{"vars":[{"containerName":"strict::Scalar","name":"Util","line":101,"kind":2},{"containerName":"","name":"base","line":103,"kind":2},{"name":"new","range":{"start":{"character":0,"line":130},"end":{"line":147,"character":9999}},"kind":12,"children":[{"line":131,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$class"},{"name":"@args","containerName":"new","line":131,"kind":13},{"localvar":"my","containerName":"new","name":"$self","definition":"my","line":132,"kind":13},{"name":"$class","containerName":"new","kind":13,"line":132},{"line":132,"kind":13,"name":"@args","containerName":"new"},{"kind":13,"line":134,"containerName":"new","name":"$map","definition":"my","localvar":"my"},{"line":134,"kind":13,"name":"$element","containerName":"new"},{"containerName":"new","name":"$position","kind":13,"line":134},{"name":"$desc","containerName":"new","line":134,"kind":13},{"name":"$self","containerName":"new","line":135,"kind":13},{"containerName":"new","name":"_rearrange","kind":12,"line":135},{"name":"@args","containerName":"new","kind":13,"line":135},{"name":"$map","containerName":"new","line":137,"kind":13},{"kind":13,"line":137,"name":"$element","containerName":"new"},{"containerName":"new","name":"$position","kind":13,"line":137},{"containerName":"new","name":"$self","kind":13,"line":138},{"containerName":"new","name":"throw","line":138,"kind":12},{"name":"$map","containerName":"new","line":141,"kind":13},{"containerName":"new","name":"$self","line":141,"kind":13},{"containerName":"new","name":"map","line":141,"kind":12},{"containerName":"new","name":"$map","line":141,"kind":13},{"name":"$element","containerName":"new","kind":13,"line":142},{"line":142,"kind":13,"containerName":"new","name":"$self"},{"name":"element","containerName":"new","kind":12,"line":142},{"containerName":"new","name":"$element","line":142,"kind":13},{"name":"$position","containerName":"new","line":143,"kind":13},{"containerName":"new","name":"$self","line":143,"kind":13},{"line":143,"kind":12,"containerName":"new","name":"position"},{"containerName":"new","name":"$position","line":143,"kind":13},{"name":"$desc","containerName":"new","line":144,"kind":13},{"line":144,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"description","kind":12,"line":144},{"name":"$desc","containerName":"new","kind":13,"line":144},{"line":146,"kind":13,"containerName":"new","name":"$self"}],"line":130,"definition":"sub","containerName":"main::","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Relative.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Relative\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Relative - Represents what a Position's coordiantes are relative to.\n\n=head1 SYNOPSIS\n\n    # Get a Bio::Map::PositionI somehow\n    my $pos = Bio::Map::Position->new(-value => 100);\n\n    # its co-ordinates are implicitly relative to the start of its map\n    my $implicit_relative = $pos->relative;\n    my $type = $implicit_relative->type; # $type eq 'map'\n    my $value = $implicit_relative->$type(); # $value == 0\n\n    # make its co-ordinates relative to another Position\n    my $pos_we_are_relative_to = Bio::Map::Position->new(-value => 200);\n    my $relative = Bio::Map::Relative->new(-position => $pos_we_are_relative_to);\n    $pos->relative($relative);\n\n    # Get the start co-ordinate of $pos relative to $pos_we_are_relative_to\n    my $start = $pos->start; # $start == 100\n\n    # Get the start co-ordinate of $pos relative to the start of the map\n    my $abs_start = $relative->absolute_conversion($pos); # $abs_start == 300\n    # - or -\n    $pos->absolute(1);\n    my $abs_start = $pos->start; # $abs_start == 300\n    $pos->absolute(0);\n\n    # Get the start co-ordinate of $pos relative to a third Position\n    my $pos_frame_of_reference = Bio::Map::Position->new(-value => 10);\n    my $relative2 = Bio::Map::Relative->new(-position => $pos_frame_of_reference);\n    my $start = $pos->start($relative2); # $start == 290\n\n=head1 DESCRIPTION\n\nA Relative object is used to describe what the co-ordinates (numerical(),\nstart(), end()) of a Position are relative to. By default they are\nimplicitly assumed to be relative to the start of the map the Position is on.\nBut setting the relative() of a Position to one of these objects lets us\ndefine otherwise.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Relative;\nuse strict;\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Root::Root Bio::Map::RelativeI);\n\n=head2 new\n\n Title   : new\n Usage   : my $relative = Bio::Map::Relative->new();\n Function: Build a new Bio::Map::Relative object.\n Returns : Bio::Map::Relative object\n Args    : -map => int           : coordinates are relative to this point on the\n                                   Position's map [default is map => 0, ie.\n                                   relative to the start of the map],\n           -element => Mappable  : or relative to this element's (a\n                                   Bio::Map::MappableI) position in the map\n                                   (only works if the given element has only one\n                                   position in the map the Position belongs to),\n           -position => Position : or relative to this other Position (a\n                                   Bio::Map::PositionI, fails if the other\n                                   Position is on a different map to this map)\n\n           -description => string: Free text description of what this relative\n                                   describes\n\n           (To say a Position is relative to something and upstream of it,\n            the Position's start() co-ordinate should be set negative)"},"detail":"($class,@args)"},{"line":132,"kind":12,"name":"SUPER","containerName":"new"},{"signature":{"label":"absolute_conversion($self,$pos)","documentation":"1;\n# $Id: Relative.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Relative\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Relative - Represents what a Position's coordiantes are relative to.\n\n=head1 SYNOPSIS\n\n    # Get a Bio::Map::PositionI somehow\n    my $pos = Bio::Map::Position->new(-value => 100);\n\n    # its co-ordinates are implicitly relative to the start of its map\n    my $implicit_relative = $pos->relative;\n    my $type = $implicit_relative->type; # $type eq 'map'\n    my $value = $implicit_relative->$type(); # $value == 0\n\n    # make its co-ordinates relative to another Position\n    my $pos_we_are_relative_to = Bio::Map::Position->new(-value => 200);\n    my $relative = Bio::Map::Relative->new(-position => $pos_we_are_relative_to);\n    $pos->relative($relative);\n\n    # Get the start co-ordinate of $pos relative to $pos_we_are_relative_to\n    my $start = $pos->start; # $start == 100\n\n    # Get the start co-ordinate of $pos relative to the start of the map\n    my $abs_start = $relative->absolute_conversion($pos); # $abs_start == 300\n    # - or -\n    $pos->absolute(1);\n    my $abs_start = $pos->start; # $abs_start == 300\n    $pos->absolute(0);\n\n    # Get the start co-ordinate of $pos relative to a third Position\n    my $pos_frame_of_reference = Bio::Map::Position->new(-value => 10);\n    my $relative2 = Bio::Map::Relative->new(-position => $pos_frame_of_reference);\n    my $start = $pos->start($relative2); # $start == 290\n\n=head1 DESCRIPTION\n\nA Relative object is used to describe what the co-ordinates (numerical(),\nstart(), end()) of a Position are relative to. By default they are\nimplicitly assumed to be relative to the start of the map the Position is on.\nBut setting the relative() of a Position to one of these objects lets us\ndefine otherwise.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Relative;\nuse strict;\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Root::Root Bio::Map::RelativeI);\n\n=head2 new\n\n Title   : new\n Usage   : my $relative = Bio::Map::Relative->new();\n Function: Build a new Bio::Map::Relative object.\n Returns : Bio::Map::Relative object\n Args    : -map => int           : coordinates are relative to this point on the\n                                   Position's map [default is map => 0, ie.\n                                   relative to the start of the map],\n           -element => Mappable  : or relative to this element's (a\n                                   Bio::Map::MappableI) position in the map\n                                   (only works if the given element has only one\n                                   position in the map the Position belongs to),\n           -position => Position : or relative to this other Position (a\n                                   Bio::Map::PositionI, fails if the other\n                                   Position is on a different map to this map)\n\n           -description => string: Free text description of what this relative\n                                   describes\n\n           (To say a Position is relative to something and upstream of it,\n            the Position's start() co-ordinate should be set negative)\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($map, $element, $position, $desc) = \n\t$self->_rearrange([qw( MAP ELEMENT POSITION DESCRIPTION )], @args);\n    \n    if (defined($map) + defined($element) + defined($position) > 1) {\n        $self->throw(\"-map, -element and -position are mutually exclusive\");\n    }\n    \n    defined($map) && $self->map($map);\n    $element && $self->element($element);\n    $position && $self->position($position);\n    $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 absolute_conversion\n\n Title   : absolute_conversion\n Usage   : my $absolute_coord = $relative->absolute_conversion($pos);\n Function: Convert the start co-ordinate of the supplied position into a number\n           relative to the start of its map.\n Returns : scalar number\n Args    : Bio::Map::PositionI object","parameters":[{"label":"$self"},{"label":"$pos"}]},"detail":"($self,$pos)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"absolute_conversion","definition":"my","name":"$self","line":161,"kind":13},{"line":161,"kind":13,"containerName":"absolute_conversion","name":"$pos"},{"line":162,"kind":13,"name":"$self","containerName":"absolute_conversion"},{"name":"throw","containerName":"absolute_conversion","line":162,"kind":12},{"line":162,"kind":13,"name":"$pos","containerName":"absolute_conversion"},{"containerName":"absolute_conversion","name":"$self","line":163,"kind":13},{"name":"throw","containerName":"absolute_conversion","line":163,"kind":12},{"containerName":"absolute_conversion","name":"$pos","kind":13,"line":163},{"name":"isa","containerName":"absolute_conversion","kind":12,"line":163},{"containerName":"absolute_conversion","definition":"my","name":"$prior_abs","localvar":"my","kind":13,"line":166},{"kind":13,"line":166,"name":"$pos","containerName":"absolute_conversion"},{"name":"absolute","containerName":"absolute_conversion","kind":12,"line":166},{"containerName":"absolute_conversion","name":"$pos","line":167,"kind":13},{"kind":12,"line":167,"containerName":"absolute_conversion","name":"absolute"},{"line":167,"kind":13,"name":"$prior_abs","containerName":"absolute_conversion"},{"localvar":"my","containerName":"absolute_conversion","definition":"my","name":"$raw","line":168,"kind":13},{"kind":13,"line":168,"name":"$pos","containerName":"absolute_conversion"},{"containerName":"absolute_conversion","name":"start","line":168,"kind":12},{"name":"$pos","containerName":"absolute_conversion","line":169,"kind":13},{"line":169,"kind":12,"name":"absolute","containerName":"absolute_conversion"},{"name":"$prior_abs","containerName":"absolute_conversion","line":169,"kind":13},{"name":"$prior_abs","containerName":"absolute_conversion","line":169,"kind":13},{"kind":13,"line":170,"name":"$self","containerName":"absolute_conversion"},{"name":"throw","containerName":"absolute_conversion","kind":12,"line":170},{"containerName":"absolute_conversion","name":"$raw","line":170,"kind":13},{"line":173,"kind":13,"localvar":"my","containerName":"absolute_conversion","name":"$type","definition":"my"},{"name":"$self","containerName":"absolute_conversion","kind":13,"line":173},{"kind":12,"line":173,"containerName":"absolute_conversion","name":"type"},{"localvar":"my","containerName":"absolute_conversion","name":"$value","definition":"my","line":174,"kind":13},{"line":174,"kind":13,"containerName":"absolute_conversion","name":"$self"},{"name":"$type","containerName":"absolute_conversion","line":174,"kind":13},{"line":175,"kind":13,"containerName":"absolute_conversion","name":"$self"},{"name":"throw","containerName":"absolute_conversion","kind":12,"line":175},{"name":"$type","containerName":"absolute_conversion","kind":13,"line":175},{"kind":13,"line":175,"name":"$value","containerName":"absolute_conversion"},{"localvar":"my","containerName":"absolute_conversion","name":"$map","definition":"my","line":178,"kind":13},{"containerName":"absolute_conversion","name":"$pos","kind":13,"line":178},{"containerName":"absolute_conversion","name":"map","kind":12,"line":178},{"line":179,"kind":13,"name":"$type","containerName":"absolute_conversion"},{"kind":13,"line":180,"name":"$self","containerName":"absolute_conversion"},{"name":"throw","containerName":"absolute_conversion","line":180,"kind":12},{"line":180,"kind":13,"name":"$map","containerName":"absolute_conversion"},{"localvar":"my","name":"@positions","definition":"my","containerName":"absolute_conversion","line":181,"kind":13},{"kind":13,"line":181,"containerName":"absolute_conversion","name":"$value"},{"line":181,"kind":12,"name":"get_positions","containerName":"absolute_conversion"},{"line":181,"kind":13,"containerName":"absolute_conversion","name":"$map"},{"line":182,"kind":13,"name":"$value","containerName":"absolute_conversion"},{"kind":13,"line":182,"name":"@positions","containerName":"absolute_conversion"},{"kind":13,"line":183,"containerName":"absolute_conversion","name":"$self"},{"containerName":"absolute_conversion","name":"throw","kind":12,"line":183},{"kind":13,"line":183,"containerName":"absolute_conversion","name":"$value"},{"containerName":"absolute_conversion","name":"$value","line":185,"kind":13},{"line":187,"kind":13,"localvar":"my","containerName":"absolute_conversion","name":"$rel","definition":"my"},{"containerName":"absolute_conversion","name":"$value","kind":13,"line":187},{"containerName":"absolute_conversion","name":"relative","line":187,"kind":12},{"name":"$value","containerName":"absolute_conversion","kind":13,"line":188},{"line":188,"kind":13,"name":"$rel","containerName":"absolute_conversion"},{"kind":12,"line":188,"containerName":"absolute_conversion","name":"absolute_conversion"},{"containerName":"absolute_conversion","name":"$value","line":188,"kind":13},{"name":"$value","containerName":"absolute_conversion","line":191,"kind":13},{"name":"$value","containerName":"absolute_conversion","kind":13,"line":192},{"kind":13,"line":192,"name":"$raw","containerName":"absolute_conversion"}],"line":160,"kind":12,"range":{"end":{"character":9999,"line":195},"start":{"character":0,"line":160}},"name":"absolute_conversion"},{"definition":"sub","name":"type","containerName":"main::","range":{"end":{"line":216,"character":9999},"start":{"line":213,"character":0}},"kind":12,"children":[{"definition":"my","name":"$self","containerName":"type","localvar":"my","kind":13,"line":214},{"line":215,"kind":13,"containerName":"type","name":"$self"}],"line":213},{"name":"_use","kind":12,"line":215},{"range":{"end":{"line":239,"character":9999},"start":{"line":231,"character":0}},"name":"map","line":231,"children":[{"line":232,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"map"},{"containerName":"map","name":"$num","line":232,"kind":13},{"kind":13,"line":233,"containerName":"map","name":"$num"},{"containerName":"map","name":"$self","kind":13,"line":234},{"kind":12,"line":234,"containerName":"map","name":"throw"},{"containerName":"map","name":"$num","line":234,"kind":13},{"kind":13,"line":235,"containerName":"map","name":"$self"},{"line":236,"kind":13,"containerName":"map","name":"$self"},{"line":236,"kind":13,"containerName":"map","name":"$num"},{"kind":13,"line":238,"name":"$self","containerName":"map"},{"name":"$self","containerName":"map","kind":13,"line":238}],"kind":12,"detail":"($self,$num)","signature":{"parameters":[{"label":"$self"},{"label":"$num"}],"documentation":"1;\n# $Id: Relative.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Relative\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Relative - Represents what a Position's coordiantes are relative to.\n\n=head1 SYNOPSIS\n\n    # Get a Bio::Map::PositionI somehow\n    my $pos = Bio::Map::Position->new(-value => 100);\n\n    # its co-ordinates are implicitly relative to the start of its map\n    my $implicit_relative = $pos->relative;\n    my $type = $implicit_relative->type; # $type eq 'map'\n    my $value = $implicit_relative->$type(); # $value == 0\n\n    # make its co-ordinates relative to another Position\n    my $pos_we_are_relative_to = Bio::Map::Position->new(-value => 200);\n    my $relative = Bio::Map::Relative->new(-position => $pos_we_are_relative_to);\n    $pos->relative($relative);\n\n    # Get the start co-ordinate of $pos relative to $pos_we_are_relative_to\n    my $start = $pos->start; # $start == 100\n\n    # Get the start co-ordinate of $pos relative to the start of the map\n    my $abs_start = $relative->absolute_conversion($pos); # $abs_start == 300\n    # - or -\n    $pos->absolute(1);\n    my $abs_start = $pos->start; # $abs_start == 300\n    $pos->absolute(0);\n\n    # Get the start co-ordinate of $pos relative to a third Position\n    my $pos_frame_of_reference = Bio::Map::Position->new(-value => 10);\n    my $relative2 = Bio::Map::Relative->new(-position => $pos_frame_of_reference);\n    my $start = $pos->start($relative2); # $start == 290\n\n=head1 DESCRIPTION\n\nA Relative object is used to describe what the co-ordinates (numerical(),\nstart(), end()) of a Position are relative to. By default they are\nimplicitly assumed to be relative to the start of the map the Position is on.\nBut setting the relative() of a Position to one of these objects lets us\ndefine otherwise.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Relative;\nuse strict;\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Root::Root Bio::Map::RelativeI);\n\n=head2 new\n\n Title   : new\n Usage   : my $relative = Bio::Map::Relative->new();\n Function: Build a new Bio::Map::Relative object.\n Returns : Bio::Map::Relative object\n Args    : -map => int           : coordinates are relative to this point on the\n                                   Position's map [default is map => 0, ie.\n                                   relative to the start of the map],\n           -element => Mappable  : or relative to this element's (a\n                                   Bio::Map::MappableI) position in the map\n                                   (only works if the given element has only one\n                                   position in the map the Position belongs to),\n           -position => Position : or relative to this other Position (a\n                                   Bio::Map::PositionI, fails if the other\n                                   Position is on a different map to this map)\n\n           -description => string: Free text description of what this relative\n                                   describes\n\n           (To say a Position is relative to something and upstream of it,\n            the Position's start() co-ordinate should be set negative)\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($map, $element, $position, $desc) = \n\t$self->_rearrange([qw( MAP ELEMENT POSITION DESCRIPTION )], @args);\n    \n    if (defined($map) + defined($element) + defined($position) > 1) {\n        $self->throw(\"-map, -element and -position are mutually exclusive\");\n    }\n    \n    defined($map) && $self->map($map);\n    $element && $self->element($element);\n    $position && $self->position($position);\n    $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 absolute_conversion\n\n Title   : absolute_conversion\n Usage   : my $absolute_coord = $relative->absolute_conversion($pos);\n Function: Convert the start co-ordinate of the supplied position into a number\n           relative to the start of its map.\n Returns : scalar number\n Args    : Bio::Map::PositionI object\n\n\nsub absolute_conversion {\n    my ($self, $pos) = @_;\n    $self->throw(\"Must supply an object\") unless ref($pos);\n    $self->throw(\"This is [$pos], not a Bio::Map::PositionI\") unless $pos->isa('Bio::Map::PositionI');\n    \n    # get the raw start position of our position\n    my $prior_abs = $pos->absolute;\n    $pos->absolute(0) if $prior_abs;\n    my $raw = $pos->start;\n    $pos->absolute($prior_abs) if $prior_abs;\n    $self->throw(\"Can't convert co-ordinates when start isn't set\") unless defined($raw); #*** needed? return undef?\n    \n    # what are we relative to?\n    my $type = $self->type;\n    my $value = $self->$type;\n    $self->throw(\"Details not yet set for this Relative, cannot convert\") unless $type && defined($value);\n    \n    # get the absolute start of the thing we're relative to\n    my $map = $pos->map;\n    if ($type eq 'element') {\n        $self->throw(\"Relative to a Mappable, but the Position has no map\") unless $map;\n        my @positions = $value->get_positions($map);\n        $value = shift(@positions);\n        $self->throw(\"Relative to a Mappable, but this Mappable has no positions on the supplied Position's map\") unless $value;\n    }\n    if (ref($value)) {\n        # psuedo-recurse\n        my $rel = $value->relative;\n        $value = $rel->absolute_conversion($value);\n    }\n    \n    if (defined($value)) {\n        return $value + $raw;\n    }\n    return;\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $relative->type();\n Function: Get the type of thing we are relative to. The types correspond\n           to a method name, so the value of what we are relative to can\n           subsequently be found by $value = $relative->$type;\n\n           Note that type is set by the last method that was set, or during\n           new().\n\n Returns : the string 'map', 'element' or 'position', or undef\n Args    : none\n\n\nsub type {\n    my $self = shift;\n    return $self->{_use} || return;\n}\n\n=head2 map\n\n Title   : map\n Usage   : my $int = $relative->map();\n           $relative->map($int);\n Function: Get/set the distance from the start of the map that the Position's\n           co-ordiantes are relative to.\n Returns : int\n Args    : none to get, OR\n           int to set; a value of 0 means relative to the start of the map.","label":"map($self,$num)"},"containerName":"main::","definition":"sub"},{"kind":12,"line":234,"name":"looks_like_number"},{"name":"_use","line":235,"kind":12},{"name":"_map","kind":12,"line":236},{"kind":12,"line":238,"name":"_map"},{"kind":12,"line":238,"name":"_map"},{"range":{"end":{"character":9999,"line":264},"start":{"character":0,"line":255}},"name":"element","signature":{"label":"element($self,$element)","parameters":[{"label":"$self"},{"label":"$element"}],"documentation":"1;\n# $Id: Relative.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Relative\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Relative - Represents what a Position's coordiantes are relative to.\n\n=head1 SYNOPSIS\n\n    # Get a Bio::Map::PositionI somehow\n    my $pos = Bio::Map::Position->new(-value => 100);\n\n    # its co-ordinates are implicitly relative to the start of its map\n    my $implicit_relative = $pos->relative;\n    my $type = $implicit_relative->type; # $type eq 'map'\n    my $value = $implicit_relative->$type(); # $value == 0\n\n    # make its co-ordinates relative to another Position\n    my $pos_we_are_relative_to = Bio::Map::Position->new(-value => 200);\n    my $relative = Bio::Map::Relative->new(-position => $pos_we_are_relative_to);\n    $pos->relative($relative);\n\n    # Get the start co-ordinate of $pos relative to $pos_we_are_relative_to\n    my $start = $pos->start; # $start == 100\n\n    # Get the start co-ordinate of $pos relative to the start of the map\n    my $abs_start = $relative->absolute_conversion($pos); # $abs_start == 300\n    # - or -\n    $pos->absolute(1);\n    my $abs_start = $pos->start; # $abs_start == 300\n    $pos->absolute(0);\n\n    # Get the start co-ordinate of $pos relative to a third Position\n    my $pos_frame_of_reference = Bio::Map::Position->new(-value => 10);\n    my $relative2 = Bio::Map::Relative->new(-position => $pos_frame_of_reference);\n    my $start = $pos->start($relative2); # $start == 290\n\n=head1 DESCRIPTION\n\nA Relative object is used to describe what the co-ordinates (numerical(),\nstart(), end()) of a Position are relative to. By default they are\nimplicitly assumed to be relative to the start of the map the Position is on.\nBut setting the relative() of a Position to one of these objects lets us\ndefine otherwise.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Relative;\nuse strict;\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Root::Root Bio::Map::RelativeI);\n\n=head2 new\n\n Title   : new\n Usage   : my $relative = Bio::Map::Relative->new();\n Function: Build a new Bio::Map::Relative object.\n Returns : Bio::Map::Relative object\n Args    : -map => int           : coordinates are relative to this point on the\n                                   Position's map [default is map => 0, ie.\n                                   relative to the start of the map],\n           -element => Mappable  : or relative to this element's (a\n                                   Bio::Map::MappableI) position in the map\n                                   (only works if the given element has only one\n                                   position in the map the Position belongs to),\n           -position => Position : or relative to this other Position (a\n                                   Bio::Map::PositionI, fails if the other\n                                   Position is on a different map to this map)\n\n           -description => string: Free text description of what this relative\n                                   describes\n\n           (To say a Position is relative to something and upstream of it,\n            the Position's start() co-ordinate should be set negative)\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($map, $element, $position, $desc) = \n\t$self->_rearrange([qw( MAP ELEMENT POSITION DESCRIPTION )], @args);\n    \n    if (defined($map) + defined($element) + defined($position) > 1) {\n        $self->throw(\"-map, -element and -position are mutually exclusive\");\n    }\n    \n    defined($map) && $self->map($map);\n    $element && $self->element($element);\n    $position && $self->position($position);\n    $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 absolute_conversion\n\n Title   : absolute_conversion\n Usage   : my $absolute_coord = $relative->absolute_conversion($pos);\n Function: Convert the start co-ordinate of the supplied position into a number\n           relative to the start of its map.\n Returns : scalar number\n Args    : Bio::Map::PositionI object\n\n\nsub absolute_conversion {\n    my ($self, $pos) = @_;\n    $self->throw(\"Must supply an object\") unless ref($pos);\n    $self->throw(\"This is [$pos], not a Bio::Map::PositionI\") unless $pos->isa('Bio::Map::PositionI');\n    \n    # get the raw start position of our position\n    my $prior_abs = $pos->absolute;\n    $pos->absolute(0) if $prior_abs;\n    my $raw = $pos->start;\n    $pos->absolute($prior_abs) if $prior_abs;\n    $self->throw(\"Can't convert co-ordinates when start isn't set\") unless defined($raw); #*** needed? return undef?\n    \n    # what are we relative to?\n    my $type = $self->type;\n    my $value = $self->$type;\n    $self->throw(\"Details not yet set for this Relative, cannot convert\") unless $type && defined($value);\n    \n    # get the absolute start of the thing we're relative to\n    my $map = $pos->map;\n    if ($type eq 'element') {\n        $self->throw(\"Relative to a Mappable, but the Position has no map\") unless $map;\n        my @positions = $value->get_positions($map);\n        $value = shift(@positions);\n        $self->throw(\"Relative to a Mappable, but this Mappable has no positions on the supplied Position's map\") unless $value;\n    }\n    if (ref($value)) {\n        # psuedo-recurse\n        my $rel = $value->relative;\n        $value = $rel->absolute_conversion($value);\n    }\n    \n    if (defined($value)) {\n        return $value + $raw;\n    }\n    return;\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $relative->type();\n Function: Get the type of thing we are relative to. The types correspond\n           to a method name, so the value of what we are relative to can\n           subsequently be found by $value = $relative->$type;\n\n           Note that type is set by the last method that was set, or during\n           new().\n\n Returns : the string 'map', 'element' or 'position', or undef\n Args    : none\n\n\nsub type {\n    my $self = shift;\n    return $self->{_use} || return;\n}\n\n=head2 map\n\n Title   : map\n Usage   : my $int = $relative->map();\n           $relative->map($int);\n Function: Get/set the distance from the start of the map that the Position's\n           co-ordiantes are relative to.\n Returns : int\n Args    : none to get, OR\n           int to set; a value of 0 means relative to the start of the map.\n\n\nsub map {\n    my ($self, $num) = @_;\n    if (defined($num)) {\n        $self->throw(\"This is [$num], not a number\") unless looks_like_number($num);\n        $self->{_use} = 'map';\n        $self->{_map} = $num;\n    }\n    return defined($self->{_map}) ? $self->{_map} : return;\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $relative->element();\n           $relative->element($element);\n Function: Get/set the map element (Mappable) the Position is relative to. If\n           the Mappable has more than one Position on the Position's map, we\n           will be relative to the Mappable's first Position on the map.\n Returns : Bio::Map::MappableI\n Args    : none to get, OR\n           Bio::Map::MappableI to set"},"detail":"($self,$element)","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"element","line":256,"kind":13},{"name":"$element","containerName":"element","line":256,"kind":13},{"line":257,"kind":13,"containerName":"element","name":"$element"},{"kind":13,"line":258,"containerName":"element","name":"$self"},{"containerName":"element","name":"throw","kind":12,"line":258},{"name":"$element","containerName":"element","kind":13,"line":258},{"containerName":"element","name":"$self","line":259,"kind":13},{"containerName":"element","name":"throw","line":259,"kind":12},{"line":259,"kind":13,"containerName":"element","name":"$element"},{"name":"isa","containerName":"element","line":259,"kind":12},{"name":"$self","containerName":"element","line":260,"kind":13},{"kind":13,"line":261,"name":"$self","containerName":"element"},{"containerName":"element","name":"$element","kind":13,"line":261},{"line":263,"kind":13,"containerName":"element","name":"$self"}],"line":255,"kind":12},{"kind":12,"line":260,"name":"_use"},{"line":261,"kind":12,"name":"_element"},{"name":"_element","line":263,"kind":12},{"range":{"start":{"line":280,"character":0},"end":{"character":9999,"line":289}},"name":"position","line":280,"children":[{"containerName":"position","definition":"my","name":"$self","localvar":"my","kind":13,"line":281},{"containerName":"position","name":"$pos","line":281,"kind":13},{"kind":13,"line":282,"name":"$pos","containerName":"position"},{"name":"$self","containerName":"position","line":283,"kind":13},{"name":"throw","containerName":"position","kind":12,"line":283},{"kind":13,"line":283,"name":"$pos","containerName":"position"},{"kind":13,"line":284,"containerName":"position","name":"$self"},{"containerName":"position","name":"throw","kind":12,"line":284},{"containerName":"position","name":"$pos","kind":13,"line":284},{"line":284,"kind":12,"name":"isa","containerName":"position"},{"containerName":"position","name":"$self","line":285,"kind":13},{"kind":13,"line":286,"containerName":"position","name":"$self"},{"kind":13,"line":286,"containerName":"position","name":"$pos"},{"containerName":"position","name":"$self","kind":13,"line":288}],"kind":12,"detail":"($self,$pos)","signature":{"label":"position($self,$pos)","parameters":[{"label":"$self"},{"label":"$pos"}],"documentation":"1;\n# $Id: Relative.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Relative\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Relative - Represents what a Position's coordiantes are relative to.\n\n=head1 SYNOPSIS\n\n    # Get a Bio::Map::PositionI somehow\n    my $pos = Bio::Map::Position->new(-value => 100);\n\n    # its co-ordinates are implicitly relative to the start of its map\n    my $implicit_relative = $pos->relative;\n    my $type = $implicit_relative->type; # $type eq 'map'\n    my $value = $implicit_relative->$type(); # $value == 0\n\n    # make its co-ordinates relative to another Position\n    my $pos_we_are_relative_to = Bio::Map::Position->new(-value => 200);\n    my $relative = Bio::Map::Relative->new(-position => $pos_we_are_relative_to);\n    $pos->relative($relative);\n\n    # Get the start co-ordinate of $pos relative to $pos_we_are_relative_to\n    my $start = $pos->start; # $start == 100\n\n    # Get the start co-ordinate of $pos relative to the start of the map\n    my $abs_start = $relative->absolute_conversion($pos); # $abs_start == 300\n    # - or -\n    $pos->absolute(1);\n    my $abs_start = $pos->start; # $abs_start == 300\n    $pos->absolute(0);\n\n    # Get the start co-ordinate of $pos relative to a third Position\n    my $pos_frame_of_reference = Bio::Map::Position->new(-value => 10);\n    my $relative2 = Bio::Map::Relative->new(-position => $pos_frame_of_reference);\n    my $start = $pos->start($relative2); # $start == 290\n\n=head1 DESCRIPTION\n\nA Relative object is used to describe what the co-ordinates (numerical(),\nstart(), end()) of a Position are relative to. By default they are\nimplicitly assumed to be relative to the start of the map the Position is on.\nBut setting the relative() of a Position to one of these objects lets us\ndefine otherwise.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Relative;\nuse strict;\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Root::Root Bio::Map::RelativeI);\n\n=head2 new\n\n Title   : new\n Usage   : my $relative = Bio::Map::Relative->new();\n Function: Build a new Bio::Map::Relative object.\n Returns : Bio::Map::Relative object\n Args    : -map => int           : coordinates are relative to this point on the\n                                   Position's map [default is map => 0, ie.\n                                   relative to the start of the map],\n           -element => Mappable  : or relative to this element's (a\n                                   Bio::Map::MappableI) position in the map\n                                   (only works if the given element has only one\n                                   position in the map the Position belongs to),\n           -position => Position : or relative to this other Position (a\n                                   Bio::Map::PositionI, fails if the other\n                                   Position is on a different map to this map)\n\n           -description => string: Free text description of what this relative\n                                   describes\n\n           (To say a Position is relative to something and upstream of it,\n            the Position's start() co-ordinate should be set negative)\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($map, $element, $position, $desc) = \n\t$self->_rearrange([qw( MAP ELEMENT POSITION DESCRIPTION )], @args);\n    \n    if (defined($map) + defined($element) + defined($position) > 1) {\n        $self->throw(\"-map, -element and -position are mutually exclusive\");\n    }\n    \n    defined($map) && $self->map($map);\n    $element && $self->element($element);\n    $position && $self->position($position);\n    $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 absolute_conversion\n\n Title   : absolute_conversion\n Usage   : my $absolute_coord = $relative->absolute_conversion($pos);\n Function: Convert the start co-ordinate of the supplied position into a number\n           relative to the start of its map.\n Returns : scalar number\n Args    : Bio::Map::PositionI object\n\n\nsub absolute_conversion {\n    my ($self, $pos) = @_;\n    $self->throw(\"Must supply an object\") unless ref($pos);\n    $self->throw(\"This is [$pos], not a Bio::Map::PositionI\") unless $pos->isa('Bio::Map::PositionI');\n    \n    # get the raw start position of our position\n    my $prior_abs = $pos->absolute;\n    $pos->absolute(0) if $prior_abs;\n    my $raw = $pos->start;\n    $pos->absolute($prior_abs) if $prior_abs;\n    $self->throw(\"Can't convert co-ordinates when start isn't set\") unless defined($raw); #*** needed? return undef?\n    \n    # what are we relative to?\n    my $type = $self->type;\n    my $value = $self->$type;\n    $self->throw(\"Details not yet set for this Relative, cannot convert\") unless $type && defined($value);\n    \n    # get the absolute start of the thing we're relative to\n    my $map = $pos->map;\n    if ($type eq 'element') {\n        $self->throw(\"Relative to a Mappable, but the Position has no map\") unless $map;\n        my @positions = $value->get_positions($map);\n        $value = shift(@positions);\n        $self->throw(\"Relative to a Mappable, but this Mappable has no positions on the supplied Position's map\") unless $value;\n    }\n    if (ref($value)) {\n        # psuedo-recurse\n        my $rel = $value->relative;\n        $value = $rel->absolute_conversion($value);\n    }\n    \n    if (defined($value)) {\n        return $value + $raw;\n    }\n    return;\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $relative->type();\n Function: Get the type of thing we are relative to. The types correspond\n           to a method name, so the value of what we are relative to can\n           subsequently be found by $value = $relative->$type;\n\n           Note that type is set by the last method that was set, or during\n           new().\n\n Returns : the string 'map', 'element' or 'position', or undef\n Args    : none\n\n\nsub type {\n    my $self = shift;\n    return $self->{_use} || return;\n}\n\n=head2 map\n\n Title   : map\n Usage   : my $int = $relative->map();\n           $relative->map($int);\n Function: Get/set the distance from the start of the map that the Position's\n           co-ordiantes are relative to.\n Returns : int\n Args    : none to get, OR\n           int to set; a value of 0 means relative to the start of the map.\n\n\nsub map {\n    my ($self, $num) = @_;\n    if (defined($num)) {\n        $self->throw(\"This is [$num], not a number\") unless looks_like_number($num);\n        $self->{_use} = 'map';\n        $self->{_map} = $num;\n    }\n    return defined($self->{_map}) ? $self->{_map} : return;\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $relative->element();\n           $relative->element($element);\n Function: Get/set the map element (Mappable) the Position is relative to. If\n           the Mappable has more than one Position on the Position's map, we\n           will be relative to the Mappable's first Position on the map.\n Returns : Bio::Map::MappableI\n Args    : none to get, OR\n           Bio::Map::MappableI to set\n\n\nsub element {\n    my ($self, $element) = @_;\n    if ($element) {\n        $self->throw(\"Must supply an object\") unless ref($element);\n        $self->throw(\"This is [$element], not a Bio::Map::MappableI\") unless $element->isa('Bio::Map::MappableI');\n        $self->{_use} = 'element';\n        $self->{_element} = $element;\n    }\n    return $self->{_element} || return;\n}\n\n=head2 position\n\n Title   : position\n Usage   : my $position = $relative->position();\n           $relative->position($position);\n Function: Get/set the Position your Position is relative to. Your Position\n           will be made relative to the start of this supplied Position. It\n           makes no difference what maps the Positions are on.\n Returns : Bio::Map::PositionI\n Args    : none to get, OR\n           Bio::Map::PositionI to set"},"containerName":"main::","definition":"sub"},{"name":"_use","line":285,"kind":12},{"name":"_position","line":286,"kind":12},{"kind":12,"line":288,"name":"_position"},{"kind":12,"line":303,"children":[{"containerName":"description","name":"$self","definition":"my","localvar":"my","kind":13,"line":304},{"line":305,"kind":13,"name":"$self","containerName":"description"},{"kind":13,"line":306,"name":"$self","containerName":"description"}],"containerName":"main::","name":"description","definition":"sub","range":{"start":{"line":303,"character":0},"end":{"line":307,"character":9999}}},{"kind":12,"line":305,"name":"desc"},{"name":"desc","kind":12,"line":306}],"version":5}