{"version":5,"vars":[{"line":93,"kind":2,"containerName":"strict::Bio::Map::PositionHandler::Bio::Map::Mappable::Scalar","name":"Util"},{"containerName":"","name":"base","line":95,"kind":2},{"definition":"sub","name":"get_position_handler","containerName":"main::","range":{"end":{"character":9999,"line":122},"start":{"character":0,"line":114}},"kind":12,"children":[{"kind":13,"line":115,"name":"$self","definition":"my","containerName":"get_position_handler","localvar":"my"},{"containerName":"get_position_handler","name":"$self","line":116,"kind":13},{"line":117,"kind":13,"localvar":"my","containerName":"get_position_handler","definition":"my","name":"$ph"},{"name":"new","containerName":"get_position_handler","line":117,"kind":12},{"name":"$self","containerName":"get_position_handler","line":117,"kind":13},{"line":118,"kind":13,"name":"$self","containerName":"get_position_handler"},{"kind":13,"line":118,"name":"$ph","containerName":"get_position_handler"},{"line":119,"kind":13,"name":"$ph","containerName":"get_position_handler"},{"kind":12,"line":119,"containerName":"get_position_handler","name":"register"},{"containerName":"get_position_handler","name":"$self","line":121,"kind":13}],"line":114},{"name":"_eh","kind":12,"line":116},{"containerName":"Map::PositionHandler","name":"Bio","kind":12,"line":117},{"kind":12,"line":118,"name":"_eh"},{"name":"_eh","line":121,"kind":12},{"detail":"($self,$map)","signature":{"label":"map($self,$map)","parameters":[{"label":"$self"},{"label":"$map"}],"documentation":"1;\n# $Id: PositionI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionI - Abstracts the notion of a position having a value in the context of a marker and a Map\n\n=head1 SYNOPSIS\n\n    # do not use this module directly\n    # See Bio::Map::Position for an example of\n    # implementation.\n\n=head1 DESCRIPTION\n\nThis object stores one of the postions that a mappable object\n(e.g. Marker) may have in a map.\n\nPositions can have non-numeric values or other methods to store the locations,\nso they have a method numeric() which does the conversion. numeric()\nreturns the position in a form that can be compared between other positions of\nthe same type. It is not necessarily a value suitable for sorting positions (it\nmay be the distance from the previous position); for that purpose the result of\nsortable() should be used.\n\nA 'position', in addition to being a single point, can also be an area and so\ncan be imagined as a range and compared with other positions on the basis of\noverlap, intersection etc.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein-at-cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionI;\nuse strict;\nuse Bio::Map::PositionHandler;\nuse Bio::Map::Mappable;\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Map::EntityI Bio::RangeI);\n\n=head2 EntityI methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 get_position_handler\n\n Title   : get_position_handler\n Usage   : my $position_handler = $entity->get_position_handler();\n Function: Gets a PositionHandlerI that $entity is registered with.\n Returns : Bio::Map::PositionHandlerI object\n Args    : none\n\n\nsub get_position_handler {\n    my $self = shift;\n    unless (defined $self->{_eh}) {\n        my $ph = Bio::Map::PositionHandler->new(-self => $self);\n        $self->{_eh} = $ph;\n        $ph->register;\n    }\n    return $self->{_eh};\n}\n\n=head2 PositionHandlerI-related methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position->map();\n           $position->map($map);\n Function: Get/Set the map the position is in.\n Returns : L<Bio::Map::MapI>\n Args    : none to get\n           new L<Bio::Map::MapI> to set"},"containerName":"main::","definition":"sub","line":143,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"map","line":144,"kind":13},{"name":"$map","containerName":"map","kind":13,"line":144},{"name":"$self","containerName":"map","line":145,"kind":13},{"name":"get_position_handler","containerName":"map","line":145,"kind":12},{"line":145,"kind":12,"containerName":"map","name":"map"},{"kind":13,"line":145,"containerName":"map","name":"$map"}],"kind":12,"range":{"end":{"line":146,"character":9999},"start":{"character":0,"line":143}},"name":"map"},{"name":"element","range":{"start":{"line":160,"character":0},"end":{"character":9999,"line":163}},"kind":12,"line":160,"children":[{"line":161,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"element"},{"kind":13,"line":161,"containerName":"element","name":"$element"},{"containerName":"element","name":"$self","line":162,"kind":13},{"line":162,"kind":12,"name":"get_position_handler","containerName":"element"},{"line":162,"kind":12,"name":"element","containerName":"element"},{"line":162,"kind":13,"containerName":"element","name":"$element"}],"containerName":"main::","definition":"sub","detail":"($self,$element)","signature":{"label":"element($self,$element)","documentation":"1;\n# $Id: PositionI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionI - Abstracts the notion of a position having a value in the context of a marker and a Map\n\n=head1 SYNOPSIS\n\n    # do not use this module directly\n    # See Bio::Map::Position for an example of\n    # implementation.\n\n=head1 DESCRIPTION\n\nThis object stores one of the postions that a mappable object\n(e.g. Marker) may have in a map.\n\nPositions can have non-numeric values or other methods to store the locations,\nso they have a method numeric() which does the conversion. numeric()\nreturns the position in a form that can be compared between other positions of\nthe same type. It is not necessarily a value suitable for sorting positions (it\nmay be the distance from the previous position); for that purpose the result of\nsortable() should be used.\n\nA 'position', in addition to being a single point, can also be an area and so\ncan be imagined as a range and compared with other positions on the basis of\noverlap, intersection etc.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein-at-cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionI;\nuse strict;\nuse Bio::Map::PositionHandler;\nuse Bio::Map::Mappable;\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Map::EntityI Bio::RangeI);\n\n=head2 EntityI methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 get_position_handler\n\n Title   : get_position_handler\n Usage   : my $position_handler = $entity->get_position_handler();\n Function: Gets a PositionHandlerI that $entity is registered with.\n Returns : Bio::Map::PositionHandlerI object\n Args    : none\n\n\nsub get_position_handler {\n    my $self = shift;\n    unless (defined $self->{_eh}) {\n        my $ph = Bio::Map::PositionHandler->new(-self => $self);\n        $self->{_eh} = $ph;\n        $ph->register;\n    }\n    return $self->{_eh};\n}\n\n=head2 PositionHandlerI-related methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position->map();\n           $position->map($map);\n Function: Get/Set the map the position is in.\n Returns : L<Bio::Map::MapI>\n Args    : none to get\n           new L<Bio::Map::MapI> to set\n\n\nsub map {\n    my ($self, $map) = @_;\n    return $self->get_position_handler->map($map);\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $position->element();\n           $position->element($element);\n Function: Get/Set the element the position is for.\n Returns : L<Bio::Map::MappableI>\n Args    : none to get\n           new L<Bio::Map::MappableI> to set","parameters":[{"label":"$self"},{"label":"$element"}]}},{"kind":12,"children":[{"line":190,"kind":13,"localvar":"my","containerName":"value","name":"$self","definition":"my"},{"name":"$self","containerName":"value","line":191,"kind":13},{"containerName":"value","name":"throw_not_implemented","kind":12,"line":191}],"line":189,"name":"value","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":189},"end":{"character":9999,"line":192}}},{"children":[{"line":208,"kind":13,"localvar":"my","containerName":"numeric","name":"$self","definition":"my"},{"kind":13,"line":209,"name":"$self","containerName":"numeric"},{"line":209,"kind":12,"name":"throw_not_implemented","containerName":"numeric"}],"line":207,"kind":12,"range":{"end":{"character":9999,"line":210},"start":{"line":207,"character":0}},"name":"numeric","definition":"sub","containerName":"main::"},{"range":{"end":{"line":228,"character":9999},"start":{"character":0,"line":225}},"containerName":"main::","name":"sortable","definition":"sub","line":225,"children":[{"line":226,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"sortable"},{"name":"$self","containerName":"sortable","line":227,"kind":13},{"containerName":"sortable","name":"throw_not_implemented","line":227,"kind":12}],"kind":12},{"line":244,"children":[{"kind":13,"line":245,"containerName":"relative","definition":"my","name":"$self","localvar":"my"},{"line":246,"kind":13,"containerName":"relative","name":"$self"},{"line":246,"kind":12,"containerName":"relative","name":"throw_not_implemented"}],"kind":12,"range":{"start":{"line":244,"character":0},"end":{"line":247,"character":9999}},"containerName":"main::","definition":"sub","name":"relative"},{"range":{"start":{"line":273,"character":0},"end":{"character":9999,"line":276}},"name":"absolute","definition":"sub","containerName":"main::","children":[{"containerName":"absolute","definition":"my","name":"$self","localvar":"my","kind":13,"line":274},{"line":275,"kind":13,"containerName":"absolute","name":"$self"},{"containerName":"absolute","name":"throw_not_implemented","line":275,"kind":12}],"line":273,"kind":12},{"kind":12,"line":331,"children":[],"containerName":"main::","name":"strand","definition":"sub","range":{"start":{"character":0,"line":331},"end":{"character":9999,"line":333}}},{"containerName":"main::","name":"toString","definition":"sub","range":{"start":{"character":0,"line":346},"end":{"character":9999,"line":349}},"kind":12,"line":346,"children":[{"definition":"my","name":"$self","containerName":"toString","localvar":"my","kind":13,"line":347},{"kind":13,"line":348,"name":"$self","containerName":"toString"},{"name":"throw_not_implemented","containerName":"toString","line":348,"kind":12}]},{"range":{"start":{"character":0,"line":392},"end":{"character":9999,"line":401}},"name":"equals","children":[{"kind":13,"line":394,"containerName":"equals","name":"$self","definition":"my","localvar":"my"},{"line":394,"kind":13,"name":"$other","containerName":"equals"},{"kind":13,"line":394,"containerName":"equals","name":"$so"},{"containerName":"equals","name":"$rel","line":394,"kind":13},{"containerName":"equals","name":"$own_start","definition":"my","localvar":"my","kind":13,"line":396},{"name":"$own_end","containerName":"equals","line":396,"kind":13},{"kind":13,"line":396,"containerName":"equals","name":"$self"},{"line":396,"kind":12,"name":"_pre_rangei","containerName":"equals"},{"containerName":"equals","name":"$self","kind":13,"line":396},{"name":"$rel","containerName":"equals","kind":13,"line":396},{"line":397,"kind":13,"localvar":"my","containerName":"equals","name":"$other_start","definition":"my"},{"kind":13,"line":397,"containerName":"equals","name":"$other_end"},{"line":397,"kind":13,"name":"$self","containerName":"equals"},{"line":397,"kind":12,"containerName":"equals","name":"_pre_rangei"},{"containerName":"equals","name":"$other","kind":13,"line":397},{"containerName":"equals","name":"$rel","line":397,"kind":13},{"line":399,"kind":13,"name":"$self","containerName":"equals"},{"line":399,"kind":12,"containerName":"equals","name":"_testStrand"},{"line":399,"kind":13,"name":"$other","containerName":"equals"},{"line":399,"kind":13,"containerName":"equals","name":"$so"},{"line":400,"kind":13,"name":"$own_start","containerName":"equals"},{"line":400,"kind":13,"name":"$other_start","containerName":"equals"},{"name":"$own_end","containerName":"equals","line":400,"kind":13},{"name":"$other_end","containerName":"equals","line":400,"kind":13}],"line":392,"kind":12,"signature":{"documentation":"1;\n# $Id: PositionI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionI - Abstracts the notion of a position having a value in the context of a marker and a Map\n\n=head1 SYNOPSIS\n\n    # do not use this module directly\n    # See Bio::Map::Position for an example of\n    # implementation.\n\n=head1 DESCRIPTION\n\nThis object stores one of the postions that a mappable object\n(e.g. Marker) may have in a map.\n\nPositions can have non-numeric values or other methods to store the locations,\nso they have a method numeric() which does the conversion. numeric()\nreturns the position in a form that can be compared between other positions of\nthe same type. It is not necessarily a value suitable for sorting positions (it\nmay be the distance from the previous position); for that purpose the result of\nsortable() should be used.\n\nA 'position', in addition to being a single point, can also be an area and so\ncan be imagined as a range and compared with other positions on the basis of\noverlap, intersection etc.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein-at-cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionI;\nuse strict;\nuse Bio::Map::PositionHandler;\nuse Bio::Map::Mappable;\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Map::EntityI Bio::RangeI);\n\n=head2 EntityI methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 get_position_handler\n\n Title   : get_position_handler\n Usage   : my $position_handler = $entity->get_position_handler();\n Function: Gets a PositionHandlerI that $entity is registered with.\n Returns : Bio::Map::PositionHandlerI object\n Args    : none\n\n\nsub get_position_handler {\n    my $self = shift;\n    unless (defined $self->{_eh}) {\n        my $ph = Bio::Map::PositionHandler->new(-self => $self);\n        $self->{_eh} = $ph;\n        $ph->register;\n    }\n    return $self->{_eh};\n}\n\n=head2 PositionHandlerI-related methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position->map();\n           $position->map($map);\n Function: Get/Set the map the position is in.\n Returns : L<Bio::Map::MapI>\n Args    : none to get\n           new L<Bio::Map::MapI> to set\n\n\nsub map {\n    my ($self, $map) = @_;\n    return $self->get_position_handler->map($map);\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $position->element();\n           $position->element($element);\n Function: Get/Set the element the position is for.\n Returns : L<Bio::Map::MappableI>\n Args    : none to get\n           new L<Bio::Map::MappableI> to set\n\n\nsub element {\n    my ($self, $element) = @_;\n    return $self->get_position_handler->element($element);\n}\n\n=head2 marker\n\n Title   : marker\n Function: This is a synonym of the element() method\n Status  : deprecated, will be removed in the next version\n\n\n*marker = \\&element;\n\n=head2 PositionI-specific methods\n\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value();\n Function: Get/Set the value for this position\n Returns : scalar, value\n Args    : [optional] new value to set\n\n\nsub value {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 numeric\n\n Title   : numeric\n Usage   : my $num = $position->numeric;\n Function: Read-only method that is guaranteed to return a numeric \n           representation of the start of this position. \n Returns : scalar numeric\n Args    : none to get the co-ordinate normally (see absolute() method), OR\n           Bio::Map::RelativeI to get the co-ordinate converted to be\n           relative to what this Relative describes.\n\n\nsub numeric {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 sortable\n\n Title   : sortable\n Usage   : my $num = $position->sortable();\n Function: Read-only method that is guaranteed to return a value suitable\n           for correctly sorting this kind of position amongst other positions\n           of the same kind on the same map. Note that sorting different kinds\n           of position together is unlikely to give sane results.\n Returns : numeric\n Args    : none\n\n\nsub sortable {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set\n\n\nsub relative {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 absolute\n\n  Title   : absolute\n  Usage   : my $absolute = $position->absolute();\n            $position->absolute($absolute);\n  Function: Get/set how this Position's co-ordinates (numerical(), start(),\n            end()) are reported. When absolute is off, co-ordinates are\n            relative to the thing described by relative(). Ie. the value\n            returned by start() will be the same as the value you set start()\n            to. When absolute is on, co-ordinates are converted to be relative\n            to the start of the map.\n\n            So if relative() currently points to a Relative object describing\n            \"relative to another position which is 100 bp from the start of\n            the map\", this Position's start() had been set to 50 and absolute()\n            returns 1, $position->start() will return 150. If absolute() returns\n            0 in the same situation, $position->start() would return 50.\n\n  Returns : boolean (default 0)\n  Args    : none to get, OR\n            boolean to set\n\n\nsub absolute {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 RangeI-based methods\n\n\n=head2 start\n\n  Title   : start\n  Usage   : my $start = $position->start();\n            $position->start($start);\n  Function: Get/set the start co-ordinate of this position.\n  Returns : the start of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 end\n\n  Title   : end\n  Usage   : my $end = $position->end();\n            $position->end($end);\n  Function: Get/set the end co-ordinate of this position.\n  Returns : the end of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $position->length();\n  Function: Get the length of this position.\n  Returns : the length of this position\n  Args    : none\n\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $position->strand();\n  Function: Get the strand of this position; it is always 1 since maps to not\n            have strands.\n  Returns : 1\n  Args    : none\n\n\nsub strand {\n    return 1;\n}\n\n=head2 toString\n\n  Title   : toString\n  Usage   : print $position->toString(), \"\\n\";\n  Function: stringifies this range\n  Returns : a string representation of the range of this Position\n  Args    : optional Bio::Map::RelativeI to have the co-ordinates reported\n            relative to the thing described by that Relative\n\n\nsub toString {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head1 RangeI-related methods\n\nThese methods work by considering only the values of start() and end(), as\nmodified by considering every such co-ordinate relative to the start of the map\n(ie. absolute(1) is set temporarily during the calculation), or any supplied\nRelative. For the boolean methods, when the comparison Position is on the same\nmap as the calling Position, there is no point supplying a Relative since the\nanswer will be the same as without. Relative is most useful when comparing\nPositions on different maps and you have a Relative that describes some special\nplace on each map like 'the start of the gene', where the actual start of the\ngene relative to the start of the map is different for each map.\n\nThe methods do not consider maps during their calculations - things on different\nmaps can overlap/contain/intersect/etc. each other.\n\nThe geometrical methods (intersect, union etc.) do things to the geometry of\nranges, and return Bio::Map::PositionI compliant objects or triplets (start,\nstop, strand) from which new positions could be built. When a PositionI is made\nit will have a map transferred to it if all the arguments shared the same map.\nIf a Relative was supplied the result will have that same Relative.\n\nNote that the strand-testing args are there for compatability with the RangeI\ninterface. They have no meaning when only using PositionI objects since maps do\nnot have strands. Typically you will just set the argument to undef if you want\nto supply the argument after it.\n\n=head2 equals\n\n  Title   : equals\n  Usage   : if ($p1->equals($p2)) {...}\n  Function: Test whether $p1 has the same start, end, length as $p2.\n  Returns : true if they are describing the same position (regardless of map)\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Positions\n                     equal in terms of their relative position to the thing\n                     described by that Relative","parameters":[{"label":"$self"},{"label":"$other"},{"label":"$so"},{"label":"$rel"}],"label":"equals($self,$other,$so,$rel)"},"detail":"($self,$other,$so,$rel)","definition":"sub","containerName":"main::"},{"signature":{"label":"less_than($self,$other,$rel)","documentation":"1;\n# $Id: PositionI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionI - Abstracts the notion of a position having a value in the context of a marker and a Map\n\n=head1 SYNOPSIS\n\n    # do not use this module directly\n    # See Bio::Map::Position for an example of\n    # implementation.\n\n=head1 DESCRIPTION\n\nThis object stores one of the postions that a mappable object\n(e.g. Marker) may have in a map.\n\nPositions can have non-numeric values or other methods to store the locations,\nso they have a method numeric() which does the conversion. numeric()\nreturns the position in a form that can be compared between other positions of\nthe same type. It is not necessarily a value suitable for sorting positions (it\nmay be the distance from the previous position); for that purpose the result of\nsortable() should be used.\n\nA 'position', in addition to being a single point, can also be an area and so\ncan be imagined as a range and compared with other positions on the basis of\noverlap, intersection etc.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein-at-cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionI;\nuse strict;\nuse Bio::Map::PositionHandler;\nuse Bio::Map::Mappable;\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Map::EntityI Bio::RangeI);\n\n=head2 EntityI methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 get_position_handler\n\n Title   : get_position_handler\n Usage   : my $position_handler = $entity->get_position_handler();\n Function: Gets a PositionHandlerI that $entity is registered with.\n Returns : Bio::Map::PositionHandlerI object\n Args    : none\n\n\nsub get_position_handler {\n    my $self = shift;\n    unless (defined $self->{_eh}) {\n        my $ph = Bio::Map::PositionHandler->new(-self => $self);\n        $self->{_eh} = $ph;\n        $ph->register;\n    }\n    return $self->{_eh};\n}\n\n=head2 PositionHandlerI-related methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position->map();\n           $position->map($map);\n Function: Get/Set the map the position is in.\n Returns : L<Bio::Map::MapI>\n Args    : none to get\n           new L<Bio::Map::MapI> to set\n\n\nsub map {\n    my ($self, $map) = @_;\n    return $self->get_position_handler->map($map);\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $position->element();\n           $position->element($element);\n Function: Get/Set the element the position is for.\n Returns : L<Bio::Map::MappableI>\n Args    : none to get\n           new L<Bio::Map::MappableI> to set\n\n\nsub element {\n    my ($self, $element) = @_;\n    return $self->get_position_handler->element($element);\n}\n\n=head2 marker\n\n Title   : marker\n Function: This is a synonym of the element() method\n Status  : deprecated, will be removed in the next version\n\n\n*marker = \\&element;\n\n=head2 PositionI-specific methods\n\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value();\n Function: Get/Set the value for this position\n Returns : scalar, value\n Args    : [optional] new value to set\n\n\nsub value {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 numeric\n\n Title   : numeric\n Usage   : my $num = $position->numeric;\n Function: Read-only method that is guaranteed to return a numeric \n           representation of the start of this position. \n Returns : scalar numeric\n Args    : none to get the co-ordinate normally (see absolute() method), OR\n           Bio::Map::RelativeI to get the co-ordinate converted to be\n           relative to what this Relative describes.\n\n\nsub numeric {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 sortable\n\n Title   : sortable\n Usage   : my $num = $position->sortable();\n Function: Read-only method that is guaranteed to return a value suitable\n           for correctly sorting this kind of position amongst other positions\n           of the same kind on the same map. Note that sorting different kinds\n           of position together is unlikely to give sane results.\n Returns : numeric\n Args    : none\n\n\nsub sortable {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set\n\n\nsub relative {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 absolute\n\n  Title   : absolute\n  Usage   : my $absolute = $position->absolute();\n            $position->absolute($absolute);\n  Function: Get/set how this Position's co-ordinates (numerical(), start(),\n            end()) are reported. When absolute is off, co-ordinates are\n            relative to the thing described by relative(). Ie. the value\n            returned by start() will be the same as the value you set start()\n            to. When absolute is on, co-ordinates are converted to be relative\n            to the start of the map.\n\n            So if relative() currently points to a Relative object describing\n            \"relative to another position which is 100 bp from the start of\n            the map\", this Position's start() had been set to 50 and absolute()\n            returns 1, $position->start() will return 150. If absolute() returns\n            0 in the same situation, $position->start() would return 50.\n\n  Returns : boolean (default 0)\n  Args    : none to get, OR\n            boolean to set\n\n\nsub absolute {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 RangeI-based methods\n\n\n=head2 start\n\n  Title   : start\n  Usage   : my $start = $position->start();\n            $position->start($start);\n  Function: Get/set the start co-ordinate of this position.\n  Returns : the start of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 end\n\n  Title   : end\n  Usage   : my $end = $position->end();\n            $position->end($end);\n  Function: Get/set the end co-ordinate of this position.\n  Returns : the end of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $position->length();\n  Function: Get the length of this position.\n  Returns : the length of this position\n  Args    : none\n\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $position->strand();\n  Function: Get the strand of this position; it is always 1 since maps to not\n            have strands.\n  Returns : 1\n  Args    : none\n\n\nsub strand {\n    return 1;\n}\n\n=head2 toString\n\n  Title   : toString\n  Usage   : print $position->toString(), \"\\n\";\n  Function: stringifies this range\n  Returns : a string representation of the range of this Position\n  Args    : optional Bio::Map::RelativeI to have the co-ordinates reported\n            relative to the thing described by that Relative\n\n\nsub toString {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head1 RangeI-related methods\n\nThese methods work by considering only the values of start() and end(), as\nmodified by considering every such co-ordinate relative to the start of the map\n(ie. absolute(1) is set temporarily during the calculation), or any supplied\nRelative. For the boolean methods, when the comparison Position is on the same\nmap as the calling Position, there is no point supplying a Relative since the\nanswer will be the same as without. Relative is most useful when comparing\nPositions on different maps and you have a Relative that describes some special\nplace on each map like 'the start of the gene', where the actual start of the\ngene relative to the start of the map is different for each map.\n\nThe methods do not consider maps during their calculations - things on different\nmaps can overlap/contain/intersect/etc. each other.\n\nThe geometrical methods (intersect, union etc.) do things to the geometry of\nranges, and return Bio::Map::PositionI compliant objects or triplets (start,\nstop, strand) from which new positions could be built. When a PositionI is made\nit will have a map transferred to it if all the arguments shared the same map.\nIf a Relative was supplied the result will have that same Relative.\n\nNote that the strand-testing args are there for compatability with the RangeI\ninterface. They have no meaning when only using PositionI objects since maps do\nnot have strands. Typically you will just set the argument to undef if you want\nto supply the argument after it.\n\n=head2 equals\n\n  Title   : equals\n  Usage   : if ($p1->equals($p2)) {...}\n  Function: Test whether $p1 has the same start, end, length as $p2.\n  Returns : true if they are describing the same position (regardless of map)\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Positions\n                     equal in terms of their relative position to the thing\n                     described by that Relative\n\n\nsub equals {\n    # overriding the RangeI implementation so we can handle Relative\n    my ($self, $other, $so, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return ($self->_testStrand($other, $so) and\n            $own_start == $other_start and $own_end == $other_end);\n}\n\n\n=head2 less_than\n\n Title   : less_than\n Usage   : if ($position->less_than($other_position)) {...}\n Function: Ask if this Position ends before another starts.\n Returns : boolean\n Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                    one to (mandatory)\n           arg #2 = optional Bio::Map::RelativeI to ask if the Position is less\n                    in terms of their relative position to the thing described\n                    by that Relative","parameters":[{"label":"$self"},{"label":"$other"},{"label":"$rel"}]},"detail":"($self,$other,$rel)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":419,"containerName":"less_than","definition":"my","name":"$self","localvar":"my"},{"name":"$other","containerName":"less_than","line":419,"kind":13},{"line":419,"kind":13,"containerName":"less_than","name":"$rel"},{"localvar":"my","containerName":"less_than","name":"$own_start","definition":"my","line":421,"kind":13},{"containerName":"less_than","name":"$own_end","line":421,"kind":13},{"line":421,"kind":13,"name":"$self","containerName":"less_than"},{"containerName":"less_than","name":"_pre_rangei","line":421,"kind":12},{"name":"$self","containerName":"less_than","kind":13,"line":421},{"containerName":"less_than","name":"$rel","kind":13,"line":421},{"localvar":"my","name":"$other_start","definition":"my","containerName":"less_than","line":422,"kind":13},{"line":422,"kind":13,"containerName":"less_than","name":"$other_end"},{"line":422,"kind":13,"name":"$self","containerName":"less_than"},{"name":"_pre_rangei","containerName":"less_than","kind":12,"line":422},{"kind":13,"line":422,"containerName":"less_than","name":"$other"},{"containerName":"less_than","name":"$rel","kind":13,"line":422},{"line":424,"kind":13,"containerName":"less_than","name":"$own_end"},{"containerName":"less_than","name":"$other_start","line":424,"kind":13}],"line":418,"kind":12,"range":{"end":{"character":9999,"line":425},"start":{"line":418,"character":0}},"name":"less_than"},{"line":441,"children":[{"line":442,"kind":13,"localvar":"my","containerName":"greater_than","definition":"my","name":"$self"},{"name":"$other","containerName":"greater_than","kind":13,"line":442},{"line":442,"kind":13,"name":"$rel","containerName":"greater_than"},{"definition":"my","name":"$own_start","containerName":"greater_than","localvar":"my","kind":13,"line":444},{"name":"$own_end","containerName":"greater_than","kind":13,"line":444},{"name":"$self","containerName":"greater_than","line":444,"kind":13},{"kind":12,"line":444,"name":"_pre_rangei","containerName":"greater_than"},{"name":"$self","containerName":"greater_than","line":444,"kind":13},{"name":"$rel","containerName":"greater_than","kind":13,"line":444},{"localvar":"my","name":"$other_start","definition":"my","containerName":"greater_than","line":445,"kind":13},{"line":445,"kind":13,"name":"$other_end","containerName":"greater_than"},{"line":445,"kind":13,"name":"$self","containerName":"greater_than"},{"line":445,"kind":12,"containerName":"greater_than","name":"_pre_rangei"},{"name":"$other","containerName":"greater_than","line":445,"kind":13},{"kind":13,"line":445,"name":"$rel","containerName":"greater_than"},{"containerName":"greater_than","name":"$own_start","line":447,"kind":13},{"name":"$other_end","containerName":"greater_than","line":447,"kind":13}],"kind":12,"detail":"($self,$other,$rel)","signature":{"label":"greater_than($self,$other,$rel)","documentation":"1;\n# $Id: PositionI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionI - Abstracts the notion of a position having a value in the context of a marker and a Map\n\n=head1 SYNOPSIS\n\n    # do not use this module directly\n    # See Bio::Map::Position for an example of\n    # implementation.\n\n=head1 DESCRIPTION\n\nThis object stores one of the postions that a mappable object\n(e.g. Marker) may have in a map.\n\nPositions can have non-numeric values or other methods to store the locations,\nso they have a method numeric() which does the conversion. numeric()\nreturns the position in a form that can be compared between other positions of\nthe same type. It is not necessarily a value suitable for sorting positions (it\nmay be the distance from the previous position); for that purpose the result of\nsortable() should be used.\n\nA 'position', in addition to being a single point, can also be an area and so\ncan be imagined as a range and compared with other positions on the basis of\noverlap, intersection etc.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein-at-cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionI;\nuse strict;\nuse Bio::Map::PositionHandler;\nuse Bio::Map::Mappable;\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Map::EntityI Bio::RangeI);\n\n=head2 EntityI methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 get_position_handler\n\n Title   : get_position_handler\n Usage   : my $position_handler = $entity->get_position_handler();\n Function: Gets a PositionHandlerI that $entity is registered with.\n Returns : Bio::Map::PositionHandlerI object\n Args    : none\n\n\nsub get_position_handler {\n    my $self = shift;\n    unless (defined $self->{_eh}) {\n        my $ph = Bio::Map::PositionHandler->new(-self => $self);\n        $self->{_eh} = $ph;\n        $ph->register;\n    }\n    return $self->{_eh};\n}\n\n=head2 PositionHandlerI-related methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position->map();\n           $position->map($map);\n Function: Get/Set the map the position is in.\n Returns : L<Bio::Map::MapI>\n Args    : none to get\n           new L<Bio::Map::MapI> to set\n\n\nsub map {\n    my ($self, $map) = @_;\n    return $self->get_position_handler->map($map);\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $position->element();\n           $position->element($element);\n Function: Get/Set the element the position is for.\n Returns : L<Bio::Map::MappableI>\n Args    : none to get\n           new L<Bio::Map::MappableI> to set\n\n\nsub element {\n    my ($self, $element) = @_;\n    return $self->get_position_handler->element($element);\n}\n\n=head2 marker\n\n Title   : marker\n Function: This is a synonym of the element() method\n Status  : deprecated, will be removed in the next version\n\n\n*marker = \\&element;\n\n=head2 PositionI-specific methods\n\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value();\n Function: Get/Set the value for this position\n Returns : scalar, value\n Args    : [optional] new value to set\n\n\nsub value {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 numeric\n\n Title   : numeric\n Usage   : my $num = $position->numeric;\n Function: Read-only method that is guaranteed to return a numeric \n           representation of the start of this position. \n Returns : scalar numeric\n Args    : none to get the co-ordinate normally (see absolute() method), OR\n           Bio::Map::RelativeI to get the co-ordinate converted to be\n           relative to what this Relative describes.\n\n\nsub numeric {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 sortable\n\n Title   : sortable\n Usage   : my $num = $position->sortable();\n Function: Read-only method that is guaranteed to return a value suitable\n           for correctly sorting this kind of position amongst other positions\n           of the same kind on the same map. Note that sorting different kinds\n           of position together is unlikely to give sane results.\n Returns : numeric\n Args    : none\n\n\nsub sortable {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set\n\n\nsub relative {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 absolute\n\n  Title   : absolute\n  Usage   : my $absolute = $position->absolute();\n            $position->absolute($absolute);\n  Function: Get/set how this Position's co-ordinates (numerical(), start(),\n            end()) are reported. When absolute is off, co-ordinates are\n            relative to the thing described by relative(). Ie. the value\n            returned by start() will be the same as the value you set start()\n            to. When absolute is on, co-ordinates are converted to be relative\n            to the start of the map.\n\n            So if relative() currently points to a Relative object describing\n            \"relative to another position which is 100 bp from the start of\n            the map\", this Position's start() had been set to 50 and absolute()\n            returns 1, $position->start() will return 150. If absolute() returns\n            0 in the same situation, $position->start() would return 50.\n\n  Returns : boolean (default 0)\n  Args    : none to get, OR\n            boolean to set\n\n\nsub absolute {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 RangeI-based methods\n\n\n=head2 start\n\n  Title   : start\n  Usage   : my $start = $position->start();\n            $position->start($start);\n  Function: Get/set the start co-ordinate of this position.\n  Returns : the start of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 end\n\n  Title   : end\n  Usage   : my $end = $position->end();\n            $position->end($end);\n  Function: Get/set the end co-ordinate of this position.\n  Returns : the end of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $position->length();\n  Function: Get the length of this position.\n  Returns : the length of this position\n  Args    : none\n\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $position->strand();\n  Function: Get the strand of this position; it is always 1 since maps to not\n            have strands.\n  Returns : 1\n  Args    : none\n\n\nsub strand {\n    return 1;\n}\n\n=head2 toString\n\n  Title   : toString\n  Usage   : print $position->toString(), \"\\n\";\n  Function: stringifies this range\n  Returns : a string representation of the range of this Position\n  Args    : optional Bio::Map::RelativeI to have the co-ordinates reported\n            relative to the thing described by that Relative\n\n\nsub toString {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head1 RangeI-related methods\n\nThese methods work by considering only the values of start() and end(), as\nmodified by considering every such co-ordinate relative to the start of the map\n(ie. absolute(1) is set temporarily during the calculation), or any supplied\nRelative. For the boolean methods, when the comparison Position is on the same\nmap as the calling Position, there is no point supplying a Relative since the\nanswer will be the same as without. Relative is most useful when comparing\nPositions on different maps and you have a Relative that describes some special\nplace on each map like 'the start of the gene', where the actual start of the\ngene relative to the start of the map is different for each map.\n\nThe methods do not consider maps during their calculations - things on different\nmaps can overlap/contain/intersect/etc. each other.\n\nThe geometrical methods (intersect, union etc.) do things to the geometry of\nranges, and return Bio::Map::PositionI compliant objects or triplets (start,\nstop, strand) from which new positions could be built. When a PositionI is made\nit will have a map transferred to it if all the arguments shared the same map.\nIf a Relative was supplied the result will have that same Relative.\n\nNote that the strand-testing args are there for compatability with the RangeI\ninterface. They have no meaning when only using PositionI objects since maps do\nnot have strands. Typically you will just set the argument to undef if you want\nto supply the argument after it.\n\n=head2 equals\n\n  Title   : equals\n  Usage   : if ($p1->equals($p2)) {...}\n  Function: Test whether $p1 has the same start, end, length as $p2.\n  Returns : true if they are describing the same position (regardless of map)\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Positions\n                     equal in terms of their relative position to the thing\n                     described by that Relative\n\n\nsub equals {\n    # overriding the RangeI implementation so we can handle Relative\n    my ($self, $other, $so, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return ($self->_testStrand($other, $so) and\n            $own_start == $other_start and $own_end == $other_end);\n}\n\n\n=head2 less_than\n\n Title   : less_than\n Usage   : if ($position->less_than($other_position)) {...}\n Function: Ask if this Position ends before another starts.\n Returns : boolean\n Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                    one to (mandatory)\n           arg #2 = optional Bio::Map::RelativeI to ask if the Position is less\n                    in terms of their relative position to the thing described\n                    by that Relative\n\n\nsub less_than {\n    my ($self, $other, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return $own_end < $other_start;\n}\n\n=head2 greater_than\n\n Title   : greater_than\n Usage   : if ($position->greater_than($other_position)) {...}\n Function: Ask if this Position starts after another ends.\n Returns : boolean\n Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                    one to (mandatory)\n           arg #2 = optional Bio::Map::RelativeI to ask if the Position is\n                    greater in terms of their relative position to the thing\n                    described by that Relative","parameters":[{"label":"$self"},{"label":"$other"},{"label":"$rel"}]},"containerName":"main::","definition":"sub","range":{"start":{"line":441,"character":0},"end":{"line":448,"character":9999}},"name":"greater_than"},{"definition":"sub","containerName":"main::","signature":{"label":"overlaps($self,$other,$so,$rel,$min_percent)","parameters":[{"label":"$self"},{"label":"$other"},{"label":"$so"},{"label":"$rel"},{"label":"$min_percent"}],"documentation":"1;\n# $Id: PositionI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionI - Abstracts the notion of a position having a value in the context of a marker and a Map\n\n=head1 SYNOPSIS\n\n    # do not use this module directly\n    # See Bio::Map::Position for an example of\n    # implementation.\n\n=head1 DESCRIPTION\n\nThis object stores one of the postions that a mappable object\n(e.g. Marker) may have in a map.\n\nPositions can have non-numeric values or other methods to store the locations,\nso they have a method numeric() which does the conversion. numeric()\nreturns the position in a form that can be compared between other positions of\nthe same type. It is not necessarily a value suitable for sorting positions (it\nmay be the distance from the previous position); for that purpose the result of\nsortable() should be used.\n\nA 'position', in addition to being a single point, can also be an area and so\ncan be imagined as a range and compared with other positions on the basis of\noverlap, intersection etc.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein-at-cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionI;\nuse strict;\nuse Bio::Map::PositionHandler;\nuse Bio::Map::Mappable;\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Map::EntityI Bio::RangeI);\n\n=head2 EntityI methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 get_position_handler\n\n Title   : get_position_handler\n Usage   : my $position_handler = $entity->get_position_handler();\n Function: Gets a PositionHandlerI that $entity is registered with.\n Returns : Bio::Map::PositionHandlerI object\n Args    : none\n\n\nsub get_position_handler {\n    my $self = shift;\n    unless (defined $self->{_eh}) {\n        my $ph = Bio::Map::PositionHandler->new(-self => $self);\n        $self->{_eh} = $ph;\n        $ph->register;\n    }\n    return $self->{_eh};\n}\n\n=head2 PositionHandlerI-related methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position->map();\n           $position->map($map);\n Function: Get/Set the map the position is in.\n Returns : L<Bio::Map::MapI>\n Args    : none to get\n           new L<Bio::Map::MapI> to set\n\n\nsub map {\n    my ($self, $map) = @_;\n    return $self->get_position_handler->map($map);\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $position->element();\n           $position->element($element);\n Function: Get/Set the element the position is for.\n Returns : L<Bio::Map::MappableI>\n Args    : none to get\n           new L<Bio::Map::MappableI> to set\n\n\nsub element {\n    my ($self, $element) = @_;\n    return $self->get_position_handler->element($element);\n}\n\n=head2 marker\n\n Title   : marker\n Function: This is a synonym of the element() method\n Status  : deprecated, will be removed in the next version\n\n\n*marker = \\&element;\n\n=head2 PositionI-specific methods\n\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value();\n Function: Get/Set the value for this position\n Returns : scalar, value\n Args    : [optional] new value to set\n\n\nsub value {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 numeric\n\n Title   : numeric\n Usage   : my $num = $position->numeric;\n Function: Read-only method that is guaranteed to return a numeric \n           representation of the start of this position. \n Returns : scalar numeric\n Args    : none to get the co-ordinate normally (see absolute() method), OR\n           Bio::Map::RelativeI to get the co-ordinate converted to be\n           relative to what this Relative describes.\n\n\nsub numeric {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 sortable\n\n Title   : sortable\n Usage   : my $num = $position->sortable();\n Function: Read-only method that is guaranteed to return a value suitable\n           for correctly sorting this kind of position amongst other positions\n           of the same kind on the same map. Note that sorting different kinds\n           of position together is unlikely to give sane results.\n Returns : numeric\n Args    : none\n\n\nsub sortable {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set\n\n\nsub relative {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 absolute\n\n  Title   : absolute\n  Usage   : my $absolute = $position->absolute();\n            $position->absolute($absolute);\n  Function: Get/set how this Position's co-ordinates (numerical(), start(),\n            end()) are reported. When absolute is off, co-ordinates are\n            relative to the thing described by relative(). Ie. the value\n            returned by start() will be the same as the value you set start()\n            to. When absolute is on, co-ordinates are converted to be relative\n            to the start of the map.\n\n            So if relative() currently points to a Relative object describing\n            \"relative to another position which is 100 bp from the start of\n            the map\", this Position's start() had been set to 50 and absolute()\n            returns 1, $position->start() will return 150. If absolute() returns\n            0 in the same situation, $position->start() would return 50.\n\n  Returns : boolean (default 0)\n  Args    : none to get, OR\n            boolean to set\n\n\nsub absolute {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 RangeI-based methods\n\n\n=head2 start\n\n  Title   : start\n  Usage   : my $start = $position->start();\n            $position->start($start);\n  Function: Get/set the start co-ordinate of this position.\n  Returns : the start of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 end\n\n  Title   : end\n  Usage   : my $end = $position->end();\n            $position->end($end);\n  Function: Get/set the end co-ordinate of this position.\n  Returns : the end of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $position->length();\n  Function: Get the length of this position.\n  Returns : the length of this position\n  Args    : none\n\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $position->strand();\n  Function: Get the strand of this position; it is always 1 since maps to not\n            have strands.\n  Returns : 1\n  Args    : none\n\n\nsub strand {\n    return 1;\n}\n\n=head2 toString\n\n  Title   : toString\n  Usage   : print $position->toString(), \"\\n\";\n  Function: stringifies this range\n  Returns : a string representation of the range of this Position\n  Args    : optional Bio::Map::RelativeI to have the co-ordinates reported\n            relative to the thing described by that Relative\n\n\nsub toString {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head1 RangeI-related methods\n\nThese methods work by considering only the values of start() and end(), as\nmodified by considering every such co-ordinate relative to the start of the map\n(ie. absolute(1) is set temporarily during the calculation), or any supplied\nRelative. For the boolean methods, when the comparison Position is on the same\nmap as the calling Position, there is no point supplying a Relative since the\nanswer will be the same as without. Relative is most useful when comparing\nPositions on different maps and you have a Relative that describes some special\nplace on each map like 'the start of the gene', where the actual start of the\ngene relative to the start of the map is different for each map.\n\nThe methods do not consider maps during their calculations - things on different\nmaps can overlap/contain/intersect/etc. each other.\n\nThe geometrical methods (intersect, union etc.) do things to the geometry of\nranges, and return Bio::Map::PositionI compliant objects or triplets (start,\nstop, strand) from which new positions could be built. When a PositionI is made\nit will have a map transferred to it if all the arguments shared the same map.\nIf a Relative was supplied the result will have that same Relative.\n\nNote that the strand-testing args are there for compatability with the RangeI\ninterface. They have no meaning when only using PositionI objects since maps do\nnot have strands. Typically you will just set the argument to undef if you want\nto supply the argument after it.\n\n=head2 equals\n\n  Title   : equals\n  Usage   : if ($p1->equals($p2)) {...}\n  Function: Test whether $p1 has the same start, end, length as $p2.\n  Returns : true if they are describing the same position (regardless of map)\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Positions\n                     equal in terms of their relative position to the thing\n                     described by that Relative\n\n\nsub equals {\n    # overriding the RangeI implementation so we can handle Relative\n    my ($self, $other, $so, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return ($self->_testStrand($other, $so) and\n            $own_start == $other_start and $own_end == $other_end);\n}\n\n\n=head2 less_than\n\n Title   : less_than\n Usage   : if ($position->less_than($other_position)) {...}\n Function: Ask if this Position ends before another starts.\n Returns : boolean\n Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                    one to (mandatory)\n           arg #2 = optional Bio::Map::RelativeI to ask if the Position is less\n                    in terms of their relative position to the thing described\n                    by that Relative\n\n\nsub less_than {\n    my ($self, $other, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return $own_end < $other_start;\n}\n\n=head2 greater_than\n\n Title   : greater_than\n Usage   : if ($position->greater_than($other_position)) {...}\n Function: Ask if this Position starts after another ends.\n Returns : boolean\n Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                    one to (mandatory)\n           arg #2 = optional Bio::Map::RelativeI to ask if the Position is\n                    greater in terms of their relative position to the thing\n                    described by that Relative\n\n\nsub greater_than {\n    my ($self, $other, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return $own_start > $other_end;\n}\n\n=head2 overlaps\n\n  Title   : overlaps\n  Usage   : if ($p1->overlaps($p2)) {...}\n  Function: Tests if $p1 overlaps $p2.\n  Returns : True if the positions overlap (regardless of map), false otherwise\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Positions\n                     overlap in terms of their relative position to the thing\n                     described by that Relative\n            arg #4 = optional minimum percentage length of the overlap before\n                     reporting an overlap exists (default 0)"},"detail":"($self,$other,$so,$rel,$min_percent)","kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"overlaps","line":469,"kind":13},{"containerName":"overlaps","name":"$other","kind":13,"line":469},{"kind":13,"line":469,"name":"$so","containerName":"overlaps"},{"kind":13,"line":469,"name":"$rel","containerName":"overlaps"},{"kind":13,"line":469,"name":"$min_percent","containerName":"overlaps"},{"containerName":"overlaps","name":"$min_percent","line":470,"kind":13},{"localvar":"my","containerName":"overlaps","name":"$own_min","definition":"my","line":472,"kind":13},{"line":472,"kind":13,"containerName":"overlaps","name":"$other_min"},{"name":"$min_percent","containerName":"overlaps","kind":13,"line":473},{"kind":13,"line":474,"containerName":"overlaps","name":"$own_min"},{"name":"$self","containerName":"overlaps","line":474,"kind":13},{"containerName":"overlaps","name":"length","line":474,"kind":12},{"containerName":"overlaps","name":"$min_percent","line":474,"kind":13},{"containerName":"overlaps","name":"$other_min","kind":13,"line":475},{"name":"$other","containerName":"overlaps","kind":13,"line":475},{"name":"length","containerName":"overlaps","kind":12,"line":475},{"name":"$min_percent","containerName":"overlaps","line":475,"kind":13},{"localvar":"my","name":"$own_start","definition":"my","containerName":"overlaps","line":478,"kind":13},{"name":"$own_end","containerName":"overlaps","kind":13,"line":478},{"name":"$self","containerName":"overlaps","line":478,"kind":13},{"line":478,"kind":12,"name":"_pre_rangei","containerName":"overlaps"},{"kind":13,"line":478,"name":"$self","containerName":"overlaps"},{"containerName":"overlaps","name":"$rel","kind":13,"line":478},{"line":479,"kind":13,"localvar":"my","containerName":"overlaps","name":"$other_start","definition":"my"},{"line":479,"kind":13,"name":"$other_end","containerName":"overlaps"},{"kind":13,"line":479,"containerName":"overlaps","name":"$self"},{"kind":12,"line":479,"name":"_pre_rangei","containerName":"overlaps"},{"containerName":"overlaps","name":"$other","line":479,"kind":13},{"containerName":"overlaps","name":"$rel","line":479,"kind":13},{"kind":13,"line":481,"name":"$self","containerName":"overlaps"},{"line":481,"kind":12,"containerName":"overlaps","name":"_testStrand"},{"name":"$other","containerName":"overlaps","line":481,"kind":13},{"containerName":"overlaps","name":"$so","line":481,"kind":13},{"kind":13,"line":482,"name":"$own_start","containerName":"overlaps"},{"kind":13,"line":482,"containerName":"overlaps","name":"$own_min"},{"name":"$other_end","containerName":"overlaps","kind":13,"line":482},{"name":"$own_end","containerName":"overlaps","kind":13,"line":482},{"containerName":"overlaps","name":"$own_min","kind":13,"line":482},{"kind":13,"line":482,"name":"$other_start","containerName":"overlaps"},{"line":483,"kind":13,"containerName":"overlaps","name":"$own_start"},{"kind":13,"line":483,"containerName":"overlaps","name":"$other_end"},{"kind":13,"line":483,"name":"$other_min","containerName":"overlaps"},{"kind":13,"line":483,"containerName":"overlaps","name":"$own_end"},{"line":483,"kind":13,"containerName":"overlaps","name":"$other_start"},{"name":"$other_min","containerName":"overlaps","kind":13,"line":483}],"line":467,"name":"overlaps","range":{"end":{"line":484,"character":9999},"start":{"character":0,"line":467}}},{"kind":12,"line":502,"children":[{"definition":"my","name":"$self","containerName":"contains","localvar":"my","kind":13,"line":504},{"name":"$other","containerName":"contains","kind":13,"line":504},{"kind":13,"line":504,"name":"$so","containerName":"contains"},{"name":"$rel","containerName":"contains","kind":13,"line":504},{"line":506,"kind":13,"localvar":"my","containerName":"contains","name":"$own_start","definition":"my"},{"name":"$own_end","containerName":"contains","kind":13,"line":506},{"containerName":"contains","name":"$self","kind":13,"line":506},{"line":506,"kind":12,"name":"_pre_rangei","containerName":"contains"},{"kind":13,"line":506,"containerName":"contains","name":"$self"},{"line":506,"kind":13,"name":"$rel","containerName":"contains"},{"name":"$other_start","definition":"my","containerName":"contains","localvar":"my","kind":13,"line":507},{"name":"$other_end","containerName":"contains","kind":13,"line":507},{"containerName":"contains","name":"$self","kind":13,"line":507},{"line":507,"kind":12,"name":"_pre_rangei","containerName":"contains"},{"name":"$other","containerName":"contains","line":507,"kind":13},{"containerName":"contains","name":"$rel","line":507,"kind":13},{"kind":13,"line":509,"name":"$self","containerName":"contains"},{"kind":12,"line":509,"containerName":"contains","name":"_testStrand"},{"containerName":"contains","name":"$other","line":509,"kind":13},{"name":"$so","containerName":"contains","kind":13,"line":509},{"containerName":"contains","name":"$other_start","kind":13,"line":510},{"containerName":"contains","name":"$own_start","line":510,"kind":13},{"line":510,"kind":13,"containerName":"contains","name":"$other_end"},{"containerName":"contains","name":"$own_end","kind":13,"line":510}],"containerName":"main::","definition":"sub","detail":"($self,$other,$so,$rel)","signature":{"label":"contains($self,$other,$so,$rel)","documentation":"1;\n# $Id: PositionI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionI - Abstracts the notion of a position having a value in the context of a marker and a Map\n\n=head1 SYNOPSIS\n\n    # do not use this module directly\n    # See Bio::Map::Position for an example of\n    # implementation.\n\n=head1 DESCRIPTION\n\nThis object stores one of the postions that a mappable object\n(e.g. Marker) may have in a map.\n\nPositions can have non-numeric values or other methods to store the locations,\nso they have a method numeric() which does the conversion. numeric()\nreturns the position in a form that can be compared between other positions of\nthe same type. It is not necessarily a value suitable for sorting positions (it\nmay be the distance from the previous position); for that purpose the result of\nsortable() should be used.\n\nA 'position', in addition to being a single point, can also be an area and so\ncan be imagined as a range and compared with other positions on the basis of\noverlap, intersection etc.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein-at-cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionI;\nuse strict;\nuse Bio::Map::PositionHandler;\nuse Bio::Map::Mappable;\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Map::EntityI Bio::RangeI);\n\n=head2 EntityI methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 get_position_handler\n\n Title   : get_position_handler\n Usage   : my $position_handler = $entity->get_position_handler();\n Function: Gets a PositionHandlerI that $entity is registered with.\n Returns : Bio::Map::PositionHandlerI object\n Args    : none\n\n\nsub get_position_handler {\n    my $self = shift;\n    unless (defined $self->{_eh}) {\n        my $ph = Bio::Map::PositionHandler->new(-self => $self);\n        $self->{_eh} = $ph;\n        $ph->register;\n    }\n    return $self->{_eh};\n}\n\n=head2 PositionHandlerI-related methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position->map();\n           $position->map($map);\n Function: Get/Set the map the position is in.\n Returns : L<Bio::Map::MapI>\n Args    : none to get\n           new L<Bio::Map::MapI> to set\n\n\nsub map {\n    my ($self, $map) = @_;\n    return $self->get_position_handler->map($map);\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $position->element();\n           $position->element($element);\n Function: Get/Set the element the position is for.\n Returns : L<Bio::Map::MappableI>\n Args    : none to get\n           new L<Bio::Map::MappableI> to set\n\n\nsub element {\n    my ($self, $element) = @_;\n    return $self->get_position_handler->element($element);\n}\n\n=head2 marker\n\n Title   : marker\n Function: This is a synonym of the element() method\n Status  : deprecated, will be removed in the next version\n\n\n*marker = \\&element;\n\n=head2 PositionI-specific methods\n\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value();\n Function: Get/Set the value for this position\n Returns : scalar, value\n Args    : [optional] new value to set\n\n\nsub value {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 numeric\n\n Title   : numeric\n Usage   : my $num = $position->numeric;\n Function: Read-only method that is guaranteed to return a numeric \n           representation of the start of this position. \n Returns : scalar numeric\n Args    : none to get the co-ordinate normally (see absolute() method), OR\n           Bio::Map::RelativeI to get the co-ordinate converted to be\n           relative to what this Relative describes.\n\n\nsub numeric {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 sortable\n\n Title   : sortable\n Usage   : my $num = $position->sortable();\n Function: Read-only method that is guaranteed to return a value suitable\n           for correctly sorting this kind of position amongst other positions\n           of the same kind on the same map. Note that sorting different kinds\n           of position together is unlikely to give sane results.\n Returns : numeric\n Args    : none\n\n\nsub sortable {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set\n\n\nsub relative {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 absolute\n\n  Title   : absolute\n  Usage   : my $absolute = $position->absolute();\n            $position->absolute($absolute);\n  Function: Get/set how this Position's co-ordinates (numerical(), start(),\n            end()) are reported. When absolute is off, co-ordinates are\n            relative to the thing described by relative(). Ie. the value\n            returned by start() will be the same as the value you set start()\n            to. When absolute is on, co-ordinates are converted to be relative\n            to the start of the map.\n\n            So if relative() currently points to a Relative object describing\n            \"relative to another position which is 100 bp from the start of\n            the map\", this Position's start() had been set to 50 and absolute()\n            returns 1, $position->start() will return 150. If absolute() returns\n            0 in the same situation, $position->start() would return 50.\n\n  Returns : boolean (default 0)\n  Args    : none to get, OR\n            boolean to set\n\n\nsub absolute {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 RangeI-based methods\n\n\n=head2 start\n\n  Title   : start\n  Usage   : my $start = $position->start();\n            $position->start($start);\n  Function: Get/set the start co-ordinate of this position.\n  Returns : the start of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 end\n\n  Title   : end\n  Usage   : my $end = $position->end();\n            $position->end($end);\n  Function: Get/set the end co-ordinate of this position.\n  Returns : the end of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $position->length();\n  Function: Get the length of this position.\n  Returns : the length of this position\n  Args    : none\n\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $position->strand();\n  Function: Get the strand of this position; it is always 1 since maps to not\n            have strands.\n  Returns : 1\n  Args    : none\n\n\nsub strand {\n    return 1;\n}\n\n=head2 toString\n\n  Title   : toString\n  Usage   : print $position->toString(), \"\\n\";\n  Function: stringifies this range\n  Returns : a string representation of the range of this Position\n  Args    : optional Bio::Map::RelativeI to have the co-ordinates reported\n            relative to the thing described by that Relative\n\n\nsub toString {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head1 RangeI-related methods\n\nThese methods work by considering only the values of start() and end(), as\nmodified by considering every such co-ordinate relative to the start of the map\n(ie. absolute(1) is set temporarily during the calculation), or any supplied\nRelative. For the boolean methods, when the comparison Position is on the same\nmap as the calling Position, there is no point supplying a Relative since the\nanswer will be the same as without. Relative is most useful when comparing\nPositions on different maps and you have a Relative that describes some special\nplace on each map like 'the start of the gene', where the actual start of the\ngene relative to the start of the map is different for each map.\n\nThe methods do not consider maps during their calculations - things on different\nmaps can overlap/contain/intersect/etc. each other.\n\nThe geometrical methods (intersect, union etc.) do things to the geometry of\nranges, and return Bio::Map::PositionI compliant objects or triplets (start,\nstop, strand) from which new positions could be built. When a PositionI is made\nit will have a map transferred to it if all the arguments shared the same map.\nIf a Relative was supplied the result will have that same Relative.\n\nNote that the strand-testing args are there for compatability with the RangeI\ninterface. They have no meaning when only using PositionI objects since maps do\nnot have strands. Typically you will just set the argument to undef if you want\nto supply the argument after it.\n\n=head2 equals\n\n  Title   : equals\n  Usage   : if ($p1->equals($p2)) {...}\n  Function: Test whether $p1 has the same start, end, length as $p2.\n  Returns : true if they are describing the same position (regardless of map)\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Positions\n                     equal in terms of their relative position to the thing\n                     described by that Relative\n\n\nsub equals {\n    # overriding the RangeI implementation so we can handle Relative\n    my ($self, $other, $so, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return ($self->_testStrand($other, $so) and\n            $own_start == $other_start and $own_end == $other_end);\n}\n\n\n=head2 less_than\n\n Title   : less_than\n Usage   : if ($position->less_than($other_position)) {...}\n Function: Ask if this Position ends before another starts.\n Returns : boolean\n Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                    one to (mandatory)\n           arg #2 = optional Bio::Map::RelativeI to ask if the Position is less\n                    in terms of their relative position to the thing described\n                    by that Relative\n\n\nsub less_than {\n    my ($self, $other, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return $own_end < $other_start;\n}\n\n=head2 greater_than\n\n Title   : greater_than\n Usage   : if ($position->greater_than($other_position)) {...}\n Function: Ask if this Position starts after another ends.\n Returns : boolean\n Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                    one to (mandatory)\n           arg #2 = optional Bio::Map::RelativeI to ask if the Position is\n                    greater in terms of their relative position to the thing\n                    described by that Relative\n\n\nsub greater_than {\n    my ($self, $other, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return $own_start > $other_end;\n}\n\n=head2 overlaps\n\n  Title   : overlaps\n  Usage   : if ($p1->overlaps($p2)) {...}\n  Function: Tests if $p1 overlaps $p2.\n  Returns : True if the positions overlap (regardless of map), false otherwise\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Positions\n                     overlap in terms of their relative position to the thing\n                     described by that Relative\n            arg #4 = optional minimum percentage length of the overlap before\n                     reporting an overlap exists (default 0)\n\n\nsub overlaps {\n    # overriding the RangeI implementation so we can handle Relative\n    my ($self, $other, $so, $rel, $min_percent) = @_;\n    $min_percent ||= 0;\n    \n    my ($own_min, $other_min) = (0, 0);\n    if ($min_percent > 0) {\n        $own_min = (($self->length / 100) * $min_percent) - 1;\n        $other_min = (($other->length / 100) * $min_percent) - 1;\n    }\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return ($self->_testStrand($other, $so) and not\n            (($own_start + $own_min > $other_end or $own_end - $own_min < $other_start) ||\n             ($own_start > $other_end - $other_min or $own_end < $other_start + $other_min)));\n}\n\n=head2 contains\n\n  Title   : contains\n  Usage   : if ($p1->contains($p2)) {...}\n  Function: Tests whether $p1 totally contains $p2.\n  Returns : true if the argument is totally contained within this position\n            (regardless of map), false otherwise\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to, or scalar number (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Position\n                     is contained in terms of their relative position to the\n                     thing described by that Relative","parameters":[{"label":"$self"},{"label":"$other"},{"label":"$so"},{"label":"$rel"}]},"name":"contains","range":{"end":{"character":9999,"line":511},"start":{"line":502,"character":0}}},{"name":"intersection","range":{"end":{"line":549,"character":9999},"start":{"line":535,"character":0}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$given"},{"label":"$so"},{"label":"$rel"}],"documentation":"1;\n# $Id: PositionI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionI - Abstracts the notion of a position having a value in the context of a marker and a Map\n\n=head1 SYNOPSIS\n\n    # do not use this module directly\n    # See Bio::Map::Position for an example of\n    # implementation.\n\n=head1 DESCRIPTION\n\nThis object stores one of the postions that a mappable object\n(e.g. Marker) may have in a map.\n\nPositions can have non-numeric values or other methods to store the locations,\nso they have a method numeric() which does the conversion. numeric()\nreturns the position in a form that can be compared between other positions of\nthe same type. It is not necessarily a value suitable for sorting positions (it\nmay be the distance from the previous position); for that purpose the result of\nsortable() should be used.\n\nA 'position', in addition to being a single point, can also be an area and so\ncan be imagined as a range and compared with other positions on the basis of\noverlap, intersection etc.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein-at-cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionI;\nuse strict;\nuse Bio::Map::PositionHandler;\nuse Bio::Map::Mappable;\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Map::EntityI Bio::RangeI);\n\n=head2 EntityI methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 get_position_handler\n\n Title   : get_position_handler\n Usage   : my $position_handler = $entity->get_position_handler();\n Function: Gets a PositionHandlerI that $entity is registered with.\n Returns : Bio::Map::PositionHandlerI object\n Args    : none\n\n\nsub get_position_handler {\n    my $self = shift;\n    unless (defined $self->{_eh}) {\n        my $ph = Bio::Map::PositionHandler->new(-self => $self);\n        $self->{_eh} = $ph;\n        $ph->register;\n    }\n    return $self->{_eh};\n}\n\n=head2 PositionHandlerI-related methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position->map();\n           $position->map($map);\n Function: Get/Set the map the position is in.\n Returns : L<Bio::Map::MapI>\n Args    : none to get\n           new L<Bio::Map::MapI> to set\n\n\nsub map {\n    my ($self, $map) = @_;\n    return $self->get_position_handler->map($map);\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $position->element();\n           $position->element($element);\n Function: Get/Set the element the position is for.\n Returns : L<Bio::Map::MappableI>\n Args    : none to get\n           new L<Bio::Map::MappableI> to set\n\n\nsub element {\n    my ($self, $element) = @_;\n    return $self->get_position_handler->element($element);\n}\n\n=head2 marker\n\n Title   : marker\n Function: This is a synonym of the element() method\n Status  : deprecated, will be removed in the next version\n\n\n*marker = \\&element;\n\n=head2 PositionI-specific methods\n\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value();\n Function: Get/Set the value for this position\n Returns : scalar, value\n Args    : [optional] new value to set\n\n\nsub value {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 numeric\n\n Title   : numeric\n Usage   : my $num = $position->numeric;\n Function: Read-only method that is guaranteed to return a numeric \n           representation of the start of this position. \n Returns : scalar numeric\n Args    : none to get the co-ordinate normally (see absolute() method), OR\n           Bio::Map::RelativeI to get the co-ordinate converted to be\n           relative to what this Relative describes.\n\n\nsub numeric {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 sortable\n\n Title   : sortable\n Usage   : my $num = $position->sortable();\n Function: Read-only method that is guaranteed to return a value suitable\n           for correctly sorting this kind of position amongst other positions\n           of the same kind on the same map. Note that sorting different kinds\n           of position together is unlikely to give sane results.\n Returns : numeric\n Args    : none\n\n\nsub sortable {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set\n\n\nsub relative {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 absolute\n\n  Title   : absolute\n  Usage   : my $absolute = $position->absolute();\n            $position->absolute($absolute);\n  Function: Get/set how this Position's co-ordinates (numerical(), start(),\n            end()) are reported. When absolute is off, co-ordinates are\n            relative to the thing described by relative(). Ie. the value\n            returned by start() will be the same as the value you set start()\n            to. When absolute is on, co-ordinates are converted to be relative\n            to the start of the map.\n\n            So if relative() currently points to a Relative object describing\n            \"relative to another position which is 100 bp from the start of\n            the map\", this Position's start() had been set to 50 and absolute()\n            returns 1, $position->start() will return 150. If absolute() returns\n            0 in the same situation, $position->start() would return 50.\n\n  Returns : boolean (default 0)\n  Args    : none to get, OR\n            boolean to set\n\n\nsub absolute {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 RangeI-based methods\n\n\n=head2 start\n\n  Title   : start\n  Usage   : my $start = $position->start();\n            $position->start($start);\n  Function: Get/set the start co-ordinate of this position.\n  Returns : the start of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 end\n\n  Title   : end\n  Usage   : my $end = $position->end();\n            $position->end($end);\n  Function: Get/set the end co-ordinate of this position.\n  Returns : the end of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $position->length();\n  Function: Get the length of this position.\n  Returns : the length of this position\n  Args    : none\n\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $position->strand();\n  Function: Get the strand of this position; it is always 1 since maps to not\n            have strands.\n  Returns : 1\n  Args    : none\n\n\nsub strand {\n    return 1;\n}\n\n=head2 toString\n\n  Title   : toString\n  Usage   : print $position->toString(), \"\\n\";\n  Function: stringifies this range\n  Returns : a string representation of the range of this Position\n  Args    : optional Bio::Map::RelativeI to have the co-ordinates reported\n            relative to the thing described by that Relative\n\n\nsub toString {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head1 RangeI-related methods\n\nThese methods work by considering only the values of start() and end(), as\nmodified by considering every such co-ordinate relative to the start of the map\n(ie. absolute(1) is set temporarily during the calculation), or any supplied\nRelative. For the boolean methods, when the comparison Position is on the same\nmap as the calling Position, there is no point supplying a Relative since the\nanswer will be the same as without. Relative is most useful when comparing\nPositions on different maps and you have a Relative that describes some special\nplace on each map like 'the start of the gene', where the actual start of the\ngene relative to the start of the map is different for each map.\n\nThe methods do not consider maps during their calculations - things on different\nmaps can overlap/contain/intersect/etc. each other.\n\nThe geometrical methods (intersect, union etc.) do things to the geometry of\nranges, and return Bio::Map::PositionI compliant objects or triplets (start,\nstop, strand) from which new positions could be built. When a PositionI is made\nit will have a map transferred to it if all the arguments shared the same map.\nIf a Relative was supplied the result will have that same Relative.\n\nNote that the strand-testing args are there for compatability with the RangeI\ninterface. They have no meaning when only using PositionI objects since maps do\nnot have strands. Typically you will just set the argument to undef if you want\nto supply the argument after it.\n\n=head2 equals\n\n  Title   : equals\n  Usage   : if ($p1->equals($p2)) {...}\n  Function: Test whether $p1 has the same start, end, length as $p2.\n  Returns : true if they are describing the same position (regardless of map)\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Positions\n                     equal in terms of their relative position to the thing\n                     described by that Relative\n\n\nsub equals {\n    # overriding the RangeI implementation so we can handle Relative\n    my ($self, $other, $so, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return ($self->_testStrand($other, $so) and\n            $own_start == $other_start and $own_end == $other_end);\n}\n\n\n=head2 less_than\n\n Title   : less_than\n Usage   : if ($position->less_than($other_position)) {...}\n Function: Ask if this Position ends before another starts.\n Returns : boolean\n Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                    one to (mandatory)\n           arg #2 = optional Bio::Map::RelativeI to ask if the Position is less\n                    in terms of their relative position to the thing described\n                    by that Relative\n\n\nsub less_than {\n    my ($self, $other, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return $own_end < $other_start;\n}\n\n=head2 greater_than\n\n Title   : greater_than\n Usage   : if ($position->greater_than($other_position)) {...}\n Function: Ask if this Position starts after another ends.\n Returns : boolean\n Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                    one to (mandatory)\n           arg #2 = optional Bio::Map::RelativeI to ask if the Position is\n                    greater in terms of their relative position to the thing\n                    described by that Relative\n\n\nsub greater_than {\n    my ($self, $other, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return $own_start > $other_end;\n}\n\n=head2 overlaps\n\n  Title   : overlaps\n  Usage   : if ($p1->overlaps($p2)) {...}\n  Function: Tests if $p1 overlaps $p2.\n  Returns : True if the positions overlap (regardless of map), false otherwise\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Positions\n                     overlap in terms of their relative position to the thing\n                     described by that Relative\n            arg #4 = optional minimum percentage length of the overlap before\n                     reporting an overlap exists (default 0)\n\n\nsub overlaps {\n    # overriding the RangeI implementation so we can handle Relative\n    my ($self, $other, $so, $rel, $min_percent) = @_;\n    $min_percent ||= 0;\n    \n    my ($own_min, $other_min) = (0, 0);\n    if ($min_percent > 0) {\n        $own_min = (($self->length / 100) * $min_percent) - 1;\n        $other_min = (($other->length / 100) * $min_percent) - 1;\n    }\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return ($self->_testStrand($other, $so) and not\n            (($own_start + $own_min > $other_end or $own_end - $own_min < $other_start) ||\n             ($own_start > $other_end - $other_min or $own_end < $other_start + $other_min)));\n}\n\n=head2 contains\n\n  Title   : contains\n  Usage   : if ($p1->contains($p2)) {...}\n  Function: Tests whether $p1 totally contains $p2.\n  Returns : true if the argument is totally contained within this position\n            (regardless of map), false otherwise\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to, or scalar number (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Position\n                     is contained in terms of their relative position to the\n                     thing described by that Relative\n\n\nsub contains {\n    # overriding the RangeI implementation so we can handle Relative\n    my ($self, $other, $so, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return ($self->_testStrand($other, $so) and\n\t\t\t$other_start >= $own_start and $other_end <= $own_end);\n}\n\n=head2 intersection\n\n Title   : intersection\n Usage   : ($start, $stop, $strand) = $p1->intersection($p2)\n           ($start, $stop, $strand) = Bio::Map::Position->intersection(\\@positions);\n           $mappable = $p1->intersection($p2, undef, $relative);\n           $mappable = Bio::Map::Position->intersection(\\@positions);\n Function: gives the range that is contained by all ranges\n Returns : undef if they do not overlap, OR\n           Bio::Map::Mappable object who's positions are the\n           cross-map-calculated intersection of the input positions on all the\n           maps that the input positions belong to, OR, in list context, a three\n           element array (start, end, strand)\n Args    : arg #1 = [REQUIRED] a Bio::RangeI (eg. a Bio::Map::Position) to\n                    compare this one to, or an array ref of Bio::RangeI\n           arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n           arg #3 = optional Bio::Map::RelativeI to ask how the Positions\n                    intersect in terms of their relative position to the thing\n                    described by that Relative","label":"intersection($self,$given,$so,$rel)"},"detail":"($self,$given,$so,$rel)","kind":12,"children":[{"kind":13,"line":538,"containerName":"intersection","name":"$self","definition":"my","localvar":"my"},{"line":538,"kind":13,"containerName":"intersection","name":"$given"},{"containerName":"intersection","name":"$so","kind":13,"line":538},{"name":"$rel","containerName":"intersection","line":538,"kind":13},{"name":"$self","containerName":"intersection","line":539,"kind":13},{"kind":12,"line":539,"name":"throw","containerName":"intersection"},{"kind":13,"line":539,"name":"$given","containerName":"intersection"},{"definition":"my","name":"@positions","containerName":"intersection","localvar":"my","kind":13,"line":541},{"name":"$self","containerName":"intersection","kind":13,"line":542},{"name":"$self","containerName":"intersection","kind":13,"line":543},{"kind":13,"line":544,"name":"$self","containerName":"intersection"},{"containerName":"intersection","name":"warn","line":544,"kind":12},{"name":"$self","containerName":"intersection","line":546,"kind":13},{"containerName":"intersection","name":"@positions","line":547,"kind":13},{"containerName":"intersection","name":"$self","kind":13,"line":547},{"line":549,"kind":13,"name":"$given","containerName":"intersection"},{"containerName":"intersection","name":"@positions","kind":13,"line":549},{"line":549,"kind":13,"name":"$given","containerName":"intersection"}],"line":535},{"line":549,"kind":13,"containerName":null,"name":"@positions"},{"containerName":null,"name":"$given","line":549,"kind":13},{"kind":13,"line":550,"name":"$self","containerName":null},{"name":"throw","containerName":"main::","line":550,"kind":12},{"kind":13,"line":550,"containerName":null,"name":"@positions"},{"localvar":"my","name":"$intersect","definition":"my","containerName":null,"line":552,"kind":13},{"containerName":null,"name":"$i_start","line":552,"kind":13},{"containerName":null,"name":"$i_end","kind":13,"line":552},{"line":552,"kind":13,"name":"$c_start","containerName":null},{"kind":13,"line":552,"name":"$c_end","containerName":null},{"containerName":null,"name":"%known_maps","line":552,"kind":13},{"containerName":null,"name":"@positions","line":553,"kind":13},{"kind":13,"line":554,"containerName":null,"name":"%intersect"},{"kind":13,"line":555,"containerName":null,"name":"$intersect"},{"containerName":null,"name":"@positions","line":555,"kind":13},{"containerName":null,"name":"$i_start","line":556,"kind":13},{"containerName":null,"name":"$i_end","line":556,"kind":13},{"name":"$self","containerName":null,"line":556,"kind":13},{"name":"_pre_rangei","containerName":"main::","kind":12,"line":556},{"kind":13,"line":556,"containerName":null,"name":"$intersect"},{"kind":13,"line":556,"containerName":null,"name":"$rel"},{"kind":13,"line":557,"containerName":null,"name":"$map","definition":"my","localvar":"my"},{"kind":13,"line":557,"containerName":null,"name":"$intersect"},{"containerName":"main::","name":"map","kind":12,"line":557},{"line":558,"kind":13,"containerName":null,"name":"%known_maps"},{"line":558,"kind":13,"containerName":null,"name":"$map"},{"name":"unique_id","containerName":"main::","kind":12,"line":558},{"kind":13,"line":558,"containerName":null,"name":"$map"},{"kind":13,"line":561,"containerName":null,"name":"$compare","definition":"my","localvar":"my"},{"name":"@positions","containerName":null,"line":561,"kind":13},{"name":"$c_start","containerName":null,"kind":13,"line":562},{"name":"$c_end","containerName":null,"line":562,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":562},{"line":562,"kind":12,"name":"_pre_rangei","containerName":"main::"},{"containerName":null,"name":"$compare","kind":13,"line":562},{"name":"$rel","containerName":null,"line":562,"kind":13},{"kind":13,"line":563,"containerName":null,"name":"$compare"},{"line":563,"kind":12,"name":"_testStrand","containerName":"main::"},{"kind":13,"line":563,"name":"$intersect","containerName":null},{"line":563,"kind":13,"containerName":null,"name":"$so"},{"kind":13,"line":564,"containerName":null,"name":"$compare"},{"containerName":"main::","name":"isa","line":564,"kind":12},{"kind":13,"line":565,"name":"$this_map","definition":"my","containerName":null,"localvar":"my"},{"name":"$compare","containerName":null,"kind":13,"line":565},{"line":565,"kind":12,"containerName":"main::","name":"map"},{"kind":13,"line":566,"containerName":null,"name":"%this_map"},{"name":"%known_maps","containerName":null,"line":567,"kind":13},{"containerName":null,"name":"$this_map","kind":13,"line":567},{"name":"unique_id","containerName":"main::","kind":12,"line":567},{"kind":13,"line":567,"name":"%this_map","containerName":null},{"containerName":null,"name":"$self","kind":13,"line":571},{"containerName":"main::","name":"throw","line":571,"kind":12},{"line":574,"kind":13,"localvar":"my","name":"@starts","definition":"my","containerName":null},{"name":"$a","containerName":null,"line":574,"kind":13},{"line":574,"kind":13,"name":"$b","containerName":null},{"name":"$i_start","containerName":null,"line":574,"kind":13},{"kind":13,"line":574,"name":"$c_start","containerName":null},{"line":575,"kind":13,"localvar":"my","name":"@ends","definition":"my","containerName":null},{"line":575,"kind":13,"containerName":null,"name":"$a"},{"line":575,"kind":13,"name":"$b","containerName":null},{"containerName":null,"name":"$i_end","line":575,"kind":13},{"containerName":null,"name":"$c_end","kind":13,"line":575},{"containerName":null,"definition":"my","name":"$start","localvar":"my","kind":13,"line":577},{"containerName":null,"name":"@starts","line":577,"kind":13},{"line":578,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$end"},{"kind":13,"line":578,"containerName":null,"name":"@ends"},{"localvar":"my","name":"$intersect_strand","definition":"my","containerName":null,"line":580,"kind":13},{"containerName":null,"name":"$intersect","kind":13,"line":581},{"kind":12,"line":581,"containerName":"main::","name":"strand"},{"name":"$compare","containerName":null,"kind":13,"line":581},{"line":581,"kind":12,"containerName":"main::","name":"strand"},{"name":"$intersect","containerName":null,"kind":13,"line":581},{"kind":12,"line":581,"name":"strand","containerName":"main::"},{"name":"$compare","containerName":null,"line":581,"kind":13},{"containerName":"main::","name":"strand","kind":12,"line":581},{"kind":13,"line":582,"containerName":null,"name":"$intersect_strand"},{"line":582,"kind":13,"name":"$compare","containerName":null},{"line":582,"kind":12,"containerName":"main::","name":"strand"},{"name":"$intersect_strand","containerName":null,"kind":13,"line":585},{"kind":13,"line":588,"containerName":null,"name":"$start"},{"name":"%end","containerName":null,"line":588,"kind":13},{"line":592,"kind":13,"name":"$intersect","containerName":null},{"containerName":null,"name":"$self","kind":13,"line":592},{"line":592,"kind":12,"name":"new","containerName":"main::"},{"line":592,"kind":13,"name":"$start","containerName":null},{"kind":13,"line":593,"containerName":null,"name":"$end"},{"name":"$intersect_strand","containerName":null,"line":594,"kind":13},{"name":"$intersect","containerName":null,"line":598,"kind":13},{"definition":"my","name":"$start","containerName":null,"localvar":"my","kind":13,"line":599},{"line":599,"kind":13,"name":"$end","containerName":null},{"kind":13,"line":599,"name":"$strand","containerName":null},{"containerName":null,"name":"$intersect","line":599,"kind":13},{"line":599,"kind":12,"containerName":"main::","name":"start"},{"kind":13,"line":599,"name":"$intersect","containerName":null},{"containerName":"main::","name":"end","line":599,"kind":12},{"name":"$intersect","containerName":null,"kind":13,"line":599},{"name":"strand","containerName":"main::","kind":12,"line":599},{"line":601,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"@intersects"},{"kind":13,"line":602,"name":"$known_map","definition":"my","containerName":null,"localvar":"my"},{"line":602,"kind":13,"name":"%known_maps","containerName":null},{"localvar":"my","definition":"my","name":"$new_intersect","containerName":null,"line":603,"kind":13},{"containerName":null,"name":"$intersect","line":603,"kind":13},{"containerName":"main::","name":"new","kind":12,"line":603},{"name":"$start","containerName":null,"line":603,"kind":13},{"name":"$end","containerName":null,"line":604,"kind":13},{"kind":13,"line":605,"containerName":null,"name":"$strand"},{"name":"$known_map","containerName":null,"line":606,"kind":13},{"line":607,"kind":13,"containerName":null,"name":"$new_intersect"},{"containerName":"main::","name":"relative","line":607,"kind":12},{"kind":13,"line":607,"name":"$rel","containerName":null},{"kind":13,"line":607,"name":"$rel","containerName":null},{"line":608,"kind":13,"name":"@intersects","containerName":null},{"line":608,"kind":13,"containerName":null,"name":"$new_intersect"},{"line":610,"kind":13,"containerName":null,"name":"@intersects"},{"line":611,"kind":13,"containerName":null,"name":"$intersect"},{"kind":12,"line":611,"containerName":"main::","name":"relative"},{"line":611,"kind":13,"name":"$rel","containerName":null},{"line":611,"kind":13,"containerName":null,"name":"$rel"},{"name":"@intersects","containerName":null,"line":612,"kind":13},{"line":612,"kind":13,"containerName":null,"name":"$intersect"},{"kind":13,"line":615,"definition":"my","name":"$result","containerName":null,"localvar":"my"},{"kind":12,"line":615,"name":"Bio","containerName":"Map::Mappable"},{"name":"new","containerName":"main::","line":615,"kind":12},{"line":616,"kind":13,"containerName":null,"name":"$result"},{"name":"add_position","containerName":"main::","line":616,"kind":12},{"name":"@intersects","containerName":null,"line":616,"kind":13},{"kind":13,"line":617,"containerName":null,"name":"$result"},{"name":"union","range":{"start":{"character":0,"line":640},"end":{"line":657,"character":9999}},"kind":12,"line":640,"children":[{"kind":13,"line":643,"definition":"my","name":"$self","containerName":"union","localvar":"my"},{"name":"@args","containerName":"union","line":643,"kind":13},{"name":"$self","containerName":"union","kind":13,"line":644},{"containerName":"union","name":"throw","kind":12,"line":644},{"name":"@args","containerName":"union","line":644,"kind":13},{"localvar":"my","definition":"my","name":"@positions","containerName":"union","line":646,"kind":13},{"line":647,"kind":13,"localvar":"my","containerName":"union","name":"$rel","definition":"my"},{"kind":13,"line":648,"name":"$self","containerName":"union"},{"containerName":"union","name":"$self","kind":13,"line":649},{"containerName":"union","name":"$self","line":650,"kind":13},{"name":"warn","containerName":"union","line":650,"kind":12},{"line":652,"kind":13,"containerName":"union","name":"$self"},{"containerName":"union","name":"@positions","kind":13,"line":653},{"line":653,"kind":13,"name":"$self","containerName":"union"},{"line":655,"kind":13,"containerName":"union","name":"$args"},{"name":"@positions","containerName":"union","kind":13,"line":656},{"line":656,"kind":13,"containerName":"union","name":"@args"}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"union($self,@args)","documentation":"1;\n# $Id: PositionI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionI - Abstracts the notion of a position having a value in the context of a marker and a Map\n\n=head1 SYNOPSIS\n\n    # do not use this module directly\n    # See Bio::Map::Position for an example of\n    # implementation.\n\n=head1 DESCRIPTION\n\nThis object stores one of the postions that a mappable object\n(e.g. Marker) may have in a map.\n\nPositions can have non-numeric values or other methods to store the locations,\nso they have a method numeric() which does the conversion. numeric()\nreturns the position in a form that can be compared between other positions of\nthe same type. It is not necessarily a value suitable for sorting positions (it\nmay be the distance from the previous position); for that purpose the result of\nsortable() should be used.\n\nA 'position', in addition to being a single point, can also be an area and so\ncan be imagined as a range and compared with other positions on the basis of\noverlap, intersection etc.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein-at-cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionI;\nuse strict;\nuse Bio::Map::PositionHandler;\nuse Bio::Map::Mappable;\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Map::EntityI Bio::RangeI);\n\n=head2 EntityI methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 get_position_handler\n\n Title   : get_position_handler\n Usage   : my $position_handler = $entity->get_position_handler();\n Function: Gets a PositionHandlerI that $entity is registered with.\n Returns : Bio::Map::PositionHandlerI object\n Args    : none\n\n\nsub get_position_handler {\n    my $self = shift;\n    unless (defined $self->{_eh}) {\n        my $ph = Bio::Map::PositionHandler->new(-self => $self);\n        $self->{_eh} = $ph;\n        $ph->register;\n    }\n    return $self->{_eh};\n}\n\n=head2 PositionHandlerI-related methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position->map();\n           $position->map($map);\n Function: Get/Set the map the position is in.\n Returns : L<Bio::Map::MapI>\n Args    : none to get\n           new L<Bio::Map::MapI> to set\n\n\nsub map {\n    my ($self, $map) = @_;\n    return $self->get_position_handler->map($map);\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $position->element();\n           $position->element($element);\n Function: Get/Set the element the position is for.\n Returns : L<Bio::Map::MappableI>\n Args    : none to get\n           new L<Bio::Map::MappableI> to set\n\n\nsub element {\n    my ($self, $element) = @_;\n    return $self->get_position_handler->element($element);\n}\n\n=head2 marker\n\n Title   : marker\n Function: This is a synonym of the element() method\n Status  : deprecated, will be removed in the next version\n\n\n*marker = \\&element;\n\n=head2 PositionI-specific methods\n\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value();\n Function: Get/Set the value for this position\n Returns : scalar, value\n Args    : [optional] new value to set\n\n\nsub value {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 numeric\n\n Title   : numeric\n Usage   : my $num = $position->numeric;\n Function: Read-only method that is guaranteed to return a numeric \n           representation of the start of this position. \n Returns : scalar numeric\n Args    : none to get the co-ordinate normally (see absolute() method), OR\n           Bio::Map::RelativeI to get the co-ordinate converted to be\n           relative to what this Relative describes.\n\n\nsub numeric {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 sortable\n\n Title   : sortable\n Usage   : my $num = $position->sortable();\n Function: Read-only method that is guaranteed to return a value suitable\n           for correctly sorting this kind of position amongst other positions\n           of the same kind on the same map. Note that sorting different kinds\n           of position together is unlikely to give sane results.\n Returns : numeric\n Args    : none\n\n\nsub sortable {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set\n\n\nsub relative {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 absolute\n\n  Title   : absolute\n  Usage   : my $absolute = $position->absolute();\n            $position->absolute($absolute);\n  Function: Get/set how this Position's co-ordinates (numerical(), start(),\n            end()) are reported. When absolute is off, co-ordinates are\n            relative to the thing described by relative(). Ie. the value\n            returned by start() will be the same as the value you set start()\n            to. When absolute is on, co-ordinates are converted to be relative\n            to the start of the map.\n\n            So if relative() currently points to a Relative object describing\n            \"relative to another position which is 100 bp from the start of\n            the map\", this Position's start() had been set to 50 and absolute()\n            returns 1, $position->start() will return 150. If absolute() returns\n            0 in the same situation, $position->start() would return 50.\n\n  Returns : boolean (default 0)\n  Args    : none to get, OR\n            boolean to set\n\n\nsub absolute {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 RangeI-based methods\n\n\n=head2 start\n\n  Title   : start\n  Usage   : my $start = $position->start();\n            $position->start($start);\n  Function: Get/set the start co-ordinate of this position.\n  Returns : the start of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 end\n\n  Title   : end\n  Usage   : my $end = $position->end();\n            $position->end($end);\n  Function: Get/set the end co-ordinate of this position.\n  Returns : the end of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $position->length();\n  Function: Get the length of this position.\n  Returns : the length of this position\n  Args    : none\n\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $position->strand();\n  Function: Get the strand of this position; it is always 1 since maps to not\n            have strands.\n  Returns : 1\n  Args    : none\n\n\nsub strand {\n    return 1;\n}\n\n=head2 toString\n\n  Title   : toString\n  Usage   : print $position->toString(), \"\\n\";\n  Function: stringifies this range\n  Returns : a string representation of the range of this Position\n  Args    : optional Bio::Map::RelativeI to have the co-ordinates reported\n            relative to the thing described by that Relative\n\n\nsub toString {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head1 RangeI-related methods\n\nThese methods work by considering only the values of start() and end(), as\nmodified by considering every such co-ordinate relative to the start of the map\n(ie. absolute(1) is set temporarily during the calculation), or any supplied\nRelative. For the boolean methods, when the comparison Position is on the same\nmap as the calling Position, there is no point supplying a Relative since the\nanswer will be the same as without. Relative is most useful when comparing\nPositions on different maps and you have a Relative that describes some special\nplace on each map like 'the start of the gene', where the actual start of the\ngene relative to the start of the map is different for each map.\n\nThe methods do not consider maps during their calculations - things on different\nmaps can overlap/contain/intersect/etc. each other.\n\nThe geometrical methods (intersect, union etc.) do things to the geometry of\nranges, and return Bio::Map::PositionI compliant objects or triplets (start,\nstop, strand) from which new positions could be built. When a PositionI is made\nit will have a map transferred to it if all the arguments shared the same map.\nIf a Relative was supplied the result will have that same Relative.\n\nNote that the strand-testing args are there for compatability with the RangeI\ninterface. They have no meaning when only using PositionI objects since maps do\nnot have strands. Typically you will just set the argument to undef if you want\nto supply the argument after it.\n\n=head2 equals\n\n  Title   : equals\n  Usage   : if ($p1->equals($p2)) {...}\n  Function: Test whether $p1 has the same start, end, length as $p2.\n  Returns : true if they are describing the same position (regardless of map)\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Positions\n                     equal in terms of their relative position to the thing\n                     described by that Relative\n\n\nsub equals {\n    # overriding the RangeI implementation so we can handle Relative\n    my ($self, $other, $so, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return ($self->_testStrand($other, $so) and\n            $own_start == $other_start and $own_end == $other_end);\n}\n\n\n=head2 less_than\n\n Title   : less_than\n Usage   : if ($position->less_than($other_position)) {...}\n Function: Ask if this Position ends before another starts.\n Returns : boolean\n Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                    one to (mandatory)\n           arg #2 = optional Bio::Map::RelativeI to ask if the Position is less\n                    in terms of their relative position to the thing described\n                    by that Relative\n\n\nsub less_than {\n    my ($self, $other, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return $own_end < $other_start;\n}\n\n=head2 greater_than\n\n Title   : greater_than\n Usage   : if ($position->greater_than($other_position)) {...}\n Function: Ask if this Position starts after another ends.\n Returns : boolean\n Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                    one to (mandatory)\n           arg #2 = optional Bio::Map::RelativeI to ask if the Position is\n                    greater in terms of their relative position to the thing\n                    described by that Relative\n\n\nsub greater_than {\n    my ($self, $other, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return $own_start > $other_end;\n}\n\n=head2 overlaps\n\n  Title   : overlaps\n  Usage   : if ($p1->overlaps($p2)) {...}\n  Function: Tests if $p1 overlaps $p2.\n  Returns : True if the positions overlap (regardless of map), false otherwise\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Positions\n                     overlap in terms of their relative position to the thing\n                     described by that Relative\n            arg #4 = optional minimum percentage length of the overlap before\n                     reporting an overlap exists (default 0)\n\n\nsub overlaps {\n    # overriding the RangeI implementation so we can handle Relative\n    my ($self, $other, $so, $rel, $min_percent) = @_;\n    $min_percent ||= 0;\n    \n    my ($own_min, $other_min) = (0, 0);\n    if ($min_percent > 0) {\n        $own_min = (($self->length / 100) * $min_percent) - 1;\n        $other_min = (($other->length / 100) * $min_percent) - 1;\n    }\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return ($self->_testStrand($other, $so) and not\n            (($own_start + $own_min > $other_end or $own_end - $own_min < $other_start) ||\n             ($own_start > $other_end - $other_min or $own_end < $other_start + $other_min)));\n}\n\n=head2 contains\n\n  Title   : contains\n  Usage   : if ($p1->contains($p2)) {...}\n  Function: Tests whether $p1 totally contains $p2.\n  Returns : true if the argument is totally contained within this position\n            (regardless of map), false otherwise\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to, or scalar number (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Position\n                     is contained in terms of their relative position to the\n                     thing described by that Relative\n\n\nsub contains {\n    # overriding the RangeI implementation so we can handle Relative\n    my ($self, $other, $so, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return ($self->_testStrand($other, $so) and\n\t\t\t$other_start >= $own_start and $other_end <= $own_end);\n}\n\n=head2 intersection\n\n Title   : intersection\n Usage   : ($start, $stop, $strand) = $p1->intersection($p2)\n           ($start, $stop, $strand) = Bio::Map::Position->intersection(\\@positions);\n           $mappable = $p1->intersection($p2, undef, $relative);\n           $mappable = Bio::Map::Position->intersection(\\@positions);\n Function: gives the range that is contained by all ranges\n Returns : undef if they do not overlap, OR\n           Bio::Map::Mappable object who's positions are the\n           cross-map-calculated intersection of the input positions on all the\n           maps that the input positions belong to, OR, in list context, a three\n           element array (start, end, strand)\n Args    : arg #1 = [REQUIRED] a Bio::RangeI (eg. a Bio::Map::Position) to\n                    compare this one to, or an array ref of Bio::RangeI\n           arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n           arg #3 = optional Bio::Map::RelativeI to ask how the Positions\n                    intersect in terms of their relative position to the thing\n                    described by that Relative\n\n\nsub intersection {\n    # overriding the RangeI implementation so we can transfer map and handle\n    # Relative\n    my ($self, $given, $so, $rel) = @_;\n\t$self->throw(\"missing arg: you need to pass in another argument\") unless $given;\n    \n    my @positions;\n    if ($self eq \"Bio::Map::PositionI\") {\n\t\t$self = \"Bio::Map::Position\";\n\t\t$self->warn(\"calling static methods of an interface is deprecated; use $self instead\");\n\t}\n\tif (ref $self) {\n\t\tpush(@positions, $self);\n\t}\n    ref($given) eq 'ARRAY' ? push(@positions, @{$given}) : push(@positions, $given);\n    $self->throw(\"Need at least 2 Positions\") unless @positions >= 2;\n    \n    my ($intersect, $i_start, $i_end, $c_start, $c_end, %known_maps);\n    while (@positions > 0) {\n        unless ($intersect) {\n            $intersect = shift(@positions);\n            ($i_start, $i_end) = $self->_pre_rangei($intersect, $rel);\n            my $map = $intersect->map;\n            $known_maps{$map->unique_id} = $map;\n        }\n        \n        my $compare = shift(@positions);\n        ($c_start, $c_end) = $self->_pre_rangei($compare, $rel);\n        return unless $compare->_testStrand($intersect, $so);\n        if ($compare->isa('Bio::Map::PositionI')) {\n            my $this_map = $compare->map;\n            if ($this_map) {\n                $known_maps{$this_map->unique_id} = $this_map;\n            }\n        }\n        else {\n            $self->throw(\"Only Bio::Map::PositionI objects are supported, not [$compare]\");\n        }\n        \n        my @starts = sort {$a <=> $b} ($i_start, $c_start);\n        my @ends   = sort {$a <=> $b} ($i_end, $c_end);\n        \n        my $start = pop @starts; # larger of the 2 starts\n        my $end = shift @ends;   # smaller of the 2 ends\n        \n        my $intersect_strand;    # strand for the intersection\n        if (defined($intersect->strand) && defined($compare->strand) && $intersect->strand == $compare->strand) {\n            $intersect_strand = $compare->strand;\n        }\n        else {\n            $intersect_strand = 0;\n        }\n        \n        if ($start > $end) {\n            return;\n        }\n        else {\n            $intersect = $self->new(-start  => $start,\n                                    -end    => $end,\n                                    -strand => $intersect_strand);\n        }\n    }\n    \n    $intersect || return;\n    my ($start, $end, $strand) = ($intersect->start, $intersect->end, $intersect->strand);\n    \n    my @intersects;\n    foreach my $known_map (values %known_maps) {\n        my $new_intersect = $intersect->new(-start => $start,\n                                            -end => $end,\n                                            -strand => $strand,\n                                            -map => $known_map);\n        $new_intersect->relative($rel) if $rel;\n        push(@intersects, $new_intersect);\n    }\n    unless (@intersects) {\n        $intersect->relative($rel) if $rel;\n        @intersects = ($intersect);\n    }\n    \n    my $result = Bio::Map::Mappable->new();\n    $result->add_position(@intersects); # sneaky, add_position can take a list of positions\n    return $result;\n}\n\n=head2 union\n\n Title   : union\n Usage   : ($start, $stop, $strand) = $p1->union($p2);\n           ($start, $stop, $strand) = Bio::Map::Position->union(@positions);\n           my $mappable = $p1->union($p2);\n           my $mappable = Bio::Map::Position->union(@positions);\n Function: finds the minimal position/range that contains all of the positions\n Returns : Bio::Map::Mappable object who's positions are the\n           cross-map-calculated union of the input positions on all the maps\n           that the input positions belong to, OR, in list context, a three\n           element array (start, end, strand)\n Args    : a Bio::Map::PositionI to compare this one to, or a list of such\n           OR\n           a single Bio::Map::PositionI or array ref of such AND a\n           Bio::Map::RelativeI to ask for the Position's union in terms of their\n           relative position to the thing described by that Relative","parameters":[{"label":"$self"},{"label":"@args"}]}},{"kind":12,"line":656,"name":"shift"},{"kind":13,"line":659,"containerName":null,"name":"@positions"},{"line":659,"kind":13,"name":"@args","containerName":null},{"name":"@args","containerName":null,"line":661,"kind":13},{"kind":13,"line":661,"containerName":null,"name":"@args"},{"line":661,"kind":12,"name":"isa","containerName":"main::"},{"line":662,"kind":13,"containerName":null,"name":"$rel"},{"line":662,"kind":13,"containerName":null,"name":"@args"},{"localvar":"my","definition":"my","name":"$arg","containerName":null,"line":664,"kind":13},{"kind":13,"line":664,"containerName":null,"name":"@args"},{"name":"@positions","containerName":null,"kind":13,"line":666},{"line":666,"kind":13,"containerName":null,"name":"$arg"},{"containerName":null,"name":"$arg","line":666,"kind":13},{"kind":13,"line":668,"containerName":null,"name":"$self"},{"kind":12,"line":668,"name":"throw","containerName":"main::"},{"line":668,"kind":13,"containerName":null,"name":"@positions"},{"name":"@starts","definition":"my","containerName":null,"localvar":"my","kind":13,"line":670},{"containerName":null,"name":"@ends","kind":13,"line":670},{"containerName":null,"name":"%known_maps","kind":13,"line":670},{"containerName":null,"name":"$union_strand","line":670,"kind":13},{"containerName":null,"definition":"my","name":"$compare","localvar":"my","kind":13,"line":671},{"line":671,"kind":13,"name":"@positions","containerName":null},{"line":674,"kind":13,"localvar":"my","containerName":null,"name":"$start","definition":"my"},{"name":"$end","containerName":null,"line":674,"kind":13},{"name":"$self","containerName":null,"line":674,"kind":13},{"name":"_pre_rangei","containerName":"main::","kind":12,"line":674},{"name":"$compare","containerName":null,"kind":13,"line":674},{"kind":13,"line":674,"containerName":null,"name":"$rel"},{"line":676,"kind":13,"name":"$compare","containerName":null},{"name":"isa","containerName":"main::","line":676,"kind":12},{"localvar":"my","definition":"my","name":"$this_map","containerName":null,"line":677,"kind":13},{"name":"$compare","containerName":null,"kind":13,"line":677},{"kind":12,"line":677,"containerName":"main::","name":"map"},{"name":"%this_map","containerName":null,"line":678,"kind":13},{"line":679,"kind":13,"name":"%known_maps","containerName":null},{"kind":13,"line":679,"containerName":null,"name":"$this_map"},{"name":"unique_id","containerName":"main::","line":679,"kind":12},{"name":"%this_map","containerName":null,"kind":13,"line":679},{"line":683,"kind":13,"containerName":null,"name":"$self"},{"name":"throw","containerName":"main::","line":683,"kind":12},{"containerName":null,"name":"%union_strand","line":686,"kind":13},{"kind":13,"line":687,"name":"$union_strand","containerName":null},{"name":"$compare","containerName":null,"line":687,"kind":13},{"kind":12,"line":687,"containerName":"main::","name":"strand"},{"line":690,"kind":13,"name":"$compare","containerName":null},{"kind":12,"line":690,"name":"strand","containerName":"main::"},{"kind":13,"line":690,"name":"$union_strand","containerName":null},{"kind":13,"line":690,"containerName":null,"name":"$compare"},{"line":690,"kind":12,"name":"strand","containerName":"main::"},{"line":691,"kind":13,"containerName":null,"name":"$union_strand"},{"containerName":null,"name":"@starts","kind":13,"line":695},{"containerName":null,"name":"$start","kind":13,"line":695},{"name":"@ends","containerName":null,"line":696,"kind":13},{"line":696,"kind":13,"containerName":null,"name":"$end"},{"line":699,"kind":13,"containerName":null,"name":"@starts"},{"containerName":null,"name":"$a","line":699,"kind":13},{"kind":13,"line":699,"name":"$b","containerName":null},{"containerName":null,"name":"@starts","line":699,"kind":13},{"containerName":null,"name":"@ends","kind":13,"line":700},{"line":700,"kind":13,"containerName":null,"name":"$a"},{"containerName":null,"name":"$b","kind":13,"line":700},{"line":700,"kind":13,"containerName":null,"name":"@ends"},{"kind":13,"line":701,"containerName":null,"definition":"my","name":"$start","localvar":"my"},{"kind":13,"line":701,"name":"@starts","containerName":null},{"line":702,"kind":13,"localvar":"my","name":"$end","definition":"my","containerName":null},{"kind":13,"line":702,"name":"@ends","containerName":null},{"localvar":"my","containerName":null,"definition":"my","name":"@unions","line":704,"kind":13},{"localvar":"my","definition":"my","name":"$known_map","containerName":null,"line":705,"kind":13},{"containerName":null,"name":"%known_maps","kind":13,"line":705},{"containerName":null,"name":"$new_union","definition":"my","localvar":"my","kind":13,"line":706},{"line":706,"kind":13,"name":"$self","containerName":null},{"name":"new","containerName":"main::","line":706,"kind":12},{"kind":13,"line":706,"containerName":null,"name":"$start"},{"kind":13,"line":707,"containerName":null,"name":"$end"},{"name":"$union_strand","containerName":null,"line":708,"kind":13},{"name":"$known_map","containerName":null,"kind":13,"line":709},{"name":"$new_union","containerName":null,"line":710,"kind":13},{"kind":12,"line":710,"containerName":"main::","name":"relative"},{"name":"$rel","containerName":null,"line":710,"kind":13},{"line":710,"kind":13,"name":"$rel","containerName":null},{"kind":13,"line":711,"name":"@unions","containerName":null},{"containerName":null,"name":"$new_union","kind":13,"line":711},{"kind":13,"line":713,"name":"@unions","containerName":null},{"kind":13,"line":714,"containerName":null,"name":"@unions"},{"kind":13,"line":714,"containerName":null,"name":"$self"},{"kind":12,"line":714,"name":"new","containerName":"main::"},{"kind":13,"line":714,"containerName":null,"name":"$start"},{"containerName":null,"name":"$end","kind":13,"line":715},{"containerName":null,"name":"$union_strand","kind":13,"line":716},{"line":717,"kind":13,"containerName":null,"name":"@unions"},{"kind":12,"line":717,"containerName":"main::","name":"relative"},{"line":717,"kind":13,"name":"$rel","containerName":null},{"containerName":null,"name":"$rel","kind":13,"line":717},{"kind":13,"line":720,"containerName":null,"name":"$result","definition":"my","localvar":"my"},{"name":"Bio","containerName":"Map::Mappable","kind":12,"line":720},{"line":720,"kind":12,"name":"new","containerName":"main::"},{"line":721,"kind":13,"containerName":null,"name":"$result"},{"containerName":"main::","name":"add_position","line":721,"kind":12},{"name":"@unions","containerName":null,"line":721,"kind":13},{"containerName":null,"name":"$result","line":722,"kind":13},{"range":{"start":{"line":760,"character":0},"end":{"line":778,"character":9999}},"name":"disconnected_ranges","detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: PositionI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionI - Abstracts the notion of a position having a value in the context of a marker and a Map\n\n=head1 SYNOPSIS\n\n    # do not use this module directly\n    # See Bio::Map::Position for an example of\n    # implementation.\n\n=head1 DESCRIPTION\n\nThis object stores one of the postions that a mappable object\n(e.g. Marker) may have in a map.\n\nPositions can have non-numeric values or other methods to store the locations,\nso they have a method numeric() which does the conversion. numeric()\nreturns the position in a form that can be compared between other positions of\nthe same type. It is not necessarily a value suitable for sorting positions (it\nmay be the distance from the previous position); for that purpose the result of\nsortable() should be used.\n\nA 'position', in addition to being a single point, can also be an area and so\ncan be imagined as a range and compared with other positions on the basis of\noverlap, intersection etc.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein-at-cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionI;\nuse strict;\nuse Bio::Map::PositionHandler;\nuse Bio::Map::Mappable;\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Map::EntityI Bio::RangeI);\n\n=head2 EntityI methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 get_position_handler\n\n Title   : get_position_handler\n Usage   : my $position_handler = $entity->get_position_handler();\n Function: Gets a PositionHandlerI that $entity is registered with.\n Returns : Bio::Map::PositionHandlerI object\n Args    : none\n\n\nsub get_position_handler {\n    my $self = shift;\n    unless (defined $self->{_eh}) {\n        my $ph = Bio::Map::PositionHandler->new(-self => $self);\n        $self->{_eh} = $ph;\n        $ph->register;\n    }\n    return $self->{_eh};\n}\n\n=head2 PositionHandlerI-related methods\n\n These are fundamental to coordination of Positions and other entities, so are\n implemented at the interface level\n\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position->map();\n           $position->map($map);\n Function: Get/Set the map the position is in.\n Returns : L<Bio::Map::MapI>\n Args    : none to get\n           new L<Bio::Map::MapI> to set\n\n\nsub map {\n    my ($self, $map) = @_;\n    return $self->get_position_handler->map($map);\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $position->element();\n           $position->element($element);\n Function: Get/Set the element the position is for.\n Returns : L<Bio::Map::MappableI>\n Args    : none to get\n           new L<Bio::Map::MappableI> to set\n\n\nsub element {\n    my ($self, $element) = @_;\n    return $self->get_position_handler->element($element);\n}\n\n=head2 marker\n\n Title   : marker\n Function: This is a synonym of the element() method\n Status  : deprecated, will be removed in the next version\n\n\n*marker = \\&element;\n\n=head2 PositionI-specific methods\n\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value();\n Function: Get/Set the value for this position\n Returns : scalar, value\n Args    : [optional] new value to set\n\n\nsub value {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 numeric\n\n Title   : numeric\n Usage   : my $num = $position->numeric;\n Function: Read-only method that is guaranteed to return a numeric \n           representation of the start of this position. \n Returns : scalar numeric\n Args    : none to get the co-ordinate normally (see absolute() method), OR\n           Bio::Map::RelativeI to get the co-ordinate converted to be\n           relative to what this Relative describes.\n\n\nsub numeric {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 sortable\n\n Title   : sortable\n Usage   : my $num = $position->sortable();\n Function: Read-only method that is guaranteed to return a value suitable\n           for correctly sorting this kind of position amongst other positions\n           of the same kind on the same map. Note that sorting different kinds\n           of position together is unlikely to give sane results.\n Returns : numeric\n Args    : none\n\n\nsub sortable {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set\n\n\nsub relative {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 absolute\n\n  Title   : absolute\n  Usage   : my $absolute = $position->absolute();\n            $position->absolute($absolute);\n  Function: Get/set how this Position's co-ordinates (numerical(), start(),\n            end()) are reported. When absolute is off, co-ordinates are\n            relative to the thing described by relative(). Ie. the value\n            returned by start() will be the same as the value you set start()\n            to. When absolute is on, co-ordinates are converted to be relative\n            to the start of the map.\n\n            So if relative() currently points to a Relative object describing\n            \"relative to another position which is 100 bp from the start of\n            the map\", this Position's start() had been set to 50 and absolute()\n            returns 1, $position->start() will return 150. If absolute() returns\n            0 in the same situation, $position->start() would return 50.\n\n  Returns : boolean (default 0)\n  Args    : none to get, OR\n            boolean to set\n\n\nsub absolute {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head2 RangeI-based methods\n\n\n=head2 start\n\n  Title   : start\n  Usage   : my $start = $position->start();\n            $position->start($start);\n  Function: Get/set the start co-ordinate of this position.\n  Returns : the start of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 end\n\n  Title   : end\n  Usage   : my $end = $position->end();\n            $position->end($end);\n  Function: Get/set the end co-ordinate of this position.\n  Returns : the end of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $position->length();\n  Function: Get the length of this position.\n  Returns : the length of this position\n  Args    : none\n\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $position->strand();\n  Function: Get the strand of this position; it is always 1 since maps to not\n            have strands.\n  Returns : 1\n  Args    : none\n\n\nsub strand {\n    return 1;\n}\n\n=head2 toString\n\n  Title   : toString\n  Usage   : print $position->toString(), \"\\n\";\n  Function: stringifies this range\n  Returns : a string representation of the range of this Position\n  Args    : optional Bio::Map::RelativeI to have the co-ordinates reported\n            relative to the thing described by that Relative\n\n\nsub toString {\n    my $self = shift;\n    $self->throw_not_implemented();\n}\n\n=head1 RangeI-related methods\n\nThese methods work by considering only the values of start() and end(), as\nmodified by considering every such co-ordinate relative to the start of the map\n(ie. absolute(1) is set temporarily during the calculation), or any supplied\nRelative. For the boolean methods, when the comparison Position is on the same\nmap as the calling Position, there is no point supplying a Relative since the\nanswer will be the same as without. Relative is most useful when comparing\nPositions on different maps and you have a Relative that describes some special\nplace on each map like 'the start of the gene', where the actual start of the\ngene relative to the start of the map is different for each map.\n\nThe methods do not consider maps during their calculations - things on different\nmaps can overlap/contain/intersect/etc. each other.\n\nThe geometrical methods (intersect, union etc.) do things to the geometry of\nranges, and return Bio::Map::PositionI compliant objects or triplets (start,\nstop, strand) from which new positions could be built. When a PositionI is made\nit will have a map transferred to it if all the arguments shared the same map.\nIf a Relative was supplied the result will have that same Relative.\n\nNote that the strand-testing args are there for compatability with the RangeI\ninterface. They have no meaning when only using PositionI objects since maps do\nnot have strands. Typically you will just set the argument to undef if you want\nto supply the argument after it.\n\n=head2 equals\n\n  Title   : equals\n  Usage   : if ($p1->equals($p2)) {...}\n  Function: Test whether $p1 has the same start, end, length as $p2.\n  Returns : true if they are describing the same position (regardless of map)\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Positions\n                     equal in terms of their relative position to the thing\n                     described by that Relative\n\n\nsub equals {\n    # overriding the RangeI implementation so we can handle Relative\n    my ($self, $other, $so, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return ($self->_testStrand($other, $so) and\n            $own_start == $other_start and $own_end == $other_end);\n}\n\n\n=head2 less_than\n\n Title   : less_than\n Usage   : if ($position->less_than($other_position)) {...}\n Function: Ask if this Position ends before another starts.\n Returns : boolean\n Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                    one to (mandatory)\n           arg #2 = optional Bio::Map::RelativeI to ask if the Position is less\n                    in terms of their relative position to the thing described\n                    by that Relative\n\n\nsub less_than {\n    my ($self, $other, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return $own_end < $other_start;\n}\n\n=head2 greater_than\n\n Title   : greater_than\n Usage   : if ($position->greater_than($other_position)) {...}\n Function: Ask if this Position starts after another ends.\n Returns : boolean\n Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                    one to (mandatory)\n           arg #2 = optional Bio::Map::RelativeI to ask if the Position is\n                    greater in terms of their relative position to the thing\n                    described by that Relative\n\n\nsub greater_than {\n    my ($self, $other, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return $own_start > $other_end;\n}\n\n=head2 overlaps\n\n  Title   : overlaps\n  Usage   : if ($p1->overlaps($p2)) {...}\n  Function: Tests if $p1 overlaps $p2.\n  Returns : True if the positions overlap (regardless of map), false otherwise\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Positions\n                     overlap in terms of their relative position to the thing\n                     described by that Relative\n            arg #4 = optional minimum percentage length of the overlap before\n                     reporting an overlap exists (default 0)\n\n\nsub overlaps {\n    # overriding the RangeI implementation so we can handle Relative\n    my ($self, $other, $so, $rel, $min_percent) = @_;\n    $min_percent ||= 0;\n    \n    my ($own_min, $other_min) = (0, 0);\n    if ($min_percent > 0) {\n        $own_min = (($self->length / 100) * $min_percent) - 1;\n        $other_min = (($other->length / 100) * $min_percent) - 1;\n    }\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return ($self->_testStrand($other, $so) and not\n            (($own_start + $own_min > $other_end or $own_end - $own_min < $other_start) ||\n             ($own_start > $other_end - $other_min or $own_end < $other_start + $other_min)));\n}\n\n=head2 contains\n\n  Title   : contains\n  Usage   : if ($p1->contains($p2)) {...}\n  Function: Tests whether $p1 totally contains $p2.\n  Returns : true if the argument is totally contained within this position\n            (regardless of map), false otherwise\n  Args    : arg #1 = a Bio::RangeI (eg. a Bio::Map::Position) to compare this\n                     one to, or scalar number (mandatory)\n            arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n            arg #3 = optional Bio::Map::RelativeI to ask if the Position\n                     is contained in terms of their relative position to the\n                     thing described by that Relative\n\n\nsub contains {\n    # overriding the RangeI implementation so we can handle Relative\n    my ($self, $other, $so, $rel) = @_;\n    \n    my ($own_start, $own_end) = $self->_pre_rangei($self, $rel);\n    my ($other_start, $other_end) = $self->_pre_rangei($other, $rel);\n    \n    return ($self->_testStrand($other, $so) and\n\t\t\t$other_start >= $own_start and $other_end <= $own_end);\n}\n\n=head2 intersection\n\n Title   : intersection\n Usage   : ($start, $stop, $strand) = $p1->intersection($p2)\n           ($start, $stop, $strand) = Bio::Map::Position->intersection(\\@positions);\n           $mappable = $p1->intersection($p2, undef, $relative);\n           $mappable = Bio::Map::Position->intersection(\\@positions);\n Function: gives the range that is contained by all ranges\n Returns : undef if they do not overlap, OR\n           Bio::Map::Mappable object who's positions are the\n           cross-map-calculated intersection of the input positions on all the\n           maps that the input positions belong to, OR, in list context, a three\n           element array (start, end, strand)\n Args    : arg #1 = [REQUIRED] a Bio::RangeI (eg. a Bio::Map::Position) to\n                    compare this one to, or an array ref of Bio::RangeI\n           arg #2 = optional strand-testing arg ('strong', 'weak', 'ignore')\n           arg #3 = optional Bio::Map::RelativeI to ask how the Positions\n                    intersect in terms of their relative position to the thing\n                    described by that Relative\n\n\nsub intersection {\n    # overriding the RangeI implementation so we can transfer map and handle\n    # Relative\n    my ($self, $given, $so, $rel) = @_;\n\t$self->throw(\"missing arg: you need to pass in another argument\") unless $given;\n    \n    my @positions;\n    if ($self eq \"Bio::Map::PositionI\") {\n\t\t$self = \"Bio::Map::Position\";\n\t\t$self->warn(\"calling static methods of an interface is deprecated; use $self instead\");\n\t}\n\tif (ref $self) {\n\t\tpush(@positions, $self);\n\t}\n    ref($given) eq 'ARRAY' ? push(@positions, @{$given}) : push(@positions, $given);\n    $self->throw(\"Need at least 2 Positions\") unless @positions >= 2;\n    \n    my ($intersect, $i_start, $i_end, $c_start, $c_end, %known_maps);\n    while (@positions > 0) {\n        unless ($intersect) {\n            $intersect = shift(@positions);\n            ($i_start, $i_end) = $self->_pre_rangei($intersect, $rel);\n            my $map = $intersect->map;\n            $known_maps{$map->unique_id} = $map;\n        }\n        \n        my $compare = shift(@positions);\n        ($c_start, $c_end) = $self->_pre_rangei($compare, $rel);\n        return unless $compare->_testStrand($intersect, $so);\n        if ($compare->isa('Bio::Map::PositionI')) {\n            my $this_map = $compare->map;\n            if ($this_map) {\n                $known_maps{$this_map->unique_id} = $this_map;\n            }\n        }\n        else {\n            $self->throw(\"Only Bio::Map::PositionI objects are supported, not [$compare]\");\n        }\n        \n        my @starts = sort {$a <=> $b} ($i_start, $c_start);\n        my @ends   = sort {$a <=> $b} ($i_end, $c_end);\n        \n        my $start = pop @starts; # larger of the 2 starts\n        my $end = shift @ends;   # smaller of the 2 ends\n        \n        my $intersect_strand;    # strand for the intersection\n        if (defined($intersect->strand) && defined($compare->strand) && $intersect->strand == $compare->strand) {\n            $intersect_strand = $compare->strand;\n        }\n        else {\n            $intersect_strand = 0;\n        }\n        \n        if ($start > $end) {\n            return;\n        }\n        else {\n            $intersect = $self->new(-start  => $start,\n                                    -end    => $end,\n                                    -strand => $intersect_strand);\n        }\n    }\n    \n    $intersect || return;\n    my ($start, $end, $strand) = ($intersect->start, $intersect->end, $intersect->strand);\n    \n    my @intersects;\n    foreach my $known_map (values %known_maps) {\n        my $new_intersect = $intersect->new(-start => $start,\n                                            -end => $end,\n                                            -strand => $strand,\n                                            -map => $known_map);\n        $new_intersect->relative($rel) if $rel;\n        push(@intersects, $new_intersect);\n    }\n    unless (@intersects) {\n        $intersect->relative($rel) if $rel;\n        @intersects = ($intersect);\n    }\n    \n    my $result = Bio::Map::Mappable->new();\n    $result->add_position(@intersects); # sneaky, add_position can take a list of positions\n    return $result;\n}\n\n=head2 union\n\n Title   : union\n Usage   : ($start, $stop, $strand) = $p1->union($p2);\n           ($start, $stop, $strand) = Bio::Map::Position->union(@positions);\n           my $mappable = $p1->union($p2);\n           my $mappable = Bio::Map::Position->union(@positions);\n Function: finds the minimal position/range that contains all of the positions\n Returns : Bio::Map::Mappable object who's positions are the\n           cross-map-calculated union of the input positions on all the maps\n           that the input positions belong to, OR, in list context, a three\n           element array (start, end, strand)\n Args    : a Bio::Map::PositionI to compare this one to, or a list of such\n           OR\n           a single Bio::Map::PositionI or array ref of such AND a\n           Bio::Map::RelativeI to ask for the Position's union in terms of their\n           relative position to the thing described by that Relative\n\n\nsub union {\n    # overriding the RangeI implementation so we can transfer map and handle\n    # Relative\n    my ($self, @args) = @_;\n    $self->throw(\"Not enough arguments\") unless @args >= 1;\n    \n    my @positions;\n    my $rel;\n    if ($self eq \"Bio::Map::PositionI\") {\n\t\t$self = \"Bio::Map::Position\";\n\t\t$self->warn(\"calling static methods of an interface is deprecated; use $self instead\");\n\t}\n\tif (ref $self) {\n\t\tpush(@positions, $self);\n\t}\n    if (ref $args[0] eq 'ARRAY') {\n        push(@positions, @{shift(@args)});\n    }\n    else {\n        push(@positions, shift(@args));\n    }\n    if ($args[0] && $args[0]->isa('Bio::Map::RelativeI')) {\n        $rel = shift(@args);\n    }\n    foreach my $arg (@args) {\n        # avoid pushing undefined values into @positions\n        push(@positions, $arg) if $arg;\n    }\n    $self->throw(\"Need at least 2 Positions\") unless @positions >= 2;\n    \n    my (@starts, @ends, %known_maps, $union_strand);\n    foreach my $compare (@positions) {\n        # RangeI union allows start or end to be undefined; however _pre_rangei\n        # will throw\n        my ($start, $end) = $self->_pre_rangei($compare, $rel);\n        \n        if ($compare->isa('Bio::Map::PositionI')) {\n            my $this_map = $compare->map;\n            if ($this_map) {\n                $known_maps{$this_map->unique_id} = $this_map;\n            }\n        }\n        else {\n            $self->throw(\"Only Bio::Map::PositionI objects are supported, not [$compare]\");\n        }\n        \n        if (! defined $union_strand) {\n\t\t\t$union_strand = $compare->strand;\n\t\t}\n        else {\n\t\t\tif (! defined $compare->strand or $union_strand ne $compare->strand) {\n\t\t\t\t$union_strand = 0;\n\t\t\t}\n\t\t}\n        \n        push(@starts, $start);\n        push(@ends, $end);\n    }\n    \n\t@starts = sort { $a <=> $b } @starts;\n\t@ends   = sort { $a <=> $b } @ends;\n\tmy $start = shift @starts;\n\tmy $end = pop @ends;\n    \n    my @unions;\n    foreach my $known_map (values %known_maps) {\n        my $new_union = $self->new(-start => $start,\n                                   -end => $end,\n                                   -strand => $union_strand,\n                                   -map => $known_map);\n        $new_union->relative($rel) if $rel;\n        push(@unions, $new_union);\n    }\n    unless (@unions) {\n        @unions = ($self->new(-start => $start,\n                         -end => $end,\n                         -strand => $union_strand));\n        $unions[0]->relative($rel) if $rel;\n    }\n    \n    my $result = Bio::Map::Mappable->new();\n    $result->add_position(@unions); # sneaky, add_position can take a list of positions\n    return $result;\n}\n\n=head2 overlap_extent\n\n Title   : overlap_extent\n Usage   : ($a_unique,$common,$b_unique) = $a->overlap_extent($b)\n Function: Provides actual amount of overlap between two different\n           positions\n Example :\n Returns : array of values containing the length unique to the calling \n           position, the length common to both, and the length unique to \n           the argument position\n Args    : a position\n\n\n#*** should this be overridden from RangeI?\n\n=head2 disconnected_ranges\n\n Title   : disconnected_ranges\n Usage   : my @disc_ranges = Bio::Map::Position->disconnected_ranges(@ranges);\n Function: Creates the minimal set of positions such that each input position is\n           fully contained by at least one output position, and none of the\n           output positions overlap.\n Returns : Bio::Map::Mappable with the calculated disconnected ranges\n Args    : a Bio::Map::PositionI to compare this one to, or a list of such,\n           OR\n           a single Bio::Map::PositionI or array ref of such AND a\n           Bio::Map::RelativeI to consider all Position's co-ordinates in terms\n           of their relative position to the thing described by that Relative,\n           AND, optionally, an int for the minimum percentage of overlap that\n           must be present before considering two ranges to be overlapping\n           (default 0)","label":"disconnected_ranges($self,@args)"},"containerName":"main::","definition":"sub","line":760,"children":[{"line":763,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"disconnected_ranges"},{"line":763,"kind":13,"name":"@args","containerName":"disconnected_ranges"},{"containerName":"disconnected_ranges","name":"$self","line":764,"kind":13},{"name":"throw","containerName":"disconnected_ranges","kind":12,"line":764},{"line":764,"kind":13,"name":"@args","containerName":"disconnected_ranges"},{"name":"@positions","definition":"my","containerName":"disconnected_ranges","localvar":"my","kind":13,"line":766},{"kind":13,"line":767,"name":"$rel","definition":"my","containerName":"disconnected_ranges","localvar":"my"},{"line":768,"kind":13,"localvar":"my","containerName":"disconnected_ranges","definition":"my","name":"$overlap"},{"kind":13,"line":769,"containerName":"disconnected_ranges","name":"$self"},{"kind":13,"line":770,"name":"$self","containerName":"disconnected_ranges"},{"name":"$self","containerName":"disconnected_ranges","kind":13,"line":771},{"containerName":"disconnected_ranges","name":"warn","kind":12,"line":771},{"name":"$self","containerName":"disconnected_ranges","line":773,"kind":13},{"kind":13,"line":774,"containerName":"disconnected_ranges","name":"@positions"},{"containerName":"disconnected_ranges","name":"$self","kind":13,"line":774},{"containerName":"disconnected_ranges","name":"$args","line":776,"kind":13},{"containerName":"disconnected_ranges","name":"@positions","kind":13,"line":777},{"name":"@args","containerName":"disconnected_ranges","kind":13,"line":777}],"kind":12},{"kind":12,"line":777,"name":"shift"},{"kind":13,"line":780,"containerName":null,"name":"@positions"},{"line":780,"kind":13,"name":"@args","containerName":null},{"line":782,"kind":13,"containerName":null,"name":"@args"},{"kind":13,"line":782,"containerName":null,"name":"@args"},{"line":782,"kind":12,"containerName":"main::","name":"isa"},{"line":783,"kind":13,"name":"$rel","containerName":null},{"line":783,"kind":13,"containerName":null,"name":"@args"},{"kind":13,"line":784,"containerName":null,"name":"$overlap"},{"kind":13,"line":784,"name":"@args","containerName":null},{"line":786,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$arg"},{"containerName":null,"name":"@args","kind":13,"line":786},{"name":"@positions","containerName":null,"line":787,"kind":13},{"kind":13,"line":787,"name":"$arg","containerName":null},{"containerName":null,"name":"$arg","kind":13,"line":787},{"containerName":null,"name":"$self","line":789,"kind":13},{"name":"throw","containerName":"main::","line":789,"kind":12},{"kind":13,"line":789,"name":"@positions","containerName":null},{"kind":13,"line":791,"definition":"my","name":"%known_maps","containerName":null,"localvar":"my"},{"kind":13,"line":792,"definition":"my","name":"$pos","containerName":null,"localvar":"my"},{"name":"@positions","containerName":null,"line":792,"kind":13},{"containerName":null,"name":"$pos","kind":13,"line":793},{"containerName":"main::","name":"isa","line":793,"kind":12},{"name":"$self","containerName":null,"line":793,"kind":13},{"line":793,"kind":12,"containerName":"main::","name":"throw"},{"localvar":"my","containerName":null,"definition":"my","name":"$map","line":794,"kind":13},{"containerName":null,"name":"$pos","line":794,"kind":13},{"kind":12,"line":794,"containerName":"main::","name":"map"},{"name":"%known_maps","containerName":null,"line":795,"kind":13},{"line":795,"kind":13,"containerName":null,"name":"$map"},{"line":795,"kind":12,"name":"unique_id","containerName":"main::"},{"containerName":null,"name":"$map","line":795,"kind":13},{"localvar":"my","definition":"my","name":"%prior_positions","containerName":null,"line":797,"kind":13},{"kind":13,"line":798,"containerName":null,"name":"$map","definition":"my","localvar":"my"},{"kind":13,"line":798,"containerName":null,"name":"%known_maps"},{"localvar":"my","definition":"my","name":"$pos","containerName":null,"line":799,"kind":13},{"kind":13,"line":799,"name":"$map","containerName":null},{"kind":12,"line":799,"name":"get_positions","containerName":"main::"},{"kind":13,"line":800,"containerName":null,"name":"%prior_positions"},{"line":800,"kind":13,"containerName":null,"name":"$pos"},{"kind":13,"line":804,"containerName":null,"definition":"my","name":"@outranges","localvar":"my"},{"name":"$inrange","definition":"my","containerName":null,"localvar":"my","kind":13,"line":805},{"line":805,"kind":13,"containerName":null,"name":"@positions"},{"localvar":"my","definition":"my","name":"@outranges_new","containerName":null,"line":806,"kind":13},{"localvar":"my","definition":"my","name":"%overlapping_ranges","containerName":null,"line":807,"kind":13},{"kind":13,"line":809,"containerName":null,"definition":"my","name":"$i","localvar":"my"},{"line":809,"kind":13,"name":"$i","containerName":null},{"kind":13,"line":809,"name":"@outranges","containerName":null},{"containerName":null,"name":"%i","line":809,"kind":13},{"kind":13,"line":810,"definition":"my","name":"$outrange","containerName":null,"localvar":"my"},{"name":"@outranges","containerName":null,"kind":13,"line":810},{"line":810,"kind":13,"containerName":null,"name":"$i"},{"containerName":null,"name":"$inrange","line":811,"kind":13},{"line":811,"kind":12,"containerName":"main::","name":"overlaps"},{"kind":13,"line":811,"name":"$outrange","containerName":null},{"name":"$rel","containerName":null,"line":811,"kind":13},{"line":811,"kind":13,"name":"%overlap","containerName":null},{"containerName":null,"definition":"my","name":"$union_able","localvar":"my","kind":13,"line":812},{"name":"$inrange","containerName":null,"kind":13,"line":812},{"name":"union","containerName":"main::","line":812,"kind":12},{"kind":13,"line":812,"containerName":null,"name":"$outrange"},{"containerName":null,"name":"$rel","kind":13,"line":812},{"localvar":"my","definition":"my","name":"$pos","containerName":null,"line":814,"kind":13},{"line":814,"kind":13,"name":"$union_able","containerName":null},{"containerName":"main::","name":"get_positions","kind":12,"line":814},{"containerName":null,"name":"%overlapping_ranges","kind":13,"line":815},{"line":815,"kind":13,"name":"$pos","containerName":null},{"line":815,"kind":12,"containerName":"main::","name":"toString"},{"kind":13,"line":815,"containerName":null,"name":"%pos"},{"containerName":null,"name":"@outranges_new","kind":13,"line":822},{"containerName":null,"name":"$outrange","kind":13,"line":822},{"containerName":null,"name":"@outranges","line":826,"kind":13},{"containerName":null,"name":"@outranges_new","kind":13,"line":826},{"kind":13,"line":828,"definition":"my","name":"@overlappers","containerName":null,"localvar":"my"},{"line":828,"kind":13,"name":"%overlapping_ranges","containerName":null},{"name":"@overlappers","containerName":null,"kind":13,"line":829},{"name":"@overlappers","containerName":null,"line":830,"kind":13},{"localvar":"my","name":"$merged_range_able","definition":"my","containerName":null,"line":831,"kind":13},{"name":"@overlappers","containerName":null,"line":831,"kind":13},{"containerName":"main::","name":"union","kind":12,"line":831},{"containerName":null,"name":"@overlappers","kind":13,"line":831},{"kind":13,"line":831,"name":"$rel","containerName":null},{"containerName":null,"name":"@outranges","kind":13,"line":832},{"kind":13,"line":832,"containerName":null,"name":"$merged_range_able"},{"name":"get_positions","containerName":"main::","kind":12,"line":832},{"line":835,"kind":13,"name":"@outranges","containerName":null},{"kind":13,"line":835,"containerName":null,"name":"@overlappers"},{"containerName":null,"name":"@outranges","kind":13,"line":839},{"kind":13,"line":839,"containerName":null,"name":"$self"},{"name":"new","containerName":"main::","line":839,"kind":12},{"kind":13,"line":839,"containerName":null,"name":"$inrange"},{"containerName":"main::","name":"start","kind":12,"line":839},{"name":"$rel","containerName":null,"kind":13,"line":839},{"containerName":null,"name":"$inrange","kind":13,"line":839},{"kind":12,"line":839,"name":"end","containerName":"main::"},{"line":839,"kind":13,"containerName":null,"name":"$rel"},{"line":839,"kind":13,"containerName":null,"name":"$inrange"},{"containerName":"main::","name":"strand","line":839,"kind":12},{"line":839,"kind":13,"name":"$inrange","containerName":null},{"kind":12,"line":839,"name":"map","containerName":"main::"},{"line":839,"kind":13,"name":"$rel","containerName":null},{"localvar":"my","name":"%answers","definition":"my","containerName":null,"line":845,"kind":13},{"containerName":null,"name":"@outranges","line":845,"kind":13},{"localvar":"my","containerName":null,"name":"$map","definition":"my","line":846,"kind":13},{"name":"%known_maps","containerName":null,"kind":13,"line":846},{"localvar":"my","containerName":null,"name":"$pos","definition":"my","line":847,"kind":13},{"line":847,"kind":13,"name":"$map","containerName":null},{"name":"get_positions","containerName":"main::","kind":12,"line":847},{"line":848,"kind":13,"name":"%prior_positions","containerName":null},{"line":848,"kind":13,"name":"$pos","containerName":null},{"name":"%answers","containerName":null,"line":848,"kind":13},{"kind":13,"line":848,"containerName":null,"name":"%pos"},{"containerName":null,"name":"$map","kind":13,"line":849},{"containerName":"main::","name":"purge_positions","line":849,"kind":12},{"kind":13,"line":849,"containerName":null,"name":"$pos"},{"kind":13,"line":854,"definition":"my","name":"%post_positions","containerName":null,"localvar":"my"},{"name":"$map","definition":"my","containerName":null,"localvar":"my","kind":13,"line":855},{"line":855,"kind":13,"containerName":null,"name":"%known_maps"},{"line":856,"kind":13,"localvar":"my","definition":"my","name":"$pos","containerName":null},{"containerName":null,"name":"$map","kind":13,"line":856},{"kind":12,"line":856,"name":"get_positions","containerName":"main::"},{"containerName":null,"name":"%post_positions","line":857,"kind":13},{"name":"$pos","containerName":null,"line":857,"kind":13},{"line":861,"kind":13,"containerName":null,"name":"@outranges"},{"localvar":"my","containerName":null,"definition":"my","name":"@final_positions","line":864,"kind":13},{"kind":13,"line":865,"definition":"my","name":"$map","containerName":null,"localvar":"my"},{"containerName":null,"name":"%known_maps","line":865,"kind":13},{"kind":13,"line":866,"containerName":null,"definition":"my","name":"$pos","localvar":"my"},{"name":"@outranges","containerName":null,"line":866,"kind":13},{"containerName":null,"name":"$pos","kind":13,"line":867},{"containerName":"main::","name":"map","kind":12,"line":867},{"line":867,"kind":13,"name":"%map","containerName":null},{"line":868,"kind":13,"name":"@final_positions","containerName":null},{"kind":13,"line":868,"containerName":null,"name":"%pos"},{"name":"@final_positions","containerName":null,"line":871,"kind":13},{"name":"$pos","containerName":null,"kind":13,"line":871},{"kind":12,"line":871,"name":"new","containerName":"main::"},{"containerName":null,"name":"$pos","kind":13,"line":871},{"name":"start","containerName":"main::","line":871,"kind":12},{"name":"$pos","containerName":null,"line":872,"kind":13},{"line":872,"kind":12,"name":"end","containerName":"main::"},{"line":873,"kind":13,"containerName":null,"name":"$pos"},{"line":873,"kind":12,"name":"relative","containerName":"main::"},{"containerName":null,"name":"$map","kind":13,"line":874},{"kind":13,"line":880,"name":"$result","definition":"my","containerName":null,"localvar":"my"},{"line":880,"kind":12,"containerName":"Map::Mappable","name":"Bio"},{"kind":12,"line":880,"name":"new","containerName":"main::"},{"containerName":null,"name":"$result","line":881,"kind":13},{"line":881,"kind":12,"name":"add_position","containerName":"main::"},{"name":"@final_positions","containerName":null,"kind":13,"line":881},{"line":882,"kind":13,"containerName":null,"name":"$result"},{"range":{"end":{"character":9999,"line":936},"start":{"line":886,"character":0}},"name":"_pre_rangei","line":886,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_pre_rangei","line":887,"kind":13},{"containerName":"_pre_rangei","name":"$other","kind":13,"line":887},{"kind":13,"line":887,"name":"$rel","containerName":"_pre_rangei"},{"kind":13,"line":888,"containerName":"_pre_rangei","name":"$self"},{"kind":12,"line":888,"name":"throw","containerName":"_pre_rangei"},{"name":"$other","containerName":"_pre_rangei","kind":13,"line":888},{"line":889,"kind":13,"name":"$rel","containerName":"_pre_rangei"},{"line":890,"kind":13,"name":"$self","containerName":"_pre_rangei"},{"kind":12,"line":890,"containerName":"_pre_rangei","name":"throw"},{"line":890,"kind":13,"containerName":"_pre_rangei","name":"$rel"},{"line":891,"kind":13,"name":"$self","containerName":"_pre_rangei"},{"containerName":"_pre_rangei","name":"throw","line":891,"kind":12},{"name":"$rel","containerName":"_pre_rangei","kind":13,"line":891},{"containerName":"_pre_rangei","name":"isa","kind":12,"line":891},{"localvar":"my","containerName":"_pre_rangei","name":"$other_start","definition":"my","line":894,"kind":13},{"kind":13,"line":894,"name":"$other_end","containerName":"_pre_rangei"},{"containerName":"_pre_rangei","name":"$other","line":895,"kind":13},{"kind":13,"line":896,"containerName":"_pre_rangei","name":"$other"},{"line":897,"kind":13,"containerName":"_pre_rangei","name":"$self"},{"name":"throw","containerName":"_pre_rangei","kind":12,"line":897},{"kind":13,"line":899,"name":"$self","containerName":"_pre_rangei"},{"name":"throw","containerName":"_pre_rangei","line":899,"kind":12},{"kind":13,"line":899,"containerName":"_pre_rangei","name":"$other"},{"name":"$other","containerName":"_pre_rangei","line":899,"kind":13},{"name":"isa","containerName":"_pre_rangei","line":899,"kind":12},{"kind":13,"line":901,"name":"$other","containerName":"_pre_rangei"},{"kind":12,"line":901,"name":"isa","containerName":"_pre_rangei"},{"kind":13,"line":907,"containerName":"_pre_rangei","definition":"my","name":"$other_map","localvar":"my"},{"name":"$other","containerName":"_pre_rangei","kind":13,"line":907},{"line":907,"kind":12,"containerName":"_pre_rangei","name":"map"},{"kind":13,"line":908,"name":"$other_map","containerName":"_pre_rangei"},{"containerName":"_pre_rangei","name":"$self_map","definition":"my","localvar":"my","kind":13,"line":909},{"line":909,"kind":13,"containerName":"_pre_rangei","name":"$self"},{"line":909,"kind":12,"containerName":"_pre_rangei","name":"map"},{"containerName":"_pre_rangei","name":"$self","kind":13,"line":909},{"name":"throw","containerName":"_pre_rangei","line":909,"kind":12},{"containerName":"_pre_rangei","name":"$other","line":910,"kind":13},{"line":910,"kind":12,"containerName":"_pre_rangei","name":"map"},{"kind":13,"line":910,"name":"$self_map","containerName":"_pre_rangei"},{"kind":13,"line":914,"name":"$rel","containerName":"_pre_rangei"},{"containerName":"_pre_rangei","name":"$other","line":914,"kind":13},{"kind":12,"line":914,"containerName":"_pre_rangei","name":"absolute_relative"},{"containerName":"_pre_rangei","name":"$other_start","kind":13,"line":915},{"containerName":"_pre_rangei","name":"$other","line":915,"kind":13},{"containerName":"_pre_rangei","name":"start","kind":12,"line":915},{"name":"$rel","containerName":"_pre_rangei","line":915,"kind":13},{"kind":13,"line":916,"name":"$other_end","containerName":"_pre_rangei"},{"line":916,"kind":13,"name":"$other","containerName":"_pre_rangei"},{"line":916,"kind":12,"containerName":"_pre_rangei","name":"end"},{"name":"$rel","containerName":"_pre_rangei","kind":13,"line":916},{"kind":13,"line":918,"containerName":"_pre_rangei","name":"$other_map"},{"kind":13,"line":919,"containerName":"_pre_rangei","name":"$self"},{"containerName":"_pre_rangei","name":"map","line":919,"kind":12},{"containerName":"_pre_rangei","name":"$other","kind":13,"line":919},{"line":923,"kind":13,"containerName":"_pre_rangei","name":"$other_start"},{"containerName":"_pre_rangei","name":"$other","kind":13,"line":923},{"kind":12,"line":923,"name":"start","containerName":"_pre_rangei"},{"kind":13,"line":924,"name":"$other_end","containerName":"_pre_rangei"},{"line":924,"kind":13,"name":"$other","containerName":"_pre_rangei"},{"containerName":"_pre_rangei","name":"end","line":924,"kind":12},{"name":"$self","containerName":"_pre_rangei","line":928,"kind":13},{"containerName":"_pre_rangei","name":"throw","kind":12,"line":928},{"line":928,"kind":13,"containerName":"_pre_rangei","name":"$other"},{"line":929,"kind":13,"name":"$other_start","containerName":"_pre_rangei"},{"containerName":"_pre_rangei","name":"$other_end","kind":13,"line":929},{"line":929,"kind":13,"name":"$other","containerName":"_pre_rangei"},{"line":932,"kind":13,"containerName":"_pre_rangei","name":"$other"},{"kind":12,"line":932,"name":"throw","containerName":"_pre_rangei"},{"kind":13,"line":932,"containerName":"_pre_rangei","name":"$other_start"},{"name":"$other","containerName":"_pre_rangei","kind":13,"line":933},{"line":933,"kind":12,"containerName":"_pre_rangei","name":"throw"},{"containerName":"_pre_rangei","name":"$other_end","kind":13,"line":933},{"kind":13,"line":935,"containerName":"_pre_rangei","name":"$other_start"},{"line":935,"kind":13,"name":"$other_end","containerName":"_pre_rangei"}],"kind":12,"detail":"($self,$other,$rel)","signature":{"parameters":[{"label":"$self"},{"label":"$other"},{"label":"$rel"}],"documentation":" get start & end suitable for rangeI methods, taking relative into account","label":"_pre_rangei($self,$other,$rel)"},"containerName":"main::","definition":"sub"},{"line":919,"kind":12,"name":"purge_positions"},{"name":"looks_like_number","kind":12,"line":928}]}