{"version":5,"vars":[{"containerName":"","name":"base","kind":2,"line":106},{"containerName":null,"definition":"my","name":"%RELATIONS","localvar":"my","kind":13,"line":109},{"kind":12,"line":125,"children":[{"line":126,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$class"},{"containerName":"new","name":"@args","kind":13,"line":126},{"kind":13,"line":127,"containerName":"new","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":127,"containerName":"new","name":"$class"},{"line":127,"kind":13,"containerName":"new","name":"@args"},{"containerName":"new","name":"$you","definition":"my","localvar":"my","kind":13,"line":129},{"line":129,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"_rearrange","kind":12,"line":129},{"line":129,"kind":13,"containerName":"new","name":"@args"},{"containerName":"new","name":"$self","line":131,"kind":13},{"kind":12,"line":131,"name":"throw","containerName":"new"},{"line":131,"kind":13,"name":"$you","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":132},{"line":132,"kind":12,"name":"throw","containerName":"new"},{"kind":13,"line":132,"name":"$you","containerName":"new"},{"line":133,"kind":13,"containerName":"new","name":"$self"},{"name":"throw","containerName":"new","line":133,"kind":12},{"name":"$you","containerName":"new","kind":13,"line":133},{"kind":12,"line":133,"containerName":"new","name":"isa"},{"kind":13,"line":134,"name":"$self","containerName":"new"},{"line":134,"kind":13,"name":"$you","containerName":"new"},{"name":"$self","containerName":"new","line":135,"kind":13},{"name":"$RELATIONS","containerName":"new","kind":13,"line":135},{"name":"$self","containerName":"new","kind":13,"line":136}],"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: PositionHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionHandler - A Position Handler Implementation\n\n=head1 SYNOPSIS\n\n    # This is used by modules when they want to implement being a\n    # Position or being something that has Positions (when they are\n    # a L<Bio::Map::EntityI>)\n\n    # Make a PositionHandler that knows about you\n    my $ph = Bio::Map::PositionHandler->new($self);\n\n    # Register with it so that it handles your Position-related needs\n    $ph->register;\n\n    # If you are a position, get/set the map you are on and the marker you are\n    # for\n    $ph->map($map);\n    $ph->element($marker);\n    my $map = $ph->map;\n    my $marker = $ph->element;\n\n    # If you are a marker, add a new position to yourself\n    $ph->add_positions($pos);\n\n    # And then get all your positions on a particular map\n    foreach my $pos ($ph->get_positions($map)) {\n        # do something with this Bio::Map::PositionI\n    }\n\n    # Or find out what maps you exist on\n    my @maps = $ph->get_other_entities;\n\n    # The same applies if you were a map\n\n=head1 DESCRIPTION\n\nA Position Handler copes with the coordination of different Bio::Map::EntityI\nobjects, adding and removing them from each other and knowning who belongs to\nwho. These relationships between objects are based around shared Positions,\nhence PositionHandler.\n\nThis PositionHandler is able to cope with Bio::Map::PositionI objects,\nBio::Map::MappableI objects and Bio::Map::MapI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionHandler;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Map::PositionHandlerI);\n\n# globally accessible hash, via private instance methods\nmy $RELATIONS = {};\n\n=head2 General methods\n\n\n=head2 new\n\n Title   : new\n Usage   : my $position_handler = Bio::Map::PositionHandler->new(-self => $self);\n Function: Get a Bio::Map::PositionHandler that knows who you are.\n Returns : Bio::Map::PositionHandler object\n Args    : -self => Bio::Map::EntityI that is you","label":"new($class,@args)"},"name":"new","range":{"start":{"line":125,"character":0},"end":{"line":137,"character":9999}}},{"line":127,"kind":12,"name":"SUPER","containerName":"new"},{"line":134,"kind":12,"name":"_who"},{"name":"_rel","line":135,"kind":12},{"containerName":"main::","definition":"sub","name":"register","range":{"end":{"character":9999,"line":157},"start":{"character":0,"line":149}},"kind":12,"line":149,"children":[{"name":"$self","definition":"my","containerName":"register","localvar":"my","kind":13,"line":150},{"line":151,"kind":13,"localvar":"my","containerName":"register","name":"$you","definition":"my"},{"kind":13,"line":151,"name":"$self","containerName":"register"},{"line":153,"kind":13,"name":"$self","containerName":"register"},{"kind":12,"line":153,"containerName":"register","name":"throw"},{"kind":13,"line":153,"name":"$you","containerName":"register"},{"containerName":"register","name":"get_position_handler","kind":12,"line":153},{"kind":12,"line":153,"name":"index","containerName":"register"},{"line":155,"kind":13,"name":"$self","containerName":"register"},{"name":"$self","containerName":"register","line":155,"kind":13},{"containerName":"register","name":"$self","kind":13,"line":156},{"name":"$self","containerName":"register","line":156,"kind":13},{"kind":13,"line":156,"containerName":"register","name":"$you"}]},{"name":"_who","line":151,"kind":12},{"kind":12,"line":155,"name":"_index"},{"kind":12,"line":155,"name":"_rel"},{"kind":12,"line":155,"name":"assigned_indices"},{"kind":12,"line":156,"name":"_rel"},{"name":"registered","kind":12,"line":156},{"kind":12,"line":156,"name":"_index"},{"line":170,"children":[{"line":171,"kind":13,"localvar":"my","containerName":"index","name":"$self","definition":"my"},{"line":172,"kind":13,"name":"$self","containerName":"index"}],"kind":12,"range":{"end":{"character":9999,"line":173},"start":{"line":170,"character":0}},"containerName":"main::","definition":"sub","name":"index"},{"name":"_index","line":172,"kind":12},{"definition":"sub","containerName":"main::","signature":{"label":"get_entity($self,$index)","documentation":"1;\n# $Id: PositionHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionHandler - A Position Handler Implementation\n\n=head1 SYNOPSIS\n\n    # This is used by modules when they want to implement being a\n    # Position or being something that has Positions (when they are\n    # a L<Bio::Map::EntityI>)\n\n    # Make a PositionHandler that knows about you\n    my $ph = Bio::Map::PositionHandler->new($self);\n\n    # Register with it so that it handles your Position-related needs\n    $ph->register;\n\n    # If you are a position, get/set the map you are on and the marker you are\n    # for\n    $ph->map($map);\n    $ph->element($marker);\n    my $map = $ph->map;\n    my $marker = $ph->element;\n\n    # If you are a marker, add a new position to yourself\n    $ph->add_positions($pos);\n\n    # And then get all your positions on a particular map\n    foreach my $pos ($ph->get_positions($map)) {\n        # do something with this Bio::Map::PositionI\n    }\n\n    # Or find out what maps you exist on\n    my @maps = $ph->get_other_entities;\n\n    # The same applies if you were a map\n\n=head1 DESCRIPTION\n\nA Position Handler copes with the coordination of different Bio::Map::EntityI\nobjects, adding and removing them from each other and knowning who belongs to\nwho. These relationships between objects are based around shared Positions,\nhence PositionHandler.\n\nThis PositionHandler is able to cope with Bio::Map::PositionI objects,\nBio::Map::MappableI objects and Bio::Map::MapI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionHandler;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Map::PositionHandlerI);\n\n# globally accessible hash, via private instance methods\nmy $RELATIONS = {};\n\n=head2 General methods\n\n\n=head2 new\n\n Title   : new\n Usage   : my $position_handler = Bio::Map::PositionHandler->new(-self => $self);\n Function: Get a Bio::Map::PositionHandler that knows who you are.\n Returns : Bio::Map::PositionHandler object\n Args    : -self => Bio::Map::EntityI that is you\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($you) = $self->_rearrange([qw(SELF)], @args);\n    \n    $self->throw('Must supply -self') unless $you;\n    $self->throw('-self must be a reference (object)') unless ref($you);\n    $self->throw('This is [$you], not a Bio::Map::EntityI object') unless $you->isa('Bio::Map::EntityI');\n    $self->{_who} = $you;\n    $self->{_rel} = $RELATIONS;\n    return $self;\n}\n\n=head2 register\n\n Title   : register\n Usage   : $position_handler->register();\n Function: Ask this Position Handler to look after your entity relationships.\n Returns : n/a\n Args    : none\n\n\nsub register {\n    my $self = shift;\n    my $you = $self->{_who};\n    \n    $self->throw(\"Trying to re-register [$you], which could be bad\") if $you->get_position_handler->index;\n    \n    $self->{_index} = ++$self->{_rel}->{assigned_indices};\n    $self->{_rel}->{registered}->{$self->{_index}} = $you;\n}\n\n=head2 index\n\n Title   : index\n Usage   : my $index = $position_handler->index();\n Function: Get the unique registry index for yourself, generated during the\n           resistration process.\n Returns : int\n Args    : none\n\n\nsub index {\n    my $self = shift;\n    return $self->{_index};\n}\n\n=head2 get_entity\n\n Title   : get_entity\n Usage   : my $entity = $position_handler->get_entity($index);\n Function: Get the entity that corresponds to the supplied registry index.\n Returns : Bio::Map::EntityI object\n Args    : int","parameters":[{"label":"$self"},{"label":"$index"}]},"detail":"($self,$index)","kind":12,"children":[{"localvar":"my","containerName":"get_entity","name":"$self","definition":"my","line":186,"kind":13},{"line":186,"kind":13,"name":"$index","containerName":"get_entity"},{"kind":13,"line":187,"name":"$self","containerName":"get_entity"},{"line":187,"kind":13,"containerName":"get_entity","name":"$index"},{"line":187,"kind":13,"name":"$self","containerName":"get_entity"},{"name":"throw","containerName":"get_entity","line":187,"kind":12}],"line":185,"name":"get_entity","range":{"end":{"character":9999,"line":188},"start":{"character":0,"line":185}}},{"kind":12,"line":187,"name":"_rel"},{"name":"registered","line":187,"kind":12},{"range":{"end":{"character":9999,"line":209},"start":{"line":206,"character":0}},"name":"map","line":206,"children":[{"line":207,"kind":13,"localvar":"my","containerName":"map","definition":"my","name":"$self"},{"containerName":"map","name":"$entity","kind":13,"line":207},{"kind":13,"line":208,"name":"$self","containerName":"map"},{"line":208,"kind":12,"name":"_pos_get_set","containerName":"map"},{"containerName":"map","name":"$entity","kind":13,"line":208}],"kind":12,"detail":"($self,$entity)","signature":{"label":"map($self,$entity)","documentation":"1;\n# $Id: PositionHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionHandler - A Position Handler Implementation\n\n=head1 SYNOPSIS\n\n    # This is used by modules when they want to implement being a\n    # Position or being something that has Positions (when they are\n    # a L<Bio::Map::EntityI>)\n\n    # Make a PositionHandler that knows about you\n    my $ph = Bio::Map::PositionHandler->new($self);\n\n    # Register with it so that it handles your Position-related needs\n    $ph->register;\n\n    # If you are a position, get/set the map you are on and the marker you are\n    # for\n    $ph->map($map);\n    $ph->element($marker);\n    my $map = $ph->map;\n    my $marker = $ph->element;\n\n    # If you are a marker, add a new position to yourself\n    $ph->add_positions($pos);\n\n    # And then get all your positions on a particular map\n    foreach my $pos ($ph->get_positions($map)) {\n        # do something with this Bio::Map::PositionI\n    }\n\n    # Or find out what maps you exist on\n    my @maps = $ph->get_other_entities;\n\n    # The same applies if you were a map\n\n=head1 DESCRIPTION\n\nA Position Handler copes with the coordination of different Bio::Map::EntityI\nobjects, adding and removing them from each other and knowning who belongs to\nwho. These relationships between objects are based around shared Positions,\nhence PositionHandler.\n\nThis PositionHandler is able to cope with Bio::Map::PositionI objects,\nBio::Map::MappableI objects and Bio::Map::MapI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionHandler;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Map::PositionHandlerI);\n\n# globally accessible hash, via private instance methods\nmy $RELATIONS = {};\n\n=head2 General methods\n\n\n=head2 new\n\n Title   : new\n Usage   : my $position_handler = Bio::Map::PositionHandler->new(-self => $self);\n Function: Get a Bio::Map::PositionHandler that knows who you are.\n Returns : Bio::Map::PositionHandler object\n Args    : -self => Bio::Map::EntityI that is you\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($you) = $self->_rearrange([qw(SELF)], @args);\n    \n    $self->throw('Must supply -self') unless $you;\n    $self->throw('-self must be a reference (object)') unless ref($you);\n    $self->throw('This is [$you], not a Bio::Map::EntityI object') unless $you->isa('Bio::Map::EntityI');\n    $self->{_who} = $you;\n    $self->{_rel} = $RELATIONS;\n    return $self;\n}\n\n=head2 register\n\n Title   : register\n Usage   : $position_handler->register();\n Function: Ask this Position Handler to look after your entity relationships.\n Returns : n/a\n Args    : none\n\n\nsub register {\n    my $self = shift;\n    my $you = $self->{_who};\n    \n    $self->throw(\"Trying to re-register [$you], which could be bad\") if $you->get_position_handler->index;\n    \n    $self->{_index} = ++$self->{_rel}->{assigned_indices};\n    $self->{_rel}->{registered}->{$self->{_index}} = $you;\n}\n\n=head2 index\n\n Title   : index\n Usage   : my $index = $position_handler->index();\n Function: Get the unique registry index for yourself, generated during the\n           resistration process.\n Returns : int\n Args    : none\n\n\nsub index {\n    my $self = shift;\n    return $self->{_index};\n}\n\n=head2 get_entity\n\n Title   : get_entity\n Usage   : my $entity = $position_handler->get_entity($index);\n Function: Get the entity that corresponds to the supplied registry index.\n Returns : Bio::Map::EntityI object\n Args    : int\n\n\nsub get_entity {\n    my ($self, $index) = @_;\n    return $self->{_rel}->{registered}->{$index} || $self->throw(\"Requested registy index '$index' but that index isn't in the registry\");\n}\n\n=head2 Methods for Bio::Map::PositionI objects\n\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position_handler->map();\n           $position_handler->map($map);\n Function: Get/Set the map you are on. You must be a Position.\n Returns : L<Bio::Map::MapI>\n Args    : none to get, OR\n           new L<Bio::Map::MapI> to set","parameters":[{"label":"$self"},{"label":"$entity"}]},"containerName":"main::","definition":"sub"},{"range":{"start":{"character":0,"line":223},"end":{"line":226,"character":9999}},"name":"element","children":[{"kind":13,"line":224,"name":"$self","definition":"my","containerName":"element","localvar":"my"},{"kind":13,"line":224,"containerName":"element","name":"$entity"},{"kind":13,"line":225,"name":"$self","containerName":"element"},{"name":"_pos_get_set","containerName":"element","kind":12,"line":225},{"name":"$entity","containerName":"element","line":225,"kind":13}],"line":223,"kind":12,"signature":{"label":"element($self,$entity)","documentation":"1;\n# $Id: PositionHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionHandler - A Position Handler Implementation\n\n=head1 SYNOPSIS\n\n    # This is used by modules when they want to implement being a\n    # Position or being something that has Positions (when they are\n    # a L<Bio::Map::EntityI>)\n\n    # Make a PositionHandler that knows about you\n    my $ph = Bio::Map::PositionHandler->new($self);\n\n    # Register with it so that it handles your Position-related needs\n    $ph->register;\n\n    # If you are a position, get/set the map you are on and the marker you are\n    # for\n    $ph->map($map);\n    $ph->element($marker);\n    my $map = $ph->map;\n    my $marker = $ph->element;\n\n    # If you are a marker, add a new position to yourself\n    $ph->add_positions($pos);\n\n    # And then get all your positions on a particular map\n    foreach my $pos ($ph->get_positions($map)) {\n        # do something with this Bio::Map::PositionI\n    }\n\n    # Or find out what maps you exist on\n    my @maps = $ph->get_other_entities;\n\n    # The same applies if you were a map\n\n=head1 DESCRIPTION\n\nA Position Handler copes with the coordination of different Bio::Map::EntityI\nobjects, adding and removing them from each other and knowning who belongs to\nwho. These relationships between objects are based around shared Positions,\nhence PositionHandler.\n\nThis PositionHandler is able to cope with Bio::Map::PositionI objects,\nBio::Map::MappableI objects and Bio::Map::MapI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionHandler;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Map::PositionHandlerI);\n\n# globally accessible hash, via private instance methods\nmy $RELATIONS = {};\n\n=head2 General methods\n\n\n=head2 new\n\n Title   : new\n Usage   : my $position_handler = Bio::Map::PositionHandler->new(-self => $self);\n Function: Get a Bio::Map::PositionHandler that knows who you are.\n Returns : Bio::Map::PositionHandler object\n Args    : -self => Bio::Map::EntityI that is you\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($you) = $self->_rearrange([qw(SELF)], @args);\n    \n    $self->throw('Must supply -self') unless $you;\n    $self->throw('-self must be a reference (object)') unless ref($you);\n    $self->throw('This is [$you], not a Bio::Map::EntityI object') unless $you->isa('Bio::Map::EntityI');\n    $self->{_who} = $you;\n    $self->{_rel} = $RELATIONS;\n    return $self;\n}\n\n=head2 register\n\n Title   : register\n Usage   : $position_handler->register();\n Function: Ask this Position Handler to look after your entity relationships.\n Returns : n/a\n Args    : none\n\n\nsub register {\n    my $self = shift;\n    my $you = $self->{_who};\n    \n    $self->throw(\"Trying to re-register [$you], which could be bad\") if $you->get_position_handler->index;\n    \n    $self->{_index} = ++$self->{_rel}->{assigned_indices};\n    $self->{_rel}->{registered}->{$self->{_index}} = $you;\n}\n\n=head2 index\n\n Title   : index\n Usage   : my $index = $position_handler->index();\n Function: Get the unique registry index for yourself, generated during the\n           resistration process.\n Returns : int\n Args    : none\n\n\nsub index {\n    my $self = shift;\n    return $self->{_index};\n}\n\n=head2 get_entity\n\n Title   : get_entity\n Usage   : my $entity = $position_handler->get_entity($index);\n Function: Get the entity that corresponds to the supplied registry index.\n Returns : Bio::Map::EntityI object\n Args    : int\n\n\nsub get_entity {\n    my ($self, $index) = @_;\n    return $self->{_rel}->{registered}->{$index} || $self->throw(\"Requested registy index '$index' but that index isn't in the registry\");\n}\n\n=head2 Methods for Bio::Map::PositionI objects\n\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position_handler->map();\n           $position_handler->map($map);\n Function: Get/Set the map you are on. You must be a Position.\n Returns : L<Bio::Map::MapI>\n Args    : none to get, OR\n           new L<Bio::Map::MapI> to set\n\n\nsub map {\n    my ($self, $entity) = @_;\n    return $self->_pos_get_set($entity, 'position_maps', 'Bio::Map::MapI');\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $position_handler->element();\n           $position_handler->element($element);\n Function: Get/Set the map element you are for. You must be a Position.\n Returns : L<Bio::Map::MappableI>\n Args    : none to get, OR\n           new L<Bio::Map::MappableI> to set","parameters":[{"label":"$self"},{"label":"$entity"}]},"detail":"($self,$entity)","definition":"sub","containerName":"main::"},{"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"add_positions","line":243,"kind":13},{"name":"$self","containerName":"add_positions","line":244,"kind":13},{"line":244,"kind":12,"name":"throw","containerName":"add_positions"},{"kind":13,"line":245,"containerName":"add_positions","name":"$you_index","definition":"my","localvar":"my"},{"name":"$self","containerName":"add_positions","kind":13,"line":245},{"containerName":"add_positions","name":"_get_you_index","kind":12,"line":245},{"kind":13,"line":246,"containerName":"add_positions","name":"$kind","definition":"my","localvar":"my"},{"name":"$self","containerName":"add_positions","kind":13,"line":246},{"containerName":"add_positions","name":"_get_kind","line":246,"kind":12},{"line":248,"kind":13,"localvar":"my","containerName":"add_positions","definition":"my","name":"$pos"},{"kind":13,"line":249,"name":"$self","containerName":"add_positions"},{"kind":12,"line":249,"name":"_check_object","containerName":"add_positions"},{"line":249,"kind":13,"name":"$pos","containerName":"add_positions"},{"line":250,"kind":13,"localvar":"my","definition":"my","name":"$pos_index","containerName":"add_positions"},{"containerName":"add_positions","name":"$self","kind":13,"line":250},{"kind":12,"line":250,"containerName":"add_positions","name":"_get_other_index"},{"line":250,"kind":13,"containerName":"add_positions","name":"$pos"},{"containerName":"add_positions","name":"$self","line":252,"kind":13},{"name":"_pos_set","containerName":"add_positions","kind":12,"line":252},{"containerName":"add_positions","name":"$pos_index","line":252,"kind":13},{"name":"$you_index","containerName":"add_positions","line":252,"kind":13},{"name":"$kind","containerName":"add_positions","line":252,"kind":13}],"line":242,"kind":12,"range":{"start":{"line":242,"character":0},"end":{"line":254,"character":9999}},"name":"add_positions","definition":"sub","containerName":"main::"},{"range":{"start":{"character":0,"line":268},"end":{"character":9999,"line":272}},"name":"get_positions","detail":"($self,$entity)","signature":{"parameters":[{"label":"$self"},{"label":"$entity"}],"documentation":"1;\n# $Id: PositionHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionHandler - A Position Handler Implementation\n\n=head1 SYNOPSIS\n\n    # This is used by modules when they want to implement being a\n    # Position or being something that has Positions (when they are\n    # a L<Bio::Map::EntityI>)\n\n    # Make a PositionHandler that knows about you\n    my $ph = Bio::Map::PositionHandler->new($self);\n\n    # Register with it so that it handles your Position-related needs\n    $ph->register;\n\n    # If you are a position, get/set the map you are on and the marker you are\n    # for\n    $ph->map($map);\n    $ph->element($marker);\n    my $map = $ph->map;\n    my $marker = $ph->element;\n\n    # If you are a marker, add a new position to yourself\n    $ph->add_positions($pos);\n\n    # And then get all your positions on a particular map\n    foreach my $pos ($ph->get_positions($map)) {\n        # do something with this Bio::Map::PositionI\n    }\n\n    # Or find out what maps you exist on\n    my @maps = $ph->get_other_entities;\n\n    # The same applies if you were a map\n\n=head1 DESCRIPTION\n\nA Position Handler copes with the coordination of different Bio::Map::EntityI\nobjects, adding and removing them from each other and knowning who belongs to\nwho. These relationships between objects are based around shared Positions,\nhence PositionHandler.\n\nThis PositionHandler is able to cope with Bio::Map::PositionI objects,\nBio::Map::MappableI objects and Bio::Map::MapI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionHandler;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Map::PositionHandlerI);\n\n# globally accessible hash, via private instance methods\nmy $RELATIONS = {};\n\n=head2 General methods\n\n\n=head2 new\n\n Title   : new\n Usage   : my $position_handler = Bio::Map::PositionHandler->new(-self => $self);\n Function: Get a Bio::Map::PositionHandler that knows who you are.\n Returns : Bio::Map::PositionHandler object\n Args    : -self => Bio::Map::EntityI that is you\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($you) = $self->_rearrange([qw(SELF)], @args);\n    \n    $self->throw('Must supply -self') unless $you;\n    $self->throw('-self must be a reference (object)') unless ref($you);\n    $self->throw('This is [$you], not a Bio::Map::EntityI object') unless $you->isa('Bio::Map::EntityI');\n    $self->{_who} = $you;\n    $self->{_rel} = $RELATIONS;\n    return $self;\n}\n\n=head2 register\n\n Title   : register\n Usage   : $position_handler->register();\n Function: Ask this Position Handler to look after your entity relationships.\n Returns : n/a\n Args    : none\n\n\nsub register {\n    my $self = shift;\n    my $you = $self->{_who};\n    \n    $self->throw(\"Trying to re-register [$you], which could be bad\") if $you->get_position_handler->index;\n    \n    $self->{_index} = ++$self->{_rel}->{assigned_indices};\n    $self->{_rel}->{registered}->{$self->{_index}} = $you;\n}\n\n=head2 index\n\n Title   : index\n Usage   : my $index = $position_handler->index();\n Function: Get the unique registry index for yourself, generated during the\n           resistration process.\n Returns : int\n Args    : none\n\n\nsub index {\n    my $self = shift;\n    return $self->{_index};\n}\n\n=head2 get_entity\n\n Title   : get_entity\n Usage   : my $entity = $position_handler->get_entity($index);\n Function: Get the entity that corresponds to the supplied registry index.\n Returns : Bio::Map::EntityI object\n Args    : int\n\n\nsub get_entity {\n    my ($self, $index) = @_;\n    return $self->{_rel}->{registered}->{$index} || $self->throw(\"Requested registy index '$index' but that index isn't in the registry\");\n}\n\n=head2 Methods for Bio::Map::PositionI objects\n\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position_handler->map();\n           $position_handler->map($map);\n Function: Get/Set the map you are on. You must be a Position.\n Returns : L<Bio::Map::MapI>\n Args    : none to get, OR\n           new L<Bio::Map::MapI> to set\n\n\nsub map {\n    my ($self, $entity) = @_;\n    return $self->_pos_get_set($entity, 'position_maps', 'Bio::Map::MapI');\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $position_handler->element();\n           $position_handler->element($element);\n Function: Get/Set the map element you are for. You must be a Position.\n Returns : L<Bio::Map::MappableI>\n Args    : none to get, OR\n           new L<Bio::Map::MappableI> to set\n\n\nsub element {\n    my ($self, $entity) = @_;\n    return $self->_pos_get_set($entity, 'position_elements', 'Bio::Map::MappableI');\n}\n\n=head2 Methods for all other Bio::Map::EntityI objects\n\n\n=head2 add_positions\n\n Title   : add_positions\n Usage   : $position_handler->add_positions($pos1, $pos2, ...);\n Function: Add some positions to yourself. You can't be a position.\n Returns : n/a\n Args    : Array of Bio::Map::PositionI objects\n\n\nsub add_positions {\n    my $self = shift;\n    $self->throw('Must supply at least one Bio::Map::EntityI') unless @_ > 0;\n    my $you_index = $self->_get_you_index(0);\n    my $kind = $self->_get_kind;\n    \n    foreach my $pos (@_) {\n        $self->_check_object($pos, 'Bio::Map::PositionI');\n        my $pos_index = $self->_get_other_index($pos);\n        \n        $self->_pos_set($pos_index, $you_index, $kind);\n    }\n}\n\n=head2 get_positions\n\n Title   : get_positions\n Usage   : my @positions = $position_handler->get_positions();\n Function: Get all your positions. You can't be a Position.\n Returns : Array of Bio::Map::PositionI objects\n Args    : none for all, OR\n           Bio::Map::EntityI object to limit the Positions to those that\n           are shared by you and this other entity.","label":"get_positions($self,$entity)"},"containerName":"main::","definition":"sub","line":268,"children":[{"localvar":"my","containerName":"get_positions","name":"$self","definition":"my","line":269,"kind":13},{"line":269,"kind":13,"name":"$entity","containerName":"get_positions"},{"line":270,"kind":13,"localvar":"my","containerName":"get_positions","definition":"my","name":"$you_index"},{"containerName":"get_positions","name":"$self","kind":13,"line":270},{"name":"_get_you_index","containerName":"get_positions","kind":12,"line":270},{"line":272,"kind":13,"localvar":"my","containerName":"get_positions","definition":"my","name":"@positions"},{"kind":13,"line":272,"name":"$self","containerName":"get_positions"},{"kind":13,"line":272,"containerName":"get_positions","name":"$you_index"}],"kind":12},{"name":"_rel","line":272,"kind":12},{"name":"%entity","containerName":null,"line":274,"kind":13},{"localvar":"my","containerName":null,"name":"$entity_index","definition":"my","line":275,"kind":13},{"name":"$self","containerName":null,"line":275,"kind":13},{"containerName":"main::","name":"_get_other_index","line":275,"kind":12},{"name":"$entity","containerName":null,"kind":13,"line":275},{"containerName":null,"name":"$pos_ref","definition":"my","localvar":"my","kind":13,"line":276},{"containerName":null,"name":"%self","kind":13,"line":276},{"line":276,"kind":12,"name":"_rel"},{"line":276,"kind":13,"containerName":null,"name":"$entity_index"},{"containerName":null,"name":"@positions","line":277,"kind":13},{"line":277,"kind":13,"containerName":null,"name":"%pos_ref"},{"name":"@positions","containerName":null,"line":277,"kind":13},{"containerName":null,"name":"$self","kind":13,"line":280},{"kind":12,"line":280,"name":"get_entity","containerName":"main::"},{"kind":13,"line":280,"containerName":null,"name":"@positions"},{"name":"purge_positions","range":{"end":{"character":9999,"line":312},"start":{"character":0,"line":296}},"containerName":"main::","definition":"sub","detail":"($self,$thing)","signature":{"parameters":[{"label":"$self"},{"label":"$thing"}],"documentation":"1;\n# $Id: PositionHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::PositionHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::PositionHandler - A Position Handler Implementation\n\n=head1 SYNOPSIS\n\n    # This is used by modules when they want to implement being a\n    # Position or being something that has Positions (when they are\n    # a L<Bio::Map::EntityI>)\n\n    # Make a PositionHandler that knows about you\n    my $ph = Bio::Map::PositionHandler->new($self);\n\n    # Register with it so that it handles your Position-related needs\n    $ph->register;\n\n    # If you are a position, get/set the map you are on and the marker you are\n    # for\n    $ph->map($map);\n    $ph->element($marker);\n    my $map = $ph->map;\n    my $marker = $ph->element;\n\n    # If you are a marker, add a new position to yourself\n    $ph->add_positions($pos);\n\n    # And then get all your positions on a particular map\n    foreach my $pos ($ph->get_positions($map)) {\n        # do something with this Bio::Map::PositionI\n    }\n\n    # Or find out what maps you exist on\n    my @maps = $ph->get_other_entities;\n\n    # The same applies if you were a map\n\n=head1 DESCRIPTION\n\nA Position Handler copes with the coordination of different Bio::Map::EntityI\nobjects, adding and removing them from each other and knowning who belongs to\nwho. These relationships between objects are based around shared Positions,\nhence PositionHandler.\n\nThis PositionHandler is able to cope with Bio::Map::PositionI objects,\nBio::Map::MappableI objects and Bio::Map::MapI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::PositionHandler;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Map::PositionHandlerI);\n\n# globally accessible hash, via private instance methods\nmy $RELATIONS = {};\n\n=head2 General methods\n\n\n=head2 new\n\n Title   : new\n Usage   : my $position_handler = Bio::Map::PositionHandler->new(-self => $self);\n Function: Get a Bio::Map::PositionHandler that knows who you are.\n Returns : Bio::Map::PositionHandler object\n Args    : -self => Bio::Map::EntityI that is you\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($you) = $self->_rearrange([qw(SELF)], @args);\n    \n    $self->throw('Must supply -self') unless $you;\n    $self->throw('-self must be a reference (object)') unless ref($you);\n    $self->throw('This is [$you], not a Bio::Map::EntityI object') unless $you->isa('Bio::Map::EntityI');\n    $self->{_who} = $you;\n    $self->{_rel} = $RELATIONS;\n    return $self;\n}\n\n=head2 register\n\n Title   : register\n Usage   : $position_handler->register();\n Function: Ask this Position Handler to look after your entity relationships.\n Returns : n/a\n Args    : none\n\n\nsub register {\n    my $self = shift;\n    my $you = $self->{_who};\n    \n    $self->throw(\"Trying to re-register [$you], which could be bad\") if $you->get_position_handler->index;\n    \n    $self->{_index} = ++$self->{_rel}->{assigned_indices};\n    $self->{_rel}->{registered}->{$self->{_index}} = $you;\n}\n\n=head2 index\n\n Title   : index\n Usage   : my $index = $position_handler->index();\n Function: Get the unique registry index for yourself, generated during the\n           resistration process.\n Returns : int\n Args    : none\n\n\nsub index {\n    my $self = shift;\n    return $self->{_index};\n}\n\n=head2 get_entity\n\n Title   : get_entity\n Usage   : my $entity = $position_handler->get_entity($index);\n Function: Get the entity that corresponds to the supplied registry index.\n Returns : Bio::Map::EntityI object\n Args    : int\n\n\nsub get_entity {\n    my ($self, $index) = @_;\n    return $self->{_rel}->{registered}->{$index} || $self->throw(\"Requested registy index '$index' but that index isn't in the registry\");\n}\n\n=head2 Methods for Bio::Map::PositionI objects\n\n\n=head2 map\n\n Title   : map\n Usage   : my $map = $position_handler->map();\n           $position_handler->map($map);\n Function: Get/Set the map you are on. You must be a Position.\n Returns : L<Bio::Map::MapI>\n Args    : none to get, OR\n           new L<Bio::Map::MapI> to set\n\n\nsub map {\n    my ($self, $entity) = @_;\n    return $self->_pos_get_set($entity, 'position_maps', 'Bio::Map::MapI');\n}\n\n=head2 element\n\n Title   : element\n Usage   : my $element = $position_handler->element();\n           $position_handler->element($element);\n Function: Get/Set the map element you are for. You must be a Position.\n Returns : L<Bio::Map::MappableI>\n Args    : none to get, OR\n           new L<Bio::Map::MappableI> to set\n\n\nsub element {\n    my ($self, $entity) = @_;\n    return $self->_pos_get_set($entity, 'position_elements', 'Bio::Map::MappableI');\n}\n\n=head2 Methods for all other Bio::Map::EntityI objects\n\n\n=head2 add_positions\n\n Title   : add_positions\n Usage   : $position_handler->add_positions($pos1, $pos2, ...);\n Function: Add some positions to yourself. You can't be a position.\n Returns : n/a\n Args    : Array of Bio::Map::PositionI objects\n\n\nsub add_positions {\n    my $self = shift;\n    $self->throw('Must supply at least one Bio::Map::EntityI') unless @_ > 0;\n    my $you_index = $self->_get_you_index(0);\n    my $kind = $self->_get_kind;\n    \n    foreach my $pos (@_) {\n        $self->_check_object($pos, 'Bio::Map::PositionI');\n        my $pos_index = $self->_get_other_index($pos);\n        \n        $self->_pos_set($pos_index, $you_index, $kind);\n    }\n}\n\n=head2 get_positions\n\n Title   : get_positions\n Usage   : my @positions = $position_handler->get_positions();\n Function: Get all your positions. You can't be a Position.\n Returns : Array of Bio::Map::PositionI objects\n Args    : none for all, OR\n           Bio::Map::EntityI object to limit the Positions to those that\n           are shared by you and this other entity.\n\n\nsub get_positions {\n    my ($self, $entity) = @_;\n    my $you_index = $self->_get_you_index(0);\n    \n    my @positions = keys %{$self->{_rel}->{has}->{$you_index}};\n    \n    if ($entity) {\n        my $entity_index = $self->_get_other_index($entity);\n        my $pos_ref = $self->{_rel}->{has}->{$entity_index};\n        @positions = grep { $pos_ref->{$_} } @positions;\n    }\n    \n    return map { $self->get_entity($_) } @positions;\n}\n\n=head2 purge_positions\n\n Title   : purge_positions\n Usage   : $position_handler->purge_positions();\n Function: Remove all positions from yourself. You can't be a Position.\n Returns : n/a\n Args    : none to remove all, OR\n           Bio::Map::PositionI object to remove only that entity, OR\n           Bio::Map::EntityI object to limit the removal to those Positions that\n           are shared by you and this other entity.","label":"purge_positions($self,$thing)"},"kind":12,"line":296,"children":[{"name":"$self","definition":"my","containerName":"purge_positions","localvar":"my","kind":13,"line":297},{"name":"$thing","containerName":"purge_positions","kind":13,"line":297},{"line":298,"kind":13,"localvar":"my","containerName":"purge_positions","name":"$you_index","definition":"my"},{"containerName":"purge_positions","name":"$self","line":298,"kind":13},{"name":"_get_you_index","containerName":"purge_positions","kind":12,"line":298},{"localvar":"my","name":"$kind","definition":"my","containerName":"purge_positions","line":299,"kind":13},{"line":299,"kind":13,"containerName":"purge_positions","name":"$self"},{"kind":12,"line":299,"name":"_get_kind","containerName":"purge_positions"},{"kind":13,"line":301,"containerName":"purge_positions","definition":"my","name":"@pos_indices","localvar":"my"},{"containerName":"purge_positions","name":"$thing","line":302,"kind":13},{"name":"$self","containerName":"purge_positions","line":303,"kind":13},{"containerName":"purge_positions","name":"throw","line":303,"kind":12},{"line":303,"kind":13,"containerName":"purge_positions","name":"$thing"},{"kind":13,"line":304,"containerName":"purge_positions","name":"$thing"},{"line":304,"kind":12,"name":"isa","containerName":"purge_positions"},{"kind":13,"line":305,"name":"@pos_indices","containerName":"purge_positions"},{"name":"$self","containerName":"purge_positions","kind":13,"line":305},{"kind":12,"line":305,"name":"_get_other_index","containerName":"purge_positions"},{"line":305,"kind":13,"containerName":"purge_positions","name":"$thing"},{"kind":13,"line":308,"containerName":"purge_positions","name":"$entity_index","definition":"my","localvar":"my"},{"containerName":"purge_positions","name":"$self","line":308,"kind":13},{"kind":12,"line":308,"containerName":"purge_positions","name":"_get_other_index"},{"line":308,"kind":13,"containerName":"purge_positions","name":"$thing"},{"containerName":"purge_positions","definition":"my","name":"$pos_ref","localvar":"my","kind":13,"line":309},{"name":"$self","containerName":"purge_positions","line":309,"kind":13},{"kind":13,"line":309,"name":"$entity_index","containerName":"purge_positions"},{"line":310,"kind":13,"name":"@pos_indices","containerName":"purge_positions"},{"kind":13,"line":310,"containerName":"purge_positions","name":"$pos_ref"},{"line":310,"kind":13,"containerName":"purge_positions","name":"$self"},{"kind":13,"line":310,"containerName":"purge_positions","name":"$you_index"}]},{"name":"_rel","line":309,"kind":12},{"name":"_rel","line":310,"kind":12},{"name":"@pos_indices","containerName":null,"line":314,"kind":13},{"kind":13,"line":314,"name":"%self","containerName":null},{"name":"_rel","line":314,"kind":12},{"containerName":null,"name":"$you_index","line":314,"kind":13},{"kind":13,"line":317,"definition":"my","name":"$pos_index","containerName":null,"localvar":"my"},{"line":317,"kind":13,"name":"@pos_indices","containerName":null},{"containerName":null,"name":"$self","line":318,"kind":13},{"containerName":"main::","name":"_purge_pos_entity","kind":12,"line":318},{"containerName":null,"name":"$pos_index","line":318,"kind":13},{"line":318,"kind":13,"containerName":null,"name":"$you_index"},{"kind":13,"line":318,"containerName":null,"name":"$kind"},{"kind":12,"line":333,"children":[{"line":334,"kind":13,"localvar":"my","containerName":"get_other_entities","name":"$self","definition":"my"},{"localvar":"my","definition":"my","name":"$you_index","containerName":"get_other_entities","line":335,"kind":13},{"line":335,"kind":13,"containerName":"get_other_entities","name":"$self"},{"name":"_get_you_index","containerName":"get_other_entities","kind":12,"line":335},{"kind":13,"line":336,"definition":"my","name":"$kind","containerName":"get_other_entities","localvar":"my"},{"kind":13,"line":336,"name":"$self","containerName":"get_other_entities"},{"containerName":"get_other_entities","name":"_get_kind","kind":12,"line":336},{"kind":13,"line":337,"name":"$want","definition":"my","containerName":"get_other_entities","localvar":"my"},{"containerName":"get_other_entities","name":"$kind","line":337,"kind":13},{"line":339,"kind":13,"localvar":"my","containerName":"get_other_entities","name":"%entities","definition":"my"},{"localvar":"my","containerName":"get_other_entities","name":"$pos_index","definition":"my","line":340,"kind":13},{"line":340,"kind":13,"name":"$self","containerName":"get_other_entities"},{"containerName":"get_other_entities","name":"$you_index","kind":13,"line":340}],"containerName":"main::","name":"get_other_entities","definition":"sub","range":{"start":{"line":333,"character":0},"end":{"line":340,"character":9999}}},{"kind":12,"line":340,"name":"_rel"},{"localvar":"my","containerName":null,"definition":"my","name":"$entity_index","line":341,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":341},{"kind":12,"line":341,"name":"_rel"},{"containerName":null,"name":"%want","line":341,"kind":13},{"containerName":null,"name":"$pos_index","line":341,"kind":13},{"name":"%entities","containerName":null,"kind":13,"line":342},{"containerName":null,"name":"$entity_index","line":342,"kind":13},{"containerName":null,"name":"%entity_index","kind":13,"line":342},{"containerName":null,"name":"$self","line":345,"kind":13},{"containerName":"main::","name":"get_entity","kind":12,"line":345},{"name":"%entities","containerName":null,"kind":13,"line":345},{"range":{"start":{"character":0,"line":349},"end":{"character":9999,"line":354}},"name":"_check_object","signature":{"label":"_check_object($self,$object,$interface)","parameters":[{"label":"$self"},{"label":"$object"},{"label":"$interface"}],"documentation":" do basic check on an object, make sure it is the right type"},"detail":"($self,$object,$interface)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":350,"name":"$self","definition":"my","containerName":"_check_object","localvar":"my"},{"name":"$object","containerName":"_check_object","line":350,"kind":13},{"kind":13,"line":350,"containerName":"_check_object","name":"$interface"},{"line":351,"kind":13,"containerName":"_check_object","name":"$self"},{"containerName":"_check_object","name":"throw","kind":12,"line":351},{"containerName":"_check_object","name":"$object","line":351,"kind":13},{"name":"$self","containerName":"_check_object","kind":13,"line":352},{"kind":12,"line":352,"name":"throw","containerName":"_check_object"},{"kind":13,"line":352,"containerName":"_check_object","name":"$object"},{"line":353,"kind":13,"name":"$self","containerName":"_check_object"},{"name":"throw","containerName":"_check_object","kind":12,"line":353},{"line":353,"kind":13,"containerName":"_check_object","name":"$object"},{"containerName":"_check_object","name":"isa","line":353,"kind":12},{"containerName":"_check_object","name":"$interface","kind":13,"line":353}],"line":349,"kind":12},{"kind":12,"children":[{"localvar":"my","containerName":"_get_you_index","name":"$self","definition":"my","line":359,"kind":13},{"name":"$should_be_pos","containerName":"_get_you_index","line":359,"kind":13},{"localvar":"my","containerName":"_get_you_index","definition":"my","name":"$you","line":360,"kind":13},{"name":"$self","containerName":"_get_you_index","kind":13,"line":360},{"name":"$should_be_pos","containerName":"_get_you_index","line":361,"kind":13},{"name":"$self","containerName":"_get_you_index","kind":13,"line":362},{"containerName":"_get_you_index","name":"throw","line":362,"kind":12},{"line":362,"kind":13,"containerName":"_get_you_index","name":"$you"},{"containerName":"_get_you_index","name":"isa","kind":12,"line":362},{"containerName":"_get_you_index","name":"$self","line":365,"kind":13},{"name":"throw","containerName":"_get_you_index","kind":12,"line":365},{"line":365,"kind":13,"containerName":"_get_you_index","name":"$you"},{"name":"isa","containerName":"_get_you_index","line":365,"kind":12},{"kind":13,"line":367,"name":"$self","containerName":"_get_you_index"},{"line":367,"kind":12,"containerName":"_get_you_index","name":"index"}],"line":358,"definition":"sub","containerName":"main::","signature":{"label":"_get_you_index($self,$should_be_pos)","parameters":[{"label":"$self"},{"label":"$should_be_pos"}],"documentation":" get the object we are the handler of, its index, and throw depending on if\n we're a Position"},"detail":"($self,$should_be_pos)","name":"_get_you_index","range":{"end":{"character":9999,"line":368},"start":{"line":358,"character":0}}},{"line":360,"kind":12,"name":"_who"},{"kind":12,"line":371,"children":[{"line":372,"kind":13,"localvar":"my","containerName":"_get_other_index","name":"$self","definition":"my"},{"kind":13,"line":372,"name":"$entity","containerName":"_get_other_index"},{"name":"$self","containerName":"_get_other_index","line":373,"kind":13},{"containerName":"_get_other_index","name":"throw","kind":12,"line":373},{"name":"$entity","containerName":"_get_other_index","kind":13,"line":373},{"containerName":"_get_other_index","definition":"my","name":"$index","localvar":"my","kind":13,"line":374},{"kind":13,"line":374,"containerName":"_get_other_index","name":"$entity"},{"containerName":"_get_other_index","name":"get_position_handler","kind":12,"line":374},{"name":"index","containerName":"_get_other_index","kind":12,"line":374},{"line":375,"kind":13,"containerName":"_get_other_index","name":"$self"},{"containerName":"_get_other_index","name":"throw","kind":12,"line":375},{"kind":13,"line":375,"containerName":"_get_other_index","name":"$index"},{"containerName":"_get_other_index","name":"$self","line":376,"kind":13},{"kind":12,"line":376,"name":"throw","containerName":"_get_other_index"},{"containerName":"_get_other_index","name":"$entity","line":376,"kind":13},{"containerName":"_get_other_index","name":"$self","line":376,"kind":13},{"containerName":"_get_other_index","name":"get_entity","line":376,"kind":12},{"name":"$index","containerName":"_get_other_index","line":376,"kind":13},{"kind":13,"line":377,"name":"$index","containerName":"_get_other_index"}],"containerName":"main::","definition":"sub","detail":"($self,$entity)","signature":{"label":"_get_other_index($self,$entity)","parameters":[{"label":"$self"},{"label":"$entity"}],"documentation":" check an entity is registered and get its index"},"name":"_get_other_index","range":{"end":{"line":378,"character":9999},"start":{"character":0,"line":371}}},{"range":{"end":{"line":385,"character":9999},"start":{"character":0,"line":381}},"containerName":"main::","definition":"sub","name":"_get_kind","line":381,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_get_kind","line":382,"kind":13},{"kind":13,"line":383,"definition":"my","name":"$you","containerName":"_get_kind","localvar":"my"},{"kind":13,"line":383,"containerName":"_get_kind","name":"$self"},{"kind":13,"line":384,"name":"$you","containerName":"_get_kind"},{"name":"isa","containerName":"_get_kind","kind":12,"line":384},{"line":384,"kind":13,"name":"$you","containerName":"_get_kind"},{"name":"isa","containerName":"_get_kind","kind":12,"line":384},{"name":"$self","containerName":"_get_kind","line":384,"kind":13},{"line":384,"kind":12,"name":"throw","containerName":"_get_kind"}],"kind":12},{"kind":12,"line":383,"name":"_who"},{"range":{"start":{"line":388,"character":0},"end":{"line":404,"character":9999}},"name":"_pos_get_set","detail":"($self,$entity,$kind,$interface)","signature":{"label":"_pos_get_set($self,$entity,$kind,$interface)","parameters":[{"label":"$self"},{"label":"$entity"},{"label":"$kind"},{"label":"$interface"}],"documentation":" get/set position entity"},"containerName":"main::","definition":"sub","line":388,"children":[{"kind":13,"line":389,"containerName":"_pos_get_set","definition":"my","name":"$self","localvar":"my"},{"name":"$entity","containerName":"_pos_get_set","kind":13,"line":389},{"line":389,"kind":13,"containerName":"_pos_get_set","name":"$kind"},{"kind":13,"line":389,"name":"$interface","containerName":"_pos_get_set"},{"localvar":"my","containerName":"_pos_get_set","name":"$you_index","definition":"my","line":390,"kind":13},{"line":390,"kind":13,"name":"$self","containerName":"_pos_get_set"},{"kind":12,"line":390,"name":"_get_you_index","containerName":"_pos_get_set"},{"localvar":"my","name":"$entity_index","definition":"my","containerName":"_pos_get_set","line":392,"kind":13},{"line":393,"kind":13,"name":"$entity","containerName":"_pos_get_set"},{"name":"$self","containerName":"_pos_get_set","line":394,"kind":13},{"kind":12,"line":394,"containerName":"_pos_get_set","name":"_check_object"},{"kind":13,"line":394,"containerName":"_pos_get_set","name":"$entity"},{"line":394,"kind":13,"containerName":"_pos_get_set","name":"$interface"},{"localvar":"my","containerName":"_pos_get_set","name":"$new_entity_index","definition":"my","line":395,"kind":13},{"kind":13,"line":395,"name":"$self","containerName":"_pos_get_set"},{"containerName":"_pos_get_set","name":"_get_other_index","kind":12,"line":395},{"kind":13,"line":395,"containerName":"_pos_get_set","name":"$entity"},{"name":"$entity_index","containerName":"_pos_get_set","line":396,"kind":13},{"containerName":"_pos_get_set","name":"$self","kind":13,"line":396},{"containerName":"_pos_get_set","name":"_pos_set","line":396,"kind":12},{"containerName":"_pos_get_set","name":"$you_index","kind":13,"line":396},{"name":"$new_entity_index","containerName":"_pos_get_set","line":396,"kind":13},{"line":396,"kind":13,"name":"$kind","containerName":"_pos_get_set"},{"containerName":"_pos_get_set","name":"$entity_index","line":399,"kind":13},{"containerName":"_pos_get_set","name":"$self","kind":13,"line":399},{"kind":13,"line":399,"containerName":"_pos_get_set","name":"$kind"},{"containerName":"_pos_get_set","name":"$you_index","kind":13,"line":399},{"line":400,"kind":13,"containerName":"_pos_get_set","name":"$entity_index"},{"kind":13,"line":401,"containerName":"_pos_get_set","name":"$self"},{"containerName":"_pos_get_set","name":"get_entity","kind":12,"line":401},{"containerName":"_pos_get_set","name":"$entity_index","line":401,"kind":13}],"kind":12},{"line":399,"kind":12,"name":"_rel"},{"containerName":"main::","definition":"sub","detail":"($self,$pos_index,$new_entity_index,$kind)","signature":{"parameters":[{"label":"$self"},{"label":"$pos_index"},{"label":"$new_entity_index"},{"label":"$kind"}],"documentation":" set position entity","label":"_pos_set($self,$pos_index,$new_entity_index,$kind)"},"kind":12,"line":407,"children":[{"line":408,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_pos_set"},{"kind":13,"line":408,"name":"$pos_index","containerName":"_pos_set"},{"containerName":"_pos_set","name":"$new_entity_index","kind":13,"line":408},{"kind":13,"line":408,"name":"$kind","containerName":"_pos_set"},{"name":"$current_entity_index","definition":"my","containerName":"_pos_set","localvar":"my","kind":13,"line":409},{"name":"$self","containerName":"_pos_set","kind":13,"line":409},{"kind":13,"line":409,"name":"$kind","containerName":"_pos_set"},{"containerName":"_pos_set","name":"$pos_index","kind":13,"line":409},{"line":411,"kind":13,"containerName":"_pos_set","name":"$current_entity_index"},{"line":412,"kind":13,"containerName":"_pos_set","name":"$current_entity_index"},{"line":412,"kind":13,"name":"$new_entity_index","containerName":"_pos_set"},{"kind":13,"line":413,"containerName":"_pos_set","name":"$current_entity_index"},{"kind":13,"line":416,"containerName":"_pos_set","name":"$self"},{"name":"_purge_pos_entity","containerName":"_pos_set","kind":12,"line":416},{"line":416,"kind":13,"name":"$pos_index","containerName":"_pos_set"},{"name":"$current_entity_index","containerName":"_pos_set","kind":13,"line":416},{"line":416,"kind":13,"name":"$kind","containerName":"_pos_set"},{"kind":13,"line":419,"containerName":"_pos_set","name":"$self"},{"line":419,"kind":13,"name":"$new_entity_index","containerName":"_pos_set"},{"name":"$pos_index","containerName":"_pos_set","kind":13,"line":419},{"name":"$self","containerName":"_pos_set","kind":13,"line":420},{"containerName":"_pos_set","name":"$kind","kind":13,"line":420},{"name":"$pos_index","containerName":"_pos_set","line":420,"kind":13},{"kind":13,"line":420,"name":"$new_entity_index","containerName":"_pos_set"},{"line":421,"kind":13,"containerName":"_pos_set","name":"$new_entity_index"}],"name":"_pos_set","range":{"end":{"character":9999,"line":422},"start":{"character":0,"line":407}}},{"line":409,"kind":12,"name":"_rel"},{"name":"_rel","line":419,"kind":12},{"name":"_rel","kind":12,"line":420},{"name":"_purge_pos_entity","range":{"end":{"line":429,"character":9999},"start":{"line":425,"character":0}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$pos_index"},{"label":"$entity_index"},{"label":"$kind"}],"documentation":" disassociate position from one of its current entities","label":"_purge_pos_entity($self,$pos_index,$entity_index,$kind)"},"detail":"($self,$pos_index,$entity_index,$kind)","kind":12,"children":[{"line":426,"kind":13,"localvar":"my","containerName":"_purge_pos_entity","definition":"my","name":"$self"},{"containerName":"_purge_pos_entity","name":"$pos_index","kind":13,"line":426},{"line":426,"kind":13,"name":"$entity_index","containerName":"_purge_pos_entity"},{"line":426,"kind":13,"containerName":"_purge_pos_entity","name":"$kind"},{"name":"$self","containerName":"_purge_pos_entity","line":427,"kind":13},{"kind":13,"line":427,"containerName":"_purge_pos_entity","name":"$entity_index"},{"kind":13,"line":427,"name":"$pos_index","containerName":"_purge_pos_entity"},{"name":"$self","containerName":"_purge_pos_entity","line":428,"kind":13},{"containerName":"_purge_pos_entity","name":"$kind","line":428,"kind":13},{"name":"$pos_index","containerName":"_purge_pos_entity","kind":13,"line":428}],"line":425},{"line":427,"kind":12,"name":"_rel"},{"name":"_rel","line":428,"kind":12}]}