{"vars":[{"containerName":"strict::Scalar","name":"Util","kind":2,"line":101},{"containerName":"","name":"base","kind":2,"line":104},{"range":{"start":{"character":0,"line":129},"end":{"line":171,"character":9999}},"name":"new","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Position.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Position\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Position - A single position of a Marker, or the range over which\n                     that marker lies, in a Map\n\n=head1 SYNOPSIS\n\n    use Bio::Map::Position;\n    my $position = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -value => 100\n\t\t\t\t\t  );\n\n\tmy $position_with_range = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -start => 100,\n\t\t\t\t\t  -length => 10\n\t\t\t\t\t  );\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the PositionI interface that\nhandles the specific values of a position. This allows a map element\n(e.g. Marker) to have multiple positions within a map and still be\ntreated as a single entity.\n\nThis handles the concept of a relative map in which the order of\nelements and the distance between them is known, but does not\ndirectly handle the case when distances are unknown - in that case\narbitrary values must be assigned for position values.\n\nNo units are assumed here - units are handled by context of which Map\na position is placed in or the subclass of this Position.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nChad Matsalla, bioinformatics1@dieselwurks.com\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Position;\nuse strict;\n\nuse Scalar::Util qw(looks_like_number);\nuse Bio::Map::Relative;\n\nuse base qw(Bio::Root::Root Bio::Map::PositionI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::Position->new();\n Function: Builds a new Bio::Map::Position object \n Returns : Bio::Map::Position\n Args    : -map      => Bio::Map::MapI object\n           -element  => Bio::Map::MappableI object\n           -relative => Bio::Map::RelativeI object\n\n           * If this position has no range, or if a single value can describe\n             the range *\n           -value => scalar             : something that describes the single\n                                          point position or range of this\n                                          Position, most likely an int\n\n           * Or if this position has a range, at least two of *\n           -start => int                : value of the start co-ordinate\n           -end => int                  : value of the end co-ordinate\n           -length => int               : length of the range"},"detail":"($class,@args)","definition":"sub","containerName":"main::","children":[{"line":130,"kind":13,"localvar":"my","name":"$class","definition":"my","containerName":"new"},{"line":130,"kind":13,"containerName":"new","name":"@args"},{"line":131,"kind":13,"localvar":"my","containerName":"new","name":"$self","definition":"my"},{"line":131,"kind":13,"name":"$class","containerName":"new"},{"containerName":"new","name":"@args","line":131,"kind":13},{"kind":13,"line":133,"definition":"my","name":"$map","containerName":"new","localvar":"my"},{"line":133,"kind":13,"containerName":"new","name":"$marker"},{"containerName":"new","name":"$element","line":133,"kind":13},{"name":"$value","containerName":"new","kind":13,"line":133},{"name":"$start","containerName":"new","kind":13,"line":133},{"name":"$end","containerName":"new","kind":13,"line":133},{"name":"$length","containerName":"new","line":133,"kind":13},{"name":"$relative","containerName":"new","kind":13,"line":133},{"containerName":"new","name":"$self","kind":13,"line":134},{"line":134,"kind":12,"containerName":"new","name":"_rearrange"},{"line":142,"kind":13,"name":"@args","containerName":"new"},{"kind":13,"line":144,"containerName":"new","name":"$do_range","definition":"my","localvar":"my"},{"line":144,"kind":13,"containerName":"new","name":"$start"},{"name":"$end","containerName":"new","line":144,"kind":13},{"name":"$value","containerName":"new","kind":13,"line":145},{"name":"$do_range","containerName":"new","kind":13,"line":145},{"kind":13,"line":146,"name":"$self","containerName":"new"},{"containerName":"new","name":"warn","kind":12,"line":146},{"containerName":"new","name":"$value","line":147,"kind":13},{"kind":13,"line":150,"containerName":"new","name":"$map"},{"kind":13,"line":150,"containerName":"new","name":"$self"},{"name":"map","containerName":"new","line":150,"kind":12},{"name":"$map","containerName":"new","kind":13,"line":150},{"containerName":"new","name":"$marker","kind":13,"line":151},{"line":151,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":151,"name":"element","containerName":"new"},{"line":151,"kind":13,"containerName":"new","name":"$marker"},{"kind":13,"line":152,"name":"$element","containerName":"new"},{"kind":13,"line":152,"name":"$self","containerName":"new"},{"name":"element","containerName":"new","line":152,"kind":12},{"containerName":"new","name":"$element","line":152,"kind":13},{"line":153,"kind":13,"name":"$relative","containerName":"new"},{"kind":13,"line":153,"name":"$self","containerName":"new"},{"containerName":"new","name":"relative","line":153,"kind":12},{"name":"$relative","containerName":"new","kind":13,"line":153},{"name":"$value","containerName":"new","kind":13,"line":154},{"line":154,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":154,"name":"value","containerName":"new"},{"name":"$value","containerName":"new","kind":13,"line":154},{"kind":13,"line":156,"name":"$do_range","containerName":"new"},{"kind":13,"line":157,"name":"$start","containerName":"new"},{"kind":13,"line":157,"containerName":"new","name":"$self"},{"line":157,"kind":12,"name":"start","containerName":"new"},{"containerName":"new","name":"$start","kind":13,"line":157},{"kind":13,"line":158,"containerName":"new","name":"$end"},{"name":"$self","containerName":"new","line":158,"kind":13},{"kind":12,"line":158,"name":"end","containerName":"new"},{"containerName":"new","name":"$end","line":158,"kind":13},{"line":159,"kind":13,"containerName":"new","name":"$length"},{"line":160,"kind":13,"containerName":"new","name":"$start"},{"line":160,"kind":13,"name":"$end","containerName":"new"},{"kind":13,"line":161,"containerName":"new","name":"$self"},{"line":161,"kind":12,"containerName":"new","name":"end"},{"name":"$start","containerName":"new","kind":13,"line":161},{"name":"$length","containerName":"new","kind":13,"line":161},{"name":"$start","containerName":"new","line":163,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":164},{"name":"start","containerName":"new","kind":12,"line":164},{"line":164,"kind":13,"name":"$end","containerName":"new"},{"kind":13,"line":164,"containerName":"new","name":"$length"},{"line":167,"kind":13,"name":"$self","containerName":"new"},{"line":167,"kind":12,"containerName":"new","name":"end"},{"kind":13,"line":167,"name":"$self","containerName":"new"},{"line":167,"kind":12,"name":"end","containerName":"new"},{"kind":13,"line":167,"name":"$start","containerName":"new"},{"kind":13,"line":170,"containerName":"new","name":"$self"}],"line":129,"kind":12},{"kind":12,"line":131,"name":"SUPER","containerName":"new"},{"kind":12,"children":[{"line":188,"kind":13,"localvar":"my","containerName":"relative","name":"$self","definition":"my"},{"line":188,"kind":13,"name":"$relative","containerName":"relative"},{"containerName":"relative","name":"$relative","kind":13,"line":189},{"containerName":"relative","name":"$self","line":190,"kind":13},{"line":190,"kind":12,"containerName":"relative","name":"throw"},{"name":"$relative","containerName":"relative","line":190,"kind":13},{"kind":13,"line":191,"name":"$self","containerName":"relative"},{"containerName":"relative","name":"throw","kind":12,"line":191},{"line":191,"kind":13,"containerName":"relative","name":"$relative"},{"line":191,"kind":12,"containerName":"relative","name":"isa"},{"containerName":"relative","name":"$self","line":192,"kind":13},{"line":193,"kind":13,"containerName":"relative","name":"$self"},{"line":193,"kind":13,"containerName":"relative","name":"$relative"},{"containerName":"relative","name":"$self","kind":13,"line":195},{"name":"$self","containerName":"relative","kind":13,"line":195},{"name":"absolute_relative","containerName":"relative","kind":12,"line":195}],"line":187,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: Position.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Position\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Position - A single position of a Marker, or the range over which\n                     that marker lies, in a Map\n\n=head1 SYNOPSIS\n\n    use Bio::Map::Position;\n    my $position = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -value => 100\n\t\t\t\t\t  );\n\n\tmy $position_with_range = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -start => 100,\n\t\t\t\t\t  -length => 10\n\t\t\t\t\t  );\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the PositionI interface that\nhandles the specific values of a position. This allows a map element\n(e.g. Marker) to have multiple positions within a map and still be\ntreated as a single entity.\n\nThis handles the concept of a relative map in which the order of\nelements and the distance between them is known, but does not\ndirectly handle the case when distances are unknown - in that case\narbitrary values must be assigned for position values.\n\nNo units are assumed here - units are handled by context of which Map\na position is placed in or the subclass of this Position.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nChad Matsalla, bioinformatics1@dieselwurks.com\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Position;\nuse strict;\n\nuse Scalar::Util qw(looks_like_number);\nuse Bio::Map::Relative;\n\nuse base qw(Bio::Root::Root Bio::Map::PositionI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::Position->new();\n Function: Builds a new Bio::Map::Position object \n Returns : Bio::Map::Position\n Args    : -map      => Bio::Map::MapI object\n           -element  => Bio::Map::MappableI object\n           -relative => Bio::Map::RelativeI object\n\n           * If this position has no range, or if a single value can describe\n             the range *\n           -value => scalar             : something that describes the single\n                                          point position or range of this\n                                          Position, most likely an int\n\n           * Or if this position has a range, at least two of *\n           -start => int                : value of the start co-ordinate\n           -end => int                  : value of the end co-ordinate\n           -length => int               : length of the range\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\t\n    my ($map, $marker, $element, $value, $start, $end, $length, $relative) = \n\t$self->_rearrange([qw( MAP\n\t\t\t       MARKER\n                   ELEMENT\n\t\t\t       VALUE\n\t\t\t\t   START\n\t\t\t\t   END\n\t\t\t\t   LENGTH\n                   RELATIVE\n\t\t\t       )], @args);\n\t\n    my $do_range = defined($start) || defined($end);\n    if ($value && $do_range) {\n        $self->warn(\"-value and (-start|-end|-length) are mutually exclusive, ignoring value\");\n\t\t$value = undef;\n    }\n\t\n    $map            && $self->map($map);\n    $marker         && $self->element($marker); # backwards compatibility\n    $element        && $self->element($element);\n    $relative       && $self->relative($relative);\n    defined($value) && $self->value($value);\n\t\n    if ($do_range) {\n\t\tdefined($start) && $self->start($start);\n\t\tdefined($end)   && $self->end($end);\n\t\tif ($length) {\n\t\t\tif (defined($start) && ! defined($end)) {\n\t\t\t\t$self->end($start + $length - 1);\n\t\t\t}\n\t\t\telsif (! defined($start)) {\n\t\t\t\t$self->start($end - $length + 1);\n\t\t\t}\n\t\t}\n\t\tdefined($self->end) || $self->end($start);\n    }\n\t\n    return $self;\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set","parameters":[{"label":"$self"},{"label":"$relative"}],"label":"relative($self,$relative)"},"detail":"($self,$relative)","name":"relative","range":{"start":{"character":0,"line":187},"end":{"character":9999,"line":196}}},{"line":192,"kind":12,"name":"_relative_not_implicit"},{"line":193,"kind":12,"name":"_relative"},{"line":195,"kind":12,"name":"_relative"},{"definition":"sub","name":"absolute","containerName":"main::","range":{"start":{"line":222,"character":0},"end":{"line":226,"character":9999}},"kind":12,"children":[{"line":223,"kind":13,"localvar":"my","containerName":"absolute","name":"$self","definition":"my"},{"kind":13,"line":224,"containerName":"absolute","name":"$self"},{"line":225,"kind":13,"name":"$self","containerName":"absolute"}],"line":222},{"name":"_absolute","line":224,"kind":12},{"line":225,"kind":12,"name":"_absolute"},{"name":"value","range":{"end":{"character":9999,"line":246},"start":{"character":0,"line":238}},"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"value($self,$value)","documentation":"1;\n# $Id: Position.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Position\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Position - A single position of a Marker, or the range over which\n                     that marker lies, in a Map\n\n=head1 SYNOPSIS\n\n    use Bio::Map::Position;\n    my $position = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -value => 100\n\t\t\t\t\t  );\n\n\tmy $position_with_range = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -start => 100,\n\t\t\t\t\t  -length => 10\n\t\t\t\t\t  );\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the PositionI interface that\nhandles the specific values of a position. This allows a map element\n(e.g. Marker) to have multiple positions within a map and still be\ntreated as a single entity.\n\nThis handles the concept of a relative map in which the order of\nelements and the distance between them is known, but does not\ndirectly handle the case when distances are unknown - in that case\narbitrary values must be assigned for position values.\n\nNo units are assumed here - units are handled by context of which Map\na position is placed in or the subclass of this Position.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nChad Matsalla, bioinformatics1@dieselwurks.com\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Position;\nuse strict;\n\nuse Scalar::Util qw(looks_like_number);\nuse Bio::Map::Relative;\n\nuse base qw(Bio::Root::Root Bio::Map::PositionI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::Position->new();\n Function: Builds a new Bio::Map::Position object \n Returns : Bio::Map::Position\n Args    : -map      => Bio::Map::MapI object\n           -element  => Bio::Map::MappableI object\n           -relative => Bio::Map::RelativeI object\n\n           * If this position has no range, or if a single value can describe\n             the range *\n           -value => scalar             : something that describes the single\n                                          point position or range of this\n                                          Position, most likely an int\n\n           * Or if this position has a range, at least two of *\n           -start => int                : value of the start co-ordinate\n           -end => int                  : value of the end co-ordinate\n           -length => int               : length of the range\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\t\n    my ($map, $marker, $element, $value, $start, $end, $length, $relative) = \n\t$self->_rearrange([qw( MAP\n\t\t\t       MARKER\n                   ELEMENT\n\t\t\t       VALUE\n\t\t\t\t   START\n\t\t\t\t   END\n\t\t\t\t   LENGTH\n                   RELATIVE\n\t\t\t       )], @args);\n\t\n    my $do_range = defined($start) || defined($end);\n    if ($value && $do_range) {\n        $self->warn(\"-value and (-start|-end|-length) are mutually exclusive, ignoring value\");\n\t\t$value = undef;\n    }\n\t\n    $map            && $self->map($map);\n    $marker         && $self->element($marker); # backwards compatibility\n    $element        && $self->element($element);\n    $relative       && $self->relative($relative);\n    defined($value) && $self->value($value);\n\t\n    if ($do_range) {\n\t\tdefined($start) && $self->start($start);\n\t\tdefined($end)   && $self->end($end);\n\t\tif ($length) {\n\t\t\tif (defined($start) && ! defined($end)) {\n\t\t\t\t$self->end($start + $length - 1);\n\t\t\t}\n\t\t\telsif (! defined($start)) {\n\t\t\t\t$self->start($end - $length + 1);\n\t\t\t}\n\t\t}\n\t\tdefined($self->end) || $self->end($start);\n    }\n\t\n    return $self;\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set\n\n\nsub relative {\n    my ($self, $relative) = @_;\n    if ($relative) {\n        $self->throw(\"Must supply an object\") unless ref($relative);\n        $self->throw(\"This is [$relative], not a Bio::Map::RelativeI\") unless $relative->isa('Bio::Map::RelativeI');\n        $self->{_relative_not_implicit} = 1;\n        $self->{_relative} = $relative;\n    }\n    return $self->{_relative} || $self->absolute_relative;\n}\n\n=head2 absolute\n\n  Title   : absolute\n  Usage   : my $absolute = $position->absolute();\n            $position->absolute($absolute);\n  Function: Get/set how this Position's co-ordinates (numerical(), start(),\n            end()) are reported. When absolute is off, co-ordinates are\n            relative to the thing described by relative(). Ie. the value\n            returned by start() will be the same as the value you set start()\n            to. When absolute is on, co-ordinates are converted to be relative\n            to the start of the map.\n\n            So if relative() currently points to a Relative object describing\n            \"relative to another position which is 100 bp from the start of\n            the map\", this Position's start() had been set to 50 and absolute()\n            returns 1, $position->start() will return 150. If absolute() returns\n            0 in the same situation, $position->start() would return 50.\n\n  Returns : boolean (default 0)\n  Args    : none to get, OR\n            boolean to set\n\n\nsub absolute {\n    my $self = shift;\n    if (@_) { $self->{_absolute} = shift }\n    return $self->{_absolute} || 0;\n}\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value;\n Function: Get/Set the value for this postion\n Returns : scalar, value\n Args    : [optional] new value to set","parameters":[{"label":"$self"},{"label":"$value"}]},"kind":12,"line":238,"children":[{"kind":13,"line":239,"containerName":"value","name":"$self","definition":"my","localvar":"my"},{"line":239,"kind":13,"name":"$value","containerName":"value"},{"containerName":"value","name":"$value","line":240,"kind":13},{"name":"$self","containerName":"value","line":241,"kind":13},{"name":"$value","containerName":"value","kind":13,"line":241},{"name":"$self","containerName":"value","line":242,"kind":13},{"containerName":"value","name":"start","line":242,"kind":12},{"line":242,"kind":13,"containerName":"value","name":"$self"},{"name":"numeric","containerName":"value","kind":12,"line":242},{"containerName":"value","name":"$self","kind":13,"line":242},{"line":242,"kind":12,"containerName":"value","name":"start"},{"name":"$self","containerName":"value","line":243,"kind":13},{"containerName":"value","name":"end","line":243,"kind":12},{"kind":13,"line":243,"containerName":"value","name":"$self"},{"containerName":"value","name":"numeric","line":243,"kind":12},{"kind":13,"line":243,"containerName":"value","name":"$self"},{"kind":12,"line":243,"name":"end","containerName":"value"},{"containerName":"value","name":"$self","line":245,"kind":13}]},{"range":{"end":{"character":9999,"line":281},"start":{"character":0,"line":261}},"name":"numeric","detail":"($self,$value)","signature":{"label":"numeric($self,$value)","documentation":"1;\n# $Id: Position.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Position\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Position - A single position of a Marker, or the range over which\n                     that marker lies, in a Map\n\n=head1 SYNOPSIS\n\n    use Bio::Map::Position;\n    my $position = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -value => 100\n\t\t\t\t\t  );\n\n\tmy $position_with_range = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -start => 100,\n\t\t\t\t\t  -length => 10\n\t\t\t\t\t  );\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the PositionI interface that\nhandles the specific values of a position. This allows a map element\n(e.g. Marker) to have multiple positions within a map and still be\ntreated as a single entity.\n\nThis handles the concept of a relative map in which the order of\nelements and the distance between them is known, but does not\ndirectly handle the case when distances are unknown - in that case\narbitrary values must be assigned for position values.\n\nNo units are assumed here - units are handled by context of which Map\na position is placed in or the subclass of this Position.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nChad Matsalla, bioinformatics1@dieselwurks.com\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Position;\nuse strict;\n\nuse Scalar::Util qw(looks_like_number);\nuse Bio::Map::Relative;\n\nuse base qw(Bio::Root::Root Bio::Map::PositionI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::Position->new();\n Function: Builds a new Bio::Map::Position object \n Returns : Bio::Map::Position\n Args    : -map      => Bio::Map::MapI object\n           -element  => Bio::Map::MappableI object\n           -relative => Bio::Map::RelativeI object\n\n           * If this position has no range, or if a single value can describe\n             the range *\n           -value => scalar             : something that describes the single\n                                          point position or range of this\n                                          Position, most likely an int\n\n           * Or if this position has a range, at least two of *\n           -start => int                : value of the start co-ordinate\n           -end => int                  : value of the end co-ordinate\n           -length => int               : length of the range\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\t\n    my ($map, $marker, $element, $value, $start, $end, $length, $relative) = \n\t$self->_rearrange([qw( MAP\n\t\t\t       MARKER\n                   ELEMENT\n\t\t\t       VALUE\n\t\t\t\t   START\n\t\t\t\t   END\n\t\t\t\t   LENGTH\n                   RELATIVE\n\t\t\t       )], @args);\n\t\n    my $do_range = defined($start) || defined($end);\n    if ($value && $do_range) {\n        $self->warn(\"-value and (-start|-end|-length) are mutually exclusive, ignoring value\");\n\t\t$value = undef;\n    }\n\t\n    $map            && $self->map($map);\n    $marker         && $self->element($marker); # backwards compatibility\n    $element        && $self->element($element);\n    $relative       && $self->relative($relative);\n    defined($value) && $self->value($value);\n\t\n    if ($do_range) {\n\t\tdefined($start) && $self->start($start);\n\t\tdefined($end)   && $self->end($end);\n\t\tif ($length) {\n\t\t\tif (defined($start) && ! defined($end)) {\n\t\t\t\t$self->end($start + $length - 1);\n\t\t\t}\n\t\t\telsif (! defined($start)) {\n\t\t\t\t$self->start($end - $length + 1);\n\t\t\t}\n\t\t}\n\t\tdefined($self->end) || $self->end($start);\n    }\n\t\n    return $self;\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set\n\n\nsub relative {\n    my ($self, $relative) = @_;\n    if ($relative) {\n        $self->throw(\"Must supply an object\") unless ref($relative);\n        $self->throw(\"This is [$relative], not a Bio::Map::RelativeI\") unless $relative->isa('Bio::Map::RelativeI');\n        $self->{_relative_not_implicit} = 1;\n        $self->{_relative} = $relative;\n    }\n    return $self->{_relative} || $self->absolute_relative;\n}\n\n=head2 absolute\n\n  Title   : absolute\n  Usage   : my $absolute = $position->absolute();\n            $position->absolute($absolute);\n  Function: Get/set how this Position's co-ordinates (numerical(), start(),\n            end()) are reported. When absolute is off, co-ordinates are\n            relative to the thing described by relative(). Ie. the value\n            returned by start() will be the same as the value you set start()\n            to. When absolute is on, co-ordinates are converted to be relative\n            to the start of the map.\n\n            So if relative() currently points to a Relative object describing\n            \"relative to another position which is 100 bp from the start of\n            the map\", this Position's start() had been set to 50 and absolute()\n            returns 1, $position->start() will return 150. If absolute() returns\n            0 in the same situation, $position->start() would return 50.\n\n  Returns : boolean (default 0)\n  Args    : none to get, OR\n            boolean to set\n\n\nsub absolute {\n    my $self = shift;\n    if (@_) { $self->{_absolute} = shift }\n    return $self->{_absolute} || 0;\n}\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value;\n Function: Get/Set the value for this postion\n Returns : scalar, value\n Args    : [optional] new value to set\n\n\nsub value {\n\tmy ($self, $value) = @_;\n\tif (defined $value) {\n\t\t$self->{'_value'} = $value;\n\t\t$self->start($self->numeric) unless defined($self->start);\n\t\t$self->end($self->numeric) unless defined($self->end);\n\t}\n\treturn $self->{'_value'};\n}\n\n=head2 numeric\n\n Title   : numeric\n Usage   : my $num = $position->numeric;\n Function: Read-only method that is guaranteed to return a numeric \n           representation of the start of this position. \n Returns : scalar numeric\n Args    : none to get the co-ordinate normally (see absolute() method), OR\n           Bio::Map::RelativeI to get the co-ordinate converted to be\n           relative to what this Relative describes.","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub","line":261,"children":[{"kind":13,"line":262,"containerName":"numeric","name":"$self","definition":"my","localvar":"my"},{"containerName":"numeric","name":"$value","kind":13,"line":262},{"containerName":"numeric","name":"$num","definition":"my","localvar":"my","kind":13,"line":263},{"line":263,"kind":13,"name":"$self","containerName":"numeric"},{"line":264,"kind":13,"containerName":"numeric","name":"$self"},{"line":264,"kind":12,"containerName":"numeric","name":"throw"},{"kind":13,"line":264,"containerName":"numeric","name":"$num"},{"kind":13,"line":265,"containerName":"numeric","name":"$self"},{"line":265,"kind":12,"containerName":"numeric","name":"throw"},{"containerName":"numeric","name":"$num","line":265,"kind":13},{"line":267,"kind":13,"name":"$value","containerName":"numeric"},{"name":"$value","containerName":"numeric","line":267,"kind":13},{"kind":12,"line":267,"name":"isa","containerName":"numeric"},{"line":269,"kind":13,"localvar":"my","name":"$raw","definition":"my","containerName":"numeric"},{"line":269,"kind":13,"containerName":"numeric","name":"$num"},{"kind":13,"line":270,"definition":"my","name":"$abs_start","containerName":"numeric","localvar":"my"},{"containerName":"numeric","name":"$rel_start","kind":13,"line":270},{"containerName":"numeric","name":"$self","line":270,"kind":13},{"containerName":"numeric","name":"_relative_handler","line":270,"kind":12},{"name":"$value","containerName":"numeric","kind":13,"line":270},{"containerName":"numeric","name":"$abs_start","kind":13,"line":271},{"kind":13,"line":271,"name":"$raw","containerName":"numeric"},{"containerName":"numeric","name":"$rel_start","line":271,"kind":13},{"kind":13,"line":275,"containerName":"numeric","name":"$self"},{"line":275,"kind":13,"containerName":"numeric","name":"$self"},{"kind":12,"line":275,"containerName":"numeric","name":"absolute"},{"kind":13,"line":277,"name":"$self","containerName":"numeric"},{"line":277,"kind":12,"containerName":"numeric","name":"relative"},{"containerName":"numeric","name":"absolute_conversion","line":277,"kind":12},{"containerName":"numeric","name":"$self","kind":13,"line":277},{"line":280,"kind":13,"name":"$num","containerName":"numeric"}],"kind":12},{"kind":12,"line":265,"name":"looks_like_number"},{"kind":12,"line":275,"name":"_relative_not_implicit"},{"range":{"start":{"character":0,"line":297},"end":{"line":321,"character":9999}},"name":"start","signature":{"label":"start($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Position.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Position\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Position - A single position of a Marker, or the range over which\n                     that marker lies, in a Map\n\n=head1 SYNOPSIS\n\n    use Bio::Map::Position;\n    my $position = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -value => 100\n\t\t\t\t\t  );\n\n\tmy $position_with_range = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -start => 100,\n\t\t\t\t\t  -length => 10\n\t\t\t\t\t  );\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the PositionI interface that\nhandles the specific values of a position. This allows a map element\n(e.g. Marker) to have multiple positions within a map and still be\ntreated as a single entity.\n\nThis handles the concept of a relative map in which the order of\nelements and the distance between them is known, but does not\ndirectly handle the case when distances are unknown - in that case\narbitrary values must be assigned for position values.\n\nNo units are assumed here - units are handled by context of which Map\na position is placed in or the subclass of this Position.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nChad Matsalla, bioinformatics1@dieselwurks.com\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Position;\nuse strict;\n\nuse Scalar::Util qw(looks_like_number);\nuse Bio::Map::Relative;\n\nuse base qw(Bio::Root::Root Bio::Map::PositionI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::Position->new();\n Function: Builds a new Bio::Map::Position object \n Returns : Bio::Map::Position\n Args    : -map      => Bio::Map::MapI object\n           -element  => Bio::Map::MappableI object\n           -relative => Bio::Map::RelativeI object\n\n           * If this position has no range, or if a single value can describe\n             the range *\n           -value => scalar             : something that describes the single\n                                          point position or range of this\n                                          Position, most likely an int\n\n           * Or if this position has a range, at least two of *\n           -start => int                : value of the start co-ordinate\n           -end => int                  : value of the end co-ordinate\n           -length => int               : length of the range\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\t\n    my ($map, $marker, $element, $value, $start, $end, $length, $relative) = \n\t$self->_rearrange([qw( MAP\n\t\t\t       MARKER\n                   ELEMENT\n\t\t\t       VALUE\n\t\t\t\t   START\n\t\t\t\t   END\n\t\t\t\t   LENGTH\n                   RELATIVE\n\t\t\t       )], @args);\n\t\n    my $do_range = defined($start) || defined($end);\n    if ($value && $do_range) {\n        $self->warn(\"-value and (-start|-end|-length) are mutually exclusive, ignoring value\");\n\t\t$value = undef;\n    }\n\t\n    $map            && $self->map($map);\n    $marker         && $self->element($marker); # backwards compatibility\n    $element        && $self->element($element);\n    $relative       && $self->relative($relative);\n    defined($value) && $self->value($value);\n\t\n    if ($do_range) {\n\t\tdefined($start) && $self->start($start);\n\t\tdefined($end)   && $self->end($end);\n\t\tif ($length) {\n\t\t\tif (defined($start) && ! defined($end)) {\n\t\t\t\t$self->end($start + $length - 1);\n\t\t\t}\n\t\t\telsif (! defined($start)) {\n\t\t\t\t$self->start($end - $length + 1);\n\t\t\t}\n\t\t}\n\t\tdefined($self->end) || $self->end($start);\n    }\n\t\n    return $self;\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set\n\n\nsub relative {\n    my ($self, $relative) = @_;\n    if ($relative) {\n        $self->throw(\"Must supply an object\") unless ref($relative);\n        $self->throw(\"This is [$relative], not a Bio::Map::RelativeI\") unless $relative->isa('Bio::Map::RelativeI');\n        $self->{_relative_not_implicit} = 1;\n        $self->{_relative} = $relative;\n    }\n    return $self->{_relative} || $self->absolute_relative;\n}\n\n=head2 absolute\n\n  Title   : absolute\n  Usage   : my $absolute = $position->absolute();\n            $position->absolute($absolute);\n  Function: Get/set how this Position's co-ordinates (numerical(), start(),\n            end()) are reported. When absolute is off, co-ordinates are\n            relative to the thing described by relative(). Ie. the value\n            returned by start() will be the same as the value you set start()\n            to. When absolute is on, co-ordinates are converted to be relative\n            to the start of the map.\n\n            So if relative() currently points to a Relative object describing\n            \"relative to another position which is 100 bp from the start of\n            the map\", this Position's start() had been set to 50 and absolute()\n            returns 1, $position->start() will return 150. If absolute() returns\n            0 in the same situation, $position->start() would return 50.\n\n  Returns : boolean (default 0)\n  Args    : none to get, OR\n            boolean to set\n\n\nsub absolute {\n    my $self = shift;\n    if (@_) { $self->{_absolute} = shift }\n    return $self->{_absolute} || 0;\n}\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value;\n Function: Get/Set the value for this postion\n Returns : scalar, value\n Args    : [optional] new value to set\n\n\nsub value {\n\tmy ($self, $value) = @_;\n\tif (defined $value) {\n\t\t$self->{'_value'} = $value;\n\t\t$self->start($self->numeric) unless defined($self->start);\n\t\t$self->end($self->numeric) unless defined($self->end);\n\t}\n\treturn $self->{'_value'};\n}\n\n=head2 numeric\n\n Title   : numeric\n Usage   : my $num = $position->numeric;\n Function: Read-only method that is guaranteed to return a numeric \n           representation of the start of this position. \n Returns : scalar numeric\n Args    : none to get the co-ordinate normally (see absolute() method), OR\n           Bio::Map::RelativeI to get the co-ordinate converted to be\n           relative to what this Relative describes.\n\n\nsub numeric {\n    my ($self, $value) = @_;\n    my $num = $self->{'_value'};\n    $self->throw(\"The value has not been set, can't convert to numeric\") unless defined($num);\n    $self->throw(\"This value [$num] is not numeric\") unless looks_like_number($num);\n    \n    if (ref($value) && $value->isa('Bio::Map::RelativeI')) {\n        # get the value after co-ordinate conversion\n        my $raw = $num;\n        my ($abs_start, $rel_start) = $self->_relative_handler($value);\n        return $abs_start + $raw - $rel_start;\n    }\n    \n    # get the value as per absolute\n    if ($self->{_relative_not_implicit} && $self->absolute) {\n        # this actually returns the start, but should be the same thing...\n        return $self->relative->absolute_conversion($self);\n    }\n    \n    return $num;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : my $start = $position->start();\n            $position->start($start);\n  Function: Get/set the start co-ordinate of this position.\n  Returns : the start of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes."},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"start","name":"$self","definition":"my","line":298,"kind":13},{"containerName":"start","name":"$value","kind":13,"line":298},{"kind":13,"line":299,"containerName":"start","name":"$value"},{"line":300,"kind":13,"containerName":"start","name":"$value"},{"name":"$value","containerName":"start","line":300,"kind":13},{"containerName":"start","name":"isa","line":300,"kind":12},{"kind":13,"line":302,"name":"$raw","definition":"my","containerName":"start","localvar":"my"},{"line":302,"kind":13,"name":"$self","containerName":"start"},{"line":303,"kind":13,"name":"$raw","containerName":"start"},{"localvar":"my","definition":"my","name":"$abs_start","containerName":"start","line":304,"kind":13},{"line":304,"kind":13,"name":"$rel_start","containerName":"start"},{"line":304,"kind":13,"name":"$self","containerName":"start"},{"name":"_relative_handler","containerName":"start","kind":12,"line":304},{"kind":13,"line":304,"name":"$value","containerName":"start"},{"containerName":"start","name":"$abs_start","kind":13,"line":305},{"kind":13,"line":305,"name":"$raw","containerName":"start"},{"containerName":"start","name":"$rel_start","kind":13,"line":305},{"name":"$self","containerName":"start","line":309,"kind":13},{"kind":12,"line":309,"name":"throw","containerName":"start"},{"kind":13,"line":309,"containerName":"start","name":"$value"},{"line":310,"kind":13,"name":"$self","containerName":"start"},{"containerName":"start","name":"$value","kind":13,"line":310},{"name":"$self","containerName":"start","kind":13,"line":311},{"line":311,"kind":12,"name":"value","containerName":"start"},{"line":311,"kind":13,"containerName":"start","name":"$value"},{"kind":13,"line":311,"name":"$self","containerName":"start"},{"name":"value","containerName":"start","kind":12,"line":311},{"kind":13,"line":316,"name":"$self","containerName":"start"},{"containerName":"start","name":"$self","line":316,"kind":13},{"kind":12,"line":316,"containerName":"start","name":"absolute"},{"kind":13,"line":317,"name":"$self","containerName":"start"},{"containerName":"start","name":"relative","line":317,"kind":12},{"kind":12,"line":317,"name":"absolute_conversion","containerName":"start"},{"containerName":"start","name":"$self","kind":13,"line":317},{"kind":13,"line":320,"containerName":"start","name":"$self"},{"line":320,"kind":13,"containerName":"start","name":"$self"}],"line":297,"kind":12},{"line":302,"kind":12,"name":"start"},{"name":"looks_like_number","line":309,"kind":12},{"name":"start","kind":12,"line":310},{"line":316,"kind":12,"name":"_relative_not_implicit"},{"name":"start","kind":12,"line":320},{"name":"start","line":320,"kind":12},{"range":{"start":{"line":337,"character":0},"end":{"character":9999,"line":362}},"name":"end","children":[{"line":338,"kind":13,"localvar":"my","containerName":"end","name":"$self","definition":"my"},{"containerName":"end","name":"$value","line":338,"kind":13},{"line":339,"kind":13,"name":"$value","containerName":"end"},{"kind":13,"line":340,"name":"$value","containerName":"end"},{"line":340,"kind":13,"name":"$value","containerName":"end"},{"kind":12,"line":340,"name":"isa","containerName":"end"},{"localvar":"my","definition":"my","name":"$raw","containerName":"end","line":342,"kind":13},{"containerName":"end","name":"$self","kind":13,"line":342},{"kind":13,"line":343,"containerName":"end","name":"$raw"},{"kind":13,"line":344,"definition":"my","name":"$abs_start","containerName":"end","localvar":"my"},{"line":344,"kind":13,"name":"$rel_start","containerName":"end"},{"kind":13,"line":344,"name":"$self","containerName":"end"},{"containerName":"end","name":"_relative_handler","line":344,"kind":12},{"name":"$value","containerName":"end","kind":13,"line":344},{"kind":13,"line":345,"name":"$abs_start","containerName":"end"},{"line":345,"kind":13,"name":"$raw","containerName":"end"},{"name":"$rel_start","containerName":"end","kind":13,"line":345},{"name":"$self","containerName":"end","kind":13,"line":349},{"kind":12,"line":349,"containerName":"end","name":"throw"},{"line":349,"kind":13,"name":"$value","containerName":"end"},{"containerName":"end","name":"$self","line":350,"kind":13},{"containerName":"end","name":"$value","line":350,"kind":13},{"name":"$self","containerName":"end","kind":13,"line":355},{"name":"$self","containerName":"end","kind":13,"line":355},{"line":355,"kind":12,"containerName":"end","name":"absolute"},{"kind":13,"line":356,"containerName":"end","definition":"my","name":"$raw","localvar":"my"},{"kind":13,"line":356,"containerName":"end","name":"$self"},{"containerName":"end","definition":"my","name":"$abs_start","localvar":"my","kind":13,"line":357},{"containerName":"end","name":"$self","line":357,"kind":13},{"name":"relative","containerName":"end","line":357,"kind":12},{"containerName":"end","name":"absolute_conversion","line":357,"kind":12},{"kind":13,"line":357,"containerName":"end","name":"$self"},{"kind":13,"line":358,"containerName":"end","name":"$abs_start"},{"line":358,"kind":13,"name":"$raw","containerName":"end"},{"name":"$self","containerName":"end","line":358,"kind":13},{"kind":13,"line":361,"name":"$self","containerName":"end"},{"kind":13,"line":361,"containerName":"end","name":"$self"}],"line":337,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Position.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Position\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Position - A single position of a Marker, or the range over which\n                     that marker lies, in a Map\n\n=head1 SYNOPSIS\n\n    use Bio::Map::Position;\n    my $position = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -value => 100\n\t\t\t\t\t  );\n\n\tmy $position_with_range = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -start => 100,\n\t\t\t\t\t  -length => 10\n\t\t\t\t\t  );\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the PositionI interface that\nhandles the specific values of a position. This allows a map element\n(e.g. Marker) to have multiple positions within a map and still be\ntreated as a single entity.\n\nThis handles the concept of a relative map in which the order of\nelements and the distance between them is known, but does not\ndirectly handle the case when distances are unknown - in that case\narbitrary values must be assigned for position values.\n\nNo units are assumed here - units are handled by context of which Map\na position is placed in or the subclass of this Position.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nChad Matsalla, bioinformatics1@dieselwurks.com\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Position;\nuse strict;\n\nuse Scalar::Util qw(looks_like_number);\nuse Bio::Map::Relative;\n\nuse base qw(Bio::Root::Root Bio::Map::PositionI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::Position->new();\n Function: Builds a new Bio::Map::Position object \n Returns : Bio::Map::Position\n Args    : -map      => Bio::Map::MapI object\n           -element  => Bio::Map::MappableI object\n           -relative => Bio::Map::RelativeI object\n\n           * If this position has no range, or if a single value can describe\n             the range *\n           -value => scalar             : something that describes the single\n                                          point position or range of this\n                                          Position, most likely an int\n\n           * Or if this position has a range, at least two of *\n           -start => int                : value of the start co-ordinate\n           -end => int                  : value of the end co-ordinate\n           -length => int               : length of the range\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\t\n    my ($map, $marker, $element, $value, $start, $end, $length, $relative) = \n\t$self->_rearrange([qw( MAP\n\t\t\t       MARKER\n                   ELEMENT\n\t\t\t       VALUE\n\t\t\t\t   START\n\t\t\t\t   END\n\t\t\t\t   LENGTH\n                   RELATIVE\n\t\t\t       )], @args);\n\t\n    my $do_range = defined($start) || defined($end);\n    if ($value && $do_range) {\n        $self->warn(\"-value and (-start|-end|-length) are mutually exclusive, ignoring value\");\n\t\t$value = undef;\n    }\n\t\n    $map            && $self->map($map);\n    $marker         && $self->element($marker); # backwards compatibility\n    $element        && $self->element($element);\n    $relative       && $self->relative($relative);\n    defined($value) && $self->value($value);\n\t\n    if ($do_range) {\n\t\tdefined($start) && $self->start($start);\n\t\tdefined($end)   && $self->end($end);\n\t\tif ($length) {\n\t\t\tif (defined($start) && ! defined($end)) {\n\t\t\t\t$self->end($start + $length - 1);\n\t\t\t}\n\t\t\telsif (! defined($start)) {\n\t\t\t\t$self->start($end - $length + 1);\n\t\t\t}\n\t\t}\n\t\tdefined($self->end) || $self->end($start);\n    }\n\t\n    return $self;\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set\n\n\nsub relative {\n    my ($self, $relative) = @_;\n    if ($relative) {\n        $self->throw(\"Must supply an object\") unless ref($relative);\n        $self->throw(\"This is [$relative], not a Bio::Map::RelativeI\") unless $relative->isa('Bio::Map::RelativeI');\n        $self->{_relative_not_implicit} = 1;\n        $self->{_relative} = $relative;\n    }\n    return $self->{_relative} || $self->absolute_relative;\n}\n\n=head2 absolute\n\n  Title   : absolute\n  Usage   : my $absolute = $position->absolute();\n            $position->absolute($absolute);\n  Function: Get/set how this Position's co-ordinates (numerical(), start(),\n            end()) are reported. When absolute is off, co-ordinates are\n            relative to the thing described by relative(). Ie. the value\n            returned by start() will be the same as the value you set start()\n            to. When absolute is on, co-ordinates are converted to be relative\n            to the start of the map.\n\n            So if relative() currently points to a Relative object describing\n            \"relative to another position which is 100 bp from the start of\n            the map\", this Position's start() had been set to 50 and absolute()\n            returns 1, $position->start() will return 150. If absolute() returns\n            0 in the same situation, $position->start() would return 50.\n\n  Returns : boolean (default 0)\n  Args    : none to get, OR\n            boolean to set\n\n\nsub absolute {\n    my $self = shift;\n    if (@_) { $self->{_absolute} = shift }\n    return $self->{_absolute} || 0;\n}\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value;\n Function: Get/Set the value for this postion\n Returns : scalar, value\n Args    : [optional] new value to set\n\n\nsub value {\n\tmy ($self, $value) = @_;\n\tif (defined $value) {\n\t\t$self->{'_value'} = $value;\n\t\t$self->start($self->numeric) unless defined($self->start);\n\t\t$self->end($self->numeric) unless defined($self->end);\n\t}\n\treturn $self->{'_value'};\n}\n\n=head2 numeric\n\n Title   : numeric\n Usage   : my $num = $position->numeric;\n Function: Read-only method that is guaranteed to return a numeric \n           representation of the start of this position. \n Returns : scalar numeric\n Args    : none to get the co-ordinate normally (see absolute() method), OR\n           Bio::Map::RelativeI to get the co-ordinate converted to be\n           relative to what this Relative describes.\n\n\nsub numeric {\n    my ($self, $value) = @_;\n    my $num = $self->{'_value'};\n    $self->throw(\"The value has not been set, can't convert to numeric\") unless defined($num);\n    $self->throw(\"This value [$num] is not numeric\") unless looks_like_number($num);\n    \n    if (ref($value) && $value->isa('Bio::Map::RelativeI')) {\n        # get the value after co-ordinate conversion\n        my $raw = $num;\n        my ($abs_start, $rel_start) = $self->_relative_handler($value);\n        return $abs_start + $raw - $rel_start;\n    }\n    \n    # get the value as per absolute\n    if ($self->{_relative_not_implicit} && $self->absolute) {\n        # this actually returns the start, but should be the same thing...\n        return $self->relative->absolute_conversion($self);\n    }\n    \n    return $num;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : my $start = $position->start();\n            $position->start($start);\n  Function: Get/set the start co-ordinate of this position.\n  Returns : the start of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\nsub start {\n\tmy ($self, $value) = @_;\n    if (defined $value) {\n        if (ref($value) && $value->isa('Bio::Map::RelativeI')) {\n            # get the value after co-ordinate conversion\n            my $raw = $self->{start};\n            defined $raw || return;\n            my ($abs_start, $rel_start) = $self->_relative_handler($value);\n            return $abs_start + $raw - $rel_start;\n        }\n        else {\n            # set the value\n            $self->throw(\"This is [$value], not a number\") unless looks_like_number($value);\n            $self->{start} = $value;\n            $self->value($value) unless defined($self->value);\n        }\n    }\n    \n    # get the value as per absolute\n    if ($self->{_relative_not_implicit} && $self->absolute) {\n        return $self->relative->absolute_conversion($self);\n    }\n    \n    return defined($self->{start}) ? $self->{start} : return;\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : my $end = $position->end();\n            $position->end($end);\n  Function: Get/set the end co-ordinate of this position.\n  Returns : the end of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.","label":"end($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"name":"end","kind":12,"line":342},{"kind":12,"line":349,"name":"looks_like_number"},{"name":"end","kind":12,"line":350},{"kind":12,"line":355,"name":"_relative_not_implicit"},{"name":"end","kind":12,"line":356},{"name":"start","line":358,"kind":12},{"line":361,"kind":12,"name":"end"},{"line":361,"kind":12,"name":"end"},{"range":{"start":{"line":376,"character":0},"end":{"line":389,"character":9999}},"name":"length","children":[{"line":377,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"length"},{"containerName":"length","name":"$length","line":377,"kind":13},{"containerName":"length","name":"$length","line":378,"kind":13},{"name":"$length","containerName":"length","line":379,"kind":13},{"containerName":"length","definition":"my","name":"$existing_length","localvar":"my","kind":13,"line":380},{"line":380,"kind":13,"name":"$self","containerName":"length"},{"name":"length","containerName":"length","line":380,"kind":12},{"kind":13,"line":381,"containerName":"length","name":"$length"},{"kind":13,"line":381,"name":"$existing_length","containerName":"length"},{"line":381,"kind":13,"containerName":"length","name":"$length"},{"kind":13,"line":382,"name":"$self","containerName":"length"},{"name":"end","containerName":"length","kind":12,"line":382},{"name":"$self","containerName":"length","kind":13,"line":382},{"kind":13,"line":382,"containerName":"length","name":"$length"},{"kind":13,"line":385,"containerName":"length","name":"$self"},{"line":385,"kind":12,"containerName":"length","name":"start"},{"containerName":"length","name":"$self","line":385,"kind":13},{"name":"end","containerName":"length","kind":12,"line":385},{"containerName":"length","name":"$self","line":386,"kind":13},{"name":"end","containerName":"length","kind":12,"line":386},{"name":"$self","containerName":"length","line":386,"kind":13},{"containerName":"length","name":"start","kind":12,"line":386}],"line":376,"kind":12,"signature":{"label":"length($self,$length)","parameters":[{"label":"$self"},{"label":"$length"}],"documentation":"1;\n# $Id: Position.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Position\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Position - A single position of a Marker, or the range over which\n                     that marker lies, in a Map\n\n=head1 SYNOPSIS\n\n    use Bio::Map::Position;\n    my $position = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -value => 100\n\t\t\t\t\t  );\n\n\tmy $position_with_range = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -start => 100,\n\t\t\t\t\t  -length => 10\n\t\t\t\t\t  );\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the PositionI interface that\nhandles the specific values of a position. This allows a map element\n(e.g. Marker) to have multiple positions within a map and still be\ntreated as a single entity.\n\nThis handles the concept of a relative map in which the order of\nelements and the distance between them is known, but does not\ndirectly handle the case when distances are unknown - in that case\narbitrary values must be assigned for position values.\n\nNo units are assumed here - units are handled by context of which Map\na position is placed in or the subclass of this Position.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nChad Matsalla, bioinformatics1@dieselwurks.com\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Position;\nuse strict;\n\nuse Scalar::Util qw(looks_like_number);\nuse Bio::Map::Relative;\n\nuse base qw(Bio::Root::Root Bio::Map::PositionI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::Position->new();\n Function: Builds a new Bio::Map::Position object \n Returns : Bio::Map::Position\n Args    : -map      => Bio::Map::MapI object\n           -element  => Bio::Map::MappableI object\n           -relative => Bio::Map::RelativeI object\n\n           * If this position has no range, or if a single value can describe\n             the range *\n           -value => scalar             : something that describes the single\n                                          point position or range of this\n                                          Position, most likely an int\n\n           * Or if this position has a range, at least two of *\n           -start => int                : value of the start co-ordinate\n           -end => int                  : value of the end co-ordinate\n           -length => int               : length of the range\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\t\n    my ($map, $marker, $element, $value, $start, $end, $length, $relative) = \n\t$self->_rearrange([qw( MAP\n\t\t\t       MARKER\n                   ELEMENT\n\t\t\t       VALUE\n\t\t\t\t   START\n\t\t\t\t   END\n\t\t\t\t   LENGTH\n                   RELATIVE\n\t\t\t       )], @args);\n\t\n    my $do_range = defined($start) || defined($end);\n    if ($value && $do_range) {\n        $self->warn(\"-value and (-start|-end|-length) are mutually exclusive, ignoring value\");\n\t\t$value = undef;\n    }\n\t\n    $map            && $self->map($map);\n    $marker         && $self->element($marker); # backwards compatibility\n    $element        && $self->element($element);\n    $relative       && $self->relative($relative);\n    defined($value) && $self->value($value);\n\t\n    if ($do_range) {\n\t\tdefined($start) && $self->start($start);\n\t\tdefined($end)   && $self->end($end);\n\t\tif ($length) {\n\t\t\tif (defined($start) && ! defined($end)) {\n\t\t\t\t$self->end($start + $length - 1);\n\t\t\t}\n\t\t\telsif (! defined($start)) {\n\t\t\t\t$self->start($end - $length + 1);\n\t\t\t}\n\t\t}\n\t\tdefined($self->end) || $self->end($start);\n    }\n\t\n    return $self;\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set\n\n\nsub relative {\n    my ($self, $relative) = @_;\n    if ($relative) {\n        $self->throw(\"Must supply an object\") unless ref($relative);\n        $self->throw(\"This is [$relative], not a Bio::Map::RelativeI\") unless $relative->isa('Bio::Map::RelativeI');\n        $self->{_relative_not_implicit} = 1;\n        $self->{_relative} = $relative;\n    }\n    return $self->{_relative} || $self->absolute_relative;\n}\n\n=head2 absolute\n\n  Title   : absolute\n  Usage   : my $absolute = $position->absolute();\n            $position->absolute($absolute);\n  Function: Get/set how this Position's co-ordinates (numerical(), start(),\n            end()) are reported. When absolute is off, co-ordinates are\n            relative to the thing described by relative(). Ie. the value\n            returned by start() will be the same as the value you set start()\n            to. When absolute is on, co-ordinates are converted to be relative\n            to the start of the map.\n\n            So if relative() currently points to a Relative object describing\n            \"relative to another position which is 100 bp from the start of\n            the map\", this Position's start() had been set to 50 and absolute()\n            returns 1, $position->start() will return 150. If absolute() returns\n            0 in the same situation, $position->start() would return 50.\n\n  Returns : boolean (default 0)\n  Args    : none to get, OR\n            boolean to set\n\n\nsub absolute {\n    my $self = shift;\n    if (@_) { $self->{_absolute} = shift }\n    return $self->{_absolute} || 0;\n}\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value;\n Function: Get/Set the value for this postion\n Returns : scalar, value\n Args    : [optional] new value to set\n\n\nsub value {\n\tmy ($self, $value) = @_;\n\tif (defined $value) {\n\t\t$self->{'_value'} = $value;\n\t\t$self->start($self->numeric) unless defined($self->start);\n\t\t$self->end($self->numeric) unless defined($self->end);\n\t}\n\treturn $self->{'_value'};\n}\n\n=head2 numeric\n\n Title   : numeric\n Usage   : my $num = $position->numeric;\n Function: Read-only method that is guaranteed to return a numeric \n           representation of the start of this position. \n Returns : scalar numeric\n Args    : none to get the co-ordinate normally (see absolute() method), OR\n           Bio::Map::RelativeI to get the co-ordinate converted to be\n           relative to what this Relative describes.\n\n\nsub numeric {\n    my ($self, $value) = @_;\n    my $num = $self->{'_value'};\n    $self->throw(\"The value has not been set, can't convert to numeric\") unless defined($num);\n    $self->throw(\"This value [$num] is not numeric\") unless looks_like_number($num);\n    \n    if (ref($value) && $value->isa('Bio::Map::RelativeI')) {\n        # get the value after co-ordinate conversion\n        my $raw = $num;\n        my ($abs_start, $rel_start) = $self->_relative_handler($value);\n        return $abs_start + $raw - $rel_start;\n    }\n    \n    # get the value as per absolute\n    if ($self->{_relative_not_implicit} && $self->absolute) {\n        # this actually returns the start, but should be the same thing...\n        return $self->relative->absolute_conversion($self);\n    }\n    \n    return $num;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : my $start = $position->start();\n            $position->start($start);\n  Function: Get/set the start co-ordinate of this position.\n  Returns : the start of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\nsub start {\n\tmy ($self, $value) = @_;\n    if (defined $value) {\n        if (ref($value) && $value->isa('Bio::Map::RelativeI')) {\n            # get the value after co-ordinate conversion\n            my $raw = $self->{start};\n            defined $raw || return;\n            my ($abs_start, $rel_start) = $self->_relative_handler($value);\n            return $abs_start + $raw - $rel_start;\n        }\n        else {\n            # set the value\n            $self->throw(\"This is [$value], not a number\") unless looks_like_number($value);\n            $self->{start} = $value;\n            $self->value($value) unless defined($self->value);\n        }\n    }\n    \n    # get the value as per absolute\n    if ($self->{_relative_not_implicit} && $self->absolute) {\n        return $self->relative->absolute_conversion($self);\n    }\n    \n    return defined($self->{start}) ? $self->{start} : return;\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : my $end = $position->end();\n            $position->end($end);\n  Function: Get/set the end co-ordinate of this position.\n  Returns : the end of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\nsub end {\n\tmy ($self, $value) = @_;\n    if (defined $value) {\n        if (ref($value) && $value->isa('Bio::Map::RelativeI')) {\n            # get the value after co-ordinate conversion\n            my $raw = $self->{end};\n            defined $raw || return;\n            my ($abs_start, $rel_start) = $self->_relative_handler($value);\n            return $abs_start + $raw - $rel_start;\n        }\n        else {\n            # set the value\n            $self->throw(\"This value [$value] is not numeric!\") unless looks_like_number($value);\n            $self->{end} = $value;\n        }\n    }\n    \n    # get the value as per absolute\n    if ($self->{_relative_not_implicit} && $self->absolute) {\n        my $raw = $self->{end} || return;\n        my $abs_start = $self->relative->absolute_conversion($self) || return;\n        return $abs_start + ($raw - $self->{start});\n    }\n    \n    return defined($self->{end}) ? $self->{end} : return;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $position->length();\n  Function: Get/set the length of this position's range, changing the end() if\n            necessary. Getting and even setting the length will fail if both\n            start() and end() are not already defined.\n  Returns : the length of this range\n  Args    : none to get, OR scalar numeric (>0) to set."},"detail":"($self,$length)","definition":"sub","containerName":"main::"},{"kind":12,"line":382,"name":"start"},{"range":{"start":{"character":0,"line":404},"end":{"character":9999,"line":408}},"name":"sortable","detail":"($self,$given_map)","signature":{"label":"sortable($self,$given_map)","documentation":"1;\n# $Id: Position.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Position\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Position - A single position of a Marker, or the range over which\n                     that marker lies, in a Map\n\n=head1 SYNOPSIS\n\n    use Bio::Map::Position;\n    my $position = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -value => 100\n\t\t\t\t\t  );\n\n\tmy $position_with_range = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -start => 100,\n\t\t\t\t\t  -length => 10\n\t\t\t\t\t  );\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the PositionI interface that\nhandles the specific values of a position. This allows a map element\n(e.g. Marker) to have multiple positions within a map and still be\ntreated as a single entity.\n\nThis handles the concept of a relative map in which the order of\nelements and the distance between them is known, but does not\ndirectly handle the case when distances are unknown - in that case\narbitrary values must be assigned for position values.\n\nNo units are assumed here - units are handled by context of which Map\na position is placed in or the subclass of this Position.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nChad Matsalla, bioinformatics1@dieselwurks.com\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Position;\nuse strict;\n\nuse Scalar::Util qw(looks_like_number);\nuse Bio::Map::Relative;\n\nuse base qw(Bio::Root::Root Bio::Map::PositionI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::Position->new();\n Function: Builds a new Bio::Map::Position object \n Returns : Bio::Map::Position\n Args    : -map      => Bio::Map::MapI object\n           -element  => Bio::Map::MappableI object\n           -relative => Bio::Map::RelativeI object\n\n           * If this position has no range, or if a single value can describe\n             the range *\n           -value => scalar             : something that describes the single\n                                          point position or range of this\n                                          Position, most likely an int\n\n           * Or if this position has a range, at least two of *\n           -start => int                : value of the start co-ordinate\n           -end => int                  : value of the end co-ordinate\n           -length => int               : length of the range\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\t\n    my ($map, $marker, $element, $value, $start, $end, $length, $relative) = \n\t$self->_rearrange([qw( MAP\n\t\t\t       MARKER\n                   ELEMENT\n\t\t\t       VALUE\n\t\t\t\t   START\n\t\t\t\t   END\n\t\t\t\t   LENGTH\n                   RELATIVE\n\t\t\t       )], @args);\n\t\n    my $do_range = defined($start) || defined($end);\n    if ($value && $do_range) {\n        $self->warn(\"-value and (-start|-end|-length) are mutually exclusive, ignoring value\");\n\t\t$value = undef;\n    }\n\t\n    $map            && $self->map($map);\n    $marker         && $self->element($marker); # backwards compatibility\n    $element        && $self->element($element);\n    $relative       && $self->relative($relative);\n    defined($value) && $self->value($value);\n\t\n    if ($do_range) {\n\t\tdefined($start) && $self->start($start);\n\t\tdefined($end)   && $self->end($end);\n\t\tif ($length) {\n\t\t\tif (defined($start) && ! defined($end)) {\n\t\t\t\t$self->end($start + $length - 1);\n\t\t\t}\n\t\t\telsif (! defined($start)) {\n\t\t\t\t$self->start($end - $length + 1);\n\t\t\t}\n\t\t}\n\t\tdefined($self->end) || $self->end($start);\n    }\n\t\n    return $self;\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set\n\n\nsub relative {\n    my ($self, $relative) = @_;\n    if ($relative) {\n        $self->throw(\"Must supply an object\") unless ref($relative);\n        $self->throw(\"This is [$relative], not a Bio::Map::RelativeI\") unless $relative->isa('Bio::Map::RelativeI');\n        $self->{_relative_not_implicit} = 1;\n        $self->{_relative} = $relative;\n    }\n    return $self->{_relative} || $self->absolute_relative;\n}\n\n=head2 absolute\n\n  Title   : absolute\n  Usage   : my $absolute = $position->absolute();\n            $position->absolute($absolute);\n  Function: Get/set how this Position's co-ordinates (numerical(), start(),\n            end()) are reported. When absolute is off, co-ordinates are\n            relative to the thing described by relative(). Ie. the value\n            returned by start() will be the same as the value you set start()\n            to. When absolute is on, co-ordinates are converted to be relative\n            to the start of the map.\n\n            So if relative() currently points to a Relative object describing\n            \"relative to another position which is 100 bp from the start of\n            the map\", this Position's start() had been set to 50 and absolute()\n            returns 1, $position->start() will return 150. If absolute() returns\n            0 in the same situation, $position->start() would return 50.\n\n  Returns : boolean (default 0)\n  Args    : none to get, OR\n            boolean to set\n\n\nsub absolute {\n    my $self = shift;\n    if (@_) { $self->{_absolute} = shift }\n    return $self->{_absolute} || 0;\n}\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value;\n Function: Get/Set the value for this postion\n Returns : scalar, value\n Args    : [optional] new value to set\n\n\nsub value {\n\tmy ($self, $value) = @_;\n\tif (defined $value) {\n\t\t$self->{'_value'} = $value;\n\t\t$self->start($self->numeric) unless defined($self->start);\n\t\t$self->end($self->numeric) unless defined($self->end);\n\t}\n\treturn $self->{'_value'};\n}\n\n=head2 numeric\n\n Title   : numeric\n Usage   : my $num = $position->numeric;\n Function: Read-only method that is guaranteed to return a numeric \n           representation of the start of this position. \n Returns : scalar numeric\n Args    : none to get the co-ordinate normally (see absolute() method), OR\n           Bio::Map::RelativeI to get the co-ordinate converted to be\n           relative to what this Relative describes.\n\n\nsub numeric {\n    my ($self, $value) = @_;\n    my $num = $self->{'_value'};\n    $self->throw(\"The value has not been set, can't convert to numeric\") unless defined($num);\n    $self->throw(\"This value [$num] is not numeric\") unless looks_like_number($num);\n    \n    if (ref($value) && $value->isa('Bio::Map::RelativeI')) {\n        # get the value after co-ordinate conversion\n        my $raw = $num;\n        my ($abs_start, $rel_start) = $self->_relative_handler($value);\n        return $abs_start + $raw - $rel_start;\n    }\n    \n    # get the value as per absolute\n    if ($self->{_relative_not_implicit} && $self->absolute) {\n        # this actually returns the start, but should be the same thing...\n        return $self->relative->absolute_conversion($self);\n    }\n    \n    return $num;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : my $start = $position->start();\n            $position->start($start);\n  Function: Get/set the start co-ordinate of this position.\n  Returns : the start of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\nsub start {\n\tmy ($self, $value) = @_;\n    if (defined $value) {\n        if (ref($value) && $value->isa('Bio::Map::RelativeI')) {\n            # get the value after co-ordinate conversion\n            my $raw = $self->{start};\n            defined $raw || return;\n            my ($abs_start, $rel_start) = $self->_relative_handler($value);\n            return $abs_start + $raw - $rel_start;\n        }\n        else {\n            # set the value\n            $self->throw(\"This is [$value], not a number\") unless looks_like_number($value);\n            $self->{start} = $value;\n            $self->value($value) unless defined($self->value);\n        }\n    }\n    \n    # get the value as per absolute\n    if ($self->{_relative_not_implicit} && $self->absolute) {\n        return $self->relative->absolute_conversion($self);\n    }\n    \n    return defined($self->{start}) ? $self->{start} : return;\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : my $end = $position->end();\n            $position->end($end);\n  Function: Get/set the end co-ordinate of this position.\n  Returns : the end of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\nsub end {\n\tmy ($self, $value) = @_;\n    if (defined $value) {\n        if (ref($value) && $value->isa('Bio::Map::RelativeI')) {\n            # get the value after co-ordinate conversion\n            my $raw = $self->{end};\n            defined $raw || return;\n            my ($abs_start, $rel_start) = $self->_relative_handler($value);\n            return $abs_start + $raw - $rel_start;\n        }\n        else {\n            # set the value\n            $self->throw(\"This value [$value] is not numeric!\") unless looks_like_number($value);\n            $self->{end} = $value;\n        }\n    }\n    \n    # get the value as per absolute\n    if ($self->{_relative_not_implicit} && $self->absolute) {\n        my $raw = $self->{end} || return;\n        my $abs_start = $self->relative->absolute_conversion($self) || return;\n        return $abs_start + ($raw - $self->{start});\n    }\n    \n    return defined($self->{end}) ? $self->{end} : return;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $position->length();\n  Function: Get/set the length of this position's range, changing the end() if\n            necessary. Getting and even setting the length will fail if both\n            start() and end() are not already defined.\n  Returns : the length of this range\n  Args    : none to get, OR scalar numeric (>0) to set.\n\n\nsub length {\n\tmy ($self, $length) = @_;\n\tif ($length) {\n        $length > 0 || return;\n\t\tmy $existing_length = $self->length || return;\n        return $length if $existing_length == $length;\n        $self->end($self->{start} + $length - 1);\n\t}\n\t\n\tif (defined($self->start) && defined($self->end)) {\n\t\treturn $self->end - $self->start + 1;\n\t}\n    return;\n}\n\n=head2 sortable\n\n Title   : sortable\n Usage   : my $num = $position->sortable();\n Function: Read-only method that is guaranteed to return a value suitable\n           for correctly sorting this kind of position amongst other positions\n           of the same kind on the same map. Note that sorting different kinds\n           of position together is unlikely to give sane results.\n Returns : numeric\n Args    : none","parameters":[{"label":"$self"},{"label":"$given_map"}]},"containerName":"main::","definition":"sub","line":404,"children":[{"localvar":"my","containerName":"sortable","definition":"my","name":"$self","line":405,"kind":13},{"kind":13,"line":405,"containerName":"sortable","name":"$given_map"},{"containerName":"sortable","definition":"my","name":"$answer","localvar":"my","kind":13,"line":406},{"line":406,"kind":13,"name":"$self","containerName":"sortable"},{"name":"numeric","containerName":"sortable","kind":12,"line":406},{"containerName":"sortable","name":"$self","kind":13,"line":406},{"kind":12,"line":406,"containerName":"sortable","name":"absolute_relative"},{"kind":13,"line":407,"containerName":"sortable","name":"$answer"}],"kind":12},{"containerName":"main::","definition":"sub","detail":"($self,$rel)","signature":{"label":"toString($self,$rel)","documentation":"1;\n# $Id: Position.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Position\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Position - A single position of a Marker, or the range over which\n                     that marker lies, in a Map\n\n=head1 SYNOPSIS\n\n    use Bio::Map::Position;\n    my $position = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -value => 100\n\t\t\t\t\t  );\n\n\tmy $position_with_range = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -start => 100,\n\t\t\t\t\t  -length => 10\n\t\t\t\t\t  );\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the PositionI interface that\nhandles the specific values of a position. This allows a map element\n(e.g. Marker) to have multiple positions within a map and still be\ntreated as a single entity.\n\nThis handles the concept of a relative map in which the order of\nelements and the distance between them is known, but does not\ndirectly handle the case when distances are unknown - in that case\narbitrary values must be assigned for position values.\n\nNo units are assumed here - units are handled by context of which Map\na position is placed in or the subclass of this Position.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nChad Matsalla, bioinformatics1@dieselwurks.com\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Position;\nuse strict;\n\nuse Scalar::Util qw(looks_like_number);\nuse Bio::Map::Relative;\n\nuse base qw(Bio::Root::Root Bio::Map::PositionI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::Position->new();\n Function: Builds a new Bio::Map::Position object \n Returns : Bio::Map::Position\n Args    : -map      => Bio::Map::MapI object\n           -element  => Bio::Map::MappableI object\n           -relative => Bio::Map::RelativeI object\n\n           * If this position has no range, or if a single value can describe\n             the range *\n           -value => scalar             : something that describes the single\n                                          point position or range of this\n                                          Position, most likely an int\n\n           * Or if this position has a range, at least two of *\n           -start => int                : value of the start co-ordinate\n           -end => int                  : value of the end co-ordinate\n           -length => int               : length of the range\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\t\n    my ($map, $marker, $element, $value, $start, $end, $length, $relative) = \n\t$self->_rearrange([qw( MAP\n\t\t\t       MARKER\n                   ELEMENT\n\t\t\t       VALUE\n\t\t\t\t   START\n\t\t\t\t   END\n\t\t\t\t   LENGTH\n                   RELATIVE\n\t\t\t       )], @args);\n\t\n    my $do_range = defined($start) || defined($end);\n    if ($value && $do_range) {\n        $self->warn(\"-value and (-start|-end|-length) are mutually exclusive, ignoring value\");\n\t\t$value = undef;\n    }\n\t\n    $map            && $self->map($map);\n    $marker         && $self->element($marker); # backwards compatibility\n    $element        && $self->element($element);\n    $relative       && $self->relative($relative);\n    defined($value) && $self->value($value);\n\t\n    if ($do_range) {\n\t\tdefined($start) && $self->start($start);\n\t\tdefined($end)   && $self->end($end);\n\t\tif ($length) {\n\t\t\tif (defined($start) && ! defined($end)) {\n\t\t\t\t$self->end($start + $length - 1);\n\t\t\t}\n\t\t\telsif (! defined($start)) {\n\t\t\t\t$self->start($end - $length + 1);\n\t\t\t}\n\t\t}\n\t\tdefined($self->end) || $self->end($start);\n    }\n\t\n    return $self;\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set\n\n\nsub relative {\n    my ($self, $relative) = @_;\n    if ($relative) {\n        $self->throw(\"Must supply an object\") unless ref($relative);\n        $self->throw(\"This is [$relative], not a Bio::Map::RelativeI\") unless $relative->isa('Bio::Map::RelativeI');\n        $self->{_relative_not_implicit} = 1;\n        $self->{_relative} = $relative;\n    }\n    return $self->{_relative} || $self->absolute_relative;\n}\n\n=head2 absolute\n\n  Title   : absolute\n  Usage   : my $absolute = $position->absolute();\n            $position->absolute($absolute);\n  Function: Get/set how this Position's co-ordinates (numerical(), start(),\n            end()) are reported. When absolute is off, co-ordinates are\n            relative to the thing described by relative(). Ie. the value\n            returned by start() will be the same as the value you set start()\n            to. When absolute is on, co-ordinates are converted to be relative\n            to the start of the map.\n\n            So if relative() currently points to a Relative object describing\n            \"relative to another position which is 100 bp from the start of\n            the map\", this Position's start() had been set to 50 and absolute()\n            returns 1, $position->start() will return 150. If absolute() returns\n            0 in the same situation, $position->start() would return 50.\n\n  Returns : boolean (default 0)\n  Args    : none to get, OR\n            boolean to set\n\n\nsub absolute {\n    my $self = shift;\n    if (@_) { $self->{_absolute} = shift }\n    return $self->{_absolute} || 0;\n}\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value;\n Function: Get/Set the value for this postion\n Returns : scalar, value\n Args    : [optional] new value to set\n\n\nsub value {\n\tmy ($self, $value) = @_;\n\tif (defined $value) {\n\t\t$self->{'_value'} = $value;\n\t\t$self->start($self->numeric) unless defined($self->start);\n\t\t$self->end($self->numeric) unless defined($self->end);\n\t}\n\treturn $self->{'_value'};\n}\n\n=head2 numeric\n\n Title   : numeric\n Usage   : my $num = $position->numeric;\n Function: Read-only method that is guaranteed to return a numeric \n           representation of the start of this position. \n Returns : scalar numeric\n Args    : none to get the co-ordinate normally (see absolute() method), OR\n           Bio::Map::RelativeI to get the co-ordinate converted to be\n           relative to what this Relative describes.\n\n\nsub numeric {\n    my ($self, $value) = @_;\n    my $num = $self->{'_value'};\n    $self->throw(\"The value has not been set, can't convert to numeric\") unless defined($num);\n    $self->throw(\"This value [$num] is not numeric\") unless looks_like_number($num);\n    \n    if (ref($value) && $value->isa('Bio::Map::RelativeI')) {\n        # get the value after co-ordinate conversion\n        my $raw = $num;\n        my ($abs_start, $rel_start) = $self->_relative_handler($value);\n        return $abs_start + $raw - $rel_start;\n    }\n    \n    # get the value as per absolute\n    if ($self->{_relative_not_implicit} && $self->absolute) {\n        # this actually returns the start, but should be the same thing...\n        return $self->relative->absolute_conversion($self);\n    }\n    \n    return $num;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : my $start = $position->start();\n            $position->start($start);\n  Function: Get/set the start co-ordinate of this position.\n  Returns : the start of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\nsub start {\n\tmy ($self, $value) = @_;\n    if (defined $value) {\n        if (ref($value) && $value->isa('Bio::Map::RelativeI')) {\n            # get the value after co-ordinate conversion\n            my $raw = $self->{start};\n            defined $raw || return;\n            my ($abs_start, $rel_start) = $self->_relative_handler($value);\n            return $abs_start + $raw - $rel_start;\n        }\n        else {\n            # set the value\n            $self->throw(\"This is [$value], not a number\") unless looks_like_number($value);\n            $self->{start} = $value;\n            $self->value($value) unless defined($self->value);\n        }\n    }\n    \n    # get the value as per absolute\n    if ($self->{_relative_not_implicit} && $self->absolute) {\n        return $self->relative->absolute_conversion($self);\n    }\n    \n    return defined($self->{start}) ? $self->{start} : return;\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : my $end = $position->end();\n            $position->end($end);\n  Function: Get/set the end co-ordinate of this position.\n  Returns : the end of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\nsub end {\n\tmy ($self, $value) = @_;\n    if (defined $value) {\n        if (ref($value) && $value->isa('Bio::Map::RelativeI')) {\n            # get the value after co-ordinate conversion\n            my $raw = $self->{end};\n            defined $raw || return;\n            my ($abs_start, $rel_start) = $self->_relative_handler($value);\n            return $abs_start + $raw - $rel_start;\n        }\n        else {\n            # set the value\n            $self->throw(\"This value [$value] is not numeric!\") unless looks_like_number($value);\n            $self->{end} = $value;\n        }\n    }\n    \n    # get the value as per absolute\n    if ($self->{_relative_not_implicit} && $self->absolute) {\n        my $raw = $self->{end} || return;\n        my $abs_start = $self->relative->absolute_conversion($self) || return;\n        return $abs_start + ($raw - $self->{start});\n    }\n    \n    return defined($self->{end}) ? $self->{end} : return;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $position->length();\n  Function: Get/set the length of this position's range, changing the end() if\n            necessary. Getting and even setting the length will fail if both\n            start() and end() are not already defined.\n  Returns : the length of this range\n  Args    : none to get, OR scalar numeric (>0) to set.\n\n\nsub length {\n\tmy ($self, $length) = @_;\n\tif ($length) {\n        $length > 0 || return;\n\t\tmy $existing_length = $self->length || return;\n        return $length if $existing_length == $length;\n        $self->end($self->{start} + $length - 1);\n\t}\n\t\n\tif (defined($self->start) && defined($self->end)) {\n\t\treturn $self->end - $self->start + 1;\n\t}\n    return;\n}\n\n=head2 sortable\n\n Title   : sortable\n Usage   : my $num = $position->sortable();\n Function: Read-only method that is guaranteed to return a value suitable\n           for correctly sorting this kind of position amongst other positions\n           of the same kind on the same map. Note that sorting different kinds\n           of position together is unlikely to give sane results.\n Returns : numeric\n Args    : none\n\n\nsub sortable {\n    my ($self, $given_map) = @_;\n    my $answer = $self->numeric($self->absolute_relative);\n    return $answer;\n}\n\n=head2 toString\n\n  Title   : toString\n  Usage   : print $position->toString(), \"\\n\";\n  Function: stringifies this range\n  Returns : a string representation of the range of this Position\n  Args    : optional Bio::Map::RelativeI to have the co-ordinates reported\n            relative to the thing described by that Relative","parameters":[{"label":"$self"},{"label":"$rel"}]},"kind":12,"line":421,"children":[{"localvar":"my","containerName":"toString","name":"$self","definition":"my","line":422,"kind":13},{"line":422,"kind":13,"name":"$rel","containerName":"toString"},{"kind":13,"line":423,"name":"$self","containerName":"toString"},{"kind":12,"line":423,"name":"start","containerName":"toString"},{"name":"$self","containerName":"toString","kind":13,"line":423},{"kind":12,"line":423,"containerName":"toString","name":"end"},{"containerName":"toString","name":"$self","kind":13,"line":424},{"name":"start","containerName":"toString","line":424,"kind":12},{"kind":13,"line":424,"name":"$rel","containerName":"toString"},{"line":424,"kind":13,"name":"$self","containerName":"toString"},{"kind":12,"line":424,"name":"end","containerName":"toString"},{"containerName":"toString","name":"$rel","kind":13,"line":424}],"name":"toString","range":{"start":{"line":421,"character":0},"end":{"line":427,"character":9999}}},{"definition":"sub","name":"absolute_relative","containerName":"main::","range":{"start":{"line":441,"character":0},"end":{"character":9999,"line":443}},"kind":12,"children":[{"containerName":"absolute_relative","name":"new","line":442,"kind":12}],"line":441},{"name":"Bio","containerName":"Map::Relative","kind":12,"line":442},{"children":[{"name":"$self","definition":"my","containerName":"_relative_handler","localvar":"my","kind":13,"line":448},{"name":"$value","containerName":"_relative_handler","line":448,"kind":13},{"name":"$own_relative","definition":"my","containerName":"_relative_handler","localvar":"my","kind":13,"line":450},{"line":450,"kind":13,"name":"$self","containerName":"_relative_handler"},{"kind":12,"line":450,"containerName":"_relative_handler","name":"relative"},{"containerName":"_relative_handler","definition":"my","name":"$own_type","localvar":"my","kind":13,"line":454},{"kind":13,"line":454,"name":"$req_type","containerName":"_relative_handler"},{"name":"$own_relative","containerName":"_relative_handler","line":454,"kind":13},{"name":"type","containerName":"_relative_handler","kind":12,"line":454},{"containerName":"_relative_handler","name":"$value","line":454,"kind":13},{"line":454,"kind":12,"name":"type","containerName":"_relative_handler"},{"line":455,"kind":13,"name":"$own_type","containerName":"_relative_handler"},{"name":"$req_type","containerName":"_relative_handler","line":455,"kind":13},{"line":455,"kind":13,"containerName":"_relative_handler","name":"$own_type"},{"containerName":"_relative_handler","name":"$req_type","line":455,"kind":13},{"line":455,"kind":13,"containerName":"_relative_handler","name":"$own_relative"},{"line":455,"kind":13,"name":"$own_type","containerName":"_relative_handler"},{"name":"$value","containerName":"_relative_handler","kind":13,"line":455},{"containerName":"_relative_handler","name":"$req_type","kind":13,"line":455},{"localvar":"my","name":"$abs_start","definition":"my","containerName":"_relative_handler","line":459,"kind":13},{"containerName":"_relative_handler","name":"$own_relative","kind":13,"line":459},{"name":"absolute_conversion","containerName":"_relative_handler","kind":12,"line":459},{"kind":13,"line":459,"containerName":"_relative_handler","name":"$self"},{"containerName":"_relative_handler","definition":"my","name":"$rel_start","localvar":"my","kind":13,"line":460},{"containerName":"_relative_handler","name":"$value","kind":13,"line":460},{"name":"absolute_conversion","containerName":"_relative_handler","kind":12,"line":460},{"kind":13,"line":460,"containerName":"_relative_handler","name":"$self"},{"line":461,"kind":13,"containerName":"_relative_handler","name":"$self"},{"name":"throw","containerName":"_relative_handler","kind":12,"line":461},{"containerName":"_relative_handler","name":"$abs_start","kind":13,"line":462},{"line":462,"kind":13,"name":"$rel_start","containerName":"_relative_handler"},{"name":"$abs_start","containerName":"_relative_handler","kind":13,"line":464},{"kind":13,"line":464,"name":"$rel_start","containerName":"_relative_handler"}],"line":447,"kind":12,"signature":{"documentation":" get our own absolute start and that of the thing we want as a frame of\n reference","parameters":[{"label":"$self"},{"label":"$value"}],"label":"_relative_handler($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","range":{"end":{"line":465,"character":9999},"start":{"character":0,"line":447}},"name":"_relative_handler"}],"version":5}