{"vars":[{"containerName":"","name":"base","line":104,"kind":2},{"signature":{"documentation":"1;\n### TO BE DELETED ###\n\n# BioPerl module for Bio::Map::OrderedPositionWithDistance\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics1@dieselwurks.com>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::OrderedPositionWithDistance - Abstracts the notion of a member\n\tof an ordered list of markers. Each marker is a certain distance\n\tfrom the one in the ordered list before it.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::OrderedPositionWithDistance;\n\t# the first marker in the sequence\n    my $position = Bio::Map::OrderedPositionWithDistance->new(-positions => 1,\n\t\t\t-distance => 22.3 );\n\t# the second marker in the sequence, 15.6 units from the fist one\n    my $position2 = Bio::Map::OrderedPositionWithDistance->new(-positions => 2,\n\t\t\t-distance => 15.6 );\n\t# the third marker in the sequence, coincidental with the second\n\t# marker\n    my $position3 = Bio::Map::OrderedPositionWithDistance->new(-positions => 3,\n\t\t\t-distance => 0 );\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the PositionI interface and the\nPosition object handles the specific values of a position.\nOrderedPositionWithDistance is intended to be slightly more specific\nthen Position but only specific enough for a parser from the MarkerIO\nsubsystem to create and then pass to a client application to bless into\nthe proper type. For an example of how this is intended to work, see the\nMapmaker.pm.\n\nNo units are assumed here - units are handled by context of which Map\na position is placed in.\n\nSe Bio::Map::Position for additional information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Map::OrderedPositionWithDistance;\nuse strict;\n\n\nuse base qw(Bio::Map::Position);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::OrderedPositionWithDistance->new();\n Function: Builds a new Bio::Map::OrderedPositionWithDistance object \n Returns : Bio::Map::OrderedPositionWithDistance\n Args    : -positions  - Should be a single value representing the order\n\tof this marker within the list of markers\n\t-distance - The distance this marker is from the marker before it.\n\t\t0 reflects coincidentality.","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"detail":"($class,@args)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":120,"name":"$class","definition":"my","containerName":"new","localvar":"my"},{"line":120,"kind":13,"name":"@args","containerName":"new"},{"containerName":"new","definition":"my","name":"$self","localvar":"my","kind":13,"line":121},{"name":"$class","containerName":"new","kind":13,"line":121},{"containerName":"new","name":"@args","line":121,"kind":13},{"name":"$self","containerName":"new","line":122,"kind":13},{"kind":13,"line":123,"containerName":"new","definition":"my","name":"$positions","localvar":"my"},{"name":"$distance","containerName":"new","line":123,"kind":13},{"containerName":"new","name":"$self","line":123,"kind":13},{"kind":12,"line":123,"containerName":"new","name":"_rearrange"},{"kind":13,"line":123,"name":"@args","containerName":"new"},{"containerName":"new","name":"$positions","kind":13,"line":124},{"kind":13,"line":125,"containerName":"new","name":"$p","definition":"my","localvar":"my"},{"kind":13,"line":125,"name":"$positions","containerName":"new"},{"kind":13,"line":126,"name":"$self","containerName":"new"},{"name":"add_position","containerName":"new","line":126,"kind":12},{"line":126,"kind":13,"name":"$p","containerName":"new"},{"line":129,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":129,"name":"add_position","containerName":"new"},{"kind":13,"line":129,"name":"$positions","containerName":"new"},{"line":131,"kind":13,"containerName":"new","name":"$distance"},{"name":"$self","containerName":"new","line":131,"kind":13},{"containerName":"new","name":"distance","line":131,"kind":12},{"name":"$distance","containerName":"new","kind":13,"line":131},{"line":133,"kind":13,"name":"$self","containerName":"new"}],"line":119,"kind":12,"range":{"end":{"character":9999,"line":135},"start":{"character":0,"line":119}},"name":"new"},{"line":121,"kind":12,"containerName":"new","name":"SUPER"},{"kind":12,"children":[{"localvar":"my","containerName":"distance","name":"$self","definition":"my","line":151,"kind":13},{"containerName":"distance","name":"$distance","line":151,"kind":13},{"containerName":"distance","name":"$distance","line":152,"kind":13},{"containerName":"distance","name":"$self","line":153,"kind":13},{"containerName":"distance","name":"$distance","kind":13,"line":153},{"line":155,"kind":13,"name":"$self","containerName":"distance"}],"line":150,"definition":"sub","containerName":"main::","signature":{"label":"distance($self,$distance)","documentation":"1;\n### TO BE DELETED ###\n\n# BioPerl module for Bio::Map::OrderedPositionWithDistance\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics1@dieselwurks.com>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::OrderedPositionWithDistance - Abstracts the notion of a member\n\tof an ordered list of markers. Each marker is a certain distance\n\tfrom the one in the ordered list before it.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::OrderedPositionWithDistance;\n\t# the first marker in the sequence\n    my $position = Bio::Map::OrderedPositionWithDistance->new(-positions => 1,\n\t\t\t-distance => 22.3 );\n\t# the second marker in the sequence, 15.6 units from the fist one\n    my $position2 = Bio::Map::OrderedPositionWithDistance->new(-positions => 2,\n\t\t\t-distance => 15.6 );\n\t# the third marker in the sequence, coincidental with the second\n\t# marker\n    my $position3 = Bio::Map::OrderedPositionWithDistance->new(-positions => 3,\n\t\t\t-distance => 0 );\n\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the PositionI interface and the\nPosition object handles the specific values of a position.\nOrderedPositionWithDistance is intended to be slightly more specific\nthen Position but only specific enough for a parser from the MarkerIO\nsubsystem to create and then pass to a client application to bless into\nthe proper type. For an example of how this is intended to work, see the\nMapmaker.pm.\n\nNo units are assumed here - units are handled by context of which Map\na position is placed in.\n\nSe Bio::Map::Position for additional information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Map::OrderedPositionWithDistance;\nuse strict;\n\n\nuse base qw(Bio::Map::Position);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::OrderedPositionWithDistance->new();\n Function: Builds a new Bio::Map::OrderedPositionWithDistance object \n Returns : Bio::Map::OrderedPositionWithDistance\n Args    : -positions  - Should be a single value representing the order\n\tof this marker within the list of markers\n\t-distance - The distance this marker is from the marker before it.\n\t\t0 reflects coincidentality.\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  $self->{'_positions'} = [];\n  my ($positions,$distance) = $self->_rearrange([qw(POSITIONS DISTANCE)], @args);\n  if( ref($positions) =~ /array/i ) { \n      foreach my $p ( @$positions ) {\n\t  $self->add_position($p);\n      }\n  } else { \n      $self->add_position($positions);\n  }\n\t$distance && $self->distance($distance);\n\t\n  return $self;\n\n}\n\n\n=head2 distance($new_distance)\n\n Title   : distance($new_distance)\n Usage   : $position->distance(new_distance) _or_\n        $position->distance()\n Function: get/set the distance of this position from the previous marker\n Returns : A scalar representing the current distance for this position.\n Args    : If $new_distance is provided the distance of this Position will\n        be set to $new_distance","parameters":[{"label":"$self"},{"label":"$distance"}]},"detail":"($self,$distance)","name":"distance","range":{"end":{"character":9999,"line":156},"start":{"character":0,"line":150}}}],"version":5}