{"vars":[{"kind":2,"line":85,"containerName":"","name":"base"},{"containerName":"main::","name":"get_position_handler","definition":"sub","range":{"end":{"line":112,"character":9999},"start":{"line":104,"character":0}},"kind":12,"line":104,"children":[{"kind":13,"line":105,"name":"$self","definition":"my","containerName":"get_position_handler","localvar":"my"},{"line":106,"kind":13,"containerName":"get_position_handler","name":"$self"},{"localvar":"my","containerName":"get_position_handler","name":"$ph","definition":"my","line":107,"kind":13},{"line":107,"kind":12,"containerName":"get_position_handler","name":"new"},{"name":"$self","containerName":"get_position_handler","line":107,"kind":13},{"name":"$self","containerName":"get_position_handler","kind":13,"line":108},{"name":"$ph","containerName":"get_position_handler","kind":13,"line":108},{"containerName":"get_position_handler","name":"$ph","line":109,"kind":13},{"kind":12,"line":109,"name":"register","containerName":"get_position_handler"},{"kind":13,"line":111,"containerName":"get_position_handler","name":"$self"}]},{"line":106,"kind":12,"name":"_eh"},{"containerName":"Map::PositionHandler","name":"Bio","kind":12,"line":107},{"name":"_eh","kind":12,"line":108},{"kind":12,"line":111,"name":"_eh"},{"containerName":"main::","definition":"sub","name":"add_position","range":{"start":{"line":131,"character":0},"end":{"character":9999,"line":135}},"kind":12,"line":131,"children":[{"localvar":"my","containerName":"add_position","name":"$self","definition":"my","line":132,"kind":13},{"containerName":"add_position","name":"$self","line":134,"kind":13},{"name":"get_position_handler","containerName":"add_position","kind":12,"line":134},{"kind":12,"line":134,"name":"add_positions","containerName":"add_position"}]},{"kind":12,"line":149,"children":[{"containerName":"get_positions","name":"$self","definition":"my","localvar":"my","kind":13,"line":150},{"containerName":"get_positions","name":"$thing","kind":13,"line":150},{"kind":13,"line":150,"containerName":"get_positions","name":"$no_sort"},{"line":151,"kind":13,"localvar":"my","containerName":"get_positions","name":"$map","definition":"my"},{"name":"$thing","containerName":"get_positions","kind":13,"line":152},{"line":152,"kind":13,"containerName":"get_positions","name":"$thing"},{"line":152,"kind":12,"name":"isa","containerName":"get_positions"},{"containerName":"get_positions","name":"$map","kind":13,"line":153},{"name":"$thing","containerName":"get_positions","kind":13,"line":153},{"line":156,"kind":13,"name":"$no_sort","containerName":"get_positions"},{"name":"$thing","containerName":"get_positions","line":156,"kind":13},{"kind":13,"line":158,"containerName":"get_positions","definition":"my","name":"@positions","localvar":"my"},{"containerName":"get_positions","name":"$self","kind":13,"line":158},{"kind":12,"line":158,"containerName":"get_positions","name":"get_position_handler"},{"line":158,"kind":12,"name":"get_positions","containerName":"get_positions"},{"kind":13,"line":158,"containerName":"get_positions","name":"$map"},{"line":159,"kind":13,"containerName":"get_positions","name":"@positions"},{"kind":13,"line":159,"containerName":"get_positions","name":"@positions"},{"containerName":"get_positions","name":"$no_sort","line":161,"kind":13},{"kind":13,"line":167,"name":"@positions","containerName":"get_positions"},{"name":"$a","containerName":"get_positions","line":168,"kind":13},{"kind":13,"line":168,"containerName":"get_positions","name":"$b"},{"line":169,"kind":12,"name":"sortable","containerName":"get_positions"},{"containerName":"get_positions","name":"@positions","line":170,"kind":13},{"line":172,"kind":13,"name":"@positions","containerName":"get_positions"}],"containerName":"main::","definition":"sub","detail":"($self,$thing,$no_sort)","signature":{"label":"get_positions($self,$thing,$no_sort)","parameters":[{"label":"$self"},{"label":"$thing"},{"label":"$no_sort"}],"documentation":"1;\n# $Id: MappableI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::MappableI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::MappableI - An object that can be placed in a map\n\n=head1 SYNOPSIS\n\n    # do not use this module directly\n    # See Bio::Map::Mappable for an example of\n    # implementation.\n\n=head1 DESCRIPTION\n\nThis object handles the generic notion of an element placed on a\n(linear) Map. A Mappable can have multiple positions in multiple maps, such as\nis the case of Restriction enzyme cut sites on sequence maps. For exact\ninformation about a mappable's position in a map one must query the associate\nPositionI objects which are accessible through the get_positions() method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho heikki-at-bioperl-dot-org\nLincoln Stein      lstein@cshl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::MappableI;\nuse strict;\nuse Bio::Map::PositionHandler;\n\nuse base qw(Bio::Map::EntityI Bio::AnnotatableI);\n\n=head2 EntityI methods\n\n These are fundamental to coordination of Mappables and other entities, so are\n implemented at the interface level\n\n\n=head2 get_position_handler\n\n Title   : get_position_handler\n Usage   : my $position_handler = $entity->get_position_handler();\n Function: Gets a PositionHandlerI that $entity is registered with.\n Returns : Bio::Map::PositionHandlerI object\n Args    : none\n\n\nsub get_position_handler {\n    my $self = shift;\n    unless (defined $self->{_eh}) {\n        my $ph = Bio::Map::PositionHandler->new(-self => $self);\n        $self->{_eh} = $ph;\n        $ph->register;\n    }\n    return $self->{_eh};\n}\n\n=head2 PositionHandlerI-related methods\n\n These are fundamental to coordination of Mappables and other entities, so are\n implemented at the interface level\n\n\n=head2 add_position\n\n Title   : add_position\n Usage   : $mappable->add_position($position);\n Function: Add a position to this mappable (defining where on which map it is).\n Returns : n/a\n Args    : L<Bio::Map::PositionI> object\n\n\nsub add_position {\n    my $self = shift;\n\t# actually, we allow multiple positions to be set at once\n    $self->get_position_handler->add_positions(@_);\n}\n\n=head2 get_positions\n\n Title   : get_positions\n Usage   : my @positions = $mappable->get_positions();\n Function: Get all the Positions of this Mappable (sorted).\n Returns : Array of L<Bio::Map::PositionI> objects\n Args    : none for all, OR\n           L<Bio::Map::MapI> object for positions on the given map, AND/OR some\n           other true value to avoid sorting"},"name":"get_positions","range":{"end":{"character":9999,"line":173},"start":{"line":149,"character":0}}},{"children":[{"kind":13,"line":199,"containerName":"purge_positions","name":"$self","definition":"my","localvar":"my"},{"containerName":"purge_positions","name":"$thing","kind":13,"line":199},{"line":200,"kind":13,"name":"$self","containerName":"purge_positions"},{"name":"get_position_handler","containerName":"purge_positions","kind":12,"line":200},{"line":200,"kind":12,"name":"purge_positions","containerName":"purge_positions"},{"containerName":"purge_positions","name":"$thing","line":200,"kind":13}],"line":198,"kind":12,"signature":{"label":"purge_positions($self,$thing)","parameters":[{"label":"$self"},{"label":"$thing"}],"documentation":"1;\n# $Id: MappableI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::MappableI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::MappableI - An object that can be placed in a map\n\n=head1 SYNOPSIS\n\n    # do not use this module directly\n    # See Bio::Map::Mappable for an example of\n    # implementation.\n\n=head1 DESCRIPTION\n\nThis object handles the generic notion of an element placed on a\n(linear) Map. A Mappable can have multiple positions in multiple maps, such as\nis the case of Restriction enzyme cut sites on sequence maps. For exact\ninformation about a mappable's position in a map one must query the associate\nPositionI objects which are accessible through the get_positions() method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho heikki-at-bioperl-dot-org\nLincoln Stein      lstein@cshl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::MappableI;\nuse strict;\nuse Bio::Map::PositionHandler;\n\nuse base qw(Bio::Map::EntityI Bio::AnnotatableI);\n\n=head2 EntityI methods\n\n These are fundamental to coordination of Mappables and other entities, so are\n implemented at the interface level\n\n\n=head2 get_position_handler\n\n Title   : get_position_handler\n Usage   : my $position_handler = $entity->get_position_handler();\n Function: Gets a PositionHandlerI that $entity is registered with.\n Returns : Bio::Map::PositionHandlerI object\n Args    : none\n\n\nsub get_position_handler {\n    my $self = shift;\n    unless (defined $self->{_eh}) {\n        my $ph = Bio::Map::PositionHandler->new(-self => $self);\n        $self->{_eh} = $ph;\n        $ph->register;\n    }\n    return $self->{_eh};\n}\n\n=head2 PositionHandlerI-related methods\n\n These are fundamental to coordination of Mappables and other entities, so are\n implemented at the interface level\n\n\n=head2 add_position\n\n Title   : add_position\n Usage   : $mappable->add_position($position);\n Function: Add a position to this mappable (defining where on which map it is).\n Returns : n/a\n Args    : L<Bio::Map::PositionI> object\n\n\nsub add_position {\n    my $self = shift;\n\t# actually, we allow multiple positions to be set at once\n    $self->get_position_handler->add_positions(@_);\n}\n\n=head2 get_positions\n\n Title   : get_positions\n Usage   : my @positions = $mappable->get_positions();\n Function: Get all the Positions of this Mappable (sorted).\n Returns : Array of L<Bio::Map::PositionI> objects\n Args    : none for all, OR\n           L<Bio::Map::MapI> object for positions on the given map, AND/OR some\n           other true value to avoid sorting\n\n\nsub get_positions {\n    my ($self, $thing, $no_sort) = @_;\n    my $map;\n    if (ref($thing) && $thing->isa('Bio::Map::MapI')) {\n        $map = $thing;\n    }\n    else {\n        $no_sort = $thing;\n    }\n    my @positions = $self->get_position_handler->get_positions($map);\n    return @positions if @positions == 1;\n    \n    unless ($no_sort) {\n        # don't do\n        # @positions = sort { $a->sortable <=> $b->sortable } @positions;\n        # directly since sortable() can result in the call of another sort\n        # routine and cause problems; pre-compute sortable values instead\n        # (which is also more efficient)\n        @positions = map { $_->[1] }\n                     sort { $a->[0] <=> $b->[0] }\n                     map  { [$_->sortable, $_] }\n                     @positions;\n    }\n    return @positions;\n}\n\n=head2 each_position\n\n Title   : each_position\n Function: Synonym of the get_positions() method.\n Status  : deprecated, will be removed in next version\n\n\n*each_position = \\&get_positions;\n\n=head2 purge_positions\n\n Title   : purge_positions\n Usage   : $mappable->purge_positions();\n Function: Remove positions from this mappable.\n Returns : n/a\n Args    : none to remove all positions, OR\n           L<Bio::Map::PositionI> object to remove just that Position, OR\n\t\t   L<Bio::Map::MapI> object to remove only those positions on the given\n\t\t   map"},"detail":"($self,$thing)","definition":"sub","containerName":"main::","range":{"end":{"line":201,"character":9999},"start":{"character":0,"line":198}},"name":"purge_positions"},{"range":{"end":{"line":216,"character":9999},"start":{"character":0,"line":213}},"name":"known_maps","definition":"sub","containerName":"main::","children":[{"kind":13,"line":214,"containerName":"known_maps","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":215,"name":"$self","containerName":"known_maps"},{"containerName":"known_maps","name":"get_position_handler","kind":12,"line":215},{"line":215,"kind":12,"containerName":"known_maps","name":"get_other_entities"}],"line":213,"kind":12},{"range":{"start":{"line":234,"character":0},"end":{"character":9999,"line":237}},"name":"name","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"name","line":235,"kind":13},{"kind":13,"line":236,"containerName":"name","name":"$self"},{"name":"throw_not_implemented","containerName":"name","kind":12,"line":236}],"line":234,"kind":12},{"line":251,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"id","line":252,"kind":13},{"containerName":"id","name":"$self","kind":13,"line":253},{"name":"throw_not_implemented","containerName":"id","line":253,"kind":12}],"kind":12,"range":{"end":{"character":9999,"line":254},"start":{"line":251,"character":0}},"containerName":"main::","name":"id","definition":"sub"},{"kind":12,"line":266,"children":[{"line":267,"kind":13,"localvar":"my","containerName":"in_map","definition":"my","name":"$self"},{"kind":13,"line":268,"containerName":"in_map","name":"$self"},{"line":268,"kind":12,"containerName":"in_map","name":"throw_not_implemented"}],"containerName":"main::","definition":"sub","name":"in_map","range":{"end":{"line":269,"character":9999},"start":{"character":0,"line":266}}},{"containerName":"main::","name":"equals","definition":"sub","range":{"start":{"character":0,"line":298},"end":{"line":301,"character":9999}},"kind":12,"line":298,"children":[{"containerName":"equals","name":"$self","definition":"my","localvar":"my","kind":13,"line":299},{"containerName":"equals","name":"$self","line":300,"kind":13},{"line":300,"kind":12,"containerName":"equals","name":"throw_not_implemented"}]},{"containerName":"main::","definition":"sub","name":"overlaps","range":{"start":{"line":323,"character":0},"end":{"line":326,"character":9999}},"kind":12,"line":323,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"overlaps","line":324,"kind":13},{"name":"$self","containerName":"overlaps","line":325,"kind":13},{"kind":12,"line":325,"containerName":"overlaps","name":"throw_not_implemented"}]},{"containerName":"main::","definition":"sub","name":"contains","range":{"end":{"line":351,"character":9999},"start":{"line":348,"character":0}},"kind":12,"line":348,"children":[{"kind":13,"line":349,"containerName":"contains","name":"$self","definition":"my","localvar":"my"},{"line":350,"kind":13,"containerName":"contains","name":"$self"},{"name":"throw_not_implemented","containerName":"contains","line":350,"kind":12}]},{"name":"intersection","definition":"sub","containerName":"main::","range":{"start":{"line":374,"character":0},"end":{"character":9999,"line":377}},"kind":12,"children":[{"kind":13,"line":375,"containerName":"intersection","name":"$self","definition":"my","localvar":"my"},{"line":376,"kind":13,"containerName":"intersection","name":"$self"},{"line":376,"kind":12,"containerName":"intersection","name":"throw_not_implemented"}],"line":374},{"range":{"start":{"character":0,"line":400},"end":{"character":9999,"line":403}},"definition":"sub","name":"union","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"union","line":401,"kind":13},{"containerName":"union","name":"$self","kind":13,"line":402},{"kind":12,"line":402,"containerName":"union","name":"throw_not_implemented"}],"line":400,"kind":12}],"version":5}