{"vars":[{"name":"base","containerName":"","kind":2,"line":85},{"range":{"end":{"line":112,"character":9999},"start":{"line":104,"character":0}},"containerName":"main::","name":"get_position_handler","definition":"sub","line":104,"children":[{"kind":13,"line":105,"name":"$self","definition":"my","containerName":"get_position_handler","localvar":"my"},{"line":106,"kind":13,"containerName":"get_position_handler","name":"$self"},{"definition":"my","name":"$ph","containerName":"get_position_handler","localvar":"my","kind":13,"line":107},{"containerName":"get_position_handler","name":"new","kind":12,"line":107},{"containerName":"get_position_handler","name":"$self","line":107,"kind":13},{"name":"$self","containerName":"get_position_handler","line":108,"kind":13},{"name":"$ph","containerName":"get_position_handler","kind":13,"line":108},{"name":"$ph","containerName":"get_position_handler","kind":13,"line":109},{"kind":12,"line":109,"containerName":"get_position_handler","name":"register"},{"containerName":"get_position_handler","name":"$self","line":111,"kind":13}],"kind":12},{"name":"_eh","kind":12,"line":106},{"line":107,"kind":12,"containerName":"Map::PositionHandler","name":"Bio"},{"line":108,"kind":12,"name":"_eh"},{"name":"_eh","kind":12,"line":111},{"name":"get_positions","range":{"start":{"line":132,"character":0},"end":{"character":9999,"line":141}},"containerName":"main::","definition":"sub","detail":"($self,$mappable)","signature":{"label":"get_positions($self,$mappable)","parameters":[{"label":"$self"},{"label":"$mappable"}],"documentation":"1;\n# $Id: MapI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::MapI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::MapI - Interface for describing Map objects in bioperl \n\n=head1 SYNOPSIS\n\n    # get a MapI somehow\n    my $name   = $map->name();     # string\n    my $length = $map->length();   # integer\n    my $species= $map->species;    # Bio::Species\n    my $type   = $map->type();     # genetic/sts/rh/\n\n=head1 DESCRIPTION\n\nThis object describes the basic functionality of a Map in bioperl.\nMaps are anything from Genetic Map to Sequence Map to Assembly Map\nto Restriction Enzyme to FPC.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::MapI;\nuse strict;\nuse Bio::Map::PositionHandler;\n\nuse base qw(Bio::Map::EntityI Bio::AnnotatableI);\n\n=head2 EntityI methods\n\n These are fundamental to coordination of Maps and other entities, so are\n implemented at the interface level\n\n\n=head2 get_position_handler\n\n Title   : get_position_handler\n Usage   : my $position_handler = $entity->get_position_handler();\n Function: Gets a PositionHandlerI that $entity is registered with.\n Returns : Bio::Map::PositionHandlerI object\n Args    : none\n\n\nsub get_position_handler {\n    my $self = shift;\n    unless (defined $self->{_eh}) {\n        my $ph = Bio::Map::PositionHandler->new(-self => $self);\n        $self->{_eh} = $ph;\n        $ph->register;\n    }\n    return $self->{_eh};\n}\n\n=head2 PositionHandlerI-related methods\n\n These are fundamental to coordination of Maps and other entities, so are\n implemented at the interface level\n\n\n=head2 get_positions\n\n Title   : get_positions\n Usage   : my @positions = $mappable->get_positions();\n Function: Get all the Positions on this Map (sorted).\n Returns : Array of L<Bio::Map::PositionI> objects\n Args    : none for all, OR\n           L<Bio::Map::MappableI> object for positions of the given Mappable"},"kind":12,"line":132,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"get_positions","line":133,"kind":13},{"kind":13,"line":133,"name":"$mappable","containerName":"get_positions"},{"localvar":"my","containerName":"get_positions","definition":"my","name":"@positions","line":134,"kind":13},{"kind":13,"line":134,"containerName":"get_positions","name":"$self"},{"name":"get_position_handler","containerName":"get_positions","line":134,"kind":12},{"containerName":"get_positions","name":"get_positions","line":134,"kind":12},{"kind":13,"line":134,"containerName":"get_positions","name":"$mappable"},{"kind":13,"line":136,"containerName":"get_positions","name":"@positions"},{"kind":13,"line":137,"containerName":"get_positions","name":"$a"},{"name":"$b","containerName":"get_positions","kind":13,"line":137},{"kind":12,"line":138,"name":"sortable","containerName":"get_positions"},{"containerName":"get_positions","name":"@positions","kind":13,"line":139},{"line":140,"kind":13,"name":"@positions","containerName":"get_positions"}]},{"name":"purge_positions","range":{"start":{"character":0,"line":167},"end":{"line":170,"character":9999}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: MapI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::MapI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::MapI - Interface for describing Map objects in bioperl \n\n=head1 SYNOPSIS\n\n    # get a MapI somehow\n    my $name   = $map->name();     # string\n    my $length = $map->length();   # integer\n    my $species= $map->species;    # Bio::Species\n    my $type   = $map->type();     # genetic/sts/rh/\n\n=head1 DESCRIPTION\n\nThis object describes the basic functionality of a Map in bioperl.\nMaps are anything from Genetic Map to Sequence Map to Assembly Map\nto Restriction Enzyme to FPC.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::MapI;\nuse strict;\nuse Bio::Map::PositionHandler;\n\nuse base qw(Bio::Map::EntityI Bio::AnnotatableI);\n\n=head2 EntityI methods\n\n These are fundamental to coordination of Maps and other entities, so are\n implemented at the interface level\n\n\n=head2 get_position_handler\n\n Title   : get_position_handler\n Usage   : my $position_handler = $entity->get_position_handler();\n Function: Gets a PositionHandlerI that $entity is registered with.\n Returns : Bio::Map::PositionHandlerI object\n Args    : none\n\n\nsub get_position_handler {\n    my $self = shift;\n    unless (defined $self->{_eh}) {\n        my $ph = Bio::Map::PositionHandler->new(-self => $self);\n        $self->{_eh} = $ph;\n        $ph->register;\n    }\n    return $self->{_eh};\n}\n\n=head2 PositionHandlerI-related methods\n\n These are fundamental to coordination of Maps and other entities, so are\n implemented at the interface level\n\n\n=head2 get_positions\n\n Title   : get_positions\n Usage   : my @positions = $mappable->get_positions();\n Function: Get all the Positions on this Map (sorted).\n Returns : Array of L<Bio::Map::PositionI> objects\n Args    : none for all, OR\n           L<Bio::Map::MappableI> object for positions of the given Mappable\n\n\nsub get_positions {\n    my ($self, $mappable) = @_;\n\tmy @positions = $self->get_position_handler->get_positions($mappable);\n    # precompute sortable for effieciency and to avoid bugs\n    @positions = map { $_->[1] }\n                 sort { $a->[0] <=> $b->[0] }\n                 map { [$_->sortable, $_] }\n                 @positions;\n    return @positions;\n}\n\n=head2 each_position\n\n Title   : each_position\n Function: Synonym of the get_positions() method.\n Status  : deprecated, will be removed in next version\n\n\n*each_position = \\&get_positions;\n\n=head2 purge_positions\n\n Title   : purge_positions\n Usage   : $map->purge_position();\n Function: Remove all positions from this map. Notifies the positions they are\n           no longer on this map.\n Returns : n/a\n Args    : none to remove all positions, OR\n           L<Bio::Map::PositionI> object to remove just that Position, OR\n\t\t   L<Bio::Map::MappableI> object to remove only those positions of the\n           given mappable","parameters":[{"label":"$self"},{"label":"$thing"}],"label":"purge_positions($self,$thing)"},"detail":"($self,$thing)","kind":12,"children":[{"containerName":"purge_positions","name":"$self","definition":"my","localvar":"my","kind":13,"line":168},{"line":168,"kind":13,"containerName":"purge_positions","name":"$thing"},{"containerName":"purge_positions","name":"$self","line":169,"kind":13},{"containerName":"purge_positions","name":"get_position_handler","line":169,"kind":12},{"kind":12,"line":169,"name":"purge_positions","containerName":"purge_positions"},{"containerName":"purge_positions","name":"$thing","line":169,"kind":13}],"line":167},{"range":{"start":{"character":0,"line":182},"end":{"character":9999,"line":185}},"containerName":"main::","name":"get_elements","definition":"sub","line":182,"children":[{"line":183,"kind":13,"localvar":"my","containerName":"get_elements","name":"$self","definition":"my"},{"line":184,"kind":13,"name":"$self","containerName":"get_elements"},{"containerName":"get_elements","name":"get_position_handler","kind":12,"line":184},{"kind":12,"line":184,"name":"get_other_entities","containerName":"get_elements"}],"kind":12},{"detail":"($self,$maps_ref,@extra_args)","signature":{"documentation":"1;\n# $Id: MapI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::MapI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::MapI - Interface for describing Map objects in bioperl \n\n=head1 SYNOPSIS\n\n    # get a MapI somehow\n    my $name   = $map->name();     # string\n    my $length = $map->length();   # integer\n    my $species= $map->species;    # Bio::Species\n    my $type   = $map->type();     # genetic/sts/rh/\n\n=head1 DESCRIPTION\n\nThis object describes the basic functionality of a Map in bioperl.\nMaps are anything from Genetic Map to Sequence Map to Assembly Map\nto Restriction Enzyme to FPC.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::MapI;\nuse strict;\nuse Bio::Map::PositionHandler;\n\nuse base qw(Bio::Map::EntityI Bio::AnnotatableI);\n\n=head2 EntityI methods\n\n These are fundamental to coordination of Maps and other entities, so are\n implemented at the interface level\n\n\n=head2 get_position_handler\n\n Title   : get_position_handler\n Usage   : my $position_handler = $entity->get_position_handler();\n Function: Gets a PositionHandlerI that $entity is registered with.\n Returns : Bio::Map::PositionHandlerI object\n Args    : none\n\n\nsub get_position_handler {\n    my $self = shift;\n    unless (defined $self->{_eh}) {\n        my $ph = Bio::Map::PositionHandler->new(-self => $self);\n        $self->{_eh} = $ph;\n        $ph->register;\n    }\n    return $self->{_eh};\n}\n\n=head2 PositionHandlerI-related methods\n\n These are fundamental to coordination of Maps and other entities, so are\n implemented at the interface level\n\n\n=head2 get_positions\n\n Title   : get_positions\n Usage   : my @positions = $mappable->get_positions();\n Function: Get all the Positions on this Map (sorted).\n Returns : Array of L<Bio::Map::PositionI> objects\n Args    : none for all, OR\n           L<Bio::Map::MappableI> object for positions of the given Mappable\n\n\nsub get_positions {\n    my ($self, $mappable) = @_;\n\tmy @positions = $self->get_position_handler->get_positions($mappable);\n    # precompute sortable for effieciency and to avoid bugs\n    @positions = map { $_->[1] }\n                 sort { $a->[0] <=> $b->[0] }\n                 map { [$_->sortable, $_] }\n                 @positions;\n    return @positions;\n}\n\n=head2 each_position\n\n Title   : each_position\n Function: Synonym of the get_positions() method.\n Status  : deprecated, will be removed in next version\n\n\n*each_position = \\&get_positions;\n\n=head2 purge_positions\n\n Title   : purge_positions\n Usage   : $map->purge_position();\n Function: Remove all positions from this map. Notifies the positions they are\n           no longer on this map.\n Returns : n/a\n Args    : none to remove all positions, OR\n           L<Bio::Map::PositionI> object to remove just that Position, OR\n\t\t   L<Bio::Map::MappableI> object to remove only those positions of the\n           given mappable\n\n\nsub purge_positions {\n    my ($self, $thing) = @_;\n    $self->get_position_handler->purge_positions($thing);\n}\n\n=head2 get_elements\n\n Title   : get_elements\n Usage   : my @elements = $map->get_elements;\n Function: Retrieves all the elements on a map (unordered)\n Returns : Array of Map elements (L<Bio::Map::MappableI>)\n Args    : none\n\n\nsub get_elements {\n    my $self = shift;\n    return $self->get_position_handler->get_other_entities;\n}\n\n=head2 each_element\n\n Title   : each_element\n Function: Synonym of the get_elements() method.\n Status  : deprecated, will be removed in the next version\n\n\n=head2 common_elements\n\n Title   : common_elements\n Usage   : my @common_elements = $map->common_elements(\\@other_maps);\n           my @common_elements = Bio::Map::SimpleMap->common_elements(\\@maps);\n Function: Find the elements that are common to multiple maps.\n Returns : array of Bio::Map::MappableI\n Args    : arg #1 = L<Bio::Map::MapI> to compare this one to, or an array ref\n                    of such objects (mandatory)\n           arg #2 = optionally, one or more of the key => value pairs below\n           -min_num => int        : the minimum number of input maps an element\n                                    must be found on before before returned\n                                    [default is 1]\n           -min_percent => number : as above, but the minimum percentage of\n                                    input maps [default is 100 - note that this\n                                    will effectively override all other options]\n           -require_self => 1|0   : require that all output elements at least\n                                    be on the calling map [default is 1, has no\n                                    effect when the second usage form is used]\n           -required => \\@maps    : require that all output elements be on at\n                                    least all the maps supplied here","parameters":[{"label":"$self"},{"label":"$maps_ref"},{"label":"@extra_args"}],"label":"common_elements($self,$maps_ref,@extra_args)"},"containerName":"main::","definition":"sub","line":219,"children":[{"definition":"my","name":"$self","containerName":"common_elements","localvar":"my","kind":13,"line":220},{"containerName":"common_elements","name":"$maps_ref","kind":13,"line":220},{"line":220,"kind":13,"name":"@extra_args","containerName":"common_elements"},{"line":221,"kind":13,"name":"$self","containerName":"common_elements"},{"containerName":"common_elements","name":"throw","line":221,"kind":12},{"containerName":"common_elements","name":"$maps_ref","kind":13,"line":221},{"kind":13,"line":222,"definition":"my","name":"@maps","containerName":"common_elements","localvar":"my"},{"containerName":"common_elements","name":"$maps_ref","kind":13,"line":223},{"line":224,"kind":13,"name":"@maps","containerName":"common_elements"},{"containerName":"common_elements","name":"$maps_ref","line":224,"kind":13}],"kind":12,"range":{"start":{"line":219,"character":0},"end":{"line":225,"character":9999}},"name":"common_elements"},{"containerName":null,"name":"$maps_ref","line":226,"kind":13},{"containerName":"main::","name":"isa","kind":12,"line":226},{"line":227,"kind":13,"name":"@maps","containerName":null},{"containerName":null,"name":"$maps_ref","line":227,"kind":13},{"line":229,"kind":13,"name":"%self","containerName":null},{"containerName":null,"name":"@maps","kind":13,"line":230},{"line":230,"kind":13,"containerName":null,"name":"$self"},{"line":232,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","name":"throw","kind":12,"line":232},{"line":232,"kind":13,"name":"@maps","containerName":null},{"containerName":null,"definition":"my","name":"%args","localvar":"my","kind":13,"line":234},{"kind":13,"line":234,"name":"@extra_args","containerName":null},{"name":"$min_num","definition":"my","containerName":null,"localvar":"my","kind":13,"line":235},{"name":"%args","containerName":null,"kind":13,"line":235},{"kind":13,"line":236,"name":"%args","containerName":null},{"line":237,"kind":13,"localvar":"my","containerName":null,"name":"$mn","definition":"my"},{"kind":13,"line":237,"containerName":null,"name":"@maps"},{"line":237,"kind":13,"name":"%args","containerName":null},{"name":"$mn","containerName":null,"line":238,"kind":13},{"line":238,"kind":13,"name":"%min_num","containerName":null},{"name":"$min_num","containerName":null,"kind":13,"line":239},{"containerName":null,"name":"$mn","kind":13,"line":239},{"kind":13,"line":242,"containerName":null,"name":"%required","definition":"my","localvar":"my"},{"line":242,"kind":13,"name":"%args","containerName":null},{"kind":13,"line":242,"name":"%args","containerName":null},{"kind":13,"line":243,"name":"%required","containerName":null},{"line":243,"kind":13,"containerName":null,"name":"$self"},{"name":"$self","containerName":null,"kind":13,"line":243},{"line":243,"kind":13,"name":"%args","containerName":null},{"localvar":"my","name":"@required","definition":"my","containerName":null,"line":244,"kind":13},{"kind":13,"line":244,"name":"%required","containerName":null},{"containerName":null,"definition":"my","name":"%map_elements","localvar":"my","kind":13,"line":246},{"line":247,"kind":13,"localvar":"my","definition":"my","name":"%elements","containerName":null},{"kind":13,"line":248,"definition":"my","name":"%count","containerName":null,"localvar":"my"},{"containerName":null,"definition":"my","name":"$map","localvar":"my","kind":13,"line":249},{"line":249,"kind":13,"containerName":null,"name":"@maps"},{"kind":13,"line":250,"containerName":null,"name":"%map_elements"},{"containerName":null,"name":"%map","kind":13,"line":250},{"containerName":null,"name":"$element","definition":"my","localvar":"my","kind":13,"line":251},{"line":251,"kind":13,"name":"$map","containerName":null},{"kind":12,"line":251,"name":"get_elements","containerName":"main::"},{"name":"%map_elements","containerName":null,"line":252,"kind":13},{"kind":13,"line":252,"name":"%map","containerName":null},{"name":"$element","containerName":null,"line":252,"kind":13},{"line":253,"kind":13,"name":"%elements","containerName":null},{"containerName":null,"name":"$element","line":253,"kind":13},{"containerName":null,"name":"$element","kind":13,"line":253},{"containerName":null,"name":"%count","line":254,"kind":13},{"name":"$element","containerName":null,"line":254,"kind":13},{"localvar":"my","definition":"my","name":"@elements","containerName":null,"line":258,"kind":13},{"name":"ELEMENT","line":259,"kind":12},{"kind":13,"line":259,"containerName":null,"definition":"my","name":"$key","localvar":"my"},{"line":259,"kind":13,"containerName":null,"name":"$value"},{"name":"%elements","containerName":null,"kind":13,"line":259},{"containerName":null,"name":"%count","kind":13,"line":260},{"line":260,"kind":13,"name":"$key","containerName":null},{"name":"$min_num","containerName":null,"line":260,"kind":13},{"kind":13,"line":261,"containerName":null,"definition":"my","name":"$required","localvar":"my"},{"name":"@required","containerName":null,"kind":13,"line":261},{"name":"%map_elements","containerName":null,"kind":13,"line":262},{"name":"%required","containerName":null,"line":262,"kind":13},{"line":262,"kind":13,"containerName":null,"name":"$key"},{"kind":12,"line":262,"name":"ELEMENT"},{"name":"@elements","containerName":null,"kind":13,"line":265},{"containerName":null,"name":"$value","line":265,"kind":13},{"containerName":null,"name":"@elements","line":267,"kind":13},{"kind":12,"children":[{"kind":13,"line":285,"containerName":"species","name":"$self","definition":"my","localvar":"my"},{"line":286,"kind":13,"containerName":"species","name":"$self"},{"name":"throw_not_implemented","containerName":"species","kind":12,"line":286}],"line":284,"name":"species","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":287},"start":{"line":284,"character":0}}},{"kind":12,"line":299,"children":[{"localvar":"my","containerName":"units","name":"$self","definition":"my","line":300,"kind":13},{"name":"$self","containerName":"units","kind":13,"line":301},{"name":"throw_not_implemented","containerName":"units","kind":12,"line":301}],"containerName":"main::","definition":"sub","name":"units","range":{"start":{"character":0,"line":299},"end":{"line":302,"character":9999}}},{"line":314,"children":[{"name":"$self","definition":"my","containerName":"type","localvar":"my","kind":13,"line":315},{"name":"$self","containerName":"type","kind":13,"line":316},{"line":316,"kind":12,"name":"throw_not_implemented","containerName":"type"}],"kind":12,"range":{"start":{"line":314,"character":0},"end":{"line":317,"character":9999}},"containerName":"main::","definition":"sub","name":"type"},{"children":[{"kind":13,"line":330,"definition":"my","name":"$self","containerName":"name","localvar":"my"},{"line":331,"kind":13,"containerName":"name","name":"$self"},{"kind":12,"line":331,"name":"throw_not_implemented","containerName":"name"}],"line":329,"kind":12,"range":{"end":{"character":9999,"line":332},"start":{"line":329,"character":0}},"name":"name","definition":"sub","containerName":"main::"},{"line":347,"children":[{"line":348,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"length"},{"kind":13,"line":349,"name":"$self","containerName":"length"},{"kind":12,"line":349,"name":"throw_not_implemented","containerName":"length"}],"kind":12,"range":{"end":{"character":9999,"line":350},"start":{"character":0,"line":347}},"containerName":"main::","definition":"sub","name":"length"}],"version":5}