{"version":5,"vars":[{"containerName":"","name":"base","line":128,"kind":2},{"line":130,"kind":13,"definition":"our","name":"%GENEMAPS","containerName":"main::"},{"name":"new","range":{"start":{"character":0,"line":157},"end":{"character":9999,"line":183}},"kind":12,"line":157,"children":[{"localvar":"my","name":"$class","definition":"my","containerName":"new","line":158,"kind":13},{"kind":13,"line":158,"name":"@args","containerName":"new"},{"name":"$self","definition":"my","containerName":"new","localvar":"my","kind":13,"line":159},{"line":159,"kind":13,"name":"$class","containerName":"new"},{"line":159,"kind":13,"name":"@args","containerName":"new"},{"line":161,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$uid"},{"line":161,"kind":13,"name":"$gene","containerName":"new"},{"kind":13,"line":161,"name":"$species","containerName":"new"},{"line":161,"kind":13,"name":"$desc","containerName":"new"},{"kind":13,"line":161,"containerName":"new","name":"$up"},{"name":"$down","containerName":"new","kind":13,"line":161},{"containerName":"new","name":"$seq","line":161,"kind":13},{"line":161,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"_rearrange","line":161,"kind":12},{"name":"@args","containerName":"new","line":167,"kind":13},{"name":"$gene","containerName":"new","line":169,"kind":13},{"containerName":"new","name":"$species","kind":13,"line":169},{"name":"$self","containerName":"new","line":170,"kind":13},{"name":"throw","containerName":"new","line":170,"kind":12},{"line":173,"kind":13,"containerName":"new","name":"$self"},{"line":173,"kind":12,"containerName":"new","name":"gene"},{"name":"$gene","containerName":"new","line":173,"kind":13},{"line":173,"kind":13,"name":"$desc","containerName":"new"},{"line":173,"kind":13,"name":"$up","containerName":"new"},{"name":"$down","containerName":"new","kind":13,"line":173},{"kind":13,"line":174,"containerName":"new","name":"$self"},{"name":"seq","containerName":"new","line":174,"kind":12},{"name":"$seq","containerName":"new","kind":13,"line":174},{"name":"$seq","containerName":"new","line":174,"kind":13},{"name":"$uid","containerName":"new","kind":13,"line":176},{"name":"$self","containerName":"new","line":179,"kind":13},{"line":179,"kind":12,"containerName":"new","name":"unique_id"},{"containerName":"new","name":"$self","kind":13,"line":179},{"name":"unique_id","containerName":"new","line":179,"kind":12},{"name":"$self","containerName":"new","line":182,"kind":13}],"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: GeneMap.pm,v 1.17 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::GeneMap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GeneMap - A MapI implementation to represent the area around a gene\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GeneMap;\n    use Bio::Map::Gene;\n    use Bio::Map::TranscriptionFactor;\n    use Bio::Map::GeneRelative;\n\n\t# make some maps that will represent an area around a particular gene in\n\t# particular species (by default, the map represents the area in the genome\n    # 1000bp upstream of the gene)\n    my $map1 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'human',\n                                      -description => 'breast cancer 2, early onset');\n\tmy $map2 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'mouse');\n\n\t# model a TF that binds 500bp upstream of the BRCA2 gene in humans and\n\t# 250bp upstream of BRCA2 in mice\n\tmy $rel = Bio::Map::GeneRelative->new(-description => \"gene start\");\n    my $tf = Bio::Map::TranscriptionFactor->get(-universal_name => 'tf1');\n\tBio::Map::Position->new(-map => $map1,\n                            -element => $tf,\n                            -start => -500,\n                            -length => 10,\n                            -relative => $rel);\n\tBio::Map::Position->new(-map => $map2,\n                            -element => $tf,\n                            -start => -250,\n                            -length => 10,\n                            -relative => $rel);\n\n\t# find out all the things that map near BRCA2 in all species\n\tforeach my $map ($gene->known_maps) {\n\t\tforeach my $thing ($map->get_elements) {\n            next if $thing eq $gene;\n            foreach my $pos ($thing->get_positions($map)) {\n                print \"In species \", $map->species, \", \",\n                      $thing->universal_name, \" maps at \", $pos->value,\n                      \" relative to \", $pos->relative->description, \" of gene \",\n                      $gene->universal_name, \"\\n\";\n            }\n\t\t}\n\t}\n    \n    # a GeneMap isa PrimarySeq and so can have sequence associated with it\n    $map1->seq('ATGC');\n    my $subseq = $map1->subseq(2,3); # TG\n\n=head1 DESCRIPTION\n\nModel the abstract notion of the area around a gene - you don't care exactly\nwhere this area is in the genome, you just want to be able to say \"something\nbinds upstream of gene X\" and \"something else binds 20bp upstream of the first\nsomething\" etc.\n\nIt's useful for modelling transcription factor bindings sites, letting you find\nout which transcription factors bind near a gene of interest, or which genes\nare bound by a transcription factor of interest.\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GeneMap;\nuse strict;\n\nuse Bio::Map::Gene;\nuse Bio::Map::Position;\n\nuse base qw(Bio::Map::SimpleMap Bio::PrimarySeq);\n\nour $GENEMAPS = {};\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::GeneMap->new();\n Function: Builds a new Bio::Map::GeneMap object (that has placed on it a\n           mappable element (Bio::Map::Gene) representing a gene).\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene"}},{"name":"SUPER","containerName":"new","kind":12,"line":159},{"range":{"start":{"character":0,"line":217},"end":{"character":9999,"line":246}},"name":"get","detail":"($class,@args)","signature":{"label":"get($class,@args)","documentation":"1;\n# $Id: GeneMap.pm,v 1.17 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::GeneMap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GeneMap - A MapI implementation to represent the area around a gene\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GeneMap;\n    use Bio::Map::Gene;\n    use Bio::Map::TranscriptionFactor;\n    use Bio::Map::GeneRelative;\n\n\t# make some maps that will represent an area around a particular gene in\n\t# particular species (by default, the map represents the area in the genome\n    # 1000bp upstream of the gene)\n    my $map1 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'human',\n                                      -description => 'breast cancer 2, early onset');\n\tmy $map2 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'mouse');\n\n\t# model a TF that binds 500bp upstream of the BRCA2 gene in humans and\n\t# 250bp upstream of BRCA2 in mice\n\tmy $rel = Bio::Map::GeneRelative->new(-description => \"gene start\");\n    my $tf = Bio::Map::TranscriptionFactor->get(-universal_name => 'tf1');\n\tBio::Map::Position->new(-map => $map1,\n                            -element => $tf,\n                            -start => -500,\n                            -length => 10,\n                            -relative => $rel);\n\tBio::Map::Position->new(-map => $map2,\n                            -element => $tf,\n                            -start => -250,\n                            -length => 10,\n                            -relative => $rel);\n\n\t# find out all the things that map near BRCA2 in all species\n\tforeach my $map ($gene->known_maps) {\n\t\tforeach my $thing ($map->get_elements) {\n            next if $thing eq $gene;\n            foreach my $pos ($thing->get_positions($map)) {\n                print \"In species \", $map->species, \", \",\n                      $thing->universal_name, \" maps at \", $pos->value,\n                      \" relative to \", $pos->relative->description, \" of gene \",\n                      $gene->universal_name, \"\\n\";\n            }\n\t\t}\n\t}\n    \n    # a GeneMap isa PrimarySeq and so can have sequence associated with it\n    $map1->seq('ATGC');\n    my $subseq = $map1->subseq(2,3); # TG\n\n=head1 DESCRIPTION\n\nModel the abstract notion of the area around a gene - you don't care exactly\nwhere this area is in the genome, you just want to be able to say \"something\nbinds upstream of gene X\" and \"something else binds 20bp upstream of the first\nsomething\" etc.\n\nIt's useful for modelling transcription factor bindings sites, letting you find\nout which transcription factors bind near a gene of interest, or which genes\nare bound by a transcription factor of interest.\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GeneMap;\nuse strict;\n\nuse Bio::Map::Gene;\nuse Bio::Map::Position;\n\nuse base qw(Bio::Map::SimpleMap Bio::PrimarySeq);\n\nour $GENEMAPS = {};\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::GeneMap->new();\n Function: Builds a new Bio::Map::GeneMap object (that has placed on it a\n           mappable element (Bio::Map::Gene) representing a gene).\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($uid, $gene, $species, $desc, $up, $down, $seq) = $self->_rearrange([qw(UID\n                                                    GENE\n                                                    SPECIES\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM\n                                                    SEQ)], @args);\n    \n    unless (defined $gene && defined $species) {\n        $self->throw(\"You must supply both -species and -gene\");\n    }\n    \n    $self->gene(-gene => $gene, -description => $desc, -upstream => $up, -downstream => $down);\n    $self->seq($seq) if $seq;\n    \n    unless (defined($uid)) {\n        # trigger the special behaviour in our unique_id method by supplying it\n        # the unique_id we got from our parent class\n        $self->unique_id($self->unique_id);\n    }\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $map = Bio::Map::GeneMap->get();\n Function: Builds a new Bio::Map::GeneMap object (like new()), or gets a\n           pre-existing one that corresponds to your arguements.\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n           If you supply a -uid, and a map had previously been created and\n           given that uid, that same map object will be returned. Otherwise, the\n           combination of -gene and -species will be used to determine\n           if the same map had previously been made. If a corresponding map\n           hadn't previously been made, a new map object will be created and\n           returned.","parameters":[{"label":"$class"},{"label":"@args"}]},"containerName":"main::","definition":"sub","line":217,"children":[{"localvar":"my","containerName":"get","definition":"my","name":"$class","line":218,"kind":13},{"containerName":"get","name":"@args","kind":13,"line":218},{"containerName":"get","definition":"my","name":"$uid","localvar":"my","kind":13,"line":219},{"kind":13,"line":219,"containerName":"get","name":"$gene"},{"name":"$species","containerName":"get","kind":13,"line":219},{"line":219,"kind":13,"name":"$desc","containerName":"get"},{"line":219,"kind":13,"name":"$up","containerName":"get"},{"name":"$down","containerName":"get","kind":13,"line":219},{"name":"$seq","containerName":"get","kind":13,"line":219},{"kind":12,"line":219,"containerName":"get","name":"_rearrange"},{"line":225,"kind":13,"name":"@args","containerName":"get"},{"definition":"my","name":"$gene_map","containerName":"get","localvar":"my","kind":13,"line":227},{"containerName":"get","name":"$uid","line":228,"kind":13},{"line":228,"kind":13,"containerName":"get","name":"$GENEMAPS"},{"line":228,"kind":13,"containerName":"get","name":"$uid"},{"kind":13,"line":229,"containerName":"get","name":"$gene_map"},{"containerName":"get","name":"$GENEMAPS","line":229,"kind":13},{"containerName":"get","name":"$uid","line":229,"kind":13},{"name":"$gene","containerName":"get","kind":13,"line":231},{"line":231,"kind":13,"containerName":"get","name":"$species"},{"name":"$name","definition":"my","containerName":"get","localvar":"my","kind":13,"line":232},{"kind":13,"line":232,"containerName":"get","name":"$gene"},{"containerName":"get","name":"$gene","line":232,"kind":13},{"containerName":"get","name":"universal_name","line":232,"kind":12},{"containerName":"get","name":"$gene","line":232,"kind":13},{"containerName":"get","name":"$GENEMAPS","line":233,"kind":13},{"kind":13,"line":233,"containerName":"get","name":"$name"},{"kind":13,"line":233,"containerName":"get","name":"$species"},{"name":"$gene_map","containerName":"get","line":234,"kind":13},{"containerName":"get","name":"$GENEMAPS","line":234,"kind":13},{"name":"$name","containerName":"get","line":234,"kind":13},{"kind":13,"line":234,"containerName":"get","name":"$species"},{"containerName":"get","name":"$gene_map","kind":13,"line":237},{"containerName":"get","name":"$gene_map","kind":13,"line":238},{"line":238,"kind":12,"name":"gene","containerName":"get"},{"name":"description","containerName":"get","line":238,"kind":12},{"containerName":"get","name":"$desc","line":238,"kind":13},{"name":"$desc","containerName":"get","line":238,"kind":13},{"name":"$gene_map","containerName":"get","kind":13,"line":239},{"line":239,"kind":12,"containerName":"get","name":"upstream"},{"line":239,"kind":13,"name":"$up","containerName":"get"},{"kind":13,"line":239,"containerName":"get","name":"$up"},{"line":240,"kind":13,"containerName":"get","name":"$gene_map"},{"kind":12,"line":240,"name":"downstream","containerName":"get"},{"containerName":"get","name":"$down","line":240,"kind":13},{"kind":13,"line":240,"containerName":"get","name":"$down"},{"containerName":"get","name":"$gene_map","kind":13,"line":241},{"kind":12,"line":241,"name":"seq","containerName":"get"},{"containerName":"get","name":"$seq","line":241,"kind":13},{"containerName":"get","name":"$seq","kind":13,"line":241},{"name":"$gene_map","containerName":"get","kind":13,"line":242},{"kind":13,"line":245,"containerName":"get","name":"$class"},{"line":245,"kind":12,"containerName":"get","name":"new"},{"name":"@args","containerName":"get","line":245,"kind":13}],"kind":12},{"kind":12,"line":219,"name":"Bio","containerName":"Root::Root"},{"name":"by_uid","line":228,"kind":12},{"line":229,"kind":12,"name":"by_uid"},{"name":"by_ns","line":233,"kind":12},{"name":"by_ns","line":234,"kind":12},{"detail":"($self,$id)","signature":{"label":"unique_id($self,$id)","documentation":"1;\n# $Id: GeneMap.pm,v 1.17 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::GeneMap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GeneMap - A MapI implementation to represent the area around a gene\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GeneMap;\n    use Bio::Map::Gene;\n    use Bio::Map::TranscriptionFactor;\n    use Bio::Map::GeneRelative;\n\n\t# make some maps that will represent an area around a particular gene in\n\t# particular species (by default, the map represents the area in the genome\n    # 1000bp upstream of the gene)\n    my $map1 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'human',\n                                      -description => 'breast cancer 2, early onset');\n\tmy $map2 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'mouse');\n\n\t# model a TF that binds 500bp upstream of the BRCA2 gene in humans and\n\t# 250bp upstream of BRCA2 in mice\n\tmy $rel = Bio::Map::GeneRelative->new(-description => \"gene start\");\n    my $tf = Bio::Map::TranscriptionFactor->get(-universal_name => 'tf1');\n\tBio::Map::Position->new(-map => $map1,\n                            -element => $tf,\n                            -start => -500,\n                            -length => 10,\n                            -relative => $rel);\n\tBio::Map::Position->new(-map => $map2,\n                            -element => $tf,\n                            -start => -250,\n                            -length => 10,\n                            -relative => $rel);\n\n\t# find out all the things that map near BRCA2 in all species\n\tforeach my $map ($gene->known_maps) {\n\t\tforeach my $thing ($map->get_elements) {\n            next if $thing eq $gene;\n            foreach my $pos ($thing->get_positions($map)) {\n                print \"In species \", $map->species, \", \",\n                      $thing->universal_name, \" maps at \", $pos->value,\n                      \" relative to \", $pos->relative->description, \" of gene \",\n                      $gene->universal_name, \"\\n\";\n            }\n\t\t}\n\t}\n    \n    # a GeneMap isa PrimarySeq and so can have sequence associated with it\n    $map1->seq('ATGC');\n    my $subseq = $map1->subseq(2,3); # TG\n\n=head1 DESCRIPTION\n\nModel the abstract notion of the area around a gene - you don't care exactly\nwhere this area is in the genome, you just want to be able to say \"something\nbinds upstream of gene X\" and \"something else binds 20bp upstream of the first\nsomething\" etc.\n\nIt's useful for modelling transcription factor bindings sites, letting you find\nout which transcription factors bind near a gene of interest, or which genes\nare bound by a transcription factor of interest.\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GeneMap;\nuse strict;\n\nuse Bio::Map::Gene;\nuse Bio::Map::Position;\n\nuse base qw(Bio::Map::SimpleMap Bio::PrimarySeq);\n\nour $GENEMAPS = {};\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::GeneMap->new();\n Function: Builds a new Bio::Map::GeneMap object (that has placed on it a\n           mappable element (Bio::Map::Gene) representing a gene).\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($uid, $gene, $species, $desc, $up, $down, $seq) = $self->_rearrange([qw(UID\n                                                    GENE\n                                                    SPECIES\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM\n                                                    SEQ)], @args);\n    \n    unless (defined $gene && defined $species) {\n        $self->throw(\"You must supply both -species and -gene\");\n    }\n    \n    $self->gene(-gene => $gene, -description => $desc, -upstream => $up, -downstream => $down);\n    $self->seq($seq) if $seq;\n    \n    unless (defined($uid)) {\n        # trigger the special behaviour in our unique_id method by supplying it\n        # the unique_id we got from our parent class\n        $self->unique_id($self->unique_id);\n    }\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $map = Bio::Map::GeneMap->get();\n Function: Builds a new Bio::Map::GeneMap object (like new()), or gets a\n           pre-existing one that corresponds to your arguements.\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n           If you supply a -uid, and a map had previously been created and\n           given that uid, that same map object will be returned. Otherwise, the\n           combination of -gene and -species will be used to determine\n           if the same map had previously been made. If a corresponding map\n           hadn't previously been made, a new map object will be created and\n           returned.\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($uid, $gene, $species, $desc, $up, $down, $seq) = Bio::Root::Root->_rearrange([qw(UID\n                                                    GENE\n                                                    SPECIES\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM\n                                                    SEQ)], @args);\n    \n    my $gene_map;\n    if ($uid && defined $GENEMAPS->{by_uid}->{$uid}) {\n        $gene_map = $GENEMAPS->{by_uid}->{$uid};\n    }\n    elsif ($gene && $species) {\n        my $name = ref($gene) ? $gene->universal_name : $gene;\n        if (defined $GENEMAPS->{by_ns}->{$name}->{$species}) {\n            $gene_map = $GENEMAPS->{by_ns}->{$name}->{$species};\n        }\n    }\n    if ($gene_map) {\n        $gene_map->gene->description($desc) if $desc;\n        $gene_map->upstream($up) if defined($up);\n        $gene_map->downstream($down) if defined($down);\n        $gene_map->seq($seq) if $seq;\n        return $gene_map;\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $map->unique_id;\n Function: Get/set the unique ID for this map\n Returns : string\n Args    : none to get, OR string to set","parameters":[{"label":"$self"},{"label":"$id"}]},"containerName":"main::","definition":"sub","line":258,"children":[{"line":259,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"unique_id"},{"name":"$id","containerName":"unique_id","kind":13,"line":259},{"containerName":"unique_id","name":"$id","kind":13,"line":260},{"line":261,"kind":13,"containerName":"unique_id","name":"$GENEMAPS"},{"containerName":"unique_id","name":"$self","line":261,"kind":13},{"name":"$self","containerName":"unique_id","kind":13,"line":262},{"kind":13,"line":262,"name":"$id","containerName":"unique_id"},{"containerName":"unique_id","name":"$GENEMAPS","kind":13,"line":263},{"kind":13,"line":263,"name":"$id","containerName":"unique_id"},{"containerName":"unique_id","name":"$self","line":263,"kind":13},{"name":"$self","containerName":"unique_id","line":265,"kind":13}],"kind":12,"range":{"start":{"line":258,"character":0},"end":{"line":266,"character":9999}},"name":"unique_id"},{"kind":12,"line":261,"name":"by_uid"},{"name":"by_uid","kind":12,"line":263},{"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GeneMap.pm,v 1.17 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::GeneMap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GeneMap - A MapI implementation to represent the area around a gene\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GeneMap;\n    use Bio::Map::Gene;\n    use Bio::Map::TranscriptionFactor;\n    use Bio::Map::GeneRelative;\n\n\t# make some maps that will represent an area around a particular gene in\n\t# particular species (by default, the map represents the area in the genome\n    # 1000bp upstream of the gene)\n    my $map1 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'human',\n                                      -description => 'breast cancer 2, early onset');\n\tmy $map2 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'mouse');\n\n\t# model a TF that binds 500bp upstream of the BRCA2 gene in humans and\n\t# 250bp upstream of BRCA2 in mice\n\tmy $rel = Bio::Map::GeneRelative->new(-description => \"gene start\");\n    my $tf = Bio::Map::TranscriptionFactor->get(-universal_name => 'tf1');\n\tBio::Map::Position->new(-map => $map1,\n                            -element => $tf,\n                            -start => -500,\n                            -length => 10,\n                            -relative => $rel);\n\tBio::Map::Position->new(-map => $map2,\n                            -element => $tf,\n                            -start => -250,\n                            -length => 10,\n                            -relative => $rel);\n\n\t# find out all the things that map near BRCA2 in all species\n\tforeach my $map ($gene->known_maps) {\n\t\tforeach my $thing ($map->get_elements) {\n            next if $thing eq $gene;\n            foreach my $pos ($thing->get_positions($map)) {\n                print \"In species \", $map->species, \", \",\n                      $thing->universal_name, \" maps at \", $pos->value,\n                      \" relative to \", $pos->relative->description, \" of gene \",\n                      $gene->universal_name, \"\\n\";\n            }\n\t\t}\n\t}\n    \n    # a GeneMap isa PrimarySeq and so can have sequence associated with it\n    $map1->seq('ATGC');\n    my $subseq = $map1->subseq(2,3); # TG\n\n=head1 DESCRIPTION\n\nModel the abstract notion of the area around a gene - you don't care exactly\nwhere this area is in the genome, you just want to be able to say \"something\nbinds upstream of gene X\" and \"something else binds 20bp upstream of the first\nsomething\" etc.\n\nIt's useful for modelling transcription factor bindings sites, letting you find\nout which transcription factors bind near a gene of interest, or which genes\nare bound by a transcription factor of interest.\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GeneMap;\nuse strict;\n\nuse Bio::Map::Gene;\nuse Bio::Map::Position;\n\nuse base qw(Bio::Map::SimpleMap Bio::PrimarySeq);\n\nour $GENEMAPS = {};\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::GeneMap->new();\n Function: Builds a new Bio::Map::GeneMap object (that has placed on it a\n           mappable element (Bio::Map::Gene) representing a gene).\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($uid, $gene, $species, $desc, $up, $down, $seq) = $self->_rearrange([qw(UID\n                                                    GENE\n                                                    SPECIES\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM\n                                                    SEQ)], @args);\n    \n    unless (defined $gene && defined $species) {\n        $self->throw(\"You must supply both -species and -gene\");\n    }\n    \n    $self->gene(-gene => $gene, -description => $desc, -upstream => $up, -downstream => $down);\n    $self->seq($seq) if $seq;\n    \n    unless (defined($uid)) {\n        # trigger the special behaviour in our unique_id method by supplying it\n        # the unique_id we got from our parent class\n        $self->unique_id($self->unique_id);\n    }\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $map = Bio::Map::GeneMap->get();\n Function: Builds a new Bio::Map::GeneMap object (like new()), or gets a\n           pre-existing one that corresponds to your arguements.\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n           If you supply a -uid, and a map had previously been created and\n           given that uid, that same map object will be returned. Otherwise, the\n           combination of -gene and -species will be used to determine\n           if the same map had previously been made. If a corresponding map\n           hadn't previously been made, a new map object will be created and\n           returned.\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($uid, $gene, $species, $desc, $up, $down, $seq) = Bio::Root::Root->_rearrange([qw(UID\n                                                    GENE\n                                                    SPECIES\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM\n                                                    SEQ)], @args);\n    \n    my $gene_map;\n    if ($uid && defined $GENEMAPS->{by_uid}->{$uid}) {\n        $gene_map = $GENEMAPS->{by_uid}->{$uid};\n    }\n    elsif ($gene && $species) {\n        my $name = ref($gene) ? $gene->universal_name : $gene;\n        if (defined $GENEMAPS->{by_ns}->{$name}->{$species}) {\n            $gene_map = $GENEMAPS->{by_ns}->{$name}->{$species};\n        }\n    }\n    if ($gene_map) {\n        $gene_map->gene->description($desc) if $desc;\n        $gene_map->upstream($up) if defined($up);\n        $gene_map->downstream($down) if defined($down);\n        $gene_map->seq($seq) if $seq;\n        return $gene_map;\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $map->unique_id;\n Function: Get/set the unique ID for this map\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub unique_id {\n    my ($self, $id) = @_;\n    if (defined $id) {\n        delete $GENEMAPS->{by_uid}->{$self->{'_uid'}};\n        $self->{'_uid'} = $id;\n        $GENEMAPS->{by_uid}->{$id} = $self;\n    }\n    return $self->{'_uid'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : my $species = $map->species;\n Function: Get/set Species for a map. It is not recommended to change this once\n           set.\n Returns : Bio::Taxon object or string\n Args    : none to get, OR Bio::Taxon or string to set","label":"species($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"containerName":"species","name":"$self","definition":"my","localvar":"my","kind":13,"line":280},{"line":280,"kind":13,"containerName":"species","name":"$value"},{"kind":13,"line":281,"containerName":"species","name":"$value"},{"localvar":"my","containerName":"species","definition":"my","name":"$old_species","line":282,"kind":13},{"line":282,"kind":13,"containerName":"species","name":"$self"},{"name":"$self","containerName":"species","kind":13,"line":283},{"line":283,"kind":13,"containerName":"species","name":"$value"},{"kind":13,"line":284,"containerName":"species","name":"$name","definition":"my","localvar":"my"},{"name":"$self","containerName":"species","kind":13,"line":284},{"containerName":"species","name":"universal_name","kind":12,"line":284},{"line":284,"kind":13,"name":"$value","containerName":"species"},{"containerName":"species","name":"$old_species","line":285,"kind":13},{"kind":13,"line":286,"containerName":"species","name":"$GENEMAPS"},{"name":"$name","containerName":"species","line":286,"kind":13},{"name":"$old_species","containerName":"species","line":286,"kind":13},{"name":"$GENEMAPS","containerName":"species","line":288,"kind":13},{"containerName":"species","name":"$name","line":288,"kind":13},{"containerName":"species","name":"$value","kind":13,"line":288},{"line":288,"kind":13,"containerName":"species","name":"$self"},{"line":290,"kind":13,"containerName":"species","name":"$self"}],"line":279,"kind":12,"range":{"end":{"character":9999,"line":291},"start":{"line":279,"character":0}},"name":"species"},{"line":282,"kind":12,"name":"_species"},{"line":286,"kind":12,"name":"by_ns"},{"name":"by_ns","kind":12,"line":288},{"range":{"end":{"character":9999,"line":305},"start":{"line":303,"character":0}},"containerName":"main::","definition":"sub","name":"type","line":303,"children":[],"kind":12},{"name":"gene","range":{"end":{"line":366,"character":9999},"start":{"line":327,"character":0}},"definition":"sub","containerName":"main::","signature":{"label":"gene($self,@args)","documentation":"1;\n# $Id: GeneMap.pm,v 1.17 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::GeneMap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GeneMap - A MapI implementation to represent the area around a gene\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GeneMap;\n    use Bio::Map::Gene;\n    use Bio::Map::TranscriptionFactor;\n    use Bio::Map::GeneRelative;\n\n\t# make some maps that will represent an area around a particular gene in\n\t# particular species (by default, the map represents the area in the genome\n    # 1000bp upstream of the gene)\n    my $map1 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'human',\n                                      -description => 'breast cancer 2, early onset');\n\tmy $map2 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'mouse');\n\n\t# model a TF that binds 500bp upstream of the BRCA2 gene in humans and\n\t# 250bp upstream of BRCA2 in mice\n\tmy $rel = Bio::Map::GeneRelative->new(-description => \"gene start\");\n    my $tf = Bio::Map::TranscriptionFactor->get(-universal_name => 'tf1');\n\tBio::Map::Position->new(-map => $map1,\n                            -element => $tf,\n                            -start => -500,\n                            -length => 10,\n                            -relative => $rel);\n\tBio::Map::Position->new(-map => $map2,\n                            -element => $tf,\n                            -start => -250,\n                            -length => 10,\n                            -relative => $rel);\n\n\t# find out all the things that map near BRCA2 in all species\n\tforeach my $map ($gene->known_maps) {\n\t\tforeach my $thing ($map->get_elements) {\n            next if $thing eq $gene;\n            foreach my $pos ($thing->get_positions($map)) {\n                print \"In species \", $map->species, \", \",\n                      $thing->universal_name, \" maps at \", $pos->value,\n                      \" relative to \", $pos->relative->description, \" of gene \",\n                      $gene->universal_name, \"\\n\";\n            }\n\t\t}\n\t}\n    \n    # a GeneMap isa PrimarySeq and so can have sequence associated with it\n    $map1->seq('ATGC');\n    my $subseq = $map1->subseq(2,3); # TG\n\n=head1 DESCRIPTION\n\nModel the abstract notion of the area around a gene - you don't care exactly\nwhere this area is in the genome, you just want to be able to say \"something\nbinds upstream of gene X\" and \"something else binds 20bp upstream of the first\nsomething\" etc.\n\nIt's useful for modelling transcription factor bindings sites, letting you find\nout which transcription factors bind near a gene of interest, or which genes\nare bound by a transcription factor of interest.\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GeneMap;\nuse strict;\n\nuse Bio::Map::Gene;\nuse Bio::Map::Position;\n\nuse base qw(Bio::Map::SimpleMap Bio::PrimarySeq);\n\nour $GENEMAPS = {};\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::GeneMap->new();\n Function: Builds a new Bio::Map::GeneMap object (that has placed on it a\n           mappable element (Bio::Map::Gene) representing a gene).\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($uid, $gene, $species, $desc, $up, $down, $seq) = $self->_rearrange([qw(UID\n                                                    GENE\n                                                    SPECIES\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM\n                                                    SEQ)], @args);\n    \n    unless (defined $gene && defined $species) {\n        $self->throw(\"You must supply both -species and -gene\");\n    }\n    \n    $self->gene(-gene => $gene, -description => $desc, -upstream => $up, -downstream => $down);\n    $self->seq($seq) if $seq;\n    \n    unless (defined($uid)) {\n        # trigger the special behaviour in our unique_id method by supplying it\n        # the unique_id we got from our parent class\n        $self->unique_id($self->unique_id);\n    }\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $map = Bio::Map::GeneMap->get();\n Function: Builds a new Bio::Map::GeneMap object (like new()), or gets a\n           pre-existing one that corresponds to your arguements.\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n           If you supply a -uid, and a map had previously been created and\n           given that uid, that same map object will be returned. Otherwise, the\n           combination of -gene and -species will be used to determine\n           if the same map had previously been made. If a corresponding map\n           hadn't previously been made, a new map object will be created and\n           returned.\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($uid, $gene, $species, $desc, $up, $down, $seq) = Bio::Root::Root->_rearrange([qw(UID\n                                                    GENE\n                                                    SPECIES\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM\n                                                    SEQ)], @args);\n    \n    my $gene_map;\n    if ($uid && defined $GENEMAPS->{by_uid}->{$uid}) {\n        $gene_map = $GENEMAPS->{by_uid}->{$uid};\n    }\n    elsif ($gene && $species) {\n        my $name = ref($gene) ? $gene->universal_name : $gene;\n        if (defined $GENEMAPS->{by_ns}->{$name}->{$species}) {\n            $gene_map = $GENEMAPS->{by_ns}->{$name}->{$species};\n        }\n    }\n    if ($gene_map) {\n        $gene_map->gene->description($desc) if $desc;\n        $gene_map->upstream($up) if defined($up);\n        $gene_map->downstream($down) if defined($down);\n        $gene_map->seq($seq) if $seq;\n        return $gene_map;\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $map->unique_id;\n Function: Get/set the unique ID for this map\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub unique_id {\n    my ($self, $id) = @_;\n    if (defined $id) {\n        delete $GENEMAPS->{by_uid}->{$self->{'_uid'}};\n        $self->{'_uid'} = $id;\n        $GENEMAPS->{by_uid}->{$id} = $self;\n    }\n    return $self->{'_uid'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : my $species = $map->species;\n Function: Get/set Species for a map. It is not recommended to change this once\n           set.\n Returns : Bio::Taxon object or string\n Args    : none to get, OR Bio::Taxon or string to set\n\n\nsub species {\n    my ($self, $value) = @_;\n    if ($value) {\n        my $old_species = $self->{_species};\n        $self->{'_species'} = $value;\n        my $name = $self->universal_name || return $value;\n        if ($old_species) {\n            delete $GENEMAPS->{by_ns}->{$name}->{$old_species};\n        }\n        $GENEMAPS->{by_ns}->{$name}->{$value} = $self;\n    }\n    return $self->{'_species'};\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $map->type\n Function: Get Map type\n Returns : string 'gene'\n Args    : none\n\n\nsub type {\n    return 'gene';\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : my $gene = $map->gene;\n           $map->gene(-gene => $gene);\n Function: Get/set the mappable element on this map that represents the gene\n           this map is for. Once set, it is not recommended to re-set the gene\n           to something else. Behaviour in that case is undefined.\n Returns : Bio::Map::Gene\n Args    : none to get, OR to set:\n           -gene        => Bio::Map::Gene or string of the universal name (see\n                           Bio::Map::Gene docs), REQUIRED\n           -description => string, applied to the Bio::Map::Gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","kind":12,"children":[{"line":328,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"gene"},{"line":328,"kind":13,"name":"@args","containerName":"gene"},{"name":"@args","containerName":"gene","kind":13,"line":330},{"name":"$gene","definition":"my","containerName":"gene","localvar":"my","kind":13,"line":331},{"name":"$desc","containerName":"gene","line":331,"kind":13},{"line":331,"kind":13,"name":"$up","containerName":"gene"},{"name":"$down","containerName":"gene","kind":13,"line":331},{"kind":13,"line":331,"containerName":"gene","name":"$self"},{"name":"_rearrange","containerName":"gene","line":331,"kind":12},{"kind":13,"line":334,"name":"@args","containerName":"gene"},{"line":335,"kind":13,"name":"$self","containerName":"gene"},{"containerName":"gene","name":"throw","kind":12,"line":335},{"containerName":"gene","name":"$gene","kind":13,"line":335},{"localvar":"my","name":"$gene_obj","definition":"my","containerName":"gene","line":337,"kind":13},{"name":"$gene","containerName":"gene","kind":13,"line":337},{"kind":13,"line":337,"containerName":"gene","name":"$gene"},{"containerName":"gene","name":"get","kind":12,"line":337},{"line":337,"kind":13,"containerName":"gene","name":"$gene"},{"line":337,"kind":13,"name":"$desc","containerName":"gene"},{"containerName":"gene","name":"$self","kind":13,"line":338},{"containerName":"gene","name":"$self","kind":13,"line":339},{"kind":13,"line":339,"name":"$gene_obj","containerName":"gene"},{"name":"$self","containerName":"gene","kind":13,"line":340},{"kind":12,"line":340,"containerName":"gene","name":"warn"},{"name":"$self","containerName":"gene","kind":13,"line":341},{"kind":12,"line":341,"containerName":"gene","name":"purge_positions"},{"line":341,"kind":13,"name":"$self","containerName":"gene"},{"containerName":"gene","name":"$GENEMAPS","kind":13,"line":342},{"kind":13,"line":342,"containerName":"gene","name":"$self"},{"name":"universal_name","containerName":"gene","line":342,"kind":12},{"kind":13,"line":342,"name":"$self","containerName":"gene"},{"line":342,"kind":12,"containerName":"gene","name":"species"},{"name":"$self","containerName":"gene","kind":13,"line":343},{"line":343,"kind":13,"name":"$gene_obj","containerName":"gene"},{"name":"$self","containerName":"gene","kind":13,"line":347},{"name":"upstream","containerName":"gene","line":347,"kind":12},{"kind":13,"line":347,"name":"$up","containerName":"gene"},{"name":"$up","containerName":"gene","line":347,"kind":13},{"containerName":"gene","name":"$self","line":348,"kind":13},{"containerName":"gene","name":"downstream","line":348,"kind":12},{"kind":13,"line":348,"name":"$down","containerName":"gene"},{"line":348,"kind":13,"containerName":"gene","name":"$down"},{"containerName":"gene","name":"$up","kind":13,"line":352},{"kind":13,"line":353,"containerName":"gene","name":"$up"},{"containerName":"gene","name":"$self","line":353,"kind":13},{"containerName":"gene","name":"throw","kind":12,"line":353},{"name":"new","containerName":"gene","kind":12,"line":354},{"name":"$self","containerName":"gene","line":354,"kind":13},{"line":354,"kind":13,"containerName":"gene","name":"$up"},{"name":"$gene_obj","containerName":"gene","kind":13,"line":354},{"name":"$self","containerName":"gene","kind":13,"line":355},{"line":355,"kind":13,"name":"$gene_obj","containerName":"gene"},{"name":"$self","containerName":"gene","kind":13,"line":356},{"containerName":"gene","name":"downstream","kind":12,"line":356},{"name":"$down","containerName":"gene","line":356,"kind":13},{"name":"$gene_obj","containerName":"gene","line":359,"kind":13},{"containerName":"gene","name":"_set_from_db","kind":12,"line":359},{"containerName":"gene","name":"$self","line":359,"kind":13},{"line":362,"kind":13,"containerName":"gene","name":"$GENEMAPS"},{"name":"$self","containerName":"gene","line":362,"kind":13},{"containerName":"gene","name":"universal_name","line":362,"kind":12},{"name":"$self","containerName":"gene","line":362,"kind":13},{"kind":12,"line":362,"name":"species","containerName":"gene"},{"containerName":"gene","name":"$self","kind":13,"line":362},{"containerName":"gene","name":"$self","kind":13,"line":365}],"line":327},{"containerName":"Map::Gene","name":"Bio","line":337,"kind":12},{"name":"gene","line":338,"kind":12},{"name":"gene","kind":12,"line":339},{"line":341,"kind":12,"name":"gene"},{"name":"by_ns","kind":12,"line":342},{"line":343,"kind":12,"name":"gene"},{"kind":12,"line":354,"name":"Bio","containerName":"Map::Position"},{"name":"gene","kind":12,"line":355},{"line":362,"kind":12,"name":"by_ns"},{"name":"gene","kind":12,"line":365},{"name":"universal_name","range":{"start":{"character":0,"line":379},"end":{"line":389,"character":9999}},"definition":"sub","containerName":"main::","signature":{"label":"universal_name($self,$value)","documentation":"1;\n# $Id: GeneMap.pm,v 1.17 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::GeneMap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GeneMap - A MapI implementation to represent the area around a gene\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GeneMap;\n    use Bio::Map::Gene;\n    use Bio::Map::TranscriptionFactor;\n    use Bio::Map::GeneRelative;\n\n\t# make some maps that will represent an area around a particular gene in\n\t# particular species (by default, the map represents the area in the genome\n    # 1000bp upstream of the gene)\n    my $map1 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'human',\n                                      -description => 'breast cancer 2, early onset');\n\tmy $map2 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'mouse');\n\n\t# model a TF that binds 500bp upstream of the BRCA2 gene in humans and\n\t# 250bp upstream of BRCA2 in mice\n\tmy $rel = Bio::Map::GeneRelative->new(-description => \"gene start\");\n    my $tf = Bio::Map::TranscriptionFactor->get(-universal_name => 'tf1');\n\tBio::Map::Position->new(-map => $map1,\n                            -element => $tf,\n                            -start => -500,\n                            -length => 10,\n                            -relative => $rel);\n\tBio::Map::Position->new(-map => $map2,\n                            -element => $tf,\n                            -start => -250,\n                            -length => 10,\n                            -relative => $rel);\n\n\t# find out all the things that map near BRCA2 in all species\n\tforeach my $map ($gene->known_maps) {\n\t\tforeach my $thing ($map->get_elements) {\n            next if $thing eq $gene;\n            foreach my $pos ($thing->get_positions($map)) {\n                print \"In species \", $map->species, \", \",\n                      $thing->universal_name, \" maps at \", $pos->value,\n                      \" relative to \", $pos->relative->description, \" of gene \",\n                      $gene->universal_name, \"\\n\";\n            }\n\t\t}\n\t}\n    \n    # a GeneMap isa PrimarySeq and so can have sequence associated with it\n    $map1->seq('ATGC');\n    my $subseq = $map1->subseq(2,3); # TG\n\n=head1 DESCRIPTION\n\nModel the abstract notion of the area around a gene - you don't care exactly\nwhere this area is in the genome, you just want to be able to say \"something\nbinds upstream of gene X\" and \"something else binds 20bp upstream of the first\nsomething\" etc.\n\nIt's useful for modelling transcription factor bindings sites, letting you find\nout which transcription factors bind near a gene of interest, or which genes\nare bound by a transcription factor of interest.\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GeneMap;\nuse strict;\n\nuse Bio::Map::Gene;\nuse Bio::Map::Position;\n\nuse base qw(Bio::Map::SimpleMap Bio::PrimarySeq);\n\nour $GENEMAPS = {};\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::GeneMap->new();\n Function: Builds a new Bio::Map::GeneMap object (that has placed on it a\n           mappable element (Bio::Map::Gene) representing a gene).\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($uid, $gene, $species, $desc, $up, $down, $seq) = $self->_rearrange([qw(UID\n                                                    GENE\n                                                    SPECIES\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM\n                                                    SEQ)], @args);\n    \n    unless (defined $gene && defined $species) {\n        $self->throw(\"You must supply both -species and -gene\");\n    }\n    \n    $self->gene(-gene => $gene, -description => $desc, -upstream => $up, -downstream => $down);\n    $self->seq($seq) if $seq;\n    \n    unless (defined($uid)) {\n        # trigger the special behaviour in our unique_id method by supplying it\n        # the unique_id we got from our parent class\n        $self->unique_id($self->unique_id);\n    }\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $map = Bio::Map::GeneMap->get();\n Function: Builds a new Bio::Map::GeneMap object (like new()), or gets a\n           pre-existing one that corresponds to your arguements.\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n           If you supply a -uid, and a map had previously been created and\n           given that uid, that same map object will be returned. Otherwise, the\n           combination of -gene and -species will be used to determine\n           if the same map had previously been made. If a corresponding map\n           hadn't previously been made, a new map object will be created and\n           returned.\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($uid, $gene, $species, $desc, $up, $down, $seq) = Bio::Root::Root->_rearrange([qw(UID\n                                                    GENE\n                                                    SPECIES\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM\n                                                    SEQ)], @args);\n    \n    my $gene_map;\n    if ($uid && defined $GENEMAPS->{by_uid}->{$uid}) {\n        $gene_map = $GENEMAPS->{by_uid}->{$uid};\n    }\n    elsif ($gene && $species) {\n        my $name = ref($gene) ? $gene->universal_name : $gene;\n        if (defined $GENEMAPS->{by_ns}->{$name}->{$species}) {\n            $gene_map = $GENEMAPS->{by_ns}->{$name}->{$species};\n        }\n    }\n    if ($gene_map) {\n        $gene_map->gene->description($desc) if $desc;\n        $gene_map->upstream($up) if defined($up);\n        $gene_map->downstream($down) if defined($down);\n        $gene_map->seq($seq) if $seq;\n        return $gene_map;\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $map->unique_id;\n Function: Get/set the unique ID for this map\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub unique_id {\n    my ($self, $id) = @_;\n    if (defined $id) {\n        delete $GENEMAPS->{by_uid}->{$self->{'_uid'}};\n        $self->{'_uid'} = $id;\n        $GENEMAPS->{by_uid}->{$id} = $self;\n    }\n    return $self->{'_uid'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : my $species = $map->species;\n Function: Get/set Species for a map. It is not recommended to change this once\n           set.\n Returns : Bio::Taxon object or string\n Args    : none to get, OR Bio::Taxon or string to set\n\n\nsub species {\n    my ($self, $value) = @_;\n    if ($value) {\n        my $old_species = $self->{_species};\n        $self->{'_species'} = $value;\n        my $name = $self->universal_name || return $value;\n        if ($old_species) {\n            delete $GENEMAPS->{by_ns}->{$name}->{$old_species};\n        }\n        $GENEMAPS->{by_ns}->{$name}->{$value} = $self;\n    }\n    return $self->{'_species'};\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $map->type\n Function: Get Map type\n Returns : string 'gene'\n Args    : none\n\n\nsub type {\n    return 'gene';\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : my $gene = $map->gene;\n           $map->gene(-gene => $gene);\n Function: Get/set the mappable element on this map that represents the gene\n           this map is for. Once set, it is not recommended to re-set the gene\n           to something else. Behaviour in that case is undefined.\n Returns : Bio::Map::Gene\n Args    : none to get, OR to set:\n           -gene        => Bio::Map::Gene or string of the universal name (see\n                           Bio::Map::Gene docs), REQUIRED\n           -description => string, applied to the Bio::Map::Gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n\n\nsub gene {\n    my ($self, @args) = @_;\n    \n    if (@args > 0) {\n        my ($gene, $desc, $up, $down) = $self->_rearrange([qw(GENE\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM)], @args);\n        $self->throw(\"You must supply -gene\") unless $gene;\n        \n        my $gene_obj = ref($gene) ? $gene : Bio::Map::Gene->get(-universal_name => $gene, -description => $desc);\n        if (defined $self->{gene}) {\n            if ($self->{gene} ne $gene_obj) {\n                $self->warn(\"Changing the gene that this map is for, which could be bad\");\n                $self->purge_positions($self->{gene});\n                delete $GENEMAPS->{by_ns}->{$self->universal_name}->{$self->species};\n                $self->{gene} = $gene_obj;\n            }\n            \n            # change the gene's position on us if necessary\n            $self->upstream($up) if defined $up;\n            $self->downstream($down) if defined $down;\n        }\n        else {\n            # give the gene object a position on us\n            $up ||= 1000;\n            $up >= 0 || $self->throw(\"-upstream must be a positive integer\");\n            Bio::Map::Position->new(-map => $self, -start => ($up + 1), -element => $gene_obj);\n            $self->{gene} = $gene_obj;\n            $self->downstream($down || 0);\n            \n            # set other gene positions from db if already user-requested\n            $gene_obj->_set_from_db($self);\n        }\n        \n        $GENEMAPS->{by_ns}->{$self->universal_name}->{$self->species} = $self;\n    }\n    \n    return $self->{gene};\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $map->universal_name\n Function: Get/set the name of Bio::Map::Gene object associated with this map.\n           It is not recommended to change this once set.\n Returns : string\n Args    : none to get, OR string to set","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","kind":12,"children":[{"kind":13,"line":380,"containerName":"universal_name","definition":"my","name":"$self","localvar":"my"},{"name":"$value","containerName":"universal_name","kind":13,"line":380},{"kind":13,"line":381,"containerName":"universal_name","name":"$self"},{"containerName":"universal_name","name":"gene","line":381,"kind":12},{"containerName":"universal_name","name":"$value","kind":13,"line":382},{"kind":13,"line":383,"containerName":"universal_name","name":"$species","definition":"my","localvar":"my"},{"line":383,"kind":13,"containerName":"universal_name","name":"$self"},{"name":"species","containerName":"universal_name","line":383,"kind":12},{"containerName":"universal_name","name":"$GENEMAPS","kind":13,"line":384},{"line":384,"kind":13,"name":"$self","containerName":"universal_name"},{"containerName":"universal_name","name":"gene","line":384,"kind":12},{"line":384,"kind":12,"containerName":"universal_name","name":"universal_name"},{"kind":13,"line":384,"name":"$species","containerName":"universal_name"},{"kind":13,"line":385,"containerName":"universal_name","name":"$self"},{"name":"gene","containerName":"universal_name","kind":12,"line":385},{"name":"universal_name","containerName":"universal_name","line":385,"kind":12},{"kind":13,"line":385,"name":"$value","containerName":"universal_name"},{"kind":13,"line":386,"containerName":"universal_name","name":"$GENEMAPS"},{"containerName":"universal_name","name":"$value","line":386,"kind":13},{"line":386,"kind":13,"name":"$species","containerName":"universal_name"},{"containerName":"universal_name","name":"$self","kind":13,"line":386},{"kind":13,"line":388,"name":"$self","containerName":"universal_name"},{"line":388,"kind":12,"name":"gene","containerName":"universal_name"},{"containerName":"universal_name","name":"universal_name","kind":12,"line":388}],"line":379},{"name":"by_ns","kind":12,"line":384},{"name":"by_ns","kind":12,"line":386},{"name":"upstream","range":{"start":{"line":404,"character":0},"end":{"line":414,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"upstream($self,$value)","documentation":"1;\n# $Id: GeneMap.pm,v 1.17 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::GeneMap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GeneMap - A MapI implementation to represent the area around a gene\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GeneMap;\n    use Bio::Map::Gene;\n    use Bio::Map::TranscriptionFactor;\n    use Bio::Map::GeneRelative;\n\n\t# make some maps that will represent an area around a particular gene in\n\t# particular species (by default, the map represents the area in the genome\n    # 1000bp upstream of the gene)\n    my $map1 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'human',\n                                      -description => 'breast cancer 2, early onset');\n\tmy $map2 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'mouse');\n\n\t# model a TF that binds 500bp upstream of the BRCA2 gene in humans and\n\t# 250bp upstream of BRCA2 in mice\n\tmy $rel = Bio::Map::GeneRelative->new(-description => \"gene start\");\n    my $tf = Bio::Map::TranscriptionFactor->get(-universal_name => 'tf1');\n\tBio::Map::Position->new(-map => $map1,\n                            -element => $tf,\n                            -start => -500,\n                            -length => 10,\n                            -relative => $rel);\n\tBio::Map::Position->new(-map => $map2,\n                            -element => $tf,\n                            -start => -250,\n                            -length => 10,\n                            -relative => $rel);\n\n\t# find out all the things that map near BRCA2 in all species\n\tforeach my $map ($gene->known_maps) {\n\t\tforeach my $thing ($map->get_elements) {\n            next if $thing eq $gene;\n            foreach my $pos ($thing->get_positions($map)) {\n                print \"In species \", $map->species, \", \",\n                      $thing->universal_name, \" maps at \", $pos->value,\n                      \" relative to \", $pos->relative->description, \" of gene \",\n                      $gene->universal_name, \"\\n\";\n            }\n\t\t}\n\t}\n    \n    # a GeneMap isa PrimarySeq and so can have sequence associated with it\n    $map1->seq('ATGC');\n    my $subseq = $map1->subseq(2,3); # TG\n\n=head1 DESCRIPTION\n\nModel the abstract notion of the area around a gene - you don't care exactly\nwhere this area is in the genome, you just want to be able to say \"something\nbinds upstream of gene X\" and \"something else binds 20bp upstream of the first\nsomething\" etc.\n\nIt's useful for modelling transcription factor bindings sites, letting you find\nout which transcription factors bind near a gene of interest, or which genes\nare bound by a transcription factor of interest.\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GeneMap;\nuse strict;\n\nuse Bio::Map::Gene;\nuse Bio::Map::Position;\n\nuse base qw(Bio::Map::SimpleMap Bio::PrimarySeq);\n\nour $GENEMAPS = {};\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::GeneMap->new();\n Function: Builds a new Bio::Map::GeneMap object (that has placed on it a\n           mappable element (Bio::Map::Gene) representing a gene).\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($uid, $gene, $species, $desc, $up, $down, $seq) = $self->_rearrange([qw(UID\n                                                    GENE\n                                                    SPECIES\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM\n                                                    SEQ)], @args);\n    \n    unless (defined $gene && defined $species) {\n        $self->throw(\"You must supply both -species and -gene\");\n    }\n    \n    $self->gene(-gene => $gene, -description => $desc, -upstream => $up, -downstream => $down);\n    $self->seq($seq) if $seq;\n    \n    unless (defined($uid)) {\n        # trigger the special behaviour in our unique_id method by supplying it\n        # the unique_id we got from our parent class\n        $self->unique_id($self->unique_id);\n    }\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $map = Bio::Map::GeneMap->get();\n Function: Builds a new Bio::Map::GeneMap object (like new()), or gets a\n           pre-existing one that corresponds to your arguements.\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n           If you supply a -uid, and a map had previously been created and\n           given that uid, that same map object will be returned. Otherwise, the\n           combination of -gene and -species will be used to determine\n           if the same map had previously been made. If a corresponding map\n           hadn't previously been made, a new map object will be created and\n           returned.\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($uid, $gene, $species, $desc, $up, $down, $seq) = Bio::Root::Root->_rearrange([qw(UID\n                                                    GENE\n                                                    SPECIES\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM\n                                                    SEQ)], @args);\n    \n    my $gene_map;\n    if ($uid && defined $GENEMAPS->{by_uid}->{$uid}) {\n        $gene_map = $GENEMAPS->{by_uid}->{$uid};\n    }\n    elsif ($gene && $species) {\n        my $name = ref($gene) ? $gene->universal_name : $gene;\n        if (defined $GENEMAPS->{by_ns}->{$name}->{$species}) {\n            $gene_map = $GENEMAPS->{by_ns}->{$name}->{$species};\n        }\n    }\n    if ($gene_map) {\n        $gene_map->gene->description($desc) if $desc;\n        $gene_map->upstream($up) if defined($up);\n        $gene_map->downstream($down) if defined($down);\n        $gene_map->seq($seq) if $seq;\n        return $gene_map;\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $map->unique_id;\n Function: Get/set the unique ID for this map\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub unique_id {\n    my ($self, $id) = @_;\n    if (defined $id) {\n        delete $GENEMAPS->{by_uid}->{$self->{'_uid'}};\n        $self->{'_uid'} = $id;\n        $GENEMAPS->{by_uid}->{$id} = $self;\n    }\n    return $self->{'_uid'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : my $species = $map->species;\n Function: Get/set Species for a map. It is not recommended to change this once\n           set.\n Returns : Bio::Taxon object or string\n Args    : none to get, OR Bio::Taxon or string to set\n\n\nsub species {\n    my ($self, $value) = @_;\n    if ($value) {\n        my $old_species = $self->{_species};\n        $self->{'_species'} = $value;\n        my $name = $self->universal_name || return $value;\n        if ($old_species) {\n            delete $GENEMAPS->{by_ns}->{$name}->{$old_species};\n        }\n        $GENEMAPS->{by_ns}->{$name}->{$value} = $self;\n    }\n    return $self->{'_species'};\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $map->type\n Function: Get Map type\n Returns : string 'gene'\n Args    : none\n\n\nsub type {\n    return 'gene';\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : my $gene = $map->gene;\n           $map->gene(-gene => $gene);\n Function: Get/set the mappable element on this map that represents the gene\n           this map is for. Once set, it is not recommended to re-set the gene\n           to something else. Behaviour in that case is undefined.\n Returns : Bio::Map::Gene\n Args    : none to get, OR to set:\n           -gene        => Bio::Map::Gene or string of the universal name (see\n                           Bio::Map::Gene docs), REQUIRED\n           -description => string, applied to the Bio::Map::Gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n\n\nsub gene {\n    my ($self, @args) = @_;\n    \n    if (@args > 0) {\n        my ($gene, $desc, $up, $down) = $self->_rearrange([qw(GENE\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM)], @args);\n        $self->throw(\"You must supply -gene\") unless $gene;\n        \n        my $gene_obj = ref($gene) ? $gene : Bio::Map::Gene->get(-universal_name => $gene, -description => $desc);\n        if (defined $self->{gene}) {\n            if ($self->{gene} ne $gene_obj) {\n                $self->warn(\"Changing the gene that this map is for, which could be bad\");\n                $self->purge_positions($self->{gene});\n                delete $GENEMAPS->{by_ns}->{$self->universal_name}->{$self->species};\n                $self->{gene} = $gene_obj;\n            }\n            \n            # change the gene's position on us if necessary\n            $self->upstream($up) if defined $up;\n            $self->downstream($down) if defined $down;\n        }\n        else {\n            # give the gene object a position on us\n            $up ||= 1000;\n            $up >= 0 || $self->throw(\"-upstream must be a positive integer\");\n            Bio::Map::Position->new(-map => $self, -start => ($up + 1), -element => $gene_obj);\n            $self->{gene} = $gene_obj;\n            $self->downstream($down || 0);\n            \n            # set other gene positions from db if already user-requested\n            $gene_obj->_set_from_db($self);\n        }\n        \n        $GENEMAPS->{by_ns}->{$self->universal_name}->{$self->species} = $self;\n    }\n    \n    return $self->{gene};\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $map->universal_name\n Function: Get/set the name of Bio::Map::Gene object associated with this map.\n           It is not recommended to change this once set.\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub universal_name {\n    my ($self, $value) = @_;\n    $self->gene || return;\n    if ($value) {\n        my $species = $self->species;\n        delete $GENEMAPS->{by_ns}->{$self->gene->universal_name}->{$species};\n        $self->gene->universal_name($value);\n        $GENEMAPS->{by_ns}->{$value}->{$species} = $self;\n    }\n    return $self->gene->universal_name;\n}\n\n=head2 upstream\n\n Title   : upstream\n Usage   : my $distance = $map->upstream;\n           $map->upstream($distance);\n Function: Get/set how long the map is before the start of the Bio::Map::Gene\n           object on this map.\n Returns : int\n Args    : none to get, OR int to set (the number of bases the map extends\n           before the start of the gene)","parameters":[{"label":"$self"},{"label":"$value"}]},"kind":12,"line":404,"children":[{"localvar":"my","containerName":"upstream","name":"$self","definition":"my","line":405,"kind":13},{"kind":13,"line":405,"containerName":"upstream","name":"$value"},{"kind":13,"line":407,"definition":"my","name":"$pos","containerName":"upstream","localvar":"my"},{"line":407,"kind":13,"name":"$self","containerName":"upstream"},{"containerName":"upstream","name":"gene","line":407,"kind":12},{"containerName":"upstream","name":"position","kind":12,"line":407},{"name":"$self","containerName":"upstream","line":407,"kind":13},{"containerName":"upstream","name":"$value","line":408,"kind":13},{"containerName":"upstream","name":"$value","kind":13,"line":409},{"kind":13,"line":409,"name":"$self","containerName":"upstream"},{"kind":12,"line":409,"containerName":"upstream","name":"throw"},{"kind":13,"line":410,"name":"$pos","containerName":"upstream"},{"containerName":"upstream","name":"start","kind":12,"line":410},{"line":410,"kind":13,"containerName":"upstream","name":"$value"},{"line":413,"kind":13,"containerName":"upstream","name":"$pos"},{"kind":12,"line":413,"name":"start","containerName":"upstream"}]},{"range":{"end":{"character":9999,"line":433},"start":{"character":0,"line":429}},"containerName":"main::","name":"downstream","definition":"sub","line":429,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"downstream","line":430,"kind":13},{"containerName":"downstream","name":"$self","kind":13,"line":431},{"containerName":"downstream","name":"$self","kind":13,"line":432}],"kind":12},{"name":"_downstream","line":431,"kind":12},{"line":432,"kind":12,"name":"_downstream"},{"range":{"end":{"character":9999,"line":453},"start":{"line":448,"character":0}},"containerName":"main::","name":"length","definition":"sub","line":448,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"length","line":449,"kind":13},{"line":450,"kind":13,"localvar":"my","name":"$expected_length","definition":"my","containerName":"length"},{"name":"$self","containerName":"length","kind":13,"line":450},{"kind":12,"line":450,"name":"gene","containerName":"length"},{"name":"position","containerName":"length","line":450,"kind":12},{"containerName":"length","name":"$self","line":450,"kind":13},{"name":"length","containerName":"length","line":450,"kind":12},{"kind":13,"line":450,"containerName":"length","name":"$self"},{"kind":12,"line":450,"containerName":"length","name":"upstream"},{"line":450,"kind":13,"name":"$self","containerName":"length"},{"containerName":"length","name":"downstream","line":450,"kind":12},{"kind":13,"line":451,"containerName":"length","definition":"my","name":"$actual_length","localvar":"my"},{"containerName":"length","name":"$self","line":451,"kind":13},{"kind":13,"line":452,"name":"$actual_length","containerName":"length"},{"line":452,"kind":13,"name":"$expected_length","containerName":"length"},{"name":"$actual_length","containerName":"length","kind":13,"line":452},{"name":"$expected_length","containerName":"length","kind":13,"line":452}],"kind":12},{"line":452,"kind":12,"name":"SUPER","containerName":"length"},{"range":{"end":{"line":523,"character":9999},"start":{"character":0,"line":472}},"name":"seq","line":472,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"seq","line":473,"kind":13},{"containerName":"seq","name":"@args","line":473,"kind":13},{"containerName":"seq","name":"$seq","definition":"my","localvar":"my","kind":13,"line":474},{"containerName":"seq","name":"$self","line":474,"kind":13},{"kind":13,"line":474,"name":"@args","containerName":"seq"},{"localvar":"my","containerName":"seq","definition":"my","name":"$expected_length","line":475,"kind":13},{"kind":13,"line":475,"name":"$self","containerName":"seq"},{"containerName":"seq","name":"length","kind":12,"line":475},{"kind":13,"line":476,"containerName":"seq","name":"$seq"},{"containerName":"seq","name":"$seq","line":476,"kind":13},{"name":"$expected_length","containerName":"seq","line":476,"kind":13},{"containerName":"seq","definition":"my","name":"@have","localvar":"my","kind":13,"line":477},{"containerName":"seq","name":"$seq","kind":13,"line":477},{"localvar":"my","name":"@result","definition":"my","containerName":"seq","line":478,"kind":13},{"line":479,"kind":13,"name":"$expected_length","containerName":"seq"},{"kind":13,"line":480,"containerName":"seq","name":"$result"},{"containerName":"seq","name":"@have","kind":13,"line":480},{"kind":13,"line":484,"name":"@slice_stuff","definition":"my","containerName":"seq","localvar":"my"},{"kind":13,"line":484,"name":"$self","containerName":"seq"},{"name":"gene","containerName":"seq","kind":12,"line":484},{"kind":12,"line":484,"name":"_get_slice","containerName":"seq"},{"containerName":"seq","name":"$self","kind":13,"line":484},{"kind":13,"line":485,"name":"@slice_stuff","containerName":"seq"},{"line":486,"kind":13,"localvar":"my","containerName":"seq","name":"$slice_adaptor","definition":"my"},{"kind":13,"line":486,"containerName":"seq","name":"$slice"},{"name":"$strand","containerName":"seq","kind":13,"line":486},{"name":"@slice_stuff","containerName":"seq","kind":13,"line":486},{"containerName":"seq","definition":"my","name":"$start","localvar":"my","kind":13,"line":487},{"containerName":"seq","name":"$end","kind":13,"line":487},{"containerName":"seq","name":"$gene_start","line":487,"kind":13},{"containerName":"seq","name":"$seq","line":487,"kind":13},{"containerName":"seq","name":"$expected_length","line":487,"kind":13},{"line":487,"kind":13,"containerName":"seq","name":"$self"},{"name":"upstream","containerName":"seq","kind":12,"line":487},{"line":490,"kind":13,"localvar":"my","containerName":"seq","definition":"my","name":"$adjust"},{"containerName":"seq","name":"$strand","kind":13,"line":490},{"containerName":"seq","name":"$slice","line":490,"kind":13},{"containerName":"seq","name":"end","kind":12,"line":490},{"containerName":"seq","name":"$slice","line":490,"kind":13},{"containerName":"seq","name":"start","line":490,"kind":12},{"kind":13,"line":491,"definition":"my","name":"$adjustment","containerName":"seq","localvar":"my"},{"containerName":"seq","name":"$strand","kind":13,"line":491},{"kind":13,"line":491,"name":"$adjust","containerName":"seq"},{"containerName":"seq","name":"$adjust","kind":13,"line":491},{"line":492,"kind":13,"localvar":"my","definition":"my","name":"$converted_start","containerName":"seq"},{"kind":13,"line":492,"containerName":"seq","name":"$start"},{"name":"$gene_start","containerName":"seq","kind":13,"line":492},{"name":"$converted_end","definition":"my","containerName":"seq","localvar":"my","kind":13,"line":493},{"line":493,"kind":13,"containerName":"seq","name":"$end"},{"containerName":"seq","name":"$gene_start","kind":13,"line":493},{"line":494,"kind":13,"name":"$converted_start","containerName":"seq"},{"line":494,"kind":13,"containerName":"seq","name":"$converted_end"},{"containerName":"seq","name":"$converted_end","line":494,"kind":13},{"kind":13,"line":494,"name":"$converted_start","containerName":"seq"},{"kind":13,"line":494,"name":"$converted_start","containerName":"seq"},{"containerName":"seq","name":"$converted_end","line":494,"kind":13},{"kind":13,"line":498,"containerName":"seq","name":"$new_slice","definition":"my","localvar":"my"},{"containerName":"seq","name":"$slice_adaptor","kind":13,"line":498},{"name":"fetch_by_region","containerName":"seq","line":498,"kind":12},{"containerName":"seq","name":"$slice","line":498,"kind":13},{"containerName":"seq","name":"coord_system_name","line":498,"kind":12},{"line":498,"kind":13,"name":"$slice","containerName":"seq"},{"containerName":"seq","name":"seq_region_name","kind":12,"line":498},{"containerName":"seq","name":"$converted_start","kind":13,"line":498},{"line":498,"kind":13,"containerName":"seq","name":"$converted_end"},{"name":"$new_slice","containerName":"seq","line":499,"kind":13},{"localvar":"my","containerName":"seq","definition":"my","name":"$seq_str","line":499,"kind":13},{"kind":13,"line":499,"name":"$new_slice","containerName":"seq"},{"name":"seq","containerName":"seq","line":499,"kind":12},{"name":"$strand","containerName":"seq","kind":13,"line":500},{"line":501,"kind":13,"name":"$seq_str","containerName":"seq"},{"name":"$self","containerName":"seq","line":501,"kind":13},{"line":501,"kind":12,"name":"_revcom","containerName":"seq"},{"containerName":"seq","name":"$seq_str","line":501,"kind":13},{"name":"@result","containerName":"seq","line":503,"kind":13},{"name":"$seq","containerName":"seq","line":503,"kind":13},{"kind":13,"line":503,"name":"$seq_str","containerName":"seq"},{"kind":13,"line":503,"containerName":"seq","name":"$seq_str"},{"name":"$pos","definition":"my","containerName":"seq","localvar":"my","kind":13,"line":507},{"name":"$self","containerName":"seq","kind":13,"line":507},{"name":"get_positions","containerName":"seq","kind":12,"line":507},{"name":"$pos","containerName":"seq","line":508,"kind":13},{"kind":12,"line":508,"containerName":"seq","name":"can"},{"kind":13,"line":509,"containerName":"seq","definition":"my","name":"@pos_seq","localvar":"my"},{"kind":13,"line":509,"containerName":"seq","name":"$pos"},{"kind":12,"line":509,"containerName":"seq","name":"seq"},{"line":510,"kind":13,"localvar":"my","definition":"my","name":"$i","containerName":"seq"},{"containerName":"seq","name":"$pos","line":510,"kind":13},{"name":"start","containerName":"seq","kind":12,"line":510},{"line":510,"kind":13,"containerName":"seq","name":"$pos"},{"kind":12,"line":510,"containerName":"seq","name":"absolute_relative"},{"name":"$pos","containerName":"seq","line":510,"kind":13},{"containerName":"seq","name":"end","kind":12,"line":510},{"containerName":"seq","name":"$pos","kind":13,"line":510},{"name":"absolute_relative","containerName":"seq","line":510,"kind":12},{"name":"$i","containerName":"seq","kind":13,"line":511},{"kind":13,"line":512,"containerName":"seq","definition":"my","name":"$base","localvar":"my"},{"line":512,"kind":13,"containerName":"seq","name":"@pos_seq"},{"line":513,"kind":13,"containerName":"seq","name":"$result"},{"containerName":"seq","name":"$i","line":513,"kind":13},{"name":"$result","containerName":"seq","kind":13,"line":514},{"name":"$i","containerName":"seq","line":514,"kind":13},{"name":"$base","containerName":"seq","line":514,"kind":13},{"containerName":"seq","name":"$seq","line":520,"kind":13},{"containerName":"seq","name":"@result","kind":13,"line":520},{"containerName":"seq","name":"$seq","line":522,"kind":13}],"kind":12,"detail":"($self,@args)","signature":{"label":"seq($self,@args)","documentation":"1;\n# $Id: GeneMap.pm,v 1.17 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::GeneMap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GeneMap - A MapI implementation to represent the area around a gene\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GeneMap;\n    use Bio::Map::Gene;\n    use Bio::Map::TranscriptionFactor;\n    use Bio::Map::GeneRelative;\n\n\t# make some maps that will represent an area around a particular gene in\n\t# particular species (by default, the map represents the area in the genome\n    # 1000bp upstream of the gene)\n    my $map1 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'human',\n                                      -description => 'breast cancer 2, early onset');\n\tmy $map2 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'mouse');\n\n\t# model a TF that binds 500bp upstream of the BRCA2 gene in humans and\n\t# 250bp upstream of BRCA2 in mice\n\tmy $rel = Bio::Map::GeneRelative->new(-description => \"gene start\");\n    my $tf = Bio::Map::TranscriptionFactor->get(-universal_name => 'tf1');\n\tBio::Map::Position->new(-map => $map1,\n                            -element => $tf,\n                            -start => -500,\n                            -length => 10,\n                            -relative => $rel);\n\tBio::Map::Position->new(-map => $map2,\n                            -element => $tf,\n                            -start => -250,\n                            -length => 10,\n                            -relative => $rel);\n\n\t# find out all the things that map near BRCA2 in all species\n\tforeach my $map ($gene->known_maps) {\n\t\tforeach my $thing ($map->get_elements) {\n            next if $thing eq $gene;\n            foreach my $pos ($thing->get_positions($map)) {\n                print \"In species \", $map->species, \", \",\n                      $thing->universal_name, \" maps at \", $pos->value,\n                      \" relative to \", $pos->relative->description, \" of gene \",\n                      $gene->universal_name, \"\\n\";\n            }\n\t\t}\n\t}\n    \n    # a GeneMap isa PrimarySeq and so can have sequence associated with it\n    $map1->seq('ATGC');\n    my $subseq = $map1->subseq(2,3); # TG\n\n=head1 DESCRIPTION\n\nModel the abstract notion of the area around a gene - you don't care exactly\nwhere this area is in the genome, you just want to be able to say \"something\nbinds upstream of gene X\" and \"something else binds 20bp upstream of the first\nsomething\" etc.\n\nIt's useful for modelling transcription factor bindings sites, letting you find\nout which transcription factors bind near a gene of interest, or which genes\nare bound by a transcription factor of interest.\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GeneMap;\nuse strict;\n\nuse Bio::Map::Gene;\nuse Bio::Map::Position;\n\nuse base qw(Bio::Map::SimpleMap Bio::PrimarySeq);\n\nour $GENEMAPS = {};\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::GeneMap->new();\n Function: Builds a new Bio::Map::GeneMap object (that has placed on it a\n           mappable element (Bio::Map::Gene) representing a gene).\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($uid, $gene, $species, $desc, $up, $down, $seq) = $self->_rearrange([qw(UID\n                                                    GENE\n                                                    SPECIES\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM\n                                                    SEQ)], @args);\n    \n    unless (defined $gene && defined $species) {\n        $self->throw(\"You must supply both -species and -gene\");\n    }\n    \n    $self->gene(-gene => $gene, -description => $desc, -upstream => $up, -downstream => $down);\n    $self->seq($seq) if $seq;\n    \n    unless (defined($uid)) {\n        # trigger the special behaviour in our unique_id method by supplying it\n        # the unique_id we got from our parent class\n        $self->unique_id($self->unique_id);\n    }\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $map = Bio::Map::GeneMap->get();\n Function: Builds a new Bio::Map::GeneMap object (like new()), or gets a\n           pre-existing one that corresponds to your arguements.\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n           If you supply a -uid, and a map had previously been created and\n           given that uid, that same map object will be returned. Otherwise, the\n           combination of -gene and -species will be used to determine\n           if the same map had previously been made. If a corresponding map\n           hadn't previously been made, a new map object will be created and\n           returned.\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($uid, $gene, $species, $desc, $up, $down, $seq) = Bio::Root::Root->_rearrange([qw(UID\n                                                    GENE\n                                                    SPECIES\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM\n                                                    SEQ)], @args);\n    \n    my $gene_map;\n    if ($uid && defined $GENEMAPS->{by_uid}->{$uid}) {\n        $gene_map = $GENEMAPS->{by_uid}->{$uid};\n    }\n    elsif ($gene && $species) {\n        my $name = ref($gene) ? $gene->universal_name : $gene;\n        if (defined $GENEMAPS->{by_ns}->{$name}->{$species}) {\n            $gene_map = $GENEMAPS->{by_ns}->{$name}->{$species};\n        }\n    }\n    if ($gene_map) {\n        $gene_map->gene->description($desc) if $desc;\n        $gene_map->upstream($up) if defined($up);\n        $gene_map->downstream($down) if defined($down);\n        $gene_map->seq($seq) if $seq;\n        return $gene_map;\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $map->unique_id;\n Function: Get/set the unique ID for this map\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub unique_id {\n    my ($self, $id) = @_;\n    if (defined $id) {\n        delete $GENEMAPS->{by_uid}->{$self->{'_uid'}};\n        $self->{'_uid'} = $id;\n        $GENEMAPS->{by_uid}->{$id} = $self;\n    }\n    return $self->{'_uid'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : my $species = $map->species;\n Function: Get/set Species for a map. It is not recommended to change this once\n           set.\n Returns : Bio::Taxon object or string\n Args    : none to get, OR Bio::Taxon or string to set\n\n\nsub species {\n    my ($self, $value) = @_;\n    if ($value) {\n        my $old_species = $self->{_species};\n        $self->{'_species'} = $value;\n        my $name = $self->universal_name || return $value;\n        if ($old_species) {\n            delete $GENEMAPS->{by_ns}->{$name}->{$old_species};\n        }\n        $GENEMAPS->{by_ns}->{$name}->{$value} = $self;\n    }\n    return $self->{'_species'};\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $map->type\n Function: Get Map type\n Returns : string 'gene'\n Args    : none\n\n\nsub type {\n    return 'gene';\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : my $gene = $map->gene;\n           $map->gene(-gene => $gene);\n Function: Get/set the mappable element on this map that represents the gene\n           this map is for. Once set, it is not recommended to re-set the gene\n           to something else. Behaviour in that case is undefined.\n Returns : Bio::Map::Gene\n Args    : none to get, OR to set:\n           -gene        => Bio::Map::Gene or string of the universal name (see\n                           Bio::Map::Gene docs), REQUIRED\n           -description => string, applied to the Bio::Map::Gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n\n\nsub gene {\n    my ($self, @args) = @_;\n    \n    if (@args > 0) {\n        my ($gene, $desc, $up, $down) = $self->_rearrange([qw(GENE\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM)], @args);\n        $self->throw(\"You must supply -gene\") unless $gene;\n        \n        my $gene_obj = ref($gene) ? $gene : Bio::Map::Gene->get(-universal_name => $gene, -description => $desc);\n        if (defined $self->{gene}) {\n            if ($self->{gene} ne $gene_obj) {\n                $self->warn(\"Changing the gene that this map is for, which could be bad\");\n                $self->purge_positions($self->{gene});\n                delete $GENEMAPS->{by_ns}->{$self->universal_name}->{$self->species};\n                $self->{gene} = $gene_obj;\n            }\n            \n            # change the gene's position on us if necessary\n            $self->upstream($up) if defined $up;\n            $self->downstream($down) if defined $down;\n        }\n        else {\n            # give the gene object a position on us\n            $up ||= 1000;\n            $up >= 0 || $self->throw(\"-upstream must be a positive integer\");\n            Bio::Map::Position->new(-map => $self, -start => ($up + 1), -element => $gene_obj);\n            $self->{gene} = $gene_obj;\n            $self->downstream($down || 0);\n            \n            # set other gene positions from db if already user-requested\n            $gene_obj->_set_from_db($self);\n        }\n        \n        $GENEMAPS->{by_ns}->{$self->universal_name}->{$self->species} = $self;\n    }\n    \n    return $self->{gene};\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $map->universal_name\n Function: Get/set the name of Bio::Map::Gene object associated with this map.\n           It is not recommended to change this once set.\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub universal_name {\n    my ($self, $value) = @_;\n    $self->gene || return;\n    if ($value) {\n        my $species = $self->species;\n        delete $GENEMAPS->{by_ns}->{$self->gene->universal_name}->{$species};\n        $self->gene->universal_name($value);\n        $GENEMAPS->{by_ns}->{$value}->{$species} = $self;\n    }\n    return $self->gene->universal_name;\n}\n\n=head2 upstream\n\n Title   : upstream\n Usage   : my $distance = $map->upstream;\n           $map->upstream($distance);\n Function: Get/set how long the map is before the start of the Bio::Map::Gene\n           object on this map.\n Returns : int\n Args    : none to get, OR int to set (the number of bases the map extends\n           before the start of the gene)\n\n\nsub upstream {\n    my ($self, $value) = @_;\n    \n    my $pos = $self->gene->position($self);\n    if (defined($value)) {\n        $value >= 0 || $self->throw(\"Supplied value must be a positive integer\");\n        $pos->start($value + 1);\n    }\n    \n    return $pos->start - 1;\n}\n\n=head2 downstream\n\n Title   : downstream\n Usage   : my $distance = $map->downstream;\n           $map->downstream($distance);\n Function: Get/set the nominal end of the map relative to the end of the\n           Bio::Map::Gene object on this map.\n Returns : int\n Args    : none to get, OR int to set (the number of bases the map extends\n           beyond the end of the gene)\n\n\nsub downstream {\n    my $self = shift;\n    if (@_) { $self->{_downstream} = shift }\n    return $self->{_downstream} || 0;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $length = $map->length();\n Function: Retrieves the length of the map. This is normally the length of the\n           upstream region + length of the gene + length of the downstream\n           region, but may be longer if positions have been placed on the map\n           beyond the end of the nominal downstream region.\n Returns : int\n Args    : none\n\n\nsub length {\n\tmy $self = shift;\n\tmy $expected_length = $self->gene->position($self)->length + $self->upstream + $self->downstream;\n    my $actual_length = $self->SUPER::length;\n    return $actual_length > $expected_length ? $actual_length : $expected_length;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $string = $obj->seq()\n Function: Get/set the sequence as a string of letters. When getting, If the\n           GeneMap object didn't have sequence attached directly to it for the\n           region requested, the map's gene's database will be asked for the\n           sequence, and failing that, the map's gene's positions will be asked\n           for their sequences. Areas for which no sequence could be found will\n           be filled with Ns, unless no sequence was found anywhere, in which\n           case undef is returned.\n Returns : string\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).","parameters":[{"label":"$self"},{"label":"@args"}]},"containerName":"main::","definition":"sub"},{"line":474,"kind":12,"containerName":"seq","name":"SUPER"},{"line":476,"kind":12,"name":"CORE","containerName":"length"},{"name":"CORE","containerName":"length","line":487,"kind":12},{"name":"adjustment","kind":12,"line":492},{"kind":12,"line":493,"name":"adjustment"},{"kind":12,"line":503,"containerName":"length","name":"CORE"},{"line":503,"kind":12,"name":"CORE","containerName":"length"},{"range":{"start":{"line":547,"character":0},"end":{"character":9999,"line":568}},"name":"subseq","detail":"($self,$start,$end)","signature":{"documentation":"1;\n# $Id: GeneMap.pm,v 1.17 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::GeneMap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GeneMap - A MapI implementation to represent the area around a gene\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GeneMap;\n    use Bio::Map::Gene;\n    use Bio::Map::TranscriptionFactor;\n    use Bio::Map::GeneRelative;\n\n\t# make some maps that will represent an area around a particular gene in\n\t# particular species (by default, the map represents the area in the genome\n    # 1000bp upstream of the gene)\n    my $map1 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'human',\n                                      -description => 'breast cancer 2, early onset');\n\tmy $map2 = Bio::Map::GeneMap->get(-gene => 'BRCA2',\n                                      -species => 'mouse');\n\n\t# model a TF that binds 500bp upstream of the BRCA2 gene in humans and\n\t# 250bp upstream of BRCA2 in mice\n\tmy $rel = Bio::Map::GeneRelative->new(-description => \"gene start\");\n    my $tf = Bio::Map::TranscriptionFactor->get(-universal_name => 'tf1');\n\tBio::Map::Position->new(-map => $map1,\n                            -element => $tf,\n                            -start => -500,\n                            -length => 10,\n                            -relative => $rel);\n\tBio::Map::Position->new(-map => $map2,\n                            -element => $tf,\n                            -start => -250,\n                            -length => 10,\n                            -relative => $rel);\n\n\t# find out all the things that map near BRCA2 in all species\n\tforeach my $map ($gene->known_maps) {\n\t\tforeach my $thing ($map->get_elements) {\n            next if $thing eq $gene;\n            foreach my $pos ($thing->get_positions($map)) {\n                print \"In species \", $map->species, \", \",\n                      $thing->universal_name, \" maps at \", $pos->value,\n                      \" relative to \", $pos->relative->description, \" of gene \",\n                      $gene->universal_name, \"\\n\";\n            }\n\t\t}\n\t}\n    \n    # a GeneMap isa PrimarySeq and so can have sequence associated with it\n    $map1->seq('ATGC');\n    my $subseq = $map1->subseq(2,3); # TG\n\n=head1 DESCRIPTION\n\nModel the abstract notion of the area around a gene - you don't care exactly\nwhere this area is in the genome, you just want to be able to say \"something\nbinds upstream of gene X\" and \"something else binds 20bp upstream of the first\nsomething\" etc.\n\nIt's useful for modelling transcription factor bindings sites, letting you find\nout which transcription factors bind near a gene of interest, or which genes\nare bound by a transcription factor of interest.\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GeneMap;\nuse strict;\n\nuse Bio::Map::Gene;\nuse Bio::Map::Position;\n\nuse base qw(Bio::Map::SimpleMap Bio::PrimarySeq);\n\nour $GENEMAPS = {};\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::GeneMap->new();\n Function: Builds a new Bio::Map::GeneMap object (that has placed on it a\n           mappable element (Bio::Map::Gene) representing a gene).\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($uid, $gene, $species, $desc, $up, $down, $seq) = $self->_rearrange([qw(UID\n                                                    GENE\n                                                    SPECIES\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM\n                                                    SEQ)], @args);\n    \n    unless (defined $gene && defined $species) {\n        $self->throw(\"You must supply both -species and -gene\");\n    }\n    \n    $self->gene(-gene => $gene, -description => $desc, -upstream => $up, -downstream => $down);\n    $self->seq($seq) if $seq;\n    \n    unless (defined($uid)) {\n        # trigger the special behaviour in our unique_id method by supplying it\n        # the unique_id we got from our parent class\n        $self->unique_id($self->unique_id);\n    }\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $map = Bio::Map::GeneMap->get();\n Function: Builds a new Bio::Map::GeneMap object (like new()), or gets a\n           pre-existing one that corresponds to your arguements.\n Returns : Bio::Map::GeneMap\n Args    : -gene        => string name of the gene this map will be for\n                           (in a form common to all species that have the gene,\n                           but unique amongst non-orthologous genes) or a\n                           Bio::Map::Gene object, REQUIRED\n           -species     => Bio::Taxon or string representing species, REQUIRED\n           -uid         => string, unique identifier for this map (must be\n                           unique amongst all gene/species combinations)\n           -description => string, free text description of the gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n           -seq         => string, the sequence of the map, presumably the\n                           genomic sequence -upstream bases of the gene,\n                           including the gene, and -downstream bases of the gene\n\n           If you supply a -uid, and a map had previously been created and\n           given that uid, that same map object will be returned. Otherwise, the\n           combination of -gene and -species will be used to determine\n           if the same map had previously been made. If a corresponding map\n           hadn't previously been made, a new map object will be created and\n           returned.\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($uid, $gene, $species, $desc, $up, $down, $seq) = Bio::Root::Root->_rearrange([qw(UID\n                                                    GENE\n                                                    SPECIES\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM\n                                                    SEQ)], @args);\n    \n    my $gene_map;\n    if ($uid && defined $GENEMAPS->{by_uid}->{$uid}) {\n        $gene_map = $GENEMAPS->{by_uid}->{$uid};\n    }\n    elsif ($gene && $species) {\n        my $name = ref($gene) ? $gene->universal_name : $gene;\n        if (defined $GENEMAPS->{by_ns}->{$name}->{$species}) {\n            $gene_map = $GENEMAPS->{by_ns}->{$name}->{$species};\n        }\n    }\n    if ($gene_map) {\n        $gene_map->gene->description($desc) if $desc;\n        $gene_map->upstream($up) if defined($up);\n        $gene_map->downstream($down) if defined($down);\n        $gene_map->seq($seq) if $seq;\n        return $gene_map;\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $map->unique_id;\n Function: Get/set the unique ID for this map\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub unique_id {\n    my ($self, $id) = @_;\n    if (defined $id) {\n        delete $GENEMAPS->{by_uid}->{$self->{'_uid'}};\n        $self->{'_uid'} = $id;\n        $GENEMAPS->{by_uid}->{$id} = $self;\n    }\n    return $self->{'_uid'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : my $species = $map->species;\n Function: Get/set Species for a map. It is not recommended to change this once\n           set.\n Returns : Bio::Taxon object or string\n Args    : none to get, OR Bio::Taxon or string to set\n\n\nsub species {\n    my ($self, $value) = @_;\n    if ($value) {\n        my $old_species = $self->{_species};\n        $self->{'_species'} = $value;\n        my $name = $self->universal_name || return $value;\n        if ($old_species) {\n            delete $GENEMAPS->{by_ns}->{$name}->{$old_species};\n        }\n        $GENEMAPS->{by_ns}->{$name}->{$value} = $self;\n    }\n    return $self->{'_species'};\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $map->type\n Function: Get Map type\n Returns : string 'gene'\n Args    : none\n\n\nsub type {\n    return 'gene';\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : my $gene = $map->gene;\n           $map->gene(-gene => $gene);\n Function: Get/set the mappable element on this map that represents the gene\n           this map is for. Once set, it is not recommended to re-set the gene\n           to something else. Behaviour in that case is undefined.\n Returns : Bio::Map::Gene\n Args    : none to get, OR to set:\n           -gene        => Bio::Map::Gene or string of the universal name (see\n                           Bio::Map::Gene docs), REQUIRED\n           -description => string, applied to the Bio::Map::Gene\n           -upstream    => int, the number of bases the map extends before the\n                           start of the gene element (default 1000).\n           -downstream  => int, the number of bases the map extends beyond the\n                           end of the gene element (default 0).\n\n\nsub gene {\n    my ($self, @args) = @_;\n    \n    if (@args > 0) {\n        my ($gene, $desc, $up, $down) = $self->_rearrange([qw(GENE\n                                                    DESCRIPTION\n                                                    UPSTREAM\n                                                    DOWNSTREAM)], @args);\n        $self->throw(\"You must supply -gene\") unless $gene;\n        \n        my $gene_obj = ref($gene) ? $gene : Bio::Map::Gene->get(-universal_name => $gene, -description => $desc);\n        if (defined $self->{gene}) {\n            if ($self->{gene} ne $gene_obj) {\n                $self->warn(\"Changing the gene that this map is for, which could be bad\");\n                $self->purge_positions($self->{gene});\n                delete $GENEMAPS->{by_ns}->{$self->universal_name}->{$self->species};\n                $self->{gene} = $gene_obj;\n            }\n            \n            # change the gene's position on us if necessary\n            $self->upstream($up) if defined $up;\n            $self->downstream($down) if defined $down;\n        }\n        else {\n            # give the gene object a position on us\n            $up ||= 1000;\n            $up >= 0 || $self->throw(\"-upstream must be a positive integer\");\n            Bio::Map::Position->new(-map => $self, -start => ($up + 1), -element => $gene_obj);\n            $self->{gene} = $gene_obj;\n            $self->downstream($down || 0);\n            \n            # set other gene positions from db if already user-requested\n            $gene_obj->_set_from_db($self);\n        }\n        \n        $GENEMAPS->{by_ns}->{$self->universal_name}->{$self->species} = $self;\n    }\n    \n    return $self->{gene};\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $map->universal_name\n Function: Get/set the name of Bio::Map::Gene object associated with this map.\n           It is not recommended to change this once set.\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub universal_name {\n    my ($self, $value) = @_;\n    $self->gene || return;\n    if ($value) {\n        my $species = $self->species;\n        delete $GENEMAPS->{by_ns}->{$self->gene->universal_name}->{$species};\n        $self->gene->universal_name($value);\n        $GENEMAPS->{by_ns}->{$value}->{$species} = $self;\n    }\n    return $self->gene->universal_name;\n}\n\n=head2 upstream\n\n Title   : upstream\n Usage   : my $distance = $map->upstream;\n           $map->upstream($distance);\n Function: Get/set how long the map is before the start of the Bio::Map::Gene\n           object on this map.\n Returns : int\n Args    : none to get, OR int to set (the number of bases the map extends\n           before the start of the gene)\n\n\nsub upstream {\n    my ($self, $value) = @_;\n    \n    my $pos = $self->gene->position($self);\n    if (defined($value)) {\n        $value >= 0 || $self->throw(\"Supplied value must be a positive integer\");\n        $pos->start($value + 1);\n    }\n    \n    return $pos->start - 1;\n}\n\n=head2 downstream\n\n Title   : downstream\n Usage   : my $distance = $map->downstream;\n           $map->downstream($distance);\n Function: Get/set the nominal end of the map relative to the end of the\n           Bio::Map::Gene object on this map.\n Returns : int\n Args    : none to get, OR int to set (the number of bases the map extends\n           beyond the end of the gene)\n\n\nsub downstream {\n    my $self = shift;\n    if (@_) { $self->{_downstream} = shift }\n    return $self->{_downstream} || 0;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $length = $map->length();\n Function: Retrieves the length of the map. This is normally the length of the\n           upstream region + length of the gene + length of the downstream\n           region, but may be longer if positions have been placed on the map\n           beyond the end of the nominal downstream region.\n Returns : int\n Args    : none\n\n\nsub length {\n\tmy $self = shift;\n\tmy $expected_length = $self->gene->position($self)->length + $self->upstream + $self->downstream;\n    my $actual_length = $self->SUPER::length;\n    return $actual_length > $expected_length ? $actual_length : $expected_length;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $string = $obj->seq()\n Function: Get/set the sequence as a string of letters. When getting, If the\n           GeneMap object didn't have sequence attached directly to it for the\n           region requested, the map's gene's database will be asked for the\n           sequence, and failing that, the map's gene's positions will be asked\n           for their sequences. Areas for which no sequence could be found will\n           be filled with Ns, unless no sequence was found anywhere, in which\n           case undef is returned.\n Returns : string\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n\n\nsub seq {\n    my ($self, @args) = @_;\n    my $seq = $self->SUPER::seq(@args);\n    my $expected_length = $self->length;\n    if (! $seq || CORE::length($seq) < $expected_length) {\n        my @have = split('', $seq || '');\n        my @result;\n        for (0..($expected_length - 1)) {\n            $result[$_] = shift(@have) || 'N';\n        }\n        \n        # build map sequence by asking gene or positions\n        my @slice_stuff = $self->gene->_get_slice($self);\n        if (@slice_stuff) {\n            my ($slice_adaptor, $slice, $strand) = @slice_stuff;\n            my ($start, $end, $gene_start) = (CORE::length($seq || '') + 1, $expected_length, $self->upstream + 1);\n            \n            # convert map coords to genomic coords\n            my $adjust = $strand == -1 ? $slice->end : $slice->start;\n            my $adjustment = sub { return $strand == -1 ? $adjust - shift() : shift() + $adjust; };\n            my $converted_start = &$adjustment($start - $gene_start);\n            my $converted_end = &$adjustment($end - $gene_start);\n            ($converted_start, $converted_end) = ($converted_end, $converted_start) if $converted_start > $converted_end;\n            \n            # get sequence from a new slice of desired region\n            #*** what happens if desired region starts or ends off end of chromo?...\n            my $new_slice = $slice_adaptor->fetch_by_region($slice->coord_system_name, $slice->seq_region_name, $converted_start, $converted_end);\n            if ($new_slice && (my $seq_str = $new_slice->seq)) {\n                if ($strand == -1) {\n                    $seq_str = $self->_revcom($seq_str);\n                }\n                splice(@result, CORE::length($seq || ''), CORE::length($seq_str), split('', $seq_str));\n            }\n        }\n        else {\n            foreach my $pos ($self->get_positions) {\n                next unless $pos->can('seq');\n                my @pos_seq = split('', $pos->seq(undef, undef, 1) || next);\n                for my $i ($pos->start($pos->absolute_relative)..$pos->end($pos->absolute_relative)) {\n                    $i--;\n                    my $base = shift(@pos_seq);\n                    if ($result[$i] eq 'N') {\n                        $result[$i] = $base;\n                    }\n                }\n            }\n        }\n        \n        $seq = join('', @result);\n    }\n    return $seq;\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10, 40);\n Function: Returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence. If the GeneMap object didn't have sequence\n           attached directly to it for the region requested, the map's gene's\n           database will be asked for the sequence, and failing that, the map's\n           gene's positions will be asked for their sequences. Areas for which\n           no sequence could be found will be filled with Ns, unless no\n           sequence was found anywhere, in which case undef is returned. subseq\n           requests that extend beyond the end of the map will throw.\n Returns : string\n Args    : integer for start position AND integer for end position\n                 OR\n           Bio::LocationI location for subseq (strand honored)\n                 OR\n           Bio::RangeI (eg. a Bio::Map::PositionI)","parameters":[{"label":"$self"},{"label":"$start"},{"label":"$end"}],"label":"subseq($self,$start,$end)"},"containerName":"main::","definition":"sub","line":547,"children":[{"definition":"my","name":"$self","containerName":"subseq","localvar":"my","kind":13,"line":548},{"kind":13,"line":548,"name":"$start","containerName":"subseq"},{"containerName":"subseq","name":"$end","kind":13,"line":548},{"line":550,"kind":13,"name":"$start","containerName":"subseq"},{"line":550,"kind":13,"containerName":"subseq","name":"$start"},{"name":"$start","containerName":"subseq","kind":13,"line":550},{"kind":12,"line":550,"name":"isa","containerName":"subseq"},{"localvar":"my","containerName":"subseq","definition":"my","name":"$thing","line":551,"kind":13},{"line":551,"kind":13,"containerName":"subseq","name":"$start"},{"kind":13,"line":552,"name":"$start","containerName":"subseq"},{"containerName":"subseq","name":"isa","kind":12,"line":552},{"containerName":"subseq","name":"$start","kind":13,"line":553},{"name":"$end","containerName":"subseq","kind":13,"line":553},{"containerName":"subseq","name":"$thing","line":553,"kind":13},{"kind":12,"line":553,"name":"start","containerName":"subseq"},{"line":553,"kind":13,"containerName":"subseq","name":"$thing"},{"name":"absolute_relative","containerName":"subseq","line":553,"kind":12},{"containerName":"subseq","name":"$thing","line":553,"kind":13},{"line":553,"kind":12,"containerName":"subseq","name":"end"},{"containerName":"subseq","name":"$thing","kind":13,"line":553},{"kind":12,"line":553,"containerName":"subseq","name":"absolute_relative"},{"kind":13,"line":556,"containerName":"subseq","name":"$start"},{"containerName":"subseq","name":"$end","kind":13,"line":556},{"name":"$thing","containerName":"subseq","line":556,"kind":13},{"name":"start","containerName":"subseq","line":556,"kind":12},{"line":556,"kind":13,"containerName":"subseq","name":"$thing"},{"name":"end","containerName":"subseq","line":556,"kind":12},{"kind":13,"line":562,"name":"$orig_seq","definition":"my","containerName":"subseq","localvar":"my"},{"name":"$self","containerName":"subseq","line":562,"kind":13},{"line":563,"kind":13,"containerName":"subseq","name":"$self"},{"name":"$self","containerName":"subseq","line":563,"kind":13},{"kind":12,"line":563,"containerName":"subseq","name":"seq"},{"kind":13,"line":564,"definition":"my","name":"$subseq","containerName":"subseq","localvar":"my"},{"line":564,"kind":13,"name":"$self","containerName":"subseq"},{"containerName":"subseq","name":"$self","kind":13,"line":564},{"name":"$start","containerName":"subseq","kind":13,"line":564},{"containerName":"subseq","name":"$end","kind":13,"line":564},{"containerName":"subseq","name":"$self","line":565,"kind":13},{"line":565,"kind":13,"containerName":"subseq","name":"$orig_seq"},{"containerName":"subseq","name":"$subseq","line":567,"kind":13}],"kind":12},{"line":562,"kind":12,"name":"seq"},{"line":563,"kind":12,"name":"seq"},{"kind":12,"line":564,"name":"seq"},{"name":"SUPER","containerName":"subseq","kind":12,"line":564},{"kind":12,"line":565,"name":"seq"},{"detail":"($self,$seq)","signature":{"label":"_revcom($self,$seq)","parameters":[{"label":"$self"},{"label":"$seq"}],"documentation":" quick revcom for strings (silly to create a PrimarySeq just to revcom and then\n return a string again)"},"containerName":"main::","definition":"sub","line":572,"children":[{"name":"$self","definition":"my","containerName":"_revcom","localvar":"my","kind":13,"line":573},{"line":573,"kind":13,"name":"$seq","containerName":"_revcom"},{"containerName":"_revcom","name":"$seq","kind":13,"line":574},{"name":"$seq","containerName":"_revcom","kind":13,"line":575},{"line":575,"kind":13,"name":"$seq","containerName":"_revcom"},{"kind":13,"line":576,"name":"$seq","containerName":"_revcom"},{"line":577,"kind":13,"containerName":"_revcom","name":"$seq"}],"kind":12,"range":{"end":{"character":9999,"line":578},"start":{"character":0,"line":572}},"name":"_revcom"}]}