{"vars":[{"containerName":"main::","definition":"our","name":"@CORBALOCATIONOPERATOR","kind":13,"line":97},{"kind":2,"line":97,"definition":1,"name":"Bio::Location::Split"},{"containerName":"","name":"base","line":101,"kind":2},{"name":"new","range":{"start":{"character":0,"line":103},"end":{"line":120,"character":9999}},"kind":12,"children":[{"kind":13,"line":104,"name":"$class","definition":"my","containerName":"new","localvar":"my"},{"line":104,"kind":13,"name":"@args","containerName":"new"},{"line":105,"kind":13,"localvar":"my","containerName":"new","name":"$self","definition":"my"},{"containerName":"new","name":"$class","line":105,"kind":13},{"line":105,"kind":13,"name":"@args","containerName":"new"},{"containerName":"new","name":"$self","line":107,"kind":13},{"line":108,"kind":13,"localvar":"my","definition":"my","name":"$type","containerName":"new"},{"containerName":"new","name":"$seqid","line":108,"kind":13},{"name":"$locations","containerName":"new","kind":13,"line":108},{"name":"$self","containerName":"new","line":109,"kind":13},{"containerName":"new","name":"_rearrange","kind":12,"line":109},{"containerName":"new","name":"@args","line":112,"kind":13},{"kind":13,"line":113,"containerName":"new","name":"$locations"},{"containerName":"new","name":"$locations","kind":13,"line":113},{"containerName":"new","name":"$self","line":114,"kind":13},{"kind":12,"line":114,"name":"add_sub_Location","containerName":"new"},{"name":"$locations","containerName":"new","kind":13,"line":114},{"kind":13,"line":116,"name":"$seqid","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":116},{"kind":12,"line":116,"name":"seq_id","containerName":"new"},{"containerName":"new","name":"$seqid","kind":13,"line":116},{"containerName":"new","name":"$type","line":117,"kind":13},{"name":"$type","containerName":"new","line":117,"kind":13},{"containerName":"new","name":"$self","line":118,"kind":13},{"kind":12,"line":118,"name":"splittype","containerName":"new"},{"line":118,"kind":13,"name":"$type","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":119}],"line":103,"definition":"sub","containerName":"Bio::Location::Split","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"","label":"new($class,@args)"},"detail":"($class,@args)"},{"name":"SUPER","containerName":"new","line":105,"kind":12},{"kind":12,"line":135,"children":[{"line":136,"kind":13,"localvar":"my","containerName":"each_Location","definition":"my","name":"$self"},{"kind":13,"line":136,"name":"$order","containerName":"each_Location"},{"localvar":"my","containerName":"each_Location","name":"@locs","definition":"my","line":137,"kind":13},{"localvar":"my","containerName":"each_Location","name":"$subloc","definition":"my","line":138,"kind":13},{"kind":13,"line":138,"name":"$self","containerName":"each_Location"},{"containerName":"each_Location","name":"sub_Location","kind":12,"line":138},{"kind":13,"line":138,"containerName":"each_Location","name":"$order"},{"kind":13,"line":140,"containerName":"each_Location","name":"@locs"},{"kind":13,"line":140,"name":"$subloc","containerName":"each_Location"},{"kind":12,"line":140,"name":"each_Location","containerName":"each_Location"},{"kind":13,"line":140,"name":"$order","containerName":"each_Location"},{"containerName":"each_Location","name":"@locs","line":142,"kind":13}],"containerName":"Bio::Location::Split","definition":"sub","detail":"($self,$order)","signature":{"label":"each_Location($self,$order)","documentation":"1;\n# $Id: Split.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Split\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Split - Implementation of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Split;\n\n    my $splitlocation = Bio::Location::Split->new();\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>1,\n\t\t\t\t\t\t\t       -end=>30,\n\t\t\t\t\t\t\t       -strand=>1));\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>50,\n\t\t\t\t\t\t\t       -end=>61,\n\t\t\t\t\t\t\t       -strand=>1));   \n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start } \n\t\t\t   @sublocs ) {\n\tprintf \"sub feature %d [%d..%d]\\n\", \n\t       $count, $location->start,$location->end, \"\\n\";\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis implementation handles locations which span more than one\nstart/end location, or and/or lie on different sequences, and can\nwork with split locations that depend on the specific order of the\nsublocations ('join') or don't have a specific order but represent\na feature spanning discontiguous sublocations ('order', 'bond').\n\nNote that the order in which sublocations are added may be very important,\ndepending on the specific split location type.  For instance, a 'join'\nmust have the sublocations added in the order that one expects to\njoin the sublocations, whereas all other types are sorted based on the\nsequence location.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl_DOT_org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Split;\n\n# as defined by BSANE 0.03\nour @CORBALOCATIONOPERATOR = ('NONE','JOIN', undef, 'ORDER');;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Location::Atomic Bio::Location::SplitLocationI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    # initialize\n    $self->{'_sublocations'} = [];\n    my ( $type, $seqid, $locations ) = \n\t$self->_rearrange([qw(SPLITTYPE\n                              SEQ_ID\n\t\t\t      LOCATIONS\n                              )], @args);\n    if( defined $locations && ref($locations) =~ /array/i ) {\n\t$self->add_sub_Location(@$locations);\n    }\n    $seqid  && $self->seq_id($seqid);\n    $type = lc ($type);    \n    $self->splittype($type || 'JOIN');\n    return $self;\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location()","parameters":[{"label":"$self"},{"label":"$order"}]},"name":"each_Location","range":{"start":{"character":0,"line":135},"end":{"character":9999,"line":143}}},{"name":"sub_Location","range":{"end":{"character":9999,"line":172},"start":{"character":0,"line":164}},"definition":"sub","containerName":"Bio::Location::Split","signature":{"parameters":[{"label":"$self"},{"label":"$order"}],"documentation":"1;\n# $Id: Split.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Split\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Split - Implementation of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Split;\n\n    my $splitlocation = Bio::Location::Split->new();\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>1,\n\t\t\t\t\t\t\t       -end=>30,\n\t\t\t\t\t\t\t       -strand=>1));\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>50,\n\t\t\t\t\t\t\t       -end=>61,\n\t\t\t\t\t\t\t       -strand=>1));   \n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start } \n\t\t\t   @sublocs ) {\n\tprintf \"sub feature %d [%d..%d]\\n\", \n\t       $count, $location->start,$location->end, \"\\n\";\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis implementation handles locations which span more than one\nstart/end location, or and/or lie on different sequences, and can\nwork with split locations that depend on the specific order of the\nsublocations ('join') or don't have a specific order but represent\na feature spanning discontiguous sublocations ('order', 'bond').\n\nNote that the order in which sublocations are added may be very important,\ndepending on the specific split location type.  For instance, a 'join'\nmust have the sublocations added in the order that one expects to\njoin the sublocations, whereas all other types are sorted based on the\nsequence location.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl_DOT_org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Split;\n\n# as defined by BSANE 0.03\nour @CORBALOCATIONOPERATOR = ('NONE','JOIN', undef, 'ORDER');;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Location::Atomic Bio::Location::SplitLocationI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    # initialize\n    $self->{'_sublocations'} = [];\n    my ( $type, $seqid, $locations ) = \n\t$self->_rearrange([qw(SPLITTYPE\n                              SEQ_ID\n\t\t\t      LOCATIONS\n                              )], @args);\n    if( defined $locations && ref($locations) =~ /array/i ) {\n\t$self->add_sub_Location(@$locations);\n    }\n    $seqid  && $self->seq_id($seqid);\n    $type = lc ($type);    \n    $self->splittype($type || 'JOIN');\n    return $self;\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location()\n\n\nsub each_Location {\n    my ($self, $order) = @_;\n    my @locs = ();\n    foreach my $subloc ($self->sub_Location($order)) {\n\t# Recursively check to get hierarchical split locations:\n\tpush @locs, $subloc->each_Location($order);\n    }\n    return @locs;\n}\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @sublocs = $splitloc->sub_Location();\n Function: Returns the array of sublocations making up this compound (split)\n           location. Those sublocations referring to the same sequence as\n           the root split location will be sorted by start position (forward\n           sort) or end position (reverse sort) and come first (before\n           those on other sequences).\n\n           The sort order can be optionally specified or suppressed by the\n           value of the first argument. The default is no sort.\n\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optionally 1, 0, or -1 for specifying a forward, no, or reverse\n           sort order","label":"sub_Location($self,$order)"},"detail":"($self,$order)","kind":12,"children":[{"line":165,"kind":13,"localvar":"my","containerName":"sub_Location","definition":"my","name":"$self"},{"line":165,"kind":13,"containerName":"sub_Location","name":"$order"},{"kind":13,"line":166,"containerName":"sub_Location","name":"$order"},{"kind":13,"line":166,"name":"$order","containerName":"sub_Location"},{"line":167,"kind":13,"name":"$order","containerName":"sub_Location"},{"containerName":"sub_Location","name":"$order","kind":13,"line":167},{"name":"$self","containerName":"sub_Location","line":168,"kind":13},{"line":168,"kind":12,"name":"throw","containerName":"sub_Location"},{"name":"$order","containerName":"sub_Location","kind":13,"line":170},{"kind":13,"line":170,"containerName":"sub_Location","name":"$order"},{"containerName":"sub_Location","name":"$order","line":171,"kind":13},{"name":"$order","containerName":"sub_Location","kind":13,"line":171},{"kind":13,"line":172,"name":"@sublocs","definition":"my","containerName":"sub_Location","localvar":"my"},{"kind":13,"line":172,"containerName":"sub_Location","name":"$self"},{"containerName":"sub_Location","name":"$self","line":172,"kind":13}],"line":164},{"containerName":null,"name":"@sublocs","line":175,"kind":13},{"line":175,"kind":13,"containerName":null,"name":"$order"},{"line":175,"kind":13,"containerName":null,"name":"@sublocs"},{"definition":"my","name":"$seqid","containerName":null,"localvar":"my","kind":13,"line":179},{"name":"$self","containerName":null,"line":179,"kind":13},{"name":"seq_id","containerName":"Bio::Location::Split","kind":12,"line":179},{"kind":13,"line":180,"name":"$i","definition":"my","containerName":null,"localvar":"my"},{"name":"$seqid","containerName":null,"kind":13,"line":181},{"containerName":null,"name":"$i","line":181,"kind":13},{"kind":12,"line":181,"name":"sublocs"},{"line":182,"kind":13,"containerName":null,"name":"$seqid"},{"kind":13,"line":182,"containerName":null,"name":"@sublocs"},{"name":"$i","containerName":null,"line":182,"kind":13},{"kind":12,"line":182,"containerName":"Bio::Location::Split","name":"seq_id"},{"name":"$self","containerName":null,"line":184,"kind":13},{"line":184,"kind":12,"containerName":"Bio::Location::Split","name":"seq_id"},{"name":"%seqid","containerName":null,"line":184,"kind":13},{"line":185,"kind":13,"name":"$self","containerName":null},{"containerName":"Bio::Location::Split","name":"warn","kind":12,"line":185},{"localvar":"my","name":"@locs","definition":"my","containerName":null,"line":189,"kind":13},{"containerName":null,"name":"%seqid","line":189,"kind":13},{"containerName":"Bio::Location::Split","name":"seq_id","kind":12,"line":190},{"kind":13,"line":190,"containerName":null,"name":"$seqid"},{"kind":13,"line":190,"containerName":null,"name":"@sublocs"},{"kind":13,"line":191,"name":"@sublocs","containerName":null},{"line":192,"kind":13,"containerName":null,"name":"@locs"},{"containerName":null,"name":"%order","kind":13,"line":193},{"name":"@locs","containerName":null,"kind":13,"line":195},{"containerName":null,"name":"$a","line":197,"kind":13},{"kind":13,"line":197,"containerName":null,"name":"$b"},{"kind":13,"line":197,"name":"@a","containerName":null},{"kind":13,"line":197,"containerName":null,"name":"@b"},{"name":"%a","containerName":null,"line":198,"kind":13},{"kind":12,"line":201,"containerName":"Bio::Location::Split","name":"start"},{"line":201,"kind":12,"containerName":"Bio::Location::Split","name":"start"},{"line":201,"kind":12,"name":"end","containerName":"Bio::Location::Split"},{"kind":13,"line":202,"name":"@locs","containerName":null},{"line":204,"kind":13,"name":"@locs","containerName":null},{"containerName":null,"name":"$a","kind":13,"line":206},{"line":206,"kind":13,"containerName":null,"name":"$b"},{"line":206,"kind":13,"name":"@b","containerName":null},{"kind":13,"line":206,"name":"@a","containerName":null},{"containerName":null,"name":"%a","line":207,"kind":13},{"name":"end","containerName":"Bio::Location::Split","kind":12,"line":210},{"containerName":"Bio::Location::Split","name":"end","kind":12,"line":210},{"line":210,"kind":12,"name":"start","containerName":"Bio::Location::Split"},{"containerName":null,"name":"@locs","kind":13,"line":211},{"name":"%seqid","containerName":null,"kind":13,"line":215},{"name":"@locs","containerName":null,"line":216,"kind":13},{"containerName":"Bio::Location::Split","name":"seq_id","kind":12,"line":216},{"line":216,"kind":13,"containerName":null,"name":"$seqid"},{"name":"@sublocs","containerName":null,"kind":13,"line":216},{"containerName":null,"name":"@locs","line":220,"kind":13},{"kind":12,"line":233,"children":[{"localvar":"my","containerName":"add_sub_Location","definition":"my","name":"$self","line":234,"kind":13},{"name":"@args","containerName":"add_sub_Location","line":234,"kind":13},{"localvar":"my","containerName":"add_sub_Location","definition":"my","name":"@locs","line":235,"kind":13},{"line":236,"kind":13,"localvar":"my","containerName":"add_sub_Location","name":"$loc","definition":"my"},{"line":236,"kind":13,"containerName":"add_sub_Location","name":"@args"},{"line":237,"kind":13,"containerName":"add_sub_Location","name":"$loc"},{"line":237,"kind":13,"containerName":"add_sub_Location","name":"$loc"},{"line":237,"kind":12,"containerName":"add_sub_Location","name":"isa"},{"containerName":"add_sub_Location","name":"$self","kind":13,"line":238},{"containerName":"add_sub_Location","name":"throw","kind":12,"line":238},{"kind":13,"line":241,"containerName":"add_sub_Location","name":"$self"},{"containerName":"add_sub_Location","name":"$loc","line":241,"kind":13}],"containerName":"Bio::Location::Split","definition":"sub","detail":"($self,@args)","signature":{"label":"add_sub_Location($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Split.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Split\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Split - Implementation of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Split;\n\n    my $splitlocation = Bio::Location::Split->new();\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>1,\n\t\t\t\t\t\t\t       -end=>30,\n\t\t\t\t\t\t\t       -strand=>1));\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>50,\n\t\t\t\t\t\t\t       -end=>61,\n\t\t\t\t\t\t\t       -strand=>1));   \n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start } \n\t\t\t   @sublocs ) {\n\tprintf \"sub feature %d [%d..%d]\\n\", \n\t       $count, $location->start,$location->end, \"\\n\";\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis implementation handles locations which span more than one\nstart/end location, or and/or lie on different sequences, and can\nwork with split locations that depend on the specific order of the\nsublocations ('join') or don't have a specific order but represent\na feature spanning discontiguous sublocations ('order', 'bond').\n\nNote that the order in which sublocations are added may be very important,\ndepending on the specific split location type.  For instance, a 'join'\nmust have the sublocations added in the order that one expects to\njoin the sublocations, whereas all other types are sorted based on the\nsequence location.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl_DOT_org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Split;\n\n# as defined by BSANE 0.03\nour @CORBALOCATIONOPERATOR = ('NONE','JOIN', undef, 'ORDER');;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Location::Atomic Bio::Location::SplitLocationI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    # initialize\n    $self->{'_sublocations'} = [];\n    my ( $type, $seqid, $locations ) = \n\t$self->_rearrange([qw(SPLITTYPE\n                              SEQ_ID\n\t\t\t      LOCATIONS\n                              )], @args);\n    if( defined $locations && ref($locations) =~ /array/i ) {\n\t$self->add_sub_Location(@$locations);\n    }\n    $seqid  && $self->seq_id($seqid);\n    $type = lc ($type);    \n    $self->splittype($type || 'JOIN');\n    return $self;\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location()\n\n\nsub each_Location {\n    my ($self, $order) = @_;\n    my @locs = ();\n    foreach my $subloc ($self->sub_Location($order)) {\n\t# Recursively check to get hierarchical split locations:\n\tpush @locs, $subloc->each_Location($order);\n    }\n    return @locs;\n}\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @sublocs = $splitloc->sub_Location();\n Function: Returns the array of sublocations making up this compound (split)\n           location. Those sublocations referring to the same sequence as\n           the root split location will be sorted by start position (forward\n           sort) or end position (reverse sort) and come first (before\n           those on other sequences).\n\n           The sort order can be optionally specified or suppressed by the\n           value of the first argument. The default is no sort.\n\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optionally 1, 0, or -1 for specifying a forward, no, or reverse\n           sort order\n\n\nsub sub_Location {\n    my ($self, $order) = @_;\n    $order = 0 unless defined $order;\n    if( defined($order) && ($order !~ /^-?\\d+$/) ) {\n\t$self->throw(\"value $order passed in to sub_Location is $order, an invalid value\");\n    } \n    $order = 1 if($order > 1);\n    $order = -1 if($order < -1);\n    my @sublocs = defined $self->{'_sublocations'} ? @{$self->{'_sublocations'}} : ();\n\n    # return the array if no ordering requested\n    return @sublocs if( ($order == 0) || (! @sublocs) );\n    \t\n    # sort those locations that are on the same sequence as the top (`master')\n    # if the top seq is undefined, we take the first defined in a sublocation\n    my $seqid = $self->seq_id();\n    my $i = 0;\n    while((! defined($seqid)) && ($i <= $#sublocs)) {\n\t\t$seqid = $sublocs[$i++]->seq_id();\n    }\n    if((! $self->seq_id()) && $seqid) {\n\t\t$self->warn(\"sorted sublocation array requested but \".\n\t\t\t\t\"root location doesn't define seq_id \".\n\t\t\t\t\"(at least one sublocation does!)\");\n    }\n    my @locs = ($seqid ?\n\t\tgrep { $_->seq_id() eq $seqid; } @sublocs :\n\t\t@sublocs);\n    if(@locs) {\n\t\tif($order == 1) {\n\t\t\t# Schwartzian transforms for performance boost\t  \n\t\t\t@locs = map { $_->[0] }\n\t\t\tsort {\n\t\t\t\t(defined $a && defined $b) ? $a->[1] <=> $b->[1] :\n                $a                         ?  -1                 : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->start ? $_->start : $_->end)]\n\t\t\t\t} @locs;;\n\t\t} else { # $order == -1\n\t\t\t@locs = map { $_->[0]}\n\t\t\tsort { \n\t\t\t\t(defined $a && defined $b) ? $b->[1] <=> $a->[1] :\n\t\t\t\t$a                         ? -1                  : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->end ? $_->end : $_->start)]\n\t\t\t\t} @locs;\n\t\t}\n    }\n    # push the rest unsorted\n    if($seqid) {\n\t\tpush(@locs, grep { $_->seq_id() ne $seqid; } @sublocs);\n    }\n    # done!\n\n    return @locs;\n}\n\n=head2 add_sub_Location\n\n Title   : add_sub_Location\n Usage   : $splitloc->add_sub_Location(@locationIobjs);\n Function: add an additional sublocation\n Returns : number of current sub locations\n Args    : list of Bio::LocationI implementing object(s) to add"},"name":"add_sub_Location","range":{"end":{"character":9999,"line":242},"start":{"line":233,"character":0}}},{"kind":13,"line":244,"containerName":null,"name":"%self"},{"range":{"end":{"character":9999,"line":264},"start":{"line":257,"character":0}},"name":"splittype","detail":"($self,$value)","signature":{"label":"splittype($self,$value)","documentation":"1;\n# $Id: Split.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Split\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Split - Implementation of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Split;\n\n    my $splitlocation = Bio::Location::Split->new();\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>1,\n\t\t\t\t\t\t\t       -end=>30,\n\t\t\t\t\t\t\t       -strand=>1));\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>50,\n\t\t\t\t\t\t\t       -end=>61,\n\t\t\t\t\t\t\t       -strand=>1));   \n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start } \n\t\t\t   @sublocs ) {\n\tprintf \"sub feature %d [%d..%d]\\n\", \n\t       $count, $location->start,$location->end, \"\\n\";\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis implementation handles locations which span more than one\nstart/end location, or and/or lie on different sequences, and can\nwork with split locations that depend on the specific order of the\nsublocations ('join') or don't have a specific order but represent\na feature spanning discontiguous sublocations ('order', 'bond').\n\nNote that the order in which sublocations are added may be very important,\ndepending on the specific split location type.  For instance, a 'join'\nmust have the sublocations added in the order that one expects to\njoin the sublocations, whereas all other types are sorted based on the\nsequence location.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl_DOT_org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Split;\n\n# as defined by BSANE 0.03\nour @CORBALOCATIONOPERATOR = ('NONE','JOIN', undef, 'ORDER');;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Location::Atomic Bio::Location::SplitLocationI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    # initialize\n    $self->{'_sublocations'} = [];\n    my ( $type, $seqid, $locations ) = \n\t$self->_rearrange([qw(SPLITTYPE\n                              SEQ_ID\n\t\t\t      LOCATIONS\n                              )], @args);\n    if( defined $locations && ref($locations) =~ /array/i ) {\n\t$self->add_sub_Location(@$locations);\n    }\n    $seqid  && $self->seq_id($seqid);\n    $type = lc ($type);    \n    $self->splittype($type || 'JOIN');\n    return $self;\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location()\n\n\nsub each_Location {\n    my ($self, $order) = @_;\n    my @locs = ();\n    foreach my $subloc ($self->sub_Location($order)) {\n\t# Recursively check to get hierarchical split locations:\n\tpush @locs, $subloc->each_Location($order);\n    }\n    return @locs;\n}\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @sublocs = $splitloc->sub_Location();\n Function: Returns the array of sublocations making up this compound (split)\n           location. Those sublocations referring to the same sequence as\n           the root split location will be sorted by start position (forward\n           sort) or end position (reverse sort) and come first (before\n           those on other sequences).\n\n           The sort order can be optionally specified or suppressed by the\n           value of the first argument. The default is no sort.\n\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optionally 1, 0, or -1 for specifying a forward, no, or reverse\n           sort order\n\n\nsub sub_Location {\n    my ($self, $order) = @_;\n    $order = 0 unless defined $order;\n    if( defined($order) && ($order !~ /^-?\\d+$/) ) {\n\t$self->throw(\"value $order passed in to sub_Location is $order, an invalid value\");\n    } \n    $order = 1 if($order > 1);\n    $order = -1 if($order < -1);\n    my @sublocs = defined $self->{'_sublocations'} ? @{$self->{'_sublocations'}} : ();\n\n    # return the array if no ordering requested\n    return @sublocs if( ($order == 0) || (! @sublocs) );\n    \t\n    # sort those locations that are on the same sequence as the top (`master')\n    # if the top seq is undefined, we take the first defined in a sublocation\n    my $seqid = $self->seq_id();\n    my $i = 0;\n    while((! defined($seqid)) && ($i <= $#sublocs)) {\n\t\t$seqid = $sublocs[$i++]->seq_id();\n    }\n    if((! $self->seq_id()) && $seqid) {\n\t\t$self->warn(\"sorted sublocation array requested but \".\n\t\t\t\t\"root location doesn't define seq_id \".\n\t\t\t\t\"(at least one sublocation does!)\");\n    }\n    my @locs = ($seqid ?\n\t\tgrep { $_->seq_id() eq $seqid; } @sublocs :\n\t\t@sublocs);\n    if(@locs) {\n\t\tif($order == 1) {\n\t\t\t# Schwartzian transforms for performance boost\t  \n\t\t\t@locs = map { $_->[0] }\n\t\t\tsort {\n\t\t\t\t(defined $a && defined $b) ? $a->[1] <=> $b->[1] :\n                $a                         ?  -1                 : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->start ? $_->start : $_->end)]\n\t\t\t\t} @locs;;\n\t\t} else { # $order == -1\n\t\t\t@locs = map { $_->[0]}\n\t\t\tsort { \n\t\t\t\t(defined $a && defined $b) ? $b->[1] <=> $a->[1] :\n\t\t\t\t$a                         ? -1                  : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->end ? $_->end : $_->start)]\n\t\t\t\t} @locs;\n\t\t}\n    }\n    # push the rest unsorted\n    if($seqid) {\n\t\tpush(@locs, grep { $_->seq_id() ne $seqid; } @sublocs);\n    }\n    # done!\n\n    return @locs;\n}\n\n=head2 add_sub_Location\n\n Title   : add_sub_Location\n Usage   : $splitloc->add_sub_Location(@locationIobjs);\n Function: add an additional sublocation\n Returns : number of current sub locations\n Args    : list of Bio::LocationI implementing object(s) to add\n\n\nsub add_sub_Location {\n    my ($self,@args) = @_;\n    my @locs;    \n    foreach my $loc ( @args ) {\n\tif( !ref($loc) || ! $loc->isa('Bio::LocationI') ) {\n\t    $self->throw(\"Trying to add $loc as a sub Location but it doesn't implement Bio::LocationI!\");\n\t    next;\n\t}\t\n\tpush @{$self->{'_sublocations'}}, $loc;\n    }\n\n    return scalar @{$self->{'_sublocations'}};\n}\n\n=head2 splittype\n\n  Title   : splittype\n  Usage   : $splittype = $location->splittype();\n  Function: get/set the split splittype\n  Returns : the splittype of split feature (join, order)\n  Args    : splittype to set","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"Bio::Location::Split","definition":"sub","line":257,"children":[{"name":"$self","definition":"my","containerName":"splittype","localvar":"my","kind":13,"line":258},{"containerName":"splittype","name":"$value","kind":13,"line":258},{"line":259,"kind":13,"name":"$value","containerName":"splittype"},{"kind":13,"line":259,"name":"$self","containerName":"splittype"},{"containerName":"splittype","name":"$value","kind":13,"line":260},{"line":260,"kind":13,"name":"$value","containerName":"splittype"},{"name":"$self","containerName":"splittype","kind":13,"line":261},{"containerName":"splittype","name":"$value","line":261,"kind":13},{"line":263,"kind":13,"containerName":"splittype","name":"$self"}],"kind":12},{"detail":"($self)","signature":{"label":"is_single_sequence($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Split.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Split\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Split - Implementation of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Split;\n\n    my $splitlocation = Bio::Location::Split->new();\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>1,\n\t\t\t\t\t\t\t       -end=>30,\n\t\t\t\t\t\t\t       -strand=>1));\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>50,\n\t\t\t\t\t\t\t       -end=>61,\n\t\t\t\t\t\t\t       -strand=>1));   \n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start } \n\t\t\t   @sublocs ) {\n\tprintf \"sub feature %d [%d..%d]\\n\", \n\t       $count, $location->start,$location->end, \"\\n\";\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis implementation handles locations which span more than one\nstart/end location, or and/or lie on different sequences, and can\nwork with split locations that depend on the specific order of the\nsublocations ('join') or don't have a specific order but represent\na feature spanning discontiguous sublocations ('order', 'bond').\n\nNote that the order in which sublocations are added may be very important,\ndepending on the specific split location type.  For instance, a 'join'\nmust have the sublocations added in the order that one expects to\njoin the sublocations, whereas all other types are sorted based on the\nsequence location.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl_DOT_org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Split;\n\n# as defined by BSANE 0.03\nour @CORBALOCATIONOPERATOR = ('NONE','JOIN', undef, 'ORDER');;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Location::Atomic Bio::Location::SplitLocationI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    # initialize\n    $self->{'_sublocations'} = [];\n    my ( $type, $seqid, $locations ) = \n\t$self->_rearrange([qw(SPLITTYPE\n                              SEQ_ID\n\t\t\t      LOCATIONS\n                              )], @args);\n    if( defined $locations && ref($locations) =~ /array/i ) {\n\t$self->add_sub_Location(@$locations);\n    }\n    $seqid  && $self->seq_id($seqid);\n    $type = lc ($type);    \n    $self->splittype($type || 'JOIN');\n    return $self;\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location()\n\n\nsub each_Location {\n    my ($self, $order) = @_;\n    my @locs = ();\n    foreach my $subloc ($self->sub_Location($order)) {\n\t# Recursively check to get hierarchical split locations:\n\tpush @locs, $subloc->each_Location($order);\n    }\n    return @locs;\n}\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @sublocs = $splitloc->sub_Location();\n Function: Returns the array of sublocations making up this compound (split)\n           location. Those sublocations referring to the same sequence as\n           the root split location will be sorted by start position (forward\n           sort) or end position (reverse sort) and come first (before\n           those on other sequences).\n\n           The sort order can be optionally specified or suppressed by the\n           value of the first argument. The default is no sort.\n\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optionally 1, 0, or -1 for specifying a forward, no, or reverse\n           sort order\n\n\nsub sub_Location {\n    my ($self, $order) = @_;\n    $order = 0 unless defined $order;\n    if( defined($order) && ($order !~ /^-?\\d+$/) ) {\n\t$self->throw(\"value $order passed in to sub_Location is $order, an invalid value\");\n    } \n    $order = 1 if($order > 1);\n    $order = -1 if($order < -1);\n    my @sublocs = defined $self->{'_sublocations'} ? @{$self->{'_sublocations'}} : ();\n\n    # return the array if no ordering requested\n    return @sublocs if( ($order == 0) || (! @sublocs) );\n    \t\n    # sort those locations that are on the same sequence as the top (`master')\n    # if the top seq is undefined, we take the first defined in a sublocation\n    my $seqid = $self->seq_id();\n    my $i = 0;\n    while((! defined($seqid)) && ($i <= $#sublocs)) {\n\t\t$seqid = $sublocs[$i++]->seq_id();\n    }\n    if((! $self->seq_id()) && $seqid) {\n\t\t$self->warn(\"sorted sublocation array requested but \".\n\t\t\t\t\"root location doesn't define seq_id \".\n\t\t\t\t\"(at least one sublocation does!)\");\n    }\n    my @locs = ($seqid ?\n\t\tgrep { $_->seq_id() eq $seqid; } @sublocs :\n\t\t@sublocs);\n    if(@locs) {\n\t\tif($order == 1) {\n\t\t\t# Schwartzian transforms for performance boost\t  \n\t\t\t@locs = map { $_->[0] }\n\t\t\tsort {\n\t\t\t\t(defined $a && defined $b) ? $a->[1] <=> $b->[1] :\n                $a                         ?  -1                 : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->start ? $_->start : $_->end)]\n\t\t\t\t} @locs;;\n\t\t} else { # $order == -1\n\t\t\t@locs = map { $_->[0]}\n\t\t\tsort { \n\t\t\t\t(defined $a && defined $b) ? $b->[1] <=> $a->[1] :\n\t\t\t\t$a                         ? -1                  : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->end ? $_->end : $_->start)]\n\t\t\t\t} @locs;\n\t\t}\n    }\n    # push the rest unsorted\n    if($seqid) {\n\t\tpush(@locs, grep { $_->seq_id() ne $seqid; } @sublocs);\n    }\n    # done!\n\n    return @locs;\n}\n\n=head2 add_sub_Location\n\n Title   : add_sub_Location\n Usage   : $splitloc->add_sub_Location(@locationIobjs);\n Function: add an additional sublocation\n Returns : number of current sub locations\n Args    : list of Bio::LocationI implementing object(s) to add\n\n\nsub add_sub_Location {\n    my ($self,@args) = @_;\n    my @locs;    \n    foreach my $loc ( @args ) {\n\tif( !ref($loc) || ! $loc->isa('Bio::LocationI') ) {\n\t    $self->throw(\"Trying to add $loc as a sub Location but it doesn't implement Bio::LocationI!\");\n\t    next;\n\t}\t\n\tpush @{$self->{'_sublocations'}}, $loc;\n    }\n\n    return scalar @{$self->{'_sublocations'}};\n}\n\n=head2 splittype\n\n  Title   : splittype\n  Usage   : $splittype = $location->splittype();\n  Function: get/set the split splittype\n  Returns : the splittype of split feature (join, order)\n  Args    : splittype to set\n\n\nsub splittype {\n    my ($self, $value) = @_;\n    if( defined $value || ! defined $self->{'_splittype'} ) {\n\t$value = 'JOIN' unless( defined $value );\n\t$self->{'_splittype'} = uc ($value);\n    }\n    return $self->{'_splittype'};\n}\n\n=head2 is_single_sequence\n\n  Title   : is_single_sequence\n  Usage   : if($splitloc->is_single_sequence()) {\n                print \"Location object $splitloc is split \".\n                      \"but only across a single sequence\\n\";\n\t    }\n  Function: Determine whether this location is split across a single or\n            multiple sequences.\n\n            This implementation ignores (sub-)locations that do not define\n            seq_id(). The same holds true for the root location.\n\n  Returns : TRUE if all sublocations lie on the same sequence as the root\n            location (feature), and FALSE otherwise.\n  Args    : none"},"containerName":"Bio::Location::Split","definition":"sub","line":285,"children":[{"line":286,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"is_single_sequence"},{"localvar":"my","definition":"my","name":"$seqid","containerName":"is_single_sequence","line":288,"kind":13},{"kind":13,"line":288,"name":"$self","containerName":"is_single_sequence"},{"kind":12,"line":288,"containerName":"is_single_sequence","name":"seq_id"},{"kind":13,"line":289,"containerName":"is_single_sequence","name":"$loc","definition":"my","localvar":"my"},{"name":"$self","containerName":"is_single_sequence","kind":13,"line":289},{"line":289,"kind":12,"containerName":"is_single_sequence","name":"sub_Location"},{"kind":13,"line":290,"containerName":"is_single_sequence","name":"$seqid"},{"name":"$loc","containerName":"is_single_sequence","line":290,"kind":13},{"kind":12,"line":290,"name":"seq_id","containerName":"is_single_sequence"},{"containerName":"is_single_sequence","name":"$seqid","kind":13,"line":290},{"name":"$loc","containerName":"is_single_sequence","line":291,"kind":13},{"name":"seq_id","containerName":"is_single_sequence","line":291,"kind":12},{"line":291,"kind":13,"name":"$loc","containerName":"is_single_sequence"},{"kind":12,"line":291,"name":"seq_id","containerName":"is_single_sequence"},{"kind":13,"line":291,"containerName":"is_single_sequence","name":"$seqid"}],"kind":12,"range":{"end":{"line":296,"character":9999},"start":{"character":0,"line":285}},"name":"is_single_sequence"},{"line":310,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"guide_strand","line":311,"kind":13},{"kind":13,"line":312,"name":"$self","containerName":"guide_strand"},{"kind":13,"line":313,"containerName":"guide_strand","name":"$self"}],"kind":12,"range":{"end":{"line":314,"character":9999},"start":{"character":0,"line":310}},"containerName":"Bio::Location::Split","name":"guide_strand","definition":"sub"},{"line":338,"children":[{"name":"$self","definition":"my","containerName":"strand","localvar":"my","kind":13,"line":339},{"kind":13,"line":339,"name":"$value","containerName":"strand"},{"line":340,"kind":13,"name":"$value","containerName":"strand"},{"containerName":"strand","name":"$self","line":341,"kind":13},{"containerName":"strand","name":"$value","line":341,"kind":13},{"name":"$loc","definition":"my","containerName":"strand","localvar":"my","kind":13,"line":343},{"containerName":"strand","name":"$self","line":343,"kind":13},{"name":"sub_Location","containerName":"strand","line":343,"kind":12},{"name":"$loc","containerName":"strand","kind":13,"line":344},{"name":"strand","containerName":"strand","line":344,"kind":12},{"line":344,"kind":13,"name":"$value","containerName":"strand"},{"definition":"my","name":"$strand","containerName":"strand","localvar":"my","kind":13,"line":347},{"containerName":"strand","name":"$lstrand","kind":13,"line":347},{"localvar":"my","containerName":"strand","definition":"my","name":"$loc","line":348,"kind":13},{"containerName":"strand","name":"$self","line":348,"kind":13},{"name":"sub_Location","containerName":"strand","line":348,"kind":12},{"kind":13,"line":354,"name":"$lstrand","containerName":"strand"},{"kind":13,"line":354,"containerName":"strand","name":"$loc"},{"kind":12,"line":354,"name":"strand","containerName":"strand"},{"line":355,"kind":13,"name":"$lstrand","containerName":"strand"},{"name":"$strand","containerName":"strand","kind":13,"line":356},{"kind":13,"line":356,"containerName":"strand","name":"$strand"},{"name":"$lstrand","containerName":"strand","line":356,"kind":13},{"containerName":"strand","name":"$loc","line":357,"kind":13},{"name":"is_remote","containerName":"strand","line":357,"kind":12},{"line":358,"kind":13,"name":"$strand","containerName":"strand"},{"kind":13,"line":360,"containerName":"strand","name":"$strand"},{"line":361,"kind":13,"name":"$strand","containerName":"strand"},{"line":361,"kind":13,"containerName":"strand","name":"$lstrand"},{"kind":13,"line":364,"containerName":"strand","name":"$strand"}],"kind":12,"detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Split.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Split\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Split - Implementation of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Split;\n\n    my $splitlocation = Bio::Location::Split->new();\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>1,\n\t\t\t\t\t\t\t       -end=>30,\n\t\t\t\t\t\t\t       -strand=>1));\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>50,\n\t\t\t\t\t\t\t       -end=>61,\n\t\t\t\t\t\t\t       -strand=>1));   \n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start } \n\t\t\t   @sublocs ) {\n\tprintf \"sub feature %d [%d..%d]\\n\", \n\t       $count, $location->start,$location->end, \"\\n\";\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis implementation handles locations which span more than one\nstart/end location, or and/or lie on different sequences, and can\nwork with split locations that depend on the specific order of the\nsublocations ('join') or don't have a specific order but represent\na feature spanning discontiguous sublocations ('order', 'bond').\n\nNote that the order in which sublocations are added may be very important,\ndepending on the specific split location type.  For instance, a 'join'\nmust have the sublocations added in the order that one expects to\njoin the sublocations, whereas all other types are sorted based on the\nsequence location.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl_DOT_org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Split;\n\n# as defined by BSANE 0.03\nour @CORBALOCATIONOPERATOR = ('NONE','JOIN', undef, 'ORDER');;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Location::Atomic Bio::Location::SplitLocationI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    # initialize\n    $self->{'_sublocations'} = [];\n    my ( $type, $seqid, $locations ) = \n\t$self->_rearrange([qw(SPLITTYPE\n                              SEQ_ID\n\t\t\t      LOCATIONS\n                              )], @args);\n    if( defined $locations && ref($locations) =~ /array/i ) {\n\t$self->add_sub_Location(@$locations);\n    }\n    $seqid  && $self->seq_id($seqid);\n    $type = lc ($type);    \n    $self->splittype($type || 'JOIN');\n    return $self;\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location()\n\n\nsub each_Location {\n    my ($self, $order) = @_;\n    my @locs = ();\n    foreach my $subloc ($self->sub_Location($order)) {\n\t# Recursively check to get hierarchical split locations:\n\tpush @locs, $subloc->each_Location($order);\n    }\n    return @locs;\n}\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @sublocs = $splitloc->sub_Location();\n Function: Returns the array of sublocations making up this compound (split)\n           location. Those sublocations referring to the same sequence as\n           the root split location will be sorted by start position (forward\n           sort) or end position (reverse sort) and come first (before\n           those on other sequences).\n\n           The sort order can be optionally specified or suppressed by the\n           value of the first argument. The default is no sort.\n\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optionally 1, 0, or -1 for specifying a forward, no, or reverse\n           sort order\n\n\nsub sub_Location {\n    my ($self, $order) = @_;\n    $order = 0 unless defined $order;\n    if( defined($order) && ($order !~ /^-?\\d+$/) ) {\n\t$self->throw(\"value $order passed in to sub_Location is $order, an invalid value\");\n    } \n    $order = 1 if($order > 1);\n    $order = -1 if($order < -1);\n    my @sublocs = defined $self->{'_sublocations'} ? @{$self->{'_sublocations'}} : ();\n\n    # return the array if no ordering requested\n    return @sublocs if( ($order == 0) || (! @sublocs) );\n    \t\n    # sort those locations that are on the same sequence as the top (`master')\n    # if the top seq is undefined, we take the first defined in a sublocation\n    my $seqid = $self->seq_id();\n    my $i = 0;\n    while((! defined($seqid)) && ($i <= $#sublocs)) {\n\t\t$seqid = $sublocs[$i++]->seq_id();\n    }\n    if((! $self->seq_id()) && $seqid) {\n\t\t$self->warn(\"sorted sublocation array requested but \".\n\t\t\t\t\"root location doesn't define seq_id \".\n\t\t\t\t\"(at least one sublocation does!)\");\n    }\n    my @locs = ($seqid ?\n\t\tgrep { $_->seq_id() eq $seqid; } @sublocs :\n\t\t@sublocs);\n    if(@locs) {\n\t\tif($order == 1) {\n\t\t\t# Schwartzian transforms for performance boost\t  \n\t\t\t@locs = map { $_->[0] }\n\t\t\tsort {\n\t\t\t\t(defined $a && defined $b) ? $a->[1] <=> $b->[1] :\n                $a                         ?  -1                 : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->start ? $_->start : $_->end)]\n\t\t\t\t} @locs;;\n\t\t} else { # $order == -1\n\t\t\t@locs = map { $_->[0]}\n\t\t\tsort { \n\t\t\t\t(defined $a && defined $b) ? $b->[1] <=> $a->[1] :\n\t\t\t\t$a                         ? -1                  : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->end ? $_->end : $_->start)]\n\t\t\t\t} @locs;\n\t\t}\n    }\n    # push the rest unsorted\n    if($seqid) {\n\t\tpush(@locs, grep { $_->seq_id() ne $seqid; } @sublocs);\n    }\n    # done!\n\n    return @locs;\n}\n\n=head2 add_sub_Location\n\n Title   : add_sub_Location\n Usage   : $splitloc->add_sub_Location(@locationIobjs);\n Function: add an additional sublocation\n Returns : number of current sub locations\n Args    : list of Bio::LocationI implementing object(s) to add\n\n\nsub add_sub_Location {\n    my ($self,@args) = @_;\n    my @locs;    \n    foreach my $loc ( @args ) {\n\tif( !ref($loc) || ! $loc->isa('Bio::LocationI') ) {\n\t    $self->throw(\"Trying to add $loc as a sub Location but it doesn't implement Bio::LocationI!\");\n\t    next;\n\t}\t\n\tpush @{$self->{'_sublocations'}}, $loc;\n    }\n\n    return scalar @{$self->{'_sublocations'}};\n}\n\n=head2 splittype\n\n  Title   : splittype\n  Usage   : $splittype = $location->splittype();\n  Function: get/set the split splittype\n  Returns : the splittype of split feature (join, order)\n  Args    : splittype to set\n\n\nsub splittype {\n    my ($self, $value) = @_;\n    if( defined $value || ! defined $self->{'_splittype'} ) {\n\t$value = 'JOIN' unless( defined $value );\n\t$self->{'_splittype'} = uc ($value);\n    }\n    return $self->{'_splittype'};\n}\n\n=head2 is_single_sequence\n\n  Title   : is_single_sequence\n  Usage   : if($splitloc->is_single_sequence()) {\n                print \"Location object $splitloc is split \".\n                      \"but only across a single sequence\\n\";\n\t    }\n  Function: Determine whether this location is split across a single or\n            multiple sequences.\n\n            This implementation ignores (sub-)locations that do not define\n            seq_id(). The same holds true for the root location.\n\n  Returns : TRUE if all sublocations lie on the same sequence as the root\n            location (feature), and FALSE otherwise.\n  Args    : none\n\n\nsub is_single_sequence {\n    my ($self) = @_;\n\n    my $seqid = $self->seq_id();\n    foreach my $loc ($self->sub_Location(0)) {\n\t$seqid = $loc->seq_id() if(! $seqid);\n\tif(defined($loc->seq_id()) && ($loc->seq_id() ne $seqid)) {\n\t    return 0;\n\t}\n    }\n    return 1;\n}\n\n=head2 guide_strand\n\n  Title   : guide_strand\n  Usage   : $str = $loc->guide_strand();\n  Function: Get/Set the guide strand.  Of use only if the split type is\n            a 'join' (this helps determine the order of sublocation\n\t\t\tretrieval)\n  Returns : value of guide strand (1, -1, or undef)\n  Args    : new value (-1 or 1, optional)\n\n\nsub guide_strand {\n\tmy $self = shift;\n\treturn $self->{'strand'} = shift if @_;\n\treturn $self->{'strand'};\n}\n\n=head1 LocationI methods\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand($newval)\n Function: For SplitLocations, setting the strand of the container\n           (this object) is a short-cut for setting the strand of all\n           sublocations.\n\n           In get-mode, checks if no sub-location is remote, and if\n           all have the same strand. If so, it returns that shared\n           strand value. Otherwise it returns undef.\n\n Example : \n Returns : on get, value of strand if identical between sublocations \n           (-1, 1, or undef)\n Args    : new value (-1 or 1, optional)","label":"strand($self,$value)"},"containerName":"Bio::Location::Split","definition":"sub","range":{"start":{"character":0,"line":338},"end":{"line":366,"character":9999}},"name":"strand"},{"range":{"end":{"character":9999,"line":388},"start":{"character":0,"line":379}},"name":"flip_strand","definition":"sub","containerName":"Bio::Location::Split","children":[{"kind":13,"line":380,"definition":"my","name":"$self","containerName":"flip_strand","localvar":"my"},{"containerName":"flip_strand","name":"$loc","definition":"my","localvar":"my","kind":13,"line":381},{"line":381,"kind":13,"containerName":"flip_strand","name":"$self"},{"name":"sub_Location","containerName":"flip_strand","line":381,"kind":12},{"kind":13,"line":382,"containerName":"flip_strand","name":"$loc"},{"line":382,"kind":12,"name":"flip_strand","containerName":"flip_strand"},{"line":383,"kind":13,"name":"$loc","containerName":"flip_strand"},{"kind":12,"line":383,"containerName":"flip_strand","name":"isa"},{"kind":13,"line":384,"definition":"my","name":"$gs","containerName":"flip_strand","localvar":"my"},{"line":384,"kind":13,"containerName":"flip_strand","name":"$self"},{"name":"guide_strand","containerName":"flip_strand","kind":12,"line":384},{"name":"$loc","containerName":"flip_strand","kind":13,"line":385},{"line":385,"kind":12,"containerName":"flip_strand","name":"guide_strand"},{"kind":13,"line":385,"name":"$gs","containerName":"flip_strand"}],"line":379,"kind":12},{"children":[{"line":401,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"start"},{"name":"$value","containerName":"start","line":401,"kind":13},{"line":402,"kind":13,"name":"$value","containerName":"start"},{"containerName":"start","name":"$self","line":403,"kind":13},{"line":403,"kind":12,"containerName":"start","name":"throw"},{"kind":13,"line":406,"containerName":"start","name":"$self"}],"line":400,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Split.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Split\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Split - Implementation of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Split;\n\n    my $splitlocation = Bio::Location::Split->new();\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>1,\n\t\t\t\t\t\t\t       -end=>30,\n\t\t\t\t\t\t\t       -strand=>1));\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>50,\n\t\t\t\t\t\t\t       -end=>61,\n\t\t\t\t\t\t\t       -strand=>1));   \n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start } \n\t\t\t   @sublocs ) {\n\tprintf \"sub feature %d [%d..%d]\\n\", \n\t       $count, $location->start,$location->end, \"\\n\";\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis implementation handles locations which span more than one\nstart/end location, or and/or lie on different sequences, and can\nwork with split locations that depend on the specific order of the\nsublocations ('join') or don't have a specific order but represent\na feature spanning discontiguous sublocations ('order', 'bond').\n\nNote that the order in which sublocations are added may be very important,\ndepending on the specific split location type.  For instance, a 'join'\nmust have the sublocations added in the order that one expects to\njoin the sublocations, whereas all other types are sorted based on the\nsequence location.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl_DOT_org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Split;\n\n# as defined by BSANE 0.03\nour @CORBALOCATIONOPERATOR = ('NONE','JOIN', undef, 'ORDER');;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Location::Atomic Bio::Location::SplitLocationI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    # initialize\n    $self->{'_sublocations'} = [];\n    my ( $type, $seqid, $locations ) = \n\t$self->_rearrange([qw(SPLITTYPE\n                              SEQ_ID\n\t\t\t      LOCATIONS\n                              )], @args);\n    if( defined $locations && ref($locations) =~ /array/i ) {\n\t$self->add_sub_Location(@$locations);\n    }\n    $seqid  && $self->seq_id($seqid);\n    $type = lc ($type);    \n    $self->splittype($type || 'JOIN');\n    return $self;\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location()\n\n\nsub each_Location {\n    my ($self, $order) = @_;\n    my @locs = ();\n    foreach my $subloc ($self->sub_Location($order)) {\n\t# Recursively check to get hierarchical split locations:\n\tpush @locs, $subloc->each_Location($order);\n    }\n    return @locs;\n}\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @sublocs = $splitloc->sub_Location();\n Function: Returns the array of sublocations making up this compound (split)\n           location. Those sublocations referring to the same sequence as\n           the root split location will be sorted by start position (forward\n           sort) or end position (reverse sort) and come first (before\n           those on other sequences).\n\n           The sort order can be optionally specified or suppressed by the\n           value of the first argument. The default is no sort.\n\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optionally 1, 0, or -1 for specifying a forward, no, or reverse\n           sort order\n\n\nsub sub_Location {\n    my ($self, $order) = @_;\n    $order = 0 unless defined $order;\n    if( defined($order) && ($order !~ /^-?\\d+$/) ) {\n\t$self->throw(\"value $order passed in to sub_Location is $order, an invalid value\");\n    } \n    $order = 1 if($order > 1);\n    $order = -1 if($order < -1);\n    my @sublocs = defined $self->{'_sublocations'} ? @{$self->{'_sublocations'}} : ();\n\n    # return the array if no ordering requested\n    return @sublocs if( ($order == 0) || (! @sublocs) );\n    \t\n    # sort those locations that are on the same sequence as the top (`master')\n    # if the top seq is undefined, we take the first defined in a sublocation\n    my $seqid = $self->seq_id();\n    my $i = 0;\n    while((! defined($seqid)) && ($i <= $#sublocs)) {\n\t\t$seqid = $sublocs[$i++]->seq_id();\n    }\n    if((! $self->seq_id()) && $seqid) {\n\t\t$self->warn(\"sorted sublocation array requested but \".\n\t\t\t\t\"root location doesn't define seq_id \".\n\t\t\t\t\"(at least one sublocation does!)\");\n    }\n    my @locs = ($seqid ?\n\t\tgrep { $_->seq_id() eq $seqid; } @sublocs :\n\t\t@sublocs);\n    if(@locs) {\n\t\tif($order == 1) {\n\t\t\t# Schwartzian transforms for performance boost\t  \n\t\t\t@locs = map { $_->[0] }\n\t\t\tsort {\n\t\t\t\t(defined $a && defined $b) ? $a->[1] <=> $b->[1] :\n                $a                         ?  -1                 : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->start ? $_->start : $_->end)]\n\t\t\t\t} @locs;;\n\t\t} else { # $order == -1\n\t\t\t@locs = map { $_->[0]}\n\t\t\tsort { \n\t\t\t\t(defined $a && defined $b) ? $b->[1] <=> $a->[1] :\n\t\t\t\t$a                         ? -1                  : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->end ? $_->end : $_->start)]\n\t\t\t\t} @locs;\n\t\t}\n    }\n    # push the rest unsorted\n    if($seqid) {\n\t\tpush(@locs, grep { $_->seq_id() ne $seqid; } @sublocs);\n    }\n    # done!\n\n    return @locs;\n}\n\n=head2 add_sub_Location\n\n Title   : add_sub_Location\n Usage   : $splitloc->add_sub_Location(@locationIobjs);\n Function: add an additional sublocation\n Returns : number of current sub locations\n Args    : list of Bio::LocationI implementing object(s) to add\n\n\nsub add_sub_Location {\n    my ($self,@args) = @_;\n    my @locs;    \n    foreach my $loc ( @args ) {\n\tif( !ref($loc) || ! $loc->isa('Bio::LocationI') ) {\n\t    $self->throw(\"Trying to add $loc as a sub Location but it doesn't implement Bio::LocationI!\");\n\t    next;\n\t}\t\n\tpush @{$self->{'_sublocations'}}, $loc;\n    }\n\n    return scalar @{$self->{'_sublocations'}};\n}\n\n=head2 splittype\n\n  Title   : splittype\n  Usage   : $splittype = $location->splittype();\n  Function: get/set the split splittype\n  Returns : the splittype of split feature (join, order)\n  Args    : splittype to set\n\n\nsub splittype {\n    my ($self, $value) = @_;\n    if( defined $value || ! defined $self->{'_splittype'} ) {\n\t$value = 'JOIN' unless( defined $value );\n\t$self->{'_splittype'} = uc ($value);\n    }\n    return $self->{'_splittype'};\n}\n\n=head2 is_single_sequence\n\n  Title   : is_single_sequence\n  Usage   : if($splitloc->is_single_sequence()) {\n                print \"Location object $splitloc is split \".\n                      \"but only across a single sequence\\n\";\n\t    }\n  Function: Determine whether this location is split across a single or\n            multiple sequences.\n\n            This implementation ignores (sub-)locations that do not define\n            seq_id(). The same holds true for the root location.\n\n  Returns : TRUE if all sublocations lie on the same sequence as the root\n            location (feature), and FALSE otherwise.\n  Args    : none\n\n\nsub is_single_sequence {\n    my ($self) = @_;\n\n    my $seqid = $self->seq_id();\n    foreach my $loc ($self->sub_Location(0)) {\n\t$seqid = $loc->seq_id() if(! $seqid);\n\tif(defined($loc->seq_id()) && ($loc->seq_id() ne $seqid)) {\n\t    return 0;\n\t}\n    }\n    return 1;\n}\n\n=head2 guide_strand\n\n  Title   : guide_strand\n  Usage   : $str = $loc->guide_strand();\n  Function: Get/Set the guide strand.  Of use only if the split type is\n            a 'join' (this helps determine the order of sublocation\n\t\t\tretrieval)\n  Returns : value of guide strand (1, -1, or undef)\n  Args    : new value (-1 or 1, optional)\n\n\nsub guide_strand {\n\tmy $self = shift;\n\treturn $self->{'strand'} = shift if @_;\n\treturn $self->{'strand'};\n}\n\n=head1 LocationI methods\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand($newval)\n Function: For SplitLocations, setting the strand of the container\n           (this object) is a short-cut for setting the strand of all\n           sublocations.\n\n           In get-mode, checks if no sub-location is remote, and if\n           all have the same strand. If so, it returns that shared\n           strand value. Otherwise it returns undef.\n\n Example : \n Returns : on get, value of strand if identical between sublocations \n           (-1, 1, or undef)\n Args    : new value (-1 or 1, optional)\n\n\n\nsub strand{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t\t$self->{'strand'} = $value;\n\t\t# propagate to all sublocs\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t$loc->strand($value);\n\t\t}\n    } else {\n\t\tmy ($strand, $lstrand);\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t# we give up upon any location that's remote or doesn't have\n\t\t\t# the strand specified, or has a differing one set than \n\t\t\t# previously seen.\n\t\t\t# calling strand() is potentially expensive if the subloc is also\n\t\t\t# a split location, so we cache it\n\t\t\t$lstrand = $loc->strand();\n\t\t\tif((! $lstrand) ||\n\t\t\t   ($strand && ($strand != $lstrand)) ||\n\t\t\t   $loc->is_remote()) {\n\t\t\t$strand = undef;\n\t\t\tlast;\n\t\t\t} elsif(! $strand) {\n\t\t\t$strand = $lstrand;\n\t\t\t}\n\t\t}\n\t\treturn $strand;\n    }\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite.  Also switch Split strand\n            from undef to -1 or -1 to undef\n  Returns : None\n  Args    : None\n\n\nsub flip_strand {\n    my $self = shift;\n    for my $loc ( $self->sub_Location(0) ) {\n\t\t$loc->flip_strand;\n\t\tif ($loc->isa('Bio::Location::SplitLocationI')) {\n\t\t\tmy $gs = ($self->guide_strand == -1) ? undef : -1;\n\t\t\t$loc->guide_strand($gs);\n\t\t}\n    }\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $location->start();\n  Function: get the starting point of the first (sorted) sublocation\n  Returns : integer\n  Args    : none","label":"start($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"Bio::Location::Split","range":{"start":{"character":0,"line":400},"end":{"line":407,"character":9999}},"name":"start"},{"line":406,"kind":12,"name":"SUPER","containerName":"start"},{"children":[{"kind":13,"line":420,"name":"$self","definition":"my","containerName":"end","localvar":"my"},{"name":"$value","containerName":"end","line":420,"kind":13},{"containerName":"end","name":"$value","kind":13,"line":421},{"containerName":"end","name":"$self","line":422,"kind":13},{"name":"throw","containerName":"end","kind":12,"line":422},{"line":425,"kind":13,"containerName":"end","name":"$self"}],"line":419,"kind":12,"signature":{"label":"end($self,$value)","documentation":"1;\n# $Id: Split.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Split\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Split - Implementation of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Split;\n\n    my $splitlocation = Bio::Location::Split->new();\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>1,\n\t\t\t\t\t\t\t       -end=>30,\n\t\t\t\t\t\t\t       -strand=>1));\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>50,\n\t\t\t\t\t\t\t       -end=>61,\n\t\t\t\t\t\t\t       -strand=>1));   \n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start } \n\t\t\t   @sublocs ) {\n\tprintf \"sub feature %d [%d..%d]\\n\", \n\t       $count, $location->start,$location->end, \"\\n\";\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis implementation handles locations which span more than one\nstart/end location, or and/or lie on different sequences, and can\nwork with split locations that depend on the specific order of the\nsublocations ('join') or don't have a specific order but represent\na feature spanning discontiguous sublocations ('order', 'bond').\n\nNote that the order in which sublocations are added may be very important,\ndepending on the specific split location type.  For instance, a 'join'\nmust have the sublocations added in the order that one expects to\njoin the sublocations, whereas all other types are sorted based on the\nsequence location.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl_DOT_org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Split;\n\n# as defined by BSANE 0.03\nour @CORBALOCATIONOPERATOR = ('NONE','JOIN', undef, 'ORDER');;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Location::Atomic Bio::Location::SplitLocationI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    # initialize\n    $self->{'_sublocations'} = [];\n    my ( $type, $seqid, $locations ) = \n\t$self->_rearrange([qw(SPLITTYPE\n                              SEQ_ID\n\t\t\t      LOCATIONS\n                              )], @args);\n    if( defined $locations && ref($locations) =~ /array/i ) {\n\t$self->add_sub_Location(@$locations);\n    }\n    $seqid  && $self->seq_id($seqid);\n    $type = lc ($type);    \n    $self->splittype($type || 'JOIN');\n    return $self;\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location()\n\n\nsub each_Location {\n    my ($self, $order) = @_;\n    my @locs = ();\n    foreach my $subloc ($self->sub_Location($order)) {\n\t# Recursively check to get hierarchical split locations:\n\tpush @locs, $subloc->each_Location($order);\n    }\n    return @locs;\n}\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @sublocs = $splitloc->sub_Location();\n Function: Returns the array of sublocations making up this compound (split)\n           location. Those sublocations referring to the same sequence as\n           the root split location will be sorted by start position (forward\n           sort) or end position (reverse sort) and come first (before\n           those on other sequences).\n\n           The sort order can be optionally specified or suppressed by the\n           value of the first argument. The default is no sort.\n\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optionally 1, 0, or -1 for specifying a forward, no, or reverse\n           sort order\n\n\nsub sub_Location {\n    my ($self, $order) = @_;\n    $order = 0 unless defined $order;\n    if( defined($order) && ($order !~ /^-?\\d+$/) ) {\n\t$self->throw(\"value $order passed in to sub_Location is $order, an invalid value\");\n    } \n    $order = 1 if($order > 1);\n    $order = -1 if($order < -1);\n    my @sublocs = defined $self->{'_sublocations'} ? @{$self->{'_sublocations'}} : ();\n\n    # return the array if no ordering requested\n    return @sublocs if( ($order == 0) || (! @sublocs) );\n    \t\n    # sort those locations that are on the same sequence as the top (`master')\n    # if the top seq is undefined, we take the first defined in a sublocation\n    my $seqid = $self->seq_id();\n    my $i = 0;\n    while((! defined($seqid)) && ($i <= $#sublocs)) {\n\t\t$seqid = $sublocs[$i++]->seq_id();\n    }\n    if((! $self->seq_id()) && $seqid) {\n\t\t$self->warn(\"sorted sublocation array requested but \".\n\t\t\t\t\"root location doesn't define seq_id \".\n\t\t\t\t\"(at least one sublocation does!)\");\n    }\n    my @locs = ($seqid ?\n\t\tgrep { $_->seq_id() eq $seqid; } @sublocs :\n\t\t@sublocs);\n    if(@locs) {\n\t\tif($order == 1) {\n\t\t\t# Schwartzian transforms for performance boost\t  \n\t\t\t@locs = map { $_->[0] }\n\t\t\tsort {\n\t\t\t\t(defined $a && defined $b) ? $a->[1] <=> $b->[1] :\n                $a                         ?  -1                 : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->start ? $_->start : $_->end)]\n\t\t\t\t} @locs;;\n\t\t} else { # $order == -1\n\t\t\t@locs = map { $_->[0]}\n\t\t\tsort { \n\t\t\t\t(defined $a && defined $b) ? $b->[1] <=> $a->[1] :\n\t\t\t\t$a                         ? -1                  : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->end ? $_->end : $_->start)]\n\t\t\t\t} @locs;\n\t\t}\n    }\n    # push the rest unsorted\n    if($seqid) {\n\t\tpush(@locs, grep { $_->seq_id() ne $seqid; } @sublocs);\n    }\n    # done!\n\n    return @locs;\n}\n\n=head2 add_sub_Location\n\n Title   : add_sub_Location\n Usage   : $splitloc->add_sub_Location(@locationIobjs);\n Function: add an additional sublocation\n Returns : number of current sub locations\n Args    : list of Bio::LocationI implementing object(s) to add\n\n\nsub add_sub_Location {\n    my ($self,@args) = @_;\n    my @locs;    \n    foreach my $loc ( @args ) {\n\tif( !ref($loc) || ! $loc->isa('Bio::LocationI') ) {\n\t    $self->throw(\"Trying to add $loc as a sub Location but it doesn't implement Bio::LocationI!\");\n\t    next;\n\t}\t\n\tpush @{$self->{'_sublocations'}}, $loc;\n    }\n\n    return scalar @{$self->{'_sublocations'}};\n}\n\n=head2 splittype\n\n  Title   : splittype\n  Usage   : $splittype = $location->splittype();\n  Function: get/set the split splittype\n  Returns : the splittype of split feature (join, order)\n  Args    : splittype to set\n\n\nsub splittype {\n    my ($self, $value) = @_;\n    if( defined $value || ! defined $self->{'_splittype'} ) {\n\t$value = 'JOIN' unless( defined $value );\n\t$self->{'_splittype'} = uc ($value);\n    }\n    return $self->{'_splittype'};\n}\n\n=head2 is_single_sequence\n\n  Title   : is_single_sequence\n  Usage   : if($splitloc->is_single_sequence()) {\n                print \"Location object $splitloc is split \".\n                      \"but only across a single sequence\\n\";\n\t    }\n  Function: Determine whether this location is split across a single or\n            multiple sequences.\n\n            This implementation ignores (sub-)locations that do not define\n            seq_id(). The same holds true for the root location.\n\n  Returns : TRUE if all sublocations lie on the same sequence as the root\n            location (feature), and FALSE otherwise.\n  Args    : none\n\n\nsub is_single_sequence {\n    my ($self) = @_;\n\n    my $seqid = $self->seq_id();\n    foreach my $loc ($self->sub_Location(0)) {\n\t$seqid = $loc->seq_id() if(! $seqid);\n\tif(defined($loc->seq_id()) && ($loc->seq_id() ne $seqid)) {\n\t    return 0;\n\t}\n    }\n    return 1;\n}\n\n=head2 guide_strand\n\n  Title   : guide_strand\n  Usage   : $str = $loc->guide_strand();\n  Function: Get/Set the guide strand.  Of use only if the split type is\n            a 'join' (this helps determine the order of sublocation\n\t\t\tretrieval)\n  Returns : value of guide strand (1, -1, or undef)\n  Args    : new value (-1 or 1, optional)\n\n\nsub guide_strand {\n\tmy $self = shift;\n\treturn $self->{'strand'} = shift if @_;\n\treturn $self->{'strand'};\n}\n\n=head1 LocationI methods\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand($newval)\n Function: For SplitLocations, setting the strand of the container\n           (this object) is a short-cut for setting the strand of all\n           sublocations.\n\n           In get-mode, checks if no sub-location is remote, and if\n           all have the same strand. If so, it returns that shared\n           strand value. Otherwise it returns undef.\n\n Example : \n Returns : on get, value of strand if identical between sublocations \n           (-1, 1, or undef)\n Args    : new value (-1 or 1, optional)\n\n\n\nsub strand{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t\t$self->{'strand'} = $value;\n\t\t# propagate to all sublocs\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t$loc->strand($value);\n\t\t}\n    } else {\n\t\tmy ($strand, $lstrand);\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t# we give up upon any location that's remote or doesn't have\n\t\t\t# the strand specified, or has a differing one set than \n\t\t\t# previously seen.\n\t\t\t# calling strand() is potentially expensive if the subloc is also\n\t\t\t# a split location, so we cache it\n\t\t\t$lstrand = $loc->strand();\n\t\t\tif((! $lstrand) ||\n\t\t\t   ($strand && ($strand != $lstrand)) ||\n\t\t\t   $loc->is_remote()) {\n\t\t\t$strand = undef;\n\t\t\tlast;\n\t\t\t} elsif(! $strand) {\n\t\t\t$strand = $lstrand;\n\t\t\t}\n\t\t}\n\t\treturn $strand;\n    }\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite.  Also switch Split strand\n            from undef to -1 or -1 to undef\n  Returns : None\n  Args    : None\n\n\nsub flip_strand {\n    my $self = shift;\n    for my $loc ( $self->sub_Location(0) ) {\n\t\t$loc->flip_strand;\n\t\tif ($loc->isa('Bio::Location::SplitLocationI')) {\n\t\t\tmy $gs = ($self->guide_strand == -1) ? undef : -1;\n\t\t\t$loc->guide_strand($gs);\n\t\t}\n    }\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $location->start();\n  Function: get the starting point of the first (sorted) sublocation\n  Returns : integer\n  Args    : none\n\n\nsub start {\n    my ($self,$value) = @_;    \n    if( defined $value ) {\n\t$self->throw(\"Trying to set the starting point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $location->end();\n  Function: get the ending point of the last (sorted) sublocation\n  Returns : integer\n  Args    : none","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","definition":"sub","containerName":"Bio::Location::Split","range":{"start":{"line":419,"character":0},"end":{"character":9999,"line":426}},"name":"end"},{"containerName":"end","name":"SUPER","kind":12,"line":425},{"range":{"end":{"character":9999,"line":448},"start":{"character":0,"line":438}},"name":"min_start","detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: Split.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Split\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Split - Implementation of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Split;\n\n    my $splitlocation = Bio::Location::Split->new();\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>1,\n\t\t\t\t\t\t\t       -end=>30,\n\t\t\t\t\t\t\t       -strand=>1));\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>50,\n\t\t\t\t\t\t\t       -end=>61,\n\t\t\t\t\t\t\t       -strand=>1));   \n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start } \n\t\t\t   @sublocs ) {\n\tprintf \"sub feature %d [%d..%d]\\n\", \n\t       $count, $location->start,$location->end, \"\\n\";\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis implementation handles locations which span more than one\nstart/end location, or and/or lie on different sequences, and can\nwork with split locations that depend on the specific order of the\nsublocations ('join') or don't have a specific order but represent\na feature spanning discontiguous sublocations ('order', 'bond').\n\nNote that the order in which sublocations are added may be very important,\ndepending on the specific split location type.  For instance, a 'join'\nmust have the sublocations added in the order that one expects to\njoin the sublocations, whereas all other types are sorted based on the\nsequence location.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl_DOT_org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Split;\n\n# as defined by BSANE 0.03\nour @CORBALOCATIONOPERATOR = ('NONE','JOIN', undef, 'ORDER');;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Location::Atomic Bio::Location::SplitLocationI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    # initialize\n    $self->{'_sublocations'} = [];\n    my ( $type, $seqid, $locations ) = \n\t$self->_rearrange([qw(SPLITTYPE\n                              SEQ_ID\n\t\t\t      LOCATIONS\n                              )], @args);\n    if( defined $locations && ref($locations) =~ /array/i ) {\n\t$self->add_sub_Location(@$locations);\n    }\n    $seqid  && $self->seq_id($seqid);\n    $type = lc ($type);    \n    $self->splittype($type || 'JOIN');\n    return $self;\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location()\n\n\nsub each_Location {\n    my ($self, $order) = @_;\n    my @locs = ();\n    foreach my $subloc ($self->sub_Location($order)) {\n\t# Recursively check to get hierarchical split locations:\n\tpush @locs, $subloc->each_Location($order);\n    }\n    return @locs;\n}\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @sublocs = $splitloc->sub_Location();\n Function: Returns the array of sublocations making up this compound (split)\n           location. Those sublocations referring to the same sequence as\n           the root split location will be sorted by start position (forward\n           sort) or end position (reverse sort) and come first (before\n           those on other sequences).\n\n           The sort order can be optionally specified or suppressed by the\n           value of the first argument. The default is no sort.\n\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optionally 1, 0, or -1 for specifying a forward, no, or reverse\n           sort order\n\n\nsub sub_Location {\n    my ($self, $order) = @_;\n    $order = 0 unless defined $order;\n    if( defined($order) && ($order !~ /^-?\\d+$/) ) {\n\t$self->throw(\"value $order passed in to sub_Location is $order, an invalid value\");\n    } \n    $order = 1 if($order > 1);\n    $order = -1 if($order < -1);\n    my @sublocs = defined $self->{'_sublocations'} ? @{$self->{'_sublocations'}} : ();\n\n    # return the array if no ordering requested\n    return @sublocs if( ($order == 0) || (! @sublocs) );\n    \t\n    # sort those locations that are on the same sequence as the top (`master')\n    # if the top seq is undefined, we take the first defined in a sublocation\n    my $seqid = $self->seq_id();\n    my $i = 0;\n    while((! defined($seqid)) && ($i <= $#sublocs)) {\n\t\t$seqid = $sublocs[$i++]->seq_id();\n    }\n    if((! $self->seq_id()) && $seqid) {\n\t\t$self->warn(\"sorted sublocation array requested but \".\n\t\t\t\t\"root location doesn't define seq_id \".\n\t\t\t\t\"(at least one sublocation does!)\");\n    }\n    my @locs = ($seqid ?\n\t\tgrep { $_->seq_id() eq $seqid; } @sublocs :\n\t\t@sublocs);\n    if(@locs) {\n\t\tif($order == 1) {\n\t\t\t# Schwartzian transforms for performance boost\t  \n\t\t\t@locs = map { $_->[0] }\n\t\t\tsort {\n\t\t\t\t(defined $a && defined $b) ? $a->[1] <=> $b->[1] :\n                $a                         ?  -1                 : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->start ? $_->start : $_->end)]\n\t\t\t\t} @locs;;\n\t\t} else { # $order == -1\n\t\t\t@locs = map { $_->[0]}\n\t\t\tsort { \n\t\t\t\t(defined $a && defined $b) ? $b->[1] <=> $a->[1] :\n\t\t\t\t$a                         ? -1                  : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->end ? $_->end : $_->start)]\n\t\t\t\t} @locs;\n\t\t}\n    }\n    # push the rest unsorted\n    if($seqid) {\n\t\tpush(@locs, grep { $_->seq_id() ne $seqid; } @sublocs);\n    }\n    # done!\n\n    return @locs;\n}\n\n=head2 add_sub_Location\n\n Title   : add_sub_Location\n Usage   : $splitloc->add_sub_Location(@locationIobjs);\n Function: add an additional sublocation\n Returns : number of current sub locations\n Args    : list of Bio::LocationI implementing object(s) to add\n\n\nsub add_sub_Location {\n    my ($self,@args) = @_;\n    my @locs;    \n    foreach my $loc ( @args ) {\n\tif( !ref($loc) || ! $loc->isa('Bio::LocationI') ) {\n\t    $self->throw(\"Trying to add $loc as a sub Location but it doesn't implement Bio::LocationI!\");\n\t    next;\n\t}\t\n\tpush @{$self->{'_sublocations'}}, $loc;\n    }\n\n    return scalar @{$self->{'_sublocations'}};\n}\n\n=head2 splittype\n\n  Title   : splittype\n  Usage   : $splittype = $location->splittype();\n  Function: get/set the split splittype\n  Returns : the splittype of split feature (join, order)\n  Args    : splittype to set\n\n\nsub splittype {\n    my ($self, $value) = @_;\n    if( defined $value || ! defined $self->{'_splittype'} ) {\n\t$value = 'JOIN' unless( defined $value );\n\t$self->{'_splittype'} = uc ($value);\n    }\n    return $self->{'_splittype'};\n}\n\n=head2 is_single_sequence\n\n  Title   : is_single_sequence\n  Usage   : if($splitloc->is_single_sequence()) {\n                print \"Location object $splitloc is split \".\n                      \"but only across a single sequence\\n\";\n\t    }\n  Function: Determine whether this location is split across a single or\n            multiple sequences.\n\n            This implementation ignores (sub-)locations that do not define\n            seq_id(). The same holds true for the root location.\n\n  Returns : TRUE if all sublocations lie on the same sequence as the root\n            location (feature), and FALSE otherwise.\n  Args    : none\n\n\nsub is_single_sequence {\n    my ($self) = @_;\n\n    my $seqid = $self->seq_id();\n    foreach my $loc ($self->sub_Location(0)) {\n\t$seqid = $loc->seq_id() if(! $seqid);\n\tif(defined($loc->seq_id()) && ($loc->seq_id() ne $seqid)) {\n\t    return 0;\n\t}\n    }\n    return 1;\n}\n\n=head2 guide_strand\n\n  Title   : guide_strand\n  Usage   : $str = $loc->guide_strand();\n  Function: Get/Set the guide strand.  Of use only if the split type is\n            a 'join' (this helps determine the order of sublocation\n\t\t\tretrieval)\n  Returns : value of guide strand (1, -1, or undef)\n  Args    : new value (-1 or 1, optional)\n\n\nsub guide_strand {\n\tmy $self = shift;\n\treturn $self->{'strand'} = shift if @_;\n\treturn $self->{'strand'};\n}\n\n=head1 LocationI methods\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand($newval)\n Function: For SplitLocations, setting the strand of the container\n           (this object) is a short-cut for setting the strand of all\n           sublocations.\n\n           In get-mode, checks if no sub-location is remote, and if\n           all have the same strand. If so, it returns that shared\n           strand value. Otherwise it returns undef.\n\n Example : \n Returns : on get, value of strand if identical between sublocations \n           (-1, 1, or undef)\n Args    : new value (-1 or 1, optional)\n\n\n\nsub strand{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t\t$self->{'strand'} = $value;\n\t\t# propagate to all sublocs\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t$loc->strand($value);\n\t\t}\n    } else {\n\t\tmy ($strand, $lstrand);\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t# we give up upon any location that's remote or doesn't have\n\t\t\t# the strand specified, or has a differing one set than \n\t\t\t# previously seen.\n\t\t\t# calling strand() is potentially expensive if the subloc is also\n\t\t\t# a split location, so we cache it\n\t\t\t$lstrand = $loc->strand();\n\t\t\tif((! $lstrand) ||\n\t\t\t   ($strand && ($strand != $lstrand)) ||\n\t\t\t   $loc->is_remote()) {\n\t\t\t$strand = undef;\n\t\t\tlast;\n\t\t\t} elsif(! $strand) {\n\t\t\t$strand = $lstrand;\n\t\t\t}\n\t\t}\n\t\treturn $strand;\n    }\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite.  Also switch Split strand\n            from undef to -1 or -1 to undef\n  Returns : None\n  Args    : None\n\n\nsub flip_strand {\n    my $self = shift;\n    for my $loc ( $self->sub_Location(0) ) {\n\t\t$loc->flip_strand;\n\t\tif ($loc->isa('Bio::Location::SplitLocationI')) {\n\t\t\tmy $gs = ($self->guide_strand == -1) ? undef : -1;\n\t\t\t$loc->guide_strand($gs);\n\t\t}\n    }\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $location->start();\n  Function: get the starting point of the first (sorted) sublocation\n  Returns : integer\n  Args    : none\n\n\nsub start {\n    my ($self,$value) = @_;    \n    if( defined $value ) {\n\t$self->throw(\"Trying to set the starting point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $location->end();\n  Function: get the ending point of the last (sorted) sublocation\n  Returns : integer\n  Args    : none\n\n\nsub end {\n    my ($self,$value) = @_;    \n    if( defined $value ) {\n\t$self->throw(\"Trying to set the ending point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    return $self->SUPER::end();\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : $min_start = $location->min_start();\n  Function: get the minimum starting point\n  Returns : the minimum starting point from the contained sublocations\n  Args    : none","parameters":[{"label":"$self"},{"label":"$value"}],"label":"min_start($self,$value)"},"containerName":"Bio::Location::Split","definition":"sub","line":438,"children":[{"definition":"my","name":"$self","containerName":"min_start","localvar":"my","kind":13,"line":439},{"line":439,"kind":13,"containerName":"min_start","name":"$value"},{"line":441,"kind":13,"name":"$value","containerName":"min_start"},{"line":442,"kind":13,"name":"$self","containerName":"min_start"},{"kind":12,"line":442,"name":"throw","containerName":"min_start"},{"localvar":"my","containerName":"min_start","definition":"my","name":"@locs","line":445,"kind":13},{"line":445,"kind":13,"containerName":"min_start","name":"$self"},{"kind":12,"line":445,"name":"sub_Location","containerName":"min_start"},{"name":"$locs","containerName":"min_start","kind":13,"line":446},{"name":"min_start","containerName":"min_start","line":446,"kind":12},{"line":446,"kind":13,"name":"@locs","containerName":"min_start"}],"kind":12},{"children":[{"kind":13,"line":461,"name":"$self","definition":"my","containerName":"max_start","localvar":"my"},{"containerName":"max_start","name":"$value","kind":13,"line":461},{"kind":13,"line":463,"name":"$value","containerName":"max_start"},{"containerName":"max_start","name":"$self","kind":13,"line":464},{"line":464,"kind":12,"containerName":"max_start","name":"throw"},{"line":467,"kind":13,"localvar":"my","containerName":"max_start","name":"@locs","definition":"my"},{"kind":13,"line":467,"name":"$self","containerName":"max_start"},{"line":467,"kind":12,"name":"sub_Location","containerName":"max_start"},{"name":"$locs","containerName":"max_start","kind":13,"line":468},{"kind":12,"line":468,"containerName":"max_start","name":"max_start"},{"kind":13,"line":468,"name":"@locs","containerName":"max_start"}],"line":460,"kind":12,"signature":{"label":"max_start($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Split.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Split\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Split - Implementation of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Split;\n\n    my $splitlocation = Bio::Location::Split->new();\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>1,\n\t\t\t\t\t\t\t       -end=>30,\n\t\t\t\t\t\t\t       -strand=>1));\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>50,\n\t\t\t\t\t\t\t       -end=>61,\n\t\t\t\t\t\t\t       -strand=>1));   \n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start } \n\t\t\t   @sublocs ) {\n\tprintf \"sub feature %d [%d..%d]\\n\", \n\t       $count, $location->start,$location->end, \"\\n\";\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis implementation handles locations which span more than one\nstart/end location, or and/or lie on different sequences, and can\nwork with split locations that depend on the specific order of the\nsublocations ('join') or don't have a specific order but represent\na feature spanning discontiguous sublocations ('order', 'bond').\n\nNote that the order in which sublocations are added may be very important,\ndepending on the specific split location type.  For instance, a 'join'\nmust have the sublocations added in the order that one expects to\njoin the sublocations, whereas all other types are sorted based on the\nsequence location.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl_DOT_org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Split;\n\n# as defined by BSANE 0.03\nour @CORBALOCATIONOPERATOR = ('NONE','JOIN', undef, 'ORDER');;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Location::Atomic Bio::Location::SplitLocationI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    # initialize\n    $self->{'_sublocations'} = [];\n    my ( $type, $seqid, $locations ) = \n\t$self->_rearrange([qw(SPLITTYPE\n                              SEQ_ID\n\t\t\t      LOCATIONS\n                              )], @args);\n    if( defined $locations && ref($locations) =~ /array/i ) {\n\t$self->add_sub_Location(@$locations);\n    }\n    $seqid  && $self->seq_id($seqid);\n    $type = lc ($type);    \n    $self->splittype($type || 'JOIN');\n    return $self;\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location()\n\n\nsub each_Location {\n    my ($self, $order) = @_;\n    my @locs = ();\n    foreach my $subloc ($self->sub_Location($order)) {\n\t# Recursively check to get hierarchical split locations:\n\tpush @locs, $subloc->each_Location($order);\n    }\n    return @locs;\n}\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @sublocs = $splitloc->sub_Location();\n Function: Returns the array of sublocations making up this compound (split)\n           location. Those sublocations referring to the same sequence as\n           the root split location will be sorted by start position (forward\n           sort) or end position (reverse sort) and come first (before\n           those on other sequences).\n\n           The sort order can be optionally specified or suppressed by the\n           value of the first argument. The default is no sort.\n\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optionally 1, 0, or -1 for specifying a forward, no, or reverse\n           sort order\n\n\nsub sub_Location {\n    my ($self, $order) = @_;\n    $order = 0 unless defined $order;\n    if( defined($order) && ($order !~ /^-?\\d+$/) ) {\n\t$self->throw(\"value $order passed in to sub_Location is $order, an invalid value\");\n    } \n    $order = 1 if($order > 1);\n    $order = -1 if($order < -1);\n    my @sublocs = defined $self->{'_sublocations'} ? @{$self->{'_sublocations'}} : ();\n\n    # return the array if no ordering requested\n    return @sublocs if( ($order == 0) || (! @sublocs) );\n    \t\n    # sort those locations that are on the same sequence as the top (`master')\n    # if the top seq is undefined, we take the first defined in a sublocation\n    my $seqid = $self->seq_id();\n    my $i = 0;\n    while((! defined($seqid)) && ($i <= $#sublocs)) {\n\t\t$seqid = $sublocs[$i++]->seq_id();\n    }\n    if((! $self->seq_id()) && $seqid) {\n\t\t$self->warn(\"sorted sublocation array requested but \".\n\t\t\t\t\"root location doesn't define seq_id \".\n\t\t\t\t\"(at least one sublocation does!)\");\n    }\n    my @locs = ($seqid ?\n\t\tgrep { $_->seq_id() eq $seqid; } @sublocs :\n\t\t@sublocs);\n    if(@locs) {\n\t\tif($order == 1) {\n\t\t\t# Schwartzian transforms for performance boost\t  \n\t\t\t@locs = map { $_->[0] }\n\t\t\tsort {\n\t\t\t\t(defined $a && defined $b) ? $a->[1] <=> $b->[1] :\n                $a                         ?  -1                 : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->start ? $_->start : $_->end)]\n\t\t\t\t} @locs;;\n\t\t} else { # $order == -1\n\t\t\t@locs = map { $_->[0]}\n\t\t\tsort { \n\t\t\t\t(defined $a && defined $b) ? $b->[1] <=> $a->[1] :\n\t\t\t\t$a                         ? -1                  : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->end ? $_->end : $_->start)]\n\t\t\t\t} @locs;\n\t\t}\n    }\n    # push the rest unsorted\n    if($seqid) {\n\t\tpush(@locs, grep { $_->seq_id() ne $seqid; } @sublocs);\n    }\n    # done!\n\n    return @locs;\n}\n\n=head2 add_sub_Location\n\n Title   : add_sub_Location\n Usage   : $splitloc->add_sub_Location(@locationIobjs);\n Function: add an additional sublocation\n Returns : number of current sub locations\n Args    : list of Bio::LocationI implementing object(s) to add\n\n\nsub add_sub_Location {\n    my ($self,@args) = @_;\n    my @locs;    \n    foreach my $loc ( @args ) {\n\tif( !ref($loc) || ! $loc->isa('Bio::LocationI') ) {\n\t    $self->throw(\"Trying to add $loc as a sub Location but it doesn't implement Bio::LocationI!\");\n\t    next;\n\t}\t\n\tpush @{$self->{'_sublocations'}}, $loc;\n    }\n\n    return scalar @{$self->{'_sublocations'}};\n}\n\n=head2 splittype\n\n  Title   : splittype\n  Usage   : $splittype = $location->splittype();\n  Function: get/set the split splittype\n  Returns : the splittype of split feature (join, order)\n  Args    : splittype to set\n\n\nsub splittype {\n    my ($self, $value) = @_;\n    if( defined $value || ! defined $self->{'_splittype'} ) {\n\t$value = 'JOIN' unless( defined $value );\n\t$self->{'_splittype'} = uc ($value);\n    }\n    return $self->{'_splittype'};\n}\n\n=head2 is_single_sequence\n\n  Title   : is_single_sequence\n  Usage   : if($splitloc->is_single_sequence()) {\n                print \"Location object $splitloc is split \".\n                      \"but only across a single sequence\\n\";\n\t    }\n  Function: Determine whether this location is split across a single or\n            multiple sequences.\n\n            This implementation ignores (sub-)locations that do not define\n            seq_id(). The same holds true for the root location.\n\n  Returns : TRUE if all sublocations lie on the same sequence as the root\n            location (feature), and FALSE otherwise.\n  Args    : none\n\n\nsub is_single_sequence {\n    my ($self) = @_;\n\n    my $seqid = $self->seq_id();\n    foreach my $loc ($self->sub_Location(0)) {\n\t$seqid = $loc->seq_id() if(! $seqid);\n\tif(defined($loc->seq_id()) && ($loc->seq_id() ne $seqid)) {\n\t    return 0;\n\t}\n    }\n    return 1;\n}\n\n=head2 guide_strand\n\n  Title   : guide_strand\n  Usage   : $str = $loc->guide_strand();\n  Function: Get/Set the guide strand.  Of use only if the split type is\n            a 'join' (this helps determine the order of sublocation\n\t\t\tretrieval)\n  Returns : value of guide strand (1, -1, or undef)\n  Args    : new value (-1 or 1, optional)\n\n\nsub guide_strand {\n\tmy $self = shift;\n\treturn $self->{'strand'} = shift if @_;\n\treturn $self->{'strand'};\n}\n\n=head1 LocationI methods\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand($newval)\n Function: For SplitLocations, setting the strand of the container\n           (this object) is a short-cut for setting the strand of all\n           sublocations.\n\n           In get-mode, checks if no sub-location is remote, and if\n           all have the same strand. If so, it returns that shared\n           strand value. Otherwise it returns undef.\n\n Example : \n Returns : on get, value of strand if identical between sublocations \n           (-1, 1, or undef)\n Args    : new value (-1 or 1, optional)\n\n\n\nsub strand{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t\t$self->{'strand'} = $value;\n\t\t# propagate to all sublocs\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t$loc->strand($value);\n\t\t}\n    } else {\n\t\tmy ($strand, $lstrand);\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t# we give up upon any location that's remote or doesn't have\n\t\t\t# the strand specified, or has a differing one set than \n\t\t\t# previously seen.\n\t\t\t# calling strand() is potentially expensive if the subloc is also\n\t\t\t# a split location, so we cache it\n\t\t\t$lstrand = $loc->strand();\n\t\t\tif((! $lstrand) ||\n\t\t\t   ($strand && ($strand != $lstrand)) ||\n\t\t\t   $loc->is_remote()) {\n\t\t\t$strand = undef;\n\t\t\tlast;\n\t\t\t} elsif(! $strand) {\n\t\t\t$strand = $lstrand;\n\t\t\t}\n\t\t}\n\t\treturn $strand;\n    }\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite.  Also switch Split strand\n            from undef to -1 or -1 to undef\n  Returns : None\n  Args    : None\n\n\nsub flip_strand {\n    my $self = shift;\n    for my $loc ( $self->sub_Location(0) ) {\n\t\t$loc->flip_strand;\n\t\tif ($loc->isa('Bio::Location::SplitLocationI')) {\n\t\t\tmy $gs = ($self->guide_strand == -1) ? undef : -1;\n\t\t\t$loc->guide_strand($gs);\n\t\t}\n    }\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $location->start();\n  Function: get the starting point of the first (sorted) sublocation\n  Returns : integer\n  Args    : none\n\n\nsub start {\n    my ($self,$value) = @_;    \n    if( defined $value ) {\n\t$self->throw(\"Trying to set the starting point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $location->end();\n  Function: get the ending point of the last (sorted) sublocation\n  Returns : integer\n  Args    : none\n\n\nsub end {\n    my ($self,$value) = @_;    \n    if( defined $value ) {\n\t$self->throw(\"Trying to set the ending point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    return $self->SUPER::end();\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : $min_start = $location->min_start();\n  Function: get the minimum starting point\n  Returns : the minimum starting point from the contained sublocations\n  Args    : none\n\n\nsub min_start {\n    my ($self, $value) = @_;    \n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the minimum starting point of a split \".\n\t\t\t\t \"location, that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location(1);\n    return $locs[0]->min_start() if @locs; \n    return;\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting location of feature startpoint  \n  Returns : integer or undef if no maximum starting point.\n  Args    : none"},"detail":"($self,$value)","definition":"sub","containerName":"Bio::Location::Split","range":{"start":{"line":460,"character":0},"end":{"line":470,"character":9999}},"name":"max_start"},{"name":"start_pos_type","range":{"start":{"character":0,"line":483},"end":{"character":9999,"line":492}},"kind":12,"children":[{"kind":13,"line":484,"containerName":"start_pos_type","definition":"my","name":"$self","localvar":"my"},{"line":484,"kind":13,"name":"$value","containerName":"start_pos_type"},{"containerName":"start_pos_type","name":"$value","line":486,"kind":13},{"name":"$self","containerName":"start_pos_type","line":487,"kind":13},{"kind":12,"line":487,"containerName":"start_pos_type","name":"throw"},{"kind":13,"line":490,"definition":"my","name":"@locs","containerName":"start_pos_type","localvar":"my"},{"name":"$self","containerName":"start_pos_type","kind":13,"line":490},{"name":"sub_Location","containerName":"start_pos_type","kind":12,"line":490},{"line":491,"kind":13,"containerName":"start_pos_type","name":"@locs"},{"name":"$locs","containerName":"start_pos_type","line":491,"kind":13},{"kind":12,"line":491,"containerName":"start_pos_type","name":"start_pos_type"}],"line":483,"definition":"sub","containerName":"Bio::Location::Split","signature":{"label":"start_pos_type($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Split.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Split\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Split - Implementation of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Split;\n\n    my $splitlocation = Bio::Location::Split->new();\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>1,\n\t\t\t\t\t\t\t       -end=>30,\n\t\t\t\t\t\t\t       -strand=>1));\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>50,\n\t\t\t\t\t\t\t       -end=>61,\n\t\t\t\t\t\t\t       -strand=>1));   \n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start } \n\t\t\t   @sublocs ) {\n\tprintf \"sub feature %d [%d..%d]\\n\", \n\t       $count, $location->start,$location->end, \"\\n\";\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis implementation handles locations which span more than one\nstart/end location, or and/or lie on different sequences, and can\nwork with split locations that depend on the specific order of the\nsublocations ('join') or don't have a specific order but represent\na feature spanning discontiguous sublocations ('order', 'bond').\n\nNote that the order in which sublocations are added may be very important,\ndepending on the specific split location type.  For instance, a 'join'\nmust have the sublocations added in the order that one expects to\njoin the sublocations, whereas all other types are sorted based on the\nsequence location.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl_DOT_org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Split;\n\n# as defined by BSANE 0.03\nour @CORBALOCATIONOPERATOR = ('NONE','JOIN', undef, 'ORDER');;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Location::Atomic Bio::Location::SplitLocationI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    # initialize\n    $self->{'_sublocations'} = [];\n    my ( $type, $seqid, $locations ) = \n\t$self->_rearrange([qw(SPLITTYPE\n                              SEQ_ID\n\t\t\t      LOCATIONS\n                              )], @args);\n    if( defined $locations && ref($locations) =~ /array/i ) {\n\t$self->add_sub_Location(@$locations);\n    }\n    $seqid  && $self->seq_id($seqid);\n    $type = lc ($type);    \n    $self->splittype($type || 'JOIN');\n    return $self;\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location()\n\n\nsub each_Location {\n    my ($self, $order) = @_;\n    my @locs = ();\n    foreach my $subloc ($self->sub_Location($order)) {\n\t# Recursively check to get hierarchical split locations:\n\tpush @locs, $subloc->each_Location($order);\n    }\n    return @locs;\n}\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @sublocs = $splitloc->sub_Location();\n Function: Returns the array of sublocations making up this compound (split)\n           location. Those sublocations referring to the same sequence as\n           the root split location will be sorted by start position (forward\n           sort) or end position (reverse sort) and come first (before\n           those on other sequences).\n\n           The sort order can be optionally specified or suppressed by the\n           value of the first argument. The default is no sort.\n\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optionally 1, 0, or -1 for specifying a forward, no, or reverse\n           sort order\n\n\nsub sub_Location {\n    my ($self, $order) = @_;\n    $order = 0 unless defined $order;\n    if( defined($order) && ($order !~ /^-?\\d+$/) ) {\n\t$self->throw(\"value $order passed in to sub_Location is $order, an invalid value\");\n    } \n    $order = 1 if($order > 1);\n    $order = -1 if($order < -1);\n    my @sublocs = defined $self->{'_sublocations'} ? @{$self->{'_sublocations'}} : ();\n\n    # return the array if no ordering requested\n    return @sublocs if( ($order == 0) || (! @sublocs) );\n    \t\n    # sort those locations that are on the same sequence as the top (`master')\n    # if the top seq is undefined, we take the first defined in a sublocation\n    my $seqid = $self->seq_id();\n    my $i = 0;\n    while((! defined($seqid)) && ($i <= $#sublocs)) {\n\t\t$seqid = $sublocs[$i++]->seq_id();\n    }\n    if((! $self->seq_id()) && $seqid) {\n\t\t$self->warn(\"sorted sublocation array requested but \".\n\t\t\t\t\"root location doesn't define seq_id \".\n\t\t\t\t\"(at least one sublocation does!)\");\n    }\n    my @locs = ($seqid ?\n\t\tgrep { $_->seq_id() eq $seqid; } @sublocs :\n\t\t@sublocs);\n    if(@locs) {\n\t\tif($order == 1) {\n\t\t\t# Schwartzian transforms for performance boost\t  \n\t\t\t@locs = map { $_->[0] }\n\t\t\tsort {\n\t\t\t\t(defined $a && defined $b) ? $a->[1] <=> $b->[1] :\n                $a                         ?  -1                 : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->start ? $_->start : $_->end)]\n\t\t\t\t} @locs;;\n\t\t} else { # $order == -1\n\t\t\t@locs = map { $_->[0]}\n\t\t\tsort { \n\t\t\t\t(defined $a && defined $b) ? $b->[1] <=> $a->[1] :\n\t\t\t\t$a                         ? -1                  : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->end ? $_->end : $_->start)]\n\t\t\t\t} @locs;\n\t\t}\n    }\n    # push the rest unsorted\n    if($seqid) {\n\t\tpush(@locs, grep { $_->seq_id() ne $seqid; } @sublocs);\n    }\n    # done!\n\n    return @locs;\n}\n\n=head2 add_sub_Location\n\n Title   : add_sub_Location\n Usage   : $splitloc->add_sub_Location(@locationIobjs);\n Function: add an additional sublocation\n Returns : number of current sub locations\n Args    : list of Bio::LocationI implementing object(s) to add\n\n\nsub add_sub_Location {\n    my ($self,@args) = @_;\n    my @locs;    \n    foreach my $loc ( @args ) {\n\tif( !ref($loc) || ! $loc->isa('Bio::LocationI') ) {\n\t    $self->throw(\"Trying to add $loc as a sub Location but it doesn't implement Bio::LocationI!\");\n\t    next;\n\t}\t\n\tpush @{$self->{'_sublocations'}}, $loc;\n    }\n\n    return scalar @{$self->{'_sublocations'}};\n}\n\n=head2 splittype\n\n  Title   : splittype\n  Usage   : $splittype = $location->splittype();\n  Function: get/set the split splittype\n  Returns : the splittype of split feature (join, order)\n  Args    : splittype to set\n\n\nsub splittype {\n    my ($self, $value) = @_;\n    if( defined $value || ! defined $self->{'_splittype'} ) {\n\t$value = 'JOIN' unless( defined $value );\n\t$self->{'_splittype'} = uc ($value);\n    }\n    return $self->{'_splittype'};\n}\n\n=head2 is_single_sequence\n\n  Title   : is_single_sequence\n  Usage   : if($splitloc->is_single_sequence()) {\n                print \"Location object $splitloc is split \".\n                      \"but only across a single sequence\\n\";\n\t    }\n  Function: Determine whether this location is split across a single or\n            multiple sequences.\n\n            This implementation ignores (sub-)locations that do not define\n            seq_id(). The same holds true for the root location.\n\n  Returns : TRUE if all sublocations lie on the same sequence as the root\n            location (feature), and FALSE otherwise.\n  Args    : none\n\n\nsub is_single_sequence {\n    my ($self) = @_;\n\n    my $seqid = $self->seq_id();\n    foreach my $loc ($self->sub_Location(0)) {\n\t$seqid = $loc->seq_id() if(! $seqid);\n\tif(defined($loc->seq_id()) && ($loc->seq_id() ne $seqid)) {\n\t    return 0;\n\t}\n    }\n    return 1;\n}\n\n=head2 guide_strand\n\n  Title   : guide_strand\n  Usage   : $str = $loc->guide_strand();\n  Function: Get/Set the guide strand.  Of use only if the split type is\n            a 'join' (this helps determine the order of sublocation\n\t\t\tretrieval)\n  Returns : value of guide strand (1, -1, or undef)\n  Args    : new value (-1 or 1, optional)\n\n\nsub guide_strand {\n\tmy $self = shift;\n\treturn $self->{'strand'} = shift if @_;\n\treturn $self->{'strand'};\n}\n\n=head1 LocationI methods\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand($newval)\n Function: For SplitLocations, setting the strand of the container\n           (this object) is a short-cut for setting the strand of all\n           sublocations.\n\n           In get-mode, checks if no sub-location is remote, and if\n           all have the same strand. If so, it returns that shared\n           strand value. Otherwise it returns undef.\n\n Example : \n Returns : on get, value of strand if identical between sublocations \n           (-1, 1, or undef)\n Args    : new value (-1 or 1, optional)\n\n\n\nsub strand{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t\t$self->{'strand'} = $value;\n\t\t# propagate to all sublocs\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t$loc->strand($value);\n\t\t}\n    } else {\n\t\tmy ($strand, $lstrand);\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t# we give up upon any location that's remote or doesn't have\n\t\t\t# the strand specified, or has a differing one set than \n\t\t\t# previously seen.\n\t\t\t# calling strand() is potentially expensive if the subloc is also\n\t\t\t# a split location, so we cache it\n\t\t\t$lstrand = $loc->strand();\n\t\t\tif((! $lstrand) ||\n\t\t\t   ($strand && ($strand != $lstrand)) ||\n\t\t\t   $loc->is_remote()) {\n\t\t\t$strand = undef;\n\t\t\tlast;\n\t\t\t} elsif(! $strand) {\n\t\t\t$strand = $lstrand;\n\t\t\t}\n\t\t}\n\t\treturn $strand;\n    }\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite.  Also switch Split strand\n            from undef to -1 or -1 to undef\n  Returns : None\n  Args    : None\n\n\nsub flip_strand {\n    my $self = shift;\n    for my $loc ( $self->sub_Location(0) ) {\n\t\t$loc->flip_strand;\n\t\tif ($loc->isa('Bio::Location::SplitLocationI')) {\n\t\t\tmy $gs = ($self->guide_strand == -1) ? undef : -1;\n\t\t\t$loc->guide_strand($gs);\n\t\t}\n    }\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $location->start();\n  Function: get the starting point of the first (sorted) sublocation\n  Returns : integer\n  Args    : none\n\n\nsub start {\n    my ($self,$value) = @_;    \n    if( defined $value ) {\n\t$self->throw(\"Trying to set the starting point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $location->end();\n  Function: get the ending point of the last (sorted) sublocation\n  Returns : integer\n  Args    : none\n\n\nsub end {\n    my ($self,$value) = @_;    \n    if( defined $value ) {\n\t$self->throw(\"Trying to set the ending point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    return $self->SUPER::end();\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : $min_start = $location->min_start();\n  Function: get the minimum starting point\n  Returns : the minimum starting point from the contained sublocations\n  Args    : none\n\n\nsub min_start {\n    my ($self, $value) = @_;    \n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the minimum starting point of a split \".\n\t\t\t\t \"location, that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location(1);\n    return $locs[0]->min_start() if @locs; \n    return;\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting location of feature startpoint  \n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\nsub max_start {\n    my ($self,$value) = @_;\n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the maximum starting point of a split \".\n\t\t\t\t \"location, that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location(1);\n    return $locs[0]->max_start() if @locs; \n    return;\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type (ie <,>, ^) \n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none"},"detail":"($self,$value)"},{"range":{"start":{"line":504,"character":0},"end":{"character":9999,"line":515}},"name":"min_end","children":[{"line":505,"kind":13,"localvar":"my","containerName":"min_end","name":"$self","definition":"my"},{"kind":13,"line":505,"containerName":"min_end","name":"$value"},{"line":507,"kind":13,"name":"$value","containerName":"min_end"},{"containerName":"min_end","name":"$self","line":508,"kind":13},{"kind":12,"line":508,"name":"throw","containerName":"min_end"},{"containerName":"min_end","name":"@locs","definition":"my","localvar":"my","kind":13,"line":512},{"kind":13,"line":512,"containerName":"min_end","name":"$self"},{"name":"sub_Location","containerName":"min_end","kind":12,"line":512},{"kind":13,"line":513,"containerName":"min_end","name":"$locs"},{"name":"min_end","containerName":"min_end","line":513,"kind":12},{"containerName":"min_end","name":"@locs","line":513,"kind":13}],"line":504,"kind":12,"signature":{"label":"min_end($self,$value)","documentation":"1;\n# $Id: Split.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Split\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Split - Implementation of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Split;\n\n    my $splitlocation = Bio::Location::Split->new();\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>1,\n\t\t\t\t\t\t\t       -end=>30,\n\t\t\t\t\t\t\t       -strand=>1));\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>50,\n\t\t\t\t\t\t\t       -end=>61,\n\t\t\t\t\t\t\t       -strand=>1));   \n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start } \n\t\t\t   @sublocs ) {\n\tprintf \"sub feature %d [%d..%d]\\n\", \n\t       $count, $location->start,$location->end, \"\\n\";\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis implementation handles locations which span more than one\nstart/end location, or and/or lie on different sequences, and can\nwork with split locations that depend on the specific order of the\nsublocations ('join') or don't have a specific order but represent\na feature spanning discontiguous sublocations ('order', 'bond').\n\nNote that the order in which sublocations are added may be very important,\ndepending on the specific split location type.  For instance, a 'join'\nmust have the sublocations added in the order that one expects to\njoin the sublocations, whereas all other types are sorted based on the\nsequence location.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl_DOT_org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Split;\n\n# as defined by BSANE 0.03\nour @CORBALOCATIONOPERATOR = ('NONE','JOIN', undef, 'ORDER');;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Location::Atomic Bio::Location::SplitLocationI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    # initialize\n    $self->{'_sublocations'} = [];\n    my ( $type, $seqid, $locations ) = \n\t$self->_rearrange([qw(SPLITTYPE\n                              SEQ_ID\n\t\t\t      LOCATIONS\n                              )], @args);\n    if( defined $locations && ref($locations) =~ /array/i ) {\n\t$self->add_sub_Location(@$locations);\n    }\n    $seqid  && $self->seq_id($seqid);\n    $type = lc ($type);    \n    $self->splittype($type || 'JOIN');\n    return $self;\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location()\n\n\nsub each_Location {\n    my ($self, $order) = @_;\n    my @locs = ();\n    foreach my $subloc ($self->sub_Location($order)) {\n\t# Recursively check to get hierarchical split locations:\n\tpush @locs, $subloc->each_Location($order);\n    }\n    return @locs;\n}\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @sublocs = $splitloc->sub_Location();\n Function: Returns the array of sublocations making up this compound (split)\n           location. Those sublocations referring to the same sequence as\n           the root split location will be sorted by start position (forward\n           sort) or end position (reverse sort) and come first (before\n           those on other sequences).\n\n           The sort order can be optionally specified or suppressed by the\n           value of the first argument. The default is no sort.\n\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optionally 1, 0, or -1 for specifying a forward, no, or reverse\n           sort order\n\n\nsub sub_Location {\n    my ($self, $order) = @_;\n    $order = 0 unless defined $order;\n    if( defined($order) && ($order !~ /^-?\\d+$/) ) {\n\t$self->throw(\"value $order passed in to sub_Location is $order, an invalid value\");\n    } \n    $order = 1 if($order > 1);\n    $order = -1 if($order < -1);\n    my @sublocs = defined $self->{'_sublocations'} ? @{$self->{'_sublocations'}} : ();\n\n    # return the array if no ordering requested\n    return @sublocs if( ($order == 0) || (! @sublocs) );\n    \t\n    # sort those locations that are on the same sequence as the top (`master')\n    # if the top seq is undefined, we take the first defined in a sublocation\n    my $seqid = $self->seq_id();\n    my $i = 0;\n    while((! defined($seqid)) && ($i <= $#sublocs)) {\n\t\t$seqid = $sublocs[$i++]->seq_id();\n    }\n    if((! $self->seq_id()) && $seqid) {\n\t\t$self->warn(\"sorted sublocation array requested but \".\n\t\t\t\t\"root location doesn't define seq_id \".\n\t\t\t\t\"(at least one sublocation does!)\");\n    }\n    my @locs = ($seqid ?\n\t\tgrep { $_->seq_id() eq $seqid; } @sublocs :\n\t\t@sublocs);\n    if(@locs) {\n\t\tif($order == 1) {\n\t\t\t# Schwartzian transforms for performance boost\t  \n\t\t\t@locs = map { $_->[0] }\n\t\t\tsort {\n\t\t\t\t(defined $a && defined $b) ? $a->[1] <=> $b->[1] :\n                $a                         ?  -1                 : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->start ? $_->start : $_->end)]\n\t\t\t\t} @locs;;\n\t\t} else { # $order == -1\n\t\t\t@locs = map { $_->[0]}\n\t\t\tsort { \n\t\t\t\t(defined $a && defined $b) ? $b->[1] <=> $a->[1] :\n\t\t\t\t$a                         ? -1                  : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->end ? $_->end : $_->start)]\n\t\t\t\t} @locs;\n\t\t}\n    }\n    # push the rest unsorted\n    if($seqid) {\n\t\tpush(@locs, grep { $_->seq_id() ne $seqid; } @sublocs);\n    }\n    # done!\n\n    return @locs;\n}\n\n=head2 add_sub_Location\n\n Title   : add_sub_Location\n Usage   : $splitloc->add_sub_Location(@locationIobjs);\n Function: add an additional sublocation\n Returns : number of current sub locations\n Args    : list of Bio::LocationI implementing object(s) to add\n\n\nsub add_sub_Location {\n    my ($self,@args) = @_;\n    my @locs;    \n    foreach my $loc ( @args ) {\n\tif( !ref($loc) || ! $loc->isa('Bio::LocationI') ) {\n\t    $self->throw(\"Trying to add $loc as a sub Location but it doesn't implement Bio::LocationI!\");\n\t    next;\n\t}\t\n\tpush @{$self->{'_sublocations'}}, $loc;\n    }\n\n    return scalar @{$self->{'_sublocations'}};\n}\n\n=head2 splittype\n\n  Title   : splittype\n  Usage   : $splittype = $location->splittype();\n  Function: get/set the split splittype\n  Returns : the splittype of split feature (join, order)\n  Args    : splittype to set\n\n\nsub splittype {\n    my ($self, $value) = @_;\n    if( defined $value || ! defined $self->{'_splittype'} ) {\n\t$value = 'JOIN' unless( defined $value );\n\t$self->{'_splittype'} = uc ($value);\n    }\n    return $self->{'_splittype'};\n}\n\n=head2 is_single_sequence\n\n  Title   : is_single_sequence\n  Usage   : if($splitloc->is_single_sequence()) {\n                print \"Location object $splitloc is split \".\n                      \"but only across a single sequence\\n\";\n\t    }\n  Function: Determine whether this location is split across a single or\n            multiple sequences.\n\n            This implementation ignores (sub-)locations that do not define\n            seq_id(). The same holds true for the root location.\n\n  Returns : TRUE if all sublocations lie on the same sequence as the root\n            location (feature), and FALSE otherwise.\n  Args    : none\n\n\nsub is_single_sequence {\n    my ($self) = @_;\n\n    my $seqid = $self->seq_id();\n    foreach my $loc ($self->sub_Location(0)) {\n\t$seqid = $loc->seq_id() if(! $seqid);\n\tif(defined($loc->seq_id()) && ($loc->seq_id() ne $seqid)) {\n\t    return 0;\n\t}\n    }\n    return 1;\n}\n\n=head2 guide_strand\n\n  Title   : guide_strand\n  Usage   : $str = $loc->guide_strand();\n  Function: Get/Set the guide strand.  Of use only if the split type is\n            a 'join' (this helps determine the order of sublocation\n\t\t\tretrieval)\n  Returns : value of guide strand (1, -1, or undef)\n  Args    : new value (-1 or 1, optional)\n\n\nsub guide_strand {\n\tmy $self = shift;\n\treturn $self->{'strand'} = shift if @_;\n\treturn $self->{'strand'};\n}\n\n=head1 LocationI methods\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand($newval)\n Function: For SplitLocations, setting the strand of the container\n           (this object) is a short-cut for setting the strand of all\n           sublocations.\n\n           In get-mode, checks if no sub-location is remote, and if\n           all have the same strand. If so, it returns that shared\n           strand value. Otherwise it returns undef.\n\n Example : \n Returns : on get, value of strand if identical between sublocations \n           (-1, 1, or undef)\n Args    : new value (-1 or 1, optional)\n\n\n\nsub strand{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t\t$self->{'strand'} = $value;\n\t\t# propagate to all sublocs\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t$loc->strand($value);\n\t\t}\n    } else {\n\t\tmy ($strand, $lstrand);\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t# we give up upon any location that's remote or doesn't have\n\t\t\t# the strand specified, or has a differing one set than \n\t\t\t# previously seen.\n\t\t\t# calling strand() is potentially expensive if the subloc is also\n\t\t\t# a split location, so we cache it\n\t\t\t$lstrand = $loc->strand();\n\t\t\tif((! $lstrand) ||\n\t\t\t   ($strand && ($strand != $lstrand)) ||\n\t\t\t   $loc->is_remote()) {\n\t\t\t$strand = undef;\n\t\t\tlast;\n\t\t\t} elsif(! $strand) {\n\t\t\t$strand = $lstrand;\n\t\t\t}\n\t\t}\n\t\treturn $strand;\n    }\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite.  Also switch Split strand\n            from undef to -1 or -1 to undef\n  Returns : None\n  Args    : None\n\n\nsub flip_strand {\n    my $self = shift;\n    for my $loc ( $self->sub_Location(0) ) {\n\t\t$loc->flip_strand;\n\t\tif ($loc->isa('Bio::Location::SplitLocationI')) {\n\t\t\tmy $gs = ($self->guide_strand == -1) ? undef : -1;\n\t\t\t$loc->guide_strand($gs);\n\t\t}\n    }\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $location->start();\n  Function: get the starting point of the first (sorted) sublocation\n  Returns : integer\n  Args    : none\n\n\nsub start {\n    my ($self,$value) = @_;    \n    if( defined $value ) {\n\t$self->throw(\"Trying to set the starting point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $location->end();\n  Function: get the ending point of the last (sorted) sublocation\n  Returns : integer\n  Args    : none\n\n\nsub end {\n    my ($self,$value) = @_;    \n    if( defined $value ) {\n\t$self->throw(\"Trying to set the ending point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    return $self->SUPER::end();\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : $min_start = $location->min_start();\n  Function: get the minimum starting point\n  Returns : the minimum starting point from the contained sublocations\n  Args    : none\n\n\nsub min_start {\n    my ($self, $value) = @_;    \n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the minimum starting point of a split \".\n\t\t\t\t \"location, that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location(1);\n    return $locs[0]->min_start() if @locs; \n    return;\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting location of feature startpoint  \n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\nsub max_start {\n    my ($self,$value) = @_;\n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the maximum starting point of a split \".\n\t\t\t\t \"location, that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location(1);\n    return $locs[0]->max_start() if @locs; \n    return;\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type (ie <,>, ^) \n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub start_pos_type {\n    my ($self,$value) = @_;\n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the start_pos_type of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location();\n    return ( @locs ) ? $locs[0]->start_pos_type() : undef;    \n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get minimum ending location of feature endpoint \n  Returns : integer or undef if no minimum ending point.\n  Args    : none","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","definition":"sub","containerName":"Bio::Location::Split"},{"definition":"sub","containerName":"Bio::Location::Split","signature":{"documentation":"1;\n# $Id: Split.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Split\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Split - Implementation of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Split;\n\n    my $splitlocation = Bio::Location::Split->new();\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>1,\n\t\t\t\t\t\t\t       -end=>30,\n\t\t\t\t\t\t\t       -strand=>1));\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>50,\n\t\t\t\t\t\t\t       -end=>61,\n\t\t\t\t\t\t\t       -strand=>1));   \n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start } \n\t\t\t   @sublocs ) {\n\tprintf \"sub feature %d [%d..%d]\\n\", \n\t       $count, $location->start,$location->end, \"\\n\";\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis implementation handles locations which span more than one\nstart/end location, or and/or lie on different sequences, and can\nwork with split locations that depend on the specific order of the\nsublocations ('join') or don't have a specific order but represent\na feature spanning discontiguous sublocations ('order', 'bond').\n\nNote that the order in which sublocations are added may be very important,\ndepending on the specific split location type.  For instance, a 'join'\nmust have the sublocations added in the order that one expects to\njoin the sublocations, whereas all other types are sorted based on the\nsequence location.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl_DOT_org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Split;\n\n# as defined by BSANE 0.03\nour @CORBALOCATIONOPERATOR = ('NONE','JOIN', undef, 'ORDER');;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Location::Atomic Bio::Location::SplitLocationI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    # initialize\n    $self->{'_sublocations'} = [];\n    my ( $type, $seqid, $locations ) = \n\t$self->_rearrange([qw(SPLITTYPE\n                              SEQ_ID\n\t\t\t      LOCATIONS\n                              )], @args);\n    if( defined $locations && ref($locations) =~ /array/i ) {\n\t$self->add_sub_Location(@$locations);\n    }\n    $seqid  && $self->seq_id($seqid);\n    $type = lc ($type);    \n    $self->splittype($type || 'JOIN');\n    return $self;\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location()\n\n\nsub each_Location {\n    my ($self, $order) = @_;\n    my @locs = ();\n    foreach my $subloc ($self->sub_Location($order)) {\n\t# Recursively check to get hierarchical split locations:\n\tpush @locs, $subloc->each_Location($order);\n    }\n    return @locs;\n}\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @sublocs = $splitloc->sub_Location();\n Function: Returns the array of sublocations making up this compound (split)\n           location. Those sublocations referring to the same sequence as\n           the root split location will be sorted by start position (forward\n           sort) or end position (reverse sort) and come first (before\n           those on other sequences).\n\n           The sort order can be optionally specified or suppressed by the\n           value of the first argument. The default is no sort.\n\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optionally 1, 0, or -1 for specifying a forward, no, or reverse\n           sort order\n\n\nsub sub_Location {\n    my ($self, $order) = @_;\n    $order = 0 unless defined $order;\n    if( defined($order) && ($order !~ /^-?\\d+$/) ) {\n\t$self->throw(\"value $order passed in to sub_Location is $order, an invalid value\");\n    } \n    $order = 1 if($order > 1);\n    $order = -1 if($order < -1);\n    my @sublocs = defined $self->{'_sublocations'} ? @{$self->{'_sublocations'}} : ();\n\n    # return the array if no ordering requested\n    return @sublocs if( ($order == 0) || (! @sublocs) );\n    \t\n    # sort those locations that are on the same sequence as the top (`master')\n    # if the top seq is undefined, we take the first defined in a sublocation\n    my $seqid = $self->seq_id();\n    my $i = 0;\n    while((! defined($seqid)) && ($i <= $#sublocs)) {\n\t\t$seqid = $sublocs[$i++]->seq_id();\n    }\n    if((! $self->seq_id()) && $seqid) {\n\t\t$self->warn(\"sorted sublocation array requested but \".\n\t\t\t\t\"root location doesn't define seq_id \".\n\t\t\t\t\"(at least one sublocation does!)\");\n    }\n    my @locs = ($seqid ?\n\t\tgrep { $_->seq_id() eq $seqid; } @sublocs :\n\t\t@sublocs);\n    if(@locs) {\n\t\tif($order == 1) {\n\t\t\t# Schwartzian transforms for performance boost\t  \n\t\t\t@locs = map { $_->[0] }\n\t\t\tsort {\n\t\t\t\t(defined $a && defined $b) ? $a->[1] <=> $b->[1] :\n                $a                         ?  -1                 : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->start ? $_->start : $_->end)]\n\t\t\t\t} @locs;;\n\t\t} else { # $order == -1\n\t\t\t@locs = map { $_->[0]}\n\t\t\tsort { \n\t\t\t\t(defined $a && defined $b) ? $b->[1] <=> $a->[1] :\n\t\t\t\t$a                         ? -1                  : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->end ? $_->end : $_->start)]\n\t\t\t\t} @locs;\n\t\t}\n    }\n    # push the rest unsorted\n    if($seqid) {\n\t\tpush(@locs, grep { $_->seq_id() ne $seqid; } @sublocs);\n    }\n    # done!\n\n    return @locs;\n}\n\n=head2 add_sub_Location\n\n Title   : add_sub_Location\n Usage   : $splitloc->add_sub_Location(@locationIobjs);\n Function: add an additional sublocation\n Returns : number of current sub locations\n Args    : list of Bio::LocationI implementing object(s) to add\n\n\nsub add_sub_Location {\n    my ($self,@args) = @_;\n    my @locs;    \n    foreach my $loc ( @args ) {\n\tif( !ref($loc) || ! $loc->isa('Bio::LocationI') ) {\n\t    $self->throw(\"Trying to add $loc as a sub Location but it doesn't implement Bio::LocationI!\");\n\t    next;\n\t}\t\n\tpush @{$self->{'_sublocations'}}, $loc;\n    }\n\n    return scalar @{$self->{'_sublocations'}};\n}\n\n=head2 splittype\n\n  Title   : splittype\n  Usage   : $splittype = $location->splittype();\n  Function: get/set the split splittype\n  Returns : the splittype of split feature (join, order)\n  Args    : splittype to set\n\n\nsub splittype {\n    my ($self, $value) = @_;\n    if( defined $value || ! defined $self->{'_splittype'} ) {\n\t$value = 'JOIN' unless( defined $value );\n\t$self->{'_splittype'} = uc ($value);\n    }\n    return $self->{'_splittype'};\n}\n\n=head2 is_single_sequence\n\n  Title   : is_single_sequence\n  Usage   : if($splitloc->is_single_sequence()) {\n                print \"Location object $splitloc is split \".\n                      \"but only across a single sequence\\n\";\n\t    }\n  Function: Determine whether this location is split across a single or\n            multiple sequences.\n\n            This implementation ignores (sub-)locations that do not define\n            seq_id(). The same holds true for the root location.\n\n  Returns : TRUE if all sublocations lie on the same sequence as the root\n            location (feature), and FALSE otherwise.\n  Args    : none\n\n\nsub is_single_sequence {\n    my ($self) = @_;\n\n    my $seqid = $self->seq_id();\n    foreach my $loc ($self->sub_Location(0)) {\n\t$seqid = $loc->seq_id() if(! $seqid);\n\tif(defined($loc->seq_id()) && ($loc->seq_id() ne $seqid)) {\n\t    return 0;\n\t}\n    }\n    return 1;\n}\n\n=head2 guide_strand\n\n  Title   : guide_strand\n  Usage   : $str = $loc->guide_strand();\n  Function: Get/Set the guide strand.  Of use only if the split type is\n            a 'join' (this helps determine the order of sublocation\n\t\t\tretrieval)\n  Returns : value of guide strand (1, -1, or undef)\n  Args    : new value (-1 or 1, optional)\n\n\nsub guide_strand {\n\tmy $self = shift;\n\treturn $self->{'strand'} = shift if @_;\n\treturn $self->{'strand'};\n}\n\n=head1 LocationI methods\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand($newval)\n Function: For SplitLocations, setting the strand of the container\n           (this object) is a short-cut for setting the strand of all\n           sublocations.\n\n           In get-mode, checks if no sub-location is remote, and if\n           all have the same strand. If so, it returns that shared\n           strand value. Otherwise it returns undef.\n\n Example : \n Returns : on get, value of strand if identical between sublocations \n           (-1, 1, or undef)\n Args    : new value (-1 or 1, optional)\n\n\n\nsub strand{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t\t$self->{'strand'} = $value;\n\t\t# propagate to all sublocs\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t$loc->strand($value);\n\t\t}\n    } else {\n\t\tmy ($strand, $lstrand);\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t# we give up upon any location that's remote or doesn't have\n\t\t\t# the strand specified, or has a differing one set than \n\t\t\t# previously seen.\n\t\t\t# calling strand() is potentially expensive if the subloc is also\n\t\t\t# a split location, so we cache it\n\t\t\t$lstrand = $loc->strand();\n\t\t\tif((! $lstrand) ||\n\t\t\t   ($strand && ($strand != $lstrand)) ||\n\t\t\t   $loc->is_remote()) {\n\t\t\t$strand = undef;\n\t\t\tlast;\n\t\t\t} elsif(! $strand) {\n\t\t\t$strand = $lstrand;\n\t\t\t}\n\t\t}\n\t\treturn $strand;\n    }\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite.  Also switch Split strand\n            from undef to -1 or -1 to undef\n  Returns : None\n  Args    : None\n\n\nsub flip_strand {\n    my $self = shift;\n    for my $loc ( $self->sub_Location(0) ) {\n\t\t$loc->flip_strand;\n\t\tif ($loc->isa('Bio::Location::SplitLocationI')) {\n\t\t\tmy $gs = ($self->guide_strand == -1) ? undef : -1;\n\t\t\t$loc->guide_strand($gs);\n\t\t}\n    }\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $location->start();\n  Function: get the starting point of the first (sorted) sublocation\n  Returns : integer\n  Args    : none\n\n\nsub start {\n    my ($self,$value) = @_;    \n    if( defined $value ) {\n\t$self->throw(\"Trying to set the starting point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $location->end();\n  Function: get the ending point of the last (sorted) sublocation\n  Returns : integer\n  Args    : none\n\n\nsub end {\n    my ($self,$value) = @_;    \n    if( defined $value ) {\n\t$self->throw(\"Trying to set the ending point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    return $self->SUPER::end();\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : $min_start = $location->min_start();\n  Function: get the minimum starting point\n  Returns : the minimum starting point from the contained sublocations\n  Args    : none\n\n\nsub min_start {\n    my ($self, $value) = @_;    \n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the minimum starting point of a split \".\n\t\t\t\t \"location, that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location(1);\n    return $locs[0]->min_start() if @locs; \n    return;\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting location of feature startpoint  \n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\nsub max_start {\n    my ($self,$value) = @_;\n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the maximum starting point of a split \".\n\t\t\t\t \"location, that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location(1);\n    return $locs[0]->max_start() if @locs; \n    return;\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type (ie <,>, ^) \n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub start_pos_type {\n    my ($self,$value) = @_;\n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the start_pos_type of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location();\n    return ( @locs ) ? $locs[0]->start_pos_type() : undef;    \n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get minimum ending location of feature endpoint \n  Returns : integer or undef if no minimum ending point.\n  Args    : none\n\n\nsub min_end {\n    my ($self,$value) = @_;\n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the minimum end point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    # reverse sort locations by largest ending to smallest ending\n    my @locs = $self->sub_Location(-1);\n    return $locs[0]->min_end() if @locs; \n    return;\n}\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get maximum ending location of feature endpoint \n  Returns : integer or undef if no maximum ending point.\n  Args    : none","parameters":[{"label":"$self"},{"label":"$value"}],"label":"max_end($self,$value)"},"detail":"($self,$value)","kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"max_end","line":528,"kind":13},{"kind":13,"line":528,"name":"$value","containerName":"max_end"},{"kind":13,"line":530,"containerName":"max_end","name":"$value"},{"line":531,"kind":13,"containerName":"max_end","name":"$self"},{"kind":12,"line":531,"containerName":"max_end","name":"throw"},{"localvar":"my","containerName":"max_end","definition":"my","name":"@locs","line":535,"kind":13},{"containerName":"max_end","name":"$self","kind":13,"line":535},{"containerName":"max_end","name":"sub_Location","kind":12,"line":535},{"line":536,"kind":13,"name":"$locs","containerName":"max_end"},{"line":536,"kind":12,"containerName":"max_end","name":"max_end"},{"kind":13,"line":536,"containerName":"max_end","name":"@locs"}],"line":527,"name":"max_end","range":{"start":{"line":527,"character":0},"end":{"character":9999,"line":538}}},{"name":"end_pos_type","range":{"start":{"character":0,"line":551},"end":{"line":560,"character":9999}},"containerName":"Bio::Location::Split","definition":"sub","detail":"($self,$value)","signature":{"label":"end_pos_type($self,$value)","documentation":"1;\n# $Id: Split.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Split\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Split - Implementation of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Split;\n\n    my $splitlocation = Bio::Location::Split->new();\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>1,\n\t\t\t\t\t\t\t       -end=>30,\n\t\t\t\t\t\t\t       -strand=>1));\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>50,\n\t\t\t\t\t\t\t       -end=>61,\n\t\t\t\t\t\t\t       -strand=>1));   \n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start } \n\t\t\t   @sublocs ) {\n\tprintf \"sub feature %d [%d..%d]\\n\", \n\t       $count, $location->start,$location->end, \"\\n\";\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis implementation handles locations which span more than one\nstart/end location, or and/or lie on different sequences, and can\nwork with split locations that depend on the specific order of the\nsublocations ('join') or don't have a specific order but represent\na feature spanning discontiguous sublocations ('order', 'bond').\n\nNote that the order in which sublocations are added may be very important,\ndepending on the specific split location type.  For instance, a 'join'\nmust have the sublocations added in the order that one expects to\njoin the sublocations, whereas all other types are sorted based on the\nsequence location.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl_DOT_org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Split;\n\n# as defined by BSANE 0.03\nour @CORBALOCATIONOPERATOR = ('NONE','JOIN', undef, 'ORDER');;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Location::Atomic Bio::Location::SplitLocationI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    # initialize\n    $self->{'_sublocations'} = [];\n    my ( $type, $seqid, $locations ) = \n\t$self->_rearrange([qw(SPLITTYPE\n                              SEQ_ID\n\t\t\t      LOCATIONS\n                              )], @args);\n    if( defined $locations && ref($locations) =~ /array/i ) {\n\t$self->add_sub_Location(@$locations);\n    }\n    $seqid  && $self->seq_id($seqid);\n    $type = lc ($type);    \n    $self->splittype($type || 'JOIN');\n    return $self;\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location()\n\n\nsub each_Location {\n    my ($self, $order) = @_;\n    my @locs = ();\n    foreach my $subloc ($self->sub_Location($order)) {\n\t# Recursively check to get hierarchical split locations:\n\tpush @locs, $subloc->each_Location($order);\n    }\n    return @locs;\n}\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @sublocs = $splitloc->sub_Location();\n Function: Returns the array of sublocations making up this compound (split)\n           location. Those sublocations referring to the same sequence as\n           the root split location will be sorted by start position (forward\n           sort) or end position (reverse sort) and come first (before\n           those on other sequences).\n\n           The sort order can be optionally specified or suppressed by the\n           value of the first argument. The default is no sort.\n\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optionally 1, 0, or -1 for specifying a forward, no, or reverse\n           sort order\n\n\nsub sub_Location {\n    my ($self, $order) = @_;\n    $order = 0 unless defined $order;\n    if( defined($order) && ($order !~ /^-?\\d+$/) ) {\n\t$self->throw(\"value $order passed in to sub_Location is $order, an invalid value\");\n    } \n    $order = 1 if($order > 1);\n    $order = -1 if($order < -1);\n    my @sublocs = defined $self->{'_sublocations'} ? @{$self->{'_sublocations'}} : ();\n\n    # return the array if no ordering requested\n    return @sublocs if( ($order == 0) || (! @sublocs) );\n    \t\n    # sort those locations that are on the same sequence as the top (`master')\n    # if the top seq is undefined, we take the first defined in a sublocation\n    my $seqid = $self->seq_id();\n    my $i = 0;\n    while((! defined($seqid)) && ($i <= $#sublocs)) {\n\t\t$seqid = $sublocs[$i++]->seq_id();\n    }\n    if((! $self->seq_id()) && $seqid) {\n\t\t$self->warn(\"sorted sublocation array requested but \".\n\t\t\t\t\"root location doesn't define seq_id \".\n\t\t\t\t\"(at least one sublocation does!)\");\n    }\n    my @locs = ($seqid ?\n\t\tgrep { $_->seq_id() eq $seqid; } @sublocs :\n\t\t@sublocs);\n    if(@locs) {\n\t\tif($order == 1) {\n\t\t\t# Schwartzian transforms for performance boost\t  \n\t\t\t@locs = map { $_->[0] }\n\t\t\tsort {\n\t\t\t\t(defined $a && defined $b) ? $a->[1] <=> $b->[1] :\n                $a                         ?  -1                 : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->start ? $_->start : $_->end)]\n\t\t\t\t} @locs;;\n\t\t} else { # $order == -1\n\t\t\t@locs = map { $_->[0]}\n\t\t\tsort { \n\t\t\t\t(defined $a && defined $b) ? $b->[1] <=> $a->[1] :\n\t\t\t\t$a                         ? -1                  : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->end ? $_->end : $_->start)]\n\t\t\t\t} @locs;\n\t\t}\n    }\n    # push the rest unsorted\n    if($seqid) {\n\t\tpush(@locs, grep { $_->seq_id() ne $seqid; } @sublocs);\n    }\n    # done!\n\n    return @locs;\n}\n\n=head2 add_sub_Location\n\n Title   : add_sub_Location\n Usage   : $splitloc->add_sub_Location(@locationIobjs);\n Function: add an additional sublocation\n Returns : number of current sub locations\n Args    : list of Bio::LocationI implementing object(s) to add\n\n\nsub add_sub_Location {\n    my ($self,@args) = @_;\n    my @locs;    \n    foreach my $loc ( @args ) {\n\tif( !ref($loc) || ! $loc->isa('Bio::LocationI') ) {\n\t    $self->throw(\"Trying to add $loc as a sub Location but it doesn't implement Bio::LocationI!\");\n\t    next;\n\t}\t\n\tpush @{$self->{'_sublocations'}}, $loc;\n    }\n\n    return scalar @{$self->{'_sublocations'}};\n}\n\n=head2 splittype\n\n  Title   : splittype\n  Usage   : $splittype = $location->splittype();\n  Function: get/set the split splittype\n  Returns : the splittype of split feature (join, order)\n  Args    : splittype to set\n\n\nsub splittype {\n    my ($self, $value) = @_;\n    if( defined $value || ! defined $self->{'_splittype'} ) {\n\t$value = 'JOIN' unless( defined $value );\n\t$self->{'_splittype'} = uc ($value);\n    }\n    return $self->{'_splittype'};\n}\n\n=head2 is_single_sequence\n\n  Title   : is_single_sequence\n  Usage   : if($splitloc->is_single_sequence()) {\n                print \"Location object $splitloc is split \".\n                      \"but only across a single sequence\\n\";\n\t    }\n  Function: Determine whether this location is split across a single or\n            multiple sequences.\n\n            This implementation ignores (sub-)locations that do not define\n            seq_id(). The same holds true for the root location.\n\n  Returns : TRUE if all sublocations lie on the same sequence as the root\n            location (feature), and FALSE otherwise.\n  Args    : none\n\n\nsub is_single_sequence {\n    my ($self) = @_;\n\n    my $seqid = $self->seq_id();\n    foreach my $loc ($self->sub_Location(0)) {\n\t$seqid = $loc->seq_id() if(! $seqid);\n\tif(defined($loc->seq_id()) && ($loc->seq_id() ne $seqid)) {\n\t    return 0;\n\t}\n    }\n    return 1;\n}\n\n=head2 guide_strand\n\n  Title   : guide_strand\n  Usage   : $str = $loc->guide_strand();\n  Function: Get/Set the guide strand.  Of use only if the split type is\n            a 'join' (this helps determine the order of sublocation\n\t\t\tretrieval)\n  Returns : value of guide strand (1, -1, or undef)\n  Args    : new value (-1 or 1, optional)\n\n\nsub guide_strand {\n\tmy $self = shift;\n\treturn $self->{'strand'} = shift if @_;\n\treturn $self->{'strand'};\n}\n\n=head1 LocationI methods\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand($newval)\n Function: For SplitLocations, setting the strand of the container\n           (this object) is a short-cut for setting the strand of all\n           sublocations.\n\n           In get-mode, checks if no sub-location is remote, and if\n           all have the same strand. If so, it returns that shared\n           strand value. Otherwise it returns undef.\n\n Example : \n Returns : on get, value of strand if identical between sublocations \n           (-1, 1, or undef)\n Args    : new value (-1 or 1, optional)\n\n\n\nsub strand{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t\t$self->{'strand'} = $value;\n\t\t# propagate to all sublocs\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t$loc->strand($value);\n\t\t}\n    } else {\n\t\tmy ($strand, $lstrand);\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t# we give up upon any location that's remote or doesn't have\n\t\t\t# the strand specified, or has a differing one set than \n\t\t\t# previously seen.\n\t\t\t# calling strand() is potentially expensive if the subloc is also\n\t\t\t# a split location, so we cache it\n\t\t\t$lstrand = $loc->strand();\n\t\t\tif((! $lstrand) ||\n\t\t\t   ($strand && ($strand != $lstrand)) ||\n\t\t\t   $loc->is_remote()) {\n\t\t\t$strand = undef;\n\t\t\tlast;\n\t\t\t} elsif(! $strand) {\n\t\t\t$strand = $lstrand;\n\t\t\t}\n\t\t}\n\t\treturn $strand;\n    }\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite.  Also switch Split strand\n            from undef to -1 or -1 to undef\n  Returns : None\n  Args    : None\n\n\nsub flip_strand {\n    my $self = shift;\n    for my $loc ( $self->sub_Location(0) ) {\n\t\t$loc->flip_strand;\n\t\tif ($loc->isa('Bio::Location::SplitLocationI')) {\n\t\t\tmy $gs = ($self->guide_strand == -1) ? undef : -1;\n\t\t\t$loc->guide_strand($gs);\n\t\t}\n    }\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $location->start();\n  Function: get the starting point of the first (sorted) sublocation\n  Returns : integer\n  Args    : none\n\n\nsub start {\n    my ($self,$value) = @_;    \n    if( defined $value ) {\n\t$self->throw(\"Trying to set the starting point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $location->end();\n  Function: get the ending point of the last (sorted) sublocation\n  Returns : integer\n  Args    : none\n\n\nsub end {\n    my ($self,$value) = @_;    \n    if( defined $value ) {\n\t$self->throw(\"Trying to set the ending point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    return $self->SUPER::end();\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : $min_start = $location->min_start();\n  Function: get the minimum starting point\n  Returns : the minimum starting point from the contained sublocations\n  Args    : none\n\n\nsub min_start {\n    my ($self, $value) = @_;    \n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the minimum starting point of a split \".\n\t\t\t\t \"location, that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location(1);\n    return $locs[0]->min_start() if @locs; \n    return;\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting location of feature startpoint  \n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\nsub max_start {\n    my ($self,$value) = @_;\n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the maximum starting point of a split \".\n\t\t\t\t \"location, that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location(1);\n    return $locs[0]->max_start() if @locs; \n    return;\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type (ie <,>, ^) \n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub start_pos_type {\n    my ($self,$value) = @_;\n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the start_pos_type of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location();\n    return ( @locs ) ? $locs[0]->start_pos_type() : undef;    \n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get minimum ending location of feature endpoint \n  Returns : integer or undef if no minimum ending point.\n  Args    : none\n\n\nsub min_end {\n    my ($self,$value) = @_;\n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the minimum end point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    # reverse sort locations by largest ending to smallest ending\n    my @locs = $self->sub_Location(-1);\n    return $locs[0]->min_end() if @locs; \n    return;\n}\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get maximum ending location of feature endpoint \n  Returns : integer or undef if no maximum ending point.\n  Args    : none\n\n\nsub max_end {\n    my ($self,$value) = @_;\n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the maximum end point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    # reverse sort locations by largest ending to smallest ending\n    my @locs = $self->sub_Location(-1);\n    return $locs[0]->max_end() if @locs; \n    return;\n}\n\n=head2 end_pos_type\n\n  Title   : end_pos_type\n  Usage   : my $end_pos_type = $location->end_pos_type();\n  Function: Get end position type (ie <,>, ^) \n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none","parameters":[{"label":"$self"},{"label":"$value"}]},"kind":12,"line":551,"children":[{"kind":13,"line":552,"name":"$self","definition":"my","containerName":"end_pos_type","localvar":"my"},{"containerName":"end_pos_type","name":"$value","line":552,"kind":13},{"line":554,"kind":13,"containerName":"end_pos_type","name":"$value"},{"name":"$self","containerName":"end_pos_type","kind":13,"line":555},{"kind":12,"line":555,"name":"throw","containerName":"end_pos_type"},{"kind":13,"line":558,"name":"@locs","definition":"my","containerName":"end_pos_type","localvar":"my"},{"kind":13,"line":558,"containerName":"end_pos_type","name":"$self"},{"line":558,"kind":12,"name":"sub_Location","containerName":"end_pos_type"},{"line":559,"kind":13,"containerName":"end_pos_type","name":"@locs"},{"containerName":"end_pos_type","name":"$locs","kind":13,"line":559},{"kind":12,"line":559,"name":"end_pos_type","containerName":"end_pos_type"}]},{"children":[{"kind":13,"line":578,"containerName":"seq_id","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":580,"name":"$self","containerName":"seq_id"},{"containerName":"seq_id","name":"is_remote","line":580,"kind":12},{"localvar":"my","definition":"my","name":"$subloc","containerName":"seq_id","line":581,"kind":13},{"kind":13,"line":581,"name":"$self","containerName":"seq_id"},{"containerName":"seq_id","name":"sub_Location","kind":12,"line":581},{"name":"$subloc","containerName":"seq_id","line":582,"kind":13},{"containerName":"seq_id","name":"seq_id","line":582,"kind":12},{"kind":13,"line":582,"name":"$subloc","containerName":"seq_id"},{"kind":12,"line":582,"containerName":"seq_id","name":"is_remote"},{"name":"$self","containerName":"seq_id","line":585,"kind":13}],"line":577,"kind":12,"range":{"start":{"line":577,"character":0},"end":{"character":9999,"line":586}},"name":"seq_id","definition":"sub","containerName":"Bio::Location::Split"},{"containerName":"seq_id","name":"SUPER","line":585,"kind":12},{"kind":12,"children":[{"definition":"my","name":"$self","containerName":"to_FTstring","localvar":"my","kind":13,"line":624},{"containerName":"to_FTstring","name":"@strs","definition":"my","localvar":"my","kind":13,"line":625},{"definition":"my","name":"$strand","containerName":"to_FTstring","localvar":"my","kind":13,"line":626},{"line":626,"kind":13,"containerName":"to_FTstring","name":"$self"},{"name":"strand","containerName":"to_FTstring","line":626,"kind":12},{"kind":13,"line":627,"definition":"my","name":"$stype","containerName":"to_FTstring","localvar":"my"},{"name":"$self","containerName":"to_FTstring","kind":13,"line":627},{"line":627,"kind":12,"containerName":"to_FTstring","name":"splittype"},{"line":628,"kind":13,"localvar":"my","containerName":"to_FTstring","definition":"my","name":"$guide"},{"name":"$self","containerName":"to_FTstring","kind":13,"line":628},{"kind":12,"line":628,"containerName":"to_FTstring","name":"guide_strand"},{"containerName":"to_FTstring","name":"$strand","line":630,"kind":13},{"name":"$self","containerName":"to_FTstring","line":631,"kind":13},{"name":"flip_strand","containerName":"to_FTstring","kind":12,"line":631},{"line":637,"kind":13,"localvar":"my","definition":"my","name":"@locs","containerName":"to_FTstring"},{"containerName":"to_FTstring","name":"$stype","kind":13,"line":637},{"containerName":"to_FTstring","name":"$guide","line":637,"kind":13},{"name":"$strand","containerName":"to_FTstring","kind":13,"line":637},{"kind":13,"line":638,"name":"$self","containerName":"to_FTstring"},{"containerName":"to_FTstring","name":"sub_Location","line":638,"kind":12},{"name":"$self","containerName":"to_FTstring","line":638,"kind":13},{"name":"sub_Location","containerName":"to_FTstring","kind":12,"line":638},{"kind":13,"line":640,"containerName":"to_FTstring","definition":"my","name":"$loc","localvar":"my"},{"name":"@locs","containerName":"to_FTstring","line":640,"kind":13},{"containerName":"to_FTstring","name":"$loc","kind":13,"line":641},{"containerName":"to_FTstring","name":"verbose","kind":12,"line":641},{"name":"$self","containerName":"to_FTstring","line":641,"kind":13},{"containerName":"to_FTstring","name":"verbose","kind":12,"line":641},{"localvar":"my","name":"$str","definition":"my","containerName":"to_FTstring","line":642,"kind":13},{"containerName":"to_FTstring","name":"$loc","kind":13,"line":642},{"name":"to_FTstring","containerName":"to_FTstring","kind":12,"line":642},{"name":"$loc","containerName":"to_FTstring","kind":13,"line":646},{"kind":12,"line":646,"name":"is_remote","containerName":"to_FTstring"},{"name":"$self","containerName":"to_FTstring","kind":13,"line":647},{"name":"seq_id","containerName":"to_FTstring","line":647,"kind":12},{"name":"$loc","containerName":"to_FTstring","line":647,"kind":13},{"name":"seq_id","containerName":"to_FTstring","line":647,"kind":12},{"containerName":"to_FTstring","name":"$loc","kind":13,"line":648},{"containerName":"to_FTstring","name":"seq_id","line":648,"kind":12},{"containerName":"to_FTstring","name":"$self","kind":13,"line":648},{"kind":12,"line":648,"containerName":"to_FTstring","name":"seq_id"},{"name":"$str","containerName":"to_FTstring","kind":13,"line":649},{"kind":13,"line":649,"name":"$loc","containerName":"to_FTstring"},{"kind":12,"line":649,"containerName":"to_FTstring","name":"seq_id"},{"name":"$str","containerName":"to_FTstring","line":649,"kind":13},{"line":651,"kind":13,"containerName":"to_FTstring","name":"@strs"},{"name":"$str","containerName":"to_FTstring","kind":13,"line":651},{"line":653,"kind":13,"containerName":"to_FTstring","name":"$self"},{"containerName":"to_FTstring","name":"flip_strand","line":653,"kind":12},{"name":"$strand","containerName":"to_FTstring","line":653,"kind":13},{"containerName":"to_FTstring","definition":"my","name":"$str","localvar":"my","kind":13,"line":654},{"line":655,"kind":13,"name":"@strs","containerName":"to_FTstring"},{"line":656,"kind":13,"containerName":"to_FTstring","name":"$str"},{"containerName":"to_FTstring","name":"@strs","kind":13,"line":656},{"name":"@strs","containerName":"to_FTstring","line":657,"kind":13},{"containerName":"to_FTstring","name":"$self","line":658,"kind":13},{"containerName":"to_FTstring","name":"warn","line":658,"kind":12},{"line":660,"kind":13,"containerName":"to_FTstring","name":"$str"},{"containerName":"to_FTstring","name":"$self","line":660,"kind":13},{"containerName":"to_FTstring","name":"splittype","line":660,"kind":12},{"line":660,"kind":13,"containerName":"to_FTstring","name":"@strs"},{"name":"$strand","containerName":"to_FTstring","line":662,"kind":13},{"containerName":"to_FTstring","name":"$str","kind":13,"line":663},{"line":663,"kind":13,"containerName":"to_FTstring","name":"$str"},{"line":666,"kind":13,"name":"$str","containerName":"to_FTstring"}],"line":623,"definition":"sub","containerName":"Bio::Location::Split","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Split.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Split\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Split - Implementation of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Split;\n\n    my $splitlocation = Bio::Location::Split->new();\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>1,\n\t\t\t\t\t\t\t       -end=>30,\n\t\t\t\t\t\t\t       -strand=>1));\n    $splitlocation->add_sub_Location(Bio::Location::Simple->new(-start=>50,\n\t\t\t\t\t\t\t       -end=>61,\n\t\t\t\t\t\t\t       -strand=>1));   \n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start } \n\t\t\t   @sublocs ) {\n\tprintf \"sub feature %d [%d..%d]\\n\", \n\t       $count, $location->start,$location->end, \"\\n\";\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis implementation handles locations which span more than one\nstart/end location, or and/or lie on different sequences, and can\nwork with split locations that depend on the specific order of the\nsublocations ('join') or don't have a specific order but represent\na feature spanning discontiguous sublocations ('order', 'bond').\n\nNote that the order in which sublocations are added may be very important,\ndepending on the specific split location type.  For instance, a 'join'\nmust have the sublocations added in the order that one expects to\njoin the sublocations, whereas all other types are sorted based on the\nsequence location.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl_DOT_org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Split;\n\n# as defined by BSANE 0.03\nour @CORBALOCATIONOPERATOR = ('NONE','JOIN', undef, 'ORDER');;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Location::Atomic Bio::Location::SplitLocationI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    # initialize\n    $self->{'_sublocations'} = [];\n    my ( $type, $seqid, $locations ) = \n\t$self->_rearrange([qw(SPLITTYPE\n                              SEQ_ID\n\t\t\t      LOCATIONS\n                              )], @args);\n    if( defined $locations && ref($locations) =~ /array/i ) {\n\t$self->add_sub_Location(@$locations);\n    }\n    $seqid  && $self->seq_id($seqid);\n    $type = lc ($type);    \n    $self->splittype($type || 'JOIN');\n    return $self;\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optional sort order to be passed to sub_Location()\n\n\nsub each_Location {\n    my ($self, $order) = @_;\n    my @locs = ();\n    foreach my $subloc ($self->sub_Location($order)) {\n\t# Recursively check to get hierarchical split locations:\n\tpush @locs, $subloc->each_Location($order);\n    }\n    return @locs;\n}\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @sublocs = $splitloc->sub_Location();\n Function: Returns the array of sublocations making up this compound (split)\n           location. Those sublocations referring to the same sequence as\n           the root split location will be sorted by start position (forward\n           sort) or end position (reverse sort) and come first (before\n           those on other sequences).\n\n           The sort order can be optionally specified or suppressed by the\n           value of the first argument. The default is no sort.\n\n Returns : an array of Bio::LocationI implementing objects\n Args    : Optionally 1, 0, or -1 for specifying a forward, no, or reverse\n           sort order\n\n\nsub sub_Location {\n    my ($self, $order) = @_;\n    $order = 0 unless defined $order;\n    if( defined($order) && ($order !~ /^-?\\d+$/) ) {\n\t$self->throw(\"value $order passed in to sub_Location is $order, an invalid value\");\n    } \n    $order = 1 if($order > 1);\n    $order = -1 if($order < -1);\n    my @sublocs = defined $self->{'_sublocations'} ? @{$self->{'_sublocations'}} : ();\n\n    # return the array if no ordering requested\n    return @sublocs if( ($order == 0) || (! @sublocs) );\n    \t\n    # sort those locations that are on the same sequence as the top (`master')\n    # if the top seq is undefined, we take the first defined in a sublocation\n    my $seqid = $self->seq_id();\n    my $i = 0;\n    while((! defined($seqid)) && ($i <= $#sublocs)) {\n\t\t$seqid = $sublocs[$i++]->seq_id();\n    }\n    if((! $self->seq_id()) && $seqid) {\n\t\t$self->warn(\"sorted sublocation array requested but \".\n\t\t\t\t\"root location doesn't define seq_id \".\n\t\t\t\t\"(at least one sublocation does!)\");\n    }\n    my @locs = ($seqid ?\n\t\tgrep { $_->seq_id() eq $seqid; } @sublocs :\n\t\t@sublocs);\n    if(@locs) {\n\t\tif($order == 1) {\n\t\t\t# Schwartzian transforms for performance boost\t  \n\t\t\t@locs = map { $_->[0] }\n\t\t\tsort {\n\t\t\t\t(defined $a && defined $b) ? $a->[1] <=> $b->[1] :\n                $a                         ?  -1                 : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->start ? $_->start : $_->end)]\n\t\t\t\t} @locs;;\n\t\t} else { # $order == -1\n\t\t\t@locs = map { $_->[0]}\n\t\t\tsort { \n\t\t\t\t(defined $a && defined $b) ? $b->[1] <=> $a->[1] :\n\t\t\t\t$a                         ? -1                  : 1\n\t\t\t\t}\n\t\t\tmap {\n\t\t\t\t[$_, (defined $_->end ? $_->end : $_->start)]\n\t\t\t\t} @locs;\n\t\t}\n    }\n    # push the rest unsorted\n    if($seqid) {\n\t\tpush(@locs, grep { $_->seq_id() ne $seqid; } @sublocs);\n    }\n    # done!\n\n    return @locs;\n}\n\n=head2 add_sub_Location\n\n Title   : add_sub_Location\n Usage   : $splitloc->add_sub_Location(@locationIobjs);\n Function: add an additional sublocation\n Returns : number of current sub locations\n Args    : list of Bio::LocationI implementing object(s) to add\n\n\nsub add_sub_Location {\n    my ($self,@args) = @_;\n    my @locs;    \n    foreach my $loc ( @args ) {\n\tif( !ref($loc) || ! $loc->isa('Bio::LocationI') ) {\n\t    $self->throw(\"Trying to add $loc as a sub Location but it doesn't implement Bio::LocationI!\");\n\t    next;\n\t}\t\n\tpush @{$self->{'_sublocations'}}, $loc;\n    }\n\n    return scalar @{$self->{'_sublocations'}};\n}\n\n=head2 splittype\n\n  Title   : splittype\n  Usage   : $splittype = $location->splittype();\n  Function: get/set the split splittype\n  Returns : the splittype of split feature (join, order)\n  Args    : splittype to set\n\n\nsub splittype {\n    my ($self, $value) = @_;\n    if( defined $value || ! defined $self->{'_splittype'} ) {\n\t$value = 'JOIN' unless( defined $value );\n\t$self->{'_splittype'} = uc ($value);\n    }\n    return $self->{'_splittype'};\n}\n\n=head2 is_single_sequence\n\n  Title   : is_single_sequence\n  Usage   : if($splitloc->is_single_sequence()) {\n                print \"Location object $splitloc is split \".\n                      \"but only across a single sequence\\n\";\n\t    }\n  Function: Determine whether this location is split across a single or\n            multiple sequences.\n\n            This implementation ignores (sub-)locations that do not define\n            seq_id(). The same holds true for the root location.\n\n  Returns : TRUE if all sublocations lie on the same sequence as the root\n            location (feature), and FALSE otherwise.\n  Args    : none\n\n\nsub is_single_sequence {\n    my ($self) = @_;\n\n    my $seqid = $self->seq_id();\n    foreach my $loc ($self->sub_Location(0)) {\n\t$seqid = $loc->seq_id() if(! $seqid);\n\tif(defined($loc->seq_id()) && ($loc->seq_id() ne $seqid)) {\n\t    return 0;\n\t}\n    }\n    return 1;\n}\n\n=head2 guide_strand\n\n  Title   : guide_strand\n  Usage   : $str = $loc->guide_strand();\n  Function: Get/Set the guide strand.  Of use only if the split type is\n            a 'join' (this helps determine the order of sublocation\n\t\t\tretrieval)\n  Returns : value of guide strand (1, -1, or undef)\n  Args    : new value (-1 or 1, optional)\n\n\nsub guide_strand {\n\tmy $self = shift;\n\treturn $self->{'strand'} = shift if @_;\n\treturn $self->{'strand'};\n}\n\n=head1 LocationI methods\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand($newval)\n Function: For SplitLocations, setting the strand of the container\n           (this object) is a short-cut for setting the strand of all\n           sublocations.\n\n           In get-mode, checks if no sub-location is remote, and if\n           all have the same strand. If so, it returns that shared\n           strand value. Otherwise it returns undef.\n\n Example : \n Returns : on get, value of strand if identical between sublocations \n           (-1, 1, or undef)\n Args    : new value (-1 or 1, optional)\n\n\n\nsub strand{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t\t$self->{'strand'} = $value;\n\t\t# propagate to all sublocs\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t$loc->strand($value);\n\t\t}\n    } else {\n\t\tmy ($strand, $lstrand);\n\t\tforeach my $loc ($self->sub_Location(0)) {\n\t\t\t# we give up upon any location that's remote or doesn't have\n\t\t\t# the strand specified, or has a differing one set than \n\t\t\t# previously seen.\n\t\t\t# calling strand() is potentially expensive if the subloc is also\n\t\t\t# a split location, so we cache it\n\t\t\t$lstrand = $loc->strand();\n\t\t\tif((! $lstrand) ||\n\t\t\t   ($strand && ($strand != $lstrand)) ||\n\t\t\t   $loc->is_remote()) {\n\t\t\t$strand = undef;\n\t\t\tlast;\n\t\t\t} elsif(! $strand) {\n\t\t\t$strand = $lstrand;\n\t\t\t}\n\t\t}\n\t\treturn $strand;\n    }\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite.  Also switch Split strand\n            from undef to -1 or -1 to undef\n  Returns : None\n  Args    : None\n\n\nsub flip_strand {\n    my $self = shift;\n    for my $loc ( $self->sub_Location(0) ) {\n\t\t$loc->flip_strand;\n\t\tif ($loc->isa('Bio::Location::SplitLocationI')) {\n\t\t\tmy $gs = ($self->guide_strand == -1) ? undef : -1;\n\t\t\t$loc->guide_strand($gs);\n\t\t}\n    }\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $location->start();\n  Function: get the starting point of the first (sorted) sublocation\n  Returns : integer\n  Args    : none\n\n\nsub start {\n    my ($self,$value) = @_;    \n    if( defined $value ) {\n\t$self->throw(\"Trying to set the starting point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $location->end();\n  Function: get the ending point of the last (sorted) sublocation\n  Returns : integer\n  Args    : none\n\n\nsub end {\n    my ($self,$value) = @_;    \n    if( defined $value ) {\n\t$self->throw(\"Trying to set the ending point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    return $self->SUPER::end();\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : $min_start = $location->min_start();\n  Function: get the minimum starting point\n  Returns : the minimum starting point from the contained sublocations\n  Args    : none\n\n\nsub min_start {\n    my ($self, $value) = @_;    \n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the minimum starting point of a split \".\n\t\t\t\t \"location, that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location(1);\n    return $locs[0]->min_start() if @locs; \n    return;\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting location of feature startpoint  \n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\nsub max_start {\n    my ($self,$value) = @_;\n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the maximum starting point of a split \".\n\t\t\t\t \"location, that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location(1);\n    return $locs[0]->max_start() if @locs; \n    return;\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type (ie <,>, ^) \n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub start_pos_type {\n    my ($self,$value) = @_;\n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the start_pos_type of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location();\n    return ( @locs ) ? $locs[0]->start_pos_type() : undef;    \n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get minimum ending location of feature endpoint \n  Returns : integer or undef if no minimum ending point.\n  Args    : none\n\n\nsub min_end {\n    my ($self,$value) = @_;\n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the minimum end point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    # reverse sort locations by largest ending to smallest ending\n    my @locs = $self->sub_Location(-1);\n    return $locs[0]->min_end() if @locs; \n    return;\n}\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get maximum ending location of feature endpoint \n  Returns : integer or undef if no maximum ending point.\n  Args    : none\n\n\nsub max_end {\n    my ($self,$value) = @_;\n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set the maximum end point of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    # reverse sort locations by largest ending to smallest ending\n    my @locs = $self->sub_Location(-1);\n    return $locs[0]->max_end() if @locs; \n    return;\n}\n\n=head2 end_pos_type\n\n  Title   : end_pos_type\n  Usage   : my $end_pos_type = $location->end_pos_type();\n  Function: Get end position type (ie <,>, ^) \n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub end_pos_type {\n    my ($self,$value) = @_;\n\n    if( defined $value ) {\n\t$self->throw(\"Trying to set end_pos_type of a split location, \".\n\t\t\t\t \"that is not possible, try manipulating the sub Locations\");\n    }\n    my @locs = $self->sub_Location();\n    return ( @locs ) ? $locs[0]->end_pos_type() : undef;    \n}\n\n\n=head2 seq_id\n\n  Title   : seq_id\n  Usage   : my $seqid = $location->seq_id();\n  Function: Get/Set seq_id that location refers to\n\n            We override this here in order to propagate to all sublocations\n            which are not remote (provided this root is not remote either)\n  Returns : seq_id\n  Args    : [optional] seq_id value to set\n\n\n\nsub seq_id {\n    my $self = shift;\n\n    if(@_ && !$self->is_remote()) {\n\tforeach my $subloc ($self->sub_Location(0)) {\n\t    $subloc->seq_id(@_) if !$subloc->is_remote();\n\t}\n    }\n    return $self->SUPER::seq_id(@_);\n}\n\n=head2 coordinate_policy\n\n  Title   : coordinate_policy\n  Usage   : $policy = $location->coordinate_policy();\n            $location->coordinate_policy($mypolicy); # set may not be possible\n  Function: Get the coordinate computing policy employed by this object.\n\n            See Bio::Location::CoordinatePolicyI for documentation about\n            the policy object and its use.\n\n            The interface *does not* require implementing classes to accept\n            setting of a different policy. The implementation provided here\n            does, however, allow to do so.\n\n            Implementors of this interface are expected to initialize every\n            new instance with a CoordinatePolicyI object. The implementation\n            provided here will return a default policy object if none has\n            been set yet. To change this default policy object call this\n            method as a class method with an appropriate argument. Note that\n            in this case only subsequently created Location objects will be\n            affected.\n\n  Returns : A Bio::Location::CoordinatePolicyI implementing object.\n  Args    : On set, a Bio::Location::CoordinatePolicyI implementing object.\n\n=head2 to_FTstring\n\n  Title   : to_FTstring\n  Usage   : my $locstr = $location->to_FTstring()\n  Function: returns the FeatureTable string of this location\n  Returns : string\n  Args    : none","label":"to_FTstring($self)"},"detail":"($self)","name":"to_FTstring","range":{"end":{"character":9999,"line":667},"start":{"line":623,"character":0}}}],"version":5}