{"version":5,"vars":[{"line":84,"kind":2,"containerName":"","name":"base"},{"line":86,"kind":13,"containerName":"main::","name":"@LOCATIONCODESBSANE","definition":"our"},{"kind":13,"line":89,"name":"%FUZZYCODES","definition":"our","containerName":"main::"},{"containerName":"main::","name":"%FUZZYPOINTENCODE","definition":"our","line":107,"kind":13},{"line":118,"kind":13,"containerName":"main::","name":"%FUZZYRANGEENCODE","definition":"our"},{"range":{"end":{"character":9999,"line":161},"start":{"character":0,"line":146}},"name":"new","line":146,"children":[{"name":"$class","definition":"my","containerName":"new","localvar":"my","kind":13,"line":147},{"containerName":"new","name":"@args","kind":13,"line":147},{"kind":13,"line":148,"containerName":"new","definition":"my","name":"$self","localvar":"my"},{"containerName":"new","name":"$class","line":148,"kind":13},{"name":"@args","containerName":"new","line":148,"kind":13},{"containerName":"new","definition":"my","name":"$location_type","localvar":"my","kind":13,"line":149},{"kind":13,"line":149,"containerName":"new","name":"$start_ext"},{"line":149,"kind":13,"containerName":"new","name":"$start_fuz"},{"line":149,"kind":13,"name":"$end_ext","containerName":"new"},{"name":"$end_fuz","containerName":"new","kind":13,"line":149},{"containerName":"new","name":"$self","kind":13,"line":150},{"kind":12,"line":150,"containerName":"new","name":"_rearrange"},{"kind":13,"line":152,"containerName":"new","name":"@args"},{"containerName":"new","name":"$location_type","kind":13,"line":154},{"containerName":"new","name":"$self","kind":13,"line":154},{"containerName":"new","name":"location_type","line":154,"kind":12},{"name":"$location_type","containerName":"new","line":154,"kind":13},{"containerName":"new","name":"$start_ext","line":155,"kind":13},{"containerName":"new","name":"$self","line":155,"kind":13},{"name":"max_start","containerName":"new","kind":12,"line":155},{"kind":13,"line":155,"containerName":"new","name":"$self"},{"containerName":"new","name":"min_start","line":155,"kind":12},{"kind":13,"line":155,"name":"$start_ext","containerName":"new"},{"line":156,"kind":13,"containerName":"new","name":"$end_ext"},{"line":156,"kind":13,"name":"$self","containerName":"new"},{"line":156,"kind":12,"name":"max_end","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":156},{"name":"min_end","containerName":"new","kind":12,"line":156},{"name":"$end_ext","containerName":"new","kind":13,"line":156},{"kind":13,"line":157,"containerName":"new","name":"$start_fuz"},{"containerName":"new","name":"$self","kind":13,"line":157},{"containerName":"new","name":"start_pos_type","line":157,"kind":12},{"name":"$start_fuz","containerName":"new","line":157,"kind":13},{"containerName":"new","name":"$end_fuz","kind":13,"line":158},{"name":"$self","containerName":"new","kind":13,"line":158},{"name":"end_pos_type","containerName":"new","line":158,"kind":12},{"name":"$end_fuz","containerName":"new","line":158,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":160}],"kind":12,"detail":"($class,@args)","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Fuzzy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Fuzzy\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Fuzzy - Implementation of a Location on a Sequence\nwhich has unclear start and/or end locations\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Fuzzy;\n    my $fuzzylocation = Bio::Location::Fuzzy->new(\n                                                 -start => '<30',\n                                                 -end   => 90,\n                                                 -location_type => '..');\n\n    print \"location string is \", $fuzzylocation->to_FTstring(), \"\\n\";\n    print \"location is of the type \", $fuzzylocation->location_type, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis module contains the necessary methods for representing a\nFuzzy Location, one that does not have clear start and/or end points.\nThis will initially serve to handle features from Genbank/EMBL feature\ntables that are written as 1^100 meaning between bases 1 and 100 or\nE<lt>100..300 meaning it starts somewhere before 100.  Advanced\nimplementations of this interface may be able to handle the necessary\nlogic of overlaps/intersection/contains/union.  It was constructed to\nhandle fuzzy locations that can be represented in Genbank/EMBL and\nSwissprot.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Fuzzy;\nuse strict;\n\nuse base qw(Bio::Location::Atomic Bio::Location::FuzzyLocationI);\n\nour @LOCATIONCODESBSANE = (undef, 'EXACT', 'WITHIN', 'BETWEEN', 'UNCERTAIN',\n            'BEFORE', 'AFTER');\n\nour %FUZZYCODES = ( 'EXACT' => '..', # Position is 'exact\n   # Exact position is unknown, but is within the range specified, ((1.2)..100)\n            'WITHIN' => '.', \n            # 1^2\n            'BETWEEN'    => '^',\n            'IN-BETWEEN' => '^',\n            'UNCERTAIN'  => '?',\n            # <100\n            'BEFORE'  => '<',\n            # >10\n            'AFTER'   => '>');   \n   \n    # The following regular expressions map to fuzzy location types. Every\n    # expression must match the complete encoded point string, and must\n    # contain two groups identifying min and max. Empty matches are automatic.\n    # converted to undef, except for 'EXACT', for which max is set to equal\n    # min.\n    \nour %FUZZYPOINTENCODE = ( \n    '\\>(\\d+)(.{0})' => 'AFTER',\n    '\\<(.{0})(\\d+)' => 'BEFORE',\n    '(\\d+)'         => 'EXACT',\n    '\\?(\\d*)'       => 'UNCERTAIN',\n    '(\\d+)(.{0})\\>' => 'AFTER',\n    '(.{0})(\\d+)\\<' => 'BEFORE',\n    '(\\d+)\\.(\\d+)'  => 'WITHIN',\n    '(\\d+)\\^(\\d+)'  => 'BETWEEN',\n   );\n    \nour %FUZZYRANGEENCODE  = (  '\\.'   => 'WITHIN',\n                            '\\.\\.' => 'EXACT',\n                            '\\^'   => 'IN-BETWEEN' );\n\n=head2 new\n\n Title   : new\n Usage   : my $fuzzyloc = Bio::Location::Fuzzy->new( @args);\n Function:\n Returns : \n Args    : -start    => value for start  (initialize by superclass)\n           -end      => value for end    (initialize by superclass)\n           -strand   => value for strand (initialize by superclass)\n           -location_type => either ('EXACT','WITHIN','IN-BETWEEN',\n                             'UNCERTAIN') OR ( 1,2,3,4)\n           -start_ext=> extension for start - defaults to 0, \n           -start_fuz=  fuzzy code for start can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN' ) OR\n                      a value 1 - 5 corresponding to index+1 above\n           -end_ext=> extension for end - defaults to 0, \n           -end_fuz=  fuzzy code for end can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN') OR\n                      a value 1 - 5 corresponding to index+1 above","label":"new($class,@args)"},"containerName":"main::","definition":"sub"},{"kind":12,"line":148,"containerName":"new","name":"SUPER"},{"kind":12,"line":173,"children":[{"kind":13,"line":174,"definition":"my","name":"$self","containerName":"location_type","localvar":"my"},{"line":174,"kind":13,"containerName":"location_type","name":"$value"},{"kind":13,"line":175,"containerName":"location_type","name":"$value"},{"line":175,"kind":13,"name":"$self","containerName":"location_type"},{"containerName":"location_type","name":"$value","line":176,"kind":13},{"kind":13,"line":176,"containerName":"location_type","name":"$value"},{"name":"$FUZZYCODES","containerName":"location_type","line":177,"kind":13},{"containerName":"location_type","name":"$value","kind":13,"line":177},{"containerName":"location_type","name":"$value","kind":13,"line":178},{"kind":13,"line":178,"containerName":"location_type","name":"$value"},{"name":"$value","containerName":"location_type","line":179,"kind":13},{"line":180,"kind":13,"name":"$value","containerName":"location_type"},{"name":"$value","containerName":"location_type","kind":13,"line":181},{"kind":13,"line":182,"name":"$value","containerName":"location_type"},{"kind":13,"line":183,"containerName":"location_type","name":"$value"},{"containerName":"location_type","name":"$value","kind":13,"line":184},{"line":185,"kind":13,"containerName":"location_type","name":"$self"},{"kind":12,"line":185,"name":"throw","containerName":"location_type"},{"kind":13,"line":186,"containerName":"location_type","name":"$self"},{"name":"start","containerName":"location_type","line":186,"kind":12},{"name":"$self","containerName":"location_type","line":186,"kind":13},{"kind":12,"line":186,"name":"end","containerName":"location_type"},{"kind":13,"line":187,"name":"$self","containerName":"location_type"},{"containerName":"location_type","name":"start","line":187,"kind":12},{"containerName":"location_type","name":"$self","line":187,"kind":13},{"kind":12,"line":187,"name":"end","containerName":"location_type"},{"kind":13,"line":188,"name":"$self","containerName":"location_type"},{"name":"end","containerName":"location_type","kind":12,"line":188},{"line":188,"kind":13,"containerName":"location_type","name":"$self"},{"line":188,"kind":12,"name":"start","containerName":"location_type"},{"containerName":"location_type","name":"$value","line":189,"kind":13},{"containerName":"location_type","name":"$value","kind":13,"line":190},{"name":"$value","containerName":"location_type","line":191,"kind":13},{"kind":13,"line":191,"containerName":"location_type","name":"$value"},{"line":192,"kind":13,"containerName":"location_type","name":"$value"},{"name":"$self","containerName":"location_type","line":193,"kind":13},{"containerName":"location_type","name":"throw","line":193,"kind":12},{"line":196,"kind":13,"name":"$self","containerName":"location_type"},{"name":"$value","containerName":"location_type","kind":13,"line":196},{"line":198,"kind":13,"name":"$self","containerName":"location_type"}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Fuzzy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Fuzzy\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Fuzzy - Implementation of a Location on a Sequence\nwhich has unclear start and/or end locations\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Fuzzy;\n    my $fuzzylocation = Bio::Location::Fuzzy->new(\n                                                 -start => '<30',\n                                                 -end   => 90,\n                                                 -location_type => '..');\n\n    print \"location string is \", $fuzzylocation->to_FTstring(), \"\\n\";\n    print \"location is of the type \", $fuzzylocation->location_type, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis module contains the necessary methods for representing a\nFuzzy Location, one that does not have clear start and/or end points.\nThis will initially serve to handle features from Genbank/EMBL feature\ntables that are written as 1^100 meaning between bases 1 and 100 or\nE<lt>100..300 meaning it starts somewhere before 100.  Advanced\nimplementations of this interface may be able to handle the necessary\nlogic of overlaps/intersection/contains/union.  It was constructed to\nhandle fuzzy locations that can be represented in Genbank/EMBL and\nSwissprot.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Fuzzy;\nuse strict;\n\nuse base qw(Bio::Location::Atomic Bio::Location::FuzzyLocationI);\n\nour @LOCATIONCODESBSANE = (undef, 'EXACT', 'WITHIN', 'BETWEEN', 'UNCERTAIN',\n            'BEFORE', 'AFTER');\n\nour %FUZZYCODES = ( 'EXACT' => '..', # Position is 'exact\n   # Exact position is unknown, but is within the range specified, ((1.2)..100)\n            'WITHIN' => '.', \n            # 1^2\n            'BETWEEN'    => '^',\n            'IN-BETWEEN' => '^',\n            'UNCERTAIN'  => '?',\n            # <100\n            'BEFORE'  => '<',\n            # >10\n            'AFTER'   => '>');   \n   \n    # The following regular expressions map to fuzzy location types. Every\n    # expression must match the complete encoded point string, and must\n    # contain two groups identifying min and max. Empty matches are automatic.\n    # converted to undef, except for 'EXACT', for which max is set to equal\n    # min.\n    \nour %FUZZYPOINTENCODE = ( \n    '\\>(\\d+)(.{0})' => 'AFTER',\n    '\\<(.{0})(\\d+)' => 'BEFORE',\n    '(\\d+)'         => 'EXACT',\n    '\\?(\\d*)'       => 'UNCERTAIN',\n    '(\\d+)(.{0})\\>' => 'AFTER',\n    '(.{0})(\\d+)\\<' => 'BEFORE',\n    '(\\d+)\\.(\\d+)'  => 'WITHIN',\n    '(\\d+)\\^(\\d+)'  => 'BETWEEN',\n   );\n    \nour %FUZZYRANGEENCODE  = (  '\\.'   => 'WITHIN',\n                            '\\.\\.' => 'EXACT',\n                            '\\^'   => 'IN-BETWEEN' );\n\n=head2 new\n\n Title   : new\n Usage   : my $fuzzyloc = Bio::Location::Fuzzy->new( @args);\n Function:\n Returns : \n Args    : -start    => value for start  (initialize by superclass)\n           -end      => value for end    (initialize by superclass)\n           -strand   => value for strand (initialize by superclass)\n           -location_type => either ('EXACT','WITHIN','IN-BETWEEN',\n                             'UNCERTAIN') OR ( 1,2,3,4)\n           -start_ext=> extension for start - defaults to 0, \n           -start_fuz=  fuzzy code for start can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN' ) OR\n                      a value 1 - 5 corresponding to index+1 above\n           -end_ext=> extension for end - defaults to 0, \n           -end_fuz=  fuzzy code for end can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN') OR\n                      a value 1 - 5 corresponding to index+1 above\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($location_type, $start_ext, $start_fuz, $end_ext, $end_fuz) = \n        $self->_rearrange([ qw(LOCATION_TYPE START_EXT START_FUZ \n                   END_EXT END_FUZ )\n                ], @args);\n\n    $location_type  && $self->location_type($location_type);\n    $start_ext && $self->max_start($self->min_start + $start_ext);\n    $end_ext   && $self->max_end($self->min_end + $end_ext);\n    $start_fuz && $self->start_pos_type($start_fuz);\n    $end_fuz   && $self->end_pos_type($end_fuz);\n\n    return $self;\n}\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN', 'UNCERTAIN')\n  Args    : none","label":"location_type($self,$value)"},"name":"location_type","range":{"end":{"character":9999,"line":199},"start":{"line":173,"character":0}}},{"line":235,"children":[{"line":236,"kind":13,"localvar":"my","containerName":"start","definition":"my","name":"$self"},{"name":"$value","containerName":"start","line":236,"kind":13},{"kind":13,"line":237,"containerName":"start","name":"$value"},{"localvar":"my","name":"$encode","definition":"my","containerName":"start","line":238,"kind":13},{"kind":13,"line":238,"containerName":"start","name":"$min"},{"containerName":"start","name":"$max","kind":13,"line":238},{"name":"$self","containerName":"start","line":238,"kind":13},{"containerName":"start","name":"_fuzzypointdecode","kind":12,"line":238},{"name":"$value","containerName":"start","line":238,"kind":13},{"kind":13,"line":239,"name":"$self","containerName":"start"},{"line":239,"kind":12,"name":"start_pos_type","containerName":"start"},{"name":"$encode","containerName":"start","line":239,"kind":13},{"name":"$self","containerName":"start","kind":13,"line":240},{"name":"min_start","containerName":"start","line":240,"kind":12},{"line":240,"kind":13,"containerName":"start","name":"$min"},{"kind":13,"line":241,"containerName":"start","name":"$self"},{"containerName":"start","name":"max_start","kind":12,"line":241},{"kind":13,"line":241,"name":"$max","containerName":"start"},{"kind":13,"line":244,"containerName":"start","name":"$self"},{"line":244,"kind":12,"containerName":"start","name":"throw"},{"containerName":"start","name":"$self","line":245,"kind":13},{"containerName":"start","name":"$self","line":245,"kind":13},{"containerName":"start","name":"$self","line":246,"kind":13},{"line":246,"kind":12,"name":"location_type","containerName":"start"},{"line":246,"kind":13,"containerName":"start","name":"$self"},{"containerName":"start","name":"$self","kind":13,"line":247},{"line":247,"kind":13,"containerName":"start","name":"$self"},{"containerName":"start","name":"$self","line":249,"kind":13}],"kind":12,"detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: Fuzzy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Fuzzy\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Fuzzy - Implementation of a Location on a Sequence\nwhich has unclear start and/or end locations\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Fuzzy;\n    my $fuzzylocation = Bio::Location::Fuzzy->new(\n                                                 -start => '<30',\n                                                 -end   => 90,\n                                                 -location_type => '..');\n\n    print \"location string is \", $fuzzylocation->to_FTstring(), \"\\n\";\n    print \"location is of the type \", $fuzzylocation->location_type, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis module contains the necessary methods for representing a\nFuzzy Location, one that does not have clear start and/or end points.\nThis will initially serve to handle features from Genbank/EMBL feature\ntables that are written as 1^100 meaning between bases 1 and 100 or\nE<lt>100..300 meaning it starts somewhere before 100.  Advanced\nimplementations of this interface may be able to handle the necessary\nlogic of overlaps/intersection/contains/union.  It was constructed to\nhandle fuzzy locations that can be represented in Genbank/EMBL and\nSwissprot.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Fuzzy;\nuse strict;\n\nuse base qw(Bio::Location::Atomic Bio::Location::FuzzyLocationI);\n\nour @LOCATIONCODESBSANE = (undef, 'EXACT', 'WITHIN', 'BETWEEN', 'UNCERTAIN',\n            'BEFORE', 'AFTER');\n\nour %FUZZYCODES = ( 'EXACT' => '..', # Position is 'exact\n   # Exact position is unknown, but is within the range specified, ((1.2)..100)\n            'WITHIN' => '.', \n            # 1^2\n            'BETWEEN'    => '^',\n            'IN-BETWEEN' => '^',\n            'UNCERTAIN'  => '?',\n            # <100\n            'BEFORE'  => '<',\n            # >10\n            'AFTER'   => '>');   \n   \n    # The following regular expressions map to fuzzy location types. Every\n    # expression must match the complete encoded point string, and must\n    # contain two groups identifying min and max. Empty matches are automatic.\n    # converted to undef, except for 'EXACT', for which max is set to equal\n    # min.\n    \nour %FUZZYPOINTENCODE = ( \n    '\\>(\\d+)(.{0})' => 'AFTER',\n    '\\<(.{0})(\\d+)' => 'BEFORE',\n    '(\\d+)'         => 'EXACT',\n    '\\?(\\d*)'       => 'UNCERTAIN',\n    '(\\d+)(.{0})\\>' => 'AFTER',\n    '(.{0})(\\d+)\\<' => 'BEFORE',\n    '(\\d+)\\.(\\d+)'  => 'WITHIN',\n    '(\\d+)\\^(\\d+)'  => 'BETWEEN',\n   );\n    \nour %FUZZYRANGEENCODE  = (  '\\.'   => 'WITHIN',\n                            '\\.\\.' => 'EXACT',\n                            '\\^'   => 'IN-BETWEEN' );\n\n=head2 new\n\n Title   : new\n Usage   : my $fuzzyloc = Bio::Location::Fuzzy->new( @args);\n Function:\n Returns : \n Args    : -start    => value for start  (initialize by superclass)\n           -end      => value for end    (initialize by superclass)\n           -strand   => value for strand (initialize by superclass)\n           -location_type => either ('EXACT','WITHIN','IN-BETWEEN',\n                             'UNCERTAIN') OR ( 1,2,3,4)\n           -start_ext=> extension for start - defaults to 0, \n           -start_fuz=  fuzzy code for start can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN' ) OR\n                      a value 1 - 5 corresponding to index+1 above\n           -end_ext=> extension for end - defaults to 0, \n           -end_fuz=  fuzzy code for end can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN') OR\n                      a value 1 - 5 corresponding to index+1 above\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($location_type, $start_ext, $start_fuz, $end_ext, $end_fuz) = \n        $self->_rearrange([ qw(LOCATION_TYPE START_EXT START_FUZ \n                   END_EXT END_FUZ )\n                ], @args);\n\n    $location_type  && $self->location_type($location_type);\n    $start_ext && $self->max_start($self->min_start + $start_ext);\n    $end_ext   && $self->max_end($self->min_end + $end_ext);\n    $start_fuz && $self->start_pos_type($start_fuz);\n    $end_fuz   && $self->end_pos_type($end_fuz);\n\n    return $self;\n}\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN', 'UNCERTAIN')\n  Args    : none\n\n\nsub location_type {\n    my ($self,$value) = @_;\n    if( defined $value || ! defined $self->{'_location_type'} ) {\n        $value = 'EXACT' unless defined $value;\n        if(! defined $FUZZYCODES{$value} )  {\n            $value = uc($value);\n            if( $value =~ /\\.\\./ ) {\n                $value = 'EXACT';\n            } elsif( $value =~ /^\\.$/ ) {\n                $value = 'WITHIN';\n            } elsif( $value =~ /\\^/ ) {\n                $value = 'IN-BETWEEN';\n                $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                             $self->start. \"] and [\". $self->end. \"]\")\n                  if defined $self->start && defined $self->end &&\n                            ($self->end - 1 == $self->start);\n            } elsif( $value =~ /\\?/ ) {\n                $value = 'UNCERTAIN';\n            } elsif( $value ne 'EXACT' && $value ne 'WITHIN' && \n                        $value ne 'IN-BETWEEN' ) {\n                $self->throw(\"Did not specify a valid location type\");\n            }\n        }\n        $self->{'_location_type'} = $value;\n    }\n    return $self->{'_location_type'};\n}\n\n=head1 LocationI methods\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $fuzzy_loc->length();\n  Function: Get the length of this location.\n\n            Note that the length of a fuzzy location will always depend\n            on the currently active interpretation of start and end. The\n            result will therefore vary for different CoordinatePolicy objects.\n\n  Returns : an integer\n  Args    : none\n\n\n#sub length {\n#    my($self) = @_;\n#    return $self->SUPER::length() if( !$self->start || !$self->end);\n#    $self->warn('Length is not valid for a FuzzyLocation'); \n#    return 0;\n#}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $fuzzy->start();\n  Function: get/set start of this range, handling fuzzy_starts\n  Returns : a positive integer representing the start of the location\n  Args    : start location on set (can be fuzzy point string)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"start($self,$value)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":235},"end":{"line":250,"character":9999}},"name":"start"},{"line":245,"kind":12,"containerName":"start","name":"SUPER"},{"line":245,"kind":12,"name":"SUPER","containerName":"end"},{"kind":12,"line":246,"name":"SUPER","containerName":"end"},{"containerName":"end","name":"SUPER","kind":12,"line":247},{"name":"SUPER","containerName":"start","kind":12,"line":247},{"containerName":"start","name":"SUPER","kind":12,"line":249},{"detail":"($self,$value)","signature":{"label":"end($self,$value)","documentation":"1;\n# $Id: Fuzzy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Fuzzy\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Fuzzy - Implementation of a Location on a Sequence\nwhich has unclear start and/or end locations\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Fuzzy;\n    my $fuzzylocation = Bio::Location::Fuzzy->new(\n                                                 -start => '<30',\n                                                 -end   => 90,\n                                                 -location_type => '..');\n\n    print \"location string is \", $fuzzylocation->to_FTstring(), \"\\n\";\n    print \"location is of the type \", $fuzzylocation->location_type, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis module contains the necessary methods for representing a\nFuzzy Location, one that does not have clear start and/or end points.\nThis will initially serve to handle features from Genbank/EMBL feature\ntables that are written as 1^100 meaning between bases 1 and 100 or\nE<lt>100..300 meaning it starts somewhere before 100.  Advanced\nimplementations of this interface may be able to handle the necessary\nlogic of overlaps/intersection/contains/union.  It was constructed to\nhandle fuzzy locations that can be represented in Genbank/EMBL and\nSwissprot.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Fuzzy;\nuse strict;\n\nuse base qw(Bio::Location::Atomic Bio::Location::FuzzyLocationI);\n\nour @LOCATIONCODESBSANE = (undef, 'EXACT', 'WITHIN', 'BETWEEN', 'UNCERTAIN',\n            'BEFORE', 'AFTER');\n\nour %FUZZYCODES = ( 'EXACT' => '..', # Position is 'exact\n   # Exact position is unknown, but is within the range specified, ((1.2)..100)\n            'WITHIN' => '.', \n            # 1^2\n            'BETWEEN'    => '^',\n            'IN-BETWEEN' => '^',\n            'UNCERTAIN'  => '?',\n            # <100\n            'BEFORE'  => '<',\n            # >10\n            'AFTER'   => '>');   \n   \n    # The following regular expressions map to fuzzy location types. Every\n    # expression must match the complete encoded point string, and must\n    # contain two groups identifying min and max. Empty matches are automatic.\n    # converted to undef, except for 'EXACT', for which max is set to equal\n    # min.\n    \nour %FUZZYPOINTENCODE = ( \n    '\\>(\\d+)(.{0})' => 'AFTER',\n    '\\<(.{0})(\\d+)' => 'BEFORE',\n    '(\\d+)'         => 'EXACT',\n    '\\?(\\d*)'       => 'UNCERTAIN',\n    '(\\d+)(.{0})\\>' => 'AFTER',\n    '(.{0})(\\d+)\\<' => 'BEFORE',\n    '(\\d+)\\.(\\d+)'  => 'WITHIN',\n    '(\\d+)\\^(\\d+)'  => 'BETWEEN',\n   );\n    \nour %FUZZYRANGEENCODE  = (  '\\.'   => 'WITHIN',\n                            '\\.\\.' => 'EXACT',\n                            '\\^'   => 'IN-BETWEEN' );\n\n=head2 new\n\n Title   : new\n Usage   : my $fuzzyloc = Bio::Location::Fuzzy->new( @args);\n Function:\n Returns : \n Args    : -start    => value for start  (initialize by superclass)\n           -end      => value for end    (initialize by superclass)\n           -strand   => value for strand (initialize by superclass)\n           -location_type => either ('EXACT','WITHIN','IN-BETWEEN',\n                             'UNCERTAIN') OR ( 1,2,3,4)\n           -start_ext=> extension for start - defaults to 0, \n           -start_fuz=  fuzzy code for start can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN' ) OR\n                      a value 1 - 5 corresponding to index+1 above\n           -end_ext=> extension for end - defaults to 0, \n           -end_fuz=  fuzzy code for end can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN') OR\n                      a value 1 - 5 corresponding to index+1 above\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($location_type, $start_ext, $start_fuz, $end_ext, $end_fuz) = \n        $self->_rearrange([ qw(LOCATION_TYPE START_EXT START_FUZ \n                   END_EXT END_FUZ )\n                ], @args);\n\n    $location_type  && $self->location_type($location_type);\n    $start_ext && $self->max_start($self->min_start + $start_ext);\n    $end_ext   && $self->max_end($self->min_end + $end_ext);\n    $start_fuz && $self->start_pos_type($start_fuz);\n    $end_fuz   && $self->end_pos_type($end_fuz);\n\n    return $self;\n}\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN', 'UNCERTAIN')\n  Args    : none\n\n\nsub location_type {\n    my ($self,$value) = @_;\n    if( defined $value || ! defined $self->{'_location_type'} ) {\n        $value = 'EXACT' unless defined $value;\n        if(! defined $FUZZYCODES{$value} )  {\n            $value = uc($value);\n            if( $value =~ /\\.\\./ ) {\n                $value = 'EXACT';\n            } elsif( $value =~ /^\\.$/ ) {\n                $value = 'WITHIN';\n            } elsif( $value =~ /\\^/ ) {\n                $value = 'IN-BETWEEN';\n                $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                             $self->start. \"] and [\". $self->end. \"]\")\n                  if defined $self->start && defined $self->end &&\n                            ($self->end - 1 == $self->start);\n            } elsif( $value =~ /\\?/ ) {\n                $value = 'UNCERTAIN';\n            } elsif( $value ne 'EXACT' && $value ne 'WITHIN' && \n                        $value ne 'IN-BETWEEN' ) {\n                $self->throw(\"Did not specify a valid location type\");\n            }\n        }\n        $self->{'_location_type'} = $value;\n    }\n    return $self->{'_location_type'};\n}\n\n=head1 LocationI methods\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $fuzzy_loc->length();\n  Function: Get the length of this location.\n\n            Note that the length of a fuzzy location will always depend\n            on the currently active interpretation of start and end. The\n            result will therefore vary for different CoordinatePolicy objects.\n\n  Returns : an integer\n  Args    : none\n\n\n#sub length {\n#    my($self) = @_;\n#    return $self->SUPER::length() if( !$self->start || !$self->end);\n#    $self->warn('Length is not valid for a FuzzyLocation'); \n#    return 0;\n#}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $fuzzy->start();\n  Function: get/set start of this range, handling fuzzy_starts\n  Returns : a positive integer representing the start of the location\n  Args    : start location on set (can be fuzzy point string)\n\n\nsub start {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->start_pos_type($encode);\n    $self->min_start($min);\n    $self->max_start($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\"\n                 . $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN'  && defined $self->SUPER::end &&\n                  ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $fuzzy->end();\n  Function: get/set end of this range, handling fuzzy_ends\n  Returns : a positive integer representing the end of the range\n  Args    : end location on set (can be fuzzy string)","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub","line":262,"children":[{"line":263,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"end"},{"name":"$value","containerName":"end","line":263,"kind":13},{"kind":13,"line":264,"name":"$value","containerName":"end"},{"localvar":"my","containerName":"end","definition":"my","name":"$encode","line":265,"kind":13},{"containerName":"end","name":"$min","line":265,"kind":13},{"kind":13,"line":265,"name":"$max","containerName":"end"},{"name":"$self","containerName":"end","kind":13,"line":265},{"containerName":"end","name":"_fuzzypointdecode","line":265,"kind":12},{"kind":13,"line":265,"containerName":"end","name":"$value"},{"line":266,"kind":13,"containerName":"end","name":"$self"},{"containerName":"end","name":"end_pos_type","line":266,"kind":12},{"name":"$encode","containerName":"end","kind":13,"line":266},{"line":267,"kind":13,"name":"$self","containerName":"end"},{"line":267,"kind":12,"name":"min_end","containerName":"end"},{"line":267,"kind":13,"name":"$min","containerName":"end"},{"containerName":"end","name":"$self","kind":13,"line":268},{"kind":12,"line":268,"containerName":"end","name":"max_end"},{"line":268,"kind":13,"containerName":"end","name":"$max"},{"kind":13,"line":271,"name":"$self","containerName":"end"},{"name":"throw","containerName":"end","line":271,"kind":12},{"containerName":"end","name":"$self","line":272,"kind":13},{"line":272,"kind":13,"containerName":"end","name":"$self"},{"kind":13,"line":273,"name":"$self","containerName":"end"},{"kind":12,"line":273,"name":"location_type","containerName":"end"},{"line":273,"kind":13,"name":"$self","containerName":"end"},{"containerName":"end","name":"$self","line":274,"kind":13},{"line":274,"kind":13,"containerName":"end","name":"$self"},{"name":"$self","containerName":"end","kind":13,"line":276}],"kind":12,"range":{"start":{"character":0,"line":262},"end":{"character":9999,"line":277}},"name":"end"},{"kind":12,"line":272,"containerName":"start","name":"SUPER"},{"kind":12,"line":272,"name":"SUPER","containerName":"end"},{"line":273,"kind":12,"containerName":"start","name":"SUPER"},{"name":"SUPER","containerName":"end","kind":12,"line":274},{"name":"SUPER","containerName":"start","line":274,"kind":12},{"name":"SUPER","containerName":"end","kind":12,"line":276},{"range":{"end":{"line":296,"character":9999},"start":{"line":289,"character":0}},"name":"min_start","children":[{"name":"$self","definition":"my","containerName":"min_start","localvar":"my","kind":13,"line":290},{"line":290,"kind":13,"containerName":"min_start","name":"@args"},{"kind":13,"line":292,"name":"@args","containerName":"min_start"},{"name":"$self","containerName":"min_start","line":293,"kind":13},{"kind":13,"line":293,"name":"$args","containerName":"min_start"},{"containerName":"min_start","name":"$self","line":295,"kind":13}],"line":289,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Fuzzy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Fuzzy\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Fuzzy - Implementation of a Location on a Sequence\nwhich has unclear start and/or end locations\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Fuzzy;\n    my $fuzzylocation = Bio::Location::Fuzzy->new(\n                                                 -start => '<30',\n                                                 -end   => 90,\n                                                 -location_type => '..');\n\n    print \"location string is \", $fuzzylocation->to_FTstring(), \"\\n\";\n    print \"location is of the type \", $fuzzylocation->location_type, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis module contains the necessary methods for representing a\nFuzzy Location, one that does not have clear start and/or end points.\nThis will initially serve to handle features from Genbank/EMBL feature\ntables that are written as 1^100 meaning between bases 1 and 100 or\nE<lt>100..300 meaning it starts somewhere before 100.  Advanced\nimplementations of this interface may be able to handle the necessary\nlogic of overlaps/intersection/contains/union.  It was constructed to\nhandle fuzzy locations that can be represented in Genbank/EMBL and\nSwissprot.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Fuzzy;\nuse strict;\n\nuse base qw(Bio::Location::Atomic Bio::Location::FuzzyLocationI);\n\nour @LOCATIONCODESBSANE = (undef, 'EXACT', 'WITHIN', 'BETWEEN', 'UNCERTAIN',\n            'BEFORE', 'AFTER');\n\nour %FUZZYCODES = ( 'EXACT' => '..', # Position is 'exact\n   # Exact position is unknown, but is within the range specified, ((1.2)..100)\n            'WITHIN' => '.', \n            # 1^2\n            'BETWEEN'    => '^',\n            'IN-BETWEEN' => '^',\n            'UNCERTAIN'  => '?',\n            # <100\n            'BEFORE'  => '<',\n            # >10\n            'AFTER'   => '>');   \n   \n    # The following regular expressions map to fuzzy location types. Every\n    # expression must match the complete encoded point string, and must\n    # contain two groups identifying min and max. Empty matches are automatic.\n    # converted to undef, except for 'EXACT', for which max is set to equal\n    # min.\n    \nour %FUZZYPOINTENCODE = ( \n    '\\>(\\d+)(.{0})' => 'AFTER',\n    '\\<(.{0})(\\d+)' => 'BEFORE',\n    '(\\d+)'         => 'EXACT',\n    '\\?(\\d*)'       => 'UNCERTAIN',\n    '(\\d+)(.{0})\\>' => 'AFTER',\n    '(.{0})(\\d+)\\<' => 'BEFORE',\n    '(\\d+)\\.(\\d+)'  => 'WITHIN',\n    '(\\d+)\\^(\\d+)'  => 'BETWEEN',\n   );\n    \nour %FUZZYRANGEENCODE  = (  '\\.'   => 'WITHIN',\n                            '\\.\\.' => 'EXACT',\n                            '\\^'   => 'IN-BETWEEN' );\n\n=head2 new\n\n Title   : new\n Usage   : my $fuzzyloc = Bio::Location::Fuzzy->new( @args);\n Function:\n Returns : \n Args    : -start    => value for start  (initialize by superclass)\n           -end      => value for end    (initialize by superclass)\n           -strand   => value for strand (initialize by superclass)\n           -location_type => either ('EXACT','WITHIN','IN-BETWEEN',\n                             'UNCERTAIN') OR ( 1,2,3,4)\n           -start_ext=> extension for start - defaults to 0, \n           -start_fuz=  fuzzy code for start can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN' ) OR\n                      a value 1 - 5 corresponding to index+1 above\n           -end_ext=> extension for end - defaults to 0, \n           -end_fuz=  fuzzy code for end can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN') OR\n                      a value 1 - 5 corresponding to index+1 above\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($location_type, $start_ext, $start_fuz, $end_ext, $end_fuz) = \n        $self->_rearrange([ qw(LOCATION_TYPE START_EXT START_FUZ \n                   END_EXT END_FUZ )\n                ], @args);\n\n    $location_type  && $self->location_type($location_type);\n    $start_ext && $self->max_start($self->min_start + $start_ext);\n    $end_ext   && $self->max_end($self->min_end + $end_ext);\n    $start_fuz && $self->start_pos_type($start_fuz);\n    $end_fuz   && $self->end_pos_type($end_fuz);\n\n    return $self;\n}\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN', 'UNCERTAIN')\n  Args    : none\n\n\nsub location_type {\n    my ($self,$value) = @_;\n    if( defined $value || ! defined $self->{'_location_type'} ) {\n        $value = 'EXACT' unless defined $value;\n        if(! defined $FUZZYCODES{$value} )  {\n            $value = uc($value);\n            if( $value =~ /\\.\\./ ) {\n                $value = 'EXACT';\n            } elsif( $value =~ /^\\.$/ ) {\n                $value = 'WITHIN';\n            } elsif( $value =~ /\\^/ ) {\n                $value = 'IN-BETWEEN';\n                $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                             $self->start. \"] and [\". $self->end. \"]\")\n                  if defined $self->start && defined $self->end &&\n                            ($self->end - 1 == $self->start);\n            } elsif( $value =~ /\\?/ ) {\n                $value = 'UNCERTAIN';\n            } elsif( $value ne 'EXACT' && $value ne 'WITHIN' && \n                        $value ne 'IN-BETWEEN' ) {\n                $self->throw(\"Did not specify a valid location type\");\n            }\n        }\n        $self->{'_location_type'} = $value;\n    }\n    return $self->{'_location_type'};\n}\n\n=head1 LocationI methods\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $fuzzy_loc->length();\n  Function: Get the length of this location.\n\n            Note that the length of a fuzzy location will always depend\n            on the currently active interpretation of start and end. The\n            result will therefore vary for different CoordinatePolicy objects.\n\n  Returns : an integer\n  Args    : none\n\n\n#sub length {\n#    my($self) = @_;\n#    return $self->SUPER::length() if( !$self->start || !$self->end);\n#    $self->warn('Length is not valid for a FuzzyLocation'); \n#    return 0;\n#}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $fuzzy->start();\n  Function: get/set start of this range, handling fuzzy_starts\n  Returns : a positive integer representing the start of the location\n  Args    : start location on set (can be fuzzy point string)\n\n\nsub start {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->start_pos_type($encode);\n    $self->min_start($min);\n    $self->max_start($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\"\n                 . $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN'  && defined $self->SUPER::end &&\n                  ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $fuzzy->end();\n  Function: get/set end of this range, handling fuzzy_ends\n  Returns : a positive integer representing the end of the range\n  Args    : end location on set (can be fuzzy string)\n\n\nsub end {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->end_pos_type($encode);\n    $self->min_end($min);\n    $self->max_end($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                 $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN' && defined $self->SUPER::start &&\n                ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::end();\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : $min_start = $fuzzy->min_start();\n  Function: get/set the minimum starting point\n  Returns : the minimum starting point from the contained sublocations\n  Args    : integer or undef on set","label":"min_start($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::"},{"signature":{"label":"max_start($self,@args)","documentation":"1;\n# $Id: Fuzzy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Fuzzy\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Fuzzy - Implementation of a Location on a Sequence\nwhich has unclear start and/or end locations\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Fuzzy;\n    my $fuzzylocation = Bio::Location::Fuzzy->new(\n                                                 -start => '<30',\n                                                 -end   => 90,\n                                                 -location_type => '..');\n\n    print \"location string is \", $fuzzylocation->to_FTstring(), \"\\n\";\n    print \"location is of the type \", $fuzzylocation->location_type, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis module contains the necessary methods for representing a\nFuzzy Location, one that does not have clear start and/or end points.\nThis will initially serve to handle features from Genbank/EMBL feature\ntables that are written as 1^100 meaning between bases 1 and 100 or\nE<lt>100..300 meaning it starts somewhere before 100.  Advanced\nimplementations of this interface may be able to handle the necessary\nlogic of overlaps/intersection/contains/union.  It was constructed to\nhandle fuzzy locations that can be represented in Genbank/EMBL and\nSwissprot.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Fuzzy;\nuse strict;\n\nuse base qw(Bio::Location::Atomic Bio::Location::FuzzyLocationI);\n\nour @LOCATIONCODESBSANE = (undef, 'EXACT', 'WITHIN', 'BETWEEN', 'UNCERTAIN',\n            'BEFORE', 'AFTER');\n\nour %FUZZYCODES = ( 'EXACT' => '..', # Position is 'exact\n   # Exact position is unknown, but is within the range specified, ((1.2)..100)\n            'WITHIN' => '.', \n            # 1^2\n            'BETWEEN'    => '^',\n            'IN-BETWEEN' => '^',\n            'UNCERTAIN'  => '?',\n            # <100\n            'BEFORE'  => '<',\n            # >10\n            'AFTER'   => '>');   \n   \n    # The following regular expressions map to fuzzy location types. Every\n    # expression must match the complete encoded point string, and must\n    # contain two groups identifying min and max. Empty matches are automatic.\n    # converted to undef, except for 'EXACT', for which max is set to equal\n    # min.\n    \nour %FUZZYPOINTENCODE = ( \n    '\\>(\\d+)(.{0})' => 'AFTER',\n    '\\<(.{0})(\\d+)' => 'BEFORE',\n    '(\\d+)'         => 'EXACT',\n    '\\?(\\d*)'       => 'UNCERTAIN',\n    '(\\d+)(.{0})\\>' => 'AFTER',\n    '(.{0})(\\d+)\\<' => 'BEFORE',\n    '(\\d+)\\.(\\d+)'  => 'WITHIN',\n    '(\\d+)\\^(\\d+)'  => 'BETWEEN',\n   );\n    \nour %FUZZYRANGEENCODE  = (  '\\.'   => 'WITHIN',\n                            '\\.\\.' => 'EXACT',\n                            '\\^'   => 'IN-BETWEEN' );\n\n=head2 new\n\n Title   : new\n Usage   : my $fuzzyloc = Bio::Location::Fuzzy->new( @args);\n Function:\n Returns : \n Args    : -start    => value for start  (initialize by superclass)\n           -end      => value for end    (initialize by superclass)\n           -strand   => value for strand (initialize by superclass)\n           -location_type => either ('EXACT','WITHIN','IN-BETWEEN',\n                             'UNCERTAIN') OR ( 1,2,3,4)\n           -start_ext=> extension for start - defaults to 0, \n           -start_fuz=  fuzzy code for start can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN' ) OR\n                      a value 1 - 5 corresponding to index+1 above\n           -end_ext=> extension for end - defaults to 0, \n           -end_fuz=  fuzzy code for end can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN') OR\n                      a value 1 - 5 corresponding to index+1 above\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($location_type, $start_ext, $start_fuz, $end_ext, $end_fuz) = \n        $self->_rearrange([ qw(LOCATION_TYPE START_EXT START_FUZ \n                   END_EXT END_FUZ )\n                ], @args);\n\n    $location_type  && $self->location_type($location_type);\n    $start_ext && $self->max_start($self->min_start + $start_ext);\n    $end_ext   && $self->max_end($self->min_end + $end_ext);\n    $start_fuz && $self->start_pos_type($start_fuz);\n    $end_fuz   && $self->end_pos_type($end_fuz);\n\n    return $self;\n}\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN', 'UNCERTAIN')\n  Args    : none\n\n\nsub location_type {\n    my ($self,$value) = @_;\n    if( defined $value || ! defined $self->{'_location_type'} ) {\n        $value = 'EXACT' unless defined $value;\n        if(! defined $FUZZYCODES{$value} )  {\n            $value = uc($value);\n            if( $value =~ /\\.\\./ ) {\n                $value = 'EXACT';\n            } elsif( $value =~ /^\\.$/ ) {\n                $value = 'WITHIN';\n            } elsif( $value =~ /\\^/ ) {\n                $value = 'IN-BETWEEN';\n                $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                             $self->start. \"] and [\". $self->end. \"]\")\n                  if defined $self->start && defined $self->end &&\n                            ($self->end - 1 == $self->start);\n            } elsif( $value =~ /\\?/ ) {\n                $value = 'UNCERTAIN';\n            } elsif( $value ne 'EXACT' && $value ne 'WITHIN' && \n                        $value ne 'IN-BETWEEN' ) {\n                $self->throw(\"Did not specify a valid location type\");\n            }\n        }\n        $self->{'_location_type'} = $value;\n    }\n    return $self->{'_location_type'};\n}\n\n=head1 LocationI methods\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $fuzzy_loc->length();\n  Function: Get the length of this location.\n\n            Note that the length of a fuzzy location will always depend\n            on the currently active interpretation of start and end. The\n            result will therefore vary for different CoordinatePolicy objects.\n\n  Returns : an integer\n  Args    : none\n\n\n#sub length {\n#    my($self) = @_;\n#    return $self->SUPER::length() if( !$self->start || !$self->end);\n#    $self->warn('Length is not valid for a FuzzyLocation'); \n#    return 0;\n#}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $fuzzy->start();\n  Function: get/set start of this range, handling fuzzy_starts\n  Returns : a positive integer representing the start of the location\n  Args    : start location on set (can be fuzzy point string)\n\n\nsub start {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->start_pos_type($encode);\n    $self->min_start($min);\n    $self->max_start($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\"\n                 . $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN'  && defined $self->SUPER::end &&\n                  ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $fuzzy->end();\n  Function: get/set end of this range, handling fuzzy_ends\n  Returns : a positive integer representing the end of the range\n  Args    : end location on set (can be fuzzy string)\n\n\nsub end {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->end_pos_type($encode);\n    $self->min_end($min);\n    $self->max_end($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                 $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN' && defined $self->SUPER::start &&\n                ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::end();\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : $min_start = $fuzzy->min_start();\n  Function: get/set the minimum starting point\n  Returns : the minimum starting point from the contained sublocations\n  Args    : integer or undef on set\n\n\nsub min_start {\n    my ($self,@args) = @_;\n\n    if(@args) {\n    $self->{'_min_start'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_min_start'};\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get/set maximum starting location of feature startpoint  \n  Returns : integer or undef if no maximum starting point.\n  Args    : integer or undef on set","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"line":309,"kind":13,"localvar":"my","containerName":"max_start","name":"$self","definition":"my"},{"name":"@args","containerName":"max_start","kind":13,"line":309},{"containerName":"max_start","name":"@args","kind":13,"line":311},{"line":312,"kind":13,"name":"$self","containerName":"max_start"},{"line":312,"kind":13,"containerName":"max_start","name":"$args"},{"line":314,"kind":13,"containerName":"max_start","name":"$self"}],"line":308,"kind":12,"range":{"start":{"character":0,"line":308},"end":{"line":315,"character":9999}},"name":"max_start"},{"children":[{"localvar":"my","containerName":"start_pos_type","name":"$self","definition":"my","line":329,"kind":13},{"line":329,"kind":13,"containerName":"start_pos_type","name":"$value"},{"containerName":"start_pos_type","name":"$value","line":330,"kind":13},{"kind":13,"line":330,"name":"$value","containerName":"start_pos_type"},{"kind":13,"line":331,"containerName":"start_pos_type","name":"$value"},{"kind":13,"line":331,"name":"$value","containerName":"start_pos_type"},{"line":333,"kind":13,"localvar":"my","name":"$v","definition":"my","containerName":"start_pos_type"},{"line":333,"kind":13,"containerName":"start_pos_type","name":"$LOCATIONCODESBSANE"},{"line":333,"kind":13,"containerName":"start_pos_type","name":"$value"},{"kind":13,"line":334,"containerName":"start_pos_type","name":"$v"},{"line":335,"kind":13,"containerName":"start_pos_type","name":"$self"},{"name":"warn","containerName":"start_pos_type","line":335,"kind":12},{"kind":13,"line":337,"containerName":"start_pos_type","name":"$v"},{"name":"$value","containerName":"start_pos_type","kind":13,"line":339},{"name":"$v","containerName":"start_pos_type","line":339,"kind":13},{"line":342,"kind":13,"name":"$value","containerName":"start_pos_type"},{"containerName":"start_pos_type","name":"$self","line":343,"kind":13},{"containerName":"start_pos_type","name":"$value","kind":13,"line":343},{"name":"$self","containerName":"start_pos_type","line":345,"kind":13}],"line":328,"kind":12,"signature":{"label":"start_pos_type($self,$value)","documentation":"1;\n# $Id: Fuzzy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Fuzzy\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Fuzzy - Implementation of a Location on a Sequence\nwhich has unclear start and/or end locations\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Fuzzy;\n    my $fuzzylocation = Bio::Location::Fuzzy->new(\n                                                 -start => '<30',\n                                                 -end   => 90,\n                                                 -location_type => '..');\n\n    print \"location string is \", $fuzzylocation->to_FTstring(), \"\\n\";\n    print \"location is of the type \", $fuzzylocation->location_type, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis module contains the necessary methods for representing a\nFuzzy Location, one that does not have clear start and/or end points.\nThis will initially serve to handle features from Genbank/EMBL feature\ntables that are written as 1^100 meaning between bases 1 and 100 or\nE<lt>100..300 meaning it starts somewhere before 100.  Advanced\nimplementations of this interface may be able to handle the necessary\nlogic of overlaps/intersection/contains/union.  It was constructed to\nhandle fuzzy locations that can be represented in Genbank/EMBL and\nSwissprot.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Fuzzy;\nuse strict;\n\nuse base qw(Bio::Location::Atomic Bio::Location::FuzzyLocationI);\n\nour @LOCATIONCODESBSANE = (undef, 'EXACT', 'WITHIN', 'BETWEEN', 'UNCERTAIN',\n            'BEFORE', 'AFTER');\n\nour %FUZZYCODES = ( 'EXACT' => '..', # Position is 'exact\n   # Exact position is unknown, but is within the range specified, ((1.2)..100)\n            'WITHIN' => '.', \n            # 1^2\n            'BETWEEN'    => '^',\n            'IN-BETWEEN' => '^',\n            'UNCERTAIN'  => '?',\n            # <100\n            'BEFORE'  => '<',\n            # >10\n            'AFTER'   => '>');   \n   \n    # The following regular expressions map to fuzzy location types. Every\n    # expression must match the complete encoded point string, and must\n    # contain two groups identifying min and max. Empty matches are automatic.\n    # converted to undef, except for 'EXACT', for which max is set to equal\n    # min.\n    \nour %FUZZYPOINTENCODE = ( \n    '\\>(\\d+)(.{0})' => 'AFTER',\n    '\\<(.{0})(\\d+)' => 'BEFORE',\n    '(\\d+)'         => 'EXACT',\n    '\\?(\\d*)'       => 'UNCERTAIN',\n    '(\\d+)(.{0})\\>' => 'AFTER',\n    '(.{0})(\\d+)\\<' => 'BEFORE',\n    '(\\d+)\\.(\\d+)'  => 'WITHIN',\n    '(\\d+)\\^(\\d+)'  => 'BETWEEN',\n   );\n    \nour %FUZZYRANGEENCODE  = (  '\\.'   => 'WITHIN',\n                            '\\.\\.' => 'EXACT',\n                            '\\^'   => 'IN-BETWEEN' );\n\n=head2 new\n\n Title   : new\n Usage   : my $fuzzyloc = Bio::Location::Fuzzy->new( @args);\n Function:\n Returns : \n Args    : -start    => value for start  (initialize by superclass)\n           -end      => value for end    (initialize by superclass)\n           -strand   => value for strand (initialize by superclass)\n           -location_type => either ('EXACT','WITHIN','IN-BETWEEN',\n                             'UNCERTAIN') OR ( 1,2,3,4)\n           -start_ext=> extension for start - defaults to 0, \n           -start_fuz=  fuzzy code for start can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN' ) OR\n                      a value 1 - 5 corresponding to index+1 above\n           -end_ext=> extension for end - defaults to 0, \n           -end_fuz=  fuzzy code for end can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN') OR\n                      a value 1 - 5 corresponding to index+1 above\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($location_type, $start_ext, $start_fuz, $end_ext, $end_fuz) = \n        $self->_rearrange([ qw(LOCATION_TYPE START_EXT START_FUZ \n                   END_EXT END_FUZ )\n                ], @args);\n\n    $location_type  && $self->location_type($location_type);\n    $start_ext && $self->max_start($self->min_start + $start_ext);\n    $end_ext   && $self->max_end($self->min_end + $end_ext);\n    $start_fuz && $self->start_pos_type($start_fuz);\n    $end_fuz   && $self->end_pos_type($end_fuz);\n\n    return $self;\n}\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN', 'UNCERTAIN')\n  Args    : none\n\n\nsub location_type {\n    my ($self,$value) = @_;\n    if( defined $value || ! defined $self->{'_location_type'} ) {\n        $value = 'EXACT' unless defined $value;\n        if(! defined $FUZZYCODES{$value} )  {\n            $value = uc($value);\n            if( $value =~ /\\.\\./ ) {\n                $value = 'EXACT';\n            } elsif( $value =~ /^\\.$/ ) {\n                $value = 'WITHIN';\n            } elsif( $value =~ /\\^/ ) {\n                $value = 'IN-BETWEEN';\n                $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                             $self->start. \"] and [\". $self->end. \"]\")\n                  if defined $self->start && defined $self->end &&\n                            ($self->end - 1 == $self->start);\n            } elsif( $value =~ /\\?/ ) {\n                $value = 'UNCERTAIN';\n            } elsif( $value ne 'EXACT' && $value ne 'WITHIN' && \n                        $value ne 'IN-BETWEEN' ) {\n                $self->throw(\"Did not specify a valid location type\");\n            }\n        }\n        $self->{'_location_type'} = $value;\n    }\n    return $self->{'_location_type'};\n}\n\n=head1 LocationI methods\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $fuzzy_loc->length();\n  Function: Get the length of this location.\n\n            Note that the length of a fuzzy location will always depend\n            on the currently active interpretation of start and end. The\n            result will therefore vary for different CoordinatePolicy objects.\n\n  Returns : an integer\n  Args    : none\n\n\n#sub length {\n#    my($self) = @_;\n#    return $self->SUPER::length() if( !$self->start || !$self->end);\n#    $self->warn('Length is not valid for a FuzzyLocation'); \n#    return 0;\n#}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $fuzzy->start();\n  Function: get/set start of this range, handling fuzzy_starts\n  Returns : a positive integer representing the start of the location\n  Args    : start location on set (can be fuzzy point string)\n\n\nsub start {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->start_pos_type($encode);\n    $self->min_start($min);\n    $self->max_start($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\"\n                 . $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN'  && defined $self->SUPER::end &&\n                  ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $fuzzy->end();\n  Function: get/set end of this range, handling fuzzy_ends\n  Returns : a positive integer representing the end of the range\n  Args    : end location on set (can be fuzzy string)\n\n\nsub end {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->end_pos_type($encode);\n    $self->min_end($min);\n    $self->max_end($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                 $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN' && defined $self->SUPER::start &&\n                ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::end();\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : $min_start = $fuzzy->min_start();\n  Function: get/set the minimum starting point\n  Returns : the minimum starting point from the contained sublocations\n  Args    : integer or undef on set\n\n\nsub min_start {\n    my ($self,@args) = @_;\n\n    if(@args) {\n    $self->{'_min_start'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_min_start'};\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get/set maximum starting location of feature startpoint  \n  Returns : integer or undef if no maximum starting point.\n  Args    : integer or undef on set\n\n\nsub max_start {\n    my ($self,@args) = @_;\n\n    if(@args) {\n        $self->{'_max_start'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_max_start'};\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get/set start position type.\n  Returns : type of position coded as text \n            ('BEFORE','AFTER','EXACT','WITHIN','BETWEEN','UNCERTAIN')\n  Args    : a string on set","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":346},"start":{"line":328,"character":0}},"name":"start_pos_type"},{"detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Fuzzy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Fuzzy\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Fuzzy - Implementation of a Location on a Sequence\nwhich has unclear start and/or end locations\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Fuzzy;\n    my $fuzzylocation = Bio::Location::Fuzzy->new(\n                                                 -start => '<30',\n                                                 -end   => 90,\n                                                 -location_type => '..');\n\n    print \"location string is \", $fuzzylocation->to_FTstring(), \"\\n\";\n    print \"location is of the type \", $fuzzylocation->location_type, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis module contains the necessary methods for representing a\nFuzzy Location, one that does not have clear start and/or end points.\nThis will initially serve to handle features from Genbank/EMBL feature\ntables that are written as 1^100 meaning between bases 1 and 100 or\nE<lt>100..300 meaning it starts somewhere before 100.  Advanced\nimplementations of this interface may be able to handle the necessary\nlogic of overlaps/intersection/contains/union.  It was constructed to\nhandle fuzzy locations that can be represented in Genbank/EMBL and\nSwissprot.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Fuzzy;\nuse strict;\n\nuse base qw(Bio::Location::Atomic Bio::Location::FuzzyLocationI);\n\nour @LOCATIONCODESBSANE = (undef, 'EXACT', 'WITHIN', 'BETWEEN', 'UNCERTAIN',\n            'BEFORE', 'AFTER');\n\nour %FUZZYCODES = ( 'EXACT' => '..', # Position is 'exact\n   # Exact position is unknown, but is within the range specified, ((1.2)..100)\n            'WITHIN' => '.', \n            # 1^2\n            'BETWEEN'    => '^',\n            'IN-BETWEEN' => '^',\n            'UNCERTAIN'  => '?',\n            # <100\n            'BEFORE'  => '<',\n            # >10\n            'AFTER'   => '>');   \n   \n    # The following regular expressions map to fuzzy location types. Every\n    # expression must match the complete encoded point string, and must\n    # contain two groups identifying min and max. Empty matches are automatic.\n    # converted to undef, except for 'EXACT', for which max is set to equal\n    # min.\n    \nour %FUZZYPOINTENCODE = ( \n    '\\>(\\d+)(.{0})' => 'AFTER',\n    '\\<(.{0})(\\d+)' => 'BEFORE',\n    '(\\d+)'         => 'EXACT',\n    '\\?(\\d*)'       => 'UNCERTAIN',\n    '(\\d+)(.{0})\\>' => 'AFTER',\n    '(.{0})(\\d+)\\<' => 'BEFORE',\n    '(\\d+)\\.(\\d+)'  => 'WITHIN',\n    '(\\d+)\\^(\\d+)'  => 'BETWEEN',\n   );\n    \nour %FUZZYRANGEENCODE  = (  '\\.'   => 'WITHIN',\n                            '\\.\\.' => 'EXACT',\n                            '\\^'   => 'IN-BETWEEN' );\n\n=head2 new\n\n Title   : new\n Usage   : my $fuzzyloc = Bio::Location::Fuzzy->new( @args);\n Function:\n Returns : \n Args    : -start    => value for start  (initialize by superclass)\n           -end      => value for end    (initialize by superclass)\n           -strand   => value for strand (initialize by superclass)\n           -location_type => either ('EXACT','WITHIN','IN-BETWEEN',\n                             'UNCERTAIN') OR ( 1,2,3,4)\n           -start_ext=> extension for start - defaults to 0, \n           -start_fuz=  fuzzy code for start can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN' ) OR\n                      a value 1 - 5 corresponding to index+1 above\n           -end_ext=> extension for end - defaults to 0, \n           -end_fuz=  fuzzy code for end can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN') OR\n                      a value 1 - 5 corresponding to index+1 above\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($location_type, $start_ext, $start_fuz, $end_ext, $end_fuz) = \n        $self->_rearrange([ qw(LOCATION_TYPE START_EXT START_FUZ \n                   END_EXT END_FUZ )\n                ], @args);\n\n    $location_type  && $self->location_type($location_type);\n    $start_ext && $self->max_start($self->min_start + $start_ext);\n    $end_ext   && $self->max_end($self->min_end + $end_ext);\n    $start_fuz && $self->start_pos_type($start_fuz);\n    $end_fuz   && $self->end_pos_type($end_fuz);\n\n    return $self;\n}\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN', 'UNCERTAIN')\n  Args    : none\n\n\nsub location_type {\n    my ($self,$value) = @_;\n    if( defined $value || ! defined $self->{'_location_type'} ) {\n        $value = 'EXACT' unless defined $value;\n        if(! defined $FUZZYCODES{$value} )  {\n            $value = uc($value);\n            if( $value =~ /\\.\\./ ) {\n                $value = 'EXACT';\n            } elsif( $value =~ /^\\.$/ ) {\n                $value = 'WITHIN';\n            } elsif( $value =~ /\\^/ ) {\n                $value = 'IN-BETWEEN';\n                $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                             $self->start. \"] and [\". $self->end. \"]\")\n                  if defined $self->start && defined $self->end &&\n                            ($self->end - 1 == $self->start);\n            } elsif( $value =~ /\\?/ ) {\n                $value = 'UNCERTAIN';\n            } elsif( $value ne 'EXACT' && $value ne 'WITHIN' && \n                        $value ne 'IN-BETWEEN' ) {\n                $self->throw(\"Did not specify a valid location type\");\n            }\n        }\n        $self->{'_location_type'} = $value;\n    }\n    return $self->{'_location_type'};\n}\n\n=head1 LocationI methods\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $fuzzy_loc->length();\n  Function: Get the length of this location.\n\n            Note that the length of a fuzzy location will always depend\n            on the currently active interpretation of start and end. The\n            result will therefore vary for different CoordinatePolicy objects.\n\n  Returns : an integer\n  Args    : none\n\n\n#sub length {\n#    my($self) = @_;\n#    return $self->SUPER::length() if( !$self->start || !$self->end);\n#    $self->warn('Length is not valid for a FuzzyLocation'); \n#    return 0;\n#}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $fuzzy->start();\n  Function: get/set start of this range, handling fuzzy_starts\n  Returns : a positive integer representing the start of the location\n  Args    : start location on set (can be fuzzy point string)\n\n\nsub start {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->start_pos_type($encode);\n    $self->min_start($min);\n    $self->max_start($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\"\n                 . $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN'  && defined $self->SUPER::end &&\n                  ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $fuzzy->end();\n  Function: get/set end of this range, handling fuzzy_ends\n  Returns : a positive integer representing the end of the range\n  Args    : end location on set (can be fuzzy string)\n\n\nsub end {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->end_pos_type($encode);\n    $self->min_end($min);\n    $self->max_end($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                 $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN' && defined $self->SUPER::start &&\n                ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::end();\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : $min_start = $fuzzy->min_start();\n  Function: get/set the minimum starting point\n  Returns : the minimum starting point from the contained sublocations\n  Args    : integer or undef on set\n\n\nsub min_start {\n    my ($self,@args) = @_;\n\n    if(@args) {\n    $self->{'_min_start'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_min_start'};\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get/set maximum starting location of feature startpoint  \n  Returns : integer or undef if no maximum starting point.\n  Args    : integer or undef on set\n\n\nsub max_start {\n    my ($self,@args) = @_;\n\n    if(@args) {\n        $self->{'_max_start'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_max_start'};\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get/set start position type.\n  Returns : type of position coded as text \n            ('BEFORE','AFTER','EXACT','WITHIN','BETWEEN','UNCERTAIN')\n  Args    : a string on set\n\n\nsub start_pos_type {\n    my ($self,$value) = @_;\n    if(defined $value &&  $value =~ /^\\d+$/ ) {\n        if( $value == 0 ) { $value = 'EXACT'; }\n        else { \n            my $v = $LOCATIONCODESBSANE[$value];\n            if( ! defined $v ) {\n                $self->warn(\"Provided value $value which I don't understand,\".\n                            \" reverting to 'EXACT'\");\n                $v = 'EXACT';\n            }\n            $value = $v;\n        }\n    }\n    if(defined($value)) {\n        $self->{'_start_pos_type'} = $value;\n    }\n    return $self->{'_start_pos_type'};\n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get/set minimum ending location of feature endpoint \n  Returns : integer or undef if no minimum ending point.\n  Args    : integer or undef on set","label":"min_end($self,@args)"},"containerName":"main::","definition":"sub","line":358,"children":[{"line":359,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"min_end"},{"line":359,"kind":13,"name":"@args","containerName":"min_end"},{"line":361,"kind":13,"name":"@args","containerName":"min_end"},{"line":362,"kind":13,"name":"$self","containerName":"min_end"},{"containerName":"min_end","name":"$args","line":362,"kind":13},{"name":"$self","containerName":"min_end","kind":13,"line":364}],"kind":12,"range":{"end":{"line":365,"character":9999},"start":{"line":358,"character":0}},"name":"min_end"},{"signature":{"label":"max_end($self,@args)","documentation":"1;\n# $Id: Fuzzy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Fuzzy\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Fuzzy - Implementation of a Location on a Sequence\nwhich has unclear start and/or end locations\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Fuzzy;\n    my $fuzzylocation = Bio::Location::Fuzzy->new(\n                                                 -start => '<30',\n                                                 -end   => 90,\n                                                 -location_type => '..');\n\n    print \"location string is \", $fuzzylocation->to_FTstring(), \"\\n\";\n    print \"location is of the type \", $fuzzylocation->location_type, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis module contains the necessary methods for representing a\nFuzzy Location, one that does not have clear start and/or end points.\nThis will initially serve to handle features from Genbank/EMBL feature\ntables that are written as 1^100 meaning between bases 1 and 100 or\nE<lt>100..300 meaning it starts somewhere before 100.  Advanced\nimplementations of this interface may be able to handle the necessary\nlogic of overlaps/intersection/contains/union.  It was constructed to\nhandle fuzzy locations that can be represented in Genbank/EMBL and\nSwissprot.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Fuzzy;\nuse strict;\n\nuse base qw(Bio::Location::Atomic Bio::Location::FuzzyLocationI);\n\nour @LOCATIONCODESBSANE = (undef, 'EXACT', 'WITHIN', 'BETWEEN', 'UNCERTAIN',\n            'BEFORE', 'AFTER');\n\nour %FUZZYCODES = ( 'EXACT' => '..', # Position is 'exact\n   # Exact position is unknown, but is within the range specified, ((1.2)..100)\n            'WITHIN' => '.', \n            # 1^2\n            'BETWEEN'    => '^',\n            'IN-BETWEEN' => '^',\n            'UNCERTAIN'  => '?',\n            # <100\n            'BEFORE'  => '<',\n            # >10\n            'AFTER'   => '>');   \n   \n    # The following regular expressions map to fuzzy location types. Every\n    # expression must match the complete encoded point string, and must\n    # contain two groups identifying min and max. Empty matches are automatic.\n    # converted to undef, except for 'EXACT', for which max is set to equal\n    # min.\n    \nour %FUZZYPOINTENCODE = ( \n    '\\>(\\d+)(.{0})' => 'AFTER',\n    '\\<(.{0})(\\d+)' => 'BEFORE',\n    '(\\d+)'         => 'EXACT',\n    '\\?(\\d*)'       => 'UNCERTAIN',\n    '(\\d+)(.{0})\\>' => 'AFTER',\n    '(.{0})(\\d+)\\<' => 'BEFORE',\n    '(\\d+)\\.(\\d+)'  => 'WITHIN',\n    '(\\d+)\\^(\\d+)'  => 'BETWEEN',\n   );\n    \nour %FUZZYRANGEENCODE  = (  '\\.'   => 'WITHIN',\n                            '\\.\\.' => 'EXACT',\n                            '\\^'   => 'IN-BETWEEN' );\n\n=head2 new\n\n Title   : new\n Usage   : my $fuzzyloc = Bio::Location::Fuzzy->new( @args);\n Function:\n Returns : \n Args    : -start    => value for start  (initialize by superclass)\n           -end      => value for end    (initialize by superclass)\n           -strand   => value for strand (initialize by superclass)\n           -location_type => either ('EXACT','WITHIN','IN-BETWEEN',\n                             'UNCERTAIN') OR ( 1,2,3,4)\n           -start_ext=> extension for start - defaults to 0, \n           -start_fuz=  fuzzy code for start can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN' ) OR\n                      a value 1 - 5 corresponding to index+1 above\n           -end_ext=> extension for end - defaults to 0, \n           -end_fuz=  fuzzy code for end can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN') OR\n                      a value 1 - 5 corresponding to index+1 above\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($location_type, $start_ext, $start_fuz, $end_ext, $end_fuz) = \n        $self->_rearrange([ qw(LOCATION_TYPE START_EXT START_FUZ \n                   END_EXT END_FUZ )\n                ], @args);\n\n    $location_type  && $self->location_type($location_type);\n    $start_ext && $self->max_start($self->min_start + $start_ext);\n    $end_ext   && $self->max_end($self->min_end + $end_ext);\n    $start_fuz && $self->start_pos_type($start_fuz);\n    $end_fuz   && $self->end_pos_type($end_fuz);\n\n    return $self;\n}\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN', 'UNCERTAIN')\n  Args    : none\n\n\nsub location_type {\n    my ($self,$value) = @_;\n    if( defined $value || ! defined $self->{'_location_type'} ) {\n        $value = 'EXACT' unless defined $value;\n        if(! defined $FUZZYCODES{$value} )  {\n            $value = uc($value);\n            if( $value =~ /\\.\\./ ) {\n                $value = 'EXACT';\n            } elsif( $value =~ /^\\.$/ ) {\n                $value = 'WITHIN';\n            } elsif( $value =~ /\\^/ ) {\n                $value = 'IN-BETWEEN';\n                $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                             $self->start. \"] and [\". $self->end. \"]\")\n                  if defined $self->start && defined $self->end &&\n                            ($self->end - 1 == $self->start);\n            } elsif( $value =~ /\\?/ ) {\n                $value = 'UNCERTAIN';\n            } elsif( $value ne 'EXACT' && $value ne 'WITHIN' && \n                        $value ne 'IN-BETWEEN' ) {\n                $self->throw(\"Did not specify a valid location type\");\n            }\n        }\n        $self->{'_location_type'} = $value;\n    }\n    return $self->{'_location_type'};\n}\n\n=head1 LocationI methods\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $fuzzy_loc->length();\n  Function: Get the length of this location.\n\n            Note that the length of a fuzzy location will always depend\n            on the currently active interpretation of start and end. The\n            result will therefore vary for different CoordinatePolicy objects.\n\n  Returns : an integer\n  Args    : none\n\n\n#sub length {\n#    my($self) = @_;\n#    return $self->SUPER::length() if( !$self->start || !$self->end);\n#    $self->warn('Length is not valid for a FuzzyLocation'); \n#    return 0;\n#}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $fuzzy->start();\n  Function: get/set start of this range, handling fuzzy_starts\n  Returns : a positive integer representing the start of the location\n  Args    : start location on set (can be fuzzy point string)\n\n\nsub start {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->start_pos_type($encode);\n    $self->min_start($min);\n    $self->max_start($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\"\n                 . $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN'  && defined $self->SUPER::end &&\n                  ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $fuzzy->end();\n  Function: get/set end of this range, handling fuzzy_ends\n  Returns : a positive integer representing the end of the range\n  Args    : end location on set (can be fuzzy string)\n\n\nsub end {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->end_pos_type($encode);\n    $self->min_end($min);\n    $self->max_end($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                 $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN' && defined $self->SUPER::start &&\n                ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::end();\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : $min_start = $fuzzy->min_start();\n  Function: get/set the minimum starting point\n  Returns : the minimum starting point from the contained sublocations\n  Args    : integer or undef on set\n\n\nsub min_start {\n    my ($self,@args) = @_;\n\n    if(@args) {\n    $self->{'_min_start'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_min_start'};\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get/set maximum starting location of feature startpoint  \n  Returns : integer or undef if no maximum starting point.\n  Args    : integer or undef on set\n\n\nsub max_start {\n    my ($self,@args) = @_;\n\n    if(@args) {\n        $self->{'_max_start'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_max_start'};\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get/set start position type.\n  Returns : type of position coded as text \n            ('BEFORE','AFTER','EXACT','WITHIN','BETWEEN','UNCERTAIN')\n  Args    : a string on set\n\n\nsub start_pos_type {\n    my ($self,$value) = @_;\n    if(defined $value &&  $value =~ /^\\d+$/ ) {\n        if( $value == 0 ) { $value = 'EXACT'; }\n        else { \n            my $v = $LOCATIONCODESBSANE[$value];\n            if( ! defined $v ) {\n                $self->warn(\"Provided value $value which I don't understand,\".\n                            \" reverting to 'EXACT'\");\n                $v = 'EXACT';\n            }\n            $value = $v;\n        }\n    }\n    if(defined($value)) {\n        $self->{'_start_pos_type'} = $value;\n    }\n    return $self->{'_start_pos_type'};\n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get/set minimum ending location of feature endpoint \n  Returns : integer or undef if no minimum ending point.\n  Args    : integer or undef on set\n\n\nsub min_end {\n    my ($self,@args) = @_;\n\n    if(@args) {\n        $self->{'_min_end'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_min_end'};\n}\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get/set maximum ending location of feature endpoint \n  Returns : integer or undef if no maximum ending point.\n  Args    : integer or undef on set","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"line":378,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"max_end"},{"kind":13,"line":378,"name":"@args","containerName":"max_end"},{"containerName":"max_end","name":"@args","line":380,"kind":13},{"kind":13,"line":381,"containerName":"max_end","name":"$self"},{"name":"$args","containerName":"max_end","kind":13,"line":381},{"kind":13,"line":383,"containerName":"max_end","name":"$self"}],"line":377,"kind":12,"range":{"start":{"character":0,"line":377},"end":{"line":384,"character":9999}},"name":"max_end"},{"line":397,"children":[{"containerName":"end_pos_type","definition":"my","name":"$self","localvar":"my","kind":13,"line":398},{"containerName":"end_pos_type","name":"$value","line":398,"kind":13},{"containerName":"end_pos_type","name":"$value","kind":13,"line":399},{"name":"$value","containerName":"end_pos_type","kind":13,"line":399},{"containerName":"end_pos_type","name":"$value","line":400,"kind":13},{"name":"$value","containerName":"end_pos_type","kind":13,"line":400},{"localvar":"my","definition":"my","name":"$v","containerName":"end_pos_type","line":402,"kind":13},{"line":402,"kind":13,"containerName":"end_pos_type","name":"$LOCATIONCODESBSANE"},{"containerName":"end_pos_type","name":"$value","kind":13,"line":402},{"line":403,"kind":13,"name":"$v","containerName":"end_pos_type"},{"name":"$self","containerName":"end_pos_type","kind":13,"line":404},{"kind":12,"line":404,"name":"warn","containerName":"end_pos_type"},{"line":406,"kind":13,"name":"$v","containerName":"end_pos_type"},{"line":408,"kind":13,"containerName":"end_pos_type","name":"$value"},{"kind":13,"line":408,"name":"$v","containerName":"end_pos_type"},{"name":"$value","containerName":"end_pos_type","line":412,"kind":13},{"name":"$self","containerName":"end_pos_type","kind":13,"line":413},{"line":413,"kind":13,"name":"$value","containerName":"end_pos_type"},{"line":415,"kind":13,"name":"$self","containerName":"end_pos_type"}],"kind":12,"detail":"($self,$value)","signature":{"label":"end_pos_type($self,$value)","documentation":"1;\n# $Id: Fuzzy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Fuzzy\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Fuzzy - Implementation of a Location on a Sequence\nwhich has unclear start and/or end locations\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Fuzzy;\n    my $fuzzylocation = Bio::Location::Fuzzy->new(\n                                                 -start => '<30',\n                                                 -end   => 90,\n                                                 -location_type => '..');\n\n    print \"location string is \", $fuzzylocation->to_FTstring(), \"\\n\";\n    print \"location is of the type \", $fuzzylocation->location_type, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis module contains the necessary methods for representing a\nFuzzy Location, one that does not have clear start and/or end points.\nThis will initially serve to handle features from Genbank/EMBL feature\ntables that are written as 1^100 meaning between bases 1 and 100 or\nE<lt>100..300 meaning it starts somewhere before 100.  Advanced\nimplementations of this interface may be able to handle the necessary\nlogic of overlaps/intersection/contains/union.  It was constructed to\nhandle fuzzy locations that can be represented in Genbank/EMBL and\nSwissprot.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Fuzzy;\nuse strict;\n\nuse base qw(Bio::Location::Atomic Bio::Location::FuzzyLocationI);\n\nour @LOCATIONCODESBSANE = (undef, 'EXACT', 'WITHIN', 'BETWEEN', 'UNCERTAIN',\n            'BEFORE', 'AFTER');\n\nour %FUZZYCODES = ( 'EXACT' => '..', # Position is 'exact\n   # Exact position is unknown, but is within the range specified, ((1.2)..100)\n            'WITHIN' => '.', \n            # 1^2\n            'BETWEEN'    => '^',\n            'IN-BETWEEN' => '^',\n            'UNCERTAIN'  => '?',\n            # <100\n            'BEFORE'  => '<',\n            # >10\n            'AFTER'   => '>');   \n   \n    # The following regular expressions map to fuzzy location types. Every\n    # expression must match the complete encoded point string, and must\n    # contain two groups identifying min and max. Empty matches are automatic.\n    # converted to undef, except for 'EXACT', for which max is set to equal\n    # min.\n    \nour %FUZZYPOINTENCODE = ( \n    '\\>(\\d+)(.{0})' => 'AFTER',\n    '\\<(.{0})(\\d+)' => 'BEFORE',\n    '(\\d+)'         => 'EXACT',\n    '\\?(\\d*)'       => 'UNCERTAIN',\n    '(\\d+)(.{0})\\>' => 'AFTER',\n    '(.{0})(\\d+)\\<' => 'BEFORE',\n    '(\\d+)\\.(\\d+)'  => 'WITHIN',\n    '(\\d+)\\^(\\d+)'  => 'BETWEEN',\n   );\n    \nour %FUZZYRANGEENCODE  = (  '\\.'   => 'WITHIN',\n                            '\\.\\.' => 'EXACT',\n                            '\\^'   => 'IN-BETWEEN' );\n\n=head2 new\n\n Title   : new\n Usage   : my $fuzzyloc = Bio::Location::Fuzzy->new( @args);\n Function:\n Returns : \n Args    : -start    => value for start  (initialize by superclass)\n           -end      => value for end    (initialize by superclass)\n           -strand   => value for strand (initialize by superclass)\n           -location_type => either ('EXACT','WITHIN','IN-BETWEEN',\n                             'UNCERTAIN') OR ( 1,2,3,4)\n           -start_ext=> extension for start - defaults to 0, \n           -start_fuz=  fuzzy code for start can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN' ) OR\n                      a value 1 - 5 corresponding to index+1 above\n           -end_ext=> extension for end - defaults to 0, \n           -end_fuz=  fuzzy code for end can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN') OR\n                      a value 1 - 5 corresponding to index+1 above\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($location_type, $start_ext, $start_fuz, $end_ext, $end_fuz) = \n        $self->_rearrange([ qw(LOCATION_TYPE START_EXT START_FUZ \n                   END_EXT END_FUZ )\n                ], @args);\n\n    $location_type  && $self->location_type($location_type);\n    $start_ext && $self->max_start($self->min_start + $start_ext);\n    $end_ext   && $self->max_end($self->min_end + $end_ext);\n    $start_fuz && $self->start_pos_type($start_fuz);\n    $end_fuz   && $self->end_pos_type($end_fuz);\n\n    return $self;\n}\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN', 'UNCERTAIN')\n  Args    : none\n\n\nsub location_type {\n    my ($self,$value) = @_;\n    if( defined $value || ! defined $self->{'_location_type'} ) {\n        $value = 'EXACT' unless defined $value;\n        if(! defined $FUZZYCODES{$value} )  {\n            $value = uc($value);\n            if( $value =~ /\\.\\./ ) {\n                $value = 'EXACT';\n            } elsif( $value =~ /^\\.$/ ) {\n                $value = 'WITHIN';\n            } elsif( $value =~ /\\^/ ) {\n                $value = 'IN-BETWEEN';\n                $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                             $self->start. \"] and [\". $self->end. \"]\")\n                  if defined $self->start && defined $self->end &&\n                            ($self->end - 1 == $self->start);\n            } elsif( $value =~ /\\?/ ) {\n                $value = 'UNCERTAIN';\n            } elsif( $value ne 'EXACT' && $value ne 'WITHIN' && \n                        $value ne 'IN-BETWEEN' ) {\n                $self->throw(\"Did not specify a valid location type\");\n            }\n        }\n        $self->{'_location_type'} = $value;\n    }\n    return $self->{'_location_type'};\n}\n\n=head1 LocationI methods\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $fuzzy_loc->length();\n  Function: Get the length of this location.\n\n            Note that the length of a fuzzy location will always depend\n            on the currently active interpretation of start and end. The\n            result will therefore vary for different CoordinatePolicy objects.\n\n  Returns : an integer\n  Args    : none\n\n\n#sub length {\n#    my($self) = @_;\n#    return $self->SUPER::length() if( !$self->start || !$self->end);\n#    $self->warn('Length is not valid for a FuzzyLocation'); \n#    return 0;\n#}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $fuzzy->start();\n  Function: get/set start of this range, handling fuzzy_starts\n  Returns : a positive integer representing the start of the location\n  Args    : start location on set (can be fuzzy point string)\n\n\nsub start {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->start_pos_type($encode);\n    $self->min_start($min);\n    $self->max_start($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\"\n                 . $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN'  && defined $self->SUPER::end &&\n                  ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $fuzzy->end();\n  Function: get/set end of this range, handling fuzzy_ends\n  Returns : a positive integer representing the end of the range\n  Args    : end location on set (can be fuzzy string)\n\n\nsub end {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->end_pos_type($encode);\n    $self->min_end($min);\n    $self->max_end($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                 $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN' && defined $self->SUPER::start &&\n                ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::end();\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : $min_start = $fuzzy->min_start();\n  Function: get/set the minimum starting point\n  Returns : the minimum starting point from the contained sublocations\n  Args    : integer or undef on set\n\n\nsub min_start {\n    my ($self,@args) = @_;\n\n    if(@args) {\n    $self->{'_min_start'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_min_start'};\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get/set maximum starting location of feature startpoint  \n  Returns : integer or undef if no maximum starting point.\n  Args    : integer or undef on set\n\n\nsub max_start {\n    my ($self,@args) = @_;\n\n    if(@args) {\n        $self->{'_max_start'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_max_start'};\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get/set start position type.\n  Returns : type of position coded as text \n            ('BEFORE','AFTER','EXACT','WITHIN','BETWEEN','UNCERTAIN')\n  Args    : a string on set\n\n\nsub start_pos_type {\n    my ($self,$value) = @_;\n    if(defined $value &&  $value =~ /^\\d+$/ ) {\n        if( $value == 0 ) { $value = 'EXACT'; }\n        else { \n            my $v = $LOCATIONCODESBSANE[$value];\n            if( ! defined $v ) {\n                $self->warn(\"Provided value $value which I don't understand,\".\n                            \" reverting to 'EXACT'\");\n                $v = 'EXACT';\n            }\n            $value = $v;\n        }\n    }\n    if(defined($value)) {\n        $self->{'_start_pos_type'} = $value;\n    }\n    return $self->{'_start_pos_type'};\n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get/set minimum ending location of feature endpoint \n  Returns : integer or undef if no minimum ending point.\n  Args    : integer or undef on set\n\n\nsub min_end {\n    my ($self,@args) = @_;\n\n    if(@args) {\n        $self->{'_min_end'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_min_end'};\n}\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get/set maximum ending location of feature endpoint \n  Returns : integer or undef if no maximum ending point.\n  Args    : integer or undef on set\n\n\nsub max_end {\n    my ($self,@args) = @_;\n\n    if(@args) {\n        $self->{'_max_end'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_max_end'};\n}\n\n=head2 end_pos_type\n\n  Title   : end_pos_type\n  Usage   : my $end_pos_type = $location->end_pos_type();\n  Function: Get/set end position type.\n  Returns : type of position coded as text \n            ('BEFORE','AFTER','EXACT','WITHIN','BETWEEN','UNCERTAIN')\n  Args    : a string on set","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":416},"start":{"character":0,"line":397}},"name":"end_pos_type"},{"name":"to_FTstring","range":{"end":{"character":9999,"line":553},"start":{"line":468,"character":0}},"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"to_FTstring","line":469,"kind":13},{"name":"%vals","definition":"my","containerName":"to_FTstring","localvar":"my","kind":13,"line":470},{"containerName":"to_FTstring","name":"$self","kind":13,"line":470},{"kind":12,"line":470,"name":"start","containerName":"to_FTstring"},{"kind":13,"line":471,"containerName":"to_FTstring","name":"$self"},{"kind":12,"line":471,"name":"min_start","containerName":"to_FTstring"},{"line":472,"kind":13,"containerName":"to_FTstring","name":"$self"},{"kind":12,"line":472,"name":"max_start","containerName":"to_FTstring"},{"name":"$self","containerName":"to_FTstring","line":473,"kind":13},{"kind":12,"line":473,"name":"start_pos_type","containerName":"to_FTstring"},{"name":"$self","containerName":"to_FTstring","kind":13,"line":474},{"kind":12,"line":474,"name":"end","containerName":"to_FTstring"},{"name":"$self","containerName":"to_FTstring","line":475,"kind":13},{"containerName":"to_FTstring","name":"min_end","kind":12,"line":475},{"kind":13,"line":476,"containerName":"to_FTstring","name":"$self"},{"name":"max_end","containerName":"to_FTstring","line":476,"kind":12},{"line":477,"kind":13,"name":"$self","containerName":"to_FTstring"},{"name":"end_pos_type","containerName":"to_FTstring","kind":12,"line":477},{"localvar":"my","definition":"my","name":"%strs","containerName":"to_FTstring","line":479,"kind":13},{"line":481,"kind":13,"localvar":"my","name":"$delimiter","definition":"my","containerName":"to_FTstring"},{"name":"$FUZZYCODES","containerName":"to_FTstring","line":481,"kind":13},{"name":"$self","containerName":"to_FTstring","line":481,"kind":13},{"line":481,"kind":12,"name":"location_type","containerName":"to_FTstring"},{"kind":13,"line":482,"name":"$delimiter","containerName":"to_FTstring"},{"containerName":"to_FTstring","name":"$FUZZYCODES","kind":13,"line":482},{"containerName":"to_FTstring","name":"$self","kind":13,"line":482},{"line":482,"kind":12,"name":"location_type","containerName":"to_FTstring"},{"kind":13,"line":484,"definition":"my","name":"$policy","containerName":"to_FTstring","localvar":"my"},{"kind":13,"line":484,"containerName":"to_FTstring","name":"$self"},{"line":484,"kind":12,"name":"coordinate_policy","containerName":"to_FTstring"},{"localvar":"my","containerName":"to_FTstring","definition":"my","name":"$point","line":489,"kind":13},{"containerName":"to_FTstring","name":"$vals","kind":13,"line":490},{"name":"$point","containerName":"to_FTstring","line":490,"kind":13},{"name":"$vals","containerName":"to_FTstring","line":491,"kind":13},{"containerName":"to_FTstring","name":"$point","line":491,"kind":13},{"name":"$vals","containerName":"to_FTstring","line":494,"kind":13},{"containerName":"to_FTstring","name":"$vals","kind":13,"line":495},{"name":"$vals","containerName":"to_FTstring","kind":13,"line":496},{"line":496,"kind":13,"containerName":"to_FTstring","name":"$point"},{"name":"$vals","containerName":"to_FTstring","kind":13,"line":497},{"line":497,"kind":13,"name":"$point","containerName":"to_FTstring"},{"containerName":"to_FTstring","name":"$vals","kind":13,"line":499},{"containerName":"to_FTstring","name":"$vals","line":499,"kind":13},{"containerName":"to_FTstring","name":"$vals","kind":13,"line":500},{"containerName":"to_FTstring","name":"$vals","kind":13,"line":500},{"name":"$self","containerName":"to_FTstring","line":502,"kind":13},{"containerName":"to_FTstring","name":"warn","line":502,"kind":12},{"kind":13,"line":503,"containerName":"to_FTstring","name":"$vals"},{"line":504,"kind":13,"containerName":"to_FTstring","name":"$vals"},{"line":505,"kind":13,"containerName":"to_FTstring","name":"$vals"},{"line":505,"kind":13,"containerName":"to_FTstring","name":"$point"},{"containerName":"to_FTstring","name":"$vals","line":509,"kind":13},{"line":509,"kind":13,"name":"$point","containerName":"to_FTstring"},{"name":"$vals","containerName":"to_FTstring","line":510,"kind":13},{"name":"$point","containerName":"to_FTstring","line":510,"kind":13},{"kind":13,"line":511,"containerName":"to_FTstring","name":"$vals"},{"line":511,"kind":13,"containerName":"to_FTstring","name":"$point"},{"name":"$strs","containerName":"to_FTstring","kind":13,"line":513},{"containerName":"to_FTstring","name":"$point","kind":13,"line":513},{"line":513,"kind":13,"name":"$FUZZYCODES","containerName":"to_FTstring"},{"name":"$vals","containerName":"to_FTstring","kind":13,"line":513},{"line":513,"kind":13,"containerName":"to_FTstring","name":"$point"},{"line":514,"kind":13,"containerName":"to_FTstring","name":"$strs"},{"line":514,"kind":13,"containerName":"to_FTstring","name":"$point"},{"kind":13,"line":514,"containerName":"to_FTstring","name":"$vals"},{"name":"$vals","containerName":"to_FTstring","line":517,"kind":13},{"containerName":"to_FTstring","name":"$point","line":517,"kind":13},{"containerName":"to_FTstring","name":"$vals","line":518,"kind":13},{"kind":13,"line":518,"containerName":"to_FTstring","name":"$point"},{"containerName":"to_FTstring","name":"$vals","kind":13,"line":519},{"name":"$point","containerName":"to_FTstring","line":519,"kind":13},{"containerName":"to_FTstring","name":"$strs","kind":13,"line":522},{"line":522,"kind":13,"containerName":"to_FTstring","name":"$point"},{"line":522,"kind":13,"name":"$point","containerName":"to_FTstring"},{"containerName":"to_FTstring","name":"$vals","kind":13,"line":523},{"name":"$FUZZYCODES","containerName":"to_FTstring","kind":13,"line":524},{"name":"$vals","containerName":"to_FTstring","line":524,"kind":13},{"line":524,"kind":13,"name":"$point","containerName":"to_FTstring"},{"kind":13,"line":525,"name":"$vals","containerName":"to_FTstring"},{"kind":13,"line":525,"containerName":"to_FTstring","name":"$point"},{"name":"$vals","containerName":"to_FTstring","line":527,"kind":13},{"line":527,"kind":13,"name":"$point","containerName":"to_FTstring"},{"containerName":"to_FTstring","name":"$FUZZYCODES","kind":13,"line":528},{"kind":13,"line":528,"containerName":"to_FTstring","name":"$vals"},{"containerName":"to_FTstring","name":"$point","kind":13,"line":528},{"kind":13,"line":529,"name":"$vals","containerName":"to_FTstring"},{"line":530,"kind":13,"name":"$strs","containerName":"to_FTstring"},{"name":"$point","containerName":"to_FTstring","line":530,"kind":13},{"containerName":"to_FTstring","name":"$strs","line":530,"kind":13},{"name":"$point","containerName":"to_FTstring","kind":13,"line":530},{"line":533,"kind":13,"containerName":"to_FTstring","name":"$vals"},{"name":"$point","containerName":"to_FTstring","kind":13,"line":533},{"line":534,"kind":13,"containerName":"to_FTstring","name":"$strs"},{"name":"$point","containerName":"to_FTstring","kind":13,"line":534},{"containerName":"to_FTstring","name":"$FUZZYCODES","line":534,"kind":13},{"containerName":"to_FTstring","name":"$vals","kind":13,"line":534},{"name":"$point","containerName":"to_FTstring","line":534,"kind":13},{"kind":13,"line":535,"containerName":"to_FTstring","name":"$strs"},{"kind":13,"line":535,"name":"$point","containerName":"to_FTstring"},{"name":"$vals","containerName":"to_FTstring","line":535,"kind":13},{"containerName":"to_FTstring","name":"$point","line":535,"kind":13},{"line":535,"kind":13,"name":"$vals","containerName":"to_FTstring"},{"name":"$point","containerName":"to_FTstring","line":535,"kind":13},{"kind":13,"line":537,"containerName":"to_FTstring","name":"$strs"},{"containerName":"to_FTstring","name":"$point","line":537,"kind":13},{"line":537,"kind":13,"name":"$vals","containerName":"to_FTstring"},{"containerName":"to_FTstring","name":"$point","kind":13,"line":537},{"kind":13,"line":541,"name":"$str","definition":"my","containerName":"to_FTstring","localvar":"my"},{"name":"$strs","containerName":"to_FTstring","line":541,"kind":13},{"name":"$delimiter","containerName":"to_FTstring","line":541,"kind":13},{"line":541,"kind":13,"name":"$strs","containerName":"to_FTstring"},{"containerName":"to_FTstring","name":"$self","kind":13,"line":542},{"line":542,"kind":12,"containerName":"to_FTstring","name":"is_remote"},{"name":"$self","containerName":"to_FTstring","line":542,"kind":13},{"name":"seq_id","containerName":"to_FTstring","kind":12,"line":542},{"line":543,"kind":13,"name":"$str","containerName":"to_FTstring"},{"kind":13,"line":543,"name":"$self","containerName":"to_FTstring"},{"containerName":"to_FTstring","name":"seq_id","kind":12,"line":543},{"line":543,"kind":13,"containerName":"to_FTstring","name":"$str"},{"name":"$self","containerName":"to_FTstring","kind":13,"line":545},{"name":"strand","containerName":"to_FTstring","kind":12,"line":545},{"line":546,"kind":13,"containerName":"to_FTstring","name":"$self"},{"kind":12,"line":546,"containerName":"to_FTstring","name":"strand"},{"kind":13,"line":547,"containerName":"to_FTstring","name":"$self"},{"name":"location_type","containerName":"to_FTstring","line":547,"kind":12},{"line":548,"kind":13,"name":"$str","containerName":"to_FTstring"},{"name":"$str","containerName":"to_FTstring","kind":13,"line":548},{"name":"$self","containerName":"to_FTstring","line":549,"kind":13},{"containerName":"to_FTstring","name":"location_type","kind":12,"line":549},{"name":"$str","containerName":"to_FTstring","line":550,"kind":13},{"name":"$str","containerName":"to_FTstring","line":550,"kind":13},{"containerName":"to_FTstring","name":"$str","kind":13,"line":552}],"line":468,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: Fuzzy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Fuzzy\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Fuzzy - Implementation of a Location on a Sequence\nwhich has unclear start and/or end locations\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Fuzzy;\n    my $fuzzylocation = Bio::Location::Fuzzy->new(\n                                                 -start => '<30',\n                                                 -end   => 90,\n                                                 -location_type => '..');\n\n    print \"location string is \", $fuzzylocation->to_FTstring(), \"\\n\";\n    print \"location is of the type \", $fuzzylocation->location_type, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis module contains the necessary methods for representing a\nFuzzy Location, one that does not have clear start and/or end points.\nThis will initially serve to handle features from Genbank/EMBL feature\ntables that are written as 1^100 meaning between bases 1 and 100 or\nE<lt>100..300 meaning it starts somewhere before 100.  Advanced\nimplementations of this interface may be able to handle the necessary\nlogic of overlaps/intersection/contains/union.  It was constructed to\nhandle fuzzy locations that can be represented in Genbank/EMBL and\nSwissprot.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Fuzzy;\nuse strict;\n\nuse base qw(Bio::Location::Atomic Bio::Location::FuzzyLocationI);\n\nour @LOCATIONCODESBSANE = (undef, 'EXACT', 'WITHIN', 'BETWEEN', 'UNCERTAIN',\n            'BEFORE', 'AFTER');\n\nour %FUZZYCODES = ( 'EXACT' => '..', # Position is 'exact\n   # Exact position is unknown, but is within the range specified, ((1.2)..100)\n            'WITHIN' => '.', \n            # 1^2\n            'BETWEEN'    => '^',\n            'IN-BETWEEN' => '^',\n            'UNCERTAIN'  => '?',\n            # <100\n            'BEFORE'  => '<',\n            # >10\n            'AFTER'   => '>');   \n   \n    # The following regular expressions map to fuzzy location types. Every\n    # expression must match the complete encoded point string, and must\n    # contain two groups identifying min and max. Empty matches are automatic.\n    # converted to undef, except for 'EXACT', for which max is set to equal\n    # min.\n    \nour %FUZZYPOINTENCODE = ( \n    '\\>(\\d+)(.{0})' => 'AFTER',\n    '\\<(.{0})(\\d+)' => 'BEFORE',\n    '(\\d+)'         => 'EXACT',\n    '\\?(\\d*)'       => 'UNCERTAIN',\n    '(\\d+)(.{0})\\>' => 'AFTER',\n    '(.{0})(\\d+)\\<' => 'BEFORE',\n    '(\\d+)\\.(\\d+)'  => 'WITHIN',\n    '(\\d+)\\^(\\d+)'  => 'BETWEEN',\n   );\n    \nour %FUZZYRANGEENCODE  = (  '\\.'   => 'WITHIN',\n                            '\\.\\.' => 'EXACT',\n                            '\\^'   => 'IN-BETWEEN' );\n\n=head2 new\n\n Title   : new\n Usage   : my $fuzzyloc = Bio::Location::Fuzzy->new( @args);\n Function:\n Returns : \n Args    : -start    => value for start  (initialize by superclass)\n           -end      => value for end    (initialize by superclass)\n           -strand   => value for strand (initialize by superclass)\n           -location_type => either ('EXACT','WITHIN','IN-BETWEEN',\n                             'UNCERTAIN') OR ( 1,2,3,4)\n           -start_ext=> extension for start - defaults to 0, \n           -start_fuz=  fuzzy code for start can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN' ) OR\n                      a value 1 - 5 corresponding to index+1 above\n           -end_ext=> extension for end - defaults to 0, \n           -end_fuz=  fuzzy code for end can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN') OR\n                      a value 1 - 5 corresponding to index+1 above\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($location_type, $start_ext, $start_fuz, $end_ext, $end_fuz) = \n        $self->_rearrange([ qw(LOCATION_TYPE START_EXT START_FUZ \n                   END_EXT END_FUZ )\n                ], @args);\n\n    $location_type  && $self->location_type($location_type);\n    $start_ext && $self->max_start($self->min_start + $start_ext);\n    $end_ext   && $self->max_end($self->min_end + $end_ext);\n    $start_fuz && $self->start_pos_type($start_fuz);\n    $end_fuz   && $self->end_pos_type($end_fuz);\n\n    return $self;\n}\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN', 'UNCERTAIN')\n  Args    : none\n\n\nsub location_type {\n    my ($self,$value) = @_;\n    if( defined $value || ! defined $self->{'_location_type'} ) {\n        $value = 'EXACT' unless defined $value;\n        if(! defined $FUZZYCODES{$value} )  {\n            $value = uc($value);\n            if( $value =~ /\\.\\./ ) {\n                $value = 'EXACT';\n            } elsif( $value =~ /^\\.$/ ) {\n                $value = 'WITHIN';\n            } elsif( $value =~ /\\^/ ) {\n                $value = 'IN-BETWEEN';\n                $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                             $self->start. \"] and [\". $self->end. \"]\")\n                  if defined $self->start && defined $self->end &&\n                            ($self->end - 1 == $self->start);\n            } elsif( $value =~ /\\?/ ) {\n                $value = 'UNCERTAIN';\n            } elsif( $value ne 'EXACT' && $value ne 'WITHIN' && \n                        $value ne 'IN-BETWEEN' ) {\n                $self->throw(\"Did not specify a valid location type\");\n            }\n        }\n        $self->{'_location_type'} = $value;\n    }\n    return $self->{'_location_type'};\n}\n\n=head1 LocationI methods\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $fuzzy_loc->length();\n  Function: Get the length of this location.\n\n            Note that the length of a fuzzy location will always depend\n            on the currently active interpretation of start and end. The\n            result will therefore vary for different CoordinatePolicy objects.\n\n  Returns : an integer\n  Args    : none\n\n\n#sub length {\n#    my($self) = @_;\n#    return $self->SUPER::length() if( !$self->start || !$self->end);\n#    $self->warn('Length is not valid for a FuzzyLocation'); \n#    return 0;\n#}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $fuzzy->start();\n  Function: get/set start of this range, handling fuzzy_starts\n  Returns : a positive integer representing the start of the location\n  Args    : start location on set (can be fuzzy point string)\n\n\nsub start {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->start_pos_type($encode);\n    $self->min_start($min);\n    $self->max_start($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\"\n                 . $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN'  && defined $self->SUPER::end &&\n                  ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $fuzzy->end();\n  Function: get/set end of this range, handling fuzzy_ends\n  Returns : a positive integer representing the end of the range\n  Args    : end location on set (can be fuzzy string)\n\n\nsub end {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->end_pos_type($encode);\n    $self->min_end($min);\n    $self->max_end($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                 $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN' && defined $self->SUPER::start &&\n                ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::end();\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : $min_start = $fuzzy->min_start();\n  Function: get/set the minimum starting point\n  Returns : the minimum starting point from the contained sublocations\n  Args    : integer or undef on set\n\n\nsub min_start {\n    my ($self,@args) = @_;\n\n    if(@args) {\n    $self->{'_min_start'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_min_start'};\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get/set maximum starting location of feature startpoint  \n  Returns : integer or undef if no maximum starting point.\n  Args    : integer or undef on set\n\n\nsub max_start {\n    my ($self,@args) = @_;\n\n    if(@args) {\n        $self->{'_max_start'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_max_start'};\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get/set start position type.\n  Returns : type of position coded as text \n            ('BEFORE','AFTER','EXACT','WITHIN','BETWEEN','UNCERTAIN')\n  Args    : a string on set\n\n\nsub start_pos_type {\n    my ($self,$value) = @_;\n    if(defined $value &&  $value =~ /^\\d+$/ ) {\n        if( $value == 0 ) { $value = 'EXACT'; }\n        else { \n            my $v = $LOCATIONCODESBSANE[$value];\n            if( ! defined $v ) {\n                $self->warn(\"Provided value $value which I don't understand,\".\n                            \" reverting to 'EXACT'\");\n                $v = 'EXACT';\n            }\n            $value = $v;\n        }\n    }\n    if(defined($value)) {\n        $self->{'_start_pos_type'} = $value;\n    }\n    return $self->{'_start_pos_type'};\n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get/set minimum ending location of feature endpoint \n  Returns : integer or undef if no minimum ending point.\n  Args    : integer or undef on set\n\n\nsub min_end {\n    my ($self,@args) = @_;\n\n    if(@args) {\n        $self->{'_min_end'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_min_end'};\n}\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get/set maximum ending location of feature endpoint \n  Returns : integer or undef if no maximum ending point.\n  Args    : integer or undef on set\n\n\nsub max_end {\n    my ($self,@args) = @_;\n\n    if(@args) {\n        $self->{'_max_end'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_max_end'};\n}\n\n=head2 end_pos_type\n\n  Title   : end_pos_type\n  Usage   : my $end_pos_type = $location->end_pos_type();\n  Function: Get/set end position type.\n  Returns : type of position coded as text \n            ('BEFORE','AFTER','EXACT','WITHIN','BETWEEN','UNCERTAIN')\n  Args    : a string on set\n\n\nsub end_pos_type {\n    my ($self,$value) = @_;\n    if( defined $value && $value =~ /^\\d+$/ ) {\n        if( $value == 0 ) { $value = 'EXACT'; }\n        else { \n            my $v = $LOCATIONCODESBSANE[$value];\n            if( ! defined $v ) {\n                $self->warn(\"Provided value $value which I don't understand,\".\n                            \" reverting to 'EXACT'\");\n                $v = 'EXACT';\n            }\n            $value = $v;\n        }\n    }\n\n    if(defined($value)) {\n        $self->{'_end_pos_type'} = $value;\n    }\n    return $self->{'_end_pos_type'};\n}\n\n=head2 seq_id\n\n  Title   : seq_id\n  Usage   : my $seqid = $location->seq_id();\n  Function: Get/Set seq_id that location refers to\n  Returns : seq_id\n  Args    : [optional] seq_id value to set\n\n\n=head2 coordinate_policy\n\n  Title   : coordinate_policy\n\n  Usage   : $policy = $location->coordinate_policy();\n            $location->coordinate_policy($mypolicy); # set may not be possible\n  Function: Get the coordinate computing policy employed by this object.\n\n            See Bio::Location::CoordinatePolicyI for documentation about\n            the policy object and its use.\n\n            The interface *does not* require implementing classes to accept\n            setting of a different policy. The implementation provided here\n            does, however, allow to do so.\n\n            Implementors of this interface are expected to initialize every\n            new instance with a CoordinatePolicyI object. The implementation\n            provided here will return a default policy object if none has\n            been set yet. To change this default policy object call this\n            method as a class method with an appropriate argument. Note that\n            in this case only subsequently created Location objects will be\n            affected.\n\n  Returns : A Bio::Location::CoordinatePolicyI implementing object.\n  Args    : On set, a Bio::Location::CoordinatePolicyI implementing object.\n\nSee L<Bio::Location::CoordinatePolicyI>\n\n\n=head2 to_FTstring\n\n  Title   : to_FTstring\n  Usage   : my $locstr = $location->to_FTstring()\n  Function: Get/Set seq_id that location refers to\n  Returns : seq_id\n  Args    : [optional] seq_id value to set","parameters":[{"label":"$self"}],"label":"to_FTstring($self)"},"detail":"($self)"},{"containerName":"main::","definition":"sub","detail":"($self,$string)","signature":{"parameters":[{"label":"$self"},{"label":"$string"}],"documentation":"1;\n# $Id: Fuzzy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Fuzzy\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Fuzzy - Implementation of a Location on a Sequence\nwhich has unclear start and/or end locations\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Fuzzy;\n    my $fuzzylocation = Bio::Location::Fuzzy->new(\n                                                 -start => '<30',\n                                                 -end   => 90,\n                                                 -location_type => '..');\n\n    print \"location string is \", $fuzzylocation->to_FTstring(), \"\\n\";\n    print \"location is of the type \", $fuzzylocation->location_type, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis module contains the necessary methods for representing a\nFuzzy Location, one that does not have clear start and/or end points.\nThis will initially serve to handle features from Genbank/EMBL feature\ntables that are written as 1^100 meaning between bases 1 and 100 or\nE<lt>100..300 meaning it starts somewhere before 100.  Advanced\nimplementations of this interface may be able to handle the necessary\nlogic of overlaps/intersection/contains/union.  It was constructed to\nhandle fuzzy locations that can be represented in Genbank/EMBL and\nSwissprot.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Location::Fuzzy;\nuse strict;\n\nuse base qw(Bio::Location::Atomic Bio::Location::FuzzyLocationI);\n\nour @LOCATIONCODESBSANE = (undef, 'EXACT', 'WITHIN', 'BETWEEN', 'UNCERTAIN',\n            'BEFORE', 'AFTER');\n\nour %FUZZYCODES = ( 'EXACT' => '..', # Position is 'exact\n   # Exact position is unknown, but is within the range specified, ((1.2)..100)\n            'WITHIN' => '.', \n            # 1^2\n            'BETWEEN'    => '^',\n            'IN-BETWEEN' => '^',\n            'UNCERTAIN'  => '?',\n            # <100\n            'BEFORE'  => '<',\n            # >10\n            'AFTER'   => '>');   \n   \n    # The following regular expressions map to fuzzy location types. Every\n    # expression must match the complete encoded point string, and must\n    # contain two groups identifying min and max. Empty matches are automatic.\n    # converted to undef, except for 'EXACT', for which max is set to equal\n    # min.\n    \nour %FUZZYPOINTENCODE = ( \n    '\\>(\\d+)(.{0})' => 'AFTER',\n    '\\<(.{0})(\\d+)' => 'BEFORE',\n    '(\\d+)'         => 'EXACT',\n    '\\?(\\d*)'       => 'UNCERTAIN',\n    '(\\d+)(.{0})\\>' => 'AFTER',\n    '(.{0})(\\d+)\\<' => 'BEFORE',\n    '(\\d+)\\.(\\d+)'  => 'WITHIN',\n    '(\\d+)\\^(\\d+)'  => 'BETWEEN',\n   );\n    \nour %FUZZYRANGEENCODE  = (  '\\.'   => 'WITHIN',\n                            '\\.\\.' => 'EXACT',\n                            '\\^'   => 'IN-BETWEEN' );\n\n=head2 new\n\n Title   : new\n Usage   : my $fuzzyloc = Bio::Location::Fuzzy->new( @args);\n Function:\n Returns : \n Args    : -start    => value for start  (initialize by superclass)\n           -end      => value for end    (initialize by superclass)\n           -strand   => value for strand (initialize by superclass)\n           -location_type => either ('EXACT','WITHIN','IN-BETWEEN',\n                             'UNCERTAIN') OR ( 1,2,3,4)\n           -start_ext=> extension for start - defaults to 0, \n           -start_fuz=  fuzzy code for start can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN' ) OR\n                      a value 1 - 5 corresponding to index+1 above\n           -end_ext=> extension for end - defaults to 0, \n           -end_fuz=  fuzzy code for end can be \n                      ('EXACT','WITHIN','BETWEEN','BEFORE','AFTER',\n                       'UNCERTAIN') OR\n                      a value 1 - 5 corresponding to index+1 above\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($location_type, $start_ext, $start_fuz, $end_ext, $end_fuz) = \n        $self->_rearrange([ qw(LOCATION_TYPE START_EXT START_FUZ \n                   END_EXT END_FUZ )\n                ], @args);\n\n    $location_type  && $self->location_type($location_type);\n    $start_ext && $self->max_start($self->min_start + $start_ext);\n    $end_ext   && $self->max_end($self->min_end + $end_ext);\n    $start_fuz && $self->start_pos_type($start_fuz);\n    $end_fuz   && $self->end_pos_type($end_fuz);\n\n    return $self;\n}\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN', 'UNCERTAIN')\n  Args    : none\n\n\nsub location_type {\n    my ($self,$value) = @_;\n    if( defined $value || ! defined $self->{'_location_type'} ) {\n        $value = 'EXACT' unless defined $value;\n        if(! defined $FUZZYCODES{$value} )  {\n            $value = uc($value);\n            if( $value =~ /\\.\\./ ) {\n                $value = 'EXACT';\n            } elsif( $value =~ /^\\.$/ ) {\n                $value = 'WITHIN';\n            } elsif( $value =~ /\\^/ ) {\n                $value = 'IN-BETWEEN';\n                $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                             $self->start. \"] and [\". $self->end. \"]\")\n                  if defined $self->start && defined $self->end &&\n                            ($self->end - 1 == $self->start);\n            } elsif( $value =~ /\\?/ ) {\n                $value = 'UNCERTAIN';\n            } elsif( $value ne 'EXACT' && $value ne 'WITHIN' && \n                        $value ne 'IN-BETWEEN' ) {\n                $self->throw(\"Did not specify a valid location type\");\n            }\n        }\n        $self->{'_location_type'} = $value;\n    }\n    return $self->{'_location_type'};\n}\n\n=head1 LocationI methods\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $fuzzy_loc->length();\n  Function: Get the length of this location.\n\n            Note that the length of a fuzzy location will always depend\n            on the currently active interpretation of start and end. The\n            result will therefore vary for different CoordinatePolicy objects.\n\n  Returns : an integer\n  Args    : none\n\n\n#sub length {\n#    my($self) = @_;\n#    return $self->SUPER::length() if( !$self->start || !$self->end);\n#    $self->warn('Length is not valid for a FuzzyLocation'); \n#    return 0;\n#}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $fuzzy->start();\n  Function: get/set start of this range, handling fuzzy_starts\n  Returns : a positive integer representing the start of the location\n  Args    : start location on set (can be fuzzy point string)\n\n\nsub start {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->start_pos_type($encode);\n    $self->min_start($min);\n    $self->max_start($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\"\n                 . $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN'  && defined $self->SUPER::end &&\n                  ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $fuzzy->end();\n  Function: get/set end of this range, handling fuzzy_ends\n  Returns : a positive integer representing the end of the range\n  Args    : end location on set (can be fuzzy string)\n\n\nsub end {\n    my($self,$value) = @_;\n    if( defined $value ) {\n    my ($encode,$min,$max) = $self->_fuzzypointdecode($value);\n    $self->end_pos_type($encode);\n    $self->min_end($min);\n    $self->max_end($max);\n    }\n\n    $self->throw(\"Use Bio::Location::Simple for IN-BETWEEN locations [\".\n                 $self->SUPER::start. \"] and [\". $self->SUPER::end. \"]\")\n    if $self->location_type eq 'IN-BETWEEN' && defined $self->SUPER::start &&\n                ($self->SUPER::end - 1 == $self->SUPER::start);\n\n    return $self->SUPER::end();\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : $min_start = $fuzzy->min_start();\n  Function: get/set the minimum starting point\n  Returns : the minimum starting point from the contained sublocations\n  Args    : integer or undef on set\n\n\nsub min_start {\n    my ($self,@args) = @_;\n\n    if(@args) {\n    $self->{'_min_start'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_min_start'};\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get/set maximum starting location of feature startpoint  \n  Returns : integer or undef if no maximum starting point.\n  Args    : integer or undef on set\n\n\nsub max_start {\n    my ($self,@args) = @_;\n\n    if(@args) {\n        $self->{'_max_start'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_max_start'};\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get/set start position type.\n  Returns : type of position coded as text \n            ('BEFORE','AFTER','EXACT','WITHIN','BETWEEN','UNCERTAIN')\n  Args    : a string on set\n\n\nsub start_pos_type {\n    my ($self,$value) = @_;\n    if(defined $value &&  $value =~ /^\\d+$/ ) {\n        if( $value == 0 ) { $value = 'EXACT'; }\n        else { \n            my $v = $LOCATIONCODESBSANE[$value];\n            if( ! defined $v ) {\n                $self->warn(\"Provided value $value which I don't understand,\".\n                            \" reverting to 'EXACT'\");\n                $v = 'EXACT';\n            }\n            $value = $v;\n        }\n    }\n    if(defined($value)) {\n        $self->{'_start_pos_type'} = $value;\n    }\n    return $self->{'_start_pos_type'};\n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get/set minimum ending location of feature endpoint \n  Returns : integer or undef if no minimum ending point.\n  Args    : integer or undef on set\n\n\nsub min_end {\n    my ($self,@args) = @_;\n\n    if(@args) {\n        $self->{'_min_end'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_min_end'};\n}\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get/set maximum ending location of feature endpoint \n  Returns : integer or undef if no maximum ending point.\n  Args    : integer or undef on set\n\n\nsub max_end {\n    my ($self,@args) = @_;\n\n    if(@args) {\n        $self->{'_max_end'} = $args[0]; # the value may be undef!\n    }\n    return $self->{'_max_end'};\n}\n\n=head2 end_pos_type\n\n  Title   : end_pos_type\n  Usage   : my $end_pos_type = $location->end_pos_type();\n  Function: Get/set end position type.\n  Returns : type of position coded as text \n            ('BEFORE','AFTER','EXACT','WITHIN','BETWEEN','UNCERTAIN')\n  Args    : a string on set\n\n\nsub end_pos_type {\n    my ($self,$value) = @_;\n    if( defined $value && $value =~ /^\\d+$/ ) {\n        if( $value == 0 ) { $value = 'EXACT'; }\n        else { \n            my $v = $LOCATIONCODESBSANE[$value];\n            if( ! defined $v ) {\n                $self->warn(\"Provided value $value which I don't understand,\".\n                            \" reverting to 'EXACT'\");\n                $v = 'EXACT';\n            }\n            $value = $v;\n        }\n    }\n\n    if(defined($value)) {\n        $self->{'_end_pos_type'} = $value;\n    }\n    return $self->{'_end_pos_type'};\n}\n\n=head2 seq_id\n\n  Title   : seq_id\n  Usage   : my $seqid = $location->seq_id();\n  Function: Get/Set seq_id that location refers to\n  Returns : seq_id\n  Args    : [optional] seq_id value to set\n\n\n=head2 coordinate_policy\n\n  Title   : coordinate_policy\n\n  Usage   : $policy = $location->coordinate_policy();\n            $location->coordinate_policy($mypolicy); # set may not be possible\n  Function: Get the coordinate computing policy employed by this object.\n\n            See Bio::Location::CoordinatePolicyI for documentation about\n            the policy object and its use.\n\n            The interface *does not* require implementing classes to accept\n            setting of a different policy. The implementation provided here\n            does, however, allow to do so.\n\n            Implementors of this interface are expected to initialize every\n            new instance with a CoordinatePolicyI object. The implementation\n            provided here will return a default policy object if none has\n            been set yet. To change this default policy object call this\n            method as a class method with an appropriate argument. Note that\n            in this case only subsequently created Location objects will be\n            affected.\n\n  Returns : A Bio::Location::CoordinatePolicyI implementing object.\n  Args    : On set, a Bio::Location::CoordinatePolicyI implementing object.\n\nSee L<Bio::Location::CoordinatePolicyI>\n\n\n=head2 to_FTstring\n\n  Title   : to_FTstring\n  Usage   : my $locstr = $location->to_FTstring()\n  Function: Get/Set seq_id that location refers to\n  Returns : seq_id\n  Args    : [optional] seq_id value to set\n\n\nsub to_FTstring {\n    my ($self) = @_;    \n    my (%vals) = ( 'start' => $self->start,\n           'min_start' => $self->min_start,\n           'max_start' => $self->max_start,\n           'start_code' => $self->start_pos_type,\n           'end' => $self->end,\n           'min_end' => $self->min_end,\n           'max_end' => $self->max_end,\n           'end_code' => $self->end_pos_type );\n\n    my (%strs) = ( 'start' => '',\n           'end'   => '');\n    my ($delimiter) = $FUZZYCODES{$self->location_type};\n    $delimiter = $FUZZYCODES{'EXACT'} if ($self->location_type eq 'UNCERTAIN');\n    \n    my $policy = ref($self->coordinate_policy);\n    \n    # I'm lazy, lets do this in a loop since behaviour will be the same for \n    # start and end\n    # The CoordinatePolicy now dictates start/end data here (bug 992) - cjf\n    foreach my $point ( qw(start end) ) {\n        if( ($vals{$point.\"_code\"} ne 'EXACT') &&\n            ($vals{$point.\"_code\"} ne 'UNCERTAIN') ) {\n            \n            # must have max and min defined to use 'WITHIN', 'BETWEEN'\n            if ((!defined $vals{\"min_$point\"} ||\n                 !defined $vals{\"max_$point\"}) && \n                ( $vals{$point.\"_code\"} eq 'WITHIN' || \n                  $vals{$point.\"_code\"} eq 'BETWEEN'))\n            {\n                $vals{\"min_$point\"} = '' unless defined $vals{\"min_$point\"};\n                $vals{\"max_$point\"} = '' unless defined $vals{\"max_$point\"};\n                \n                $self->warn(\"Fuzzy codes for start are in a strange state, (\".\n                        join(\",\", ($vals{\"min_$point\"}, \n                               $vals{\"max_$point\"},\n                               $vals{$point.\"_code\"})). \")\");\n                return '';\n            }\n            \n            if (defined $vals{$point.\"_code\"} && \n               ($vals{$point.\"_code\"} eq 'BEFORE' ||\n                $vals{$point.\"_code\"} eq 'AFTER'))\n            {\n                $strs{$point} .= $FUZZYCODES{$vals{$point.\"_code\"}};\n                $strs{$point} .= $vals{\"$point\"};\n            }\n \n            if( defined $vals{$point.\"_code\"} && \n              ($vals{$point.\"_code\"} eq 'WITHIN' ||\n               $vals{$point.\"_code\"} eq 'BETWEEN'))\n            {\n                # Expect odd results with anything but WidestCoordPolicy for now\n                $strs{$point} .= ($point eq 'start') ?\n                        $vals{\"$point\"}.\n                        $FUZZYCODES{$vals{$point.\"_code\"}}.\n                        $vals{'max_'.$point}\n                        :\n                        $vals{'min_'.$point}.\n                        $FUZZYCODES{$vals{$point.\"_code\"}}.\n                        $vals{\"$point\"};\n                $strs{$point} = \"(\".$strs{$point}.\")\";\n            }\n            \n        } elsif ($vals{$point.\"_code\"} eq 'UNCERTAIN') {\n            $strs{$point}  = $FUZZYCODES{$vals{$point.\"_code\"}};\n            $strs{$point} .= $vals{$point} if defined $vals{$point};\n        } else {\n            $strs{$point} = $vals{$point};\n        }\n    }\n    \n    my $str = $strs{'start'} . $delimiter . $strs{'end'};\n    if($self->is_remote() && $self->seq_id()) {\n    $str = $self->seq_id() . \":\" . $str;\n    }\n    if( defined $self->strand && \n    $self->strand == -1 &&\n    $self->location_type() ne \"UNCERTAIN\") {\n    $str = \"complement(\" . $str . \")\";\n    } elsif($self->location_type() eq \"WITHIN\") {\n    $str = \"(\".$str.\")\";\n    }\n    return $str;\n}\n\n=head2 valid_Location\n\n Title   : valid_Location\n Usage   : if ($location->valid_location) {...};\n Function: boolean method to determine whether location is considered valid\n           (has minimum requirements for Simple implementation)\n Returns : Boolean value: true if location is valid, false otherwise\n Args    : none\n\n\n=head2 _fuzzypointdecode\n\n  Title   : _fuzzypointdecode\n  Usage   : ($type,$min,$max) = $self->_fuzzypointdecode('<5');\n  Function: Decode a fuzzy string.\n  Returns : A 3-element array consisting of the type of location, the\n            minimum integer, and the maximum integer describing the range\n            of coordinates this start or endpoint refers to. Minimum or\n            maximum coordinate may be undefined.\n          : Returns empty array on fail.\n  Args    : fuzzypoint string","label":"_fuzzypointdecode($self,$string)"},"kind":12,"line":580,"children":[{"containerName":"_fuzzypointdecode","definition":"my","name":"$self","localvar":"my","kind":13,"line":581},{"line":581,"kind":13,"containerName":"_fuzzypointdecode","name":"$string"},{"name":"$string","containerName":"_fuzzypointdecode","line":582,"kind":13},{"kind":13,"line":584,"containerName":"_fuzzypointdecode","name":"$string"},{"containerName":"_fuzzypointdecode","definition":"my","name":"$pattern","localvar":"my","kind":13,"line":585},{"line":585,"kind":13,"containerName":"_fuzzypointdecode","name":"%FUZZYPOINTENCODE"},{"kind":13,"line":586,"name":"$string","containerName":"_fuzzypointdecode"},{"kind":13,"line":587,"name":"$min","definition":"my","containerName":"_fuzzypointdecode","localvar":"my"},{"line":587,"kind":13,"name":"$max","containerName":"_fuzzypointdecode"},{"containerName":"_fuzzypointdecode","name":"$FUZZYPOINTENCODE","kind":13,"line":588},{"name":"$pattern","containerName":"_fuzzypointdecode","kind":13,"line":588},{"line":589,"kind":13,"name":"$FUZZYPOINTENCODE","containerName":"_fuzzypointdecode"},{"line":589,"kind":13,"containerName":"_fuzzypointdecode","name":"$pattern"},{"containerName":"_fuzzypointdecode","name":"$max","line":591,"kind":13},{"line":591,"kind":13,"name":"$min","containerName":"_fuzzypointdecode"},{"kind":13,"line":593,"containerName":"_fuzzypointdecode","name":"$max"},{"name":"$max","containerName":"_fuzzypointdecode","kind":13,"line":593},{"containerName":"_fuzzypointdecode","name":"$max","kind":13,"line":593},{"name":"$min","containerName":"_fuzzypointdecode","line":594,"kind":13},{"containerName":"_fuzzypointdecode","name":"$min","line":594,"kind":13},{"name":"$min","containerName":"_fuzzypointdecode","kind":13,"line":594},{"line":596,"kind":13,"containerName":"_fuzzypointdecode","name":"$FUZZYPOINTENCODE"},{"kind":13,"line":596,"containerName":"_fuzzypointdecode","name":"$pattern"},{"line":596,"kind":13,"name":"$min","containerName":"_fuzzypointdecode"},{"line":596,"kind":13,"name":"$max","containerName":"_fuzzypointdecode"},{"containerName":"_fuzzypointdecode","name":"$self","line":599,"kind":13},{"name":"verbose","containerName":"_fuzzypointdecode","line":599,"kind":12},{"line":600,"kind":13,"name":"$self","containerName":"_fuzzypointdecode"},{"kind":12,"line":600,"containerName":"_fuzzypointdecode","name":"warn"}],"name":"_fuzzypointdecode","range":{"start":{"line":580,"character":0},"end":{"line":603,"character":9999}}}]}