{"vars":[{"kind":2,"line":111,"name":"base","containerName":""},{"detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":""},"containerName":"main::","definition":"sub","line":113,"children":[{"kind":13,"line":114,"name":"$class","definition":"my","containerName":"new","localvar":"my"},{"kind":13,"line":114,"containerName":"new","name":"@args"},{"line":115,"kind":13,"localvar":"my","containerName":"new","name":"$self","definition":"my"},{"containerName":"new","name":"$self","line":116,"kind":13},{"containerName":"new","name":"$self","line":117,"kind":13},{"containerName":"new","name":"$class","kind":13,"line":117},{"localvar":"my","containerName":"new","definition":"my","name":"$seq","line":119,"kind":13},{"name":"$seqori","containerName":"new","kind":13,"line":119},{"line":119,"kind":13,"containerName":"new","name":"$pos"},{"kind":13,"line":119,"name":"$len","containerName":"new"},{"name":"$label","containerName":"new","line":119,"kind":13},{"kind":13,"line":120,"containerName":"new","name":"$self"},{"name":"_rearrange","containerName":"new","kind":12,"line":120},{"kind":13,"line":125,"containerName":"new","name":"@args"},{"name":"$seq","containerName":"new","kind":13,"line":127},{"containerName":"new","name":"$self","kind":13,"line":127},{"line":127,"kind":12,"name":"seq","containerName":"new"},{"name":"$seq","containerName":"new","line":127,"kind":13},{"kind":13,"line":128,"name":"$seqori","containerName":"new"},{"kind":13,"line":128,"name":"$self","containerName":"new"},{"line":128,"kind":12,"name":"seqori","containerName":"new"},{"name":"$seqori","containerName":"new","line":128,"kind":13},{"name":"$pos","containerName":"new","line":129,"kind":13},{"kind":13,"line":129,"containerName":"new","name":"$self"},{"kind":12,"line":129,"name":"pos","containerName":"new"},{"kind":13,"line":129,"name":"$pos","containerName":"new"},{"name":"$len","containerName":"new","kind":13,"line":130},{"line":130,"kind":13,"containerName":"new","name":"$self"},{"line":130,"kind":12,"name":"len","containerName":"new"},{"kind":13,"line":130,"containerName":"new","name":"$len"},{"kind":13,"line":132,"containerName":"new","name":"$self"}],"kind":12,"range":{"end":{"line":133,"character":9999},"start":{"line":113,"character":0}},"name":"new"},{"line":152,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"seq","line":153,"kind":13},{"line":153,"kind":13,"name":"$value","containerName":"seq"},{"line":154,"kind":13,"name":"$value","containerName":"seq"},{"name":"$self","containerName":"seq","line":155,"kind":13},{"containerName":"seq","name":"$value","line":155,"kind":13},{"kind":13,"line":157,"name":"$self","containerName":"seq"}],"kind":12,"detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: Mutation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LiveSeq::Mutation\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutation - Mutation event descriptor class\n\n=head1 SYNOPSIS\n\n  # full descrition of a point mutation\n  $mutation1a = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -seqori => 'T',\n\t\t\t\t\t      -pos  => 100,\n\t\t\t\t\t      -len => 1 # optional, defaults to length(seq)\n\t\t\t\t\t     );\n\n  # minimal information for a point mutation\n  $mutation1b = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -pos  => 100\n\t\t\t\t\t      );\n  # insertion\n  $mutation2 = Bio::LiveSeq::Mutation->new ( -seq => 'ATT',\n\t\t\t\t\t     -pos  => 100,\n\t\t\t\t\t     -len => 0\n\t\t\t\t\t     );\n  # deletion\n  $mutation3 = Bio::LiveSeq::Mutation->new ( -seq => '',  # optional\n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n  # complex\n  $mutation4 = Bio::LiveSeq::Mutation->new ( -seq => 'CC', \n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n\n\n=head1 DESCRIPTION\n\nThis class describes a local mutation event using minimalistic\ndescription.  It is not necessary to know anything about the original\nsequence. You need to give the changed sequence, the position of the\nmutation in the (unidentified) reference sequence, and the length of\nthe affected subsequence in the reference sequence. If the original\nallele sequence is given, the objects applying the mutation into the\nreference sequence (e.g. L<Bio::LiveSeq::Mutator>) might check for its\nvalidity.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutation;\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($seq, $seqori, $pos, $len, $label) =\n\t    $self->_rearrange([qw(SEQ\n\t\t\t\t  SEQORI\n\t\t\t\t  POS\n\t\t\t\t  LEN\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $seq && $self->seq($seq);\n    $seqori && $self->seqori($seqori);\n    $pos && $self->pos($pos);\n    defined($len) && $self->len($len); # defined() added otherwise won't work for len==0\n    \n    return $self; # success - we hope!\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $obj->seq();\n Function: \n\n            Sets and returns the mutated sequence. No checking is done\n            to validate the symbols.\n\n Example : \n Returns : string\n Args    : integer","parameters":[{"label":"$self"},{"label":"$value"}],"label":"seq($self,$value)"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":158},"start":{"character":0,"line":152}},"name":"seq"},{"range":{"end":{"line":184,"character":9999},"start":{"line":178,"character":0}},"name":"seqori","signature":{"label":"seqori($self,$value)","documentation":"1;\n# $Id: Mutation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LiveSeq::Mutation\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutation - Mutation event descriptor class\n\n=head1 SYNOPSIS\n\n  # full descrition of a point mutation\n  $mutation1a = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -seqori => 'T',\n\t\t\t\t\t      -pos  => 100,\n\t\t\t\t\t      -len => 1 # optional, defaults to length(seq)\n\t\t\t\t\t     );\n\n  # minimal information for a point mutation\n  $mutation1b = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -pos  => 100\n\t\t\t\t\t      );\n  # insertion\n  $mutation2 = Bio::LiveSeq::Mutation->new ( -seq => 'ATT',\n\t\t\t\t\t     -pos  => 100,\n\t\t\t\t\t     -len => 0\n\t\t\t\t\t     );\n  # deletion\n  $mutation3 = Bio::LiveSeq::Mutation->new ( -seq => '',  # optional\n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n  # complex\n  $mutation4 = Bio::LiveSeq::Mutation->new ( -seq => 'CC', \n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n\n\n=head1 DESCRIPTION\n\nThis class describes a local mutation event using minimalistic\ndescription.  It is not necessary to know anything about the original\nsequence. You need to give the changed sequence, the position of the\nmutation in the (unidentified) reference sequence, and the length of\nthe affected subsequence in the reference sequence. If the original\nallele sequence is given, the objects applying the mutation into the\nreference sequence (e.g. L<Bio::LiveSeq::Mutator>) might check for its\nvalidity.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutation;\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($seq, $seqori, $pos, $len, $label) =\n\t    $self->_rearrange([qw(SEQ\n\t\t\t\t  SEQORI\n\t\t\t\t  POS\n\t\t\t\t  LEN\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $seq && $self->seq($seq);\n    $seqori && $self->seqori($seqori);\n    $pos && $self->pos($pos);\n    defined($len) && $self->len($len); # defined() added otherwise won't work for len==0\n    \n    return $self; # success - we hope!\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $obj->seq();\n Function: \n\n            Sets and returns the mutated sequence. No checking is done\n            to validate the symbols.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub seq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seq'} = $value;\n    }\n    return $self->{'seq'} || '';\n}\n\n\n=head2 seqori\n\n Title   : seqori\n Usage   : $obj->seqori();\n Function: \n\n            Sets and returns the original subsequence in the reference\n            sequence. No checking is done to validate the symbols.\n            Optional value.\n\n Example : \n Returns : string\n Args    : string","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":179,"containerName":"seqori","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":179,"containerName":"seqori","name":"$value"},{"line":180,"kind":13,"containerName":"seqori","name":"$value"},{"containerName":"seqori","name":"$self","kind":13,"line":181},{"kind":13,"line":181,"name":"$value","containerName":"seqori"},{"line":183,"kind":13,"name":"$self","containerName":"seqori"}],"line":178,"kind":12},{"detail":"($self,$value)","signature":{"label":"pos($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Mutation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LiveSeq::Mutation\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutation - Mutation event descriptor class\n\n=head1 SYNOPSIS\n\n  # full descrition of a point mutation\n  $mutation1a = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -seqori => 'T',\n\t\t\t\t\t      -pos  => 100,\n\t\t\t\t\t      -len => 1 # optional, defaults to length(seq)\n\t\t\t\t\t     );\n\n  # minimal information for a point mutation\n  $mutation1b = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -pos  => 100\n\t\t\t\t\t      );\n  # insertion\n  $mutation2 = Bio::LiveSeq::Mutation->new ( -seq => 'ATT',\n\t\t\t\t\t     -pos  => 100,\n\t\t\t\t\t     -len => 0\n\t\t\t\t\t     );\n  # deletion\n  $mutation3 = Bio::LiveSeq::Mutation->new ( -seq => '',  # optional\n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n  # complex\n  $mutation4 = Bio::LiveSeq::Mutation->new ( -seq => 'CC', \n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n\n\n=head1 DESCRIPTION\n\nThis class describes a local mutation event using minimalistic\ndescription.  It is not necessary to know anything about the original\nsequence. You need to give the changed sequence, the position of the\nmutation in the (unidentified) reference sequence, and the length of\nthe affected subsequence in the reference sequence. If the original\nallele sequence is given, the objects applying the mutation into the\nreference sequence (e.g. L<Bio::LiveSeq::Mutator>) might check for its\nvalidity.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutation;\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($seq, $seqori, $pos, $len, $label) =\n\t    $self->_rearrange([qw(SEQ\n\t\t\t\t  SEQORI\n\t\t\t\t  POS\n\t\t\t\t  LEN\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $seq && $self->seq($seq);\n    $seqori && $self->seqori($seqori);\n    $pos && $self->pos($pos);\n    defined($len) && $self->len($len); # defined() added otherwise won't work for len==0\n    \n    return $self; # success - we hope!\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $obj->seq();\n Function: \n\n            Sets and returns the mutated sequence. No checking is done\n            to validate the symbols.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub seq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seq'} = $value;\n    }\n    return $self->{'seq'} || '';\n}\n\n\n=head2 seqori\n\n Title   : seqori\n Usage   : $obj->seqori();\n Function: \n\n            Sets and returns the original subsequence in the reference\n            sequence. No checking is done to validate the symbols.\n            Optional value.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub seqori {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seqori'} = $value;\n    }\n    return $self->{'seqori'} || '';\n}\n\n\n=head2 pos\n\n Title   : pos\n Usage   : $obj->pos();\n Function: \n\n            Sets and returns the position of the first element in the\n            sequence.\n\n Example : \n Returns : string\n Args    : integer"},"containerName":"main::","definition":"sub","line":203,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"pos","line":204,"kind":13},{"kind":13,"line":204,"name":"$value","containerName":"pos"},{"line":205,"kind":13,"name":"$value","containerName":"pos"},{"name":"$value","containerName":"pos","kind":13,"line":206},{"containerName":"pos","name":"$self","kind":13,"line":207},{"kind":12,"line":207,"name":"throw","containerName":"pos"},{"containerName":"pos","name":"$self","line":209,"kind":13},{"containerName":"pos","name":"$value","line":209,"kind":13},{"name":"$self","containerName":"pos","kind":13,"line":212}],"kind":12,"range":{"start":{"character":0,"line":203},"end":{"character":9999,"line":213}},"name":"pos"},{"kind":12,"line":231,"children":[{"containerName":"len","definition":"my","name":"$self","localvar":"my","kind":13,"line":232},{"line":232,"kind":13,"containerName":"len","name":"$value"},{"containerName":"len","name":"$value","line":233,"kind":13},{"name":"$self","containerName":"len","line":234,"kind":13},{"kind":13,"line":234,"containerName":"len","name":"$value"},{"line":236,"kind":13,"containerName":"len","name":"$self"},{"containerName":"len","name":"$self","line":237,"kind":13},{"containerName":"len","name":"$self","line":239,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"len($self,$value)","documentation":"1;\n# $Id: Mutation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LiveSeq::Mutation\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutation - Mutation event descriptor class\n\n=head1 SYNOPSIS\n\n  # full descrition of a point mutation\n  $mutation1a = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -seqori => 'T',\n\t\t\t\t\t      -pos  => 100,\n\t\t\t\t\t      -len => 1 # optional, defaults to length(seq)\n\t\t\t\t\t     );\n\n  # minimal information for a point mutation\n  $mutation1b = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -pos  => 100\n\t\t\t\t\t      );\n  # insertion\n  $mutation2 = Bio::LiveSeq::Mutation->new ( -seq => 'ATT',\n\t\t\t\t\t     -pos  => 100,\n\t\t\t\t\t     -len => 0\n\t\t\t\t\t     );\n  # deletion\n  $mutation3 = Bio::LiveSeq::Mutation->new ( -seq => '',  # optional\n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n  # complex\n  $mutation4 = Bio::LiveSeq::Mutation->new ( -seq => 'CC', \n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n\n\n=head1 DESCRIPTION\n\nThis class describes a local mutation event using minimalistic\ndescription.  It is not necessary to know anything about the original\nsequence. You need to give the changed sequence, the position of the\nmutation in the (unidentified) reference sequence, and the length of\nthe affected subsequence in the reference sequence. If the original\nallele sequence is given, the objects applying the mutation into the\nreference sequence (e.g. L<Bio::LiveSeq::Mutator>) might check for its\nvalidity.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutation;\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($seq, $seqori, $pos, $len, $label) =\n\t    $self->_rearrange([qw(SEQ\n\t\t\t\t  SEQORI\n\t\t\t\t  POS\n\t\t\t\t  LEN\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $seq && $self->seq($seq);\n    $seqori && $self->seqori($seqori);\n    $pos && $self->pos($pos);\n    defined($len) && $self->len($len); # defined() added otherwise won't work for len==0\n    \n    return $self; # success - we hope!\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $obj->seq();\n Function: \n\n            Sets and returns the mutated sequence. No checking is done\n            to validate the symbols.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub seq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seq'} = $value;\n    }\n    return $self->{'seq'} || '';\n}\n\n\n=head2 seqori\n\n Title   : seqori\n Usage   : $obj->seqori();\n Function: \n\n            Sets and returns the original subsequence in the reference\n            sequence. No checking is done to validate the symbols.\n            Optional value.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub seqori {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seqori'} = $value;\n    }\n    return $self->{'seqori'} || '';\n}\n\n\n=head2 pos\n\n Title   : pos\n Usage   : $obj->pos();\n Function: \n\n            Sets and returns the position of the first element in the\n            sequence.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub pos {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ( $value !~ /^([+-])?\\d+$/ ) {\n\t    $self->throw(\"[$value] for pos has to be an integer\\n\");\n\t} else {\n\t    $self->{'pos'} = $value;\n\t}\n    }\n    return $self->{'pos'};\n}\n\n=head2 len\n\n Title   : len\n Usage   : $obj->len();\n Function: \n\n            Sets and returns the len of the affected original allele\n            sequence.  If value is not set, defaults to the lenght of\n            the mutated sequence (seq).\n\n Example : \n Returns : string\n Args    : string","parameters":[{"label":"$self"},{"label":"$value"}]},"name":"len","range":{"end":{"line":240,"character":9999},"start":{"character":0,"line":231}}},{"line":259,"children":[{"containerName":"label","name":"$self","definition":"my","localvar":"my","kind":13,"line":260},{"line":260,"kind":13,"name":"$value","containerName":"label"},{"line":261,"kind":13,"containerName":"label","name":"$value"},{"containerName":"label","name":"$self","kind":13,"line":262},{"line":262,"kind":13,"containerName":"label","name":"$value"},{"kind":13,"line":264,"containerName":"label","name":"$self"},{"kind":13,"line":267,"containerName":"label","name":"$self"}],"kind":12,"detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: Mutation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LiveSeq::Mutation\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutation - Mutation event descriptor class\n\n=head1 SYNOPSIS\n\n  # full descrition of a point mutation\n  $mutation1a = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -seqori => 'T',\n\t\t\t\t\t      -pos  => 100,\n\t\t\t\t\t      -len => 1 # optional, defaults to length(seq)\n\t\t\t\t\t     );\n\n  # minimal information for a point mutation\n  $mutation1b = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -pos  => 100\n\t\t\t\t\t      );\n  # insertion\n  $mutation2 = Bio::LiveSeq::Mutation->new ( -seq => 'ATT',\n\t\t\t\t\t     -pos  => 100,\n\t\t\t\t\t     -len => 0\n\t\t\t\t\t     );\n  # deletion\n  $mutation3 = Bio::LiveSeq::Mutation->new ( -seq => '',  # optional\n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n  # complex\n  $mutation4 = Bio::LiveSeq::Mutation->new ( -seq => 'CC', \n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n\n\n=head1 DESCRIPTION\n\nThis class describes a local mutation event using minimalistic\ndescription.  It is not necessary to know anything about the original\nsequence. You need to give the changed sequence, the position of the\nmutation in the (unidentified) reference sequence, and the length of\nthe affected subsequence in the reference sequence. If the original\nallele sequence is given, the objects applying the mutation into the\nreference sequence (e.g. L<Bio::LiveSeq::Mutator>) might check for its\nvalidity.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutation;\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($seq, $seqori, $pos, $len, $label) =\n\t    $self->_rearrange([qw(SEQ\n\t\t\t\t  SEQORI\n\t\t\t\t  POS\n\t\t\t\t  LEN\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $seq && $self->seq($seq);\n    $seqori && $self->seqori($seqori);\n    $pos && $self->pos($pos);\n    defined($len) && $self->len($len); # defined() added otherwise won't work for len==0\n    \n    return $self; # success - we hope!\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $obj->seq();\n Function: \n\n            Sets and returns the mutated sequence. No checking is done\n            to validate the symbols.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub seq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seq'} = $value;\n    }\n    return $self->{'seq'} || '';\n}\n\n\n=head2 seqori\n\n Title   : seqori\n Usage   : $obj->seqori();\n Function: \n\n            Sets and returns the original subsequence in the reference\n            sequence. No checking is done to validate the symbols.\n            Optional value.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub seqori {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seqori'} = $value;\n    }\n    return $self->{'seqori'} || '';\n}\n\n\n=head2 pos\n\n Title   : pos\n Usage   : $obj->pos();\n Function: \n\n            Sets and returns the position of the first element in the\n            sequence.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub pos {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ( $value !~ /^([+-])?\\d+$/ ) {\n\t    $self->throw(\"[$value] for pos has to be an integer\\n\");\n\t} else {\n\t    $self->{'pos'} = $value;\n\t}\n    }\n    return $self->{'pos'};\n}\n\n=head2 len\n\n Title   : len\n Usage   : $obj->len();\n Function: \n\n            Sets and returns the len of the affected original allele\n            sequence.  If value is not set, defaults to the lenght of\n            the mutated sequence (seq).\n\n Example : \n Returns : string\n Args    : string\n\n\nsub len {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'len'} = $value;\n  }\n   if ( ! exists $self->{'len'} ) {\n       return length $self->{'seq'};\n   }\n   return $self->{'len'};\n}\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns the label of the affected original allele\n            location. Label is a stable identifier whereas location\n            can be changed by mutations. Label comes from\n            l<Bio::LiveSeq::Gene>.\n\n Example : \n Returns : string\n Args    : string","parameters":[{"label":"$self"},{"label":"$value"}],"label":"label($self,$value)"},"containerName":"main::","definition":"sub","range":{"end":{"line":268,"character":9999},"start":{"line":259,"character":0}},"name":"label"},{"range":{"start":{"line":289,"character":0},"end":{"character":9999,"line":299}},"name":"transpos","children":[{"line":290,"kind":13,"localvar":"my","containerName":"transpos","name":"$self","definition":"my"},{"line":290,"kind":13,"containerName":"transpos","name":"$value"},{"line":291,"kind":13,"containerName":"transpos","name":"$value"},{"name":"$value","containerName":"transpos","kind":13,"line":292},{"containerName":"transpos","name":"$self","line":293,"kind":13},{"containerName":"transpos","name":"throw","kind":12,"line":293},{"containerName":"transpos","name":"$self","kind":13,"line":295},{"containerName":"transpos","name":"$value","line":295,"kind":13},{"line":298,"kind":13,"containerName":"transpos","name":"$self"}],"line":289,"kind":12,"signature":{"label":"transpos($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Mutation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LiveSeq::Mutation\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutation - Mutation event descriptor class\n\n=head1 SYNOPSIS\n\n  # full descrition of a point mutation\n  $mutation1a = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -seqori => 'T',\n\t\t\t\t\t      -pos  => 100,\n\t\t\t\t\t      -len => 1 # optional, defaults to length(seq)\n\t\t\t\t\t     );\n\n  # minimal information for a point mutation\n  $mutation1b = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -pos  => 100\n\t\t\t\t\t      );\n  # insertion\n  $mutation2 = Bio::LiveSeq::Mutation->new ( -seq => 'ATT',\n\t\t\t\t\t     -pos  => 100,\n\t\t\t\t\t     -len => 0\n\t\t\t\t\t     );\n  # deletion\n  $mutation3 = Bio::LiveSeq::Mutation->new ( -seq => '',  # optional\n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n  # complex\n  $mutation4 = Bio::LiveSeq::Mutation->new ( -seq => 'CC', \n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n\n\n=head1 DESCRIPTION\n\nThis class describes a local mutation event using minimalistic\ndescription.  It is not necessary to know anything about the original\nsequence. You need to give the changed sequence, the position of the\nmutation in the (unidentified) reference sequence, and the length of\nthe affected subsequence in the reference sequence. If the original\nallele sequence is given, the objects applying the mutation into the\nreference sequence (e.g. L<Bio::LiveSeq::Mutator>) might check for its\nvalidity.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutation;\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($seq, $seqori, $pos, $len, $label) =\n\t    $self->_rearrange([qw(SEQ\n\t\t\t\t  SEQORI\n\t\t\t\t  POS\n\t\t\t\t  LEN\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $seq && $self->seq($seq);\n    $seqori && $self->seqori($seqori);\n    $pos && $self->pos($pos);\n    defined($len) && $self->len($len); # defined() added otherwise won't work for len==0\n    \n    return $self; # success - we hope!\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $obj->seq();\n Function: \n\n            Sets and returns the mutated sequence. No checking is done\n            to validate the symbols.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub seq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seq'} = $value;\n    }\n    return $self->{'seq'} || '';\n}\n\n\n=head2 seqori\n\n Title   : seqori\n Usage   : $obj->seqori();\n Function: \n\n            Sets and returns the original subsequence in the reference\n            sequence. No checking is done to validate the symbols.\n            Optional value.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub seqori {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seqori'} = $value;\n    }\n    return $self->{'seqori'} || '';\n}\n\n\n=head2 pos\n\n Title   : pos\n Usage   : $obj->pos();\n Function: \n\n            Sets and returns the position of the first element in the\n            sequence.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub pos {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ( $value !~ /^([+-])?\\d+$/ ) {\n\t    $self->throw(\"[$value] for pos has to be an integer\\n\");\n\t} else {\n\t    $self->{'pos'} = $value;\n\t}\n    }\n    return $self->{'pos'};\n}\n\n=head2 len\n\n Title   : len\n Usage   : $obj->len();\n Function: \n\n            Sets and returns the len of the affected original allele\n            sequence.  If value is not set, defaults to the lenght of\n            the mutated sequence (seq).\n\n Example : \n Returns : string\n Args    : string\n\n\nsub len {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'len'} = $value;\n  }\n   if ( ! exists $self->{'len'} ) {\n       return length $self->{'seq'};\n   }\n   return $self->{'len'};\n}\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns the label of the affected original allele\n            location. Label is a stable identifier whereas location\n            can be changed by mutations. Label comes from\n            l<Bio::LiveSeq::Gene>.\n\n Example : \n Returns : string\n Args    : string\n\n\nsub label {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'label'} = $value;\n   }\n   if ( ! exists $self->{'label'} ) {\n       return;\n   } \n   return $self->{'label'};\n}\n\n\n=head2 transpos\n\n Title   : transpos\n Usage   : $obj->transpos();\n Function: \n\n            Sets and returns the transcript position of the mutation.\n            Set when associated with a reference sequence. Value\n            depends on reference molecule and the co-ordinate system\n            used.\n\n Example : \n Returns : string\n Args    : integer"},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"line":319,"children":[{"line":320,"kind":13,"localvar":"my","containerName":"issue","definition":"my","name":"$self"},{"containerName":"issue","name":"$value","line":320,"kind":13},{"name":"$value","containerName":"issue","kind":13,"line":321},{"containerName":"issue","name":"$value","kind":13,"line":322},{"name":"$self","containerName":"issue","kind":13,"line":323},{"name":"throw","containerName":"issue","line":323,"kind":12},{"line":325,"kind":13,"name":"$self","containerName":"issue"},{"line":325,"kind":13,"containerName":"issue","name":"$value"},{"kind":13,"line":328,"containerName":"issue","name":"$self"}],"kind":12,"detail":"($self,$value)","signature":{"label":"issue($self,$value)","documentation":"1;\n# $Id: Mutation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LiveSeq::Mutation\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutation - Mutation event descriptor class\n\n=head1 SYNOPSIS\n\n  # full descrition of a point mutation\n  $mutation1a = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -seqori => 'T',\n\t\t\t\t\t      -pos  => 100,\n\t\t\t\t\t      -len => 1 # optional, defaults to length(seq)\n\t\t\t\t\t     );\n\n  # minimal information for a point mutation\n  $mutation1b = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -pos  => 100\n\t\t\t\t\t      );\n  # insertion\n  $mutation2 = Bio::LiveSeq::Mutation->new ( -seq => 'ATT',\n\t\t\t\t\t     -pos  => 100,\n\t\t\t\t\t     -len => 0\n\t\t\t\t\t     );\n  # deletion\n  $mutation3 = Bio::LiveSeq::Mutation->new ( -seq => '',  # optional\n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n  # complex\n  $mutation4 = Bio::LiveSeq::Mutation->new ( -seq => 'CC', \n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n\n\n=head1 DESCRIPTION\n\nThis class describes a local mutation event using minimalistic\ndescription.  It is not necessary to know anything about the original\nsequence. You need to give the changed sequence, the position of the\nmutation in the (unidentified) reference sequence, and the length of\nthe affected subsequence in the reference sequence. If the original\nallele sequence is given, the objects applying the mutation into the\nreference sequence (e.g. L<Bio::LiveSeq::Mutator>) might check for its\nvalidity.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutation;\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($seq, $seqori, $pos, $len, $label) =\n\t    $self->_rearrange([qw(SEQ\n\t\t\t\t  SEQORI\n\t\t\t\t  POS\n\t\t\t\t  LEN\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $seq && $self->seq($seq);\n    $seqori && $self->seqori($seqori);\n    $pos && $self->pos($pos);\n    defined($len) && $self->len($len); # defined() added otherwise won't work for len==0\n    \n    return $self; # success - we hope!\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $obj->seq();\n Function: \n\n            Sets and returns the mutated sequence. No checking is done\n            to validate the symbols.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub seq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seq'} = $value;\n    }\n    return $self->{'seq'} || '';\n}\n\n\n=head2 seqori\n\n Title   : seqori\n Usage   : $obj->seqori();\n Function: \n\n            Sets and returns the original subsequence in the reference\n            sequence. No checking is done to validate the symbols.\n            Optional value.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub seqori {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seqori'} = $value;\n    }\n    return $self->{'seqori'} || '';\n}\n\n\n=head2 pos\n\n Title   : pos\n Usage   : $obj->pos();\n Function: \n\n            Sets and returns the position of the first element in the\n            sequence.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub pos {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ( $value !~ /^([+-])?\\d+$/ ) {\n\t    $self->throw(\"[$value] for pos has to be an integer\\n\");\n\t} else {\n\t    $self->{'pos'} = $value;\n\t}\n    }\n    return $self->{'pos'};\n}\n\n=head2 len\n\n Title   : len\n Usage   : $obj->len();\n Function: \n\n            Sets and returns the len of the affected original allele\n            sequence.  If value is not set, defaults to the lenght of\n            the mutated sequence (seq).\n\n Example : \n Returns : string\n Args    : string\n\n\nsub len {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'len'} = $value;\n  }\n   if ( ! exists $self->{'len'} ) {\n       return length $self->{'seq'};\n   }\n   return $self->{'len'};\n}\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns the label of the affected original allele\n            location. Label is a stable identifier whereas location\n            can be changed by mutations. Label comes from\n            l<Bio::LiveSeq::Gene>.\n\n Example : \n Returns : string\n Args    : string\n\n\nsub label {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'label'} = $value;\n   }\n   if ( ! exists $self->{'label'} ) {\n       return;\n   } \n   return $self->{'label'};\n}\n\n\n=head2 transpos\n\n Title   : transpos\n Usage   : $obj->transpos();\n Function: \n\n            Sets and returns the transcript position of the mutation.\n            Set when associated with a reference sequence. Value\n            depends on reference molecule and the co-ordinate system\n            used.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub transpos {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ( $value !~ /^([+-])?\\d+$/ ) {\n\t    $self->throw(\"[$value] for transpos has to be an integer\\n\");\n\t} else {\n\t    $self->{'transpos'} = $value;\n\t}\n    }\n    return $self->{'transpos'};\n}\n\n\n=head2 issue\n\n Title   : issue\n Usage   : $obj->issue();\n Function: \n\n            Sets and returns the position of the mutation in an array\n            of mutations to be issued. Set after the validity of the\n            mutation has been confirmed.\n\n Example : \n Returns : string\n Args    : integer","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":319},"end":{"line":329,"character":9999}},"name":"issue"},{"name":"prelabel","range":{"end":{"character":9999,"line":358},"start":{"character":0,"line":349}},"kind":12,"line":349,"children":[{"name":"$self","definition":"my","containerName":"prelabel","localvar":"my","kind":13,"line":350},{"kind":13,"line":350,"containerName":"prelabel","name":"$value"},{"name":"$value","containerName":"prelabel","kind":13,"line":351},{"name":"$self","containerName":"prelabel","line":352,"kind":13},{"containerName":"prelabel","name":"$value","kind":13,"line":352},{"kind":13,"line":354,"containerName":"prelabel","name":"$self"},{"line":357,"kind":13,"name":"$self","containerName":"prelabel"}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: Mutation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LiveSeq::Mutation\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutation - Mutation event descriptor class\n\n=head1 SYNOPSIS\n\n  # full descrition of a point mutation\n  $mutation1a = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -seqori => 'T',\n\t\t\t\t\t      -pos  => 100,\n\t\t\t\t\t      -len => 1 # optional, defaults to length(seq)\n\t\t\t\t\t     );\n\n  # minimal information for a point mutation\n  $mutation1b = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -pos  => 100\n\t\t\t\t\t      );\n  # insertion\n  $mutation2 = Bio::LiveSeq::Mutation->new ( -seq => 'ATT',\n\t\t\t\t\t     -pos  => 100,\n\t\t\t\t\t     -len => 0\n\t\t\t\t\t     );\n  # deletion\n  $mutation3 = Bio::LiveSeq::Mutation->new ( -seq => '',  # optional\n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n  # complex\n  $mutation4 = Bio::LiveSeq::Mutation->new ( -seq => 'CC', \n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n\n\n=head1 DESCRIPTION\n\nThis class describes a local mutation event using minimalistic\ndescription.  It is not necessary to know anything about the original\nsequence. You need to give the changed sequence, the position of the\nmutation in the (unidentified) reference sequence, and the length of\nthe affected subsequence in the reference sequence. If the original\nallele sequence is given, the objects applying the mutation into the\nreference sequence (e.g. L<Bio::LiveSeq::Mutator>) might check for its\nvalidity.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutation;\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($seq, $seqori, $pos, $len, $label) =\n\t    $self->_rearrange([qw(SEQ\n\t\t\t\t  SEQORI\n\t\t\t\t  POS\n\t\t\t\t  LEN\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $seq && $self->seq($seq);\n    $seqori && $self->seqori($seqori);\n    $pos && $self->pos($pos);\n    defined($len) && $self->len($len); # defined() added otherwise won't work for len==0\n    \n    return $self; # success - we hope!\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $obj->seq();\n Function: \n\n            Sets and returns the mutated sequence. No checking is done\n            to validate the symbols.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub seq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seq'} = $value;\n    }\n    return $self->{'seq'} || '';\n}\n\n\n=head2 seqori\n\n Title   : seqori\n Usage   : $obj->seqori();\n Function: \n\n            Sets and returns the original subsequence in the reference\n            sequence. No checking is done to validate the symbols.\n            Optional value.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub seqori {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seqori'} = $value;\n    }\n    return $self->{'seqori'} || '';\n}\n\n\n=head2 pos\n\n Title   : pos\n Usage   : $obj->pos();\n Function: \n\n            Sets and returns the position of the first element in the\n            sequence.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub pos {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ( $value !~ /^([+-])?\\d+$/ ) {\n\t    $self->throw(\"[$value] for pos has to be an integer\\n\");\n\t} else {\n\t    $self->{'pos'} = $value;\n\t}\n    }\n    return $self->{'pos'};\n}\n\n=head2 len\n\n Title   : len\n Usage   : $obj->len();\n Function: \n\n            Sets and returns the len of the affected original allele\n            sequence.  If value is not set, defaults to the lenght of\n            the mutated sequence (seq).\n\n Example : \n Returns : string\n Args    : string\n\n\nsub len {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'len'} = $value;\n  }\n   if ( ! exists $self->{'len'} ) {\n       return length $self->{'seq'};\n   }\n   return $self->{'len'};\n}\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns the label of the affected original allele\n            location. Label is a stable identifier whereas location\n            can be changed by mutations. Label comes from\n            l<Bio::LiveSeq::Gene>.\n\n Example : \n Returns : string\n Args    : string\n\n\nsub label {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'label'} = $value;\n   }\n   if ( ! exists $self->{'label'} ) {\n       return;\n   } \n   return $self->{'label'};\n}\n\n\n=head2 transpos\n\n Title   : transpos\n Usage   : $obj->transpos();\n Function: \n\n            Sets and returns the transcript position of the mutation.\n            Set when associated with a reference sequence. Value\n            depends on reference molecule and the co-ordinate system\n            used.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub transpos {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ( $value !~ /^([+-])?\\d+$/ ) {\n\t    $self->throw(\"[$value] for transpos has to be an integer\\n\");\n\t} else {\n\t    $self->{'transpos'} = $value;\n\t}\n    }\n    return $self->{'transpos'};\n}\n\n\n=head2 issue\n\n Title   : issue\n Usage   : $obj->issue();\n Function: \n\n            Sets and returns the position of the mutation in an array\n            of mutations to be issued. Set after the validity of the\n            mutation has been confirmed.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub issue {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ( $value !~ /^([+-])?\\d+$/ ) {\n\t    $self->throw(\"[$value] for issue has to be an integer\\n\");\n\t} else {\n\t    $self->{'issue'} = $value;\n\t}\n    }\n    return $self->{'issue'};\n}\n\n\n=head2 prelabel\n\n Title   : prelabel\n Usage   : $obj->prelabel();\n Function: \n\n            Sets and returns the prelabel of the affected original allele\n            location. Prelabel is a stable identifier whereas location\n            can be changed by mutations. Prelabel comes from\n            l<Bio::LiveSeq::Gene>.\n\n Example : \n Returns : string\n Args    : string","parameters":[{"label":"$self"},{"label":"$value"}],"label":"prelabel($self,$value)"}},{"range":{"end":{"character":9999,"line":387},"start":{"line":378,"character":0}},"name":"postlabel","signature":{"documentation":"1;\n# $Id: Mutation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LiveSeq::Mutation\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutation - Mutation event descriptor class\n\n=head1 SYNOPSIS\n\n  # full descrition of a point mutation\n  $mutation1a = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -seqori => 'T',\n\t\t\t\t\t      -pos  => 100,\n\t\t\t\t\t      -len => 1 # optional, defaults to length(seq)\n\t\t\t\t\t     );\n\n  # minimal information for a point mutation\n  $mutation1b = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -pos  => 100\n\t\t\t\t\t      );\n  # insertion\n  $mutation2 = Bio::LiveSeq::Mutation->new ( -seq => 'ATT',\n\t\t\t\t\t     -pos  => 100,\n\t\t\t\t\t     -len => 0\n\t\t\t\t\t     );\n  # deletion\n  $mutation3 = Bio::LiveSeq::Mutation->new ( -seq => '',  # optional\n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n  # complex\n  $mutation4 = Bio::LiveSeq::Mutation->new ( -seq => 'CC', \n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n\n\n=head1 DESCRIPTION\n\nThis class describes a local mutation event using minimalistic\ndescription.  It is not necessary to know anything about the original\nsequence. You need to give the changed sequence, the position of the\nmutation in the (unidentified) reference sequence, and the length of\nthe affected subsequence in the reference sequence. If the original\nallele sequence is given, the objects applying the mutation into the\nreference sequence (e.g. L<Bio::LiveSeq::Mutator>) might check for its\nvalidity.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutation;\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($seq, $seqori, $pos, $len, $label) =\n\t    $self->_rearrange([qw(SEQ\n\t\t\t\t  SEQORI\n\t\t\t\t  POS\n\t\t\t\t  LEN\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $seq && $self->seq($seq);\n    $seqori && $self->seqori($seqori);\n    $pos && $self->pos($pos);\n    defined($len) && $self->len($len); # defined() added otherwise won't work for len==0\n    \n    return $self; # success - we hope!\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $obj->seq();\n Function: \n\n            Sets and returns the mutated sequence. No checking is done\n            to validate the symbols.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub seq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seq'} = $value;\n    }\n    return $self->{'seq'} || '';\n}\n\n\n=head2 seqori\n\n Title   : seqori\n Usage   : $obj->seqori();\n Function: \n\n            Sets and returns the original subsequence in the reference\n            sequence. No checking is done to validate the symbols.\n            Optional value.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub seqori {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seqori'} = $value;\n    }\n    return $self->{'seqori'} || '';\n}\n\n\n=head2 pos\n\n Title   : pos\n Usage   : $obj->pos();\n Function: \n\n            Sets and returns the position of the first element in the\n            sequence.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub pos {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ( $value !~ /^([+-])?\\d+$/ ) {\n\t    $self->throw(\"[$value] for pos has to be an integer\\n\");\n\t} else {\n\t    $self->{'pos'} = $value;\n\t}\n    }\n    return $self->{'pos'};\n}\n\n=head2 len\n\n Title   : len\n Usage   : $obj->len();\n Function: \n\n            Sets and returns the len of the affected original allele\n            sequence.  If value is not set, defaults to the lenght of\n            the mutated sequence (seq).\n\n Example : \n Returns : string\n Args    : string\n\n\nsub len {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'len'} = $value;\n  }\n   if ( ! exists $self->{'len'} ) {\n       return length $self->{'seq'};\n   }\n   return $self->{'len'};\n}\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns the label of the affected original allele\n            location. Label is a stable identifier whereas location\n            can be changed by mutations. Label comes from\n            l<Bio::LiveSeq::Gene>.\n\n Example : \n Returns : string\n Args    : string\n\n\nsub label {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'label'} = $value;\n   }\n   if ( ! exists $self->{'label'} ) {\n       return;\n   } \n   return $self->{'label'};\n}\n\n\n=head2 transpos\n\n Title   : transpos\n Usage   : $obj->transpos();\n Function: \n\n            Sets and returns the transcript position of the mutation.\n            Set when associated with a reference sequence. Value\n            depends on reference molecule and the co-ordinate system\n            used.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub transpos {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ( $value !~ /^([+-])?\\d+$/ ) {\n\t    $self->throw(\"[$value] for transpos has to be an integer\\n\");\n\t} else {\n\t    $self->{'transpos'} = $value;\n\t}\n    }\n    return $self->{'transpos'};\n}\n\n\n=head2 issue\n\n Title   : issue\n Usage   : $obj->issue();\n Function: \n\n            Sets and returns the position of the mutation in an array\n            of mutations to be issued. Set after the validity of the\n            mutation has been confirmed.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub issue {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ( $value !~ /^([+-])?\\d+$/ ) {\n\t    $self->throw(\"[$value] for issue has to be an integer\\n\");\n\t} else {\n\t    $self->{'issue'} = $value;\n\t}\n    }\n    return $self->{'issue'};\n}\n\n\n=head2 prelabel\n\n Title   : prelabel\n Usage   : $obj->prelabel();\n Function: \n\n            Sets and returns the prelabel of the affected original allele\n            location. Prelabel is a stable identifier whereas location\n            can be changed by mutations. Prelabel comes from\n            l<Bio::LiveSeq::Gene>.\n\n Example : \n Returns : string\n Args    : string\n\n\nsub prelabel {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'prelabel'} = $value;\n   }\n   if ( ! exists $self->{'prelabel'} ) {\n       return;\n   } \n   return $self->{'prelabel'};\n}\n\n\n=head2 postlabel\n\n Title   : postlabel\n Usage   : $obj->postlabel();\n Function: \n\n            Sets and returns the postlabel of the affected original allele\n            location. Postlabel is a stable identifier whereas location\n            can be changed by mutations. Postlabel comes from\n            l<Bio::LiveSeq::Gene>.\n\n Example : \n Returns : string\n Args    : string","parameters":[{"label":"$self"},{"label":"$value"}],"label":"postlabel($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":379,"name":"$self","definition":"my","containerName":"postlabel","localvar":"my"},{"kind":13,"line":379,"containerName":"postlabel","name":"$value"},{"containerName":"postlabel","name":"$value","line":380,"kind":13},{"containerName":"postlabel","name":"$self","line":381,"kind":13},{"kind":13,"line":381,"containerName":"postlabel","name":"$value"},{"kind":13,"line":383,"containerName":"postlabel","name":"$self"},{"name":"$self","containerName":"postlabel","line":386,"kind":13}],"line":378,"kind":12},{"detail":"($self,$value)","signature":{"label":"lastlabel($self,$value)","documentation":"1;\n# $Id: Mutation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LiveSeq::Mutation\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutation - Mutation event descriptor class\n\n=head1 SYNOPSIS\n\n  # full descrition of a point mutation\n  $mutation1a = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -seqori => 'T',\n\t\t\t\t\t      -pos  => 100,\n\t\t\t\t\t      -len => 1 # optional, defaults to length(seq)\n\t\t\t\t\t     );\n\n  # minimal information for a point mutation\n  $mutation1b = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -pos  => 100\n\t\t\t\t\t      );\n  # insertion\n  $mutation2 = Bio::LiveSeq::Mutation->new ( -seq => 'ATT',\n\t\t\t\t\t     -pos  => 100,\n\t\t\t\t\t     -len => 0\n\t\t\t\t\t     );\n  # deletion\n  $mutation3 = Bio::LiveSeq::Mutation->new ( -seq => '',  # optional\n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n  # complex\n  $mutation4 = Bio::LiveSeq::Mutation->new ( -seq => 'CC', \n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n\n\n=head1 DESCRIPTION\n\nThis class describes a local mutation event using minimalistic\ndescription.  It is not necessary to know anything about the original\nsequence. You need to give the changed sequence, the position of the\nmutation in the (unidentified) reference sequence, and the length of\nthe affected subsequence in the reference sequence. If the original\nallele sequence is given, the objects applying the mutation into the\nreference sequence (e.g. L<Bio::LiveSeq::Mutator>) might check for its\nvalidity.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutation;\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($seq, $seqori, $pos, $len, $label) =\n\t    $self->_rearrange([qw(SEQ\n\t\t\t\t  SEQORI\n\t\t\t\t  POS\n\t\t\t\t  LEN\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $seq && $self->seq($seq);\n    $seqori && $self->seqori($seqori);\n    $pos && $self->pos($pos);\n    defined($len) && $self->len($len); # defined() added otherwise won't work for len==0\n    \n    return $self; # success - we hope!\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $obj->seq();\n Function: \n\n            Sets and returns the mutated sequence. No checking is done\n            to validate the symbols.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub seq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seq'} = $value;\n    }\n    return $self->{'seq'} || '';\n}\n\n\n=head2 seqori\n\n Title   : seqori\n Usage   : $obj->seqori();\n Function: \n\n            Sets and returns the original subsequence in the reference\n            sequence. No checking is done to validate the symbols.\n            Optional value.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub seqori {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seqori'} = $value;\n    }\n    return $self->{'seqori'} || '';\n}\n\n\n=head2 pos\n\n Title   : pos\n Usage   : $obj->pos();\n Function: \n\n            Sets and returns the position of the first element in the\n            sequence.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub pos {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ( $value !~ /^([+-])?\\d+$/ ) {\n\t    $self->throw(\"[$value] for pos has to be an integer\\n\");\n\t} else {\n\t    $self->{'pos'} = $value;\n\t}\n    }\n    return $self->{'pos'};\n}\n\n=head2 len\n\n Title   : len\n Usage   : $obj->len();\n Function: \n\n            Sets and returns the len of the affected original allele\n            sequence.  If value is not set, defaults to the lenght of\n            the mutated sequence (seq).\n\n Example : \n Returns : string\n Args    : string\n\n\nsub len {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'len'} = $value;\n  }\n   if ( ! exists $self->{'len'} ) {\n       return length $self->{'seq'};\n   }\n   return $self->{'len'};\n}\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns the label of the affected original allele\n            location. Label is a stable identifier whereas location\n            can be changed by mutations. Label comes from\n            l<Bio::LiveSeq::Gene>.\n\n Example : \n Returns : string\n Args    : string\n\n\nsub label {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'label'} = $value;\n   }\n   if ( ! exists $self->{'label'} ) {\n       return;\n   } \n   return $self->{'label'};\n}\n\n\n=head2 transpos\n\n Title   : transpos\n Usage   : $obj->transpos();\n Function: \n\n            Sets and returns the transcript position of the mutation.\n            Set when associated with a reference sequence. Value\n            depends on reference molecule and the co-ordinate system\n            used.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub transpos {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ( $value !~ /^([+-])?\\d+$/ ) {\n\t    $self->throw(\"[$value] for transpos has to be an integer\\n\");\n\t} else {\n\t    $self->{'transpos'} = $value;\n\t}\n    }\n    return $self->{'transpos'};\n}\n\n\n=head2 issue\n\n Title   : issue\n Usage   : $obj->issue();\n Function: \n\n            Sets and returns the position of the mutation in an array\n            of mutations to be issued. Set after the validity of the\n            mutation has been confirmed.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub issue {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ( $value !~ /^([+-])?\\d+$/ ) {\n\t    $self->throw(\"[$value] for issue has to be an integer\\n\");\n\t} else {\n\t    $self->{'issue'} = $value;\n\t}\n    }\n    return $self->{'issue'};\n}\n\n\n=head2 prelabel\n\n Title   : prelabel\n Usage   : $obj->prelabel();\n Function: \n\n            Sets and returns the prelabel of the affected original allele\n            location. Prelabel is a stable identifier whereas location\n            can be changed by mutations. Prelabel comes from\n            l<Bio::LiveSeq::Gene>.\n\n Example : \n Returns : string\n Args    : string\n\n\nsub prelabel {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'prelabel'} = $value;\n   }\n   if ( ! exists $self->{'prelabel'} ) {\n       return;\n   } \n   return $self->{'prelabel'};\n}\n\n\n=head2 postlabel\n\n Title   : postlabel\n Usage   : $obj->postlabel();\n Function: \n\n            Sets and returns the postlabel of the affected original allele\n            location. Postlabel is a stable identifier whereas location\n            can be changed by mutations. Postlabel comes from\n            l<Bio::LiveSeq::Gene>.\n\n Example : \n Returns : string\n Args    : string\n\n\nsub postlabel {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'postlabel'} = $value;\n   }\n   if ( ! exists $self->{'postlabel'} ) {\n       return;\n   } \n   return $self->{'postlabel'};\n}\n\n\n=head2 lastlabel\n\n Title   : lastlabel\n Usage   : $obj->lastlabel();\n Function: \n\n            Sets and returns the lastlabel of the affected original allele\n            location. Lastlabel is a stable identifier whereas location\n            can be changed by mutations. Lastlabel comes from\n            l<Bio::LiveSeq::Gene>.\n\n Example : \n Returns : string\n Args    : string","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub","line":407,"children":[{"definition":"my","name":"$self","containerName":"lastlabel","localvar":"my","kind":13,"line":408},{"name":"$value","containerName":"lastlabel","kind":13,"line":408},{"line":409,"kind":13,"name":"$value","containerName":"lastlabel"},{"line":410,"kind":13,"containerName":"lastlabel","name":"$self"},{"kind":13,"line":410,"name":"$value","containerName":"lastlabel"},{"line":412,"kind":13,"containerName":"lastlabel","name":"$self"},{"kind":13,"line":415,"name":"$self","containerName":"lastlabel"}],"kind":12,"range":{"start":{"character":0,"line":407},"end":{"line":416,"character":9999}},"name":"lastlabel"}],"version":5}