{"vars":[{"line":85,"kind":2,"name":"Carp","containerName":""},{"line":120,"children":[],"kind":12,"range":{"end":{"character":9999,"line":122},"start":{"character":0,"line":120}},"containerName":"main::","definition":"sub","name":"up_chain2string"},{"line":121,"kind":12,"name":"_updown_chain2string"},{"line":121,"kind":2,"containerName":"","name":"integer"},{"kind":12,"line":123,"children":[],"containerName":"main::","definition":"sub","name":"down_chain2string","range":{"end":{"line":125,"character":9999},"start":{"character":0,"line":123}}},{"name":"_updown_chain2string","line":124,"kind":12},{"name":"_updown_chain2string","range":{"start":{"line":127,"character":0},"end":{"line":171,"character":9999}},"kind":12,"line":127,"children":[{"definition":"my","name":"$direction","containerName":"_updown_chain2string","localvar":"my","kind":13,"line":128},{"containerName":"_updown_chain2string","name":"$chain","line":128,"kind":13},{"line":128,"kind":13,"containerName":"_updown_chain2string","name":"$first"},{"kind":13,"line":128,"name":"$len","containerName":"_updown_chain2string"},{"line":128,"kind":13,"containerName":"_updown_chain2string","name":"$last"},{"name":"$chain","containerName":"_updown_chain2string","line":129,"kind":13},{"line":130,"kind":13,"localvar":"my","containerName":"_updown_chain2string","definition":"my","name":"$begin"},{"containerName":"_updown_chain2string","name":"$chain","line":130,"kind":13},{"containerName":"_updown_chain2string","name":"$end","definition":"my","localvar":"my","kind":13,"line":131},{"kind":13,"line":131,"name":"$chain","containerName":"_updown_chain2string"},{"localvar":"my","definition":"my","name":"$flow","containerName":"_updown_chain2string","line":132,"kind":13},{"kind":13,"line":134,"containerName":"_updown_chain2string","name":"$direction"},{"line":135,"kind":13,"containerName":"_updown_chain2string","name":"$flow"},{"line":136,"kind":13,"containerName":"_updown_chain2string","name":"$first"},{"line":136,"kind":13,"name":"$first","containerName":"_updown_chain2string"},{"kind":13,"line":136,"name":"$end","containerName":"_updown_chain2string"},{"kind":13,"line":138,"containerName":"_updown_chain2string","name":"$flow"},{"containerName":"_updown_chain2string","name":"$first","line":139,"kind":13},{"containerName":"_updown_chain2string","name":"$first","line":139,"kind":13},{"line":139,"kind":13,"containerName":"_updown_chain2string","name":"$begin"},{"name":"$chain","containerName":"_updown_chain2string","kind":13,"line":142},{"containerName":"_updown_chain2string","name":"$first","line":142,"kind":13},{"kind":13,"line":144,"containerName":"_updown_chain2string","name":"$last"},{"line":145,"kind":13,"name":"$chain","containerName":"_updown_chain2string"},{"containerName":"_updown_chain2string","name":"$last","line":145,"kind":13},{"line":147,"kind":13,"containerName":"_updown_chain2string","name":"$len"},{"kind":13,"line":149,"name":"$len","containerName":"_updown_chain2string"},{"containerName":"_updown_chain2string","name":"$direction","kind":13,"line":152},{"kind":13,"line":153,"containerName":"_updown_chain2string","name":"$last"},{"kind":13,"line":153,"containerName":"_updown_chain2string","name":"$begin"},{"line":155,"kind":13,"containerName":"_updown_chain2string","name":"$last"},{"kind":13,"line":155,"containerName":"_updown_chain2string","name":"$end"},{"localvar":"my","definition":"my","name":"$string","containerName":"_updown_chain2string","line":159,"kind":13},{"containerName":"_updown_chain2string","name":"@array","kind":13,"line":159},{"line":160,"kind":13,"localvar":"my","containerName":"_updown_chain2string","name":"$label","definition":"my"},{"name":"$first","containerName":"_updown_chain2string","kind":13,"line":160},{"kind":13,"line":160,"containerName":"_updown_chain2string","definition":"my","name":"$i","localvar":"my"},{"line":161,"kind":13,"localvar":"my","containerName":"_updown_chain2string","name":"$afterlast","definition":"my"},{"line":161,"kind":13,"name":"$chain","containerName":"_updown_chain2string"},{"kind":13,"line":161,"containerName":"_updown_chain2string","name":"$last"},{"line":161,"kind":13,"name":"$flow","containerName":"_updown_chain2string"},{"containerName":"_updown_chain2string","name":"$afterlast","line":162,"kind":13},{"name":"$afterlast","containerName":"_updown_chain2string","line":162,"kind":13},{"name":"$label","containerName":"_updown_chain2string","line":166,"kind":13},{"containerName":"_updown_chain2string","name":"$label","kind":13,"line":166},{"kind":13,"line":166,"name":"$afterlast","containerName":"_updown_chain2string"},{"name":"$i","containerName":"_updown_chain2string","line":166,"kind":13},{"containerName":"_updown_chain2string","name":"$len","kind":13,"line":166},{"line":166,"kind":13,"containerName":"_updown_chain2string","name":"$i"},{"name":"@array","containerName":"_updown_chain2string","line":167,"kind":13},{"name":"$chain","containerName":"_updown_chain2string","line":167,"kind":13},{"kind":13,"line":167,"containerName":"_updown_chain2string","name":"$label"},{"kind":13,"line":168,"containerName":"_updown_chain2string","name":"$string"},{"kind":13,"line":168,"name":"$array","containerName":"_updown_chain2string"},{"kind":13,"line":169,"name":"$label","containerName":"_updown_chain2string"},{"containerName":"_updown_chain2string","name":"$array","kind":13,"line":169},{"name":"$flow","containerName":"_updown_chain2string","line":169,"kind":13},{"kind":13,"line":170,"name":"$i","containerName":"_updown_chain2string"}],"containerName":"main::","definition":"sub","detail":"($direction,$chain,$first,$len,$last)","signature":{"documentation":"","parameters":[{"label":"$direction"},{"label":"$chain"},{"label":"$first"},{"label":"$len"},{"label":"$last"}],"label":"_updown_chain2string($direction,$chain,$first,$len,$last)"}},{"name":"cluck","kind":12,"line":129},{"name":"cluck","line":143,"kind":12},{"name":"cluck","kind":12,"line":146},{"line":172,"kind":13,"name":"$string","containerName":null},{"children":[{"name":"$chain","definition":"my","containerName":"down_labels","localvar":"my","kind":13,"line":192},{"containerName":"down_labels","name":"$first","line":192,"kind":13},{"name":"$last","containerName":"down_labels","line":192,"kind":13},{"containerName":"down_labels","name":"$chain","kind":13,"line":193},{"name":"$first","containerName":"down_labels","kind":13,"line":193},{"line":193,"kind":13,"name":"$last","containerName":"down_labels"}],"line":191,"kind":12,"signature":{"documentation":"1; # returns 1\n#!/usr/bin/perl\n# $Id: Chain.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Chain\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n\n=head1 NAME\n\nBio::LiveSeq::Chain - DoubleChain DataStructure for Perl\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nThis is a general purpose module (that's why it's not in object-oriented\nform) that introduces a novel datastructure in PERL. It implements\nthe \"double linked chain\". The elements of the chain can contain basically\neverything. From chars to strings, from object references to arrays or hashes.\nIt is used in the LiveSequence project to create a dynamical DNA sequence,\neasier to manipulate and change. It's use is mainly for sequence variation\nanalysis but it could be used - for example - in e-cell projects.\nThe Chain module in itself doesn't have any biological bias, so can be\nused for any programming purpose.\n\nEach element of the chain (with the exclusion of the first and the last of the\nchain) is connected to other two elements (the PREVious and the NEXT one).\nThere is no absolute position (like in an array), hence if positions are\nimportant, they need to be computed (methods are provided).\nOtherwise it's easy to keep track of the elements with their \"LABELs\".\nThere is one LABEL (think of it as a pointer) to each ELEMENT. The labels\nwon't change after insertions or deletions of the chain. So it's\nalways possible to retrieve an element even if the chain has been\nmodified by successive insertions or deletions.\nFrom this the high potential profit for bioinformatics: dealing with\nsequences in a way that doesn't have to rely on positions, without\nthe need of constantly updating them if the sequence changes, even\ndramatically.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n# DoubleChain Data Structure for PERL\n# by Joseph A.L. Insana - Deathson - Filius Mortis - Fal Mortais\n# insana@ebi.ac.uk, jinsana@gmx.net\n\npackage Bio::LiveSeq::Chain;\n# TODO_list:\n# **** cleanup code\n# **** performance concerns\n# *??* create hash2dchain ???? (with hashkeys used for label)\n# **????** how about using array of arrays instead than hash of arrays??\n#\n# further strict complaints:\n# in verbose $string assignment around line 721 ???\n\n# TERMINOLOGY update, naming convention:\n# \"chain\" the datastructure\n# \"element\" the individual units that compose a chain\n# \"label\" the unique name of a single element\n# \"position\" the position of an element into the chain according to a\n#            particular coordinate system (e.g. counting from the start)\n# \"value\" what is stored in a single element\n\nuse Carp qw(croak cluck carp);\nuse Bio::Root::Version;\nuse strict; \nuse integer; # WARNING: this is to increase performance\n             # a little bit of attention has to be given if float need to\n             # be stored as elements of the array\n             # the use of this \"integer\" affects all operations but not\n             # assignments. So float CAN be assigned as elements of the chain\n             # BUT, if you assign $z=-1.8;, $z will be equal to -1 because\n             # \"-\" counts as a unary operation!\n\n=head2 _updown_chain2string\n\n  Title   : chain2string\n  Usage   : $string = Bio::LiveSeq::Chain::chain2string(\"down\",$chain,6,9)\n  Function: reads the contents of the chain, outputting a string\n  Returns : a string\n  Examples:\n          : down_chain2string($chain) -> all the chain from begin to end\n          : down_chain2string($chain,6) -> from 6 to the end\n          : down_chain2string($chain,6,4) -> from 6, going on 4 elements\n          : down_chain2string($chain,6,\"\",10) -> from 6 to 10\n          : up_chain2string($chain,10,\"\",6) -> from 10 to 6 upstream\n  Defaults: start=first element; if len undef, goes to last\n            if last undef, goes to end\n            if last defined, it overrides len (undefining it)\n  Error code: -1\n  Args    : \"up\"||\"down\" as first argument to specify the reading direction \n            reference (to the chain)\n            [first] [len] [last] optional integer arguments to specify how\n            much and from (and to) where to read\n\n\n# methods rewritten 2.61\nsub up_chain2string {\n  _updown_chain2string(\"up\",@_);\n}\nsub down_chain2string {\n  _updown_chain2string(\"down\",@_);\n}\n\nsub _updown_chain2string {\n  my ($direction,$chain,$first,$len,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n\n  if ($direction eq \"up\") {\n    $flow=2; # used to determine the direction of chain navigation\n    unless ($first) { $first=$end; } # if undef or 0, use $end\n  } else { # defaults to \"down\"\n    $flow=1; # used to determine the direction of chain navigation\n    unless ($first) { $first=$begin; } # if undef or 0, use $begin\n  }\n\n  unless($chain->{$first}) {\n    cluck \"label for first not defined\"; return (-1); }\n  if ($last) { # if last is defined, it gets priority and len is not used\n    unless($chain->{$last}) {\n      cluck \"label for last not defined\"; return (-1); }\n    if ($len) {\n      warn \"Warning chain2string: argument LAST:$last overriding LEN:$len!\";\n      undef $len;\n    }\n  } else {\n    if ($direction eq \"up\") {\n      $last=$begin; # if last not defined, go 'till begin (or upto len elements)\n    } else {\n      $last=$end; # if last not defined, go 'till end (or upto len elements)\n    }\n  }\n\n  my ($string,@array);\n  my $label=$first; my $i=1;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  # proceed for len elements or until last, whichever comes first\n  # if $len undef goes till end\n  while (($label) && ($label != $afterlast) && ($i <= ($len || $i + 1))) {\n    @array=@{$chain->{$label}};\n    $string .= $array[0];\n    $label = $array[$flow];\n    $i++;\n  }\n  return ($string); # if chain is interrupted $string won't be complete\n}\n\n=head2 _updown_labels\n\n Title   : labels\n Usage   : @labels = Bio::LiveSeq::Chain::_updown_labels(\"down\",$chain,4,16)\n Function: returns all the labels in a chain or those between two\n           specified ones (termed \"first\" and \"last\")\n Returns : a reference to an array containing the labels\n Args    : \"up\"||\"down\" as first argument to specify the reading direction \n           reference (to the chain)\n           [first] [last] (integer for the starting and eneding labels)\n\n arguments: CHAIN_REF [FIRSTLABEL] [LASTLABEL]\n returns: reference to array containing the labels","parameters":[{"label":"$chain"},{"label":"$first"},{"label":"$last"}],"label":"down_labels($chain,$first,$last)"},"detail":"($chain,$first,$last)","definition":"sub","containerName":"main::","range":{"start":{"line":191,"character":0},"end":{"line":194,"character":9999}},"name":"down_labels"},{"kind":12,"line":193,"name":"_updown_labels"},{"children":[{"line":196,"kind":13,"localvar":"my","containerName":"up_labels","name":"$chain","definition":"my"},{"kind":13,"line":196,"containerName":"up_labels","name":"$first"},{"containerName":"up_labels","name":"$last","kind":13,"line":196},{"name":"$chain","containerName":"up_labels","kind":13,"line":197},{"name":"$first","containerName":"up_labels","line":197,"kind":13},{"line":197,"kind":13,"name":"$last","containerName":"up_labels"}],"line":195,"kind":12,"signature":{"parameters":[{"label":"$chain"},{"label":"$first"},{"label":"$last"}],"documentation":"","label":"up_labels($chain,$first,$last)"},"detail":"($chain,$first,$last)","definition":"sub","containerName":"main::","range":{"end":{"line":198,"character":9999},"start":{"character":0,"line":195}},"name":"up_labels"},{"name":"_updown_labels","kind":12,"line":197},{"containerName":"main::","definition":"sub","detail":"($direction,$chain,$first,$last)","signature":{"documentation":" arguments: \"up\"||\"down\" CHAIN_REF [FIRSTLABEL] [LASTLABEL]\n returns: reference to array containing the labels","parameters":[{"label":"$direction"},{"label":"$chain"},{"label":"$first"},{"label":"$last"}],"label":"_updown_labels($direction,$chain,$first,$last)"},"kind":12,"line":201,"children":[{"localvar":"my","containerName":"_updown_labels","definition":"my","name":"$direction","line":202,"kind":13},{"containerName":"_updown_labels","name":"$chain","line":202,"kind":13},{"name":"$first","containerName":"_updown_labels","line":202,"kind":13},{"line":202,"kind":13,"containerName":"_updown_labels","name":"$last"},{"containerName":"_updown_labels","name":"$chain","kind":13,"line":203},{"name":"$begin","definition":"my","containerName":"_updown_labels","localvar":"my","kind":13,"line":204},{"kind":13,"line":204,"name":"$chain","containerName":"_updown_labels"},{"localvar":"my","containerName":"_updown_labels","definition":"my","name":"$end","line":205,"kind":13},{"containerName":"_updown_labels","name":"$chain","line":205,"kind":13},{"localvar":"my","name":"$flow","definition":"my","containerName":"_updown_labels","line":206,"kind":13},{"line":207,"kind":13,"name":"$direction","containerName":"_updown_labels"},{"containerName":"_updown_labels","name":"$flow","kind":13,"line":207},{"kind":13,"line":208,"containerName":"_updown_labels","name":"$first"},{"containerName":"_updown_labels","name":"$first","line":208,"kind":13},{"name":"$end","containerName":"_updown_labels","kind":13,"line":208},{"line":209,"kind":13,"name":"$last","containerName":"_updown_labels"},{"name":"$last","containerName":"_updown_labels","line":209,"kind":13},{"kind":13,"line":209,"containerName":"_updown_labels","name":"$begin"},{"containerName":"_updown_labels","name":"$flow","kind":13,"line":210},{"name":"$last","containerName":"_updown_labels","line":211,"kind":13},{"containerName":"_updown_labels","name":"$last","line":211,"kind":13},{"containerName":"_updown_labels","name":"$end","kind":13,"line":211},{"line":212,"kind":13,"containerName":"_updown_labels","name":"$first"},{"containerName":"_updown_labels","name":"$first","line":212,"kind":13},{"name":"$begin","containerName":"_updown_labels","kind":13,"line":212},{"containerName":"_updown_labels","name":"$chain","kind":13,"line":214},{"name":"$first","containerName":"_updown_labels","line":214,"kind":13},{"containerName":"_updown_labels","name":"$chain","kind":13,"line":215},{"line":215,"kind":13,"name":"$last","containerName":"_updown_labels"},{"containerName":"_updown_labels","definition":"my","name":"$label","localvar":"my","kind":13,"line":217},{"kind":13,"line":217,"name":"$first","containerName":"_updown_labels"},{"containerName":"_updown_labels","name":"@labels","definition":"my","localvar":"my","kind":13,"line":217},{"containerName":"_updown_labels","definition":"my","name":"$afterlast","localvar":"my","kind":13,"line":218},{"name":"$chain","containerName":"_updown_labels","kind":13,"line":218},{"name":"$last","containerName":"_updown_labels","line":218,"kind":13},{"line":218,"kind":13,"containerName":"_updown_labels","name":"$flow"},{"kind":13,"line":219,"containerName":"_updown_labels","name":"$afterlast"},{"containerName":"_updown_labels","name":"$afterlast","kind":13,"line":219},{"line":221,"kind":13,"name":"$label","containerName":"_updown_labels"},{"containerName":"_updown_labels","name":"$label","line":221,"kind":13},{"name":"$afterlast","containerName":"_updown_labels","kind":13,"line":221},{"kind":13,"line":222,"name":"@labels","containerName":"_updown_labels"},{"containerName":"_updown_labels","name":"$label","line":222,"kind":13},{"line":223,"kind":13,"name":"$label","containerName":"_updown_labels"},{"containerName":"_updown_labels","name":"$chain","kind":13,"line":223},{"name":"$label","containerName":"_updown_labels","line":223,"kind":13},{"name":"$flow","containerName":"_updown_labels","line":223,"kind":13},{"name":"@labels","containerName":"_updown_labels","line":225,"kind":13}],"name":"_updown_labels","range":{"end":{"line":226,"character":9999},"start":{"line":201,"character":0}}},{"name":"cluck","kind":12,"line":203},{"line":239,"children":[{"kind":13,"line":240,"name":"$chain","definition":"my","containerName":"start","localvar":"my"},{"kind":13,"line":241,"containerName":"start","name":"$chain"},{"containerName":"start","name":"$chain","line":242,"kind":13}],"kind":12,"range":{"end":{"line":243,"character":9999},"start":{"character":0,"line":239}},"containerName":"main::","definition":"sub","name":"start"},{"name":"cluck","line":241,"kind":12},{"kind":12,"line":255,"children":[{"kind":13,"line":256,"containerName":"end","name":"$chain","definition":"my","localvar":"my"},{"name":"$chain","containerName":"end","line":257,"kind":13},{"kind":13,"line":258,"name":"$chain","containerName":"end"}],"containerName":"main::","definition":"sub","name":"end","range":{"end":{"character":9999,"line":259},"start":{"line":255,"character":0}}},{"name":"cluck","line":257,"kind":12},{"range":{"start":{"line":273,"character":0},"end":{"line":277,"character":9999}},"name":"label_exists","line":273,"children":[{"localvar":"my","containerName":"label_exists","definition":"my","name":"$chain","line":274,"kind":13},{"containerName":"label_exists","name":"$label","kind":13,"line":274},{"line":275,"kind":13,"name":"$chain","containerName":"label_exists"},{"containerName":"label_exists","name":"$label","kind":13,"line":276},{"name":"$chain","containerName":"label_exists","line":276,"kind":13},{"name":"$label","containerName":"label_exists","line":276,"kind":13}],"kind":12,"detail":"($chain,$label)","signature":{"label":"label_exists($chain,$label)","documentation":"1; # returns 1\n#!/usr/bin/perl\n# $Id: Chain.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Chain\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n\n=head1 NAME\n\nBio::LiveSeq::Chain - DoubleChain DataStructure for Perl\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nThis is a general purpose module (that's why it's not in object-oriented\nform) that introduces a novel datastructure in PERL. It implements\nthe \"double linked chain\". The elements of the chain can contain basically\neverything. From chars to strings, from object references to arrays or hashes.\nIt is used in the LiveSequence project to create a dynamical DNA sequence,\neasier to manipulate and change. It's use is mainly for sequence variation\nanalysis but it could be used - for example - in e-cell projects.\nThe Chain module in itself doesn't have any biological bias, so can be\nused for any programming purpose.\n\nEach element of the chain (with the exclusion of the first and the last of the\nchain) is connected to other two elements (the PREVious and the NEXT one).\nThere is no absolute position (like in an array), hence if positions are\nimportant, they need to be computed (methods are provided).\nOtherwise it's easy to keep track of the elements with their \"LABELs\".\nThere is one LABEL (think of it as a pointer) to each ELEMENT. The labels\nwon't change after insertions or deletions of the chain. So it's\nalways possible to retrieve an element even if the chain has been\nmodified by successive insertions or deletions.\nFrom this the high potential profit for bioinformatics: dealing with\nsequences in a way that doesn't have to rely on positions, without\nthe need of constantly updating them if the sequence changes, even\ndramatically.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n# DoubleChain Data Structure for PERL\n# by Joseph A.L. Insana - Deathson - Filius Mortis - Fal Mortais\n# insana@ebi.ac.uk, jinsana@gmx.net\n\npackage Bio::LiveSeq::Chain;\n# TODO_list:\n# **** cleanup code\n# **** performance concerns\n# *??* create hash2dchain ???? (with hashkeys used for label)\n# **????** how about using array of arrays instead than hash of arrays??\n#\n# further strict complaints:\n# in verbose $string assignment around line 721 ???\n\n# TERMINOLOGY update, naming convention:\n# \"chain\" the datastructure\n# \"element\" the individual units that compose a chain\n# \"label\" the unique name of a single element\n# \"position\" the position of an element into the chain according to a\n#            particular coordinate system (e.g. counting from the start)\n# \"value\" what is stored in a single element\n\nuse Carp qw(croak cluck carp);\nuse Bio::Root::Version;\nuse strict; \nuse integer; # WARNING: this is to increase performance\n             # a little bit of attention has to be given if float need to\n             # be stored as elements of the array\n             # the use of this \"integer\" affects all operations but not\n             # assignments. So float CAN be assigned as elements of the chain\n             # BUT, if you assign $z=-1.8;, $z will be equal to -1 because\n             # \"-\" counts as a unary operation!\n\n=head2 _updown_chain2string\n\n  Title   : chain2string\n  Usage   : $string = Bio::LiveSeq::Chain::chain2string(\"down\",$chain,6,9)\n  Function: reads the contents of the chain, outputting a string\n  Returns : a string\n  Examples:\n          : down_chain2string($chain) -> all the chain from begin to end\n          : down_chain2string($chain,6) -> from 6 to the end\n          : down_chain2string($chain,6,4) -> from 6, going on 4 elements\n          : down_chain2string($chain,6,\"\",10) -> from 6 to 10\n          : up_chain2string($chain,10,\"\",6) -> from 10 to 6 upstream\n  Defaults: start=first element; if len undef, goes to last\n            if last undef, goes to end\n            if last defined, it overrides len (undefining it)\n  Error code: -1\n  Args    : \"up\"||\"down\" as first argument to specify the reading direction \n            reference (to the chain)\n            [first] [len] [last] optional integer arguments to specify how\n            much and from (and to) where to read\n\n\n# methods rewritten 2.61\nsub up_chain2string {\n  _updown_chain2string(\"up\",@_);\n}\nsub down_chain2string {\n  _updown_chain2string(\"down\",@_);\n}\n\nsub _updown_chain2string {\n  my ($direction,$chain,$first,$len,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n\n  if ($direction eq \"up\") {\n    $flow=2; # used to determine the direction of chain navigation\n    unless ($first) { $first=$end; } # if undef or 0, use $end\n  } else { # defaults to \"down\"\n    $flow=1; # used to determine the direction of chain navigation\n    unless ($first) { $first=$begin; } # if undef or 0, use $begin\n  }\n\n  unless($chain->{$first}) {\n    cluck \"label for first not defined\"; return (-1); }\n  if ($last) { # if last is defined, it gets priority and len is not used\n    unless($chain->{$last}) {\n      cluck \"label for last not defined\"; return (-1); }\n    if ($len) {\n      warn \"Warning chain2string: argument LAST:$last overriding LEN:$len!\";\n      undef $len;\n    }\n  } else {\n    if ($direction eq \"up\") {\n      $last=$begin; # if last not defined, go 'till begin (or upto len elements)\n    } else {\n      $last=$end; # if last not defined, go 'till end (or upto len elements)\n    }\n  }\n\n  my ($string,@array);\n  my $label=$first; my $i=1;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  # proceed for len elements or until last, whichever comes first\n  # if $len undef goes till end\n  while (($label) && ($label != $afterlast) && ($i <= ($len || $i + 1))) {\n    @array=@{$chain->{$label}};\n    $string .= $array[0];\n    $label = $array[$flow];\n    $i++;\n  }\n  return ($string); # if chain is interrupted $string won't be complete\n}\n\n=head2 _updown_labels\n\n Title   : labels\n Usage   : @labels = Bio::LiveSeq::Chain::_updown_labels(\"down\",$chain,4,16)\n Function: returns all the labels in a chain or those between two\n           specified ones (termed \"first\" and \"last\")\n Returns : a reference to an array containing the labels\n Args    : \"up\"||\"down\" as first argument to specify the reading direction \n           reference (to the chain)\n           [first] [last] (integer for the starting and eneding labels)\n\n\n\n# arguments: CHAIN_REF [FIRSTLABEL] [LASTLABEL]\n# returns: reference to array containing the labels\nsub down_labels {\n  my ($chain,$first,$last)=@_;\n  _updown_labels(\"down\",$chain,$first,$last);\n}\nsub up_labels {\n  my ($chain,$first,$last)=@_;\n  _updown_labels(\"up\",$chain,$first,$last);\n}\n# arguments: \"up\"||\"down\" CHAIN_REF [FIRSTLABEL] [LASTLABEL]\n# returns: reference to array containing the labels\nsub _updown_labels {\n  my ($direction,$chain,$first,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (0); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n  if ($direction eq \"up\") { $flow=2;\n    unless ($first) { $first=$end; }\n    unless ($last) { $last=$begin; }\n  } else { $flow=1;\n    unless ($last) { $last=$end; }\n    unless ($first) { $first=$begin; }\n  }\n  unless($chain->{$first}) { warn \"not existing label $first\"; return (0); }\n  unless($chain->{$last}) { warn \"not existing label $last\"; return (0); }\n\n  my $label=$first; my @labels;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  while (($label)&&($label != $afterlast)) {\n    push(@labels,$label);\n    $label=$chain->{$label}[$flow];\n  }\n  return (\\@labels); # if chain is interrupted @labels won't be complete\n}\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = Bio::LiveSeq::Chain::start()\n Returns : the label marking the start of the chain\n Errorcode: -1\n Args    : none\n\n\nsub start {\n  my $chain=$_[0];\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  return ($chain->{'begin'});\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = Bio::LiveSeq::Chain::end()\n Returns : the label marking the end of the chain\n Errorcode: -1\n Args    : none\n\n\nsub end {\n  my $chain=$_[0];\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  return ($chain->{'end'});\n}\n\n=head2 label_exists\n\n Title   : label_exists\n Usage   : $check = Bio::LiveSeq::Chain::label_exists($chain,$label)\n Function: It checks if a label is defined, i.e. if an element is there or\n           is not there anymore\n Returns : 1 if the label exists, 0 if it is not there, -1 error\n Errorcode: -1\n Args    : reference to the chain, integer","parameters":[{"label":"$chain"},{"label":"$label"}]},"containerName":"main::","definition":"sub"},{"name":"cluck","kind":12,"line":275},{"children":[{"definition":"my","name":"$chain","containerName":"down_get_pos_of_label","localvar":"my","kind":13,"line":298},{"line":298,"kind":13,"name":"$label","containerName":"down_get_pos_of_label"},{"containerName":"down_get_pos_of_label","name":"$first","line":298,"kind":13},{"name":"$chain","containerName":"down_get_pos_of_label","kind":13,"line":299},{"containerName":"down_get_pos_of_label","name":"$first","kind":13,"line":299},{"containerName":"down_get_pos_of_label","name":"$label","line":299,"kind":13}],"line":296,"kind":12,"signature":{"parameters":[{"label":"$chain"},{"label":"$label"},{"label":"$first"}],"documentation":"1; # returns 1\n#!/usr/bin/perl\n# $Id: Chain.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Chain\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n\n=head1 NAME\n\nBio::LiveSeq::Chain - DoubleChain DataStructure for Perl\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nThis is a general purpose module (that's why it's not in object-oriented\nform) that introduces a novel datastructure in PERL. It implements\nthe \"double linked chain\". The elements of the chain can contain basically\neverything. From chars to strings, from object references to arrays or hashes.\nIt is used in the LiveSequence project to create a dynamical DNA sequence,\neasier to manipulate and change. It's use is mainly for sequence variation\nanalysis but it could be used - for example - in e-cell projects.\nThe Chain module in itself doesn't have any biological bias, so can be\nused for any programming purpose.\n\nEach element of the chain (with the exclusion of the first and the last of the\nchain) is connected to other two elements (the PREVious and the NEXT one).\nThere is no absolute position (like in an array), hence if positions are\nimportant, they need to be computed (methods are provided).\nOtherwise it's easy to keep track of the elements with their \"LABELs\".\nThere is one LABEL (think of it as a pointer) to each ELEMENT. The labels\nwon't change after insertions or deletions of the chain. So it's\nalways possible to retrieve an element even if the chain has been\nmodified by successive insertions or deletions.\nFrom this the high potential profit for bioinformatics: dealing with\nsequences in a way that doesn't have to rely on positions, without\nthe need of constantly updating them if the sequence changes, even\ndramatically.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n# DoubleChain Data Structure for PERL\n# by Joseph A.L. Insana - Deathson - Filius Mortis - Fal Mortais\n# insana@ebi.ac.uk, jinsana@gmx.net\n\npackage Bio::LiveSeq::Chain;\n# TODO_list:\n# **** cleanup code\n# **** performance concerns\n# *??* create hash2dchain ???? (with hashkeys used for label)\n# **????** how about using array of arrays instead than hash of arrays??\n#\n# further strict complaints:\n# in verbose $string assignment around line 721 ???\n\n# TERMINOLOGY update, naming convention:\n# \"chain\" the datastructure\n# \"element\" the individual units that compose a chain\n# \"label\" the unique name of a single element\n# \"position\" the position of an element into the chain according to a\n#            particular coordinate system (e.g. counting from the start)\n# \"value\" what is stored in a single element\n\nuse Carp qw(croak cluck carp);\nuse Bio::Root::Version;\nuse strict; \nuse integer; # WARNING: this is to increase performance\n             # a little bit of attention has to be given if float need to\n             # be stored as elements of the array\n             # the use of this \"integer\" affects all operations but not\n             # assignments. So float CAN be assigned as elements of the chain\n             # BUT, if you assign $z=-1.8;, $z will be equal to -1 because\n             # \"-\" counts as a unary operation!\n\n=head2 _updown_chain2string\n\n  Title   : chain2string\n  Usage   : $string = Bio::LiveSeq::Chain::chain2string(\"down\",$chain,6,9)\n  Function: reads the contents of the chain, outputting a string\n  Returns : a string\n  Examples:\n          : down_chain2string($chain) -> all the chain from begin to end\n          : down_chain2string($chain,6) -> from 6 to the end\n          : down_chain2string($chain,6,4) -> from 6, going on 4 elements\n          : down_chain2string($chain,6,\"\",10) -> from 6 to 10\n          : up_chain2string($chain,10,\"\",6) -> from 10 to 6 upstream\n  Defaults: start=first element; if len undef, goes to last\n            if last undef, goes to end\n            if last defined, it overrides len (undefining it)\n  Error code: -1\n  Args    : \"up\"||\"down\" as first argument to specify the reading direction \n            reference (to the chain)\n            [first] [len] [last] optional integer arguments to specify how\n            much and from (and to) where to read\n\n\n# methods rewritten 2.61\nsub up_chain2string {\n  _updown_chain2string(\"up\",@_);\n}\nsub down_chain2string {\n  _updown_chain2string(\"down\",@_);\n}\n\nsub _updown_chain2string {\n  my ($direction,$chain,$first,$len,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n\n  if ($direction eq \"up\") {\n    $flow=2; # used to determine the direction of chain navigation\n    unless ($first) { $first=$end; } # if undef or 0, use $end\n  } else { # defaults to \"down\"\n    $flow=1; # used to determine the direction of chain navigation\n    unless ($first) { $first=$begin; } # if undef or 0, use $begin\n  }\n\n  unless($chain->{$first}) {\n    cluck \"label for first not defined\"; return (-1); }\n  if ($last) { # if last is defined, it gets priority and len is not used\n    unless($chain->{$last}) {\n      cluck \"label for last not defined\"; return (-1); }\n    if ($len) {\n      warn \"Warning chain2string: argument LAST:$last overriding LEN:$len!\";\n      undef $len;\n    }\n  } else {\n    if ($direction eq \"up\") {\n      $last=$begin; # if last not defined, go 'till begin (or upto len elements)\n    } else {\n      $last=$end; # if last not defined, go 'till end (or upto len elements)\n    }\n  }\n\n  my ($string,@array);\n  my $label=$first; my $i=1;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  # proceed for len elements or until last, whichever comes first\n  # if $len undef goes till end\n  while (($label) && ($label != $afterlast) && ($i <= ($len || $i + 1))) {\n    @array=@{$chain->{$label}};\n    $string .= $array[0];\n    $label = $array[$flow];\n    $i++;\n  }\n  return ($string); # if chain is interrupted $string won't be complete\n}\n\n=head2 _updown_labels\n\n Title   : labels\n Usage   : @labels = Bio::LiveSeq::Chain::_updown_labels(\"down\",$chain,4,16)\n Function: returns all the labels in a chain or those between two\n           specified ones (termed \"first\" and \"last\")\n Returns : a reference to an array containing the labels\n Args    : \"up\"||\"down\" as first argument to specify the reading direction \n           reference (to the chain)\n           [first] [last] (integer for the starting and eneding labels)\n\n\n\n# arguments: CHAIN_REF [FIRSTLABEL] [LASTLABEL]\n# returns: reference to array containing the labels\nsub down_labels {\n  my ($chain,$first,$last)=@_;\n  _updown_labels(\"down\",$chain,$first,$last);\n}\nsub up_labels {\n  my ($chain,$first,$last)=@_;\n  _updown_labels(\"up\",$chain,$first,$last);\n}\n# arguments: \"up\"||\"down\" CHAIN_REF [FIRSTLABEL] [LASTLABEL]\n# returns: reference to array containing the labels\nsub _updown_labels {\n  my ($direction,$chain,$first,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (0); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n  if ($direction eq \"up\") { $flow=2;\n    unless ($first) { $first=$end; }\n    unless ($last) { $last=$begin; }\n  } else { $flow=1;\n    unless ($last) { $last=$end; }\n    unless ($first) { $first=$begin; }\n  }\n  unless($chain->{$first}) { warn \"not existing label $first\"; return (0); }\n  unless($chain->{$last}) { warn \"not existing label $last\"; return (0); }\n\n  my $label=$first; my @labels;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  while (($label)&&($label != $afterlast)) {\n    push(@labels,$label);\n    $label=$chain->{$label}[$flow];\n  }\n  return (\\@labels); # if chain is interrupted @labels won't be complete\n}\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = Bio::LiveSeq::Chain::start()\n Returns : the label marking the start of the chain\n Errorcode: -1\n Args    : none\n\n\nsub start {\n  my $chain=$_[0];\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  return ($chain->{'begin'});\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = Bio::LiveSeq::Chain::end()\n Returns : the label marking the end of the chain\n Errorcode: -1\n Args    : none\n\n\nsub end {\n  my $chain=$_[0];\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  return ($chain->{'end'});\n}\n\n=head2 label_exists\n\n Title   : label_exists\n Usage   : $check = Bio::LiveSeq::Chain::label_exists($chain,$label)\n Function: It checks if a label is defined, i.e. if an element is there or\n           is not there anymore\n Returns : 1 if the label exists, 0 if it is not there, -1 error\n Errorcode: -1\n Args    : reference to the chain, integer\n\n\nsub label_exists {\n  my ($chain,$label)=@_;\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  if ($label && $chain->{$label}) { return (1); } else { return (0) };\n}\n\n\n=head2 down_get_pos_of_label\n\n Title   : down_get_pos_of_label\n Usage   : $position = Bio::LiveSeq::Chain::down_get_pos_of_label($chain,$label,$first)\n Function: returns the position of $label counting from $first, i.e. taking\n           $first as 1 of coordinate system. If $first is not specified it will\n           count from the start of the chain.\n Returns : \n Errorcode: 0\n Args    : reference to the chain, integer (the label of interest)\n           optional: integer (a different label that will be taken as the\n           first one, i.e. the one to count from)\n Note:     It counts \"downstream\". To proceed backward use up_get_pos_of_label","label":"down_get_pos_of_label($chain,$label,$first)"},"detail":"($chain,$label,$first)","definition":"sub","containerName":"main::","range":{"end":{"line":300,"character":9999},"start":{"line":296,"character":0}},"name":"down_get_pos_of_label"},{"name":"_updown_count","kind":12,"line":299},{"kind":12,"children":[{"kind":13,"line":303,"name":"$chain","definition":"my","containerName":"up_get_pos_of_label","localvar":"my"},{"line":303,"kind":13,"containerName":"up_get_pos_of_label","name":"$label"},{"kind":13,"line":303,"name":"$first","containerName":"up_get_pos_of_label"},{"kind":13,"line":304,"name":"$chain","containerName":"up_get_pos_of_label"},{"kind":13,"line":304,"containerName":"up_get_pos_of_label","name":"$first"},{"name":"$label","containerName":"up_get_pos_of_label","kind":13,"line":304}],"line":301,"definition":"sub","containerName":"main::","signature":{"label":"up_get_pos_of_label($chain,$label,$first)","documentation":"","parameters":[{"label":"$chain"},{"label":"$label"},{"label":"$first"}]},"detail":"($chain,$label,$first)","name":"up_get_pos_of_label","range":{"start":{"line":301,"character":0},"end":{"character":9999,"line":305}}},{"kind":12,"line":304,"name":"_updown_count"},{"name":"down_subchain_length","range":{"end":{"character":9999,"line":325},"start":{"character":0,"line":321}},"kind":12,"line":321,"children":[{"kind":13,"line":323,"name":"$chain","definition":"my","containerName":"down_subchain_length","localvar":"my"},{"name":"$first","containerName":"down_subchain_length","line":323,"kind":13},{"name":"$last","containerName":"down_subchain_length","kind":13,"line":323},{"containerName":"down_subchain_length","name":"$chain","line":324,"kind":13},{"containerName":"down_subchain_length","name":"$first","kind":13,"line":324},{"containerName":"down_subchain_length","name":"$last","kind":13,"line":324}],"containerName":"main::","definition":"sub","detail":"($chain,$first,$last)","signature":{"parameters":[{"label":"$chain"},{"label":"$first"},{"label":"$last"}],"documentation":"1; # returns 1\n#!/usr/bin/perl\n# $Id: Chain.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Chain\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n\n=head1 NAME\n\nBio::LiveSeq::Chain - DoubleChain DataStructure for Perl\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nThis is a general purpose module (that's why it's not in object-oriented\nform) that introduces a novel datastructure in PERL. It implements\nthe \"double linked chain\". The elements of the chain can contain basically\neverything. From chars to strings, from object references to arrays or hashes.\nIt is used in the LiveSequence project to create a dynamical DNA sequence,\neasier to manipulate and change. It's use is mainly for sequence variation\nanalysis but it could be used - for example - in e-cell projects.\nThe Chain module in itself doesn't have any biological bias, so can be\nused for any programming purpose.\n\nEach element of the chain (with the exclusion of the first and the last of the\nchain) is connected to other two elements (the PREVious and the NEXT one).\nThere is no absolute position (like in an array), hence if positions are\nimportant, they need to be computed (methods are provided).\nOtherwise it's easy to keep track of the elements with their \"LABELs\".\nThere is one LABEL (think of it as a pointer) to each ELEMENT. The labels\nwon't change after insertions or deletions of the chain. So it's\nalways possible to retrieve an element even if the chain has been\nmodified by successive insertions or deletions.\nFrom this the high potential profit for bioinformatics: dealing with\nsequences in a way that doesn't have to rely on positions, without\nthe need of constantly updating them if the sequence changes, even\ndramatically.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n# DoubleChain Data Structure for PERL\n# by Joseph A.L. Insana - Deathson - Filius Mortis - Fal Mortais\n# insana@ebi.ac.uk, jinsana@gmx.net\n\npackage Bio::LiveSeq::Chain;\n# TODO_list:\n# **** cleanup code\n# **** performance concerns\n# *??* create hash2dchain ???? (with hashkeys used for label)\n# **????** how about using array of arrays instead than hash of arrays??\n#\n# further strict complaints:\n# in verbose $string assignment around line 721 ???\n\n# TERMINOLOGY update, naming convention:\n# \"chain\" the datastructure\n# \"element\" the individual units that compose a chain\n# \"label\" the unique name of a single element\n# \"position\" the position of an element into the chain according to a\n#            particular coordinate system (e.g. counting from the start)\n# \"value\" what is stored in a single element\n\nuse Carp qw(croak cluck carp);\nuse Bio::Root::Version;\nuse strict; \nuse integer; # WARNING: this is to increase performance\n             # a little bit of attention has to be given if float need to\n             # be stored as elements of the array\n             # the use of this \"integer\" affects all operations but not\n             # assignments. So float CAN be assigned as elements of the chain\n             # BUT, if you assign $z=-1.8;, $z will be equal to -1 because\n             # \"-\" counts as a unary operation!\n\n=head2 _updown_chain2string\n\n  Title   : chain2string\n  Usage   : $string = Bio::LiveSeq::Chain::chain2string(\"down\",$chain,6,9)\n  Function: reads the contents of the chain, outputting a string\n  Returns : a string\n  Examples:\n          : down_chain2string($chain) -> all the chain from begin to end\n          : down_chain2string($chain,6) -> from 6 to the end\n          : down_chain2string($chain,6,4) -> from 6, going on 4 elements\n          : down_chain2string($chain,6,\"\",10) -> from 6 to 10\n          : up_chain2string($chain,10,\"\",6) -> from 10 to 6 upstream\n  Defaults: start=first element; if len undef, goes to last\n            if last undef, goes to end\n            if last defined, it overrides len (undefining it)\n  Error code: -1\n  Args    : \"up\"||\"down\" as first argument to specify the reading direction \n            reference (to the chain)\n            [first] [len] [last] optional integer arguments to specify how\n            much and from (and to) where to read\n\n\n# methods rewritten 2.61\nsub up_chain2string {\n  _updown_chain2string(\"up\",@_);\n}\nsub down_chain2string {\n  _updown_chain2string(\"down\",@_);\n}\n\nsub _updown_chain2string {\n  my ($direction,$chain,$first,$len,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n\n  if ($direction eq \"up\") {\n    $flow=2; # used to determine the direction of chain navigation\n    unless ($first) { $first=$end; } # if undef or 0, use $end\n  } else { # defaults to \"down\"\n    $flow=1; # used to determine the direction of chain navigation\n    unless ($first) { $first=$begin; } # if undef or 0, use $begin\n  }\n\n  unless($chain->{$first}) {\n    cluck \"label for first not defined\"; return (-1); }\n  if ($last) { # if last is defined, it gets priority and len is not used\n    unless($chain->{$last}) {\n      cluck \"label for last not defined\"; return (-1); }\n    if ($len) {\n      warn \"Warning chain2string: argument LAST:$last overriding LEN:$len!\";\n      undef $len;\n    }\n  } else {\n    if ($direction eq \"up\") {\n      $last=$begin; # if last not defined, go 'till begin (or upto len elements)\n    } else {\n      $last=$end; # if last not defined, go 'till end (or upto len elements)\n    }\n  }\n\n  my ($string,@array);\n  my $label=$first; my $i=1;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  # proceed for len elements or until last, whichever comes first\n  # if $len undef goes till end\n  while (($label) && ($label != $afterlast) && ($i <= ($len || $i + 1))) {\n    @array=@{$chain->{$label}};\n    $string .= $array[0];\n    $label = $array[$flow];\n    $i++;\n  }\n  return ($string); # if chain is interrupted $string won't be complete\n}\n\n=head2 _updown_labels\n\n Title   : labels\n Usage   : @labels = Bio::LiveSeq::Chain::_updown_labels(\"down\",$chain,4,16)\n Function: returns all the labels in a chain or those between two\n           specified ones (termed \"first\" and \"last\")\n Returns : a reference to an array containing the labels\n Args    : \"up\"||\"down\" as first argument to specify the reading direction \n           reference (to the chain)\n           [first] [last] (integer for the starting and eneding labels)\n\n\n\n# arguments: CHAIN_REF [FIRSTLABEL] [LASTLABEL]\n# returns: reference to array containing the labels\nsub down_labels {\n  my ($chain,$first,$last)=@_;\n  _updown_labels(\"down\",$chain,$first,$last);\n}\nsub up_labels {\n  my ($chain,$first,$last)=@_;\n  _updown_labels(\"up\",$chain,$first,$last);\n}\n# arguments: \"up\"||\"down\" CHAIN_REF [FIRSTLABEL] [LASTLABEL]\n# returns: reference to array containing the labels\nsub _updown_labels {\n  my ($direction,$chain,$first,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (0); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n  if ($direction eq \"up\") { $flow=2;\n    unless ($first) { $first=$end; }\n    unless ($last) { $last=$begin; }\n  } else { $flow=1;\n    unless ($last) { $last=$end; }\n    unless ($first) { $first=$begin; }\n  }\n  unless($chain->{$first}) { warn \"not existing label $first\"; return (0); }\n  unless($chain->{$last}) { warn \"not existing label $last\"; return (0); }\n\n  my $label=$first; my @labels;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  while (($label)&&($label != $afterlast)) {\n    push(@labels,$label);\n    $label=$chain->{$label}[$flow];\n  }\n  return (\\@labels); # if chain is interrupted @labels won't be complete\n}\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = Bio::LiveSeq::Chain::start()\n Returns : the label marking the start of the chain\n Errorcode: -1\n Args    : none\n\n\nsub start {\n  my $chain=$_[0];\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  return ($chain->{'begin'});\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = Bio::LiveSeq::Chain::end()\n Returns : the label marking the end of the chain\n Errorcode: -1\n Args    : none\n\n\nsub end {\n  my $chain=$_[0];\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  return ($chain->{'end'});\n}\n\n=head2 label_exists\n\n Title   : label_exists\n Usage   : $check = Bio::LiveSeq::Chain::label_exists($chain,$label)\n Function: It checks if a label is defined, i.e. if an element is there or\n           is not there anymore\n Returns : 1 if the label exists, 0 if it is not there, -1 error\n Errorcode: -1\n Args    : reference to the chain, integer\n\n\nsub label_exists {\n  my ($chain,$label)=@_;\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  if ($label && $chain->{$label}) { return (1); } else { return (0) };\n}\n\n\n=head2 down_get_pos_of_label\n\n Title   : down_get_pos_of_label\n Usage   : $position = Bio::LiveSeq::Chain::down_get_pos_of_label($chain,$label,$first)\n Function: returns the position of $label counting from $first, i.e. taking\n           $first as 1 of coordinate system. If $first is not specified it will\n           count from the start of the chain.\n Returns : \n Errorcode: 0\n Args    : reference to the chain, integer (the label of interest)\n           optional: integer (a different label that will be taken as the\n           first one, i.e. the one to count from)\n Note:     It counts \"downstream\". To proceed backward use up_get_pos_of_label\n\n\nsub down_get_pos_of_label {\n  #down_chain2string($_[0],$_[2],undef,$_[1],\"counting\");\n  my ($chain,$label,$first)=@_;\n  _updown_count(\"down\",$chain,$first,$label);\n}\nsub up_get_pos_of_label {\n  #up_chain2string($_[0],$_[2],undef,$_[1],\"counting\");\n  my ($chain,$label,$first)=@_;\n  _updown_count(\"up\",$chain,$first,$label);\n}\n\n=head2 down_subchain_length\n\n Title   : down_subchain_length\n Usage   : $length = Bio::LiveSeq::Chain::down_subchain_length($chain,$first,$last)\n Function: returns the length of the chain between the labels \"first\" and \"last\", included\n Returns : integer\n Errorcode: 0\n Args    : reference to the chain, integer, integer\n Note:     It counts \"downstream\". To proceed backward use up_subchain_length\n\n arguments: chain_ref [first] [last]\n returns the length of the chain between first and last (included)","label":"down_subchain_length($chain,$first,$last)"}},{"name":"_updown_count","line":324,"kind":12},{"name":"up_subchain_length","range":{"start":{"line":326,"character":0},"end":{"character":9999,"line":330}},"kind":12,"children":[{"containerName":"up_subchain_length","name":"$chain","definition":"my","localvar":"my","kind":13,"line":328},{"kind":13,"line":328,"containerName":"up_subchain_length","name":"$first"},{"name":"$last","containerName":"up_subchain_length","line":328,"kind":13},{"containerName":"up_subchain_length","name":"$chain","line":329,"kind":13},{"line":329,"kind":13,"containerName":"up_subchain_length","name":"$first"},{"line":329,"kind":13,"containerName":"up_subchain_length","name":"$last"}],"line":326,"definition":"sub","containerName":"main::","signature":{"label":"up_subchain_length($chain,$first,$last)","parameters":[{"label":"$chain"},{"label":"$first"},{"label":"$last"}],"documentation":""},"detail":"($chain,$first,$last)"},{"name":"_updown_count","kind":12,"line":329},{"name":"_updown_count","range":{"start":{"line":334,"character":0},"end":{"character":9999,"line":359}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$direction"},{"label":"$chain"},{"label":"$first"},{"label":"$last"}],"documentation":" arguments: DIRECTION CHAIN_REF FIRSTLABEL LASTLABEL\n errorcode 0","label":"_updown_count($direction,$chain,$first,$last)"},"detail":"($direction,$chain,$first,$last)","kind":12,"children":[{"kind":13,"line":335,"containerName":"_updown_count","name":"$direction","definition":"my","localvar":"my"},{"name":"$chain","containerName":"_updown_count","kind":13,"line":335},{"kind":13,"line":335,"name":"$first","containerName":"_updown_count"},{"containerName":"_updown_count","name":"$last","kind":13,"line":335},{"name":"$chain","containerName":"_updown_count","kind":13,"line":336},{"kind":13,"line":337,"containerName":"_updown_count","definition":"my","name":"$begin","localvar":"my"},{"containerName":"_updown_count","name":"$chain","kind":13,"line":337},{"line":338,"kind":13,"localvar":"my","definition":"my","name":"$end","containerName":"_updown_count"},{"name":"$chain","containerName":"_updown_count","line":338,"kind":13},{"containerName":"_updown_count","definition":"my","name":"$flow","localvar":"my","kind":13,"line":339},{"name":"$direction","containerName":"_updown_count","kind":13,"line":340},{"line":340,"kind":13,"containerName":"_updown_count","name":"$flow"},{"containerName":"_updown_count","name":"$first","kind":13,"line":341},{"kind":13,"line":341,"name":"$first","containerName":"_updown_count"},{"kind":13,"line":341,"containerName":"_updown_count","name":"$end"},{"line":342,"kind":13,"name":"$last","containerName":"_updown_count"},{"name":"$last","containerName":"_updown_count","line":342,"kind":13},{"line":342,"kind":13,"name":"$begin","containerName":"_updown_count"},{"containerName":"_updown_count","name":"$flow","line":343,"kind":13},{"kind":13,"line":344,"name":"$last","containerName":"_updown_count"},{"name":"$last","containerName":"_updown_count","line":344,"kind":13},{"name":"$end","containerName":"_updown_count","kind":13,"line":344},{"line":345,"kind":13,"name":"$first","containerName":"_updown_count"},{"name":"$first","containerName":"_updown_count","line":345,"kind":13},{"line":345,"kind":13,"containerName":"_updown_count","name":"$begin"},{"containerName":"_updown_count","name":"$chain","kind":13,"line":347},{"kind":13,"line":347,"name":"$first","containerName":"_updown_count"},{"name":"$chain","containerName":"_updown_count","kind":13,"line":348},{"line":348,"kind":13,"name":"$last","containerName":"_updown_count"},{"localvar":"my","name":"$label","definition":"my","containerName":"_updown_count","line":350,"kind":13},{"name":"$first","containerName":"_updown_count","kind":13,"line":350},{"kind":13,"line":350,"containerName":"_updown_count","name":"$count","definition":"my","localvar":"my"},{"localvar":"my","containerName":"_updown_count","name":"$afterlast","definition":"my","line":351,"kind":13},{"kind":13,"line":351,"name":"$chain","containerName":"_updown_count"},{"kind":13,"line":351,"containerName":"_updown_count","name":"$last"},{"line":351,"kind":13,"name":"$flow","containerName":"_updown_count"},{"line":352,"kind":13,"name":"$afterlast","containerName":"_updown_count"},{"name":"$afterlast","containerName":"_updown_count","line":352,"kind":13},{"line":354,"kind":13,"name":"$label","containerName":"_updown_count"},{"containerName":"_updown_count","name":"$label","line":354,"kind":13},{"name":"$afterlast","containerName":"_updown_count","line":354,"kind":13},{"kind":13,"line":355,"name":"$count","containerName":"_updown_count"},{"line":356,"kind":13,"name":"$label","containerName":"_updown_count"},{"containerName":"_updown_count","name":"$chain","line":356,"kind":13},{"name":"$label","containerName":"_updown_count","line":356,"kind":13},{"containerName":"_updown_count","name":"$flow","kind":13,"line":356},{"name":"$count","containerName":"_updown_count","kind":13,"line":358}],"line":334},{"name":"cluck","line":336,"kind":12},{"children":[{"localvar":"my","definition":"my","name":"$chain","containerName":"invert_chain","line":373,"kind":13},{"line":374,"kind":13,"containerName":"invert_chain","name":"$chain"},{"line":375,"kind":13,"localvar":"my","definition":"my","name":"$begin","containerName":"invert_chain"},{"name":"$chain","containerName":"invert_chain","kind":13,"line":375},{"kind":13,"line":376,"containerName":"invert_chain","definition":"my","name":"$end","localvar":"my"},{"containerName":"invert_chain","name":"$chain","line":376,"kind":13},{"kind":13,"line":377,"containerName":"invert_chain","definition":"my","name":"$label","localvar":"my"},{"containerName":"invert_chain","name":"@array","kind":13,"line":377},{"kind":13,"line":378,"containerName":"invert_chain","name":"$label"},{"name":"$begin","containerName":"invert_chain","kind":13,"line":378},{"line":379,"kind":13,"containerName":"invert_chain","name":"$label"},{"kind":13,"line":380,"name":"@array","containerName":"invert_chain"},{"name":"$chain","containerName":"invert_chain","line":380,"kind":13},{"name":"$label","containerName":"invert_chain","kind":13,"line":380},{"containerName":"invert_chain","name":"$chain","line":381,"kind":13},{"name":"$label","containerName":"invert_chain","line":381,"kind":13},{"name":"$chain","containerName":"invert_chain","kind":13,"line":381},{"line":381,"kind":13,"name":"$label","containerName":"invert_chain"},{"name":"$array","containerName":"invert_chain","kind":13,"line":381},{"name":"$array","containerName":"invert_chain","kind":13,"line":381},{"containerName":"invert_chain","name":"$label","line":382,"kind":13},{"containerName":"invert_chain","name":"$array","kind":13,"line":382}],"line":372,"kind":12,"range":{"start":{"character":0,"line":372},"end":{"character":9999,"line":383}},"definition":"sub","name":"invert_chain","containerName":"main::"},{"name":"cluck","line":374,"kind":12},{"name":"%chain","containerName":null,"kind":13,"line":385},{"kind":13,"line":385,"name":"%chain","containerName":null},{"containerName":null,"name":"$end","line":385,"kind":13},{"line":385,"kind":13,"name":"$begin","containerName":null},{"range":{"end":{"character":9999,"line":418},"start":{"line":411,"character":0}},"name":"down_get_value_at_pos","children":[{"containerName":"down_get_value_at_pos","definition":"my","name":"$chain","localvar":"my","kind":13,"line":412},{"containerName":"down_get_value_at_pos","name":"$position","kind":13,"line":412},{"line":412,"kind":13,"name":"$first","containerName":"down_get_value_at_pos"},{"localvar":"my","containerName":"down_get_value_at_pos","name":"$label","definition":"my","line":413,"kind":13},{"containerName":"down_get_value_at_pos","name":"$chain","line":413,"kind":13},{"name":"$position","containerName":"down_get_value_at_pos","kind":13,"line":413},{"line":413,"kind":13,"containerName":"down_get_value_at_pos","name":"$first"},{"line":415,"kind":13,"name":"$label","containerName":"down_get_value_at_pos"},{"containerName":"down_get_value_at_pos","name":"$label","line":415,"kind":13},{"containerName":"down_get_value_at_pos","name":"$chain","line":417,"kind":13},{"name":"$label","containerName":"down_get_value_at_pos","line":417,"kind":13}],"line":411,"kind":12,"signature":{"parameters":[{"label":"$chain"},{"label":"$position"},{"label":"$first"}],"documentation":"1; # returns 1\n#!/usr/bin/perl\n# $Id: Chain.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Chain\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n\n=head1 NAME\n\nBio::LiveSeq::Chain - DoubleChain DataStructure for Perl\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nThis is a general purpose module (that's why it's not in object-oriented\nform) that introduces a novel datastructure in PERL. It implements\nthe \"double linked chain\". The elements of the chain can contain basically\neverything. From chars to strings, from object references to arrays or hashes.\nIt is used in the LiveSequence project to create a dynamical DNA sequence,\neasier to manipulate and change. It's use is mainly for sequence variation\nanalysis but it could be used - for example - in e-cell projects.\nThe Chain module in itself doesn't have any biological bias, so can be\nused for any programming purpose.\n\nEach element of the chain (with the exclusion of the first and the last of the\nchain) is connected to other two elements (the PREVious and the NEXT one).\nThere is no absolute position (like in an array), hence if positions are\nimportant, they need to be computed (methods are provided).\nOtherwise it's easy to keep track of the elements with their \"LABELs\".\nThere is one LABEL (think of it as a pointer) to each ELEMENT. The labels\nwon't change after insertions or deletions of the chain. So it's\nalways possible to retrieve an element even if the chain has been\nmodified by successive insertions or deletions.\nFrom this the high potential profit for bioinformatics: dealing with\nsequences in a way that doesn't have to rely on positions, without\nthe need of constantly updating them if the sequence changes, even\ndramatically.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n# DoubleChain Data Structure for PERL\n# by Joseph A.L. Insana - Deathson - Filius Mortis - Fal Mortais\n# insana@ebi.ac.uk, jinsana@gmx.net\n\npackage Bio::LiveSeq::Chain;\n# TODO_list:\n# **** cleanup code\n# **** performance concerns\n# *??* create hash2dchain ???? (with hashkeys used for label)\n# **????** how about using array of arrays instead than hash of arrays??\n#\n# further strict complaints:\n# in verbose $string assignment around line 721 ???\n\n# TERMINOLOGY update, naming convention:\n# \"chain\" the datastructure\n# \"element\" the individual units that compose a chain\n# \"label\" the unique name of a single element\n# \"position\" the position of an element into the chain according to a\n#            particular coordinate system (e.g. counting from the start)\n# \"value\" what is stored in a single element\n\nuse Carp qw(croak cluck carp);\nuse Bio::Root::Version;\nuse strict; \nuse integer; # WARNING: this is to increase performance\n             # a little bit of attention has to be given if float need to\n             # be stored as elements of the array\n             # the use of this \"integer\" affects all operations but not\n             # assignments. So float CAN be assigned as elements of the chain\n             # BUT, if you assign $z=-1.8;, $z will be equal to -1 because\n             # \"-\" counts as a unary operation!\n\n=head2 _updown_chain2string\n\n  Title   : chain2string\n  Usage   : $string = Bio::LiveSeq::Chain::chain2string(\"down\",$chain,6,9)\n  Function: reads the contents of the chain, outputting a string\n  Returns : a string\n  Examples:\n          : down_chain2string($chain) -> all the chain from begin to end\n          : down_chain2string($chain,6) -> from 6 to the end\n          : down_chain2string($chain,6,4) -> from 6, going on 4 elements\n          : down_chain2string($chain,6,\"\",10) -> from 6 to 10\n          : up_chain2string($chain,10,\"\",6) -> from 10 to 6 upstream\n  Defaults: start=first element; if len undef, goes to last\n            if last undef, goes to end\n            if last defined, it overrides len (undefining it)\n  Error code: -1\n  Args    : \"up\"||\"down\" as first argument to specify the reading direction \n            reference (to the chain)\n            [first] [len] [last] optional integer arguments to specify how\n            much and from (and to) where to read\n\n\n# methods rewritten 2.61\nsub up_chain2string {\n  _updown_chain2string(\"up\",@_);\n}\nsub down_chain2string {\n  _updown_chain2string(\"down\",@_);\n}\n\nsub _updown_chain2string {\n  my ($direction,$chain,$first,$len,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n\n  if ($direction eq \"up\") {\n    $flow=2; # used to determine the direction of chain navigation\n    unless ($first) { $first=$end; } # if undef or 0, use $end\n  } else { # defaults to \"down\"\n    $flow=1; # used to determine the direction of chain navigation\n    unless ($first) { $first=$begin; } # if undef or 0, use $begin\n  }\n\n  unless($chain->{$first}) {\n    cluck \"label for first not defined\"; return (-1); }\n  if ($last) { # if last is defined, it gets priority and len is not used\n    unless($chain->{$last}) {\n      cluck \"label for last not defined\"; return (-1); }\n    if ($len) {\n      warn \"Warning chain2string: argument LAST:$last overriding LEN:$len!\";\n      undef $len;\n    }\n  } else {\n    if ($direction eq \"up\") {\n      $last=$begin; # if last not defined, go 'till begin (or upto len elements)\n    } else {\n      $last=$end; # if last not defined, go 'till end (or upto len elements)\n    }\n  }\n\n  my ($string,@array);\n  my $label=$first; my $i=1;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  # proceed for len elements or until last, whichever comes first\n  # if $len undef goes till end\n  while (($label) && ($label != $afterlast) && ($i <= ($len || $i + 1))) {\n    @array=@{$chain->{$label}};\n    $string .= $array[0];\n    $label = $array[$flow];\n    $i++;\n  }\n  return ($string); # if chain is interrupted $string won't be complete\n}\n\n=head2 _updown_labels\n\n Title   : labels\n Usage   : @labels = Bio::LiveSeq::Chain::_updown_labels(\"down\",$chain,4,16)\n Function: returns all the labels in a chain or those between two\n           specified ones (termed \"first\" and \"last\")\n Returns : a reference to an array containing the labels\n Args    : \"up\"||\"down\" as first argument to specify the reading direction \n           reference (to the chain)\n           [first] [last] (integer for the starting and eneding labels)\n\n\n\n# arguments: CHAIN_REF [FIRSTLABEL] [LASTLABEL]\n# returns: reference to array containing the labels\nsub down_labels {\n  my ($chain,$first,$last)=@_;\n  _updown_labels(\"down\",$chain,$first,$last);\n}\nsub up_labels {\n  my ($chain,$first,$last)=@_;\n  _updown_labels(\"up\",$chain,$first,$last);\n}\n# arguments: \"up\"||\"down\" CHAIN_REF [FIRSTLABEL] [LASTLABEL]\n# returns: reference to array containing the labels\nsub _updown_labels {\n  my ($direction,$chain,$first,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (0); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n  if ($direction eq \"up\") { $flow=2;\n    unless ($first) { $first=$end; }\n    unless ($last) { $last=$begin; }\n  } else { $flow=1;\n    unless ($last) { $last=$end; }\n    unless ($first) { $first=$begin; }\n  }\n  unless($chain->{$first}) { warn \"not existing label $first\"; return (0); }\n  unless($chain->{$last}) { warn \"not existing label $last\"; return (0); }\n\n  my $label=$first; my @labels;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  while (($label)&&($label != $afterlast)) {\n    push(@labels,$label);\n    $label=$chain->{$label}[$flow];\n  }\n  return (\\@labels); # if chain is interrupted @labels won't be complete\n}\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = Bio::LiveSeq::Chain::start()\n Returns : the label marking the start of the chain\n Errorcode: -1\n Args    : none\n\n\nsub start {\n  my $chain=$_[0];\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  return ($chain->{'begin'});\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = Bio::LiveSeq::Chain::end()\n Returns : the label marking the end of the chain\n Errorcode: -1\n Args    : none\n\n\nsub end {\n  my $chain=$_[0];\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  return ($chain->{'end'});\n}\n\n=head2 label_exists\n\n Title   : label_exists\n Usage   : $check = Bio::LiveSeq::Chain::label_exists($chain,$label)\n Function: It checks if a label is defined, i.e. if an element is there or\n           is not there anymore\n Returns : 1 if the label exists, 0 if it is not there, -1 error\n Errorcode: -1\n Args    : reference to the chain, integer\n\n\nsub label_exists {\n  my ($chain,$label)=@_;\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  if ($label && $chain->{$label}) { return (1); } else { return (0) };\n}\n\n\n=head2 down_get_pos_of_label\n\n Title   : down_get_pos_of_label\n Usage   : $position = Bio::LiveSeq::Chain::down_get_pos_of_label($chain,$label,$first)\n Function: returns the position of $label counting from $first, i.e. taking\n           $first as 1 of coordinate system. If $first is not specified it will\n           count from the start of the chain.\n Returns : \n Errorcode: 0\n Args    : reference to the chain, integer (the label of interest)\n           optional: integer (a different label that will be taken as the\n           first one, i.e. the one to count from)\n Note:     It counts \"downstream\". To proceed backward use up_get_pos_of_label\n\n\nsub down_get_pos_of_label {\n  #down_chain2string($_[0],$_[2],undef,$_[1],\"counting\");\n  my ($chain,$label,$first)=@_;\n  _updown_count(\"down\",$chain,$first,$label);\n}\nsub up_get_pos_of_label {\n  #up_chain2string($_[0],$_[2],undef,$_[1],\"counting\");\n  my ($chain,$label,$first)=@_;\n  _updown_count(\"up\",$chain,$first,$label);\n}\n\n=head2 down_subchain_length\n\n Title   : down_subchain_length\n Usage   : $length = Bio::LiveSeq::Chain::down_subchain_length($chain,$first,$last)\n Function: returns the length of the chain between the labels \"first\" and \"last\", included\n Returns : integer\n Errorcode: 0\n Args    : reference to the chain, integer, integer\n Note:     It counts \"downstream\". To proceed backward use up_subchain_length\n\n\n# arguments: chain_ref [first] [last]\n# returns the length of the chain between first and last (included)\nsub down_subchain_length {\n  #down_chain2string($_[0],$_[1],undef,$_[2],\"counting\");\n  my ($chain,$first,$last)=@_;\n  _updown_count(\"down\",$chain,$first,$last);\n}\nsub up_subchain_length {\n  #up_chain2string($_[0],$_[1],undef,$_[2],\"counting\");\n  my ($chain,$first,$last)=@_;\n  _updown_count(\"up\",$chain,$first,$last);\n}\n\n# arguments: DIRECTION CHAIN_REF FIRSTLABEL LASTLABEL\n# errorcode 0\nsub _updown_count {\n  my ($direction,$chain,$first,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (0); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n  if ($direction eq \"up\") { $flow=2;\n    unless ($first) { $first=$end; }\n    unless ($last) { $last=$begin; }\n  } else { $flow=1;\n    unless ($last) { $last=$end; }\n    unless ($first) { $first=$begin; }\n  }\n  unless($chain->{$first}) { warn \"not existing label $first\"; return (0); }\n  unless($chain->{$last}) { warn \"not existing label $last\"; return (0); }\n\n  my $label=$first; my $count;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  while (($label)&&($label != $afterlast)) {\n    $count++;\n    $label=$chain->{$label}[$flow];\n  }\n  return ($count); # if chain is interrupted, $i will be up to the breaking point\n}\n\n=head2 invert_chain\n\n Title   : invert_chain\n Usage   : $errorcode=Bio::LiveSeq::Chain::invert_chain($chain)\n Function: completely inverts the order of the chain elements; begin is swapped with end and all links updated (PREV&NEXT fields swapped)\n Returns : 1 if all OK, 0 if errors\n Errorcode: 0\n Args    : reference to the chain\n\n\nsub invert_chain {\n  my $chain=$_[0];\n  unless($chain) { cluck \"no chain input\"; return (0); }\n  my $begin=$chain->{'begin'}; # the name of the first element\n  my $end=$chain->{'end'}; # the name of the last element\n  my ($label,@array);\n  $label=$begin; # starts from the beginning\n  while ($label) { # proceed with linked elements, swapping PREV and NEXT\n    @array=@{$chain->{$label}};\n    ($chain->{$label}[1],$chain->{$label}[2])=($array[2],$array[1]); # swap\n    $label = $array[1]; # go to the next one\n  }\n  # now swap begin and end fields\n  ($chain->{'begin'},$chain->{'end'})=($end,$begin);\n  return (1); # that's it\n}\n\n# warning that method has changed name\n#sub mutate_element {\n  #croak \"Warning: old method name. Please update code to 'set_value_at_label'\\n\";\n  # &set_value_at_label;\n#}\n\n=head2 down_get_value_at_pos\n\n Title   : down_get_value_at_pos\n Usage   : $value = Bio::LiveSeq::Chain::down_get_value_at_pos($chain,$position,$first)\n Function: used to access the value of the chain at a particular position instead than directly with a label pointer. It will count the position from the start of the chain or from the label $first, if $first is specified\n Returns : whatever is stored in the element of the chain\n Errorcode: 0\n Args    : reference to the chain, integer, [integer]\n Note:     It works \"downstream\". To proceed backward use up_get_value_at_pos\n\nsub get_value_at_pos {\ncroak \"Please use instead: down_get_value_at_pos\";\n#&down_get_value_at_pos;\n}","label":"down_get_value_at_pos($chain,$position,$first)"},"detail":"($chain,$position,$first)","definition":"sub","containerName":"main::"},{"kind":12,"line":413,"name":"down_get_label_at_pos"},{"line":417,"kind":12,"name":"_get_value"},{"kind":12,"line":419,"children":[{"line":420,"kind":13,"localvar":"my","containerName":"up_get_value_at_pos","definition":"my","name":"$chain"},{"containerName":"up_get_value_at_pos","name":"$position","kind":13,"line":420},{"name":"$first","containerName":"up_get_value_at_pos","line":420,"kind":13},{"localvar":"my","name":"$label","definition":"my","containerName":"up_get_value_at_pos","line":421,"kind":13},{"name":"$chain","containerName":"up_get_value_at_pos","line":421,"kind":13},{"containerName":"up_get_value_at_pos","name":"$position","kind":13,"line":421},{"containerName":"up_get_value_at_pos","name":"$first","kind":13,"line":421},{"name":"$label","containerName":"up_get_value_at_pos","line":423,"kind":13},{"kind":13,"line":423,"containerName":"up_get_value_at_pos","name":"$label"},{"kind":13,"line":425,"containerName":"up_get_value_at_pos","name":"$chain"},{"line":425,"kind":13,"name":"$label","containerName":"up_get_value_at_pos"}],"containerName":"main::","definition":"sub","detail":"($chain,$position,$first)","signature":{"label":"up_get_value_at_pos($chain,$position,$first)","documentation":"","parameters":[{"label":"$chain"},{"label":"$position"},{"label":"$first"}]},"name":"up_get_value_at_pos","range":{"start":{"line":419,"character":0},"end":{"character":9999,"line":426}}},{"kind":12,"line":421,"name":"up_get_label_at_pos"},{"line":425,"kind":12,"name":"_get_value"},{"range":{"start":{"line":447,"character":0},"end":{"line":455,"character":9999}},"name":"down_set_value_at_pos","detail":"($chain,$value,$position,$first)","signature":{"parameters":[{"label":"$chain"},{"label":"$value"},{"label":"$position"},{"label":"$first"}],"documentation":"1; # returns 1\n#!/usr/bin/perl\n# $Id: Chain.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Chain\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n\n=head1 NAME\n\nBio::LiveSeq::Chain - DoubleChain DataStructure for Perl\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nThis is a general purpose module (that's why it's not in object-oriented\nform) that introduces a novel datastructure in PERL. It implements\nthe \"double linked chain\". The elements of the chain can contain basically\neverything. From chars to strings, from object references to arrays or hashes.\nIt is used in the LiveSequence project to create a dynamical DNA sequence,\neasier to manipulate and change. It's use is mainly for sequence variation\nanalysis but it could be used - for example - in e-cell projects.\nThe Chain module in itself doesn't have any biological bias, so can be\nused for any programming purpose.\n\nEach element of the chain (with the exclusion of the first and the last of the\nchain) is connected to other two elements (the PREVious and the NEXT one).\nThere is no absolute position (like in an array), hence if positions are\nimportant, they need to be computed (methods are provided).\nOtherwise it's easy to keep track of the elements with their \"LABELs\".\nThere is one LABEL (think of it as a pointer) to each ELEMENT. The labels\nwon't change after insertions or deletions of the chain. So it's\nalways possible to retrieve an element even if the chain has been\nmodified by successive insertions or deletions.\nFrom this the high potential profit for bioinformatics: dealing with\nsequences in a way that doesn't have to rely on positions, without\nthe need of constantly updating them if the sequence changes, even\ndramatically.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n# DoubleChain Data Structure for PERL\n# by Joseph A.L. Insana - Deathson - Filius Mortis - Fal Mortais\n# insana@ebi.ac.uk, jinsana@gmx.net\n\npackage Bio::LiveSeq::Chain;\n# TODO_list:\n# **** cleanup code\n# **** performance concerns\n# *??* create hash2dchain ???? (with hashkeys used for label)\n# **????** how about using array of arrays instead than hash of arrays??\n#\n# further strict complaints:\n# in verbose $string assignment around line 721 ???\n\n# TERMINOLOGY update, naming convention:\n# \"chain\" the datastructure\n# \"element\" the individual units that compose a chain\n# \"label\" the unique name of a single element\n# \"position\" the position of an element into the chain according to a\n#            particular coordinate system (e.g. counting from the start)\n# \"value\" what is stored in a single element\n\nuse Carp qw(croak cluck carp);\nuse Bio::Root::Version;\nuse strict; \nuse integer; # WARNING: this is to increase performance\n             # a little bit of attention has to be given if float need to\n             # be stored as elements of the array\n             # the use of this \"integer\" affects all operations but not\n             # assignments. So float CAN be assigned as elements of the chain\n             # BUT, if you assign $z=-1.8;, $z will be equal to -1 because\n             # \"-\" counts as a unary operation!\n\n=head2 _updown_chain2string\n\n  Title   : chain2string\n  Usage   : $string = Bio::LiveSeq::Chain::chain2string(\"down\",$chain,6,9)\n  Function: reads the contents of the chain, outputting a string\n  Returns : a string\n  Examples:\n          : down_chain2string($chain) -> all the chain from begin to end\n          : down_chain2string($chain,6) -> from 6 to the end\n          : down_chain2string($chain,6,4) -> from 6, going on 4 elements\n          : down_chain2string($chain,6,\"\",10) -> from 6 to 10\n          : up_chain2string($chain,10,\"\",6) -> from 10 to 6 upstream\n  Defaults: start=first element; if len undef, goes to last\n            if last undef, goes to end\n            if last defined, it overrides len (undefining it)\n  Error code: -1\n  Args    : \"up\"||\"down\" as first argument to specify the reading direction \n            reference (to the chain)\n            [first] [len] [last] optional integer arguments to specify how\n            much and from (and to) where to read\n\n\n# methods rewritten 2.61\nsub up_chain2string {\n  _updown_chain2string(\"up\",@_);\n}\nsub down_chain2string {\n  _updown_chain2string(\"down\",@_);\n}\n\nsub _updown_chain2string {\n  my ($direction,$chain,$first,$len,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n\n  if ($direction eq \"up\") {\n    $flow=2; # used to determine the direction of chain navigation\n    unless ($first) { $first=$end; } # if undef or 0, use $end\n  } else { # defaults to \"down\"\n    $flow=1; # used to determine the direction of chain navigation\n    unless ($first) { $first=$begin; } # if undef or 0, use $begin\n  }\n\n  unless($chain->{$first}) {\n    cluck \"label for first not defined\"; return (-1); }\n  if ($last) { # if last is defined, it gets priority and len is not used\n    unless($chain->{$last}) {\n      cluck \"label for last not defined\"; return (-1); }\n    if ($len) {\n      warn \"Warning chain2string: argument LAST:$last overriding LEN:$len!\";\n      undef $len;\n    }\n  } else {\n    if ($direction eq \"up\") {\n      $last=$begin; # if last not defined, go 'till begin (or upto len elements)\n    } else {\n      $last=$end; # if last not defined, go 'till end (or upto len elements)\n    }\n  }\n\n  my ($string,@array);\n  my $label=$first; my $i=1;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  # proceed for len elements or until last, whichever comes first\n  # if $len undef goes till end\n  while (($label) && ($label != $afterlast) && ($i <= ($len || $i + 1))) {\n    @array=@{$chain->{$label}};\n    $string .= $array[0];\n    $label = $array[$flow];\n    $i++;\n  }\n  return ($string); # if chain is interrupted $string won't be complete\n}\n\n=head2 _updown_labels\n\n Title   : labels\n Usage   : @labels = Bio::LiveSeq::Chain::_updown_labels(\"down\",$chain,4,16)\n Function: returns all the labels in a chain or those between two\n           specified ones (termed \"first\" and \"last\")\n Returns : a reference to an array containing the labels\n Args    : \"up\"||\"down\" as first argument to specify the reading direction \n           reference (to the chain)\n           [first] [last] (integer for the starting and eneding labels)\n\n\n\n# arguments: CHAIN_REF [FIRSTLABEL] [LASTLABEL]\n# returns: reference to array containing the labels\nsub down_labels {\n  my ($chain,$first,$last)=@_;\n  _updown_labels(\"down\",$chain,$first,$last);\n}\nsub up_labels {\n  my ($chain,$first,$last)=@_;\n  _updown_labels(\"up\",$chain,$first,$last);\n}\n# arguments: \"up\"||\"down\" CHAIN_REF [FIRSTLABEL] [LASTLABEL]\n# returns: reference to array containing the labels\nsub _updown_labels {\n  my ($direction,$chain,$first,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (0); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n  if ($direction eq \"up\") { $flow=2;\n    unless ($first) { $first=$end; }\n    unless ($last) { $last=$begin; }\n  } else { $flow=1;\n    unless ($last) { $last=$end; }\n    unless ($first) { $first=$begin; }\n  }\n  unless($chain->{$first}) { warn \"not existing label $first\"; return (0); }\n  unless($chain->{$last}) { warn \"not existing label $last\"; return (0); }\n\n  my $label=$first; my @labels;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  while (($label)&&($label != $afterlast)) {\n    push(@labels,$label);\n    $label=$chain->{$label}[$flow];\n  }\n  return (\\@labels); # if chain is interrupted @labels won't be complete\n}\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = Bio::LiveSeq::Chain::start()\n Returns : the label marking the start of the chain\n Errorcode: -1\n Args    : none\n\n\nsub start {\n  my $chain=$_[0];\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  return ($chain->{'begin'});\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = Bio::LiveSeq::Chain::end()\n Returns : the label marking the end of the chain\n Errorcode: -1\n Args    : none\n\n\nsub end {\n  my $chain=$_[0];\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  return ($chain->{'end'});\n}\n\n=head2 label_exists\n\n Title   : label_exists\n Usage   : $check = Bio::LiveSeq::Chain::label_exists($chain,$label)\n Function: It checks if a label is defined, i.e. if an element is there or\n           is not there anymore\n Returns : 1 if the label exists, 0 if it is not there, -1 error\n Errorcode: -1\n Args    : reference to the chain, integer\n\n\nsub label_exists {\n  my ($chain,$label)=@_;\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  if ($label && $chain->{$label}) { return (1); } else { return (0) };\n}\n\n\n=head2 down_get_pos_of_label\n\n Title   : down_get_pos_of_label\n Usage   : $position = Bio::LiveSeq::Chain::down_get_pos_of_label($chain,$label,$first)\n Function: returns the position of $label counting from $first, i.e. taking\n           $first as 1 of coordinate system. If $first is not specified it will\n           count from the start of the chain.\n Returns : \n Errorcode: 0\n Args    : reference to the chain, integer (the label of interest)\n           optional: integer (a different label that will be taken as the\n           first one, i.e. the one to count from)\n Note:     It counts \"downstream\". To proceed backward use up_get_pos_of_label\n\n\nsub down_get_pos_of_label {\n  #down_chain2string($_[0],$_[2],undef,$_[1],\"counting\");\n  my ($chain,$label,$first)=@_;\n  _updown_count(\"down\",$chain,$first,$label);\n}\nsub up_get_pos_of_label {\n  #up_chain2string($_[0],$_[2],undef,$_[1],\"counting\");\n  my ($chain,$label,$first)=@_;\n  _updown_count(\"up\",$chain,$first,$label);\n}\n\n=head2 down_subchain_length\n\n Title   : down_subchain_length\n Usage   : $length = Bio::LiveSeq::Chain::down_subchain_length($chain,$first,$last)\n Function: returns the length of the chain between the labels \"first\" and \"last\", included\n Returns : integer\n Errorcode: 0\n Args    : reference to the chain, integer, integer\n Note:     It counts \"downstream\". To proceed backward use up_subchain_length\n\n\n# arguments: chain_ref [first] [last]\n# returns the length of the chain between first and last (included)\nsub down_subchain_length {\n  #down_chain2string($_[0],$_[1],undef,$_[2],\"counting\");\n  my ($chain,$first,$last)=@_;\n  _updown_count(\"down\",$chain,$first,$last);\n}\nsub up_subchain_length {\n  #up_chain2string($_[0],$_[1],undef,$_[2],\"counting\");\n  my ($chain,$first,$last)=@_;\n  _updown_count(\"up\",$chain,$first,$last);\n}\n\n# arguments: DIRECTION CHAIN_REF FIRSTLABEL LASTLABEL\n# errorcode 0\nsub _updown_count {\n  my ($direction,$chain,$first,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (0); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n  if ($direction eq \"up\") { $flow=2;\n    unless ($first) { $first=$end; }\n    unless ($last) { $last=$begin; }\n  } else { $flow=1;\n    unless ($last) { $last=$end; }\n    unless ($first) { $first=$begin; }\n  }\n  unless($chain->{$first}) { warn \"not existing label $first\"; return (0); }\n  unless($chain->{$last}) { warn \"not existing label $last\"; return (0); }\n\n  my $label=$first; my $count;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  while (($label)&&($label != $afterlast)) {\n    $count++;\n    $label=$chain->{$label}[$flow];\n  }\n  return ($count); # if chain is interrupted, $i will be up to the breaking point\n}\n\n=head2 invert_chain\n\n Title   : invert_chain\n Usage   : $errorcode=Bio::LiveSeq::Chain::invert_chain($chain)\n Function: completely inverts the order of the chain elements; begin is swapped with end and all links updated (PREV&NEXT fields swapped)\n Returns : 1 if all OK, 0 if errors\n Errorcode: 0\n Args    : reference to the chain\n\n\nsub invert_chain {\n  my $chain=$_[0];\n  unless($chain) { cluck \"no chain input\"; return (0); }\n  my $begin=$chain->{'begin'}; # the name of the first element\n  my $end=$chain->{'end'}; # the name of the last element\n  my ($label,@array);\n  $label=$begin; # starts from the beginning\n  while ($label) { # proceed with linked elements, swapping PREV and NEXT\n    @array=@{$chain->{$label}};\n    ($chain->{$label}[1],$chain->{$label}[2])=($array[2],$array[1]); # swap\n    $label = $array[1]; # go to the next one\n  }\n  # now swap begin and end fields\n  ($chain->{'begin'},$chain->{'end'})=($end,$begin);\n  return (1); # that's it\n}\n\n# warning that method has changed name\n#sub mutate_element {\n  #croak \"Warning: old method name. Please update code to 'set_value_at_label'\\n\";\n  # &set_value_at_label;\n#}\n\n=head2 down_get_value_at_pos\n\n Title   : down_get_value_at_pos\n Usage   : $value = Bio::LiveSeq::Chain::down_get_value_at_pos($chain,$position,$first)\n Function: used to access the value of the chain at a particular position instead than directly with a label pointer. It will count the position from the start of the chain or from the label $first, if $first is specified\n Returns : whatever is stored in the element of the chain\n Errorcode: 0\n Args    : reference to the chain, integer, [integer]\n Note:     It works \"downstream\". To proceed backward use up_get_value_at_pos\n\n\n#sub get_value_at_pos {\n  #croak \"Please use instead: down_get_value_at_pos\";\n  ##&down_get_value_at_pos;\n#}\nsub down_get_value_at_pos {\n  my ($chain,$position,$first)=@_;\n  my $label=down_get_label_at_pos($chain,$position,$first);\n  # check place of change\n  if (($label eq -1)||($label eq 0)) { # complain if label doesn't exist\n    warn \"not existing element $label\"; return (0); }\n  return _get_value($chain,$label);\n}\nsub up_get_value_at_pos {\n  my ($chain,$position,$first)=@_;\n  my $label=up_get_label_at_pos($chain,$position,$first);\n  # check place of change\n  if (($label eq -1)||($label eq 0)) { # complain if label doesn't exist\n    warn \"not existing element $label\"; return (0); }\n  return _get_value($chain,$label);\n}\n\n=head2 down_set_value_at_pos\n\n Title   : down_set_value_at_pos\n Usage   : $errorcode = Bio::LiveSeq::Chain::down_set_value_at_pos($chain,$newvalue,$position,$first)\n Function: used to store a new value inside an element of the chain at a particular position instead than directly with a label pointer. It will count the position from the start of the chain or from the label $first, if $first is specified\n Returns : 1\n Errorcode: 0\n Args    : reference to the chain, newvalue, integer, [integer]\n           (newvalue can be: integer, string, object reference, hash ref)\n Note:     It works \"downstream\". To proceed backward use up_set_value_at_pos\n Note2:    If the $newvalue is undef, it will delete the contents of the\n           element but it won't remove the element from the chain.\n\nsub set_value_at_pos {\ncroak \"Please use instead: down_set_value_at_pos\";\n#&down_set_value_at_pos;\n}","label":"down_set_value_at_pos($chain,$value,$position,$first)"},"containerName":"main::","definition":"sub","line":447,"children":[{"line":448,"kind":13,"localvar":"my","containerName":"down_set_value_at_pos","name":"$chain","definition":"my"},{"kind":13,"line":448,"name":"$value","containerName":"down_set_value_at_pos"},{"line":448,"kind":13,"name":"$position","containerName":"down_set_value_at_pos"},{"line":448,"kind":13,"containerName":"down_set_value_at_pos","name":"$first"},{"kind":13,"line":449,"name":"$label","definition":"my","containerName":"down_set_value_at_pos","localvar":"my"},{"name":"$chain","containerName":"down_set_value_at_pos","kind":13,"line":449},{"name":"$position","containerName":"down_set_value_at_pos","kind":13,"line":449},{"line":449,"kind":13,"name":"$first","containerName":"down_set_value_at_pos"},{"line":451,"kind":13,"name":"$label","containerName":"down_set_value_at_pos"},{"containerName":"down_set_value_at_pos","name":"$label","line":451,"kind":13},{"kind":13,"line":453,"containerName":"down_set_value_at_pos","name":"$chain"},{"line":453,"kind":13,"containerName":"down_set_value_at_pos","name":"$label"},{"line":453,"kind":13,"containerName":"down_set_value_at_pos","name":"$value"}],"kind":12},{"name":"down_get_label_at_pos","kind":12,"line":449},{"line":453,"kind":12,"name":"_set_value"},{"range":{"end":{"character":9999,"line":464},"start":{"character":0,"line":456}},"name":"up_set_value_at_pos","children":[{"name":"$chain","definition":"my","containerName":"up_set_value_at_pos","localvar":"my","kind":13,"line":457},{"line":457,"kind":13,"name":"$value","containerName":"up_set_value_at_pos"},{"containerName":"up_set_value_at_pos","name":"$position","kind":13,"line":457},{"name":"$first","containerName":"up_set_value_at_pos","kind":13,"line":457},{"line":458,"kind":13,"localvar":"my","name":"$label","definition":"my","containerName":"up_set_value_at_pos"},{"name":"$chain","containerName":"up_set_value_at_pos","kind":13,"line":458},{"line":458,"kind":13,"name":"$position","containerName":"up_set_value_at_pos"},{"kind":13,"line":458,"name":"$first","containerName":"up_set_value_at_pos"},{"kind":13,"line":460,"containerName":"up_set_value_at_pos","name":"$label"},{"containerName":"up_set_value_at_pos","name":"$label","kind":13,"line":460},{"containerName":"up_set_value_at_pos","name":"$chain","kind":13,"line":462},{"name":"$label","containerName":"up_set_value_at_pos","kind":13,"line":462},{"containerName":"up_set_value_at_pos","name":"$value","line":462,"kind":13}],"line":456,"kind":12,"signature":{"label":"up_set_value_at_pos($chain,$value,$position,$first)","documentation":"","parameters":[{"label":"$chain"},{"label":"$value"},{"label":"$position"},{"label":"$first"}]},"detail":"($chain,$value,$position,$first)","definition":"sub","containerName":"main::"},{"line":458,"kind":12,"name":"up_get_label_at_pos"},{"kind":12,"line":462,"name":"_set_value"},{"name":"set_value_at_label","range":{"end":{"character":9999,"line":491},"start":{"line":482,"character":0}},"definition":"sub","containerName":"main::","signature":{"label":"set_value_at_label($chain,$value,$label)","documentation":"1; # returns 1\n#!/usr/bin/perl\n# $Id: Chain.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Chain\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n\n=head1 NAME\n\nBio::LiveSeq::Chain - DoubleChain DataStructure for Perl\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nThis is a general purpose module (that's why it's not in object-oriented\nform) that introduces a novel datastructure in PERL. It implements\nthe \"double linked chain\". The elements of the chain can contain basically\neverything. From chars to strings, from object references to arrays or hashes.\nIt is used in the LiveSequence project to create a dynamical DNA sequence,\neasier to manipulate and change. It's use is mainly for sequence variation\nanalysis but it could be used - for example - in e-cell projects.\nThe Chain module in itself doesn't have any biological bias, so can be\nused for any programming purpose.\n\nEach element of the chain (with the exclusion of the first and the last of the\nchain) is connected to other two elements (the PREVious and the NEXT one).\nThere is no absolute position (like in an array), hence if positions are\nimportant, they need to be computed (methods are provided).\nOtherwise it's easy to keep track of the elements with their \"LABELs\".\nThere is one LABEL (think of it as a pointer) to each ELEMENT. The labels\nwon't change after insertions or deletions of the chain. So it's\nalways possible to retrieve an element even if the chain has been\nmodified by successive insertions or deletions.\nFrom this the high potential profit for bioinformatics: dealing with\nsequences in a way that doesn't have to rely on positions, without\nthe need of constantly updating them if the sequence changes, even\ndramatically.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n# DoubleChain Data Structure for PERL\n# by Joseph A.L. Insana - Deathson - Filius Mortis - Fal Mortais\n# insana@ebi.ac.uk, jinsana@gmx.net\n\npackage Bio::LiveSeq::Chain;\n# TODO_list:\n# **** cleanup code\n# **** performance concerns\n# *??* create hash2dchain ???? (with hashkeys used for label)\n# **????** how about using array of arrays instead than hash of arrays??\n#\n# further strict complaints:\n# in verbose $string assignment around line 721 ???\n\n# TERMINOLOGY update, naming convention:\n# \"chain\" the datastructure\n# \"element\" the individual units that compose a chain\n# \"label\" the unique name of a single element\n# \"position\" the position of an element into the chain according to a\n#            particular coordinate system (e.g. counting from the start)\n# \"value\" what is stored in a single element\n\nuse Carp qw(croak cluck carp);\nuse Bio::Root::Version;\nuse strict; \nuse integer; # WARNING: this is to increase performance\n             # a little bit of attention has to be given if float need to\n             # be stored as elements of the array\n             # the use of this \"integer\" affects all operations but not\n             # assignments. So float CAN be assigned as elements of the chain\n             # BUT, if you assign $z=-1.8;, $z will be equal to -1 because\n             # \"-\" counts as a unary operation!\n\n=head2 _updown_chain2string\n\n  Title   : chain2string\n  Usage   : $string = Bio::LiveSeq::Chain::chain2string(\"down\",$chain,6,9)\n  Function: reads the contents of the chain, outputting a string\n  Returns : a string\n  Examples:\n          : down_chain2string($chain) -> all the chain from begin to end\n          : down_chain2string($chain,6) -> from 6 to the end\n          : down_chain2string($chain,6,4) -> from 6, going on 4 elements\n          : down_chain2string($chain,6,\"\",10) -> from 6 to 10\n          : up_chain2string($chain,10,\"\",6) -> from 10 to 6 upstream\n  Defaults: start=first element; if len undef, goes to last\n            if last undef, goes to end\n            if last defined, it overrides len (undefining it)\n  Error code: -1\n  Args    : \"up\"||\"down\" as first argument to specify the reading direction \n            reference (to the chain)\n            [first] [len] [last] optional integer arguments to specify how\n            much and from (and to) where to read\n\n\n# methods rewritten 2.61\nsub up_chain2string {\n  _updown_chain2string(\"up\",@_);\n}\nsub down_chain2string {\n  _updown_chain2string(\"down\",@_);\n}\n\nsub _updown_chain2string {\n  my ($direction,$chain,$first,$len,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n\n  if ($direction eq \"up\") {\n    $flow=2; # used to determine the direction of chain navigation\n    unless ($first) { $first=$end; } # if undef or 0, use $end\n  } else { # defaults to \"down\"\n    $flow=1; # used to determine the direction of chain navigation\n    unless ($first) { $first=$begin; } # if undef or 0, use $begin\n  }\n\n  unless($chain->{$first}) {\n    cluck \"label for first not defined\"; return (-1); }\n  if ($last) { # if last is defined, it gets priority and len is not used\n    unless($chain->{$last}) {\n      cluck \"label for last not defined\"; return (-1); }\n    if ($len) {\n      warn \"Warning chain2string: argument LAST:$last overriding LEN:$len!\";\n      undef $len;\n    }\n  } else {\n    if ($direction eq \"up\") {\n      $last=$begin; # if last not defined, go 'till begin (or upto len elements)\n    } else {\n      $last=$end; # if last not defined, go 'till end (or upto len elements)\n    }\n  }\n\n  my ($string,@array);\n  my $label=$first; my $i=1;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  # proceed for len elements or until last, whichever comes first\n  # if $len undef goes till end\n  while (($label) && ($label != $afterlast) && ($i <= ($len || $i + 1))) {\n    @array=@{$chain->{$label}};\n    $string .= $array[0];\n    $label = $array[$flow];\n    $i++;\n  }\n  return ($string); # if chain is interrupted $string won't be complete\n}\n\n=head2 _updown_labels\n\n Title   : labels\n Usage   : @labels = Bio::LiveSeq::Chain::_updown_labels(\"down\",$chain,4,16)\n Function: returns all the labels in a chain or those between two\n           specified ones (termed \"first\" and \"last\")\n Returns : a reference to an array containing the labels\n Args    : \"up\"||\"down\" as first argument to specify the reading direction \n           reference (to the chain)\n           [first] [last] (integer for the starting and eneding labels)\n\n\n\n# arguments: CHAIN_REF [FIRSTLABEL] [LASTLABEL]\n# returns: reference to array containing the labels\nsub down_labels {\n  my ($chain,$first,$last)=@_;\n  _updown_labels(\"down\",$chain,$first,$last);\n}\nsub up_labels {\n  my ($chain,$first,$last)=@_;\n  _updown_labels(\"up\",$chain,$first,$last);\n}\n# arguments: \"up\"||\"down\" CHAIN_REF [FIRSTLABEL] [LASTLABEL]\n# returns: reference to array containing the labels\nsub _updown_labels {\n  my ($direction,$chain,$first,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (0); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n  if ($direction eq \"up\") { $flow=2;\n    unless ($first) { $first=$end; }\n    unless ($last) { $last=$begin; }\n  } else { $flow=1;\n    unless ($last) { $last=$end; }\n    unless ($first) { $first=$begin; }\n  }\n  unless($chain->{$first}) { warn \"not existing label $first\"; return (0); }\n  unless($chain->{$last}) { warn \"not existing label $last\"; return (0); }\n\n  my $label=$first; my @labels;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  while (($label)&&($label != $afterlast)) {\n    push(@labels,$label);\n    $label=$chain->{$label}[$flow];\n  }\n  return (\\@labels); # if chain is interrupted @labels won't be complete\n}\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = Bio::LiveSeq::Chain::start()\n Returns : the label marking the start of the chain\n Errorcode: -1\n Args    : none\n\n\nsub start {\n  my $chain=$_[0];\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  return ($chain->{'begin'});\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = Bio::LiveSeq::Chain::end()\n Returns : the label marking the end of the chain\n Errorcode: -1\n Args    : none\n\n\nsub end {\n  my $chain=$_[0];\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  return ($chain->{'end'});\n}\n\n=head2 label_exists\n\n Title   : label_exists\n Usage   : $check = Bio::LiveSeq::Chain::label_exists($chain,$label)\n Function: It checks if a label is defined, i.e. if an element is there or\n           is not there anymore\n Returns : 1 if the label exists, 0 if it is not there, -1 error\n Errorcode: -1\n Args    : reference to the chain, integer\n\n\nsub label_exists {\n  my ($chain,$label)=@_;\n  unless($chain) { cluck \"no chain input\"; return (-1); }\n  if ($label && $chain->{$label}) { return (1); } else { return (0) };\n}\n\n\n=head2 down_get_pos_of_label\n\n Title   : down_get_pos_of_label\n Usage   : $position = Bio::LiveSeq::Chain::down_get_pos_of_label($chain,$label,$first)\n Function: returns the position of $label counting from $first, i.e. taking\n           $first as 1 of coordinate system. If $first is not specified it will\n           count from the start of the chain.\n Returns : \n Errorcode: 0\n Args    : reference to the chain, integer (the label of interest)\n           optional: integer (a different label that will be taken as the\n           first one, i.e. the one to count from)\n Note:     It counts \"downstream\". To proceed backward use up_get_pos_of_label\n\n\nsub down_get_pos_of_label {\n  #down_chain2string($_[0],$_[2],undef,$_[1],\"counting\");\n  my ($chain,$label,$first)=@_;\n  _updown_count(\"down\",$chain,$first,$label);\n}\nsub up_get_pos_of_label {\n  #up_chain2string($_[0],$_[2],undef,$_[1],\"counting\");\n  my ($chain,$label,$first)=@_;\n  _updown_count(\"up\",$chain,$first,$label);\n}\n\n=head2 down_subchain_length\n\n Title   : down_subchain_length\n Usage   : $length = Bio::LiveSeq::Chain::down_subchain_length($chain,$first,$last)\n Function: returns the length of the chain between the labels \"first\" and \"last\", included\n Returns : integer\n Errorcode: 0\n Args    : reference to the chain, integer, integer\n Note:     It counts \"downstream\". To proceed backward use up_subchain_length\n\n\n# arguments: chain_ref [first] [last]\n# returns the length of the chain between first and last (included)\nsub down_subchain_length {\n  #down_chain2string($_[0],$_[1],undef,$_[2],\"counting\");\n  my ($chain,$first,$last)=@_;\n  _updown_count(\"down\",$chain,$first,$last);\n}\nsub up_subchain_length {\n  #up_chain2string($_[0],$_[1],undef,$_[2],\"counting\");\n  my ($chain,$first,$last)=@_;\n  _updown_count(\"up\",$chain,$first,$last);\n}\n\n# arguments: DIRECTION CHAIN_REF FIRSTLABEL LASTLABEL\n# errorcode 0\nsub _updown_count {\n  my ($direction,$chain,$first,$last)=@_;\n  unless($chain) { cluck \"no chain input\"; return (0); }\n  my $begin=$chain->{'begin'}; # the label of the BEGIN element\n  my $end=$chain->{'end'}; # the label of the END element\n  my $flow;\n  if ($direction eq \"up\") { $flow=2;\n    unless ($first) { $first=$end; }\n    unless ($last) { $last=$begin; }\n  } else { $flow=1;\n    unless ($last) { $last=$end; }\n    unless ($first) { $first=$begin; }\n  }\n  unless($chain->{$first}) { warn \"not existing label $first\"; return (0); }\n  unless($chain->{$last}) { warn \"not existing label $last\"; return (0); }\n\n  my $label=$first; my $count;\n  my $afterlast=$chain->{$last}[$flow]; # if last=end, afterlast is undef\n  unless (defined $afterlast) { $afterlast=0; } # keep strict happy\n\n  while (($label)&&($label != $afterlast)) {\n    $count++;\n    $label=$chain->{$label}[$flow];\n  }\n  return ($count); # if chain is interrupted, $i will be up to the breaking point\n}\n\n=head2 invert_chain\n\n Title   : invert_chain\n Usage   : $errorcode=Bio::LiveSeq::Chain::invert_chain($chain)\n Function: completely inverts the order of the chain elements; begin is swapped with end and all links updated (PREV&NEXT fields swapped)\n Returns : 1 if all OK, 0 if errors\n Errorcode: 0\n Args    : reference to the chain\n\n\nsub invert_chain {\n  my $chain=$_[0];\n  unless($chain) { cluck \"no chain input\"; return (0); }\n  my $begin=$chain->{'begin'}; # the name of the first element\n  my $end=$chain->{'end'}; # the name of the last element\n  my ($label,@array);\n  $label=$begin; # starts from the beginning\n  while ($label) { # proceed with linked elements, swapping PREV and NEXT\n    @array=@{$chain->{$label}};\n    ($chain->{$label}[1],$chain->{$label}[2])=($array[2],$array[1]); # swap\n    $label = $array[1]; # go to the next one\n  }\n  # now swap begin and end fields\n  ($chain->{'begin'},$chain->{'end'})=($end,$begin);\n  return (1); # that's it\n}\n\n# warning that method has changed name\n#sub mutate_element {\n  #croak \"Warning: old method name. Please update code to 'set_value_at_label'\\n\";\n  # &set_value_at_label;\n#}\n\n=head2 down_get_value_at_pos\n\n Title   : down_get_value_at_pos\n Usage   : $value = Bio::LiveSeq::Chain::down_get_value_at_pos($chain,$position,$first)\n Function: used to access the value of the chain at a particular position instead than directly with a label pointer. It will count the position from the start of the chain or from the label $first, if $first is specified\n Returns : whatever is stored in the element of the chain\n Errorcode: 0\n Args    : reference to the chain, integer, [integer]\n Note:     It works \"downstream\". To proceed backward use up_get_value_at_pos\n\n\n#sub get_value_at_pos {\n  #croak \"Please use instead: down_get_value_at_pos\";\n  ##&down_get_value_at_pos;\n#}\nsub down_get_value_at_pos {\n  my ($chain,$position,$first)=@_;\n  my $label=down_get_label_at_pos($chain,$position,$first);\n  # check place of change\n  if (($label eq -1)||($label eq 0)) { # complain if label doesn't exist\n    warn \"not existing element $label\"; return (0); }\n  return _get_value($chain,$label);\n}\nsub up_get_value_at_pos {\n  my ($chain,$position,$first)=@_;\n  my $label=up_get_label_at_pos($chain,$position,$first);\n  # check place of change\n  if (($label eq -1)||($label eq 0)) { # complain if label doesn't exist\n    warn \"not existing element $label\"; return (0); }\n  return _get_value($chain,$label);\n}\n\n=head2 down_set_value_at_pos\n\n Title   : down_set_value_at_pos\n Usage   : $errorcode = Bio::LiveSeq::Chain::down_set_value_at_pos($chain,$newvalue,$position,$first)\n Function: used to store a new value inside an element of the chain at a particular position instead than directly with a label pointer. It will count the position from the start of the chain or from the label $first, if $first is specified\n Returns : 1\n Errorcode: 0\n Args    : reference to the chain, newvalue, integer, [integer]\n           (newvalue can be: integer, string, object reference, hash ref)\n Note:     It works \"downstream\". To proceed backward use up_set_value_at_pos\n Note2:    If the $newvalue is undef, it will delete the contents of the\n           element but it won't remove the element from the chain.\n\n\n#sub set_value_at_pos {\n  #croak \"Please use instead: down_set_value_at_pos\";\n  ##&down_set_value_at_pos;\n#}\nsub down_set_value_at_pos {\n  my ($chain,$value,$position,$first)=@_;\n  my $label=down_get_label_at_pos($chain,$position,$first);\n  # check place of change\n  if (($label eq -1)||($label eq 0)) { # complain if label doesn't exist\n    warn \"not existing element $label\"; return (0); }\n  _set_value($chain,$label,$value);\n  return (1);\n}\nsub up_set_value_at_pos {\n  my ($chain,$value,$position,$first)=@_;\n  my $label=up_get_label_at_pos($chain,$position,$first);\n  # check place of change\n  if (($label eq -1)||($label eq 0)) { # complain if label doesn't exist\n    warn \"not existing element $label\"; return (0); }\n  _set_value($chain,$label,$value);\n  return (1);\n}\n\n\n=head2 down_set_value_at_label\n\n Title   : down_set_value_at_label\n Usage   : $errorcode = Bio::LiveSeq::Chain::down_set_value_at_label($chain,$newvalue,$label)\n Function: used to store a new value inside an element of the chain defined by its label.\n Returns : 1\n Errorcode: 0\n Args    : reference to the chain, newvalue, integer\n           (newvalue can be: integer, string, object reference, hash ref)\n Note:     It works \"downstream\". To proceed backward use up_set_value_at_label\n Note2:    If the $newvalue is undef, it will delete the contents of the\n           element but it won't remove the element from the chain.","parameters":[{"label":"$chain"},{"label":"$value"},{"label":"$label"}]},"detail":"($chain,$value,$label)","kind":12,"children":[{"line":483,"kind":13,"localvar":"my","name":"$chain","definition":"my","containerName":"set_value_at_label"},{"line":483,"kind":13,"name":"$value","containerName":"set_value_at_label"},{"containerName":"set_value_at_label","name":"$label","kind":13,"line":483},{"kind":13,"line":484,"name":"$chain","containerName":"set_value_at_label"},{"containerName":"set_value_at_label","name":"$chain","line":487,"kind":13},{"name":"$label","containerName":"set_value_at_label","line":487,"kind":13},{"line":489,"kind":13,"name":"$chain","containerName":"set_value_at_label"},{"line":489,"kind":13,"name":"$label","containerName":"set_value_at_label"},{"kind":13,"line":489,"name":"$value","containerName":"set_value_at_label"}],"line":482},{"kind":12,"line":484,"name":"cluck"},{"name":"_set_value","kind":12,"line":489},{"containerName":"main::","definition":"sub","name":"get_value_at_label","range":{"start":{"line":505,"character":0},"end":{"line":514,"character":9999}},"kind":12,"line":505,"children":[{"kind":13,"line":506,"name":"$chain","definition":"my","containerName":"get_value_at_label","localvar":"my"},{"kind":13,"line":507,"containerName":"get_value_at_label","name":"$chain"},{"line":508,"kind":13,"localvar":"my","definition":"my","name":"$label","containerName":"get_value_at_label"},{"name":"$chain","containerName":"get_value_at_label","line":511,"kind":13},{"kind":13,"line":511,"name":"$label","containerName":"get_value_at_label"},{"kind":13,"line":513,"name":"$chain","containerName":"get_value_at_label"},{"kind":13,"line":513,"containerName":"get_value_at_label","name":"$label"}]},{"name":"cluck","line":507,"kind":12},{"name":"_get_value","line":513,"kind":12},{"containerName":"main::","definition":"sub","detail":"($chain,$label,$value)","signature":{"label":"_set_value($chain,$label,$value)","parameters":[{"label":"$chain"},{"label":"$label"},{"label":"$value"}],"documentation":" arguments: CHAIN_REF LABEL VALUE"},"kind":12,"line":517,"children":[{"kind":13,"line":518,"name":"$chain","definition":"my","containerName":"_set_value","localvar":"my"},{"name":"$label","containerName":"_set_value","line":518,"kind":13},{"name":"$value","containerName":"_set_value","kind":13,"line":518},{"containerName":"_set_value","name":"$chain","kind":13,"line":519},{"containerName":"_set_value","name":"$label","kind":13,"line":519},{"containerName":"_set_value","name":"$value","kind":13,"line":519}],"name":"_set_value","range":{"end":{"line":520,"character":9999},"start":{"character":0,"line":517}}},{"kind":12,"children":[{"name":"$chain","definition":"my","containerName":"_get_value","localvar":"my","kind":13,"line":523},{"containerName":"_get_value","name":"$label","kind":13,"line":523},{"name":"$chain","containerName":"_get_value","kind":13,"line":524},{"name":"$label","containerName":"_get_value","kind":13,"line":524}],"line":522,"definition":"sub","containerName":"main::","signature":{"label":"_get_value($chain,$label)","parameters":[{"label":"$chain"},{"label":"$label"}],"documentation":" arguments: CHAIN_REF LABEL"},"detail":"($chain,$label)","name":"_get_value","range":{"start":{"line":522,"character":0},"end":{"character":9999,"line":525}}},{"kind":12,"line":541,"children":[],"containerName":"main::","definition":"sub","name":"down_get_label_at_pos","range":{"start":{"line":541,"character":0},"end":{"character":9999,"line":543}}},{"line":542,"kind":12,"name":"_updown_get_label_at_pos"},{"line":544,"children":[],"kind":12,"range":{"start":{"character":0,"line":544},"end":{"character":9999,"line":546}},"containerName":"main::","definition":"sub","name":"up_get_label_at_pos"},{"line":545,"kind":12,"name":"_updown_get_label_at_pos"},{"range":{"start":{"line":552,"character":0},"end":{"line":570,"character":9999}},"name":"_updown_get_label_at_pos","line":552,"children":[{"kind":13,"line":553,"containerName":"_updown_get_label_at_pos","definition":"my","name":"$direction","localvar":"my"},{"name":"$chain","containerName":"_updown_get_label_at_pos","line":553,"kind":13},{"kind":13,"line":553,"containerName":"_updown_get_label_at_pos","name":"$position"},{"name":"$first","containerName":"_updown_get_label_at_pos","line":553,"kind":13},{"kind":13,"line":554,"containerName":"_updown_get_label_at_pos","name":"$chain"},{"line":555,"kind":13,"localvar":"my","containerName":"_updown_get_label_at_pos","name":"$begin","definition":"my"},{"kind":13,"line":555,"containerName":"_updown_get_label_at_pos","name":"$chain"},{"localvar":"my","definition":"my","name":"$end","containerName":"_updown_get_label_at_pos","line":556,"kind":13},{"name":"$chain","containerName":"_updown_get_label_at_pos","line":556,"kind":13},{"line":557,"kind":13,"localvar":"my","name":"$flow","definition":"my","containerName":"_updown_get_label_at_pos"},{"name":"$direction","containerName":"_updown_get_label_at_pos","kind":13,"line":558},{"kind":13,"line":558,"name":"$flow","containerName":"_updown_get_label_at_pos"},{"name":"$first","containerName":"_updown_get_label_at_pos","kind":13,"line":558},{"name":"$first","containerName":"_updown_get_label_at_pos","kind":13,"line":558},{"containerName":"_updown_get_label_at_pos","name":"$end","line":558,"kind":13},{"kind":13,"line":559,"containerName":"_updown_get_label_at_pos","name":"$flow"},{"name":"$first","containerName":"_updown_get_label_at_pos","line":559,"kind":13},{"line":559,"kind":13,"containerName":"_updown_get_label_at_pos","name":"$first"},{"name":"$begin","containerName":"_updown_get_label_at_pos","kind":13,"line":559},{"line":560,"kind":13,"containerName":"_updown_get_label_at_pos","name":"$chain"},{"line":560,"kind":13,"containerName":"_updown_get_label_at_pos","name":"$first"},{"line":562,"kind":13,"localvar":"my","definition":"my","name":"$label","containerName":"_updown_get_label_at_pos"},{"name":"$first","containerName":"_updown_get_label_at_pos","kind":13,"line":562},{"kind":13,"line":563,"containerName":"_updown_get_label_at_pos","name":"$i","definition":"my","localvar":"my"},{"kind":13,"line":564,"name":"$i","containerName":"_updown_get_label_at_pos"},{"kind":13,"line":564,"containerName":"_updown_get_label_at_pos","name":"$position"},{"kind":13,"line":565,"containerName":"_updown_get_label_at_pos","name":"$label"},{"containerName":"_updown_get_label_at_pos","name":"$chain","kind":13,"line":565},{"line":565,"kind":13,"containerName":"_updown_get_label_at_pos","name":"$label"},{"kind":13,"line":565,"containerName":"_updown_get_label_at_pos","name":"$flow"},{"containerName":"_updown_get_label_at_pos","name":"$i","line":566,"kind":13},{"name":"$label","containerName":"_updown_get_label_at_pos","kind":13,"line":567},{"line":569,"kind":13,"containerName":"_updown_get_label_at_pos","name":"$label"}],"kind":12,"detail":"($direction,$chain,$position,$first)","signature":{"label":"_updown_get_label_at_pos($direction,$chain,$position,$first)","documentation":" arguments: [DIRECTION] CHAIN_REF POSITION [FIRST]\n Default DIRECTION=\"down\"\n if FIRST is undefined, FIRST=START (if DIRECTION=down) or FIRST=END (up)","parameters":[{"label":"$direction"},{"label":"$chain"},{"label":"$position"},{"label":"$first"}]},"containerName":"main::","definition":"sub"},{"name":"cluck","line":554,"kind":12},{"kind":12,"line":573,"children":[],"containerName":"main::","definition":"sub","name":"preinsert_string","range":{"start":{"character":0,"line":573},"end":{"character":9999,"line":573}}},{"line":573,"kind":12,"name":"praeinsert_string"},{"containerName":"main::","name":"preinsert_array","definition":"sub","range":{"start":{"character":0,"line":574},"end":{"character":9999,"line":574}},"kind":12,"line":574,"children":[]},{"name":"praeinsert_array","line":574,"kind":12},{"range":{"start":{"line":581,"character":0},"end":{"character":9999,"line":584}},"containerName":"main::","definition":"sub","name":"praeinsert_string","line":581,"children":[{"line":582,"kind":13,"localvar":"my","containerName":"praeinsert_string","definition":"my","name":"@string"},{"line":583,"kind":13,"containerName":"praeinsert_string","name":"@string"}],"kind":12},{"line":583,"kind":12,"name":"praeinsert_array"},{"range":{"start":{"character":0,"line":591},"end":{"line":594,"character":9999}},"containerName":"main::","name":"postinsert_string","definition":"sub","line":591,"children":[{"kind":13,"line":592,"containerName":"postinsert_string","name":"@string","definition":"my","localvar":"my"},{"kind":13,"line":593,"name":"@string","containerName":"postinsert_string"}],"kind":12},{"name":"postinsert_array","kind":12,"line":593},{"kind":12,"line":600,"children":[],"containerName":"main::","name":"praeinsert_array","definition":"sub","range":{"end":{"character":9999,"line":602},"start":{"character":0,"line":600}}},{"name":"_praepostinsert_array","kind":12,"line":601},{"containerName":"main::","name":"postinsert_array","definition":"sub","range":{"end":{"line":610,"character":9999},"start":{"line":608,"character":0}},"kind":12,"line":608,"children":[]},{"line":609,"kind":12,"name":"_praepostinsert_array"},{"range":{"end":{"character":9999,"line":652},"start":{"character":0,"line":628}},"containerName":"main::","definition":"sub","name":"_praepostinsert_array","line":628,"children":[{"localvar":"my","name":"$chain","definition":"my","containerName":"_praepostinsert_array","line":629,"kind":13},{"name":"$chain","containerName":"_praepostinsert_array","line":630,"kind":13},{"localvar":"my","containerName":"_praepostinsert_array","definition":"my","name":"$praepost","line":631,"kind":13},{"localvar":"my","containerName":"_praepostinsert_array","name":"$prae","definition":"my","line":632,"kind":13},{"name":"$post","containerName":"_praepostinsert_array","line":632,"kind":13},{"localvar":"my","definition":"my","name":"$position","containerName":"_praepostinsert_array","line":633,"kind":13},{"line":634,"kind":13,"localvar":"my","containerName":"_praepostinsert_array","name":"$begin","definition":"my"},{"line":634,"kind":13,"name":"$chain","containerName":"_praepostinsert_array"},{"line":635,"kind":13,"localvar":"my","containerName":"_praepostinsert_array","definition":"my","name":"$end"},{"containerName":"_praepostinsert_array","name":"$chain","line":635,"kind":13},{"containerName":"_praepostinsert_array","name":"$praepost","line":637,"kind":13},{"name":"$prae","containerName":"_praepostinsert_array","line":638,"kind":13},{"line":639,"kind":13,"containerName":"_praepostinsert_array","name":"$position"},{"line":639,"kind":13,"containerName":"_praepostinsert_array","name":"$position"},{"containerName":"_praepostinsert_array","name":"$position","line":639,"kind":13},{"containerName":"_praepostinsert_array","name":"$begin","line":639,"kind":13},{"kind":13,"line":641,"name":"$post","containerName":"_praepostinsert_array"},{"name":"$position","containerName":"_praepostinsert_array","line":642,"kind":13},{"kind":13,"line":642,"containerName":"_praepostinsert_array","name":"$position"},{"line":642,"kind":13,"containerName":"_praepostinsert_array","name":"$position"},{"kind":13,"line":642,"containerName":"_praepostinsert_array","name":"$end"},{"kind":13,"line":645,"name":"$chain","containerName":"_praepostinsert_array"},{"name":"$position","containerName":"_praepostinsert_array","line":645,"kind":13},{"containerName":"_praepostinsert_array","name":"$elements","definition":"my","localvar":"my","kind":13,"line":651},{"kind":13,"line":652,"containerName":"_praepostinsert_array","name":"$elements_count","definition":"my","localvar":"my"},{"containerName":"_praepostinsert_array","name":"$elements","kind":13,"line":652}],"kind":12},{"name":"cluck","line":630,"kind":12},{"line":653,"kind":13,"containerName":null,"name":"%elements_count"},{"name":"$insertbegin","definition":"my","containerName":null,"localvar":"my","kind":13,"line":657},{"line":657,"kind":13,"name":"$insertend","containerName":null},{"line":657,"kind":12,"name":"_create_chain_elements"},{"kind":13,"line":657,"containerName":null,"name":"$chain"},{"name":"$elements","containerName":null,"line":657,"kind":13},{"name":"$noerror","definition":"my","containerName":null,"localvar":"my","kind":13,"line":666},{"name":"%prae","containerName":null,"line":667,"kind":13},{"kind":13,"line":668,"name":"$position","containerName":null},{"line":668,"kind":13,"name":"%begin","containerName":null},{"line":669,"kind":13,"containerName":null,"name":"$noerror"},{"name":"_join_chain_elements","line":669,"kind":12},{"line":669,"kind":13,"containerName":null,"name":"$chain"},{"line":669,"kind":13,"containerName":null,"name":"$insertend"},{"kind":13,"line":669,"name":"$begin","containerName":null},{"line":670,"kind":13,"containerName":null,"name":"%chain"},{"line":670,"kind":13,"name":"%insertbegin","containerName":null},{"line":672,"kind":13,"name":"$noerror","containerName":null},{"name":"_join_chain_elements","kind":12,"line":672},{"name":"$chain","containerName":null,"line":672,"kind":13},{"name":"up_element","kind":12,"line":672},{"kind":13,"line":672,"name":"$chain","containerName":null},{"containerName":null,"name":"$position","line":672,"kind":13},{"kind":13,"line":672,"name":"$insertbegin","containerName":null},{"kind":13,"line":673,"name":"$noerror","containerName":null},{"line":673,"kind":12,"name":"_join_chain_elements"},{"containerName":null,"name":"$chain","kind":13,"line":673},{"kind":13,"line":673,"containerName":null,"name":"$insertend"},{"kind":13,"line":673,"name":"$position","containerName":null},{"kind":13,"line":675,"name":"%post","containerName":null},{"containerName":null,"name":"$position","kind":13,"line":676},{"name":"%end","containerName":null,"line":676,"kind":13},{"kind":13,"line":677,"containerName":null,"name":"$noerror"},{"name":"_join_chain_elements","line":677,"kind":12},{"kind":13,"line":677,"containerName":null,"name":"$chain"},{"line":677,"kind":13,"name":"$end","containerName":null},{"containerName":null,"name":"$insertbegin","line":677,"kind":13},{"line":678,"kind":13,"containerName":null,"name":"%chain"},{"containerName":null,"name":"%insertend","line":678,"kind":13},{"containerName":null,"name":"$noerror","line":680,"kind":13},{"name":"_join_chain_elements","line":680,"kind":12},{"line":680,"kind":13,"name":"$chain","containerName":null},{"kind":13,"line":680,"name":"$insertend","containerName":null},{"name":"down_element","kind":12,"line":680},{"name":"$chain","containerName":null,"line":680,"kind":13},{"line":680,"kind":13,"containerName":null,"name":"$position"},{"kind":13,"line":681,"name":"$noerror","containerName":null},{"line":681,"kind":12,"name":"_join_chain_elements"},{"kind":13,"line":681,"containerName":null,"name":"$chain"},{"kind":13,"line":681,"containerName":null,"name":"$position"},{"containerName":null,"name":"%insertbegin","kind":13,"line":681},{"containerName":null,"name":"%noerror","kind":13,"line":688},{"kind":13,"line":689,"containerName":null,"name":"$insertbegin"},{"line":689,"kind":13,"containerName":null,"name":"%insertend"},{"range":{"end":{"line":705,"character":9999},"start":{"line":700,"character":0}},"name":"_create_chain_elements","definition":"sub","containerName":"main::","children":[{"line":701,"kind":13,"localvar":"my","definition":"my","name":"$chain","containerName":"_create_chain_elements"},{"kind":13,"line":702,"containerName":"_create_chain_elements","name":"$chain"},{"kind":13,"line":704,"name":"$arrayref","definition":"my","containerName":"_create_chain_elements","localvar":"my"},{"localvar":"my","containerName":"_create_chain_elements","definition":"my","name":"$array_count","line":705,"kind":13},{"line":705,"kind":13,"containerName":"_create_chain_elements","name":"$arrayref"}],"line":700,"kind":12},{"containerName":null,"name":"%array_count","line":706,"kind":13},{"localvar":"my","name":"$begin","definition":"my","containerName":null,"line":708,"kind":13},{"kind":13,"line":708,"name":"%chain","containerName":null},{"localvar":"my","definition":"my","name":"$i","containerName":null,"line":709,"kind":13},{"name":"$begin","containerName":null,"kind":13,"line":709},{"containerName":null,"name":"$element","definition":"my","localvar":"my","kind":13,"line":710},{"name":"$element","containerName":null,"line":711,"kind":13},{"kind":13,"line":711,"containerName":null,"name":"%arrayref"},{"name":"$i","containerName":null,"kind":13,"line":712},{"containerName":null,"name":"%chain","line":713,"kind":13},{"line":713,"kind":13,"containerName":null,"name":"@i"},{"kind":13,"line":713,"name":"$element","containerName":null},{"name":"$i","containerName":null,"line":713,"kind":13},{"containerName":null,"name":"$i","line":713,"kind":13},{"localvar":"my","definition":"my","name":"$end","containerName":null,"line":715,"kind":13},{"line":715,"kind":13,"containerName":null,"name":"$i"},{"kind":13,"line":716,"name":"%chain","containerName":null},{"name":"$i","containerName":null,"line":716,"kind":13},{"name":"%chain","containerName":null,"kind":13,"line":717},{"name":"$end","containerName":null,"line":717,"kind":13},{"kind":13,"line":717,"name":"$begin","containerName":null},{"line":719,"kind":13,"name":"%chain","containerName":null},{"kind":13,"line":719,"name":"@begin","containerName":null},{"containerName":null,"name":"%chain","kind":13,"line":720},{"line":720,"kind":13,"containerName":null,"name":"@end"},{"line":721,"kind":13,"name":"$begin","containerName":null},{"name":"$end","containerName":null,"line":721,"kind":13},{"containerName":"main::","definition":"sub","name":"down_element","range":{"end":{"character":9999,"line":730},"start":{"line":728,"character":0}},"kind":12,"line":728,"children":[]},{"line":729,"kind":12,"name":"_updown_element"},{"kind":12,"line":735,"children":[],"containerName":"main::","definition":"sub","name":"up_element","range":{"end":{"line":737,"character":9999},"start":{"line":735,"character":0}}},{"line":736,"kind":12,"name":"_updown_element"},{"range":{"end":{"line":758,"character":9999},"start":{"character":0,"line":740}},"definition":"sub","name":"_updown_element","containerName":"main::","children":[{"line":741,"kind":13,"localvar":"my","containerName":"_updown_element","name":"$direction","definition":"my"},{"kind":13,"line":742,"name":"$flow","definition":"my","containerName":"_updown_element","localvar":"my"},{"name":"$direction","containerName":"_updown_element","line":743,"kind":13},{"line":744,"kind":13,"containerName":"_updown_element","name":"$flow"},{"line":746,"kind":13,"containerName":"_updown_element","name":"$flow"},{"kind":13,"line":748,"containerName":"_updown_element","name":"$chain","definition":"my","localvar":"my"},{"name":"$chain","containerName":"_updown_element","line":749,"kind":13},{"containerName":"_updown_element","definition":"my","name":"$me","localvar":"my","kind":13,"line":751},{"kind":13,"line":752,"containerName":"_updown_element","name":"$it","definition":"my","localvar":"my"},{"name":"$chain","containerName":"_updown_element","kind":13,"line":752},{"containerName":"_updown_element","name":"$me","kind":13,"line":752},{"containerName":"_updown_element","name":"$flow","line":752,"kind":13},{"line":753,"kind":13,"containerName":"_updown_element","name":"$it"},{"name":"$it","containerName":"_updown_element","kind":13,"line":754}],"line":740,"kind":12},{"containerName":"main::","name":"_is_updownstream","definition":"sub","range":{"start":{"line":761,"character":0},"end":{"character":9999,"line":789}},"kind":12,"line":761,"children":[{"line":762,"kind":13,"localvar":"my","containerName":"_is_updownstream","definition":"my","name":"$direction"},{"kind":13,"line":763,"containerName":"_is_updownstream","definition":"my","name":"$flow","localvar":"my"},{"kind":13,"line":764,"containerName":"_is_updownstream","name":"$direction"},{"kind":13,"line":765,"containerName":"_is_updownstream","name":"$flow"},{"kind":13,"line":767,"containerName":"_is_updownstream","name":"$flow"},{"kind":13,"line":769,"name":"$chain","definition":"my","containerName":"_is_updownstream","localvar":"my"},{"containerName":"_is_updownstream","name":"$chain","kind":13,"line":770},{"kind":13,"line":772,"definition":"my","name":"$first","containerName":"_is_updownstream","localvar":"my"},{"kind":13,"line":773,"containerName":"_is_updownstream","name":"$second","definition":"my","localvar":"my"},{"line":774,"kind":13,"name":"$first","containerName":"_is_updownstream"},{"containerName":"_is_updownstream","name":"$second","line":774,"kind":13},{"line":776,"kind":13,"name":"$chain","containerName":"_is_updownstream"},{"kind":13,"line":776,"name":"$first","containerName":"_is_updownstream"},{"kind":13,"line":778,"name":"$chain","containerName":"_is_updownstream"},{"name":"$second","containerName":"_is_updownstream","line":778,"kind":13},{"definition":"my","name":"$label","containerName":"_is_updownstream","localvar":"my","kind":13,"line":780},{"name":"@array","containerName":"_is_updownstream","kind":13,"line":780},{"kind":13,"line":781,"containerName":"_is_updownstream","name":"$label"},{"kind":13,"line":781,"containerName":"_is_updownstream","name":"$first"},{"kind":13,"line":782,"name":"$found","definition":"my","containerName":"_is_updownstream","localvar":"my"},{"line":783,"kind":13,"name":"$label","containerName":"_is_updownstream"},{"containerName":"_is_updownstream","name":"$found","line":783,"kind":13},{"name":"$label","containerName":"_is_updownstream","kind":13,"line":784},{"kind":13,"line":784,"containerName":"_is_updownstream","name":"$second"},{"line":785,"kind":13,"name":"$found","containerName":"_is_updownstream"},{"line":787,"kind":13,"containerName":"_is_updownstream","name":"@array"},{"line":787,"kind":13,"containerName":"_is_updownstream","name":"$chain"},{"kind":13,"line":787,"name":"$label","containerName":"_is_updownstream"},{"line":788,"kind":13,"containerName":"_is_updownstream","name":"$label"},{"line":788,"kind":13,"containerName":"_is_updownstream","name":"$array"},{"line":788,"kind":13,"containerName":"_is_updownstream","name":"$flow"}]},{"containerName":null,"name":"$found","line":790,"kind":13},{"containerName":"main::","definition":"sub","name":"is_downstream","range":{"start":{"character":0,"line":807},"end":{"line":809,"character":9999}},"kind":12,"line":807,"children":[]},{"range":{"start":{"line":825,"character":0},"end":{"character":9999,"line":827}},"definition":"sub","name":"is_upstream","containerName":"main::","children":[],"line":825,"kind":12},{"containerName":"main::","definition":"sub","name":"check_chain","range":{"start":{"line":843,"character":0},"end":{"character":9999,"line":853}},"kind":12,"line":843,"children":[{"containerName":"check_chain","definition":"my","name":"$chain","localvar":"my","kind":13,"line":844},{"line":845,"kind":13,"containerName":"check_chain","name":"$chain"},{"localvar":"my","containerName":"check_chain","name":"$warnbound","definition":"my","line":847,"kind":13},{"kind":13,"line":847,"name":"$warnsize","containerName":"check_chain"},{"name":"$warnbacklink","containerName":"check_chain","kind":13,"line":847},{"kind":13,"line":847,"containerName":"check_chain","name":"$warnforlink"},{"containerName":"check_chain","name":"$warnbound","line":848,"kind":13},{"line":849,"kind":13,"name":"$warnsize","containerName":"check_chain"},{"name":"$warnbacklink","containerName":"check_chain","line":850,"kind":13},{"line":851,"kind":13,"name":"$warnforlink","containerName":"check_chain"},{"name":"$warnbound","containerName":"check_chain","line":852,"kind":13},{"kind":13,"line":852,"containerName":"check_chain","name":"$warnsize"},{"line":852,"kind":13,"containerName":"check_chain","name":"$warnbacklink"},{"containerName":"check_chain","name":"$warnforlink","line":852,"kind":13}]},{"name":"_boundcheck","line":848,"kind":12},{"name":"_sizecheck","line":849,"kind":12},{"kind":12,"line":850,"name":"_downlinkcheck"},{"name":"_uplinkcheck","kind":12,"line":851},{"children":[],"line":858,"kind":12,"range":{"start":{"line":858,"character":0},"end":{"character":9999,"line":860}},"name":"_uplinkcheck","definition":"sub","containerName":"main::"},{"name":"_updownlinkcheck","kind":12,"line":859},{"line":865,"children":[],"kind":12,"range":{"end":{"line":867,"character":9999},"start":{"character":0,"line":865}},"containerName":"main::","name":"_downlinkcheck","definition":"sub"},{"kind":12,"line":866,"name":"_updownlinkcheck"},{"containerName":"main::","name":"_updownlinkcheck","definition":"sub","range":{"end":{"line":904,"character":9999},"start":{"character":0,"line":872}},"kind":12,"line":872,"children":[{"containerName":"_updownlinkcheck","definition":"my","name":"$direction","localvar":"my","kind":13,"line":873},{"localvar":"my","definition":"my","name":"$flow","containerName":"_updownlinkcheck","line":874,"kind":13},{"name":"$wolf","containerName":"_updownlinkcheck","kind":13,"line":874},{"localvar":"my","name":"$chain","definition":"my","containerName":"_updownlinkcheck","line":875,"kind":13},{"name":"$chain","containerName":"_updownlinkcheck","line":876,"kind":13},{"kind":13,"line":878,"containerName":"_updownlinkcheck","name":"$begin","definition":"my","localvar":"my"},{"containerName":"_updownlinkcheck","name":"$chain","kind":13,"line":878},{"containerName":"_updownlinkcheck","definition":"my","name":"$end","localvar":"my","kind":13,"line":879},{"name":"$chain","containerName":"_updownlinkcheck","kind":13,"line":879},{"kind":13,"line":880,"definition":"my","name":"$label","containerName":"_updownlinkcheck","localvar":"my"},{"containerName":"_updownlinkcheck","name":"@array","kind":13,"line":880},{"kind":13,"line":880,"name":"$me","containerName":"_updownlinkcheck"},{"line":880,"kind":13,"name":"$it","containerName":"_updownlinkcheck"},{"name":"$itpoints","containerName":"_updownlinkcheck","kind":13,"line":880},{"kind":13,"line":881,"containerName":"_updownlinkcheck","name":"$direction"},{"name":"$flow","containerName":"_updownlinkcheck","line":882,"kind":13},{"name":"$wolf","containerName":"_updownlinkcheck","kind":13,"line":883},{"kind":13,"line":884,"containerName":"_updownlinkcheck","name":"$label"},{"kind":13,"line":884,"name":"$end","containerName":"_updownlinkcheck"},{"name":"$flow","containerName":"_updownlinkcheck","line":886,"kind":13},{"line":887,"kind":13,"name":"$wolf","containerName":"_updownlinkcheck"},{"line":888,"kind":13,"containerName":"_updownlinkcheck","name":"$label"},{"name":"$begin","containerName":"_updownlinkcheck","line":888,"kind":13},{"containerName":"_updownlinkcheck","name":"$warncode","definition":"my","localvar":"my","kind":13,"line":890},{"containerName":"_updownlinkcheck","name":"$label","line":892,"kind":13},{"name":"$me","containerName":"_updownlinkcheck","line":893,"kind":13},{"name":"$label","containerName":"_updownlinkcheck","kind":13,"line":893},{"containerName":"_updownlinkcheck","name":"@array","kind":13,"line":894},{"line":894,"kind":13,"containerName":"_updownlinkcheck","name":"$chain"},{"name":"$label","containerName":"_updownlinkcheck","line":894,"kind":13},{"name":"$label","containerName":"_updownlinkcheck","kind":13,"line":895},{"containerName":"_updownlinkcheck","name":"$array","kind":13,"line":895},{"line":895,"kind":13,"name":"$flow","containerName":"_updownlinkcheck"},{"kind":13,"line":896,"name":"$it","containerName":"_updownlinkcheck"},{"containerName":"_updownlinkcheck","name":"$label","kind":13,"line":896},{"line":897,"kind":13,"containerName":"_updownlinkcheck","name":"$it"},{"containerName":"_updownlinkcheck","name":"@array","kind":13,"line":898},{"kind":13,"line":898,"containerName":"_updownlinkcheck","name":"$chain"},{"name":"$label","containerName":"_updownlinkcheck","kind":13,"line":898},{"name":"$itpoints","containerName":"_updownlinkcheck","line":899,"kind":13},{"kind":13,"line":899,"name":"$array","containerName":"_updownlinkcheck"},{"line":899,"kind":13,"name":"$wolf","containerName":"_updownlinkcheck"},{"name":"$me","containerName":"_updownlinkcheck","line":900,"kind":13},{"kind":13,"line":900,"containerName":"_updownlinkcheck","name":"$itpoints"},{"kind":13,"line":902,"containerName":"_updownlinkcheck","name":"$warncode"}]},{"kind":13,"line":906,"name":"$warncode","containerName":null},{"line":912,"children":[{"localvar":"my","containerName":"_sizecheck","definition":"my","name":"$chain","line":913,"kind":13},{"name":"$chain","containerName":"_sizecheck","kind":13,"line":914},{"localvar":"my","name":"$begin","definition":"my","containerName":"_sizecheck","line":916,"kind":13},{"kind":13,"line":916,"name":"$chain","containerName":"_sizecheck"},{"kind":13,"line":917,"name":"$warncode","definition":"my","containerName":"_sizecheck","localvar":"my"},{"localvar":"my","definition":"my","name":"$label","containerName":"_sizecheck","line":918,"kind":13},{"kind":13,"line":918,"name":"@array","containerName":"_sizecheck"},{"kind":13,"line":919,"definition":"my","name":"$size","containerName":"_sizecheck","localvar":"my"},{"containerName":"_sizecheck","name":"$chain","line":919,"kind":13},{"line":920,"kind":13,"localvar":"my","definition":"my","name":"$count","containerName":"_sizecheck"},{"line":921,"kind":13,"containerName":"_sizecheck","name":"$label"},{"line":921,"kind":13,"name":"$begin","containerName":"_sizecheck"},{"name":"$label","containerName":"_sizecheck","kind":13,"line":922},{"line":923,"kind":13,"containerName":"_sizecheck","name":"@array"},{"containerName":"_sizecheck","name":"$chain","kind":13,"line":923},{"line":923,"kind":13,"containerName":"_sizecheck","name":"$label"},{"kind":13,"line":924,"name":"$label","containerName":"_sizecheck"},{"line":924,"kind":13,"name":"$array","containerName":"_sizecheck"},{"containerName":"_sizecheck","name":"$count","line":925,"kind":13}],"kind":12,"range":{"start":{"character":0,"line":912},"end":{"character":9999,"line":926}},"containerName":"main::","name":"_sizecheck","definition":"sub"},{"containerName":null,"name":"$size","line":927,"kind":13},{"containerName":null,"name":"%count","line":927,"kind":13},{"containerName":null,"name":"$warncode","line":929,"kind":13},{"name":"$warncode","containerName":null,"line":931,"kind":13},{"kind":12,"line":938,"children":[{"kind":13,"line":939,"name":"$chain","definition":"my","containerName":"_boundcheck","localvar":"my"},{"name":"$chain","containerName":"_boundcheck","line":940,"kind":13},{"localvar":"my","containerName":"_boundcheck","name":"$begin","definition":"my","line":942,"kind":13},{"line":942,"kind":13,"name":"$chain","containerName":"_boundcheck"},{"localvar":"my","definition":"my","name":"$end","containerName":"_boundcheck","line":943,"kind":13},{"kind":13,"line":943,"name":"$chain","containerName":"_boundcheck"},{"containerName":"_boundcheck","definition":"my","name":"$warncode","localvar":"my","kind":13,"line":944},{"containerName":"_boundcheck","name":"$begin","kind":13,"line":947},{"line":947,"kind":13,"containerName":"_boundcheck","name":"$chain"},{"name":"$begin","containerName":"_boundcheck","line":947,"kind":13},{"containerName":"_boundcheck","name":"$chain","line":948,"kind":13},{"kind":13,"line":948,"name":"$begin","containerName":"_boundcheck"},{"line":952,"kind":13,"containerName":"_boundcheck","name":"$warncode"},{"line":957,"kind":13,"containerName":"_boundcheck","name":"$warncode"},{"kind":13,"line":960,"containerName":"_boundcheck","name":"$end"},{"kind":13,"line":960,"name":"$chain","containerName":"_boundcheck"},{"kind":13,"line":960,"containerName":"_boundcheck","name":"$end"},{"line":961,"kind":13,"containerName":"_boundcheck","name":"$chain"},{"containerName":"_boundcheck","name":"$end","kind":13,"line":961},{"containerName":"_boundcheck","name":"$warncode","line":965,"kind":13},{"kind":13,"line":970,"name":"$warncode","containerName":"_boundcheck"},{"kind":13,"line":972,"name":"$warncode","containerName":"_boundcheck"}],"containerName":"main::","name":"_boundcheck","definition":"sub","range":{"end":{"character":9999,"line":973},"start":{"character":0,"line":938}}},{"containerName":"main::","name":"chain_length","definition":"sub","range":{"end":{"line":988,"character":9999},"start":{"line":978,"character":0}},"kind":12,"line":978,"children":[{"kind":13,"line":979,"containerName":"chain_length","name":"$chain","definition":"my","localvar":"my"},{"name":"$chain","containerName":"chain_length","line":980,"kind":13},{"localvar":"my","containerName":"chain_length","definition":"my","name":"$size","line":982,"kind":13},{"line":982,"kind":13,"name":"$chain","containerName":"chain_length"},{"name":"$size","containerName":"chain_length","kind":13,"line":983},{"line":984,"kind":13,"name":"$size","containerName":"chain_length"}]},{"range":{"end":{"character":9999,"line":1008},"start":{"line":992,"character":0}},"definition":"sub","name":"_join_chain_elements","containerName":"main::","children":[{"kind":13,"line":993,"containerName":"_join_chain_elements","name":"$chain","definition":"my","localvar":"my"},{"kind":13,"line":994,"name":"$chain","containerName":"_join_chain_elements"},{"localvar":"my","definition":"my","name":"$leftelem","containerName":"_join_chain_elements","line":996,"kind":13},{"kind":13,"line":997,"containerName":"_join_chain_elements","name":"$rightelem","definition":"my","localvar":"my"},{"name":"$leftelem","containerName":"_join_chain_elements","line":998,"kind":13},{"line":998,"kind":13,"name":"$rightelem","containerName":"_join_chain_elements"},{"containerName":"_join_chain_elements","name":"$chain","line":1000,"kind":13},{"line":1000,"kind":13,"containerName":"_join_chain_elements","name":"$leftelem"},{"kind":13,"line":1000,"containerName":"_join_chain_elements","name":"$chain"},{"line":1000,"kind":13,"name":"$rightelem","containerName":"_join_chain_elements"},{"kind":13,"line":1001,"name":"$chain","containerName":"_join_chain_elements"},{"containerName":"_join_chain_elements","name":"$leftelem","kind":13,"line":1001},{"line":1001,"kind":13,"containerName":"_join_chain_elements","name":"$rightelem"},{"kind":13,"line":1002,"name":"$chain","containerName":"_join_chain_elements"},{"kind":13,"line":1002,"name":"$rightelem","containerName":"_join_chain_elements"},{"name":"$leftelem","containerName":"_join_chain_elements","line":1002,"kind":13}],"line":992,"kind":12},{"name":"splice_chain","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":1025},"end":{"character":9999,"line":1069}},"kind":12,"children":[{"kind":13,"line":1026,"containerName":"splice_chain","name":"$chain","definition":"my","localvar":"my"},{"name":"$chain","containerName":"splice_chain","kind":13,"line":1027},{"kind":13,"line":1029,"containerName":"splice_chain","definition":"my","name":"$begin","localvar":"my"},{"line":1029,"kind":13,"containerName":"splice_chain","name":"$chain"},{"kind":13,"line":1030,"name":"$end","definition":"my","containerName":"splice_chain","localvar":"my"},{"containerName":"splice_chain","name":"$chain","line":1030,"kind":13},{"kind":13,"line":1031,"definition":"my","name":"$first","containerName":"splice_chain","localvar":"my"},{"containerName":"splice_chain","name":"$first","line":1032,"kind":13},{"kind":13,"line":1032,"containerName":"splice_chain","name":"$first"},{"kind":13,"line":1032,"name":"$first","containerName":"splice_chain"},{"containerName":"splice_chain","name":"$begin","line":1032,"kind":13},{"localvar":"my","definition":"my","name":"$len","containerName":"splice_chain","line":1033,"kind":13},{"line":1034,"kind":13,"localvar":"my","definition":"my","name":"$last","containerName":"splice_chain"},{"kind":13,"line":1035,"containerName":"splice_chain","definition":"my","name":"@array","localvar":"my"},{"name":"$string","containerName":"splice_chain","kind":13,"line":1035},{"localvar":"my","containerName":"splice_chain","name":"$beforecut","definition":"my","line":1036,"kind":13},{"line":1036,"kind":13,"containerName":"splice_chain","name":"$aftercut"},{"containerName":"splice_chain","name":"$chain","kind":13,"line":1038},{"line":1038,"kind":13,"name":"$first","containerName":"splice_chain"},{"kind":13,"line":1040,"containerName":"splice_chain","name":"$last"},{"kind":13,"line":1041,"name":"$chain","containerName":"splice_chain"},{"line":1041,"kind":13,"name":"$last","containerName":"splice_chain"},{"containerName":"splice_chain","name":"$len","kind":13,"line":1043},{"kind":13,"line":1045,"name":"$len","containerName":"splice_chain"},{"kind":13,"line":1048,"name":"$last","containerName":"splice_chain"},{"name":"$end","containerName":"splice_chain","kind":13,"line":1048},{"containerName":"splice_chain","name":"$beforecut","line":1051,"kind":13},{"line":1051,"kind":13,"name":"$chain","containerName":"splice_chain"},{"line":1051,"kind":13,"name":"$first","containerName":"splice_chain"},{"line":1054,"kind":13,"localvar":"my","name":"$i","definition":"my","containerName":"splice_chain"},{"localvar":"my","definition":"my","name":"$label","containerName":"splice_chain","line":1055,"kind":13},{"line":1055,"kind":13,"name":"$first","containerName":"splice_chain"},{"kind":13,"line":1056,"definition":"my","name":"$afterlast","containerName":"splice_chain","localvar":"my"},{"line":1056,"kind":13,"containerName":"splice_chain","name":"$chain"},{"line":1056,"kind":13,"name":"$last","containerName":"splice_chain"},{"name":"$afterlast","containerName":"splice_chain","kind":13,"line":1057},{"kind":13,"line":1057,"containerName":"splice_chain","name":"$afterlast"},{"line":1061,"kind":13,"containerName":"splice_chain","name":"$label"},{"containerName":"splice_chain","name":"$label","kind":13,"line":1061},{"name":"$afterlast","containerName":"splice_chain","line":1061,"kind":13},{"kind":13,"line":1061,"name":"$i","containerName":"splice_chain"},{"kind":13,"line":1061,"name":"$len","containerName":"splice_chain"},{"name":"$i","containerName":"splice_chain","line":1061,"kind":13},{"name":"@array","containerName":"splice_chain","line":1062,"kind":13},{"line":1062,"kind":13,"containerName":"splice_chain","name":"$chain"},{"kind":13,"line":1062,"name":"$label","containerName":"splice_chain"},{"line":1063,"kind":13,"name":"$string","containerName":"splice_chain"},{"containerName":"splice_chain","name":"$array","kind":13,"line":1063},{"name":"$aftercut","containerName":"splice_chain","line":1064,"kind":13},{"containerName":"splice_chain","name":"$array","line":1064,"kind":13},{"name":"$chain","containerName":"splice_chain","kind":13,"line":1066},{"line":1066,"kind":13,"containerName":"splice_chain","name":"$label"},{"name":"$label","containerName":"splice_chain","kind":13,"line":1067},{"line":1067,"kind":13,"name":"$aftercut","containerName":"splice_chain"},{"kind":13,"line":1068,"name":"$i","containerName":"splice_chain"}],"line":1025},{"name":"%beforecut","containerName":null,"kind":13,"line":1075},{"name":"%aftercut","containerName":null,"kind":13,"line":1076},{"name":"$chain","containerName":null,"kind":13,"line":1077},{"kind":13,"line":1077,"containerName":null,"name":"$beforecut"},{"name":"%aftercut","containerName":null,"kind":13,"line":1077},{"name":"%chain","containerName":null,"kind":13,"line":1079},{"kind":13,"line":1079,"containerName":null,"name":"$beforecut"},{"line":1080,"kind":13,"containerName":null,"name":"%chain"},{"kind":13,"line":1080,"containerName":null,"name":"@beforecut"},{"name":"%aftercut","containerName":null,"kind":13,"line":1083},{"line":1084,"kind":13,"containerName":null,"name":"%chain"},{"containerName":null,"name":"$aftercut","kind":13,"line":1084},{"name":"%chain","containerName":null,"line":1085,"kind":13},{"name":"@aftercut","containerName":null,"line":1085,"kind":13},{"name":"%chain","containerName":null,"line":1087,"kind":13},{"name":"%chain","containerName":null,"kind":13,"line":1088},{"line":1091,"kind":13,"name":"%chain","containerName":null},{"line":1091,"kind":13,"name":"%chain","containerName":null},{"line":1091,"kind":13,"name":"$i","containerName":null},{"kind":13,"line":1093,"containerName":null,"name":"$string"},{"range":{"end":{"line":1166,"character":9999},"start":{"character":0,"line":1163}},"definition":"sub","name":"chain2string_verbose","containerName":"main::","children":[],"line":1163,"kind":12},{"name":"carp","line":1164,"kind":12},{"name":"old_down_chain2string_verbose","line":1165,"kind":12},{"kind":12,"children":[],"line":1167,"definition":"sub","name":"up_chain2string_verbose","containerName":"main::","range":{"start":{"character":0,"line":1167},"end":{"line":1170,"character":9999}}},{"line":1168,"kind":12,"name":"carp"},{"kind":12,"line":1169,"name":"old_up_chain2string"},{"range":{"start":{"character":0,"line":1171},"end":{"character":9999,"line":1174}},"definition":"sub","name":"down_chain2string_verbose","containerName":"main::","children":[],"line":1171,"kind":12},{"name":"carp","kind":12,"line":1172},{"name":"old_down_chain2string","line":1173,"kind":12},{"children":[],"line":1180,"kind":12,"range":{"start":{"line":1180,"character":0},"end":{"character":9999,"line":1182}},"definition":"sub","name":"old_up_chain2string","containerName":"main::"},{"line":1181,"kind":12,"name":"old_updown_chain2string"},{"range":{"end":{"character":9999,"line":1185},"start":{"character":0,"line":1183}},"containerName":"main::","name":"old_down_chain2string","definition":"sub","line":1183,"children":[],"kind":12},{"kind":12,"line":1184,"name":"old_updown_chain2string"},{"line":1200,"children":[{"kind":13,"line":1201,"containerName":"old_updown_chain2string","name":"$direction","definition":"my","localvar":"my"},{"line":1201,"kind":13,"containerName":"old_updown_chain2string","name":"$chain"},{"line":1201,"kind":13,"name":"$first","containerName":"old_updown_chain2string"},{"kind":13,"line":1201,"containerName":"old_updown_chain2string","name":"$len"},{"line":1201,"kind":13,"containerName":"old_updown_chain2string","name":"$last"},{"name":"$option","containerName":"old_updown_chain2string","kind":13,"line":1201},{"kind":13,"line":1202,"containerName":"old_updown_chain2string","name":"$chain"},{"kind":13,"line":1204,"containerName":"old_updown_chain2string","name":"$begin","definition":"my","localvar":"my"},{"containerName":"old_updown_chain2string","name":"$chain","line":1204,"kind":13},{"line":1205,"kind":13,"localvar":"my","containerName":"old_updown_chain2string","definition":"my","name":"$end"},{"name":"$chain","containerName":"old_updown_chain2string","kind":13,"line":1205},{"containerName":"old_updown_chain2string","definition":"my","name":"$flow","localvar":"my","kind":13,"line":1206},{"line":1207,"kind":13,"name":"$direction","containerName":"old_updown_chain2string"},{"containerName":"old_updown_chain2string","name":"$flow","kind":13,"line":1208},{"name":"$first","containerName":"old_updown_chain2string","line":1209,"kind":13},{"containerName":"old_updown_chain2string","name":"$first","kind":13,"line":1209},{"containerName":"old_updown_chain2string","name":"$end","line":1209,"kind":13},{"name":"$flow","containerName":"old_updown_chain2string","kind":13,"line":1211},{"kind":13,"line":1212,"containerName":"old_updown_chain2string","name":"$first"},{"kind":13,"line":1212,"containerName":"old_updown_chain2string","name":"$first"},{"containerName":"old_updown_chain2string","name":"$begin","kind":13,"line":1212},{"line":1215,"kind":13,"name":"$chain","containerName":"old_updown_chain2string"},{"kind":13,"line":1215,"containerName":"old_updown_chain2string","name":"$first"},{"line":1217,"kind":13,"containerName":"old_updown_chain2string","name":"$last"},{"kind":13,"line":1218,"name":"$chain","containerName":"old_updown_chain2string"},{"containerName":"old_updown_chain2string","name":"$last","line":1218,"kind":13},{"kind":13,"line":1220,"containerName":"old_updown_chain2string","name":"$len"},{"line":1222,"kind":13,"name":"$len","containerName":"old_updown_chain2string"},{"containerName":"old_updown_chain2string","name":"$direction","kind":13,"line":1225},{"name":"$last","containerName":"old_updown_chain2string","kind":13,"line":1226},{"containerName":"old_updown_chain2string","name":"$begin","kind":13,"line":1226},{"line":1228,"kind":13,"containerName":"old_updown_chain2string","name":"$last"},{"kind":13,"line":1228,"name":"$end","containerName":"old_updown_chain2string"},{"line":1231,"kind":13,"localvar":"my","name":"@array","definition":"my","containerName":"old_updown_chain2string"},{"kind":13,"line":1231,"containerName":"old_updown_chain2string","name":"$string"},{"line":1231,"kind":13,"containerName":"old_updown_chain2string","name":"$count"},{"containerName":"old_updown_chain2string","name":"$verbose","definition":"my","localvar":"my","kind":13,"line":1233},{"line":1233,"kind":13,"localvar":"my","name":"$elements","definition":"my","containerName":"old_updown_chain2string"},{"containerName":"old_updown_chain2string","definition":"my","name":"@elements","localvar":"my","kind":13,"line":1233},{"localvar":"my","containerName":"old_updown_chain2string","name":"$counting","definition":"my","line":1233,"kind":13},{"containerName":"old_updown_chain2string","name":"$option","line":1234,"kind":13},{"line":1235,"kind":13,"containerName":"old_updown_chain2string","name":"$option"},{"name":"$verbose","containerName":"old_updown_chain2string","line":1235,"kind":13},{"kind":13,"line":1236,"containerName":"old_updown_chain2string","name":"$option"},{"containerName":"old_updown_chain2string","name":"$elements","line":1236,"kind":13},{"containerName":"old_updown_chain2string","name":"$option","line":1237,"kind":13},{"line":1237,"kind":13,"containerName":"old_updown_chain2string","name":"$counting"},{"name":"$verbose","containerName":"old_updown_chain2string","line":1240,"kind":13},{"kind":13,"line":1245,"name":"$i","definition":"my","containerName":"old_updown_chain2string","localvar":"my"},{"localvar":"my","containerName":"old_updown_chain2string","definition":"my","name":"$label","line":1246,"kind":13},{"kind":13,"line":1246,"name":"$first","containerName":"old_updown_chain2string"},{"kind":13,"line":1247,"name":"$afterlast","definition":"my","containerName":"old_updown_chain2string","localvar":"my"},{"containerName":"old_updown_chain2string","name":"$chain","line":1247,"kind":13},{"line":1247,"kind":13,"name":"$last","containerName":"old_updown_chain2string"},{"line":1247,"kind":13,"name":"$flow","containerName":"old_updown_chain2string"},{"kind":13,"line":1248,"name":"$afterlast","containerName":"old_updown_chain2string"},{"kind":13,"line":1248,"containerName":"old_updown_chain2string","name":"$afterlast"},{"name":"$label","containerName":"old_updown_chain2string","kind":13,"line":1252},{"kind":13,"line":1252,"containerName":"old_updown_chain2string","name":"$label"},{"name":"$afterlast","containerName":"old_updown_chain2string","line":1252,"kind":13},{"kind":13,"line":1252,"containerName":"old_updown_chain2string","name":"$i"},{"name":"$len","containerName":"old_updown_chain2string","line":1252,"kind":13},{"line":1252,"kind":13,"name":"$i","containerName":"old_updown_chain2string"},{"name":"@array","containerName":"old_updown_chain2string","kind":13,"line":1253},{"containerName":"old_updown_chain2string","name":"$chain","line":1253,"kind":13},{"line":1253,"kind":13,"name":"$label","containerName":"old_updown_chain2string"},{"line":1254,"kind":13,"containerName":"old_updown_chain2string","name":"$verbose"},{"containerName":"old_updown_chain2string","name":"$string","line":1255,"kind":13},{"kind":13,"line":1256,"containerName":"old_updown_chain2string","name":"$count"},{"kind":13,"line":1257,"containerName":"old_updown_chain2string","name":"$elements"},{"containerName":"old_updown_chain2string","name":"@elements","kind":13,"line":1258},{"line":1258,"kind":13,"name":"$label","containerName":"old_updown_chain2string"},{"name":"$counting","containerName":"old_updown_chain2string","line":1259,"kind":13},{"kind":13,"line":1260,"name":"$count","containerName":"old_updown_chain2string"},{"name":"$string","containerName":"old_updown_chain2string","line":1262,"kind":13},{"kind":13,"line":1262,"containerName":"old_updown_chain2string","name":"$array"},{"line":1264,"kind":13,"containerName":"old_updown_chain2string","name":"$label"},{"containerName":"old_updown_chain2string","name":"$array","line":1264,"kind":13},{"containerName":"old_updown_chain2string","name":"$flow","line":1264,"kind":13},{"line":1265,"kind":13,"containerName":"old_updown_chain2string","name":"$i"}],"kind":12,"detail":"($direction,$chain,$first,$len,$last,$option)","signature":{"parameters":[{"label":"$direction"},{"label":"$chain"},{"label":"$first"},{"label":"$len"},{"label":"$last"},{"label":"$option"}],"documentation":" common to up_chain2string and down_chain2string\n arguments: \"up\"||\"down\" chain_ref [first] [len] [last] [option]\n [option] can be any of \"verbose\", \"counting\", \"elements\"\n error: return -1\n defaults: start = first element; if len undef, goes to last\n           if last undef, goes to end\n           if last def it overrides len (that gets undef)\n returns: a string\n example usage: down_chain2string($chain) -> all the chain from begin to end\n example usage: down_chain2string($chain,6) -> from 6 to the end\n example usage: down_chain2string($chain,6,4) -> from 6, going on 4 elements\n example usage: down_chain2string($chain,6,\"\",10) -> from 6 to 10\n example usage: up_chain2string($chain,10,\"\",6) -> from 10 to 6 upstream","label":"old_updown_chain2string($direction,$chain,$first,$len,$last,$option)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":1200},"end":{"line":1266,"character":9999}},"name":"old_updown_chain2string"},{"containerName":null,"name":"%verbose","kind":13,"line":1268},{"name":"%counting","containerName":null,"line":1269,"kind":13},{"line":1270,"kind":13,"containerName":null,"name":"$count"},{"line":1271,"kind":13,"name":"%elements","containerName":null},{"line":1272,"kind":13,"name":"@elements","containerName":null},{"containerName":null,"name":"$string","kind":13,"line":1274},{"range":{"start":{"character":0,"line":1290},"end":{"character":9999,"line":1293}},"name":"string2chain","definition":"sub","containerName":"main::","children":[{"line":1291,"kind":13,"localvar":"my","definition":"my","name":"@string","containerName":"string2chain"},{"name":"@string","containerName":"string2chain","line":1292,"kind":13}],"line":1290,"kind":12},{"kind":12,"line":1292,"name":"array2chain"},{"range":{"start":{"character":0,"line":1309},"end":{"character":9999,"line":1311}},"containerName":"main::","definition":"sub","name":"array2chain","line":1309,"children":[{"line":1310,"kind":13,"localvar":"my","containerName":"array2chain","definition":"my","name":"$arrayref"},{"kind":13,"line":1311,"definition":"my","name":"$array_count","containerName":"array2chain","localvar":"my"},{"line":1311,"kind":13,"name":"$arrayref","containerName":"array2chain"}],"kind":12},{"containerName":null,"name":"%array_count","line":1312,"kind":13},{"localvar":"my","containerName":null,"name":"@begin","definition":"my","line":1314,"kind":13},{"name":"%begin","containerName":null,"kind":13,"line":1315},{"kind":13,"line":1316,"name":"%begin","containerName":null},{"kind":13,"line":1319,"name":"$begin","containerName":null},{"line":1321,"kind":13,"localvar":"my","name":"$element","definition":"my","containerName":null},{"name":"%hash","containerName":null,"line":1321,"kind":13},{"name":"%hash","containerName":null,"kind":13,"line":1322},{"line":1322,"kind":13,"name":"$begin","containerName":null},{"name":"$i","definition":"my","containerName":null,"localvar":"my","kind":13,"line":1323},{"kind":13,"line":1323,"name":"$begin","containerName":null},{"containerName":null,"name":"$element","line":1324,"kind":13},{"name":"%arrayref","containerName":null,"kind":13,"line":1324},{"name":"$i","containerName":null,"kind":13,"line":1325},{"containerName":null,"name":"%hash","kind":13,"line":1327},{"name":"@i","containerName":null,"line":1327,"kind":13},{"line":1327,"kind":13,"name":"$element","containerName":null},{"kind":13,"line":1327,"name":"$i","containerName":null},{"line":1327,"kind":13,"containerName":null,"name":"$i"},{"containerName":null,"definition":"my","name":"$end","localvar":"my","kind":13,"line":1329},{"kind":13,"line":1329,"name":"$i","containerName":null},{"kind":13,"line":1330,"name":"%hash","containerName":null},{"line":1330,"kind":13,"containerName":null,"name":"$end"},{"kind":13,"line":1331,"containerName":null,"name":"%hash"},{"name":"firstfree","kind":12,"line":1331},{"name":"$i","containerName":null,"kind":13,"line":1331},{"name":"%hash","containerName":null,"line":1332,"kind":13},{"line":1332,"kind":12,"name":"size"},{"containerName":null,"name":"$end","line":1332,"kind":13},{"line":1332,"kind":13,"containerName":null,"name":"$begin"},{"name":"%hash","containerName":null,"line":1335,"kind":13},{"line":1335,"kind":13,"containerName":null,"name":"@begin"},{"name":"%hash","containerName":null,"line":1336,"kind":13},{"kind":13,"line":1336,"name":"@end","containerName":null},{"containerName":null,"name":"%hash","line":1338,"kind":13}],"version":5}