{"vars":[{"line":113,"kind":2,"containerName":"","name":"base"},{"definition":"sub","name":"_version","containerName":"main::","range":{"end":{"character":9999,"line":116},"start":{"line":115,"character":0}},"kind":12,"children":[],"line":115},{"range":{"end":{"line":148,"character":9999},"start":{"character":0,"line":142}},"name":"new","line":142,"children":[{"localvar":"my","containerName":"new","definition":"my","name":"$class","line":144,"kind":13},{"line":144,"kind":13,"containerName":"new","name":"@args"},{"kind":13,"line":146,"containerName":"new","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":146,"containerName":"new","name":"$class"},{"name":"@args","containerName":"new","kind":13,"line":146}],"kind":12,"detail":"($class,@args)","signature":{"documentation":"1;\n# $Id: Stockholm.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Index::Stockholm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields@uiuc.edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::Stockholm - Indexes Stockholm format alignments (such as those from\nPfam and Rfam.  Retrieves raw stream data using the ID or a Bio::SimpleAlign\n(via Bio::AlignIO)\n\n=head1 SYNOPSIS\n\n    use strict;\n    use Bio::Index::Stockholm;\n    my ($indexfile,$file1,$file2,$query);\n    my $index = Bio::Index::Stockholm->new(-filename => $indexfile,\n\t\t\t\t                          -write_flag => 1);\n    $index->make_index($file1,$file2);\n\n    # get raw data stream starting at alignment position\n    my $fh = $index->get_stream($query);\n\n    # fetch individual alignment\n    my $align = $index->fetch_aln($query); # alias for fetch_report\n    my $align = $index->fetch_report($query); # same as above\n    print \"query is \", $align->display_id, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis object allows one to build an index for any file (or files)\ncontaining Stockholm alignment format (such as Rfam and Pfam) and provides\nquick access to the alignment based on the alignment ID.\n\nThis also allows for ID parsing using a callback:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /^>.+gi\\|(\\d+)/;\n      $1;\n   }\n\nThe indexer is capable of indexing based on multiple IDs passed back from the\ncallback; this is assuming of course all IDs are unique.  The default is to use\nthe alignment ID provided for Rfam/Pfam output.\n\nNote: for best results 'use strict'.\n\n=head1 TODO\n\n- allow using an alternative regex for indexing (for instance, the ID instead of AC)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Index::Stockholm;\nuse strict;\nuse Bio::AlignIO;\n\nuse base qw(Bio::Index::Abstract Bio::Root::Root);\n\nsub _version {\n\treturn ${Bio::Root::Version::VERSION};\n}\n\n=head2 new\n\n  Usage   : $index = Bio::Index::Abstract->new(\n                -filename    => $dbm_file,\n                -write_flag  => 0,\n                -dbm_package => 'DB_File',\n                -verbose     => 0);\n\n  Function: Returns a new index object.  If filename is\n            specified, then open_dbm() is immediately called. \n            Bio::Index::Abstract->new() will usually be called\n            directly only when opening an existing index.\n  Returns : A new index object\n  Args    : -filename    The name of the dbm index file.\n            -write_flag  TRUE if write access to the dbm file is\n                         needed.\n            -dbm_package The Perl dbm module to use for the\n                         index.\n            -verbose     Print debugging output to STDERR if\n                         TRUE.","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"containerName":"main::","definition":"sub"},{"line":144,"kind":12,"containerName":"Root::Version::VERSION","name":"Bio"},{"kind":12,"line":146,"name":"SUPER","containerName":"new"},{"line":165,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"fetch_report","line":166,"kind":13},{"line":166,"kind":13,"containerName":"fetch_report","name":"$id"},{"containerName":"fetch_report","name":"$fh","definition":"my","localvar":"my","kind":13,"line":167},{"containerName":"fetch_report","name":"$self","kind":13,"line":167},{"line":167,"kind":12,"containerName":"fetch_report","name":"get_stream"},{"line":167,"kind":13,"name":"$id","containerName":"fetch_report"},{"definition":"my","name":"$report","containerName":"fetch_report","localvar":"my","kind":13,"line":168},{"line":168,"kind":12,"containerName":"fetch_report","name":"new"},{"containerName":"fetch_report","name":"$fh","kind":13,"line":170},{"name":"$report","containerName":"fetch_report","kind":13,"line":171},{"name":"next_aln","containerName":"fetch_report","line":171,"kind":12}],"kind":12,"detail":"($self,$id)","signature":{"parameters":[{"label":"$self"},{"label":"$id"}],"documentation":"1;\n# $Id: Stockholm.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Index::Stockholm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields@uiuc.edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::Stockholm - Indexes Stockholm format alignments (such as those from\nPfam and Rfam.  Retrieves raw stream data using the ID or a Bio::SimpleAlign\n(via Bio::AlignIO)\n\n=head1 SYNOPSIS\n\n    use strict;\n    use Bio::Index::Stockholm;\n    my ($indexfile,$file1,$file2,$query);\n    my $index = Bio::Index::Stockholm->new(-filename => $indexfile,\n\t\t\t\t                          -write_flag => 1);\n    $index->make_index($file1,$file2);\n\n    # get raw data stream starting at alignment position\n    my $fh = $index->get_stream($query);\n\n    # fetch individual alignment\n    my $align = $index->fetch_aln($query); # alias for fetch_report\n    my $align = $index->fetch_report($query); # same as above\n    print \"query is \", $align->display_id, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis object allows one to build an index for any file (or files)\ncontaining Stockholm alignment format (such as Rfam and Pfam) and provides\nquick access to the alignment based on the alignment ID.\n\nThis also allows for ID parsing using a callback:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /^>.+gi\\|(\\d+)/;\n      $1;\n   }\n\nThe indexer is capable of indexing based on multiple IDs passed back from the\ncallback; this is assuming of course all IDs are unique.  The default is to use\nthe alignment ID provided for Rfam/Pfam output.\n\nNote: for best results 'use strict'.\n\n=head1 TODO\n\n- allow using an alternative regex for indexing (for instance, the ID instead of AC)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Index::Stockholm;\nuse strict;\nuse Bio::AlignIO;\n\nuse base qw(Bio::Index::Abstract Bio::Root::Root);\n\nsub _version {\n\treturn ${Bio::Root::Version::VERSION};\n}\n\n=head2 new\n\n  Usage   : $index = Bio::Index::Abstract->new(\n                -filename    => $dbm_file,\n                -write_flag  => 0,\n                -dbm_package => 'DB_File',\n                -verbose     => 0);\n\n  Function: Returns a new index object.  If filename is\n            specified, then open_dbm() is immediately called. \n            Bio::Index::Abstract->new() will usually be called\n            directly only when opening an existing index.\n  Returns : A new index object\n  Args    : -filename    The name of the dbm index file.\n            -write_flag  TRUE if write access to the dbm file is\n                         needed.\n            -dbm_package The Perl dbm module to use for the\n                         index.\n            -verbose     Print debugging output to STDERR if\n                         TRUE.\n\n\nsub new {\n\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n}\n\n=head2 Bio::Index::Stockholm implemented methods\n\n\n=head2 fetch_report\n\n Title   : fetch_report\n Usage   : my $align = $idx->fetch_report($id);\n Function: Returns a Bio::SimpleAlign object \n           for a specific alignment\n Returns : Bio::SimpleAlign\n Args    : valid id","label":"fetch_report($self,$id)"},"containerName":"main::","definition":"sub","range":{"start":{"line":165,"character":0},"end":{"character":9999,"line":172}},"name":"fetch_report"},{"kind":12,"line":168,"name":"Bio","containerName":"AlignIO"},{"name":"_index_file","range":{"end":{"character":9999,"line":230},"start":{"character":0,"line":205}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$file"},{"label":"$i"}],"documentation":"1;\n# $Id: Stockholm.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Index::Stockholm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields@uiuc.edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::Stockholm - Indexes Stockholm format alignments (such as those from\nPfam and Rfam.  Retrieves raw stream data using the ID or a Bio::SimpleAlign\n(via Bio::AlignIO)\n\n=head1 SYNOPSIS\n\n    use strict;\n    use Bio::Index::Stockholm;\n    my ($indexfile,$file1,$file2,$query);\n    my $index = Bio::Index::Stockholm->new(-filename => $indexfile,\n\t\t\t\t                          -write_flag => 1);\n    $index->make_index($file1,$file2);\n\n    # get raw data stream starting at alignment position\n    my $fh = $index->get_stream($query);\n\n    # fetch individual alignment\n    my $align = $index->fetch_aln($query); # alias for fetch_report\n    my $align = $index->fetch_report($query); # same as above\n    print \"query is \", $align->display_id, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis object allows one to build an index for any file (or files)\ncontaining Stockholm alignment format (such as Rfam and Pfam) and provides\nquick access to the alignment based on the alignment ID.\n\nThis also allows for ID parsing using a callback:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /^>.+gi\\|(\\d+)/;\n      $1;\n   }\n\nThe indexer is capable of indexing based on multiple IDs passed back from the\ncallback; this is assuming of course all IDs are unique.  The default is to use\nthe alignment ID provided for Rfam/Pfam output.\n\nNote: for best results 'use strict'.\n\n=head1 TODO\n\n- allow using an alternative regex for indexing (for instance, the ID instead of AC)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Index::Stockholm;\nuse strict;\nuse Bio::AlignIO;\n\nuse base qw(Bio::Index::Abstract Bio::Root::Root);\n\nsub _version {\n\treturn ${Bio::Root::Version::VERSION};\n}\n\n=head2 new\n\n  Usage   : $index = Bio::Index::Abstract->new(\n                -filename    => $dbm_file,\n                -write_flag  => 0,\n                -dbm_package => 'DB_File',\n                -verbose     => 0);\n\n  Function: Returns a new index object.  If filename is\n            specified, then open_dbm() is immediately called. \n            Bio::Index::Abstract->new() will usually be called\n            directly only when opening an existing index.\n  Returns : A new index object\n  Args    : -filename    The name of the dbm index file.\n            -write_flag  TRUE if write access to the dbm file is\n                         needed.\n            -dbm_package The Perl dbm module to use for the\n                         index.\n            -verbose     Print debugging output to STDERR if\n                         TRUE.\n\n\nsub new {\n\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n}\n\n=head2 Bio::Index::Stockholm implemented methods\n\n\n=head2 fetch_report\n\n Title   : fetch_report\n Usage   : my $align = $idx->fetch_report($id);\n Function: Returns a Bio::SimpleAlign object \n           for a specific alignment\n Returns : Bio::SimpleAlign\n Args    : valid id\n\n\nsub fetch_report{\n\tmy ($self,$id) = @_;\n\tmy $fh = $self->get_stream($id);\n\tmy $report = Bio::AlignIO->new(-noclose => 1,\n\t\t\t\t\t\t\t\t\t-format => 'stockholm',\n\t\t\t\t\t\t            -fh => $fh);\n\treturn $report->next_aln;\n}\n\n=head2 fetch_aln\n\n Title   : fetch_aln\n Usage   : my $align = $idx->fetch_aln($id);\n Function: Returns a Bio::SimpleAlign object \n           for a specific alignment\n Returns : Bio::SimpleAlign\n Args    : valid id\n Note    : alias for fetch_report\n\n\n*fetch_aln = \\&fetch_report;\n\n=head2 Require methods from Bio::Index::Abstract\n\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file( $file_name, $i )\n  Function: Specialist function to index report file(s).\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : ","label":"_index_file($self,$file,$i)"},"detail":"($self,$file,$i)","kind":12,"children":[{"kind":13,"line":206,"name":"$self","definition":"my","containerName":"_index_file","localvar":"my"},{"kind":13,"line":207,"containerName":"_index_file","name":"$file"},{"containerName":"_index_file","name":"$i","kind":13,"line":208},{"name":"$begin","definition":"my","containerName":"_index_file","localvar":"my","kind":13,"line":211},{"localvar":"my","containerName":"_index_file","name":"$BLAST","definition":"my","line":215,"kind":13},{"containerName":"_index_file","name":"$file","line":215,"kind":13},{"name":"$self","containerName":"_index_file","line":215,"kind":13},{"containerName":"_index_file","name":"throw","line":215,"kind":12},{"localvar":"my","containerName":"_index_file","definition":"my","name":"$indexpoint","line":216,"kind":13},{"containerName":"_index_file","definition":"my","name":"$lastline","localvar":"my","kind":13,"line":217},{"line":218,"kind":13,"name":"$BLAST","containerName":"_index_file"},{"line":220,"kind":13,"name":"$indexpoint","containerName":"_index_file"},{"containerName":"_index_file","name":"$BLAST","line":220,"kind":13},{"line":221,"kind":13,"containerName":"_index_file","name":"$self"},{"name":"debug","containerName":"_index_file","kind":12,"line":221},{"kind":13,"line":224,"containerName":"_index_file","name":"$id","definition":"my","localvar":"my"},{"line":224,"kind":13,"name":"$self","containerName":"_index_file"},{"containerName":"_index_file","name":"id_parser","kind":12,"line":224},{"name":"$self","containerName":"_index_file","kind":13,"line":225},{"name":"debug","containerName":"_index_file","line":225,"kind":12}],"line":205},{"containerName":"main::","definition":"sub","detail":"($self,$code)","signature":{"parameters":[{"label":"$self"},{"label":"$code"}],"documentation":"1;\n# $Id: Stockholm.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Index::Stockholm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields@uiuc.edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::Stockholm - Indexes Stockholm format alignments (such as those from\nPfam and Rfam.  Retrieves raw stream data using the ID or a Bio::SimpleAlign\n(via Bio::AlignIO)\n\n=head1 SYNOPSIS\n\n    use strict;\n    use Bio::Index::Stockholm;\n    my ($indexfile,$file1,$file2,$query);\n    my $index = Bio::Index::Stockholm->new(-filename => $indexfile,\n\t\t\t\t                          -write_flag => 1);\n    $index->make_index($file1,$file2);\n\n    # get raw data stream starting at alignment position\n    my $fh = $index->get_stream($query);\n\n    # fetch individual alignment\n    my $align = $index->fetch_aln($query); # alias for fetch_report\n    my $align = $index->fetch_report($query); # same as above\n    print \"query is \", $align->display_id, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis object allows one to build an index for any file (or files)\ncontaining Stockholm alignment format (such as Rfam and Pfam) and provides\nquick access to the alignment based on the alignment ID.\n\nThis also allows for ID parsing using a callback:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /^>.+gi\\|(\\d+)/;\n      $1;\n   }\n\nThe indexer is capable of indexing based on multiple IDs passed back from the\ncallback; this is assuming of course all IDs are unique.  The default is to use\nthe alignment ID provided for Rfam/Pfam output.\n\nNote: for best results 'use strict'.\n\n=head1 TODO\n\n- allow using an alternative regex for indexing (for instance, the ID instead of AC)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Index::Stockholm;\nuse strict;\nuse Bio::AlignIO;\n\nuse base qw(Bio::Index::Abstract Bio::Root::Root);\n\nsub _version {\n\treturn ${Bio::Root::Version::VERSION};\n}\n\n=head2 new\n\n  Usage   : $index = Bio::Index::Abstract->new(\n                -filename    => $dbm_file,\n                -write_flag  => 0,\n                -dbm_package => 'DB_File',\n                -verbose     => 0);\n\n  Function: Returns a new index object.  If filename is\n            specified, then open_dbm() is immediately called. \n            Bio::Index::Abstract->new() will usually be called\n            directly only when opening an existing index.\n  Returns : A new index object\n  Args    : -filename    The name of the dbm index file.\n            -write_flag  TRUE if write access to the dbm file is\n                         needed.\n            -dbm_package The Perl dbm module to use for the\n                         index.\n            -verbose     Print debugging output to STDERR if\n                         TRUE.\n\n\nsub new {\n\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n}\n\n=head2 Bio::Index::Stockholm implemented methods\n\n\n=head2 fetch_report\n\n Title   : fetch_report\n Usage   : my $align = $idx->fetch_report($id);\n Function: Returns a Bio::SimpleAlign object \n           for a specific alignment\n Returns : Bio::SimpleAlign\n Args    : valid id\n\n\nsub fetch_report{\n\tmy ($self,$id) = @_;\n\tmy $fh = $self->get_stream($id);\n\tmy $report = Bio::AlignIO->new(-noclose => 1,\n\t\t\t\t\t\t\t\t\t-format => 'stockholm',\n\t\t\t\t\t\t            -fh => $fh);\n\treturn $report->next_aln;\n}\n\n=head2 fetch_aln\n\n Title   : fetch_aln\n Usage   : my $align = $idx->fetch_aln($id);\n Function: Returns a Bio::SimpleAlign object \n           for a specific alignment\n Returns : Bio::SimpleAlign\n Args    : valid id\n Note    : alias for fetch_report\n\n\n*fetch_aln = \\&fetch_report;\n\n=head2 Require methods from Bio::Index::Abstract\n\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file( $file_name, $i )\n  Function: Specialist function to index report file(s).\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : \n\n\nsub _index_file {\n\tmy( $self,\n\t\t $file, # File name\n\t\t $i,    # Index-number of file being indexed\n\t  ) = @_;\n\n\tmy( $begin,  # Offset from start of file of the start\n\t\t          # of the last found record.\n\t  );\n    local $/ =\"\\n\";\n\topen(my $BLAST, '<', $file) or $self->throw(\"cannot open file $file\\n\");\n\tmy $indexpoint = 0;\n\tmy $lastline = 0;\n\twhile( <$BLAST> ) {\n\t\tif(m{^#\\sSTOCKHOLM} ) {\n            $indexpoint = tell($BLAST)-length $_;\n            $self->debug(\"Index:$indexpoint\\n\")\n\t\t}\n        if(m{^#=GF\\s+AC\\s+(\\S[^\\n]+)}) {\n            foreach my $id ($self->id_parser()->($1)) {\n\t\t\t\t$self->debug(\"id is $id, begin is $indexpoint\\n\");\n\t\t\t\t#$self->add_record($id, $i, $indexpoint);\n\t\t\t}\n        }\n\t}\n}\n\n# shamelessly stolen from Bio::Index::Fasta\n\n=head2 id_parser\n\n  Title   : id_parser\n  Usage   : $index->id_parser( CODE )\n  Function: Stores or returns the code used by record_id to\n            parse the ID for record from a string.  Useful\n            for (for instance) specifying a different\n            parser for different flavours of IDs (for instance,\n            custom stockholm-formated files). \n            Returns \\&default_id_parser (see below) if not\n            set. If you supply your own id_parser\n            subroutine, then it should expect a fasta\n            description line.  An entry will be added to\n            the index for each string in the list returned.\n  Example : $index->id_parser( \\&my_id_parser )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE","label":"id_parser($self,$code)"},"kind":12,"line":254,"children":[{"definition":"my","name":"$self","containerName":"id_parser","localvar":"my","kind":13,"line":255},{"line":255,"kind":13,"containerName":"id_parser","name":"$code"},{"name":"$code","containerName":"id_parser","line":257,"kind":13},{"line":258,"kind":13,"containerName":"id_parser","name":"$self"},{"name":"$code","containerName":"id_parser","line":258,"kind":13},{"name":"$self","containerName":"id_parser","line":260,"kind":13}],"name":"id_parser","range":{"start":{"line":254,"character":0},"end":{"character":9999,"line":261}}},{"line":260,"kind":12,"name":"default_id_parser"},{"name":"default_id_parser","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":282},"start":{"character":0,"line":275}},"kind":12,"children":[],"line":275}],"version":5}