{"version":5,"vars":[{"name":"pod","kind":12,"line":1},{"name":"base","containerName":"","kind":2,"line":82},{"children":[{"kind":13,"line":94,"containerName":"_initialize","definition":"my","name":"$self","localvar":"my"},{"containerName":"_initialize","name":"%arg","line":94,"kind":13},{"containerName":"_initialize","name":"$self","kind":13,"line":96},{"containerName":"_initialize","name":"%arg","line":96,"kind":13},{"name":"$self","containerName":"_initialize","line":98,"kind":13},{"containerName":"_initialize","name":"mode","kind":12,"line":98},{"containerName":"_initialize","name":"$self","line":99,"kind":13},{"line":100,"kind":13,"containerName":"_initialize","name":"$self"},{"kind":13,"line":103,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"throw","kind":12,"line":103}],"line":93,"kind":12,"signature":{"documentation":"=head1 NAME\n\nBio::FeatureIO::vecscreen_simple - read/write features from NCBI vecscreen -f 3\noutput\n\n=head1 SYNOPSIS\n\n    # read features \n    my $fin = Bio::FeatureIO->new(-file=>'vecscreen.out',\n                                  -format=>'vecscreen_simple');\n    my @vec_regions;\n    while (my $f = $fin->next_feature) {\n      push @vec_regions, $f;\n    }\n    \n    # write features NOT IMPLEMENTED\n\n=head1 DESCRIPTION\n\nvecscreen is a system for quickly identifying segments of a nucleic\nacid sequence that may be of vector origin.  NCBI developed vecscreen\nto minimize the incidence and impact of vector contamination in public\nsequence databases.  GenBank Annotation Staff use vecscreen to verify\nthat sequences submitted for inclusion in the database are free from\ncontaminating vector sequence. Any sequence can be screened for vector\ncontamination using vecscreen.\n\nThis module provides parsing for vecscreen '-f 3' output, described in\nthe vecscreen documentation as 'Text list, no alignments'\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n bioperl-l@bioperl.org                  - General discussion\n http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robert Buels\n\nEmail rmb32 AT cornell.edu\n\n=head1 CONTRIBUTORS\n\nBased on ptt.pm by Torsten Seeman\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::vecscreen_simple;\n\nuse strict;\nuse base qw(Bio::FeatureIO);\nuse Bio::SeqFeature::Generic;\n\n=head2 _initialize\n\nTitle   : _initialize\nFunction: Reading? parses the header of the input\n          Writing? ","parameters":[{"label":"$self"},{"label":"%arg"}],"label":"_initialize($self,%arg)"},"detail":"($self,%arg)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":105},"start":{"line":93,"character":0}},"name":"_initialize"},{"name":"Generic","containerName":"Bio::SeqFeature","kind":2,"line":94},{"containerName":"_initialize","name":"SUPER","line":96,"kind":12},{"name":"parse_state","line":99,"kind":12},{"name":"seqname","line":99,"kind":12},{"line":100,"kind":12,"name":"parse_state"},{"kind":12,"line":100,"name":"matchtype"},{"range":{"start":{"character":0,"line":117},"end":{"line":165,"character":9999}},"definition":"sub","name":"next_feature","containerName":"main::","children":[{"line":118,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"next_feature"},{"containerName":"next_feature","name":"$self","kind":13,"line":119},{"kind":12,"line":119,"name":"mode","containerName":"next_feature"},{"line":121,"kind":13,"localvar":"my","name":"$line","definition":"my","containerName":"next_feature"},{"containerName":"next_feature","name":"$self","line":121,"kind":13},{"containerName":"next_feature","name":"_readline","kind":12,"line":121},{"line":122,"kind":13,"containerName":"next_feature","name":"$line"},{"containerName":"next_feature","name":"$line","kind":13,"line":123},{"line":124,"kind":13,"name":"$self","containerName":"next_feature"},{"containerName":"next_feature","name":"$line","line":125,"kind":13},{"containerName":"next_feature","name":"$self","kind":13,"line":126},{"containerName":"next_feature","name":"warn","kind":12,"line":126},{"containerName":"next_feature","name":"$line","line":127,"kind":13},{"line":129,"kind":13,"name":"$self","containerName":"next_feature"},{"line":130,"kind":13,"name":"$self","containerName":"next_feature"},{"name":"throw","containerName":"next_feature","line":130,"kind":12},{"line":134,"kind":13,"localvar":"my","containerName":"next_feature","definition":"my","name":"$lcline"},{"containerName":"next_feature","name":"$line","line":134,"kind":13},{"name":"$line","containerName":"next_feature","line":136,"kind":13},{"name":"$s","definition":"my","containerName":"next_feature","localvar":"my","kind":13,"line":137},{"line":137,"kind":13,"containerName":"next_feature","name":"$e"},{"line":139,"kind":13,"localvar":"my","containerName":"next_feature","definition":"my","name":"$matchtype"},{"containerName":"next_feature","name":"$self","line":139,"kind":13},{"kind":13,"line":140,"containerName":"next_feature","name":"$matchtype"},{"name":"new","containerName":"next_feature","line":141,"kind":12},{"name":"$s","containerName":"next_feature","kind":13,"line":141},{"containerName":"next_feature","name":"$e","kind":13,"line":142},{"kind":13,"line":143,"containerName":"next_feature","name":"$matchtype"},{"containerName":"next_feature","name":"$self","kind":13,"line":144},{"kind":13,"line":146,"name":"$lcline","containerName":"next_feature"},{"kind":13,"line":147,"name":"$self","containerName":"next_feature"},{"name":"$lcline","containerName":"next_feature","line":148,"kind":13},{"name":"$self","containerName":"next_feature","kind":13,"line":149},{"name":"$lcline","containerName":"next_feature","line":149,"kind":13},{"kind":13,"line":151,"containerName":"next_feature","name":"$self"},{"name":"throw","containerName":"next_feature","line":151,"kind":12},{"name":"$self","containerName":"next_feature","kind":13,"line":156},{"containerName":"next_feature","name":"$self","line":160,"kind":13}],"line":117,"kind":12},{"kind":12,"line":124,"name":"parse_state"},{"kind":12,"line":124,"name":"seqname"},{"name":"parse_state","line":129,"kind":12},{"line":129,"kind":12,"name":"seqname"},{"name":"parse_state","kind":12,"line":139},{"name":"matchtype","kind":12,"line":139},{"kind":12,"line":141,"name":"Bio","containerName":"SeqFeature::Generic"},{"line":144,"kind":12,"name":"parse_state"},{"line":144,"kind":12,"name":"seqname"},{"name":"parse_state","line":147,"kind":12},{"kind":12,"line":147,"name":"seqname"},{"line":149,"kind":12,"name":"parse_state"},{"kind":12,"line":149,"name":"matchtype"},{"name":"parse_state","kind":12,"line":156},{"kind":12,"line":156,"name":"seqname"},{"line":160,"kind":12,"name":"parse_state"},{"name":"matchtype","line":160,"kind":12},{"range":{"end":{"character":9999,"line":180},"start":{"character":0,"line":178}},"name":"write_feature","definition":"sub","containerName":"main::","children":[{"kind":12,"line":179,"name":"throw_not_implemented","containerName":"write_feature"}],"line":178,"kind":12}]}