{"version":5,"vars":[{"line":249,"kind":2,"containerName":"","name":"base"},{"line":264,"kind":13,"localvar":"my","name":"$entry","definition":"my","containerName":null},{"name":"new","range":{"end":{"line":298,"character":9999},"start":{"line":266,"character":0}},"containerName":"main::","definition":"sub","detail":"($caller,@args)","signature":{"label":"new($caller,@args)","parameters":[{"label":"$caller"},{"label":"@args"}],"documentation":""},"kind":12,"line":266,"children":[{"kind":13,"line":267,"containerName":"new","name":"$caller","definition":"my","localvar":"my"},{"name":"@args","containerName":"new","kind":13,"line":267},{"kind":13,"line":268,"containerName":"new","name":"$class","definition":"my","localvar":"my"},{"name":"$caller","containerName":"new","line":268,"kind":13},{"kind":13,"line":268,"name":"$caller","containerName":"new"},{"name":"$class","containerName":"new","line":272,"kind":13},{"kind":13,"line":274,"definition":"my","name":"$self","containerName":"new","localvar":"my"},{"line":274,"kind":13,"name":"$class","containerName":"new"},{"containerName":"new","name":"@args","line":274,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":275},{"line":275,"kind":12,"name":"_initialize","containerName":"new"},{"name":"@args","containerName":"new","line":275,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":276},{"line":280,"kind":13,"localvar":"my","containerName":"new","name":"%param","definition":"my"},{"kind":13,"line":280,"name":"@args","containerName":"new"},{"name":"@param","containerName":"new","kind":13,"line":282},{"kind":13,"line":282,"name":"%param","containerName":"new"},{"containerName":"new","name":"%param","kind":13,"line":282},{"name":"$format","definition":"my","containerName":"new","localvar":"my","kind":13,"line":283},{"kind":13,"line":283,"name":"$param","containerName":"new"},{"line":284,"kind":13,"containerName":"new","name":"$class"},{"line":284,"kind":12,"name":"_guess_format","containerName":"new"},{"line":284,"kind":13,"containerName":"new","name":"$param"},{"containerName":"new","name":"$ARGV","line":284,"kind":13},{"name":"$format","containerName":"new","line":286,"kind":13},{"kind":13,"line":287,"containerName":"new","name":"$param"},{"kind":13,"line":288,"containerName":"new","name":"$format"},{"line":288,"kind":13,"containerName":"new","name":"$class"},{"line":288,"kind":12,"name":"_guess_format","containerName":"new"},{"kind":13,"line":288,"name":"$param","containerName":"new"},{"line":289,"kind":13,"containerName":"new","name":"$param"},{"containerName":"new","name":"$format","kind":13,"line":290},{"line":290,"kind":13,"name":"$class","containerName":"new"},{"kind":12,"line":290,"name":"_guess_format","containerName":"new"},{"kind":13,"line":293,"containerName":"new","name":"$format"},{"containerName":"new","name":"$class","line":294,"kind":13},{"kind":12,"line":294,"name":"_load_format_module","containerName":"new"},{"line":294,"kind":13,"containerName":"new","name":"$format"},{"kind":12,"line":295,"containerName":"new","name":"new"},{"name":"@args","containerName":"new","kind":13,"line":295}]},{"containerName":"new","name":"SUPER","kind":12,"line":274},{"range":{"start":{"line":315,"character":0},"end":{"character":9999,"line":319}},"containerName":"main::","definition":"sub","name":"newFh","line":315,"children":[{"line":316,"kind":13,"localvar":"my","definition":"my","name":"$class","containerName":"newFh"},{"localvar":"my","containerName":"newFh","name":"$self","definition":"my","line":317,"kind":13},{"kind":13,"line":317,"containerName":"newFh","name":"$class"},{"containerName":"newFh","name":"new","kind":12,"line":317},{"line":318,"kind":13,"containerName":"newFh","name":"$self"},{"name":"fh","containerName":"newFh","line":318,"kind":12}],"kind":12},{"line":335,"children":[{"kind":13,"line":336,"definition":"my","name":"$self","containerName":"fh","localvar":"my"},{"localvar":"my","name":"$class","definition":"my","containerName":"fh","line":337,"kind":13},{"line":337,"kind":13,"name":"$self","containerName":"fh"},{"kind":13,"line":337,"containerName":"fh","name":"$self"},{"containerName":"fh","name":"$s","definition":"my","localvar":"my","kind":13,"line":338},{"line":339,"kind":13,"name":"$class","containerName":"fh"},{"line":339,"kind":13,"name":"$self","containerName":"fh"},{"name":"$s","containerName":"fh","kind":13,"line":340}],"kind":12,"range":{"start":{"line":335,"character":0},"end":{"character":9999,"line":341}},"containerName":"main::","name":"fh","definition":"sub"},{"name":"Symbol","containerName":"gensym","kind":12,"line":339},{"name":"_initialize","range":{"end":{"line":353,"character":9999},"start":{"line":345,"character":0}},"definition":"sub","containerName":"main::","signature":{"label":"_initialize($self,%arg)","documentation":" _initialize is chained for all FeatureIO classes","parameters":[{"label":"$self"},{"label":"%arg"}]},"detail":"($self,%arg)","kind":12,"children":[{"localvar":"my","containerName":"_initialize","definition":"my","name":"$self","line":346,"kind":13},{"kind":13,"line":346,"name":"%arg","containerName":"_initialize"},{"name":"$self","containerName":"_initialize","kind":13,"line":351},{"line":351,"kind":12,"containerName":"_initialize","name":"seq"},{"line":351,"kind":13,"containerName":"_initialize","name":"$arg"},{"kind":13,"line":352,"containerName":"_initialize","name":"$self"},{"name":"_initialize_io","containerName":"_initialize","kind":12,"line":352},{"containerName":"_initialize","name":"%arg","line":352,"kind":13}],"line":345},{"range":{"start":{"line":380,"character":0},"end":{"line":383,"character":9999}},"name":"next_feature","signature":{"label":"next_feature($self,$seq)","documentation":"1;\n# $Id: FeatureIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::FeatureIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday@ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::FeatureIO - Handler for FeatureIO\n\n=head1 SYNOPSIS\n\n  use Bio::FeatureIO;\n\n  #read from a file\n  $in  = Bio::FeatureIO->new(-file => \"my.gff\" , -format => 'GFF');\n\n  #read from a filehandle\n  $in  = Bio::FeatureIO->new(-fh => \\*GFF , -format => 'GFF');\n\n  #read features already attached to a sequence\n  my $feat = Bio::FeatureIO->new(-seq => $seq , -format => 'features');\n\n  #read new features for existing sequence\n  my $seq = Bio::FeatureIO->new(-seq => $seq , -format => 'Das');\n\n  #write out features\n  $out = Bio::FeatureIO->new(-file    => \">outputfilename\" ,\n                             -format  => 'GFF' ,\n                             -version => 3);\n\n  while ( my $feature = $in->next_feature() ) {\n    $out->write_feature($feature);\n  }\n\n=head1 DESCRIPTION\n\nAn I/O iterator subsystem for genomic sequence features.\n\nBio::FeatureIO is a handler module for the formats in the FeatureIO set (eg,\nBio::FeatureIO::GFF). It is the officially sanctioned way of getting at\nthe format objects, which most people should use.\n\nThe Bio::FeatureIO system can be thought of like biological file handles.\nThey are attached to filehandles with smart formatting rules (eg,\nGFF format, or BED format) and \ncan either read or write feature objects (Bio::SeqFeature objects, or\nmore correctly, Bio::FeatureHolderI implementing objects, of which \nBio::SeqFeature is one such object). If you want to know what to \ndo with a Bio::SeqFeatureI object, read L<Bio::SeqFeatureI>.\n\nThe idea is that you request a stream object for a particular format.\nAll the stream objects have a notion of an internal file that is read\nfrom or written to. A particular FeatureIO object instance is configured\nfor either input or output. A specific example of a stream object is\nthe Bio::FeatureIO::gff object.\n\nEach stream object has functions:\n\n  $stream->next_feature();\n  $stream->write_feature($feature);\n\n=head1 SUPPORTED FORMATS\n\n name                         module\n -----------------------------------\n BED                          bed.pm\n GFF                          gff.pm\n GTF                          gtf.pm\n InterPro (IPRScan 4.0)  interpro.pm\n PTT (NCBI protein table)     ptt.pm\n\n\n=head1 CONSTRUCTORS\n\n=head2 Bio::FeatureIO-E<gt>new()\n\n   $featureIO = Bio::FeatureIO->new(-file => 'filename',   -format=>$format);\n   $featureIO = Bio::FeatureIO->new(-fh   => \\*FILEHANDLE, -format=>$format);\n   $featureIO = Bio::FeatureIO->new(-seq  => $seq,         -format=>$format);\n\nThe new() class method constructs a new Bio::FeatureIO object.  The\nreturned object can be used to retrieve or print Seq objects. new()\naccepts the following parameters:\n\n=over 4\n\n* -file\n\nA file path to be opened for reading or writing.  The usual Perl\nconventions apply:\n\n   'file'       # open file for reading\n   '>file'      # open file for writing\n   '>>file'     # open file for appending\n   '+<file'     # open file read/write\n   'command |'  # open a pipe from the command\n   '| command'  # open a pipe to the command\n\n* -fh\n\nYou may provide new() with a previously-opened filehandle.  For\nexample, to read from STDIN:\n\n   $featio = Bio::FeatureIO->new(-fh => \\*STDIN);\n\nNote that you must pass filehandles as references to globs.\n\nIf neither a filehandle nor a filename is specified, then the module\nwill read from the @ARGV array or STDIN, using the familiar E<lt>E<gt>\nsemantics.\n\nA string filehandle is handy if you want to modify the output in the\nmemory, before printing it out. The following program reads in EMBL\nformatted entries from a file and prints them out in fasta format with\nsome HTML tags:\n\n  use Bio::FeatureIO;\n  use IO::String;\n  my $in  = Bio::FeatureIO->new('-file' => \"my.gff\" ,\n  \t\t\t    '-format' => 'EMBL');\n  while ( my $f = $in->next_feature() ) {\n      # the output handle is reset for every file\n      my $stringio = IO::String->new($string);\n      my $out = Bio::FeatureIO->new('-fh' => $stringio,\n  \t\t\t        '-format' => 'gtf');\n      # output goes into $string\n      $out->write_feature($f);\n      # modify $string\n      $string =~ s|(>)(\\w+)|$1<font color=\"Red\">$2</font>|g;\n      # print into STDOUT\n      print $string;\n  }\n\n* -format\n\nSpecify the format of the file.  See above for list of supported formats\n\n* -flush\n\nBy default, all files (or filehandles) opened for writing sequences\nwill be flushed after each write_seq() (making the file immediately\nusable).  If you don't need this facility and would like to marginally\nimprove the efficiency of writing multiple sequences to the same file\n(or filehandle), pass the -flush option '0' or any other value that\nevaluates as defined but false:\n\n  my $f1 = Bio::FeatureIO->new -file   => \"<a.f1\",\n                              -format => \"f1\";\n  my $f2 = Bio::FeatureIO->new -file   => \">a.f2\",\n                              -format => \"f2\",\n                              -flush  => 0; # go as fast as we can!\n\n  while($feature = $f1->next_feature) { $f2->write_feature($feature) }\n\n\n=head2 Bio::FeatureIO-E<gt>newFh()\n\n   $fh = Bio::FeatureIO->newFh(-fh   => \\*FILEHANDLE, -format=>$format);\n   $fh = Bio::FeatureIO->newFh(-format => $format);\n   # etc.\n\nThis constructor behaves like new(), but returns a tied filehandle\nrather than a Bio::FeatureIO object.  You can read sequences from this\nobject using the familiar E<lt>E<gt> operator, and write to it using\nprint().  The usual array and $_ semantics work.  For example, you can\nread all sequence objects into an array like this:\n\n  @features = <$fh>;\n\nOther operations, such as read(), sysread(), write(), close(), and printf()\nare not supported.\n\n=head1 OBJECT METHODS\n\nSee below for more detailed summaries.  The main methods are:\n\n=head2 $feature = $featureIO-E<gt>next_feature()\n\nFetch the next feature from the stream.\n\n=head2 $featureIO-E<gt>write_feature($feature [,$another_feature,...])\n\nWrite the specified feature(s) to the stream.\n\n=head2 TIEHANDLE(), READLINE(), PRINT()\n\nThese provide the tie interface.  See L<perltie> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nEmail allenday@ucla.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' Let the code begin...\n\npackage Bio::FeatureIO;\n\nuse strict;\n\nuse Symbol;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : $stream = Bio::FeatureIO->new(-file => $filename, -format => 'Format')\n Function: Returns a new feature stream\n Returns : A Bio::FeatureIO stream initialised with the appropriate format\n Args    : Named parameters:\n             -file => $filename\n             -fh => filehandle to attach to\n             -format => format\n\n\nmy $entry = 0;\n\nsub new {\n  my ($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n\n  # or do we want to call SUPER on an object if $caller is an\n  # object?\n  if( $class =~ /Bio::FeatureIO::(\\S+)/ ) {\n\n    my ($self) = $class->SUPER::new(@args);\t\n    $self->_initialize(@args);\n    return $self;\n\n  } else {\n\n\tmy %param = @args;\n\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $format = $param{'-format'} ||\n      $class->_guess_format( $param{-file} || $ARGV[0] );\n\t\n\tif( ! $format ) {\n      if ($param{-file}) {\n        $format = $class->_guess_format($param{-file});\n      } elsif ($param{-fh}) {\n        $format = $class->_guess_format(undef);\n      }\n\t}\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n\treturn unless( $class->_load_format_module($format) );\n\treturn \"Bio::FeatureIO::$format\"->new(@args);\n\n  }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::FeatureIO->newFh(-file=>$filename,-format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::FeatureIO->newFh(-file=>$filename,-format=>'Format')\n           $feature = <$fh>;   # read a feature object\n           print $fh $feature; # write a feature object\n Returns : filehandle tied to the Bio::FeatureIO::Fh class\n Args    :\n\nSee L<Bio::FeatureIO::Fh>\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $feature = <$fh>;   # read a feature object\n           print $fh $feature; # write a feature object\n Returns : filehandle tied to Bio::FeatureIO class\n Args    : none\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n# _initialize is chained for all FeatureIO classes\n\nsub _initialize {\n    my($self, %arg) = @_;\n\n    # flush is initialized by the Root::IO init\n\n    # initialize the IO part\n    $self->seq($arg{-seq});\n    $self->_initialize_io(%arg);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $feature = stream->next_feature\n Function: Reads the next feature object from the stream and returns it.\n\n           Certain driver modules may encounter entries in the stream\n           that are either misformatted or that use syntax not yet\n           understood by the driver. If such an incident is\n           recoverable, e.g., by dismissing a feature of a feature\n           table or some other non-mandatory part of an entry, the\n           driver will issue a warning. In the case of a\n           non-recoverable situation an exception will be thrown.  Do\n           not assume that you can resume parsing the same stream\n           after catching the exception. Note that you can always turn\n           recoverable errors into exceptions by calling\n           $stream->verbose(2).\n\n Returns : a Bio::SeqFeatureI feature object\n Args    : none\n\nSee L<Bio::Root::RootI>, L<Bio::SeqFeatureI>","parameters":[{"label":"$self"},{"label":"$seq"}]},"detail":"($self,$seq)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"next_feature","definition":"my","name":"$self","line":381,"kind":13},{"line":381,"kind":13,"name":"$seq","containerName":"next_feature"},{"line":382,"kind":13,"containerName":"next_feature","name":"$self"},{"name":"throw","containerName":"next_feature","kind":12,"line":382}],"line":380,"kind":12},{"children":[{"line":396,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"write_feature"},{"kind":13,"line":396,"containerName":"write_feature","name":"$seq"},{"name":"$self","containerName":"write_feature","kind":13,"line":397},{"line":398,"kind":13,"name":"$self","containerName":"write_feature"},{"name":"throw","containerName":"write_feature","kind":12,"line":398},{"line":400,"kind":13,"containerName":"write_feature","name":"$self"},{"containerName":"write_feature","name":"throw_not_implemented","line":400,"kind":12}],"line":395,"kind":12,"signature":{"label":"write_feature($self,$seq)","parameters":[{"label":"$self"},{"label":"$seq"}],"documentation":"1;\n# $Id: FeatureIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::FeatureIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday@ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::FeatureIO - Handler for FeatureIO\n\n=head1 SYNOPSIS\n\n  use Bio::FeatureIO;\n\n  #read from a file\n  $in  = Bio::FeatureIO->new(-file => \"my.gff\" , -format => 'GFF');\n\n  #read from a filehandle\n  $in  = Bio::FeatureIO->new(-fh => \\*GFF , -format => 'GFF');\n\n  #read features already attached to a sequence\n  my $feat = Bio::FeatureIO->new(-seq => $seq , -format => 'features');\n\n  #read new features for existing sequence\n  my $seq = Bio::FeatureIO->new(-seq => $seq , -format => 'Das');\n\n  #write out features\n  $out = Bio::FeatureIO->new(-file    => \">outputfilename\" ,\n                             -format  => 'GFF' ,\n                             -version => 3);\n\n  while ( my $feature = $in->next_feature() ) {\n    $out->write_feature($feature);\n  }\n\n=head1 DESCRIPTION\n\nAn I/O iterator subsystem for genomic sequence features.\n\nBio::FeatureIO is a handler module for the formats in the FeatureIO set (eg,\nBio::FeatureIO::GFF). It is the officially sanctioned way of getting at\nthe format objects, which most people should use.\n\nThe Bio::FeatureIO system can be thought of like biological file handles.\nThey are attached to filehandles with smart formatting rules (eg,\nGFF format, or BED format) and \ncan either read or write feature objects (Bio::SeqFeature objects, or\nmore correctly, Bio::FeatureHolderI implementing objects, of which \nBio::SeqFeature is one such object). If you want to know what to \ndo with a Bio::SeqFeatureI object, read L<Bio::SeqFeatureI>.\n\nThe idea is that you request a stream object for a particular format.\nAll the stream objects have a notion of an internal file that is read\nfrom or written to. A particular FeatureIO object instance is configured\nfor either input or output. A specific example of a stream object is\nthe Bio::FeatureIO::gff object.\n\nEach stream object has functions:\n\n  $stream->next_feature();\n  $stream->write_feature($feature);\n\n=head1 SUPPORTED FORMATS\n\n name                         module\n -----------------------------------\n BED                          bed.pm\n GFF                          gff.pm\n GTF                          gtf.pm\n InterPro (IPRScan 4.0)  interpro.pm\n PTT (NCBI protein table)     ptt.pm\n\n\n=head1 CONSTRUCTORS\n\n=head2 Bio::FeatureIO-E<gt>new()\n\n   $featureIO = Bio::FeatureIO->new(-file => 'filename',   -format=>$format);\n   $featureIO = Bio::FeatureIO->new(-fh   => \\*FILEHANDLE, -format=>$format);\n   $featureIO = Bio::FeatureIO->new(-seq  => $seq,         -format=>$format);\n\nThe new() class method constructs a new Bio::FeatureIO object.  The\nreturned object can be used to retrieve or print Seq objects. new()\naccepts the following parameters:\n\n=over 4\n\n* -file\n\nA file path to be opened for reading or writing.  The usual Perl\nconventions apply:\n\n   'file'       # open file for reading\n   '>file'      # open file for writing\n   '>>file'     # open file for appending\n   '+<file'     # open file read/write\n   'command |'  # open a pipe from the command\n   '| command'  # open a pipe to the command\n\n* -fh\n\nYou may provide new() with a previously-opened filehandle.  For\nexample, to read from STDIN:\n\n   $featio = Bio::FeatureIO->new(-fh => \\*STDIN);\n\nNote that you must pass filehandles as references to globs.\n\nIf neither a filehandle nor a filename is specified, then the module\nwill read from the @ARGV array or STDIN, using the familiar E<lt>E<gt>\nsemantics.\n\nA string filehandle is handy if you want to modify the output in the\nmemory, before printing it out. The following program reads in EMBL\nformatted entries from a file and prints them out in fasta format with\nsome HTML tags:\n\n  use Bio::FeatureIO;\n  use IO::String;\n  my $in  = Bio::FeatureIO->new('-file' => \"my.gff\" ,\n  \t\t\t    '-format' => 'EMBL');\n  while ( my $f = $in->next_feature() ) {\n      # the output handle is reset for every file\n      my $stringio = IO::String->new($string);\n      my $out = Bio::FeatureIO->new('-fh' => $stringio,\n  \t\t\t        '-format' => 'gtf');\n      # output goes into $string\n      $out->write_feature($f);\n      # modify $string\n      $string =~ s|(>)(\\w+)|$1<font color=\"Red\">$2</font>|g;\n      # print into STDOUT\n      print $string;\n  }\n\n* -format\n\nSpecify the format of the file.  See above for list of supported formats\n\n* -flush\n\nBy default, all files (or filehandles) opened for writing sequences\nwill be flushed after each write_seq() (making the file immediately\nusable).  If you don't need this facility and would like to marginally\nimprove the efficiency of writing multiple sequences to the same file\n(or filehandle), pass the -flush option '0' or any other value that\nevaluates as defined but false:\n\n  my $f1 = Bio::FeatureIO->new -file   => \"<a.f1\",\n                              -format => \"f1\";\n  my $f2 = Bio::FeatureIO->new -file   => \">a.f2\",\n                              -format => \"f2\",\n                              -flush  => 0; # go as fast as we can!\n\n  while($feature = $f1->next_feature) { $f2->write_feature($feature) }\n\n\n=head2 Bio::FeatureIO-E<gt>newFh()\n\n   $fh = Bio::FeatureIO->newFh(-fh   => \\*FILEHANDLE, -format=>$format);\n   $fh = Bio::FeatureIO->newFh(-format => $format);\n   # etc.\n\nThis constructor behaves like new(), but returns a tied filehandle\nrather than a Bio::FeatureIO object.  You can read sequences from this\nobject using the familiar E<lt>E<gt> operator, and write to it using\nprint().  The usual array and $_ semantics work.  For example, you can\nread all sequence objects into an array like this:\n\n  @features = <$fh>;\n\nOther operations, such as read(), sysread(), write(), close(), and printf()\nare not supported.\n\n=head1 OBJECT METHODS\n\nSee below for more detailed summaries.  The main methods are:\n\n=head2 $feature = $featureIO-E<gt>next_feature()\n\nFetch the next feature from the stream.\n\n=head2 $featureIO-E<gt>write_feature($feature [,$another_feature,...])\n\nWrite the specified feature(s) to the stream.\n\n=head2 TIEHANDLE(), READLINE(), PRINT()\n\nThese provide the tie interface.  See L<perltie> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nEmail allenday@ucla.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' Let the code begin...\n\npackage Bio::FeatureIO;\n\nuse strict;\n\nuse Symbol;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : $stream = Bio::FeatureIO->new(-file => $filename, -format => 'Format')\n Function: Returns a new feature stream\n Returns : A Bio::FeatureIO stream initialised with the appropriate format\n Args    : Named parameters:\n             -file => $filename\n             -fh => filehandle to attach to\n             -format => format\n\n\nmy $entry = 0;\n\nsub new {\n  my ($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n\n  # or do we want to call SUPER on an object if $caller is an\n  # object?\n  if( $class =~ /Bio::FeatureIO::(\\S+)/ ) {\n\n    my ($self) = $class->SUPER::new(@args);\t\n    $self->_initialize(@args);\n    return $self;\n\n  } else {\n\n\tmy %param = @args;\n\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $format = $param{'-format'} ||\n      $class->_guess_format( $param{-file} || $ARGV[0] );\n\t\n\tif( ! $format ) {\n      if ($param{-file}) {\n        $format = $class->_guess_format($param{-file});\n      } elsif ($param{-fh}) {\n        $format = $class->_guess_format(undef);\n      }\n\t}\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n\treturn unless( $class->_load_format_module($format) );\n\treturn \"Bio::FeatureIO::$format\"->new(@args);\n\n  }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::FeatureIO->newFh(-file=>$filename,-format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::FeatureIO->newFh(-file=>$filename,-format=>'Format')\n           $feature = <$fh>;   # read a feature object\n           print $fh $feature; # write a feature object\n Returns : filehandle tied to the Bio::FeatureIO::Fh class\n Args    :\n\nSee L<Bio::FeatureIO::Fh>\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $feature = <$fh>;   # read a feature object\n           print $fh $feature; # write a feature object\n Returns : filehandle tied to Bio::FeatureIO class\n Args    : none\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n# _initialize is chained for all FeatureIO classes\n\nsub _initialize {\n    my($self, %arg) = @_;\n\n    # flush is initialized by the Root::IO init\n\n    # initialize the IO part\n    $self->seq($arg{-seq});\n    $self->_initialize_io(%arg);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $feature = stream->next_feature\n Function: Reads the next feature object from the stream and returns it.\n\n           Certain driver modules may encounter entries in the stream\n           that are either misformatted or that use syntax not yet\n           understood by the driver. If such an incident is\n           recoverable, e.g., by dismissing a feature of a feature\n           table or some other non-mandatory part of an entry, the\n           driver will issue a warning. In the case of a\n           non-recoverable situation an exception will be thrown.  Do\n           not assume that you can resume parsing the same stream\n           after catching the exception. Note that you can always turn\n           recoverable errors into exceptions by calling\n           $stream->verbose(2).\n\n Returns : a Bio::SeqFeatureI feature object\n Args    : none\n\nSee L<Bio::Root::RootI>, L<Bio::SeqFeatureI>\n\n\nsub next_feature {\n   my ($self, $seq) = @_;\n   $self->throw(\"Sorry, you cannot read from a generic Bio::FeatureIO object.\");\n}\n\n=head2 write_feature\n\n Title   : write_feature\n Usage   : $stream->write_feature($feature)\n Function: writes the $feature object into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::SeqFeature object"},"detail":"($self,$seq)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":402},"start":{"character":0,"line":395}},"name":"write_feature"},{"name":"_load_format_module","range":{"start":{"character":0,"line":415},"end":{"line":434,"character":9999}},"kind":12,"children":[{"containerName":"_load_format_module","name":"$self","definition":"my","localvar":"my","kind":13,"line":416},{"containerName":"_load_format_module","name":"$format","line":416,"kind":13},{"localvar":"my","containerName":"_load_format_module","name":"$class","definition":"my","line":417,"kind":13},{"name":"$self","containerName":"_load_format_module","kind":13,"line":417},{"containerName":"_load_format_module","name":"$self","line":417,"kind":13},{"containerName":"_load_format_module","name":"$module","definition":"my","localvar":"my","kind":13,"line":418},{"line":418,"kind":13,"name":"$class","containerName":"_load_format_module"},{"kind":13,"line":419,"name":"$ok","definition":"my","containerName":"_load_format_module","localvar":"my"},{"line":422,"kind":13,"containerName":"_load_format_module","name":"$ok"},{"containerName":"_load_format_module","name":"$self","line":422,"kind":13},{"name":"_load_module","containerName":"_load_format_module","kind":12,"line":422},{"kind":13,"line":422,"name":"$module","containerName":"_load_format_module"},{"kind":13,"line":433,"containerName":"_load_format_module","name":"$ok"}],"line":415,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: FeatureIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::FeatureIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday@ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::FeatureIO - Handler for FeatureIO\n\n=head1 SYNOPSIS\n\n  use Bio::FeatureIO;\n\n  #read from a file\n  $in  = Bio::FeatureIO->new(-file => \"my.gff\" , -format => 'GFF');\n\n  #read from a filehandle\n  $in  = Bio::FeatureIO->new(-fh => \\*GFF , -format => 'GFF');\n\n  #read features already attached to a sequence\n  my $feat = Bio::FeatureIO->new(-seq => $seq , -format => 'features');\n\n  #read new features for existing sequence\n  my $seq = Bio::FeatureIO->new(-seq => $seq , -format => 'Das');\n\n  #write out features\n  $out = Bio::FeatureIO->new(-file    => \">outputfilename\" ,\n                             -format  => 'GFF' ,\n                             -version => 3);\n\n  while ( my $feature = $in->next_feature() ) {\n    $out->write_feature($feature);\n  }\n\n=head1 DESCRIPTION\n\nAn I/O iterator subsystem for genomic sequence features.\n\nBio::FeatureIO is a handler module for the formats in the FeatureIO set (eg,\nBio::FeatureIO::GFF). It is the officially sanctioned way of getting at\nthe format objects, which most people should use.\n\nThe Bio::FeatureIO system can be thought of like biological file handles.\nThey are attached to filehandles with smart formatting rules (eg,\nGFF format, or BED format) and \ncan either read or write feature objects (Bio::SeqFeature objects, or\nmore correctly, Bio::FeatureHolderI implementing objects, of which \nBio::SeqFeature is one such object). If you want to know what to \ndo with a Bio::SeqFeatureI object, read L<Bio::SeqFeatureI>.\n\nThe idea is that you request a stream object for a particular format.\nAll the stream objects have a notion of an internal file that is read\nfrom or written to. A particular FeatureIO object instance is configured\nfor either input or output. A specific example of a stream object is\nthe Bio::FeatureIO::gff object.\n\nEach stream object has functions:\n\n  $stream->next_feature();\n  $stream->write_feature($feature);\n\n=head1 SUPPORTED FORMATS\n\n name                         module\n -----------------------------------\n BED                          bed.pm\n GFF                          gff.pm\n GTF                          gtf.pm\n InterPro (IPRScan 4.0)  interpro.pm\n PTT (NCBI protein table)     ptt.pm\n\n\n=head1 CONSTRUCTORS\n\n=head2 Bio::FeatureIO-E<gt>new()\n\n   $featureIO = Bio::FeatureIO->new(-file => 'filename',   -format=>$format);\n   $featureIO = Bio::FeatureIO->new(-fh   => \\*FILEHANDLE, -format=>$format);\n   $featureIO = Bio::FeatureIO->new(-seq  => $seq,         -format=>$format);\n\nThe new() class method constructs a new Bio::FeatureIO object.  The\nreturned object can be used to retrieve or print Seq objects. new()\naccepts the following parameters:\n\n=over 4\n\n* -file\n\nA file path to be opened for reading or writing.  The usual Perl\nconventions apply:\n\n   'file'       # open file for reading\n   '>file'      # open file for writing\n   '>>file'     # open file for appending\n   '+<file'     # open file read/write\n   'command |'  # open a pipe from the command\n   '| command'  # open a pipe to the command\n\n* -fh\n\nYou may provide new() with a previously-opened filehandle.  For\nexample, to read from STDIN:\n\n   $featio = Bio::FeatureIO->new(-fh => \\*STDIN);\n\nNote that you must pass filehandles as references to globs.\n\nIf neither a filehandle nor a filename is specified, then the module\nwill read from the @ARGV array or STDIN, using the familiar E<lt>E<gt>\nsemantics.\n\nA string filehandle is handy if you want to modify the output in the\nmemory, before printing it out. The following program reads in EMBL\nformatted entries from a file and prints them out in fasta format with\nsome HTML tags:\n\n  use Bio::FeatureIO;\n  use IO::String;\n  my $in  = Bio::FeatureIO->new('-file' => \"my.gff\" ,\n  \t\t\t    '-format' => 'EMBL');\n  while ( my $f = $in->next_feature() ) {\n      # the output handle is reset for every file\n      my $stringio = IO::String->new($string);\n      my $out = Bio::FeatureIO->new('-fh' => $stringio,\n  \t\t\t        '-format' => 'gtf');\n      # output goes into $string\n      $out->write_feature($f);\n      # modify $string\n      $string =~ s|(>)(\\w+)|$1<font color=\"Red\">$2</font>|g;\n      # print into STDOUT\n      print $string;\n  }\n\n* -format\n\nSpecify the format of the file.  See above for list of supported formats\n\n* -flush\n\nBy default, all files (or filehandles) opened for writing sequences\nwill be flushed after each write_seq() (making the file immediately\nusable).  If you don't need this facility and would like to marginally\nimprove the efficiency of writing multiple sequences to the same file\n(or filehandle), pass the -flush option '0' or any other value that\nevaluates as defined but false:\n\n  my $f1 = Bio::FeatureIO->new -file   => \"<a.f1\",\n                              -format => \"f1\";\n  my $f2 = Bio::FeatureIO->new -file   => \">a.f2\",\n                              -format => \"f2\",\n                              -flush  => 0; # go as fast as we can!\n\n  while($feature = $f1->next_feature) { $f2->write_feature($feature) }\n\n\n=head2 Bio::FeatureIO-E<gt>newFh()\n\n   $fh = Bio::FeatureIO->newFh(-fh   => \\*FILEHANDLE, -format=>$format);\n   $fh = Bio::FeatureIO->newFh(-format => $format);\n   # etc.\n\nThis constructor behaves like new(), but returns a tied filehandle\nrather than a Bio::FeatureIO object.  You can read sequences from this\nobject using the familiar E<lt>E<gt> operator, and write to it using\nprint().  The usual array and $_ semantics work.  For example, you can\nread all sequence objects into an array like this:\n\n  @features = <$fh>;\n\nOther operations, such as read(), sysread(), write(), close(), and printf()\nare not supported.\n\n=head1 OBJECT METHODS\n\nSee below for more detailed summaries.  The main methods are:\n\n=head2 $feature = $featureIO-E<gt>next_feature()\n\nFetch the next feature from the stream.\n\n=head2 $featureIO-E<gt>write_feature($feature [,$another_feature,...])\n\nWrite the specified feature(s) to the stream.\n\n=head2 TIEHANDLE(), READLINE(), PRINT()\n\nThese provide the tie interface.  See L<perltie> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nEmail allenday@ucla.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' Let the code begin...\n\npackage Bio::FeatureIO;\n\nuse strict;\n\nuse Symbol;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : $stream = Bio::FeatureIO->new(-file => $filename, -format => 'Format')\n Function: Returns a new feature stream\n Returns : A Bio::FeatureIO stream initialised with the appropriate format\n Args    : Named parameters:\n             -file => $filename\n             -fh => filehandle to attach to\n             -format => format\n\n\nmy $entry = 0;\n\nsub new {\n  my ($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n\n  # or do we want to call SUPER on an object if $caller is an\n  # object?\n  if( $class =~ /Bio::FeatureIO::(\\S+)/ ) {\n\n    my ($self) = $class->SUPER::new(@args);\t\n    $self->_initialize(@args);\n    return $self;\n\n  } else {\n\n\tmy %param = @args;\n\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $format = $param{'-format'} ||\n      $class->_guess_format( $param{-file} || $ARGV[0] );\n\t\n\tif( ! $format ) {\n      if ($param{-file}) {\n        $format = $class->_guess_format($param{-file});\n      } elsif ($param{-fh}) {\n        $format = $class->_guess_format(undef);\n      }\n\t}\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n\treturn unless( $class->_load_format_module($format) );\n\treturn \"Bio::FeatureIO::$format\"->new(@args);\n\n  }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::FeatureIO->newFh(-file=>$filename,-format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::FeatureIO->newFh(-file=>$filename,-format=>'Format')\n           $feature = <$fh>;   # read a feature object\n           print $fh $feature; # write a feature object\n Returns : filehandle tied to the Bio::FeatureIO::Fh class\n Args    :\n\nSee L<Bio::FeatureIO::Fh>\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $feature = <$fh>;   # read a feature object\n           print $fh $feature; # write a feature object\n Returns : filehandle tied to Bio::FeatureIO class\n Args    : none\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n# _initialize is chained for all FeatureIO classes\n\nsub _initialize {\n    my($self, %arg) = @_;\n\n    # flush is initialized by the Root::IO init\n\n    # initialize the IO part\n    $self->seq($arg{-seq});\n    $self->_initialize_io(%arg);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $feature = stream->next_feature\n Function: Reads the next feature object from the stream and returns it.\n\n           Certain driver modules may encounter entries in the stream\n           that are either misformatted or that use syntax not yet\n           understood by the driver. If such an incident is\n           recoverable, e.g., by dismissing a feature of a feature\n           table or some other non-mandatory part of an entry, the\n           driver will issue a warning. In the case of a\n           non-recoverable situation an exception will be thrown.  Do\n           not assume that you can resume parsing the same stream\n           after catching the exception. Note that you can always turn\n           recoverable errors into exceptions by calling\n           $stream->verbose(2).\n\n Returns : a Bio::SeqFeatureI feature object\n Args    : none\n\nSee L<Bio::Root::RootI>, L<Bio::SeqFeatureI>\n\n\nsub next_feature {\n   my ($self, $seq) = @_;\n   $self->throw(\"Sorry, you cannot read from a generic Bio::FeatureIO object.\");\n}\n\n=head2 write_feature\n\n Title   : write_feature\n Usage   : $stream->write_feature($feature)\n Function: writes the $feature object into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::SeqFeature object\n\n\nsub write_feature {\n    my ($self, $seq) = @_;\n    if(ref($self) eq __PACKAGE__){\n      $self->throw(\"Sorry, you cannot write to a generic Bio::FeatureIO object.\");\n    } else {\n      $self->throw_not_implemented();\n    }\n}\n\n=head2 _load_format_module\n\n Title   : _load_format_module\n Usage   : *INTERNAL FeatureIO stuff*\n Function: Loads up (like use) a module at run time on demand\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"$format"}],"label":"_load_format_module($self,$format)"},"detail":"($self,$format)"},{"kind":12,"children":[{"kind":13,"line":447,"name":"$self","definition":"my","containerName":"seq","localvar":"my"},{"kind":13,"line":448,"containerName":"seq","definition":"my","name":"$val","localvar":"my"},{"containerName":"seq","name":"$self","line":450,"kind":13},{"containerName":"seq","name":"$val","kind":13,"line":450},{"name":"$val","containerName":"seq","kind":13,"line":450},{"line":451,"kind":13,"name":"$self","containerName":"seq"}],"line":446,"name":"seq","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":446},"end":{"character":9999,"line":452}}},{"definition":"sub","containerName":"main::","signature":{"label":"_filehandle($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: FeatureIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::FeatureIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday@ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::FeatureIO - Handler for FeatureIO\n\n=head1 SYNOPSIS\n\n  use Bio::FeatureIO;\n\n  #read from a file\n  $in  = Bio::FeatureIO->new(-file => \"my.gff\" , -format => 'GFF');\n\n  #read from a filehandle\n  $in  = Bio::FeatureIO->new(-fh => \\*GFF , -format => 'GFF');\n\n  #read features already attached to a sequence\n  my $feat = Bio::FeatureIO->new(-seq => $seq , -format => 'features');\n\n  #read new features for existing sequence\n  my $seq = Bio::FeatureIO->new(-seq => $seq , -format => 'Das');\n\n  #write out features\n  $out = Bio::FeatureIO->new(-file    => \">outputfilename\" ,\n                             -format  => 'GFF' ,\n                             -version => 3);\n\n  while ( my $feature = $in->next_feature() ) {\n    $out->write_feature($feature);\n  }\n\n=head1 DESCRIPTION\n\nAn I/O iterator subsystem for genomic sequence features.\n\nBio::FeatureIO is a handler module for the formats in the FeatureIO set (eg,\nBio::FeatureIO::GFF). It is the officially sanctioned way of getting at\nthe format objects, which most people should use.\n\nThe Bio::FeatureIO system can be thought of like biological file handles.\nThey are attached to filehandles with smart formatting rules (eg,\nGFF format, or BED format) and \ncan either read or write feature objects (Bio::SeqFeature objects, or\nmore correctly, Bio::FeatureHolderI implementing objects, of which \nBio::SeqFeature is one such object). If you want to know what to \ndo with a Bio::SeqFeatureI object, read L<Bio::SeqFeatureI>.\n\nThe idea is that you request a stream object for a particular format.\nAll the stream objects have a notion of an internal file that is read\nfrom or written to. A particular FeatureIO object instance is configured\nfor either input or output. A specific example of a stream object is\nthe Bio::FeatureIO::gff object.\n\nEach stream object has functions:\n\n  $stream->next_feature();\n  $stream->write_feature($feature);\n\n=head1 SUPPORTED FORMATS\n\n name                         module\n -----------------------------------\n BED                          bed.pm\n GFF                          gff.pm\n GTF                          gtf.pm\n InterPro (IPRScan 4.0)  interpro.pm\n PTT (NCBI protein table)     ptt.pm\n\n\n=head1 CONSTRUCTORS\n\n=head2 Bio::FeatureIO-E<gt>new()\n\n   $featureIO = Bio::FeatureIO->new(-file => 'filename',   -format=>$format);\n   $featureIO = Bio::FeatureIO->new(-fh   => \\*FILEHANDLE, -format=>$format);\n   $featureIO = Bio::FeatureIO->new(-seq  => $seq,         -format=>$format);\n\nThe new() class method constructs a new Bio::FeatureIO object.  The\nreturned object can be used to retrieve or print Seq objects. new()\naccepts the following parameters:\n\n=over 4\n\n* -file\n\nA file path to be opened for reading or writing.  The usual Perl\nconventions apply:\n\n   'file'       # open file for reading\n   '>file'      # open file for writing\n   '>>file'     # open file for appending\n   '+<file'     # open file read/write\n   'command |'  # open a pipe from the command\n   '| command'  # open a pipe to the command\n\n* -fh\n\nYou may provide new() with a previously-opened filehandle.  For\nexample, to read from STDIN:\n\n   $featio = Bio::FeatureIO->new(-fh => \\*STDIN);\n\nNote that you must pass filehandles as references to globs.\n\nIf neither a filehandle nor a filename is specified, then the module\nwill read from the @ARGV array or STDIN, using the familiar E<lt>E<gt>\nsemantics.\n\nA string filehandle is handy if you want to modify the output in the\nmemory, before printing it out. The following program reads in EMBL\nformatted entries from a file and prints them out in fasta format with\nsome HTML tags:\n\n  use Bio::FeatureIO;\n  use IO::String;\n  my $in  = Bio::FeatureIO->new('-file' => \"my.gff\" ,\n  \t\t\t    '-format' => 'EMBL');\n  while ( my $f = $in->next_feature() ) {\n      # the output handle is reset for every file\n      my $stringio = IO::String->new($string);\n      my $out = Bio::FeatureIO->new('-fh' => $stringio,\n  \t\t\t        '-format' => 'gtf');\n      # output goes into $string\n      $out->write_feature($f);\n      # modify $string\n      $string =~ s|(>)(\\w+)|$1<font color=\"Red\">$2</font>|g;\n      # print into STDOUT\n      print $string;\n  }\n\n* -format\n\nSpecify the format of the file.  See above for list of supported formats\n\n* -flush\n\nBy default, all files (or filehandles) opened for writing sequences\nwill be flushed after each write_seq() (making the file immediately\nusable).  If you don't need this facility and would like to marginally\nimprove the efficiency of writing multiple sequences to the same file\n(or filehandle), pass the -flush option '0' or any other value that\nevaluates as defined but false:\n\n  my $f1 = Bio::FeatureIO->new -file   => \"<a.f1\",\n                              -format => \"f1\";\n  my $f2 = Bio::FeatureIO->new -file   => \">a.f2\",\n                              -format => \"f2\",\n                              -flush  => 0; # go as fast as we can!\n\n  while($feature = $f1->next_feature) { $f2->write_feature($feature) }\n\n\n=head2 Bio::FeatureIO-E<gt>newFh()\n\n   $fh = Bio::FeatureIO->newFh(-fh   => \\*FILEHANDLE, -format=>$format);\n   $fh = Bio::FeatureIO->newFh(-format => $format);\n   # etc.\n\nThis constructor behaves like new(), but returns a tied filehandle\nrather than a Bio::FeatureIO object.  You can read sequences from this\nobject using the familiar E<lt>E<gt> operator, and write to it using\nprint().  The usual array and $_ semantics work.  For example, you can\nread all sequence objects into an array like this:\n\n  @features = <$fh>;\n\nOther operations, such as read(), sysread(), write(), close(), and printf()\nare not supported.\n\n=head1 OBJECT METHODS\n\nSee below for more detailed summaries.  The main methods are:\n\n=head2 $feature = $featureIO-E<gt>next_feature()\n\nFetch the next feature from the stream.\n\n=head2 $featureIO-E<gt>write_feature($feature [,$another_feature,...])\n\nWrite the specified feature(s) to the stream.\n\n=head2 TIEHANDLE(), READLINE(), PRINT()\n\nThese provide the tie interface.  See L<perltie> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nEmail allenday@ucla.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' Let the code begin...\n\npackage Bio::FeatureIO;\n\nuse strict;\n\nuse Symbol;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : $stream = Bio::FeatureIO->new(-file => $filename, -format => 'Format')\n Function: Returns a new feature stream\n Returns : A Bio::FeatureIO stream initialised with the appropriate format\n Args    : Named parameters:\n             -file => $filename\n             -fh => filehandle to attach to\n             -format => format\n\n\nmy $entry = 0;\n\nsub new {\n  my ($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n\n  # or do we want to call SUPER on an object if $caller is an\n  # object?\n  if( $class =~ /Bio::FeatureIO::(\\S+)/ ) {\n\n    my ($self) = $class->SUPER::new(@args);\t\n    $self->_initialize(@args);\n    return $self;\n\n  } else {\n\n\tmy %param = @args;\n\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $format = $param{'-format'} ||\n      $class->_guess_format( $param{-file} || $ARGV[0] );\n\t\n\tif( ! $format ) {\n      if ($param{-file}) {\n        $format = $class->_guess_format($param{-file});\n      } elsif ($param{-fh}) {\n        $format = $class->_guess_format(undef);\n      }\n\t}\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n\treturn unless( $class->_load_format_module($format) );\n\treturn \"Bio::FeatureIO::$format\"->new(@args);\n\n  }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::FeatureIO->newFh(-file=>$filename,-format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::FeatureIO->newFh(-file=>$filename,-format=>'Format')\n           $feature = <$fh>;   # read a feature object\n           print $fh $feature; # write a feature object\n Returns : filehandle tied to the Bio::FeatureIO::Fh class\n Args    :\n\nSee L<Bio::FeatureIO::Fh>\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $feature = <$fh>;   # read a feature object\n           print $fh $feature; # write a feature object\n Returns : filehandle tied to Bio::FeatureIO class\n Args    : none\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n# _initialize is chained for all FeatureIO classes\n\nsub _initialize {\n    my($self, %arg) = @_;\n\n    # flush is initialized by the Root::IO init\n\n    # initialize the IO part\n    $self->seq($arg{-seq});\n    $self->_initialize_io(%arg);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $feature = stream->next_feature\n Function: Reads the next feature object from the stream and returns it.\n\n           Certain driver modules may encounter entries in the stream\n           that are either misformatted or that use syntax not yet\n           understood by the driver. If such an incident is\n           recoverable, e.g., by dismissing a feature of a feature\n           table or some other non-mandatory part of an entry, the\n           driver will issue a warning. In the case of a\n           non-recoverable situation an exception will be thrown.  Do\n           not assume that you can resume parsing the same stream\n           after catching the exception. Note that you can always turn\n           recoverable errors into exceptions by calling\n           $stream->verbose(2).\n\n Returns : a Bio::SeqFeatureI feature object\n Args    : none\n\nSee L<Bio::Root::RootI>, L<Bio::SeqFeatureI>\n\n\nsub next_feature {\n   my ($self, $seq) = @_;\n   $self->throw(\"Sorry, you cannot read from a generic Bio::FeatureIO object.\");\n}\n\n=head2 write_feature\n\n Title   : write_feature\n Usage   : $stream->write_feature($feature)\n Function: writes the $feature object into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::SeqFeature object\n\n\nsub write_feature {\n    my ($self, $seq) = @_;\n    if(ref($self) eq __PACKAGE__){\n      $self->throw(\"Sorry, you cannot write to a generic Bio::FeatureIO object.\");\n    } else {\n      $self->throw_not_implemented();\n    }\n}\n\n=head2 _load_format_module\n\n Title   : _load_format_module\n Usage   : *INTERNAL FeatureIO stuff*\n Function: Loads up (like use) a module at run time on demand\n Example :\n Returns :\n Args    :\n\n\nsub _load_format_module {\n    my ($self, $format) = @_;\n    my $class = ref($self) || $self;\n    my $module = $class.\"::$format\";#\"Bio::Feature::\" . $format;\n    my $ok;\n\n    eval {\n\t$ok = $self->_load_module($module);\n    };\n    if ( $@ ) {\n    print STDERR <<END;\n$self: $format cannot be found\nException $@\nFor more information about the FeatureIO system please see the FeatureIO docs.\nThis includes ways of checking for formats at compile time, not run time\nEND\n  ;\n  }\n  return $ok;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $obj->seq() OR $obj->seq($newSeq)\n Example :\n Returns : Bio::SeqI object\n Args    : newSeq (optional)\n\n\nsub seq {\n  my $self = shift;\n  my $val = shift;\n\n  $self->{'seq'} = $val if defined($val);\n  return $self->{'seq'};\n}\n\n=head2 _filehandle\n\n Title   : _filehandle\n Usage   : $obj->_filehandle($newval)\n Function: This method is deprecated. Call _fh() instead.\n Example :\n Returns : value of _filehandle\n Args    : newvalue (optional)"},"detail":"($self,@args)","kind":12,"children":[{"localvar":"my","containerName":"_filehandle","name":"$self","definition":"my","line":467,"kind":13},{"line":467,"kind":13,"containerName":"_filehandle","name":"@args"},{"containerName":"_filehandle","name":"$self","kind":13,"line":468},{"line":468,"kind":12,"containerName":"_filehandle","name":"_fh"},{"kind":13,"line":468,"name":"@args","containerName":"_filehandle"}],"line":466,"name":"_filehandle","range":{"end":{"character":9999,"line":469},"start":{"character":0,"line":466}}},{"line":483,"children":[{"containerName":"_guess_format","definition":"my","name":"$class","localvar":"my","kind":13,"line":484}],"kind":12,"range":{"end":{"line":492,"character":9999},"start":{"character":0,"line":483}},"containerName":"main::","definition":"sub","name":"_guess_format"},{"line":494,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"DESTROY","line":495,"kind":13},{"name":"$self","containerName":"DESTROY","line":496,"kind":13},{"kind":12,"line":496,"name":"close","containerName":"DESTROY"}],"kind":12,"range":{"end":{"line":497,"character":9999},"start":{"line":494,"character":0}},"containerName":"main::","name":"DESTROY","definition":"sub"},{"detail":"($class,$val)","signature":{"documentation":"","parameters":[{"label":"$class"},{"label":"$val"}],"label":"TIEHANDLE($class,$val)"},"containerName":"main::","definition":"sub","line":499,"children":[{"localvar":"my","name":"$class","definition":"my","containerName":"TIEHANDLE","line":500,"kind":13},{"name":"$val","containerName":"TIEHANDLE","line":500,"kind":13},{"line":501,"kind":13,"name":"$val","containerName":"TIEHANDLE"},{"name":"$class","containerName":"TIEHANDLE","line":501,"kind":13}],"kind":12,"range":{"start":{"character":0,"line":499},"end":{"character":9999,"line":502}},"name":"TIEHANDLE"},{"range":{"end":{"character":9999,"line":510},"start":{"character":0,"line":504}},"definition":"sub","name":"READLINE","containerName":"main::","children":[{"name":"$self","definition":"my","containerName":"READLINE","localvar":"my","kind":13,"line":505},{"kind":13,"line":506,"name":"$self","containerName":"READLINE"},{"kind":12,"line":506,"name":"next_feature","containerName":"READLINE"},{"line":507,"kind":13,"localvar":"my","containerName":"READLINE","definition":"my","name":"@list"},{"line":507,"kind":13,"name":"$obj","containerName":"READLINE"},{"name":"@list","containerName":"READLINE","kind":13,"line":508},{"kind":13,"line":508,"name":"$obj","containerName":"READLINE"},{"kind":13,"line":508,"name":"$obj","containerName":"READLINE"},{"line":508,"kind":13,"name":"$self","containerName":"READLINE"},{"name":"next_feature","containerName":"READLINE","kind":12,"line":508},{"name":"@list","containerName":"READLINE","line":509,"kind":13}],"line":504,"kind":12},{"kind":12,"children":[{"kind":13,"line":513,"containerName":"PRINT","name":"$self","definition":"my","localvar":"my"},{"name":"$self","containerName":"PRINT","kind":13,"line":514},{"name":"write_feature","containerName":"PRINT","kind":12,"line":514}],"line":512,"name":"PRINT","definition":"sub","containerName":"main::","range":{"end":{"line":515,"character":9999},"start":{"character":0,"line":512}}}]}