{"version":5,"vars":[{"containerName":"","name":"base","line":83,"kind":2},{"name":"add_sub_Location","range":{"end":{"character":9999,"line":117},"start":{"line":100,"character":0}},"definition":"sub","containerName":"main::","signature":{"label":"add_sub_Location($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Result.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Result\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Result - Results from coordinate transformation\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::Result;\n\n  #get results from a Bio::Coordinate::MapperI\n  $matched = $result->each_match;\n\n=head1 DESCRIPTION\n\nThe results from Bio::Coordinate::MapperI are kept in an object which\nitself is a split location, See L<Bio::Location::Split>. The results\nare either Matches or Gaps.  See L<Bio::Coordinate::Result::Match> and\nL<Bio::Coordinate::Result::Gap>.\n\nIf only one Match is returned, there is a convenience method of\nretrieving it or accessing its methods. Same holds true for a Gap.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Result;\nuse strict;\n\n\nuse base qw(Bio::Location::Split Bio::Coordinate::ResultI);\n\n\n=head2 add_location\n\n Title   : add_sub_Location\n Usage   : $obj->add_sub_Location($variant)\n Function: \n\n           Pushes one Bio::LocationI into the list of variants.\n\n Example : \n Returns : 1 when succeeds\n Args    : Location object"},"detail":"($self,$value)","kind":12,"children":[{"localvar":"my","containerName":"add_sub_Location","definition":"my","name":"$self","line":101,"kind":13},{"line":101,"kind":13,"containerName":"add_sub_Location","name":"$value"},{"line":102,"kind":13,"containerName":"add_sub_Location","name":"$value"},{"containerName":"add_sub_Location","name":"$self","line":103,"kind":13},{"containerName":"add_sub_Location","name":"warn","line":103,"kind":12},{"containerName":"add_sub_Location","name":"$self","kind":13,"line":106},{"line":106,"kind":12,"containerName":"add_sub_Location","name":"throw"},{"kind":13,"line":107,"name":"$value","containerName":"add_sub_Location"},{"name":"isa","containerName":"add_sub_Location","kind":12,"line":107},{"kind":13,"line":109,"name":"$self","containerName":"add_sub_Location"},{"name":"$value","containerName":"add_sub_Location","kind":13,"line":110},{"name":"$value","containerName":"add_sub_Location","kind":13,"line":110},{"name":"isa","containerName":"add_sub_Location","line":110,"kind":12},{"line":112,"kind":13,"name":"$self","containerName":"add_sub_Location"},{"name":"$value","containerName":"add_sub_Location","kind":13,"line":113},{"name":"$value","containerName":"add_sub_Location","line":113,"kind":13},{"containerName":"add_sub_Location","name":"isa","kind":12,"line":113},{"line":115,"kind":13,"name":"$self","containerName":"add_sub_Location"},{"kind":13,"line":115,"containerName":"add_sub_Location","name":"$value"}],"line":100},{"line":115,"kind":12,"containerName":"add_sub_Location","name":"SUPER"},{"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"add_result($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Result.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Result\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Result - Results from coordinate transformation\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::Result;\n\n  #get results from a Bio::Coordinate::MapperI\n  $matched = $result->each_match;\n\n=head1 DESCRIPTION\n\nThe results from Bio::Coordinate::MapperI are kept in an object which\nitself is a split location, See L<Bio::Location::Split>. The results\nare either Matches or Gaps.  See L<Bio::Coordinate::Result::Match> and\nL<Bio::Coordinate::Result::Gap>.\n\nIf only one Match is returned, there is a convenience method of\nretrieving it or accessing its methods. Same holds true for a Gap.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Result;\nuse strict;\n\n\nuse base qw(Bio::Location::Split Bio::Coordinate::ResultI);\n\n\n=head2 add_location\n\n Title   : add_sub_Location\n Usage   : $obj->add_sub_Location($variant)\n Function: \n\n           Pushes one Bio::LocationI into the list of variants.\n\n Example : \n Returns : 1 when succeeds\n Args    : Location object\n\n\nsub add_sub_Location {\n  my ($self,$value) = @_;\n  if( ! $value ) {\n      $self->warn(\"provding an empty value for location\\n\");\n      return;\n  }\n  $self->throw(\"Is not a Bio::LocationI but [$value]\")\n      unless $value->isa('Bio::LocationI');\n\n  $self->{'_match'} = $value\n      if $value->isa('Bio::Coordinate::Result::Match');\n\n  $self->{'_gap'} = $value\n      if $value->isa('Bio::Coordinate::Result::Gap');\n\n  $self->SUPER::add_sub_Location($value);\n\n}\n\n=head2 add_result\n\n Title   : add_result\n Usage   : $obj->add_result($result)\n Function: Adds the contents of one Bio::Coordinate::Result\n Example : \n Returns : 1 when succeeds\n Args    : Result object"},"kind":12,"line":130,"children":[{"kind":13,"line":131,"containerName":"add_result","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":131,"name":"$value","containerName":"add_result"},{"name":"$self","containerName":"add_result","kind":13,"line":133},{"containerName":"add_result","name":"throw","kind":12,"line":133},{"line":134,"kind":13,"containerName":"add_result","name":"$value"},{"line":134,"kind":12,"name":"isa","containerName":"add_result"},{"line":136,"kind":13,"name":"$self","containerName":"add_result"},{"name":"add_sub_Location","containerName":"add_result","line":136,"kind":12},{"line":136,"kind":13,"containerName":"add_result","name":"$value"},{"name":"each_Location","containerName":"add_result","kind":12,"line":136}],"name":"add_result","range":{"start":{"line":130,"character":0},"end":{"character":9999,"line":137}}},{"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"seq_id","line":155,"kind":13},{"containerName":"seq_id","name":"$seqid","line":155,"kind":13},{"containerName":"seq_id","definition":"my","name":"@ls","localvar":"my","kind":13,"line":157},{"kind":13,"line":157,"name":"$self","containerName":"seq_id"},{"name":"each_Location","containerName":"seq_id","line":157,"kind":12},{"kind":13,"line":158,"containerName":"seq_id","name":"@ls"},{"name":"$ls","containerName":"seq_id","kind":13,"line":159},{"kind":12,"line":159,"containerName":"seq_id","name":"seq_id"}],"line":154,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$seqid"}],"documentation":"1;\n# $Id: Result.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Result\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Result - Results from coordinate transformation\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::Result;\n\n  #get results from a Bio::Coordinate::MapperI\n  $matched = $result->each_match;\n\n=head1 DESCRIPTION\n\nThe results from Bio::Coordinate::MapperI are kept in an object which\nitself is a split location, See L<Bio::Location::Split>. The results\nare either Matches or Gaps.  See L<Bio::Coordinate::Result::Match> and\nL<Bio::Coordinate::Result::Gap>.\n\nIf only one Match is returned, there is a convenience method of\nretrieving it or accessing its methods. Same holds true for a Gap.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Result;\nuse strict;\n\n\nuse base qw(Bio::Location::Split Bio::Coordinate::ResultI);\n\n\n=head2 add_location\n\n Title   : add_sub_Location\n Usage   : $obj->add_sub_Location($variant)\n Function: \n\n           Pushes one Bio::LocationI into the list of variants.\n\n Example : \n Returns : 1 when succeeds\n Args    : Location object\n\n\nsub add_sub_Location {\n  my ($self,$value) = @_;\n  if( ! $value ) {\n      $self->warn(\"provding an empty value for location\\n\");\n      return;\n  }\n  $self->throw(\"Is not a Bio::LocationI but [$value]\")\n      unless $value->isa('Bio::LocationI');\n\n  $self->{'_match'} = $value\n      if $value->isa('Bio::Coordinate::Result::Match');\n\n  $self->{'_gap'} = $value\n      if $value->isa('Bio::Coordinate::Result::Gap');\n\n  $self->SUPER::add_sub_Location($value);\n\n}\n\n=head2 add_result\n\n Title   : add_result\n Usage   : $obj->add_result($result)\n Function: Adds the contents of one Bio::Coordinate::Result\n Example : \n Returns : 1 when succeeds\n Args    : Result object\n\n\nsub add_result {\n  my ($self,$value) = @_;\n\n  $self->throw(\"Is not a Bio::Coordinate::Result but [$value]\")\n      unless $value->isa('Bio::Coordinate::Result');\n\n  map { $self->add_sub_Location($_) } $value->each_Location;\n}\n\n=head2 seq_id\n\n  Title   : seq_id\n  Usage   : my $seqid = $location->seq_id();\n  Function: Get/Set seq_id that location refers to\n\n            We override this here in order to propagate to all sublocations\n            which are not remote (provided this root is not remote either)\n\n  Returns : seq_id\n  Args    : [optional] seq_id value to set","label":"seq_id($self,$seqid)"},"detail":"($self,$seqid)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":154},"end":{"line":163,"character":9999}},"name":"seq_id"},{"children":[{"name":"$self","definition":"my","containerName":"each_gap","localvar":"my","kind":13,"line":186},{"definition":"my","name":"@gaps","containerName":"each_gap","localvar":"my","kind":13,"line":188},{"kind":13,"line":189,"name":"$gap","definition":"my","containerName":"each_gap","localvar":"my"},{"name":"$self","containerName":"each_gap","kind":13,"line":189},{"kind":12,"line":189,"name":"each_Location","containerName":"each_gap"},{"name":"@gaps","containerName":"each_gap","line":190,"kind":13},{"line":190,"kind":13,"containerName":"each_gap","name":"$gap"},{"name":"$gap","containerName":"each_gap","kind":13,"line":190},{"line":190,"kind":12,"name":"isa","containerName":"each_gap"},{"line":192,"kind":13,"name":"@gaps","containerName":"each_gap"}],"line":185,"kind":12,"signature":{"label":"each_gap($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Result.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Result\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Result - Results from coordinate transformation\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::Result;\n\n  #get results from a Bio::Coordinate::MapperI\n  $matched = $result->each_match;\n\n=head1 DESCRIPTION\n\nThe results from Bio::Coordinate::MapperI are kept in an object which\nitself is a split location, See L<Bio::Location::Split>. The results\nare either Matches or Gaps.  See L<Bio::Coordinate::Result::Match> and\nL<Bio::Coordinate::Result::Gap>.\n\nIf only one Match is returned, there is a convenience method of\nretrieving it or accessing its methods. Same holds true for a Gap.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Result;\nuse strict;\n\n\nuse base qw(Bio::Location::Split Bio::Coordinate::ResultI);\n\n\n=head2 add_location\n\n Title   : add_sub_Location\n Usage   : $obj->add_sub_Location($variant)\n Function: \n\n           Pushes one Bio::LocationI into the list of variants.\n\n Example : \n Returns : 1 when succeeds\n Args    : Location object\n\n\nsub add_sub_Location {\n  my ($self,$value) = @_;\n  if( ! $value ) {\n      $self->warn(\"provding an empty value for location\\n\");\n      return;\n  }\n  $self->throw(\"Is not a Bio::LocationI but [$value]\")\n      unless $value->isa('Bio::LocationI');\n\n  $self->{'_match'} = $value\n      if $value->isa('Bio::Coordinate::Result::Match');\n\n  $self->{'_gap'} = $value\n      if $value->isa('Bio::Coordinate::Result::Gap');\n\n  $self->SUPER::add_sub_Location($value);\n\n}\n\n=head2 add_result\n\n Title   : add_result\n Usage   : $obj->add_result($result)\n Function: Adds the contents of one Bio::Coordinate::Result\n Example : \n Returns : 1 when succeeds\n Args    : Result object\n\n\nsub add_result {\n  my ($self,$value) = @_;\n\n  $self->throw(\"Is not a Bio::Coordinate::Result but [$value]\")\n      unless $value->isa('Bio::Coordinate::Result');\n\n  map { $self->add_sub_Location($_) } $value->each_Location;\n}\n\n=head2 seq_id\n\n  Title   : seq_id\n  Usage   : my $seqid = $location->seq_id();\n  Function: Get/Set seq_id that location refers to\n\n            We override this here in order to propagate to all sublocations\n            which are not remote (provided this root is not remote either)\n\n  Returns : seq_id\n  Args    : [optional] seq_id value to set\n\n\n\nsub seq_id {\n    my ($self, $seqid) = @_;\n\n    my @ls = $self->each_Location;\n    if (@ls) {\n\treturn $ls[0]->seq_id;\n    } else {\n\treturn;\n    }\n}\n\n\n=head2 Convenience methods\n\nThese methods are shortcuts to Match and Gap locations.\n\n\n=head2 each_gap\n\n Title   : each_gap\n Usage   : $obj->each_gap();\n Function: \n\n            Returns a list of Bio::Coordianate::Result::Gap objects.\n\n Returns : list of gaps\n Args    : none"},"detail":"($self)","definition":"sub","containerName":"main::","range":{"end":{"line":194,"character":9999},"start":{"character":0,"line":185}},"name":"each_gap"},{"name":"each_match","range":{"start":{"line":210,"character":0},"end":{"line":218,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"each_match($self)","documentation":"1;\n# $Id: Result.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Result\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Result - Results from coordinate transformation\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::Result;\n\n  #get results from a Bio::Coordinate::MapperI\n  $matched = $result->each_match;\n\n=head1 DESCRIPTION\n\nThe results from Bio::Coordinate::MapperI are kept in an object which\nitself is a split location, See L<Bio::Location::Split>. The results\nare either Matches or Gaps.  See L<Bio::Coordinate::Result::Match> and\nL<Bio::Coordinate::Result::Gap>.\n\nIf only one Match is returned, there is a convenience method of\nretrieving it or accessing its methods. Same holds true for a Gap.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Result;\nuse strict;\n\n\nuse base qw(Bio::Location::Split Bio::Coordinate::ResultI);\n\n\n=head2 add_location\n\n Title   : add_sub_Location\n Usage   : $obj->add_sub_Location($variant)\n Function: \n\n           Pushes one Bio::LocationI into the list of variants.\n\n Example : \n Returns : 1 when succeeds\n Args    : Location object\n\n\nsub add_sub_Location {\n  my ($self,$value) = @_;\n  if( ! $value ) {\n      $self->warn(\"provding an empty value for location\\n\");\n      return;\n  }\n  $self->throw(\"Is not a Bio::LocationI but [$value]\")\n      unless $value->isa('Bio::LocationI');\n\n  $self->{'_match'} = $value\n      if $value->isa('Bio::Coordinate::Result::Match');\n\n  $self->{'_gap'} = $value\n      if $value->isa('Bio::Coordinate::Result::Gap');\n\n  $self->SUPER::add_sub_Location($value);\n\n}\n\n=head2 add_result\n\n Title   : add_result\n Usage   : $obj->add_result($result)\n Function: Adds the contents of one Bio::Coordinate::Result\n Example : \n Returns : 1 when succeeds\n Args    : Result object\n\n\nsub add_result {\n  my ($self,$value) = @_;\n\n  $self->throw(\"Is not a Bio::Coordinate::Result but [$value]\")\n      unless $value->isa('Bio::Coordinate::Result');\n\n  map { $self->add_sub_Location($_) } $value->each_Location;\n}\n\n=head2 seq_id\n\n  Title   : seq_id\n  Usage   : my $seqid = $location->seq_id();\n  Function: Get/Set seq_id that location refers to\n\n            We override this here in order to propagate to all sublocations\n            which are not remote (provided this root is not remote either)\n\n  Returns : seq_id\n  Args    : [optional] seq_id value to set\n\n\n\nsub seq_id {\n    my ($self, $seqid) = @_;\n\n    my @ls = $self->each_Location;\n    if (@ls) {\n\treturn $ls[0]->seq_id;\n    } else {\n\treturn;\n    }\n}\n\n\n=head2 Convenience methods\n\nThese methods are shortcuts to Match and Gap locations.\n\n\n=head2 each_gap\n\n Title   : each_gap\n Usage   : $obj->each_gap();\n Function: \n\n            Returns a list of Bio::Coordianate::Result::Gap objects.\n\n Returns : list of gaps\n Args    : none\n\n\nsub each_gap {\n   my ($self) = @_;\n\n   my @gaps;\n   foreach my $gap ($self->each_Location) {\n       push @gaps, $gap if $gap->isa('Bio::Coordinate::Result::Gap');\n   }\n   return @gaps;\n\n}\n\n\n=head2 each_match\n\n Title   : each_match\n Usage   : $obj->each_match();\n Function: \n\n            Returns a list of Bio::Coordinate::Result::Match objects.\n\n Returns : list of Matchs\n Args    : none","parameters":[{"label":"$self"}]},"kind":12,"line":210,"children":[{"line":211,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"each_match"},{"kind":13,"line":213,"containerName":"each_match","name":"@matches","definition":"my","localvar":"my"},{"line":214,"kind":13,"localvar":"my","containerName":"each_match","name":"$match","definition":"my"},{"line":214,"kind":13,"containerName":"each_match","name":"$self"},{"name":"each_Location","containerName":"each_match","kind":12,"line":214},{"line":215,"kind":13,"name":"@matches","containerName":"each_match"},{"containerName":"each_match","name":"$match","kind":13,"line":215},{"name":"$match","containerName":"each_match","line":215,"kind":13},{"containerName":"each_match","name":"isa","line":215,"kind":12},{"line":217,"kind":13,"containerName":"each_match","name":"@matches"}]},{"range":{"end":{"line":241,"character":9999},"start":{"line":231,"character":0}},"name":"match","children":[{"line":232,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"match"},{"kind":13,"line":234,"containerName":"match","name":"$self"},{"containerName":"match","name":"warn","line":234,"kind":12},{"name":"$self","containerName":"match","kind":13,"line":235},{"containerName":"match","name":"each_match","kind":12,"line":235},{"name":"$self","containerName":"match","kind":13,"line":235},{"name":"verbose","containerName":"match","kind":12,"line":235},{"line":236,"kind":13,"name":"$self","containerName":"match"},{"localvar":"my","containerName":"match","name":"@m","definition":"my","line":237,"kind":13},{"containerName":"match","name":"$self","kind":13,"line":237},{"name":"each_match","containerName":"match","kind":12,"line":237},{"name":"$self","containerName":"match","kind":13,"line":238},{"line":238,"kind":13,"containerName":"match","name":"$m"},{"line":240,"kind":13,"containerName":"match","name":"$self"}],"line":231,"kind":12,"signature":{"label":"match($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Result.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Result\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Result - Results from coordinate transformation\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::Result;\n\n  #get results from a Bio::Coordinate::MapperI\n  $matched = $result->each_match;\n\n=head1 DESCRIPTION\n\nThe results from Bio::Coordinate::MapperI are kept in an object which\nitself is a split location, See L<Bio::Location::Split>. The results\nare either Matches or Gaps.  See L<Bio::Coordinate::Result::Match> and\nL<Bio::Coordinate::Result::Gap>.\n\nIf only one Match is returned, there is a convenience method of\nretrieving it or accessing its methods. Same holds true for a Gap.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Result;\nuse strict;\n\n\nuse base qw(Bio::Location::Split Bio::Coordinate::ResultI);\n\n\n=head2 add_location\n\n Title   : add_sub_Location\n Usage   : $obj->add_sub_Location($variant)\n Function: \n\n           Pushes one Bio::LocationI into the list of variants.\n\n Example : \n Returns : 1 when succeeds\n Args    : Location object\n\n\nsub add_sub_Location {\n  my ($self,$value) = @_;\n  if( ! $value ) {\n      $self->warn(\"provding an empty value for location\\n\");\n      return;\n  }\n  $self->throw(\"Is not a Bio::LocationI but [$value]\")\n      unless $value->isa('Bio::LocationI');\n\n  $self->{'_match'} = $value\n      if $value->isa('Bio::Coordinate::Result::Match');\n\n  $self->{'_gap'} = $value\n      if $value->isa('Bio::Coordinate::Result::Gap');\n\n  $self->SUPER::add_sub_Location($value);\n\n}\n\n=head2 add_result\n\n Title   : add_result\n Usage   : $obj->add_result($result)\n Function: Adds the contents of one Bio::Coordinate::Result\n Example : \n Returns : 1 when succeeds\n Args    : Result object\n\n\nsub add_result {\n  my ($self,$value) = @_;\n\n  $self->throw(\"Is not a Bio::Coordinate::Result but [$value]\")\n      unless $value->isa('Bio::Coordinate::Result');\n\n  map { $self->add_sub_Location($_) } $value->each_Location;\n}\n\n=head2 seq_id\n\n  Title   : seq_id\n  Usage   : my $seqid = $location->seq_id();\n  Function: Get/Set seq_id that location refers to\n\n            We override this here in order to propagate to all sublocations\n            which are not remote (provided this root is not remote either)\n\n  Returns : seq_id\n  Args    : [optional] seq_id value to set\n\n\n\nsub seq_id {\n    my ($self, $seqid) = @_;\n\n    my @ls = $self->each_Location;\n    if (@ls) {\n\treturn $ls[0]->seq_id;\n    } else {\n\treturn;\n    }\n}\n\n\n=head2 Convenience methods\n\nThese methods are shortcuts to Match and Gap locations.\n\n\n=head2 each_gap\n\n Title   : each_gap\n Usage   : $obj->each_gap();\n Function: \n\n            Returns a list of Bio::Coordianate::Result::Gap objects.\n\n Returns : list of gaps\n Args    : none\n\n\nsub each_gap {\n   my ($self) = @_;\n\n   my @gaps;\n   foreach my $gap ($self->each_Location) {\n       push @gaps, $gap if $gap->isa('Bio::Coordinate::Result::Gap');\n   }\n   return @gaps;\n\n}\n\n\n=head2 each_match\n\n Title   : each_match\n Usage   : $obj->each_match();\n Function: \n\n            Returns a list of Bio::Coordinate::Result::Match objects.\n\n Returns : list of Matchs\n Args    : none\n\n\nsub each_match {\n   my ($self) = @_;\n\n   my @matches;\n   foreach my $match ($self->each_Location) {\n       push @matches, $match if $match->isa('Bio::Coordinate::Result::Match');\n   }\n   return @matches;\n}\n\n=head2 match\n\n Title   : match\n Usage   : $match_object = $obj->match(); #or\n           $gstart = $obj->gap->start;\n Function: Read only method for retrieving or accessing the match object.\n Returns : one Bio::Coordinate::Result::Match\n Args    : "},"detail":"($self)","definition":"sub","containerName":"main::"},{"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"gap","line":255,"kind":13},{"name":"$self","containerName":"gap","line":257,"kind":13},{"containerName":"gap","name":"warn","kind":12,"line":257},{"kind":13,"line":258,"containerName":"gap","name":"$self"},{"line":258,"kind":12,"containerName":"gap","name":"each_gap"},{"kind":13,"line":258,"containerName":"gap","name":"$self"},{"kind":12,"line":258,"name":"verbose","containerName":"gap"},{"line":259,"kind":13,"name":"$self","containerName":"gap"},{"kind":13,"line":260,"containerName":"gap","name":"@m","definition":"my","localvar":"my"},{"name":"$self","containerName":"gap","line":260,"kind":13},{"containerName":"gap","name":"each_gap","line":260,"kind":12},{"name":"$self","containerName":"gap","line":261,"kind":13},{"kind":13,"line":261,"name":"$m","containerName":"gap"},{"containerName":"gap","name":"$self","line":263,"kind":13}],"line":254,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: Result.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Result\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Result - Results from coordinate transformation\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::Result;\n\n  #get results from a Bio::Coordinate::MapperI\n  $matched = $result->each_match;\n\n=head1 DESCRIPTION\n\nThe results from Bio::Coordinate::MapperI are kept in an object which\nitself is a split location, See L<Bio::Location::Split>. The results\nare either Matches or Gaps.  See L<Bio::Coordinate::Result::Match> and\nL<Bio::Coordinate::Result::Gap>.\n\nIf only one Match is returned, there is a convenience method of\nretrieving it or accessing its methods. Same holds true for a Gap.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Result;\nuse strict;\n\n\nuse base qw(Bio::Location::Split Bio::Coordinate::ResultI);\n\n\n=head2 add_location\n\n Title   : add_sub_Location\n Usage   : $obj->add_sub_Location($variant)\n Function: \n\n           Pushes one Bio::LocationI into the list of variants.\n\n Example : \n Returns : 1 when succeeds\n Args    : Location object\n\n\nsub add_sub_Location {\n  my ($self,$value) = @_;\n  if( ! $value ) {\n      $self->warn(\"provding an empty value for location\\n\");\n      return;\n  }\n  $self->throw(\"Is not a Bio::LocationI but [$value]\")\n      unless $value->isa('Bio::LocationI');\n\n  $self->{'_match'} = $value\n      if $value->isa('Bio::Coordinate::Result::Match');\n\n  $self->{'_gap'} = $value\n      if $value->isa('Bio::Coordinate::Result::Gap');\n\n  $self->SUPER::add_sub_Location($value);\n\n}\n\n=head2 add_result\n\n Title   : add_result\n Usage   : $obj->add_result($result)\n Function: Adds the contents of one Bio::Coordinate::Result\n Example : \n Returns : 1 when succeeds\n Args    : Result object\n\n\nsub add_result {\n  my ($self,$value) = @_;\n\n  $self->throw(\"Is not a Bio::Coordinate::Result but [$value]\")\n      unless $value->isa('Bio::Coordinate::Result');\n\n  map { $self->add_sub_Location($_) } $value->each_Location;\n}\n\n=head2 seq_id\n\n  Title   : seq_id\n  Usage   : my $seqid = $location->seq_id();\n  Function: Get/Set seq_id that location refers to\n\n            We override this here in order to propagate to all sublocations\n            which are not remote (provided this root is not remote either)\n\n  Returns : seq_id\n  Args    : [optional] seq_id value to set\n\n\n\nsub seq_id {\n    my ($self, $seqid) = @_;\n\n    my @ls = $self->each_Location;\n    if (@ls) {\n\treturn $ls[0]->seq_id;\n    } else {\n\treturn;\n    }\n}\n\n\n=head2 Convenience methods\n\nThese methods are shortcuts to Match and Gap locations.\n\n\n=head2 each_gap\n\n Title   : each_gap\n Usage   : $obj->each_gap();\n Function: \n\n            Returns a list of Bio::Coordianate::Result::Gap objects.\n\n Returns : list of gaps\n Args    : none\n\n\nsub each_gap {\n   my ($self) = @_;\n\n   my @gaps;\n   foreach my $gap ($self->each_Location) {\n       push @gaps, $gap if $gap->isa('Bio::Coordinate::Result::Gap');\n   }\n   return @gaps;\n\n}\n\n\n=head2 each_match\n\n Title   : each_match\n Usage   : $obj->each_match();\n Function: \n\n            Returns a list of Bio::Coordinate::Result::Match objects.\n\n Returns : list of Matchs\n Args    : none\n\n\nsub each_match {\n   my ($self) = @_;\n\n   my @matches;\n   foreach my $match ($self->each_Location) {\n       push @matches, $match if $match->isa('Bio::Coordinate::Result::Match');\n   }\n   return @matches;\n}\n\n=head2 match\n\n Title   : match\n Usage   : $match_object = $obj->match(); #or\n           $gstart = $obj->gap->start;\n Function: Read only method for retrieving or accessing the match object.\n Returns : one Bio::Coordinate::Result::Match\n Args    : \n\n\nsub match {\n   my ($self) = @_;\n\n   $self->warn(\"More than one match in results\")\n       if $self->each_match > 1 and $self->verbose > 0;\n   unless (defined $self->{'_match'} ) {\n       my @m = $self->each_match;\n       $self->{'_match'} = $m[-1];\n   }\n   return $self->{'_match'};\n}\n\n=head2 gap\n\n Title   : gap\n Usage   : $gap_object = $obj->gap(); #or\n           $gstart = $obj->gap->start;\n Function: Read only method for retrieving or accessing the gap object.\n Returns : one Bio::Coordinate::Result::Gap\n Args    : ","parameters":[{"label":"$self"}],"label":"gap($self)"},"detail":"($self)","name":"gap","range":{"start":{"character":0,"line":254},"end":{"character":9999,"line":264}}},{"name":"purge_gaps","range":{"end":{"line":289,"character":9999},"start":{"line":277,"character":0}},"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"purge_gaps","line":278,"kind":13},{"containerName":"purge_gaps","name":"@matches","definition":"my","localvar":"my","kind":13,"line":279},{"localvar":"my","containerName":"purge_gaps","definition":"my","name":"$count","line":280,"kind":13},{"localvar":"my","definition":"my","name":"$loc","containerName":"purge_gaps","line":282,"kind":13},{"kind":13,"line":282,"containerName":"purge_gaps","name":"$self"},{"line":282,"kind":12,"name":"each_Location","containerName":"purge_gaps"},{"line":283,"kind":13,"containerName":"purge_gaps","name":"$loc"},{"name":"isa","containerName":"purge_gaps","kind":12,"line":283},{"kind":13,"line":284,"name":"@matches","containerName":"purge_gaps"},{"kind":13,"line":284,"containerName":"purge_gaps","name":"$loc"},{"name":"$count","containerName":"purge_gaps","line":286,"kind":13},{"line":289,"kind":13,"containerName":"purge_gaps","name":"$self"}],"line":277,"definition":"sub","containerName":"main::","signature":{"label":"purge_gaps($self)","documentation":"1;\n# $Id: Result.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Result\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Result - Results from coordinate transformation\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::Result;\n\n  #get results from a Bio::Coordinate::MapperI\n  $matched = $result->each_match;\n\n=head1 DESCRIPTION\n\nThe results from Bio::Coordinate::MapperI are kept in an object which\nitself is a split location, See L<Bio::Location::Split>. The results\nare either Matches or Gaps.  See L<Bio::Coordinate::Result::Match> and\nL<Bio::Coordinate::Result::Gap>.\n\nIf only one Match is returned, there is a convenience method of\nretrieving it or accessing its methods. Same holds true for a Gap.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Result;\nuse strict;\n\n\nuse base qw(Bio::Location::Split Bio::Coordinate::ResultI);\n\n\n=head2 add_location\n\n Title   : add_sub_Location\n Usage   : $obj->add_sub_Location($variant)\n Function: \n\n           Pushes one Bio::LocationI into the list of variants.\n\n Example : \n Returns : 1 when succeeds\n Args    : Location object\n\n\nsub add_sub_Location {\n  my ($self,$value) = @_;\n  if( ! $value ) {\n      $self->warn(\"provding an empty value for location\\n\");\n      return;\n  }\n  $self->throw(\"Is not a Bio::LocationI but [$value]\")\n      unless $value->isa('Bio::LocationI');\n\n  $self->{'_match'} = $value\n      if $value->isa('Bio::Coordinate::Result::Match');\n\n  $self->{'_gap'} = $value\n      if $value->isa('Bio::Coordinate::Result::Gap');\n\n  $self->SUPER::add_sub_Location($value);\n\n}\n\n=head2 add_result\n\n Title   : add_result\n Usage   : $obj->add_result($result)\n Function: Adds the contents of one Bio::Coordinate::Result\n Example : \n Returns : 1 when succeeds\n Args    : Result object\n\n\nsub add_result {\n  my ($self,$value) = @_;\n\n  $self->throw(\"Is not a Bio::Coordinate::Result but [$value]\")\n      unless $value->isa('Bio::Coordinate::Result');\n\n  map { $self->add_sub_Location($_) } $value->each_Location;\n}\n\n=head2 seq_id\n\n  Title   : seq_id\n  Usage   : my $seqid = $location->seq_id();\n  Function: Get/Set seq_id that location refers to\n\n            We override this here in order to propagate to all sublocations\n            which are not remote (provided this root is not remote either)\n\n  Returns : seq_id\n  Args    : [optional] seq_id value to set\n\n\n\nsub seq_id {\n    my ($self, $seqid) = @_;\n\n    my @ls = $self->each_Location;\n    if (@ls) {\n\treturn $ls[0]->seq_id;\n    } else {\n\treturn;\n    }\n}\n\n\n=head2 Convenience methods\n\nThese methods are shortcuts to Match and Gap locations.\n\n\n=head2 each_gap\n\n Title   : each_gap\n Usage   : $obj->each_gap();\n Function: \n\n            Returns a list of Bio::Coordianate::Result::Gap objects.\n\n Returns : list of gaps\n Args    : none\n\n\nsub each_gap {\n   my ($self) = @_;\n\n   my @gaps;\n   foreach my $gap ($self->each_Location) {\n       push @gaps, $gap if $gap->isa('Bio::Coordinate::Result::Gap');\n   }\n   return @gaps;\n\n}\n\n\n=head2 each_match\n\n Title   : each_match\n Usage   : $obj->each_match();\n Function: \n\n            Returns a list of Bio::Coordinate::Result::Match objects.\n\n Returns : list of Matchs\n Args    : none\n\n\nsub each_match {\n   my ($self) = @_;\n\n   my @matches;\n   foreach my $match ($self->each_Location) {\n       push @matches, $match if $match->isa('Bio::Coordinate::Result::Match');\n   }\n   return @matches;\n}\n\n=head2 match\n\n Title   : match\n Usage   : $match_object = $obj->match(); #or\n           $gstart = $obj->gap->start;\n Function: Read only method for retrieving or accessing the match object.\n Returns : one Bio::Coordinate::Result::Match\n Args    : \n\n\nsub match {\n   my ($self) = @_;\n\n   $self->warn(\"More than one match in results\")\n       if $self->each_match > 1 and $self->verbose > 0;\n   unless (defined $self->{'_match'} ) {\n       my @m = $self->each_match;\n       $self->{'_match'} = $m[-1];\n   }\n   return $self->{'_match'};\n}\n\n=head2 gap\n\n Title   : gap\n Usage   : $gap_object = $obj->gap(); #or\n           $gstart = $obj->gap->start;\n Function: Read only method for retrieving or accessing the gap object.\n Returns : one Bio::Coordinate::Result::Gap\n Args    : \n\n\nsub gap {\n   my ($self) = @_;\n\n   $self->warn(\"More than one gap in results\")\n       if $self->each_gap > 1 and $self->verbose > 0;\n   unless (defined $self->{'_gap'} ) {\n       my @m = $self->each_gap;\n       $self->{'_gap'} = $m[-1];\n   }\n   return $self->{'_gap'};\n}\n\n\n=head2 purge_gaps\n\n Title   : purge_gaps\n Usage   : $gap_count = $obj->purge_gaps;\n Function: remove all gaps from the Result\n Returns : count of removed gaps\n Args    : ","parameters":[{"label":"$self"}]},"detail":"($self)"},{"name":"%self","containerName":null,"kind":13,"line":290},{"name":"%self","containerName":null,"line":291,"kind":13},{"name":"@matches","containerName":null,"line":291,"kind":13},{"kind":13,"line":292,"containerName":null,"name":"$count"}]}