{"vars":[{"containerName":"","name":"base","kind":2,"line":112},{"range":{"end":{"character":9999,"line":135},"start":{"line":115,"character":0}},"name":"new","signature":{"documentation":"","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"detail":"($class,@args)","definition":"sub","containerName":"main::","children":[{"containerName":"new","name":"$class","definition":"my","localvar":"my","kind":13,"line":116},{"line":116,"kind":13,"containerName":"new","name":"@args"},{"localvar":"my","containerName":"new","name":"$self","definition":"my","line":117,"kind":13},{"name":"$class","containerName":"new","line":117,"kind":13},{"kind":13,"line":117,"name":"@args","containerName":"new"},{"line":119,"kind":13,"containerName":"new","name":"$self"},{"line":121,"kind":13,"localvar":"my","containerName":"new","name":"$in","definition":"my"},{"line":121,"kind":13,"name":"$out","containerName":"new"},{"kind":13,"line":121,"name":"$strict","containerName":"new"},{"kind":13,"line":121,"name":"$mappers","containerName":"new"},{"kind":13,"line":121,"containerName":"new","name":"$return_match"},{"containerName":"new","name":"$self","kind":13,"line":122},{"name":"_rearrange","containerName":"new","line":122,"kind":12},{"name":"@args","containerName":"new","kind":13,"line":128},{"name":"$in","containerName":"new","kind":13,"line":130},{"containerName":"new","name":"$self","line":130,"kind":13},{"name":"in","containerName":"new","kind":12,"line":130},{"name":"$in","containerName":"new","line":130,"kind":13},{"kind":13,"line":131,"containerName":"new","name":"$out"},{"name":"$self","containerName":"new","kind":13,"line":131},{"name":"out","containerName":"new","kind":12,"line":131},{"line":131,"kind":13,"name":"$out","containerName":"new"},{"name":"$mappers","containerName":"new","kind":13,"line":132},{"line":132,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":132,"containerName":"new","name":"mappers"},{"kind":13,"line":132,"name":"$mappers","containerName":"new"},{"kind":13,"line":133,"containerName":"new","name":"$return_match"},{"name":"$self","containerName":"new","line":133,"kind":13},{"containerName":"new","name":"return_match","kind":12,"line":133},{"kind":13,"line":134,"name":"$self","containerName":"new"}],"line":115,"kind":12},{"line":117,"kind":12,"containerName":"new","name":"SUPER"},{"name":"add_mapper","range":{"start":{"line":150,"character":0},"end":{"character":9999,"line":163}},"definition":"sub","containerName":"main::","signature":{"label":"add_mapper($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Collection\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Collection - Noncontinuous match between two coordinate sets\n\n=head1 SYNOPSIS\n\n  # create Bio::Coordinate::Pairs or other Bio::Coordinate::MapperIs somehow\n  $pair1; $pair2;\n\n  # add them into a Collection\n  $collection = Bio::Coordinate::Collection->new;\n  $collection->add_mapper($pair1);\n  $collection->add_mapper($pair2);\n\n  # create a position and map it\n  $pos = Bio::Location::Simple->new (-start => 5, -end => 9 );\n  $res = $collection->map($pos);\n  $res->match->start == 1;\n  $res->match->end == 5;\n\n  # if mapping is many to one (*>1) or many-to-many (*>*)\n  # you have to give seq_id not get unrelevant entries\n  $pos = Bio::Location::Simple->new\n      (-start => 5, -end => 9 -seq_id=>'clone1');\n\n=head1 DESCRIPTION\n\nGeneric, context neutral mapper to provide coordinate transforms\nbetween two B<disjoint> coordinate systems. It brings into Bioperl the\nfunctionality from Ewan Birney's Bio::EnsEMBL::Mapper ported into\ncurrent bioperl.\n\nThis class is aimed for representing mapping between whole chromosomes\nand contigs, or between contigs and clones, or between sequencing\nreads and assembly. The submaps are automatically sorted, so they can\nbe added in any order.\n\nTo map coordinates to the other direction, you have to swap() the\ncollection. Keeping track of the direction and ID restrictions\nare left to the calling code.\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Collection;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Coordinate::Result;\nuse Bio::Coordinate::Result::Gap;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    $self->{'_mappers'} = [];\n\n    my($in, $out, $strict, $mappers, $return_match) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              STRICT\n                              MAPPERS\n                              RETURN_MATCH\n\t\t\t     )],\n\t\t\t @args);\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $mappers && $self->mappers($mappers);\n    $return_match && $self->return_match('return_match');\n    return $self; # success - we hope!\n}\n\n\n=head2 add_mapper\n\n Title   : add_mapper\n Usage   : $obj->add_mapper($mapper)\n Function: Pushes one Bio::Coordinate::MapperI into the list of mappers.\n           Sets _is_sorted() to false.\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : mapper object"},"detail":"($self,$value)","kind":12,"children":[{"containerName":"add_mapper","name":"$self","definition":"my","localvar":"my","kind":13,"line":151},{"containerName":"add_mapper","name":"$value","line":151,"kind":13},{"containerName":"add_mapper","name":"$self","line":153,"kind":13},{"name":"throw","containerName":"add_mapper","line":153,"kind":12},{"containerName":"add_mapper","name":"$value","line":154,"kind":13},{"kind":13,"line":154,"name":"$value","containerName":"add_mapper"},{"name":"isa","containerName":"add_mapper","line":154,"kind":12},{"line":157,"kind":13,"name":"$self","containerName":"add_mapper"},{"kind":12,"line":157,"containerName":"add_mapper","name":"warn"},{"name":"$value","containerName":"add_mapper","kind":13,"line":157},{"line":158,"kind":13,"containerName":"add_mapper","name":"$value"},{"line":158,"kind":12,"containerName":"add_mapper","name":"in"},{"containerName":"add_mapper","name":"seq_id","line":158,"kind":12},{"name":"$value","containerName":"add_mapper","kind":13,"line":158},{"containerName":"add_mapper","name":"out","line":158,"kind":12},{"kind":12,"line":158,"name":"seq_id","containerName":"add_mapper"},{"name":"$value","containerName":"add_mapper","line":160,"kind":13},{"name":"test","containerName":"add_mapper","kind":12,"line":160},{"kind":13,"line":162,"name":"$self","containerName":"add_mapper"},{"line":162,"kind":12,"containerName":"add_mapper","name":"_is_sorted"},{"line":163,"kind":13,"name":"$self","containerName":"add_mapper"}],"line":150},{"containerName":null,"name":"$value","kind":13,"line":163},{"name":"mappers","range":{"end":{"character":9999,"line":185},"start":{"character":0,"line":177}},"kind":12,"line":177,"children":[{"containerName":"mappers","name":"$self","definition":"my","localvar":"my","kind":13,"line":178},{"line":178,"kind":13,"containerName":"mappers","name":"@args"},{"name":"@args","containerName":"mappers","line":180,"kind":13},{"containerName":"mappers","name":"$self","line":182,"kind":13},{"name":"throw","containerName":"mappers","kind":12,"line":182},{"line":183,"kind":13,"containerName":"mappers","name":"$args"},{"containerName":"mappers","name":"$args","line":183,"kind":13},{"line":183,"kind":12,"containerName":"mappers","name":"isa"},{"containerName":"mappers","name":"$self","kind":13,"line":184},{"name":"@args","containerName":"mappers","line":184,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"mappers($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Collection\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Collection - Noncontinuous match between two coordinate sets\n\n=head1 SYNOPSIS\n\n  # create Bio::Coordinate::Pairs or other Bio::Coordinate::MapperIs somehow\n  $pair1; $pair2;\n\n  # add them into a Collection\n  $collection = Bio::Coordinate::Collection->new;\n  $collection->add_mapper($pair1);\n  $collection->add_mapper($pair2);\n\n  # create a position and map it\n  $pos = Bio::Location::Simple->new (-start => 5, -end => 9 );\n  $res = $collection->map($pos);\n  $res->match->start == 1;\n  $res->match->end == 5;\n\n  # if mapping is many to one (*>1) or many-to-many (*>*)\n  # you have to give seq_id not get unrelevant entries\n  $pos = Bio::Location::Simple->new\n      (-start => 5, -end => 9 -seq_id=>'clone1');\n\n=head1 DESCRIPTION\n\nGeneric, context neutral mapper to provide coordinate transforms\nbetween two B<disjoint> coordinate systems. It brings into Bioperl the\nfunctionality from Ewan Birney's Bio::EnsEMBL::Mapper ported into\ncurrent bioperl.\n\nThis class is aimed for representing mapping between whole chromosomes\nand contigs, or between contigs and clones, or between sequencing\nreads and assembly. The submaps are automatically sorted, so they can\nbe added in any order.\n\nTo map coordinates to the other direction, you have to swap() the\ncollection. Keeping track of the direction and ID restrictions\nare left to the calling code.\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Collection;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Coordinate::Result;\nuse Bio::Coordinate::Result::Gap;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    $self->{'_mappers'} = [];\n\n    my($in, $out, $strict, $mappers, $return_match) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              STRICT\n                              MAPPERS\n                              RETURN_MATCH\n\t\t\t     )],\n\t\t\t @args);\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $mappers && $self->mappers($mappers);\n    $return_match && $self->return_match('return_match');\n    return $self; # success - we hope!\n}\n\n\n=head2 add_mapper\n\n Title   : add_mapper\n Usage   : $obj->add_mapper($mapper)\n Function: Pushes one Bio::Coordinate::MapperI into the list of mappers.\n           Sets _is_sorted() to false.\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : mapper object\n\n\nsub add_mapper {\n  my ($self,$value) = @_;\n\n  $self->throw(\"Is not a Bio::Coordinate::MapperI but a [$self]\")\n      unless defined $value && $value->isa('Bio::Coordinate::MapperI');\n  \n  # test pair range lengths\n  $self->warn(\"Coordinates in pair [\". $value . \":\" .\n\t      $value->in->seq_id . \"/\". $value->out->seq_id .\n\t      \"] are not right.\")\n      unless $value->test;\n\n  $self->_is_sorted(0);\n  push(@{$self->{'_mappers'}},$value);\n}\n\n=head2 mappers\n\n Title   : mappers\n Usage   : $obj->mappers();\n Function: Returns or sets a list of mappers.\n Example : \n Returns : array of mappers\n Args    : array of mappers"}},{"line":187,"kind":13,"name":"%self","containerName":null},{"detail":"($self)","signature":{"label":"each_mapper($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Collection\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Collection - Noncontinuous match between two coordinate sets\n\n=head1 SYNOPSIS\n\n  # create Bio::Coordinate::Pairs or other Bio::Coordinate::MapperIs somehow\n  $pair1; $pair2;\n\n  # add them into a Collection\n  $collection = Bio::Coordinate::Collection->new;\n  $collection->add_mapper($pair1);\n  $collection->add_mapper($pair2);\n\n  # create a position and map it\n  $pos = Bio::Location::Simple->new (-start => 5, -end => 9 );\n  $res = $collection->map($pos);\n  $res->match->start == 1;\n  $res->match->end == 5;\n\n  # if mapping is many to one (*>1) or many-to-many (*>*)\n  # you have to give seq_id not get unrelevant entries\n  $pos = Bio::Location::Simple->new\n      (-start => 5, -end => 9 -seq_id=>'clone1');\n\n=head1 DESCRIPTION\n\nGeneric, context neutral mapper to provide coordinate transforms\nbetween two B<disjoint> coordinate systems. It brings into Bioperl the\nfunctionality from Ewan Birney's Bio::EnsEMBL::Mapper ported into\ncurrent bioperl.\n\nThis class is aimed for representing mapping between whole chromosomes\nand contigs, or between contigs and clones, or between sequencing\nreads and assembly. The submaps are automatically sorted, so they can\nbe added in any order.\n\nTo map coordinates to the other direction, you have to swap() the\ncollection. Keeping track of the direction and ID restrictions\nare left to the calling code.\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Collection;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Coordinate::Result;\nuse Bio::Coordinate::Result::Gap;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    $self->{'_mappers'} = [];\n\n    my($in, $out, $strict, $mappers, $return_match) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              STRICT\n                              MAPPERS\n                              RETURN_MATCH\n\t\t\t     )],\n\t\t\t @args);\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $mappers && $self->mappers($mappers);\n    $return_match && $self->return_match('return_match');\n    return $self; # success - we hope!\n}\n\n\n=head2 add_mapper\n\n Title   : add_mapper\n Usage   : $obj->add_mapper($mapper)\n Function: Pushes one Bio::Coordinate::MapperI into the list of mappers.\n           Sets _is_sorted() to false.\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : mapper object\n\n\nsub add_mapper {\n  my ($self,$value) = @_;\n\n  $self->throw(\"Is not a Bio::Coordinate::MapperI but a [$self]\")\n      unless defined $value && $value->isa('Bio::Coordinate::MapperI');\n  \n  # test pair range lengths\n  $self->warn(\"Coordinates in pair [\". $value . \":\" .\n\t      $value->in->seq_id . \"/\". $value->out->seq_id .\n\t      \"] are not right.\")\n      unless $value->test;\n\n  $self->_is_sorted(0);\n  push(@{$self->{'_mappers'}},$value);\n}\n\n=head2 mappers\n\n Title   : mappers\n Usage   : $obj->mappers();\n Function: Returns or sets a list of mappers.\n Example : \n Returns : array of mappers\n Args    : array of mappers\n\n\nsub mappers{\n   my ($self,@args) = @_;\n\n   if (@args) {\n\n       $self->throw(\"Is not a Bio::Coordinate::MapperI but a [$self]\")\n\t   unless defined $args[0] && $args[0]->isa('Bio::Coordinate::MapperI');\n       push(@{$self->{'_mappers'}}, @args);\n   }\n\n   return @{$self->{'_mappers'}};\n}\n\n\n=head2 each_mapper\n\n Title   : each_mapper\n Usage   : $obj->each_mapper();\n Function: Returns a list of mappers.\n Example : \n Returns : list of mappers\n Args    : none"},"containerName":"main::","definition":"sub","line":202,"children":[{"definition":"my","name":"$self","containerName":"each_mapper","localvar":"my","kind":13,"line":203},{"line":204,"kind":13,"name":"$self","containerName":"each_mapper"}],"kind":12,"range":{"start":{"character":0,"line":202},"end":{"line":204,"character":9999}},"name":"each_mapper"},{"kind":12,"line":220,"children":[{"definition":"my","name":"$self","containerName":"mapper_count","localvar":"my","kind":13,"line":221},{"line":222,"kind":13,"name":"$self","containerName":"mapper_count"}],"containerName":"main::","name":"mapper_count","definition":"sub","range":{"end":{"character":9999,"line":222},"start":{"line":220,"character":0}}},{"line":237,"children":[{"name":"$self","definition":"my","containerName":"swap","localvar":"my","kind":13,"line":238},{"name":"$self","containerName":"swap","line":241,"kind":13},{"name":"sort","containerName":"swap","kind":12,"line":241},{"kind":13,"line":241,"name":"$self","containerName":"swap"},{"containerName":"swap","name":"_is_sorted","kind":12,"line":241},{"line":242,"kind":12,"containerName":"swap","name":"swap"},{"name":"$self","containerName":"swap","line":242,"kind":13}],"kind":12,"detail":"($self)","signature":{"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Collection\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Collection - Noncontinuous match between two coordinate sets\n\n=head1 SYNOPSIS\n\n  # create Bio::Coordinate::Pairs or other Bio::Coordinate::MapperIs somehow\n  $pair1; $pair2;\n\n  # add them into a Collection\n  $collection = Bio::Coordinate::Collection->new;\n  $collection->add_mapper($pair1);\n  $collection->add_mapper($pair2);\n\n  # create a position and map it\n  $pos = Bio::Location::Simple->new (-start => 5, -end => 9 );\n  $res = $collection->map($pos);\n  $res->match->start == 1;\n  $res->match->end == 5;\n\n  # if mapping is many to one (*>1) or many-to-many (*>*)\n  # you have to give seq_id not get unrelevant entries\n  $pos = Bio::Location::Simple->new\n      (-start => 5, -end => 9 -seq_id=>'clone1');\n\n=head1 DESCRIPTION\n\nGeneric, context neutral mapper to provide coordinate transforms\nbetween two B<disjoint> coordinate systems. It brings into Bioperl the\nfunctionality from Ewan Birney's Bio::EnsEMBL::Mapper ported into\ncurrent bioperl.\n\nThis class is aimed for representing mapping between whole chromosomes\nand contigs, or between contigs and clones, or between sequencing\nreads and assembly. The submaps are automatically sorted, so they can\nbe added in any order.\n\nTo map coordinates to the other direction, you have to swap() the\ncollection. Keeping track of the direction and ID restrictions\nare left to the calling code.\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Collection;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Coordinate::Result;\nuse Bio::Coordinate::Result::Gap;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    $self->{'_mappers'} = [];\n\n    my($in, $out, $strict, $mappers, $return_match) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              STRICT\n                              MAPPERS\n                              RETURN_MATCH\n\t\t\t     )],\n\t\t\t @args);\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $mappers && $self->mappers($mappers);\n    $return_match && $self->return_match('return_match');\n    return $self; # success - we hope!\n}\n\n\n=head2 add_mapper\n\n Title   : add_mapper\n Usage   : $obj->add_mapper($mapper)\n Function: Pushes one Bio::Coordinate::MapperI into the list of mappers.\n           Sets _is_sorted() to false.\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : mapper object\n\n\nsub add_mapper {\n  my ($self,$value) = @_;\n\n  $self->throw(\"Is not a Bio::Coordinate::MapperI but a [$self]\")\n      unless defined $value && $value->isa('Bio::Coordinate::MapperI');\n  \n  # test pair range lengths\n  $self->warn(\"Coordinates in pair [\". $value . \":\" .\n\t      $value->in->seq_id . \"/\". $value->out->seq_id .\n\t      \"] are not right.\")\n      unless $value->test;\n\n  $self->_is_sorted(0);\n  push(@{$self->{'_mappers'}},$value);\n}\n\n=head2 mappers\n\n Title   : mappers\n Usage   : $obj->mappers();\n Function: Returns or sets a list of mappers.\n Example : \n Returns : array of mappers\n Args    : array of mappers\n\n\nsub mappers{\n   my ($self,@args) = @_;\n\n   if (@args) {\n\n       $self->throw(\"Is not a Bio::Coordinate::MapperI but a [$self]\")\n\t   unless defined $args[0] && $args[0]->isa('Bio::Coordinate::MapperI');\n       push(@{$self->{'_mappers'}}, @args);\n   }\n\n   return @{$self->{'_mappers'}};\n}\n\n\n=head2 each_mapper\n\n Title   : each_mapper\n Usage   : $obj->each_mapper();\n Function: Returns a list of mappers.\n Example : \n Returns : list of mappers\n Args    : none\n\n\nsub each_mapper{\n   my ($self) = @_;\n   return @{$self->{'_mappers'}};\n}\n\n=head2 mapper_count\n\n Title   : mapper_count\n Usage   : my $count = $collection->mapper_count;\n Function: Get the count of the number of mappers stored \n           in this collection\n Example :\n Returns : integer\n Args    : none\n\n\n\nsub mapper_count{\n   my $self = shift;\n   return scalar @{$self->{'_mappers'} || []};\n}\n\n\n=head2 swap\n\n Title   : swap\n Usage   : $obj->swap;\n Function: Swap the direction of mapping;input <-> output\n Example :\n Returns : 1\n Args    : ","parameters":[{"label":"$self"}],"label":"swap($self)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":237},"end":{"character":9999,"line":242}},"name":"swap"},{"containerName":"Data","name":"Dumper","kind":2,"line":241},{"line":243,"kind":13,"containerName":null,"name":"%self"},{"containerName":null,"name":"%self","line":243,"kind":13},{"kind":13,"line":244,"containerName":null,"name":"%self"},{"name":"%self","containerName":null,"kind":13,"line":244},{"detail":"($self)","signature":{"label":"test($self)","documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Collection\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Collection - Noncontinuous match between two coordinate sets\n\n=head1 SYNOPSIS\n\n  # create Bio::Coordinate::Pairs or other Bio::Coordinate::MapperIs somehow\n  $pair1; $pair2;\n\n  # add them into a Collection\n  $collection = Bio::Coordinate::Collection->new;\n  $collection->add_mapper($pair1);\n  $collection->add_mapper($pair2);\n\n  # create a position and map it\n  $pos = Bio::Location::Simple->new (-start => 5, -end => 9 );\n  $res = $collection->map($pos);\n  $res->match->start == 1;\n  $res->match->end == 5;\n\n  # if mapping is many to one (*>1) or many-to-many (*>*)\n  # you have to give seq_id not get unrelevant entries\n  $pos = Bio::Location::Simple->new\n      (-start => 5, -end => 9 -seq_id=>'clone1');\n\n=head1 DESCRIPTION\n\nGeneric, context neutral mapper to provide coordinate transforms\nbetween two B<disjoint> coordinate systems. It brings into Bioperl the\nfunctionality from Ewan Birney's Bio::EnsEMBL::Mapper ported into\ncurrent bioperl.\n\nThis class is aimed for representing mapping between whole chromosomes\nand contigs, or between contigs and clones, or between sequencing\nreads and assembly. The submaps are automatically sorted, so they can\nbe added in any order.\n\nTo map coordinates to the other direction, you have to swap() the\ncollection. Keeping track of the direction and ID restrictions\nare left to the calling code.\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Collection;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Coordinate::Result;\nuse Bio::Coordinate::Result::Gap;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    $self->{'_mappers'} = [];\n\n    my($in, $out, $strict, $mappers, $return_match) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              STRICT\n                              MAPPERS\n                              RETURN_MATCH\n\t\t\t     )],\n\t\t\t @args);\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $mappers && $self->mappers($mappers);\n    $return_match && $self->return_match('return_match');\n    return $self; # success - we hope!\n}\n\n\n=head2 add_mapper\n\n Title   : add_mapper\n Usage   : $obj->add_mapper($mapper)\n Function: Pushes one Bio::Coordinate::MapperI into the list of mappers.\n           Sets _is_sorted() to false.\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : mapper object\n\n\nsub add_mapper {\n  my ($self,$value) = @_;\n\n  $self->throw(\"Is not a Bio::Coordinate::MapperI but a [$self]\")\n      unless defined $value && $value->isa('Bio::Coordinate::MapperI');\n  \n  # test pair range lengths\n  $self->warn(\"Coordinates in pair [\". $value . \":\" .\n\t      $value->in->seq_id . \"/\". $value->out->seq_id .\n\t      \"] are not right.\")\n      unless $value->test;\n\n  $self->_is_sorted(0);\n  push(@{$self->{'_mappers'}},$value);\n}\n\n=head2 mappers\n\n Title   : mappers\n Usage   : $obj->mappers();\n Function: Returns or sets a list of mappers.\n Example : \n Returns : array of mappers\n Args    : array of mappers\n\n\nsub mappers{\n   my ($self,@args) = @_;\n\n   if (@args) {\n\n       $self->throw(\"Is not a Bio::Coordinate::MapperI but a [$self]\")\n\t   unless defined $args[0] && $args[0]->isa('Bio::Coordinate::MapperI');\n       push(@{$self->{'_mappers'}}, @args);\n   }\n\n   return @{$self->{'_mappers'}};\n}\n\n\n=head2 each_mapper\n\n Title   : each_mapper\n Usage   : $obj->each_mapper();\n Function: Returns a list of mappers.\n Example : \n Returns : list of mappers\n Args    : none\n\n\nsub each_mapper{\n   my ($self) = @_;\n   return @{$self->{'_mappers'}};\n}\n\n=head2 mapper_count\n\n Title   : mapper_count\n Usage   : my $count = $collection->mapper_count;\n Function: Get the count of the number of mappers stored \n           in this collection\n Example :\n Returns : integer\n Args    : none\n\n\n\nsub mapper_count{\n   my $self = shift;\n   return scalar @{$self->{'_mappers'} || []};\n}\n\n\n=head2 swap\n\n Title   : swap\n Usage   : $obj->swap;\n Function: Swap the direction of mapping;input <-> output\n Example :\n Returns : 1\n Args    : \n\n\nsub swap {\n   my ($self) = @_;\n   use Data::Dumper;\n\n   $self->sort unless $self->_is_sorted;\n   map {$_->swap;} @{$self->{'_mappers'}};\n   ($self->{'_in_ids'}, $self->{'_out_ids'}) =\n       ($self->{'_out_ids'}, $self->{'_in_ids'});\n   1;\n}\n\n=head2 test\n\n Title   : test\n Usage   : $obj->test;\n Function: test that both components of all pairs are of the same length.\n           Ran automatically.\n Example :\n Returns : boolean\n Args    :","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub","line":260,"children":[{"definition":"my","name":"$self","containerName":"test","localvar":"my","kind":13,"line":261},{"line":263,"kind":13,"localvar":"my","containerName":"test","name":"$res","definition":"my"},{"kind":13,"line":265,"definition":"my","name":"$mapper","containerName":"test","localvar":"my"},{"containerName":"test","name":"$self","line":265,"kind":13},{"containerName":"test","name":"each_mapper","line":265,"kind":12},{"containerName":"test","name":"$mapper","line":266,"kind":13},{"name":"test","containerName":"test","kind":12,"line":266},{"name":"$self","containerName":"test","line":267,"kind":13},{"containerName":"test","name":"warn","kind":12,"line":267},{"name":"$mapper","containerName":"test","kind":13,"line":267},{"containerName":"test","name":"$mapper","kind":13,"line":268},{"kind":12,"line":268,"containerName":"test","name":"in"},{"containerName":"test","name":"seq_id","kind":12,"line":268},{"line":268,"kind":13,"name":"$mapper","containerName":"test"},{"kind":12,"line":268,"containerName":"test","name":"out"},{"name":"seq_id","containerName":"test","kind":12,"line":268},{"line":270,"kind":13,"containerName":"test","name":"$res"},{"containerName":"test","name":"$res","kind":13,"line":273}],"kind":12,"range":{"end":{"character":9999,"line":274},"start":{"line":260,"character":0}},"name":"test"},{"name":"map","range":{"start":{"character":0,"line":289},"end":{"line":318,"character":9999}},"definition":"sub","containerName":"main::","signature":{"label":"map($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Collection\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Collection - Noncontinuous match between two coordinate sets\n\n=head1 SYNOPSIS\n\n  # create Bio::Coordinate::Pairs or other Bio::Coordinate::MapperIs somehow\n  $pair1; $pair2;\n\n  # add them into a Collection\n  $collection = Bio::Coordinate::Collection->new;\n  $collection->add_mapper($pair1);\n  $collection->add_mapper($pair2);\n\n  # create a position and map it\n  $pos = Bio::Location::Simple->new (-start => 5, -end => 9 );\n  $res = $collection->map($pos);\n  $res->match->start == 1;\n  $res->match->end == 5;\n\n  # if mapping is many to one (*>1) or many-to-many (*>*)\n  # you have to give seq_id not get unrelevant entries\n  $pos = Bio::Location::Simple->new\n      (-start => 5, -end => 9 -seq_id=>'clone1');\n\n=head1 DESCRIPTION\n\nGeneric, context neutral mapper to provide coordinate transforms\nbetween two B<disjoint> coordinate systems. It brings into Bioperl the\nfunctionality from Ewan Birney's Bio::EnsEMBL::Mapper ported into\ncurrent bioperl.\n\nThis class is aimed for representing mapping between whole chromosomes\nand contigs, or between contigs and clones, or between sequencing\nreads and assembly. The submaps are automatically sorted, so they can\nbe added in any order.\n\nTo map coordinates to the other direction, you have to swap() the\ncollection. Keeping track of the direction and ID restrictions\nare left to the calling code.\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Collection;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Coordinate::Result;\nuse Bio::Coordinate::Result::Gap;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    $self->{'_mappers'} = [];\n\n    my($in, $out, $strict, $mappers, $return_match) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              STRICT\n                              MAPPERS\n                              RETURN_MATCH\n\t\t\t     )],\n\t\t\t @args);\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $mappers && $self->mappers($mappers);\n    $return_match && $self->return_match('return_match');\n    return $self; # success - we hope!\n}\n\n\n=head2 add_mapper\n\n Title   : add_mapper\n Usage   : $obj->add_mapper($mapper)\n Function: Pushes one Bio::Coordinate::MapperI into the list of mappers.\n           Sets _is_sorted() to false.\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : mapper object\n\n\nsub add_mapper {\n  my ($self,$value) = @_;\n\n  $self->throw(\"Is not a Bio::Coordinate::MapperI but a [$self]\")\n      unless defined $value && $value->isa('Bio::Coordinate::MapperI');\n  \n  # test pair range lengths\n  $self->warn(\"Coordinates in pair [\". $value . \":\" .\n\t      $value->in->seq_id . \"/\". $value->out->seq_id .\n\t      \"] are not right.\")\n      unless $value->test;\n\n  $self->_is_sorted(0);\n  push(@{$self->{'_mappers'}},$value);\n}\n\n=head2 mappers\n\n Title   : mappers\n Usage   : $obj->mappers();\n Function: Returns or sets a list of mappers.\n Example : \n Returns : array of mappers\n Args    : array of mappers\n\n\nsub mappers{\n   my ($self,@args) = @_;\n\n   if (@args) {\n\n       $self->throw(\"Is not a Bio::Coordinate::MapperI but a [$self]\")\n\t   unless defined $args[0] && $args[0]->isa('Bio::Coordinate::MapperI');\n       push(@{$self->{'_mappers'}}, @args);\n   }\n\n   return @{$self->{'_mappers'}};\n}\n\n\n=head2 each_mapper\n\n Title   : each_mapper\n Usage   : $obj->each_mapper();\n Function: Returns a list of mappers.\n Example : \n Returns : list of mappers\n Args    : none\n\n\nsub each_mapper{\n   my ($self) = @_;\n   return @{$self->{'_mappers'}};\n}\n\n=head2 mapper_count\n\n Title   : mapper_count\n Usage   : my $count = $collection->mapper_count;\n Function: Get the count of the number of mappers stored \n           in this collection\n Example :\n Returns : integer\n Args    : none\n\n\n\nsub mapper_count{\n   my $self = shift;\n   return scalar @{$self->{'_mappers'} || []};\n}\n\n\n=head2 swap\n\n Title   : swap\n Usage   : $obj->swap;\n Function: Swap the direction of mapping;input <-> output\n Example :\n Returns : 1\n Args    : \n\n\nsub swap {\n   my ($self) = @_;\n   use Data::Dumper;\n\n   $self->sort unless $self->_is_sorted;\n   map {$_->swap;} @{$self->{'_mappers'}};\n   ($self->{'_in_ids'}, $self->{'_out_ids'}) =\n       ($self->{'_out_ids'}, $self->{'_in_ids'});\n   1;\n}\n\n=head2 test\n\n Title   : test\n Usage   : $obj->test;\n Function: test that both components of all pairs are of the same length.\n           Ran automatically.\n Example :\n Returns : boolean\n Args    :\n\n\nsub test {\n   my ($self) = @_;\n\n   my $res = 1;\n\n   foreach my $mapper ($self->each_mapper) {\n       unless( $mapper->test ) {\n\t   $self->warn(\"Coordinates in pair [\". $mapper . \":\" .\n\t\t       $mapper->in->seq_id . \"/\". $mapper->out->seq_id .\n\t\t       \"] are not right.\"); \n\t   $res = 0;\n       }\n   }\n   $res;\n}\n\n\n=head2 map\n\n Title   : map\n Usage   : $newpos = $obj->map($pos);\n Function: Map the location from the input coordinate system\n           to a new value in the output coordinate system.\n Example :\n Returns : new value in the output coordinate system\n Args    : integer"},"detail":"($self,$value)","kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"map","line":290,"kind":13},{"name":"$value","containerName":"map","line":290,"kind":13},{"kind":13,"line":292,"containerName":"map","name":"$self"},{"line":292,"kind":12,"name":"throw","containerName":"map"},{"name":"$value","containerName":"map","kind":13,"line":293},{"kind":13,"line":294,"name":"$self","containerName":"map"},{"line":294,"kind":12,"containerName":"map","name":"throw"},{"containerName":"map","name":"$value","kind":13,"line":295},{"line":295,"kind":12,"name":"isa","containerName":"map"},{"kind":13,"line":296,"containerName":"map","name":"$self"},{"name":"throw","containerName":"map","kind":12,"line":296},{"kind":13,"line":297,"containerName":"map","name":"$self"},{"containerName":"map","name":"each_mapper","kind":12,"line":297},{"name":"$self","containerName":"map","line":299,"kind":13},{"kind":12,"line":299,"name":"sort","containerName":"map"},{"kind":13,"line":299,"name":"$self","containerName":"map"},{"containerName":"map","name":"_is_sorted","kind":12,"line":299},{"containerName":"map","name":"$value","line":302,"kind":13},{"name":"isa","containerName":"map","line":302,"kind":12},{"definition":"my","name":"$result","containerName":"map","localvar":"my","kind":13,"line":304},{"line":304,"kind":12,"containerName":"map","name":"new"},{"line":305,"kind":13,"localvar":"my","definition":"my","name":"$loc","containerName":"map"},{"name":"$value","containerName":"map","kind":13,"line":305},{"kind":12,"line":305,"containerName":"map","name":"sub_Location"},{"localvar":"my","containerName":"map","definition":"my","name":"$res","line":307,"kind":13},{"line":307,"kind":13,"containerName":"map","name":"$self"},{"kind":12,"line":307,"containerName":"map","name":"_map"},{"line":307,"kind":13,"containerName":"map","name":"$loc"},{"kind":13,"line":308,"name":"$result","containerName":"map"},{"kind":12,"line":308,"name":"add_sub_Location","containerName":"map"},{"kind":13,"line":308,"containerName":"map","name":"$res"},{"containerName":"map","name":"each_Location","line":308,"kind":12},{"line":311,"kind":13,"containerName":"map","name":"$result"},{"line":314,"kind":13,"name":"$self","containerName":"map"},{"containerName":"map","name":"_map","kind":12,"line":314},{"line":314,"kind":13,"name":"$value","containerName":"map"}],"line":289},{"containerName":"Coordinate::Result","name":"Bio","line":304,"kind":12},{"name":"_map","range":{"start":{"line":334,"character":0},"end":{"character":9999,"line":375}},"kind":12,"children":[{"line":335,"kind":13,"localvar":"my","containerName":"_map","definition":"my","name":"$self"},{"containerName":"_map","name":"$value","kind":13,"line":335},{"definition":"my","name":"$result","containerName":"_map","localvar":"my","kind":13,"line":337},{"line":337,"kind":12,"name":"new","containerName":"_map"},{"containerName":"_map","name":"$value","kind":13,"line":343},{"containerName":"_map","name":"seq_id","kind":12,"line":343},{"containerName":"_map","name":"$self","line":344,"kind":13},{"line":344,"kind":13,"containerName":"_map","name":"$value"},{"name":"seq_id","containerName":"_map","kind":12,"line":344},{"localvar":"my","name":"$pair","definition":"my","containerName":"_map","line":346,"kind":13},{"kind":13,"line":346,"name":"$self","containerName":"_map"},{"kind":12,"line":346,"name":"each_mapper","containerName":"_map"},{"containerName":"_map","name":"$value","kind":13,"line":349},{"name":"seq_id","containerName":"_map","line":349,"kind":12},{"line":349,"kind":13,"name":"$value","containerName":"_map"},{"containerName":"_map","name":"seq_id","kind":12,"line":349},{"line":349,"kind":13,"name":"$pair","containerName":"_map"},{"name":"in","containerName":"_map","line":349,"kind":12},{"line":349,"kind":12,"containerName":"_map","name":"seq_id"},{"containerName":"_map","name":"$pair","kind":13,"line":352},{"name":"in","containerName":"_map","kind":12,"line":352},{"name":"end","containerName":"_map","kind":12,"line":352},{"kind":13,"line":352,"name":"$value","containerName":"_map"},{"containerName":"_map","name":"start","line":352,"kind":12},{"line":354,"kind":13,"containerName":"_map","name":"$pair"},{"containerName":"_map","name":"in","line":354,"kind":12},{"line":354,"kind":12,"containerName":"_map","name":"start"},{"name":"$value","containerName":"_map","line":354,"kind":13},{"containerName":"_map","name":"end","kind":12,"line":354},{"line":356,"kind":13,"localvar":"my","containerName":"_map","name":"$subres","definition":"my"},{"name":"$pair","containerName":"_map","kind":13,"line":356},{"containerName":"_map","name":"map","line":356,"kind":12},{"name":"$value","containerName":"_map","kind":13,"line":356},{"kind":13,"line":357,"containerName":"_map","name":"$result"},{"name":"add_result","containerName":"_map","kind":12,"line":357},{"line":357,"kind":13,"name":"$subres","containerName":"_map"},{"kind":13,"line":361,"name":"$result","containerName":"_map"},{"containerName":"_map","name":"seq_id","line":361,"kind":12},{"kind":13,"line":361,"name":"$result","containerName":"_map"},{"name":"match","containerName":"_map","line":361,"kind":12},{"name":"seq_id","containerName":"_map","line":361,"kind":12},{"kind":13,"line":361,"containerName":"_map","name":"$result"},{"line":361,"kind":12,"containerName":"_map","name":"match"},{"containerName":"_map","name":"$result","line":362,"kind":13},{"line":362,"kind":12,"name":"each_Location","containerName":"_map"},{"line":364,"kind":13,"localvar":"my","definition":"my","name":"$gap","containerName":"_map"},{"name":"new","containerName":"_map","kind":12,"line":364},{"name":"$value","containerName":"_map","kind":13,"line":364},{"kind":12,"line":364,"name":"start","containerName":"_map"},{"name":"$value","containerName":"_map","line":365,"kind":13},{"line":365,"kind":12,"containerName":"_map","name":"end"},{"kind":13,"line":366,"name":"$value","containerName":"_map"},{"kind":12,"line":366,"containerName":"_map","name":"strand"},{"containerName":"_map","name":"$value","kind":13,"line":367},{"kind":12,"line":368,"containerName":"_map","name":"location_type"},{"line":369,"kind":13,"containerName":"_map","name":"$gap"},{"containerName":"_map","name":"seq_id","kind":12,"line":369},{"containerName":"_map","name":"$value","kind":13,"line":369},{"line":369,"kind":12,"containerName":"_map","name":"seq_id"},{"name":"$value","containerName":"_map","line":369,"kind":13},{"name":"seq_id","containerName":"_map","kind":12,"line":369},{"line":370,"kind":13,"name":"$gap","containerName":"_map"},{"kind":13,"line":371,"name":"$result","containerName":"_map"},{"kind":12,"line":371,"containerName":"_map","name":"seq_id"},{"line":371,"kind":13,"containerName":"_map","name":"$value"},{"containerName":"_map","name":"seq_id","line":371,"kind":12},{"kind":13,"line":371,"name":"$value","containerName":"_map"},{"name":"seq_id","containerName":"_map","line":371,"kind":12},{"line":372,"kind":13,"name":"$result","containerName":"_map"},{"kind":12,"line":372,"containerName":"_map","name":"add_sub_Location"},{"name":"$gap","containerName":"_map","kind":13,"line":372},{"kind":13,"line":374,"containerName":"_map","name":"$result"}],"line":334,"definition":"sub","containerName":"main::","signature":{"label":"_map($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Collection\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Collection - Noncontinuous match between two coordinate sets\n\n=head1 SYNOPSIS\n\n  # create Bio::Coordinate::Pairs or other Bio::Coordinate::MapperIs somehow\n  $pair1; $pair2;\n\n  # add them into a Collection\n  $collection = Bio::Coordinate::Collection->new;\n  $collection->add_mapper($pair1);\n  $collection->add_mapper($pair2);\n\n  # create a position and map it\n  $pos = Bio::Location::Simple->new (-start => 5, -end => 9 );\n  $res = $collection->map($pos);\n  $res->match->start == 1;\n  $res->match->end == 5;\n\n  # if mapping is many to one (*>1) or many-to-many (*>*)\n  # you have to give seq_id not get unrelevant entries\n  $pos = Bio::Location::Simple->new\n      (-start => 5, -end => 9 -seq_id=>'clone1');\n\n=head1 DESCRIPTION\n\nGeneric, context neutral mapper to provide coordinate transforms\nbetween two B<disjoint> coordinate systems. It brings into Bioperl the\nfunctionality from Ewan Birney's Bio::EnsEMBL::Mapper ported into\ncurrent bioperl.\n\nThis class is aimed for representing mapping between whole chromosomes\nand contigs, or between contigs and clones, or between sequencing\nreads and assembly. The submaps are automatically sorted, so they can\nbe added in any order.\n\nTo map coordinates to the other direction, you have to swap() the\ncollection. Keeping track of the direction and ID restrictions\nare left to the calling code.\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Collection;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Coordinate::Result;\nuse Bio::Coordinate::Result::Gap;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    $self->{'_mappers'} = [];\n\n    my($in, $out, $strict, $mappers, $return_match) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              STRICT\n                              MAPPERS\n                              RETURN_MATCH\n\t\t\t     )],\n\t\t\t @args);\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $mappers && $self->mappers($mappers);\n    $return_match && $self->return_match('return_match');\n    return $self; # success - we hope!\n}\n\n\n=head2 add_mapper\n\n Title   : add_mapper\n Usage   : $obj->add_mapper($mapper)\n Function: Pushes one Bio::Coordinate::MapperI into the list of mappers.\n           Sets _is_sorted() to false.\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : mapper object\n\n\nsub add_mapper {\n  my ($self,$value) = @_;\n\n  $self->throw(\"Is not a Bio::Coordinate::MapperI but a [$self]\")\n      unless defined $value && $value->isa('Bio::Coordinate::MapperI');\n  \n  # test pair range lengths\n  $self->warn(\"Coordinates in pair [\". $value . \":\" .\n\t      $value->in->seq_id . \"/\". $value->out->seq_id .\n\t      \"] are not right.\")\n      unless $value->test;\n\n  $self->_is_sorted(0);\n  push(@{$self->{'_mappers'}},$value);\n}\n\n=head2 mappers\n\n Title   : mappers\n Usage   : $obj->mappers();\n Function: Returns or sets a list of mappers.\n Example : \n Returns : array of mappers\n Args    : array of mappers\n\n\nsub mappers{\n   my ($self,@args) = @_;\n\n   if (@args) {\n\n       $self->throw(\"Is not a Bio::Coordinate::MapperI but a [$self]\")\n\t   unless defined $args[0] && $args[0]->isa('Bio::Coordinate::MapperI');\n       push(@{$self->{'_mappers'}}, @args);\n   }\n\n   return @{$self->{'_mappers'}};\n}\n\n\n=head2 each_mapper\n\n Title   : each_mapper\n Usage   : $obj->each_mapper();\n Function: Returns a list of mappers.\n Example : \n Returns : list of mappers\n Args    : none\n\n\nsub each_mapper{\n   my ($self) = @_;\n   return @{$self->{'_mappers'}};\n}\n\n=head2 mapper_count\n\n Title   : mapper_count\n Usage   : my $count = $collection->mapper_count;\n Function: Get the count of the number of mappers stored \n           in this collection\n Example :\n Returns : integer\n Args    : none\n\n\n\nsub mapper_count{\n   my $self = shift;\n   return scalar @{$self->{'_mappers'} || []};\n}\n\n\n=head2 swap\n\n Title   : swap\n Usage   : $obj->swap;\n Function: Swap the direction of mapping;input <-> output\n Example :\n Returns : 1\n Args    : \n\n\nsub swap {\n   my ($self) = @_;\n   use Data::Dumper;\n\n   $self->sort unless $self->_is_sorted;\n   map {$_->swap;} @{$self->{'_mappers'}};\n   ($self->{'_in_ids'}, $self->{'_out_ids'}) =\n       ($self->{'_out_ids'}, $self->{'_in_ids'});\n   1;\n}\n\n=head2 test\n\n Title   : test\n Usage   : $obj->test;\n Function: test that both components of all pairs are of the same length.\n           Ran automatically.\n Example :\n Returns : boolean\n Args    :\n\n\nsub test {\n   my ($self) = @_;\n\n   my $res = 1;\n\n   foreach my $mapper ($self->each_mapper) {\n       unless( $mapper->test ) {\n\t   $self->warn(\"Coordinates in pair [\". $mapper . \":\" .\n\t\t       $mapper->in->seq_id . \"/\". $mapper->out->seq_id .\n\t\t       \"] are not right.\"); \n\t   $res = 0;\n       }\n   }\n   $res;\n}\n\n\n=head2 map\n\n Title   : map\n Usage   : $newpos = $obj->map($pos);\n Function: Map the location from the input coordinate system\n           to a new value in the output coordinate system.\n Example :\n Returns : new value in the output coordinate system\n Args    : integer\n\n\nsub map {\n   my ($self,$value) = @_;\n\n   $self->throw(\"Need to pass me a value.\")\n       unless defined $value;\n   $self->throw(\"I need a Bio::Location, not [$value]\")\n       unless $value->isa('Bio::LocationI');\n   $self->throw(\"No coordinate mappers!\")\n       unless $self->each_mapper;\n\n   $self->sort unless $self->_is_sorted;\n\n\n   if ($value->isa(\"Bio::Location::SplitLocationI\")) {\n\n       my $result = Bio::Coordinate::Result->new();\n       foreach my $loc ( $value->sub_Location(1) ) {\n\n           my $res = $self->_map($loc);\n           map { $result->add_sub_Location($_) } $res->each_Location;\n\n       }\n       return $result;\n\n   } else {\n       return $self->_map($value);\n   }\n\n\n}\n\n\n=head2 _map\n\n Title   : _map\n Usage   : $newpos = $obj->_map($simpleloc);\n Function: Internal method that does the actual mapping. Called multiple times\n           by map() if the location  to be mapped is a split location\n\n Example :\n Returns : new location in the output coordinate system or undef\n Args    : Bio::Location::Simple"},"detail":"($self,$value)"},{"name":"Bio","containerName":"Coordinate::Result","kind":12,"line":337},{"name":"IDMATCH","kind":12,"line":339},{"kind":12,"line":343,"name":"IDMATCH"},{"line":364,"kind":12,"name":"Bio","containerName":"Location::Simple"},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"sort($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Collection\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Collection - Noncontinuous match between two coordinate sets\n\n=head1 SYNOPSIS\n\n  # create Bio::Coordinate::Pairs or other Bio::Coordinate::MapperIs somehow\n  $pair1; $pair2;\n\n  # add them into a Collection\n  $collection = Bio::Coordinate::Collection->new;\n  $collection->add_mapper($pair1);\n  $collection->add_mapper($pair2);\n\n  # create a position and map it\n  $pos = Bio::Location::Simple->new (-start => 5, -end => 9 );\n  $res = $collection->map($pos);\n  $res->match->start == 1;\n  $res->match->end == 5;\n\n  # if mapping is many to one (*>1) or many-to-many (*>*)\n  # you have to give seq_id not get unrelevant entries\n  $pos = Bio::Location::Simple->new\n      (-start => 5, -end => 9 -seq_id=>'clone1');\n\n=head1 DESCRIPTION\n\nGeneric, context neutral mapper to provide coordinate transforms\nbetween two B<disjoint> coordinate systems. It brings into Bioperl the\nfunctionality from Ewan Birney's Bio::EnsEMBL::Mapper ported into\ncurrent bioperl.\n\nThis class is aimed for representing mapping between whole chromosomes\nand contigs, or between contigs and clones, or between sequencing\nreads and assembly. The submaps are automatically sorted, so they can\nbe added in any order.\n\nTo map coordinates to the other direction, you have to swap() the\ncollection. Keeping track of the direction and ID restrictions\nare left to the calling code.\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Collection;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Coordinate::Result;\nuse Bio::Coordinate::Result::Gap;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    $self->{'_mappers'} = [];\n\n    my($in, $out, $strict, $mappers, $return_match) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              STRICT\n                              MAPPERS\n                              RETURN_MATCH\n\t\t\t     )],\n\t\t\t @args);\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $mappers && $self->mappers($mappers);\n    $return_match && $self->return_match('return_match');\n    return $self; # success - we hope!\n}\n\n\n=head2 add_mapper\n\n Title   : add_mapper\n Usage   : $obj->add_mapper($mapper)\n Function: Pushes one Bio::Coordinate::MapperI into the list of mappers.\n           Sets _is_sorted() to false.\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : mapper object\n\n\nsub add_mapper {\n  my ($self,$value) = @_;\n\n  $self->throw(\"Is not a Bio::Coordinate::MapperI but a [$self]\")\n      unless defined $value && $value->isa('Bio::Coordinate::MapperI');\n  \n  # test pair range lengths\n  $self->warn(\"Coordinates in pair [\". $value . \":\" .\n\t      $value->in->seq_id . \"/\". $value->out->seq_id .\n\t      \"] are not right.\")\n      unless $value->test;\n\n  $self->_is_sorted(0);\n  push(@{$self->{'_mappers'}},$value);\n}\n\n=head2 mappers\n\n Title   : mappers\n Usage   : $obj->mappers();\n Function: Returns or sets a list of mappers.\n Example : \n Returns : array of mappers\n Args    : array of mappers\n\n\nsub mappers{\n   my ($self,@args) = @_;\n\n   if (@args) {\n\n       $self->throw(\"Is not a Bio::Coordinate::MapperI but a [$self]\")\n\t   unless defined $args[0] && $args[0]->isa('Bio::Coordinate::MapperI');\n       push(@{$self->{'_mappers'}}, @args);\n   }\n\n   return @{$self->{'_mappers'}};\n}\n\n\n=head2 each_mapper\n\n Title   : each_mapper\n Usage   : $obj->each_mapper();\n Function: Returns a list of mappers.\n Example : \n Returns : list of mappers\n Args    : none\n\n\nsub each_mapper{\n   my ($self) = @_;\n   return @{$self->{'_mappers'}};\n}\n\n=head2 mapper_count\n\n Title   : mapper_count\n Usage   : my $count = $collection->mapper_count;\n Function: Get the count of the number of mappers stored \n           in this collection\n Example :\n Returns : integer\n Args    : none\n\n\n\nsub mapper_count{\n   my $self = shift;\n   return scalar @{$self->{'_mappers'} || []};\n}\n\n\n=head2 swap\n\n Title   : swap\n Usage   : $obj->swap;\n Function: Swap the direction of mapping;input <-> output\n Example :\n Returns : 1\n Args    : \n\n\nsub swap {\n   my ($self) = @_;\n   use Data::Dumper;\n\n   $self->sort unless $self->_is_sorted;\n   map {$_->swap;} @{$self->{'_mappers'}};\n   ($self->{'_in_ids'}, $self->{'_out_ids'}) =\n       ($self->{'_out_ids'}, $self->{'_in_ids'});\n   1;\n}\n\n=head2 test\n\n Title   : test\n Usage   : $obj->test;\n Function: test that both components of all pairs are of the same length.\n           Ran automatically.\n Example :\n Returns : boolean\n Args    :\n\n\nsub test {\n   my ($self) = @_;\n\n   my $res = 1;\n\n   foreach my $mapper ($self->each_mapper) {\n       unless( $mapper->test ) {\n\t   $self->warn(\"Coordinates in pair [\". $mapper . \":\" .\n\t\t       $mapper->in->seq_id . \"/\". $mapper->out->seq_id .\n\t\t       \"] are not right.\"); \n\t   $res = 0;\n       }\n   }\n   $res;\n}\n\n\n=head2 map\n\n Title   : map\n Usage   : $newpos = $obj->map($pos);\n Function: Map the location from the input coordinate system\n           to a new value in the output coordinate system.\n Example :\n Returns : new value in the output coordinate system\n Args    : integer\n\n\nsub map {\n   my ($self,$value) = @_;\n\n   $self->throw(\"Need to pass me a value.\")\n       unless defined $value;\n   $self->throw(\"I need a Bio::Location, not [$value]\")\n       unless $value->isa('Bio::LocationI');\n   $self->throw(\"No coordinate mappers!\")\n       unless $self->each_mapper;\n\n   $self->sort unless $self->_is_sorted;\n\n\n   if ($value->isa(\"Bio::Location::SplitLocationI\")) {\n\n       my $result = Bio::Coordinate::Result->new();\n       foreach my $loc ( $value->sub_Location(1) ) {\n\n           my $res = $self->_map($loc);\n           map { $result->add_sub_Location($_) } $res->each_Location;\n\n       }\n       return $result;\n\n   } else {\n       return $self->_map($value);\n   }\n\n\n}\n\n\n=head2 _map\n\n Title   : _map\n Usage   : $newpos = $obj->_map($simpleloc);\n Function: Internal method that does the actual mapping. Called multiple times\n           by map() if the location  to be mapped is a split location\n\n Example :\n Returns : new location in the output coordinate system or undef\n Args    : Bio::Location::Simple\n\n\nsub _map {\n   my ($self,$value) = @_;\n\n   my $result = Bio::Coordinate::Result->new(-is_remote=>1);\n\nIDMATCH: {\n\n       # bail out now we if are forcing the use of an ID \n       # and it is not in this collection\n       last IDMATCH if defined $value->seq_id && \n\t   ! $self->{'_in_ids'}->{$value->seq_id};\n\n       foreach my $pair ($self->each_mapper) {\n\n\t   # if we are limiting input to a certain ID\n\t   next if defined $value->seq_id && $value->seq_id ne $pair->in->seq_id;\n\n\t   # if we haven't even reached the start, move on\n\t   next if $pair->in->end < $value->start;\n\t   # if we have over run, break\n\t   last if $pair->in->start > $value->end;\n\n\t   my $subres = $pair->map($value);\n\t   $result->add_result($subres);\n       }\n   }\n\n   $result->seq_id($result->match->seq_id) if $result->match;\n   unless ($result->each_Location) {\n       #build one gap;\n       my $gap = Bio::Location::Simple->new(-start => $value->start,\n\t\t\t\t\t    -end => $value->end,\n\t\t\t\t\t    -strand => $value->strand,\n\t\t\t\t\t    -location_type => $value->location_type\n\t\t\t\t\t   );\n       $gap->seq_id($value->seq_id) if defined $value->seq_id;\n       bless $gap, 'Bio::Coordinate::Result::Gap';\n       $result->seq_id($value->seq_id) if defined $value->seq_id;\n       $result->add_sub_Location($gap);\n   }\n   return $result;\n}\n\n\n=head2 sort\n\n Title   : sort\n Usage   : $obj->sort;\n Function: Sort function so that all mappings are sorted by\n           input coordinate start\n Example :\n Returns : 1\n Args    : "},"kind":12,"line":390,"children":[{"line":391,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"sort"},{"line":393,"kind":13,"containerName":"sort","name":"$self"}],"name":"sort","range":{"start":{"character":0,"line":390},"end":{"line":393,"character":9999}}},{"line":394,"kind":13,"name":"@a","containerName":null},{"name":"@b","containerName":null,"line":394,"kind":13},{"containerName":"main::","name":"in","kind":12,"line":395},{"line":395,"kind":12,"containerName":"main::","name":"start"},{"kind":13,"line":396,"name":"%self","containerName":null},{"name":"%self","containerName":null,"line":399,"kind":13},{"line":400,"kind":13,"name":"%self","containerName":null},{"line":401,"kind":13,"name":"$self","containerName":null},{"kind":12,"line":401,"containerName":"main::","name":"each_mapper"},{"kind":13,"line":402,"name":"%self","containerName":null},{"name":"in","containerName":"main::","line":402,"kind":12},{"line":402,"kind":12,"name":"seq_id","containerName":"main::"},{"containerName":null,"name":"%self","kind":13,"line":403},{"line":403,"kind":12,"containerName":"main::","name":"out"},{"kind":12,"line":403,"containerName":"main::","name":"seq_id"},{"line":406,"kind":13,"containerName":null,"name":"$self"},{"line":406,"kind":12,"containerName":"main::","name":"_is_sorted"},{"range":{"end":{"character":9999,"line":425},"start":{"line":420,"character":0}},"name":"_is_sorted","children":[{"name":"$self","definition":"my","containerName":"_is_sorted","localvar":"my","kind":13,"line":421},{"kind":13,"line":421,"containerName":"_is_sorted","name":"$value"},{"kind":13,"line":423,"name":"$self","containerName":"_is_sorted"},{"kind":13,"line":423,"containerName":"_is_sorted","name":"$value"},{"name":"$value","containerName":"_is_sorted","line":423,"kind":13},{"kind":13,"line":424,"name":"$self","containerName":"_is_sorted"}],"line":420,"kind":12,"signature":{"label":"_is_sorted($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Collection\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Collection - Noncontinuous match between two coordinate sets\n\n=head1 SYNOPSIS\n\n  # create Bio::Coordinate::Pairs or other Bio::Coordinate::MapperIs somehow\n  $pair1; $pair2;\n\n  # add them into a Collection\n  $collection = Bio::Coordinate::Collection->new;\n  $collection->add_mapper($pair1);\n  $collection->add_mapper($pair2);\n\n  # create a position and map it\n  $pos = Bio::Location::Simple->new (-start => 5, -end => 9 );\n  $res = $collection->map($pos);\n  $res->match->start == 1;\n  $res->match->end == 5;\n\n  # if mapping is many to one (*>1) or many-to-many (*>*)\n  # you have to give seq_id not get unrelevant entries\n  $pos = Bio::Location::Simple->new\n      (-start => 5, -end => 9 -seq_id=>'clone1');\n\n=head1 DESCRIPTION\n\nGeneric, context neutral mapper to provide coordinate transforms\nbetween two B<disjoint> coordinate systems. It brings into Bioperl the\nfunctionality from Ewan Birney's Bio::EnsEMBL::Mapper ported into\ncurrent bioperl.\n\nThis class is aimed for representing mapping between whole chromosomes\nand contigs, or between contigs and clones, or between sequencing\nreads and assembly. The submaps are automatically sorted, so they can\nbe added in any order.\n\nTo map coordinates to the other direction, you have to swap() the\ncollection. Keeping track of the direction and ID restrictions\nare left to the calling code.\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Collection;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Coordinate::Result;\nuse Bio::Coordinate::Result::Gap;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    $self->{'_mappers'} = [];\n\n    my($in, $out, $strict, $mappers, $return_match) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              STRICT\n                              MAPPERS\n                              RETURN_MATCH\n\t\t\t     )],\n\t\t\t @args);\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $mappers && $self->mappers($mappers);\n    $return_match && $self->return_match('return_match');\n    return $self; # success - we hope!\n}\n\n\n=head2 add_mapper\n\n Title   : add_mapper\n Usage   : $obj->add_mapper($mapper)\n Function: Pushes one Bio::Coordinate::MapperI into the list of mappers.\n           Sets _is_sorted() to false.\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : mapper object\n\n\nsub add_mapper {\n  my ($self,$value) = @_;\n\n  $self->throw(\"Is not a Bio::Coordinate::MapperI but a [$self]\")\n      unless defined $value && $value->isa('Bio::Coordinate::MapperI');\n  \n  # test pair range lengths\n  $self->warn(\"Coordinates in pair [\". $value . \":\" .\n\t      $value->in->seq_id . \"/\". $value->out->seq_id .\n\t      \"] are not right.\")\n      unless $value->test;\n\n  $self->_is_sorted(0);\n  push(@{$self->{'_mappers'}},$value);\n}\n\n=head2 mappers\n\n Title   : mappers\n Usage   : $obj->mappers();\n Function: Returns or sets a list of mappers.\n Example : \n Returns : array of mappers\n Args    : array of mappers\n\n\nsub mappers{\n   my ($self,@args) = @_;\n\n   if (@args) {\n\n       $self->throw(\"Is not a Bio::Coordinate::MapperI but a [$self]\")\n\t   unless defined $args[0] && $args[0]->isa('Bio::Coordinate::MapperI');\n       push(@{$self->{'_mappers'}}, @args);\n   }\n\n   return @{$self->{'_mappers'}};\n}\n\n\n=head2 each_mapper\n\n Title   : each_mapper\n Usage   : $obj->each_mapper();\n Function: Returns a list of mappers.\n Example : \n Returns : list of mappers\n Args    : none\n\n\nsub each_mapper{\n   my ($self) = @_;\n   return @{$self->{'_mappers'}};\n}\n\n=head2 mapper_count\n\n Title   : mapper_count\n Usage   : my $count = $collection->mapper_count;\n Function: Get the count of the number of mappers stored \n           in this collection\n Example :\n Returns : integer\n Args    : none\n\n\n\nsub mapper_count{\n   my $self = shift;\n   return scalar @{$self->{'_mappers'} || []};\n}\n\n\n=head2 swap\n\n Title   : swap\n Usage   : $obj->swap;\n Function: Swap the direction of mapping;input <-> output\n Example :\n Returns : 1\n Args    : \n\n\nsub swap {\n   my ($self) = @_;\n   use Data::Dumper;\n\n   $self->sort unless $self->_is_sorted;\n   map {$_->swap;} @{$self->{'_mappers'}};\n   ($self->{'_in_ids'}, $self->{'_out_ids'}) =\n       ($self->{'_out_ids'}, $self->{'_in_ids'});\n   1;\n}\n\n=head2 test\n\n Title   : test\n Usage   : $obj->test;\n Function: test that both components of all pairs are of the same length.\n           Ran automatically.\n Example :\n Returns : boolean\n Args    :\n\n\nsub test {\n   my ($self) = @_;\n\n   my $res = 1;\n\n   foreach my $mapper ($self->each_mapper) {\n       unless( $mapper->test ) {\n\t   $self->warn(\"Coordinates in pair [\". $mapper . \":\" .\n\t\t       $mapper->in->seq_id . \"/\". $mapper->out->seq_id .\n\t\t       \"] are not right.\"); \n\t   $res = 0;\n       }\n   }\n   $res;\n}\n\n\n=head2 map\n\n Title   : map\n Usage   : $newpos = $obj->map($pos);\n Function: Map the location from the input coordinate system\n           to a new value in the output coordinate system.\n Example :\n Returns : new value in the output coordinate system\n Args    : integer\n\n\nsub map {\n   my ($self,$value) = @_;\n\n   $self->throw(\"Need to pass me a value.\")\n       unless defined $value;\n   $self->throw(\"I need a Bio::Location, not [$value]\")\n       unless $value->isa('Bio::LocationI');\n   $self->throw(\"No coordinate mappers!\")\n       unless $self->each_mapper;\n\n   $self->sort unless $self->_is_sorted;\n\n\n   if ($value->isa(\"Bio::Location::SplitLocationI\")) {\n\n       my $result = Bio::Coordinate::Result->new();\n       foreach my $loc ( $value->sub_Location(1) ) {\n\n           my $res = $self->_map($loc);\n           map { $result->add_sub_Location($_) } $res->each_Location;\n\n       }\n       return $result;\n\n   } else {\n       return $self->_map($value);\n   }\n\n\n}\n\n\n=head2 _map\n\n Title   : _map\n Usage   : $newpos = $obj->_map($simpleloc);\n Function: Internal method that does the actual mapping. Called multiple times\n           by map() if the location  to be mapped is a split location\n\n Example :\n Returns : new location in the output coordinate system or undef\n Args    : Bio::Location::Simple\n\n\nsub _map {\n   my ($self,$value) = @_;\n\n   my $result = Bio::Coordinate::Result->new(-is_remote=>1);\n\nIDMATCH: {\n\n       # bail out now we if are forcing the use of an ID \n       # and it is not in this collection\n       last IDMATCH if defined $value->seq_id && \n\t   ! $self->{'_in_ids'}->{$value->seq_id};\n\n       foreach my $pair ($self->each_mapper) {\n\n\t   # if we are limiting input to a certain ID\n\t   next if defined $value->seq_id && $value->seq_id ne $pair->in->seq_id;\n\n\t   # if we haven't even reached the start, move on\n\t   next if $pair->in->end < $value->start;\n\t   # if we have over run, break\n\t   last if $pair->in->start > $value->end;\n\n\t   my $subres = $pair->map($value);\n\t   $result->add_result($subres);\n       }\n   }\n\n   $result->seq_id($result->match->seq_id) if $result->match;\n   unless ($result->each_Location) {\n       #build one gap;\n       my $gap = Bio::Location::Simple->new(-start => $value->start,\n\t\t\t\t\t    -end => $value->end,\n\t\t\t\t\t    -strand => $value->strand,\n\t\t\t\t\t    -location_type => $value->location_type\n\t\t\t\t\t   );\n       $gap->seq_id($value->seq_id) if defined $value->seq_id;\n       bless $gap, 'Bio::Coordinate::Result::Gap';\n       $result->seq_id($value->seq_id) if defined $value->seq_id;\n       $result->add_sub_Location($gap);\n   }\n   return $result;\n}\n\n\n=head2 sort\n\n Title   : sort\n Usage   : $obj->sort;\n Function: Sort function so that all mappings are sorted by\n           input coordinate start\n Example :\n Returns : 1\n Args    : \n\n\nsub sort{\n   my ($self) = @_;\n\n   @{$self->{'_mappers'}} = map { $_->[0] }\n                            sort { $a->[1] <=> $b->[1] }\n                            map { [ $_, $_->in->start] } \n                            @{$self->{'_mappers'}};\n\n   #create hashes for sequence ids\n   $self->{'_in_ids'} = ();\n   $self->{'_out_ids'} = ();\n   foreach ($self->each_mapper) {\n       $self->{'_in_ids'}->{$_->in->seq_id} = 1;\n       $self->{'_out_ids'}->{$_->out->seq_id} = 1;\n   }\n\n   $self->_is_sorted(1);\n}\n\n=head2 _is_sorted\n\n Title   : _is_sorted\n Usage   : $newpos = $obj->_is_sorted;\n Function: toggle for whether the (internal) coodinate mapper data are sorted\n Example :\n Returns : boolean\n Args    : boolean"},"detail":"($self,$value)","definition":"sub","containerName":"main::"}],"version":5}