{"vars":[{"line":108,"kind":2,"name":"base","containerName":""},{"name":"new","range":{"end":{"character":9999,"line":143},"start":{"character":0,"line":126}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: SequenceFamily.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# BioPerl module for Bio::Cluster::SequenceFamily\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::SequenceFamily - Sequence Family object\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::Cluster::SequenceFamily;\n  use File::Spec;\n\n  my $file =  File::Spec->catfile('t','data','swiss.dat');\n  my $seqio= Bio::SeqIO->new(-format => 'swiss',\n                            -file => $file);\n  my @mem;\n  while(my $seq = $seqio->next_seq){\n    push @mem, $seq;\n  }\n\n  #create the family\n  my $family = Bio::Cluster::SequenceFamily->new(\n          -family_id=>\"Family_1\",\n          -description=>\"Family Description Here\",\n          -annotation_score=>\"100\",\n          -members=>\\@mem);\n\n  #access the family\n\n  foreach my $mem ($family->get_members){\n    print $mem->display_id.\"\\t\".$mem->desc.\"\\n\";\n  }\n\n  #select members if members have a Bio::Species Object\n\n  my @mem = $family->get_members(-binomial=>\"Homo sapiens\");\n  @mem = $family->get_members(-ncbi_taxid => 9606);\n  @mem = $family->get_members(-common_name=>\"Human\");\n  @mem = $family->get_members(-species=>\"sapiens\");\n  @mem = $family->get_members(-genus=>\"Homo\");\n\n=head1 DESCRIPTION\n\nThis is a simple Family object that may hold any group of object. For more\nspecific families, one should derive from FamilyI.\n\n=head1 FEEDBACK\n\nEmail bioperl-l@bioperl.org for support and feedback.\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::SequenceFamily;\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Cluster::FamilyI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Cluster::SequenceFamily->new(\n                             -family_id=>\"Family_1\",\n                             -description=>\"Family Description Here\",\n                             -annotation_score=>\"100\",\n                             -members=>\\@mem);\n Function: Constructor for SequenceFamily object\n Returns : Bio::Cluster::SequenceFamily object\n\nSee L<Bio::Cluster::SequenceFamily>.","label":"new($class,@args)"},"detail":"($class,@args)","kind":12,"children":[{"kind":13,"line":127,"containerName":"new","name":"$class","definition":"my","localvar":"my"},{"containerName":"new","name":"@args","line":127,"kind":13},{"containerName":"new","definition":"my","name":"$self","localvar":"my","kind":13,"line":128},{"containerName":"new","name":"$class","line":128,"kind":13},{"name":"@args","containerName":"new","line":128,"kind":13},{"containerName":"new","definition":"my","name":"$id","localvar":"my","kind":13,"line":129},{"name":"$description","containerName":"new","line":129,"kind":13},{"name":"$version","containerName":"new","kind":13,"line":129},{"kind":13,"line":129,"name":"$annot_score","containerName":"new"},{"containerName":"new","name":"$family_score","kind":13,"line":130},{"name":"$members","containerName":"new","line":130,"kind":13},{"containerName":"new","name":"$self","line":130,"kind":13},{"name":"_rearrange","containerName":"new","line":130,"kind":12},{"line":132,"kind":13,"containerName":"new","name":"@args"},{"line":133,"kind":13,"name":"$self","containerName":"new"},{"name":"$id","containerName":"new","line":134,"kind":13},{"kind":13,"line":134,"name":"$self","containerName":"new"},{"kind":12,"line":134,"containerName":"new","name":"family_id"},{"line":134,"kind":13,"containerName":"new","name":"$id"},{"containerName":"new","name":"$description","line":135,"kind":13},{"kind":13,"line":135,"name":"$self","containerName":"new"},{"name":"description","containerName":"new","kind":12,"line":135},{"containerName":"new","name":"$description","line":135,"kind":13},{"name":"$version","containerName":"new","kind":13,"line":136},{"containerName":"new","name":"$self","kind":13,"line":136},{"line":136,"kind":12,"name":"version","containerName":"new"},{"kind":13,"line":136,"name":"$version","containerName":"new"},{"name":"$annot_score","containerName":"new","kind":13,"line":137},{"containerName":"new","name":"$self","line":137,"kind":13},{"name":"annotation_score","containerName":"new","kind":12,"line":137},{"line":137,"kind":13,"name":"$annot_score","containerName":"new"},{"kind":13,"line":138,"name":"$family_score","containerName":"new"},{"name":"$self","containerName":"new","line":138,"kind":13},{"kind":12,"line":138,"name":"family_score","containerName":"new"},{"containerName":"new","name":"$family_score","line":138,"kind":13},{"kind":13,"line":139,"containerName":"new","name":"$members"},{"name":"$self","containerName":"new","line":139,"kind":13},{"containerName":"new","name":"add_members","kind":12,"line":139},{"containerName":"new","name":"$members","line":139,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":141}],"line":126},{"kind":12,"line":128,"name":"SUPER","containerName":"new"},{"kind":12,"children":[{"name":"$self","definition":"my","containerName":"version","localvar":"my","kind":13,"line":155},{"name":"$value","containerName":"version","kind":13,"line":155},{"containerName":"version","name":"$value","line":156,"kind":13},{"kind":13,"line":157,"name":"$self","containerName":"version"},{"name":"$value","containerName":"version","kind":13,"line":157},{"containerName":"version","name":"$self","line":159,"kind":13}],"line":154,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SequenceFamily.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# BioPerl module for Bio::Cluster::SequenceFamily\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::SequenceFamily - Sequence Family object\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::Cluster::SequenceFamily;\n  use File::Spec;\n\n  my $file =  File::Spec->catfile('t','data','swiss.dat');\n  my $seqio= Bio::SeqIO->new(-format => 'swiss',\n                            -file => $file);\n  my @mem;\n  while(my $seq = $seqio->next_seq){\n    push @mem, $seq;\n  }\n\n  #create the family\n  my $family = Bio::Cluster::SequenceFamily->new(\n          -family_id=>\"Family_1\",\n          -description=>\"Family Description Here\",\n          -annotation_score=>\"100\",\n          -members=>\\@mem);\n\n  #access the family\n\n  foreach my $mem ($family->get_members){\n    print $mem->display_id.\"\\t\".$mem->desc.\"\\n\";\n  }\n\n  #select members if members have a Bio::Species Object\n\n  my @mem = $family->get_members(-binomial=>\"Homo sapiens\");\n  @mem = $family->get_members(-ncbi_taxid => 9606);\n  @mem = $family->get_members(-common_name=>\"Human\");\n  @mem = $family->get_members(-species=>\"sapiens\");\n  @mem = $family->get_members(-genus=>\"Homo\");\n\n=head1 DESCRIPTION\n\nThis is a simple Family object that may hold any group of object. For more\nspecific families, one should derive from FamilyI.\n\n=head1 FEEDBACK\n\nEmail bioperl-l@bioperl.org for support and feedback.\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::SequenceFamily;\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Cluster::FamilyI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Cluster::SequenceFamily->new(\n                             -family_id=>\"Family_1\",\n                             -description=>\"Family Description Here\",\n                             -annotation_score=>\"100\",\n                             -members=>\\@mem);\n Function: Constructor for SequenceFamily object\n Returns : Bio::Cluster::SequenceFamily object\n\nSee L<Bio::Cluster::SequenceFamily>.\n\n\nsub new {\n\tmy ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id,$description,$version,$annot_score,\n  $family_score,$members) = $self->_rearrange([qw(FAMILY_ID DESCRIPTION VERSION \n                                                   ANNOTATION_SCORE \n                                                   FAMILY_SCORE MEMBERS)],@args);\n  $self->{'_members'} = [];\n  $id && $self->family_id($id);\n  $description && $self->description($description);\n  $version && $self->version($version);\n  $annot_score && $self->annotation_score($annot_score);\n  $family_score && $self->family_score($family_score);\n  $members && $self->add_members($members);\n\n  return $self;\n\n}\n\n=head2 version\n\n Title   : version\n Usage   : $family->version(\"1.0\");\n Function: get/set for version\n Returns : a string version of the family generated. ","label":"version($self,$value)"},"detail":"($self,$value)","name":"version","range":{"end":{"character":9999,"line":160},"start":{"character":0,"line":154}}},{"range":{"end":{"character":9999,"line":182},"start":{"line":176,"character":0}},"name":"annotation_score","signature":{"label":"annotation_score($self,$score)","documentation":"1;\n# $Id: SequenceFamily.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# BioPerl module for Bio::Cluster::SequenceFamily\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::SequenceFamily - Sequence Family object\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::Cluster::SequenceFamily;\n  use File::Spec;\n\n  my $file =  File::Spec->catfile('t','data','swiss.dat');\n  my $seqio= Bio::SeqIO->new(-format => 'swiss',\n                            -file => $file);\n  my @mem;\n  while(my $seq = $seqio->next_seq){\n    push @mem, $seq;\n  }\n\n  #create the family\n  my $family = Bio::Cluster::SequenceFamily->new(\n          -family_id=>\"Family_1\",\n          -description=>\"Family Description Here\",\n          -annotation_score=>\"100\",\n          -members=>\\@mem);\n\n  #access the family\n\n  foreach my $mem ($family->get_members){\n    print $mem->display_id.\"\\t\".$mem->desc.\"\\n\";\n  }\n\n  #select members if members have a Bio::Species Object\n\n  my @mem = $family->get_members(-binomial=>\"Homo sapiens\");\n  @mem = $family->get_members(-ncbi_taxid => 9606);\n  @mem = $family->get_members(-common_name=>\"Human\");\n  @mem = $family->get_members(-species=>\"sapiens\");\n  @mem = $family->get_members(-genus=>\"Homo\");\n\n=head1 DESCRIPTION\n\nThis is a simple Family object that may hold any group of object. For more\nspecific families, one should derive from FamilyI.\n\n=head1 FEEDBACK\n\nEmail bioperl-l@bioperl.org for support and feedback.\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::SequenceFamily;\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Cluster::FamilyI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Cluster::SequenceFamily->new(\n                             -family_id=>\"Family_1\",\n                             -description=>\"Family Description Here\",\n                             -annotation_score=>\"100\",\n                             -members=>\\@mem);\n Function: Constructor for SequenceFamily object\n Returns : Bio::Cluster::SequenceFamily object\n\nSee L<Bio::Cluster::SequenceFamily>.\n\n\nsub new {\n\tmy ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id,$description,$version,$annot_score,\n  $family_score,$members) = $self->_rearrange([qw(FAMILY_ID DESCRIPTION VERSION \n                                                   ANNOTATION_SCORE \n                                                   FAMILY_SCORE MEMBERS)],@args);\n  $self->{'_members'} = [];\n  $id && $self->family_id($id);\n  $description && $self->description($description);\n  $version && $self->version($version);\n  $annot_score && $self->annotation_score($annot_score);\n  $family_score && $self->family_score($family_score);\n  $members && $self->add_members($members);\n\n  return $self;\n\n}\n\n=head2 version\n\n Title   : version\n Usage   : $family->version(\"1.0\");\n Function: get/set for version\n Returns : a string version of the family generated. \n\n\nsub version{\n  my ($self,$value) = @_;\n  if($value){\n    $self->{'_version'} =$value;\n  }\n  return $self->{'_version'};\n}\n\n=head2 annotation_score\n\n Title   : annotation_score\n Usage   : $family->annotation_score(100);\n Function: get/set for annotation_score which\n           represent the confidence in which the \n           consensus description has been assigned\n           to the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>","parameters":[{"label":"$self"},{"label":"$score"}]},"detail":"($self,$score)","definition":"sub","containerName":"main::","children":[{"line":177,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"annotation_score"},{"kind":13,"line":177,"containerName":"annotation_score","name":"$score"},{"line":178,"kind":13,"name":"$score","containerName":"annotation_score"},{"name":"$self","containerName":"annotation_score","line":179,"kind":13},{"kind":13,"line":179,"name":"$score","containerName":"annotation_score"},{"containerName":"annotation_score","name":"$self","kind":13,"line":181}],"line":176,"kind":12},{"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: SequenceFamily.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# BioPerl module for Bio::Cluster::SequenceFamily\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::SequenceFamily - Sequence Family object\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::Cluster::SequenceFamily;\n  use File::Spec;\n\n  my $file =  File::Spec->catfile('t','data','swiss.dat');\n  my $seqio= Bio::SeqIO->new(-format => 'swiss',\n                            -file => $file);\n  my @mem;\n  while(my $seq = $seqio->next_seq){\n    push @mem, $seq;\n  }\n\n  #create the family\n  my $family = Bio::Cluster::SequenceFamily->new(\n          -family_id=>\"Family_1\",\n          -description=>\"Family Description Here\",\n          -annotation_score=>\"100\",\n          -members=>\\@mem);\n\n  #access the family\n\n  foreach my $mem ($family->get_members){\n    print $mem->display_id.\"\\t\".$mem->desc.\"\\n\";\n  }\n\n  #select members if members have a Bio::Species Object\n\n  my @mem = $family->get_members(-binomial=>\"Homo sapiens\");\n  @mem = $family->get_members(-ncbi_taxid => 9606);\n  @mem = $family->get_members(-common_name=>\"Human\");\n  @mem = $family->get_members(-species=>\"sapiens\");\n  @mem = $family->get_members(-genus=>\"Homo\");\n\n=head1 DESCRIPTION\n\nThis is a simple Family object that may hold any group of object. For more\nspecific families, one should derive from FamilyI.\n\n=head1 FEEDBACK\n\nEmail bioperl-l@bioperl.org for support and feedback.\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::SequenceFamily;\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Cluster::FamilyI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Cluster::SequenceFamily->new(\n                             -family_id=>\"Family_1\",\n                             -description=>\"Family Description Here\",\n                             -annotation_score=>\"100\",\n                             -members=>\\@mem);\n Function: Constructor for SequenceFamily object\n Returns : Bio::Cluster::SequenceFamily object\n\nSee L<Bio::Cluster::SequenceFamily>.\n\n\nsub new {\n\tmy ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id,$description,$version,$annot_score,\n  $family_score,$members) = $self->_rearrange([qw(FAMILY_ID DESCRIPTION VERSION \n                                                   ANNOTATION_SCORE \n                                                   FAMILY_SCORE MEMBERS)],@args);\n  $self->{'_members'} = [];\n  $id && $self->family_id($id);\n  $description && $self->description($description);\n  $version && $self->version($version);\n  $annot_score && $self->annotation_score($annot_score);\n  $family_score && $self->family_score($family_score);\n  $members && $self->add_members($members);\n\n  return $self;\n\n}\n\n=head2 version\n\n Title   : version\n Usage   : $family->version(\"1.0\");\n Function: get/set for version\n Returns : a string version of the family generated. \n\n\nsub version{\n  my ($self,$value) = @_;\n  if($value){\n    $self->{'_version'} =$value;\n  }\n  return $self->{'_version'};\n}\n\n=head2 annotation_score\n\n Title   : annotation_score\n Usage   : $family->annotation_score(100);\n Function: get/set for annotation_score which\n           represent the confidence in which the \n           consensus description has been assigned\n           to the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>\n\n\nsub annotation_score{\n  my ($self,$score) = @_;\n  if($score){\n    $self->{'_annotation_score'} = $score;\n  }\n  return $self->{'_annotation_score'};\n}\n\n=head2 alignment\n\n Title   : alignment\n Usage   : $family->alignment($align);\n Function: get/set for an alignment object representing\n           the multiple alignment of the members of the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>","parameters":[{"label":"$self"},{"label":"$align"}],"label":"alignment($self,$align)"},"detail":"($self,$align)","kind":12,"children":[{"line":197,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"alignment"},{"name":"$align","containerName":"alignment","line":197,"kind":13},{"kind":13,"line":198,"containerName":"alignment","name":"$align"},{"containerName":"alignment","name":"$self","line":199,"kind":13},{"containerName":"alignment","name":"$align","kind":13,"line":199},{"line":201,"kind":13,"name":"$self","containerName":"alignment"}],"line":196,"name":"alignment","range":{"end":{"character":9999,"line":202},"start":{"line":196,"character":0}}},{"containerName":"main::","definition":"sub","detail":"($self,$tree)","signature":{"parameters":[{"label":"$self"},{"label":"$tree"}],"documentation":"1;\n# $Id: SequenceFamily.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# BioPerl module for Bio::Cluster::SequenceFamily\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::SequenceFamily - Sequence Family object\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::Cluster::SequenceFamily;\n  use File::Spec;\n\n  my $file =  File::Spec->catfile('t','data','swiss.dat');\n  my $seqio= Bio::SeqIO->new(-format => 'swiss',\n                            -file => $file);\n  my @mem;\n  while(my $seq = $seqio->next_seq){\n    push @mem, $seq;\n  }\n\n  #create the family\n  my $family = Bio::Cluster::SequenceFamily->new(\n          -family_id=>\"Family_1\",\n          -description=>\"Family Description Here\",\n          -annotation_score=>\"100\",\n          -members=>\\@mem);\n\n  #access the family\n\n  foreach my $mem ($family->get_members){\n    print $mem->display_id.\"\\t\".$mem->desc.\"\\n\";\n  }\n\n  #select members if members have a Bio::Species Object\n\n  my @mem = $family->get_members(-binomial=>\"Homo sapiens\");\n  @mem = $family->get_members(-ncbi_taxid => 9606);\n  @mem = $family->get_members(-common_name=>\"Human\");\n  @mem = $family->get_members(-species=>\"sapiens\");\n  @mem = $family->get_members(-genus=>\"Homo\");\n\n=head1 DESCRIPTION\n\nThis is a simple Family object that may hold any group of object. For more\nspecific families, one should derive from FamilyI.\n\n=head1 FEEDBACK\n\nEmail bioperl-l@bioperl.org for support and feedback.\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::SequenceFamily;\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Cluster::FamilyI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Cluster::SequenceFamily->new(\n                             -family_id=>\"Family_1\",\n                             -description=>\"Family Description Here\",\n                             -annotation_score=>\"100\",\n                             -members=>\\@mem);\n Function: Constructor for SequenceFamily object\n Returns : Bio::Cluster::SequenceFamily object\n\nSee L<Bio::Cluster::SequenceFamily>.\n\n\nsub new {\n\tmy ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id,$description,$version,$annot_score,\n  $family_score,$members) = $self->_rearrange([qw(FAMILY_ID DESCRIPTION VERSION \n                                                   ANNOTATION_SCORE \n                                                   FAMILY_SCORE MEMBERS)],@args);\n  $self->{'_members'} = [];\n  $id && $self->family_id($id);\n  $description && $self->description($description);\n  $version && $self->version($version);\n  $annot_score && $self->annotation_score($annot_score);\n  $family_score && $self->family_score($family_score);\n  $members && $self->add_members($members);\n\n  return $self;\n\n}\n\n=head2 version\n\n Title   : version\n Usage   : $family->version(\"1.0\");\n Function: get/set for version\n Returns : a string version of the family generated. \n\n\nsub version{\n  my ($self,$value) = @_;\n  if($value){\n    $self->{'_version'} =$value;\n  }\n  return $self->{'_version'};\n}\n\n=head2 annotation_score\n\n Title   : annotation_score\n Usage   : $family->annotation_score(100);\n Function: get/set for annotation_score which\n           represent the confidence in which the \n           consensus description has been assigned\n           to the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>\n\n\nsub annotation_score{\n  my ($self,$score) = @_;\n  if($score){\n    $self->{'_annotation_score'} = $score;\n  }\n  return $self->{'_annotation_score'};\n}\n\n=head2 alignment\n\n Title   : alignment\n Usage   : $family->alignment($align);\n Function: get/set for an alignment object representing\n           the multiple alignment of the members of the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>\n\n\nsub alignment {\n\tmy ($self,$align) = @_;\n  if($align){\n    $self->{'_alignment'} = $align;\n  }\n    return $self->{'_alignment'};\n}\n\n=head2 tree\n\n Title   : tree\n Usage   : $family->tree($tree);\n Function: get/set for an tree object representing\n           the phylogenetic tree of the family. \n Returns : Bio::Tree\n\nSee L<Bio::Tree>","label":"tree($self,$tree)"},"kind":12,"line":216,"children":[{"line":217,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"tree"},{"line":217,"kind":13,"containerName":"tree","name":"$tree"},{"kind":13,"line":218,"containerName":"tree","name":"$tree"},{"line":219,"kind":13,"name":"$self","containerName":"tree"},{"line":219,"kind":13,"containerName":"tree","name":"$tree"},{"line":221,"kind":13,"containerName":"tree","name":"$self"}],"name":"tree","range":{"start":{"line":216,"character":0},"end":{"character":9999,"line":222}}},{"containerName":"main::","name":"family_score","definition":"sub","range":{"start":{"character":0,"line":242},"end":{"character":9999,"line":244}},"kind":12,"line":242,"children":[{"name":"cluster_score","containerName":"family_score","line":243,"kind":12}]},{"kind":12,"line":259,"children":[{"containerName":"family_id","name":"display_id","kind":12,"line":260}],"containerName":"main::","name":"family_id","definition":"sub","range":{"end":{"character":9999,"line":261},"start":{"line":259,"character":0}}},{"detail":"($self,$id)","signature":{"label":"display_id($self,$id)","documentation":"1;\n# $Id: SequenceFamily.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# BioPerl module for Bio::Cluster::SequenceFamily\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::SequenceFamily - Sequence Family object\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::Cluster::SequenceFamily;\n  use File::Spec;\n\n  my $file =  File::Spec->catfile('t','data','swiss.dat');\n  my $seqio= Bio::SeqIO->new(-format => 'swiss',\n                            -file => $file);\n  my @mem;\n  while(my $seq = $seqio->next_seq){\n    push @mem, $seq;\n  }\n\n  #create the family\n  my $family = Bio::Cluster::SequenceFamily->new(\n          -family_id=>\"Family_1\",\n          -description=>\"Family Description Here\",\n          -annotation_score=>\"100\",\n          -members=>\\@mem);\n\n  #access the family\n\n  foreach my $mem ($family->get_members){\n    print $mem->display_id.\"\\t\".$mem->desc.\"\\n\";\n  }\n\n  #select members if members have a Bio::Species Object\n\n  my @mem = $family->get_members(-binomial=>\"Homo sapiens\");\n  @mem = $family->get_members(-ncbi_taxid => 9606);\n  @mem = $family->get_members(-common_name=>\"Human\");\n  @mem = $family->get_members(-species=>\"sapiens\");\n  @mem = $family->get_members(-genus=>\"Homo\");\n\n=head1 DESCRIPTION\n\nThis is a simple Family object that may hold any group of object. For more\nspecific families, one should derive from FamilyI.\n\n=head1 FEEDBACK\n\nEmail bioperl-l@bioperl.org for support and feedback.\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::SequenceFamily;\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Cluster::FamilyI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Cluster::SequenceFamily->new(\n                             -family_id=>\"Family_1\",\n                             -description=>\"Family Description Here\",\n                             -annotation_score=>\"100\",\n                             -members=>\\@mem);\n Function: Constructor for SequenceFamily object\n Returns : Bio::Cluster::SequenceFamily object\n\nSee L<Bio::Cluster::SequenceFamily>.\n\n\nsub new {\n\tmy ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id,$description,$version,$annot_score,\n  $family_score,$members) = $self->_rearrange([qw(FAMILY_ID DESCRIPTION VERSION \n                                                   ANNOTATION_SCORE \n                                                   FAMILY_SCORE MEMBERS)],@args);\n  $self->{'_members'} = [];\n  $id && $self->family_id($id);\n  $description && $self->description($description);\n  $version && $self->version($version);\n  $annot_score && $self->annotation_score($annot_score);\n  $family_score && $self->family_score($family_score);\n  $members && $self->add_members($members);\n\n  return $self;\n\n}\n\n=head2 version\n\n Title   : version\n Usage   : $family->version(\"1.0\");\n Function: get/set for version\n Returns : a string version of the family generated. \n\n\nsub version{\n  my ($self,$value) = @_;\n  if($value){\n    $self->{'_version'} =$value;\n  }\n  return $self->{'_version'};\n}\n\n=head2 annotation_score\n\n Title   : annotation_score\n Usage   : $family->annotation_score(100);\n Function: get/set for annotation_score which\n           represent the confidence in which the \n           consensus description has been assigned\n           to the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>\n\n\nsub annotation_score{\n  my ($self,$score) = @_;\n  if($score){\n    $self->{'_annotation_score'} = $score;\n  }\n  return $self->{'_annotation_score'};\n}\n\n=head2 alignment\n\n Title   : alignment\n Usage   : $family->alignment($align);\n Function: get/set for an alignment object representing\n           the multiple alignment of the members of the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>\n\n\nsub alignment {\n\tmy ($self,$align) = @_;\n  if($align){\n    $self->{'_alignment'} = $align;\n  }\n    return $self->{'_alignment'};\n}\n\n=head2 tree\n\n Title   : tree\n Usage   : $family->tree($tree);\n Function: get/set for an tree object representing\n           the phylogenetic tree of the family. \n Returns : Bio::Tree\n\nSee L<Bio::Tree>\n\n\nsub tree {\n  my ($self,$tree) = @_;\n  if($tree) {\n    $self->{'_tree'} = $tree;\n  }\n  return $self->{'_tree'};\n}\n\n=head1 L<Bio::Cluster::FamilyI> methods\n\n\n=head2 family_score\n\n Title   : family_score\n Usage   : Bio::Cluster::FamilyI->family_score(95);\n Function: get/set for the score of algorithm used to generate\n           the family if present\n\n           This is aliased to cluster_score().\n\n Returns : the score\n Args    : the score\n\n\nsub family_score {\n    return shift->cluster_score(@_);\n}\n\n\n=head2 family_id\n\n Title   : family_id\n Usage   : $family->family_id(\"Family_1\"); \n Function: get/set for family id \n\n           This is aliased to display_id().\n\n Returns : a string specifying identifier of the family \n\n\nsub family_id{\n\treturn shift->display_id(@_);\n}\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n Returns : a string\n Args    : optional, on set the display ID ( a string)","parameters":[{"label":"$self"},{"label":"$id"}]},"containerName":"main::","definition":"sub","line":277,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"display_id","line":278,"kind":13},{"name":"$id","containerName":"display_id","line":278,"kind":13},{"name":"$id","containerName":"display_id","line":279,"kind":13},{"containerName":"display_id","name":"$self","line":280,"kind":13},{"line":280,"kind":13,"name":"$id","containerName":"display_id"},{"name":"$self","containerName":"display_id","kind":13,"line":282}],"kind":12,"range":{"end":{"character":9999,"line":283},"start":{"character":0,"line":277}},"name":"display_id"},{"name":"description","range":{"end":{"character":9999,"line":301},"start":{"character":0,"line":295}},"containerName":"main::","definition":"sub","detail":"($self,$desc)","signature":{"documentation":"1;\n# $Id: SequenceFamily.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# BioPerl module for Bio::Cluster::SequenceFamily\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::SequenceFamily - Sequence Family object\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::Cluster::SequenceFamily;\n  use File::Spec;\n\n  my $file =  File::Spec->catfile('t','data','swiss.dat');\n  my $seqio= Bio::SeqIO->new(-format => 'swiss',\n                            -file => $file);\n  my @mem;\n  while(my $seq = $seqio->next_seq){\n    push @mem, $seq;\n  }\n\n  #create the family\n  my $family = Bio::Cluster::SequenceFamily->new(\n          -family_id=>\"Family_1\",\n          -description=>\"Family Description Here\",\n          -annotation_score=>\"100\",\n          -members=>\\@mem);\n\n  #access the family\n\n  foreach my $mem ($family->get_members){\n    print $mem->display_id.\"\\t\".$mem->desc.\"\\n\";\n  }\n\n  #select members if members have a Bio::Species Object\n\n  my @mem = $family->get_members(-binomial=>\"Homo sapiens\");\n  @mem = $family->get_members(-ncbi_taxid => 9606);\n  @mem = $family->get_members(-common_name=>\"Human\");\n  @mem = $family->get_members(-species=>\"sapiens\");\n  @mem = $family->get_members(-genus=>\"Homo\");\n\n=head1 DESCRIPTION\n\nThis is a simple Family object that may hold any group of object. For more\nspecific families, one should derive from FamilyI.\n\n=head1 FEEDBACK\n\nEmail bioperl-l@bioperl.org for support and feedback.\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::SequenceFamily;\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Cluster::FamilyI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Cluster::SequenceFamily->new(\n                             -family_id=>\"Family_1\",\n                             -description=>\"Family Description Here\",\n                             -annotation_score=>\"100\",\n                             -members=>\\@mem);\n Function: Constructor for SequenceFamily object\n Returns : Bio::Cluster::SequenceFamily object\n\nSee L<Bio::Cluster::SequenceFamily>.\n\n\nsub new {\n\tmy ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id,$description,$version,$annot_score,\n  $family_score,$members) = $self->_rearrange([qw(FAMILY_ID DESCRIPTION VERSION \n                                                   ANNOTATION_SCORE \n                                                   FAMILY_SCORE MEMBERS)],@args);\n  $self->{'_members'} = [];\n  $id && $self->family_id($id);\n  $description && $self->description($description);\n  $version && $self->version($version);\n  $annot_score && $self->annotation_score($annot_score);\n  $family_score && $self->family_score($family_score);\n  $members && $self->add_members($members);\n\n  return $self;\n\n}\n\n=head2 version\n\n Title   : version\n Usage   : $family->version(\"1.0\");\n Function: get/set for version\n Returns : a string version of the family generated. \n\n\nsub version{\n  my ($self,$value) = @_;\n  if($value){\n    $self->{'_version'} =$value;\n  }\n  return $self->{'_version'};\n}\n\n=head2 annotation_score\n\n Title   : annotation_score\n Usage   : $family->annotation_score(100);\n Function: get/set for annotation_score which\n           represent the confidence in which the \n           consensus description has been assigned\n           to the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>\n\n\nsub annotation_score{\n  my ($self,$score) = @_;\n  if($score){\n    $self->{'_annotation_score'} = $score;\n  }\n  return $self->{'_annotation_score'};\n}\n\n=head2 alignment\n\n Title   : alignment\n Usage   : $family->alignment($align);\n Function: get/set for an alignment object representing\n           the multiple alignment of the members of the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>\n\n\nsub alignment {\n\tmy ($self,$align) = @_;\n  if($align){\n    $self->{'_alignment'} = $align;\n  }\n    return $self->{'_alignment'};\n}\n\n=head2 tree\n\n Title   : tree\n Usage   : $family->tree($tree);\n Function: get/set for an tree object representing\n           the phylogenetic tree of the family. \n Returns : Bio::Tree\n\nSee L<Bio::Tree>\n\n\nsub tree {\n  my ($self,$tree) = @_;\n  if($tree) {\n    $self->{'_tree'} = $tree;\n  }\n  return $self->{'_tree'};\n}\n\n=head1 L<Bio::Cluster::FamilyI> methods\n\n\n=head2 family_score\n\n Title   : family_score\n Usage   : Bio::Cluster::FamilyI->family_score(95);\n Function: get/set for the score of algorithm used to generate\n           the family if present\n\n           This is aliased to cluster_score().\n\n Returns : the score\n Args    : the score\n\n\nsub family_score {\n    return shift->cluster_score(@_);\n}\n\n\n=head2 family_id\n\n Title   : family_id\n Usage   : $family->family_id(\"Family_1\"); \n Function: get/set for family id \n\n           This is aliased to display_id().\n\n Returns : a string specifying identifier of the family \n\n\nsub family_id{\n\treturn shift->display_id(@_);\n}\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n\tmy ($self,$id) = @_;\n\tif($id){\n\t\t$self->{'_cluster_id'} = $id;\n\t}\n\treturn $self->{'_cluster_id'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : $fam->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n Returns : the description string \n Args    : Optional the description string ","parameters":[{"label":"$self"},{"label":"$desc"}],"label":"description($self,$desc)"},"kind":12,"line":295,"children":[{"kind":13,"line":296,"containerName":"description","name":"$self","definition":"my","localvar":"my"},{"line":296,"kind":13,"name":"$desc","containerName":"description"},{"name":"$desc","containerName":"description","kind":13,"line":297},{"line":298,"kind":13,"containerName":"description","name":"$self"},{"containerName":"description","name":"$desc","kind":13,"line":298},{"containerName":"description","name":"$self","kind":13,"line":300}]},{"range":{"start":{"character":0,"line":325},"end":{"character":9999,"line":346}},"containerName":"main::","name":"get_members","definition":"sub","line":325,"children":[{"line":326,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"get_members"},{"localvar":"my","name":"@ret","definition":"my","containerName":"get_members","line":327,"kind":13},{"localvar":"my","containerName":"get_members","definition":"my","name":"%hash","line":330,"kind":13},{"localvar":"my","name":"$mem","definition":"my","containerName":"get_members","line":331,"kind":13},{"containerName":"get_members","name":"$self","kind":13,"line":331},{"kind":13,"line":332,"containerName":"get_members","definition":"my","name":"$key","localvar":"my"},{"containerName":"get_members","name":"%hash","line":332,"kind":13},{"line":333,"kind":13,"localvar":"my","name":"$method","definition":"my","containerName":"get_members"},{"kind":13,"line":333,"containerName":"get_members","name":"$key"},{"name":"$method","containerName":"get_members","kind":13,"line":334},{"line":335,"kind":13,"containerName":"get_members","name":"$mem"},{"kind":12,"line":335,"name":"can","containerName":"get_members"},{"definition":"my","name":"$species","containerName":"get_members","localvar":"my","kind":13,"line":336},{"line":336,"kind":13,"name":"$mem","containerName":"get_members"},{"name":"species","containerName":"get_members","line":336,"kind":12},{"line":337,"kind":13,"containerName":"get_members","name":"$species"},{"name":"can","containerName":"get_members","kind":12,"line":337},{"name":"$method","containerName":"get_members","kind":13,"line":337},{"name":"$self","containerName":"get_members","kind":13,"line":338},{"name":"throw","containerName":"get_members","kind":12,"line":338},{"containerName":"get_members","name":"$species","line":339,"kind":13},{"name":"$method","containerName":"get_members","line":339,"kind":13},{"kind":13,"line":339,"name":"$hash","containerName":"get_members"},{"name":"$key","containerName":"get_members","kind":13,"line":339},{"kind":13,"line":340,"name":"@ret","containerName":"get_members"},{"name":"$mem","containerName":"get_members","line":340,"kind":13},{"containerName":"get_members","name":"@ret","line":345,"kind":13}],"kind":12},{"kind":13,"line":347,"name":"%self","containerName":null},{"name":"size","range":{"end":{"line":364,"character":9999},"start":{"line":361,"character":0}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: SequenceFamily.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# BioPerl module for Bio::Cluster::SequenceFamily\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::SequenceFamily - Sequence Family object\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::Cluster::SequenceFamily;\n  use File::Spec;\n\n  my $file =  File::Spec->catfile('t','data','swiss.dat');\n  my $seqio= Bio::SeqIO->new(-format => 'swiss',\n                            -file => $file);\n  my @mem;\n  while(my $seq = $seqio->next_seq){\n    push @mem, $seq;\n  }\n\n  #create the family\n  my $family = Bio::Cluster::SequenceFamily->new(\n          -family_id=>\"Family_1\",\n          -description=>\"Family Description Here\",\n          -annotation_score=>\"100\",\n          -members=>\\@mem);\n\n  #access the family\n\n  foreach my $mem ($family->get_members){\n    print $mem->display_id.\"\\t\".$mem->desc.\"\\n\";\n  }\n\n  #select members if members have a Bio::Species Object\n\n  my @mem = $family->get_members(-binomial=>\"Homo sapiens\");\n  @mem = $family->get_members(-ncbi_taxid => 9606);\n  @mem = $family->get_members(-common_name=>\"Human\");\n  @mem = $family->get_members(-species=>\"sapiens\");\n  @mem = $family->get_members(-genus=>\"Homo\");\n\n=head1 DESCRIPTION\n\nThis is a simple Family object that may hold any group of object. For more\nspecific families, one should derive from FamilyI.\n\n=head1 FEEDBACK\n\nEmail bioperl-l@bioperl.org for support and feedback.\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::SequenceFamily;\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Cluster::FamilyI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Cluster::SequenceFamily->new(\n                             -family_id=>\"Family_1\",\n                             -description=>\"Family Description Here\",\n                             -annotation_score=>\"100\",\n                             -members=>\\@mem);\n Function: Constructor for SequenceFamily object\n Returns : Bio::Cluster::SequenceFamily object\n\nSee L<Bio::Cluster::SequenceFamily>.\n\n\nsub new {\n\tmy ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id,$description,$version,$annot_score,\n  $family_score,$members) = $self->_rearrange([qw(FAMILY_ID DESCRIPTION VERSION \n                                                   ANNOTATION_SCORE \n                                                   FAMILY_SCORE MEMBERS)],@args);\n  $self->{'_members'} = [];\n  $id && $self->family_id($id);\n  $description && $self->description($description);\n  $version && $self->version($version);\n  $annot_score && $self->annotation_score($annot_score);\n  $family_score && $self->family_score($family_score);\n  $members && $self->add_members($members);\n\n  return $self;\n\n}\n\n=head2 version\n\n Title   : version\n Usage   : $family->version(\"1.0\");\n Function: get/set for version\n Returns : a string version of the family generated. \n\n\nsub version{\n  my ($self,$value) = @_;\n  if($value){\n    $self->{'_version'} =$value;\n  }\n  return $self->{'_version'};\n}\n\n=head2 annotation_score\n\n Title   : annotation_score\n Usage   : $family->annotation_score(100);\n Function: get/set for annotation_score which\n           represent the confidence in which the \n           consensus description has been assigned\n           to the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>\n\n\nsub annotation_score{\n  my ($self,$score) = @_;\n  if($score){\n    $self->{'_annotation_score'} = $score;\n  }\n  return $self->{'_annotation_score'};\n}\n\n=head2 alignment\n\n Title   : alignment\n Usage   : $family->alignment($align);\n Function: get/set for an alignment object representing\n           the multiple alignment of the members of the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>\n\n\nsub alignment {\n\tmy ($self,$align) = @_;\n  if($align){\n    $self->{'_alignment'} = $align;\n  }\n    return $self->{'_alignment'};\n}\n\n=head2 tree\n\n Title   : tree\n Usage   : $family->tree($tree);\n Function: get/set for an tree object representing\n           the phylogenetic tree of the family. \n Returns : Bio::Tree\n\nSee L<Bio::Tree>\n\n\nsub tree {\n  my ($self,$tree) = @_;\n  if($tree) {\n    $self->{'_tree'} = $tree;\n  }\n  return $self->{'_tree'};\n}\n\n=head1 L<Bio::Cluster::FamilyI> methods\n\n\n=head2 family_score\n\n Title   : family_score\n Usage   : Bio::Cluster::FamilyI->family_score(95);\n Function: get/set for the score of algorithm used to generate\n           the family if present\n\n           This is aliased to cluster_score().\n\n Returns : the score\n Args    : the score\n\n\nsub family_score {\n    return shift->cluster_score(@_);\n}\n\n\n=head2 family_id\n\n Title   : family_id\n Usage   : $family->family_id(\"Family_1\"); \n Function: get/set for family id \n\n           This is aliased to display_id().\n\n Returns : a string specifying identifier of the family \n\n\nsub family_id{\n\treturn shift->display_id(@_);\n}\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n\tmy ($self,$id) = @_;\n\tif($id){\n\t\t$self->{'_cluster_id'} = $id;\n\t}\n\treturn $self->{'_cluster_id'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : $fam->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n\tmy ($self,$desc) = @_;\n\tif($desc){\n\t\t$self->{'_description'} = $desc;\n\t}\n\treturn $self->{'_description'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Valid criteria:\n           -common_name\n           -binomial\n           -ncbi_taxid\n           -organelle\n           -genus\n           $family->get_members(-common_name =>\"human\");\n           $family->get_members(-species     =>\"homo sapiens\");\n           $family->get_members(-ncbi_taxid  => 9606);\n           For now, multiple critieria are ORed.\n\n           Will return all members if no criteria are provided.\n\n Function: get members using methods from L<Bio::Species>\n           the phylogenetic tree of the family.\n Returns : an array of objects that are member of this family. \n\n\nsub get_members {\n\tmy $self = shift;\n\tmy @ret;\n\n\tif(@_) {\n\t\tmy %hash = @_;\n\t\tforeach my $mem ( @{$self->{'_members'}} ) {\n\t\t\tforeach my $key ( keys %hash){\n\t\t\t\tmy $method = $key;\n\t\t\t\t$method=~s/-//g;\n\t\t\t\tif($mem->can('species')){\n\t\t\t\t\tmy $species = $mem->species;\n\t\t\t\t\t$species->can($method) ||\n\t\t\t\t\t  $self->throw(\"$method is an invalid criteria\");\n\t\t\t\t\tif($species->$method() eq $hash{$key} ){\n\t\t\t\t\t\tpush @ret, $mem;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\treturn @ret;\n\t}\n\treturn @{$self->{'_members'}};\n}\n\n=head2 size\n\n Title   : size\n Usage   : $fam->size();\n Function: get/set for the size of the family, \n           calculated from the number of members\n Returns : the size of the family \n Args    : ","label":"size($self)"},"kind":12,"line":361,"children":[{"localvar":"my","containerName":"size","definition":"my","name":"$self","line":362,"kind":13},{"kind":13,"line":364,"name":"$self","containerName":"size"}]},{"range":{"end":{"line":385,"character":9999},"start":{"character":0,"line":379}},"name":"cluster_score","children":[{"line":380,"kind":13,"localvar":"my","containerName":"cluster_score","definition":"my","name":"$self"},{"name":"$score","containerName":"cluster_score","line":380,"kind":13},{"containerName":"cluster_score","name":"$score","kind":13,"line":381},{"name":"$self","containerName":"cluster_score","line":382,"kind":13},{"name":"$score","containerName":"cluster_score","line":382,"kind":13},{"line":384,"kind":13,"name":"$self","containerName":"cluster_score"}],"line":379,"kind":12,"signature":{"label":"cluster_score($self,$score)","parameters":[{"label":"$self"},{"label":"$score"}],"documentation":"1;\n# $Id: SequenceFamily.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# BioPerl module for Bio::Cluster::SequenceFamily\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::SequenceFamily - Sequence Family object\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::Cluster::SequenceFamily;\n  use File::Spec;\n\n  my $file =  File::Spec->catfile('t','data','swiss.dat');\n  my $seqio= Bio::SeqIO->new(-format => 'swiss',\n                            -file => $file);\n  my @mem;\n  while(my $seq = $seqio->next_seq){\n    push @mem, $seq;\n  }\n\n  #create the family\n  my $family = Bio::Cluster::SequenceFamily->new(\n          -family_id=>\"Family_1\",\n          -description=>\"Family Description Here\",\n          -annotation_score=>\"100\",\n          -members=>\\@mem);\n\n  #access the family\n\n  foreach my $mem ($family->get_members){\n    print $mem->display_id.\"\\t\".$mem->desc.\"\\n\";\n  }\n\n  #select members if members have a Bio::Species Object\n\n  my @mem = $family->get_members(-binomial=>\"Homo sapiens\");\n  @mem = $family->get_members(-ncbi_taxid => 9606);\n  @mem = $family->get_members(-common_name=>\"Human\");\n  @mem = $family->get_members(-species=>\"sapiens\");\n  @mem = $family->get_members(-genus=>\"Homo\");\n\n=head1 DESCRIPTION\n\nThis is a simple Family object that may hold any group of object. For more\nspecific families, one should derive from FamilyI.\n\n=head1 FEEDBACK\n\nEmail bioperl-l@bioperl.org for support and feedback.\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::SequenceFamily;\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Cluster::FamilyI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Cluster::SequenceFamily->new(\n                             -family_id=>\"Family_1\",\n                             -description=>\"Family Description Here\",\n                             -annotation_score=>\"100\",\n                             -members=>\\@mem);\n Function: Constructor for SequenceFamily object\n Returns : Bio::Cluster::SequenceFamily object\n\nSee L<Bio::Cluster::SequenceFamily>.\n\n\nsub new {\n\tmy ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id,$description,$version,$annot_score,\n  $family_score,$members) = $self->_rearrange([qw(FAMILY_ID DESCRIPTION VERSION \n                                                   ANNOTATION_SCORE \n                                                   FAMILY_SCORE MEMBERS)],@args);\n  $self->{'_members'} = [];\n  $id && $self->family_id($id);\n  $description && $self->description($description);\n  $version && $self->version($version);\n  $annot_score && $self->annotation_score($annot_score);\n  $family_score && $self->family_score($family_score);\n  $members && $self->add_members($members);\n\n  return $self;\n\n}\n\n=head2 version\n\n Title   : version\n Usage   : $family->version(\"1.0\");\n Function: get/set for version\n Returns : a string version of the family generated. \n\n\nsub version{\n  my ($self,$value) = @_;\n  if($value){\n    $self->{'_version'} =$value;\n  }\n  return $self->{'_version'};\n}\n\n=head2 annotation_score\n\n Title   : annotation_score\n Usage   : $family->annotation_score(100);\n Function: get/set for annotation_score which\n           represent the confidence in which the \n           consensus description has been assigned\n           to the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>\n\n\nsub annotation_score{\n  my ($self,$score) = @_;\n  if($score){\n    $self->{'_annotation_score'} = $score;\n  }\n  return $self->{'_annotation_score'};\n}\n\n=head2 alignment\n\n Title   : alignment\n Usage   : $family->alignment($align);\n Function: get/set for an alignment object representing\n           the multiple alignment of the members of the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>\n\n\nsub alignment {\n\tmy ($self,$align) = @_;\n  if($align){\n    $self->{'_alignment'} = $align;\n  }\n    return $self->{'_alignment'};\n}\n\n=head2 tree\n\n Title   : tree\n Usage   : $family->tree($tree);\n Function: get/set for an tree object representing\n           the phylogenetic tree of the family. \n Returns : Bio::Tree\n\nSee L<Bio::Tree>\n\n\nsub tree {\n  my ($self,$tree) = @_;\n  if($tree) {\n    $self->{'_tree'} = $tree;\n  }\n  return $self->{'_tree'};\n}\n\n=head1 L<Bio::Cluster::FamilyI> methods\n\n\n=head2 family_score\n\n Title   : family_score\n Usage   : Bio::Cluster::FamilyI->family_score(95);\n Function: get/set for the score of algorithm used to generate\n           the family if present\n\n           This is aliased to cluster_score().\n\n Returns : the score\n Args    : the score\n\n\nsub family_score {\n    return shift->cluster_score(@_);\n}\n\n\n=head2 family_id\n\n Title   : family_id\n Usage   : $family->family_id(\"Family_1\"); \n Function: get/set for family id \n\n           This is aliased to display_id().\n\n Returns : a string specifying identifier of the family \n\n\nsub family_id{\n\treturn shift->display_id(@_);\n}\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n\tmy ($self,$id) = @_;\n\tif($id){\n\t\t$self->{'_cluster_id'} = $id;\n\t}\n\treturn $self->{'_cluster_id'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : $fam->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n\tmy ($self,$desc) = @_;\n\tif($desc){\n\t\t$self->{'_description'} = $desc;\n\t}\n\treturn $self->{'_description'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Valid criteria:\n           -common_name\n           -binomial\n           -ncbi_taxid\n           -organelle\n           -genus\n           $family->get_members(-common_name =>\"human\");\n           $family->get_members(-species     =>\"homo sapiens\");\n           $family->get_members(-ncbi_taxid  => 9606);\n           For now, multiple critieria are ORed.\n\n           Will return all members if no criteria are provided.\n\n Function: get members using methods from L<Bio::Species>\n           the phylogenetic tree of the family.\n Returns : an array of objects that are member of this family. \n\n\nsub get_members {\n\tmy $self = shift;\n\tmy @ret;\n\n\tif(@_) {\n\t\tmy %hash = @_;\n\t\tforeach my $mem ( @{$self->{'_members'}} ) {\n\t\t\tforeach my $key ( keys %hash){\n\t\t\t\tmy $method = $key;\n\t\t\t\t$method=~s/-//g;\n\t\t\t\tif($mem->can('species')){\n\t\t\t\t\tmy $species = $mem->species;\n\t\t\t\t\t$species->can($method) ||\n\t\t\t\t\t  $self->throw(\"$method is an invalid criteria\");\n\t\t\t\t\tif($species->$method() eq $hash{$key} ){\n\t\t\t\t\t\tpush @ret, $mem;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\treturn @ret;\n\t}\n\treturn @{$self->{'_members'}};\n}\n\n=head2 size\n\n Title   : size\n Usage   : $fam->size();\n Function: get/set for the size of the family, \n           calculated from the number of members\n Returns : the size of the family \n Args    : \n\n\nsub size {\n  my ($self) = @_;\n\n  return scalar(@{$self->{'_members'}});\n\n}\n\n=head2 cluster_score\n\n Title   : cluster_score\n Usage   : $fam->cluster_score(100);\n Function: get/set for cluster_score which\n           represent the score in which the clustering\n           algorithm assigns to this cluster.\n Returns : a number"},"detail":"($self,$score)","definition":"sub","containerName":"main::"},{"definition":"sub","containerName":"main::","signature":{"label":"add_members($self,@mems)","parameters":[{"label":"$self"},{"label":"@mems"}],"documentation":"1;\n# $Id: SequenceFamily.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# BioPerl module for Bio::Cluster::SequenceFamily\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::SequenceFamily - Sequence Family object\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::Cluster::SequenceFamily;\n  use File::Spec;\n\n  my $file =  File::Spec->catfile('t','data','swiss.dat');\n  my $seqio= Bio::SeqIO->new(-format => 'swiss',\n                            -file => $file);\n  my @mem;\n  while(my $seq = $seqio->next_seq){\n    push @mem, $seq;\n  }\n\n  #create the family\n  my $family = Bio::Cluster::SequenceFamily->new(\n          -family_id=>\"Family_1\",\n          -description=>\"Family Description Here\",\n          -annotation_score=>\"100\",\n          -members=>\\@mem);\n\n  #access the family\n\n  foreach my $mem ($family->get_members){\n    print $mem->display_id.\"\\t\".$mem->desc.\"\\n\";\n  }\n\n  #select members if members have a Bio::Species Object\n\n  my @mem = $family->get_members(-binomial=>\"Homo sapiens\");\n  @mem = $family->get_members(-ncbi_taxid => 9606);\n  @mem = $family->get_members(-common_name=>\"Human\");\n  @mem = $family->get_members(-species=>\"sapiens\");\n  @mem = $family->get_members(-genus=>\"Homo\");\n\n=head1 DESCRIPTION\n\nThis is a simple Family object that may hold any group of object. For more\nspecific families, one should derive from FamilyI.\n\n=head1 FEEDBACK\n\nEmail bioperl-l@bioperl.org for support and feedback.\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::SequenceFamily;\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Cluster::FamilyI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Cluster::SequenceFamily->new(\n                             -family_id=>\"Family_1\",\n                             -description=>\"Family Description Here\",\n                             -annotation_score=>\"100\",\n                             -members=>\\@mem);\n Function: Constructor for SequenceFamily object\n Returns : Bio::Cluster::SequenceFamily object\n\nSee L<Bio::Cluster::SequenceFamily>.\n\n\nsub new {\n\tmy ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id,$description,$version,$annot_score,\n  $family_score,$members) = $self->_rearrange([qw(FAMILY_ID DESCRIPTION VERSION \n                                                   ANNOTATION_SCORE \n                                                   FAMILY_SCORE MEMBERS)],@args);\n  $self->{'_members'} = [];\n  $id && $self->family_id($id);\n  $description && $self->description($description);\n  $version && $self->version($version);\n  $annot_score && $self->annotation_score($annot_score);\n  $family_score && $self->family_score($family_score);\n  $members && $self->add_members($members);\n\n  return $self;\n\n}\n\n=head2 version\n\n Title   : version\n Usage   : $family->version(\"1.0\");\n Function: get/set for version\n Returns : a string version of the family generated. \n\n\nsub version{\n  my ($self,$value) = @_;\n  if($value){\n    $self->{'_version'} =$value;\n  }\n  return $self->{'_version'};\n}\n\n=head2 annotation_score\n\n Title   : annotation_score\n Usage   : $family->annotation_score(100);\n Function: get/set for annotation_score which\n           represent the confidence in which the \n           consensus description has been assigned\n           to the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>\n\n\nsub annotation_score{\n  my ($self,$score) = @_;\n  if($score){\n    $self->{'_annotation_score'} = $score;\n  }\n  return $self->{'_annotation_score'};\n}\n\n=head2 alignment\n\n Title   : alignment\n Usage   : $family->alignment($align);\n Function: get/set for an alignment object representing\n           the multiple alignment of the members of the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>\n\n\nsub alignment {\n\tmy ($self,$align) = @_;\n  if($align){\n    $self->{'_alignment'} = $align;\n  }\n    return $self->{'_alignment'};\n}\n\n=head2 tree\n\n Title   : tree\n Usage   : $family->tree($tree);\n Function: get/set for an tree object representing\n           the phylogenetic tree of the family. \n Returns : Bio::Tree\n\nSee L<Bio::Tree>\n\n\nsub tree {\n  my ($self,$tree) = @_;\n  if($tree) {\n    $self->{'_tree'} = $tree;\n  }\n  return $self->{'_tree'};\n}\n\n=head1 L<Bio::Cluster::FamilyI> methods\n\n\n=head2 family_score\n\n Title   : family_score\n Usage   : Bio::Cluster::FamilyI->family_score(95);\n Function: get/set for the score of algorithm used to generate\n           the family if present\n\n           This is aliased to cluster_score().\n\n Returns : the score\n Args    : the score\n\n\nsub family_score {\n    return shift->cluster_score(@_);\n}\n\n\n=head2 family_id\n\n Title   : family_id\n Usage   : $family->family_id(\"Family_1\"); \n Function: get/set for family id \n\n           This is aliased to display_id().\n\n Returns : a string specifying identifier of the family \n\n\nsub family_id{\n\treturn shift->display_id(@_);\n}\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n\tmy ($self,$id) = @_;\n\tif($id){\n\t\t$self->{'_cluster_id'} = $id;\n\t}\n\treturn $self->{'_cluster_id'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : $fam->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n\tmy ($self,$desc) = @_;\n\tif($desc){\n\t\t$self->{'_description'} = $desc;\n\t}\n\treturn $self->{'_description'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Valid criteria:\n           -common_name\n           -binomial\n           -ncbi_taxid\n           -organelle\n           -genus\n           $family->get_members(-common_name =>\"human\");\n           $family->get_members(-species     =>\"homo sapiens\");\n           $family->get_members(-ncbi_taxid  => 9606);\n           For now, multiple critieria are ORed.\n\n           Will return all members if no criteria are provided.\n\n Function: get members using methods from L<Bio::Species>\n           the phylogenetic tree of the family.\n Returns : an array of objects that are member of this family. \n\n\nsub get_members {\n\tmy $self = shift;\n\tmy @ret;\n\n\tif(@_) {\n\t\tmy %hash = @_;\n\t\tforeach my $mem ( @{$self->{'_members'}} ) {\n\t\t\tforeach my $key ( keys %hash){\n\t\t\t\tmy $method = $key;\n\t\t\t\t$method=~s/-//g;\n\t\t\t\tif($mem->can('species')){\n\t\t\t\t\tmy $species = $mem->species;\n\t\t\t\t\t$species->can($method) ||\n\t\t\t\t\t  $self->throw(\"$method is an invalid criteria\");\n\t\t\t\t\tif($species->$method() eq $hash{$key} ){\n\t\t\t\t\t\tpush @ret, $mem;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\treturn @ret;\n\t}\n\treturn @{$self->{'_members'}};\n}\n\n=head2 size\n\n Title   : size\n Usage   : $fam->size();\n Function: get/set for the size of the family, \n           calculated from the number of members\n Returns : the size of the family \n Args    : \n\n\nsub size {\n  my ($self) = @_;\n\n  return scalar(@{$self->{'_members'}});\n\n}\n\n=head2 cluster_score\n\n Title   : cluster_score\n Usage   : $fam->cluster_score(100);\n Function: get/set for cluster_score which\n           represent the score in which the clustering\n           algorithm assigns to this cluster.\n Returns : a number\n\n\nsub cluster_score{\n  my ($self,$score) = @_;\n  if($score){\n    $self->{'_cluster_score'} = $score;\n  }\n  return $self->{'_cluster_score'};\n}\n\n\n=head1 Implementation specific methods\n\n  These are mostly for adding/removing/changing.\n\n\n=head2 add_members\n\n Title   : add_members\n Usage   : $fam->add_member([$seq1,$seq1]);\n Function: add members to a family\n Returns : \n Args    : the member(s) to add, as an array or arrayref"},"detail":"($self,@mems)","kind":12,"children":[{"localvar":"my","containerName":"add_members","definition":"my","name":"$self","line":405,"kind":13},{"name":"@mems","containerName":"add_members","kind":13,"line":405},{"kind":13,"line":407,"containerName":"add_members","name":"@mems"},{"line":408,"kind":13,"localvar":"my","containerName":"add_members","name":"$mem","definition":"my"},{"containerName":"add_members","name":"@mems","line":408,"kind":13},{"line":409,"kind":13,"name":"$mem","containerName":"add_members"},{"kind":13,"line":410,"name":"$self","containerName":"add_members"},{"kind":13,"line":410,"containerName":"add_members","name":"$mem"}],"line":404,"name":"add_members","range":{"start":{"line":404,"character":0},"end":{"line":411,"character":9999}}},{"kind":13,"line":412,"containerName":null,"name":"%self"},{"containerName":null,"name":"$mem","kind":13,"line":412},{"name":"%self","containerName":null,"line":414,"kind":13},{"containerName":null,"name":"@mems","kind":13,"line":414},{"range":{"end":{"character":9999,"line":434},"start":{"character":0,"line":429}},"name":"remove_members","children":[{"line":430,"kind":13,"localvar":"my","containerName":"remove_members","name":"$self","definition":"my"},{"localvar":"my","name":"$mems","definition":"my","containerName":"remove_members","line":431,"kind":13},{"line":431,"kind":13,"containerName":"remove_members","name":"$self"},{"kind":13,"line":432,"containerName":"remove_members","name":"$self"},{"containerName":"remove_members","name":"$mems","kind":13,"line":433}],"line":429,"kind":12,"signature":{"label":"remove_members($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: SequenceFamily.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# BioPerl module for Bio::Cluster::SequenceFamily\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::SequenceFamily - Sequence Family object\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::Cluster::SequenceFamily;\n  use File::Spec;\n\n  my $file =  File::Spec->catfile('t','data','swiss.dat');\n  my $seqio= Bio::SeqIO->new(-format => 'swiss',\n                            -file => $file);\n  my @mem;\n  while(my $seq = $seqio->next_seq){\n    push @mem, $seq;\n  }\n\n  #create the family\n  my $family = Bio::Cluster::SequenceFamily->new(\n          -family_id=>\"Family_1\",\n          -description=>\"Family Description Here\",\n          -annotation_score=>\"100\",\n          -members=>\\@mem);\n\n  #access the family\n\n  foreach my $mem ($family->get_members){\n    print $mem->display_id.\"\\t\".$mem->desc.\"\\n\";\n  }\n\n  #select members if members have a Bio::Species Object\n\n  my @mem = $family->get_members(-binomial=>\"Homo sapiens\");\n  @mem = $family->get_members(-ncbi_taxid => 9606);\n  @mem = $family->get_members(-common_name=>\"Human\");\n  @mem = $family->get_members(-species=>\"sapiens\");\n  @mem = $family->get_members(-genus=>\"Homo\");\n\n=head1 DESCRIPTION\n\nThis is a simple Family object that may hold any group of object. For more\nspecific families, one should derive from FamilyI.\n\n=head1 FEEDBACK\n\nEmail bioperl-l@bioperl.org for support and feedback.\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::SequenceFamily;\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Cluster::FamilyI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Cluster::SequenceFamily->new(\n                             -family_id=>\"Family_1\",\n                             -description=>\"Family Description Here\",\n                             -annotation_score=>\"100\",\n                             -members=>\\@mem);\n Function: Constructor for SequenceFamily object\n Returns : Bio::Cluster::SequenceFamily object\n\nSee L<Bio::Cluster::SequenceFamily>.\n\n\nsub new {\n\tmy ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id,$description,$version,$annot_score,\n  $family_score,$members) = $self->_rearrange([qw(FAMILY_ID DESCRIPTION VERSION \n                                                   ANNOTATION_SCORE \n                                                   FAMILY_SCORE MEMBERS)],@args);\n  $self->{'_members'} = [];\n  $id && $self->family_id($id);\n  $description && $self->description($description);\n  $version && $self->version($version);\n  $annot_score && $self->annotation_score($annot_score);\n  $family_score && $self->family_score($family_score);\n  $members && $self->add_members($members);\n\n  return $self;\n\n}\n\n=head2 version\n\n Title   : version\n Usage   : $family->version(\"1.0\");\n Function: get/set for version\n Returns : a string version of the family generated. \n\n\nsub version{\n  my ($self,$value) = @_;\n  if($value){\n    $self->{'_version'} =$value;\n  }\n  return $self->{'_version'};\n}\n\n=head2 annotation_score\n\n Title   : annotation_score\n Usage   : $family->annotation_score(100);\n Function: get/set for annotation_score which\n           represent the confidence in which the \n           consensus description has been assigned\n           to the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>\n\n\nsub annotation_score{\n  my ($self,$score) = @_;\n  if($score){\n    $self->{'_annotation_score'} = $score;\n  }\n  return $self->{'_annotation_score'};\n}\n\n=head2 alignment\n\n Title   : alignment\n Usage   : $family->alignment($align);\n Function: get/set for an alignment object representing\n           the multiple alignment of the members of the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>\n\n\nsub alignment {\n\tmy ($self,$align) = @_;\n  if($align){\n    $self->{'_alignment'} = $align;\n  }\n    return $self->{'_alignment'};\n}\n\n=head2 tree\n\n Title   : tree\n Usage   : $family->tree($tree);\n Function: get/set for an tree object representing\n           the phylogenetic tree of the family. \n Returns : Bio::Tree\n\nSee L<Bio::Tree>\n\n\nsub tree {\n  my ($self,$tree) = @_;\n  if($tree) {\n    $self->{'_tree'} = $tree;\n  }\n  return $self->{'_tree'};\n}\n\n=head1 L<Bio::Cluster::FamilyI> methods\n\n\n=head2 family_score\n\n Title   : family_score\n Usage   : Bio::Cluster::FamilyI->family_score(95);\n Function: get/set for the score of algorithm used to generate\n           the family if present\n\n           This is aliased to cluster_score().\n\n Returns : the score\n Args    : the score\n\n\nsub family_score {\n    return shift->cluster_score(@_);\n}\n\n\n=head2 family_id\n\n Title   : family_id\n Usage   : $family->family_id(\"Family_1\"); \n Function: get/set for family id \n\n           This is aliased to display_id().\n\n Returns : a string specifying identifier of the family \n\n\nsub family_id{\n\treturn shift->display_id(@_);\n}\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n\tmy ($self,$id) = @_;\n\tif($id){\n\t\t$self->{'_cluster_id'} = $id;\n\t}\n\treturn $self->{'_cluster_id'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : $fam->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n\tmy ($self,$desc) = @_;\n\tif($desc){\n\t\t$self->{'_description'} = $desc;\n\t}\n\treturn $self->{'_description'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Valid criteria:\n           -common_name\n           -binomial\n           -ncbi_taxid\n           -organelle\n           -genus\n           $family->get_members(-common_name =>\"human\");\n           $family->get_members(-species     =>\"homo sapiens\");\n           $family->get_members(-ncbi_taxid  => 9606);\n           For now, multiple critieria are ORed.\n\n           Will return all members if no criteria are provided.\n\n Function: get members using methods from L<Bio::Species>\n           the phylogenetic tree of the family.\n Returns : an array of objects that are member of this family. \n\n\nsub get_members {\n\tmy $self = shift;\n\tmy @ret;\n\n\tif(@_) {\n\t\tmy %hash = @_;\n\t\tforeach my $mem ( @{$self->{'_members'}} ) {\n\t\t\tforeach my $key ( keys %hash){\n\t\t\t\tmy $method = $key;\n\t\t\t\t$method=~s/-//g;\n\t\t\t\tif($mem->can('species')){\n\t\t\t\t\tmy $species = $mem->species;\n\t\t\t\t\t$species->can($method) ||\n\t\t\t\t\t  $self->throw(\"$method is an invalid criteria\");\n\t\t\t\t\tif($species->$method() eq $hash{$key} ){\n\t\t\t\t\t\tpush @ret, $mem;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\treturn @ret;\n\t}\n\treturn @{$self->{'_members'}};\n}\n\n=head2 size\n\n Title   : size\n Usage   : $fam->size();\n Function: get/set for the size of the family, \n           calculated from the number of members\n Returns : the size of the family \n Args    : \n\n\nsub size {\n  my ($self) = @_;\n\n  return scalar(@{$self->{'_members'}});\n\n}\n\n=head2 cluster_score\n\n Title   : cluster_score\n Usage   : $fam->cluster_score(100);\n Function: get/set for cluster_score which\n           represent the score in which the clustering\n           algorithm assigns to this cluster.\n Returns : a number\n\n\nsub cluster_score{\n  my ($self,$score) = @_;\n  if($score){\n    $self->{'_cluster_score'} = $score;\n  }\n  return $self->{'_cluster_score'};\n}\n\n\n=head1 Implementation specific methods\n\n  These are mostly for adding/removing/changing.\n\n\n=head2 add_members\n\n Title   : add_members\n Usage   : $fam->add_member([$seq1,$seq1]);\n Function: add members to a family\n Returns : \n Args    : the member(s) to add, as an array or arrayref\n\n\nsub add_members{\n    my ($self,@mems) = @_;\n\n    if (@mems) {\n        my $mem = shift(@mems);\n        if(ref($mem) eq \"ARRAY\"){\n            push @{$self->{'_members'}},@{$mem};\n        } else {\n            push @{$self->{'_members'}},$mem;\n        }\n        push @{$self->{'_members'}}, @mems;\n    }\n    return 1;\n}\n\n=head2 remove_members\n\n Title   : remove_members\n Usage   : $fam->remove_members();\n Function: remove all members from a family \n Returns : the previous array of members\n Args    : none"},"detail":"($self)","definition":"sub","containerName":"main::"},{"containerName":"main::","name":"members","definition":"sub","range":{"end":{"character":9999,"line":464},"start":{"line":451,"character":0}},"kind":12,"line":451,"children":[{"kind":13,"line":452,"definition":"my","name":"$self","containerName":"members","localvar":"my"},{"name":"$self","containerName":"members","line":455,"kind":13},{"name":"warn","containerName":"members","line":455,"kind":12},{"line":455,"kind":13,"name":"$self","containerName":"members"},{"line":457,"kind":13,"name":"$self","containerName":"members"},{"name":"add_members","containerName":"members","kind":12,"line":457},{"kind":13,"line":460,"containerName":"members","name":"$self"},{"line":460,"kind":12,"name":"warn","containerName":"members"},{"kind":13,"line":460,"name":"$self","containerName":"members"},{"kind":13,"line":462,"name":"$self","containerName":"members"},{"name":"get_members","containerName":"members","line":462,"kind":12}]}],"version":5}