{"version":5,"vars":[{"line":202,"kind":2,"containerName":"","name":"base"},{"signature":{"documentation":"__END__\n# $Id: Biblio.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Biblio\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Martin Senger <senger@ebi.ac.uk>\n# For copyright and disclaimer see below.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Biblio - A Bibliographic Query Service module\n\n=head1 SYNOPSIS\n\n  use Bio::Biblio;\n  my $biblio = Bio::Biblio->new();\n\n  print $biblio->find ('perl')->get_count . \"\\n\";\n\n  my $collection = $biblio->find ('brazma', 'authors');\n  while ( $collection->has_next ) {\n      print $collection->get_next;\n  }\n\n  # The new() method can accept parameters, for example:\n\n  $biblio = Bio::Biblio->new\n    (-access          => 'soap',\n     -location        => 'http://www.ebi.ac.uk/openbqs/services/MedlineSRS',\n     -destroy_on_exit => '0');\n\n  # See below for some one-liners\n\n=head1 DESCRIPTION\n\nThis is a class whose instances can access bibliographic\nrepositories. It allows to query a bibliographic database (such as\nMEDLINE) and then to retrieve resulting citations from it. The\ncitations are returned in an XML format which is native to the\nrepository but there are also supporting modules for converting them\ninto Perl objects.\n\nThe detailed descriptions of all query and retrieval methods are in\nL<Bio::DB::BiblioI> (an interface). All those methods should be\ncalled on instances of this (Bio::Biblio) module.\n\nThe module complies (with some simplifications) with the specification\ndescribed in the B<OpenBQS> project. Its home page is at\nL<http://www.ebi.ac.uk/~senger/openbqs>.\n\nThe module also gives an access to a set of controlled vocabularies\nand their values. It allows to introspect bibliographic repositories\nand to find what citation resource types (such as journal and book\narticles, patents or technical reports) are provided, and what\nattributes they have, eventually what attribute values are allowed.\n\nHere are some one-liners:\n\n  perl -MBio::Biblio -e 'print new Bio::Biblio->get_by_id (\"12368254\")'\n  perl -MBio::Biblio \\\n       -e 'print join (\"\\n\", @{ Bio::Biblio->new->find (\"brazma\")->get_all_ids })'\n  perl -MBio::Biblio \\\n       -e 'print Bio::Biblio->new->find (\"Java\")->find (\"perl\")->get_count'\n\n\n=head1 OVERVIEW OF CLASSES AND PACKAGES\n\n\n* L<Bio::Biblio>\n\nThis is the main class to be used by the end users. It\nloads a real implementation for a particular access protocol according\nto the argument I<-access>. At the time of writing this documentation\nthere is only one available access module implementing all query and\nretrieval methods:\n\n   -access => soap\n\nThis module implements all methods defined in the interface\nI<Bio::DB::BiblioI> (see L<Bio::DB::BiblioI>) by delegating\ncalls to a loaded low-level module (e.g. see\nL<Bio::DB::Biblio::soap>).\n\nNote that there are other modules which do not use the SOAP protocol \nand do not implement all query methods - nevertheless they have retrieval \nmethods and can be used in the same way:\n\n   -access => biofetch\n\nLacking documentation:\n\n   -access => eutils\n\n* Bio::DB::BiblioI\n\nThis is an interface defining all methods that can be called on\nI<Bio::Biblio> instances.\n\n* Bio::DB::Biblio::soap\n\nThis is a real implementation of all methods defined in\nBio::DB::BiblioI using SOAP protocol (calling a WebService\nbased on SOAP). This class should not be instantiated directly (use\nI<Bio::Biblio> instead). See L<Bio::DB::BiblioI> for details.\n\n* Bio::Biblio::IO\n\nThis module instantiates and uses a converter of the citations read by\nany of the access methods mentioned above. See L<Bio::Biblio::IO> for\ndetails.\n\n* Bio::Biblio::IO::medlinexml and Bio::Biblio::IO::medline2ref\n\nA converter of MEDLINE citations in XML into Perl objects.\n\n* Bio::Biblio::IO::pubmedxml and Bio::Biblio::IO::pubmed2ref\n\nA converter of PUBMED citations in XML into Perl objects.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nMartin Senger (martin.senger@gmail.com)\n\n=head1 COPYRIGHT\n\nCopyright (c) 2002 European Bioinformatics Institute. All Rights Reserved.\n\nThis module is free software; you can redistribute it and/or modify\nit under the same terms as Perl itself.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 SEE ALSO\n\n\n* *\n\nOpenBQS home page: http://www.ebi.ac.uk/~senger/openbqs/\n\n* *\n\nComments to the Perl client: http://www.ebi.ac.uk/~senger/openbqs/Client_perl.html\n\n\n=head1 APPENDIX\n\nThe main documentation details are to be found in\nL<Bio::DB::BiblioI>.\n\nHere is the rest of the object methods.  Internal methods are preceded\nwith an underscore _.\n\n\n\n# Let the code begin...\n\n\npackage Bio::Biblio;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::DB::BiblioI);\n\n# -----------------------------------------------------------------------------\n\n=head2 new\n\n Usage   : my $obj = Bio::Biblio->new(@args);\n Returns : Bio::Biblio object on success, or undef on failure\n Args    : This module recognizes and uses:\n\n             -access => 'soap'\n               It indicates what lower-level module to load.\n               Default is 'soap'.\n\n             -location => 'http://...'\n                It says where to find a bibliographic query service.\n                The format and contents of this argument is dependent\n                on the '-access' argument.\n\n                For 'soap' access it is a URL of a WebService.\n                Default is http://www.ebi.ac.uk/openbqs/services/MedlineSRS\n\n           Other arguments can be given here but they are\n           recognized by the lower-level module\n           (e.g. see Bio::DB::Biblio::soap).\n\nIt builds, populates and returns a new I<Bio::Biblio> object. This is\nhow it is seen from the outside. But in fact, it builds, populates and\nreturns a more specific lower-level object, for example\nI<Bio::DB::Biblio::soap> object - which one it is depends on the\nparameter I<-access>.\n\nThe real initialization is done in the method I<_initialize> of the\nlower-level object.\n\nThis method can also be used for I<cloning> an existing object and\nchanging or adding new attributes to it in the same time. This is,\nhowever, not particulary useful for the casual users of this module,\nbecause the query methods (see L<Bio::DB::BiblioI>) themselves\nalready return cloned objects with more refined query\ncollections. Anyway this is how the cloning can be done:\n\n  use Bio::Biblio;\n  my $biblio = Bio::Biblio->new();\n\n  # this will create a new object which will NOT send a 'destroy'\n  # message to the remote server when its life ends\n  my $clone = $biblio->new (-destroy-on-exit => '0'); ","parameters":[{"label":"$caller"},{"label":"@args"}],"label":"new($caller,@args)"},"detail":"($caller,@args)","definition":"sub","containerName":"main::","children":[{"line":254,"kind":13,"localvar":"my","containerName":"new","name":"$caller","definition":"my"},{"line":254,"kind":13,"containerName":"new","name":"@args"},{"line":255,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$class"},{"name":"$caller","containerName":"new","kind":13,"line":255},{"containerName":"new","name":"$caller","line":255,"kind":13},{"containerName":"new","name":"$class","kind":13,"line":261},{"containerName":"new","name":"$self","definition":"my","localvar":"my","kind":13,"line":262},{"kind":13,"line":262,"name":"$class","containerName":"new"},{"kind":13,"line":262,"containerName":"new","name":"@args"},{"kind":13,"line":267,"name":"$caller","containerName":"new"},{"line":268,"kind":13,"containerName":"new","name":"$self"},{"line":268,"kind":13,"name":"$caller","containerName":"new"}],"line":253,"kind":12,"range":{"end":{"character":9999,"line":269},"start":{"line":253,"character":0}},"name":"new"},{"line":262,"kind":12,"name":"SUPER","containerName":"new"},{"containerName":null,"name":"$self","line":274,"kind":13},{"containerName":"main::","name":"_initialize","line":274,"kind":12},{"kind":13,"line":274,"name":"@args","containerName":null},{"containerName":null,"name":"%self","kind":13,"line":275},{"line":283,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"%param"},{"line":283,"kind":13,"containerName":null,"name":"@args"},{"containerName":null,"name":"@param","kind":13,"line":284},{"containerName":null,"name":"%param","kind":13,"line":284},{"name":"%param","containerName":null,"kind":13,"line":284},{"containerName":null,"definition":"my","name":"$access","localvar":"my","kind":13,"line":285},{"line":286,"kind":13,"name":"%param","containerName":null},{"line":287,"kind":13,"name":"$class","containerName":null},{"line":287,"kind":12,"name":"_guess_access","containerName":"main::"},{"containerName":null,"name":"%param","line":287,"kind":13},{"name":"$access","containerName":null,"kind":13,"line":289},{"kind":12,"line":292,"name":"_load_access_module"},{"containerName":null,"name":"$access","kind":13,"line":292},{"line":296,"kind":12,"name":"new","containerName":"main::"},{"kind":13,"line":296,"containerName":null,"name":"@args"},{"definition":"sub","containerName":"main::","signature":{"label":"_load_access_module($access)","documentation":"__END__\n# $Id: Biblio.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Biblio\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Martin Senger <senger@ebi.ac.uk>\n# For copyright and disclaimer see below.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Biblio - A Bibliographic Query Service module\n\n=head1 SYNOPSIS\n\n  use Bio::Biblio;\n  my $biblio = Bio::Biblio->new();\n\n  print $biblio->find ('perl')->get_count . \"\\n\";\n\n  my $collection = $biblio->find ('brazma', 'authors');\n  while ( $collection->has_next ) {\n      print $collection->get_next;\n  }\n\n  # The new() method can accept parameters, for example:\n\n  $biblio = Bio::Biblio->new\n    (-access          => 'soap',\n     -location        => 'http://www.ebi.ac.uk/openbqs/services/MedlineSRS',\n     -destroy_on_exit => '0');\n\n  # See below for some one-liners\n\n=head1 DESCRIPTION\n\nThis is a class whose instances can access bibliographic\nrepositories. It allows to query a bibliographic database (such as\nMEDLINE) and then to retrieve resulting citations from it. The\ncitations are returned in an XML format which is native to the\nrepository but there are also supporting modules for converting them\ninto Perl objects.\n\nThe detailed descriptions of all query and retrieval methods are in\nL<Bio::DB::BiblioI> (an interface). All those methods should be\ncalled on instances of this (Bio::Biblio) module.\n\nThe module complies (with some simplifications) with the specification\ndescribed in the B<OpenBQS> project. Its home page is at\nL<http://www.ebi.ac.uk/~senger/openbqs>.\n\nThe module also gives an access to a set of controlled vocabularies\nand their values. It allows to introspect bibliographic repositories\nand to find what citation resource types (such as journal and book\narticles, patents or technical reports) are provided, and what\nattributes they have, eventually what attribute values are allowed.\n\nHere are some one-liners:\n\n  perl -MBio::Biblio -e 'print new Bio::Biblio->get_by_id (\"12368254\")'\n  perl -MBio::Biblio \\\n       -e 'print join (\"\\n\", @{ Bio::Biblio->new->find (\"brazma\")->get_all_ids })'\n  perl -MBio::Biblio \\\n       -e 'print Bio::Biblio->new->find (\"Java\")->find (\"perl\")->get_count'\n\n\n=head1 OVERVIEW OF CLASSES AND PACKAGES\n\n\n* L<Bio::Biblio>\n\nThis is the main class to be used by the end users. It\nloads a real implementation for a particular access protocol according\nto the argument I<-access>. At the time of writing this documentation\nthere is only one available access module implementing all query and\nretrieval methods:\n\n   -access => soap\n\nThis module implements all methods defined in the interface\nI<Bio::DB::BiblioI> (see L<Bio::DB::BiblioI>) by delegating\ncalls to a loaded low-level module (e.g. see\nL<Bio::DB::Biblio::soap>).\n\nNote that there are other modules which do not use the SOAP protocol \nand do not implement all query methods - nevertheless they have retrieval \nmethods and can be used in the same way:\n\n   -access => biofetch\n\nLacking documentation:\n\n   -access => eutils\n\n* Bio::DB::BiblioI\n\nThis is an interface defining all methods that can be called on\nI<Bio::Biblio> instances.\n\n* Bio::DB::Biblio::soap\n\nThis is a real implementation of all methods defined in\nBio::DB::BiblioI using SOAP protocol (calling a WebService\nbased on SOAP). This class should not be instantiated directly (use\nI<Bio::Biblio> instead). See L<Bio::DB::BiblioI> for details.\n\n* Bio::Biblio::IO\n\nThis module instantiates and uses a converter of the citations read by\nany of the access methods mentioned above. See L<Bio::Biblio::IO> for\ndetails.\n\n* Bio::Biblio::IO::medlinexml and Bio::Biblio::IO::medline2ref\n\nA converter of MEDLINE citations in XML into Perl objects.\n\n* Bio::Biblio::IO::pubmedxml and Bio::Biblio::IO::pubmed2ref\n\nA converter of PUBMED citations in XML into Perl objects.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nMartin Senger (martin.senger@gmail.com)\n\n=head1 COPYRIGHT\n\nCopyright (c) 2002 European Bioinformatics Institute. All Rights Reserved.\n\nThis module is free software; you can redistribute it and/or modify\nit under the same terms as Perl itself.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 SEE ALSO\n\n\n* *\n\nOpenBQS home page: http://www.ebi.ac.uk/~senger/openbqs/\n\n* *\n\nComments to the Perl client: http://www.ebi.ac.uk/~senger/openbqs/Client_perl.html\n\n\n=head1 APPENDIX\n\nThe main documentation details are to be found in\nL<Bio::DB::BiblioI>.\n\nHere is the rest of the object methods.  Internal methods are preceded\nwith an underscore _.\n\n\n\n# Let the code begin...\n\n\npackage Bio::Biblio;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::DB::BiblioI);\n\n# -----------------------------------------------------------------------------\n\n=head2 new\n\n Usage   : my $obj = Bio::Biblio->new(@args);\n Returns : Bio::Biblio object on success, or undef on failure\n Args    : This module recognizes and uses:\n\n             -access => 'soap'\n               It indicates what lower-level module to load.\n               Default is 'soap'.\n\n             -location => 'http://...'\n                It says where to find a bibliographic query service.\n                The format and contents of this argument is dependent\n                on the '-access' argument.\n\n                For 'soap' access it is a URL of a WebService.\n                Default is http://www.ebi.ac.uk/openbqs/services/MedlineSRS\n\n           Other arguments can be given here but they are\n           recognized by the lower-level module\n           (e.g. see Bio::DB::Biblio::soap).\n\nIt builds, populates and returns a new I<Bio::Biblio> object. This is\nhow it is seen from the outside. But in fact, it builds, populates and\nreturns a more specific lower-level object, for example\nI<Bio::DB::Biblio::soap> object - which one it is depends on the\nparameter I<-access>.\n\nThe real initialization is done in the method I<_initialize> of the\nlower-level object.\n\nThis method can also be used for I<cloning> an existing object and\nchanging or adding new attributes to it in the same time. This is,\nhowever, not particulary useful for the casual users of this module,\nbecause the query methods (see L<Bio::DB::BiblioI>) themselves\nalready return cloned objects with more refined query\ncollections. Anyway this is how the cloning can be done:\n\n  use Bio::Biblio;\n  my $biblio = Bio::Biblio->new();\n\n  # this will create a new object which will NOT send a 'destroy'\n  # message to the remote server when its life ends\n  my $clone = $biblio->new (-destroy-on-exit => '0'); \n\n\nsub new {\n    my ($caller,@args) = @_;\n    my $class = ref($caller) || $caller;\n  \n    # if $caller is an object, or if it is an underlying\n    # 'real-work-doing' class (e.g. Bio::DB::Biblio::soap) then\n    # we want to call SUPER to create and bless an object\n\n    if ($class =~ /Bio::DB::Biblio::(\\S+)/) {\n\tmy ($self) = $class->SUPER::new (@args);\n\n\t# now the $self is an empty object - we will populate it from\n\t# the $caller - if $caller is an object\n\n\tif (ref ($caller)) {\n\t    %{ $self } = %{ $caller };\n\t}\n\n\t# and finally add values from '@args' into the newly created\n\t# object (the values will overwrite the values copied above)\n\n\t$self->_initialize (@args);\n\treturn $self;\n\n    # this is called only the first time when somebody calls: 'new\n    # Bio::Biblio (...)', and it actually loads a 'real-work-doing'\n    # module and call this new() method again (unless the loaded\n    # module has its own new() method)\n\n    } else { \n\tmy %param = @args;\n\t@param { map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $access =\n\t    $param {'-access'} || \n\t    $class->_guess_access ( $param {'-location'} ) ||\n\t    'soap';\n\t$access = \"\\L$access\";\t# normalize capitalization to lower case\n\n\t# load module with the real implementation - as defined in $access\n\treturn unless (&_load_access_module ($access));\n\n\t# this will call this same method new() - but rather its the\n\t# upper (object) branche\n\treturn \"Bio::DB::Biblio::$access\"->new (@args);\n    }\n}\n\n# -----------------------------------------------------------------------------\n\n=head2 _load_access_module\n\n Usage   : $class->_load_access_module ($access)\n Returns : 1 on success, undef on failure\n Args    : 'access' should contain the last part of the\n           name of a module who does the real implementation\n\nIt does (in run-time) a similar thing as\n\n   require Bio::DB::Biblio::$access\n\nIt prints an error on STDERR if it fails to find and load the module\n(for example, because of the compilation errors in the module).","parameters":[{"label":"$access"}]},"detail":"($access)","kind":12,"children":[{"containerName":"_load_access_module","definition":"my","name":"$access","localvar":"my","kind":13,"line":319},{"definition":"my","name":"$module","containerName":"_load_access_module","localvar":"my","kind":13,"line":320},{"kind":13,"line":320,"name":"$load","containerName":"_load_access_module"},{"line":320,"kind":13,"name":"$m","containerName":"_load_access_module"},{"kind":13,"line":322,"containerName":"_load_access_module","name":"$module"},{"line":323,"kind":13,"name":"$load","containerName":"_load_access_module"},{"kind":13,"line":325,"containerName":"_load_access_module","name":"$main"},{"line":325,"kind":13,"name":"$module","containerName":"_load_access_module"},{"kind":13,"line":327,"containerName":"_load_access_module","name":"$load"},{"name":"throw","containerName":"_load_access_module","line":331,"kind":12}],"line":318,"name":"_load_access_module","range":{"start":{"character":0,"line":318},"end":{"line":340,"character":9999}}},{"containerName":"Root::Root","name":"Bio","kind":12,"line":331},{"range":{"start":{"character":0,"line":363},"end":{"character":9999,"line":366}},"containerName":"main::","definition":"sub","name":"_guess_access","line":363,"children":[],"kind":12}]}