{"version":5,"vars":[{"kind":2,"line":103,"containerName":"","name":"base"},{"line":118,"children":[{"localvar":"my","containerName":"new","name":"$class","definition":"my","line":119,"kind":13},{"containerName":"new","name":"@args","line":119,"kind":13},{"containerName":"new","name":"$self","definition":"my","localvar":"my","kind":13,"line":121},{"name":"$class","containerName":"new","line":121,"kind":13},{"name":"@args","containerName":"new","line":121,"kind":13},{"containerName":"new","definition":"my","name":"$type","localvar":"my","kind":13,"line":123},{"name":"$self","containerName":"new","line":123,"kind":13},{"name":"_rearrange","containerName":"new","line":123,"kind":12},{"line":123,"kind":13,"containerName":"new","name":"@args"},{"line":125,"kind":13,"containerName":"new","name":"$self"},{"name":"$self","containerName":"new","kind":13,"line":126},{"kind":12,"line":126,"containerName":"new","name":"type"},{"kind":13,"line":126,"containerName":"new","name":"$type"},{"containerName":"new","name":"$type","kind":13,"line":126},{"name":"$self","containerName":"new","line":128,"kind":13}],"kind":12,"detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: AnnotationFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::AnnotationFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::AnnotationFactory - Instantiates a new \nBio::AnnotationI (or derived class) through a factory\n\n=head1 SYNOPSIS\n\n    use Bio::Annotation::AnnotationFactory;\n    # \n    my $factory = Bio::Annotation::AnnotationFactory->new(\n                    -type => 'Bio::Annotation::SimpleValue');\n    my $ann = $factory->create_object(-value => 'peroxisome',\n                                      -tagname => 'cellular component');\n\n\n=head1 DESCRIPTION\n\nThis object will build L<Bio::AnnotationI> objects generically.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n\n=head1 CONTRIBUTORS\n\nThis is mostly copy-and-paste with subsequent adaptation from\nBio::Seq::SeqFactory by Jason Stajich. Most credits should in fact go\nto him.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::AnnotationFactory;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Factory::ObjectFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Annotation::AnnotationFactory->new();\n Function: Builds a new Bio::Annotation::AnnotationFactory object \n Returns : Bio::Annotation::AnnotationFactory\n Args    : -type => string, name of a L<Bio::AnnotationI> derived class.\n\nIf type is not set the module guesses it based on arguments passed to\nmethod L<create_object>."},"containerName":"main::","definition":"sub","range":{"end":{"line":129,"character":9999},"start":{"character":0,"line":118}},"name":"new"},{"kind":12,"line":121,"containerName":"new","name":"SUPER"},{"kind":12,"line":148,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"create_object","line":149,"kind":13},{"kind":13,"line":149,"name":"@args","containerName":"create_object"},{"name":"$type","definition":"my","containerName":"create_object","localvar":"my","kind":13,"line":151},{"kind":13,"line":151,"containerName":"create_object","name":"$self"},{"containerName":"create_object","name":"type","line":151,"kind":12},{"line":152,"kind":13,"containerName":"create_object","name":"$type"},{"containerName":"create_object","name":"$type","kind":13,"line":154},{"containerName":"create_object","name":"$self","kind":13,"line":154},{"containerName":"create_object","name":"_guess_type","kind":12,"line":154},{"name":"@args","containerName":"create_object","kind":13,"line":154},{"kind":13,"line":155,"name":"$type","containerName":"create_object"},{"containerName":"create_object","name":"$self","kind":13,"line":156},{"kind":12,"line":156,"containerName":"create_object","name":"throw"},{"kind":13,"line":159,"name":"$self","containerName":"create_object"},{"kind":13,"line":159,"containerName":"create_object","name":"$type"},{"line":161,"kind":13,"name":"$self","containerName":"create_object"},{"name":"_load_module","containerName":"create_object","kind":12,"line":161},{"name":"$type","containerName":"create_object","kind":13,"line":161},{"kind":13,"line":162,"name":"$self","containerName":"create_object"},{"kind":13,"line":162,"name":"$type","containerName":"create_object"},{"line":165,"kind":13,"name":"$self","containerName":"create_object"},{"line":165,"kind":12,"containerName":"create_object","name":"throw"},{"containerName":"create_object","name":"$type","line":170,"kind":13},{"line":170,"kind":12,"containerName":"create_object","name":"new"},{"line":170,"kind":13,"name":"$self","containerName":"create_object"},{"containerName":"create_object","name":"verbose","kind":12,"line":170},{"kind":13,"line":170,"containerName":"create_object","name":"@args"}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: AnnotationFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::AnnotationFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::AnnotationFactory - Instantiates a new \nBio::AnnotationI (or derived class) through a factory\n\n=head1 SYNOPSIS\n\n    use Bio::Annotation::AnnotationFactory;\n    # \n    my $factory = Bio::Annotation::AnnotationFactory->new(\n                    -type => 'Bio::Annotation::SimpleValue');\n    my $ann = $factory->create_object(-value => 'peroxisome',\n                                      -tagname => 'cellular component');\n\n\n=head1 DESCRIPTION\n\nThis object will build L<Bio::AnnotationI> objects generically.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n\n=head1 CONTRIBUTORS\n\nThis is mostly copy-and-paste with subsequent adaptation from\nBio::Seq::SeqFactory by Jason Stajich. Most credits should in fact go\nto him.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::AnnotationFactory;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Factory::ObjectFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Annotation::AnnotationFactory->new();\n Function: Builds a new Bio::Annotation::AnnotationFactory object \n Returns : Bio::Annotation::AnnotationFactory\n Args    : -type => string, name of a L<Bio::AnnotationI> derived class.\n\nIf type is not set the module guesses it based on arguments passed to\nmethod L<create_object>.\n\n\nsub new {\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n  \n    my ($type) = $self->_rearrange([qw(TYPE)], @args);\n\n    $self->{'_loaded_types'} = {};\n    $self->type($type) if $type;\n\n    return $self;\n}\n\n\n=head2 create_object\n\n Title   : create_object\n Usage   : my $seq = $factory->create_object(<named parameters>);\n Function: Instantiates new Bio::AnnotationI (or one of its child classes)\n\n           This object allows us to genericize the instantiation of\n           cluster objects.\n\n Returns : L<Bio::AnnotationI> compliant object\n           The return type is configurable using new(-type =>\"...\").\n Args    : initialization parameters specific to the type of annotation\n           object we want.","label":"create_object($self,@args)"},"name":"create_object","range":{"start":{"line":148,"character":0},"end":{"character":9999,"line":171}}},{"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"type","line":189,"kind":13},{"containerName":"type","name":"$type","definition":"my","localvar":"my","kind":13,"line":192},{"line":193,"kind":13,"containerName":"type","name":"$type"},{"kind":13,"line":193,"containerName":"type","name":"$self"},{"kind":13,"line":193,"name":"$type","containerName":"type"},{"name":"$self","containerName":"type","line":195,"kind":13},{"kind":12,"line":195,"name":"_load_module","containerName":"type"},{"name":"$type","containerName":"type","kind":13,"line":195},{"containerName":"type","name":"$self","kind":13,"line":198},{"line":198,"kind":12,"containerName":"type","name":"throw"},{"line":201,"kind":13,"localvar":"my","definition":"my","name":"$a","containerName":"type"},{"name":"$type","containerName":"type","line":201,"kind":13},{"kind":13,"line":202,"name":"$a","containerName":"type"},{"name":"isa","containerName":"type","kind":12,"line":202},{"kind":13,"line":203,"name":"$self","containerName":"type"},{"line":203,"kind":12,"containerName":"type","name":"throw"},{"name":"$self","containerName":"type","line":206,"kind":13},{"kind":13,"line":206,"name":"$type","containerName":"type"},{"line":208,"kind":13,"containerName":"type","name":"$self"},{"kind":13,"line":208,"containerName":"type","name":"$type"},{"containerName":"type","name":"$self","line":210,"kind":13}],"line":188,"kind":12,"range":{"end":{"character":9999,"line":211},"start":{"line":188,"character":0}},"name":"type","definition":"sub","containerName":"main::"},{"name":"_guess_type","range":{"start":{"line":228,"character":0},"end":{"character":9999,"line":257}},"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_guess_type","line":229,"kind":13},{"line":229,"kind":13,"name":"@args","containerName":"_guess_type"},{"definition":"my","name":"$type","containerName":"_guess_type","localvar":"my","kind":13,"line":230},{"kind":13,"line":233,"containerName":"_guess_type","definition":"my","name":"$val","localvar":"my"},{"kind":13,"line":233,"name":"$db","containerName":"_guess_type"},{"line":233,"kind":13,"name":"$text","containerName":"_guess_type"},{"kind":13,"line":233,"name":"$name","containerName":"_guess_type"},{"containerName":"_guess_type","name":"$authors","kind":13,"line":233},{"kind":13,"line":233,"containerName":"_guess_type","name":"$start"},{"name":"$tree","containerName":"_guess_type","line":233,"kind":13},{"kind":13,"line":233,"name":"$node","containerName":"_guess_type"},{"containerName":"_guess_type","name":"$self","kind":13,"line":234},{"line":234,"kind":12,"name":"_rearrange","containerName":"_guess_type"},{"line":242,"kind":13,"name":"@args","containerName":"_guess_type"},{"name":"$val","containerName":"_guess_type","kind":13,"line":244},{"line":244,"kind":13,"containerName":"_guess_type","name":"$type"},{"line":244,"kind":13,"name":"$val","containerName":"_guess_type"},{"containerName":"_guess_type","name":"$authors","line":245,"kind":13},{"line":245,"kind":13,"containerName":"_guess_type","name":"$type"},{"line":246,"kind":13,"name":"$db","containerName":"_guess_type"},{"line":246,"kind":13,"name":"$type","containerName":"_guess_type"},{"kind":13,"line":247,"name":"$text","containerName":"_guess_type"},{"containerName":"_guess_type","name":"$type","line":247,"kind":13},{"line":248,"kind":13,"containerName":"_guess_type","name":"$name"},{"containerName":"_guess_type","name":"$type","line":248,"kind":13},{"name":"$start","containerName":"_guess_type","line":249,"kind":13},{"containerName":"_guess_type","name":"$type","kind":13,"line":249},{"name":"$tree","containerName":"_guess_type","line":250,"kind":13},{"name":"$type","containerName":"_guess_type","line":250,"kind":13},{"containerName":"_guess_type","name":"$node","line":251,"kind":13},{"name":"$type","containerName":"_guess_type","kind":13,"line":251},{"name":"$type","containerName":"_guess_type","kind":13,"line":254},{"containerName":"_guess_type","name":"$type","kind":13,"line":254},{"kind":13,"line":256,"name":"$type","containerName":"_guess_type"}],"line":228,"definition":"sub","containerName":"main::","signature":{"label":"_guess_type($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: AnnotationFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::AnnotationFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::AnnotationFactory - Instantiates a new \nBio::AnnotationI (or derived class) through a factory\n\n=head1 SYNOPSIS\n\n    use Bio::Annotation::AnnotationFactory;\n    # \n    my $factory = Bio::Annotation::AnnotationFactory->new(\n                    -type => 'Bio::Annotation::SimpleValue');\n    my $ann = $factory->create_object(-value => 'peroxisome',\n                                      -tagname => 'cellular component');\n\n\n=head1 DESCRIPTION\n\nThis object will build L<Bio::AnnotationI> objects generically.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n\n=head1 CONTRIBUTORS\n\nThis is mostly copy-and-paste with subsequent adaptation from\nBio::Seq::SeqFactory by Jason Stajich. Most credits should in fact go\nto him.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::AnnotationFactory;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Factory::ObjectFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Annotation::AnnotationFactory->new();\n Function: Builds a new Bio::Annotation::AnnotationFactory object \n Returns : Bio::Annotation::AnnotationFactory\n Args    : -type => string, name of a L<Bio::AnnotationI> derived class.\n\nIf type is not set the module guesses it based on arguments passed to\nmethod L<create_object>.\n\n\nsub new {\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n  \n    my ($type) = $self->_rearrange([qw(TYPE)], @args);\n\n    $self->{'_loaded_types'} = {};\n    $self->type($type) if $type;\n\n    return $self;\n}\n\n\n=head2 create_object\n\n Title   : create_object\n Usage   : my $seq = $factory->create_object(<named parameters>);\n Function: Instantiates new Bio::AnnotationI (or one of its child classes)\n\n           This object allows us to genericize the instantiation of\n           cluster objects.\n\n Returns : L<Bio::AnnotationI> compliant object\n           The return type is configurable using new(-type =>\"...\").\n Args    : initialization parameters specific to the type of annotation\n           object we want.\n\n\nsub create_object {\n   my ($self,@args) = @_;\n\n   my $type = $self->type; \n   if(! $type) {\n       # we need to guess this\n       $type = $self->_guess_type(@args);\n       if(! $type) {\n       $self->throw(\"No annotation type set and unable to guess.\");\n       }\n       # load dynamically if it hasn't been loaded yet\n       if(! $self->{'_loaded_types'}->{$type}) {\n       eval {\n           $self->_load_module($type);\n           $self->{'_loaded_types'}->{$type} = 1;\n       };\n       if($@) {\n           $self->throw(\"Bio::AnnotationI implementation $type \".\n                \"failed to load: \".$@);\n       }\n       }\n   }\n   return $type->new(-verbose => $self->verbose, @args);\n}\n\n=head2 type\n\n Title   : type\n Usage   : $obj->type($newval)\n Function: Get/set the type of L<Bio::AnnotationI> object to be created.\n\n           This may be changed at any time during the lifetime of this\n           factory.\n\n Returns : value of type\n Args    : newvalue (optional)\n\n\n\nsub type{\n    my $self = shift;\n\n    if(@_) {\n    my $type = shift;\n    if($type && (! $self->{'_loaded_types'}->{$type})) {\n        eval {\n        $self->_load_module($type);\n        };\n        if( $@ ) {\n        $self->throw(\"Annotation class '$type' failed to load: \".\n                 $@);\n        }\n        my $a = bless {},$type;\n        if( ! $a->isa('Bio::AnnotationI') ) {\n        $self->throw(\"'$type' does not implement Bio::AnnotationI. \".\n                 \"Too bad.\");\n        }\n        $self->{'_loaded_types'}->{$type} = 1;\n    }\n    return $self->{'type'} = $type;\n    }\n    return $self->{'type'};\n}\n\n=head2 _guess_type\n\n Title   : _guess_type\n Usage   :\n Function: Guesses the right type of L<Bio::AnnotationI> implementation\n           based on initialization parameters for the prospective\n           object.\n Example :\n Returns : the type (a string, the module name)\n Args    : initialization parameters to be passed to the prospective\n           cluster object"},"detail":"($self,@args)"},{"name":"SWITCH","kind":12,"line":243},{"name":"SWITCH","line":244,"kind":12},{"line":245,"kind":12,"name":"SWITCH"},{"line":246,"kind":12,"name":"SWITCH"},{"line":247,"kind":12,"name":"SWITCH"},{"kind":12,"line":248,"name":"SWITCH"},{"kind":12,"line":249,"name":"SWITCH"},{"kind":12,"line":250,"name":"SWITCH"},{"name":"SWITCH","line":251,"kind":12}]}