{"version":5,"vars":[{"line":76,"kind":2,"containerName":"","name":"vars"},{"kind":13,"line":80,"name":"$LINELENGTH","containerName":null},{"kind":2,"line":80,"name":"strict","containerName":""},{"line":81,"kind":2,"containerName":"","name":"base"},{"detail":"($self,@args)","signature":{"label":"_initialize($self,@args)","documentation":"1;\n# $Id: proda.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::proda\n#\n#   based on the Bio::SeqIO modules\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#       and the Bio::SimpleAlign module of Ewan Birney\n#\n# Copyright Albert Vilella\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::proda - proda sequence input/output stream\n\nThis provides the basic capabilities to parse the output alignments\nfrom the ProDA multiple sequence alignment program\n(http://proda.stanford.edu)\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::AlignIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Align::AlignI objects to and from proda\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Albert Vilella\n\nEmail: avilella-at-gmail-dot-com\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::proda;\nuse vars qw($LINELENGTH);\nuse strict;\n\n\n$LINELENGTH          = 60;\nuse base qw(Bio::AlignIO);\n\n=head2 new\n\n Title   : new\n Usage   : $alignio = Bio::AlignIO->new(-format => 'proda',\n                       -file => 'filename');\n Function: returns a new Bio::AlignIO object to handle proda files\n Returns : Bio::AlignIO::proda object\n Args    : -verbose => verbosity setting (-1, 0, 1, 2)\n           -file    => name of file to read in or to write, with \">\"\n           -fh      => alternative to -file param - provide a filehandle\n                       to read from or write to\n           -format  => alignment format to process or produce\n           -percentages => display a percentage of identity\n                           in each line of the alignment (proda only)\n           -linelength=> alignment output line length (default 60)","parameters":[{"label":"$self"},{"label":"@args"}]},"containerName":"main::","definition":"sub","line":101,"children":[{"kind":13,"line":102,"name":"$self","definition":"my","containerName":"_initialize","localvar":"my"},{"line":102,"kind":13,"name":"@args","containerName":"_initialize"},{"line":103,"kind":13,"name":"$self","containerName":"_initialize"},{"kind":13,"line":103,"name":"@args","containerName":"_initialize"},{"kind":13,"line":104,"containerName":"_initialize","definition":"my","name":"$percentages","localvar":"my"},{"containerName":"_initialize","name":"$ll","kind":13,"line":104},{"kind":13,"line":105,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"_rearrange","kind":12,"line":105},{"containerName":"_initialize","name":"@args","kind":13,"line":105},{"name":"$percentages","containerName":"_initialize","kind":13,"line":106},{"containerName":"_initialize","name":"$self","line":106,"kind":13},{"kind":12,"line":106,"name":"percentages","containerName":"_initialize"},{"kind":13,"line":106,"containerName":"_initialize","name":"$percentages"},{"kind":13,"line":107,"containerName":"_initialize","name":"$self"},{"line":107,"kind":12,"containerName":"_initialize","name":"line_length"},{"kind":13,"line":107,"name":"$ll","containerName":"_initialize"},{"line":107,"kind":13,"containerName":"_initialize","name":"$LINELENGTH"}],"kind":12,"range":{"end":{"line":108,"character":9999},"start":{"line":101,"character":0}},"name":"_initialize"},{"name":"SUPER","containerName":"_initialize","line":103,"kind":12},{"name":"next_aln","range":{"start":{"character":0,"line":122},"end":{"character":9999,"line":235}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"next_aln($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: proda.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::proda\n#\n#   based on the Bio::SeqIO modules\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#       and the Bio::SimpleAlign module of Ewan Birney\n#\n# Copyright Albert Vilella\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::proda - proda sequence input/output stream\n\nThis provides the basic capabilities to parse the output alignments\nfrom the ProDA multiple sequence alignment program\n(http://proda.stanford.edu)\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::AlignIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Align::AlignI objects to and from proda\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Albert Vilella\n\nEmail: avilella-at-gmail-dot-com\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::proda;\nuse vars qw($LINELENGTH);\nuse strict;\n\n\n$LINELENGTH          = 60;\nuse base qw(Bio::AlignIO);\n\n=head2 new\n\n Title   : new\n Usage   : $alignio = Bio::AlignIO->new(-format => 'proda',\n                       -file => 'filename');\n Function: returns a new Bio::AlignIO object to handle proda files\n Returns : Bio::AlignIO::proda object\n Args    : -verbose => verbosity setting (-1, 0, 1, 2)\n           -file    => name of file to read in or to write, with \">\"\n           -fh      => alternative to -file param - provide a filehandle\n                       to read from or write to\n           -format  => alignment format to process or produce\n           -percentages => display a percentage of identity\n                           in each line of the alignment (proda only)\n           -linelength=> alignment output line length (default 60)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ( $percentages, $ll ) =\n      $self->_rearrange( [qw(PERCENTAGES LINELENGTH)], @args );\n    defined $percentages && $self->percentages($percentages);\n    $self->line_length( $ll || $LINELENGTH );\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream\n Returns : Bio::Align::AlignI object\n Args    : NONE\n\nSee L<Bio::Align::AlignI> for details"},"kind":12,"line":122,"children":[{"containerName":"next_aln","name":"$self","definition":"my","localvar":"my","kind":13,"line":123},{"localvar":"my","containerName":"next_aln","name":"$first_line","definition":"my","line":124,"kind":13},{"containerName":"next_aln","name":"$first_line","line":126,"kind":13},{"containerName":"next_aln","name":"$self","line":126,"kind":13},{"containerName":"next_aln","name":"_readline","kind":12,"line":126},{"kind":13,"line":127,"name":"$first_line","containerName":"next_aln"},{"line":129,"kind":13,"name":"$self","containerName":"next_aln"},{"kind":12,"line":129,"containerName":"next_aln","name":"_pushback"},{"containerName":"next_aln","name":"$first_line","kind":13,"line":129},{"name":"$first_line","containerName":"next_aln","kind":13,"line":130},{"kind":13,"line":130,"name":"$self","containerName":"next_aln"},{"line":130,"kind":12,"name":"_readline","containerName":"next_aln"},{"name":"$first_line","containerName":"next_aln","line":131,"kind":13},{"line":133,"kind":13,"containerName":"next_aln","name":"$self"},{"containerName":"next_aln","name":"throw","line":133,"kind":12},{"containerName":"next_aln","name":"$self","kind":13,"line":138},{"containerName":"next_aln","name":"_pushback","kind":12,"line":138},{"containerName":"next_aln","name":"$first_line","kind":13,"line":138},{"localvar":"my","containerName":"next_aln","name":"%alignments","definition":"my","line":140,"kind":13},{"line":141,"kind":13,"localvar":"my","containerName":"next_aln","definition":"my","name":"$aln"},{"containerName":"next_aln","name":"new","kind":12,"line":141},{"kind":13,"line":143,"name":"$self","containerName":"next_aln"},{"kind":12,"line":144,"containerName":"next_aln","name":"verbose"},{"containerName":"next_aln","definition":"my","name":"$order","localvar":"my","kind":13,"line":145},{"containerName":"next_aln","definition":"my","name":"%order","localvar":"my","kind":13,"line":146},{"containerName":"next_aln","name":"$self","line":147,"kind":13},{"name":"$first_block","definition":"my","containerName":"next_aln","localvar":"my","kind":13,"line":148},{"containerName":"next_aln","name":"$seen_block","line":148,"kind":13},{"containerName":"next_aln","name":"$seen_header","line":148,"kind":13},{"localvar":"my","containerName":"next_aln","name":"@ids","definition":"my","line":149,"kind":13},{"kind":13,"line":149,"definition":"my","name":"@ids_copy","containerName":"next_aln","localvar":"my"},{"containerName":"next_aln","name":"$self","line":150,"kind":13},{"kind":12,"line":150,"containerName":"next_aln","name":"_readline"},{"containerName":"next_aln","name":"$first_block","line":151,"kind":13},{"containerName":"next_aln","name":"$seen_block","line":153,"kind":13},{"name":"$first_block","containerName":"next_aln","line":156,"kind":13},{"line":160,"kind":13,"name":"$seen_header","containerName":"next_aln"},{"containerName":"next_aln","name":"$self","kind":13,"line":161},{"name":"_pushback","containerName":"next_aln","line":161,"kind":12},{"name":"$seen_header","containerName":"next_aln","kind":13,"line":165},{"kind":13,"line":166,"containerName":"next_aln","name":"@ids"},{"containerName":"next_aln","name":"$seen_header","line":167,"kind":13},{"name":"$seqname","definition":"my","containerName":"next_aln","localvar":"my","kind":13,"line":171},{"line":171,"kind":13,"name":"$aln_line","containerName":"next_aln"},{"line":175,"kind":13,"containerName":"next_aln","name":"$seqname"},{"kind":13,"line":175,"containerName":"next_aln","name":"$aln_line"},{"line":180,"kind":13,"containerName":"next_aln","name":"$seqname"},{"line":180,"kind":13,"name":"$aln_line","containerName":"next_aln"},{"containerName":"next_aln","name":"$seqname","kind":13,"line":181},{"name":"$self","containerName":"next_aln","line":182,"kind":13},{"containerName":"next_aln","name":"$self","line":187,"kind":13},{"line":192,"kind":13,"name":"@ids_copy","containerName":"next_aln"},{"kind":13,"line":192,"name":"@ids","containerName":"next_aln"},{"containerName":"next_aln","name":"$ids_copy","line":192,"kind":13},{"containerName":"next_aln","definition":"my","name":"$seqname_with_coords","localvar":"my","kind":13,"line":193},{"line":193,"kind":13,"name":"@ids_copy","containerName":"next_aln"},{"kind":13,"line":194,"name":"$seqname_with_coords","containerName":"next_aln"},{"kind":13,"line":196,"containerName":"next_aln","name":"$self"},{"kind":12,"line":196,"name":"throw","containerName":"next_aln"},{"name":"$alignments","containerName":"next_aln","line":199,"kind":13},{"containerName":"next_aln","name":"$seqname_with_coords","line":199,"kind":13},{"name":"$aln_line","containerName":"next_aln","kind":13,"line":199},{"kind":13,"line":201,"containerName":"next_aln","name":"$seen_block"},{"kind":13,"line":202,"name":"$order","containerName":"next_aln"},{"containerName":"next_aln","name":"$seqname_with_coords","kind":13,"line":202},{"name":"$self","containerName":"next_aln","line":203,"kind":13},{"kind":12,"line":203,"containerName":"next_aln","name":"warn"},{"containerName":"next_aln","name":"$order","kind":13,"line":207},{"line":207,"kind":13,"name":"$seqname_with_coords","containerName":"next_aln"},{"containerName":"next_aln","name":"$order","line":207,"kind":13},{"containerName":"next_aln","definition":"my","name":"$sname","localvar":"my","kind":13,"line":213},{"name":"$start","containerName":"next_aln","line":213,"kind":13},{"containerName":"next_aln","name":"$end","line":213,"kind":13},{"localvar":"my","containerName":"next_aln","name":"$name","definition":"my","line":214,"kind":13},{"line":214,"kind":13,"name":"$order","containerName":"next_aln"},{"name":"$a","containerName":"next_aln","line":214,"kind":13},{"line":214,"kind":13,"name":"$order","containerName":"next_aln"},{"name":"$b","containerName":"next_aln","kind":13,"line":214},{"line":214,"kind":13,"name":"%alignments","containerName":"next_aln"},{"line":215,"kind":13,"name":"$name","containerName":"next_aln"},{"name":"$sname","containerName":"next_aln","line":216,"kind":13},{"containerName":"next_aln","name":"$start","kind":13,"line":216},{"line":216,"kind":13,"name":"$end","containerName":"next_aln"},{"name":"$sname","containerName":"next_aln","kind":13,"line":219},{"name":"$start","containerName":"next_aln","line":219,"kind":13},{"kind":13,"line":219,"containerName":"next_aln","name":"$name"},{"localvar":"my","containerName":"next_aln","name":"$str","definition":"my","line":220,"kind":13},{"line":220,"kind":13,"name":"$alignments","containerName":"next_aln"},{"kind":13,"line":220,"containerName":"next_aln","name":"$name"},{"line":221,"kind":13,"name":"$str","containerName":"next_aln"},{"kind":13,"line":222,"name":"$end","containerName":"next_aln"},{"line":222,"kind":13,"containerName":"next_aln","name":"$str"},{"containerName":"next_aln","name":"$seq","definition":"my","localvar":"my","kind":13,"line":224},{"containerName":"next_aln","name":"new","line":224,"kind":12},{"name":"$alignments","containerName":"next_aln","kind":13,"line":225},{"name":"$name","containerName":"next_aln","line":225,"kind":13},{"line":226,"kind":13,"name":"$sname","containerName":"next_aln"},{"containerName":"next_aln","name":"$start","line":227,"kind":13},{"kind":13,"line":229,"name":"$end","containerName":"next_aln"},{"containerName":"next_aln","name":"$aln","line":230,"kind":13},{"kind":12,"line":230,"name":"add_seq","containerName":"next_aln"},{"kind":13,"line":230,"name":"$seq","containerName":"next_aln"},{"kind":13,"line":233,"name":"$aln","containerName":"next_aln"},{"kind":13,"line":233,"containerName":"next_aln","name":"$aln"},{"name":"num_sequences","containerName":"next_aln","line":233,"kind":12}]},{"name":"Bio","containerName":"SimpleAlign","kind":12,"line":141},{"name":"_lastline","kind":12,"line":147},{"name":"_lastline","line":182,"kind":12},{"name":"_lastline","line":187,"kind":12},{"kind":12,"line":224,"name":"Bio","containerName":"LocatableSeq"},{"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: proda.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::proda\n#\n#   based on the Bio::SeqIO modules\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#       and the Bio::SimpleAlign module of Ewan Birney\n#\n# Copyright Albert Vilella\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::proda - proda sequence input/output stream\n\nThis provides the basic capabilities to parse the output alignments\nfrom the ProDA multiple sequence alignment program\n(http://proda.stanford.edu)\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::AlignIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Align::AlignI objects to and from proda\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Albert Vilella\n\nEmail: avilella-at-gmail-dot-com\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::proda;\nuse vars qw($LINELENGTH);\nuse strict;\n\n\n$LINELENGTH          = 60;\nuse base qw(Bio::AlignIO);\n\n=head2 new\n\n Title   : new\n Usage   : $alignio = Bio::AlignIO->new(-format => 'proda',\n                       -file => 'filename');\n Function: returns a new Bio::AlignIO object to handle proda files\n Returns : Bio::AlignIO::proda object\n Args    : -verbose => verbosity setting (-1, 0, 1, 2)\n           -file    => name of file to read in or to write, with \">\"\n           -fh      => alternative to -file param - provide a filehandle\n                       to read from or write to\n           -format  => alignment format to process or produce\n           -percentages => display a percentage of identity\n                           in each line of the alignment (proda only)\n           -linelength=> alignment output line length (default 60)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ( $percentages, $ll ) =\n      $self->_rearrange( [qw(PERCENTAGES LINELENGTH)], @args );\n    defined $percentages && $self->percentages($percentages);\n    $self->line_length( $ll || $LINELENGTH );\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream\n Returns : Bio::Align::AlignI object\n Args    : NONE\n\nSee L<Bio::Align::AlignI> for details\n\n\nsub next_aln {\n    my ($self) = @_;\n    my $first_line;\n\n    while ( $first_line = $self->_readline ) {\n        last if $first_line !~ /^$/;\n    }\n    $self->_pushback($first_line);\n    if ( defined( $first_line = $self->_readline )\n        && $first_line !~ /\\(/ )\n    {\n        $self->throw(\n            \"trying to parse a file which does not start with proda headers\"\n        );\n    } else {\n        # use it inside the loop\n        $self->_pushback($first_line);\n    }\n    my %alignments;\n    my $aln = Bio::SimpleAlign->new(\n        -source  => 'proda',\n        -verbose => $self->verbose\n    );\n    my $order = 0;\n    my %order;\n    $self->{_lastline} = '';\n    my ($first_block, $seen_block, $seen_header) = (0,0,0);\n    my @ids; my @ids_copy;\n    while ( defined( $_ = $self->_readline ) ) {\n        next if (/^\\s+$/ && !$first_block);\n        if (/^\\s$/) {  # line contains no description\n            $seen_block = 1;\n            next;\n        }\n        $first_block = 1;\n\n        # break the loop if we come to the end of the current alignment\n        # and push back the proda header\n        if (/\\(/ && $seen_header) {\n            $self->_pushback($_);\n            last;\n        }\n\n        if (/\\(/ && !$seen_header) {\n            @ids = split(' ', $_);\n            $seen_header = 1;\n            next;\n        }\n\n        my ( $seqname, $aln_line ) = ( '', '' );\n        if (/^\\s*(\\S+)\\s*\\/\\s*(\\d+)-(\\d+)\\s+(\\S+)\\s*$/ox) {\n\n            # clustal 1.4 format\n            ( $seqname, $aln_line ) = ( \"$1:$2-$3\", $4 );\n\n            # } elsif( /^\\s*(\\S+)\\s+(\\S+)\\s*$/ox ) { without trailing numbers\n        }\n        elsif (/^\\s*(\\S+)\\s+(\\S+)\\s*\\d*\\s*$/ox) {    # with numbers\n            ( $seqname, $aln_line ) = ( $1, $2 );\n            if ( $seqname =~ /^[\\*\\.\\+\\:]+$/ ) {\n                $self->{_lastline} = $_;\n                next;\n            }\n        }\n        else {\n            $self->{_lastline} = $_;\n            next;\n        }\n\n        # we ended up the first block and now are on the second\n        @ids_copy = @ids unless(defined($ids_copy[0])); #FIXME - hacky\n        my $seqname_with_coords = shift(@ids_copy);\n        if ($seqname_with_coords !~ /$seqname/) {\n            {\n                $self->throw(\"header and body of the alignment dont match\");\n            }\n        }\n        $alignments{$seqname_with_coords} .= $aln_line;\n\n        if ( !$seen_block ) {\n            if (exists $order{$seqname_with_coords}) {\n                $self->warn(\"Duplicate sequence : $seqname\\n\".\n                            \"Can't guarantee alignment quality\");\n            }\n            else {\n                $order{$seqname_with_coords} = $order++;\n            }\n        }\n\n    }\n\n    my ( $sname, $start, $end );\n    foreach my $name ( sort { $order{$a} <=> $order{$b} } keys %alignments ) {\n        if ( $name =~ /(\\S+):(\\d+)-(\\d+)/ ) {\n            ( $sname, $start, $end ) = ( $1, $2, $3 );\n        }\n        else {\n            ( $sname, $start ) = ( $name, 1 );\n            my $str = $alignments{$name};\n            $str =~ s/[^A-Za-z]//g;\n            $end = length($str);\n        }\n        my $seq = Bio::LocatableSeq->new(\n            -seq   => $alignments{$name},\n            -id    => $sname,\n            -start => $start,\n            -end   => $end\n        );\n        $aln->add_seq($seq);\n    }\n    \n    return $aln if $aln->num_sequences;\n    return;\n}\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the proda-format object (.aln) into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Align::AlignI object","parameters":[{"label":"$self"},{"label":"@aln"}],"label":"write_aln($self,@aln)"},"detail":"($self,@aln)","kind":12,"children":[{"line":248,"kind":13,"localvar":"my","containerName":"write_aln","name":"$self","definition":"my"},{"name":"@aln","containerName":"write_aln","kind":13,"line":248},{"containerName":"write_aln","name":"$self","kind":13,"line":249},{"containerName":"write_aln","name":"throw_not_implemented","line":249,"kind":12}],"line":247,"name":"write_aln","range":{"end":{"line":250,"character":9999},"start":{"line":247,"character":0}}},{"range":{"end":{"line":270,"character":9999},"start":{"character":0,"line":264}},"name":"percentages","line":264,"children":[{"line":265,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"percentages"},{"line":265,"kind":13,"containerName":"percentages","name":"$value"},{"kind":13,"line":266,"containerName":"percentages","name":"$value"},{"name":"$self","containerName":"percentages","line":267,"kind":13},{"containerName":"percentages","name":"$value","kind":13,"line":267},{"line":269,"kind":13,"name":"$self","containerName":"percentages"}],"kind":12,"detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: proda.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::proda\n#\n#   based on the Bio::SeqIO modules\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#       and the Bio::SimpleAlign module of Ewan Birney\n#\n# Copyright Albert Vilella\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::proda - proda sequence input/output stream\n\nThis provides the basic capabilities to parse the output alignments\nfrom the ProDA multiple sequence alignment program\n(http://proda.stanford.edu)\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::AlignIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Align::AlignI objects to and from proda\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Albert Vilella\n\nEmail: avilella-at-gmail-dot-com\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::proda;\nuse vars qw($LINELENGTH);\nuse strict;\n\n\n$LINELENGTH          = 60;\nuse base qw(Bio::AlignIO);\n\n=head2 new\n\n Title   : new\n Usage   : $alignio = Bio::AlignIO->new(-format => 'proda',\n                       -file => 'filename');\n Function: returns a new Bio::AlignIO object to handle proda files\n Returns : Bio::AlignIO::proda object\n Args    : -verbose => verbosity setting (-1, 0, 1, 2)\n           -file    => name of file to read in or to write, with \">\"\n           -fh      => alternative to -file param - provide a filehandle\n                       to read from or write to\n           -format  => alignment format to process or produce\n           -percentages => display a percentage of identity\n                           in each line of the alignment (proda only)\n           -linelength=> alignment output line length (default 60)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ( $percentages, $ll ) =\n      $self->_rearrange( [qw(PERCENTAGES LINELENGTH)], @args );\n    defined $percentages && $self->percentages($percentages);\n    $self->line_length( $ll || $LINELENGTH );\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream\n Returns : Bio::Align::AlignI object\n Args    : NONE\n\nSee L<Bio::Align::AlignI> for details\n\n\nsub next_aln {\n    my ($self) = @_;\n    my $first_line;\n\n    while ( $first_line = $self->_readline ) {\n        last if $first_line !~ /^$/;\n    }\n    $self->_pushback($first_line);\n    if ( defined( $first_line = $self->_readline )\n        && $first_line !~ /\\(/ )\n    {\n        $self->throw(\n            \"trying to parse a file which does not start with proda headers\"\n        );\n    } else {\n        # use it inside the loop\n        $self->_pushback($first_line);\n    }\n    my %alignments;\n    my $aln = Bio::SimpleAlign->new(\n        -source  => 'proda',\n        -verbose => $self->verbose\n    );\n    my $order = 0;\n    my %order;\n    $self->{_lastline} = '';\n    my ($first_block, $seen_block, $seen_header) = (0,0,0);\n    my @ids; my @ids_copy;\n    while ( defined( $_ = $self->_readline ) ) {\n        next if (/^\\s+$/ && !$first_block);\n        if (/^\\s$/) {  # line contains no description\n            $seen_block = 1;\n            next;\n        }\n        $first_block = 1;\n\n        # break the loop if we come to the end of the current alignment\n        # and push back the proda header\n        if (/\\(/ && $seen_header) {\n            $self->_pushback($_);\n            last;\n        }\n\n        if (/\\(/ && !$seen_header) {\n            @ids = split(' ', $_);\n            $seen_header = 1;\n            next;\n        }\n\n        my ( $seqname, $aln_line ) = ( '', '' );\n        if (/^\\s*(\\S+)\\s*\\/\\s*(\\d+)-(\\d+)\\s+(\\S+)\\s*$/ox) {\n\n            # clustal 1.4 format\n            ( $seqname, $aln_line ) = ( \"$1:$2-$3\", $4 );\n\n            # } elsif( /^\\s*(\\S+)\\s+(\\S+)\\s*$/ox ) { without trailing numbers\n        }\n        elsif (/^\\s*(\\S+)\\s+(\\S+)\\s*\\d*\\s*$/ox) {    # with numbers\n            ( $seqname, $aln_line ) = ( $1, $2 );\n            if ( $seqname =~ /^[\\*\\.\\+\\:]+$/ ) {\n                $self->{_lastline} = $_;\n                next;\n            }\n        }\n        else {\n            $self->{_lastline} = $_;\n            next;\n        }\n\n        # we ended up the first block and now are on the second\n        @ids_copy = @ids unless(defined($ids_copy[0])); #FIXME - hacky\n        my $seqname_with_coords = shift(@ids_copy);\n        if ($seqname_with_coords !~ /$seqname/) {\n            {\n                $self->throw(\"header and body of the alignment dont match\");\n            }\n        }\n        $alignments{$seqname_with_coords} .= $aln_line;\n\n        if ( !$seen_block ) {\n            if (exists $order{$seqname_with_coords}) {\n                $self->warn(\"Duplicate sequence : $seqname\\n\".\n                            \"Can't guarantee alignment quality\");\n            }\n            else {\n                $order{$seqname_with_coords} = $order++;\n            }\n        }\n\n    }\n\n    my ( $sname, $start, $end );\n    foreach my $name ( sort { $order{$a} <=> $order{$b} } keys %alignments ) {\n        if ( $name =~ /(\\S+):(\\d+)-(\\d+)/ ) {\n            ( $sname, $start, $end ) = ( $1, $2, $3 );\n        }\n        else {\n            ( $sname, $start ) = ( $name, 1 );\n            my $str = $alignments{$name};\n            $str =~ s/[^A-Za-z]//g;\n            $end = length($str);\n        }\n        my $seq = Bio::LocatableSeq->new(\n            -seq   => $alignments{$name},\n            -id    => $sname,\n            -start => $start,\n            -end   => $end\n        );\n        $aln->add_seq($seq);\n    }\n    \n    return $aln if $aln->num_sequences;\n    return;\n}\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the proda-format object (.aln) into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Align::AlignI object\n\n\nsub write_aln {\n    my ($self,@aln) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 percentages\n\n Title   : percentages\n Usage   : $obj->percentages($newval)\n Function: Set the percentages flag - whether or not to show percentages in\n           each output line\n Returns : value of percentages\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"percentages($self,$value)"},"containerName":"main::","definition":"sub"},{"range":{"start":{"line":283,"character":0},"end":{"line":289,"character":9999}},"name":"line_length","children":[{"kind":13,"line":284,"containerName":"line_length","name":"$self","definition":"my","localvar":"my"},{"containerName":"line_length","name":"$value","kind":13,"line":284},{"name":"$value","containerName":"line_length","kind":13,"line":285},{"line":286,"kind":13,"containerName":"line_length","name":"$self"},{"kind":13,"line":286,"name":"$value","containerName":"line_length"},{"containerName":"line_length","name":"$self","line":288,"kind":13}],"line":283,"kind":12,"signature":{"label":"line_length($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: proda.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::proda\n#\n#   based on the Bio::SeqIO modules\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#       and the Bio::SimpleAlign module of Ewan Birney\n#\n# Copyright Albert Vilella\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::proda - proda sequence input/output stream\n\nThis provides the basic capabilities to parse the output alignments\nfrom the ProDA multiple sequence alignment program\n(http://proda.stanford.edu)\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::AlignIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Align::AlignI objects to and from proda\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Albert Vilella\n\nEmail: avilella-at-gmail-dot-com\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::proda;\nuse vars qw($LINELENGTH);\nuse strict;\n\n\n$LINELENGTH          = 60;\nuse base qw(Bio::AlignIO);\n\n=head2 new\n\n Title   : new\n Usage   : $alignio = Bio::AlignIO->new(-format => 'proda',\n                       -file => 'filename');\n Function: returns a new Bio::AlignIO object to handle proda files\n Returns : Bio::AlignIO::proda object\n Args    : -verbose => verbosity setting (-1, 0, 1, 2)\n           -file    => name of file to read in or to write, with \">\"\n           -fh      => alternative to -file param - provide a filehandle\n                       to read from or write to\n           -format  => alignment format to process or produce\n           -percentages => display a percentage of identity\n                           in each line of the alignment (proda only)\n           -linelength=> alignment output line length (default 60)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ( $percentages, $ll ) =\n      $self->_rearrange( [qw(PERCENTAGES LINELENGTH)], @args );\n    defined $percentages && $self->percentages($percentages);\n    $self->line_length( $ll || $LINELENGTH );\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream\n Returns : Bio::Align::AlignI object\n Args    : NONE\n\nSee L<Bio::Align::AlignI> for details\n\n\nsub next_aln {\n    my ($self) = @_;\n    my $first_line;\n\n    while ( $first_line = $self->_readline ) {\n        last if $first_line !~ /^$/;\n    }\n    $self->_pushback($first_line);\n    if ( defined( $first_line = $self->_readline )\n        && $first_line !~ /\\(/ )\n    {\n        $self->throw(\n            \"trying to parse a file which does not start with proda headers\"\n        );\n    } else {\n        # use it inside the loop\n        $self->_pushback($first_line);\n    }\n    my %alignments;\n    my $aln = Bio::SimpleAlign->new(\n        -source  => 'proda',\n        -verbose => $self->verbose\n    );\n    my $order = 0;\n    my %order;\n    $self->{_lastline} = '';\n    my ($first_block, $seen_block, $seen_header) = (0,0,0);\n    my @ids; my @ids_copy;\n    while ( defined( $_ = $self->_readline ) ) {\n        next if (/^\\s+$/ && !$first_block);\n        if (/^\\s$/) {  # line contains no description\n            $seen_block = 1;\n            next;\n        }\n        $first_block = 1;\n\n        # break the loop if we come to the end of the current alignment\n        # and push back the proda header\n        if (/\\(/ && $seen_header) {\n            $self->_pushback($_);\n            last;\n        }\n\n        if (/\\(/ && !$seen_header) {\n            @ids = split(' ', $_);\n            $seen_header = 1;\n            next;\n        }\n\n        my ( $seqname, $aln_line ) = ( '', '' );\n        if (/^\\s*(\\S+)\\s*\\/\\s*(\\d+)-(\\d+)\\s+(\\S+)\\s*$/ox) {\n\n            # clustal 1.4 format\n            ( $seqname, $aln_line ) = ( \"$1:$2-$3\", $4 );\n\n            # } elsif( /^\\s*(\\S+)\\s+(\\S+)\\s*$/ox ) { without trailing numbers\n        }\n        elsif (/^\\s*(\\S+)\\s+(\\S+)\\s*\\d*\\s*$/ox) {    # with numbers\n            ( $seqname, $aln_line ) = ( $1, $2 );\n            if ( $seqname =~ /^[\\*\\.\\+\\:]+$/ ) {\n                $self->{_lastline} = $_;\n                next;\n            }\n        }\n        else {\n            $self->{_lastline} = $_;\n            next;\n        }\n\n        # we ended up the first block and now are on the second\n        @ids_copy = @ids unless(defined($ids_copy[0])); #FIXME - hacky\n        my $seqname_with_coords = shift(@ids_copy);\n        if ($seqname_with_coords !~ /$seqname/) {\n            {\n                $self->throw(\"header and body of the alignment dont match\");\n            }\n        }\n        $alignments{$seqname_with_coords} .= $aln_line;\n\n        if ( !$seen_block ) {\n            if (exists $order{$seqname_with_coords}) {\n                $self->warn(\"Duplicate sequence : $seqname\\n\".\n                            \"Can't guarantee alignment quality\");\n            }\n            else {\n                $order{$seqname_with_coords} = $order++;\n            }\n        }\n\n    }\n\n    my ( $sname, $start, $end );\n    foreach my $name ( sort { $order{$a} <=> $order{$b} } keys %alignments ) {\n        if ( $name =~ /(\\S+):(\\d+)-(\\d+)/ ) {\n            ( $sname, $start, $end ) = ( $1, $2, $3 );\n        }\n        else {\n            ( $sname, $start ) = ( $name, 1 );\n            my $str = $alignments{$name};\n            $str =~ s/[^A-Za-z]//g;\n            $end = length($str);\n        }\n        my $seq = Bio::LocatableSeq->new(\n            -seq   => $alignments{$name},\n            -id    => $sname,\n            -start => $start,\n            -end   => $end\n        );\n        $aln->add_seq($seq);\n    }\n    \n    return $aln if $aln->num_sequences;\n    return;\n}\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the proda-format object (.aln) into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Align::AlignI object\n\n\nsub write_aln {\n    my ($self,@aln) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 percentages\n\n Title   : percentages\n Usage   : $obj->percentages($newval)\n Function: Set the percentages flag - whether or not to show percentages in\n           each output line\n Returns : value of percentages\n Args    : newvalue (optional)\n\n\n\nsub percentages {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_percentages'} = $value;\n    }\n    return $self->{'_percentages'};\n}\n\n=head2 line_length\n\n Title   : line_length\n Usage   : $obj->line_length($newval)\n Function: Set the alignment output line length\n Returns : value of line_length\n Args    : newvalue (optional)"},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"children":[{"line":303,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"no_header"},{"line":303,"kind":13,"containerName":"no_header","name":"$value"},{"name":"$value","containerName":"no_header","kind":13,"line":304},{"name":"$self","containerName":"no_header","kind":13,"line":305},{"containerName":"no_header","name":"$value","line":305,"kind":13},{"line":307,"kind":13,"containerName":"no_header","name":"$self"}],"line":302,"kind":12,"signature":{"label":"no_header($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: proda.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::proda\n#\n#   based on the Bio::SeqIO modules\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#       and the Bio::SimpleAlign module of Ewan Birney\n#\n# Copyright Albert Vilella\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::proda - proda sequence input/output stream\n\nThis provides the basic capabilities to parse the output alignments\nfrom the ProDA multiple sequence alignment program\n(http://proda.stanford.edu)\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::AlignIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Align::AlignI objects to and from proda\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Albert Vilella\n\nEmail: avilella-at-gmail-dot-com\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::proda;\nuse vars qw($LINELENGTH);\nuse strict;\n\n\n$LINELENGTH          = 60;\nuse base qw(Bio::AlignIO);\n\n=head2 new\n\n Title   : new\n Usage   : $alignio = Bio::AlignIO->new(-format => 'proda',\n                       -file => 'filename');\n Function: returns a new Bio::AlignIO object to handle proda files\n Returns : Bio::AlignIO::proda object\n Args    : -verbose => verbosity setting (-1, 0, 1, 2)\n           -file    => name of file to read in or to write, with \">\"\n           -fh      => alternative to -file param - provide a filehandle\n                       to read from or write to\n           -format  => alignment format to process or produce\n           -percentages => display a percentage of identity\n                           in each line of the alignment (proda only)\n           -linelength=> alignment output line length (default 60)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ( $percentages, $ll ) =\n      $self->_rearrange( [qw(PERCENTAGES LINELENGTH)], @args );\n    defined $percentages && $self->percentages($percentages);\n    $self->line_length( $ll || $LINELENGTH );\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream\n Returns : Bio::Align::AlignI object\n Args    : NONE\n\nSee L<Bio::Align::AlignI> for details\n\n\nsub next_aln {\n    my ($self) = @_;\n    my $first_line;\n\n    while ( $first_line = $self->_readline ) {\n        last if $first_line !~ /^$/;\n    }\n    $self->_pushback($first_line);\n    if ( defined( $first_line = $self->_readline )\n        && $first_line !~ /\\(/ )\n    {\n        $self->throw(\n            \"trying to parse a file which does not start with proda headers\"\n        );\n    } else {\n        # use it inside the loop\n        $self->_pushback($first_line);\n    }\n    my %alignments;\n    my $aln = Bio::SimpleAlign->new(\n        -source  => 'proda',\n        -verbose => $self->verbose\n    );\n    my $order = 0;\n    my %order;\n    $self->{_lastline} = '';\n    my ($first_block, $seen_block, $seen_header) = (0,0,0);\n    my @ids; my @ids_copy;\n    while ( defined( $_ = $self->_readline ) ) {\n        next if (/^\\s+$/ && !$first_block);\n        if (/^\\s$/) {  # line contains no description\n            $seen_block = 1;\n            next;\n        }\n        $first_block = 1;\n\n        # break the loop if we come to the end of the current alignment\n        # and push back the proda header\n        if (/\\(/ && $seen_header) {\n            $self->_pushback($_);\n            last;\n        }\n\n        if (/\\(/ && !$seen_header) {\n            @ids = split(' ', $_);\n            $seen_header = 1;\n            next;\n        }\n\n        my ( $seqname, $aln_line ) = ( '', '' );\n        if (/^\\s*(\\S+)\\s*\\/\\s*(\\d+)-(\\d+)\\s+(\\S+)\\s*$/ox) {\n\n            # clustal 1.4 format\n            ( $seqname, $aln_line ) = ( \"$1:$2-$3\", $4 );\n\n            # } elsif( /^\\s*(\\S+)\\s+(\\S+)\\s*$/ox ) { without trailing numbers\n        }\n        elsif (/^\\s*(\\S+)\\s+(\\S+)\\s*\\d*\\s*$/ox) {    # with numbers\n            ( $seqname, $aln_line ) = ( $1, $2 );\n            if ( $seqname =~ /^[\\*\\.\\+\\:]+$/ ) {\n                $self->{_lastline} = $_;\n                next;\n            }\n        }\n        else {\n            $self->{_lastline} = $_;\n            next;\n        }\n\n        # we ended up the first block and now are on the second\n        @ids_copy = @ids unless(defined($ids_copy[0])); #FIXME - hacky\n        my $seqname_with_coords = shift(@ids_copy);\n        if ($seqname_with_coords !~ /$seqname/) {\n            {\n                $self->throw(\"header and body of the alignment dont match\");\n            }\n        }\n        $alignments{$seqname_with_coords} .= $aln_line;\n\n        if ( !$seen_block ) {\n            if (exists $order{$seqname_with_coords}) {\n                $self->warn(\"Duplicate sequence : $seqname\\n\".\n                            \"Can't guarantee alignment quality\");\n            }\n            else {\n                $order{$seqname_with_coords} = $order++;\n            }\n        }\n\n    }\n\n    my ( $sname, $start, $end );\n    foreach my $name ( sort { $order{$a} <=> $order{$b} } keys %alignments ) {\n        if ( $name =~ /(\\S+):(\\d+)-(\\d+)/ ) {\n            ( $sname, $start, $end ) = ( $1, $2, $3 );\n        }\n        else {\n            ( $sname, $start ) = ( $name, 1 );\n            my $str = $alignments{$name};\n            $str =~ s/[^A-Za-z]//g;\n            $end = length($str);\n        }\n        my $seq = Bio::LocatableSeq->new(\n            -seq   => $alignments{$name},\n            -id    => $sname,\n            -start => $start,\n            -end   => $end\n        );\n        $aln->add_seq($seq);\n    }\n    \n    return $aln if $aln->num_sequences;\n    return;\n}\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the proda-format object (.aln) into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Align::AlignI object\n\n\nsub write_aln {\n    my ($self,@aln) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 percentages\n\n Title   : percentages\n Usage   : $obj->percentages($newval)\n Function: Set the percentages flag - whether or not to show percentages in\n           each output line\n Returns : value of percentages\n Args    : newvalue (optional)\n\n\n\nsub percentages {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_percentages'} = $value;\n    }\n    return $self->{'_percentages'};\n}\n\n=head2 line_length\n\n Title   : line_length\n Usage   : $obj->line_length($newval)\n Function: Set the alignment output line length\n Returns : value of line_length\n Args    : newvalue (optional)\n\n\n\nsub line_length {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_line_length'} = $value;\n    }\n    return $self->{'_line_length'};\n}\n\n=head2 no_header\n\n Title   : no_header\n Usage   : $obj->no_header($newval)\n Function: Set if the alignment input has a CLUSTAL header or not\n Returns : value of no_header\n Args    : newvalue (optional)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","range":{"start":{"line":302,"character":0},"end":{"line":308,"character":9999}},"name":"no_header"}]}