{"version":5,"vars":[{"containerName":"","name":"vars","line":95,"kind":2},{"line":101,"kind":2,"name":"base","containerName":""},{"kind":13,"line":103,"name":"@EXPORT","containerName":null},{"containerName":null,"name":"@EXPORT_OK","line":104,"kind":13},{"name":"%EXPORT_TAGS","containerName":null,"kind":13,"line":105},{"name":"all","kind":12,"line":105},{"kind":13,"line":105,"name":"@EXPORT","containerName":null},{"name":"@EXPORT_OK","containerName":null,"kind":13,"line":105},{"kind":14,"line":107,"name":"CODONSIZE","definition":1,"containerName":"main::"},{"name":"$GAP","containerName":null,"kind":13,"line":108},{"name":"$CODONGAP","containerName":null,"kind":13,"line":109},{"kind":13,"line":109,"name":"$GAP","containerName":null},{"kind":12,"line":109,"name":"CODONSIZE"},{"range":{"start":{"character":0,"line":136},"end":{"character":9999,"line":179}},"name":"aa_to_dna_aln","children":[{"localvar":"my","name":"$aln","definition":"my","containerName":"aa_to_dna_aln","line":137,"kind":13},{"containerName":"aa_to_dna_aln","name":"$dnaseqs","kind":13,"line":137},{"containerName":"aa_to_dna_aln","name":"$aln","line":138,"kind":13},{"name":"$aln","containerName":"aa_to_dna_aln","kind":13,"line":139},{"kind":13,"line":140,"name":"$aln","containerName":"aa_to_dna_aln"},{"kind":12,"line":140,"name":"isa","containerName":"aa_to_dna_aln"},{"kind":13,"line":143,"containerName":"aa_to_dna_aln","definition":"my","name":"$alnlen","localvar":"my"},{"kind":13,"line":143,"name":"$aln","containerName":"aa_to_dna_aln"},{"containerName":"aa_to_dna_aln","name":"length","kind":12,"line":143},{"kind":13,"line":144,"containerName":"aa_to_dna_aln","definition":"my","name":"$dnaalign","localvar":"my"},{"containerName":"aa_to_dna_aln","name":"new","kind":12,"line":144},{"containerName":"aa_to_dna_aln","name":"$aln","line":145,"kind":13},{"line":145,"kind":12,"name":"map_chars","containerName":"aa_to_dna_aln"},{"line":145,"kind":13,"containerName":"aa_to_dna_aln","name":"$GAP"},{"localvar":"my","containerName":"aa_to_dna_aln","definition":"my","name":"$seq","line":147,"kind":13},{"kind":13,"line":147,"name":"$aln","containerName":"aa_to_dna_aln"},{"containerName":"aa_to_dna_aln","name":"each_seq","line":147,"kind":12},{"localvar":"my","containerName":"aa_to_dna_aln","definition":"my","name":"$aa_seqstr","line":148,"kind":13},{"containerName":"aa_to_dna_aln","name":"$seq","kind":13,"line":148},{"name":"seq","containerName":"aa_to_dna_aln","kind":12,"line":148},{"localvar":"my","name":"$id","definition":"my","containerName":"aa_to_dna_aln","line":149,"kind":13},{"line":149,"kind":13,"containerName":"aa_to_dna_aln","name":"$seq"},{"kind":12,"line":149,"containerName":"aa_to_dna_aln","name":"display_id"},{"kind":13,"line":150,"containerName":"aa_to_dna_aln","definition":"my","name":"$dnaseq","localvar":"my"},{"containerName":"aa_to_dna_aln","name":"$dnaseqs","line":150,"kind":13},{"containerName":"aa_to_dna_aln","name":"$id","kind":13,"line":150},{"kind":13,"line":150,"name":"$aln","containerName":"aa_to_dna_aln"},{"name":"throw","containerName":"aa_to_dna_aln","kind":12,"line":150},{"kind":13,"line":151,"containerName":"aa_to_dna_aln","name":"$seq"},{"name":"display_id","containerName":"aa_to_dna_aln","kind":12,"line":151},{"containerName":"aa_to_dna_aln","name":"$start_offset","definition":"my","localvar":"my","kind":13,"line":152},{"kind":13,"line":152,"containerName":"aa_to_dna_aln","name":"$seq"},{"name":"start","containerName":"aa_to_dna_aln","line":152,"kind":12},{"kind":13,"line":154,"name":"$dnaseq","containerName":"aa_to_dna_aln"},{"kind":13,"line":154,"containerName":"aa_to_dna_aln","name":"$dnaseq"},{"name":"seq","containerName":"aa_to_dna_aln","kind":12,"line":154},{"line":155,"kind":13,"localvar":"my","containerName":"aa_to_dna_aln","definition":"my","name":"$dnalen"},{"containerName":"aa_to_dna_aln","name":"$dnaseqs","kind":13,"line":155},{"kind":13,"line":155,"containerName":"aa_to_dna_aln","name":"$id"},{"containerName":"aa_to_dna_aln","name":"length","line":155,"kind":12},{"kind":13,"line":156,"definition":"my","name":"$nt_seqstr","containerName":"aa_to_dna_aln","localvar":"my"},{"containerName":"aa_to_dna_aln","definition":"my","name":"$j","localvar":"my","kind":13,"line":157},{"localvar":"my","containerName":"aa_to_dna_aln","name":"$i","definition":"my","line":158,"kind":13},{"name":"$i","containerName":"aa_to_dna_aln","kind":13,"line":158},{"line":158,"kind":13,"containerName":"aa_to_dna_aln","name":"$alnlen"},{"line":158,"kind":13,"containerName":"aa_to_dna_aln","name":"$i"},{"localvar":"my","containerName":"aa_to_dna_aln","definition":"my","name":"$char","line":159,"kind":13},{"line":159,"kind":13,"containerName":"aa_to_dna_aln","name":"$aa_seqstr"},{"kind":13,"line":159,"name":"$i","containerName":"aa_to_dna_aln"},{"line":159,"kind":13,"name":"$start_offset","containerName":"aa_to_dna_aln"},{"line":160,"kind":13,"name":"$char","containerName":"aa_to_dna_aln"},{"name":"$GAP","containerName":"aa_to_dna_aln","kind":13,"line":160},{"line":160,"kind":13,"containerName":"aa_to_dna_aln","name":"$j"},{"kind":13,"line":160,"containerName":"aa_to_dna_aln","name":"$dnalen"},{"kind":13,"line":161,"containerName":"aa_to_dna_aln","name":"$nt_seqstr"},{"line":161,"kind":13,"name":"$CODONGAP","containerName":"aa_to_dna_aln"},{"line":163,"kind":13,"name":"$nt_seqstr","containerName":"aa_to_dna_aln"},{"containerName":"aa_to_dna_aln","name":"$dnaseq","kind":13,"line":163},{"name":"$j","containerName":"aa_to_dna_aln","kind":13,"line":163},{"containerName":"aa_to_dna_aln","name":"$j","kind":13,"line":164},{"name":"$nt_seqstr","containerName":"aa_to_dna_aln","line":167,"kind":13},{"line":167,"kind":13,"containerName":"aa_to_dna_aln","name":"$GAP"},{"line":167,"kind":13,"containerName":"aa_to_dna_aln","name":"$alnlen"},{"kind":13,"line":167,"name":"$nt_seqstr","containerName":"aa_to_dna_aln"},{"kind":13,"line":169,"containerName":"aa_to_dna_aln","definition":"my","name":"$newdna","localvar":"my"},{"line":169,"kind":12,"name":"new","containerName":"aa_to_dna_aln"},{"line":169,"kind":13,"name":"$id","containerName":"aa_to_dna_aln"},{"kind":13,"line":171,"name":"$start_offset","containerName":"aa_to_dna_aln"},{"line":172,"kind":13,"containerName":"aa_to_dna_aln","name":"$seq"},{"line":172,"kind":12,"name":"end","containerName":"aa_to_dna_aln"},{"name":"$nt_seqstr","containerName":"aa_to_dna_aln","kind":13,"line":175},{"line":176,"kind":13,"name":"$dnaalign","containerName":"aa_to_dna_aln"},{"kind":12,"line":176,"containerName":"aa_to_dna_aln","name":"add_seq"},{"name":"$newdna","containerName":"aa_to_dna_aln","kind":13,"line":176},{"kind":13,"line":178,"containerName":"aa_to_dna_aln","name":"$dnaalign"}],"line":136,"kind":12,"signature":{"documentation":"1;\n# $Id: Utilities.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::Utilities\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::Utilities - A collection of utilities regarding converting\nand manipulating alignment objects\n\n=head1 SYNOPSIS\n\n  use Bio::Align::Utilities qw(:all);\n  # %dnaseqs is a hash of CDS sequences (spliced)\n\n\n  # Even if the protein alignments are local make sure the start/end\n  # stored in the LocatableSeq objects are to the full length protein.\n  # The CoDing Sequence that is passed in should still be the full \n  # length CDS as the nt alignment will be generated.\n  #\n  my $dna_aln = &aa_to_dna_aln($aa_aln,\\%dnaseqs);\n\n\n  # generate bootstraps\n  my $replicates = &bootstrap_replicates($aln,$count);\n\n\n=head1 DESCRIPTION\n\nThis module contains utility methods for manipulating sequence\nalignments ( L<Bio::Align::AlignI>) objects.\n\nThe B<aa_to_dna_aln> utility is essentially the same as the B<mrtrans>\nprogram by Bill Pearson available at\nftp://ftp.virginia.edu/pub/fasta/other/mrtrans.shar.  Of course this\nis a pure-perl implementation, but just to mention that if anything\nseems odd you can check the alignments generated against Bill's\nprogram.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n#' keep my emacs happy\n# Let the code begin...\n\n\npackage Bio::Align::Utilities;\nuse vars qw(@EXPORT @EXPORT_OK $GAP $CODONGAP %EXPORT_TAGS);\nuse strict;\nuse Carp;\nuse Bio::Root::Version;\nrequire Exporter;\n\nuse base qw(Exporter);\n\n@EXPORT = qw();\n@EXPORT_OK = qw(aa_to_dna_aln bootstrap_replicates cat);\n%EXPORT_TAGS = (all =>[@EXPORT, @EXPORT_OK]);\nBEGIN {\n    use constant CODONSIZE => 3;\n    $GAP = '-';\n    $CODONGAP = $GAP x CODONSIZE;\n}\n\n=head2 aa_to_dna_aln\n\n Title   : aa_to_dna_aln\n Usage   : my $dnaaln = aa_to_dna_aln($aa_aln, \\%seqs);\n Function: Will convert an AA alignment to DNA space given the \n           corresponding DNA sequences.  Note that this method expects \n           the DNA sequences to be in frame +1 (GFF frame 0) as it will\n           start to project into coordinates starting at the first base of \n           the DNA sequence, if this alignment represents a different \n           frame for the cDNA you will need to edit the DNA sequences\n           to remove the 1st or 2nd bases (and revcom if things should be).\n Returns : Bio::Align::AlignI object \n Args    : 2 arguments, the alignment and a hashref.\n           Alignment is a Bio::Align::AlignI of amino acid sequences. \n           The hash reference should have keys which are \n           the display_ids for the aa \n           sequences in the alignment and the values are a \n           Bio::PrimarySeqI object for the corresponding \n           spliced cDNA sequence. \n\nSee also: L<Bio::Align::AlignI>, L<Bio::SimpleAlign>, L<Bio::PrimarySeq>","parameters":[{"label":"$aln"},{"label":"$dnaseqs"}],"label":"aa_to_dna_aln($aln,$dnaseqs)"},"detail":"($aln,$dnaseqs)","definition":"sub","containerName":"main::"},{"kind":12,"line":141,"name":"croak"},{"name":"Bio","containerName":"SimpleAlign","kind":12,"line":144},{"kind":12,"line":152,"name":"CODONSIZE"},{"line":163,"kind":12,"name":"CODONSIZE"},{"kind":12,"line":164,"name":"CODONSIZE"},{"containerName":"LocatableSeq","name":"Bio","kind":12,"line":169},{"kind":12,"line":173,"name":"CODONSIZE"},{"range":{"end":{"line":227,"character":9999},"start":{"character":0,"line":194}},"name":"bootstrap_replicates","detail":"($aln,$count)","signature":{"documentation":"1;\n# $Id: Utilities.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::Utilities\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::Utilities - A collection of utilities regarding converting\nand manipulating alignment objects\n\n=head1 SYNOPSIS\n\n  use Bio::Align::Utilities qw(:all);\n  # %dnaseqs is a hash of CDS sequences (spliced)\n\n\n  # Even if the protein alignments are local make sure the start/end\n  # stored in the LocatableSeq objects are to the full length protein.\n  # The CoDing Sequence that is passed in should still be the full \n  # length CDS as the nt alignment will be generated.\n  #\n  my $dna_aln = &aa_to_dna_aln($aa_aln,\\%dnaseqs);\n\n\n  # generate bootstraps\n  my $replicates = &bootstrap_replicates($aln,$count);\n\n\n=head1 DESCRIPTION\n\nThis module contains utility methods for manipulating sequence\nalignments ( L<Bio::Align::AlignI>) objects.\n\nThe B<aa_to_dna_aln> utility is essentially the same as the B<mrtrans>\nprogram by Bill Pearson available at\nftp://ftp.virginia.edu/pub/fasta/other/mrtrans.shar.  Of course this\nis a pure-perl implementation, but just to mention that if anything\nseems odd you can check the alignments generated against Bill's\nprogram.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n#' keep my emacs happy\n# Let the code begin...\n\n\npackage Bio::Align::Utilities;\nuse vars qw(@EXPORT @EXPORT_OK $GAP $CODONGAP %EXPORT_TAGS);\nuse strict;\nuse Carp;\nuse Bio::Root::Version;\nrequire Exporter;\n\nuse base qw(Exporter);\n\n@EXPORT = qw();\n@EXPORT_OK = qw(aa_to_dna_aln bootstrap_replicates cat);\n%EXPORT_TAGS = (all =>[@EXPORT, @EXPORT_OK]);\nBEGIN {\n    use constant CODONSIZE => 3;\n    $GAP = '-';\n    $CODONGAP = $GAP x CODONSIZE;\n}\n\n=head2 aa_to_dna_aln\n\n Title   : aa_to_dna_aln\n Usage   : my $dnaaln = aa_to_dna_aln($aa_aln, \\%seqs);\n Function: Will convert an AA alignment to DNA space given the \n           corresponding DNA sequences.  Note that this method expects \n           the DNA sequences to be in frame +1 (GFF frame 0) as it will\n           start to project into coordinates starting at the first base of \n           the DNA sequence, if this alignment represents a different \n           frame for the cDNA you will need to edit the DNA sequences\n           to remove the 1st or 2nd bases (and revcom if things should be).\n Returns : Bio::Align::AlignI object \n Args    : 2 arguments, the alignment and a hashref.\n           Alignment is a Bio::Align::AlignI of amino acid sequences. \n           The hash reference should have keys which are \n           the display_ids for the aa \n           sequences in the alignment and the values are a \n           Bio::PrimarySeqI object for the corresponding \n           spliced cDNA sequence. \n\nSee also: L<Bio::Align::AlignI>, L<Bio::SimpleAlign>, L<Bio::PrimarySeq>\n\n\nsub aa_to_dna_aln {\n    my ($aln,$dnaseqs) = @_;\n    unless( defined $aln && \n\t    ref($aln) &&\n\t    $aln->isa('Bio::Align::AlignI') ) { \n\tcroak('Must provide a valid Bio::Align::AlignI object as the first argument to aa_to_dna_aln, see the documentation for proper usage and the method signature');\n    }\n    my $alnlen = $aln->length;\n    my $dnaalign = Bio::SimpleAlign->new();\n    $aln->map_chars('\\.',$GAP);\n\n    foreach my $seq ( $aln->each_seq ) {    \n\tmy $aa_seqstr = $seq->seq();\n\tmy $id = $seq->display_id;\n\tmy $dnaseq = $dnaseqs->{$id} || $aln->throw(\"cannot find \".\n\t\t\t\t\t\t     $seq->display_id);\n\tmy $start_offset = ($seq->start - 1) * CODONSIZE;\n\n\t$dnaseq = $dnaseq->seq();\n\tmy $dnalen = $dnaseqs->{$id}->length;\n\tmy $nt_seqstr;\n\tmy $j = 0;\n\tfor( my $i = 0; $i < $alnlen; $i++ ) {\n\t    my $char = substr($aa_seqstr,$i + $start_offset,1);\t    \n\t    if ( $char eq $GAP || $j >= $dnalen )  { \n\t\t$nt_seqstr .= $CODONGAP;\n\t    } else {\n\t\t$nt_seqstr .= substr($dnaseq,$j,CODONSIZE);\n\t\t$j += CODONSIZE;\n\t    }\n\t}\n\t$nt_seqstr .= $GAP x (($alnlen * 3) - length($nt_seqstr));\n\n\tmy $newdna = Bio::LocatableSeq->new(-display_id  => $id,\n\t\t\t\t\t   -alphabet    => 'dna',\n\t\t\t\t\t   -start       => $start_offset+1,\n\t\t\t\t\t   -end         => ($seq->end * \n\t\t\t\t\t\t\t    CODONSIZE),\n\t\t\t\t\t   -strand      => 1,\n\t\t\t\t\t   -seq         => $nt_seqstr);    \n\t$dnaalign->add_seq($newdna);\n    }\n    return $dnaalign;\n}\n\n=head2 bootstrap_replicates\n\n Title   : bootstrap_replicates\n Usage   : my $alns = &bootstrap_replicates($aln,100);\n Function: Generate a pseudo-replicate of the data by randomly\n           sampling, with replacement, the columns from an alignment for\n           the non-parametric bootstrap.\n Returns : Arrayref of L<Bio::SimpleAlign> objects\n Args    : L<Bio::SimpleAlign> object\n           Number of replicates to generate","parameters":[{"label":"$aln"},{"label":"$count"}],"label":"bootstrap_replicates($aln,$count)"},"containerName":"main::","definition":"sub","line":194,"children":[{"line":195,"kind":13,"localvar":"my","containerName":"bootstrap_replicates","definition":"my","name":"$aln"},{"line":195,"kind":13,"name":"$count","containerName":"bootstrap_replicates"},{"kind":13,"line":196,"containerName":"bootstrap_replicates","name":"$count"},{"containerName":"bootstrap_replicates","definition":"my","name":"$alen","localvar":"my","kind":13,"line":197},{"kind":13,"line":197,"containerName":"bootstrap_replicates","name":"$aln"},{"containerName":"bootstrap_replicates","name":"length","line":197,"kind":12},{"line":198,"kind":13,"localvar":"my","definition":"my","name":"@seqs","containerName":"bootstrap_replicates"},{"line":198,"kind":13,"name":"@nm","containerName":"bootstrap_replicates"},{"name":"$aln","containerName":"bootstrap_replicates","kind":13,"line":199},{"name":"set_displayname_flat","containerName":"bootstrap_replicates","line":199,"kind":12},{"name":"$s","definition":"my","containerName":"bootstrap_replicates","localvar":"my","kind":13,"line":200},{"name":"$aln","containerName":"bootstrap_replicates","kind":13,"line":200},{"name":"each_seq","containerName":"bootstrap_replicates","kind":12,"line":200},{"name":"@seqs","containerName":"bootstrap_replicates","kind":13,"line":201},{"containerName":"bootstrap_replicates","name":"$s","line":201,"kind":13},{"containerName":"bootstrap_replicates","name":"seq","kind":12,"line":201},{"kind":13,"line":202,"containerName":"bootstrap_replicates","name":"@nm"},{"kind":13,"line":202,"containerName":"bootstrap_replicates","name":"$s"},{"line":202,"kind":12,"name":"id","containerName":"bootstrap_replicates"},{"localvar":"my","containerName":"bootstrap_replicates","definition":"my","name":"@alns","line":204,"kind":13},{"containerName":"bootstrap_replicates","name":"$i","line":204,"kind":13},{"name":"$count","containerName":"bootstrap_replicates","line":205,"kind":13},{"line":206,"kind":13,"localvar":"my","definition":"my","name":"@newseqs","containerName":"bootstrap_replicates"},{"name":"$i","containerName":"bootstrap_replicates","line":207,"kind":13},{"name":"$i","containerName":"bootstrap_replicates","line":207,"kind":13},{"name":"$alen","containerName":"bootstrap_replicates","line":207,"kind":13},{"kind":13,"line":207,"name":"$i","containerName":"bootstrap_replicates"},{"line":208,"kind":13,"localvar":"my","definition":"my","name":"$index","containerName":"bootstrap_replicates"},{"containerName":"bootstrap_replicates","name":"$alen","kind":13,"line":208},{"localvar":"my","containerName":"bootstrap_replicates","name":"$c","definition":"my","line":209,"kind":13},{"line":210,"kind":13,"name":"@seqs","containerName":"bootstrap_replicates"},{"kind":13,"line":211,"containerName":"bootstrap_replicates","name":"$newseqs"},{"kind":13,"line":211,"containerName":"bootstrap_replicates","name":"$c"},{"name":"$index","containerName":"bootstrap_replicates","kind":13,"line":211},{"localvar":"my","definition":"my","name":"$newaln","containerName":"bootstrap_replicates","line":214,"kind":13},{"name":"new","containerName":"bootstrap_replicates","line":214,"kind":12},{"kind":13,"line":215,"containerName":"bootstrap_replicates","definition":"my","name":"$i","localvar":"my"},{"line":216,"kind":13,"localvar":"my","containerName":"bootstrap_replicates","definition":"my","name":"$s"},{"name":"@newseqs","containerName":"bootstrap_replicates","kind":13,"line":216},{"kind":13,"line":217,"containerName":"bootstrap_replicates","name":"$tmp","definition":"my","localvar":"my"},{"name":"$s","containerName":"bootstrap_replicates","kind":13,"line":217},{"kind":13,"line":218,"name":"$newaln","containerName":"bootstrap_replicates"},{"containerName":"bootstrap_replicates","name":"add_seq","line":218,"kind":12},{"kind":12,"line":219,"containerName":"bootstrap_replicates","name":"new"},{"line":220,"kind":13,"name":"$tmp","containerName":"bootstrap_replicates"},{"kind":13,"line":221,"containerName":"bootstrap_replicates","name":"$nm"},{"kind":13,"line":221,"containerName":"bootstrap_replicates","name":"$i"},{"name":"$s","containerName":"bootstrap_replicates","line":222,"kind":13},{"containerName":"bootstrap_replicates","name":"@alns","kind":13,"line":224},{"containerName":"bootstrap_replicates","name":"$newaln","line":224,"kind":13},{"containerName":"bootstrap_replicates","name":"@alns","kind":13,"line":226}],"kind":12},{"name":"Bio","containerName":"SimpleAlign","line":214,"kind":12},{"containerName":"LocatableSeq","name":"Bio","kind":12,"line":218},{"line":246,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"cat","line":247,"kind":13},{"line":247,"kind":13,"name":"@aln","containerName":"cat"},{"name":"$self","containerName":"cat","kind":13,"line":248},{"line":248,"kind":12,"containerName":"cat","name":"throw"},{"kind":13,"line":248,"name":"$self","containerName":"cat"},{"name":"$self","containerName":"cat","line":249,"kind":13},{"kind":13,"line":249,"containerName":"cat","name":"@aln"},{"containerName":"cat","name":"$self","line":250,"kind":13},{"name":"throw","containerName":"cat","kind":12,"line":250},{"name":"id","containerName":"cat","kind":12,"line":250},{"kind":12,"line":250,"containerName":"cat","name":"isa"},{"containerName":"cat","name":"$self","line":251,"kind":13},{"line":251,"kind":12,"name":"throw","containerName":"cat"},{"line":251,"kind":12,"containerName":"cat","name":"id"},{"line":251,"kind":12,"containerName":"cat","name":"is_flush"},{"line":253,"kind":13,"localvar":"my","containerName":"cat","definition":"my","name":"$aln"},{"containerName":"cat","name":"$self","kind":13,"line":253},{"name":"new","containerName":"cat","line":253,"kind":12},{"containerName":"cat","name":"$aln","line":254,"kind":13},{"containerName":"cat","name":"id","line":254,"kind":12},{"containerName":"cat","name":"$self","kind":13,"line":254},{"line":254,"kind":12,"containerName":"cat","name":"id"},{"containerName":"cat","name":"$aln","line":255,"kind":13},{"containerName":"cat","name":"annotation","line":255,"kind":12},{"name":"$self","containerName":"cat","kind":13,"line":255},{"line":255,"kind":12,"containerName":"cat","name":"annotation"},{"line":256,"kind":13,"localvar":"my","definition":"my","name":"%unique","containerName":"cat"},{"kind":13,"line":257,"containerName":"cat","name":"$seq","definition":"my","localvar":"my"},{"kind":13,"line":257,"containerName":"cat","name":"$self"},{"kind":12,"line":257,"name":"each_seq","containerName":"cat"},{"kind":13,"line":258,"name":"$seq","containerName":"cat"},{"kind":12,"line":258,"containerName":"cat","name":"id"},{"line":258,"kind":13,"name":"$unique","containerName":"cat"},{"kind":13,"line":258,"containerName":"cat","name":"$seq"},{"containerName":"cat","name":"id","kind":12,"line":258},{"containerName":"cat","name":"$unique","line":259,"kind":13},{"kind":13,"line":259,"containerName":"cat","name":"$seq"},{"name":"id","containerName":"cat","line":259,"kind":12},{"line":262,"kind":13,"localvar":"my","name":"$new_seq","definition":"my","containerName":"cat"},{"name":"$seq","containerName":"cat","kind":13,"line":262},{"name":"new","containerName":"cat","kind":12,"line":262},{"containerName":"cat","name":"$seq","line":262,"kind":13},{"containerName":"cat","name":"id","line":262,"kind":12},{"containerName":"cat","name":"$seq","kind":13,"line":263},{"name":"strand","containerName":"cat","line":263,"kind":12},{"containerName":"cat","name":"$self","kind":13,"line":264},{"name":"verbose","containerName":"cat","line":264,"kind":12},{"containerName":"cat","name":"$new_seq","line":265,"kind":13},{"line":265,"kind":12,"containerName":"cat","name":"seq"},{"line":265,"kind":13,"containerName":"cat","name":"$seq"},{"line":265,"kind":12,"containerName":"cat","name":"seq"},{"kind":13,"line":266,"name":"$new_seq","containerName":"cat"},{"kind":12,"line":266,"containerName":"cat","name":"start"},{"kind":13,"line":266,"name":"$seq","containerName":"cat"},{"containerName":"cat","name":"start","kind":12,"line":266},{"line":267,"kind":13,"name":"$new_seq","containerName":"cat"},{"name":"end","containerName":"cat","kind":12,"line":267},{"line":267,"kind":13,"containerName":"cat","name":"$seq"},{"kind":12,"line":267,"name":"end","containerName":"cat"},{"kind":13,"line":268,"containerName":"cat","name":"$new_seq"},{"line":268,"kind":12,"containerName":"cat","name":"isa"},{"kind":13,"line":269,"containerName":"cat","name":"$meta_name","definition":"my","localvar":"my"},{"kind":13,"line":269,"containerName":"cat","name":"$seq"},{"containerName":"cat","name":"meta_names","line":269,"kind":12},{"kind":13,"line":270,"containerName":"cat","name":"$new_seq"},{"kind":12,"line":270,"containerName":"cat","name":"named_submeta"},{"name":"$meta_name","containerName":"cat","line":270,"kind":13},{"name":"$new_seq","containerName":"cat","kind":13,"line":270},{"line":270,"kind":12,"name":"start","containerName":"cat"},{"containerName":"cat","name":"$new_seq","line":270,"kind":13},{"name":"end","containerName":"cat","line":270,"kind":12},{"name":"$seq","containerName":"cat","line":270,"kind":13},{"name":"named_meta","containerName":"cat","kind":12,"line":270},{"line":270,"kind":13,"name":"$meta_name","containerName":"cat"},{"line":273,"kind":13,"localvar":"my","definition":"my","name":"$cat_aln","containerName":"cat"},{"name":"@aln","containerName":"cat","kind":13,"line":273},{"containerName":"cat","name":"@cat_seq","definition":"my","localvar":"my","kind":13,"line":274},{"kind":13,"line":274,"containerName":"cat","name":"$cat_aln"},{"name":"each_seq_with_id","containerName":"cat","line":274,"kind":12},{"kind":13,"line":274,"name":"$seq","containerName":"cat"},{"line":274,"kind":12,"containerName":"cat","name":"id"},{"line":275,"kind":13,"name":"@cat_seq","containerName":"cat"},{"kind":13,"line":276,"containerName":"cat","name":"$self"},{"containerName":"cat","name":"warn","line":276,"kind":12},{"containerName":"cat","name":"$seq","kind":13,"line":276},{"kind":12,"line":276,"name":"id","containerName":"cat"},{"name":"$cat_aln","containerName":"cat","kind":13,"line":276},{"kind":12,"line":276,"containerName":"cat","name":"id"},{"containerName":"cat","name":"@cat_seq","kind":13,"line":279},{"line":280,"kind":13,"name":"$self","containerName":"cat"},{"name":"warn","containerName":"cat","line":280,"kind":12},{"kind":13,"line":280,"name":"$seq","containerName":"cat"},{"containerName":"cat","name":"id","kind":12,"line":280},{"kind":13,"line":280,"containerName":"cat","name":"$cat_aln"},{"containerName":"cat","name":"id","kind":12,"line":280},{"line":283,"kind":13,"localvar":"my","definition":"my","name":"$cat_seq","containerName":"cat"},{"containerName":"cat","name":"$cat_seq","kind":13,"line":283},{"line":284,"kind":13,"localvar":"my","definition":"my","name":"$old_end","containerName":"cat"},{"line":284,"kind":13,"containerName":"cat","name":"$new_seq"},{"containerName":"cat","name":"end","kind":12,"line":284},{"kind":13,"line":285,"name":"$new_seq","containerName":"cat"},{"line":285,"kind":12,"containerName":"cat","name":"seq"},{"containerName":"cat","name":"$new_seq","line":285,"kind":13},{"name":"seq","containerName":"cat","line":285,"kind":12},{"kind":13,"line":285,"name":"$cat_seq","containerName":"cat"},{"containerName":"cat","name":"seq","kind":12,"line":285},{"kind":13,"line":288,"name":"$new_seq","containerName":"cat"},{"kind":12,"line":288,"name":"end","containerName":"cat"},{"kind":13,"line":288,"containerName":"cat","name":"$new_seq"},{"kind":12,"line":288,"containerName":"cat","name":"end"},{"kind":13,"line":288,"containerName":"cat","name":"$cat_seq"},{"containerName":"cat","name":"end","line":288,"kind":12},{"name":"$cat_seq","containerName":"cat","line":288,"kind":13},{"containerName":"cat","name":"start","line":288,"kind":12},{"line":290,"kind":13,"name":"$cat_seq","containerName":"cat"},{"containerName":"cat","name":"isa","kind":12,"line":290},{"line":291,"kind":13,"name":"$new_seq","containerName":"cat"},{"kind":12,"line":291,"name":"isa","containerName":"cat"},{"definition":"my","name":"$meta_seq","containerName":"cat","localvar":"my","kind":13,"line":292},{"name":"new","containerName":"cat","line":292,"kind":12},{"kind":13,"line":293,"containerName":"cat","name":"$meta_seq"},{"kind":12,"line":293,"containerName":"cat","name":"seq"},{"line":293,"kind":13,"containerName":"cat","name":"$new_seq"},{"kind":12,"line":293,"name":"seq","containerName":"cat"},{"name":"$meta_seq","containerName":"cat","kind":13,"line":294},{"line":294,"kind":12,"name":"start","containerName":"cat"},{"line":294,"kind":13,"containerName":"cat","name":"$new_seq"},{"kind":12,"line":294,"name":"start","containerName":"cat"},{"line":295,"kind":13,"containerName":"cat","name":"$meta_seq"},{"name":"end","containerName":"cat","kind":12,"line":295},{"containerName":"cat","name":"$new_seq","line":295,"kind":13},{"line":295,"kind":12,"name":"end","containerName":"cat"},{"containerName":"cat","name":"$new_seq","kind":13,"line":296},{"containerName":"cat","name":"isa","line":296,"kind":12},{"containerName":"cat","name":"$meta_name","definition":"my","localvar":"my","kind":13,"line":297},{"kind":13,"line":297,"containerName":"cat","name":"$new_seq"},{"name":"meta_names","containerName":"cat","kind":12,"line":297},{"containerName":"cat","name":"$meta_seq","kind":13,"line":298},{"kind":12,"line":298,"containerName":"cat","name":"named_submeta"},{"containerName":"cat","name":"$meta_name","kind":13,"line":298},{"line":299,"kind":13,"containerName":"cat","name":"$new_seq"},{"line":299,"kind":12,"name":"start","containerName":"cat"},{"name":"$old_end","containerName":"cat","line":300,"kind":13},{"kind":13,"line":301,"name":"$new_seq","containerName":"cat"},{"line":301,"kind":12,"name":"named_meta","containerName":"cat"},{"line":301,"kind":13,"name":"$meta_name","containerName":"cat"},{"containerName":"cat","name":"$new_seq","kind":13,"line":305},{"name":"$meta_seq","containerName":"cat","line":305,"kind":13},{"line":307,"kind":13,"localvar":"my","name":"$meta_name","definition":"my","containerName":"cat"},{"kind":13,"line":307,"containerName":"cat","name":"$cat_seq"},{"containerName":"cat","name":"meta_names","kind":12,"line":307},{"line":308,"kind":13,"containerName":"cat","name":"$new_seq"},{"name":"named_submeta","containerName":"cat","line":308,"kind":12},{"line":308,"kind":13,"containerName":"cat","name":"$meta_name"},{"containerName":"cat","name":"$old_end","line":309,"kind":13},{"name":"$new_seq","containerName":"cat","line":310,"kind":13},{"line":310,"kind":12,"containerName":"cat","name":"end"},{"containerName":"cat","name":"$cat_seq","kind":13,"line":311},{"name":"named_meta","containerName":"cat","line":311,"kind":12},{"line":311,"kind":13,"name":"$meta_name","containerName":"cat"},{"line":314,"kind":13,"name":"$cat_seq","containerName":"cat"},{"containerName":"cat","name":"isa","line":314,"kind":12},{"kind":13,"line":315,"name":"$new_seq","containerName":"cat"},{"name":"isa","containerName":"cat","line":315,"kind":12},{"localvar":"my","definition":"my","name":"$meta_name","containerName":"cat","line":316,"kind":13},{"kind":13,"line":316,"name":"$cat_seq","containerName":"cat"},{"name":"meta_names","containerName":"cat","line":316,"kind":12},{"containerName":"cat","name":"$new_seq","line":317,"kind":13},{"kind":12,"line":317,"containerName":"cat","name":"named_submeta"},{"containerName":"cat","name":"$meta_name","line":317,"kind":13},{"name":"$old_end","containerName":"cat","kind":13,"line":318},{"name":"$new_seq","containerName":"cat","kind":13,"line":319},{"name":"end","containerName":"cat","line":319,"kind":12},{"line":320,"kind":13,"name":"$cat_seq","containerName":"cat"},{"containerName":"cat","name":"named_meta","kind":12,"line":320},{"kind":13,"line":320,"containerName":"cat","name":"$meta_name"},{"name":"$new_seq","containerName":"cat","line":324,"kind":13},{"line":324,"kind":12,"containerName":"cat","name":"isa"},{"line":325,"kind":13,"localvar":"my","definition":"my","name":"$meta_seq","containerName":"cat"},{"line":325,"kind":12,"name":"new","containerName":"cat"},{"name":"$meta_seq","containerName":"cat","line":326,"kind":13},{"name":"seq","containerName":"cat","kind":12,"line":326},{"kind":13,"line":326,"containerName":"cat","name":"$new_seq"},{"containerName":"cat","name":"seq","kind":12,"line":326},{"containerName":"cat","name":"$meta_seq","line":327,"kind":13},{"line":327,"kind":12,"containerName":"cat","name":"start"},{"name":"$new_seq","containerName":"cat","kind":13,"line":327},{"containerName":"cat","name":"start","kind":12,"line":327},{"line":328,"kind":13,"containerName":"cat","name":"$meta_seq"},{"kind":12,"line":328,"name":"end","containerName":"cat"},{"kind":13,"line":328,"name":"$new_seq","containerName":"cat"},{"containerName":"cat","name":"end","line":328,"kind":12},{"containerName":"cat","name":"$new_seq","kind":13,"line":329},{"containerName":"cat","name":"$meta_seq","line":329,"kind":13},{"line":331,"kind":13,"localvar":"my","containerName":"cat","name":"$meta_name","definition":"my"},{"line":331,"kind":13,"containerName":"cat","name":"$cat_seq"},{"kind":12,"line":331,"name":"meta_names","containerName":"cat"},{"containerName":"cat","name":"$new_seq","kind":13,"line":332},{"containerName":"cat","name":"named_submeta","kind":12,"line":332},{"kind":13,"line":332,"containerName":"cat","name":"$meta_name"},{"name":"$old_end","containerName":"cat","line":333,"kind":13},{"name":"$new_seq","containerName":"cat","kind":13,"line":334},{"name":"end","containerName":"cat","kind":12,"line":334},{"kind":13,"line":335,"name":"$cat_seq","containerName":"cat"},{"containerName":"cat","name":"named_meta","kind":12,"line":335},{"name":"$meta_name","containerName":"cat","line":335,"kind":13},{"line":341,"kind":13,"containerName":"cat","name":"$aln"},{"containerName":"cat","name":"add_seq","kind":12,"line":341},{"containerName":"cat","name":"$new_seq","kind":13,"line":341},{"line":343,"kind":13,"localvar":"my","containerName":"cat","definition":"my","name":"$cons_meta"},{"kind":13,"line":343,"containerName":"cat","name":"$self"},{"line":343,"kind":12,"containerName":"cat","name":"consensus_meta"},{"name":"$new_cons_meta","definition":"my","containerName":"cat","localvar":"my","kind":13,"line":344},{"kind":13,"line":345,"name":"$cons_meta","containerName":"cat"},{"kind":13,"line":346,"name":"$new_cons_meta","containerName":"cat"},{"name":"new","containerName":"cat","line":346,"kind":12},{"line":347,"kind":13,"localvar":"my","definition":"my","name":"$meta_name","containerName":"cat"},{"kind":13,"line":347,"name":"$cons_meta","containerName":"cat"},{"name":"meta_names","containerName":"cat","kind":12,"line":347},{"containerName":"cat","name":"$new_cons_meta","line":348,"kind":13},{"kind":12,"line":348,"name":"named_submeta","containerName":"cat"},{"name":"$meta_name","containerName":"cat","line":348,"kind":13},{"kind":13,"line":348,"containerName":"cat","name":"$self"},{"line":348,"kind":12,"containerName":"cat","name":"length"},{"line":348,"kind":13,"containerName":"cat","name":"$cons_meta"},{"name":"$meta_name","containerName":"cat","kind":13,"line":348},{"localvar":"my","containerName":"cat","definition":"my","name":"$end","line":351,"kind":13},{"line":351,"kind":13,"containerName":"cat","name":"$self"},{"kind":12,"line":351,"name":"length","containerName":"cat"},{"kind":13,"line":352,"containerName":"cat","name":"$cat_aln","definition":"my","localvar":"my"},{"name":"@aln","containerName":"cat","kind":13,"line":352},{"line":353,"kind":13,"localvar":"my","name":"$cat_cons_meta","definition":"my","containerName":"cat"},{"kind":13,"line":353,"name":"$cat_aln","containerName":"cat"},{"kind":12,"line":353,"name":"consensus_meta","containerName":"cat"},{"containerName":"cat","name":"$cat_cons_meta","line":354,"kind":13},{"containerName":"cat","name":"$new_cons_meta","line":355,"kind":13},{"containerName":"cat","name":"new","line":355,"kind":12},{"line":355,"kind":13,"containerName":"cat","name":"$new_cons_meta"},{"containerName":"cat","name":"$meta_name","definition":"my","localvar":"my","kind":13,"line":356},{"name":"$cat_cons_meta","containerName":"cat","kind":13,"line":356},{"name":"meta_names","containerName":"cat","kind":12,"line":356},{"name":"$new_cons_meta","containerName":"cat","line":357,"kind":13},{"containerName":"cat","name":"named_submeta","line":357,"kind":12},{"name":"$meta_name","containerName":"cat","line":357,"kind":13},{"name":"$end","containerName":"cat","line":357,"kind":13},{"containerName":"cat","name":"$end","kind":13,"line":357},{"kind":13,"line":357,"containerName":"cat","name":"$cat_aln"},{"name":"length","containerName":"cat","line":357,"kind":12},{"containerName":"cat","name":"$cat_cons_meta","line":357,"kind":13},{"kind":13,"line":357,"name":"$meta_name","containerName":"cat"},{"line":360,"kind":13,"containerName":"cat","name":"$end"},{"line":360,"kind":13,"name":"$cat_aln","containerName":"cat"},{"line":360,"kind":12,"containerName":"cat","name":"length"},{"containerName":"cat","name":"$aln","line":362,"kind":13},{"kind":12,"line":362,"containerName":"cat","name":"consensus_meta"},{"containerName":"cat","name":"$new_cons_meta","kind":13,"line":362},{"kind":13,"line":362,"containerName":"cat","name":"$new_cons_meta"},{"containerName":"cat","name":"$aln","line":363,"kind":13}],"kind":12,"detail":"($self,@aln)","signature":{"label":"cat($self,@aln)","documentation":"1;\n# $Id: Utilities.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::Utilities\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::Utilities - A collection of utilities regarding converting\nand manipulating alignment objects\n\n=head1 SYNOPSIS\n\n  use Bio::Align::Utilities qw(:all);\n  # %dnaseqs is a hash of CDS sequences (spliced)\n\n\n  # Even if the protein alignments are local make sure the start/end\n  # stored in the LocatableSeq objects are to the full length protein.\n  # The CoDing Sequence that is passed in should still be the full \n  # length CDS as the nt alignment will be generated.\n  #\n  my $dna_aln = &aa_to_dna_aln($aa_aln,\\%dnaseqs);\n\n\n  # generate bootstraps\n  my $replicates = &bootstrap_replicates($aln,$count);\n\n\n=head1 DESCRIPTION\n\nThis module contains utility methods for manipulating sequence\nalignments ( L<Bio::Align::AlignI>) objects.\n\nThe B<aa_to_dna_aln> utility is essentially the same as the B<mrtrans>\nprogram by Bill Pearson available at\nftp://ftp.virginia.edu/pub/fasta/other/mrtrans.shar.  Of course this\nis a pure-perl implementation, but just to mention that if anything\nseems odd you can check the alignments generated against Bill's\nprogram.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n#' keep my emacs happy\n# Let the code begin...\n\n\npackage Bio::Align::Utilities;\nuse vars qw(@EXPORT @EXPORT_OK $GAP $CODONGAP %EXPORT_TAGS);\nuse strict;\nuse Carp;\nuse Bio::Root::Version;\nrequire Exporter;\n\nuse base qw(Exporter);\n\n@EXPORT = qw();\n@EXPORT_OK = qw(aa_to_dna_aln bootstrap_replicates cat);\n%EXPORT_TAGS = (all =>[@EXPORT, @EXPORT_OK]);\nBEGIN {\n    use constant CODONSIZE => 3;\n    $GAP = '-';\n    $CODONGAP = $GAP x CODONSIZE;\n}\n\n=head2 aa_to_dna_aln\n\n Title   : aa_to_dna_aln\n Usage   : my $dnaaln = aa_to_dna_aln($aa_aln, \\%seqs);\n Function: Will convert an AA alignment to DNA space given the \n           corresponding DNA sequences.  Note that this method expects \n           the DNA sequences to be in frame +1 (GFF frame 0) as it will\n           start to project into coordinates starting at the first base of \n           the DNA sequence, if this alignment represents a different \n           frame for the cDNA you will need to edit the DNA sequences\n           to remove the 1st or 2nd bases (and revcom if things should be).\n Returns : Bio::Align::AlignI object \n Args    : 2 arguments, the alignment and a hashref.\n           Alignment is a Bio::Align::AlignI of amino acid sequences. \n           The hash reference should have keys which are \n           the display_ids for the aa \n           sequences in the alignment and the values are a \n           Bio::PrimarySeqI object for the corresponding \n           spliced cDNA sequence. \n\nSee also: L<Bio::Align::AlignI>, L<Bio::SimpleAlign>, L<Bio::PrimarySeq>\n\n\nsub aa_to_dna_aln {\n    my ($aln,$dnaseqs) = @_;\n    unless( defined $aln && \n\t    ref($aln) &&\n\t    $aln->isa('Bio::Align::AlignI') ) { \n\tcroak('Must provide a valid Bio::Align::AlignI object as the first argument to aa_to_dna_aln, see the documentation for proper usage and the method signature');\n    }\n    my $alnlen = $aln->length;\n    my $dnaalign = Bio::SimpleAlign->new();\n    $aln->map_chars('\\.',$GAP);\n\n    foreach my $seq ( $aln->each_seq ) {    \n\tmy $aa_seqstr = $seq->seq();\n\tmy $id = $seq->display_id;\n\tmy $dnaseq = $dnaseqs->{$id} || $aln->throw(\"cannot find \".\n\t\t\t\t\t\t     $seq->display_id);\n\tmy $start_offset = ($seq->start - 1) * CODONSIZE;\n\n\t$dnaseq = $dnaseq->seq();\n\tmy $dnalen = $dnaseqs->{$id}->length;\n\tmy $nt_seqstr;\n\tmy $j = 0;\n\tfor( my $i = 0; $i < $alnlen; $i++ ) {\n\t    my $char = substr($aa_seqstr,$i + $start_offset,1);\t    \n\t    if ( $char eq $GAP || $j >= $dnalen )  { \n\t\t$nt_seqstr .= $CODONGAP;\n\t    } else {\n\t\t$nt_seqstr .= substr($dnaseq,$j,CODONSIZE);\n\t\t$j += CODONSIZE;\n\t    }\n\t}\n\t$nt_seqstr .= $GAP x (($alnlen * 3) - length($nt_seqstr));\n\n\tmy $newdna = Bio::LocatableSeq->new(-display_id  => $id,\n\t\t\t\t\t   -alphabet    => 'dna',\n\t\t\t\t\t   -start       => $start_offset+1,\n\t\t\t\t\t   -end         => ($seq->end * \n\t\t\t\t\t\t\t    CODONSIZE),\n\t\t\t\t\t   -strand      => 1,\n\t\t\t\t\t   -seq         => $nt_seqstr);    \n\t$dnaalign->add_seq($newdna);\n    }\n    return $dnaalign;\n}\n\n=head2 bootstrap_replicates\n\n Title   : bootstrap_replicates\n Usage   : my $alns = &bootstrap_replicates($aln,100);\n Function: Generate a pseudo-replicate of the data by randomly\n           sampling, with replacement, the columns from an alignment for\n           the non-parametric bootstrap.\n Returns : Arrayref of L<Bio::SimpleAlign> objects\n Args    : L<Bio::SimpleAlign> object\n           Number of replicates to generate\n\n\nsub bootstrap_replicates {\n   my ($aln,$count) = @_;\n   $count ||= 1;\n   my $alen = $aln->length;\n   my (@seqs,@nm);\n   $aln->set_displayname_flat(1);\n   for my $s ( $aln->each_seq ) {\n       push @seqs, $s->seq();\n       push @nm, $s->id;\n   }\n   my (@alns,$i);\n   while( $count-- > 0 ) {\n       my @newseqs;\n       for($i =0; $i < $alen; $i++ ) {\n\t   my $index = int(rand($alen));\n\t   my $c = 0;\n\t   for ( @seqs ) {\n\t       $newseqs[$c++] .= substr($_,$index,1);\n\t   }\n       }\n       my $newaln = Bio::SimpleAlign->new();\n       my $i = 0;\n       for my $s ( @newseqs ) {\n       (my $tmp = $s) =~ s{[$Bio::LocatableSeq::GAP_SYMBOLS]+}{}g;\n\t   $newaln->add_seq( Bio::LocatableSeq->new\n\t\t\t     (-start         => 1,\n\t\t\t      -end           => length($tmp),\n\t\t\t      -display_id    => $nm[$i++],\n\t\t\t      -seq           => $s));\n       }\n       push @alns, $newaln;\n   }\n   return \\@alns;\n}\n\n=head2 cat\n\n Title     : cat\n Usage     : $aln123 = cat($aln1, $aln2, $aln3)\n Function  : Concatenates alignment objects. Sequences are identified by id.\n             An error will be thrown if the sequence ids are not unique in the\n             first alignment. If any ids are not present or not unique in any\n             of the additional alignments then those sequences are omitted from\n             the concatenated alignment, and a warning is issued. An error will\n             be thrown if any of the alignments are not flush, since\n             concatenating such alignments is unlikely to make biological\n             sense.\n Returns   : A new Bio::SimpleAlign object\n Args      : A list of Bio::SimpleAlign objects","parameters":[{"label":"$self"},{"label":"@aln"}]},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":364},"start":{"line":246,"character":0}},"name":"cat"},{"name":"SEQ","kind":12,"line":257},{"kind":12,"line":258,"name":"throw"},{"name":"SEQ","kind":12,"line":277},{"kind":12,"line":281,"name":"SEQ"},{"containerName":"Seq::Meta::Array","name":"Bio","line":292,"kind":12},{"kind":12,"line":325,"name":"Bio","containerName":"Seq::Meta::Array"},{"line":346,"kind":12,"name":"Bio","containerName":"Seq::Meta"},{"containerName":"Seq::Meta","name":"Bio","line":355,"kind":12}]}