{"vars":[{"kind":2,"line":79,"name":"vars","containerName":""},{"line":83,"kind":13,"containerName":null,"name":"$GapChars"},{"containerName":"","name":"strict","kind":2,"line":83},{"line":85,"kind":2,"name":"base","containerName":""},{"signature":{"documentation":"1;\n# $Id: PairwiseStatistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::PairwiseStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::PairwiseStatistics - Base statistic object for Pairwise Alignments\n\n=head1 SYNOPSIS\n\n  use strict;\n  my $stats = Bio::Align::PairwiseStatistics->new();\n\n  # get alignment object of two sequences somehow\n  my $pwaln;\n  print $stats->number_of_comparable_bases($pwaln);\n  my $score = $stats->score_nuc($pwaln);\n\n\n=head1 DESCRIPTION\n\nCalculate pairwise statistics.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::PairwiseStatistics;\nuse vars qw($GapChars);\nuse strict;\n\n\nBEGIN { $GapChars = '(\\.|\\-)'; }\n\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n=head2 number_of_comparable_bases\n\n Title   : number_of_comparable_bases\n Usage   : my $bases = $stat->number_of_comparable_bases($aln);\n Function: Returns the count of the number of bases that can be\n           compared (L) in this alignment ( length - gaps)\n Returns : integer\n Args    : L<Bio::Align::AlignI>","parameters":[{"label":"$self"},{"label":"$aln"}],"label":"number_of_comparable_bases($self,$aln)"},"detail":"($self,$aln)","definition":"sub","containerName":"main::","children":[{"line":100,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"number_of_comparable_bases"},{"name":"$aln","containerName":"number_of_comparable_bases","line":100,"kind":13},{"line":101,"kind":13,"name":"$aln","containerName":"number_of_comparable_bases"},{"name":"$aln","containerName":"number_of_comparable_bases","kind":13,"line":101},{"containerName":"number_of_comparable_bases","name":"isa","line":101,"kind":12},{"containerName":"number_of_comparable_bases","name":"$self","kind":13,"line":102},{"name":"throw","containerName":"number_of_comparable_bases","kind":12,"line":102},{"kind":13,"line":105,"containerName":"number_of_comparable_bases","name":"$aln"},{"line":105,"kind":12,"containerName":"number_of_comparable_bases","name":"num_sequences"},{"containerName":"number_of_comparable_bases","name":"$self","kind":13,"line":106},{"name":"throw","containerName":"number_of_comparable_bases","line":106,"kind":12},{"line":107,"kind":13,"containerName":"number_of_comparable_bases","name":"$aln"},{"containerName":"number_of_comparable_bases","name":"num_sequences","line":107,"kind":12},{"line":109,"kind":13,"localvar":"my","containerName":"number_of_comparable_bases","name":"$L","definition":"my"},{"kind":13,"line":109,"name":"$aln","containerName":"number_of_comparable_bases"},{"kind":12,"line":109,"name":"length","containerName":"number_of_comparable_bases"},{"containerName":"number_of_comparable_bases","name":"$self","kind":13,"line":109},{"line":109,"kind":12,"name":"number_of_gaps","containerName":"number_of_comparable_bases"},{"name":"$aln","containerName":"number_of_comparable_bases","line":109,"kind":13},{"line":110,"kind":13,"containerName":"number_of_comparable_bases","name":"$L"}],"line":99,"kind":12,"range":{"start":{"character":0,"line":99},"end":{"character":9999,"line":111}},"name":"number_of_comparable_bases"},{"kind":12,"children":[{"definition":"my","name":"$self","containerName":"number_of_differences","localvar":"my","kind":13,"line":125},{"containerName":"number_of_differences","name":"$aln","line":125,"kind":13},{"kind":13,"line":126,"name":"$aln","containerName":"number_of_differences"},{"line":126,"kind":13,"containerName":"number_of_differences","name":"$aln"},{"line":126,"kind":12,"containerName":"number_of_differences","name":"isa"},{"containerName":"number_of_differences","name":"$self","kind":13,"line":127},{"name":"throw","containerName":"number_of_differences","line":127,"kind":12},{"line":129,"kind":13,"containerName":"number_of_differences","name":"$aln"},{"containerName":"number_of_differences","name":"num_sequences","line":129,"kind":12},{"kind":13,"line":130,"containerName":"number_of_differences","name":"$self"},{"line":130,"kind":12,"containerName":"number_of_differences","name":"throw"},{"kind":13,"line":131,"containerName":"number_of_differences","name":"$aln"},{"kind":12,"line":131,"containerName":"number_of_differences","name":"num_sequences"},{"line":133,"kind":13,"localvar":"my","name":"@seqs","definition":"my","containerName":"number_of_differences"},{"kind":13,"line":134,"definition":"my","name":"$seq","containerName":"number_of_differences","localvar":"my"},{"line":134,"kind":13,"name":"$aln","containerName":"number_of_differences"},{"line":134,"kind":12,"name":"each_seq","containerName":"number_of_differences"},{"line":135,"kind":13,"containerName":"number_of_differences","name":"@seqs"},{"line":135,"kind":13,"containerName":"number_of_differences","name":"$seq"},{"kind":12,"line":135,"name":"seq","containerName":"number_of_differences"},{"localvar":"my","definition":"my","name":"$firstseq","containerName":"number_of_differences","line":137,"kind":13},{"line":137,"kind":13,"containerName":"number_of_differences","name":"@seqs"},{"line":139,"kind":13,"localvar":"my","name":"$diffcount","definition":"my","containerName":"number_of_differences"},{"localvar":"my","name":"$i","definition":"my","containerName":"number_of_differences","line":140,"kind":13},{"kind":13,"line":140,"name":"$i","containerName":"number_of_differences"},{"containerName":"number_of_differences","name":"$aln","kind":13,"line":140},{"kind":12,"line":140,"name":"length","containerName":"number_of_differences"},{"kind":13,"line":140,"containerName":"number_of_differences","name":"$i"},{"kind":13,"line":141,"containerName":"number_of_differences","name":"$firstseq"},{"name":"$i","containerName":"number_of_differences","line":141,"kind":13},{"line":142,"kind":13,"localvar":"my","containerName":"number_of_differences","definition":"my","name":"$seq"},{"line":142,"kind":13,"containerName":"number_of_differences","name":"@seqs"},{"name":"$seq","containerName":"number_of_differences","line":143,"kind":13},{"line":143,"kind":13,"containerName":"number_of_differences","name":"$i"},{"kind":13,"line":144,"containerName":"number_of_differences","name":"$firstseq"},{"name":"$i","containerName":"number_of_differences","line":144,"kind":13},{"kind":13,"line":144,"name":"$seq","containerName":"number_of_differences"},{"name":"$i","containerName":"number_of_differences","line":144,"kind":13},{"kind":13,"line":145,"name":"$diffcount","containerName":"number_of_differences"},{"name":"$diffcount","containerName":"number_of_differences","line":149,"kind":13}],"line":124,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$aln"}],"documentation":"1;\n# $Id: PairwiseStatistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::PairwiseStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::PairwiseStatistics - Base statistic object for Pairwise Alignments\n\n=head1 SYNOPSIS\n\n  use strict;\n  my $stats = Bio::Align::PairwiseStatistics->new();\n\n  # get alignment object of two sequences somehow\n  my $pwaln;\n  print $stats->number_of_comparable_bases($pwaln);\n  my $score = $stats->score_nuc($pwaln);\n\n\n=head1 DESCRIPTION\n\nCalculate pairwise statistics.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::PairwiseStatistics;\nuse vars qw($GapChars);\nuse strict;\n\n\nBEGIN { $GapChars = '(\\.|\\-)'; }\n\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n=head2 number_of_comparable_bases\n\n Title   : number_of_comparable_bases\n Usage   : my $bases = $stat->number_of_comparable_bases($aln);\n Function: Returns the count of the number of bases that can be\n           compared (L) in this alignment ( length - gaps)\n Returns : integer\n Args    : L<Bio::Align::AlignI>\n\n\n\nsub number_of_comparable_bases{\n   my ($self,$aln) = @_;\n  if ( ! defined $aln || ! $aln->isa('Bio::Align::AlignI') ) {\n    $self->throw(\"Must provide a Bio::Align::AlignI compliant object to \".\n      \"Bio::Align::PairwiseStatistics\");\n       return 0;\n  } elsif ( $aln->num_sequences != 2 ) { \n    $self->throw(\"Only pairwise calculations supported. Found \".\n      $aln->num_sequences.\" sequences in alignment\\n\");\n   }\n   my $L = $aln->length - $self->number_of_gaps($aln);\n   return $L;\n}\n\n=head2 number_of_differences\n\n Title   : number_of_differences\n Usage   : my $nd = $stat->number_of_distances($aln);\n Function: Returns the number of differences between two sequences\n Returns : integer\n Args    : L<Bio::Align::AlignI>","label":"number_of_differences($self,$aln)"},"detail":"($self,$aln)","name":"number_of_differences","range":{"end":{"line":150,"character":9999},"start":{"character":0,"line":124}}},{"range":{"end":{"line":175,"character":9999},"start":{"line":163,"character":0}},"name":"number_of_gaps","line":163,"children":[{"containerName":"number_of_gaps","definition":"my","name":"$self","localvar":"my","kind":13,"line":164},{"line":164,"kind":13,"containerName":"number_of_gaps","name":"$aln"},{"line":165,"kind":13,"containerName":"number_of_gaps","name":"$aln"},{"kind":13,"line":165,"containerName":"number_of_gaps","name":"$aln"},{"line":165,"kind":12,"containerName":"number_of_gaps","name":"isa"},{"containerName":"number_of_gaps","name":"$self","line":166,"kind":13},{"line":166,"kind":12,"name":"throw","containerName":"number_of_gaps"},{"kind":13,"line":168,"containerName":"number_of_gaps","name":"$aln"},{"line":168,"kind":12,"name":"num_sequences","containerName":"number_of_gaps"},{"name":"$self","containerName":"number_of_gaps","line":169,"kind":13},{"kind":12,"line":169,"name":"throw","containerName":"number_of_gaps"},{"name":"$aln","containerName":"number_of_gaps","kind":13,"line":170},{"kind":12,"line":170,"containerName":"number_of_gaps","name":"num_sequences"},{"containerName":"number_of_gaps","definition":"my","name":"$gapline","localvar":"my","kind":13,"line":172},{"kind":13,"line":172,"name":"$aln","containerName":"number_of_gaps"},{"line":172,"kind":12,"name":"gap_line","containerName":"number_of_gaps"},{"kind":13,"line":174,"containerName":"number_of_gaps","name":"$gapline"}],"kind":12,"detail":"($self,$aln)","signature":{"label":"number_of_gaps($self,$aln)","parameters":[{"label":"$self"},{"label":"$aln"}],"documentation":"1;\n# $Id: PairwiseStatistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::PairwiseStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::PairwiseStatistics - Base statistic object for Pairwise Alignments\n\n=head1 SYNOPSIS\n\n  use strict;\n  my $stats = Bio::Align::PairwiseStatistics->new();\n\n  # get alignment object of two sequences somehow\n  my $pwaln;\n  print $stats->number_of_comparable_bases($pwaln);\n  my $score = $stats->score_nuc($pwaln);\n\n\n=head1 DESCRIPTION\n\nCalculate pairwise statistics.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::PairwiseStatistics;\nuse vars qw($GapChars);\nuse strict;\n\n\nBEGIN { $GapChars = '(\\.|\\-)'; }\n\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n=head2 number_of_comparable_bases\n\n Title   : number_of_comparable_bases\n Usage   : my $bases = $stat->number_of_comparable_bases($aln);\n Function: Returns the count of the number of bases that can be\n           compared (L) in this alignment ( length - gaps)\n Returns : integer\n Args    : L<Bio::Align::AlignI>\n\n\n\nsub number_of_comparable_bases{\n   my ($self,$aln) = @_;\n  if ( ! defined $aln || ! $aln->isa('Bio::Align::AlignI') ) {\n    $self->throw(\"Must provide a Bio::Align::AlignI compliant object to \".\n      \"Bio::Align::PairwiseStatistics\");\n       return 0;\n  } elsif ( $aln->num_sequences != 2 ) { \n    $self->throw(\"Only pairwise calculations supported. Found \".\n      $aln->num_sequences.\" sequences in alignment\\n\");\n   }\n   my $L = $aln->length - $self->number_of_gaps($aln);\n   return $L;\n}\n\n=head2 number_of_differences\n\n Title   : number_of_differences\n Usage   : my $nd = $stat->number_of_distances($aln);\n Function: Returns the number of differences between two sequences\n Returns : integer\n Args    : L<Bio::Align::AlignI>\n\n\n\nsub number_of_differences{\n   my ($self,$aln) = @_;\n    if( ! defined $aln || ! $aln->isa('Bio::Align::AlignI') ) {\n    $self->throw(\"Must provide a Bio::Align::AlignI compliant object to \".\n      \"Bio::Align::PairwiseStatistics\");\n  } elsif ( $aln->num_sequences != 2 ) { \n    $self->throw(\"Only pairwise calculations supported. Found \".\n      $aln->num_sequences.\" sequences in alignment\\n\");\n    }\n   my (@seqs);\n  foreach my $seq ( $aln->each_seq ) {\n       push @seqs, [ split(//,$seq->seq())];\n   }\n   my $firstseq = shift @seqs;\n  #my $secondseq = shift @seqs;\n   my $diffcount = 0;\n   for (my $i = 0;$i<$aln->length; $i++ ) {\n    next if ( $firstseq->[$i]  =~ /^$GapChars$/ );\n       foreach my $seq ( @seqs ) {\n      next if ( $seq->[$i]  =~ /^$GapChars$/ );\n\t   if( $firstseq->[$i] ne $seq->[$i] ) {\n\t       $diffcount++;\n\t   }\n       }\n   }\n   return $diffcount;\n}\n\n=head2 number_of_gaps\n\n Title   : number_of_gaps\n Usage   : my $nd = $stat->number_of_gaps($aln);\n Function: Returns the number of gapped positions among sequences in alignment\n Returns : integer\n Args    : L<Bio::Align::AlignI>"},"containerName":"main::","definition":"sub"},{"name":"score_nuc","range":{"start":{"line":203,"character":0},"end":{"line":256,"character":9999}},"kind":12,"line":203,"children":[{"containerName":"score_nuc","definition":"my","name":"$self","localvar":"my","kind":13,"line":204},{"kind":13,"line":204,"name":"@args","containerName":"score_nuc"},{"kind":13,"line":205,"containerName":"score_nuc","name":"$aln","definition":"my","localvar":"my"},{"name":"$match","containerName":"score_nuc","line":205,"kind":13},{"kind":13,"line":205,"containerName":"score_nuc","name":"$mismatch"},{"containerName":"score_nuc","name":"$gap_open","kind":13,"line":205},{"kind":13,"line":205,"containerName":"score_nuc","name":"$gap_ext"},{"line":205,"kind":13,"containerName":"score_nuc","name":"$self"},{"containerName":"score_nuc","name":"_rearrange","kind":12,"line":205},{"name":"@args","containerName":"score_nuc","kind":13,"line":207},{"containerName":"score_nuc","name":"$aln","kind":13,"line":208},{"containerName":"score_nuc","name":"$aln","line":208,"kind":13},{"name":"isa","containerName":"score_nuc","kind":12,"line":208},{"containerName":"score_nuc","name":"$self","line":209,"kind":13},{"line":209,"kind":12,"name":"throw","containerName":"score_nuc"},{"containerName":"score_nuc","name":"$aln","line":211,"kind":13},{"name":"num_sequences","containerName":"score_nuc","kind":12,"line":211},{"name":"$self","containerName":"score_nuc","line":212,"kind":13},{"kind":12,"line":212,"containerName":"score_nuc","name":"throw"},{"line":213,"kind":13,"containerName":"score_nuc","name":"$aln"},{"name":"num_sequences","containerName":"score_nuc","kind":12,"line":213},{"kind":13,"line":215,"definition":"my","name":"$seq1","containerName":"score_nuc","localvar":"my"},{"containerName":"score_nuc","name":"$aln","line":215,"kind":13},{"name":"get_seq_by_pos","containerName":"score_nuc","kind":12,"line":215},{"kind":13,"line":216,"definition":"my","name":"$seq2","containerName":"score_nuc","localvar":"my"},{"name":"$aln","containerName":"score_nuc","line":216,"kind":13},{"kind":12,"line":216,"name":"get_seq_by_pos","containerName":"score_nuc"},{"kind":13,"line":217,"containerName":"score_nuc","name":"$seq1"},{"containerName":"score_nuc","name":"alphabet","kind":12,"line":217},{"line":217,"kind":13,"containerName":"score_nuc","name":"$seq1"},{"containerName":"score_nuc","name":"alphabet","line":217,"kind":12},{"kind":13,"line":218,"name":"$seq2","containerName":"score_nuc"},{"name":"alphabet","containerName":"score_nuc","kind":12,"line":218},{"containerName":"score_nuc","name":"$seq2","kind":13,"line":218},{"line":218,"kind":12,"name":"alphabet","containerName":"score_nuc"},{"containerName":"score_nuc","name":"$self","kind":13,"line":219},{"name":"throw","containerName":"score_nuc","line":219,"kind":12},{"line":221,"kind":13,"name":"$match","containerName":"score_nuc"},{"line":222,"kind":13,"containerName":"score_nuc","name":"$mismatch"},{"kind":13,"line":223,"containerName":"score_nuc","name":"$gap_open"},{"name":"$gap_ext","containerName":"score_nuc","line":224,"kind":13},{"line":225,"kind":13,"localvar":"my","containerName":"score_nuc","definition":"my","name":"$score"},{"kind":13,"line":226,"containerName":"score_nuc","name":"$prevres1","definition":"my","localvar":"my"},{"line":227,"kind":13,"localvar":"my","containerName":"score_nuc","name":"$prevres2","definition":"my"},{"line":228,"kind":13,"localvar":"my","containerName":"score_nuc","definition":"my","name":"$pos"},{"kind":13,"line":228,"name":"$pos","containerName":"score_nuc"},{"name":"$aln","containerName":"score_nuc","kind":13,"line":228},{"name":"length","containerName":"score_nuc","line":228,"kind":12},{"line":228,"kind":13,"name":"$pos","containerName":"score_nuc"},{"line":229,"kind":13,"localvar":"my","definition":"my","name":"$res1","containerName":"score_nuc"},{"name":"$seq1","containerName":"score_nuc","line":229,"kind":13},{"line":229,"kind":12,"containerName":"score_nuc","name":"subseq"},{"kind":13,"line":229,"name":"$pos","containerName":"score_nuc"},{"kind":13,"line":229,"name":"$pos","containerName":"score_nuc"},{"kind":13,"line":230,"containerName":"score_nuc","definition":"my","name":"$res2","localvar":"my"},{"containerName":"score_nuc","name":"$seq2","line":230,"kind":13},{"containerName":"score_nuc","name":"subseq","kind":12,"line":230},{"containerName":"score_nuc","name":"$pos","kind":13,"line":230},{"name":"$pos","containerName":"score_nuc","line":230,"kind":13},{"containerName":"score_nuc","name":"$res1","line":231,"kind":13},{"kind":13,"line":231,"name":"$res2","containerName":"score_nuc"},{"kind":13,"line":232,"name":"$res1","containerName":"score_nuc"},{"kind":13,"line":232,"name":"$res2","containerName":"score_nuc"},{"kind":13,"line":233,"containerName":"score_nuc","name":"$score"},{"line":233,"kind":13,"containerName":"score_nuc","name":"$match"},{"name":"$score","containerName":"score_nuc","line":235,"kind":13},{"kind":13,"line":235,"containerName":"score_nuc","name":"$mismatch"},{"line":238,"kind":13,"localvar":"my","definition":"my","name":"$open","containerName":"score_nuc"},{"containerName":"score_nuc","name":"$res1","line":239,"kind":13},{"name":"$res2","containerName":"score_nuc","line":239,"kind":13},{"containerName":"score_nuc","name":"$prevres","definition":"my","localvar":"my","kind":13,"line":240},{"name":"$prevres1","containerName":"score_nuc","line":240,"kind":13},{"line":241,"kind":13,"name":"$prevres","containerName":"score_nuc"},{"name":"$prevres2","containerName":"score_nuc","kind":13,"line":241},{"kind":13,"line":241,"name":"$res2","containerName":"score_nuc"},{"line":242,"kind":13,"containerName":"score_nuc","name":"$open"},{"containerName":"score_nuc","name":"$prevres","line":242,"kind":13},{"name":"$open","containerName":"score_nuc","line":244,"kind":13},{"line":244,"kind":13,"containerName":"score_nuc","name":"$prevres1"},{"name":"$prevres2","containerName":"score_nuc","line":244,"kind":13},{"kind":13,"line":246,"name":"$open","containerName":"score_nuc"},{"line":247,"kind":13,"containerName":"score_nuc","name":"$score"},{"containerName":"score_nuc","name":"$gap_open","line":247,"kind":13},{"kind":13,"line":249,"name":"$score","containerName":"score_nuc"},{"line":249,"kind":13,"containerName":"score_nuc","name":"$gap_ext"},{"containerName":"score_nuc","name":"$prevres1","line":252,"kind":13},{"name":"$res1","containerName":"score_nuc","kind":13,"line":252},{"containerName":"score_nuc","name":"$prevres2","kind":13,"line":253},{"line":253,"kind":13,"name":"$res2","containerName":"score_nuc"},{"name":"$score","containerName":"score_nuc","kind":13,"line":255}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"score_nuc($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: PairwiseStatistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::PairwiseStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::PairwiseStatistics - Base statistic object for Pairwise Alignments\n\n=head1 SYNOPSIS\n\n  use strict;\n  my $stats = Bio::Align::PairwiseStatistics->new();\n\n  # get alignment object of two sequences somehow\n  my $pwaln;\n  print $stats->number_of_comparable_bases($pwaln);\n  my $score = $stats->score_nuc($pwaln);\n\n\n=head1 DESCRIPTION\n\nCalculate pairwise statistics.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::PairwiseStatistics;\nuse vars qw($GapChars);\nuse strict;\n\n\nBEGIN { $GapChars = '(\\.|\\-)'; }\n\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n=head2 number_of_comparable_bases\n\n Title   : number_of_comparable_bases\n Usage   : my $bases = $stat->number_of_comparable_bases($aln);\n Function: Returns the count of the number of bases that can be\n           compared (L) in this alignment ( length - gaps)\n Returns : integer\n Args    : L<Bio::Align::AlignI>\n\n\n\nsub number_of_comparable_bases{\n   my ($self,$aln) = @_;\n  if ( ! defined $aln || ! $aln->isa('Bio::Align::AlignI') ) {\n    $self->throw(\"Must provide a Bio::Align::AlignI compliant object to \".\n      \"Bio::Align::PairwiseStatistics\");\n       return 0;\n  } elsif ( $aln->num_sequences != 2 ) { \n    $self->throw(\"Only pairwise calculations supported. Found \".\n      $aln->num_sequences.\" sequences in alignment\\n\");\n   }\n   my $L = $aln->length - $self->number_of_gaps($aln);\n   return $L;\n}\n\n=head2 number_of_differences\n\n Title   : number_of_differences\n Usage   : my $nd = $stat->number_of_distances($aln);\n Function: Returns the number of differences between two sequences\n Returns : integer\n Args    : L<Bio::Align::AlignI>\n\n\n\nsub number_of_differences{\n   my ($self,$aln) = @_;\n    if( ! defined $aln || ! $aln->isa('Bio::Align::AlignI') ) {\n    $self->throw(\"Must provide a Bio::Align::AlignI compliant object to \".\n      \"Bio::Align::PairwiseStatistics\");\n  } elsif ( $aln->num_sequences != 2 ) { \n    $self->throw(\"Only pairwise calculations supported. Found \".\n      $aln->num_sequences.\" sequences in alignment\\n\");\n    }\n   my (@seqs);\n  foreach my $seq ( $aln->each_seq ) {\n       push @seqs, [ split(//,$seq->seq())];\n   }\n   my $firstseq = shift @seqs;\n  #my $secondseq = shift @seqs;\n   my $diffcount = 0;\n   for (my $i = 0;$i<$aln->length; $i++ ) {\n    next if ( $firstseq->[$i]  =~ /^$GapChars$/ );\n       foreach my $seq ( @seqs ) {\n      next if ( $seq->[$i]  =~ /^$GapChars$/ );\n\t   if( $firstseq->[$i] ne $seq->[$i] ) {\n\t       $diffcount++;\n\t   }\n       }\n   }\n   return $diffcount;\n}\n\n=head2 number_of_gaps\n\n Title   : number_of_gaps\n Usage   : my $nd = $stat->number_of_gaps($aln);\n Function: Returns the number of gapped positions among sequences in alignment\n Returns : integer\n Args    : L<Bio::Align::AlignI>\n\n\n\nsub number_of_gaps{\n   my ($self,$aln) = @_;\n  if ( ! defined $aln || ! $aln->isa('Bio::Align::AlignI') ) {\n    $self->throw(\"Must provide a Bio::Align::AlignI compliant object to \".\n      \"Bio::Align::PairwiseStatistics\");\n  } elsif ( $aln->num_sequences != 2 ) { \n    $self->throw(\"Only pairwise calculations supported. Found \".\n      $aln->num_sequences.\" sequences in alignment\\n\");\n    }\n   my $gapline = $aln->gap_line;\n   # this will count the number of '-' characters\n   return $gapline =~ tr/-/-/;\n}\n\n\n=head2 score_nuc\n\n Title   : score_nuc\n Usage   : my $score = $stat->score_nuc($aln);\n             or\n           my $score = $stat->score_nuc(\n             -aln =>$aln,\n             -match    => 1,\n             -mismatch => -1,\n             -gap_open => -1,\n             -gap_ext  => -1\n           );\n Function: Calculate the score of an alignment of 2 nucleic acid sequences. The\n           scoring parameters can be specified. Otherwise the blastn default\n           parameters are used: match = 2, mismatch = -3, gap opening = -5, gap\n           extension = -2\n Returns : alignment score (number)\n Args    : L<Bio::Align::AlignI>\n           match score [optional]\n           mismatch score [optional]\n           gap opening score [optional]\n           gap extension score [optional]"}}],"version":5}