# -*-Perl-*- Test Harness script for Bioperl
# $Id: TreeBuild.t 15112 2008-12-08 18:12:38Z sendu $

use strict;

BEGIN { 
    use lib '.';
    use Bio::Root::Test;
    
    test_begin(-tests => 13);
	
	for my $mod ( qw(Bio::Align::DNAStatistics
					 Bio::Align::ProteinStatistics
					 Bio::Align::Utilities
					 Bio::AlignIO
					 Bio::Tree::DistanceFactory
					 Bio::TreeIO) ) {
		use_ok($mod);
    }
}

my $debug = test_debug();

use Bio::Align::Utilities qw(:all);

my $in = Bio::AlignIO->new(-format => 'clustalw',
       			  -file   => test_input_file('pep-266.aln'));
my $aln = $in->next_aln();
isa_ok($aln, 'Bio::SimpleAlign','SimpleAlign object parsed out');
my $pstats = Bio::Align::ProteinStatistics->new(-verbose => $debug);
my $matrix = $pstats->distance(-method => 'Kimura',
			       -align  => $aln);
isa_ok($matrix,'Bio::Matrix::MatrixI','Protein distance matrix retrieved');

my $treebuilder = Bio::Tree::DistanceFactory->new(-method => 'NJ');
my $tree = $treebuilder->make_tree($matrix);
isa_ok($tree,'Bio::Tree::TreeI', 'Tree object gotten back');

my ($cn) = $tree->find_node('183.m01790');

# brlens checked against tree generated by PHYLIP NJ
is($tree->find_node('AN2438.1')->branch_length, '0.28221','NJ calculated Branch length');
is($tree->find_node('FG05298.1')->branch_length, '0.20593','NJ calculated Branch length');

# simple topology test - make sure these 2 are sister
is($tree->find_node('YOR262W')->ancestor->id, 
   $tree->find_node('Smik_Contig1103.1')->ancestor->id, 'Make sure two nodes are sister');

# TODO?
# UPGMA tests


# test the bootstrap
my $replicates = &bootstrap_replicates($aln,10);
is(scalar @$replicates, 10,'10 replicates formulated');
