{"version":5,"vars":[{"line":5,"containerName":"warnings::Test::Exception::Test::Builder::Sub","kind":2,"name":"Uplevel"},{"line":6,"kind":2,"containerName":"","name":"base"},{"containerName":"main::","kind":13,"name":"$VERSION","line":9,"definition":"our"},{"line":9,"containerName":"","kind":2,"name":"Carp"},{"definition":"our","kind":13,"containerName":"main::","name":"@EXPORT","line":10},{"definition":"my","line":12,"name":"$Tester","containerName":null,"localvar":"my","kind":13},{"line":12,"name":"Test","containerName":"Builder","kind":12},{"line":12,"kind":12,"containerName":"main::","name":"new"},{"range":{"start":{"character":0,"line":14},"end":{"line":22,"character":9999}},"kind":12,"line":14,"containerName":"main::","name":"import","children":[{"definition":"my","line":15,"kind":13,"localvar":"my","containerName":"import","name":"$self"},{"line":17,"name":"$package","localvar":"my","kind":13,"containerName":"import","definition":"my"},{"line":18,"name":"$Tester","containerName":"import","kind":13},{"name":"exported_to","containerName":"import","kind":12,"line":18},{"name":"$package","kind":13,"containerName":"import","line":18},{"name":"$Tester","containerName":"import","kind":13,"line":19},{"line":19,"name":"plan","containerName":"import","kind":12},{"line":21,"name":"$self","containerName":"import","kind":13},{"containerName":"import","kind":12,"name":"export_to_level","line":21},{"name":"$self","kind":13,"containerName":"import","line":21},{"kind":13,"containerName":"import","name":"@EXPORT","line":21}],"definition":"sub"},{"definition":"sub","children":[{"line":81,"containerName":"_try_as_caller","localvar":"my","kind":13,"name":"$coderef","definition":"my"},{"kind":13,"containerName":"_try_as_caller","name":"$coderef","line":82}],"name":"_try_as_caller","containerName":"main::","line":80,"range":{"end":{"line":84,"character":9999},"start":{"line":80,"character":0}},"kind":12},{"kind":12,"name":"uplevel","line":82},{"children":[{"definition":"my","line":88,"localvar":"my","kind":13,"containerName":"_is_exception","name":"$exception"},{"containerName":"_is_exception","kind":13,"name":"$exception","line":89},{"line":89,"name":"$exception","containerName":"_is_exception","kind":13}],"name":"_is_exception","containerName":"main::","definition":"sub","line":87,"kind":12,"range":{"start":{"line":87,"character":0},"end":{"line":90,"character":9999}}},{"signature":{"parameters":[{"label":"$prefix"},{"label":"$exception"}],"documentation":"","label":"_exception_as_string($prefix,$exception)"},"line":93,"kind":12,"range":{"start":{"character":0,"line":93},"end":{"character":9999,"line":101}},"definition":"sub","detail":"($prefix,$exception)","children":[{"line":94,"localvar":"my","kind":13,"containerName":"_exception_as_string","name":"$prefix","definition":"my"},{"line":94,"containerName":"_exception_as_string","kind":13,"name":"$exception"},{"line":95,"name":"$exception","containerName":"_exception_as_string","kind":13},{"line":96,"containerName":"_exception_as_string","localvar":"my","kind":13,"name":"$class","definition":"my"},{"kind":13,"containerName":"_exception_as_string","name":"$exception","line":96},{"containerName":"_exception_as_string","kind":13,"name":"$exception","line":97},{"name":"$class","containerName":"_exception_as_string","kind":13,"line":98},{"name":"$exception","kind":13,"containerName":"_exception_as_string","line":99}],"containerName":"main::","name":"_exception_as_string"},{"name":"dies_ok","containerName":"main::","children":[{"localvar":"my","containerName":"dies_ok","kind":13,"name":"$coderef","line":128,"definition":"my"},{"line":128,"containerName":"dies_ok","kind":13,"name":"$description"},{"line":129,"localvar":"my","kind":13,"containerName":"dies_ok","name":"$exception","definition":"my"},{"line":129,"containerName":"dies_ok","kind":13,"name":"$coderef"},{"definition":"my","line":130,"localvar":"my","kind":13,"containerName":"dies_ok","name":"$ok"},{"kind":13,"containerName":"dies_ok","name":"$Tester","line":130},{"containerName":"dies_ok","kind":12,"name":"ok","line":130},{"containerName":"dies_ok","kind":13,"name":"$exception","line":130},{"line":130,"name":"$description","kind":13,"containerName":"dies_ok"},{"kind":13,"containerName":"dies_ok","name":"$exception","line":131},{"containerName":"dies_ok","kind":13,"name":"$ok","line":132}],"detail":"(&;$)","definition":"sub","range":{"end":{"line":133,"character":9999},"start":{"character":0,"line":127}},"kind":12,"line":127,"signature":{"parameters":[{"label":"&;$"}],"documentation":"1;\nuse strict;\nuse warnings;\n\npackage Test::Exception;\nuse Test::Builder;\nuse Sub::Uplevel qw( uplevel );\nuse base qw( Exporter );\nuse Carp;\n\nour $VERSION = '0.25';\nour @EXPORT = qw(dies_ok lives_ok throws_ok lives_and);\n\nmy $Tester = Test::Builder->new;\n\nsub import {\n    my $self = shift;\n    if ( @_ ) {\n        my $package = caller;\n        $Tester->exported_to( $package );\n        $Tester->plan( @_ );\n    };\n    $self->export_to_level( 1, $self, $_ ) foreach @EXPORT;\n}\n\n=head1 NAME\n\nTest::Exception - Test exception based code\n\n=head1 SYNOPSIS\n\n  use Test::More tests => 5;\n  use Test::Exception;\n\n  # or if you don't need Test::More\n\n  use Test::Exception tests => 5;\n\n  # then...\n\n  # Check that something died\n  dies_ok { $foo->method1 } 'expecting to die';\n\n  # Check that something did not die\n  lives_ok { $foo->method2 } 'expecting to live';\n\n  # Check that the stringified exception matches given regex\n  throws_ok { $foo->method3 } qr/division by zero/, 'zero caught okay';\n\n  # Check an exception of the given class (or subclass) is thrown\n  throws_ok { $foo->method4 } 'Error::Simple', 'simple error thrown';\n  \n  # all Test::Exceptions subroutines are guaranteed to preserve the state \n  # of $@ so you can do things like this after throws_ok and dies_ok\n  like $@, 'what the stringified exception should look like';\n\n  # Check that a test runs without an exception\n  lives_and { is $foo->method, 42 } 'method is 42';\n  \n  # or if you don't like prototyped functions\n  \n  dies_ok( sub { $foo->method1 }, 'expecting to die' );\n  lives_ok( sub { $foo->method2 }, 'expecting to live' );\n  throws_ok( sub { $foo->method3 }, qr/division by zero/,\n      'zero caught okay' );\n  throws_ok( sub { $foo->method4 }, 'Error::Simple', \n      'simple error thrown' );\n  lives_and( sub { is $foo->method, 42 }, 'method is 42' );\n\n\n=head1 DESCRIPTION\n\nThis module provides a few convenience methods for testing exception based code. It is built with L<Test::Builder> and plays happily with L<Test::More> and friends.\n\nIf you are not already familiar with L<Test::More> now would be the time to go take a look.\n\nYou can specify the test plan when you C<use Test::Exception> in the same way as C<use Test::More>. See L<Test::More> for details.\n\n\n\nsub _try_as_caller {\n    my $coderef = shift;\n    eval { uplevel 3, $coderef };\n    return $@;\n};\n\n\nsub _is_exception {\n    my $exception = shift;\n    return ref $exception || $exception ne '';\n};\n\n\nsub _exception_as_string {\n    my ( $prefix, $exception ) = @_;\n    return \"$prefix normal exit\" unless _is_exception( $exception );\n    my $class = ref $exception;\n    $exception = \"$class ($exception)\" \n            if $class && \"$exception\" !~ m/^\\Q$class/;\n    chomp $exception;\n    return \"$prefix $exception\";\n};\n\n\n=over 4\n\n* B<dies_ok>\n\nChecks that a piece of code dies, rather than returning normally. For example:\n\n    sub div {\n        my ( $a, $b ) = @_;\n        return $a / $b;\n    };\n\n    dies_ok { div( 1, 0 ) } 'divide by zero detected';\n\n    # or if you don't like prototypes\n    dies_ok( sub { div( 1, 0 ) }, 'divide by zero detected' );\n\nA true value is returned if the test succeeds, false otherwise. On exit $@ is guaranteed to be the cause of death (if any).\n\nThe test description is optional, but recommended. ","label":"dies_ok(&;$)"}},{"containerName":"main::","name":"lives_ok","children":[{"line":167,"name":"$coderef","containerName":"lives_ok","localvar":"my","kind":13,"definition":"my"},{"line":167,"name":"$description","kind":13,"containerName":"lives_ok"},{"localvar":"my","kind":13,"containerName":"lives_ok","name":"$exception","line":168,"definition":"my"},{"name":"$coderef","kind":13,"containerName":"lives_ok","line":168},{"name":"$ok","kind":13,"localvar":"my","containerName":"lives_ok","line":169,"definition":"my"},{"line":169,"name":"$Tester","containerName":"lives_ok","kind":13},{"line":169,"kind":12,"containerName":"lives_ok","name":"ok"},{"line":169,"containerName":"lives_ok","kind":13,"name":"$exception"},{"containerName":"lives_ok","kind":13,"name":"$description","line":169},{"line":170,"containerName":"lives_ok","kind":13,"name":"$Tester"},{"line":170,"name":"diag","kind":12,"containerName":"lives_ok"},{"line":170,"containerName":"lives_ok","kind":13,"name":"$exception"},{"line":170,"containerName":"lives_ok","kind":13,"name":"$ok"},{"line":171,"kind":13,"containerName":"lives_ok","name":"$exception"},{"name":"$ok","kind":13,"containerName":"lives_ok","line":172}],"detail":"(&;$)","definition":"sub","kind":12,"range":{"end":{"line":173,"character":9999},"start":{"character":0,"line":166}},"line":166,"signature":{"parameters":[{"label":"&;$"}],"documentation":"1;\nuse strict;\nuse warnings;\n\npackage Test::Exception;\nuse Test::Builder;\nuse Sub::Uplevel qw( uplevel );\nuse base qw( Exporter );\nuse Carp;\n\nour $VERSION = '0.25';\nour @EXPORT = qw(dies_ok lives_ok throws_ok lives_and);\n\nmy $Tester = Test::Builder->new;\n\nsub import {\n    my $self = shift;\n    if ( @_ ) {\n        my $package = caller;\n        $Tester->exported_to( $package );\n        $Tester->plan( @_ );\n    };\n    $self->export_to_level( 1, $self, $_ ) foreach @EXPORT;\n}\n\n=head1 NAME\n\nTest::Exception - Test exception based code\n\n=head1 SYNOPSIS\n\n  use Test::More tests => 5;\n  use Test::Exception;\n\n  # or if you don't need Test::More\n\n  use Test::Exception tests => 5;\n\n  # then...\n\n  # Check that something died\n  dies_ok { $foo->method1 } 'expecting to die';\n\n  # Check that something did not die\n  lives_ok { $foo->method2 } 'expecting to live';\n\n  # Check that the stringified exception matches given regex\n  throws_ok { $foo->method3 } qr/division by zero/, 'zero caught okay';\n\n  # Check an exception of the given class (or subclass) is thrown\n  throws_ok { $foo->method4 } 'Error::Simple', 'simple error thrown';\n  \n  # all Test::Exceptions subroutines are guaranteed to preserve the state \n  # of $@ so you can do things like this after throws_ok and dies_ok\n  like $@, 'what the stringified exception should look like';\n\n  # Check that a test runs without an exception\n  lives_and { is $foo->method, 42 } 'method is 42';\n  \n  # or if you don't like prototyped functions\n  \n  dies_ok( sub { $foo->method1 }, 'expecting to die' );\n  lives_ok( sub { $foo->method2 }, 'expecting to live' );\n  throws_ok( sub { $foo->method3 }, qr/division by zero/,\n      'zero caught okay' );\n  throws_ok( sub { $foo->method4 }, 'Error::Simple', \n      'simple error thrown' );\n  lives_and( sub { is $foo->method, 42 }, 'method is 42' );\n\n\n=head1 DESCRIPTION\n\nThis module provides a few convenience methods for testing exception based code. It is built with L<Test::Builder> and plays happily with L<Test::More> and friends.\n\nIf you are not already familiar with L<Test::More> now would be the time to go take a look.\n\nYou can specify the test plan when you C<use Test::Exception> in the same way as C<use Test::More>. See L<Test::More> for details.\n\n\n\nsub _try_as_caller {\n    my $coderef = shift;\n    eval { uplevel 3, $coderef };\n    return $@;\n};\n\n\nsub _is_exception {\n    my $exception = shift;\n    return ref $exception || $exception ne '';\n};\n\n\nsub _exception_as_string {\n    my ( $prefix, $exception ) = @_;\n    return \"$prefix normal exit\" unless _is_exception( $exception );\n    my $class = ref $exception;\n    $exception = \"$class ($exception)\" \n            if $class && \"$exception\" !~ m/^\\Q$class/;\n    chomp $exception;\n    return \"$prefix $exception\";\n};\n\n\n=over 4\n\n* B<dies_ok>\n\nChecks that a piece of code dies, rather than returning normally. For example:\n\n    sub div {\n        my ( $a, $b ) = @_;\n        return $a / $b;\n    };\n\n    dies_ok { div( 1, 0 ) } 'divide by zero detected';\n\n    # or if you don't like prototypes\n    dies_ok( sub { div( 1, 0 ) }, 'divide by zero detected' );\n\nA true value is returned if the test succeeds, false otherwise. On exit $@ is guaranteed to be the cause of death (if any).\n\nThe test description is optional, but recommended. \n\n\n\nsub dies_ok (&;$) {\n    my ( $coderef, $description ) = @_;\n    my $exception = _try_as_caller( $coderef );\n    my $ok = $Tester->ok( _is_exception($exception), $description );\n    $@ = $exception;\n    return $ok;\n}\n\n\n* B<lives_ok>\n\nChecks that a piece of code exits normally, and doesn't die. For example:\n\n    sub read_file {\n        my $file = shift;\n        local $/;\n        open my $fh, '<', $file or die \"open failed ($!)\\n\";\n        $file = <FILE>;\n        return $file;\n    };\n\n    my $file;\n    lives_ok { $file = read_file('test.txt') } 'file read';\n\n    # or if you don't like prototypes\n    lives_ok( sub { $file = read_file('test.txt') }, 'file read' );\n\nShould a lives_ok() test fail it produces appropriate diagnostic messages. For example:\n\n    not ok 1 - file read\n    #     Failed test (test.t at line 15)\n    # died: open failed (No such file or directory)\n\nA true value is returned if the test succeeds, false otherwise. On exit $@ is guaranteed to be the cause of death (if any).\n\nThe test description is optional, but recommended. ","label":"lives_ok(&;$)"}},{"children":[{"definition":"my","name":"$coderef","localvar":"my","kind":13,"containerName":"throws_ok","line":221},{"line":221,"kind":13,"containerName":"throws_ok","name":"$expecting"},{"name":"$description","kind":13,"containerName":"throws_ok","line":221},{"line":223,"containerName":"throws_ok","kind":13,"name":"$expecting"},{"name":"$description","kind":13,"containerName":"throws_ok","line":224},{"line":224,"name":"$expecting","kind":13,"containerName":"throws_ok"},{"name":"$description","kind":13,"containerName":"throws_ok","line":225},{"name":"$exception","localvar":"my","kind":13,"containerName":"throws_ok","line":226,"definition":"my"},{"name":"$coderef","containerName":"throws_ok","kind":13,"line":226},{"name":"$regex","kind":13,"localvar":"my","containerName":"throws_ok","line":227,"definition":"my"},{"line":227,"name":"$Tester","containerName":"throws_ok","kind":13},{"name":"maybe_regex","kind":12,"containerName":"throws_ok","line":227},{"line":227,"name":"$expecting","containerName":"throws_ok","kind":13},{"line":228,"name":"$ok","localvar":"my","containerName":"throws_ok","kind":13,"definition":"my"},{"line":228,"containerName":"throws_ok","kind":13,"name":"$regex"},{"line":229,"name":"$exception","containerName":"throws_ok","kind":13},{"name":"$exception","kind":13,"containerName":"throws_ok","line":231},{"containerName":"throws_ok","kind":12,"name":"isa","line":231},{"line":231,"name":"$expecting","containerName":"throws_ok","kind":13},{"containerName":"throws_ok","kind":13,"name":"$expecting","line":231},{"line":231,"kind":13,"containerName":"throws_ok","name":"$expecting"},{"line":233,"containerName":"throws_ok","kind":13,"name":"$Tester"},{"line":233,"containerName":"throws_ok","kind":12,"name":"ok"},{"name":"$ok","containerName":"throws_ok","kind":13,"line":233},{"name":"$description","kind":13,"containerName":"throws_ok","line":233},{"name":"$ok","containerName":"throws_ok","kind":13,"line":234},{"line":235,"containerName":"throws_ok","kind":13,"name":"$Tester"},{"containerName":"throws_ok","kind":12,"name":"diag","line":235},{"kind":13,"containerName":"throws_ok","name":"$expecting","line":235},{"line":236,"name":"$Tester","containerName":"throws_ok","kind":13},{"name":"diag","containerName":"throws_ok","kind":12,"line":236},{"containerName":"throws_ok","kind":13,"name":"$exception","line":236},{"line":238,"containerName":"throws_ok","kind":13,"name":"$exception"},{"kind":13,"containerName":"throws_ok","name":"$ok","line":239}],"containerName":"main::","name":"throws_ok","definition":"sub","detail":"(&$;$)","line":220,"kind":12,"range":{"start":{"character":0,"line":220},"end":{"line":240,"character":9999}},"signature":{"label":"throws_ok(&$;$)","parameters":[{"label":"&$;$"}],"documentation":"1;\nuse strict;\nuse warnings;\n\npackage Test::Exception;\nuse Test::Builder;\nuse Sub::Uplevel qw( uplevel );\nuse base qw( Exporter );\nuse Carp;\n\nour $VERSION = '0.25';\nour @EXPORT = qw(dies_ok lives_ok throws_ok lives_and);\n\nmy $Tester = Test::Builder->new;\n\nsub import {\n    my $self = shift;\n    if ( @_ ) {\n        my $package = caller;\n        $Tester->exported_to( $package );\n        $Tester->plan( @_ );\n    };\n    $self->export_to_level( 1, $self, $_ ) foreach @EXPORT;\n}\n\n=head1 NAME\n\nTest::Exception - Test exception based code\n\n=head1 SYNOPSIS\n\n  use Test::More tests => 5;\n  use Test::Exception;\n\n  # or if you don't need Test::More\n\n  use Test::Exception tests => 5;\n\n  # then...\n\n  # Check that something died\n  dies_ok { $foo->method1 } 'expecting to die';\n\n  # Check that something did not die\n  lives_ok { $foo->method2 } 'expecting to live';\n\n  # Check that the stringified exception matches given regex\n  throws_ok { $foo->method3 } qr/division by zero/, 'zero caught okay';\n\n  # Check an exception of the given class (or subclass) is thrown\n  throws_ok { $foo->method4 } 'Error::Simple', 'simple error thrown';\n  \n  # all Test::Exceptions subroutines are guaranteed to preserve the state \n  # of $@ so you can do things like this after throws_ok and dies_ok\n  like $@, 'what the stringified exception should look like';\n\n  # Check that a test runs without an exception\n  lives_and { is $foo->method, 42 } 'method is 42';\n  \n  # or if you don't like prototyped functions\n  \n  dies_ok( sub { $foo->method1 }, 'expecting to die' );\n  lives_ok( sub { $foo->method2 }, 'expecting to live' );\n  throws_ok( sub { $foo->method3 }, qr/division by zero/,\n      'zero caught okay' );\n  throws_ok( sub { $foo->method4 }, 'Error::Simple', \n      'simple error thrown' );\n  lives_and( sub { is $foo->method, 42 }, 'method is 42' );\n\n\n=head1 DESCRIPTION\n\nThis module provides a few convenience methods for testing exception based code. It is built with L<Test::Builder> and plays happily with L<Test::More> and friends.\n\nIf you are not already familiar with L<Test::More> now would be the time to go take a look.\n\nYou can specify the test plan when you C<use Test::Exception> in the same way as C<use Test::More>. See L<Test::More> for details.\n\n\n\nsub _try_as_caller {\n    my $coderef = shift;\n    eval { uplevel 3, $coderef };\n    return $@;\n};\n\n\nsub _is_exception {\n    my $exception = shift;\n    return ref $exception || $exception ne '';\n};\n\n\nsub _exception_as_string {\n    my ( $prefix, $exception ) = @_;\n    return \"$prefix normal exit\" unless _is_exception( $exception );\n    my $class = ref $exception;\n    $exception = \"$class ($exception)\" \n            if $class && \"$exception\" !~ m/^\\Q$class/;\n    chomp $exception;\n    return \"$prefix $exception\";\n};\n\n\n=over 4\n\n* B<dies_ok>\n\nChecks that a piece of code dies, rather than returning normally. For example:\n\n    sub div {\n        my ( $a, $b ) = @_;\n        return $a / $b;\n    };\n\n    dies_ok { div( 1, 0 ) } 'divide by zero detected';\n\n    # or if you don't like prototypes\n    dies_ok( sub { div( 1, 0 ) }, 'divide by zero detected' );\n\nA true value is returned if the test succeeds, false otherwise. On exit $@ is guaranteed to be the cause of death (if any).\n\nThe test description is optional, but recommended. \n\n\n\nsub dies_ok (&;$) {\n    my ( $coderef, $description ) = @_;\n    my $exception = _try_as_caller( $coderef );\n    my $ok = $Tester->ok( _is_exception($exception), $description );\n    $@ = $exception;\n    return $ok;\n}\n\n\n* B<lives_ok>\n\nChecks that a piece of code exits normally, and doesn't die. For example:\n\n    sub read_file {\n        my $file = shift;\n        local $/;\n        open my $fh, '<', $file or die \"open failed ($!)\\n\";\n        $file = <FILE>;\n        return $file;\n    };\n\n    my $file;\n    lives_ok { $file = read_file('test.txt') } 'file read';\n\n    # or if you don't like prototypes\n    lives_ok( sub { $file = read_file('test.txt') }, 'file read' );\n\nShould a lives_ok() test fail it produces appropriate diagnostic messages. For example:\n\n    not ok 1 - file read\n    #     Failed test (test.t at line 15)\n    # died: open failed (No such file or directory)\n\nA true value is returned if the test succeeds, false otherwise. On exit $@ is guaranteed to be the cause of death (if any).\n\nThe test description is optional, but recommended. \n\n\nsub lives_ok (&;$) {\n    my ( $coderef, $description ) = @_;\n    my $exception = _try_as_caller( $coderef );\n    my $ok = $Tester->ok( ! _is_exception( $exception ), $description );\n\t$Tester->diag( _exception_as_string( \"died:\", $exception ) ) unless $ok;\n    $@ = $exception;\n    return $ok;\n}\n\n\n* B<throws_ok>\n\nTests to see that a specific exception is thrown. throws_ok() has two forms: \n\n  throws_ok BLOCK REGEX, TEST_DESCRIPTION\n  throws_ok BLOCK CLASS, TEST_DESCRIPTION\n\nIn the first form the test passes if the stringified exception matches the give regular expression. For example:\n\n    throws_ok { read_file( 'unreadable' ) } qr/No file/, 'no file';\n\nIf your perl does not support C<qr//> you can also pass a regex-like string, for example:\n\n    throws_ok { read_file( 'unreadable' ) } '/No file/', 'no file';\n\nThe second form of throws_ok() test passes if the exception is of the same class as the one supplied, or a subclass of that class. For example:\n\n    throws_ok { $foo->bar } \"Error::Simple\", 'simple error';\n\nWill only pass if the C<bar> method throws an Error::Simple exception, or a subclass of an Error::Simple exception.\n\nYou can get the same effect by passing an instance of the exception you want to look for. The following is equivalent to the previous example:\n\n    my $SIMPLE = Error::Simple->new;\n    throws_ok { $foo->bar } $SIMPLE, 'simple error';\n\nShould a throws_ok() test fail it produces appropriate diagnostic messages. For example:\n\n    not ok 3 - simple error\n    #     Failed test (test.t at line 48)\n    # expecting: Error::Simple exception\n    # found: normal exit\n\nLike all other Test::Exception functions you can avoid prototypes by passing a subroutine explicitly:\n\n    throws_ok( sub {$foo->bar}, \"Error::Simple\", 'simple error' );\n\nA true value is returned if the test succeeds, false otherwise. On exit $@ is guaranteed to be the cause of death (if any).\n\nA description of the exception being checked is used if no optional test description is passed."}},{"name":"croak","kind":12,"line":222},{"signature":{"parameters":[{"label":"&;$"}],"documentation":"1;\nuse strict;\nuse warnings;\n\npackage Test::Exception;\nuse Test::Builder;\nuse Sub::Uplevel qw( uplevel );\nuse base qw( Exporter );\nuse Carp;\n\nour $VERSION = '0.25';\nour @EXPORT = qw(dies_ok lives_ok throws_ok lives_and);\n\nmy $Tester = Test::Builder->new;\n\nsub import {\n    my $self = shift;\n    if ( @_ ) {\n        my $package = caller;\n        $Tester->exported_to( $package );\n        $Tester->plan( @_ );\n    };\n    $self->export_to_level( 1, $self, $_ ) foreach @EXPORT;\n}\n\n=head1 NAME\n\nTest::Exception - Test exception based code\n\n=head1 SYNOPSIS\n\n  use Test::More tests => 5;\n  use Test::Exception;\n\n  # or if you don't need Test::More\n\n  use Test::Exception tests => 5;\n\n  # then...\n\n  # Check that something died\n  dies_ok { $foo->method1 } 'expecting to die';\n\n  # Check that something did not die\n  lives_ok { $foo->method2 } 'expecting to live';\n\n  # Check that the stringified exception matches given regex\n  throws_ok { $foo->method3 } qr/division by zero/, 'zero caught okay';\n\n  # Check an exception of the given class (or subclass) is thrown\n  throws_ok { $foo->method4 } 'Error::Simple', 'simple error thrown';\n  \n  # all Test::Exceptions subroutines are guaranteed to preserve the state \n  # of $@ so you can do things like this after throws_ok and dies_ok\n  like $@, 'what the stringified exception should look like';\n\n  # Check that a test runs without an exception\n  lives_and { is $foo->method, 42 } 'method is 42';\n  \n  # or if you don't like prototyped functions\n  \n  dies_ok( sub { $foo->method1 }, 'expecting to die' );\n  lives_ok( sub { $foo->method2 }, 'expecting to live' );\n  throws_ok( sub { $foo->method3 }, qr/division by zero/,\n      'zero caught okay' );\n  throws_ok( sub { $foo->method4 }, 'Error::Simple', \n      'simple error thrown' );\n  lives_and( sub { is $foo->method, 42 }, 'method is 42' );\n\n\n=head1 DESCRIPTION\n\nThis module provides a few convenience methods for testing exception based code. It is built with L<Test::Builder> and plays happily with L<Test::More> and friends.\n\nIf you are not already familiar with L<Test::More> now would be the time to go take a look.\n\nYou can specify the test plan when you C<use Test::Exception> in the same way as C<use Test::More>. See L<Test::More> for details.\n\n\n\nsub _try_as_caller {\n    my $coderef = shift;\n    eval { uplevel 3, $coderef };\n    return $@;\n};\n\n\nsub _is_exception {\n    my $exception = shift;\n    return ref $exception || $exception ne '';\n};\n\n\nsub _exception_as_string {\n    my ( $prefix, $exception ) = @_;\n    return \"$prefix normal exit\" unless _is_exception( $exception );\n    my $class = ref $exception;\n    $exception = \"$class ($exception)\" \n            if $class && \"$exception\" !~ m/^\\Q$class/;\n    chomp $exception;\n    return \"$prefix $exception\";\n};\n\n\n=over 4\n\n* B<dies_ok>\n\nChecks that a piece of code dies, rather than returning normally. For example:\n\n    sub div {\n        my ( $a, $b ) = @_;\n        return $a / $b;\n    };\n\n    dies_ok { div( 1, 0 ) } 'divide by zero detected';\n\n    # or if you don't like prototypes\n    dies_ok( sub { div( 1, 0 ) }, 'divide by zero detected' );\n\nA true value is returned if the test succeeds, false otherwise. On exit $@ is guaranteed to be the cause of death (if any).\n\nThe test description is optional, but recommended. \n\n\n\nsub dies_ok (&;$) {\n    my ( $coderef, $description ) = @_;\n    my $exception = _try_as_caller( $coderef );\n    my $ok = $Tester->ok( _is_exception($exception), $description );\n    $@ = $exception;\n    return $ok;\n}\n\n\n* B<lives_ok>\n\nChecks that a piece of code exits normally, and doesn't die. For example:\n\n    sub read_file {\n        my $file = shift;\n        local $/;\n        open my $fh, '<', $file or die \"open failed ($!)\\n\";\n        $file = <FILE>;\n        return $file;\n    };\n\n    my $file;\n    lives_ok { $file = read_file('test.txt') } 'file read';\n\n    # or if you don't like prototypes\n    lives_ok( sub { $file = read_file('test.txt') }, 'file read' );\n\nShould a lives_ok() test fail it produces appropriate diagnostic messages. For example:\n\n    not ok 1 - file read\n    #     Failed test (test.t at line 15)\n    # died: open failed (No such file or directory)\n\nA true value is returned if the test succeeds, false otherwise. On exit $@ is guaranteed to be the cause of death (if any).\n\nThe test description is optional, but recommended. \n\n\nsub lives_ok (&;$) {\n    my ( $coderef, $description ) = @_;\n    my $exception = _try_as_caller( $coderef );\n    my $ok = $Tester->ok( ! _is_exception( $exception ), $description );\n\t$Tester->diag( _exception_as_string( \"died:\", $exception ) ) unless $ok;\n    $@ = $exception;\n    return $ok;\n}\n\n\n* B<throws_ok>\n\nTests to see that a specific exception is thrown. throws_ok() has two forms: \n\n  throws_ok BLOCK REGEX, TEST_DESCRIPTION\n  throws_ok BLOCK CLASS, TEST_DESCRIPTION\n\nIn the first form the test passes if the stringified exception matches the give regular expression. For example:\n\n    throws_ok { read_file( 'unreadable' ) } qr/No file/, 'no file';\n\nIf your perl does not support C<qr//> you can also pass a regex-like string, for example:\n\n    throws_ok { read_file( 'unreadable' ) } '/No file/', 'no file';\n\nThe second form of throws_ok() test passes if the exception is of the same class as the one supplied, or a subclass of that class. For example:\n\n    throws_ok { $foo->bar } \"Error::Simple\", 'simple error';\n\nWill only pass if the C<bar> method throws an Error::Simple exception, or a subclass of an Error::Simple exception.\n\nYou can get the same effect by passing an instance of the exception you want to look for. The following is equivalent to the previous example:\n\n    my $SIMPLE = Error::Simple->new;\n    throws_ok { $foo->bar } $SIMPLE, 'simple error';\n\nShould a throws_ok() test fail it produces appropriate diagnostic messages. For example:\n\n    not ok 3 - simple error\n    #     Failed test (test.t at line 48)\n    # expecting: Error::Simple exception\n    # found: normal exit\n\nLike all other Test::Exception functions you can avoid prototypes by passing a subroutine explicitly:\n\n    throws_ok( sub {$foo->bar}, \"Error::Simple\", 'simple error' );\n\nA true value is returned if the test succeeds, false otherwise. On exit $@ is guaranteed to be the cause of death (if any).\n\nA description of the exception being checked is used if no optional test description is passed.\n\n\n\nsub throws_ok (&$;$) {\n    my ( $coderef, $expecting, $description ) = @_;\n    croak \"throws_ok: must pass exception class/object or regex\" \n        unless defined $expecting;\n    $description = _exception_as_string( \"threw\", $expecting )\n    \tunless defined $description;\n    my $exception = _try_as_caller( $coderef );\n    my $regex = $Tester->maybe_regex( $expecting );\n    my $ok = $regex \n        ? ( $exception =~ m/$regex/ ) \n        : eval { \n            $exception->isa( ref $expecting ? ref $expecting : $expecting ) \n        };\n    $Tester->ok( $ok, $description );\n    unless ( $ok ) {\n        $Tester->diag( _exception_as_string( \"expecting:\", $expecting ) );\n        $Tester->diag( _exception_as_string( \"found:\", $exception ) );\n    };\n    $@ = $exception;\n    return $ok;\n};\n\n\n* B<lives_and>\n\nRun a test that may throw an exception. For example, instead of doing:\n\n  my $file;\n  lives_ok { $file = read_file('answer.txt') } 'read_file worked';\n  is $file, \"42\", 'answer was 42';\n\nYou can use lives_and() like this:\n\n  lives_and { is read_file('answer.txt'), \"42\" } 'answer is 42';\n  # or if you don't like prototypes\n  lives_and(sub {is read_file('answer.txt'), \"42\"}, 'answer is 42');\n\nWhich is the same as doing\n\n  is read_file('answer.txt'), \"42\\n\", 'answer is 42';\n\nunless C<read_file('answer.txt')> dies, in which case you get the same kind of error as lives_ok()\n\n  not ok 1 - answer is 42\n  #     Failed test (test.t at line 15)\n  # died: open failed (No such file or directory)\n\nA true value is returned if the test succeeds, false otherwise. On exit $@ is guaranteed to be the cause of death (if any).\n\nThe test description is optional, but recommended.","label":"lives_and(&;$)"},"line":273,"range":{"start":{"character":0,"line":273},"end":{"character":9999,"line":293}},"kind":12,"definition":"sub","detail":"(&;$)","children":[{"name":"$test","containerName":"lives_and","localvar":"my","kind":13,"line":274,"definition":"my"},{"line":274,"kind":13,"containerName":"lives_and","name":"$description"},{"name":"$Test","containerName":"lives_and","kind":13,"line":276},{"name":"$Test","containerName":"lives_and","kind":13,"line":276},{"localvar":"my","containerName":"lives_and","kind":13,"name":"$ok","line":277,"definition":"my"},{"name":"$description","containerName":"lives_and","kind":13,"line":280},{"name":"$ok","kind":13,"containerName":"lives_and","line":281},{"line":284,"containerName":"lives_and","kind":13,"name":"$test"},{"definition":"my","name":"$exception","containerName":"lives_and","localvar":"my","kind":13,"line":286},{"containerName":"lives_and","kind":13,"name":"$exception","line":287},{"line":288,"containerName":"lives_and","kind":13,"name":"$Tester"},{"containerName":"lives_and","kind":12,"name":"ok","line":288},{"kind":13,"containerName":"lives_and","name":"$description","line":288},{"name":"$Tester","containerName":"lives_and","kind":13,"line":289},{"line":289,"kind":12,"containerName":"lives_and","name":"diag"},{"line":289,"kind":13,"containerName":"lives_and","name":"$exception"},{"line":291,"containerName":"lives_and","kind":13,"name":"$exception"}],"containerName":"main::","name":"lives_and"},{"line":276,"name":"Builder","containerName":"Level","kind":12},{"line":276,"name":"Builder","kind":12,"containerName":"Level"},{"line":278,"name":"warnings","kind":12},{"kind":12,"containerName":"Builder::ok","name":"Test","line":279},{"name":"Builder","containerName":"ok","kind":12,"line":279},{"containerName":"","kind":2,"name":"warnings","line":284}]}