{"vars":[{"name":"base","containerName":"","kind":2,"line":141},{"containerName":"main::","name":"seq","children":[{"definition":"my","line":164,"localvar":"my","containerName":"seq","kind":13,"name":"$self"},{"line":165,"name":"$self","kind":13,"containerName":"seq"},{"containerName":"seq","kind":12,"name":"throw_not_implemented","line":165}],"detail":"($self)","definition":"sub","range":{"end":{"character":9999,"line":166},"start":{"line":163,"character":0}},"kind":12,"line":163,"signature":{"label":"seq($self)","documentation":"1;\n# $Id: PrimarySeqI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI [Developers] - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # accessors\n\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n    # object manipulation\n\n    eval {\n\t$rev    = $obj->revcom();\n    };\n    if( $@ ) {\n\t$obj->throw(-class => 'Bio::Root::Exception',\n                    -text => \"Could not reverse complement. \".\n\t\t             \"Probably not DNA. Actual exception\\n$@\\n\",\n                    -value => $@);\n    }\n\n    $trunc = $obj->trunc(12,50);\n\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in Bio::PrimarySeq. If you just want to\nuse Bio::PrimarySeq objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence, without providing an implementation of this. (An\nimplementation is provided in Bio::PrimarySeq). If you want to provide\na Bio::PrimarySeq 'compliant' object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inheriet\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual","parameters":[{"label":"$self"}]}},{"kind":12,"range":{"start":{"character":0,"line":184},"end":{"line":187,"character":9999}},"line":184,"signature":{"documentation":"1;\n# $Id: PrimarySeqI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI [Developers] - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # accessors\n\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n    # object manipulation\n\n    eval {\n\t$rev    = $obj->revcom();\n    };\n    if( $@ ) {\n\t$obj->throw(-class => 'Bio::Root::Exception',\n                    -text => \"Could not reverse complement. \".\n\t\t             \"Probably not DNA. Actual exception\\n$@\\n\",\n                    -value => $@);\n    }\n\n    $trunc = $obj->trunc(12,50);\n\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in Bio::PrimarySeq. If you just want to\nuse Bio::PrimarySeq objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence, without providing an implementation of this. (An\nimplementation is provided in Bio::PrimarySeq). If you want to provide\na Bio::PrimarySeq 'compliant' object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inheriet\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : a string\n Args    :\n Status  : Virtual","parameters":[{"label":"$self"}],"label":"subseq($self)"},"name":"subseq","containerName":"main::","children":[{"name":"$self","containerName":"subseq","localvar":"my","kind":13,"line":185,"definition":"my"},{"name":"$self","containerName":"subseq","kind":13,"line":186},{"kind":12,"containerName":"subseq","name":"throw_not_implemented","line":186}],"detail":"($self)","definition":"sub"},{"children":[{"definition":"my","line":216,"localvar":"my","kind":13,"containerName":"display_id","name":"$self"},{"line":217,"name":"$self","containerName":"display_id","kind":13},{"line":217,"containerName":"display_id","kind":12,"name":"throw_not_implemented"}],"containerName":"main::","name":"display_id","definition":"sub","detail":"($self)","line":215,"range":{"end":{"character":9999,"line":218},"start":{"character":0,"line":215}},"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PrimarySeqI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI [Developers] - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # accessors\n\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n    # object manipulation\n\n    eval {\n\t$rev    = $obj->revcom();\n    };\n    if( $@ ) {\n\t$obj->throw(-class => 'Bio::Root::Exception',\n                    -text => \"Could not reverse complement. \".\n\t\t             \"Probably not DNA. Actual exception\\n$@\\n\",\n                    -value => $@);\n    }\n\n    $trunc = $obj->trunc(12,50);\n\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in Bio::PrimarySeq. If you just want to\nuse Bio::PrimarySeq objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence, without providing an implementation of this. (An\nimplementation is provided in Bio::PrimarySeq). If you want to provide\na Bio::PrimarySeq 'compliant' object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inheriet\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : a string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues\n Returns : A string\n Args    : None\n Status  : Virtual","label":"display_id($self)"}},{"children":[{"containerName":"accession_number","localvar":"my","kind":13,"name":"$self","line":242,"definition":"my"},{"line":242,"containerName":"accession_number","kind":13,"name":"@args"},{"line":243,"name":"$self","containerName":"accession_number","kind":13},{"kind":12,"containerName":"accession_number","name":"throw_not_implemented","line":243}],"containerName":"main::","name":"accession_number","definition":"sub","detail":"($self,@args)","line":241,"range":{"end":{"character":9999,"line":244},"start":{"character":0,"line":241}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: PrimarySeqI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI [Developers] - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # accessors\n\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n    # object manipulation\n\n    eval {\n\t$rev    = $obj->revcom();\n    };\n    if( $@ ) {\n\t$obj->throw(-class => 'Bio::Root::Exception',\n                    -text => \"Could not reverse complement. \".\n\t\t             \"Probably not DNA. Actual exception\\n$@\\n\",\n                    -value => $@);\n    }\n\n    $trunc = $obj->trunc(12,50);\n\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in Bio::PrimarySeq. If you just want to\nuse Bio::PrimarySeq objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence, without providing an implementation of this. (An\nimplementation is provided in Bio::PrimarySeq). If you want to provide\na Bio::PrimarySeq 'compliant' object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inheriet\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : a string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual","label":"accession_number($self,@args)"}},{"signature":{"documentation":"1;\n# $Id: PrimarySeqI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI [Developers] - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # accessors\n\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n    # object manipulation\n\n    eval {\n\t$rev    = $obj->revcom();\n    };\n    if( $@ ) {\n\t$obj->throw(-class => 'Bio::Root::Exception',\n                    -text => \"Could not reverse complement. \".\n\t\t             \"Probably not DNA. Actual exception\\n$@\\n\",\n                    -value => $@);\n    }\n\n    $trunc = $obj->trunc(12,50);\n\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in Bio::PrimarySeq. If you just want to\nuse Bio::PrimarySeq objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence, without providing an implementation of this. (An\nimplementation is provided in Bio::PrimarySeq). If you want to provide\na Bio::PrimarySeq 'compliant' object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inheriet\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : a string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n           [Note this method name is likely to change in 1.3]\n\n Returns : A string\n Args    : None\n Status  : Virtual","parameters":[{"label":"$self"},{"label":"@args"}],"label":"primary_id($self,@args)"},"kind":12,"range":{"start":{"character":0,"line":269},"end":{"line":272,"character":9999}},"line":269,"detail":"($self,@args)","definition":"sub","name":"primary_id","containerName":"main::","children":[{"definition":"my","line":270,"name":"$self","kind":13,"localvar":"my","containerName":"primary_id"},{"line":270,"containerName":"primary_id","kind":13,"name":"@args"},{"kind":13,"containerName":"primary_id","name":"$self","line":271},{"line":271,"containerName":"primary_id","kind":12,"name":"throw_not_implemented"}]},{"definition":"sub","detail":"($self,@args)","children":[{"line":300,"localvar":"my","kind":13,"containerName":"can_call_new","name":"$self","definition":"my"},{"line":300,"name":"@args","kind":13,"containerName":"can_call_new"}],"name":"can_call_new","containerName":"main::","signature":{"label":"can_call_new($self,@args)","documentation":"1;\n# $Id: PrimarySeqI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI [Developers] - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # accessors\n\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n    # object manipulation\n\n    eval {\n\t$rev    = $obj->revcom();\n    };\n    if( $@ ) {\n\t$obj->throw(-class => 'Bio::Root::Exception',\n                    -text => \"Could not reverse complement. \".\n\t\t             \"Probably not DNA. Actual exception\\n$@\\n\",\n                    -value => $@);\n    }\n\n    $trunc = $obj->trunc(12,50);\n\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in Bio::PrimarySeq. If you just want to\nuse Bio::PrimarySeq objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence, without providing an implementation of this. (An\nimplementation is provided in Bio::PrimarySeq). If you want to provide\na Bio::PrimarySeq 'compliant' object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inheriet\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : a string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n           [Note this method name is likely to change in 1.3]\n\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :","parameters":[{"label":"$self"},{"label":"@args"}]},"line":299,"kind":12,"range":{"end":{"character":9999,"line":305},"start":{"line":299,"character":0}}},{"detail":"($self)","definition":"sub","name":"alphabet","containerName":"main::","children":[{"definition":"my","line":327,"localvar":"my","kind":13,"containerName":"alphabet","name":"$self"},{"line":328,"name":"$self","kind":13,"containerName":"alphabet"},{"line":328,"containerName":"alphabet","kind":12,"name":"throw_not_implemented"}],"signature":{"label":"alphabet($self)","documentation":"1;\n# $Id: PrimarySeqI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI [Developers] - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # accessors\n\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n    # object manipulation\n\n    eval {\n\t$rev    = $obj->revcom();\n    };\n    if( $@ ) {\n\t$obj->throw(-class => 'Bio::Root::Exception',\n                    -text => \"Could not reverse complement. \".\n\t\t             \"Probably not DNA. Actual exception\\n$@\\n\",\n                    -value => $@);\n    }\n\n    $trunc = $obj->trunc(12,50);\n\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in Bio::PrimarySeq. If you just want to\nuse Bio::PrimarySeq objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence, without providing an implementation of this. (An\nimplementation is provided in Bio::PrimarySeq). If you want to provide\na Bio::PrimarySeq 'compliant' object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inheriet\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : a string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n           [Note this method name is likely to change in 1.3]\n\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n\n   # we default to 0 here\n\n   return 0;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no type specified it\n           has to guess.\n Args    : none\n Status  : Virtual","parameters":[{"label":"$self"}]},"range":{"end":{"character":9999,"line":329},"start":{"character":0,"line":326}},"kind":12,"line":326},{"name":"moltype","containerName":"main::","children":[{"definition":"my","line":332,"containerName":"moltype","localvar":"my","kind":13,"name":"$self"},{"line":332,"kind":13,"containerName":"moltype","name":"@args"},{"name":"$self","containerName":"moltype","kind":13,"line":334},{"name":"warn","kind":12,"containerName":"moltype","line":334},{"line":335,"kind":13,"containerName":"moltype","name":"$self"},{"name":"alphabet","kind":12,"containerName":"moltype","line":335},{"kind":13,"containerName":"moltype","name":"@args","line":335}],"detail":"($self,@args)","definition":"sub","range":{"end":{"line":336,"character":9999},"start":{"character":0,"line":331}},"kind":12,"line":331,"signature":{"label":"moltype($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":""}},{"children":[{"definition":"my","line":383,"localvar":"my","containerName":"revcom","kind":13,"name":"$self"},{"containerName":"revcom","localvar":"my","kind":13,"name":"$t","line":387,"definition":"my"},{"line":387,"name":"$self","kind":13,"containerName":"revcom"},{"line":387,"name":"alphabet","kind":12,"containerName":"revcom"},{"line":389,"kind":13,"containerName":"revcom","name":"$t"},{"name":"$self","kind":13,"containerName":"revcom","line":390},{"line":390,"name":"throw","kind":12,"containerName":"revcom"},{"containerName":"revcom","kind":13,"name":"$t","line":394},{"name":"$t","containerName":"revcom","kind":13,"line":394},{"name":"$self","kind":13,"containerName":"revcom","line":395},{"line":395,"name":"can","kind":12,"containerName":"revcom"},{"line":396,"name":"$self","kind":13,"containerName":"revcom"},{"kind":12,"containerName":"revcom","name":"warn","line":396},{"definition":"my","name":"$str","kind":13,"localvar":"my","containerName":"revcom","line":406},{"name":"$self","kind":13,"containerName":"revcom","line":406},{"line":406,"name":"seq","kind":12,"containerName":"revcom"},{"line":410,"containerName":"revcom","kind":13,"name":"$t"},{"line":411,"name":"$str","kind":13,"containerName":"revcom"},{"kind":13,"containerName":"revcom","name":"$str","line":416},{"definition":"my","localvar":"my","kind":13,"containerName":"revcom","name":"$revseq","line":417},{"line":417,"kind":13,"containerName":"revcom","name":"$str"},{"kind":13,"containerName":"revcom","name":"$t","line":419},{"line":420,"name":"$revseq","containerName":"revcom","kind":13},{"name":"$seqclass","localvar":"my","kind":13,"containerName":"revcom","line":423,"definition":"my"},{"kind":13,"containerName":"revcom","name":"$self","line":424},{"line":424,"name":"can_call_new","containerName":"revcom","kind":12},{"line":425,"name":"$seqclass","kind":13,"containerName":"revcom"},{"line":425,"kind":13,"containerName":"revcom","name":"$self"},{"name":"$seqclass","kind":13,"containerName":"revcom","line":427},{"name":"$self","containerName":"revcom","kind":13,"line":428},{"name":"_attempt_to_load_Seq","kind":12,"containerName":"revcom","line":428},{"localvar":"my","kind":13,"containerName":"revcom","name":"$out","line":430,"definition":"my"},{"line":430,"kind":13,"containerName":"revcom","name":"$seqclass"},{"kind":12,"containerName":"revcom","name":"new","line":430},{"kind":13,"containerName":"revcom","name":"$revseq","line":430},{"name":"$self","containerName":"revcom","kind":13,"line":431},{"line":431,"containerName":"revcom","kind":12,"name":"display_id"},{"line":432,"name":"$self","kind":13,"containerName":"revcom"},{"name":"accession_number","kind":12,"containerName":"revcom","line":432},{"kind":13,"containerName":"revcom","name":"$self","line":433},{"containerName":"revcom","kind":12,"name":"alphabet","line":433},{"line":434,"name":"$self","containerName":"revcom","kind":13},{"line":434,"containerName":"revcom","kind":12,"name":"desc"},{"kind":13,"containerName":"revcom","name":"$out","line":436}],"containerName":"main::","name":"revcom","definition":"sub","detail":"($self)","line":382,"kind":12,"range":{"end":{"line":438,"character":9999},"start":{"line":382,"character":0}},"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PrimarySeqI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI [Developers] - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # accessors\n\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n    # object manipulation\n\n    eval {\n\t$rev    = $obj->revcom();\n    };\n    if( $@ ) {\n\t$obj->throw(-class => 'Bio::Root::Exception',\n                    -text => \"Could not reverse complement. \".\n\t\t             \"Probably not DNA. Actual exception\\n$@\\n\",\n                    -value => $@);\n    }\n\n    $trunc = $obj->trunc(12,50);\n\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in Bio::PrimarySeq. If you just want to\nuse Bio::PrimarySeq objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence, without providing an implementation of this. (An\nimplementation is provided in Bio::PrimarySeq). If you want to provide\na Bio::PrimarySeq 'compliant' object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inheriet\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : a string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n           [Note this method name is likely to change in 1.3]\n\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n\n   # we default to 0 here\n\n   return 0;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no type specified it\n           has to guess.\n Args    : none\n Status  : Virtual\n\n\n\nsub alphabet{\n    my ( $self ) = @_;\n    $self->throw_not_implemented();\n}\n\nsub moltype{\n   my ($self,@args) = @_;\n\n   $self->warn(\"moltype: pre v1.0 method. Calling alphabet() instead...\");\n   $self->alphabet(@args);\n}\n\n\n=head1 Optional Implementation Functions\n\nThe following functions rely on the above functions. An\nimplementing class does not need to provide these functions, as they\nwill be provided by this class, but is free to override these\nfunctions.\n\nAll of revcom(), trunc(), and translate() create new sequence\nobjects. They will call new() on the class of the sequence object\ninstance passed as argument, unless can_call_new() returns FALSE. In\nthe latter case a Bio::PrimarySeq object will be created. Implementors\nwhich really want to control how objects are created (eg, for object\npersistence over a database, or objects in a CORBA framework), they\nare encouraged to override these methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::PrimarySeqI implementing object which\n           is the reversed complement of the sequence. For protein\n           sequences this throws an exception of \"Sequence is a\n           protein. Cannot revcom\"\n\n           The id is the same id as the original sequence, and the\n           accession number is also indentical. If someone wants to\n           track that this sequence has be reversed, it needs to\n           define its own extensions\n\n           To do an inplace edit of an object you can go:\n\n           $seq = $seq->revcom();\n\n           This of course, causes Perl to handle the garbage\n           collection of the old object, but it is roughly speaking as\n           efficient as an inplace edit.\n\n Returns : A new (fresh) Bio::PrimarySeqI object\n Args    : none","label":"revcom($self)"}},{"line":419,"name":"CORE","containerName":"reverse","kind":12},{"signature":{"label":"trunc($self,$start,$end)","documentation":"1;\n# $Id: PrimarySeqI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI [Developers] - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # accessors\n\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n    # object manipulation\n\n    eval {\n\t$rev    = $obj->revcom();\n    };\n    if( $@ ) {\n\t$obj->throw(-class => 'Bio::Root::Exception',\n                    -text => \"Could not reverse complement. \".\n\t\t             \"Probably not DNA. Actual exception\\n$@\\n\",\n                    -value => $@);\n    }\n\n    $trunc = $obj->trunc(12,50);\n\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in Bio::PrimarySeq. If you just want to\nuse Bio::PrimarySeq objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence, without providing an implementation of this. (An\nimplementation is provided in Bio::PrimarySeq). If you want to provide\na Bio::PrimarySeq 'compliant' object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inheriet\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : a string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n           [Note this method name is likely to change in 1.3]\n\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n\n   # we default to 0 here\n\n   return 0;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no type specified it\n           has to guess.\n Args    : none\n Status  : Virtual\n\n\n\nsub alphabet{\n    my ( $self ) = @_;\n    $self->throw_not_implemented();\n}\n\nsub moltype{\n   my ($self,@args) = @_;\n\n   $self->warn(\"moltype: pre v1.0 method. Calling alphabet() instead...\");\n   $self->alphabet(@args);\n}\n\n\n=head1 Optional Implementation Functions\n\nThe following functions rely on the above functions. An\nimplementing class does not need to provide these functions, as they\nwill be provided by this class, but is free to override these\nfunctions.\n\nAll of revcom(), trunc(), and translate() create new sequence\nobjects. They will call new() on the class of the sequence object\ninstance passed as argument, unless can_call_new() returns FALSE. In\nthe latter case a Bio::PrimarySeq object will be created. Implementors\nwhich really want to control how objects are created (eg, for object\npersistence over a database, or objects in a CORBA framework), they\nare encouraged to override these methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::PrimarySeqI implementing object which\n           is the reversed complement of the sequence. For protein\n           sequences this throws an exception of \"Sequence is a\n           protein. Cannot revcom\"\n\n           The id is the same id as the original sequence, and the\n           accession number is also indentical. If someone wants to\n           track that this sequence has be reversed, it needs to\n           define its own extensions\n\n           To do an inplace edit of an object you can go:\n\n           $seq = $seq->revcom();\n\n           This of course, causes Perl to handle the garbage\n           collection of the old object, but it is roughly speaking as\n           efficient as an inplace edit.\n\n Returns : A new (fresh) Bio::PrimarySeqI object\n Args    : none\n\n\n\nsub revcom{\n   my ($self) = @_;\n\n\n   # check the type is good first.\n   my $t = $self->alphabet;\n\n   if( $t eq 'protein' ) {\n       $self->throw(-class => 'Bio::Root::Exception',\n\t\t    -text  => \"Sequence is a protein. Cannot revcom\");\n   }\n\n   if( $t ne 'dna' && $t ne 'rna' ) {\n       if( $self->can('warn') ) {\n\t   $self->warn(\"Sequence is not dna or rna, but [$t]. \".\n\t\t       \"Attempting to revcom, but unsure if this is right\");\n       } else {\n\t   warn(\"[$self] Sequence is not dna or rna, but [$t]. \".\n\t\t\"Attempting to revcom, but unsure if this is right\");\n       }\n   }\n\n   # yank out the sequence string\n\n   my $str = $self->seq();\n\n   # if is RNA - map to DNA then map back\n\n   if( $t eq 'rna' ) {\n       $str =~ tr/uU/tT/;\n   }\n\n   # revcom etc...\n\n   $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n   my $revseq = CORE::reverse $str;\n\n   if( $t eq 'rna' ) {\n       $revseq =~ tr/tT/uU/;\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n   my $out = $seqclass->new( '-seq' => $revseq,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n\n}\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence,\n\n Example :\n Returns : a fresh Bio::PrimarySeqI implementing object\n Args    : Two integers denoting first and last base of the sub-sequence.","parameters":[{"label":"$self"},{"label":"$start"},{"label":"$end"}]},"range":{"start":{"line":453,"character":0},"end":{"character":9999,"line":486}},"kind":12,"line":453,"detail":"($self,$start,$end)","definition":"sub","name":"trunc","containerName":"main::","children":[{"definition":"my","line":454,"name":"$self","containerName":"trunc","localvar":"my","kind":13},{"line":454,"containerName":"trunc","kind":13,"name":"$start"},{"name":"$end","kind":13,"containerName":"trunc","line":454},{"line":456,"containerName":"trunc","localvar":"my","kind":13,"name":"$str","definition":"my"},{"name":"$start","kind":13,"containerName":"trunc","line":457},{"line":457,"name":"$start","containerName":"trunc","kind":13},{"line":458,"name":"$start","containerName":"trunc","kind":13},{"line":458,"name":"isa","containerName":"trunc","kind":12},{"line":459,"name":"$str","kind":13,"containerName":"trunc"},{"kind":13,"containerName":"trunc","name":"$self","line":459},{"line":459,"name":"subseq","kind":12,"containerName":"trunc"},{"kind":13,"containerName":"trunc","name":"$start","line":459},{"line":460,"kind":13,"containerName":"trunc","name":"$end"},{"kind":13,"containerName":"trunc","name":"$self","line":461},{"containerName":"trunc","kind":12,"name":"throw","line":461},{"name":"$end","containerName":"trunc","kind":13,"line":462},{"line":462,"kind":13,"containerName":"trunc","name":"$start"},{"name":"$msg","kind":13,"localvar":"my","containerName":"trunc","line":463,"definition":"my"},{"line":466,"name":"$self","kind":13,"containerName":"trunc"},{"line":466,"name":"throw","kind":12,"containerName":"trunc"},{"kind":13,"containerName":"trunc","name":"$msg","line":466},{"line":468,"kind":13,"containerName":"trunc","name":"$str"},{"name":"$self","kind":13,"containerName":"trunc","line":468},{"containerName":"trunc","kind":12,"name":"subseq","line":468},{"line":468,"kind":13,"containerName":"trunc","name":"$start"},{"line":468,"name":"$end","kind":13,"containerName":"trunc"},{"definition":"my","name":"$seqclass","localvar":"my","kind":13,"containerName":"trunc","line":471},{"line":472,"name":"$self","kind":13,"containerName":"trunc"},{"line":472,"name":"can_call_new","kind":12,"containerName":"trunc"},{"line":473,"containerName":"trunc","kind":13,"name":"$seqclass"},{"name":"$self","containerName":"trunc","kind":13,"line":473},{"line":475,"name":"$seqclass","containerName":"trunc","kind":13},{"line":476,"containerName":"trunc","kind":13,"name":"$self"},{"name":"_attempt_to_load_Seq","kind":12,"containerName":"trunc","line":476},{"definition":"my","name":"$out","containerName":"trunc","localvar":"my","kind":13,"line":479},{"containerName":"trunc","kind":13,"name":"$seqclass","line":479},{"name":"new","containerName":"trunc","kind":12,"line":479},{"line":479,"name":"$str","containerName":"trunc","kind":13},{"line":480,"name":"$self","containerName":"trunc","kind":13},{"line":480,"kind":12,"containerName":"trunc","name":"display_id"},{"line":481,"name":"$self","containerName":"trunc","kind":13},{"line":481,"containerName":"trunc","kind":12,"name":"accession_number"},{"kind":13,"containerName":"trunc","name":"$self","line":482},{"containerName":"trunc","kind":12,"name":"alphabet","line":482},{"kind":13,"containerName":"trunc","name":"$self","line":483},{"name":"desc","containerName":"trunc","kind":12,"line":483},{"line":485,"name":"$out","kind":13,"containerName":"trunc"}]},{"definition":"sub","detail":"($stop,$unknown,$frame,$tableid,$fullCDS,$throw)","children":[{"definition":"my","line":519,"name":"$self","localvar":"my","kind":13,"containerName":"translate"},{"definition":"my","line":520,"kind":13,"localvar":"my","containerName":"translate","name":"$stop"},{"kind":13,"containerName":"translate","name":"$unknown","line":520},{"line":520,"name":"$frame","containerName":"translate","kind":13},{"name":"$tableid","containerName":"translate","kind":13,"line":520},{"name":"$fullCDS","kind":13,"containerName":"translate","line":520},{"line":520,"kind":13,"containerName":"translate","name":"$throw"},{"line":521,"localvar":"my","kind":13,"containerName":"translate","name":"$i","definition":"my"},{"name":"$len","kind":13,"containerName":"translate","line":521},{"line":521,"name":"$output","kind":13,"containerName":"translate"},{"definition":"my","localvar":"my","containerName":"translate","kind":13,"name":"$codon","line":522},{"definition":"my","line":523,"name":"$aa","containerName":"translate","localvar":"my","kind":13},{"kind":13,"containerName":"translate","name":"$stop","line":526},{"line":526,"name":"$stop","kind":13,"containerName":"translate"},{"line":526,"name":"$stop","kind":13,"containerName":"translate"},{"kind":13,"containerName":"translate","name":"$unknown","line":527},{"line":527,"name":"$unknown","kind":13,"containerName":"translate"},{"line":527,"containerName":"translate","kind":13,"name":"$unknown"},{"line":528,"name":"$frame","containerName":"translate","kind":13},{"name":"$frame","kind":13,"containerName":"translate","line":528},{"line":528,"kind":13,"containerName":"translate","name":"$frame"},{"name":"$tableid","kind":13,"containerName":"translate","line":531},{"name":"$tableid","kind":13,"containerName":"translate","line":531},{"line":531,"name":"$tableid","kind":13,"containerName":"translate"},{"line":534,"name":"$self","kind":13,"containerName":"translate"},{"name":"alphabet","kind":12,"containerName":"translate","line":534},{"name":"$self","kind":13,"containerName":"translate","line":535},{"name":"throw","containerName":"translate","kind":12,"line":535},{"line":540,"kind":13,"containerName":"translate","name":"$frame"},{"line":540,"kind":13,"containerName":"translate","name":"$frame"},{"kind":13,"containerName":"translate","name":"$frame","line":540},{"name":"$self","containerName":"translate","kind":13,"line":541},{"line":541,"name":"throw","kind":12,"containerName":"translate"},{"kind":13,"containerName":"translate","name":"$frame","line":543},{"containerName":"translate","localvar":"my","kind":13,"name":"$codonTable","line":547,"definition":"my"},{"line":547,"name":"new","kind":12,"containerName":"translate"},{"line":547,"kind":13,"containerName":"translate","name":"$tableid"},{"line":549,"name":"$seq","containerName":"translate","localvar":"my","kind":13,"definition":"my"},{"line":549,"name":"$self","containerName":"translate","kind":13},{"line":549,"kind":12,"containerName":"translate","name":"seq"},{"kind":13,"containerName":"translate","name":"$frame","line":552},{"containerName":"translate","kind":13,"name":"$seq","line":553},{"line":553,"kind":13,"containerName":"translate","name":"$seq"},{"line":553,"name":"$frame","kind":13,"containerName":"translate"},{"name":"$output","kind":13,"containerName":"translate","line":557},{"kind":13,"containerName":"translate","name":"$codonTable","line":557},{"line":557,"kind":12,"containerName":"translate","name":"translate"},{"line":557,"containerName":"translate","kind":13,"name":"$seq"},{"line":559,"containerName":"translate","kind":13,"name":"$output"},{"line":560,"name":"$output","containerName":"translate","kind":13},{"line":563,"containerName":"translate","kind":13,"name":"$fullCDS"},{"line":564,"localvar":"my","containerName":"translate","kind":13,"name":"$id","definition":"my"},{"line":564,"containerName":"translate","kind":13,"name":"$self"},{"line":564,"name":"display_id","containerName":"translate","kind":12},{"line":566,"containerName":"translate","kind":13,"name":"$output"},{"line":566,"name":"$stop","containerName":"translate","kind":13},{"kind":13,"containerName":"translate","name":"$output","line":567},{"line":569,"name":"$throw","containerName":"translate","kind":13},{"line":569,"containerName":"translate","kind":13,"name":"$self"},{"name":"throw","kind":12,"containerName":"translate","line":569},{"line":570,"containerName":"translate","kind":13,"name":"$output"},{"line":571,"name":"$output","containerName":"translate","kind":13},{"kind":13,"containerName":"translate","name":"$self","line":572},{"line":572,"kind":12,"containerName":"translate","name":"warn"},{"kind":13,"containerName":"translate","name":"$output","line":572},{"containerName":"translate","kind":13,"name":"$output","line":575},{"name":"$throw","kind":13,"containerName":"translate","line":576},{"line":576,"kind":13,"containerName":"translate","name":"$self"},{"name":"throw","containerName":"translate","kind":12,"line":576},{"line":578,"name":"$self","containerName":"translate","kind":13},{"line":578,"containerName":"translate","kind":12,"name":"warn"},{"name":"$output","kind":13,"containerName":"translate","line":581},{"line":582,"name":"$codonTable","kind":13,"containerName":"translate"},{"name":"is_start_codon","kind":12,"containerName":"translate","line":582},{"kind":13,"containerName":"translate","name":"$seq","line":582},{"line":583,"kind":13,"containerName":"translate","name":"$output"},{"kind":13,"containerName":"translate","name":"$output","line":583},{"line":585,"name":"$throw","containerName":"translate","kind":13},{"line":586,"name":"$self","containerName":"translate","kind":13},{"kind":12,"containerName":"translate","name":"throw","line":586},{"kind":13,"containerName":"translate","name":"$seq","line":587},{"kind":13,"containerName":"translate","name":"$seq","line":588},{"line":590,"kind":13,"containerName":"translate","name":"$self"},{"line":590,"kind":12,"containerName":"translate","name":"warn"},{"name":"$seqclass","kind":13,"localvar":"my","containerName":"translate","line":595,"definition":"my"},{"name":"$self","kind":13,"containerName":"translate","line":596},{"name":"can_call_new","containerName":"translate","kind":12,"line":596},{"line":597,"kind":13,"containerName":"translate","name":"$seqclass"},{"name":"$self","kind":13,"containerName":"translate","line":597},{"name":"$seqclass","kind":13,"containerName":"translate","line":599},{"line":600,"containerName":"translate","kind":13,"name":"$self"},{"kind":12,"containerName":"translate","name":"_attempt_to_load_Seq","line":600},{"localvar":"my","kind":13,"containerName":"translate","name":"$out","line":602,"definition":"my"},{"line":602,"name":"$seqclass","kind":13,"containerName":"translate"},{"name":"new","containerName":"translate","kind":12,"line":602},{"line":602,"name":"$output","kind":13,"containerName":"translate"},{"kind":13,"containerName":"translate","name":"$self","line":603},{"line":603,"containerName":"translate","kind":12,"name":"display_id"},{"line":604,"name":"$self","kind":13,"containerName":"translate"},{"line":604,"containerName":"translate","kind":12,"name":"accession_number"},{"kind":13,"containerName":"translate","name":"$self","line":607},{"kind":12,"containerName":"translate","name":"desc","line":607},{"line":610,"name":"$out","containerName":"translate","kind":13}],"name":"translate","containerName":"main::","signature":{"label":"translate($stop,$unknown,$frame,$tableid,$fullCDS,$throw)","documentation":"1;\n# $Id: PrimarySeqI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI [Developers] - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # accessors\n\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n    # object manipulation\n\n    eval {\n\t$rev    = $obj->revcom();\n    };\n    if( $@ ) {\n\t$obj->throw(-class => 'Bio::Root::Exception',\n                    -text => \"Could not reverse complement. \".\n\t\t             \"Probably not DNA. Actual exception\\n$@\\n\",\n                    -value => $@);\n    }\n\n    $trunc = $obj->trunc(12,50);\n\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in Bio::PrimarySeq. If you just want to\nuse Bio::PrimarySeq objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence, without providing an implementation of this. (An\nimplementation is provided in Bio::PrimarySeq). If you want to provide\na Bio::PrimarySeq 'compliant' object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inheriet\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : a string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n           [Note this method name is likely to change in 1.3]\n\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n\n   # we default to 0 here\n\n   return 0;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no type specified it\n           has to guess.\n Args    : none\n Status  : Virtual\n\n\n\nsub alphabet{\n    my ( $self ) = @_;\n    $self->throw_not_implemented();\n}\n\nsub moltype{\n   my ($self,@args) = @_;\n\n   $self->warn(\"moltype: pre v1.0 method. Calling alphabet() instead...\");\n   $self->alphabet(@args);\n}\n\n\n=head1 Optional Implementation Functions\n\nThe following functions rely on the above functions. An\nimplementing class does not need to provide these functions, as they\nwill be provided by this class, but is free to override these\nfunctions.\n\nAll of revcom(), trunc(), and translate() create new sequence\nobjects. They will call new() on the class of the sequence object\ninstance passed as argument, unless can_call_new() returns FALSE. In\nthe latter case a Bio::PrimarySeq object will be created. Implementors\nwhich really want to control how objects are created (eg, for object\npersistence over a database, or objects in a CORBA framework), they\nare encouraged to override these methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::PrimarySeqI implementing object which\n           is the reversed complement of the sequence. For protein\n           sequences this throws an exception of \"Sequence is a\n           protein. Cannot revcom\"\n\n           The id is the same id as the original sequence, and the\n           accession number is also indentical. If someone wants to\n           track that this sequence has be reversed, it needs to\n           define its own extensions\n\n           To do an inplace edit of an object you can go:\n\n           $seq = $seq->revcom();\n\n           This of course, causes Perl to handle the garbage\n           collection of the old object, but it is roughly speaking as\n           efficient as an inplace edit.\n\n Returns : A new (fresh) Bio::PrimarySeqI object\n Args    : none\n\n\n\nsub revcom{\n   my ($self) = @_;\n\n\n   # check the type is good first.\n   my $t = $self->alphabet;\n\n   if( $t eq 'protein' ) {\n       $self->throw(-class => 'Bio::Root::Exception',\n\t\t    -text  => \"Sequence is a protein. Cannot revcom\");\n   }\n\n   if( $t ne 'dna' && $t ne 'rna' ) {\n       if( $self->can('warn') ) {\n\t   $self->warn(\"Sequence is not dna or rna, but [$t]. \".\n\t\t       \"Attempting to revcom, but unsure if this is right\");\n       } else {\n\t   warn(\"[$self] Sequence is not dna or rna, but [$t]. \".\n\t\t\"Attempting to revcom, but unsure if this is right\");\n       }\n   }\n\n   # yank out the sequence string\n\n   my $str = $self->seq();\n\n   # if is RNA - map to DNA then map back\n\n   if( $t eq 'rna' ) {\n       $str =~ tr/uU/tT/;\n   }\n\n   # revcom etc...\n\n   $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n   my $revseq = CORE::reverse $str;\n\n   if( $t eq 'rna' ) {\n       $revseq =~ tr/tT/uU/;\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n   my $out = $seqclass->new( '-seq' => $revseq,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n\n}\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence,\n\n Example :\n Returns : a fresh Bio::PrimarySeqI implementing object\n Args    : Two integers denoting first and last base of the sub-sequence.\n\n\n\nsub trunc{\n   my ($self,$start,$end) = @_;\n\n   my $str;\n   if( defined $start && ref($start) &&\n       $start->isa('Bio::LocationI') ) {\n       $str = $self->subseq($start); # start is a location actually\n   } elsif( !$end ) {\n       $self->throw(\"trunc start,end -- there was no end for $start\");\n   } elsif( $end < $start ) {\n       my $msg = \"start [$start] is greater than end [$end]. \\n\".\n\t   \"If you want to truncated and reverse complement, \\n\".\n\t       \"you must call trunc followed by revcom. Sorry.\";\n       $self->throw($msg);\n   } else {\n       $str = $self->subseq($start,$end);\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n\n   my $out = $seqclass->new( '-seq' => $str,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n}\n\n\n=head2 translate\n\n Title   : translate\n Usage   : $protein_seq_obj = $dna_seq_obj->translate\n\n Function:\n\n           Provides the translation of the DNA sequence using full\n           IUPAC ambiguities in DNA/RNA and amino acid codes.\n\n           The full CDS translation is identical to EMBL/TREMBL\n           database translation. Note that the trailing terminator\n           character is removed before returning the translation\n           object.\n\n           Note: if you set $dna_seq_obj->verbose(1) you will get a\n           warning if the first codon is not a valid initiator.\n\n\n Returns : A Bio::PrimarySeqI implementing object\n Args    : character for terminator (optional) defaults to '*'\n           character for unknown amino acid (optional) defaults to 'X'\n           frame (optional) valid values 0, 1, 2, defaults to 0\n           codon table id (optional) defaults to 1\n           complete coding sequence expected, defaults to 0 (false)\n           boolean, throw exception if not complete CDS (true) or defaults to warning (false)","parameters":[{"label":"$stop"},{"label":"$unknown"},{"label":"$frame"},{"label":"$tableid"},{"label":"$fullCDS"},{"label":"$throw"}]},"line":518,"range":{"start":{"character":0,"line":518},"end":{"character":9999,"line":612}},"kind":12},{"line":547,"name":"Bio","containerName":"Tools::CodonTable","kind":12},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PrimarySeqI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI [Developers] - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # accessors\n\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n    # object manipulation\n\n    eval {\n\t$rev    = $obj->revcom();\n    };\n    if( $@ ) {\n\t$obj->throw(-class => 'Bio::Root::Exception',\n                    -text => \"Could not reverse complement. \".\n\t\t             \"Probably not DNA. Actual exception\\n$@\\n\",\n                    -value => $@);\n    }\n\n    $trunc = $obj->trunc(12,50);\n\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in Bio::PrimarySeq. If you just want to\nuse Bio::PrimarySeq objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence, without providing an implementation of this. (An\nimplementation is provided in Bio::PrimarySeq). If you want to provide\na Bio::PrimarySeq 'compliant' object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inheriet\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : a string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n           [Note this method name is likely to change in 1.3]\n\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n\n   # we default to 0 here\n\n   return 0;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no type specified it\n           has to guess.\n Args    : none\n Status  : Virtual\n\n\n\nsub alphabet{\n    my ( $self ) = @_;\n    $self->throw_not_implemented();\n}\n\nsub moltype{\n   my ($self,@args) = @_;\n\n   $self->warn(\"moltype: pre v1.0 method. Calling alphabet() instead...\");\n   $self->alphabet(@args);\n}\n\n\n=head1 Optional Implementation Functions\n\nThe following functions rely on the above functions. An\nimplementing class does not need to provide these functions, as they\nwill be provided by this class, but is free to override these\nfunctions.\n\nAll of revcom(), trunc(), and translate() create new sequence\nobjects. They will call new() on the class of the sequence object\ninstance passed as argument, unless can_call_new() returns FALSE. In\nthe latter case a Bio::PrimarySeq object will be created. Implementors\nwhich really want to control how objects are created (eg, for object\npersistence over a database, or objects in a CORBA framework), they\nare encouraged to override these methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::PrimarySeqI implementing object which\n           is the reversed complement of the sequence. For protein\n           sequences this throws an exception of \"Sequence is a\n           protein. Cannot revcom\"\n\n           The id is the same id as the original sequence, and the\n           accession number is also indentical. If someone wants to\n           track that this sequence has be reversed, it needs to\n           define its own extensions\n\n           To do an inplace edit of an object you can go:\n\n           $seq = $seq->revcom();\n\n           This of course, causes Perl to handle the garbage\n           collection of the old object, but it is roughly speaking as\n           efficient as an inplace edit.\n\n Returns : A new (fresh) Bio::PrimarySeqI object\n Args    : none\n\n\n\nsub revcom{\n   my ($self) = @_;\n\n\n   # check the type is good first.\n   my $t = $self->alphabet;\n\n   if( $t eq 'protein' ) {\n       $self->throw(-class => 'Bio::Root::Exception',\n\t\t    -text  => \"Sequence is a protein. Cannot revcom\");\n   }\n\n   if( $t ne 'dna' && $t ne 'rna' ) {\n       if( $self->can('warn') ) {\n\t   $self->warn(\"Sequence is not dna or rna, but [$t]. \".\n\t\t       \"Attempting to revcom, but unsure if this is right\");\n       } else {\n\t   warn(\"[$self] Sequence is not dna or rna, but [$t]. \".\n\t\t\"Attempting to revcom, but unsure if this is right\");\n       }\n   }\n\n   # yank out the sequence string\n\n   my $str = $self->seq();\n\n   # if is RNA - map to DNA then map back\n\n   if( $t eq 'rna' ) {\n       $str =~ tr/uU/tT/;\n   }\n\n   # revcom etc...\n\n   $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n   my $revseq = CORE::reverse $str;\n\n   if( $t eq 'rna' ) {\n       $revseq =~ tr/tT/uU/;\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n   my $out = $seqclass->new( '-seq' => $revseq,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n\n}\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence,\n\n Example :\n Returns : a fresh Bio::PrimarySeqI implementing object\n Args    : Two integers denoting first and last base of the sub-sequence.\n\n\n\nsub trunc{\n   my ($self,$start,$end) = @_;\n\n   my $str;\n   if( defined $start && ref($start) &&\n       $start->isa('Bio::LocationI') ) {\n       $str = $self->subseq($start); # start is a location actually\n   } elsif( !$end ) {\n       $self->throw(\"trunc start,end -- there was no end for $start\");\n   } elsif( $end < $start ) {\n       my $msg = \"start [$start] is greater than end [$end]. \\n\".\n\t   \"If you want to truncated and reverse complement, \\n\".\n\t       \"you must call trunc followed by revcom. Sorry.\";\n       $self->throw($msg);\n   } else {\n       $str = $self->subseq($start,$end);\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n\n   my $out = $seqclass->new( '-seq' => $str,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n}\n\n\n=head2 translate\n\n Title   : translate\n Usage   : $protein_seq_obj = $dna_seq_obj->translate\n\n Function:\n\n           Provides the translation of the DNA sequence using full\n           IUPAC ambiguities in DNA/RNA and amino acid codes.\n\n           The full CDS translation is identical to EMBL/TREMBL\n           database translation. Note that the trailing terminator\n           character is removed before returning the translation\n           object.\n\n           Note: if you set $dna_seq_obj->verbose(1) you will get a\n           warning if the first codon is not a valid initiator.\n\n\n Returns : A Bio::PrimarySeqI implementing object\n Args    : character for terminator (optional) defaults to '*'\n           character for unknown amino acid (optional) defaults to 'X'\n           frame (optional) valid values 0, 1, 2, defaults to 0\n           codon table id (optional) defaults to 1\n           complete coding sequence expected, defaults to 0 (false)\n           boolean, throw exception if not complete CDS (true) or defaults to warning (false)\n\n\nsub translate {\n    my($self) = shift;\n    my($stop, $unknown, $frame, $tableid, $fullCDS, $throw) = @_;\n    my($i, $len, $output) = (0,0,'');\n    my($codon)   = \"\";\n    my $aa;\n\n    ## User can pass in symbol for stop and unknown codons\n    unless(defined($stop) and $stop ne '')    { $stop = \"*\"; }\n    unless(defined($unknown) and $unknown ne '') { $unknown = \"X\"; }\n    unless(defined($frame) and $frame ne '') { $frame = 0; }\n\n    ## the codon table ID\n    unless(defined($tableid) and $tableid ne '')    { $tableid = 1; }\n\n    ##Error if monomer is \"Amino\"\n    if ($self->alphabet eq 'protein') {\n\t$self->throw(-class => 'Bio::Root::Exception',\n\t\t     -text => \"Can't translate an amino acid sequence.\")\n    }\n\n    ##Error if frame is not 0, 1 or 2\n    unless ($frame == 0 or $frame == 1 or $frame == 2) {\n\t$self->throw(-class => 'Bio::Root::BadParameter',\n\t\t     -text   => \"Valid values for frame are 0, 1, 2, not [$frame].\",\n\t\t     -value => $frame);\n    }\n\n    #warns if ID is invalid\n    my $codonTable = Bio::Tools::CodonTable->new( -id => $tableid);\n\n    my ($seq) = $self->seq();\n\n    # deal with frame offset.\n    if( $frame ) {\n\t$seq = substr ($seq,$frame);\n    }\n\n    # Translate it\n    $output = $codonTable->translate($seq);\n    # Use user-input stop/unknown\n    $output =~ s/\\*/$stop/g;\n    $output =~ s/X/$unknown/g;\n\t\n    # only if we are expecting to translate a complete coding region\n    if ($fullCDS) {\n\tmy $id = $self->display_id;\n\t#remove the stop character\n\tif( substr($output,-1,1) eq $stop ) {\n\t    chop $output;\n\t} else {\n\t    $throw && $self->throw(-class => 'Bio::Root::Exception',\n\t\t\t\t   -text  => \"Seq [$id]: Not using a valid terminator codon!: \". substr($output,-1,1),\n\t\t\t\t   -value => substr($output,-1,1));\n\t    $self->warn(\"Seq [$id]: Not using a valid terminator codon!: \". substr($output,-1,1));\n\t}\n\t# test if there are terminator characters inside the protein sequence!\n\tif ($output =~ /\\*/) {\n\t    $throw && $self->throw(-class => 'Bio::Root::Exception',\n\t\t\t\t   -text  => \"Seq [$id]: Terminator codon inside CDS!\");\n\t    $self->warn(\"Seq [$id]: Terminator codon inside CDS!\");\n\t}\n\t# if the initiator codon is not ATG, the amino acid needs to changed into M\n\tif ( substr($output,0,1) ne 'M' ) {\n\t    if ($codonTable->is_start_codon(substr($seq, 0, 3)) ) {\n\t\t$output = 'M'. substr($output,1);\n\t    }\n\t    elsif ($throw) {\n\t\t$self->throw(-class => 'Bio::Root::Exception',\n\t\t\t     -text => \"Seq [$id]: Not using a valid initiator codon!: \". substr($seq, 0, 3),\n\t\t\t     -value => substr($seq, 0, 3));\n\t    } else {\n\t\t$self->warn(\"Seq [$id]: Not using a valid initiator codon!\");\n\t    }\n\t}\n    }\n\n    my $seqclass;\n    if($self->can_call_new()) {\n\t$seqclass = ref($self);\n    } else {\n\t$seqclass = 'Bio::PrimarySeq';\n\t$self->_attempt_to_load_Seq();\n    }\n    my $out = $seqclass->new( '-seq' => $output,\n\t\t\t      '-display_id'  => $self->display_id,\n\t\t\t      '-accession_number' => $self->accession_number,\n\t\t\t      # is there anything wrong with retaining the\n\t\t\t      # description?\n\t\t\t      '-desc' => $self->desc(),\n\t\t\t      '-alphabet' => 'protein'\n\t\t\t    );\n    return $out;\n\n}\n\n=head2 id\n\n Title   : id\n Usage   : $id = $seq->id()\n Function: ID of the sequence. This should normally be (and actually is in\n           the implementation provided here) just a synonym for display_id().\n Example :\n Returns : A string.\n Args    :","label":"id($self)"},"range":{"end":{"character":9999,"line":631},"start":{"line":627,"character":0}},"kind":12,"line":627,"detail":"($self)","definition":"sub","containerName":"main::","name":"id","children":[{"line":628,"kind":13,"localvar":"my","containerName":"id","name":"$self","definition":"my"},{"line":630,"name":"$self","containerName":"id","kind":13},{"line":630,"name":"display_id","containerName":"id","kind":12}]},{"detail":"($self)","definition":"sub","containerName":"main::","name":"length","children":[{"line":647,"localvar":"my","containerName":"length","kind":13,"name":"$self","definition":"my"},{"line":648,"kind":13,"containerName":"length","name":"$self"},{"line":648,"name":"throw_not_implemented","containerName":"length","kind":12}],"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PrimarySeqI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI [Developers] - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # accessors\n\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n    # object manipulation\n\n    eval {\n\t$rev    = $obj->revcom();\n    };\n    if( $@ ) {\n\t$obj->throw(-class => 'Bio::Root::Exception',\n                    -text => \"Could not reverse complement. \".\n\t\t             \"Probably not DNA. Actual exception\\n$@\\n\",\n                    -value => $@);\n    }\n\n    $trunc = $obj->trunc(12,50);\n\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in Bio::PrimarySeq. If you just want to\nuse Bio::PrimarySeq objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence, without providing an implementation of this. (An\nimplementation is provided in Bio::PrimarySeq). If you want to provide\na Bio::PrimarySeq 'compliant' object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inheriet\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : a string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n           [Note this method name is likely to change in 1.3]\n\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n\n   # we default to 0 here\n\n   return 0;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no type specified it\n           has to guess.\n Args    : none\n Status  : Virtual\n\n\n\nsub alphabet{\n    my ( $self ) = @_;\n    $self->throw_not_implemented();\n}\n\nsub moltype{\n   my ($self,@args) = @_;\n\n   $self->warn(\"moltype: pre v1.0 method. Calling alphabet() instead...\");\n   $self->alphabet(@args);\n}\n\n\n=head1 Optional Implementation Functions\n\nThe following functions rely on the above functions. An\nimplementing class does not need to provide these functions, as they\nwill be provided by this class, but is free to override these\nfunctions.\n\nAll of revcom(), trunc(), and translate() create new sequence\nobjects. They will call new() on the class of the sequence object\ninstance passed as argument, unless can_call_new() returns FALSE. In\nthe latter case a Bio::PrimarySeq object will be created. Implementors\nwhich really want to control how objects are created (eg, for object\npersistence over a database, or objects in a CORBA framework), they\nare encouraged to override these methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::PrimarySeqI implementing object which\n           is the reversed complement of the sequence. For protein\n           sequences this throws an exception of \"Sequence is a\n           protein. Cannot revcom\"\n\n           The id is the same id as the original sequence, and the\n           accession number is also indentical. If someone wants to\n           track that this sequence has be reversed, it needs to\n           define its own extensions\n\n           To do an inplace edit of an object you can go:\n\n           $seq = $seq->revcom();\n\n           This of course, causes Perl to handle the garbage\n           collection of the old object, but it is roughly speaking as\n           efficient as an inplace edit.\n\n Returns : A new (fresh) Bio::PrimarySeqI object\n Args    : none\n\n\n\nsub revcom{\n   my ($self) = @_;\n\n\n   # check the type is good first.\n   my $t = $self->alphabet;\n\n   if( $t eq 'protein' ) {\n       $self->throw(-class => 'Bio::Root::Exception',\n\t\t    -text  => \"Sequence is a protein. Cannot revcom\");\n   }\n\n   if( $t ne 'dna' && $t ne 'rna' ) {\n       if( $self->can('warn') ) {\n\t   $self->warn(\"Sequence is not dna or rna, but [$t]. \".\n\t\t       \"Attempting to revcom, but unsure if this is right\");\n       } else {\n\t   warn(\"[$self] Sequence is not dna or rna, but [$t]. \".\n\t\t\"Attempting to revcom, but unsure if this is right\");\n       }\n   }\n\n   # yank out the sequence string\n\n   my $str = $self->seq();\n\n   # if is RNA - map to DNA then map back\n\n   if( $t eq 'rna' ) {\n       $str =~ tr/uU/tT/;\n   }\n\n   # revcom etc...\n\n   $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n   my $revseq = CORE::reverse $str;\n\n   if( $t eq 'rna' ) {\n       $revseq =~ tr/tT/uU/;\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n   my $out = $seqclass->new( '-seq' => $revseq,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n\n}\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence,\n\n Example :\n Returns : a fresh Bio::PrimarySeqI implementing object\n Args    : Two integers denoting first and last base of the sub-sequence.\n\n\n\nsub trunc{\n   my ($self,$start,$end) = @_;\n\n   my $str;\n   if( defined $start && ref($start) &&\n       $start->isa('Bio::LocationI') ) {\n       $str = $self->subseq($start); # start is a location actually\n   } elsif( !$end ) {\n       $self->throw(\"trunc start,end -- there was no end for $start\");\n   } elsif( $end < $start ) {\n       my $msg = \"start [$start] is greater than end [$end]. \\n\".\n\t   \"If you want to truncated and reverse complement, \\n\".\n\t       \"you must call trunc followed by revcom. Sorry.\";\n       $self->throw($msg);\n   } else {\n       $str = $self->subseq($start,$end);\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n\n   my $out = $seqclass->new( '-seq' => $str,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n}\n\n\n=head2 translate\n\n Title   : translate\n Usage   : $protein_seq_obj = $dna_seq_obj->translate\n\n Function:\n\n           Provides the translation of the DNA sequence using full\n           IUPAC ambiguities in DNA/RNA and amino acid codes.\n\n           The full CDS translation is identical to EMBL/TREMBL\n           database translation. Note that the trailing terminator\n           character is removed before returning the translation\n           object.\n\n           Note: if you set $dna_seq_obj->verbose(1) you will get a\n           warning if the first codon is not a valid initiator.\n\n\n Returns : A Bio::PrimarySeqI implementing object\n Args    : character for terminator (optional) defaults to '*'\n           character for unknown amino acid (optional) defaults to 'X'\n           frame (optional) valid values 0, 1, 2, defaults to 0\n           codon table id (optional) defaults to 1\n           complete coding sequence expected, defaults to 0 (false)\n           boolean, throw exception if not complete CDS (true) or defaults to warning (false)\n\n\nsub translate {\n    my($self) = shift;\n    my($stop, $unknown, $frame, $tableid, $fullCDS, $throw) = @_;\n    my($i, $len, $output) = (0,0,'');\n    my($codon)   = \"\";\n    my $aa;\n\n    ## User can pass in symbol for stop and unknown codons\n    unless(defined($stop) and $stop ne '')    { $stop = \"*\"; }\n    unless(defined($unknown) and $unknown ne '') { $unknown = \"X\"; }\n    unless(defined($frame) and $frame ne '') { $frame = 0; }\n\n    ## the codon table ID\n    unless(defined($tableid) and $tableid ne '')    { $tableid = 1; }\n\n    ##Error if monomer is \"Amino\"\n    if ($self->alphabet eq 'protein') {\n\t$self->throw(-class => 'Bio::Root::Exception',\n\t\t     -text => \"Can't translate an amino acid sequence.\")\n    }\n\n    ##Error if frame is not 0, 1 or 2\n    unless ($frame == 0 or $frame == 1 or $frame == 2) {\n\t$self->throw(-class => 'Bio::Root::BadParameter',\n\t\t     -text   => \"Valid values for frame are 0, 1, 2, not [$frame].\",\n\t\t     -value => $frame);\n    }\n\n    #warns if ID is invalid\n    my $codonTable = Bio::Tools::CodonTable->new( -id => $tableid);\n\n    my ($seq) = $self->seq();\n\n    # deal with frame offset.\n    if( $frame ) {\n\t$seq = substr ($seq,$frame);\n    }\n\n    # Translate it\n    $output = $codonTable->translate($seq);\n    # Use user-input stop/unknown\n    $output =~ s/\\*/$stop/g;\n    $output =~ s/X/$unknown/g;\n\t\n    # only if we are expecting to translate a complete coding region\n    if ($fullCDS) {\n\tmy $id = $self->display_id;\n\t#remove the stop character\n\tif( substr($output,-1,1) eq $stop ) {\n\t    chop $output;\n\t} else {\n\t    $throw && $self->throw(-class => 'Bio::Root::Exception',\n\t\t\t\t   -text  => \"Seq [$id]: Not using a valid terminator codon!: \". substr($output,-1,1),\n\t\t\t\t   -value => substr($output,-1,1));\n\t    $self->warn(\"Seq [$id]: Not using a valid terminator codon!: \". substr($output,-1,1));\n\t}\n\t# test if there are terminator characters inside the protein sequence!\n\tif ($output =~ /\\*/) {\n\t    $throw && $self->throw(-class => 'Bio::Root::Exception',\n\t\t\t\t   -text  => \"Seq [$id]: Terminator codon inside CDS!\");\n\t    $self->warn(\"Seq [$id]: Terminator codon inside CDS!\");\n\t}\n\t# if the initiator codon is not ATG, the amino acid needs to changed into M\n\tif ( substr($output,0,1) ne 'M' ) {\n\t    if ($codonTable->is_start_codon(substr($seq, 0, 3)) ) {\n\t\t$output = 'M'. substr($output,1);\n\t    }\n\t    elsif ($throw) {\n\t\t$self->throw(-class => 'Bio::Root::Exception',\n\t\t\t     -text => \"Seq [$id]: Not using a valid initiator codon!: \". substr($seq, 0, 3),\n\t\t\t     -value => substr($seq, 0, 3));\n\t    } else {\n\t\t$self->warn(\"Seq [$id]: Not using a valid initiator codon!\");\n\t    }\n\t}\n    }\n\n    my $seqclass;\n    if($self->can_call_new()) {\n\t$seqclass = ref($self);\n    } else {\n\t$seqclass = 'Bio::PrimarySeq';\n\t$self->_attempt_to_load_Seq();\n    }\n    my $out = $seqclass->new( '-seq' => $output,\n\t\t\t      '-display_id'  => $self->display_id,\n\t\t\t      '-accession_number' => $self->accession_number,\n\t\t\t      # is there anything wrong with retaining the\n\t\t\t      # description?\n\t\t\t      '-desc' => $self->desc(),\n\t\t\t      '-alphabet' => 'protein'\n\t\t\t    );\n    return $out;\n\n}\n\n=head2 id\n\n Title   : id\n Usage   : $id = $seq->id()\n Function: ID of the sequence. This should normally be (and actually is in\n           the implementation provided here) just a synonym for display_id().\n Example :\n Returns : A string.\n Args    :\n\n\n\nsub  id {\n   my ($self)= @_;\n\n   return $self->display_id();\n}\n\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length()\n Function:\n Example :\n Returns : integer representing the length of the sequence.\n Args    :","label":"length($self)"},"kind":12,"range":{"start":{"line":646,"character":0},"end":{"line":649,"character":9999}},"line":646},{"detail":"($self,$value)","definition":"sub","name":"desc","containerName":"main::","children":[{"line":665,"name":"$self","kind":13,"localvar":"my","containerName":"desc","definition":"my"},{"containerName":"desc","kind":13,"name":"$value","line":665},{"name":"$self","containerName":"desc","kind":13,"line":666},{"line":666,"kind":12,"containerName":"desc","name":"throw_not_implemented"}],"signature":{"label":"desc($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: PrimarySeqI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI [Developers] - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # accessors\n\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n    # object manipulation\n\n    eval {\n\t$rev    = $obj->revcom();\n    };\n    if( $@ ) {\n\t$obj->throw(-class => 'Bio::Root::Exception',\n                    -text => \"Could not reverse complement. \".\n\t\t             \"Probably not DNA. Actual exception\\n$@\\n\",\n                    -value => $@);\n    }\n\n    $trunc = $obj->trunc(12,50);\n\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in Bio::PrimarySeq. If you just want to\nuse Bio::PrimarySeq objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence, without providing an implementation of this. (An\nimplementation is provided in Bio::PrimarySeq). If you want to provide\na Bio::PrimarySeq 'compliant' object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inheriet\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : a string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n           [Note this method name is likely to change in 1.3]\n\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n\n   # we default to 0 here\n\n   return 0;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no type specified it\n           has to guess.\n Args    : none\n Status  : Virtual\n\n\n\nsub alphabet{\n    my ( $self ) = @_;\n    $self->throw_not_implemented();\n}\n\nsub moltype{\n   my ($self,@args) = @_;\n\n   $self->warn(\"moltype: pre v1.0 method. Calling alphabet() instead...\");\n   $self->alphabet(@args);\n}\n\n\n=head1 Optional Implementation Functions\n\nThe following functions rely on the above functions. An\nimplementing class does not need to provide these functions, as they\nwill be provided by this class, but is free to override these\nfunctions.\n\nAll of revcom(), trunc(), and translate() create new sequence\nobjects. They will call new() on the class of the sequence object\ninstance passed as argument, unless can_call_new() returns FALSE. In\nthe latter case a Bio::PrimarySeq object will be created. Implementors\nwhich really want to control how objects are created (eg, for object\npersistence over a database, or objects in a CORBA framework), they\nare encouraged to override these methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::PrimarySeqI implementing object which\n           is the reversed complement of the sequence. For protein\n           sequences this throws an exception of \"Sequence is a\n           protein. Cannot revcom\"\n\n           The id is the same id as the original sequence, and the\n           accession number is also indentical. If someone wants to\n           track that this sequence has be reversed, it needs to\n           define its own extensions\n\n           To do an inplace edit of an object you can go:\n\n           $seq = $seq->revcom();\n\n           This of course, causes Perl to handle the garbage\n           collection of the old object, but it is roughly speaking as\n           efficient as an inplace edit.\n\n Returns : A new (fresh) Bio::PrimarySeqI object\n Args    : none\n\n\n\nsub revcom{\n   my ($self) = @_;\n\n\n   # check the type is good first.\n   my $t = $self->alphabet;\n\n   if( $t eq 'protein' ) {\n       $self->throw(-class => 'Bio::Root::Exception',\n\t\t    -text  => \"Sequence is a protein. Cannot revcom\");\n   }\n\n   if( $t ne 'dna' && $t ne 'rna' ) {\n       if( $self->can('warn') ) {\n\t   $self->warn(\"Sequence is not dna or rna, but [$t]. \".\n\t\t       \"Attempting to revcom, but unsure if this is right\");\n       } else {\n\t   warn(\"[$self] Sequence is not dna or rna, but [$t]. \".\n\t\t\"Attempting to revcom, but unsure if this is right\");\n       }\n   }\n\n   # yank out the sequence string\n\n   my $str = $self->seq();\n\n   # if is RNA - map to DNA then map back\n\n   if( $t eq 'rna' ) {\n       $str =~ tr/uU/tT/;\n   }\n\n   # revcom etc...\n\n   $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n   my $revseq = CORE::reverse $str;\n\n   if( $t eq 'rna' ) {\n       $revseq =~ tr/tT/uU/;\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n   my $out = $seqclass->new( '-seq' => $revseq,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n\n}\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence,\n\n Example :\n Returns : a fresh Bio::PrimarySeqI implementing object\n Args    : Two integers denoting first and last base of the sub-sequence.\n\n\n\nsub trunc{\n   my ($self,$start,$end) = @_;\n\n   my $str;\n   if( defined $start && ref($start) &&\n       $start->isa('Bio::LocationI') ) {\n       $str = $self->subseq($start); # start is a location actually\n   } elsif( !$end ) {\n       $self->throw(\"trunc start,end -- there was no end for $start\");\n   } elsif( $end < $start ) {\n       my $msg = \"start [$start] is greater than end [$end]. \\n\".\n\t   \"If you want to truncated and reverse complement, \\n\".\n\t       \"you must call trunc followed by revcom. Sorry.\";\n       $self->throw($msg);\n   } else {\n       $str = $self->subseq($start,$end);\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n\n   my $out = $seqclass->new( '-seq' => $str,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n}\n\n\n=head2 translate\n\n Title   : translate\n Usage   : $protein_seq_obj = $dna_seq_obj->translate\n\n Function:\n\n           Provides the translation of the DNA sequence using full\n           IUPAC ambiguities in DNA/RNA and amino acid codes.\n\n           The full CDS translation is identical to EMBL/TREMBL\n           database translation. Note that the trailing terminator\n           character is removed before returning the translation\n           object.\n\n           Note: if you set $dna_seq_obj->verbose(1) you will get a\n           warning if the first codon is not a valid initiator.\n\n\n Returns : A Bio::PrimarySeqI implementing object\n Args    : character for terminator (optional) defaults to '*'\n           character for unknown amino acid (optional) defaults to 'X'\n           frame (optional) valid values 0, 1, 2, defaults to 0\n           codon table id (optional) defaults to 1\n           complete coding sequence expected, defaults to 0 (false)\n           boolean, throw exception if not complete CDS (true) or defaults to warning (false)\n\n\nsub translate {\n    my($self) = shift;\n    my($stop, $unknown, $frame, $tableid, $fullCDS, $throw) = @_;\n    my($i, $len, $output) = (0,0,'');\n    my($codon)   = \"\";\n    my $aa;\n\n    ## User can pass in symbol for stop and unknown codons\n    unless(defined($stop) and $stop ne '')    { $stop = \"*\"; }\n    unless(defined($unknown) and $unknown ne '') { $unknown = \"X\"; }\n    unless(defined($frame) and $frame ne '') { $frame = 0; }\n\n    ## the codon table ID\n    unless(defined($tableid) and $tableid ne '')    { $tableid = 1; }\n\n    ##Error if monomer is \"Amino\"\n    if ($self->alphabet eq 'protein') {\n\t$self->throw(-class => 'Bio::Root::Exception',\n\t\t     -text => \"Can't translate an amino acid sequence.\")\n    }\n\n    ##Error if frame is not 0, 1 or 2\n    unless ($frame == 0 or $frame == 1 or $frame == 2) {\n\t$self->throw(-class => 'Bio::Root::BadParameter',\n\t\t     -text   => \"Valid values for frame are 0, 1, 2, not [$frame].\",\n\t\t     -value => $frame);\n    }\n\n    #warns if ID is invalid\n    my $codonTable = Bio::Tools::CodonTable->new( -id => $tableid);\n\n    my ($seq) = $self->seq();\n\n    # deal with frame offset.\n    if( $frame ) {\n\t$seq = substr ($seq,$frame);\n    }\n\n    # Translate it\n    $output = $codonTable->translate($seq);\n    # Use user-input stop/unknown\n    $output =~ s/\\*/$stop/g;\n    $output =~ s/X/$unknown/g;\n\t\n    # only if we are expecting to translate a complete coding region\n    if ($fullCDS) {\n\tmy $id = $self->display_id;\n\t#remove the stop character\n\tif( substr($output,-1,1) eq $stop ) {\n\t    chop $output;\n\t} else {\n\t    $throw && $self->throw(-class => 'Bio::Root::Exception',\n\t\t\t\t   -text  => \"Seq [$id]: Not using a valid terminator codon!: \". substr($output,-1,1),\n\t\t\t\t   -value => substr($output,-1,1));\n\t    $self->warn(\"Seq [$id]: Not using a valid terminator codon!: \". substr($output,-1,1));\n\t}\n\t# test if there are terminator characters inside the protein sequence!\n\tif ($output =~ /\\*/) {\n\t    $throw && $self->throw(-class => 'Bio::Root::Exception',\n\t\t\t\t   -text  => \"Seq [$id]: Terminator codon inside CDS!\");\n\t    $self->warn(\"Seq [$id]: Terminator codon inside CDS!\");\n\t}\n\t# if the initiator codon is not ATG, the amino acid needs to changed into M\n\tif ( substr($output,0,1) ne 'M' ) {\n\t    if ($codonTable->is_start_codon(substr($seq, 0, 3)) ) {\n\t\t$output = 'M'. substr($output,1);\n\t    }\n\t    elsif ($throw) {\n\t\t$self->throw(-class => 'Bio::Root::Exception',\n\t\t\t     -text => \"Seq [$id]: Not using a valid initiator codon!: \". substr($seq, 0, 3),\n\t\t\t     -value => substr($seq, 0, 3));\n\t    } else {\n\t\t$self->warn(\"Seq [$id]: Not using a valid initiator codon!\");\n\t    }\n\t}\n    }\n\n    my $seqclass;\n    if($self->can_call_new()) {\n\t$seqclass = ref($self);\n    } else {\n\t$seqclass = 'Bio::PrimarySeq';\n\t$self->_attempt_to_load_Seq();\n    }\n    my $out = $seqclass->new( '-seq' => $output,\n\t\t\t      '-display_id'  => $self->display_id,\n\t\t\t      '-accession_number' => $self->accession_number,\n\t\t\t      # is there anything wrong with retaining the\n\t\t\t      # description?\n\t\t\t      '-desc' => $self->desc(),\n\t\t\t      '-alphabet' => 'protein'\n\t\t\t    );\n    return $out;\n\n}\n\n=head2 id\n\n Title   : id\n Usage   : $id = $seq->id()\n Function: ID of the sequence. This should normally be (and actually is in\n           the implementation provided here) just a synonym for display_id().\n Example :\n Returns : A string.\n Args    :\n\n\n\nsub  id {\n   my ($self)= @_;\n\n   return $self->display_id();\n}\n\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length()\n Function:\n Example :\n Returns : integer representing the length of the sequence.\n Args    :\n\n\n\nsub  length {\n   my ($self)= @_;\n   $self->throw_not_implemented();\n}\n\n=head2 desc\n\n Title   : desc\n Usage   : $seq->desc($newval);\n           $description = $seq->desc();\n Function: Get/set description text for a seq object\n Example :\n Returns : value of desc\n Args    : newvalue (optional)"},"kind":12,"range":{"start":{"character":0,"line":664},"end":{"character":9999,"line":667}},"line":664},{"signature":{"label":"is_circular($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: PrimarySeqI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI [Developers] - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # accessors\n\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n    # object manipulation\n\n    eval {\n\t$rev    = $obj->revcom();\n    };\n    if( $@ ) {\n\t$obj->throw(-class => 'Bio::Root::Exception',\n                    -text => \"Could not reverse complement. \".\n\t\t             \"Probably not DNA. Actual exception\\n$@\\n\",\n                    -value => $@);\n    }\n\n    $trunc = $obj->trunc(12,50);\n\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in Bio::PrimarySeq. If you just want to\nuse Bio::PrimarySeq objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence, without providing an implementation of this. (An\nimplementation is provided in Bio::PrimarySeq). If you want to provide\na Bio::PrimarySeq 'compliant' object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inheriet\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : a string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n           [Note this method name is likely to change in 1.3]\n\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n\n   # we default to 0 here\n\n   return 0;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no type specified it\n           has to guess.\n Args    : none\n Status  : Virtual\n\n\n\nsub alphabet{\n    my ( $self ) = @_;\n    $self->throw_not_implemented();\n}\n\nsub moltype{\n   my ($self,@args) = @_;\n\n   $self->warn(\"moltype: pre v1.0 method. Calling alphabet() instead...\");\n   $self->alphabet(@args);\n}\n\n\n=head1 Optional Implementation Functions\n\nThe following functions rely on the above functions. An\nimplementing class does not need to provide these functions, as they\nwill be provided by this class, but is free to override these\nfunctions.\n\nAll of revcom(), trunc(), and translate() create new sequence\nobjects. They will call new() on the class of the sequence object\ninstance passed as argument, unless can_call_new() returns FALSE. In\nthe latter case a Bio::PrimarySeq object will be created. Implementors\nwhich really want to control how objects are created (eg, for object\npersistence over a database, or objects in a CORBA framework), they\nare encouraged to override these methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::PrimarySeqI implementing object which\n           is the reversed complement of the sequence. For protein\n           sequences this throws an exception of \"Sequence is a\n           protein. Cannot revcom\"\n\n           The id is the same id as the original sequence, and the\n           accession number is also indentical. If someone wants to\n           track that this sequence has be reversed, it needs to\n           define its own extensions\n\n           To do an inplace edit of an object you can go:\n\n           $seq = $seq->revcom();\n\n           This of course, causes Perl to handle the garbage\n           collection of the old object, but it is roughly speaking as\n           efficient as an inplace edit.\n\n Returns : A new (fresh) Bio::PrimarySeqI object\n Args    : none\n\n\n\nsub revcom{\n   my ($self) = @_;\n\n\n   # check the type is good first.\n   my $t = $self->alphabet;\n\n   if( $t eq 'protein' ) {\n       $self->throw(-class => 'Bio::Root::Exception',\n\t\t    -text  => \"Sequence is a protein. Cannot revcom\");\n   }\n\n   if( $t ne 'dna' && $t ne 'rna' ) {\n       if( $self->can('warn') ) {\n\t   $self->warn(\"Sequence is not dna or rna, but [$t]. \".\n\t\t       \"Attempting to revcom, but unsure if this is right\");\n       } else {\n\t   warn(\"[$self] Sequence is not dna or rna, but [$t]. \".\n\t\t\"Attempting to revcom, but unsure if this is right\");\n       }\n   }\n\n   # yank out the sequence string\n\n   my $str = $self->seq();\n\n   # if is RNA - map to DNA then map back\n\n   if( $t eq 'rna' ) {\n       $str =~ tr/uU/tT/;\n   }\n\n   # revcom etc...\n\n   $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n   my $revseq = CORE::reverse $str;\n\n   if( $t eq 'rna' ) {\n       $revseq =~ tr/tT/uU/;\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n   my $out = $seqclass->new( '-seq' => $revseq,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n\n}\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence,\n\n Example :\n Returns : a fresh Bio::PrimarySeqI implementing object\n Args    : Two integers denoting first and last base of the sub-sequence.\n\n\n\nsub trunc{\n   my ($self,$start,$end) = @_;\n\n   my $str;\n   if( defined $start && ref($start) &&\n       $start->isa('Bio::LocationI') ) {\n       $str = $self->subseq($start); # start is a location actually\n   } elsif( !$end ) {\n       $self->throw(\"trunc start,end -- there was no end for $start\");\n   } elsif( $end < $start ) {\n       my $msg = \"start [$start] is greater than end [$end]. \\n\".\n\t   \"If you want to truncated and reverse complement, \\n\".\n\t       \"you must call trunc followed by revcom. Sorry.\";\n       $self->throw($msg);\n   } else {\n       $str = $self->subseq($start,$end);\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n\n   my $out = $seqclass->new( '-seq' => $str,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n}\n\n\n=head2 translate\n\n Title   : translate\n Usage   : $protein_seq_obj = $dna_seq_obj->translate\n\n Function:\n\n           Provides the translation of the DNA sequence using full\n           IUPAC ambiguities in DNA/RNA and amino acid codes.\n\n           The full CDS translation is identical to EMBL/TREMBL\n           database translation. Note that the trailing terminator\n           character is removed before returning the translation\n           object.\n\n           Note: if you set $dna_seq_obj->verbose(1) you will get a\n           warning if the first codon is not a valid initiator.\n\n\n Returns : A Bio::PrimarySeqI implementing object\n Args    : character for terminator (optional) defaults to '*'\n           character for unknown amino acid (optional) defaults to 'X'\n           frame (optional) valid values 0, 1, 2, defaults to 0\n           codon table id (optional) defaults to 1\n           complete coding sequence expected, defaults to 0 (false)\n           boolean, throw exception if not complete CDS (true) or defaults to warning (false)\n\n\nsub translate {\n    my($self) = shift;\n    my($stop, $unknown, $frame, $tableid, $fullCDS, $throw) = @_;\n    my($i, $len, $output) = (0,0,'');\n    my($codon)   = \"\";\n    my $aa;\n\n    ## User can pass in symbol for stop and unknown codons\n    unless(defined($stop) and $stop ne '')    { $stop = \"*\"; }\n    unless(defined($unknown) and $unknown ne '') { $unknown = \"X\"; }\n    unless(defined($frame) and $frame ne '') { $frame = 0; }\n\n    ## the codon table ID\n    unless(defined($tableid) and $tableid ne '')    { $tableid = 1; }\n\n    ##Error if monomer is \"Amino\"\n    if ($self->alphabet eq 'protein') {\n\t$self->throw(-class => 'Bio::Root::Exception',\n\t\t     -text => \"Can't translate an amino acid sequence.\")\n    }\n\n    ##Error if frame is not 0, 1 or 2\n    unless ($frame == 0 or $frame == 1 or $frame == 2) {\n\t$self->throw(-class => 'Bio::Root::BadParameter',\n\t\t     -text   => \"Valid values for frame are 0, 1, 2, not [$frame].\",\n\t\t     -value => $frame);\n    }\n\n    #warns if ID is invalid\n    my $codonTable = Bio::Tools::CodonTable->new( -id => $tableid);\n\n    my ($seq) = $self->seq();\n\n    # deal with frame offset.\n    if( $frame ) {\n\t$seq = substr ($seq,$frame);\n    }\n\n    # Translate it\n    $output = $codonTable->translate($seq);\n    # Use user-input stop/unknown\n    $output =~ s/\\*/$stop/g;\n    $output =~ s/X/$unknown/g;\n\t\n    # only if we are expecting to translate a complete coding region\n    if ($fullCDS) {\n\tmy $id = $self->display_id;\n\t#remove the stop character\n\tif( substr($output,-1,1) eq $stop ) {\n\t    chop $output;\n\t} else {\n\t    $throw && $self->throw(-class => 'Bio::Root::Exception',\n\t\t\t\t   -text  => \"Seq [$id]: Not using a valid terminator codon!: \". substr($output,-1,1),\n\t\t\t\t   -value => substr($output,-1,1));\n\t    $self->warn(\"Seq [$id]: Not using a valid terminator codon!: \". substr($output,-1,1));\n\t}\n\t# test if there are terminator characters inside the protein sequence!\n\tif ($output =~ /\\*/) {\n\t    $throw && $self->throw(-class => 'Bio::Root::Exception',\n\t\t\t\t   -text  => \"Seq [$id]: Terminator codon inside CDS!\");\n\t    $self->warn(\"Seq [$id]: Terminator codon inside CDS!\");\n\t}\n\t# if the initiator codon is not ATG, the amino acid needs to changed into M\n\tif ( substr($output,0,1) ne 'M' ) {\n\t    if ($codonTable->is_start_codon(substr($seq, 0, 3)) ) {\n\t\t$output = 'M'. substr($output,1);\n\t    }\n\t    elsif ($throw) {\n\t\t$self->throw(-class => 'Bio::Root::Exception',\n\t\t\t     -text => \"Seq [$id]: Not using a valid initiator codon!: \". substr($seq, 0, 3),\n\t\t\t     -value => substr($seq, 0, 3));\n\t    } else {\n\t\t$self->warn(\"Seq [$id]: Not using a valid initiator codon!\");\n\t    }\n\t}\n    }\n\n    my $seqclass;\n    if($self->can_call_new()) {\n\t$seqclass = ref($self);\n    } else {\n\t$seqclass = 'Bio::PrimarySeq';\n\t$self->_attempt_to_load_Seq();\n    }\n    my $out = $seqclass->new( '-seq' => $output,\n\t\t\t      '-display_id'  => $self->display_id,\n\t\t\t      '-accession_number' => $self->accession_number,\n\t\t\t      # is there anything wrong with retaining the\n\t\t\t      # description?\n\t\t\t      '-desc' => $self->desc(),\n\t\t\t      '-alphabet' => 'protein'\n\t\t\t    );\n    return $out;\n\n}\n\n=head2 id\n\n Title   : id\n Usage   : $id = $seq->id()\n Function: ID of the sequence. This should normally be (and actually is in\n           the implementation provided here) just a synonym for display_id().\n Example :\n Returns : A string.\n Args    :\n\n\n\nsub  id {\n   my ($self)= @_;\n\n   return $self->display_id();\n}\n\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length()\n Function:\n Example :\n Returns : integer representing the length of the sequence.\n Args    :\n\n\n\nsub  length {\n   my ($self)= @_;\n   $self->throw_not_implemented();\n}\n\n=head2 desc\n\n Title   : desc\n Usage   : $seq->desc($newval);\n           $description = $seq->desc();\n Function: Get/set description text for a seq object\n Example :\n Returns : value of desc\n Args    : newvalue (optional)\n\n\n\nsub desc {\n   my ($self,$value) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 is_circular\n\n Title   : is_circular\n Usage   : if( $obj->is_circular) { /Do Something/ }\n Function: Returns true if the molecule is circular\n Returns : Boolean value\n Args    : none"},"range":{"start":{"line":680,"character":0},"end":{"character":9999,"line":686}},"kind":12,"line":680,"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"is_circular","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"is_circular","line":681,"definition":"my"},{"line":681,"name":"$value","kind":13,"containerName":"is_circular"},{"line":682,"containerName":"is_circular","kind":13,"name":"$value"},{"line":683,"containerName":"is_circular","kind":13,"name":"$self"},{"kind":13,"containerName":"is_circular","name":"$value","line":683},{"name":"$self","kind":13,"containerName":"is_circular","line":685}]},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PrimarySeqI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI [Developers] - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # accessors\n\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n    # object manipulation\n\n    eval {\n\t$rev    = $obj->revcom();\n    };\n    if( $@ ) {\n\t$obj->throw(-class => 'Bio::Root::Exception',\n                    -text => \"Could not reverse complement. \".\n\t\t             \"Probably not DNA. Actual exception\\n$@\\n\",\n                    -value => $@);\n    }\n\n    $trunc = $obj->trunc(12,50);\n\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in Bio::PrimarySeq. If you just want to\nuse Bio::PrimarySeq objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence, without providing an implementation of this. (An\nimplementation is provided in Bio::PrimarySeq). If you want to provide\na Bio::PrimarySeq 'compliant' object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inheriet\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : a string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convience issues\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n           [Note this method name is likely to change in 1.3]\n\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n\n   # we default to 0 here\n\n   return 0;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no type specified it\n           has to guess.\n Args    : none\n Status  : Virtual\n\n\n\nsub alphabet{\n    my ( $self ) = @_;\n    $self->throw_not_implemented();\n}\n\nsub moltype{\n   my ($self,@args) = @_;\n\n   $self->warn(\"moltype: pre v1.0 method. Calling alphabet() instead...\");\n   $self->alphabet(@args);\n}\n\n\n=head1 Optional Implementation Functions\n\nThe following functions rely on the above functions. An\nimplementing class does not need to provide these functions, as they\nwill be provided by this class, but is free to override these\nfunctions.\n\nAll of revcom(), trunc(), and translate() create new sequence\nobjects. They will call new() on the class of the sequence object\ninstance passed as argument, unless can_call_new() returns FALSE. In\nthe latter case a Bio::PrimarySeq object will be created. Implementors\nwhich really want to control how objects are created (eg, for object\npersistence over a database, or objects in a CORBA framework), they\nare encouraged to override these methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::PrimarySeqI implementing object which\n           is the reversed complement of the sequence. For protein\n           sequences this throws an exception of \"Sequence is a\n           protein. Cannot revcom\"\n\n           The id is the same id as the original sequence, and the\n           accession number is also indentical. If someone wants to\n           track that this sequence has be reversed, it needs to\n           define its own extensions\n\n           To do an inplace edit of an object you can go:\n\n           $seq = $seq->revcom();\n\n           This of course, causes Perl to handle the garbage\n           collection of the old object, but it is roughly speaking as\n           efficient as an inplace edit.\n\n Returns : A new (fresh) Bio::PrimarySeqI object\n Args    : none\n\n\n\nsub revcom{\n   my ($self) = @_;\n\n\n   # check the type is good first.\n   my $t = $self->alphabet;\n\n   if( $t eq 'protein' ) {\n       $self->throw(-class => 'Bio::Root::Exception',\n\t\t    -text  => \"Sequence is a protein. Cannot revcom\");\n   }\n\n   if( $t ne 'dna' && $t ne 'rna' ) {\n       if( $self->can('warn') ) {\n\t   $self->warn(\"Sequence is not dna or rna, but [$t]. \".\n\t\t       \"Attempting to revcom, but unsure if this is right\");\n       } else {\n\t   warn(\"[$self] Sequence is not dna or rna, but [$t]. \".\n\t\t\"Attempting to revcom, but unsure if this is right\");\n       }\n   }\n\n   # yank out the sequence string\n\n   my $str = $self->seq();\n\n   # if is RNA - map to DNA then map back\n\n   if( $t eq 'rna' ) {\n       $str =~ tr/uU/tT/;\n   }\n\n   # revcom etc...\n\n   $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n   my $revseq = CORE::reverse $str;\n\n   if( $t eq 'rna' ) {\n       $revseq =~ tr/tT/uU/;\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n   my $out = $seqclass->new( '-seq' => $revseq,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n\n}\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence,\n\n Example :\n Returns : a fresh Bio::PrimarySeqI implementing object\n Args    : Two integers denoting first and last base of the sub-sequence.\n\n\n\nsub trunc{\n   my ($self,$start,$end) = @_;\n\n   my $str;\n   if( defined $start && ref($start) &&\n       $start->isa('Bio::LocationI') ) {\n       $str = $self->subseq($start); # start is a location actually\n   } elsif( !$end ) {\n       $self->throw(\"trunc start,end -- there was no end for $start\");\n   } elsif( $end < $start ) {\n       my $msg = \"start [$start] is greater than end [$end]. \\n\".\n\t   \"If you want to truncated and reverse complement, \\n\".\n\t       \"you must call trunc followed by revcom. Sorry.\";\n       $self->throw($msg);\n   } else {\n       $str = $self->subseq($start,$end);\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n\n   my $out = $seqclass->new( '-seq' => $str,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n}\n\n\n=head2 translate\n\n Title   : translate\n Usage   : $protein_seq_obj = $dna_seq_obj->translate\n\n Function:\n\n           Provides the translation of the DNA sequence using full\n           IUPAC ambiguities in DNA/RNA and amino acid codes.\n\n           The full CDS translation is identical to EMBL/TREMBL\n           database translation. Note that the trailing terminator\n           character is removed before returning the translation\n           object.\n\n           Note: if you set $dna_seq_obj->verbose(1) you will get a\n           warning if the first codon is not a valid initiator.\n\n\n Returns : A Bio::PrimarySeqI implementing object\n Args    : character for terminator (optional) defaults to '*'\n           character for unknown amino acid (optional) defaults to 'X'\n           frame (optional) valid values 0, 1, 2, defaults to 0\n           codon table id (optional) defaults to 1\n           complete coding sequence expected, defaults to 0 (false)\n           boolean, throw exception if not complete CDS (true) or defaults to warning (false)\n\n\nsub translate {\n    my($self) = shift;\n    my($stop, $unknown, $frame, $tableid, $fullCDS, $throw) = @_;\n    my($i, $len, $output) = (0,0,'');\n    my($codon)   = \"\";\n    my $aa;\n\n    ## User can pass in symbol for stop and unknown codons\n    unless(defined($stop) and $stop ne '')    { $stop = \"*\"; }\n    unless(defined($unknown) and $unknown ne '') { $unknown = \"X\"; }\n    unless(defined($frame) and $frame ne '') { $frame = 0; }\n\n    ## the codon table ID\n    unless(defined($tableid) and $tableid ne '')    { $tableid = 1; }\n\n    ##Error if monomer is \"Amino\"\n    if ($self->alphabet eq 'protein') {\n\t$self->throw(-class => 'Bio::Root::Exception',\n\t\t     -text => \"Can't translate an amino acid sequence.\")\n    }\n\n    ##Error if frame is not 0, 1 or 2\n    unless ($frame == 0 or $frame == 1 or $frame == 2) {\n\t$self->throw(-class => 'Bio::Root::BadParameter',\n\t\t     -text   => \"Valid values for frame are 0, 1, 2, not [$frame].\",\n\t\t     -value => $frame);\n    }\n\n    #warns if ID is invalid\n    my $codonTable = Bio::Tools::CodonTable->new( -id => $tableid);\n\n    my ($seq) = $self->seq();\n\n    # deal with frame offset.\n    if( $frame ) {\n\t$seq = substr ($seq,$frame);\n    }\n\n    # Translate it\n    $output = $codonTable->translate($seq);\n    # Use user-input stop/unknown\n    $output =~ s/\\*/$stop/g;\n    $output =~ s/X/$unknown/g;\n\t\n    # only if we are expecting to translate a complete coding region\n    if ($fullCDS) {\n\tmy $id = $self->display_id;\n\t#remove the stop character\n\tif( substr($output,-1,1) eq $stop ) {\n\t    chop $output;\n\t} else {\n\t    $throw && $self->throw(-class => 'Bio::Root::Exception',\n\t\t\t\t   -text  => \"Seq [$id]: Not using a valid terminator codon!: \". substr($output,-1,1),\n\t\t\t\t   -value => substr($output,-1,1));\n\t    $self->warn(\"Seq [$id]: Not using a valid terminator codon!: \". substr($output,-1,1));\n\t}\n\t# test if there are terminator characters inside the protein sequence!\n\tif ($output =~ /\\*/) {\n\t    $throw && $self->throw(-class => 'Bio::Root::Exception',\n\t\t\t\t   -text  => \"Seq [$id]: Terminator codon inside CDS!\");\n\t    $self->warn(\"Seq [$id]: Terminator codon inside CDS!\");\n\t}\n\t# if the initiator codon is not ATG, the amino acid needs to changed into M\n\tif ( substr($output,0,1) ne 'M' ) {\n\t    if ($codonTable->is_start_codon(substr($seq, 0, 3)) ) {\n\t\t$output = 'M'. substr($output,1);\n\t    }\n\t    elsif ($throw) {\n\t\t$self->throw(-class => 'Bio::Root::Exception',\n\t\t\t     -text => \"Seq [$id]: Not using a valid initiator codon!: \". substr($seq, 0, 3),\n\t\t\t     -value => substr($seq, 0, 3));\n\t    } else {\n\t\t$self->warn(\"Seq [$id]: Not using a valid initiator codon!\");\n\t    }\n\t}\n    }\n\n    my $seqclass;\n    if($self->can_call_new()) {\n\t$seqclass = ref($self);\n    } else {\n\t$seqclass = 'Bio::PrimarySeq';\n\t$self->_attempt_to_load_Seq();\n    }\n    my $out = $seqclass->new( '-seq' => $output,\n\t\t\t      '-display_id'  => $self->display_id,\n\t\t\t      '-accession_number' => $self->accession_number,\n\t\t\t      # is there anything wrong with retaining the\n\t\t\t      # description?\n\t\t\t      '-desc' => $self->desc(),\n\t\t\t      '-alphabet' => 'protein'\n\t\t\t    );\n    return $out;\n\n}\n\n=head2 id\n\n Title   : id\n Usage   : $id = $seq->id()\n Function: ID of the sequence. This should normally be (and actually is in\n           the implementation provided here) just a synonym for display_id().\n Example :\n Returns : A string.\n Args    :\n\n\n\nsub  id {\n   my ($self)= @_;\n\n   return $self->display_id();\n}\n\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length()\n Function:\n Example :\n Returns : integer representing the length of the sequence.\n Args    :\n\n\n\nsub  length {\n   my ($self)= @_;\n   $self->throw_not_implemented();\n}\n\n=head2 desc\n\n Title   : desc\n Usage   : $seq->desc($newval);\n           $description = $seq->desc();\n Function: Get/set description text for a seq object\n Example :\n Returns : value of desc\n Args    : newvalue (optional)\n\n\n\nsub desc {\n   my ($self,$value) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 is_circular\n\n Title   : is_circular\n Usage   : if( $obj->is_circular) { /Do Something/ }\n Function: Returns true if the molecule is circular\n Returns : Boolean value\n Args    : none\n\n\nsub is_circular{\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'_is_circular'} = $value;\n    }\n    return $self->{'_is_circular'};\n}\n\n=head1 Private functions\n\nThese are some private functions for the PrimarySeqI interface. You do not\nneed to implement these functions\n\n=head2 _attempt_to_load_Seq\n\n Title   : _attempt_to_load_Seq\n Usage   :\n Function:\n Example :\n Returns :\n Args    :","label":"_attempt_to_load_Seq($self)"},"line":705,"kind":12,"range":{"start":{"line":705,"character":0},"end":{"line":729,"character":9999}},"definition":"sub","detail":"($self)","children":[{"definition":"my","containerName":"_attempt_to_load_Seq","localvar":"my","kind":13,"name":"$self","line":706},{"name":"$main","containerName":"_attempt_to_load_Seq","kind":13,"line":708},{"kind":13,"localvar":"my","containerName":"_attempt_to_load_Seq","name":"$text","line":715,"definition":"my"},{"name":"$self","containerName":"_attempt_to_load_Seq","kind":13,"line":721},{"line":721,"kind":12,"containerName":"_attempt_to_load_Seq","name":"throw"}],"name":"_attempt_to_load_Seq","containerName":"main::"},{"name":"Bio","kind":12,"containerName":"PrimarySeq","line":714}],"version":5}