{"vars":[{"line":210,"kind":13,"containerName":null,"name":"$VERSION"},{"name":"version","containerName":"","kind":2,"line":210},{"line":210,"kind":12,"name":"qv"},{"kind":12,"range":{"end":{"line":269,"character":9999},"start":{"line":236,"character":0}},"line":236,"name":"return_methods","containerName":"main::","children":[{"line":238,"name":"@input","localvar":"my","kind":13,"containerName":"return_methods","definition":"my"},{"name":"%methods_of","localvar":"my","kind":13,"containerName":"return_methods","line":244,"definition":"my"},{"line":247,"name":"$class","containerName":"return_methods","localvar":"my","kind":13,"definition":"my"},{"name":"@input","kind":13,"containerName":"return_methods","line":247},{"line":250,"containerName":"return_methods","kind":13,"name":"$class"},{"definition":"my","line":258,"localvar":"my","containerName":"return_methods","kind":13,"name":"$methods_aryref3"},{"line":259,"name":"methods","kind":12,"containerName":"return_methods"},{"line":259,"name":"$class","containerName":"return_methods","kind":13},{"definition":"my","line":262,"name":"$i","kind":13,"localvar":"my","containerName":"return_methods"},{"name":"$i","containerName":"return_methods","kind":13,"line":262},{"containerName":"return_methods","kind":13,"name":"$methods_aryref3","line":262},{"name":"$i","kind":13,"containerName":"return_methods","line":262},{"definition":"my","containerName":"return_methods","localvar":"my","kind":13,"name":"$meth","line":263},{"line":263,"name":"$methods_aryref3","containerName":"return_methods","kind":13},{"line":263,"kind":13,"containerName":"return_methods","name":"$i"},{"line":264,"localvar":"my","kind":13,"containerName":"return_methods","name":"$method_name","definition":"my"},{"line":264,"name":"$meth","containerName":"return_methods","kind":13},{"localvar":"my","containerName":"return_methods","kind":13,"name":"$inherited_from","line":265,"definition":"my"},{"containerName":"return_methods","kind":13,"name":"$meth","line":265},{"line":266,"kind":13,"containerName":"return_methods","name":"$methods_of"},{"line":266,"kind":13,"containerName":"return_methods","name":"$class"},{"line":266,"name":"$method_name","kind":13,"containerName":"return_methods"},{"line":266,"kind":13,"containerName":"return_methods","name":"$inherited_from"}],"definition":"sub"},{"containerName":"","kind":2,"name":"lib","line":238},{"kind":12,"name":"_load_module","line":250},{"line":259,"kind":12,"containerName":"Inspector","name":"Class"},{"name":"%methods_of","kind":13,"containerName":null,"line":272},{"line":288,"kind":12,"range":{"start":{"line":288,"character":0},"end":{"character":9999,"line":318}},"children":[{"name":"@input","containerName":"print_methods","localvar":"my","kind":13,"line":290,"definition":"my"},{"name":"$class","localvar":"my","containerName":"print_methods","kind":13,"line":292,"definition":"my"},{"containerName":"print_methods","kind":13,"name":"@input","line":292},{"line":295,"name":"$class","containerName":"print_methods","kind":13},{"definition":"my","line":303,"kind":13,"localvar":"my","containerName":"print_methods","name":"$methods_aryref3"},{"name":"methods","containerName":"print_methods","kind":12,"line":304},{"name":"$class","containerName":"print_methods","kind":13,"line":304},{"name":"$i","kind":13,"localvar":"my","containerName":"print_methods","line":309,"definition":"my"},{"line":309,"name":"$i","containerName":"print_methods","kind":13},{"name":"$methods_aryref3","containerName":"print_methods","kind":13,"line":309},{"name":"$i","kind":13,"containerName":"print_methods","line":309},{"line":311,"name":"$meth","kind":13,"localvar":"my","containerName":"print_methods","definition":"my"},{"line":311,"kind":13,"containerName":"print_methods","name":"$methods_aryref3"},{"line":311,"containerName":"print_methods","kind":13,"name":"$i"}],"containerName":"main::","name":"print_methods","definition":"sub"},{"line":295,"kind":12,"name":"_load_module"},{"line":304,"containerName":"Inspector","kind":12,"name":"Class"},{"range":{"end":{"character":9999,"line":339},"start":{"character":0,"line":332}},"kind":12,"line":332,"name":"_load_module","containerName":"main::","children":[{"definition":"my","line":333,"localvar":"my","kind":13,"containerName":"_load_module","name":"$module"},{"definition":"my","line":335,"name":"$err","localvar":"my","kind":13,"containerName":"_load_module"}],"definition":"sub"},{"line":338,"kind":12,"name":"return"},{"containerName":"main::","name":"open_db","children":[{"name":"$filename","localvar":"my","containerName":"open_db","kind":13,"line":352,"definition":"my"},{"line":354,"name":"%hash","kind":13,"localvar":"my","containerName":"open_db","definition":"my"},{"definition":"my","localvar":"my","containerName":"open_db","kind":13,"name":"$hashref","line":355},{"name":"%hash","kind":13,"containerName":"open_db","line":355},{"line":357,"containerName":"open_db","kind":13,"name":"%hash"},{"containerName":"open_db","kind":13,"name":"$filename","line":357},{"name":"$hashref","containerName":"open_db","kind":13,"line":359}],"detail":"($filename)","definition":"sub","kind":12,"range":{"end":{"line":360,"character":9999},"start":{"character":0,"line":351}},"line":351,"signature":{"documentation":"__END__\npackage Deobfuscator;\n\n# module for retrieving method-specific documentation from a\n# Berkeley database\n#\n# first version by Dave Messina (dmessina@watson.wustl.edu) at the\n# Cold Spring Harbor Laboratory Advanced Bioinformatics Course\n# Oct 12-25, 2005\n\n# part of the Deobfuscator package\n# by Laura Kavanaugh and Dave Messina\n#\n# cared for by Dave Messina <dave-pause@davemessina.net>\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nDeobfuscator - get BioPerl method and package information from a Berkeley DB\n\n\n=head1 VERSION\n\nThis document describes Deobfuscator version 0.0.3\n\n\n=head1 SYNOPSIS\n\n    use Deobfuscator;\n\n    # get all the methods available to objects belonging to a class\n    # (including those inherited from parent classes)\n    my $hashref = Deobfuscator::return_methods('Bio::SeqIO', 'Bio::AlignIO');\n\n    # retrieve the return values for a method\n    my $method_db_ref = Deobfuscator::open_db('methods.db');\n    my $ret_vals = Deobfuscator::get_method_docs( $method_db_ref,\n                                                  'Bio::SeqIO::next_seq',\n                                                  'returns' );\n    close_db($method_db_ref);\n\n    # retrieve the synopsis documentation for a class\n    my $pkg_db_ref = Deobfuscator::open_db('packages.db');\n    my $synopsis = Deobfuscator::get_pkg_docs( $pkg_db_ref,\n                                              'Bio::SeqIO',\n                                              'synopsis' );\n    close_db($pkg_db_ref);\n\n\n=head1 DESCRIPTION\n\nThe Deobfuscator module contains functions which relate to retrieving\nspecific types of documentation about BioPerl packages and methods.\n\nThe deob_index.pl script reads through all of the BioPerl files, extracts\nthe documentation, and stores it in two BerkeleyDB databases. This module\nis then used to query those databases for information about a given method\nor package. (see the deob_index.pl documentation for more info.)\n\nThe types of information available for individual methods include: the\nusage statement, the return values, the arguments to give to the method, the\ndescription of the function, and an example of how to use the method.\n\nThe Deobfuscator module can be used also to retrieve the synopsis and\ndescription documentation for a given class.\n\n\n=head1 DIAGNOSTICS\n\n\n* C<< error: couldn't eval $module >>\n\nA package couldn't be loaded (eval'd), which would prevent us from determining\nwhat its methods are.\n\n* C<< error: couldn't open $filename >>\n\nOne of the Berkeley databases couldn't be opened. Possible causes are:\ndeob_index.pl wasn't run and so the databases weren't created, or the database\nfiles aren't in the correct place.\n\n* C<< error: couldn't close database >>\n\nOne of the Berkeley databases couldn't be closed. This might just be a \ntransient filesystem error.\n\n\n\n=head1 CONFIGURATION AND ENVIRONMENT\n\nThis software requires:\n\n\n* A working installation of the Berkeley DB\n\nThe Berkeley DB comes standard with most UNIX distributions, so you may \nalready have it installed. See L<http://www.sleepycat.com> for more information.\n\n* BioPerl\n\nDeobfuscator.pm recursively navigates a directory of BioPerl modules. Note\nthat the BioPerl module directory need not be \"installed\"; any old location\nwill do. See L<http://www.bioperl.org> for the latest version.\n\n\n\n=head1 DEPENDENCIES\n\nL<version>, L<Class::Inspector>, L<DB_File>\n\n\n=head1 INCOMPATIBILITIES\n\nNone reported.\n\n\n=head1 BUGS AND LIMITATIONS\n\nIn the current implementation, Deobfuscator does not show internal or private\nmethods (i.e. those whose name begins with an underscore). This is simply an\noption in the Class::Inspector->methods call, and so could be presented as an\noption to the user (patches welcome).\n\nNo bugs have been reported.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                       - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists   - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org/\n\n\n=head1 SEE ALSO\n\nL<deob_index.pl>\n\n\n=head1 AUTHOR\n\nDave Messina C<< <dave-pause@davemessina.net> >>\n\n\n=head1 CONTRIBUTORS\n\n\n* Laura Kavanaugh\n\n* David Curiel\n\n\n\n=head1 ACKNOWLEDGMENTS\n\nThis software was developed originally at the Cold Spring Harbor Laboratory's\nAdvanced Bioinformatics Course between Oct 12-25, 2005. Many thanks to David\nCuriel, who provided much-needed guidance and assistance on this project.\n\n\n=head1 LICENSE AND COPYRIGHT\n\nCopyright (C) 2005-6 Laura Kavanaugh and Dave Messina. All Rights Reserved.\n\nThis module is free software; you may redistribute it and/or modify it under the\nsame terms as Perl itself. See L<perlartistic>.\n\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the functions.\nInternal methods are preceded with a \"_\".\n\n\n\nuse version; $VERSION = qv('0.0.3');\nuse warnings;\nuse strict;\nuse Class::Inspector;\nuse DB_File;\n\nuse lib './lib';\n\n\n=head2 return_methods\n\nTitle   : return_methods\nUsage   : $methods_hashref = Deobfuscator::return_methods('Bio::AlignIO',\n          'Bio::SeqIO');\nFunction: traverses the inheritance tree for a given class to determine\n          the methods available to objects belonging to that class\n\nReturns : a reference to a hash. The hash keys are fully-qualified class\n          names, such as 'Bio::SeqIO'. The hash values are references to\n          an array of hashes, where each array element is a reference to \n          a hash containing two key-value pairs, 'method' and 'class';\n\nArgs    : a list of fully-qualified class names\n\n\nsub return_methods {\n\n    my @input = @_;\n\n    # key: full class name\n    # value: a reference to an array of hashes\n    #    where each array element is a pointer to a hash\n    #    which contains two key: 'method' and 'class'\n    my %methods_of;\n\n\n    foreach my $class (@input) {\n\n        # fancy eval so that we can loop through different modules\n        _load_module($class);\n\n        # methods returned from Class::Inspector as:\n        # [\n        #   [ 'Class::method1',   'Class',   'method1', \\&Class::method1   ],\n        #   [ 'Another::method2', 'Another', 'method2', \\&Another::method2 ],\n        #   [ 'Foo::bar',         'Foo',     'bar',     \\&Foo::bar         ],\n        # ]\n        my $methods_aryref3\n            = Class::Inspector->methods( $class, 'expanded', 'public' );\n\n\n        for ( my $i = 0; $i < scalar @{$methods_aryref3}; $i++ ) {\n            foreach my $meth ( $methods_aryref3->[$i] ) {\n                my $method_name    = $meth->[2];\n                my $inherited_from = $meth->[1];\n                push @{$methods_of{$class}}, [$method_name, $inherited_from];\n            }\n\n        }\n\n    }\n    return \\%methods_of;\n}\n\n=head2 print_methods\n\nTitle   : print_methods\nUsage   : print_methods('Bio::AlignIO','Bio::SeqIO');\nFunction: traverses the inheritance tree for a given class to determine\n           the methods available to objects belonging to that class, then\n           pretty-prints the resulting information.\nReturns : nothing. But it does print to the current filehandle (usually\n           STDOUT).\nArgs    : a list of fully-qualified class names\n\n\nsub print_methods {\n\n    my @input = @_;\n\n    foreach my $class (@input) {\n\n        # fancy eval so that we can loop through different modules\n        _load_module($class);\n\n        # methods returned as\n        # [\n        #   [ 'Class::method1',   'Class',   'method1', \\&Class::method1   ],\n        #   [ 'Another::method2', 'Another', 'method2', \\&Another::method2 ],\n        #   [ 'Foo::bar',         'Foo',     'bar',     \\&Foo::bar         ],\n        # ]\n        my $methods_aryref3\n            = Class::Inspector->methods( $class, 'expanded', 'public' );\n\n        print \"methods for $class\\n\";\n        print \"=========================================\\n\";\n\n        for ( my $i = 0; $i < scalar @{$methods_aryref3}; $i++ ) {\n            print \"method $i\\n\";\n            foreach my $meth ( $methods_aryref3->[$i] ) {\n                print \"\\t           class: $meth->[1]\\n\";\n                print \"\\t          method: $meth->[2]\\n\";\n            }\n            print \"--------------------------------------\\n\";\n        }\n\n    }\n\n}\n\n=head2 _load_module\n\nTitle   : _load_module\nUsage   : * INTERNAL USE ONLY *\nFunction: attempts to load a module\nReturns : nothing. But it does die upon failure to load.\nArgs    : a module name\n\n\nsub _load_module {\n    my $module = shift;\n    eval \"require $module\";\n    my $err = $@ || 'eval returned undef';\n    \n    if ($@) { return $@ }\n    else { return }\n}\n\n=head2 open_db\n\nTitle   : open_db\nUsage   : open_db($filename)\nFunction: opens a Berkeley DB\nReturns : a hashref tied to the DB\nArgs    : a filename as a scalar","parameters":[{"label":"$filename"}],"label":"open_db($filename)"}},{"line":372,"kind":12,"range":{"start":{"character":0,"line":372},"end":{"line":376,"character":9999}},"signature":{"parameters":[{"label":"$hashref"}],"documentation":"__END__\npackage Deobfuscator;\n\n# module for retrieving method-specific documentation from a\n# Berkeley database\n#\n# first version by Dave Messina (dmessina@watson.wustl.edu) at the\n# Cold Spring Harbor Laboratory Advanced Bioinformatics Course\n# Oct 12-25, 2005\n\n# part of the Deobfuscator package\n# by Laura Kavanaugh and Dave Messina\n#\n# cared for by Dave Messina <dave-pause@davemessina.net>\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nDeobfuscator - get BioPerl method and package information from a Berkeley DB\n\n\n=head1 VERSION\n\nThis document describes Deobfuscator version 0.0.3\n\n\n=head1 SYNOPSIS\n\n    use Deobfuscator;\n\n    # get all the methods available to objects belonging to a class\n    # (including those inherited from parent classes)\n    my $hashref = Deobfuscator::return_methods('Bio::SeqIO', 'Bio::AlignIO');\n\n    # retrieve the return values for a method\n    my $method_db_ref = Deobfuscator::open_db('methods.db');\n    my $ret_vals = Deobfuscator::get_method_docs( $method_db_ref,\n                                                  'Bio::SeqIO::next_seq',\n                                                  'returns' );\n    close_db($method_db_ref);\n\n    # retrieve the synopsis documentation for a class\n    my $pkg_db_ref = Deobfuscator::open_db('packages.db');\n    my $synopsis = Deobfuscator::get_pkg_docs( $pkg_db_ref,\n                                              'Bio::SeqIO',\n                                              'synopsis' );\n    close_db($pkg_db_ref);\n\n\n=head1 DESCRIPTION\n\nThe Deobfuscator module contains functions which relate to retrieving\nspecific types of documentation about BioPerl packages and methods.\n\nThe deob_index.pl script reads through all of the BioPerl files, extracts\nthe documentation, and stores it in two BerkeleyDB databases. This module\nis then used to query those databases for information about a given method\nor package. (see the deob_index.pl documentation for more info.)\n\nThe types of information available for individual methods include: the\nusage statement, the return values, the arguments to give to the method, the\ndescription of the function, and an example of how to use the method.\n\nThe Deobfuscator module can be used also to retrieve the synopsis and\ndescription documentation for a given class.\n\n\n=head1 DIAGNOSTICS\n\n\n* C<< error: couldn't eval $module >>\n\nA package couldn't be loaded (eval'd), which would prevent us from determining\nwhat its methods are.\n\n* C<< error: couldn't open $filename >>\n\nOne of the Berkeley databases couldn't be opened. Possible causes are:\ndeob_index.pl wasn't run and so the databases weren't created, or the database\nfiles aren't in the correct place.\n\n* C<< error: couldn't close database >>\n\nOne of the Berkeley databases couldn't be closed. This might just be a \ntransient filesystem error.\n\n\n\n=head1 CONFIGURATION AND ENVIRONMENT\n\nThis software requires:\n\n\n* A working installation of the Berkeley DB\n\nThe Berkeley DB comes standard with most UNIX distributions, so you may \nalready have it installed. See L<http://www.sleepycat.com> for more information.\n\n* BioPerl\n\nDeobfuscator.pm recursively navigates a directory of BioPerl modules. Note\nthat the BioPerl module directory need not be \"installed\"; any old location\nwill do. See L<http://www.bioperl.org> for the latest version.\n\n\n\n=head1 DEPENDENCIES\n\nL<version>, L<Class::Inspector>, L<DB_File>\n\n\n=head1 INCOMPATIBILITIES\n\nNone reported.\n\n\n=head1 BUGS AND LIMITATIONS\n\nIn the current implementation, Deobfuscator does not show internal or private\nmethods (i.e. those whose name begins with an underscore). This is simply an\noption in the Class::Inspector->methods call, and so could be presented as an\noption to the user (patches welcome).\n\nNo bugs have been reported.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                       - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists   - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org/\n\n\n=head1 SEE ALSO\n\nL<deob_index.pl>\n\n\n=head1 AUTHOR\n\nDave Messina C<< <dave-pause@davemessina.net> >>\n\n\n=head1 CONTRIBUTORS\n\n\n* Laura Kavanaugh\n\n* David Curiel\n\n\n\n=head1 ACKNOWLEDGMENTS\n\nThis software was developed originally at the Cold Spring Harbor Laboratory's\nAdvanced Bioinformatics Course between Oct 12-25, 2005. Many thanks to David\nCuriel, who provided much-needed guidance and assistance on this project.\n\n\n=head1 LICENSE AND COPYRIGHT\n\nCopyright (C) 2005-6 Laura Kavanaugh and Dave Messina. All Rights Reserved.\n\nThis module is free software; you may redistribute it and/or modify it under the\nsame terms as Perl itself. See L<perlartistic>.\n\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the functions.\nInternal methods are preceded with a \"_\".\n\n\n\nuse version; $VERSION = qv('0.0.3');\nuse warnings;\nuse strict;\nuse Class::Inspector;\nuse DB_File;\n\nuse lib './lib';\n\n\n=head2 return_methods\n\nTitle   : return_methods\nUsage   : $methods_hashref = Deobfuscator::return_methods('Bio::AlignIO',\n          'Bio::SeqIO');\nFunction: traverses the inheritance tree for a given class to determine\n          the methods available to objects belonging to that class\n\nReturns : a reference to a hash. The hash keys are fully-qualified class\n          names, such as 'Bio::SeqIO'. The hash values are references to\n          an array of hashes, where each array element is a reference to \n          a hash containing two key-value pairs, 'method' and 'class';\n\nArgs    : a list of fully-qualified class names\n\n\nsub return_methods {\n\n    my @input = @_;\n\n    # key: full class name\n    # value: a reference to an array of hashes\n    #    where each array element is a pointer to a hash\n    #    which contains two key: 'method' and 'class'\n    my %methods_of;\n\n\n    foreach my $class (@input) {\n\n        # fancy eval so that we can loop through different modules\n        _load_module($class);\n\n        # methods returned from Class::Inspector as:\n        # [\n        #   [ 'Class::method1',   'Class',   'method1', \\&Class::method1   ],\n        #   [ 'Another::method2', 'Another', 'method2', \\&Another::method2 ],\n        #   [ 'Foo::bar',         'Foo',     'bar',     \\&Foo::bar         ],\n        # ]\n        my $methods_aryref3\n            = Class::Inspector->methods( $class, 'expanded', 'public' );\n\n\n        for ( my $i = 0; $i < scalar @{$methods_aryref3}; $i++ ) {\n            foreach my $meth ( $methods_aryref3->[$i] ) {\n                my $method_name    = $meth->[2];\n                my $inherited_from = $meth->[1];\n                push @{$methods_of{$class}}, [$method_name, $inherited_from];\n            }\n\n        }\n\n    }\n    return \\%methods_of;\n}\n\n=head2 print_methods\n\nTitle   : print_methods\nUsage   : print_methods('Bio::AlignIO','Bio::SeqIO');\nFunction: traverses the inheritance tree for a given class to determine\n           the methods available to objects belonging to that class, then\n           pretty-prints the resulting information.\nReturns : nothing. But it does print to the current filehandle (usually\n           STDOUT).\nArgs    : a list of fully-qualified class names\n\n\nsub print_methods {\n\n    my @input = @_;\n\n    foreach my $class (@input) {\n\n        # fancy eval so that we can loop through different modules\n        _load_module($class);\n\n        # methods returned as\n        # [\n        #   [ 'Class::method1',   'Class',   'method1', \\&Class::method1   ],\n        #   [ 'Another::method2', 'Another', 'method2', \\&Another::method2 ],\n        #   [ 'Foo::bar',         'Foo',     'bar',     \\&Foo::bar         ],\n        # ]\n        my $methods_aryref3\n            = Class::Inspector->methods( $class, 'expanded', 'public' );\n\n        print \"methods for $class\\n\";\n        print \"=========================================\\n\";\n\n        for ( my $i = 0; $i < scalar @{$methods_aryref3}; $i++ ) {\n            print \"method $i\\n\";\n            foreach my $meth ( $methods_aryref3->[$i] ) {\n                print \"\\t           class: $meth->[1]\\n\";\n                print \"\\t          method: $meth->[2]\\n\";\n            }\n            print \"--------------------------------------\\n\";\n        }\n\n    }\n\n}\n\n=head2 _load_module\n\nTitle   : _load_module\nUsage   : * INTERNAL USE ONLY *\nFunction: attempts to load a module\nReturns : nothing. But it does die upon failure to load.\nArgs    : a module name\n\n\nsub _load_module {\n    my $module = shift;\n    eval \"require $module\";\n    my $err = $@ || 'eval returned undef';\n    \n    if ($@) { return $@ }\n    else { return }\n}\n\n=head2 open_db\n\nTitle   : open_db\nUsage   : open_db($filename)\nFunction: opens a Berkeley DB\nReturns : a hashref tied to the DB\nArgs    : a filename as a scalar\n\n\nsub open_db {\n    my ($filename) = @_;\n    \n    my %hash;\n    my $hashref = \\%hash;\n    \n    tie %hash, \"DB_File\", $filename or die \"error: couldn't open $filename: $!\\n\";\n    \n    return $hashref;\n}\n\n=head2 close_db\n\nTitle   : close_db\nUsage   : closes a Berkeley DB\nFunction: closes a database\nReturns : nothing.\nArgs    : a hashref to a tied Berkeley DB","label":"close_db($hashref)"},"children":[{"definition":"my","name":"$hashref","localvar":"my","containerName":"close_db","kind":13,"line":373},{"containerName":"close_db","kind":13,"name":"$hashref","line":375}],"name":"close_db","containerName":"main::","definition":"sub","detail":"($hashref)"},{"line":393,"range":{"start":{"line":393,"character":0},"end":{"character":9999,"line":415}},"kind":12,"signature":{"label":"get_pkg_docs($db_hashref,$pkg_name,$info_type)","parameters":[{"label":"$db_hashref"},{"label":"$pkg_name"},{"label":"$info_type"}],"documentation":"__END__\npackage Deobfuscator;\n\n# module for retrieving method-specific documentation from a\n# Berkeley database\n#\n# first version by Dave Messina (dmessina@watson.wustl.edu) at the\n# Cold Spring Harbor Laboratory Advanced Bioinformatics Course\n# Oct 12-25, 2005\n\n# part of the Deobfuscator package\n# by Laura Kavanaugh and Dave Messina\n#\n# cared for by Dave Messina <dave-pause@davemessina.net>\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nDeobfuscator - get BioPerl method and package information from a Berkeley DB\n\n\n=head1 VERSION\n\nThis document describes Deobfuscator version 0.0.3\n\n\n=head1 SYNOPSIS\n\n    use Deobfuscator;\n\n    # get all the methods available to objects belonging to a class\n    # (including those inherited from parent classes)\n    my $hashref = Deobfuscator::return_methods('Bio::SeqIO', 'Bio::AlignIO');\n\n    # retrieve the return values for a method\n    my $method_db_ref = Deobfuscator::open_db('methods.db');\n    my $ret_vals = Deobfuscator::get_method_docs( $method_db_ref,\n                                                  'Bio::SeqIO::next_seq',\n                                                  'returns' );\n    close_db($method_db_ref);\n\n    # retrieve the synopsis documentation for a class\n    my $pkg_db_ref = Deobfuscator::open_db('packages.db');\n    my $synopsis = Deobfuscator::get_pkg_docs( $pkg_db_ref,\n                                              'Bio::SeqIO',\n                                              'synopsis' );\n    close_db($pkg_db_ref);\n\n\n=head1 DESCRIPTION\n\nThe Deobfuscator module contains functions which relate to retrieving\nspecific types of documentation about BioPerl packages and methods.\n\nThe deob_index.pl script reads through all of the BioPerl files, extracts\nthe documentation, and stores it in two BerkeleyDB databases. This module\nis then used to query those databases for information about a given method\nor package. (see the deob_index.pl documentation for more info.)\n\nThe types of information available for individual methods include: the\nusage statement, the return values, the arguments to give to the method, the\ndescription of the function, and an example of how to use the method.\n\nThe Deobfuscator module can be used also to retrieve the synopsis and\ndescription documentation for a given class.\n\n\n=head1 DIAGNOSTICS\n\n\n* C<< error: couldn't eval $module >>\n\nA package couldn't be loaded (eval'd), which would prevent us from determining\nwhat its methods are.\n\n* C<< error: couldn't open $filename >>\n\nOne of the Berkeley databases couldn't be opened. Possible causes are:\ndeob_index.pl wasn't run and so the databases weren't created, or the database\nfiles aren't in the correct place.\n\n* C<< error: couldn't close database >>\n\nOne of the Berkeley databases couldn't be closed. This might just be a \ntransient filesystem error.\n\n\n\n=head1 CONFIGURATION AND ENVIRONMENT\n\nThis software requires:\n\n\n* A working installation of the Berkeley DB\n\nThe Berkeley DB comes standard with most UNIX distributions, so you may \nalready have it installed. See L<http://www.sleepycat.com> for more information.\n\n* BioPerl\n\nDeobfuscator.pm recursively navigates a directory of BioPerl modules. Note\nthat the BioPerl module directory need not be \"installed\"; any old location\nwill do. See L<http://www.bioperl.org> for the latest version.\n\n\n\n=head1 DEPENDENCIES\n\nL<version>, L<Class::Inspector>, L<DB_File>\n\n\n=head1 INCOMPATIBILITIES\n\nNone reported.\n\n\n=head1 BUGS AND LIMITATIONS\n\nIn the current implementation, Deobfuscator does not show internal or private\nmethods (i.e. those whose name begins with an underscore). This is simply an\noption in the Class::Inspector->methods call, and so could be presented as an\noption to the user (patches welcome).\n\nNo bugs have been reported.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                       - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists   - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org/\n\n\n=head1 SEE ALSO\n\nL<deob_index.pl>\n\n\n=head1 AUTHOR\n\nDave Messina C<< <dave-pause@davemessina.net> >>\n\n\n=head1 CONTRIBUTORS\n\n\n* Laura Kavanaugh\n\n* David Curiel\n\n\n\n=head1 ACKNOWLEDGMENTS\n\nThis software was developed originally at the Cold Spring Harbor Laboratory's\nAdvanced Bioinformatics Course between Oct 12-25, 2005. Many thanks to David\nCuriel, who provided much-needed guidance and assistance on this project.\n\n\n=head1 LICENSE AND COPYRIGHT\n\nCopyright (C) 2005-6 Laura Kavanaugh and Dave Messina. All Rights Reserved.\n\nThis module is free software; you may redistribute it and/or modify it under the\nsame terms as Perl itself. See L<perlartistic>.\n\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the functions.\nInternal methods are preceded with a \"_\".\n\n\n\nuse version; $VERSION = qv('0.0.3');\nuse warnings;\nuse strict;\nuse Class::Inspector;\nuse DB_File;\n\nuse lib './lib';\n\n\n=head2 return_methods\n\nTitle   : return_methods\nUsage   : $methods_hashref = Deobfuscator::return_methods('Bio::AlignIO',\n          'Bio::SeqIO');\nFunction: traverses the inheritance tree for a given class to determine\n          the methods available to objects belonging to that class\n\nReturns : a reference to a hash. The hash keys are fully-qualified class\n          names, such as 'Bio::SeqIO'. The hash values are references to\n          an array of hashes, where each array element is a reference to \n          a hash containing two key-value pairs, 'method' and 'class';\n\nArgs    : a list of fully-qualified class names\n\n\nsub return_methods {\n\n    my @input = @_;\n\n    # key: full class name\n    # value: a reference to an array of hashes\n    #    where each array element is a pointer to a hash\n    #    which contains two key: 'method' and 'class'\n    my %methods_of;\n\n\n    foreach my $class (@input) {\n\n        # fancy eval so that we can loop through different modules\n        _load_module($class);\n\n        # methods returned from Class::Inspector as:\n        # [\n        #   [ 'Class::method1',   'Class',   'method1', \\&Class::method1   ],\n        #   [ 'Another::method2', 'Another', 'method2', \\&Another::method2 ],\n        #   [ 'Foo::bar',         'Foo',     'bar',     \\&Foo::bar         ],\n        # ]\n        my $methods_aryref3\n            = Class::Inspector->methods( $class, 'expanded', 'public' );\n\n\n        for ( my $i = 0; $i < scalar @{$methods_aryref3}; $i++ ) {\n            foreach my $meth ( $methods_aryref3->[$i] ) {\n                my $method_name    = $meth->[2];\n                my $inherited_from = $meth->[1];\n                push @{$methods_of{$class}}, [$method_name, $inherited_from];\n            }\n\n        }\n\n    }\n    return \\%methods_of;\n}\n\n=head2 print_methods\n\nTitle   : print_methods\nUsage   : print_methods('Bio::AlignIO','Bio::SeqIO');\nFunction: traverses the inheritance tree for a given class to determine\n           the methods available to objects belonging to that class, then\n           pretty-prints the resulting information.\nReturns : nothing. But it does print to the current filehandle (usually\n           STDOUT).\nArgs    : a list of fully-qualified class names\n\n\nsub print_methods {\n\n    my @input = @_;\n\n    foreach my $class (@input) {\n\n        # fancy eval so that we can loop through different modules\n        _load_module($class);\n\n        # methods returned as\n        # [\n        #   [ 'Class::method1',   'Class',   'method1', \\&Class::method1   ],\n        #   [ 'Another::method2', 'Another', 'method2', \\&Another::method2 ],\n        #   [ 'Foo::bar',         'Foo',     'bar',     \\&Foo::bar         ],\n        # ]\n        my $methods_aryref3\n            = Class::Inspector->methods( $class, 'expanded', 'public' );\n\n        print \"methods for $class\\n\";\n        print \"=========================================\\n\";\n\n        for ( my $i = 0; $i < scalar @{$methods_aryref3}; $i++ ) {\n            print \"method $i\\n\";\n            foreach my $meth ( $methods_aryref3->[$i] ) {\n                print \"\\t           class: $meth->[1]\\n\";\n                print \"\\t          method: $meth->[2]\\n\";\n            }\n            print \"--------------------------------------\\n\";\n        }\n\n    }\n\n}\n\n=head2 _load_module\n\nTitle   : _load_module\nUsage   : * INTERNAL USE ONLY *\nFunction: attempts to load a module\nReturns : nothing. But it does die upon failure to load.\nArgs    : a module name\n\n\nsub _load_module {\n    my $module = shift;\n    eval \"require $module\";\n    my $err = $@ || 'eval returned undef';\n    \n    if ($@) { return $@ }\n    else { return }\n}\n\n=head2 open_db\n\nTitle   : open_db\nUsage   : open_db($filename)\nFunction: opens a Berkeley DB\nReturns : a hashref tied to the DB\nArgs    : a filename as a scalar\n\n\nsub open_db {\n    my ($filename) = @_;\n    \n    my %hash;\n    my $hashref = \\%hash;\n    \n    tie %hash, \"DB_File\", $filename or die \"error: couldn't open $filename: $!\\n\";\n    \n    return $hashref;\n}\n\n=head2 close_db\n\nTitle   : close_db\nUsage   : closes a Berkeley DB\nFunction: closes a database\nReturns : nothing.\nArgs    : a hashref to a tied Berkeley DB\n\n\nsub close_db {\n    my ($hashref) = @_;\n    \n    untie $hashref or die \"error: couldn't close database: $!\\n\";\n}\n\n=head2 get_pkg_docs\n\nTitle   : get_pkg_docs\nUsage   : get_pkg_docs($db_hashref, 'Class name', 'documentation type');\nFunction: returns a specified part of the documentation for a class\nReturns : a string containing the desired documentation or ' ' if the\n          documentation doesn't exist\nArgs    : - $db_hashref is the ref to the hash tied to the DB\n          - Class name is of the form 'Bio::SeqIO'\n          - documentation type is the subfield of the method's POD.\n          The possible values of documentation type are:\n          short_desc, synopsis, desc"},"children":[{"name":"$db_hashref","localvar":"my","kind":13,"containerName":"get_pkg_docs","line":394,"definition":"my"},{"line":394,"kind":13,"containerName":"get_pkg_docs","name":"$pkg_name"},{"line":394,"name":"$info_type","kind":13,"containerName":"get_pkg_docs"},{"definition":"my","line":397,"localvar":"my","kind":13,"containerName":"get_pkg_docs","name":"%record"},{"name":"$rec_sep","localvar":"my","kind":13,"containerName":"get_pkg_docs","line":399,"definition":"my"},{"kind":13,"containerName":"get_pkg_docs","name":"$db_hashref","line":402},{"line":402,"containerName":"get_pkg_docs","kind":13,"name":"$pkg_name"},{"name":"$record","kind":13,"containerName":"get_pkg_docs","line":407},{"name":"$record","containerName":"get_pkg_docs","kind":13,"line":407},{"kind":13,"containerName":"get_pkg_docs","name":"$record","line":407},{"line":408,"containerName":"get_pkg_docs","kind":13,"name":"$rec_sep"},{"name":"$db_hashref","containerName":"get_pkg_docs","kind":13,"line":408},{"line":408,"kind":13,"containerName":"get_pkg_docs","name":"$pkg_name"},{"line":411,"name":"$record","kind":13,"containerName":"get_pkg_docs"},{"containerName":"get_pkg_docs","kind":13,"name":"$info_type","line":411},{"line":412,"name":"$record","containerName":"get_pkg_docs","kind":13},{"name":"$info_type","containerName":"get_pkg_docs","kind":13,"line":412}],"name":"get_pkg_docs","containerName":"main::","definition":"sub","detail":"($db_hashref,$pkg_name,$info_type)"},{"signature":{"parameters":[{"label":"$db_hashref"},{"label":"$meth_name"},{"label":"$info_type"}],"documentation":"__END__\npackage Deobfuscator;\n\n# module for retrieving method-specific documentation from a\n# Berkeley database\n#\n# first version by Dave Messina (dmessina@watson.wustl.edu) at the\n# Cold Spring Harbor Laboratory Advanced Bioinformatics Course\n# Oct 12-25, 2005\n\n# part of the Deobfuscator package\n# by Laura Kavanaugh and Dave Messina\n#\n# cared for by Dave Messina <dave-pause@davemessina.net>\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nDeobfuscator - get BioPerl method and package information from a Berkeley DB\n\n\n=head1 VERSION\n\nThis document describes Deobfuscator version 0.0.3\n\n\n=head1 SYNOPSIS\n\n    use Deobfuscator;\n\n    # get all the methods available to objects belonging to a class\n    # (including those inherited from parent classes)\n    my $hashref = Deobfuscator::return_methods('Bio::SeqIO', 'Bio::AlignIO');\n\n    # retrieve the return values for a method\n    my $method_db_ref = Deobfuscator::open_db('methods.db');\n    my $ret_vals = Deobfuscator::get_method_docs( $method_db_ref,\n                                                  'Bio::SeqIO::next_seq',\n                                                  'returns' );\n    close_db($method_db_ref);\n\n    # retrieve the synopsis documentation for a class\n    my $pkg_db_ref = Deobfuscator::open_db('packages.db');\n    my $synopsis = Deobfuscator::get_pkg_docs( $pkg_db_ref,\n                                              'Bio::SeqIO',\n                                              'synopsis' );\n    close_db($pkg_db_ref);\n\n\n=head1 DESCRIPTION\n\nThe Deobfuscator module contains functions which relate to retrieving\nspecific types of documentation about BioPerl packages and methods.\n\nThe deob_index.pl script reads through all of the BioPerl files, extracts\nthe documentation, and stores it in two BerkeleyDB databases. This module\nis then used to query those databases for information about a given method\nor package. (see the deob_index.pl documentation for more info.)\n\nThe types of information available for individual methods include: the\nusage statement, the return values, the arguments to give to the method, the\ndescription of the function, and an example of how to use the method.\n\nThe Deobfuscator module can be used also to retrieve the synopsis and\ndescription documentation for a given class.\n\n\n=head1 DIAGNOSTICS\n\n\n* C<< error: couldn't eval $module >>\n\nA package couldn't be loaded (eval'd), which would prevent us from determining\nwhat its methods are.\n\n* C<< error: couldn't open $filename >>\n\nOne of the Berkeley databases couldn't be opened. Possible causes are:\ndeob_index.pl wasn't run and so the databases weren't created, or the database\nfiles aren't in the correct place.\n\n* C<< error: couldn't close database >>\n\nOne of the Berkeley databases couldn't be closed. This might just be a \ntransient filesystem error.\n\n\n\n=head1 CONFIGURATION AND ENVIRONMENT\n\nThis software requires:\n\n\n* A working installation of the Berkeley DB\n\nThe Berkeley DB comes standard with most UNIX distributions, so you may \nalready have it installed. See L<http://www.sleepycat.com> for more information.\n\n* BioPerl\n\nDeobfuscator.pm recursively navigates a directory of BioPerl modules. Note\nthat the BioPerl module directory need not be \"installed\"; any old location\nwill do. See L<http://www.bioperl.org> for the latest version.\n\n\n\n=head1 DEPENDENCIES\n\nL<version>, L<Class::Inspector>, L<DB_File>\n\n\n=head1 INCOMPATIBILITIES\n\nNone reported.\n\n\n=head1 BUGS AND LIMITATIONS\n\nIn the current implementation, Deobfuscator does not show internal or private\nmethods (i.e. those whose name begins with an underscore). This is simply an\noption in the Class::Inspector->methods call, and so could be presented as an\noption to the user (patches welcome).\n\nNo bugs have been reported.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                       - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists   - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org/\n\n\n=head1 SEE ALSO\n\nL<deob_index.pl>\n\n\n=head1 AUTHOR\n\nDave Messina C<< <dave-pause@davemessina.net> >>\n\n\n=head1 CONTRIBUTORS\n\n\n* Laura Kavanaugh\n\n* David Curiel\n\n\n\n=head1 ACKNOWLEDGMENTS\n\nThis software was developed originally at the Cold Spring Harbor Laboratory's\nAdvanced Bioinformatics Course between Oct 12-25, 2005. Many thanks to David\nCuriel, who provided much-needed guidance and assistance on this project.\n\n\n=head1 LICENSE AND COPYRIGHT\n\nCopyright (C) 2005-6 Laura Kavanaugh and Dave Messina. All Rights Reserved.\n\nThis module is free software; you may redistribute it and/or modify it under the\nsame terms as Perl itself. See L<perlartistic>.\n\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the functions.\nInternal methods are preceded with a \"_\".\n\n\n\nuse version; $VERSION = qv('0.0.3');\nuse warnings;\nuse strict;\nuse Class::Inspector;\nuse DB_File;\n\nuse lib './lib';\n\n\n=head2 return_methods\n\nTitle   : return_methods\nUsage   : $methods_hashref = Deobfuscator::return_methods('Bio::AlignIO',\n          'Bio::SeqIO');\nFunction: traverses the inheritance tree for a given class to determine\n          the methods available to objects belonging to that class\n\nReturns : a reference to a hash. The hash keys are fully-qualified class\n          names, such as 'Bio::SeqIO'. The hash values are references to\n          an array of hashes, where each array element is a reference to \n          a hash containing two key-value pairs, 'method' and 'class';\n\nArgs    : a list of fully-qualified class names\n\n\nsub return_methods {\n\n    my @input = @_;\n\n    # key: full class name\n    # value: a reference to an array of hashes\n    #    where each array element is a pointer to a hash\n    #    which contains two key: 'method' and 'class'\n    my %methods_of;\n\n\n    foreach my $class (@input) {\n\n        # fancy eval so that we can loop through different modules\n        _load_module($class);\n\n        # methods returned from Class::Inspector as:\n        # [\n        #   [ 'Class::method1',   'Class',   'method1', \\&Class::method1   ],\n        #   [ 'Another::method2', 'Another', 'method2', \\&Another::method2 ],\n        #   [ 'Foo::bar',         'Foo',     'bar',     \\&Foo::bar         ],\n        # ]\n        my $methods_aryref3\n            = Class::Inspector->methods( $class, 'expanded', 'public' );\n\n\n        for ( my $i = 0; $i < scalar @{$methods_aryref3}; $i++ ) {\n            foreach my $meth ( $methods_aryref3->[$i] ) {\n                my $method_name    = $meth->[2];\n                my $inherited_from = $meth->[1];\n                push @{$methods_of{$class}}, [$method_name, $inherited_from];\n            }\n\n        }\n\n    }\n    return \\%methods_of;\n}\n\n=head2 print_methods\n\nTitle   : print_methods\nUsage   : print_methods('Bio::AlignIO','Bio::SeqIO');\nFunction: traverses the inheritance tree for a given class to determine\n           the methods available to objects belonging to that class, then\n           pretty-prints the resulting information.\nReturns : nothing. But it does print to the current filehandle (usually\n           STDOUT).\nArgs    : a list of fully-qualified class names\n\n\nsub print_methods {\n\n    my @input = @_;\n\n    foreach my $class (@input) {\n\n        # fancy eval so that we can loop through different modules\n        _load_module($class);\n\n        # methods returned as\n        # [\n        #   [ 'Class::method1',   'Class',   'method1', \\&Class::method1   ],\n        #   [ 'Another::method2', 'Another', 'method2', \\&Another::method2 ],\n        #   [ 'Foo::bar',         'Foo',     'bar',     \\&Foo::bar         ],\n        # ]\n        my $methods_aryref3\n            = Class::Inspector->methods( $class, 'expanded', 'public' );\n\n        print \"methods for $class\\n\";\n        print \"=========================================\\n\";\n\n        for ( my $i = 0; $i < scalar @{$methods_aryref3}; $i++ ) {\n            print \"method $i\\n\";\n            foreach my $meth ( $methods_aryref3->[$i] ) {\n                print \"\\t           class: $meth->[1]\\n\";\n                print \"\\t          method: $meth->[2]\\n\";\n            }\n            print \"--------------------------------------\\n\";\n        }\n\n    }\n\n}\n\n=head2 _load_module\n\nTitle   : _load_module\nUsage   : * INTERNAL USE ONLY *\nFunction: attempts to load a module\nReturns : nothing. But it does die upon failure to load.\nArgs    : a module name\n\n\nsub _load_module {\n    my $module = shift;\n    eval \"require $module\";\n    my $err = $@ || 'eval returned undef';\n    \n    if ($@) { return $@ }\n    else { return }\n}\n\n=head2 open_db\n\nTitle   : open_db\nUsage   : open_db($filename)\nFunction: opens a Berkeley DB\nReturns : a hashref tied to the DB\nArgs    : a filename as a scalar\n\n\nsub open_db {\n    my ($filename) = @_;\n    \n    my %hash;\n    my $hashref = \\%hash;\n    \n    tie %hash, \"DB_File\", $filename or die \"error: couldn't open $filename: $!\\n\";\n    \n    return $hashref;\n}\n\n=head2 close_db\n\nTitle   : close_db\nUsage   : closes a Berkeley DB\nFunction: closes a database\nReturns : nothing.\nArgs    : a hashref to a tied Berkeley DB\n\n\nsub close_db {\n    my ($hashref) = @_;\n    \n    untie $hashref or die \"error: couldn't close database: $!\\n\";\n}\n\n=head2 get_pkg_docs\n\nTitle   : get_pkg_docs\nUsage   : get_pkg_docs($db_hashref, 'Class name', 'documentation type');\nFunction: returns a specified part of the documentation for a class\nReturns : a string containing the desired documentation or ' ' if the\n          documentation doesn't exist\nArgs    : - $db_hashref is the ref to the hash tied to the DB\n          - Class name is of the form 'Bio::SeqIO'\n          - documentation type is the subfield of the method's POD.\n          The possible values of documentation type are:\n          short_desc, synopsis, desc\n\n\nsub get_pkg_docs {\n    my ($db_hashref, $pkg_name, $info_type) = @_;\n\n    # hash to store our hash value, now split out into its constituent parts\n    my %record;\n        \n    my $rec_sep = 'DaVe-ReC-sEp';\n\n    # if the method isn't in our db\n    if ( ! exists($db_hashref->{$pkg_name}) ) {\n        return 0;\n    }\n\n    # grab the constituent parts of the pkg record\n    ( $record{'short_desc'}, $record{'synopsis'}, $record{'desc'} ) = \n        ( split $rec_sep, $db_hashref->{$pkg_name} );\n\n    # return just the part that was asked for\n    if ( exists($record{$info_type}) ) {\n        return $record{$info_type};\n    }\n    else { return ' '; }\n}\n\n=head2 get_method_docs\n\nTitle   : get_method_docs\nUsage   : get_method_docs($db_hashref, 'Class+method name', 'documentation type');\nExample : get_method_docs($db_hashref, 'Bio::SeqIO::next_aln', 'args');\nFunction: returns a specified part of the documentation for a class's method\nReturns : a string containing the desired documentation, or 0 if the\n         desired documentation doesn't exist\nArgs    : - $db_hashref is the ref to the hash tied to the DB\n          - Class+method name is of the form 'Bio::SeqIO::next_aln',\n            where Bio::SeqIO is the class and next_aln is the method.\n          - documentation type is the subfield of the method's POD.\n            The possible values of documentation type are:\n            title, usage, function, returns, args","label":"get_method_docs($db_hashref,$meth_name,$info_type)"},"line":434,"kind":12,"range":{"start":{"character":0,"line":434},"end":{"character":9999,"line":477}},"definition":"sub","detail":"($db_hashref,$meth_name,$info_type)","children":[{"kind":13,"localvar":"my","containerName":"get_method_docs","name":"$db_hashref","line":435,"definition":"my"},{"name":"$meth_name","kind":13,"containerName":"get_method_docs","line":435},{"line":435,"name":"$info_type","kind":13,"containerName":"get_method_docs"},{"definition":"my","name":"%record","kind":13,"localvar":"my","containerName":"get_method_docs","line":437},{"line":438,"name":"$whole_record","localvar":"my","containerName":"get_method_docs","kind":13,"definition":"my"},{"definition":"my","localvar":"my","kind":13,"containerName":"get_method_docs","name":"$rec_sep","line":440},{"line":443,"name":"$db_hashref","kind":13,"containerName":"get_method_docs"},{"line":443,"containerName":"get_method_docs","kind":13,"name":"$meth_name"},{"localvar":"my","kind":13,"containerName":"get_method_docs","name":"@parts","line":448,"definition":"my"},{"kind":13,"containerName":"get_method_docs","name":"$rec_sep","line":448},{"line":448,"containerName":"get_method_docs","kind":13,"name":"$db_hashref"},{"line":448,"name":"$meth_name","kind":13,"containerName":"get_method_docs"},{"definition":"my","line":451,"containerName":"get_method_docs","localvar":"my","kind":13,"name":"$part"},{"line":451,"name":"@parts","containerName":"get_method_docs","kind":13},{"line":452,"name":"$part","kind":13,"containerName":"get_method_docs"},{"line":452,"kind":13,"containerName":"get_method_docs","name":"$record"},{"line":455,"name":"$whole_record","containerName":"get_method_docs","kind":13},{"containerName":"get_method_docs","kind":13,"name":"$info_type","line":459},{"line":461,"name":"$record","kind":13,"containerName":"get_method_docs"},{"name":"$info_type","containerName":"get_method_docs","kind":13,"line":461},{"line":464,"name":"$record","containerName":"get_method_docs","kind":13},{"line":464,"name":"$info_type","kind":13,"containerName":"get_method_docs"},{"line":465,"kind":13,"containerName":"get_method_docs","name":"$record"},{"line":465,"name":"$info_type","containerName":"get_method_docs","kind":13},{"name":"$record","kind":13,"containerName":"get_method_docs","line":467},{"name":"$info_type","containerName":"get_method_docs","kind":13,"line":467},{"name":"$whole_record","kind":13,"containerName":"get_method_docs","line":471},{"kind":13,"containerName":"get_method_docs","name":"$whole_record","line":475}],"name":"get_method_docs","containerName":"main::"},{"detail":"($string)","definition":"sub","name":"htmlify","containerName":"main::","children":[{"definition":"my","line":492,"containerName":"htmlify","localvar":"my","kind":13,"name":"$string"},{"name":"$string","kind":13,"containerName":"htmlify","line":495},{"line":498,"name":"$string","containerName":"htmlify","kind":13},{"line":499,"name":"$string","containerName":"htmlify","kind":13},{"line":502,"name":"$string","kind":13,"containerName":"htmlify"}],"signature":{"label":"htmlify($string)","documentation":"__END__\npackage Deobfuscator;\n\n# module for retrieving method-specific documentation from a\n# Berkeley database\n#\n# first version by Dave Messina (dmessina@watson.wustl.edu) at the\n# Cold Spring Harbor Laboratory Advanced Bioinformatics Course\n# Oct 12-25, 2005\n\n# part of the Deobfuscator package\n# by Laura Kavanaugh and Dave Messina\n#\n# cared for by Dave Messina <dave-pause@davemessina.net>\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nDeobfuscator - get BioPerl method and package information from a Berkeley DB\n\n\n=head1 VERSION\n\nThis document describes Deobfuscator version 0.0.3\n\n\n=head1 SYNOPSIS\n\n    use Deobfuscator;\n\n    # get all the methods available to objects belonging to a class\n    # (including those inherited from parent classes)\n    my $hashref = Deobfuscator::return_methods('Bio::SeqIO', 'Bio::AlignIO');\n\n    # retrieve the return values for a method\n    my $method_db_ref = Deobfuscator::open_db('methods.db');\n    my $ret_vals = Deobfuscator::get_method_docs( $method_db_ref,\n                                                  'Bio::SeqIO::next_seq',\n                                                  'returns' );\n    close_db($method_db_ref);\n\n    # retrieve the synopsis documentation for a class\n    my $pkg_db_ref = Deobfuscator::open_db('packages.db');\n    my $synopsis = Deobfuscator::get_pkg_docs( $pkg_db_ref,\n                                              'Bio::SeqIO',\n                                              'synopsis' );\n    close_db($pkg_db_ref);\n\n\n=head1 DESCRIPTION\n\nThe Deobfuscator module contains functions which relate to retrieving\nspecific types of documentation about BioPerl packages and methods.\n\nThe deob_index.pl script reads through all of the BioPerl files, extracts\nthe documentation, and stores it in two BerkeleyDB databases. This module\nis then used to query those databases for information about a given method\nor package. (see the deob_index.pl documentation for more info.)\n\nThe types of information available for individual methods include: the\nusage statement, the return values, the arguments to give to the method, the\ndescription of the function, and an example of how to use the method.\n\nThe Deobfuscator module can be used also to retrieve the synopsis and\ndescription documentation for a given class.\n\n\n=head1 DIAGNOSTICS\n\n\n* C<< error: couldn't eval $module >>\n\nA package couldn't be loaded (eval'd), which would prevent us from determining\nwhat its methods are.\n\n* C<< error: couldn't open $filename >>\n\nOne of the Berkeley databases couldn't be opened. Possible causes are:\ndeob_index.pl wasn't run and so the databases weren't created, or the database\nfiles aren't in the correct place.\n\n* C<< error: couldn't close database >>\n\nOne of the Berkeley databases couldn't be closed. This might just be a \ntransient filesystem error.\n\n\n\n=head1 CONFIGURATION AND ENVIRONMENT\n\nThis software requires:\n\n\n* A working installation of the Berkeley DB\n\nThe Berkeley DB comes standard with most UNIX distributions, so you may \nalready have it installed. See L<http://www.sleepycat.com> for more information.\n\n* BioPerl\n\nDeobfuscator.pm recursively navigates a directory of BioPerl modules. Note\nthat the BioPerl module directory need not be \"installed\"; any old location\nwill do. See L<http://www.bioperl.org> for the latest version.\n\n\n\n=head1 DEPENDENCIES\n\nL<version>, L<Class::Inspector>, L<DB_File>\n\n\n=head1 INCOMPATIBILITIES\n\nNone reported.\n\n\n=head1 BUGS AND LIMITATIONS\n\nIn the current implementation, Deobfuscator does not show internal or private\nmethods (i.e. those whose name begins with an underscore). This is simply an\noption in the Class::Inspector->methods call, and so could be presented as an\noption to the user (patches welcome).\n\nNo bugs have been reported.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                       - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists   - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org/\n\n\n=head1 SEE ALSO\n\nL<deob_index.pl>\n\n\n=head1 AUTHOR\n\nDave Messina C<< <dave-pause@davemessina.net> >>\n\n\n=head1 CONTRIBUTORS\n\n\n* Laura Kavanaugh\n\n* David Curiel\n\n\n\n=head1 ACKNOWLEDGMENTS\n\nThis software was developed originally at the Cold Spring Harbor Laboratory's\nAdvanced Bioinformatics Course between Oct 12-25, 2005. Many thanks to David\nCuriel, who provided much-needed guidance and assistance on this project.\n\n\n=head1 LICENSE AND COPYRIGHT\n\nCopyright (C) 2005-6 Laura Kavanaugh and Dave Messina. All Rights Reserved.\n\nThis module is free software; you may redistribute it and/or modify it under the\nsame terms as Perl itself. See L<perlartistic>.\n\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the functions.\nInternal methods are preceded with a \"_\".\n\n\n\nuse version; $VERSION = qv('0.0.3');\nuse warnings;\nuse strict;\nuse Class::Inspector;\nuse DB_File;\n\nuse lib './lib';\n\n\n=head2 return_methods\n\nTitle   : return_methods\nUsage   : $methods_hashref = Deobfuscator::return_methods('Bio::AlignIO',\n          'Bio::SeqIO');\nFunction: traverses the inheritance tree for a given class to determine\n          the methods available to objects belonging to that class\n\nReturns : a reference to a hash. The hash keys are fully-qualified class\n          names, such as 'Bio::SeqIO'. The hash values are references to\n          an array of hashes, where each array element is a reference to \n          a hash containing two key-value pairs, 'method' and 'class';\n\nArgs    : a list of fully-qualified class names\n\n\nsub return_methods {\n\n    my @input = @_;\n\n    # key: full class name\n    # value: a reference to an array of hashes\n    #    where each array element is a pointer to a hash\n    #    which contains two key: 'method' and 'class'\n    my %methods_of;\n\n\n    foreach my $class (@input) {\n\n        # fancy eval so that we can loop through different modules\n        _load_module($class);\n\n        # methods returned from Class::Inspector as:\n        # [\n        #   [ 'Class::method1',   'Class',   'method1', \\&Class::method1   ],\n        #   [ 'Another::method2', 'Another', 'method2', \\&Another::method2 ],\n        #   [ 'Foo::bar',         'Foo',     'bar',     \\&Foo::bar         ],\n        # ]\n        my $methods_aryref3\n            = Class::Inspector->methods( $class, 'expanded', 'public' );\n\n\n        for ( my $i = 0; $i < scalar @{$methods_aryref3}; $i++ ) {\n            foreach my $meth ( $methods_aryref3->[$i] ) {\n                my $method_name    = $meth->[2];\n                my $inherited_from = $meth->[1];\n                push @{$methods_of{$class}}, [$method_name, $inherited_from];\n            }\n\n        }\n\n    }\n    return \\%methods_of;\n}\n\n=head2 print_methods\n\nTitle   : print_methods\nUsage   : print_methods('Bio::AlignIO','Bio::SeqIO');\nFunction: traverses the inheritance tree for a given class to determine\n           the methods available to objects belonging to that class, then\n           pretty-prints the resulting information.\nReturns : nothing. But it does print to the current filehandle (usually\n           STDOUT).\nArgs    : a list of fully-qualified class names\n\n\nsub print_methods {\n\n    my @input = @_;\n\n    foreach my $class (@input) {\n\n        # fancy eval so that we can loop through different modules\n        _load_module($class);\n\n        # methods returned as\n        # [\n        #   [ 'Class::method1',   'Class',   'method1', \\&Class::method1   ],\n        #   [ 'Another::method2', 'Another', 'method2', \\&Another::method2 ],\n        #   [ 'Foo::bar',         'Foo',     'bar',     \\&Foo::bar         ],\n        # ]\n        my $methods_aryref3\n            = Class::Inspector->methods( $class, 'expanded', 'public' );\n\n        print \"methods for $class\\n\";\n        print \"=========================================\\n\";\n\n        for ( my $i = 0; $i < scalar @{$methods_aryref3}; $i++ ) {\n            print \"method $i\\n\";\n            foreach my $meth ( $methods_aryref3->[$i] ) {\n                print \"\\t           class: $meth->[1]\\n\";\n                print \"\\t          method: $meth->[2]\\n\";\n            }\n            print \"--------------------------------------\\n\";\n        }\n\n    }\n\n}\n\n=head2 _load_module\n\nTitle   : _load_module\nUsage   : * INTERNAL USE ONLY *\nFunction: attempts to load a module\nReturns : nothing. But it does die upon failure to load.\nArgs    : a module name\n\n\nsub _load_module {\n    my $module = shift;\n    eval \"require $module\";\n    my $err = $@ || 'eval returned undef';\n    \n    if ($@) { return $@ }\n    else { return }\n}\n\n=head2 open_db\n\nTitle   : open_db\nUsage   : open_db($filename)\nFunction: opens a Berkeley DB\nReturns : a hashref tied to the DB\nArgs    : a filename as a scalar\n\n\nsub open_db {\n    my ($filename) = @_;\n    \n    my %hash;\n    my $hashref = \\%hash;\n    \n    tie %hash, \"DB_File\", $filename or die \"error: couldn't open $filename: $!\\n\";\n    \n    return $hashref;\n}\n\n=head2 close_db\n\nTitle   : close_db\nUsage   : closes a Berkeley DB\nFunction: closes a database\nReturns : nothing.\nArgs    : a hashref to a tied Berkeley DB\n\n\nsub close_db {\n    my ($hashref) = @_;\n    \n    untie $hashref or die \"error: couldn't close database: $!\\n\";\n}\n\n=head2 get_pkg_docs\n\nTitle   : get_pkg_docs\nUsage   : get_pkg_docs($db_hashref, 'Class name', 'documentation type');\nFunction: returns a specified part of the documentation for a class\nReturns : a string containing the desired documentation or ' ' if the\n          documentation doesn't exist\nArgs    : - $db_hashref is the ref to the hash tied to the DB\n          - Class name is of the form 'Bio::SeqIO'\n          - documentation type is the subfield of the method's POD.\n          The possible values of documentation type are:\n          short_desc, synopsis, desc\n\n\nsub get_pkg_docs {\n    my ($db_hashref, $pkg_name, $info_type) = @_;\n\n    # hash to store our hash value, now split out into its constituent parts\n    my %record;\n        \n    my $rec_sep = 'DaVe-ReC-sEp';\n\n    # if the method isn't in our db\n    if ( ! exists($db_hashref->{$pkg_name}) ) {\n        return 0;\n    }\n\n    # grab the constituent parts of the pkg record\n    ( $record{'short_desc'}, $record{'synopsis'}, $record{'desc'} ) = \n        ( split $rec_sep, $db_hashref->{$pkg_name} );\n\n    # return just the part that was asked for\n    if ( exists($record{$info_type}) ) {\n        return $record{$info_type};\n    }\n    else { return ' '; }\n}\n\n=head2 get_method_docs\n\nTitle   : get_method_docs\nUsage   : get_method_docs($db_hashref, 'Class+method name', 'documentation type');\nExample : get_method_docs($db_hashref, 'Bio::SeqIO::next_aln', 'args');\nFunction: returns a specified part of the documentation for a class's method\nReturns : a string containing the desired documentation, or 0 if the\n         desired documentation doesn't exist\nArgs    : - $db_hashref is the ref to the hash tied to the DB\n          - Class+method name is of the form 'Bio::SeqIO::next_aln',\n            where Bio::SeqIO is the class and next_aln is the method.\n          - documentation type is the subfield of the method's POD.\n            The possible values of documentation type are:\n            title, usage, function, returns, args\n\n\nsub get_method_docs {\n    my ($db_hashref, $meth_name, $info_type) = @_;\n\n    my %record;\n    my $whole_record;\n\n    my $rec_sep = 'DaVe-ReC-sEp';\n\n    # if the method isn't in our db\n    if ( !exists( $db_hashref->{$meth_name} ) ) {\n        return 0;\n    }\n\n    # separate the sub-records using the record separator and field tag\n    my @parts = split $rec_sep, $db_hashref->{$meth_name};\n\n    # put individual info types into separate hash entries...\n    foreach my $part (@parts) {\n        if ($part =~ /^-(\\w+)\\|(.*)/) { $record{$1} = $2; }\n    \n    # ... and put the whole thing into one big string\n        $whole_record .= \"$part\\n\";\n    }\n\n    # return a specific part if that was asked for\n    if ($info_type) {\n        # return just the part that was asked for      \n        if ( exists( $record{$info_type} ) ) {\n\n\t\t\t# if there's really nothing in there, say so.\n\t\t\tif ( ( $record{$info_type} =~ /^[\\s\\n]*$/)\n         \t|| ( $record{$info_type} eq '') ) { return 0; }\n\t\t\telse { \n\t\t\t\treturn $record{$info_type};\n\t\t\t}\n        }\n        # or return everything\n        else { return $whole_record; }\n    }\n    # otherwise return whole record\n    else {\n        return $whole_record;\n    }\n}\n\n=head2 htmlify\n\nTitle   : htmlify\nUsage   : htmlify($string);\nExample : htmlify('this is a : doc);\nFunction: does some crude reformatting of POD method documentation by swapping\n          isolated colons (':') into HTML <br> tags\nReturns : a string\nArgs    : a string","parameters":[{"label":"$string"}]},"range":{"start":{"line":491,"character":0},"end":{"line":503,"character":9999}},"kind":12,"line":491},{"name":"urlify_pkg","kind":12,"line":499},{"signature":{"documentation":"__END__\npackage Deobfuscator;\n\n# module for retrieving method-specific documentation from a\n# Berkeley database\n#\n# first version by Dave Messina (dmessina@watson.wustl.edu) at the\n# Cold Spring Harbor Laboratory Advanced Bioinformatics Course\n# Oct 12-25, 2005\n\n# part of the Deobfuscator package\n# by Laura Kavanaugh and Dave Messina\n#\n# cared for by Dave Messina <dave-pause@davemessina.net>\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nDeobfuscator - get BioPerl method and package information from a Berkeley DB\n\n\n=head1 VERSION\n\nThis document describes Deobfuscator version 0.0.3\n\n\n=head1 SYNOPSIS\n\n    use Deobfuscator;\n\n    # get all the methods available to objects belonging to a class\n    # (including those inherited from parent classes)\n    my $hashref = Deobfuscator::return_methods('Bio::SeqIO', 'Bio::AlignIO');\n\n    # retrieve the return values for a method\n    my $method_db_ref = Deobfuscator::open_db('methods.db');\n    my $ret_vals = Deobfuscator::get_method_docs( $method_db_ref,\n                                                  'Bio::SeqIO::next_seq',\n                                                  'returns' );\n    close_db($method_db_ref);\n\n    # retrieve the synopsis documentation for a class\n    my $pkg_db_ref = Deobfuscator::open_db('packages.db');\n    my $synopsis = Deobfuscator::get_pkg_docs( $pkg_db_ref,\n                                              'Bio::SeqIO',\n                                              'synopsis' );\n    close_db($pkg_db_ref);\n\n\n=head1 DESCRIPTION\n\nThe Deobfuscator module contains functions which relate to retrieving\nspecific types of documentation about BioPerl packages and methods.\n\nThe deob_index.pl script reads through all of the BioPerl files, extracts\nthe documentation, and stores it in two BerkeleyDB databases. This module\nis then used to query those databases for information about a given method\nor package. (see the deob_index.pl documentation for more info.)\n\nThe types of information available for individual methods include: the\nusage statement, the return values, the arguments to give to the method, the\ndescription of the function, and an example of how to use the method.\n\nThe Deobfuscator module can be used also to retrieve the synopsis and\ndescription documentation for a given class.\n\n\n=head1 DIAGNOSTICS\n\n\n* C<< error: couldn't eval $module >>\n\nA package couldn't be loaded (eval'd), which would prevent us from determining\nwhat its methods are.\n\n* C<< error: couldn't open $filename >>\n\nOne of the Berkeley databases couldn't be opened. Possible causes are:\ndeob_index.pl wasn't run and so the databases weren't created, or the database\nfiles aren't in the correct place.\n\n* C<< error: couldn't close database >>\n\nOne of the Berkeley databases couldn't be closed. This might just be a \ntransient filesystem error.\n\n\n\n=head1 CONFIGURATION AND ENVIRONMENT\n\nThis software requires:\n\n\n* A working installation of the Berkeley DB\n\nThe Berkeley DB comes standard with most UNIX distributions, so you may \nalready have it installed. See L<http://www.sleepycat.com> for more information.\n\n* BioPerl\n\nDeobfuscator.pm recursively navigates a directory of BioPerl modules. Note\nthat the BioPerl module directory need not be \"installed\"; any old location\nwill do. See L<http://www.bioperl.org> for the latest version.\n\n\n\n=head1 DEPENDENCIES\n\nL<version>, L<Class::Inspector>, L<DB_File>\n\n\n=head1 INCOMPATIBILITIES\n\nNone reported.\n\n\n=head1 BUGS AND LIMITATIONS\n\nIn the current implementation, Deobfuscator does not show internal or private\nmethods (i.e. those whose name begins with an underscore). This is simply an\noption in the Class::Inspector->methods call, and so could be presented as an\noption to the user (patches welcome).\n\nNo bugs have been reported.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                       - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists   - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org/\n\n\n=head1 SEE ALSO\n\nL<deob_index.pl>\n\n\n=head1 AUTHOR\n\nDave Messina C<< <dave-pause@davemessina.net> >>\n\n\n=head1 CONTRIBUTORS\n\n\n* Laura Kavanaugh\n\n* David Curiel\n\n\n\n=head1 ACKNOWLEDGMENTS\n\nThis software was developed originally at the Cold Spring Harbor Laboratory's\nAdvanced Bioinformatics Course between Oct 12-25, 2005. Many thanks to David\nCuriel, who provided much-needed guidance and assistance on this project.\n\n\n=head1 LICENSE AND COPYRIGHT\n\nCopyright (C) 2005-6 Laura Kavanaugh and Dave Messina. All Rights Reserved.\n\nThis module is free software; you may redistribute it and/or modify it under the\nsame terms as Perl itself. See L<perlartistic>.\n\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the functions.\nInternal methods are preceded with a \"_\".\n\n\n\nuse version; $VERSION = qv('0.0.3');\nuse warnings;\nuse strict;\nuse Class::Inspector;\nuse DB_File;\n\nuse lib './lib';\n\n\n=head2 return_methods\n\nTitle   : return_methods\nUsage   : $methods_hashref = Deobfuscator::return_methods('Bio::AlignIO',\n          'Bio::SeqIO');\nFunction: traverses the inheritance tree for a given class to determine\n          the methods available to objects belonging to that class\n\nReturns : a reference to a hash. The hash keys are fully-qualified class\n          names, such as 'Bio::SeqIO'. The hash values are references to\n          an array of hashes, where each array element is a reference to \n          a hash containing two key-value pairs, 'method' and 'class';\n\nArgs    : a list of fully-qualified class names\n\n\nsub return_methods {\n\n    my @input = @_;\n\n    # key: full class name\n    # value: a reference to an array of hashes\n    #    where each array element is a pointer to a hash\n    #    which contains two key: 'method' and 'class'\n    my %methods_of;\n\n\n    foreach my $class (@input) {\n\n        # fancy eval so that we can loop through different modules\n        _load_module($class);\n\n        # methods returned from Class::Inspector as:\n        # [\n        #   [ 'Class::method1',   'Class',   'method1', \\&Class::method1   ],\n        #   [ 'Another::method2', 'Another', 'method2', \\&Another::method2 ],\n        #   [ 'Foo::bar',         'Foo',     'bar',     \\&Foo::bar         ],\n        # ]\n        my $methods_aryref3\n            = Class::Inspector->methods( $class, 'expanded', 'public' );\n\n\n        for ( my $i = 0; $i < scalar @{$methods_aryref3}; $i++ ) {\n            foreach my $meth ( $methods_aryref3->[$i] ) {\n                my $method_name    = $meth->[2];\n                my $inherited_from = $meth->[1];\n                push @{$methods_of{$class}}, [$method_name, $inherited_from];\n            }\n\n        }\n\n    }\n    return \\%methods_of;\n}\n\n=head2 print_methods\n\nTitle   : print_methods\nUsage   : print_methods('Bio::AlignIO','Bio::SeqIO');\nFunction: traverses the inheritance tree for a given class to determine\n           the methods available to objects belonging to that class, then\n           pretty-prints the resulting information.\nReturns : nothing. But it does print to the current filehandle (usually\n           STDOUT).\nArgs    : a list of fully-qualified class names\n\n\nsub print_methods {\n\n    my @input = @_;\n\n    foreach my $class (@input) {\n\n        # fancy eval so that we can loop through different modules\n        _load_module($class);\n\n        # methods returned as\n        # [\n        #   [ 'Class::method1',   'Class',   'method1', \\&Class::method1   ],\n        #   [ 'Another::method2', 'Another', 'method2', \\&Another::method2 ],\n        #   [ 'Foo::bar',         'Foo',     'bar',     \\&Foo::bar         ],\n        # ]\n        my $methods_aryref3\n            = Class::Inspector->methods( $class, 'expanded', 'public' );\n\n        print \"methods for $class\\n\";\n        print \"=========================================\\n\";\n\n        for ( my $i = 0; $i < scalar @{$methods_aryref3}; $i++ ) {\n            print \"method $i\\n\";\n            foreach my $meth ( $methods_aryref3->[$i] ) {\n                print \"\\t           class: $meth->[1]\\n\";\n                print \"\\t          method: $meth->[2]\\n\";\n            }\n            print \"--------------------------------------\\n\";\n        }\n\n    }\n\n}\n\n=head2 _load_module\n\nTitle   : _load_module\nUsage   : * INTERNAL USE ONLY *\nFunction: attempts to load a module\nReturns : nothing. But it does die upon failure to load.\nArgs    : a module name\n\n\nsub _load_module {\n    my $module = shift;\n    eval \"require $module\";\n    my $err = $@ || 'eval returned undef';\n    \n    if ($@) { return $@ }\n    else { return }\n}\n\n=head2 open_db\n\nTitle   : open_db\nUsage   : open_db($filename)\nFunction: opens a Berkeley DB\nReturns : a hashref tied to the DB\nArgs    : a filename as a scalar\n\n\nsub open_db {\n    my ($filename) = @_;\n    \n    my %hash;\n    my $hashref = \\%hash;\n    \n    tie %hash, \"DB_File\", $filename or die \"error: couldn't open $filename: $!\\n\";\n    \n    return $hashref;\n}\n\n=head2 close_db\n\nTitle   : close_db\nUsage   : closes a Berkeley DB\nFunction: closes a database\nReturns : nothing.\nArgs    : a hashref to a tied Berkeley DB\n\n\nsub close_db {\n    my ($hashref) = @_;\n    \n    untie $hashref or die \"error: couldn't close database: $!\\n\";\n}\n\n=head2 get_pkg_docs\n\nTitle   : get_pkg_docs\nUsage   : get_pkg_docs($db_hashref, 'Class name', 'documentation type');\nFunction: returns a specified part of the documentation for a class\nReturns : a string containing the desired documentation or ' ' if the\n          documentation doesn't exist\nArgs    : - $db_hashref is the ref to the hash tied to the DB\n          - Class name is of the form 'Bio::SeqIO'\n          - documentation type is the subfield of the method's POD.\n          The possible values of documentation type are:\n          short_desc, synopsis, desc\n\n\nsub get_pkg_docs {\n    my ($db_hashref, $pkg_name, $info_type) = @_;\n\n    # hash to store our hash value, now split out into its constituent parts\n    my %record;\n        \n    my $rec_sep = 'DaVe-ReC-sEp';\n\n    # if the method isn't in our db\n    if ( ! exists($db_hashref->{$pkg_name}) ) {\n        return 0;\n    }\n\n    # grab the constituent parts of the pkg record\n    ( $record{'short_desc'}, $record{'synopsis'}, $record{'desc'} ) = \n        ( split $rec_sep, $db_hashref->{$pkg_name} );\n\n    # return just the part that was asked for\n    if ( exists($record{$info_type}) ) {\n        return $record{$info_type};\n    }\n    else { return ' '; }\n}\n\n=head2 get_method_docs\n\nTitle   : get_method_docs\nUsage   : get_method_docs($db_hashref, 'Class+method name', 'documentation type');\nExample : get_method_docs($db_hashref, 'Bio::SeqIO::next_aln', 'args');\nFunction: returns a specified part of the documentation for a class's method\nReturns : a string containing the desired documentation, or 0 if the\n         desired documentation doesn't exist\nArgs    : - $db_hashref is the ref to the hash tied to the DB\n          - Class+method name is of the form 'Bio::SeqIO::next_aln',\n            where Bio::SeqIO is the class and next_aln is the method.\n          - documentation type is the subfield of the method's POD.\n            The possible values of documentation type are:\n            title, usage, function, returns, args\n\n\nsub get_method_docs {\n    my ($db_hashref, $meth_name, $info_type) = @_;\n\n    my %record;\n    my $whole_record;\n\n    my $rec_sep = 'DaVe-ReC-sEp';\n\n    # if the method isn't in our db\n    if ( !exists( $db_hashref->{$meth_name} ) ) {\n        return 0;\n    }\n\n    # separate the sub-records using the record separator and field tag\n    my @parts = split $rec_sep, $db_hashref->{$meth_name};\n\n    # put individual info types into separate hash entries...\n    foreach my $part (@parts) {\n        if ($part =~ /^-(\\w+)\\|(.*)/) { $record{$1} = $2; }\n    \n    # ... and put the whole thing into one big string\n        $whole_record .= \"$part\\n\";\n    }\n\n    # return a specific part if that was asked for\n    if ($info_type) {\n        # return just the part that was asked for      \n        if ( exists( $record{$info_type} ) ) {\n\n\t\t\t# if there's really nothing in there, say so.\n\t\t\tif ( ( $record{$info_type} =~ /^[\\s\\n]*$/)\n         \t|| ( $record{$info_type} eq '') ) { return 0; }\n\t\t\telse { \n\t\t\t\treturn $record{$info_type};\n\t\t\t}\n        }\n        # or return everything\n        else { return $whole_record; }\n    }\n    # otherwise return whole record\n    else {\n        return $whole_record;\n    }\n}\n\n=head2 htmlify\n\nTitle   : htmlify\nUsage   : htmlify($string);\nExample : htmlify('this is a : doc);\nFunction: does some crude reformatting of POD method documentation by swapping\n          isolated colons (':') into HTML <br> tags\nReturns : a string\nArgs    : a string\n\n\nsub htmlify {\n\tmy ($string) = @_;\n\n\t# change isolated colons into <br> tags\n\t$string =~ s/\\s:\\s/ <br> /g;\n\n    # change L<> POD link into HTML link\n    if ( $string =~ /L<(.+)>/ ) {\n        $string = urlify_pkg($1);\n    }\n\n\treturn $string;\n}\n\n=head2 urlify_pkg\n\nTitle   : urlify_pkg\nUsage   : urlify_pkg($string);\nExample : urlify('this is a : doc);\nFunction: wraps a package name in an HTML href pointing to the bioperl.org\n          pdoc docs for that package\nReturns : a string (an href in HTML)\nArgs    : a string","parameters":[{"label":"$pkg_name"}],"label":"urlify_pkg($pkg_name)"},"line":517,"kind":12,"range":{"start":{"character":0,"line":517},"end":{"character":9999,"line":529}},"definition":"sub","detail":"($pkg_name)","children":[{"definition":"my","name":"$pkg_name","localvar":"my","containerName":"urlify_pkg","kind":13,"line":518},{"localvar":"my","containerName":"urlify_pkg","kind":13,"name":"$bioperl_doc_url","line":519,"definition":"my"},{"definition":"my","line":521,"localvar":"my","kind":13,"containerName":"urlify_pkg","name":"$pkg_as_path"},{"kind":13,"containerName":"urlify_pkg","name":"$pkg_name","line":521},{"name":"$pkg_as_path","containerName":"urlify_pkg","kind":13,"line":524},{"name":"$url","containerName":"urlify_pkg","localvar":"my","kind":13,"line":525,"definition":"my"},{"line":525,"name":"$bioperl_doc_url","containerName":"urlify_pkg","kind":13},{"containerName":"urlify_pkg","kind":13,"name":"$pkg_as_path","line":525},{"definition":"my","line":526,"localvar":"my","containerName":"urlify_pkg","kind":13,"name":"$href"},{"line":528,"name":"$href","kind":13,"containerName":"urlify_pkg"}],"name":"urlify_pkg","containerName":"main::"}],"version":5}