{"vars":[{"line":77,"kind":2,"containerName":"","name":"vars"},{"containerName":null,"kind":13,"name":"$DefaultBootstrapStyle","line":84},{"kind":2,"containerName":"strict::Bio::Event","name":"EventGeneratorI","line":84},{"line":85,"kind":2,"containerName":"","name":"base"},{"line":99,"kind":12,"range":{"start":{"line":99,"character":0},"end":{"character":9999,"line":110}},"children":[{"line":100,"name":"$self","containerName":"_initialize","localvar":"my","kind":13,"definition":"my"},{"name":"$self","containerName":"_initialize","kind":13,"line":101},{"name":"$print_count","kind":13,"localvar":"my","containerName":"_initialize","line":102,"definition":"my"},{"line":102,"kind":13,"containerName":"_initialize","name":"$style"},{"line":102,"kind":13,"containerName":"_initialize","name":"$order_by"},{"name":"$self","kind":13,"containerName":"_initialize","line":102},{"containerName":"_initialize","kind":12,"name":"_rearrange","line":102},{"line":106,"kind":13,"containerName":"_initialize","name":"$self"},{"line":106,"containerName":"_initialize","kind":12,"name":"print_tree_count"},{"line":106,"name":"$print_count","containerName":"_initialize","kind":13},{"kind":13,"containerName":"_initialize","name":"$self","line":107},{"containerName":"_initialize","kind":12,"name":"bootstrap_style","line":107},{"name":"$style","containerName":"_initialize","kind":13,"line":107},{"line":107,"name":"$DefaultBootstrapStyle","containerName":"_initialize","kind":13},{"kind":13,"containerName":"_initialize","name":"$self","line":108},{"line":108,"containerName":"_initialize","kind":12,"name":"order_by"},{"name":"$order_by","containerName":"_initialize","kind":13,"line":108},{"name":"$order_by","containerName":"_initialize","kind":13,"line":108}],"containerName":"main::","name":"_initialize","definition":"sub"},{"line":101,"name":"SUPER","containerName":"_initialize","kind":12},{"signature":{"label":"next_tree($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: newick.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::newick\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::newick - TreeIO implementation for parsing \n  Newick/New Hampshire/PHYLIP format.\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::TreeIO;\n  my $treeio = Bio::TreeIO->new(-format => 'newick', \n                               -file => 't/data/LOAD_Ccd1.dnd');\n  my $tree = $treeio->next_tree;\n\n=head1 DESCRIPTION\n\nThis module handles parsing and writing of Newick/PHYLIP/New Hampshire format.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::newick;\nuse vars qw($DefaultBootstrapStyle);\nuse strict;\n\nuse Bio::Event::EventGeneratorI;\n\n#initialize some package variables, could use 'our' but fails in perl < 5.6\n\n$DefaultBootstrapStyle = 'traditional';\nuse base qw(Bio::TreeIO);\n\n\n=head2 new\n\n Title   : new\n Args    : -print_count     => boolean  default is false\n           -bootstrap_style => set the bootstrap style (one of nobranchlength,\n\t\t\t\t\t\t\tmolphy, traditional)\n           -order_by        => set the order by sort method \n                               (see L<Bio::Node::Node::each_Descendent()> )\n\n\nsub _initialize { \n    my $self = shift;\n    $self->SUPER::_initialize(@_);\n    my ($print_count,$style,$order_by) = $self->_rearrange([qw(PRINT_COUNT \n\t\t\t\t\t\t\t       BOOTSTRAP_STYLE\n\t\t\t\t\t\t\t       ORDER_BY)],\n\t\t\t\t\t  @_);\n    $self->print_tree_count($print_count || 0);\n    $self->bootstrap_style($style || $DefaultBootstrapStyle);\n    $self->order_by($order_by) if defined $order_by;\n    return;\n}\n\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $treeio->next_tree\n Function: Gets the next tree in the stream\n Returns : L<Bio::Tree::TreeI>\n Args    : none"},"kind":12,"range":{"end":{"character":9999,"line":244},"start":{"character":0,"line":124}},"line":124,"detail":"($self)","definition":"sub","containerName":"main::","name":"next_tree","children":[{"definition":"my","containerName":"next_tree","localvar":"my","kind":13,"name":"$self","line":125},{"containerName":"next_tree","kind":13,"name":"$self","line":127},{"containerName":"next_tree","kind":12,"name":"_readline","line":127},{"name":"$score","localvar":"my","containerName":"next_tree","kind":13,"line":129,"definition":"my"},{"definition":"my","line":130,"localvar":"my","kind":13,"containerName":"next_tree","name":"$despace"},{"definition":"my","line":130,"kind":13,"localvar":"my","containerName":"next_tree","name":"$dirty"},{"containerName":"next_tree","kind":13,"name":"$dirty","line":130},{"kind":13,"containerName":"next_tree","name":"$dirty","line":130},{"line":131,"kind":13,"localvar":"my","containerName":"next_tree","name":"$dequote","definition":"my"},{"definition":"my","line":131,"localvar":"my","kind":13,"containerName":"next_tree","name":"$dirty"},{"name":"$dirty","containerName":"next_tree","kind":13,"line":131},{"line":131,"name":"$dirty","containerName":"next_tree","kind":13},{"name":"$match","localvar":"my","containerName":"next_tree","kind":13,"line":134,"definition":"my"},{"line":135,"name":"$match","kind":13,"containerName":"next_tree"},{"line":136,"name":"$match","containerName":"next_tree","kind":13},{"line":137,"name":"$match","containerName":"next_tree","kind":13},{"line":138,"name":"$score","kind":13,"containerName":"next_tree"},{"line":142,"name":"$self","containerName":"next_tree","kind":13},{"line":142,"kind":12,"containerName":"next_tree","name":"debug"},{"line":152,"name":"$chars","containerName":"next_tree","localvar":"my","kind":13,"definition":"my"},{"line":153,"name":"$self","kind":13,"containerName":"next_tree"},{"line":153,"containerName":"next_tree","kind":12,"name":"_eventHandler"},{"line":153,"kind":12,"containerName":"next_tree","name":"start_document"},{"line":154,"localvar":"my","containerName":"next_tree","kind":13,"name":"$prev_event","definition":"my"},{"name":"$lastevent","containerName":"next_tree","kind":13,"line":154},{"containerName":"next_tree","kind":13,"name":"$id","line":154},{"definition":"my","kind":13,"localvar":"my","containerName":"next_tree","name":"$ch","line":155},{"line":156,"name":"$ch","kind":13,"containerName":"next_tree"},{"name":"$tree","containerName":"next_tree","localvar":"my","kind":13,"line":157,"definition":"my"},{"name":"$self","kind":13,"containerName":"next_tree","line":157},{"containerName":"next_tree","kind":12,"name":"_eventHandler","line":157},{"line":157,"kind":12,"containerName":"next_tree","name":"end_document"},{"line":157,"kind":13,"containerName":"next_tree","name":"$chars"},{"name":"$tree","kind":13,"containerName":"next_tree","line":158},{"line":158,"name":"score","containerName":"next_tree","kind":12},{"line":158,"name":"$score","containerName":"next_tree","kind":13},{"name":"$score","kind":13,"containerName":"next_tree","line":158},{"line":159,"name":"$self","containerName":"next_tree","kind":13},{"line":159,"name":"internal_node_id","containerName":"next_tree","kind":12},{"name":"$tree","kind":13,"containerName":"next_tree","line":160},{"containerName":"next_tree","kind":12,"name":"move_id_to_bootstrap","line":160},{"containerName":"next_tree","kind":13,"name":"$tree","line":162},{"containerName":"next_tree","kind":13,"name":"$ch","line":163},{"kind":13,"containerName":"next_tree","name":"$chars","line":164},{"line":165,"kind":13,"containerName":"next_tree","name":"$self"},{"kind":12,"containerName":"next_tree","name":"_eventHandler","line":165},{"containerName":"next_tree","kind":12,"name":"start_element","line":165},{"name":"$ch","kind":13,"containerName":"next_tree","line":166},{"line":167,"name":"$chars","kind":13,"containerName":"next_tree"},{"kind":13,"containerName":"next_tree","name":"$lastevent","line":168},{"line":169,"name":"$self","kind":13,"containerName":"next_tree"},{"line":169,"name":"_eventHandler","kind":12,"containerName":"next_tree"},{"line":169,"containerName":"next_tree","kind":12,"name":"start_element"},{"containerName":"next_tree","kind":13,"name":"$self","line":170},{"containerName":"next_tree","kind":12,"name":"_eventHandler","line":170},{"name":"characters","containerName":"next_tree","kind":12,"line":170},{"name":"$chars","containerName":"next_tree","kind":13,"line":170},{"name":"$self","containerName":"next_tree","kind":13,"line":171},{"line":171,"name":"_eventHandler","containerName":"next_tree","kind":12},{"name":"end_element","kind":12,"containerName":"next_tree","line":171},{"containerName":"next_tree","kind":13,"name":"$lastevent","line":172},{"line":172,"name":"$prev_event","kind":13,"containerName":"next_tree"},{"kind":13,"containerName":"next_tree","name":"$self","line":174},{"containerName":"next_tree","kind":12,"name":"debug","line":174},{"line":175,"kind":13,"containerName":"next_tree","name":"$self"},{"name":"_eventHandler","kind":12,"containerName":"next_tree","line":175},{"kind":12,"containerName":"next_tree","name":"start_element","line":175},{"line":176,"name":"$self","kind":13,"containerName":"next_tree"},{"line":176,"name":"_eventHandler","containerName":"next_tree","kind":12},{"line":176,"containerName":"next_tree","kind":12,"name":"start_element"},{"containerName":"next_tree","kind":13,"name":"$self","line":177},{"line":177,"name":"_eventHandler","containerName":"next_tree","kind":12},{"containerName":"next_tree","kind":12,"name":"characters","line":177},{"line":177,"kind":13,"containerName":"next_tree","name":"$chars"},{"line":178,"name":"$self","containerName":"next_tree","kind":13},{"containerName":"next_tree","kind":12,"name":"_eventHandler","line":178},{"line":178,"kind":12,"containerName":"next_tree","name":"end_element"},{"line":179,"name":"$id","containerName":"next_tree","kind":13},{"kind":13,"containerName":"next_tree","name":"$chars","line":179},{"definition":"my","name":"$leafstatus","containerName":"next_tree","localvar":"my","kind":13,"line":181},{"kind":13,"containerName":"next_tree","name":"$lastevent","line":182},{"line":183,"name":"$leafstatus","containerName":"next_tree","kind":13},{"line":186,"kind":13,"containerName":"next_tree","name":"$self"},{"containerName":"next_tree","kind":12,"name":"_eventHandler","line":186},{"containerName":"next_tree","kind":12,"name":"start_element","line":186},{"line":187,"containerName":"next_tree","kind":13,"name":"$self"},{"line":187,"containerName":"next_tree","kind":12,"name":"_eventHandler"},{"kind":12,"containerName":"next_tree","name":"characters","line":187},{"line":187,"name":"$leafstatus","kind":13,"containerName":"next_tree"},{"line":188,"kind":13,"containerName":"next_tree","name":"$self"},{"containerName":"next_tree","kind":12,"name":"_eventHandler","line":188},{"line":188,"name":"end_element","kind":12,"containerName":"next_tree"},{"line":189,"name":"$id","kind":13,"containerName":"next_tree"},{"line":191,"containerName":"next_tree","kind":13,"name":"$self"},{"kind":12,"containerName":"next_tree","name":"_eventHandler","line":191},{"kind":12,"containerName":"next_tree","name":"start_element","line":191},{"line":194,"kind":13,"containerName":"next_tree","name":"$self"},{"containerName":"next_tree","kind":12,"name":"_eventHandler","line":194},{"line":194,"containerName":"next_tree","kind":12,"name":"end_element"},{"line":195,"name":"$self","kind":13,"containerName":"next_tree"},{"line":195,"containerName":"next_tree","kind":12,"name":"_eventHandler"},{"name":"end_element","containerName":"next_tree","kind":12,"line":195},{"kind":13,"containerName":"next_tree","name":"$chars","line":196},{"containerName":"next_tree","kind":13,"name":"$ch","line":197},{"name":"$chars","containerName":"next_tree","kind":13,"line":198},{"containerName":"next_tree","kind":13,"name":"$lastevent","line":199},{"line":200,"kind":13,"containerName":"next_tree","name":"$self"},{"name":"_eventHandler","kind":12,"containerName":"next_tree","line":200},{"line":200,"kind":12,"containerName":"next_tree","name":"start_element"},{"name":"$self","containerName":"next_tree","kind":13,"line":201},{"line":201,"kind":12,"containerName":"next_tree","name":"_eventHandler"},{"name":"characters","kind":12,"containerName":"next_tree","line":201},{"name":"$chars","kind":13,"containerName":"next_tree","line":201},{"line":202,"kind":13,"containerName":"next_tree","name":"$self"},{"name":"_eventHandler","kind":12,"containerName":"next_tree","line":202},{"containerName":"next_tree","kind":12,"name":"end_element","line":202},{"name":"$lastevent","containerName":"next_tree","kind":13,"line":203},{"containerName":"next_tree","kind":13,"name":"$prev_event","line":203},{"line":204,"name":"$chars","containerName":"next_tree","kind":13},{"containerName":"next_tree","kind":13,"name":"$self","line":206},{"containerName":"next_tree","kind":12,"name":"debug","line":206},{"line":207,"name":"$self","containerName":"next_tree","kind":13},{"name":"_eventHandler","kind":12,"containerName":"next_tree","line":207},{"name":"start_element","containerName":"next_tree","kind":12,"line":207},{"kind":13,"containerName":"next_tree","name":"$self","line":208},{"line":208,"name":"_eventHandler","kind":12,"containerName":"next_tree"},{"line":208,"name":"start_element","containerName":"next_tree","kind":12},{"line":209,"kind":13,"containerName":"next_tree","name":"$self"},{"line":209,"kind":12,"containerName":"next_tree","name":"_eventHandler"},{"kind":12,"containerName":"next_tree","name":"characters","line":209},{"line":209,"kind":13,"containerName":"next_tree","name":"$chars"},{"line":210,"name":"$self","containerName":"next_tree","kind":13},{"line":210,"containerName":"next_tree","kind":12,"name":"_eventHandler"},{"line":210,"containerName":"next_tree","kind":12,"name":"end_element"},{"line":211,"containerName":"next_tree","kind":13,"name":"$id"},{"line":211,"name":"$chars","containerName":"next_tree","kind":13},{"line":214,"kind":13,"containerName":"next_tree","name":"$self"},{"line":214,"name":"_eventHandler","containerName":"next_tree","kind":12},{"line":214,"containerName":"next_tree","kind":12,"name":"start_element"},{"definition":"my","line":216,"name":"$leafstatus","localvar":"my","kind":13,"containerName":"next_tree"},{"line":217,"name":"$lastevent","kind":13,"containerName":"next_tree"},{"name":"$leafstatus","containerName":"next_tree","kind":13,"line":218},{"line":220,"kind":13,"containerName":"next_tree","name":"$self"},{"kind":12,"containerName":"next_tree","name":"_eventHandler","line":220},{"line":220,"containerName":"next_tree","kind":12,"name":"start_element"},{"line":221,"kind":13,"containerName":"next_tree","name":"$self"},{"containerName":"next_tree","kind":12,"name":"_eventHandler","line":221},{"name":"characters","containerName":"next_tree","kind":12,"line":221},{"name":"$leafstatus","containerName":"next_tree","kind":13,"line":221},{"containerName":"next_tree","kind":13,"name":"$self","line":222},{"line":222,"name":"_eventHandler","kind":12,"containerName":"next_tree"},{"line":222,"name":"end_element","kind":12,"containerName":"next_tree"},{"line":223,"kind":13,"containerName":"next_tree","name":"$self"},{"containerName":"next_tree","kind":12,"name":"_eventHandler","line":223},{"kind":12,"containerName":"next_tree","name":"end_element","line":223},{"line":224,"kind":13,"containerName":"next_tree","name":"$chars"},{"containerName":"next_tree","kind":13,"name":"$id","line":225},{"line":226,"name":"$ch","kind":13,"containerName":"next_tree"},{"line":227,"kind":13,"containerName":"next_tree","name":"$self"},{"name":"debug","kind":12,"containerName":"next_tree","line":227},{"containerName":"next_tree","kind":13,"name":"$self","line":228},{"line":228,"name":"_eventHandler","containerName":"next_tree","kind":12},{"kind":12,"containerName":"next_tree","name":"start_element","line":228},{"name":"$self","containerName":"next_tree","kind":13,"line":229},{"name":"_eventHandler","containerName":"next_tree","kind":12,"line":229},{"kind":12,"containerName":"next_tree","name":"start_element","line":229},{"name":"$self","containerName":"next_tree","kind":13,"line":230},{"line":230,"containerName":"next_tree","kind":12,"name":"_eventHandler"},{"line":230,"containerName":"next_tree","kind":12,"name":"characters"},{"name":"$chars","kind":13,"containerName":"next_tree","line":230},{"line":231,"name":"$self","kind":13,"containerName":"next_tree"},{"kind":12,"containerName":"next_tree","name":"_eventHandler","line":231},{"line":231,"containerName":"next_tree","kind":12,"name":"end_element"},{"line":232,"name":"$id","kind":13,"containerName":"next_tree"},{"line":232,"kind":13,"containerName":"next_tree","name":"$chars"},{"name":"$chars","kind":13,"containerName":"next_tree","line":233},{"line":235,"name":"$chars","kind":13,"containerName":"next_tree"},{"name":"$ch","kind":13,"containerName":"next_tree","line":235},{"line":238,"name":"$prev_event","containerName":"next_tree","kind":13},{"line":238,"name":"$lastevent","containerName":"next_tree","kind":13},{"line":239,"containerName":"next_tree","kind":13,"name":"$lastevent"},{"line":239,"containerName":"next_tree","kind":13,"name":"$ch"},{"line":241,"localvar":"my","containerName":"next_tree","kind":13,"name":"$tree","definition":"my"},{"containerName":"next_tree","kind":13,"name":"$self","line":241},{"kind":12,"containerName":"next_tree","name":"_eventHandler","line":241},{"containerName":"next_tree","kind":12,"name":"end_document","line":241},{"line":241,"name":"$chars","kind":13,"containerName":"next_tree"},{"line":242,"name":"$tree","kind":13,"containerName":"next_tree"},{"line":242,"name":"$tree","containerName":"next_tree","kind":13}]},{"signature":{"label":"write_tree($self,@trees)","parameters":[{"label":"$self"},{"label":"@trees"}],"documentation":"1;\n# $Id: newick.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::newick\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::newick - TreeIO implementation for parsing \n  Newick/New Hampshire/PHYLIP format.\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::TreeIO;\n  my $treeio = Bio::TreeIO->new(-format => 'newick', \n                               -file => 't/data/LOAD_Ccd1.dnd');\n  my $tree = $treeio->next_tree;\n\n=head1 DESCRIPTION\n\nThis module handles parsing and writing of Newick/PHYLIP/New Hampshire format.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::newick;\nuse vars qw($DefaultBootstrapStyle);\nuse strict;\n\nuse Bio::Event::EventGeneratorI;\n\n#initialize some package variables, could use 'our' but fails in perl < 5.6\n\n$DefaultBootstrapStyle = 'traditional';\nuse base qw(Bio::TreeIO);\n\n\n=head2 new\n\n Title   : new\n Args    : -print_count     => boolean  default is false\n           -bootstrap_style => set the bootstrap style (one of nobranchlength,\n\t\t\t\t\t\t\tmolphy, traditional)\n           -order_by        => set the order by sort method \n                               (see L<Bio::Node::Node::each_Descendent()> )\n\n\nsub _initialize { \n    my $self = shift;\n    $self->SUPER::_initialize(@_);\n    my ($print_count,$style,$order_by) = $self->_rearrange([qw(PRINT_COUNT \n\t\t\t\t\t\t\t       BOOTSTRAP_STYLE\n\t\t\t\t\t\t\t       ORDER_BY)],\n\t\t\t\t\t  @_);\n    $self->print_tree_count($print_count || 0);\n    $self->bootstrap_style($style || $DefaultBootstrapStyle);\n    $self->order_by($order_by) if defined $order_by;\n    return;\n}\n\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $treeio->next_tree\n Function: Gets the next tree in the stream\n Returns : L<Bio::Tree::TreeI>\n Args    : none\n\n\n\nsub next_tree{\n   my ($self) = @_;\n   local $/ = \";\\n\";\n   return unless $_ = $self->_readline;\n   s/[\\r\\n]//gs;\n   my $score;\n   my $despace = sub {my $dirty = shift; $dirty =~ s/\\s+//gs; return $dirty};\n   my $dequote = sub {my $dirty = shift; $dirty =~ s/^\"?\\s*(.+?)\\s*\"?$/$1/; return $dirty};\n   s/([^\"]*)(\".+?\")([^\"]*)/$despace->($1) . $dequote->($2) . $despace->($3)/egsx;\n   if( s/^\\s*\\[([^\\]]+)\\]// ) {\n       my $match = $1;\n       $match =~ s/\\s//g;\n       $match =~ s/lh\\=//;\n       if( $match =~ /([-\\d\\.+]+)/ ) {\n\t   $score = $1;\n       }\n   }\n\n   $self->debug(\"entry is $_\\n\");\n#   my $empty = chr(20);\n \n   # replace empty labels with a tag\n#   s/\\(,/\\($empty,/ig;\n#   s/,,/,$empty,/ig;\n#   s/,,/,/ig;\n#   s/,\\)/,$empty\\)/ig;\n#   s/\\\"/\\'/ig;\n\n   my $chars = '';\n   $self->_eventHandler->start_document;\n   my ($prev_event,$lastevent,$id) = ('','','');\n   foreach my $ch ( split(//,$_) ) {\n       if( $ch eq ';' ) {\n\t   my $tree = $self->_eventHandler->end_document($chars);\n\t   $tree->score($score) if defined $score;\n\t   if( $self->internal_node_id eq 'bootstrap' ) {\n\t       $tree->move_id_to_bootstrap;\n\t   }\n\t   return $tree;\n       } elsif( $ch eq '(' ) {\n\t   $chars = '';\n\t   $self->_eventHandler->start_element( {'Name' => 'tree'} );\n       } elsif($ch eq ')' ) {\n\t   if( length($chars) ) {\n\t       if( $lastevent eq ':' ) {\n\t\t   $self->_eventHandler->start_element( { 'Name' => 'branch_length'});\n\t\t   $self->_eventHandler->characters($chars);\n\t\t   $self->_eventHandler->end_element( {'Name' => 'branch_length'});\n\t\t   $lastevent = $prev_event;\n\t       } else { \n\t\t   $self->debug(\"internal node, id with no branchlength is $chars\\n\");\n\t\t   $self->_eventHandler->start_element( { 'Name' => 'node' } );\n\t\t   $self->_eventHandler->start_element( { 'Name' => 'id' } );\n\t\t   $self->_eventHandler->characters($chars);\n\t\t   $self->_eventHandler->end_element( { 'Name' => 'id' } );\n\t\t   $id = $chars;\n\t       }\n\t       my $leafstatus = 0;\n\t       if( $lastevent ne ')' ) {\n\t\t   $leafstatus = 1;\n\t       }\n\n\t       $self->_eventHandler->start_element({'Name' => 'leaf'});\n\t       $self->_eventHandler->characters($leafstatus);\n\t       $self->_eventHandler->end_element({'Name' => 'leaf'});\n\t       $id = '';\n\t   } else {\n\t       $self->_eventHandler->start_element( {'Name' => 'node'} );\n\t   }\n\n \t   $self->_eventHandler->end_element( {'Name' => 'node'} );\n\t   $self->_eventHandler->end_element( {'Name' => 'tree'} );\n\t   $chars = '';\n       } elsif ( $ch eq ',' ) {\n\t   if( length($chars) ) {\n\t       if( $lastevent eq ':' ) {\n\t\t   $self->_eventHandler->start_element( { 'Name' => 'branch_length'});\n\t\t   $self->_eventHandler->characters($chars);\n\t\t   $self->_eventHandler->end_element( {'Name' => 'branch_length'});\n\t\t   $lastevent = $prev_event;\n\t\t   $chars = '';\t\t   \n\t       } else { \n\t\t   $self->debug(\"leaf id with no branchlength is $chars\\n\");\n\t\t   $self->_eventHandler->start_element( { 'Name' => 'node' } );\n\t\t   $self->_eventHandler->start_element( { 'Name' => 'id' } );\n\t\t   $self->_eventHandler->characters($chars);\n\t\t   $self->_eventHandler->end_element( { 'Name' => 'id' } );\n\t\t   $id = $chars;\n\t       }\n\t   } else {\n\t       $self->_eventHandler->start_element( { 'Name' => 'node' } );\n\t   }\n\t   my $leafstatus = 0;\n\t   if( $lastevent ne ')' ) {\n\t       $leafstatus = 1;\n\t   }\n\t   $self->_eventHandler->start_element({'Name' => 'leaf'});\n\t   $self->_eventHandler->characters($leafstatus);\n\t   $self->_eventHandler->end_element({'Name' => 'leaf'});\n\t   $self->_eventHandler->end_element( {'Name' => 'node'} );\n\t   $chars = '';\n\t   $id    = '';\n       } elsif( $ch eq ':' ) {\n\t   $self->debug(\"id with a branchlength coming is $chars\\n\");\n\t   $self->_eventHandler->start_element( { 'Name' => 'node' } );\n\t   $self->_eventHandler->start_element( { 'Name' => 'id' } );\t   \n\t   $self->_eventHandler->characters($chars);\n\t   $self->_eventHandler->end_element( { 'Name' => 'id' } );\t   \n\t   $id = $chars;\n\t   $chars = '';\n       } else { \t   \n\t   $chars .= $ch;\n\t   next;\n       }\n       $prev_event = $lastevent;\n       $lastevent = $ch;\n   }\n   my $tree = $self->_eventHandler->end_document($chars);\n   return $tree if $tree;\n   return;\n}\n\n=head2 write_tree\n\n Title   : write_tree\n Usage   : $treeio->write_tree($tree);\n Function: Write a tree out to data stream in newick/phylip format\n Returns : none\n Args    : L<Bio::Tree::TreeI> object"},"line":256,"kind":12,"range":{"end":{"line":283,"character":9999},"start":{"character":0,"line":256}},"definition":"sub","detail":"($self,@trees)","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"write_tree","line":257,"definition":"my"},{"line":257,"containerName":"write_tree","kind":13,"name":"@trees"},{"name":"$orderby","localvar":"my","kind":13,"containerName":"write_tree","line":258,"definition":"my"},{"line":258,"containerName":"write_tree","kind":13,"name":"$self"},{"name":"order_by","kind":12,"containerName":"write_tree","line":258},{"definition":"my","line":259,"name":"$bootstrap_style","containerName":"write_tree","localvar":"my","kind":13},{"line":259,"containerName":"write_tree","kind":13,"name":"$self"},{"name":"bootstrap_style","kind":12,"containerName":"write_tree","line":259},{"name":"$self","kind":13,"containerName":"write_tree","line":260},{"name":"print_tree_count","containerName":"write_tree","kind":12,"line":260},{"line":261,"kind":13,"containerName":"write_tree","name":"$self"},{"name":"_print","containerName":"write_tree","kind":12,"line":261},{"line":261,"name":"@trees","containerName":"write_tree","kind":13},{"line":263,"name":"$nl","localvar":"my","containerName":"write_tree","kind":13,"definition":"my"},{"line":263,"kind":13,"containerName":"write_tree","name":"$self"},{"line":263,"kind":12,"containerName":"write_tree","name":"newline_each_node"},{"definition":"my","name":"$tree","localvar":"my","kind":13,"containerName":"write_tree","line":264},{"line":264,"kind":13,"containerName":"write_tree","name":"@trees"},{"line":266,"name":"$tree","kind":13,"containerName":"write_tree"},{"name":"$tree","containerName":"write_tree","kind":13,"line":266},{"line":267,"name":"$tree","kind":13,"containerName":"write_tree"},{"name":"isa","kind":12,"containerName":"write_tree","line":267},{"name":"$self","kind":13,"containerName":"write_tree","line":268},{"containerName":"write_tree","kind":12,"name":"throw","line":268},{"line":270,"name":"@data","containerName":"write_tree","localvar":"my","kind":13,"definition":"my"},{"name":"$tree","kind":13,"containerName":"write_tree","line":270},{"line":270,"containerName":"write_tree","kind":12,"name":"get_root_node"},{"containerName":"write_tree","kind":13,"name":"$bootstrap_style","line":271},{"line":272,"kind":13,"containerName":"write_tree","name":"$orderby"},{"name":"$nl","containerName":"write_tree","kind":13,"line":273},{"name":"$nl","containerName":"write_tree","kind":13,"line":274},{"line":275,"kind":13,"containerName":"write_tree","name":"$data"},{"line":276,"name":"$self","containerName":"write_tree","kind":13},{"name":"_print","containerName":"write_tree","kind":12,"line":276},{"line":276,"name":"@data","containerName":"write_tree","kind":13},{"line":278,"kind":13,"containerName":"write_tree","name":"$self"},{"containerName":"write_tree","kind":12,"name":"_print","line":278},{"line":278,"name":"@data","kind":13,"containerName":"write_tree"},{"line":281,"name":"$self","kind":13,"containerName":"write_tree"},{"line":281,"name":"flush","containerName":"write_tree","kind":12},{"line":281,"name":"$self","kind":13,"containerName":"write_tree"},{"line":281,"name":"_flush_on_write","kind":12,"containerName":"write_tree"},{"name":"$self","kind":13,"containerName":"write_tree","line":281},{"kind":12,"containerName":"write_tree","name":"_fh","line":281}],"name":"write_tree","containerName":"main::"},{"kind":12,"name":"_write_tree_Helper","line":270},{"definition":"sub","detail":"($node,$style,$orderby,$nl)","children":[{"line":286,"localvar":"my","containerName":"_write_tree_Helper","kind":13,"name":"$node","definition":"my"},{"name":"$style","kind":13,"containerName":"_write_tree_Helper","line":286},{"line":286,"name":"$orderby","containerName":"_write_tree_Helper","kind":13},{"line":286,"name":"$nl","containerName":"_write_tree_Helper","kind":13},{"name":"$style","kind":13,"containerName":"_write_tree_Helper","line":287},{"kind":13,"containerName":"_write_tree_Helper","name":"$style","line":287},{"line":288,"kind":13,"containerName":"_write_tree_Helper","name":"$node"},{"definition":"my","localvar":"my","kind":13,"containerName":"_write_tree_Helper","name":"@data","line":290},{"containerName":"_write_tree_Helper","localvar":"my","kind":13,"name":"$n","line":291,"definition":"my"},{"line":291,"containerName":"_write_tree_Helper","kind":13,"name":"$node"},{"line":291,"name":"each_Descendent","containerName":"_write_tree_Helper","kind":12},{"kind":13,"containerName":"_write_tree_Helper","name":"$orderby","line":291},{"name":"@data","containerName":"_write_tree_Helper","kind":13,"line":292},{"kind":13,"containerName":"_write_tree_Helper","name":"$n","line":292},{"containerName":"_write_tree_Helper","kind":13,"name":"$style","line":292},{"line":292,"kind":13,"containerName":"_write_tree_Helper","name":"$orderby"},{"line":292,"kind":13,"containerName":"_write_tree_Helper","name":"$nl"},{"line":296,"containerName":"_write_tree_Helper","localvar":"my","kind":13,"name":"$id","definition":"my"},{"line":296,"name":"$node","containerName":"_write_tree_Helper","kind":13},{"containerName":"_write_tree_Helper","kind":12,"name":"id_output","line":296},{"line":297,"name":"$bs","localvar":"my","containerName":"_write_tree_Helper","kind":13,"definition":"my"},{"kind":13,"containerName":"_write_tree_Helper","name":"$node","line":297},{"line":297,"name":"bootstrap","kind":12,"containerName":"_write_tree_Helper"},{"kind":13,"containerName":"_write_tree_Helper","name":"$bs","line":298},{"name":"$bs","containerName":"_write_tree_Helper","kind":13,"line":298},{"definition":"my","line":299,"kind":13,"localvar":"my","containerName":"_write_tree_Helper","name":"$bl"},{"kind":13,"containerName":"_write_tree_Helper","name":"$node","line":299},{"containerName":"_write_tree_Helper","kind":12,"name":"branch_length","line":299},{"name":"@data","kind":13,"containerName":"_write_tree_Helper","line":300},{"kind":13,"containerName":"_write_tree_Helper","name":"$nl","line":301},{"containerName":"_write_tree_Helper","kind":13,"name":"$data","line":302},{"line":302,"name":"$data","containerName":"_write_tree_Helper","kind":13},{"name":"$data","containerName":"_write_tree_Helper","kind":13,"line":303},{"containerName":"_write_tree_Helper","kind":13,"name":"$data","line":305},{"name":"$data","containerName":"_write_tree_Helper","kind":13,"line":305},{"line":306,"name":"$data","kind":13,"containerName":"_write_tree_Helper"},{"line":309,"kind":13,"containerName":"_write_tree_Helper","name":"$node"},{"containerName":"_write_tree_Helper","kind":12,"name":"is_Leaf","line":309},{"line":310,"name":"$node","containerName":"_write_tree_Helper","kind":13},{"line":310,"name":"debug","containerName":"_write_tree_Helper","kind":12},{"name":"$id","kind":13,"containerName":"_write_tree_Helper","line":312},{"line":313,"name":"$bl","kind":13,"containerName":"_write_tree_Helper"},{"name":"$bl","containerName":"_write_tree_Helper","kind":13,"line":313},{"kind":13,"containerName":"_write_tree_Helper","name":"$style","line":314},{"line":314,"kind":13,"containerName":"_write_tree_Helper","name":"$style"},{"line":315,"containerName":"_write_tree_Helper","kind":13,"name":"$data"},{"line":315,"name":"$id","containerName":"_write_tree_Helper","kind":13},{"line":316,"name":"$bl","containerName":"_write_tree_Helper","kind":13},{"kind":13,"containerName":"_write_tree_Helper","name":"$bl","line":316},{"line":317,"name":"$data","kind":13,"containerName":"_write_tree_Helper"},{"line":319,"name":"$data","containerName":"_write_tree_Helper","kind":13},{"name":"$id","containerName":"_write_tree_Helper","kind":13,"line":319},{"line":322,"kind":13,"containerName":"_write_tree_Helper","name":"$bl"},{"name":"$bl","containerName":"_write_tree_Helper","kind":13,"line":322},{"line":323,"containerName":"_write_tree_Helper","kind":13,"name":"$style"},{"containerName":"_write_tree_Helper","kind":13,"name":"$style","line":323},{"line":325,"containerName":"_write_tree_Helper","kind":13,"name":"$id"},{"line":325,"name":"$bs","containerName":"_write_tree_Helper","kind":13},{"containerName":"_write_tree_Helper","kind":13,"name":"$data","line":326},{"kind":13,"containerName":"_write_tree_Helper","name":"$bs","line":326},{"line":326,"containerName":"_write_tree_Helper","kind":13,"name":"$bs"},{"line":326,"name":"$id","containerName":"_write_tree_Helper","kind":13},{"name":"$style","containerName":"_write_tree_Helper","kind":13,"line":328},{"line":329,"kind":13,"containerName":"_write_tree_Helper","name":"$id"},{"name":"$data","kind":13,"containerName":"_write_tree_Helper","line":330},{"name":"$id","kind":13,"containerName":"_write_tree_Helper","line":330},{"line":332,"kind":13,"containerName":"_write_tree_Helper","name":"$bl"},{"containerName":"_write_tree_Helper","kind":13,"name":"$data","line":333},{"line":333,"containerName":"_write_tree_Helper","kind":13,"name":"$bl"},{"line":335,"kind":13,"containerName":"_write_tree_Helper","name":"$data"},{"containerName":"_write_tree_Helper","kind":13,"name":"$bs","line":337},{"containerName":"_write_tree_Helper","kind":13,"name":"$data","line":338},{"name":"$bs","kind":13,"containerName":"_write_tree_Helper","line":344},{"line":344,"containerName":"_write_tree_Helper","kind":13,"name":"$id"},{"kind":13,"containerName":"_write_tree_Helper","name":"$data","line":345},{"containerName":"_write_tree_Helper","kind":13,"name":"$bs","line":345},{"kind":13,"containerName":"_write_tree_Helper","name":"$bl","line":346},{"line":347,"kind":13,"containerName":"_write_tree_Helper","name":"$data"},{"containerName":"_write_tree_Helper","kind":13,"name":"$bl","line":347},{"line":349,"kind":13,"containerName":"_write_tree_Helper","name":"$data"},{"line":353,"containerName":"_write_tree_Helper","kind":13,"name":"$id"},{"line":353,"name":"$bl","containerName":"_write_tree_Helper","kind":13},{"localvar":"my","containerName":"_write_tree_Helper","kind":13,"name":"$str","line":354,"definition":"my"},{"name":"$id","kind":13,"containerName":"_write_tree_Helper","line":355},{"line":356,"name":"$bl","kind":13,"containerName":"_write_tree_Helper"},{"line":356,"name":"$bl","kind":13,"containerName":"_write_tree_Helper"},{"name":"$style","containerName":"_write_tree_Helper","kind":13,"line":357},{"line":357,"name":"$style","kind":13,"containerName":"_write_tree_Helper"},{"name":"$str","kind":13,"containerName":"_write_tree_Helper","line":358},{"line":358,"name":"$id","kind":13,"containerName":"_write_tree_Helper"},{"line":359,"name":"$bl","containerName":"_write_tree_Helper","kind":13},{"kind":13,"containerName":"_write_tree_Helper","name":"$bl","line":359},{"kind":13,"containerName":"_write_tree_Helper","name":"$str","line":360},{"line":362,"containerName":"_write_tree_Helper","kind":13,"name":"$str"},{"name":"$id","containerName":"_write_tree_Helper","kind":13,"line":362},{"line":364,"name":"@data","containerName":"_write_tree_Helper","kind":13},{"name":"$str","containerName":"_write_tree_Helper","kind":13,"line":364},{"line":366,"containerName":"_write_tree_Helper","kind":13,"name":"@data"}],"containerName":"main::","name":"_write_tree_Helper","signature":{"label":"_write_tree_Helper($node,$style,$orderby,$nl)","parameters":[{"label":"$node"},{"label":"$style"},{"label":"$orderby"},{"label":"$nl"}],"documentation":""},"line":285,"kind":12,"range":{"end":{"line":367,"character":9999},"start":{"character":0,"line":285}}},{"kind":12,"range":{"start":{"character":0,"line":380},"end":{"line":384,"character":9999}},"line":380,"definition":"sub","name":"print_tree_count","containerName":"main::","children":[{"localvar":"my","containerName":"print_tree_count","kind":13,"name":"$self","line":381,"definition":"my"},{"containerName":"print_tree_count","kind":13,"name":"$self","line":382},{"line":383,"name":"$self","kind":13,"containerName":"print_tree_count"}]},{"line":413,"kind":12,"range":{"end":{"character":9999,"line":425},"start":{"character":0,"line":413}},"definition":"sub","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"bootstrap_style","kind":13,"line":414},{"name":"$val","kind":13,"localvar":"my","containerName":"bootstrap_style","line":415,"definition":"my"},{"line":416,"name":"$val","containerName":"bootstrap_style","kind":13},{"line":418,"containerName":"bootstrap_style","kind":13,"name":"$val"},{"line":419,"name":"$self","kind":13,"containerName":"bootstrap_style"},{"name":"warn","containerName":"bootstrap_style","kind":12,"line":419},{"containerName":"bootstrap_style","kind":13,"name":"$self","line":421},{"line":421,"name":"$val","containerName":"bootstrap_style","kind":13},{"line":424,"containerName":"bootstrap_style","kind":13,"name":"$self"},{"name":"$DefaultBootstrapStyle","containerName":"bootstrap_style","kind":13,"line":424}],"name":"bootstrap_style","containerName":"main::"},{"range":{"start":{"character":0,"line":439},"end":{"character":9999,"line":444}},"kind":12,"line":439,"definition":"sub","name":"order_by","containerName":"main::","children":[{"definition":"my","line":440,"kind":13,"localvar":"my","containerName":"order_by","name":"$self"},{"name":"$self","kind":13,"containerName":"order_by","line":442},{"name":"$self","kind":13,"containerName":"order_by","line":443}]}],"version":5}