{"vars":[{"line":124,"kind":12,"name":"warnings"},{"line":126,"name":"base","containerName":"","kind":2},{"signature":{"label":"add_Descendent($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: NodeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeI - Interface describing a Tree Node\n\n=head1 SYNOPSIS\n\n    # get a Tree::NodeI somehow\n    # like from a TreeIO\n    use Bio::TreeIO;\n    # read in a clustalw NJ in phylip/newick format\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'file.dnd');\n\n    my $tree = $treeio->next_tree; # we'll assume it worked for demo purposes\n                                   # you might want to test that it was defined\n\n    my $rootnode = $tree->get_root_node;\n\n    # process just the next generation\n    foreach my $node ( $rootnode->each_Descendent() ) {\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # process all the children\n    my $example_leaf_node;\n    foreach my $node ( $rootnode->get_all_Descendents() ) {\n\tif( $node->is_Leaf ) { \n\t    print \"node is a leaf ... \"; \n            # for example use below\n            $example_leaf_node = $node unless defined $example_leaf_node; \n\t}\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # The ancestor() method points to the parent of a node\n    # A node can only have one parent\n\n    my $parent = $example_leaf_node->ancestor;\n\n    # parent won't likely have an description because it is an internal node\n    # but child will because it is a leaf\n\n    print \"Parent id: \", $parent->id,\" child id: \", \n          $example_leaf_node->id, \"\\n\";\n\n\n=head1 DESCRIPTION\n\nA NodeI is capable of the basic structure of building a tree and\nstoring the branch length between nodes.  The branch length is the\nlength of the branch between the node and its ancestor, thus a root\nnode in a Tree will not typically have a valid branch length.\n\nVarious implementations of NodeI may extend the basic functions and\nallow storing of other information (like attatching a species object\nor full sequences used to build a tree or alternative sequences).  If\nyou don't know how to extend a Bioperl object please ask, happy to\nhelp, we would also greatly appreciate contributions with improvements\nor extensions of the objects back to the Bioperl code base so that\nothers don't have to reinvent your ideas.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeI;\nuse strict;\nno warnings 'recursion';\n\nuse base qw(Bio::Root::RootI);\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $node->add_Descendent($node);\n Function: Adds a descendent to a node\n Returns : number of current descendents for this node\n Args    : Bio::Node::NodeI"},"line":139,"range":{"end":{"character":9999,"line":143},"start":{"line":139,"character":0}},"kind":12,"definition":"sub","detail":"($self,@args)","children":[{"line":140,"name":"$self","containerName":"add_Descendent","localvar":"my","kind":13,"definition":"my"},{"containerName":"add_Descendent","kind":13,"name":"@args","line":140},{"line":142,"kind":13,"containerName":"add_Descendent","name":"$self"},{"containerName":"add_Descendent","kind":12,"name":"throw_not_implemented","line":142}],"name":"add_Descendent","containerName":"main::"},{"signature":{"label":"each_Descendent($self)","documentation":"1;\n# $Id: NodeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeI - Interface describing a Tree Node\n\n=head1 SYNOPSIS\n\n    # get a Tree::NodeI somehow\n    # like from a TreeIO\n    use Bio::TreeIO;\n    # read in a clustalw NJ in phylip/newick format\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'file.dnd');\n\n    my $tree = $treeio->next_tree; # we'll assume it worked for demo purposes\n                                   # you might want to test that it was defined\n\n    my $rootnode = $tree->get_root_node;\n\n    # process just the next generation\n    foreach my $node ( $rootnode->each_Descendent() ) {\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # process all the children\n    my $example_leaf_node;\n    foreach my $node ( $rootnode->get_all_Descendents() ) {\n\tif( $node->is_Leaf ) { \n\t    print \"node is a leaf ... \"; \n            # for example use below\n            $example_leaf_node = $node unless defined $example_leaf_node; \n\t}\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # The ancestor() method points to the parent of a node\n    # A node can only have one parent\n\n    my $parent = $example_leaf_node->ancestor;\n\n    # parent won't likely have an description because it is an internal node\n    # but child will because it is a leaf\n\n    print \"Parent id: \", $parent->id,\" child id: \", \n          $example_leaf_node->id, \"\\n\";\n\n\n=head1 DESCRIPTION\n\nA NodeI is capable of the basic structure of building a tree and\nstoring the branch length between nodes.  The branch length is the\nlength of the branch between the node and its ancestor, thus a root\nnode in a Tree will not typically have a valid branch length.\n\nVarious implementations of NodeI may extend the basic functions and\nallow storing of other information (like attatching a species object\nor full sequences used to build a tree or alternative sequences).  If\nyou don't know how to extend a Bioperl object please ask, happy to\nhelp, we would also greatly appreciate contributions with improvements\nor extensions of the objects back to the Bioperl code base so that\nothers don't have to reinvent your ideas.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeI;\nuse strict;\nno warnings 'recursion';\n\nuse base qw(Bio::Root::RootI);\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $node->add_Descendent($node);\n Function: Adds a descendent to a node\n Returns : number of current descendents for this node\n Args    : Bio::Node::NodeI\n\n\n\nsub add_Descendent{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n\n=head2 each_Descendent\n\n Title   : each_Descendent\n Usage   : my @nodes = $node->each_Descendent;\n Function: all the descendents for this Node (but not their descendents \n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Tree::NodeI objects\n Args    : none","parameters":[{"label":"$self"}]},"kind":12,"range":{"start":{"character":0,"line":157},"end":{"line":160,"character":9999}},"line":157,"detail":"($self)","definition":"sub","name":"each_Descendent","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"each_Descendent","name":"$self","line":158},{"line":159,"kind":13,"containerName":"each_Descendent","name":"$self"},{"containerName":"each_Descendent","kind":12,"name":"throw_not_implemented","line":159}]},{"signature":{"parameters":[{"label":"$self"},{"label":"$sortby"}],"documentation":"1;\n# $Id: NodeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeI - Interface describing a Tree Node\n\n=head1 SYNOPSIS\n\n    # get a Tree::NodeI somehow\n    # like from a TreeIO\n    use Bio::TreeIO;\n    # read in a clustalw NJ in phylip/newick format\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'file.dnd');\n\n    my $tree = $treeio->next_tree; # we'll assume it worked for demo purposes\n                                   # you might want to test that it was defined\n\n    my $rootnode = $tree->get_root_node;\n\n    # process just the next generation\n    foreach my $node ( $rootnode->each_Descendent() ) {\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # process all the children\n    my $example_leaf_node;\n    foreach my $node ( $rootnode->get_all_Descendents() ) {\n\tif( $node->is_Leaf ) { \n\t    print \"node is a leaf ... \"; \n            # for example use below\n            $example_leaf_node = $node unless defined $example_leaf_node; \n\t}\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # The ancestor() method points to the parent of a node\n    # A node can only have one parent\n\n    my $parent = $example_leaf_node->ancestor;\n\n    # parent won't likely have an description because it is an internal node\n    # but child will because it is a leaf\n\n    print \"Parent id: \", $parent->id,\" child id: \", \n          $example_leaf_node->id, \"\\n\";\n\n\n=head1 DESCRIPTION\n\nA NodeI is capable of the basic structure of building a tree and\nstoring the branch length between nodes.  The branch length is the\nlength of the branch between the node and its ancestor, thus a root\nnode in a Tree will not typically have a valid branch length.\n\nVarious implementations of NodeI may extend the basic functions and\nallow storing of other information (like attatching a species object\nor full sequences used to build a tree or alternative sequences).  If\nyou don't know how to extend a Bioperl object please ask, happy to\nhelp, we would also greatly appreciate contributions with improvements\nor extensions of the objects back to the Bioperl code base so that\nothers don't have to reinvent your ideas.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeI;\nuse strict;\nno warnings 'recursion';\n\nuse base qw(Bio::Root::RootI);\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $node->add_Descendent($node);\n Function: Adds a descendent to a node\n Returns : number of current descendents for this node\n Args    : Bio::Node::NodeI\n\n\n\nsub add_Descendent{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n\n=head2 each_Descendent\n\n Title   : each_Descendent\n Usage   : my @nodes = $node->each_Descendent;\n Function: all the descendents for this Node (but not their descendents \n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Tree::NodeI objects\n Args    : none\n\n\nsub each_Descendent{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 Decorated Interface methods\n\n\n=head2 get_all_Descendents\n\n Title   : get_all_Descendents($sortby)\n Usage   : my @nodes = $node->get_all_Descendents;\n Function: Recursively fetch all the nodes and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Tree::NodeI objects\n Args    : $sortby [optional] \"height\", \"creation\", \"alpha\", \"revalpha\", \n           or a coderef to be used to sort the order of children nodes.","label":"get_all_Descendents($self,$sortby)"},"range":{"end":{"character":9999,"line":186},"start":{"line":178,"character":0}},"kind":12,"line":178,"detail":"($self,$sortby)","definition":"sub","name":"get_all_Descendents","containerName":"main::","children":[{"definition":"my","containerName":"get_all_Descendents","localvar":"my","kind":13,"name":"$self","line":179},{"name":"$sortby","containerName":"get_all_Descendents","kind":13,"line":179},{"line":180,"kind":13,"containerName":"get_all_Descendents","name":"$sortby"},{"containerName":"get_all_Descendents","localvar":"my","kind":13,"name":"@nodes","line":181,"definition":"my"},{"definition":"my","line":182,"name":"$node","containerName":"get_all_Descendents","localvar":"my","kind":13},{"line":182,"kind":13,"containerName":"get_all_Descendents","name":"$self"},{"name":"each_Descendent","containerName":"get_all_Descendents","kind":12,"line":182},{"kind":13,"containerName":"get_all_Descendents","name":"$sortby","line":182},{"name":"@nodes","kind":13,"containerName":"get_all_Descendents","line":183},{"line":183,"name":"$node","kind":13,"containerName":"get_all_Descendents"},{"line":183,"containerName":"get_all_Descendents","kind":13,"name":"$node"},{"name":"get_all_Descendents","kind":12,"containerName":"get_all_Descendents","line":183},{"name":"$sortby","containerName":"get_all_Descendents","kind":13,"line":183},{"line":185,"name":"@nodes","kind":13,"containerName":"get_all_Descendents"}]},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: NodeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeI - Interface describing a Tree Node\n\n=head1 SYNOPSIS\n\n    # get a Tree::NodeI somehow\n    # like from a TreeIO\n    use Bio::TreeIO;\n    # read in a clustalw NJ in phylip/newick format\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'file.dnd');\n\n    my $tree = $treeio->next_tree; # we'll assume it worked for demo purposes\n                                   # you might want to test that it was defined\n\n    my $rootnode = $tree->get_root_node;\n\n    # process just the next generation\n    foreach my $node ( $rootnode->each_Descendent() ) {\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # process all the children\n    my $example_leaf_node;\n    foreach my $node ( $rootnode->get_all_Descendents() ) {\n\tif( $node->is_Leaf ) { \n\t    print \"node is a leaf ... \"; \n            # for example use below\n            $example_leaf_node = $node unless defined $example_leaf_node; \n\t}\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # The ancestor() method points to the parent of a node\n    # A node can only have one parent\n\n    my $parent = $example_leaf_node->ancestor;\n\n    # parent won't likely have an description because it is an internal node\n    # but child will because it is a leaf\n\n    print \"Parent id: \", $parent->id,\" child id: \", \n          $example_leaf_node->id, \"\\n\";\n\n\n=head1 DESCRIPTION\n\nA NodeI is capable of the basic structure of building a tree and\nstoring the branch length between nodes.  The branch length is the\nlength of the branch between the node and its ancestor, thus a root\nnode in a Tree will not typically have a valid branch length.\n\nVarious implementations of NodeI may extend the basic functions and\nallow storing of other information (like attatching a species object\nor full sequences used to build a tree or alternative sequences).  If\nyou don't know how to extend a Bioperl object please ask, happy to\nhelp, we would also greatly appreciate contributions with improvements\nor extensions of the objects back to the Bioperl code base so that\nothers don't have to reinvent your ideas.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeI;\nuse strict;\nno warnings 'recursion';\n\nuse base qw(Bio::Root::RootI);\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $node->add_Descendent($node);\n Function: Adds a descendent to a node\n Returns : number of current descendents for this node\n Args    : Bio::Node::NodeI\n\n\n\nsub add_Descendent{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n\n=head2 each_Descendent\n\n Title   : each_Descendent\n Usage   : my @nodes = $node->each_Descendent;\n Function: all the descendents for this Node (but not their descendents \n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Tree::NodeI objects\n Args    : none\n\n\nsub each_Descendent{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 Decorated Interface methods\n\n\n=head2 get_all_Descendents\n\n Title   : get_all_Descendents($sortby)\n Usage   : my @nodes = $node->get_all_Descendents;\n Function: Recursively fetch all the nodes and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Tree::NodeI objects\n Args    : $sortby [optional] \"height\", \"creation\", \"alpha\", \"revalpha\", \n           or a coderef to be used to sort the order of children nodes.\n\n\nsub get_all_Descendents{\n   my ($self, $sortby) = @_;\n   $sortby ||= 'none';   \n   my @nodes;\n   foreach my $node ( $self->each_Descendent($sortby) ) {\n       push @nodes, ($node,$node->get_all_Descendents($sortby));\n   }\n   return @nodes;\n}\n\n*get_Descendents = \\&get_all_Descendents;\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf ) \n Function: Get Leaf status\n Returns : boolean\n Args    : none","label":"is_Leaf($self)"},"kind":12,"range":{"start":{"line":200,"character":0},"end":{"character":9999,"line":203}},"line":200,"detail":"($self)","definition":"sub","containerName":"main::","name":"is_Leaf","children":[{"definition":"my","containerName":"is_Leaf","localvar":"my","kind":13,"name":"$self","line":201},{"line":202,"kind":13,"containerName":"is_Leaf","name":"$self"},{"line":202,"name":"throw_not_implemented","kind":12,"containerName":"is_Leaf"}]},{"kind":12,"range":{"start":{"line":216,"character":0},"end":{"line":225,"character":9999}},"line":216,"signature":{"documentation":"1;\n# $Id: NodeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeI - Interface describing a Tree Node\n\n=head1 SYNOPSIS\n\n    # get a Tree::NodeI somehow\n    # like from a TreeIO\n    use Bio::TreeIO;\n    # read in a clustalw NJ in phylip/newick format\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'file.dnd');\n\n    my $tree = $treeio->next_tree; # we'll assume it worked for demo purposes\n                                   # you might want to test that it was defined\n\n    my $rootnode = $tree->get_root_node;\n\n    # process just the next generation\n    foreach my $node ( $rootnode->each_Descendent() ) {\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # process all the children\n    my $example_leaf_node;\n    foreach my $node ( $rootnode->get_all_Descendents() ) {\n\tif( $node->is_Leaf ) { \n\t    print \"node is a leaf ... \"; \n            # for example use below\n            $example_leaf_node = $node unless defined $example_leaf_node; \n\t}\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # The ancestor() method points to the parent of a node\n    # A node can only have one parent\n\n    my $parent = $example_leaf_node->ancestor;\n\n    # parent won't likely have an description because it is an internal node\n    # but child will because it is a leaf\n\n    print \"Parent id: \", $parent->id,\" child id: \", \n          $example_leaf_node->id, \"\\n\";\n\n\n=head1 DESCRIPTION\n\nA NodeI is capable of the basic structure of building a tree and\nstoring the branch length between nodes.  The branch length is the\nlength of the branch between the node and its ancestor, thus a root\nnode in a Tree will not typically have a valid branch length.\n\nVarious implementations of NodeI may extend the basic functions and\nallow storing of other information (like attatching a species object\nor full sequences used to build a tree or alternative sequences).  If\nyou don't know how to extend a Bioperl object please ask, happy to\nhelp, we would also greatly appreciate contributions with improvements\nor extensions of the objects back to the Bioperl code base so that\nothers don't have to reinvent your ideas.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeI;\nuse strict;\nno warnings 'recursion';\n\nuse base qw(Bio::Root::RootI);\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $node->add_Descendent($node);\n Function: Adds a descendent to a node\n Returns : number of current descendents for this node\n Args    : Bio::Node::NodeI\n\n\n\nsub add_Descendent{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n\n=head2 each_Descendent\n\n Title   : each_Descendent\n Usage   : my @nodes = $node->each_Descendent;\n Function: all the descendents for this Node (but not their descendents \n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Tree::NodeI objects\n Args    : none\n\n\nsub each_Descendent{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 Decorated Interface methods\n\n\n=head2 get_all_Descendents\n\n Title   : get_all_Descendents($sortby)\n Usage   : my @nodes = $node->get_all_Descendents;\n Function: Recursively fetch all the nodes and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Tree::NodeI objects\n Args    : $sortby [optional] \"height\", \"creation\", \"alpha\", \"revalpha\", \n           or a coderef to be used to sort the order of children nodes.\n\n\nsub get_all_Descendents{\n   my ($self, $sortby) = @_;\n   $sortby ||= 'none';   \n   my @nodes;\n   foreach my $node ( $self->each_Descendent($sortby) ) {\n       push @nodes, ($node,$node->get_all_Descendents($sortby));\n   }\n   return @nodes;\n}\n\n*get_Descendents = \\&get_all_Descendents;\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf ) \n Function: Get Leaf status\n Returns : boolean\n Args    : none\n\n\nsub is_Leaf{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 descendent_count\n\n Title   : descendent_count\n Usage   : my $count = $node->descendent_count;\n Function: Counts the number of descendents a node has \n           (and all of their subnodes)\n Returns : integer\n Args    : none","parameters":[{"label":"$self"}],"label":"descendent_count($self)"},"containerName":"main::","name":"descendent_count","children":[{"line":217,"containerName":"descendent_count","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":218,"localvar":"my","containerName":"descendent_count","kind":13,"name":"$count","definition":"my"},{"name":"$node","localvar":"my","kind":13,"containerName":"descendent_count","line":220,"definition":"my"},{"line":220,"name":"$self","containerName":"descendent_count","kind":13},{"line":220,"containerName":"descendent_count","kind":12,"name":"each_Descendent"},{"name":"$count","kind":13,"containerName":"descendent_count","line":221},{"line":222,"name":"$node","containerName":"descendent_count","kind":13},{"name":"can","kind":12,"containerName":"descendent_count","line":222},{"name":"$count","kind":13,"containerName":"descendent_count","line":222},{"line":222,"kind":13,"containerName":"descendent_count","name":"$node"},{"line":222,"name":"descendent_count","containerName":"descendent_count","kind":12},{"line":224,"name":"$count","kind":13,"containerName":"descendent_count"}],"detail":"($self)","definition":"sub"},{"signature":{"label":"to_string($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: NodeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeI - Interface describing a Tree Node\n\n=head1 SYNOPSIS\n\n    # get a Tree::NodeI somehow\n    # like from a TreeIO\n    use Bio::TreeIO;\n    # read in a clustalw NJ in phylip/newick format\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'file.dnd');\n\n    my $tree = $treeio->next_tree; # we'll assume it worked for demo purposes\n                                   # you might want to test that it was defined\n\n    my $rootnode = $tree->get_root_node;\n\n    # process just the next generation\n    foreach my $node ( $rootnode->each_Descendent() ) {\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # process all the children\n    my $example_leaf_node;\n    foreach my $node ( $rootnode->get_all_Descendents() ) {\n\tif( $node->is_Leaf ) { \n\t    print \"node is a leaf ... \"; \n            # for example use below\n            $example_leaf_node = $node unless defined $example_leaf_node; \n\t}\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # The ancestor() method points to the parent of a node\n    # A node can only have one parent\n\n    my $parent = $example_leaf_node->ancestor;\n\n    # parent won't likely have an description because it is an internal node\n    # but child will because it is a leaf\n\n    print \"Parent id: \", $parent->id,\" child id: \", \n          $example_leaf_node->id, \"\\n\";\n\n\n=head1 DESCRIPTION\n\nA NodeI is capable of the basic structure of building a tree and\nstoring the branch length between nodes.  The branch length is the\nlength of the branch between the node and its ancestor, thus a root\nnode in a Tree will not typically have a valid branch length.\n\nVarious implementations of NodeI may extend the basic functions and\nallow storing of other information (like attatching a species object\nor full sequences used to build a tree or alternative sequences).  If\nyou don't know how to extend a Bioperl object please ask, happy to\nhelp, we would also greatly appreciate contributions with improvements\nor extensions of the objects back to the Bioperl code base so that\nothers don't have to reinvent your ideas.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeI;\nuse strict;\nno warnings 'recursion';\n\nuse base qw(Bio::Root::RootI);\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $node->add_Descendent($node);\n Function: Adds a descendent to a node\n Returns : number of current descendents for this node\n Args    : Bio::Node::NodeI\n\n\n\nsub add_Descendent{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n\n=head2 each_Descendent\n\n Title   : each_Descendent\n Usage   : my @nodes = $node->each_Descendent;\n Function: all the descendents for this Node (but not their descendents \n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Tree::NodeI objects\n Args    : none\n\n\nsub each_Descendent{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 Decorated Interface methods\n\n\n=head2 get_all_Descendents\n\n Title   : get_all_Descendents($sortby)\n Usage   : my @nodes = $node->get_all_Descendents;\n Function: Recursively fetch all the nodes and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Tree::NodeI objects\n Args    : $sortby [optional] \"height\", \"creation\", \"alpha\", \"revalpha\", \n           or a coderef to be used to sort the order of children nodes.\n\n\nsub get_all_Descendents{\n   my ($self, $sortby) = @_;\n   $sortby ||= 'none';   \n   my @nodes;\n   foreach my $node ( $self->each_Descendent($sortby) ) {\n       push @nodes, ($node,$node->get_all_Descendents($sortby));\n   }\n   return @nodes;\n}\n\n*get_Descendents = \\&get_all_Descendents;\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf ) \n Function: Get Leaf status\n Returns : boolean\n Args    : none\n\n\nsub is_Leaf{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 descendent_count\n\n Title   : descendent_count\n Usage   : my $count = $node->descendent_count;\n Function: Counts the number of descendents a node has \n           (and all of their subnodes)\n Returns : integer\n Args    : none\n\n\nsub descendent_count{\n   my ($self) = @_;\n   my $count = 0;\n   \n   foreach my $node ( $self->each_Descendent ) { \n       $count += 1;\n       $node->can('descendent_count') ? $count += $node->descendent_count : next;\n   }\n   return $count;\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : my $str = $node->to_string()\n Function: For debugging, provide a node as a string\n Returns : string\n Args    : none"},"line":238,"kind":12,"range":{"end":{"character":9999,"line":243},"start":{"character":0,"line":238}},"definition":"sub","detail":"($self)","children":[{"line":239,"name":"$self","localvar":"my","kind":13,"containerName":"to_string","definition":"my"},{"name":"$self","kind":13,"containerName":"to_string","line":240},{"name":"id_output","kind":12,"containerName":"to_string","line":240},{"kind":13,"containerName":"to_string","name":"$self","line":240},{"line":240,"name":"id_output","kind":12,"containerName":"to_string"},{"line":241,"name":"$self","kind":13,"containerName":"to_string"},{"line":241,"name":"branch_length","kind":12,"containerName":"to_string"},{"containerName":"to_string","kind":13,"name":"$self","line":241},{"containerName":"to_string","kind":12,"name":"branch_length","line":241}],"name":"to_string","containerName":"main::"},{"children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"height","line":257},{"name":"$self","containerName":"height","kind":13,"line":259},{"line":259,"kind":12,"containerName":"height","name":"is_Leaf"},{"definition":"my","name":"$max","localvar":"my","kind":13,"containerName":"height","line":261},{"definition":"my","line":262,"containerName":"height","localvar":"my","kind":13,"name":"$subnode"},{"name":"$self","kind":13,"containerName":"height","line":262},{"line":262,"containerName":"height","kind":12,"name":"each_Descendent"},{"definition":"my","name":"$s","localvar":"my","kind":13,"containerName":"height","line":263},{"name":"$subnode","containerName":"height","kind":13,"line":263},{"line":263,"containerName":"height","kind":12,"name":"height"},{"line":263,"name":"$subnode","containerName":"height","kind":13},{"line":263,"name":"branch_length","containerName":"height","kind":12},{"line":264,"name":"$s","containerName":"height","kind":13},{"name":"$max","kind":13,"containerName":"height","line":264},{"line":264,"name":"$max","kind":13,"containerName":"height"},{"line":264,"kind":13,"containerName":"height","name":"$s"},{"kind":13,"containerName":"height","name":"$max","line":266}],"name":"height","containerName":"main::","definition":"sub","detail":"($self)","line":256,"range":{"start":{"character":0,"line":256},"end":{"line":267,"character":9999}},"kind":12,"signature":{"label":"height($self)","documentation":"1;\n# $Id: NodeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeI - Interface describing a Tree Node\n\n=head1 SYNOPSIS\n\n    # get a Tree::NodeI somehow\n    # like from a TreeIO\n    use Bio::TreeIO;\n    # read in a clustalw NJ in phylip/newick format\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'file.dnd');\n\n    my $tree = $treeio->next_tree; # we'll assume it worked for demo purposes\n                                   # you might want to test that it was defined\n\n    my $rootnode = $tree->get_root_node;\n\n    # process just the next generation\n    foreach my $node ( $rootnode->each_Descendent() ) {\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # process all the children\n    my $example_leaf_node;\n    foreach my $node ( $rootnode->get_all_Descendents() ) {\n\tif( $node->is_Leaf ) { \n\t    print \"node is a leaf ... \"; \n            # for example use below\n            $example_leaf_node = $node unless defined $example_leaf_node; \n\t}\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # The ancestor() method points to the parent of a node\n    # A node can only have one parent\n\n    my $parent = $example_leaf_node->ancestor;\n\n    # parent won't likely have an description because it is an internal node\n    # but child will because it is a leaf\n\n    print \"Parent id: \", $parent->id,\" child id: \", \n          $example_leaf_node->id, \"\\n\";\n\n\n=head1 DESCRIPTION\n\nA NodeI is capable of the basic structure of building a tree and\nstoring the branch length between nodes.  The branch length is the\nlength of the branch between the node and its ancestor, thus a root\nnode in a Tree will not typically have a valid branch length.\n\nVarious implementations of NodeI may extend the basic functions and\nallow storing of other information (like attatching a species object\nor full sequences used to build a tree or alternative sequences).  If\nyou don't know how to extend a Bioperl object please ask, happy to\nhelp, we would also greatly appreciate contributions with improvements\nor extensions of the objects back to the Bioperl code base so that\nothers don't have to reinvent your ideas.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeI;\nuse strict;\nno warnings 'recursion';\n\nuse base qw(Bio::Root::RootI);\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $node->add_Descendent($node);\n Function: Adds a descendent to a node\n Returns : number of current descendents for this node\n Args    : Bio::Node::NodeI\n\n\n\nsub add_Descendent{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n\n=head2 each_Descendent\n\n Title   : each_Descendent\n Usage   : my @nodes = $node->each_Descendent;\n Function: all the descendents for this Node (but not their descendents \n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Tree::NodeI objects\n Args    : none\n\n\nsub each_Descendent{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 Decorated Interface methods\n\n\n=head2 get_all_Descendents\n\n Title   : get_all_Descendents($sortby)\n Usage   : my @nodes = $node->get_all_Descendents;\n Function: Recursively fetch all the nodes and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Tree::NodeI objects\n Args    : $sortby [optional] \"height\", \"creation\", \"alpha\", \"revalpha\", \n           or a coderef to be used to sort the order of children nodes.\n\n\nsub get_all_Descendents{\n   my ($self, $sortby) = @_;\n   $sortby ||= 'none';   \n   my @nodes;\n   foreach my $node ( $self->each_Descendent($sortby) ) {\n       push @nodes, ($node,$node->get_all_Descendents($sortby));\n   }\n   return @nodes;\n}\n\n*get_Descendents = \\&get_all_Descendents;\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf ) \n Function: Get Leaf status\n Returns : boolean\n Args    : none\n\n\nsub is_Leaf{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 descendent_count\n\n Title   : descendent_count\n Usage   : my $count = $node->descendent_count;\n Function: Counts the number of descendents a node has \n           (and all of their subnodes)\n Returns : integer\n Args    : none\n\n\nsub descendent_count{\n   my ($self) = @_;\n   my $count = 0;\n   \n   foreach my $node ( $self->each_Descendent ) { \n       $count += 1;\n       $node->can('descendent_count') ? $count += $node->descendent_count : next;\n   }\n   return $count;\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : my $str = $node->to_string()\n Function: For debugging, provide a node as a string\n Returns : string\n Args    : none\n\n\n\nsub to_string{\n   my ($self) = @_;\n   return join('',defined $self->id_output ? $self->id_output : '',\n\t\t  defined $self->branch_length ? ':' . $self->branch_length \n\t\t  : ' ')\n}\n\n=head2 height\n\n Title   : height\n Usage   : my $len = $node->height\n Function: Returns the height of the tree starting at this\n           node.  Height is the maximum branchlength to get to the tip.\n Returns : The longest length (weighting branches with branch_length) to a leaf\n Args    : none","parameters":[{"label":"$self"}]}},{"detail":"($self)","definition":"sub","name":"depth","containerName":"main::","children":[{"line":281,"name":"$self","localvar":"my","containerName":"depth","kind":13,"definition":"my"},{"name":"$depth","localvar":"my","kind":13,"containerName":"depth","line":283,"definition":"my"},{"definition":"my","name":"$node","kind":13,"localvar":"my","containerName":"depth","line":284},{"containerName":"depth","kind":13,"name":"$self","line":284},{"line":285,"name":"$node","kind":13,"containerName":"depth"},{"line":285,"containerName":"depth","kind":12,"name":"ancestor"},{"line":286,"name":"$depth","kind":13,"containerName":"depth"},{"kind":13,"containerName":"depth","name":"$node","line":286},{"name":"branch_length","kind":12,"containerName":"depth","line":286},{"line":287,"containerName":"depth","kind":13,"name":"$node"},{"kind":13,"containerName":"depth","name":"$node","line":287},{"line":287,"name":"ancestor","containerName":"depth","kind":12},{"name":"$depth","kind":13,"containerName":"depth","line":289}],"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: NodeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeI - Interface describing a Tree Node\n\n=head1 SYNOPSIS\n\n    # get a Tree::NodeI somehow\n    # like from a TreeIO\n    use Bio::TreeIO;\n    # read in a clustalw NJ in phylip/newick format\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'file.dnd');\n\n    my $tree = $treeio->next_tree; # we'll assume it worked for demo purposes\n                                   # you might want to test that it was defined\n\n    my $rootnode = $tree->get_root_node;\n\n    # process just the next generation\n    foreach my $node ( $rootnode->each_Descendent() ) {\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # process all the children\n    my $example_leaf_node;\n    foreach my $node ( $rootnode->get_all_Descendents() ) {\n\tif( $node->is_Leaf ) { \n\t    print \"node is a leaf ... \"; \n            # for example use below\n            $example_leaf_node = $node unless defined $example_leaf_node; \n\t}\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # The ancestor() method points to the parent of a node\n    # A node can only have one parent\n\n    my $parent = $example_leaf_node->ancestor;\n\n    # parent won't likely have an description because it is an internal node\n    # but child will because it is a leaf\n\n    print \"Parent id: \", $parent->id,\" child id: \", \n          $example_leaf_node->id, \"\\n\";\n\n\n=head1 DESCRIPTION\n\nA NodeI is capable of the basic structure of building a tree and\nstoring the branch length between nodes.  The branch length is the\nlength of the branch between the node and its ancestor, thus a root\nnode in a Tree will not typically have a valid branch length.\n\nVarious implementations of NodeI may extend the basic functions and\nallow storing of other information (like attatching a species object\nor full sequences used to build a tree or alternative sequences).  If\nyou don't know how to extend a Bioperl object please ask, happy to\nhelp, we would also greatly appreciate contributions with improvements\nor extensions of the objects back to the Bioperl code base so that\nothers don't have to reinvent your ideas.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeI;\nuse strict;\nno warnings 'recursion';\n\nuse base qw(Bio::Root::RootI);\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $node->add_Descendent($node);\n Function: Adds a descendent to a node\n Returns : number of current descendents for this node\n Args    : Bio::Node::NodeI\n\n\n\nsub add_Descendent{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n\n=head2 each_Descendent\n\n Title   : each_Descendent\n Usage   : my @nodes = $node->each_Descendent;\n Function: all the descendents for this Node (but not their descendents \n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Tree::NodeI objects\n Args    : none\n\n\nsub each_Descendent{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 Decorated Interface methods\n\n\n=head2 get_all_Descendents\n\n Title   : get_all_Descendents($sortby)\n Usage   : my @nodes = $node->get_all_Descendents;\n Function: Recursively fetch all the nodes and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Tree::NodeI objects\n Args    : $sortby [optional] \"height\", \"creation\", \"alpha\", \"revalpha\", \n           or a coderef to be used to sort the order of children nodes.\n\n\nsub get_all_Descendents{\n   my ($self, $sortby) = @_;\n   $sortby ||= 'none';   \n   my @nodes;\n   foreach my $node ( $self->each_Descendent($sortby) ) {\n       push @nodes, ($node,$node->get_all_Descendents($sortby));\n   }\n   return @nodes;\n}\n\n*get_Descendents = \\&get_all_Descendents;\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf ) \n Function: Get Leaf status\n Returns : boolean\n Args    : none\n\n\nsub is_Leaf{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 descendent_count\n\n Title   : descendent_count\n Usage   : my $count = $node->descendent_count;\n Function: Counts the number of descendents a node has \n           (and all of their subnodes)\n Returns : integer\n Args    : none\n\n\nsub descendent_count{\n   my ($self) = @_;\n   my $count = 0;\n   \n   foreach my $node ( $self->each_Descendent ) { \n       $count += 1;\n       $node->can('descendent_count') ? $count += $node->descendent_count : next;\n   }\n   return $count;\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : my $str = $node->to_string()\n Function: For debugging, provide a node as a string\n Returns : string\n Args    : none\n\n\n\nsub to_string{\n   my ($self) = @_;\n   return join('',defined $self->id_output ? $self->id_output : '',\n\t\t  defined $self->branch_length ? ':' . $self->branch_length \n\t\t  : ' ')\n}\n\n=head2 height\n\n Title   : height\n Usage   : my $len = $node->height\n Function: Returns the height of the tree starting at this\n           node.  Height is the maximum branchlength to get to the tip.\n Returns : The longest length (weighting branches with branch_length) to a leaf\n Args    : none\n\n\nsub height{\n    my ($self) = @_;\n\n    return 0 if( $self->is_Leaf );\n    \n    my $max = 0;\n    foreach my $subnode ( $self->each_Descendent ) { \n\tmy $s = $subnode->height + $subnode->branch_length;;\n\tif( $s > $max ) { $max = $s; }\n    }\n    return $max;\n}\n\n=head2 depth\n\n Title   : depth\n Usage   : my $len = $node->depth\n Function: Returns the depth of the tree starting at this\n           node.  Depth is the distance from this node to the root.\n Returns : The branch length to the root.\n Args    : none","label":"depth($self)"},"kind":12,"range":{"end":{"character":9999,"line":290},"start":{"character":0,"line":280}},"line":280},{"line":307,"range":{"end":{"line":310,"character":9999},"start":{"character":0,"line":307}},"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: NodeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeI - Interface describing a Tree Node\n\n=head1 SYNOPSIS\n\n    # get a Tree::NodeI somehow\n    # like from a TreeIO\n    use Bio::TreeIO;\n    # read in a clustalw NJ in phylip/newick format\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'file.dnd');\n\n    my $tree = $treeio->next_tree; # we'll assume it worked for demo purposes\n                                   # you might want to test that it was defined\n\n    my $rootnode = $tree->get_root_node;\n\n    # process just the next generation\n    foreach my $node ( $rootnode->each_Descendent() ) {\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # process all the children\n    my $example_leaf_node;\n    foreach my $node ( $rootnode->get_all_Descendents() ) {\n\tif( $node->is_Leaf ) { \n\t    print \"node is a leaf ... \"; \n            # for example use below\n            $example_leaf_node = $node unless defined $example_leaf_node; \n\t}\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # The ancestor() method points to the parent of a node\n    # A node can only have one parent\n\n    my $parent = $example_leaf_node->ancestor;\n\n    # parent won't likely have an description because it is an internal node\n    # but child will because it is a leaf\n\n    print \"Parent id: \", $parent->id,\" child id: \", \n          $example_leaf_node->id, \"\\n\";\n\n\n=head1 DESCRIPTION\n\nA NodeI is capable of the basic structure of building a tree and\nstoring the branch length between nodes.  The branch length is the\nlength of the branch between the node and its ancestor, thus a root\nnode in a Tree will not typically have a valid branch length.\n\nVarious implementations of NodeI may extend the basic functions and\nallow storing of other information (like attatching a species object\nor full sequences used to build a tree or alternative sequences).  If\nyou don't know how to extend a Bioperl object please ask, happy to\nhelp, we would also greatly appreciate contributions with improvements\nor extensions of the objects back to the Bioperl code base so that\nothers don't have to reinvent your ideas.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeI;\nuse strict;\nno warnings 'recursion';\n\nuse base qw(Bio::Root::RootI);\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $node->add_Descendent($node);\n Function: Adds a descendent to a node\n Returns : number of current descendents for this node\n Args    : Bio::Node::NodeI\n\n\n\nsub add_Descendent{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n\n=head2 each_Descendent\n\n Title   : each_Descendent\n Usage   : my @nodes = $node->each_Descendent;\n Function: all the descendents for this Node (but not their descendents \n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Tree::NodeI objects\n Args    : none\n\n\nsub each_Descendent{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 Decorated Interface methods\n\n\n=head2 get_all_Descendents\n\n Title   : get_all_Descendents($sortby)\n Usage   : my @nodes = $node->get_all_Descendents;\n Function: Recursively fetch all the nodes and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Tree::NodeI objects\n Args    : $sortby [optional] \"height\", \"creation\", \"alpha\", \"revalpha\", \n           or a coderef to be used to sort the order of children nodes.\n\n\nsub get_all_Descendents{\n   my ($self, $sortby) = @_;\n   $sortby ||= 'none';   \n   my @nodes;\n   foreach my $node ( $self->each_Descendent($sortby) ) {\n       push @nodes, ($node,$node->get_all_Descendents($sortby));\n   }\n   return @nodes;\n}\n\n*get_Descendents = \\&get_all_Descendents;\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf ) \n Function: Get Leaf status\n Returns : boolean\n Args    : none\n\n\nsub is_Leaf{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 descendent_count\n\n Title   : descendent_count\n Usage   : my $count = $node->descendent_count;\n Function: Counts the number of descendents a node has \n           (and all of their subnodes)\n Returns : integer\n Args    : none\n\n\nsub descendent_count{\n   my ($self) = @_;\n   my $count = 0;\n   \n   foreach my $node ( $self->each_Descendent ) { \n       $count += 1;\n       $node->can('descendent_count') ? $count += $node->descendent_count : next;\n   }\n   return $count;\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : my $str = $node->to_string()\n Function: For debugging, provide a node as a string\n Returns : string\n Args    : none\n\n\n\nsub to_string{\n   my ($self) = @_;\n   return join('',defined $self->id_output ? $self->id_output : '',\n\t\t  defined $self->branch_length ? ':' . $self->branch_length \n\t\t  : ' ')\n}\n\n=head2 height\n\n Title   : height\n Usage   : my $len = $node->height\n Function: Returns the height of the tree starting at this\n           node.  Height is the maximum branchlength to get to the tip.\n Returns : The longest length (weighting branches with branch_length) to a leaf\n Args    : none\n\n\nsub height{\n    my ($self) = @_;\n\n    return 0 if( $self->is_Leaf );\n    \n    my $max = 0;\n    foreach my $subnode ( $self->each_Descendent ) { \n\tmy $s = $subnode->height + $subnode->branch_length;;\n\tif( $s > $max ) { $max = $s; }\n    }\n    return $max;\n}\n\n=head2 depth\n\n Title   : depth\n Usage   : my $len = $node->depth\n Function: Returns the depth of the tree starting at this\n           node.  Depth is the distance from this node to the root.\n Returns : The branch length to the root.\n Args    : none\n\n\nsub depth{\n   my ($self) = @_;\n   \n   my $depth = 0;\n   my $node = $self;\n   while( defined $node->ancestor ) { \n       $depth += $node->branch_length;\n       $node = $node->ancestor;\n   }\n   return $depth;\n}\n\n=head2 Get/Set methods\n\n\n=head2 branch_length\n\n Title   : branch_length\n Usage   : $obj->branch_length()\n Function: Get/Set the branch length\n Returns : value of branch_length\n Args    : newvalue (optional)","label":"branch_length($self)"},"children":[{"definition":"my","name":"$self","localvar":"my","containerName":"branch_length","kind":13,"line":308},{"containerName":"branch_length","kind":13,"name":"$self","line":309},{"line":309,"containerName":"branch_length","kind":12,"name":"throw_not_implemented"}],"name":"branch_length","containerName":"main::","definition":"sub","detail":"($self)"},{"line":323,"kind":12,"range":{"start":{"character":0,"line":323},"end":{"line":326,"character":9999}},"signature":{"label":"id($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: NodeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeI - Interface describing a Tree Node\n\n=head1 SYNOPSIS\n\n    # get a Tree::NodeI somehow\n    # like from a TreeIO\n    use Bio::TreeIO;\n    # read in a clustalw NJ in phylip/newick format\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'file.dnd');\n\n    my $tree = $treeio->next_tree; # we'll assume it worked for demo purposes\n                                   # you might want to test that it was defined\n\n    my $rootnode = $tree->get_root_node;\n\n    # process just the next generation\n    foreach my $node ( $rootnode->each_Descendent() ) {\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # process all the children\n    my $example_leaf_node;\n    foreach my $node ( $rootnode->get_all_Descendents() ) {\n\tif( $node->is_Leaf ) { \n\t    print \"node is a leaf ... \"; \n            # for example use below\n            $example_leaf_node = $node unless defined $example_leaf_node; \n\t}\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # The ancestor() method points to the parent of a node\n    # A node can only have one parent\n\n    my $parent = $example_leaf_node->ancestor;\n\n    # parent won't likely have an description because it is an internal node\n    # but child will because it is a leaf\n\n    print \"Parent id: \", $parent->id,\" child id: \", \n          $example_leaf_node->id, \"\\n\";\n\n\n=head1 DESCRIPTION\n\nA NodeI is capable of the basic structure of building a tree and\nstoring the branch length between nodes.  The branch length is the\nlength of the branch between the node and its ancestor, thus a root\nnode in a Tree will not typically have a valid branch length.\n\nVarious implementations of NodeI may extend the basic functions and\nallow storing of other information (like attatching a species object\nor full sequences used to build a tree or alternative sequences).  If\nyou don't know how to extend a Bioperl object please ask, happy to\nhelp, we would also greatly appreciate contributions with improvements\nor extensions of the objects back to the Bioperl code base so that\nothers don't have to reinvent your ideas.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeI;\nuse strict;\nno warnings 'recursion';\n\nuse base qw(Bio::Root::RootI);\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $node->add_Descendent($node);\n Function: Adds a descendent to a node\n Returns : number of current descendents for this node\n Args    : Bio::Node::NodeI\n\n\n\nsub add_Descendent{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n\n=head2 each_Descendent\n\n Title   : each_Descendent\n Usage   : my @nodes = $node->each_Descendent;\n Function: all the descendents for this Node (but not their descendents \n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Tree::NodeI objects\n Args    : none\n\n\nsub each_Descendent{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 Decorated Interface methods\n\n\n=head2 get_all_Descendents\n\n Title   : get_all_Descendents($sortby)\n Usage   : my @nodes = $node->get_all_Descendents;\n Function: Recursively fetch all the nodes and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Tree::NodeI objects\n Args    : $sortby [optional] \"height\", \"creation\", \"alpha\", \"revalpha\", \n           or a coderef to be used to sort the order of children nodes.\n\n\nsub get_all_Descendents{\n   my ($self, $sortby) = @_;\n   $sortby ||= 'none';   \n   my @nodes;\n   foreach my $node ( $self->each_Descendent($sortby) ) {\n       push @nodes, ($node,$node->get_all_Descendents($sortby));\n   }\n   return @nodes;\n}\n\n*get_Descendents = \\&get_all_Descendents;\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf ) \n Function: Get Leaf status\n Returns : boolean\n Args    : none\n\n\nsub is_Leaf{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 descendent_count\n\n Title   : descendent_count\n Usage   : my $count = $node->descendent_count;\n Function: Counts the number of descendents a node has \n           (and all of their subnodes)\n Returns : integer\n Args    : none\n\n\nsub descendent_count{\n   my ($self) = @_;\n   my $count = 0;\n   \n   foreach my $node ( $self->each_Descendent ) { \n       $count += 1;\n       $node->can('descendent_count') ? $count += $node->descendent_count : next;\n   }\n   return $count;\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : my $str = $node->to_string()\n Function: For debugging, provide a node as a string\n Returns : string\n Args    : none\n\n\n\nsub to_string{\n   my ($self) = @_;\n   return join('',defined $self->id_output ? $self->id_output : '',\n\t\t  defined $self->branch_length ? ':' . $self->branch_length \n\t\t  : ' ')\n}\n\n=head2 height\n\n Title   : height\n Usage   : my $len = $node->height\n Function: Returns the height of the tree starting at this\n           node.  Height is the maximum branchlength to get to the tip.\n Returns : The longest length (weighting branches with branch_length) to a leaf\n Args    : none\n\n\nsub height{\n    my ($self) = @_;\n\n    return 0 if( $self->is_Leaf );\n    \n    my $max = 0;\n    foreach my $subnode ( $self->each_Descendent ) { \n\tmy $s = $subnode->height + $subnode->branch_length;;\n\tif( $s > $max ) { $max = $s; }\n    }\n    return $max;\n}\n\n=head2 depth\n\n Title   : depth\n Usage   : my $len = $node->depth\n Function: Returns the depth of the tree starting at this\n           node.  Depth is the distance from this node to the root.\n Returns : The branch length to the root.\n Args    : none\n\n\nsub depth{\n   my ($self) = @_;\n   \n   my $depth = 0;\n   my $node = $self;\n   while( defined $node->ancestor ) { \n       $depth += $node->branch_length;\n       $node = $node->ancestor;\n   }\n   return $depth;\n}\n\n=head2 Get/Set methods\n\n\n=head2 branch_length\n\n Title   : branch_length\n Usage   : $obj->branch_length()\n Function: Get/Set the branch length\n Returns : value of branch_length\n Args    : newvalue (optional)\n\n\n\nsub branch_length{\n    my ($self)= @_;\n    $self->throw_not_implemented();\n}\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id($newval)\n Function: The human readable identifier for the node \n Returns : value of human readable id\n Args    : newvalue (optional)"},"children":[{"definition":"my","line":324,"containerName":"id","localvar":"my","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"id","line":325},{"line":325,"containerName":"id","kind":12,"name":"throw_not_implemented"}],"containerName":"main::","name":"id","definition":"sub","detail":"($self)"},{"line":338,"kind":12,"range":{"start":{"line":338,"character":0},"end":{"line":341,"character":9999}},"signature":{"label":"internal_id($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: NodeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeI - Interface describing a Tree Node\n\n=head1 SYNOPSIS\n\n    # get a Tree::NodeI somehow\n    # like from a TreeIO\n    use Bio::TreeIO;\n    # read in a clustalw NJ in phylip/newick format\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'file.dnd');\n\n    my $tree = $treeio->next_tree; # we'll assume it worked for demo purposes\n                                   # you might want to test that it was defined\n\n    my $rootnode = $tree->get_root_node;\n\n    # process just the next generation\n    foreach my $node ( $rootnode->each_Descendent() ) {\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # process all the children\n    my $example_leaf_node;\n    foreach my $node ( $rootnode->get_all_Descendents() ) {\n\tif( $node->is_Leaf ) { \n\t    print \"node is a leaf ... \"; \n            # for example use below\n            $example_leaf_node = $node unless defined $example_leaf_node; \n\t}\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # The ancestor() method points to the parent of a node\n    # A node can only have one parent\n\n    my $parent = $example_leaf_node->ancestor;\n\n    # parent won't likely have an description because it is an internal node\n    # but child will because it is a leaf\n\n    print \"Parent id: \", $parent->id,\" child id: \", \n          $example_leaf_node->id, \"\\n\";\n\n\n=head1 DESCRIPTION\n\nA NodeI is capable of the basic structure of building a tree and\nstoring the branch length between nodes.  The branch length is the\nlength of the branch between the node and its ancestor, thus a root\nnode in a Tree will not typically have a valid branch length.\n\nVarious implementations of NodeI may extend the basic functions and\nallow storing of other information (like attatching a species object\nor full sequences used to build a tree or alternative sequences).  If\nyou don't know how to extend a Bioperl object please ask, happy to\nhelp, we would also greatly appreciate contributions with improvements\nor extensions of the objects back to the Bioperl code base so that\nothers don't have to reinvent your ideas.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeI;\nuse strict;\nno warnings 'recursion';\n\nuse base qw(Bio::Root::RootI);\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $node->add_Descendent($node);\n Function: Adds a descendent to a node\n Returns : number of current descendents for this node\n Args    : Bio::Node::NodeI\n\n\n\nsub add_Descendent{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n\n=head2 each_Descendent\n\n Title   : each_Descendent\n Usage   : my @nodes = $node->each_Descendent;\n Function: all the descendents for this Node (but not their descendents \n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Tree::NodeI objects\n Args    : none\n\n\nsub each_Descendent{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 Decorated Interface methods\n\n\n=head2 get_all_Descendents\n\n Title   : get_all_Descendents($sortby)\n Usage   : my @nodes = $node->get_all_Descendents;\n Function: Recursively fetch all the nodes and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Tree::NodeI objects\n Args    : $sortby [optional] \"height\", \"creation\", \"alpha\", \"revalpha\", \n           or a coderef to be used to sort the order of children nodes.\n\n\nsub get_all_Descendents{\n   my ($self, $sortby) = @_;\n   $sortby ||= 'none';   \n   my @nodes;\n   foreach my $node ( $self->each_Descendent($sortby) ) {\n       push @nodes, ($node,$node->get_all_Descendents($sortby));\n   }\n   return @nodes;\n}\n\n*get_Descendents = \\&get_all_Descendents;\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf ) \n Function: Get Leaf status\n Returns : boolean\n Args    : none\n\n\nsub is_Leaf{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 descendent_count\n\n Title   : descendent_count\n Usage   : my $count = $node->descendent_count;\n Function: Counts the number of descendents a node has \n           (and all of their subnodes)\n Returns : integer\n Args    : none\n\n\nsub descendent_count{\n   my ($self) = @_;\n   my $count = 0;\n   \n   foreach my $node ( $self->each_Descendent ) { \n       $count += 1;\n       $node->can('descendent_count') ? $count += $node->descendent_count : next;\n   }\n   return $count;\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : my $str = $node->to_string()\n Function: For debugging, provide a node as a string\n Returns : string\n Args    : none\n\n\n\nsub to_string{\n   my ($self) = @_;\n   return join('',defined $self->id_output ? $self->id_output : '',\n\t\t  defined $self->branch_length ? ':' . $self->branch_length \n\t\t  : ' ')\n}\n\n=head2 height\n\n Title   : height\n Usage   : my $len = $node->height\n Function: Returns the height of the tree starting at this\n           node.  Height is the maximum branchlength to get to the tip.\n Returns : The longest length (weighting branches with branch_length) to a leaf\n Args    : none\n\n\nsub height{\n    my ($self) = @_;\n\n    return 0 if( $self->is_Leaf );\n    \n    my $max = 0;\n    foreach my $subnode ( $self->each_Descendent ) { \n\tmy $s = $subnode->height + $subnode->branch_length;;\n\tif( $s > $max ) { $max = $s; }\n    }\n    return $max;\n}\n\n=head2 depth\n\n Title   : depth\n Usage   : my $len = $node->depth\n Function: Returns the depth of the tree starting at this\n           node.  Depth is the distance from this node to the root.\n Returns : The branch length to the root.\n Args    : none\n\n\nsub depth{\n   my ($self) = @_;\n   \n   my $depth = 0;\n   my $node = $self;\n   while( defined $node->ancestor ) { \n       $depth += $node->branch_length;\n       $node = $node->ancestor;\n   }\n   return $depth;\n}\n\n=head2 Get/Set methods\n\n\n=head2 branch_length\n\n Title   : branch_length\n Usage   : $obj->branch_length()\n Function: Get/Set the branch length\n Returns : value of branch_length\n Args    : newvalue (optional)\n\n\n\nsub branch_length{\n    my ($self)= @_;\n    $self->throw_not_implemented();\n}\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id($newval)\n Function: The human readable identifier for the node \n Returns : value of human readable id\n Args    : newvalue (optional)\n\n\n\nsub id{\n    my ($self)= @_;\n    $self->throw_not_implemented();\n}\n\n=head2 internal_id\n\n Title   : internal_id\n Usage   : my $internalid = $node->internal_id\n Function: Returns the internal unique id for this Node\n Returns : unique id\n Args    : none"},"children":[{"line":339,"localvar":"my","containerName":"internal_id","kind":13,"name":"$self","definition":"my"},{"name":"$self","containerName":"internal_id","kind":13,"line":340},{"name":"throw_not_implemented","kind":12,"containerName":"internal_id","line":340}],"name":"internal_id","containerName":"main::","definition":"sub","detail":"($self)"},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: NodeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeI - Interface describing a Tree Node\n\n=head1 SYNOPSIS\n\n    # get a Tree::NodeI somehow\n    # like from a TreeIO\n    use Bio::TreeIO;\n    # read in a clustalw NJ in phylip/newick format\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'file.dnd');\n\n    my $tree = $treeio->next_tree; # we'll assume it worked for demo purposes\n                                   # you might want to test that it was defined\n\n    my $rootnode = $tree->get_root_node;\n\n    # process just the next generation\n    foreach my $node ( $rootnode->each_Descendent() ) {\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # process all the children\n    my $example_leaf_node;\n    foreach my $node ( $rootnode->get_all_Descendents() ) {\n\tif( $node->is_Leaf ) { \n\t    print \"node is a leaf ... \"; \n            # for example use below\n            $example_leaf_node = $node unless defined $example_leaf_node; \n\t}\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # The ancestor() method points to the parent of a node\n    # A node can only have one parent\n\n    my $parent = $example_leaf_node->ancestor;\n\n    # parent won't likely have an description because it is an internal node\n    # but child will because it is a leaf\n\n    print \"Parent id: \", $parent->id,\" child id: \", \n          $example_leaf_node->id, \"\\n\";\n\n\n=head1 DESCRIPTION\n\nA NodeI is capable of the basic structure of building a tree and\nstoring the branch length between nodes.  The branch length is the\nlength of the branch between the node and its ancestor, thus a root\nnode in a Tree will not typically have a valid branch length.\n\nVarious implementations of NodeI may extend the basic functions and\nallow storing of other information (like attatching a species object\nor full sequences used to build a tree or alternative sequences).  If\nyou don't know how to extend a Bioperl object please ask, happy to\nhelp, we would also greatly appreciate contributions with improvements\nor extensions of the objects back to the Bioperl code base so that\nothers don't have to reinvent your ideas.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeI;\nuse strict;\nno warnings 'recursion';\n\nuse base qw(Bio::Root::RootI);\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $node->add_Descendent($node);\n Function: Adds a descendent to a node\n Returns : number of current descendents for this node\n Args    : Bio::Node::NodeI\n\n\n\nsub add_Descendent{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n\n=head2 each_Descendent\n\n Title   : each_Descendent\n Usage   : my @nodes = $node->each_Descendent;\n Function: all the descendents for this Node (but not their descendents \n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Tree::NodeI objects\n Args    : none\n\n\nsub each_Descendent{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 Decorated Interface methods\n\n\n=head2 get_all_Descendents\n\n Title   : get_all_Descendents($sortby)\n Usage   : my @nodes = $node->get_all_Descendents;\n Function: Recursively fetch all the nodes and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Tree::NodeI objects\n Args    : $sortby [optional] \"height\", \"creation\", \"alpha\", \"revalpha\", \n           or a coderef to be used to sort the order of children nodes.\n\n\nsub get_all_Descendents{\n   my ($self, $sortby) = @_;\n   $sortby ||= 'none';   \n   my @nodes;\n   foreach my $node ( $self->each_Descendent($sortby) ) {\n       push @nodes, ($node,$node->get_all_Descendents($sortby));\n   }\n   return @nodes;\n}\n\n*get_Descendents = \\&get_all_Descendents;\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf ) \n Function: Get Leaf status\n Returns : boolean\n Args    : none\n\n\nsub is_Leaf{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 descendent_count\n\n Title   : descendent_count\n Usage   : my $count = $node->descendent_count;\n Function: Counts the number of descendents a node has \n           (and all of their subnodes)\n Returns : integer\n Args    : none\n\n\nsub descendent_count{\n   my ($self) = @_;\n   my $count = 0;\n   \n   foreach my $node ( $self->each_Descendent ) { \n       $count += 1;\n       $node->can('descendent_count') ? $count += $node->descendent_count : next;\n   }\n   return $count;\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : my $str = $node->to_string()\n Function: For debugging, provide a node as a string\n Returns : string\n Args    : none\n\n\n\nsub to_string{\n   my ($self) = @_;\n   return join('',defined $self->id_output ? $self->id_output : '',\n\t\t  defined $self->branch_length ? ':' . $self->branch_length \n\t\t  : ' ')\n}\n\n=head2 height\n\n Title   : height\n Usage   : my $len = $node->height\n Function: Returns the height of the tree starting at this\n           node.  Height is the maximum branchlength to get to the tip.\n Returns : The longest length (weighting branches with branch_length) to a leaf\n Args    : none\n\n\nsub height{\n    my ($self) = @_;\n\n    return 0 if( $self->is_Leaf );\n    \n    my $max = 0;\n    foreach my $subnode ( $self->each_Descendent ) { \n\tmy $s = $subnode->height + $subnode->branch_length;;\n\tif( $s > $max ) { $max = $s; }\n    }\n    return $max;\n}\n\n=head2 depth\n\n Title   : depth\n Usage   : my $len = $node->depth\n Function: Returns the depth of the tree starting at this\n           node.  Depth is the distance from this node to the root.\n Returns : The branch length to the root.\n Args    : none\n\n\nsub depth{\n   my ($self) = @_;\n   \n   my $depth = 0;\n   my $node = $self;\n   while( defined $node->ancestor ) { \n       $depth += $node->branch_length;\n       $node = $node->ancestor;\n   }\n   return $depth;\n}\n\n=head2 Get/Set methods\n\n\n=head2 branch_length\n\n Title   : branch_length\n Usage   : $obj->branch_length()\n Function: Get/Set the branch length\n Returns : value of branch_length\n Args    : newvalue (optional)\n\n\n\nsub branch_length{\n    my ($self)= @_;\n    $self->throw_not_implemented();\n}\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id($newval)\n Function: The human readable identifier for the node \n Returns : value of human readable id\n Args    : newvalue (optional)\n\n\n\nsub id{\n    my ($self)= @_;\n    $self->throw_not_implemented();\n}\n\n=head2 internal_id\n\n Title   : internal_id\n Usage   : my $internalid = $node->internal_id\n Function: Returns the internal unique id for this Node\n Returns : unique id\n Args    : none\n\n\nsub internal_id{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description($newval)\n Function: Get/Set the description string\n Returns : value of description\n Args    : newvalue (optional)","label":"description($self)"},"range":{"start":{"character":0,"line":354},"end":{"line":357,"character":9999}},"kind":12,"line":354,"detail":"($self)","definition":"sub","containerName":"main::","name":"description","children":[{"localvar":"my","containerName":"description","kind":13,"name":"$self","line":355,"definition":"my"},{"line":356,"containerName":"description","kind":13,"name":"$self"},{"line":356,"name":"throw_not_implemented","containerName":"description","kind":12}]},{"containerName":"main::","name":"bootstrap","children":[{"name":"$self","containerName":"bootstrap","localvar":"my","kind":13,"line":371,"definition":"my"},{"line":372,"containerName":"bootstrap","kind":13,"name":"$self"},{"name":"throw_not_implemented","containerName":"bootstrap","kind":12,"line":372}],"detail":"($self)","definition":"sub","range":{"end":{"character":9999,"line":373},"start":{"character":0,"line":370}},"kind":12,"line":370,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: NodeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeI - Interface describing a Tree Node\n\n=head1 SYNOPSIS\n\n    # get a Tree::NodeI somehow\n    # like from a TreeIO\n    use Bio::TreeIO;\n    # read in a clustalw NJ in phylip/newick format\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'file.dnd');\n\n    my $tree = $treeio->next_tree; # we'll assume it worked for demo purposes\n                                   # you might want to test that it was defined\n\n    my $rootnode = $tree->get_root_node;\n\n    # process just the next generation\n    foreach my $node ( $rootnode->each_Descendent() ) {\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # process all the children\n    my $example_leaf_node;\n    foreach my $node ( $rootnode->get_all_Descendents() ) {\n\tif( $node->is_Leaf ) { \n\t    print \"node is a leaf ... \"; \n            # for example use below\n            $example_leaf_node = $node unless defined $example_leaf_node; \n\t}\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # The ancestor() method points to the parent of a node\n    # A node can only have one parent\n\n    my $parent = $example_leaf_node->ancestor;\n\n    # parent won't likely have an description because it is an internal node\n    # but child will because it is a leaf\n\n    print \"Parent id: \", $parent->id,\" child id: \", \n          $example_leaf_node->id, \"\\n\";\n\n\n=head1 DESCRIPTION\n\nA NodeI is capable of the basic structure of building a tree and\nstoring the branch length between nodes.  The branch length is the\nlength of the branch between the node and its ancestor, thus a root\nnode in a Tree will not typically have a valid branch length.\n\nVarious implementations of NodeI may extend the basic functions and\nallow storing of other information (like attatching a species object\nor full sequences used to build a tree or alternative sequences).  If\nyou don't know how to extend a Bioperl object please ask, happy to\nhelp, we would also greatly appreciate contributions with improvements\nor extensions of the objects back to the Bioperl code base so that\nothers don't have to reinvent your ideas.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeI;\nuse strict;\nno warnings 'recursion';\n\nuse base qw(Bio::Root::RootI);\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $node->add_Descendent($node);\n Function: Adds a descendent to a node\n Returns : number of current descendents for this node\n Args    : Bio::Node::NodeI\n\n\n\nsub add_Descendent{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n\n=head2 each_Descendent\n\n Title   : each_Descendent\n Usage   : my @nodes = $node->each_Descendent;\n Function: all the descendents for this Node (but not their descendents \n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Tree::NodeI objects\n Args    : none\n\n\nsub each_Descendent{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 Decorated Interface methods\n\n\n=head2 get_all_Descendents\n\n Title   : get_all_Descendents($sortby)\n Usage   : my @nodes = $node->get_all_Descendents;\n Function: Recursively fetch all the nodes and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Tree::NodeI objects\n Args    : $sortby [optional] \"height\", \"creation\", \"alpha\", \"revalpha\", \n           or a coderef to be used to sort the order of children nodes.\n\n\nsub get_all_Descendents{\n   my ($self, $sortby) = @_;\n   $sortby ||= 'none';   \n   my @nodes;\n   foreach my $node ( $self->each_Descendent($sortby) ) {\n       push @nodes, ($node,$node->get_all_Descendents($sortby));\n   }\n   return @nodes;\n}\n\n*get_Descendents = \\&get_all_Descendents;\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf ) \n Function: Get Leaf status\n Returns : boolean\n Args    : none\n\n\nsub is_Leaf{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 descendent_count\n\n Title   : descendent_count\n Usage   : my $count = $node->descendent_count;\n Function: Counts the number of descendents a node has \n           (and all of their subnodes)\n Returns : integer\n Args    : none\n\n\nsub descendent_count{\n   my ($self) = @_;\n   my $count = 0;\n   \n   foreach my $node ( $self->each_Descendent ) { \n       $count += 1;\n       $node->can('descendent_count') ? $count += $node->descendent_count : next;\n   }\n   return $count;\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : my $str = $node->to_string()\n Function: For debugging, provide a node as a string\n Returns : string\n Args    : none\n\n\n\nsub to_string{\n   my ($self) = @_;\n   return join('',defined $self->id_output ? $self->id_output : '',\n\t\t  defined $self->branch_length ? ':' . $self->branch_length \n\t\t  : ' ')\n}\n\n=head2 height\n\n Title   : height\n Usage   : my $len = $node->height\n Function: Returns the height of the tree starting at this\n           node.  Height is the maximum branchlength to get to the tip.\n Returns : The longest length (weighting branches with branch_length) to a leaf\n Args    : none\n\n\nsub height{\n    my ($self) = @_;\n\n    return 0 if( $self->is_Leaf );\n    \n    my $max = 0;\n    foreach my $subnode ( $self->each_Descendent ) { \n\tmy $s = $subnode->height + $subnode->branch_length;;\n\tif( $s > $max ) { $max = $s; }\n    }\n    return $max;\n}\n\n=head2 depth\n\n Title   : depth\n Usage   : my $len = $node->depth\n Function: Returns the depth of the tree starting at this\n           node.  Depth is the distance from this node to the root.\n Returns : The branch length to the root.\n Args    : none\n\n\nsub depth{\n   my ($self) = @_;\n   \n   my $depth = 0;\n   my $node = $self;\n   while( defined $node->ancestor ) { \n       $depth += $node->branch_length;\n       $node = $node->ancestor;\n   }\n   return $depth;\n}\n\n=head2 Get/Set methods\n\n\n=head2 branch_length\n\n Title   : branch_length\n Usage   : $obj->branch_length()\n Function: Get/Set the branch length\n Returns : value of branch_length\n Args    : newvalue (optional)\n\n\n\nsub branch_length{\n    my ($self)= @_;\n    $self->throw_not_implemented();\n}\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id($newval)\n Function: The human readable identifier for the node \n Returns : value of human readable id\n Args    : newvalue (optional)\n\n\n\nsub id{\n    my ($self)= @_;\n    $self->throw_not_implemented();\n}\n\n=head2 internal_id\n\n Title   : internal_id\n Usage   : my $internalid = $node->internal_id\n Function: Returns the internal unique id for this Node\n Returns : unique id\n Args    : none\n\n\nsub internal_id{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description($newval)\n Function: Get/Set the description string\n Returns : value of description\n Args    : newvalue (optional)\n\n\n\nsub description{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 bootstrap\n\n Title   : bootstrap\n Usage   : $obj->bootstrap($newval)\n Function: Get/Set the bootstrap value\n Returns : value of bootstrap\n Args    : newvalue (optional)","label":"bootstrap($self)"}},{"containerName":"main::","name":"ancestor","children":[{"definition":"my","localvar":"my","containerName":"ancestor","kind":13,"name":"$self","line":387},{"containerName":"ancestor","kind":13,"name":"@args","line":387},{"line":388,"kind":13,"containerName":"ancestor","name":"$self"},{"kind":12,"containerName":"ancestor","name":"throw_not_implemented","line":388}],"detail":"($self,@args)","definition":"sub","kind":12,"range":{"end":{"line":389,"character":9999},"start":{"line":386,"character":0}},"line":386,"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: NodeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeI - Interface describing a Tree Node\n\n=head1 SYNOPSIS\n\n    # get a Tree::NodeI somehow\n    # like from a TreeIO\n    use Bio::TreeIO;\n    # read in a clustalw NJ in phylip/newick format\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'file.dnd');\n\n    my $tree = $treeio->next_tree; # we'll assume it worked for demo purposes\n                                   # you might want to test that it was defined\n\n    my $rootnode = $tree->get_root_node;\n\n    # process just the next generation\n    foreach my $node ( $rootnode->each_Descendent() ) {\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # process all the children\n    my $example_leaf_node;\n    foreach my $node ( $rootnode->get_all_Descendents() ) {\n\tif( $node->is_Leaf ) { \n\t    print \"node is a leaf ... \"; \n            # for example use below\n            $example_leaf_node = $node unless defined $example_leaf_node; \n\t}\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # The ancestor() method points to the parent of a node\n    # A node can only have one parent\n\n    my $parent = $example_leaf_node->ancestor;\n\n    # parent won't likely have an description because it is an internal node\n    # but child will because it is a leaf\n\n    print \"Parent id: \", $parent->id,\" child id: \", \n          $example_leaf_node->id, \"\\n\";\n\n\n=head1 DESCRIPTION\n\nA NodeI is capable of the basic structure of building a tree and\nstoring the branch length between nodes.  The branch length is the\nlength of the branch between the node and its ancestor, thus a root\nnode in a Tree will not typically have a valid branch length.\n\nVarious implementations of NodeI may extend the basic functions and\nallow storing of other information (like attatching a species object\nor full sequences used to build a tree or alternative sequences).  If\nyou don't know how to extend a Bioperl object please ask, happy to\nhelp, we would also greatly appreciate contributions with improvements\nor extensions of the objects back to the Bioperl code base so that\nothers don't have to reinvent your ideas.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeI;\nuse strict;\nno warnings 'recursion';\n\nuse base qw(Bio::Root::RootI);\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $node->add_Descendent($node);\n Function: Adds a descendent to a node\n Returns : number of current descendents for this node\n Args    : Bio::Node::NodeI\n\n\n\nsub add_Descendent{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n\n=head2 each_Descendent\n\n Title   : each_Descendent\n Usage   : my @nodes = $node->each_Descendent;\n Function: all the descendents for this Node (but not their descendents \n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Tree::NodeI objects\n Args    : none\n\n\nsub each_Descendent{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 Decorated Interface methods\n\n\n=head2 get_all_Descendents\n\n Title   : get_all_Descendents($sortby)\n Usage   : my @nodes = $node->get_all_Descendents;\n Function: Recursively fetch all the nodes and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Tree::NodeI objects\n Args    : $sortby [optional] \"height\", \"creation\", \"alpha\", \"revalpha\", \n           or a coderef to be used to sort the order of children nodes.\n\n\nsub get_all_Descendents{\n   my ($self, $sortby) = @_;\n   $sortby ||= 'none';   \n   my @nodes;\n   foreach my $node ( $self->each_Descendent($sortby) ) {\n       push @nodes, ($node,$node->get_all_Descendents($sortby));\n   }\n   return @nodes;\n}\n\n*get_Descendents = \\&get_all_Descendents;\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf ) \n Function: Get Leaf status\n Returns : boolean\n Args    : none\n\n\nsub is_Leaf{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 descendent_count\n\n Title   : descendent_count\n Usage   : my $count = $node->descendent_count;\n Function: Counts the number of descendents a node has \n           (and all of their subnodes)\n Returns : integer\n Args    : none\n\n\nsub descendent_count{\n   my ($self) = @_;\n   my $count = 0;\n   \n   foreach my $node ( $self->each_Descendent ) { \n       $count += 1;\n       $node->can('descendent_count') ? $count += $node->descendent_count : next;\n   }\n   return $count;\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : my $str = $node->to_string()\n Function: For debugging, provide a node as a string\n Returns : string\n Args    : none\n\n\n\nsub to_string{\n   my ($self) = @_;\n   return join('',defined $self->id_output ? $self->id_output : '',\n\t\t  defined $self->branch_length ? ':' . $self->branch_length \n\t\t  : ' ')\n}\n\n=head2 height\n\n Title   : height\n Usage   : my $len = $node->height\n Function: Returns the height of the tree starting at this\n           node.  Height is the maximum branchlength to get to the tip.\n Returns : The longest length (weighting branches with branch_length) to a leaf\n Args    : none\n\n\nsub height{\n    my ($self) = @_;\n\n    return 0 if( $self->is_Leaf );\n    \n    my $max = 0;\n    foreach my $subnode ( $self->each_Descendent ) { \n\tmy $s = $subnode->height + $subnode->branch_length;;\n\tif( $s > $max ) { $max = $s; }\n    }\n    return $max;\n}\n\n=head2 depth\n\n Title   : depth\n Usage   : my $len = $node->depth\n Function: Returns the depth of the tree starting at this\n           node.  Depth is the distance from this node to the root.\n Returns : The branch length to the root.\n Args    : none\n\n\nsub depth{\n   my ($self) = @_;\n   \n   my $depth = 0;\n   my $node = $self;\n   while( defined $node->ancestor ) { \n       $depth += $node->branch_length;\n       $node = $node->ancestor;\n   }\n   return $depth;\n}\n\n=head2 Get/Set methods\n\n\n=head2 branch_length\n\n Title   : branch_length\n Usage   : $obj->branch_length()\n Function: Get/Set the branch length\n Returns : value of branch_length\n Args    : newvalue (optional)\n\n\n\nsub branch_length{\n    my ($self)= @_;\n    $self->throw_not_implemented();\n}\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id($newval)\n Function: The human readable identifier for the node \n Returns : value of human readable id\n Args    : newvalue (optional)\n\n\n\nsub id{\n    my ($self)= @_;\n    $self->throw_not_implemented();\n}\n\n=head2 internal_id\n\n Title   : internal_id\n Usage   : my $internalid = $node->internal_id\n Function: Returns the internal unique id for this Node\n Returns : unique id\n Args    : none\n\n\nsub internal_id{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description($newval)\n Function: Get/Set the description string\n Returns : value of description\n Args    : newvalue (optional)\n\n\n\nsub description{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 bootstrap\n\n Title   : bootstrap\n Usage   : $obj->bootstrap($newval)\n Function: Get/Set the bootstrap value\n Returns : value of bootstrap\n Args    : newvalue (optional)\n\n\n\nsub bootstrap{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 ancestor\n\n Title   : ancestor\n Usage   : my $node = $node->ancestor;\n Function: Get/Set the ancestor node pointer for a Node\n Returns : Null if this is top level node\n Args    : none","label":"ancestor($self,@args)"}},{"definition":"sub","name":"invalidate_height","containerName":"main::","children":[{"name":"throw_not_implemented","kind":12,"containerName":"invalidate_height","line":402}],"kind":12,"range":{"start":{"character":0,"line":401},"end":{"character":9999,"line":403}},"line":401},{"definition":"sub","children":[{"name":"throw_not_implemented","containerName":"set_tag_value","kind":12,"line":422}],"name":"set_tag_value","containerName":"main::","line":421,"kind":12,"range":{"end":{"character":9999,"line":423},"start":{"line":421,"character":0}}},{"definition":"sub","containerName":"main::","name":"add_tag_value","children":[{"name":"throw_not_implemented","kind":12,"containerName":"add_tag_value","line":438}],"range":{"start":{"character":0,"line":437},"end":{"character":9999,"line":439}},"kind":12,"line":437},{"name":"remove_tag","containerName":"main::","children":[{"line":453,"name":"throw_not_implemented","kind":12,"containerName":"remove_tag"}],"definition":"sub","range":{"end":{"line":454,"character":9999},"start":{"line":452,"character":0}},"kind":12,"line":452},{"range":{"start":{"character":0,"line":467},"end":{"line":469,"character":9999}},"kind":12,"line":467,"definition":"sub","name":"remove_all_tags","containerName":"main::","children":[{"line":468,"name":"throw_not_implemented","kind":12,"containerName":"remove_all_tags"}]},{"range":{"end":{"character":9999,"line":484},"start":{"line":482,"character":0}},"kind":12,"line":482,"definition":"sub","containerName":"main::","name":"get_all_tags","children":[{"name":"throw_not_implemented","kind":12,"containerName":"get_all_tags","line":483}]},{"line":497,"range":{"start":{"character":0,"line":497},"end":{"line":499,"character":9999}},"kind":12,"children":[{"containerName":"get_tag_values","kind":12,"name":"throw_not_implemented","line":498}],"name":"get_tag_values","containerName":"main::","definition":"sub"},{"line":512,"range":{"end":{"character":9999,"line":514},"start":{"line":512,"character":0}},"kind":12,"definition":"sub","children":[{"kind":12,"containerName":"has_tag","name":"throw_not_implemented","line":513}],"containerName":"main::","name":"has_tag"},{"kind":12,"range":{"start":{"line":534,"character":0},"end":{"line":544,"character":9999}},"line":534,"definition":"sub","name":"id_output","containerName":"main::","children":[{"definition":"my","line":535,"name":"$node","localvar":"my","containerName":"id_output","kind":13},{"definition":"my","name":"$id","containerName":"id_output","localvar":"my","kind":13,"line":536},{"name":"$node","containerName":"id_output","kind":13,"line":536},{"name":"id","containerName":"id_output","kind":12,"line":536},{"containerName":"id_output","kind":13,"name":"$id","line":537},{"name":"$id","kind":13,"containerName":"id_output","line":537},{"line":540,"containerName":"id_output","kind":13,"name":"$id"},{"line":541,"kind":13,"containerName":"id_output","name":"$id"},{"line":541,"kind":13,"containerName":"id_output","name":"$id"},{"line":543,"kind":13,"containerName":"id_output","name":"$id"}]}],"version":5}