{"vars":[{"kind":2,"containerName":"","name":"vars","line":85},{"name":"Util","kind":2,"containerName":"strict::Scalar","line":88},{"containerName":"","kind":2,"name":"base","line":90},{"kind":13,"containerName":null,"name":"$CREATIONORDER","line":93},{"range":{"start":{"character":0,"line":112},"end":{"line":149,"character":9999}},"kind":12,"line":112,"signature":{"documentation":"1;\n# $Id: Node.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Node\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Node - A Simple Tree Node\n\n=head1 SYNOPSIS\n\n    use Bio::Tree::Node;\n    my $nodeA = Bio::Tree::Node->new();\n    my $nodeL = Bio::Tree::Node->new();\n    my $nodeR = Bio::Tree::Node->new();\n\n    my $node = Bio::Tree::Node->new();\n    $node->add_Descendent($nodeL);\n    $node->add_Descendent($nodeR);\n\n    print \"node is not a leaf \\n\" if( $node->is_leaf);\n\n=head1 DESCRIPTION\n\nMakes a Tree Node suitable for building a Tree.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey, amackey-at-virginia-dot-edu\nSendu Bala,   bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tree::Node;\nuse vars qw($CREATIONORDER);\nuse strict;\n\nuse Scalar::Util qw(weaken isweak);\n\nuse base qw(Bio::Root::Root Bio::Tree::NodeI);\n\nBEGIN {\n    $CREATIONORDER = 1;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Node->new();\n Function: Builds a new Bio::Tree::Node object\n Returns : Bio::Tree::Node\n Args    : -descendents   => arrayref of descendents (they will be\n                             updated s.t. their ancestor point is this\n                             node)\n           -branch_length => branch length [integer] (optional)\n           -bootstrap     => value   bootstrap value (string)\n           -description   => description of node\n           -id            => human readable id for node","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"containerName":"main::","name":"new","children":[{"definition":"my","line":113,"name":"$class","localvar":"my","kind":13,"containerName":"new"},{"line":113,"name":"@args","containerName":"new","kind":13},{"name":"$self","kind":13,"localvar":"my","containerName":"new","line":115,"definition":"my"},{"line":115,"name":"$class","containerName":"new","kind":13},{"name":"@args","kind":13,"containerName":"new","line":115},{"definition":"my","name":"$children","containerName":"new","localvar":"my","kind":13,"line":116},{"kind":13,"containerName":"new","name":"$branchlen","line":116},{"kind":13,"containerName":"new","name":"$id","line":116},{"kind":13,"containerName":"new","name":"$bootstrap","line":117},{"line":117,"containerName":"new","kind":13,"name":"$desc"},{"line":117,"name":"$d","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$self","line":117},{"containerName":"new","kind":12,"name":"_rearrange","line":117},{"line":126,"kind":13,"containerName":"new","name":"@args"},{"line":127,"containerName":"new","kind":13,"name":"$self"},{"name":"_register_for_cleanup","containerName":"new","kind":12,"line":127},{"name":"$self","containerName":"new","kind":13,"line":128},{"name":"$d","kind":13,"containerName":"new","line":129},{"name":"$desc","containerName":"new","kind":13,"line":129},{"line":130,"containerName":"new","kind":13,"name":"$self"},{"line":130,"containerName":"new","kind":12,"name":"warn"},{"kind":13,"containerName":"new","name":"$desc","line":131},{"line":131,"name":"$d","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$d","line":132},{"line":132,"kind":13,"containerName":"new","name":"$desc"},{"containerName":"new","kind":13,"name":"$desc","line":133},{"line":133,"name":"$d","containerName":"new","kind":13},{"line":135,"containerName":"new","kind":13,"name":"$desc"},{"name":"$self","containerName":"new","kind":13,"line":135},{"name":"description","containerName":"new","kind":12,"line":135},{"name":"$desc","kind":13,"containerName":"new","line":135},{"line":136,"kind":13,"containerName":"new","name":"$bootstrap"},{"line":136,"name":"$self","kind":13,"containerName":"new"},{"name":"bootstrap","containerName":"new","kind":12,"line":136},{"line":136,"containerName":"new","kind":13,"name":"$bootstrap"},{"line":137,"containerName":"new","kind":13,"name":"$id"},{"name":"$self","kind":13,"containerName":"new","line":137},{"line":137,"containerName":"new","kind":12,"name":"id"},{"line":137,"containerName":"new","kind":13,"name":"$id"},{"line":138,"containerName":"new","kind":13,"name":"$branchlen"},{"name":"$self","containerName":"new","kind":13,"line":138},{"name":"branch_length","containerName":"new","kind":12,"line":138},{"line":138,"containerName":"new","kind":13,"name":"$branchlen"},{"line":139,"containerName":"new","kind":13,"name":"$children"},{"line":140,"containerName":"new","kind":13,"name":"$children"},{"line":141,"name":"$self","kind":13,"containerName":"new"},{"containerName":"new","kind":12,"name":"warn","line":141},{"line":143,"localvar":"my","containerName":"new","kind":13,"name":"$c","definition":"my"},{"line":143,"kind":13,"containerName":"new","name":"$children"},{"line":144,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"containerName":"new","name":"add_Descendent","line":144},{"line":144,"containerName":"new","kind":13,"name":"$c"},{"name":"$self","containerName":"new","kind":13,"line":147},{"name":"_creation_id","containerName":"new","kind":12,"line":147},{"line":147,"containerName":"new","kind":13,"name":"$CREATIONORDER"},{"name":"$self","kind":13,"containerName":"new","line":148}],"detail":"($class,@args)","definition":"sub"},{"line":115,"containerName":"new","kind":12,"name":"SUPER"},{"line":127,"kind":12,"name":"node_cleanup"},{"signature":{"label":"create_node_on_branch($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":""},"line":166,"kind":12,"range":{"end":{"line":208,"character":9999},"start":{"line":166,"character":0}},"definition":"sub","detail":"($self,@args)","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"create_node_on_branch","line":167,"definition":"my"},{"line":167,"name":"@args","containerName":"create_node_on_branch","kind":13},{"line":168,"name":"$pos","containerName":"create_node_on_branch","localvar":"my","kind":13,"definition":"my"},{"line":168,"name":"$frac","containerName":"create_node_on_branch","kind":13},{"line":168,"name":"$annot","kind":13,"containerName":"create_node_on_branch"},{"kind":13,"containerName":"create_node_on_branch","name":"$force","line":168},{"line":168,"kind":13,"containerName":"create_node_on_branch","name":"$self"},{"kind":12,"containerName":"create_node_on_branch","name":"_rearrange","line":168},{"containerName":"create_node_on_branch","kind":13,"name":"@args","line":168},{"name":"$newpos","containerName":"create_node_on_branch","localvar":"my","kind":13,"line":169,"definition":"my"},{"name":"$blen","containerName":"create_node_on_branch","localvar":"my","kind":13,"line":170,"definition":"my"},{"name":"$self","containerName":"create_node_on_branch","kind":13,"line":170},{"line":170,"containerName":"create_node_on_branch","kind":12,"name":"branch_length"},{"line":172,"name":"$force","containerName":"create_node_on_branch","kind":13},{"line":173,"name":"$annot","kind":13,"containerName":"create_node_on_branch"},{"containerName":"create_node_on_branch","kind":13,"name":"$self","line":175},{"name":"ancestor","containerName":"create_node_on_branch","kind":12,"line":175},{"name":"$self","containerName":"create_node_on_branch","kind":13,"line":176},{"name":"throw","kind":12,"containerName":"create_node_on_branch","line":176},{"line":178,"name":"$blen","kind":13,"containerName":"create_node_on_branch"},{"line":179,"containerName":"create_node_on_branch","kind":13,"name":"$self"},{"line":179,"name":"throw","kind":12,"containerName":"create_node_on_branch"},{"line":179,"containerName":"create_node_on_branch","kind":13,"name":"$force"},{"line":181,"containerName":"create_node_on_branch","kind":13,"name":"$pos"},{"containerName":"create_node_on_branch","kind":13,"name":"$frac","line":181},{"line":181,"name":"$frac","containerName":"create_node_on_branch","kind":13},{"line":181,"name":"$pos","kind":13,"containerName":"create_node_on_branch"},{"name":"$self","containerName":"create_node_on_branch","kind":13,"line":182},{"line":182,"containerName":"create_node_on_branch","kind":12,"name":"throw"},{"containerName":"create_node_on_branch","kind":13,"name":"$frac","line":184},{"line":185,"containerName":"create_node_on_branch","kind":13,"name":"$self"},{"line":185,"containerName":"create_node_on_branch","kind":12,"name":"throw"},{"line":185,"name":"$frac","kind":13,"containerName":"create_node_on_branch"},{"name":"$frac","containerName":"create_node_on_branch","kind":13,"line":185},{"containerName":"create_node_on_branch","kind":13,"name":"$newpos","line":186},{"name":"$frac","containerName":"create_node_on_branch","kind":13,"line":186},{"line":186,"kind":13,"containerName":"create_node_on_branch","name":"$blen"},{"line":188,"name":"$pos","containerName":"create_node_on_branch","kind":13},{"line":189,"name":"$self","containerName":"create_node_on_branch","kind":13},{"line":189,"name":"throw","kind":12,"containerName":"create_node_on_branch"},{"line":189,"kind":13,"containerName":"create_node_on_branch","name":"$pos"},{"line":189,"containerName":"create_node_on_branch","kind":13,"name":"$pos"},{"line":189,"kind":13,"containerName":"create_node_on_branch","name":"$blen"},{"line":190,"name":"$newpos","kind":13,"containerName":"create_node_on_branch"},{"line":190,"kind":13,"containerName":"create_node_on_branch","name":"$pos"},{"name":"$self","kind":13,"containerName":"create_node_on_branch","line":193},{"kind":12,"containerName":"create_node_on_branch","name":"throw","line":193},{"line":195,"name":"$self","containerName":"create_node_on_branch","kind":13},{"line":195,"name":"throw","containerName":"create_node_on_branch","kind":12},{"line":195,"kind":13,"containerName":"create_node_on_branch","name":"$newpos"},{"containerName":"create_node_on_branch","kind":13,"name":"$force","line":195},{"line":196,"name":"$self","kind":13,"containerName":"create_node_on_branch"},{"containerName":"create_node_on_branch","kind":12,"name":"throw","line":196},{"line":196,"name":"$newpos","containerName":"create_node_on_branch","kind":13},{"name":"$blen","containerName":"create_node_on_branch","kind":13,"line":196},{"line":196,"name":"$force","containerName":"create_node_on_branch","kind":13},{"line":199,"name":"$annot","containerName":"create_node_on_branch","kind":13},{"line":199,"name":"$blen","kind":13,"containerName":"create_node_on_branch"},{"containerName":"create_node_on_branch","kind":13,"name":"$newpos","line":199},{"definition":"my","line":200,"name":"$node","localvar":"my","kind":13,"containerName":"create_node_on_branch"},{"name":"new","containerName":"create_node_on_branch","kind":12,"line":200},{"line":200,"name":"$annot","containerName":"create_node_on_branch","kind":13},{"definition":"my","line":201,"name":"$anc","localvar":"my","kind":13,"containerName":"create_node_on_branch"},{"line":201,"kind":13,"containerName":"create_node_on_branch","name":"$self"},{"line":201,"name":"ancestor","kind":12,"containerName":"create_node_on_branch"},{"kind":13,"containerName":"create_node_on_branch","name":"$node","line":203},{"name":"add_Descendent","kind":12,"containerName":"create_node_on_branch","line":203},{"line":203,"name":"$self","containerName":"create_node_on_branch","kind":13},{"line":204,"containerName":"create_node_on_branch","kind":13,"name":"$anc"},{"kind":12,"containerName":"create_node_on_branch","name":"add_Descendent","line":204},{"name":"$node","containerName":"create_node_on_branch","kind":13,"line":204},{"kind":13,"containerName":"create_node_on_branch","name":"$anc","line":205},{"line":205,"containerName":"create_node_on_branch","kind":12,"name":"remove_Descendent"},{"name":"$self","containerName":"create_node_on_branch","kind":13,"line":205},{"name":"$self","containerName":"create_node_on_branch","kind":13,"line":206},{"line":206,"name":"branch_length","kind":12,"containerName":"create_node_on_branch"},{"line":206,"containerName":"create_node_on_branch","kind":13,"name":"$newpos"},{"containerName":"create_node_on_branch","kind":13,"name":"$node","line":207}],"name":"create_node_on_branch","containerName":"main::"},{"kind":12,"containerName":"Tree::Node","name":"Bio","line":200},{"detail":"($self,$node,$ignoreoverwrite)","definition":"sub","name":"add_Descendent","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"add_Descendent","name":"$self","line":225,"definition":"my"},{"line":225,"name":"$node","kind":13,"containerName":"add_Descendent"},{"line":225,"name":"$ignoreoverwrite","containerName":"add_Descendent","kind":13},{"line":226,"name":"$node","containerName":"add_Descendent","kind":13},{"line":228,"name":"$node","containerName":"add_Descendent","kind":13},{"containerName":"add_Descendent","kind":13,"name":"$node","line":229},{"containerName":"add_Descendent","kind":13,"name":"$node","line":230},{"name":"isa","containerName":"add_Descendent","kind":12,"line":230},{"kind":13,"containerName":"add_Descendent","name":"$self","line":231},{"containerName":"add_Descendent","kind":12,"name":"throw","line":231},{"name":"$self","containerName":"add_Descendent","kind":13,"line":235},{"name":"$node","containerName":"add_Descendent","kind":13,"line":237},{"name":"ancestor","kind":12,"containerName":"add_Descendent","line":237},{"containerName":"add_Descendent","kind":13,"name":"$self","line":237},{"line":237,"name":"$node","containerName":"add_Descendent","kind":13},{"line":238,"kind":13,"containerName":"add_Descendent","name":"$self"},{"kind":13,"containerName":"add_Descendent","name":"$self","line":240},{"name":"$node","containerName":"add_Descendent","kind":13,"line":240},{"kind":12,"containerName":"add_Descendent","name":"internal_id","line":240},{"name":"$ignoreoverwrite","kind":13,"containerName":"add_Descendent","line":240},{"name":"$self","kind":13,"containerName":"add_Descendent","line":241},{"line":241,"name":"throw","kind":12,"containerName":"add_Descendent"},{"name":"$self","kind":13,"containerName":"add_Descendent","line":243},{"containerName":"add_Descendent","kind":13,"name":"$node","line":243},{"containerName":"add_Descendent","kind":12,"name":"internal_id","line":243},{"kind":13,"containerName":"add_Descendent","name":"$node","line":243},{"containerName":"add_Descendent","kind":13,"name":"$self","line":245},{"line":245,"name":"invalidate_height","kind":12,"containerName":"add_Descendent"},{"line":247,"containerName":"add_Descendent","kind":13,"name":"$self"}],"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$node"},{"label":"$ignoreoverwrite"}],"label":"add_Descendent($self,$node,$ignoreoverwrite)"},"kind":12,"range":{"start":{"character":0,"line":224},"end":{"line":247,"character":9999}},"line":224},{"kind":12,"name":"_adding_descendent","line":235},{"line":237,"name":"_setting_ancestor","kind":12},{"kind":12,"name":"_adding_descendent","line":238},{"detail":"($self,$sortby)","definition":"sub","name":"each_Descendent","containerName":"main::","children":[{"line":263,"name":"$self","localvar":"my","kind":13,"containerName":"each_Descendent","definition":"my"},{"line":263,"name":"$sortby","containerName":"each_Descendent","kind":13},{"line":266,"containerName":"each_Descendent","kind":13,"name":"$sortby"},{"line":267,"name":"$sortby","containerName":"each_Descendent","kind":13},{"definition":"my","line":268,"localvar":"my","containerName":"each_Descendent","kind":13,"name":"@values"},{"name":"$sortby","containerName":"each_Descendent","kind":13,"line":268},{"line":268,"name":"$a","kind":13,"containerName":"each_Descendent"},{"kind":13,"containerName":"each_Descendent","name":"$b","line":268},{"name":"$self","containerName":"each_Descendent","kind":13,"line":268},{"name":"@values","containerName":"each_Descendent","kind":13,"line":269}],"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$sortby"}],"label":"each_Descendent($self,$sortby)"},"kind":12,"range":{"end":{"character":9999,"line":270},"start":{"line":262,"character":0}},"line":262},{"line":270,"kind":13,"containerName":null,"name":"%sortby"},{"name":"@a","kind":13,"containerName":null,"line":272},{"line":272,"name":"@b","kind":13,"containerName":null},{"line":273,"name":"@a","kind":13,"containerName":null},{"line":273,"kind":13,"containerName":null,"name":"@b"},{"line":274,"name":"height","kind":12,"containerName":"main::"},{"line":274,"name":"internal_id","containerName":"main::","kind":12},{"containerName":null,"kind":13,"name":"%self","line":275},{"line":276,"kind":13,"containerName":null,"name":"%sortby"},{"line":277,"containerName":null,"localvar":"my","kind":13,"name":"@set","definition":"my"},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$v","line":278},{"line":278,"containerName":null,"kind":13,"name":"%self"},{"kind":13,"containerName":null,"name":"$v","line":279},{"name":"is_Leaf","containerName":"main::","kind":12,"line":279},{"line":280,"name":"@lst","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"name":"$a","containerName":null,"kind":13,"line":280},{"kind":13,"containerName":null,"name":"%b","line":280},{"name":"id","containerName":"main::","kind":12,"line":280},{"line":281,"kind":12,"containerName":"main::","name":"is_Leaf"},{"name":"$v","kind":13,"containerName":null,"line":282},{"line":282,"kind":12,"containerName":"main::","name":"get_all_Descendents"},{"line":282,"name":"$sortby","kind":13,"containerName":null},{"name":"@set","kind":13,"containerName":null,"line":283},{"kind":13,"containerName":null,"name":"$v","line":283},{"containerName":null,"kind":13,"name":"@lst","line":283},{"name":"$v","containerName":null,"kind":13,"line":283},{"line":283,"name":"internal_id","containerName":"main::","kind":12},{"line":285,"name":"@set","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$v","line":285},{"line":285,"name":"$v","kind":13,"containerName":null},{"line":285,"kind":12,"containerName":"main::","name":"id"},{"containerName":null,"kind":13,"name":"$v","line":285},{"line":285,"name":"internal_id","kind":12,"containerName":"main::"},{"line":289,"name":"@a","kind":13,"containerName":null},{"line":289,"kind":13,"containerName":null,"name":"@b"},{"line":289,"kind":13,"containerName":null,"name":"@a"},{"line":289,"name":"@b","kind":13,"containerName":null},{"line":289,"kind":13,"containerName":null,"name":"@set"},{"line":290,"name":"%sortby","kind":13,"containerName":null},{"line":291,"containerName":null,"localvar":"my","kind":13,"name":"@set","definition":"my"},{"name":"$v","localvar":"my","kind":13,"containerName":null,"line":292,"definition":"my"},{"containerName":null,"kind":13,"name":"%self","line":292},{"name":"$v","kind":13,"containerName":null,"line":293},{"kind":12,"containerName":"main::","name":"id","line":293},{"line":294,"kind":13,"containerName":null,"name":"$v"},{"line":294,"kind":12,"containerName":"main::","name":"is_Leaf"},{"definition":"my","line":295,"name":"%l","localvar":"my","kind":13,"containerName":null},{"line":295,"name":"$b","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%a","line":295},{"name":"id","containerName":"main::","kind":12,"line":295},{"line":296,"name":"is_Leaf","containerName":"main::","kind":12},{"line":297,"name":"$v","containerName":null,"kind":13},{"line":297,"name":"get_all_Descendents","containerName":"main::","kind":12},{"line":297,"name":"$sortby","containerName":null,"kind":13},{"line":298,"kind":13,"containerName":null,"name":"@set"},{"kind":13,"containerName":null,"name":"$v","line":298},{"containerName":null,"kind":13,"name":"$l","line":298},{"containerName":null,"kind":13,"name":"$v","line":298},{"name":"internal_id","kind":12,"containerName":"main::","line":298},{"line":300,"kind":13,"containerName":null,"name":"@set"},{"line":300,"name":"$v","kind":13,"containerName":null},{"name":"$v","kind":13,"containerName":null,"line":300},{"line":300,"kind":12,"containerName":"main::","name":"id"},{"name":"$v","kind":13,"containerName":null,"line":300},{"containerName":"main::","kind":12,"name":"internal_id","line":300},{"containerName":null,"kind":13,"name":"@b","line":304},{"kind":13,"containerName":null,"name":"@a","line":304},{"line":304,"containerName":null,"kind":13,"name":"@b"},{"name":"@a","kind":13,"containerName":null,"line":304},{"name":"@set","containerName":null,"kind":13,"line":304},{"containerName":null,"kind":13,"name":"@a","line":307},{"line":307,"name":"@b","containerName":null,"kind":13},{"name":"internal_id","kind":12,"containerName":"main::","line":308},{"line":309,"name":"%self","containerName":null,"kind":13},{"name":"remove_Descendent","containerName":"main::","children":[{"name":"$self","containerName":"remove_Descendent","localvar":"my","kind":13,"line":325,"definition":"my"},{"line":325,"containerName":"remove_Descendent","kind":13,"name":"@nodes"},{"line":326,"name":"$c","kind":13,"localvar":"my","containerName":"remove_Descendent","definition":"my"},{"definition":"my","line":327,"name":"$n","localvar":"my","containerName":"remove_Descendent","kind":13},{"containerName":"remove_Descendent","kind":13,"name":"@nodes","line":327},{"line":328,"name":"$self","containerName":"remove_Descendent","kind":13},{"kind":13,"containerName":"remove_Descendent","name":"$n","line":328},{"name":"internal_id","kind":12,"containerName":"remove_Descendent","line":328},{"line":329,"name":"$self","kind":13,"containerName":"remove_Descendent"},{"containerName":"remove_Descendent","kind":13,"name":"$n","line":330},{"kind":12,"containerName":"remove_Descendent","name":"ancestor","line":330},{"name":"$self","kind":13,"containerName":"remove_Descendent","line":331},{"name":"$self","kind":13,"containerName":"remove_Descendent","line":333},{"name":"$n","kind":13,"containerName":"remove_Descendent","line":333},{"kind":12,"containerName":"remove_Descendent","name":"internal_id","line":333},{"name":"ancestor","kind":12,"containerName":"remove_Descendent","line":333},{"line":334,"kind":13,"containerName":"remove_Descendent","name":"$self"},{"line":334,"containerName":"remove_Descendent","kind":13,"name":"$n"},{"line":334,"name":"internal_id","kind":12,"containerName":"remove_Descendent"},{"kind":13,"containerName":"remove_Descendent","name":"$c","line":335},{"line":337,"containerName":"remove_Descendent","kind":13,"name":"$self"},{"name":"verbose","containerName":"remove_Descendent","kind":12,"line":337},{"line":338,"name":"$self","kind":13,"containerName":"remove_Descendent"},{"name":"debug","kind":12,"containerName":"remove_Descendent","line":338},{"kind":13,"containerName":"remove_Descendent","name":"$n","line":338},{"line":338,"name":"id","kind":12,"containerName":"remove_Descendent"},{"line":338,"name":"$n","kind":13,"containerName":"remove_Descendent"},{"containerName":"remove_Descendent","kind":13,"name":"$self","line":338},{"kind":12,"containerName":"remove_Descendent","name":"id","line":338},{"kind":13,"containerName":"remove_Descendent","name":"$self","line":338},{"line":339,"name":"$self","containerName":"remove_Descendent","kind":13},{"line":339,"kind":12,"containerName":"remove_Descendent","name":"debug"},{"name":"$self","containerName":"remove_Descendent","kind":13,"line":339}],"detail":"($self,@nodes)","definition":"sub","range":{"end":{"character":9999,"line":342},"start":{"character":0,"line":324}},"kind":12,"line":324,"signature":{"label":"remove_Descendent($self,@nodes)","documentation":"","parameters":[{"label":"$self"},{"label":"@nodes"}]}},{"line":329,"kind":12,"name":"_removing_descendent"},{"line":331,"kind":12,"name":"_removing_descendent"},{"containerName":null,"kind":13,"name":"$c","line":343},{"children":[{"containerName":"remove_all_Descendents","localvar":"my","kind":13,"name":"$self","line":360,"definition":"my"},{"line":363,"containerName":"remove_all_Descendents","localvar":"my","kind":13,"name":"$node","definition":"my"},{"line":363,"name":"$val","containerName":"remove_all_Descendents","kind":13},{"line":363,"name":"$self","kind":13,"containerName":"remove_all_Descendents"}],"name":"remove_all_Descendents","containerName":"main::","definition":"sub","detail":"($self)","line":359,"range":{"start":{"line":359,"character":0},"end":{"character":9999,"line":363}},"kind":12,"signature":{"label":"remove_all_Descendents($self)","parameters":[{"label":"$self"}],"documentation":""}},{"line":364,"containerName":null,"kind":13,"name":"$val"},{"kind":12,"containerName":"main::","name":"ancestor","line":364},{"line":366,"name":"%self","kind":13,"containerName":null},{"definition":"sub","containerName":"main::","name":"ancestor","children":[{"definition":"my","line":394,"kind":13,"localvar":"my","containerName":"ancestor","name":"$self"},{"name":"$new_ancestor","localvar":"my","kind":13,"containerName":"ancestor","line":396,"definition":"my"},{"line":399,"name":"$new_ancestor","kind":13,"containerName":"ancestor"},{"line":400,"name":"$self","containerName":"ancestor","kind":13},{"containerName":"ancestor","kind":12,"name":"throw","line":400},{"line":401,"name":"$new_ancestor","kind":13,"containerName":"ancestor"},{"line":401,"name":"isa","containerName":"ancestor","kind":12},{"definition":"my","name":"$old_ancestor","localvar":"my","containerName":"ancestor","kind":13,"line":404},{"line":404,"name":"$self","kind":13,"containerName":"ancestor"},{"line":405,"kind":13,"containerName":"ancestor","name":"$old_ancestor"},{"name":"$old_ancestor","kind":13,"containerName":"ancestor","line":406},{"name":"$new_ancestor","kind":13,"containerName":"ancestor","line":406},{"line":407,"containerName":"ancestor","kind":13,"name":"$new_ancestor"},{"name":"$old_ancestor","containerName":"ancestor","kind":13,"line":407},{"line":408,"name":"$old_ancestor","containerName":"ancestor","kind":13},{"kind":13,"containerName":"ancestor","name":"$old_ancestor","line":408},{"containerName":"ancestor","kind":13,"name":"$old_ancestor","line":409},{"name":"remove_Descendent","containerName":"ancestor","kind":12,"line":409},{"line":409,"name":"$self","kind":13,"containerName":"ancestor"},{"containerName":"ancestor","kind":13,"name":"$new_ancestor","line":411},{"name":"$new_ancestor","kind":13,"containerName":"ancestor","line":412},{"line":413,"containerName":"ancestor","kind":13,"name":"$self"},{"line":414,"name":"$new_ancestor","kind":13,"containerName":"ancestor"},{"line":414,"name":"add_Descendent","kind":12,"containerName":"ancestor"},{"line":414,"kind":13,"containerName":"ancestor","name":"$self"},{"line":415,"name":"$self","kind":13,"containerName":"ancestor"},{"line":418,"name":"$self","containerName":"ancestor","kind":13},{"name":"$new_ancestor","containerName":"ancestor","kind":13,"line":418},{"name":"$self","kind":13,"containerName":"ancestor","line":421}],"kind":12,"range":{"end":{"character":9999,"line":422},"start":{"character":0,"line":393}},"line":393},{"line":408,"name":"_removing_descendent","kind":12},{"kind":12,"name":"_adding_descendent","line":412},{"kind":12,"name":"_setting_ancestor","line":413},{"kind":12,"name":"_setting_ancestor","line":415},{"line":418,"name":"weaken","kind":12},{"containerName":"main::","name":"branch_length","children":[{"line":435,"localvar":"my","kind":13,"containerName":"branch_length","name":"$self","definition":"my"},{"line":437,"localvar":"my","kind":13,"containerName":"branch_length","name":"$bl","definition":"my"},{"kind":13,"containerName":"branch_length","name":"$bl","line":438},{"line":439,"name":"$bl","containerName":"branch_length","kind":13},{"kind":13,"containerName":"branch_length","name":"$self","line":440},{"line":440,"containerName":"branch_length","kind":12,"name":"bootstrap"},{"line":442,"containerName":"branch_length","kind":13,"name":"$self"},{"line":442,"name":"$bl","containerName":"branch_length","kind":13},{"line":443,"kind":13,"containerName":"branch_length","name":"$self"},{"name":"invalidate_height","kind":12,"containerName":"branch_length","line":443},{"name":"$self","containerName":"branch_length","kind":13,"line":445}],"definition":"sub","range":{"start":{"line":434,"character":0},"end":{"character":9999,"line":446}},"kind":12,"line":434},{"kind":12,"range":{"start":{"character":0,"line":458},"end":{"line":467,"character":9999}},"line":458,"name":"bootstrap","containerName":"main::","children":[{"containerName":"bootstrap","localvar":"my","kind":13,"name":"$self","line":459,"definition":"my"},{"line":461,"name":"$self","containerName":"bootstrap","kind":13},{"line":461,"name":"has_tag","kind":12,"containerName":"bootstrap"},{"line":462,"kind":13,"containerName":"bootstrap","name":"$self"},{"line":462,"name":"remove_tag","containerName":"bootstrap","kind":12},{"name":"$self","containerName":"bootstrap","kind":13,"line":464},{"name":"add_tag_value","containerName":"bootstrap","kind":12,"line":464},{"containerName":"bootstrap","kind":13,"name":"$self","line":466},{"containerName":"bootstrap","kind":12,"name":"get_tag_values","line":466}],"definition":"sub"},{"containerName":"main::","name":"description","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"description","kind":13,"line":480},{"name":"$self","kind":13,"containerName":"description","line":481},{"name":"$self","containerName":"description","kind":13,"line":482}],"definition":"sub","kind":12,"range":{"start":{"line":479,"character":0},"end":{"line":483,"character":9999}},"line":479},{"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$value"}],"label":"id($self,$value)"},"line":508,"range":{"end":{"line":517,"character":9999},"start":{"line":508,"character":0}},"kind":12,"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","line":509,"localvar":"my","kind":13,"containerName":"id","name":"$self"},{"line":509,"name":"$value","kind":13,"containerName":"id"},{"line":510,"containerName":"id","kind":13,"name":"$value"},{"kind":13,"containerName":"id","name":"$self","line":514},{"kind":13,"containerName":"id","name":"$value","line":514},{"line":516,"kind":13,"containerName":"id","name":"$self"}],"containerName":"main::","name":"id"},{"containerName":"main::","name":"internal_id","children":[{"line":551,"containerName":"internal_id","kind":12,"name":"_creation_id"}],"definition":"sub","range":{"start":{"character":0,"line":550},"end":{"character":9999,"line":552}},"kind":12,"line":550},{"definition":"sub","children":[{"line":565,"name":"$self","containerName":"_creation_id","localvar":"my","kind":13,"definition":"my"},{"containerName":"_creation_id","kind":13,"name":"$self","line":566},{"line":567,"name":"$self","containerName":"_creation_id","kind":13}],"containerName":"main::","name":"_creation_id","line":564,"kind":12,"range":{"start":{"line":564,"character":0},"end":{"line":568,"character":9999}}},{"detail":"($self)","definition":"sub","name":"is_Leaf","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"is_Leaf","name":"$self","line":586,"definition":"my"},{"line":587,"containerName":"is_Leaf","localvar":"my","kind":13,"name":"$isleaf","definition":"my"},{"kind":13,"containerName":"is_Leaf","name":"$self","line":587},{"name":"$self","containerName":"is_Leaf","kind":13,"line":588}],"signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"is_Leaf($self)"},"range":{"start":{"character":0,"line":585},"end":{"character":9999,"line":588}},"kind":12,"line":585},{"kind":13,"containerName":null,"name":"$isleaf","line":589},{"signature":{"label":"height($self)","parameters":[{"label":"$self"}],"documentation":""},"range":{"start":{"line":603,"character":0},"end":{"character":9999,"line":616}},"kind":12,"line":603,"detail":"($self)","definition":"sub","containerName":"main::","name":"height","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"height","kind":13,"line":604},{"line":605,"kind":13,"containerName":"height","name":"$self"},{"name":"$self","containerName":"height","kind":13,"line":605},{"line":607,"name":"$self","containerName":"height","kind":13},{"line":607,"containerName":"height","kind":12,"name":"is_Leaf"},{"definition":"my","line":608,"containerName":"height","localvar":"my","kind":13,"name":"$max"},{"name":"$subnode","localvar":"my","kind":13,"containerName":"height","line":609,"definition":"my"},{"name":"$self","kind":13,"containerName":"height","line":609},{"name":"each_Descendent","containerName":"height","kind":12,"line":609},{"line":610,"containerName":"height","localvar":"my","kind":13,"name":"$bl","definition":"my"},{"line":610,"containerName":"height","kind":13,"name":"$subnode"},{"line":610,"kind":12,"containerName":"height","name":"branch_length"},{"line":611,"containerName":"height","kind":13,"name":"$bl"},{"name":"$bl","kind":13,"containerName":"height","line":611},{"containerName":"height","kind":13,"name":"$bl","line":611},{"line":612,"name":"$s","containerName":"height","localvar":"my","kind":13,"definition":"my"},{"line":612,"name":"$subnode","kind":13,"containerName":"height"},{"line":612,"name":"height","kind":12,"containerName":"height"},{"kind":13,"containerName":"height","name":"$bl","line":612},{"kind":13,"containerName":"height","name":"$s","line":613},{"kind":13,"containerName":"height","name":"$max","line":613},{"name":"$max","containerName":"height","kind":13,"line":613},{"line":613,"kind":13,"containerName":"height","name":"$s"},{"name":"$self","kind":13,"containerName":"height","line":615},{"containerName":"height","kind":13,"name":"$max","line":615}]},{"definition":"sub","detail":"($self)","children":[{"kind":13,"localvar":"my","containerName":"invalidate_height","name":"$self","line":629,"definition":"my"},{"line":631,"containerName":"invalidate_height","kind":13,"name":"$self"},{"line":632,"containerName":"invalidate_height","kind":13,"name":"$self"},{"line":632,"kind":12,"containerName":"invalidate_height","name":"ancestor"},{"kind":13,"containerName":"invalidate_height","name":"$self","line":633},{"name":"ancestor","containerName":"invalidate_height","kind":12,"line":633},{"line":633,"name":"invalidate_height","containerName":"invalidate_height","kind":12}],"name":"invalidate_height","containerName":"main::","signature":{"label":"invalidate_height($self)","parameters":[{"label":"$self"}],"documentation":""},"line":628,"kind":12,"range":{"end":{"line":635,"character":9999},"start":{"line":628,"character":0}}},{"kind":12,"range":{"end":{"character":9999,"line":655},"start":{"line":649,"character":0}},"line":649,"signature":{"label":"set_tag_value($self,$tag,@values)","parameters":[{"label":"$self"},{"label":"$tag"},{"label":"@values"}],"documentation":""},"containerName":"main::","name":"set_tag_value","children":[{"definition":"my","line":650,"kind":13,"localvar":"my","containerName":"set_tag_value","name":"$self"},{"containerName":"set_tag_value","kind":13,"name":"$tag","line":650},{"name":"@values","kind":13,"containerName":"set_tag_value","line":650},{"line":651,"kind":13,"containerName":"set_tag_value","name":"$tag"},{"containerName":"set_tag_value","kind":13,"name":"@values","line":651},{"line":652,"name":"$self","containerName":"set_tag_value","kind":13},{"line":652,"name":"warn","kind":12,"containerName":"set_tag_value"},{"containerName":"set_tag_value","kind":13,"name":"$self","line":654},{"line":654,"kind":12,"containerName":"set_tag_value","name":"remove_tag"},{"name":"$tag","containerName":"set_tag_value","kind":13,"line":654},{"line":655,"containerName":"set_tag_value","kind":13,"name":"$self"},{"containerName":"set_tag_value","kind":13,"name":"$tag","line":655}],"detail":"($self,$tag,@values)","definition":"sub"},{"line":655,"kind":13,"containerName":null,"name":"@values"},{"name":"%self","containerName":null,"kind":13,"line":656},{"name":"$tag","containerName":null,"kind":13,"line":656},{"line":671,"kind":12,"range":{"start":{"character":0,"line":671},"end":{"line":677,"character":9999}},"signature":{"label":"add_tag_value($self,$tag,$value)","documentation":"","parameters":[{"label":"$self"},{"label":"$tag"},{"label":"$value"}]},"children":[{"definition":"my","line":672,"localvar":"my","containerName":"add_tag_value","kind":13,"name":"$self"},{"line":672,"name":"$tag","containerName":"add_tag_value","kind":13},{"line":672,"name":"$value","kind":13,"containerName":"add_tag_value"},{"name":"$tag","kind":13,"containerName":"add_tag_value","line":673},{"line":673,"containerName":"add_tag_value","kind":13,"name":"$value"},{"line":674,"containerName":"add_tag_value","kind":13,"name":"$self"},{"containerName":"add_tag_value","kind":12,"name":"warn","line":674},{"name":"$tag","containerName":"add_tag_value","kind":13,"line":674},{"name":"$self","containerName":"add_tag_value","kind":13,"line":675},{"name":"warn","containerName":"add_tag_value","kind":12,"line":675},{"name":"$self","kind":13,"containerName":"add_tag_value","line":675},{"line":675,"name":"stack_trace_dump","kind":12,"containerName":"add_tag_value"},{"kind":13,"containerName":"add_tag_value","name":"$self","line":677},{"name":"$tag","containerName":"add_tag_value","kind":13,"line":677}],"containerName":"main::","name":"add_tag_value","definition":"sub","detail":"($self,$tag,$value)"},{"line":677,"name":"$value","containerName":null,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":678},{"line":678,"name":"$tag","kind":13,"containerName":null},{"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$tag"}],"label":"remove_tag($self,$tag)"},"line":692,"range":{"end":{"character":9999,"line":700},"start":{"line":692,"character":0}},"kind":12,"definition":"sub","detail":"($self,$tag)","children":[{"definition":"my","name":"$self","containerName":"remove_tag","localvar":"my","kind":13,"line":693},{"line":693,"kind":13,"containerName":"remove_tag","name":"$tag"},{"line":694,"name":"$self","kind":13,"containerName":"remove_tag"},{"name":"$tag","containerName":"remove_tag","kind":13,"line":694},{"line":695,"containerName":"remove_tag","kind":13,"name":"$self"},{"line":695,"name":"$tag","kind":13,"containerName":"remove_tag"},{"containerName":"remove_tag","kind":13,"name":"$self","line":696},{"name":"$tag","containerName":"remove_tag","kind":13,"line":696}],"containerName":"main::","name":"remove_tag"},{"detail":"($self)","definition":"sub","containerName":"main::","name":"remove_all_tags","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"remove_all_tags","name":"$self","line":713},{"name":"$self","containerName":"remove_all_tags","kind":13,"line":714}],"signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"remove_all_tags($self)"},"kind":12,"range":{"start":{"line":712,"character":0},"end":{"character":9999,"line":716}},"line":712},{"detail":"($self)","definition":"sub","name":"get_all_tags","containerName":"main::","children":[{"definition":"my","line":729,"localvar":"my","containerName":"get_all_tags","kind":13,"name":"$self"},{"definition":"my","line":730,"name":"@tags","containerName":"get_all_tags","localvar":"my","kind":13},{"line":730,"name":"$self","containerName":"get_all_tags","kind":13}],"signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"get_all_tags($self)"},"kind":12,"range":{"start":{"line":728,"character":0},"end":{"line":730,"character":9999}},"line":728},{"name":"@tags","containerName":null,"kind":13,"line":731},{"name":"get_tag_values","containerName":"main::","children":[{"definition":"my","line":747,"containerName":"get_tag_values","localvar":"my","kind":13,"name":"$self"},{"name":"$tag","kind":13,"containerName":"get_tag_values","line":747},{"line":748,"name":"$self","containerName":"get_tag_values","kind":13},{"containerName":"get_tag_values","kind":13,"name":"$tag","line":748}],"detail":"($self,$tag)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":746},"end":{"line":748,"character":9999}},"line":746,"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$tag"}],"label":"get_tag_values($self,$tag)"}},{"line":749,"containerName":null,"kind":13,"name":"%self"},{"line":749,"name":"@tag","containerName":null,"kind":13},{"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$tag"}],"label":"has_tag($self,$tag)"},"line":762,"range":{"end":{"line":765,"character":9999},"start":{"line":762,"character":0}},"kind":12,"definition":"sub","detail":"($self,$tag)","children":[{"definition":"my","line":763,"kind":13,"localvar":"my","containerName":"has_tag","name":"$self"},{"kind":13,"containerName":"has_tag","name":"$tag","line":763},{"name":"$self","kind":13,"containerName":"has_tag","line":764},{"containerName":"has_tag","kind":13,"name":"$tag","line":764}],"containerName":"main::","name":"has_tag"},{"range":{"start":{"character":0,"line":767},"end":{"character":9999,"line":779}},"kind":12,"line":767,"name":"node_cleanup","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"node_cleanup","name":"$self","line":768},{"kind":13,"containerName":"node_cleanup","name":"$self","line":769},{"name":"$self","kind":13,"containerName":"node_cleanup","line":773},{"line":774,"name":"$self","kind":13,"containerName":"node_cleanup"},{"line":775,"kind":13,"localvar":"my","containerName":"node_cleanup","name":"$nodeid","definition":"my"},{"name":"$node","containerName":"node_cleanup","kind":13,"line":775},{"line":775,"name":"$self","containerName":"node_cleanup","kind":13},{"line":776,"name":"$node","kind":13,"containerName":"node_cleanup"},{"name":"ancestor","kind":12,"containerName":"node_cleanup","line":776},{"line":777,"name":"$node","containerName":"node_cleanup","kind":13}],"definition":"sub"},{"line":780,"name":"%self","kind":13,"containerName":null},{"children":[{"definition":"my","line":795,"name":"$self","localvar":"my","containerName":"reverse_edge","kind":13},{"name":"$node","containerName":"reverse_edge","kind":13,"line":795},{"name":"$self","kind":13,"containerName":"reverse_edge","line":796},{"kind":12,"containerName":"reverse_edge","name":"delete_edge","line":796},{"name":"$node","kind":13,"containerName":"reverse_edge","line":796},{"line":797,"name":"$node","containerName":"reverse_edge","kind":13},{"name":"add_Descendent","containerName":"reverse_edge","kind":12,"line":797},{"kind":13,"containerName":"reverse_edge","name":"$self","line":797}],"name":"reverse_edge","containerName":"main::","definition":"sub","detail":"($self,$node)","line":794,"range":{"end":{"line":801,"character":9999},"start":{"line":794,"character":0}},"kind":12,"signature":{"label":"reverse_edge($self,$node)","documentation":"","parameters":[{"label":"$self"},{"label":"$node"}]}}],"version":5}