{"version":5,"vars":[{"line":86,"name":"base","kind":2,"containerName":""},{"kind":2,"containerName":"","name":"vars","line":88},{"containerName":null,"kind":13,"name":"$GeneTag","line":89},{"line":89,"kind":13,"containerName":null,"name":"$SrcTag"},{"name":"$ExonTag","containerName":null,"kind":13,"line":89},{"name":"_initialize","containerName":"main::","children":[{"line":106,"localvar":"my","kind":13,"containerName":"_initialize","name":"$self","definition":"my"},{"line":106,"kind":13,"containerName":"_initialize","name":"@args"},{"name":"$self","containerName":"_initialize","kind":13,"line":107},{"kind":13,"containerName":"_initialize","name":"@args","line":107},{"definition":"my","containerName":"_initialize","localvar":"my","kind":13,"name":"$genetag","line":108},{"name":"$exontag","containerName":"_initialize","kind":13,"line":108},{"kind":13,"containerName":"_initialize","name":"$srctag","line":108},{"line":108,"kind":13,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","kind":13,"name":"@args","line":111},{"name":"$self","containerName":"_initialize","kind":13,"line":112},{"name":"gene_tag","kind":12,"containerName":"_initialize","line":112},{"kind":13,"containerName":"_initialize","name":"$genetag","line":112},{"line":112,"kind":13,"containerName":"_initialize","name":"$genetag"},{"line":112,"name":"$GeneTag","kind":13,"containerName":"_initialize"},{"line":113,"kind":13,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","kind":12,"name":"source_tag","line":113},{"name":"$srctag","containerName":"_initialize","kind":13,"line":113},{"containerName":"_initialize","kind":13,"name":"$srctag","line":113},{"line":113,"kind":13,"containerName":"_initialize","name":"$SrcTag"},{"name":"$self","containerName":"_initialize","kind":13,"line":114},{"kind":12,"containerName":"_initialize","name":"exon_tag","line":114},{"line":114,"containerName":"_initialize","kind":13,"name":"$exontag"},{"containerName":"_initialize","kind":13,"name":"$exontag","line":114},{"line":114,"containerName":"_initialize","kind":13,"name":"$ExonTag"},{"line":115,"name":"$self","kind":13,"containerName":"_initialize"}],"detail":"($self,@args)","definition":"sub","kind":12,"range":{"start":{"line":105,"character":0},"end":{"line":116,"character":9999}},"line":105,"signature":{"documentation":"1;\n# $Id: tRNAscanSE.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::tRNAscanSE\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::tRNAscanSE - A parser for tRNAscan-SE output\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::tRNAscanSE;\n\n   my $parser = Bio::Tools::tRNAscanSE->new(-file => 'result.tRNAscanSE');\n\n   # parse the results\n   while( my $gene = $parser->next_prediction ) {\n\n       @exon_arr = $gene->get_SeqFeatures();\n\n   }\n\n=head1 DESCRIPTION\n\nThis script will parse tRNAscan-SE output.  Just the tabular output of\nthe tRNA locations in the genome for now.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::tRNAscanSE;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nuse vars qw($GeneTag $SrcTag $ExonTag);\n($GeneTag,$SrcTag,$ExonTag) = qw(gene tRNAscan-SE exon);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::tRNAscanSE->new();\n Function: Builds a new Bio::Tools::tRNAscanSE object \n Returns : an instance of Bio::Tools::tRNAscanSE\n Args    : -fh/-file for input filename\n           -genetag => primary tag used in gene features (default 'tRNA_gene')\n           -exontag => primary tag used in exon features (default 'tRNA_exon')\n           -srctag  => source tag used in all features (default 'tRNAscan-SE')","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_initialize($self,@args)"}},{"kind":12,"containerName":"_initialize","name":"SUPER","line":107},{"line":108,"kind":12,"containerName":"_rearrange","name":"SUPER"},{"line":130,"range":{"start":{"line":130,"character":0},"end":{"character":9999,"line":135}},"kind":12,"definition":"sub","children":[{"definition":"my","line":131,"kind":13,"localvar":"my","containerName":"gene_tag","name":"$self"},{"name":"$self","kind":13,"containerName":"gene_tag","line":133},{"kind":13,"containerName":"gene_tag","name":"$self","line":134}],"containerName":"main::","name":"gene_tag"},{"children":[{"kind":13,"localvar":"my","containerName":"source_tag","name":"$self","line":150,"definition":"my"},{"name":"$self","containerName":"source_tag","kind":13,"line":152},{"name":"$self","containerName":"source_tag","kind":13,"line":153}],"containerName":"main::","name":"source_tag","definition":"sub","line":149,"kind":12,"range":{"end":{"line":154,"character":9999},"start":{"character":0,"line":149}}},{"definition":"sub","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"exon_tag","line":169,"definition":"my"},{"name":"$self","kind":13,"containerName":"exon_tag","line":171},{"line":172,"kind":13,"containerName":"exon_tag","name":"$self"}],"name":"exon_tag","containerName":"main::","line":168,"range":{"start":{"line":168,"character":0},"end":{"line":173,"character":9999}},"kind":12},{"signature":{"parameters":[{"label":"$self"},{"label":"$method"}],"documentation":"1;\n# $Id: tRNAscanSE.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::tRNAscanSE\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::tRNAscanSE - A parser for tRNAscan-SE output\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::tRNAscanSE;\n\n   my $parser = Bio::Tools::tRNAscanSE->new(-file => 'result.tRNAscanSE');\n\n   # parse the results\n   while( my $gene = $parser->next_prediction ) {\n\n       @exon_arr = $gene->get_SeqFeatures();\n\n   }\n\n=head1 DESCRIPTION\n\nThis script will parse tRNAscan-SE output.  Just the tabular output of\nthe tRNA locations in the genome for now.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::tRNAscanSE;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nuse vars qw($GeneTag $SrcTag $ExonTag);\n($GeneTag,$SrcTag,$ExonTag) = qw(gene tRNAscan-SE exon);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::tRNAscanSE->new();\n Function: Builds a new Bio::Tools::tRNAscanSE object \n Returns : an instance of Bio::Tools::tRNAscanSE\n Args    : -fh/-file for input filename\n           -genetag => primary tag used in gene features (default 'tRNA_gene')\n           -exontag => primary tag used in exon features (default 'tRNA_exon')\n           -srctag  => source tag used in all features (default 'tRNAscan-SE')\n\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  my ($genetag,$exontag,$srctag) =  $self->SUPER::_rearrange([qw(GENETAG\n\t\t\t\t\t\t\t\t SRCTAG\n\t\t\t\t\t\t\t\t EXONTAG)],\n\t\t\t\t\t\t\t      @args);\n  $self->gene_tag(defined $genetag ? $genetag : $GeneTag);\n  $self->source_tag(defined $srctag ? $srctag : $SrcTag);\n  $self->exon_tag(defined $exontag ? $exontag : $ExonTag);\n  $self->{'_seen'} = {};\n}\n\n=head2 gene_tag\n\n Title   : gene_tag\n Usage   : $obj->gene_tag($newval)\n Function: Get/Set the value used for the 'gene_tag' of genes\n           Default is 'tRNA_gene' as set by the global $GeneTag\n Returns : value of gene_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub gene_tag{\n    my $self = shift;\n\n    return $self->{'gene_tag'} = shift if @_;\n    return $self->{'gene_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $obj->source_tag($newval)\n Function: Get/Set the value used for the 'source_tag' of exons and genes\n           Default is 'tRNAscan-SE' as set by the global $SrcTag\n Returns : value of source_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub source_tag{\n    my $self = shift;\n\n    return $self->{'_source_tag'} = shift if @_;\n    return $self->{'_source_tag'};\n}\n\n=head2 exon_tag\n\n Title   : exon_tag\n Usage   : $obj->exon_tag($newval)\n Function: Get/Set the value used for the 'primary_tag' of exons\n           Default is 'tRNA_exon' as set by the global $ExonTag\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub exon_tag{\n    my $self = shift;\n\n    return $self->{'_exon_tag'} = shift if @_;\n    return $self->{'_exon_tag'};\n}\n\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /tRNAscan-SE/i.\n Returns   : String\n Argument  : n/a","label":"analysis_method($self,$method)"},"line":187,"range":{"start":{"character":0,"line":187},"end":{"character":9999,"line":194}},"kind":12,"definition":"sub","detail":"($self,$method)","children":[{"name":"$self","containerName":"analysis_method","localvar":"my","kind":13,"line":189,"definition":"my"},{"kind":13,"containerName":"analysis_method","name":"$method","line":189},{"line":190,"name":"$method","containerName":"analysis_method","kind":13},{"kind":13,"containerName":"analysis_method","name":"$method","line":190},{"name":"$self","kind":13,"containerName":"analysis_method","line":191},{"line":191,"name":"throw","containerName":"analysis_method","kind":12},{"name":"$self","containerName":"analysis_method","kind":13,"line":191},{"name":"$self","containerName":"analysis_method","kind":13,"line":193},{"kind":13,"containerName":"analysis_method","name":"$method","line":193}],"name":"analysis_method","containerName":"main::"},{"name":"SUPER","kind":12,"containerName":"analysis_method","line":193},{"detail":"($self,@args)","definition":"sub","name":"next_feature","containerName":"main::","children":[{"containerName":"next_feature","localvar":"my","kind":13,"name":"$self","line":218,"definition":"my"},{"containerName":"next_feature","kind":13,"name":"@args","line":218},{"line":222,"kind":13,"containerName":"next_feature","name":"$self"},{"line":222,"kind":12,"containerName":"next_feature","name":"next_prediction"},{"line":222,"containerName":"next_feature","kind":13,"name":"@args"}],"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: tRNAscanSE.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::tRNAscanSE\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::tRNAscanSE - A parser for tRNAscan-SE output\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::tRNAscanSE;\n\n   my $parser = Bio::Tools::tRNAscanSE->new(-file => 'result.tRNAscanSE');\n\n   # parse the results\n   while( my $gene = $parser->next_prediction ) {\n\n       @exon_arr = $gene->get_SeqFeatures();\n\n   }\n\n=head1 DESCRIPTION\n\nThis script will parse tRNAscan-SE output.  Just the tabular output of\nthe tRNA locations in the genome for now.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::tRNAscanSE;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nuse vars qw($GeneTag $SrcTag $ExonTag);\n($GeneTag,$SrcTag,$ExonTag) = qw(gene tRNAscan-SE exon);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::tRNAscanSE->new();\n Function: Builds a new Bio::Tools::tRNAscanSE object \n Returns : an instance of Bio::Tools::tRNAscanSE\n Args    : -fh/-file for input filename\n           -genetag => primary tag used in gene features (default 'tRNA_gene')\n           -exontag => primary tag used in exon features (default 'tRNA_exon')\n           -srctag  => source tag used in all features (default 'tRNAscan-SE')\n\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  my ($genetag,$exontag,$srctag) =  $self->SUPER::_rearrange([qw(GENETAG\n\t\t\t\t\t\t\t\t SRCTAG\n\t\t\t\t\t\t\t\t EXONTAG)],\n\t\t\t\t\t\t\t      @args);\n  $self->gene_tag(defined $genetag ? $genetag : $GeneTag);\n  $self->source_tag(defined $srctag ? $srctag : $SrcTag);\n  $self->exon_tag(defined $exontag ? $exontag : $ExonTag);\n  $self->{'_seen'} = {};\n}\n\n=head2 gene_tag\n\n Title   : gene_tag\n Usage   : $obj->gene_tag($newval)\n Function: Get/Set the value used for the 'gene_tag' of genes\n           Default is 'tRNA_gene' as set by the global $GeneTag\n Returns : value of gene_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub gene_tag{\n    my $self = shift;\n\n    return $self->{'gene_tag'} = shift if @_;\n    return $self->{'gene_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $obj->source_tag($newval)\n Function: Get/Set the value used for the 'source_tag' of exons and genes\n           Default is 'tRNAscan-SE' as set by the global $SrcTag\n Returns : value of source_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub source_tag{\n    my $self = shift;\n\n    return $self->{'_source_tag'} = shift if @_;\n    return $self->{'_source_tag'};\n}\n\n=head2 exon_tag\n\n Title   : exon_tag\n Usage   : $obj->exon_tag($newval)\n Function: Get/Set the value used for the 'primary_tag' of exons\n           Default is 'tRNA_exon' as set by the global $ExonTag\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub exon_tag{\n    my $self = shift;\n\n    return $self->{'_exon_tag'} = shift if @_;\n    return $self->{'_exon_tag'};\n}\n\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /tRNAscan-SE/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /tRNAscan-SE/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $genscan->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genscan result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::SeqFeature::Generic object.\n Args    :\nSee also : L<Bio::SeqFeature::Generic>","label":"next_feature($self,@args)"},"kind":12,"range":{"end":{"line":223,"character":9999},"start":{"line":217,"character":0}},"line":217},{"line":241,"kind":12,"range":{"end":{"character":9999,"line":321},"start":{"character":0,"line":241}},"signature":{"documentation":"1;\n# $Id: tRNAscanSE.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::tRNAscanSE\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::tRNAscanSE - A parser for tRNAscan-SE output\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::tRNAscanSE;\n\n   my $parser = Bio::Tools::tRNAscanSE->new(-file => 'result.tRNAscanSE');\n\n   # parse the results\n   while( my $gene = $parser->next_prediction ) {\n\n       @exon_arr = $gene->get_SeqFeatures();\n\n   }\n\n=head1 DESCRIPTION\n\nThis script will parse tRNAscan-SE output.  Just the tabular output of\nthe tRNA locations in the genome for now.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::tRNAscanSE;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nuse vars qw($GeneTag $SrcTag $ExonTag);\n($GeneTag,$SrcTag,$ExonTag) = qw(gene tRNAscan-SE exon);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::tRNAscanSE->new();\n Function: Builds a new Bio::Tools::tRNAscanSE object \n Returns : an instance of Bio::Tools::tRNAscanSE\n Args    : -fh/-file for input filename\n           -genetag => primary tag used in gene features (default 'tRNA_gene')\n           -exontag => primary tag used in exon features (default 'tRNA_exon')\n           -srctag  => source tag used in all features (default 'tRNAscan-SE')\n\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  my ($genetag,$exontag,$srctag) =  $self->SUPER::_rearrange([qw(GENETAG\n\t\t\t\t\t\t\t\t SRCTAG\n\t\t\t\t\t\t\t\t EXONTAG)],\n\t\t\t\t\t\t\t      @args);\n  $self->gene_tag(defined $genetag ? $genetag : $GeneTag);\n  $self->source_tag(defined $srctag ? $srctag : $SrcTag);\n  $self->exon_tag(defined $exontag ? $exontag : $ExonTag);\n  $self->{'_seen'} = {};\n}\n\n=head2 gene_tag\n\n Title   : gene_tag\n Usage   : $obj->gene_tag($newval)\n Function: Get/Set the value used for the 'gene_tag' of genes\n           Default is 'tRNA_gene' as set by the global $GeneTag\n Returns : value of gene_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub gene_tag{\n    my $self = shift;\n\n    return $self->{'gene_tag'} = shift if @_;\n    return $self->{'gene_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $obj->source_tag($newval)\n Function: Get/Set the value used for the 'source_tag' of exons and genes\n           Default is 'tRNAscan-SE' as set by the global $SrcTag\n Returns : value of source_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub source_tag{\n    my $self = shift;\n\n    return $self->{'_source_tag'} = shift if @_;\n    return $self->{'_source_tag'};\n}\n\n=head2 exon_tag\n\n Title   : exon_tag\n Usage   : $obj->exon_tag($newval)\n Function: Get/Set the value used for the 'primary_tag' of exons\n           Default is 'tRNA_exon' as set by the global $ExonTag\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub exon_tag{\n    my $self = shift;\n\n    return $self->{'_exon_tag'} = shift if @_;\n    return $self->{'_exon_tag'};\n}\n\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /tRNAscan-SE/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /tRNAscan-SE/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $genscan->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genscan result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::SeqFeature::Generic object.\n Args    :\nSee also : L<Bio::SeqFeature::Generic>\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $genscan->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genscan result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::SeqFeature::Generic object.\n Args    :\nSee also : L<Bio::SeqFeature::Generic>","parameters":[{"label":"$self"}],"label":"next_prediction($self)"},"children":[{"line":242,"containerName":"next_prediction","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":243,"containerName":"next_prediction","localvar":"my","kind":13,"name":"$genetag","definition":"my"},{"line":243,"name":"$srctag","containerName":"next_prediction","kind":13},{"line":243,"name":"$exontag","containerName":"next_prediction","kind":13},{"name":"$self","containerName":"next_prediction","kind":13,"line":243},{"line":243,"containerName":"next_prediction","kind":12,"name":"gene_tag"},{"kind":13,"containerName":"next_prediction","name":"$self","line":244},{"line":244,"containerName":"next_prediction","kind":12,"name":"source_tag"},{"containerName":"next_prediction","kind":13,"name":"$self","line":245},{"line":245,"kind":12,"containerName":"next_prediction","name":"exon_tag"},{"kind":13,"containerName":"next_prediction","name":"$self","line":247},{"kind":12,"containerName":"next_prediction","name":"_readline","line":247},{"definition":"my","line":257,"name":"$seqid","localvar":"my","kind":13,"containerName":"next_prediction"},{"line":257,"name":"$tRNAnum","kind":13,"containerName":"next_prediction"},{"name":"$start","kind":13,"containerName":"next_prediction","line":257},{"containerName":"next_prediction","kind":13,"name":"$end","line":257},{"containerName":"next_prediction","kind":13,"name":"$type","line":257},{"containerName":"next_prediction","kind":13,"name":"$codon","line":258},{"line":258,"name":"$intron_start","kind":13,"containerName":"next_prediction"},{"line":258,"name":"$intron_end","containerName":"next_prediction","kind":13},{"name":"$score","containerName":"next_prediction","kind":13,"line":259},{"line":261,"name":"$strand","kind":13,"localvar":"my","containerName":"next_prediction","definition":"my"},{"containerName":"next_prediction","kind":13,"name":"$start","line":262},{"containerName":"next_prediction","kind":13,"name":"$end","line":262},{"kind":13,"containerName":"next_prediction","name":"$start","line":263},{"line":263,"name":"$end","kind":13,"containerName":"next_prediction"},{"line":263,"name":"$strand","kind":13,"containerName":"next_prediction"},{"containerName":"next_prediction","kind":13,"name":"$end","line":263},{"name":"$start","containerName":"next_prediction","kind":13,"line":263},{"kind":13,"containerName":"next_prediction","name":"$self","line":265},{"name":"$type","kind":13,"containerName":"next_prediction","line":265},{"containerName":"next_prediction","kind":13,"name":"$type","line":266},{"name":"$self","kind":13,"containerName":"next_prediction","line":266},{"line":266,"name":"$type","kind":13,"containerName":"next_prediction"},{"line":268,"name":"$gene","containerName":"next_prediction","localvar":"my","kind":13,"definition":"my"},{"kind":12,"containerName":"next_prediction","name":"new","line":269},{"line":269,"containerName":"next_prediction","kind":13,"name":"$seqid"},{"line":270,"name":"$start","containerName":"next_prediction","kind":13},{"kind":13,"containerName":"next_prediction","name":"$end","line":271},{"line":272,"name":"$strand","kind":13,"containerName":"next_prediction"},{"line":273,"containerName":"next_prediction","kind":13,"name":"$score"},{"line":274,"name":"$genetag","kind":13,"containerName":"next_prediction"},{"name":"$srctag","kind":13,"containerName":"next_prediction","line":275},{"line":279,"containerName":"next_prediction","kind":13,"name":"$type"},{"line":280,"name":"$codon","kind":13,"containerName":"next_prediction"},{"line":282,"kind":13,"containerName":"next_prediction","name":"$intron_start"},{"line":283,"name":"$intron_start","containerName":"next_prediction","kind":13},{"line":283,"name":"$intron_end","kind":13,"containerName":"next_prediction"},{"kind":13,"containerName":"next_prediction","name":"$intron_start","line":284},{"name":"$intron_end","kind":13,"containerName":"next_prediction","line":284},{"line":284,"name":"$intron_end","containerName":"next_prediction","kind":13},{"line":284,"name":"$intron_start","kind":13,"containerName":"next_prediction"},{"name":"$gene","containerName":"next_prediction","kind":13,"line":286},{"name":"add_SeqFeature","kind":12,"containerName":"next_prediction","line":286},{"containerName":"next_prediction","kind":12,"name":"new","line":287},{"name":"$seqid","containerName":"next_prediction","kind":13,"line":287},{"line":288,"name":"$start","containerName":"next_prediction","kind":13},{"line":289,"name":"$intron_start","containerName":"next_prediction","kind":13},{"line":290,"kind":13,"containerName":"next_prediction","name":"$strand"},{"name":"$exontag","containerName":"next_prediction","kind":13,"line":291},{"kind":13,"containerName":"next_prediction","name":"$srctag","line":292},{"name":"$gene","containerName":"next_prediction","kind":13,"line":296},{"line":296,"name":"add_SeqFeature","containerName":"next_prediction","kind":12},{"name":"new","containerName":"next_prediction","kind":12,"line":297},{"name":"$seqid","kind":13,"containerName":"next_prediction","line":297},{"line":298,"name":"$intron_end","containerName":"next_prediction","kind":13},{"containerName":"next_prediction","kind":13,"name":"$end","line":299},{"name":"$strand","kind":13,"containerName":"next_prediction","line":300},{"name":"$exontag","kind":13,"containerName":"next_prediction","line":301},{"line":302,"name":"$srctag","kind":13,"containerName":"next_prediction"},{"name":"$gene","kind":13,"containerName":"next_prediction","line":307},{"line":307,"name":"add_SeqFeature","containerName":"next_prediction","kind":12},{"line":308,"kind":12,"containerName":"next_prediction","name":"new"},{"line":308,"name":"$seqid","containerName":"next_prediction","kind":13},{"line":309,"name":"$start","containerName":"next_prediction","kind":13},{"line":310,"containerName":"next_prediction","kind":13,"name":"$end"},{"name":"$strand","kind":13,"containerName":"next_prediction","line":311},{"containerName":"next_prediction","kind":13,"name":"$exontag","line":312},{"line":313,"name":"$srctag","containerName":"next_prediction","kind":13},{"line":318,"kind":13,"containerName":"next_prediction","name":"$gene"}],"containerName":"main::","name":"next_prediction","definition":"sub","detail":"($self)"},{"line":268,"kind":12,"containerName":"SeqFeature::Generic","name":"Bio"},{"containerName":"SeqFeature::Generic","kind":12,"name":"Bio","line":286},{"containerName":"SeqFeature::Generic","kind":12,"name":"Bio","line":296},{"line":307,"kind":12,"containerName":"SeqFeature::Generic","name":"Bio"}]}