{"version":5,"vars":[{"name":"base","kind":2,"containerName":"","line":136},{"range":{"end":{"character":9999,"line":155},"start":{"character":0,"line":138}},"kind":12,"line":138,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"","label":"new($class,@args)"},"containerName":"main::","name":"new","children":[{"definition":"my","line":139,"containerName":"new","localvar":"my","kind":13,"name":"$class"},{"line":139,"name":"@args","containerName":"new","kind":13},{"definition":"my","line":141,"name":"$self","kind":13,"localvar":"my","containerName":"new"},{"name":"$class","containerName":"new","kind":13,"line":141},{"containerName":"new","kind":13,"name":"@args","line":141},{"line":143,"localvar":"my","containerName":"new","kind":13,"name":"$seqobj","definition":"my"},{"line":143,"name":"$self","kind":13,"containerName":"new"},{"name":"_rearrange","containerName":"new","kind":12,"line":143},{"line":143,"containerName":"new","kind":13,"name":"@args"},{"name":"$seqobj","containerName":"new","kind":13,"line":144},{"name":"@args","containerName":"new","kind":13,"line":144},{"name":"$args","containerName":"new","kind":13,"line":144},{"name":"$seqobj","kind":13,"containerName":"new","line":146},{"name":"$args","containerName":"new","kind":13,"line":146},{"name":"$seqobj","kind":13,"containerName":"new","line":149},{"line":149,"containerName":"new","kind":12,"name":"isa"},{"line":150,"name":"$self","containerName":"new","kind":13},{"name":"throw","containerName":"new","kind":12,"line":150},{"containerName":"new","kind":13,"name":"$self","line":150},{"containerName":"new","kind":13,"name":"$self","line":153},{"line":153,"name":"$seqobj","kind":13,"containerName":"new"},{"line":154,"containerName":"new","kind":13,"name":"$self"}],"detail":"($class,@args)","definition":"sub"},{"line":141,"containerName":"new","kind":12,"name":"SUPER"},{"detail":"($self,$seqobj,$word_length)","definition":"sub","name":"count_words","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"count_words","line":181,"definition":"my"},{"containerName":"count_words","kind":13,"name":"$seqobj","line":181},{"name":"$word_length","kind":13,"containerName":"count_words","line":181},{"line":184,"containerName":"count_words","kind":13,"name":"$seqobj"},{"line":186,"name":"$seqobj","containerName":"count_words","kind":13},{"line":186,"name":"isa","kind":12,"containerName":"count_words"},{"line":187,"containerName":"count_words","kind":13,"name":"$self"},{"kind":12,"containerName":"count_words","name":"throw","line":187},{"line":191,"name":"$word_length","kind":13,"containerName":"count_words"},{"line":191,"kind":13,"containerName":"count_words","name":"$seqobj"},{"line":192,"name":"$seqobj","containerName":"count_words","kind":13},{"name":"$seqobj","containerName":"count_words","kind":13,"line":195},{"line":196,"kind":13,"containerName":"count_words","name":"$seqobj"},{"kind":13,"containerName":"count_words","name":"$self","line":196},{"name":"$word_length","kind":13,"containerName":"count_words","line":199},{"line":199,"kind":13,"containerName":"count_words","name":"$word_length"},{"kind":13,"containerName":"count_words","name":"$self","line":200},{"line":200,"name":"throw","kind":12,"containerName":"count_words"},{"line":202,"name":"$word_length","containerName":"count_words","kind":13},{"line":202,"name":"$word_length","kind":13,"containerName":"count_words"},{"containerName":"count_words","kind":13,"name":"$word_length","line":202},{"name":"$self","kind":13,"containerName":"count_words","line":203},{"line":203,"name":"throw","kind":12,"containerName":"count_words"},{"line":207,"name":"$seqstring","kind":13,"localvar":"my","containerName":"count_words","definition":"my"},{"line":207,"name":"$seqobj","kind":13,"containerName":"count_words"},{"name":"seq","containerName":"count_words","kind":12,"line":207},{"containerName":"count_words","kind":13,"name":"$word_length","line":209},{"line":209,"name":"$seqstring","containerName":"count_words","kind":13},{"line":210,"name":"$self","kind":13,"containerName":"count_words"},{"kind":12,"containerName":"count_words","name":"throw","line":210},{"kind":13,"localvar":"my","containerName":"count_words","name":"$type","line":214,"definition":"my"},{"definition":"my","name":"$words","containerName":"count_words","localvar":"my","kind":13,"line":215},{"line":215,"containerName":"count_words","kind":13,"name":"$seqobj"},{"line":215,"kind":13,"containerName":"count_words","name":"$word_length"},{"name":"$type","kind":13,"containerName":"count_words","line":215},{"line":216,"containerName":"count_words","kind":13,"name":"$words"}],"signature":{"label":"count_words($self,$seqobj,$word_length)","parameters":[{"label":"$self"},{"label":"$seqobj"},{"label":"$word_length"}],"documentation":"1;\n# $Id: SeqWords.pm 16123 2009-09-17 12:57:27Z cjfields $\n#---------------------------------------------------------------------------\n# PACKAGE    : Bio::Tools::SeqWords\n# PURPOSE    : To count n-mers in any sequence of characters\n# AUTHOR     : Derek Gatherer (d.gatherer@vir.gla.ac.uk)\n# SOURCE     : \n# CREATED    : 21st March 2000\n# MODIFIED   : 11th November 2003 (DG - new method, count_overlap_words)\n# LICENCE    : You may distribute this module under the same terms \n#\t          : as the rest of BioPerl.\n#---------------------------------------------------------------------------\n\n=head1 NAME\n\nBio::Tools::SeqWords - Object holding n-mer statistics for a sequence\n\n=head1 SYNOPSIS\n\n  # Create the SeqWords object, e.g.:\n\n  my $inputstream = Bio::SeqIO->new(-file => \"seqfile\", \n\t                                 -format => 'Fasta');\n  my $seqobj = $inputstream->next_seq();\n  my $seq_word = Bio::Tools::SeqWords->new(-seq => $seqobj);\n\n  # Or:\n  my $seqobj = Bio::PrimarySeq->new(-seq => \"agggtttccc\",\n                                    -alphabet => 'dna',\n                                    -id => 'test');\n  my $seq_word  =  Bio::Tools::SeqWords->new(-seq => $seqobj);\n\n  # obtain a hash of word counts, eg:\n  my $hash_ref = $seq_stats->count_words($word_length);\n\n  # display hash table, eg:\n  my %hash = %$hash_ref;\n  foreach my $key(sort keys %hash)\n  {\n    print \"\\n$key\\t$hash{$key}\";\n  }\n\n  # Or:\n\n  my $hash_ref =\n     Bio::Tools::SeqWords->count_words($seqobj,$word_length);\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::SeqWords> is a featherweight object for the calculation\nof n-mer word occurrences in a single sequence.  It is envisaged that\nthe object will be useful for construction of scripts which use n-mer\nword tables as the raw material for statistical calculations; for\ninstance, hexamer frequency for the calculation of coding protential,\nor the calculation of periodicity in repetitive DNA.  Triplet\nfrequency is already handled by L<Bio::Tools::SeqStats> (author: Peter\nSchattner).\n\nThere are a few possible applications for protein, e.g. hypothesised\namino acid 7-mers in heat shock proteins, or proteins with multiple\nsimple motifs.  Sometimes these protein periodicities are best seen\nwhen the amino acid alphabet is truncated, e.g. Shulman alphabet.\nSince there are quite a few of these shortened alphabets, this module\ndoes not specify any particular alphabet.\n\nSee Synopsis above for object creation code.\n\n=head2 Rationale\n\nTake a sequence object and create an object for the purposes of\nholding n-mer word statistics about that sequence. The sequence can be\nnucleic acid or protein.\n\nIn count_words() the words are counted in a non-overlapping manner,\nie. in the style of a codon table, but with any word length.\n\nIn count_overlap_words() the words are counted in an overlapping\nmanner.\n\nFor counts on opposite strand (DNA/RNA), a reverse complement method\nshould be performed, and then the count repeated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDerek Gatherer, in the loosest sense of the word 'author'.  The\ngeneral shape of the module is lifted directly from the SeqStat module\nof Peter Schattner. The central subroutine to count the words is\nadapted from original code provided by Dave Shivak, in response to a\nquery on the bioperl mailing list.  At least 2 other people provided\nalternative means (equally good but not used in the end) of performing\nthe same calculation.  Thanks to all for your assistance.\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::SeqWords;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    # our new standard way of instantiation\n    my $self = $class->SUPER::new(@args);\n\n    my ($seqobj) = $self->_rearrange([qw(SEQ)],@args);\n    if((! defined($seqobj)) && @args && ref($args[0])) {\n\t# parameter not passed as named parameter?\n\t$seqobj = $args[0];\n    }\n    \n    if(! $seqobj->isa(\"Bio::PrimarySeqI\")) { \n\t$self->throw(ref($self) . \" works only on PrimarySeqI objects\\n\");\n    }\n\t\n    $self->{'_seqref'} = $seqobj;\n    return $self; \n}\n\n\n=head2 count_words\n\n Title   : count_words\n Usage   : $word_count = $seq_stats->count_words($word_length)\n                or \n           $word_count = $seq_stats->Bio::Tools::SeqWords->($seqobj,$word_length);\n Function: Counts non-overlapping words within a string, any alphabet is \n           used\n Example : a sequence ACCGTCCGT, counted at word length 4, will give the hash\n           {ACCG => 1, TCCG => 1}\n Returns : Reference to a hash in which keys are words (any length) of the\n           alphabet used and values are number of occurrences of the word \n           in the sequence.\n Args    : Word length as scalar and, reference to sequence object if\n           required\n\n           Throws an exception word length is not a positive integer\n           or if word length is longer than the sequence."},"kind":12,"range":{"end":{"line":217,"character":9999},"start":{"character":0,"line":179}},"line":179},{"kind":12,"name":"_count","line":215},{"line":236,"range":{"end":{"line":264,"character":9999},"start":{"line":236,"character":0}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$seqobj"},{"label":"$word_length"}],"documentation":"1;\n# $Id: SeqWords.pm 16123 2009-09-17 12:57:27Z cjfields $\n#---------------------------------------------------------------------------\n# PACKAGE    : Bio::Tools::SeqWords\n# PURPOSE    : To count n-mers in any sequence of characters\n# AUTHOR     : Derek Gatherer (d.gatherer@vir.gla.ac.uk)\n# SOURCE     : \n# CREATED    : 21st March 2000\n# MODIFIED   : 11th November 2003 (DG - new method, count_overlap_words)\n# LICENCE    : You may distribute this module under the same terms \n#\t          : as the rest of BioPerl.\n#---------------------------------------------------------------------------\n\n=head1 NAME\n\nBio::Tools::SeqWords - Object holding n-mer statistics for a sequence\n\n=head1 SYNOPSIS\n\n  # Create the SeqWords object, e.g.:\n\n  my $inputstream = Bio::SeqIO->new(-file => \"seqfile\", \n\t                                 -format => 'Fasta');\n  my $seqobj = $inputstream->next_seq();\n  my $seq_word = Bio::Tools::SeqWords->new(-seq => $seqobj);\n\n  # Or:\n  my $seqobj = Bio::PrimarySeq->new(-seq => \"agggtttccc\",\n                                    -alphabet => 'dna',\n                                    -id => 'test');\n  my $seq_word  =  Bio::Tools::SeqWords->new(-seq => $seqobj);\n\n  # obtain a hash of word counts, eg:\n  my $hash_ref = $seq_stats->count_words($word_length);\n\n  # display hash table, eg:\n  my %hash = %$hash_ref;\n  foreach my $key(sort keys %hash)\n  {\n    print \"\\n$key\\t$hash{$key}\";\n  }\n\n  # Or:\n\n  my $hash_ref =\n     Bio::Tools::SeqWords->count_words($seqobj,$word_length);\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::SeqWords> is a featherweight object for the calculation\nof n-mer word occurrences in a single sequence.  It is envisaged that\nthe object will be useful for construction of scripts which use n-mer\nword tables as the raw material for statistical calculations; for\ninstance, hexamer frequency for the calculation of coding protential,\nor the calculation of periodicity in repetitive DNA.  Triplet\nfrequency is already handled by L<Bio::Tools::SeqStats> (author: Peter\nSchattner).\n\nThere are a few possible applications for protein, e.g. hypothesised\namino acid 7-mers in heat shock proteins, or proteins with multiple\nsimple motifs.  Sometimes these protein periodicities are best seen\nwhen the amino acid alphabet is truncated, e.g. Shulman alphabet.\nSince there are quite a few of these shortened alphabets, this module\ndoes not specify any particular alphabet.\n\nSee Synopsis above for object creation code.\n\n=head2 Rationale\n\nTake a sequence object and create an object for the purposes of\nholding n-mer word statistics about that sequence. The sequence can be\nnucleic acid or protein.\n\nIn count_words() the words are counted in a non-overlapping manner,\nie. in the style of a codon table, but with any word length.\n\nIn count_overlap_words() the words are counted in an overlapping\nmanner.\n\nFor counts on opposite strand (DNA/RNA), a reverse complement method\nshould be performed, and then the count repeated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDerek Gatherer, in the loosest sense of the word 'author'.  The\ngeneral shape of the module is lifted directly from the SeqStat module\nof Peter Schattner. The central subroutine to count the words is\nadapted from original code provided by Dave Shivak, in response to a\nquery on the bioperl mailing list.  At least 2 other people provided\nalternative means (equally good but not used in the end) of performing\nthe same calculation.  Thanks to all for your assistance.\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::SeqWords;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    # our new standard way of instantiation\n    my $self = $class->SUPER::new(@args);\n\n    my ($seqobj) = $self->_rearrange([qw(SEQ)],@args);\n    if((! defined($seqobj)) && @args && ref($args[0])) {\n\t# parameter not passed as named parameter?\n\t$seqobj = $args[0];\n    }\n    \n    if(! $seqobj->isa(\"Bio::PrimarySeqI\")) { \n\t$self->throw(ref($self) . \" works only on PrimarySeqI objects\\n\");\n    }\n\t\n    $self->{'_seqref'} = $seqobj;\n    return $self; \n}\n\n\n=head2 count_words\n\n Title   : count_words\n Usage   : $word_count = $seq_stats->count_words($word_length)\n                or \n           $word_count = $seq_stats->Bio::Tools::SeqWords->($seqobj,$word_length);\n Function: Counts non-overlapping words within a string, any alphabet is \n           used\n Example : a sequence ACCGTCCGT, counted at word length 4, will give the hash\n           {ACCG => 1, TCCG => 1}\n Returns : Reference to a hash in which keys are words (any length) of the\n           alphabet used and values are number of occurrences of the word \n           in the sequence.\n Args    : Word length as scalar and, reference to sequence object if\n           required\n\n           Throws an exception word length is not a positive integer\n           or if word length is longer than the sequence.\n\n\nsub count_words\n{\n    my ($self,$seqobj,$word_length) = @_;\n\n    # check how we were called, and if necessary rearrange arguments\n    if(ref($seqobj)) {\n\t# call as SeqWords->count_words($seq, $wordlen)\n\tif(! $seqobj->isa(\"Bio::PrimarySeqI\")) { \n\t    $self->throw(\"SeqWords works only on PrimarySeqI objects\\n\");\n\t}\n    } else {\n\t# call as $obj->count_words($wordlen)\n\t$word_length = $seqobj;\n\t$seqobj = undef;\n    }\n\n    if(! defined($seqobj)){\n\t      $seqobj =  $self->{'_seqref'};\n    }\n    \n    if($word_length eq \"\" || $word_length =~ /[a-z]/i){\n\t      $self->throw(\"SeqWords cannot accept non-numeric characters\".\n\t\t     \" or a null value in the \\$word_length variable\\n\");\n    }elsif ($word_length <1 || ($word_length - int($word_length)) >0){\n\t      $self->throw(\"SeqWords requires the word length to be a \".\n\t\t     \"positive integer\\n\");\n    }\n\n    my $seqstring = uc $seqobj->seq();\n\n    if($word_length > length($seqstring)){\n\t      $self->throw(\"die in _count, \\$word_length is bigger \".\n\t\t    \"than sequence length\\n\");\n    }\n\n    my $type = \"non-overlap\";\n    my $words = _count($seqobj, $word_length, $type);\n    return $words;   # ref. to a hash\n}\n\n=head2 count_overlap_words\n\n Title   : count_overlap_words\n Usage   : $word_count = $word_obj->count_overlap_words($word_length);\n Function: Counts overlapping words within a string, any alphabet is used\n Example : A sequence ACCAACCA, counted at word length 4, will give the hash\n\t        {ACCA=>2, CCAA=>1, CAAC=>1, AACC=>1}\n Returns : Reference to a hash in which keys are words (any length) of the \n           alphabet used and values are number of occurrences of the word in \n           the sequence.\n Args    : Word length as scalar\n\n           Throws an exception if word length is not a positive integer\n           or if word length is longer than the sequence.","label":"count_overlap_words($self,$seqobj,$word_length)"},"children":[{"line":238,"name":"$self","localvar":"my","kind":13,"containerName":"count_overlap_words","definition":"my"},{"kind":13,"containerName":"count_overlap_words","name":"$seqobj","line":238},{"kind":13,"containerName":"count_overlap_words","name":"$word_length","line":238},{"name":"$seqobj","containerName":"count_overlap_words","kind":13,"line":240},{"containerName":"count_overlap_words","kind":13,"name":"$seqobj","line":242},{"line":242,"kind":12,"containerName":"count_overlap_words","name":"isa"},{"line":243,"kind":13,"containerName":"count_overlap_words","name":"$self"},{"line":243,"containerName":"count_overlap_words","kind":12,"name":"throw"},{"line":247,"name":"$word_length","containerName":"count_overlap_words","kind":13},{"line":247,"containerName":"count_overlap_words","kind":13,"name":"$seqobj"},{"line":248,"containerName":"count_overlap_words","kind":13,"name":"$seqobj"},{"line":251,"name":"$seqobj","containerName":"count_overlap_words","kind":13},{"containerName":"count_overlap_words","kind":13,"name":"$seqobj","line":252},{"kind":13,"containerName":"count_overlap_words","name":"$self","line":252},{"definition":"my","line":254,"name":"$seqstring","localvar":"my","kind":13,"containerName":"count_overlap_words"},{"name":"$seqobj","containerName":"count_overlap_words","kind":13,"line":254},{"name":"seq","containerName":"count_overlap_words","kind":12,"line":254},{"name":"$word_length","kind":13,"containerName":"count_overlap_words","line":256},{"line":256,"containerName":"count_overlap_words","kind":13,"name":"$seqstring"},{"line":257,"name":"$self","containerName":"count_overlap_words","kind":13},{"name":"throw","containerName":"count_overlap_words","kind":12,"line":257},{"definition":"my","line":261,"name":"$type","containerName":"count_overlap_words","localvar":"my","kind":13},{"line":262,"name":"$words","containerName":"count_overlap_words","localvar":"my","kind":13,"definition":"my"},{"line":262,"kind":13,"containerName":"count_overlap_words","name":"$seqobj"},{"line":262,"name":"$word_length","kind":13,"containerName":"count_overlap_words"},{"line":262,"containerName":"count_overlap_words","kind":13,"name":"$type"},{"line":263,"kind":13,"containerName":"count_overlap_words","name":"$words"}],"name":"count_overlap_words","containerName":"main::","definition":"sub","detail":"($self,$seqobj,$word_length)"},{"name":"_count","kind":12,"line":262},{"detail":"($seqobj,$word_length,$type)","definition":"sub","name":"_count","containerName":"main::","children":[{"line":269,"containerName":"_count","localvar":"my","kind":13,"name":"$seqobj","definition":"my"},{"line":269,"name":"$word_length","kind":13,"containerName":"_count"},{"containerName":"_count","kind":13,"name":"$type","line":269},{"line":270,"name":"%codon","kind":13,"localvar":"my","containerName":"_count","definition":"my"},{"definition":"my","line":275,"name":"$seqstring","containerName":"_count","localvar":"my","kind":13},{"name":"$seqobj","kind":13,"containerName":"_count","line":275},{"name":"seq","kind":12,"containerName":"_count","line":275},{"kind":13,"containerName":"_count","name":"$type","line":276},{"kind":13,"containerName":"_count","name":"$seqstring","line":278},{"line":279,"containerName":"_count","kind":13,"name":"$codon"},{"name":"$type","containerName":"_count","kind":13,"line":281},{"name":"$seqlen","localvar":"my","containerName":"_count","kind":13,"line":282,"definition":"my"},{"line":282,"name":"$seqobj","containerName":"_count","kind":13},{"line":282,"containerName":"_count","kind":12,"name":"length"},{"definition":"my","line":283,"localvar":"my","containerName":"_count","kind":13,"name":"$frame"},{"line":283,"containerName":"_count","kind":13,"name":"$frame"},{"containerName":"_count","kind":13,"name":"$word_length","line":283},{"line":283,"name":"$frame","containerName":"_count","kind":13},{"definition":"my","line":285,"kind":13,"localvar":"my","containerName":"_count","name":"$seqstring"},{"containerName":"_count","kind":13,"name":"$seqobj","line":285},{"line":285,"name":"subseq","kind":12,"containerName":"_count"},{"name":"$frame","kind":13,"containerName":"_count","line":285},{"line":285,"name":"$seqlen","kind":13,"containerName":"_count"},{"kind":13,"containerName":"_count","name":"$seqstring","line":287},{"line":288,"containerName":"_count","kind":13,"name":"$codon"},{"name":"throw","kind":12,"containerName":"_count","line":292},{"name":"%codon","containerName":"_count","kind":13,"line":294}],"signature":{"label":"_count($seqobj,$word_length,$type)","documentation":" the actual counting routine\n used by both count_words and count_overlap_words","parameters":[{"label":"$seqobj"},{"label":"$word_length"},{"label":"$type"}]},"range":{"start":{"line":268,"character":0},"end":{"character":9999,"line":295}},"kind":12,"line":268},{"name":"Bio","containerName":"Root::Root","kind":12,"line":292}]}