{"version":5,"vars":[{"kind":2,"containerName":"","name":"vars","line":127},{"name":"base","kind":2,"containerName":"","line":133},{"line":134,"name":"@Models","kind":13,"containerName":null},{"containerName":"main::","name":"next_feature","children":[{"line":159,"name":"$self","kind":13,"localvar":"my","containerName":"next_feature","definition":"my"},{"definition":"my","name":"$f","kind":13,"localvar":"my","containerName":"next_feature","line":160},{"name":"$self","kind":13,"containerName":"next_feature","line":160}],"detail":"($self)","definition":"sub","kind":12,"range":{"start":{"line":158,"character":0},"end":{"line":160,"character":9999}},"line":158,"signature":{"documentation":"1;\n# $Id: QRNA.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::QRNA\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::QRNA - A Parser for qrna output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::QRNA;\n  my $parser = Bio::Tools::QRNA->new(-file => $qrnaoutput);\n  while( my $feature = $parser->next_feature ) {\n    # do something here\n  }\n\n=head1 DESCRIPTION\n\nParses QRNA output (E.Rivas:\nhttp://selab.janelia.org/software.html\nftp://selab.janelia.org/pub/software/qrna/).\n\nThis module is not complete, but currently it packs information from\neach QRNA alignment into a single Bio::SeqFeature::Generic object.\n\nNot all options for QRNA output have been tested or tried.  It has\nbeen tested on sliding window output (-w -x) and shuffled output (-b\nor -B).\n\nSee t/QRNA.t for example usage.\n\nAt some point we may have more complicated feature object which will\nsupport this data rather than forcing most of the information into\ntag/value pairs in a SeqFeature::Generic.\n\nRunning with -verbose =E<gt> 1 will store extra data in the feature.  The\nentire unparsed entry for a particular feature will be stored as a\nstring in the tag 'entry' it is accessible via:\n\n  my ($entry) = $f->each_tag_value('entry');\n\nThe winning model for any given alignment test will be the name stored\nin the primary_tag field of feature.  The bit score will stored in the\nscore field.  The logoddpost is availble via the a tag/value pair.\nThis example code will show how to print out the score and log odds\npost for each model.\n\n  # assuming you got a feature already\n  print \"model score logoddspost\\n\";\n  foreach my $model ( qw(OTH COD RNA) ) {\n    my ($score)       = $f->get_tag_values(\"$model\\_score\");\n    my ($logoddspost) = $f->get_tag_values(\"$model\\_logoddspost\");\n    print \"$model $score $logoddspost\\n\";\n  }\n\nThe start and end of the alignment for both the query and hit sequence\nare available through the L<Bio::SeqFeature::FeaturePair> interface,\nspecifically L<Bio::SeqFeature::FeaturePair::feature1> and\nL<Bio::SeqFeature::FeaturePair::feature2>.  Additionally if you have\nrun QRNA with an input file which has the location of the alignment\nstored in the FASTA filename as in (ID/START-END) which is the default\noutput format from L<Bio::AlignIO::fasta> produced alignment output,\nthis module will re-number start/end for the two sequences so they are\nin the actual coordinates of the sequence rather than the relative\ncoordinates of the alignment.  You may find the bioperl utillity\nscript search2alnblocks useful in creating your input files for QRNA.\n\nSome other words of warning, QRNA uses a 0 based numbering system for\nsequence locations, Bioperl uses a 1 based system.  You'll notice that\nlocations will be +1 they are reported in the raw QRNA output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::QRNA;\nuse vars qw(@Models);\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::FeaturePair;\n\nuse base qw(Bio::Root::IO Bio::SeqAnalysisParserI);\n@Models = qw(OTH COD RNA);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::QRNA->new();\n Function: Builds a new Bio::Tools::QRNA object \n Returns : an instance of Bio::Tools::QRNA\n Args    : -fh/-file filehandle/filename standard input for \n                     Bio::Root:IO objects\n\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : my $feature = $parser->next_feature\n Function: Get the next QRNA feature\n Returns : \n Args    :","parameters":[{"label":"$self"}],"label":"next_feature($self)"}},{"containerName":null,"kind":13,"name":"$f","line":161},{"line":161,"name":"$self","kind":13,"containerName":null},{"line":161,"containerName":"main::","kind":12,"name":"_parse_pair"},{"name":"$f","kind":13,"containerName":null,"line":162},{"line":162,"name":"%self","containerName":null,"kind":13},{"line":164,"name":"$f","kind":13,"containerName":null},{"line":167,"kind":12,"range":{"start":{"character":0,"line":167},"end":{"line":200,"character":9999}},"signature":{"label":"_parse_pair($self,@args)","documentation":"","parameters":[{"label":"$self"},{"label":"@args"}]},"children":[{"definition":"my","containerName":"_parse_pair","localvar":"my","kind":13,"name":"$self","line":168},{"name":"@args","kind":13,"containerName":"_parse_pair","line":168},{"containerName":"_parse_pair","localvar":"my","kind":13,"name":"@features","line":169,"definition":"my"},{"line":169,"containerName":"_parse_pair","kind":13,"name":"%data"},{"definition":"my","line":170,"localvar":"my","kind":13,"containerName":"_parse_pair","name":"$seenstart"},{"kind":13,"containerName":"_parse_pair","name":"$self","line":171},{"containerName":"_parse_pair","kind":12,"name":"_readline","line":171},{"name":"$self","containerName":"_parse_pair","kind":13,"line":174},{"line":174,"name":"program_name","containerName":"_parse_pair","kind":12},{"line":175,"name":"$self","kind":13,"containerName":"_parse_pair"},{"name":"program_version","containerName":"_parse_pair","kind":12,"line":175},{"name":"$self","kind":13,"containerName":"_parse_pair","line":176},{"name":"program_date","containerName":"_parse_pair","kind":12,"line":176},{"line":178,"name":"$self","kind":13,"containerName":"_parse_pair"},{"line":178,"name":"PAM_model","containerName":"_parse_pair","kind":12},{"name":"$self","containerName":"_parse_pair","kind":13,"line":180},{"name":"RNA_model","containerName":"_parse_pair","kind":12,"line":180},{"line":182,"containerName":"_parse_pair","kind":13,"name":"$self"},{"line":182,"kind":12,"containerName":"_parse_pair","name":"seq_file"},{"line":184,"kind":13,"containerName":"_parse_pair","name":"$seenstart"},{"line":185,"name":"$data","containerName":"_parse_pair","kind":13},{"kind":13,"containerName":"_parse_pair","name":"@features","line":186},{"containerName":"_parse_pair","kind":13,"name":"$self","line":186},{"line":186,"kind":12,"containerName":"_parse_pair","name":"_make_feature"},{"line":186,"name":"%data","containerName":"_parse_pair","kind":13},{"line":188,"containerName":"_parse_pair","kind":13,"name":"$self"},{"line":188,"name":"_pushback","kind":12,"containerName":"_parse_pair"},{"kind":13,"containerName":"_parse_pair","name":"$seenstart","line":191},{"name":"$data","kind":13,"containerName":"_parse_pair","line":195},{"line":196,"containerName":"_parse_pair","kind":13,"name":"$self"},{"name":"warn","kind":12,"containerName":"_parse_pair","line":196},{"kind":13,"containerName":"_parse_pair","name":"$data","line":197},{"name":"$data","containerName":"_parse_pair","kind":13,"line":199}],"containerName":"main::","name":"_parse_pair","definition":"sub","detail":"($self,@args)"},{"line":203,"name":"%data","kind":13,"containerName":null},{"line":204,"name":"@features","kind":13,"containerName":null},{"name":"$self","kind":13,"containerName":null,"line":204},{"containerName":"main::","kind":12,"name":"_make_feature","line":204},{"name":"%data","containerName":null,"kind":13,"line":204},{"kind":13,"containerName":null,"name":"%data","line":206},{"kind":13,"containerName":null,"name":"%data","line":206},{"line":210,"kind":13,"containerName":null,"name":"%data"},{"line":212,"kind":13,"containerName":null,"name":"%data"},{"line":213,"name":"%data","containerName":null,"kind":13},{"line":216,"containerName":null,"kind":13,"name":"%data"},{"line":217,"name":"%data","containerName":null,"kind":13},{"line":219,"containerName":null,"kind":13,"name":"%data"},{"line":223,"name":"%data","kind":13,"containerName":null},{"definition":"my","line":226,"name":"$model","localvar":"my","kind":13,"containerName":null},{"line":226,"containerName":null,"kind":13,"name":"$score"},{"line":227,"containerName":null,"kind":13,"name":"%model"},{"line":228,"kind":13,"containerName":null,"name":"%data"},{"line":228,"kind":13,"containerName":null,"name":"$model"},{"kind":13,"containerName":null,"name":"%score","line":228},{"line":230,"name":"%data","kind":13,"containerName":null},{"line":230,"name":"$model","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$score","line":230},{"name":"%data","containerName":null,"kind":13,"line":234},{"line":236,"containerName":null,"kind":13,"name":"@features"},{"line":237,"containerName":null,"kind":13,"name":"%self"},{"line":237,"containerName":null,"kind":13,"name":"@features"},{"line":238,"name":"@features","containerName":null,"kind":13},{"line":255,"kind":12,"range":{"start":{"character":0,"line":255},"end":{"character":9999,"line":259}},"definition":"sub","children":[{"line":256,"name":"$self","containerName":"PAM_model","localvar":"my","kind":13,"definition":"my"},{"line":257,"containerName":"PAM_model","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"PAM_model","line":258}],"name":"PAM_model","containerName":"main::"},{"kind":12,"range":{"end":{"line":278,"character":9999},"start":{"line":273,"character":0}},"line":273,"definition":"sub","containerName":"main::","name":"RNA_model","children":[{"line":274,"name":"$self","localvar":"my","kind":13,"containerName":"RNA_model","definition":"my"},{"name":"$self","kind":13,"containerName":"RNA_model","line":276},{"containerName":"RNA_model","kind":13,"name":"$self","line":277}]},{"name":"seq_file","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"seq_file","line":293,"definition":"my"},{"line":295,"containerName":"seq_file","kind":13,"name":"$self"},{"kind":13,"containerName":"seq_file","name":"$self","line":296}],"definition":"sub","kind":12,"range":{"end":{"line":297,"character":9999},"start":{"character":0,"line":292}},"line":292},{"range":{"start":{"character":0,"line":312},"end":{"line":317,"character":9999}},"kind":12,"line":312,"definition":"sub","name":"program_name","containerName":"main::","children":[{"definition":"my","line":313,"name":"$self","kind":13,"localvar":"my","containerName":"program_name"},{"name":"$self","containerName":"program_name","kind":13,"line":315},{"kind":13,"containerName":"program_name","name":"$self","line":316}]},{"definition":"sub","children":[{"line":332,"localvar":"my","kind":13,"containerName":"program_version","name":"$self","definition":"my"},{"containerName":"program_version","kind":13,"name":"$self","line":334},{"line":335,"containerName":"program_version","kind":13,"name":"$self"}],"name":"program_version","containerName":"main::","line":331,"kind":12,"range":{"end":{"character":9999,"line":336},"start":{"line":331,"character":0}}},{"children":[{"definition":"my","line":351,"containerName":"program_date","localvar":"my","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"program_date","line":352},{"line":353,"kind":13,"containerName":"program_date","name":"$self"}],"containerName":"main::","name":"program_date","definition":"sub","line":350,"range":{"end":{"line":354,"character":9999},"start":{"character":0,"line":350}},"kind":12},{"detail":"($self,$data)","definition":"sub","containerName":"main::","name":"_make_feature","children":[{"localvar":"my","kind":13,"containerName":"_make_feature","name":"$self","line":357,"definition":"my"},{"name":"$data","containerName":"_make_feature","kind":13,"line":357},{"name":"$qoffset","localvar":"my","kind":13,"containerName":"_make_feature","line":358,"definition":"my"},{"kind":13,"containerName":"_make_feature","name":"$hoffset","line":358},{"name":"$qid","localvar":"my","containerName":"_make_feature","kind":13,"line":364,"definition":"my"},{"line":364,"name":"$hid","containerName":"_make_feature","kind":13},{"name":"$data","kind":13,"containerName":"_make_feature","line":364},{"containerName":"_make_feature","kind":13,"name":"$data","line":365},{"kind":13,"containerName":"_make_feature","name":"$qid","line":366},{"line":367,"name":"$qid","kind":13,"containerName":"_make_feature"},{"line":367,"name":"$qoffset","kind":13,"containerName":"_make_feature"},{"line":369,"kind":13,"containerName":"_make_feature","name":"$hid"},{"name":"$hid","kind":13,"containerName":"_make_feature","line":370},{"name":"$hoffset","kind":13,"containerName":"_make_feature","line":370},{"definition":"my","containerName":"_make_feature","localvar":"my","kind":13,"name":"$f","line":373},{"line":373,"kind":12,"containerName":"_make_feature","name":"new"},{"line":375,"localvar":"my","containerName":"_make_feature","kind":13,"name":"$s","definition":"my"},{"kind":13,"containerName":"_make_feature","name":"$e","line":375},{"kind":13,"containerName":"_make_feature","name":"$data","line":375},{"name":"$data","containerName":"_make_feature","kind":13,"line":375}],"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$data"}],"label":"_make_feature($self,$data)"},"kind":12,"range":{"start":{"line":356,"character":0},"end":{"line":375,"character":9999}},"line":356},{"line":373,"name":"Bio","kind":12,"containerName":"SeqFeature::FeaturePair"},{"name":"$qf","containerName":null,"localvar":"my","kind":13,"line":376,"definition":"my"},{"kind":12,"containerName":"SeqFeature::Generic","name":"Bio","line":376},{"kind":12,"containerName":"main::","name":"new","line":377},{"containerName":null,"kind":13,"name":"%data","line":377},{"containerName":null,"kind":13,"name":"$self","line":378},{"line":378,"containerName":"main::","kind":12,"name":"program_name"},{"name":"%data","containerName":null,"kind":13,"line":379},{"line":379,"containerName":null,"kind":13,"name":"%data"},{"line":380,"name":"$s","containerName":null,"kind":13},{"line":380,"kind":13,"containerName":null,"name":"$qoffset"},{"line":381,"kind":13,"containerName":null,"name":"$e"},{"containerName":null,"kind":13,"name":"$qoffset","line":381},{"name":"$qid","kind":13,"containerName":null,"line":382},{"name":"$s","kind":13,"containerName":null,"line":383},{"kind":13,"containerName":null,"name":"$e","line":383},{"line":386,"name":"$hf","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"name":"Bio","kind":12,"containerName":"SeqFeature::Generic","line":386},{"kind":12,"containerName":"main::","name":"new","line":387},{"name":"$qf","kind":13,"containerName":null,"line":387},{"line":387,"name":"primary_tag","containerName":"main::","kind":12},{"line":388,"containerName":null,"kind":13,"name":"$qf"},{"line":388,"name":"source_tag","kind":12,"containerName":"main::"},{"line":389,"name":"$qf","kind":13,"containerName":null},{"line":389,"kind":12,"containerName":"main::","name":"score"},{"line":390,"name":"$hid","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$s","line":391},{"kind":13,"containerName":null,"name":"$hoffset","line":391},{"name":"$e","kind":13,"containerName":null,"line":392},{"line":392,"containerName":null,"kind":13,"name":"$hoffset"},{"name":"$qf","containerName":null,"kind":13,"line":393},{"kind":12,"containerName":"main::","name":"strand","line":393},{"containerName":null,"kind":13,"name":"$f","line":395},{"line":395,"name":"feature1","containerName":"main::","kind":12},{"line":395,"containerName":null,"kind":13,"name":"$qf"},{"containerName":null,"kind":13,"name":"$f","line":396},{"containerName":"main::","kind":12,"name":"feature2","line":396},{"line":396,"name":"$hf","kind":13,"containerName":null},{"line":397,"name":"$f","kind":13,"containerName":null},{"line":397,"kind":12,"containerName":"main::","name":"add_tag_value"},{"kind":13,"containerName":null,"name":"%data","line":397},{"containerName":null,"kind":13,"name":"$f","line":398},{"name":"add_tag_value","kind":12,"containerName":"main::","line":398},{"containerName":null,"kind":13,"name":"%data","line":398},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$model","line":400},{"name":"@Models","kind":13,"containerName":null,"line":400},{"line":401,"name":"$f","containerName":null,"kind":13},{"line":401,"name":"add_tag_value","kind":12,"containerName":"main::"},{"kind":13,"containerName":null,"name":"%data","line":401},{"kind":13,"containerName":null,"name":"$model","line":401},{"kind":13,"containerName":null,"name":"$f","line":402},{"kind":12,"containerName":"main::","name":"add_tag_value","line":402},{"kind":13,"containerName":null,"name":"%data","line":402},{"containerName":null,"kind":13,"name":"$model","line":402},{"kind":13,"containerName":null,"name":"%data","line":403},{"name":"%model","kind":13,"containerName":null,"line":403},{"name":"$self","kind":13,"containerName":null,"line":404},{"name":"verbose","containerName":"main::","kind":12,"line":404},{"name":"$self","containerName":null,"kind":13,"line":405},{"name":"debug","kind":12,"containerName":"main::","line":405},{"line":405,"kind":13,"containerName":null,"name":"%data"},{"line":407,"containerName":null,"kind":13,"name":"$self"},{"name":"throw","containerName":"main::","kind":12,"line":407},{"line":408,"kind":13,"containerName":null,"name":"$_"},{"line":408,"kind":13,"containerName":null,"name":"%data"},{"name":"$f","kind":13,"containerName":null,"line":408},{"line":408,"name":"start","containerName":"main::","kind":12},{"name":"$f","containerName":null,"kind":13,"line":408},{"containerName":"main::","kind":12,"name":"end","line":408},{"containerName":null,"kind":13,"name":"$f","line":410},{"line":410,"name":"add_tag_value","containerName":"main::","kind":12},{"name":"%data","containerName":null,"kind":13,"line":411},{"name":"$model","kind":13,"containerName":null,"line":411},{"line":416,"name":"$f","kind":13,"containerName":null},{"line":416,"containerName":"main::","kind":12,"name":"add_tag_value"},{"line":416,"kind":13,"containerName":null,"name":"%data"},{"line":417,"name":"$f","kind":13,"containerName":null},{"name":"add_tag_value","kind":12,"containerName":"main::","line":417},{"kind":13,"containerName":null,"name":"%data","line":417},{"line":418,"name":"$f","containerName":null,"kind":13},{"line":418,"name":"add_tag_value","kind":12,"containerName":"main::"},{"line":418,"kind":13,"containerName":null,"name":"%data"},{"line":418,"kind":13,"containerName":null,"name":"$self"},{"name":"verbose","containerName":"main::","kind":12,"line":418},{"containerName":null,"kind":13,"name":"%data","line":419},{"line":420,"name":"$f","kind":13,"containerName":null},{"kind":12,"containerName":"main::","name":"add_tag_value","line":420},{"name":"%data","kind":13,"containerName":null,"line":420},{"containerName":null,"kind":13,"name":"$f","line":422}]}