{"version":5,"vars":[{"line":33,"name":"vars","kind":2,"containerName":""},{"line":39,"kind":2,"containerName":"","name":"base"},{"line":40,"containerName":null,"kind":13,"name":"@FORMATS"},{"kind":12,"range":{"end":{"character":9999,"line":63},"start":{"line":51,"character":0}},"line":51,"signature":{"label":"new($class,@args)","documentation":"1;\n\n=head1 NAME\n\nBio::Tools::PrositeScan - Parser for ps_scan result\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::PrositeScan;\n\n  my $factory = Bio::Tools::PrositeScan->new(\n      -file => 'out.PrositeScan'\n  );\n\n  while(my $match = $factory->next_prediction){\n      #  $match is of Bio::SeqFeature::FeaturePair\n      my $q_id = $fatch->feature1->seq_id;\n      my $h_id = $fatch->feature2->seq_id;\n  }\n\n=head1 DESCRIPTION\n\nThis is the parser of the output of ps_scan program. It takes either a file\nhandler or a file name, and returns a Bio::SeqFeature::FeaturePair object.\n\n=head1 AUTHOR\n\nJuguang Xiao, juguang@tll.org.sg\n\n\n# Let the code begin...\n\npackage Bio::Tools::PrositeScan;\nuse vars qw(@FORMATS);\nuse strict;\nuse Bio::Seq;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::FeaturePair;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n@FORMATS = qw(SCAN FASTA PSA MSA PFF MATCHLIST);\n\n=head2 new\n\n  Title   : new\n  Usage   : Bio::Tools::PrositeScan->new(-file => 'out.PrositeScan');\n            Bio::Tools::PrositeScan->new(-fh => \\*FH);\n  Returns : L<Bio::Tools::PrositeScan>","parameters":[{"label":"$class"},{"label":"@args"}]},"name":"new","containerName":"main::","children":[{"definition":"my","name":"$class","localvar":"my","kind":13,"containerName":"new","line":52},{"name":"@args","kind":13,"containerName":"new","line":52},{"line":53,"name":"$self","containerName":"new","localvar":"my","kind":13,"definition":"my"},{"line":53,"name":"$class","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"@args","line":53},{"line":54,"containerName":"new","kind":13,"name":"$self"},{"line":54,"name":"_initialize_io","kind":12,"containerName":"new"},{"line":54,"kind":13,"containerName":"new","name":"@args"},{"line":55,"name":"$format","containerName":"new","localvar":"my","kind":13,"definition":"my"},{"name":"$self","kind":13,"containerName":"new","line":55},{"containerName":"new","kind":12,"name":"_rearrange","line":55},{"line":55,"kind":13,"containerName":"new","name":"@args"},{"line":56,"containerName":"new","kind":13,"name":"$format"},{"kind":13,"containerName":"new","name":"$self","line":56},{"containerName":"new","kind":12,"name":"throw","line":56},{"line":57,"name":"@FORMATS","containerName":"new","kind":13},{"line":58,"name":"$self","containerName":"new","kind":13},{"containerName":"new","kind":12,"name":"format","line":58},{"containerName":"new","kind":13,"name":"$format","line":58},{"line":60,"containerName":"new","kind":13,"name":"$self"},{"name":"throw","containerName":"new","kind":12,"line":60},{"name":"$self","containerName":"new","kind":13,"line":62}],"detail":"($class,@args)","definition":"sub"},{"line":53,"containerName":"new","kind":12,"name":"SUPER"},{"name":"$self","kind":13,"localvar":"my","containerName":null,"line":66,"definition":"my"},{"line":67,"containerName":null,"kind":13,"name":"%self"},{"name":"_format","kind":12,"line":67},{"name":"%self","kind":13,"containerName":null,"line":68},{"line":68,"kind":12,"name":"_format"},{"name":"next_prediction","containerName":"main::","children":[{"line":84,"name":"$self","kind":13,"localvar":"my","containerName":"next_prediction","definition":"my"},{"containerName":"next_prediction","kind":13,"name":"$self","line":85},{"line":85,"kind":12,"containerName":"next_prediction","name":"_parsed"},{"line":86,"kind":13,"containerName":"next_prediction","name":"$self"},{"containerName":"next_prediction","kind":12,"name":"_parse","line":86},{"name":"$self","containerName":"next_prediction","kind":13,"line":87},{"name":"_parsed","kind":12,"containerName":"next_prediction","line":87},{"name":"$self","containerName":"next_prediction","kind":13,"line":89}],"detail":"($self)","definition":"sub","kind":12,"range":{"end":{"line":89,"character":9999},"start":{"character":0,"line":83}},"line":83,"signature":{"documentation":"1;\n\n=head1 NAME\n\nBio::Tools::PrositeScan - Parser for ps_scan result\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::PrositeScan;\n\n  my $factory = Bio::Tools::PrositeScan->new(\n      -file => 'out.PrositeScan'\n  );\n\n  while(my $match = $factory->next_prediction){\n      #  $match is of Bio::SeqFeature::FeaturePair\n      my $q_id = $fatch->feature1->seq_id;\n      my $h_id = $fatch->feature2->seq_id;\n  }\n\n=head1 DESCRIPTION\n\nThis is the parser of the output of ps_scan program. It takes either a file\nhandler or a file name, and returns a Bio::SeqFeature::FeaturePair object.\n\n=head1 AUTHOR\n\nJuguang Xiao, juguang@tll.org.sg\n\n\n# Let the code begin...\n\npackage Bio::Tools::PrositeScan;\nuse vars qw(@FORMATS);\nuse strict;\nuse Bio::Seq;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::FeaturePair;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n@FORMATS = qw(SCAN FASTA PSA MSA PFF MATCHLIST);\n\n=head2 new\n\n  Title   : new\n  Usage   : Bio::Tools::PrositeScan->new(-file => 'out.PrositeScan');\n            Bio::Tools::PrositeScan->new(-fh => \\*FH);\n  Returns : L<Bio::Tools::PrositeScan>\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    $self->_initialize_io(@args);\n    my ($format) = $self->_rearrange([qw(FORMAT)], @args);\n    $format || $self->throw(\"format needed\");\n    if(grep /^$format$/i, @FORMATS){\n        $self->format($format);\n    }else{\n        $self->throw(\"Invalid format, [$format]\");\n    }\n    return $self;\n}\n\nsub format {\n    my $self = shift;\n    return $self->{_format} = shift if(@_);\n    return $self->{_format};\n}\n\n=head2 next_prediction\n\n  Title   : new\n  Usage   : \n      while($result = $factory->next_prediction){\n          ;\n      }\n\n  Returns : a Bio::SeqFeature::FeaturePair object","parameters":[{"label":"$self"}],"label":"next_prediction($self)"}},{"kind":12,"name":"_matches","line":89},{"kind":12,"range":{"start":{"line":92,"character":0},"end":{"line":94,"character":9999}},"line":92,"definition":"sub","name":"next_result","containerName":"main::","children":[{"name":"next_prediction","containerName":"next_result","kind":12,"line":93}]},{"line":96,"range":{"start":{"line":96,"character":0},"end":{"line":100,"character":9999}},"kind":12,"definition":"sub","children":[{"definition":"my","line":97,"name":"$self","kind":13,"localvar":"my","containerName":"_parsed"},{"kind":13,"containerName":"_parsed","name":"$self","line":98},{"containerName":"_parsed","kind":13,"name":"$self","line":99}],"name":"_parsed","containerName":"main::"},{"name":"_parsed","kind":12,"line":98},{"name":"_parsed","kind":12,"line":99},{"definition":"sub","children":[{"line":103,"name":"$self","containerName":"_parse","localvar":"my","kind":13,"definition":"my"},{"line":104,"name":"$format","kind":13,"localvar":"my","containerName":"_parse","definition":"my"},{"line":104,"containerName":"_parse","kind":13,"name":"$self"},{"line":104,"containerName":"_parse","kind":12,"name":"format"},{"kind":13,"containerName":"_parse","name":"$self","line":105},{"name":"format","containerName":"_parse","kind":12,"line":105},{"containerName":"_parse","kind":13,"name":"$self","line":106},{"line":106,"kind":12,"containerName":"_parse","name":"_parse_fasta"},{"line":108,"kind":13,"containerName":"_parse","name":"$self"},{"line":108,"name":"throw","containerName":"_parse","kind":12}],"name":"_parse","containerName":"main::","line":102,"range":{"end":{"line":110,"character":9999},"start":{"line":102,"character":0}},"kind":12},{"children":[{"definition":"my","line":113,"localvar":"my","containerName":"_parse_fasta","kind":13,"name":"$self"},{"line":114,"name":"@matches","containerName":"_parse_fasta","localvar":"my","kind":13,"definition":"my"},{"definition":"my","line":115,"containerName":"_parse_fasta","localvar":"my","kind":13,"name":"$fp"},{"definition":"my","line":116,"localvar":"my","containerName":"_parse_fasta","kind":13,"name":"$seq"},{"containerName":"_parse_fasta","kind":13,"name":"$self","line":117},{"line":117,"name":"_readline","containerName":"_parse_fasta","kind":12},{"kind":13,"localvar":"my","containerName":"_parse_fasta","name":"$fasta_head","line":120,"definition":"my"},{"name":"$fasta_head","containerName":"_parse_fasta","kind":13,"line":121},{"line":122,"name":"$q_id","containerName":"_parse_fasta","localvar":"my","kind":13,"definition":"my"},{"line":123,"name":"$q_start","localvar":"my","kind":13,"containerName":"_parse_fasta","definition":"my"},{"definition":"my","line":124,"name":"$q_end","kind":13,"localvar":"my","containerName":"_parse_fasta"},{"definition":"my","line":125,"name":"$h_id","containerName":"_parse_fasta","localvar":"my","kind":13},{"line":126,"containerName":"_parse_fasta","kind":13,"name":"$fp"},{"line":127,"name":"$self","containerName":"_parse_fasta","kind":13},{"line":127,"name":"_attach_seq","containerName":"_parse_fasta","kind":12},{"line":127,"name":"$seq","containerName":"_parse_fasta","kind":13},{"line":127,"containerName":"_parse_fasta","kind":13,"name":"$fp"},{"line":128,"name":"@matches","containerName":"_parse_fasta","kind":13},{"line":128,"name":"$fp","containerName":"_parse_fasta","kind":13},{"containerName":"_parse_fasta","kind":13,"name":"$fp","line":130},{"name":"new","containerName":"_parse_fasta","kind":12,"line":130},{"line":131,"kind":12,"containerName":"_parse_fasta","name":"new"},{"line":132,"name":"$q_id","containerName":"_parse_fasta","kind":13},{"line":133,"containerName":"_parse_fasta","kind":13,"name":"$q_start"},{"name":"$q_end","kind":13,"containerName":"_parse_fasta","line":135},{"kind":12,"containerName":"_parse_fasta","name":"new","line":136},{"containerName":"_parse_fasta","kind":13,"name":"$h_id","line":137},{"line":142,"name":"$seq","kind":13,"containerName":"_parse_fasta"},{"line":144,"containerName":"_parse_fasta","kind":13,"name":"$self"},{"kind":12,"containerName":"_parse_fasta","name":"throw","line":144},{"line":147,"containerName":"_parse_fasta","kind":13,"name":"$seq"},{"line":150,"containerName":"_parse_fasta","kind":13,"name":"$fp"},{"name":"$self","kind":13,"containerName":"_parse_fasta","line":151},{"line":151,"name":"_attach_seq","kind":12,"containerName":"_parse_fasta"},{"line":151,"kind":13,"containerName":"_parse_fasta","name":"$seq"},{"name":"$fp","containerName":"_parse_fasta","kind":13,"line":151},{"name":"@matches","kind":13,"containerName":"_parse_fasta","line":152},{"line":152,"kind":13,"containerName":"_parse_fasta","name":"$fp"},{"kind":13,"containerName":"_parse_fasta","name":"$self","line":154}],"containerName":"main::","name":"_parse_fasta","definition":"sub","detail":"($self)","line":112,"kind":12,"range":{"end":{"character":9999,"line":154},"start":{"line":112,"character":0}},"signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"_parse_fasta($self)"}},{"line":130,"kind":12,"containerName":"SeqFeature::FeaturePair","name":"Bio"},{"line":131,"name":"Bio","containerName":"SeqFeature::Generic","kind":12},{"line":136,"name":"Bio","containerName":"SeqFeature::Generic","kind":12},{"line":154,"kind":12,"name":"_matches"},{"name":"@matches","containerName":null,"kind":13,"line":154},{"children":[{"definition":"my","line":159,"localvar":"my","containerName":"_attach_seq","kind":13,"name":"$self"},{"kind":13,"containerName":"_attach_seq","name":"$seq","line":159},{"containerName":"_attach_seq","kind":13,"name":"$fp","line":159},{"name":"$fp","kind":13,"containerName":"_attach_seq","line":160},{"definition":"my","name":"$whole_seq","kind":13,"localvar":"my","containerName":"_attach_seq","line":161},{"line":161,"containerName":"_attach_seq","kind":13,"name":"$fp"},{"name":"start","containerName":"_attach_seq","kind":12,"line":161},{"line":162,"kind":13,"containerName":"_attach_seq","name":"$whole_seq"},{"containerName":"_attach_seq","kind":13,"name":"$seq","line":162},{"line":163,"name":"$fp","kind":13,"containerName":"_attach_seq"},{"name":"feature1","containerName":"_attach_seq","kind":12,"line":163},{"line":163,"name":"attach_seq","containerName":"_attach_seq","kind":12},{"containerName":"_attach_seq","kind":12,"name":"new","line":164},{"line":164,"kind":13,"containerName":"_attach_seq","name":"$whole_seq"}],"name":"_attach_seq","containerName":"main::","definition":"sub","detail":"($self,$seq,$fp)","line":158,"range":{"end":{"line":167,"character":9999},"start":{"character":0,"line":158}},"kind":12,"signature":{"label":"_attach_seq($self,$seq,$fp)","documentation":"","parameters":[{"label":"$self"},{"label":"$seq"},{"label":"$fp"}]}},{"containerName":"Seq","kind":12,"name":"Bio","line":164}]}