{"version":5,"vars":[{"name":"base","kind":2,"containerName":"","line":93},{"kind":12,"range":{"start":{"character":0,"line":106},"end":{"line":113,"character":9999}},"line":106,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Gumby.pm,v 1.2 2007/06/14 18:01:52 nathan Exp $\n#\n# BioPerl module for Bio::Tools::Phylo::Gerp\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Phylo::Gerp - Parses output from GERP\n\n=head1 SYNOPSIS\n\n  use strict;\n\n  use Bio::Tools::Phylo::Gerp;\n\n  my $parser = Bio::Tools::Phylo::Gerp->new(-file => \"alignment.rates.elems\");\n\n  while (my $feat = $parser->next_result) {\n    my $start = $feat->start;\n    my $end = $feat->end;\n    my $rs_score = $feat->score;\n    my $p_value = ($feat->annotation->get_Annotations('p-value'))[0]->value;\n  }\n\n=head1 DESCRIPTION\n\nThis module is used to parse the output from 'GERP' (v2) by Eugene Davydov\n(originally Gregory M. Cooper et al.). You can get details here:\nhttp://mendel.stanford.edu/sidowlab/\n\nIt works on the .elems files produced by gerpelem.\n\nEach result is a Bio::SeqFeature::Annotated representing a single constrained\nelement.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::Phylo::Gerp;\nuse strict;\n\nuse Bio::SeqFeature::Annotated;\nuse Bio::Annotation::SimpleValue;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Phylo::Gerp->new();\n Function: Builds a new Bio::Tools::Phylo::Gerp object\n Returns : Bio::Tools::Phylo::Gerp\n Args    : -file (or -fh) should contain the contents of a gerpelem .elems file","label":"new($class,@args)"},"containerName":"main::","name":"new","children":[{"definition":"my","line":107,"name":"$class","kind":13,"localvar":"my","containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":107},{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$self","line":108},{"line":108,"name":"$class","kind":13,"containerName":"new"},{"name":"@args","kind":13,"containerName":"new","line":108},{"name":"$self","containerName":"new","kind":13,"line":110},{"line":110,"containerName":"new","kind":12,"name":"_initialize_io"},{"name":"@args","kind":13,"containerName":"new","line":110},{"line":112,"name":"$self","containerName":"new","kind":13}],"detail":"($class,@args)","definition":"sub"},{"name":"SUPER","containerName":"new","kind":12,"line":108},{"definition":"sub","detail":"($self)","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"next_result","name":"$self","line":133},{"line":135,"containerName":"next_result","localvar":"my","kind":13,"name":"$line","definition":"my"},{"name":"$self","kind":13,"containerName":"next_result","line":135},{"line":135,"containerName":"next_result","kind":12,"name":"_readline"},{"line":137,"kind":13,"containerName":"next_result","name":"$line"},{"name":"$line","containerName":"next_result","kind":13,"line":138},{"containerName":"next_result","kind":13,"name":"$self","line":138},{"line":138,"name":"_readline","kind":12,"containerName":"next_result"},{"name":"$start","localvar":"my","kind":13,"containerName":"next_result","line":144,"definition":"my"},{"containerName":"next_result","kind":13,"name":"$end","line":144},{"containerName":"next_result","kind":13,"name":"$rs_score","line":144},{"kind":13,"containerName":"next_result","name":"$p_value","line":144},{"line":144,"name":"$seq_id","containerName":"next_result","kind":13},{"line":144,"containerName":"next_result","kind":13,"name":"$line"},{"name":"$feat","containerName":"next_result","localvar":"my","kind":13,"line":145,"definition":"my"},{"line":145,"name":"new","kind":12,"containerName":"next_result"},{"line":146,"name":"$seq_id","containerName":"next_result","kind":13},{"line":146,"containerName":"next_result","kind":13,"name":"$seq_id"},{"name":"$start","kind":13,"containerName":"next_result","line":147},{"line":148,"kind":13,"containerName":"next_result","name":"$end"},{"line":150,"name":"$rs_score","kind":13,"containerName":"next_result"},{"definition":"my","line":154,"name":"$sv","containerName":"next_result","localvar":"my","kind":13},{"line":154,"name":"new","kind":12,"containerName":"next_result"},{"line":155,"kind":13,"containerName":"next_result","name":"$feat"},{"kind":12,"containerName":"next_result","name":"annotation","line":155},{"line":155,"containerName":"next_result","kind":12,"name":"add_Annotation"},{"line":155,"name":"$sv","containerName":"next_result","kind":13},{"name":"$sv","kind":13,"containerName":"next_result","line":156},{"line":156,"containerName":"next_result","kind":12,"name":"new"},{"name":"$p_value","kind":13,"containerName":"next_result","line":156},{"line":157,"kind":13,"containerName":"next_result","name":"$feat"},{"name":"annotation","containerName":"next_result","kind":12,"line":157},{"containerName":"next_result","kind":12,"name":"add_Annotation","line":157},{"line":157,"containerName":"next_result","kind":13,"name":"$sv"},{"line":159,"containerName":"next_result","kind":13,"name":"$feat"}],"containerName":"main::","name":"next_result","signature":{"label":"next_result($self)","documentation":"1;\n# $Id: Gumby.pm,v 1.2 2007/06/14 18:01:52 nathan Exp $\n#\n# BioPerl module for Bio::Tools::Phylo::Gerp\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Phylo::Gerp - Parses output from GERP\n\n=head1 SYNOPSIS\n\n  use strict;\n\n  use Bio::Tools::Phylo::Gerp;\n\n  my $parser = Bio::Tools::Phylo::Gerp->new(-file => \"alignment.rates.elems\");\n\n  while (my $feat = $parser->next_result) {\n    my $start = $feat->start;\n    my $end = $feat->end;\n    my $rs_score = $feat->score;\n    my $p_value = ($feat->annotation->get_Annotations('p-value'))[0]->value;\n  }\n\n=head1 DESCRIPTION\n\nThis module is used to parse the output from 'GERP' (v2) by Eugene Davydov\n(originally Gregory M. Cooper et al.). You can get details here:\nhttp://mendel.stanford.edu/sidowlab/\n\nIt works on the .elems files produced by gerpelem.\n\nEach result is a Bio::SeqFeature::Annotated representing a single constrained\nelement.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::Phylo::Gerp;\nuse strict;\n\nuse Bio::SeqFeature::Annotated;\nuse Bio::Annotation::SimpleValue;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Phylo::Gerp->new();\n Function: Builds a new Bio::Tools::Phylo::Gerp object\n Returns : Bio::Tools::Phylo::Gerp\n Args    : -file (or -fh) should contain the contents of a gerpelem .elems file\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->_initialize_io(@args);\n    \n    return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : $result = $obj->next_result();\n Function: Returns the next result available from the input, or undef if there\n           are no more results.\n Returns : Bio::SeqFeature::Annotated object. Features are annotated with a tag\n           for 'pvalue', and a 'predicted' tag. They have no sequence id unless\n           the input GERP file is non-standard, with the seq id as the 6th\n           column.\n\n           NB: feature coordinates are alignment columns of the alignment\n           used to create the result file.\n Args    : none","parameters":[{"label":"$self"}]},"line":132,"range":{"start":{"line":132,"character":0},"end":{"character":9999,"line":160}},"kind":12},{"containerName":"SeqFeature::Annotated","kind":12,"name":"Bio","line":145},{"line":154,"name":"Bio","kind":12,"containerName":"Annotation::SimpleValue"},{"name":"Bio","kind":12,"containerName":"Annotation::SimpleValue","line":156}]}