{"version":5,"vars":[{"line":120,"containerName":"","kind":2,"name":"base"},{"signature":{"documentation":"1;\n# $Id: Genemark.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Genemark\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mark Fiers <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp, Mark Fiers\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Genemark - Results of one Genemark run\n\n=head1 SYNOPSIS\n\n   $Genemark = Bio::Tools::Genemark->new(-file => 'result.Genemark');\n   # filehandle:\n   $Genemark = Bio::Tools::Genemark->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $Genemark->next_feature() is the same\n   while($gene = $Genemark->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of\n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons:\n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $Genemark->close();\n\n=head1 DESCRIPTION\n\nThe Genemark module provides a parser for Genemark gene structure\nprediction output. It parses one gene prediction into a\nBio::SeqFeature::Gene::Transcript- derived object.\n\nThis module has been developed around genemark.hmm for eukaryots v2.2a\nand will probably not work with other versions.\n\n\nThis module also implements the Bio::SeqAnalysisParserI interface, and\nthus can be used wherever such an object fits. See\nL<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp, Mark Fiers\n\nEmail hlapp@gmx.net\n      m.w.e.j.fiers@plant.wag-ur.nl\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Genemark;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\nuse Bio::Seq;\nuse Bio::Factory::FTLocationFactory;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Genemark->new();\n Function: Builds a new Bio::Tools::Genemark object\n Returns : an instance of Bio::Tools::Genemark\n Args    : seqname","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"line":133,"kind":12,"range":{"end":{"line":144,"character":9999},"start":{"character":0,"line":133}},"definition":"sub","detail":"($class,@args)","children":[{"line":134,"name":"$class","containerName":"new","localvar":"my","kind":13,"definition":"my"},{"line":134,"name":"@args","kind":13,"containerName":"new"},{"line":136,"localvar":"my","kind":13,"containerName":"new","name":"$self","definition":"my"},{"name":"$class","containerName":"new","kind":13,"line":136},{"name":"@args","kind":13,"containerName":"new","line":136},{"line":138,"name":"$seqname","localvar":"my","kind":13,"containerName":"new","definition":"my"},{"name":"$self","containerName":"new","kind":13,"line":138},{"containerName":"new","kind":12,"name":"_rearrange","line":138},{"line":138,"name":"@args","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$self","line":141},{"line":141,"name":"_seqname","kind":12,"containerName":"new"},{"containerName":"new","kind":13,"name":"$seqname","line":141},{"containerName":"new","kind":13,"name":"$seqname","line":141},{"name":"$self","kind":13,"containerName":"new","line":143}],"name":"new","containerName":"main::"},{"line":136,"name":"SUPER","kind":12,"containerName":"new"},{"name":"_initialize_state","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"_initialize_state","name":"$self","line":147,"definition":"my"},{"name":"@args","containerName":"_initialize_state","kind":13,"line":147},{"line":150,"name":"$self","kind":13,"containerName":"_initialize_state"},{"line":150,"containerName":"_initialize_state","kind":13,"name":"@args"},{"kind":13,"containerName":"_initialize_state","name":"$self","line":153},{"line":154,"kind":13,"containerName":"_initialize_state","name":"$self"},{"kind":13,"containerName":"_initialize_state","name":"$self","line":156},{"name":"$self","containerName":"_initialize_state","kind":13,"line":158}],"detail":"($self,@args)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":146},"end":{"character":9999,"line":159}},"line":146,"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_initialize_state($self,@args)"}},{"name":"SUPER","containerName":"_initialize_state","kind":12,"line":150},{"line":172,"kind":12,"range":{"end":{"line":179,"character":9999},"start":{"character":0,"line":172}},"signature":{"documentation":"1;\n# $Id: Genemark.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Genemark\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mark Fiers <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp, Mark Fiers\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Genemark - Results of one Genemark run\n\n=head1 SYNOPSIS\n\n   $Genemark = Bio::Tools::Genemark->new(-file => 'result.Genemark');\n   # filehandle:\n   $Genemark = Bio::Tools::Genemark->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $Genemark->next_feature() is the same\n   while($gene = $Genemark->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of\n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons:\n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $Genemark->close();\n\n=head1 DESCRIPTION\n\nThe Genemark module provides a parser for Genemark gene structure\nprediction output. It parses one gene prediction into a\nBio::SeqFeature::Gene::Transcript- derived object.\n\nThis module has been developed around genemark.hmm for eukaryots v2.2a\nand will probably not work with other versions.\n\n\nThis module also implements the Bio::SeqAnalysisParserI interface, and\nthus can be used wherever such an object fits. See\nL<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp, Mark Fiers\n\nEmail hlapp@gmx.net\n      m.w.e.j.fiers@plant.wag-ur.nl\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Genemark;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\nuse Bio::Seq;\nuse Bio::Factory::FTLocationFactory;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Genemark->new();\n Function: Builds a new Bio::Tools::Genemark object\n Returns : an instance of Bio::Tools::Genemark\n Args    : seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($seqname) = $self->_rearrange([qw(SEQNAME)], @args);\n\n  # hardwire seq_id when creating gene and exon objects\n  $self->_seqname($seqname) if defined($seqname);\n\n  return $self;\n}\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $Genemark->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /GeneMark.hmm/i.\n Returns   : String\n Argument  : n/a","parameters":[{"label":"$self"},{"label":"$method"}],"label":"analysis_method($self,$method)"},"children":[{"definition":"my","containerName":"analysis_method","localvar":"my","kind":13,"name":"$self","line":174},{"name":"$method","containerName":"analysis_method","kind":13,"line":174},{"line":175,"name":"$method","kind":13,"containerName":"analysis_method"},{"line":175,"name":"$method","containerName":"analysis_method","kind":13},{"line":176,"name":"$self","containerName":"analysis_method","kind":13},{"line":176,"name":"throw","kind":12,"containerName":"analysis_method"},{"name":"$self","kind":13,"containerName":"analysis_method","line":176},{"line":178,"containerName":"analysis_method","kind":13,"name":"$self"},{"kind":13,"containerName":"analysis_method","name":"$method","line":178}],"name":"analysis_method","containerName":"main::","definition":"sub","detail":"($self,$method)"},{"line":178,"name":"SUPER","containerName":"analysis_method","kind":12},{"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Genemark.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Genemark\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mark Fiers <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp, Mark Fiers\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Genemark - Results of one Genemark run\n\n=head1 SYNOPSIS\n\n   $Genemark = Bio::Tools::Genemark->new(-file => 'result.Genemark');\n   # filehandle:\n   $Genemark = Bio::Tools::Genemark->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $Genemark->next_feature() is the same\n   while($gene = $Genemark->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of\n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons:\n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $Genemark->close();\n\n=head1 DESCRIPTION\n\nThe Genemark module provides a parser for Genemark gene structure\nprediction output. It parses one gene prediction into a\nBio::SeqFeature::Gene::Transcript- derived object.\n\nThis module has been developed around genemark.hmm for eukaryots v2.2a\nand will probably not work with other versions.\n\n\nThis module also implements the Bio::SeqAnalysisParserI interface, and\nthus can be used wherever such an object fits. See\nL<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp, Mark Fiers\n\nEmail hlapp@gmx.net\n      m.w.e.j.fiers@plant.wag-ur.nl\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Genemark;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\nuse Bio::Seq;\nuse Bio::Factory::FTLocationFactory;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Genemark->new();\n Function: Builds a new Bio::Tools::Genemark object\n Returns : an instance of Bio::Tools::Genemark\n Args    : seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($seqname) = $self->_rearrange([qw(SEQNAME)], @args);\n\n  # hardwire seq_id when creating gene and exon objects\n  $self->_seqname($seqname) if defined($seqname);\n\n  return $self;\n}\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $Genemark->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /GeneMark.hmm/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method {\n#-------------\n    my ($self, $method) = @_;\n    if($method && ($method !~ /Genemark\\.hmm/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $Genemark->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genemark result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for\n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :","label":"next_feature($self,@args)"},"range":{"end":{"line":207,"character":9999},"start":{"character":0,"line":201}},"kind":12,"line":201,"detail":"($self,@args)","definition":"sub","name":"next_feature","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"next_feature","name":"$self","line":202},{"name":"@args","containerName":"next_feature","kind":13,"line":202},{"line":206,"name":"$self","kind":13,"containerName":"next_feature"},{"line":206,"kind":12,"containerName":"next_feature","name":"next_prediction"},{"line":206,"kind":13,"containerName":"next_feature","name":"@args"}]},{"signature":{"label":"next_prediction($self)","documentation":"1;\n# $Id: Genemark.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Genemark\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mark Fiers <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp, Mark Fiers\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Genemark - Results of one Genemark run\n\n=head1 SYNOPSIS\n\n   $Genemark = Bio::Tools::Genemark->new(-file => 'result.Genemark');\n   # filehandle:\n   $Genemark = Bio::Tools::Genemark->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $Genemark->next_feature() is the same\n   while($gene = $Genemark->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of\n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons:\n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $Genemark->close();\n\n=head1 DESCRIPTION\n\nThe Genemark module provides a parser for Genemark gene structure\nprediction output. It parses one gene prediction into a\nBio::SeqFeature::Gene::Transcript- derived object.\n\nThis module has been developed around genemark.hmm for eukaryots v2.2a\nand will probably not work with other versions.\n\n\nThis module also implements the Bio::SeqAnalysisParserI interface, and\nthus can be used wherever such an object fits. See\nL<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp, Mark Fiers\n\nEmail hlapp@gmx.net\n      m.w.e.j.fiers@plant.wag-ur.nl\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Genemark;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\nuse Bio::Seq;\nuse Bio::Factory::FTLocationFactory;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Genemark->new();\n Function: Builds a new Bio::Tools::Genemark object\n Returns : an instance of Bio::Tools::Genemark\n Args    : seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($seqname) = $self->_rearrange([qw(SEQNAME)], @args);\n\n  # hardwire seq_id when creating gene and exon objects\n  $self->_seqname($seqname) if defined($seqname);\n\n  return $self;\n}\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $Genemark->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /GeneMark.hmm/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method {\n#-------------\n    my ($self, $method) = @_;\n    if($method && ($method !~ /Genemark\\.hmm/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $Genemark->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genemark result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for\n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $Genemark->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genemark result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :","parameters":[{"label":"$self"}]},"line":224,"kind":12,"range":{"end":{"character":9999,"line":235},"start":{"character":0,"line":224}},"definition":"sub","detail":"($self)","children":[{"localvar":"my","kind":13,"containerName":"next_prediction","name":"$self","line":225,"definition":"my"},{"definition":"my","name":"$gene","containerName":"next_prediction","localvar":"my","kind":13,"line":226},{"name":"$self","containerName":"next_prediction","kind":13,"line":229},{"kind":12,"containerName":"next_prediction","name":"_parse_predictions","line":229},{"name":"$self","containerName":"next_prediction","kind":13,"line":229},{"name":"_predictions_parsed","kind":12,"containerName":"next_prediction","line":229},{"containerName":"next_prediction","kind":13,"name":"$gene","line":232},{"line":232,"kind":13,"containerName":"next_prediction","name":"$self"},{"containerName":"next_prediction","kind":12,"name":"_prediction","line":232},{"name":"$gene","containerName":"next_prediction","kind":13,"line":234}],"containerName":"main::","name":"next_prediction"},{"line":248,"range":{"end":{"character":9999,"line":412},"start":{"character":0,"line":248}},"kind":12,"signature":{"label":"_parse_predictions($self)","documentation":"1;\n# $Id: Genemark.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Genemark\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mark Fiers <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp, Mark Fiers\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Genemark - Results of one Genemark run\n\n=head1 SYNOPSIS\n\n   $Genemark = Bio::Tools::Genemark->new(-file => 'result.Genemark');\n   # filehandle:\n   $Genemark = Bio::Tools::Genemark->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $Genemark->next_feature() is the same\n   while($gene = $Genemark->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of\n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons:\n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $Genemark->close();\n\n=head1 DESCRIPTION\n\nThe Genemark module provides a parser for Genemark gene structure\nprediction output. It parses one gene prediction into a\nBio::SeqFeature::Gene::Transcript- derived object.\n\nThis module has been developed around genemark.hmm for eukaryots v2.2a\nand will probably not work with other versions.\n\n\nThis module also implements the Bio::SeqAnalysisParserI interface, and\nthus can be used wherever such an object fits. See\nL<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp, Mark Fiers\n\nEmail hlapp@gmx.net\n      m.w.e.j.fiers@plant.wag-ur.nl\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Genemark;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\nuse Bio::Seq;\nuse Bio::Factory::FTLocationFactory;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Genemark->new();\n Function: Builds a new Bio::Tools::Genemark object\n Returns : an instance of Bio::Tools::Genemark\n Args    : seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($seqname) = $self->_rearrange([qw(SEQNAME)], @args);\n\n  # hardwire seq_id when creating gene and exon objects\n  $self->_seqname($seqname) if defined($seqname);\n\n  return $self;\n}\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $Genemark->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /GeneMark.hmm/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method {\n#-------------\n    my ($self, $method) = @_;\n    if($method && ($method !~ /Genemark\\.hmm/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $Genemark->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genemark result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for\n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $Genemark->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genemark result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # get next gene structure\n    $gene = $self->_prediction();\n\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns :","parameters":[{"label":"$self"}]},"children":[{"line":249,"localvar":"my","kind":13,"containerName":"_parse_predictions","name":"$self","definition":"my"},{"line":250,"containerName":"_parse_predictions","localvar":"my","kind":13,"name":"%exontags","definition":"my"},{"localvar":"my","containerName":"_parse_predictions","kind":13,"name":"$exontag","line":255,"definition":"my"},{"definition":"my","line":256,"kind":13,"localvar":"my","containerName":"_parse_predictions","name":"$gene"},{"localvar":"my","kind":13,"containerName":"_parse_predictions","name":"$exontype","line":257,"definition":"my"},{"definition":"my","line":258,"kind":13,"localvar":"my","containerName":"_parse_predictions","name":"$current_gene_no"},{"line":262,"name":"$seqname","containerName":"_parse_predictions","localvar":"my","kind":13,"definition":"my"},{"line":262,"containerName":"_parse_predictions","kind":13,"name":"$self"},{"name":"_seqname","kind":12,"containerName":"_parse_predictions","line":262},{"line":264,"name":"$self","containerName":"_parse_predictions","kind":13},{"name":"_readline","kind":12,"containerName":"_parse_predictions","line":264},{"localvar":"my","kind":13,"containerName":"_parse_predictions","name":"$prednr","line":270,"definition":"my"},{"containerName":"_parse_predictions","localvar":"my","kind":13,"name":"$signalnr","line":273,"definition":"my"},{"definition":"my","line":274,"name":"$signalnr","kind":13,"localvar":"my","containerName":"_parse_predictions"},{"definition":"my","name":"@flds","containerName":"_parse_predictions","localvar":"my","kind":13,"line":278},{"line":281,"name":"$predobj","containerName":"_parse_predictions","localvar":"my","kind":13,"definition":"my"},{"line":281,"name":"new","kind":12,"containerName":"_parse_predictions"},{"name":"$start","containerName":"_parse_predictions","localvar":"my","kind":13,"line":285,"definition":"my"},{"line":285,"kind":13,"containerName":"_parse_predictions","name":"$end"},{"containerName":"_parse_predictions","kind":13,"name":"$orientation","line":285},{"line":285,"name":"$prediction_source","containerName":"_parse_predictions","kind":13},{"name":"$self","containerName":"_parse_predictions","kind":13,"line":287},{"name":"analysis_method","containerName":"_parse_predictions","kind":12,"line":287},{"line":288,"name":"$prediction_source","containerName":"_parse_predictions","kind":13},{"line":289,"name":"$orientation","containerName":"_parse_predictions","kind":13},{"line":289,"name":"$flds","kind":13,"containerName":"_parse_predictions"},{"line":290,"name":"$start","containerName":"_parse_predictions","kind":13},{"line":290,"name":"$end","containerName":"_parse_predictions","kind":13},{"line":290,"kind":13,"containerName":"_parse_predictions","name":"@flds"},{"line":291,"containerName":"_parse_predictions","kind":13,"name":"$exontag"},{"name":"$prediction_source","kind":13,"containerName":"_parse_predictions","line":294},{"containerName":"_parse_predictions","kind":13,"name":"$orientation","line":295},{"line":295,"name":"$flds","kind":13,"containerName":"_parse_predictions"},{"line":296,"containerName":"_parse_predictions","kind":13,"name":"$start"},{"name":"$end","kind":13,"containerName":"_parse_predictions","line":296},{"name":"@flds","kind":13,"containerName":"_parse_predictions","line":296},{"kind":13,"containerName":"_parse_predictions","name":"$exontag","line":297},{"kind":13,"containerName":"_parse_predictions","name":"$flds","line":297},{"definition":"my","kind":13,"localvar":"my","containerName":"_parse_predictions","name":"$location_string","line":303},{"kind":13,"containerName":"_parse_predictions","name":"$start","line":303},{"name":"$end","containerName":"_parse_predictions","kind":13,"line":303},{"definition":"my","localvar":"my","containerName":"_parse_predictions","kind":13,"name":"$location_factory","line":304},{"line":304,"name":"new","containerName":"_parse_predictions","kind":12},{"definition":"my","name":"$location_obj","containerName":"_parse_predictions","localvar":"my","kind":13,"line":305},{"line":305,"name":"$location_factory","containerName":"_parse_predictions","kind":13},{"line":305,"kind":12,"containerName":"_parse_predictions","name":"from_string"},{"name":"$location_string","kind":13,"containerName":"_parse_predictions","line":305},{"kind":13,"containerName":"_parse_predictions","name":"$predobj","line":306},{"line":306,"containerName":"_parse_predictions","kind":12,"name":"location"},{"line":306,"name":"$location_obj","kind":13,"containerName":"_parse_predictions"},{"line":309,"name":"$predobj","containerName":"_parse_predictions","kind":13},{"name":"source_tag","containerName":"_parse_predictions","kind":12,"line":309},{"kind":13,"containerName":"_parse_predictions","name":"$prediction_source","line":309},{"kind":13,"containerName":"_parse_predictions","name":"$predobj","line":310},{"name":"strand","kind":12,"containerName":"_parse_predictions","line":310},{"line":310,"name":"$orientation","containerName":"_parse_predictions","kind":13},{"line":312,"name":"$predobj","kind":13,"containerName":"_parse_predictions"},{"name":"primary_tag","kind":12,"containerName":"_parse_predictions","line":312},{"name":"$exontags","containerName":"_parse_predictions","kind":13,"line":312},{"name":"$exontag","kind":13,"containerName":"_parse_predictions","line":312},{"containerName":"_parse_predictions","kind":13,"name":"$predobj","line":314},{"kind":12,"containerName":"_parse_predictions","name":"add_tag_value","line":314},{"line":314,"name":"$signalnr","containerName":"_parse_predictions","kind":13},{"kind":13,"containerName":"_parse_predictions","name":"$predobj","line":316},{"name":"is_coding","kind":12,"containerName":"_parse_predictions","line":316},{"line":318,"name":"$predobj","containerName":"_parse_predictions","kind":13},{"line":318,"name":"seq_id","containerName":"_parse_predictions","kind":12},{"line":318,"kind":13,"containerName":"_parse_predictions","name":"$seqname"},{"line":318,"name":"$seqname","kind":13,"containerName":"_parse_predictions"},{"kind":13,"containerName":"_parse_predictions","name":"$seqname","line":318},{"line":325,"containerName":"_parse_predictions","kind":13,"name":"$prednr"},{"line":325,"name":"$current_gene_no","kind":13,"containerName":"_parse_predictions"},{"name":"$gene","containerName":"_parse_predictions","kind":13,"line":327},{"kind":13,"containerName":"_parse_predictions","name":"$gene","line":328},{"line":328,"containerName":"_parse_predictions","kind":12,"name":"seq_id"},{"kind":13,"containerName":"_parse_predictions","name":"$seqname","line":328},{"line":329,"name":"$gene","containerName":"_parse_predictions","kind":13},{"kind":13,"containerName":"_parse_predictions","name":"$gene","line":332},{"line":333,"containerName":"_parse_predictions","kind":12,"name":"new"},{"name":"$prediction_source","containerName":"_parse_predictions","kind":13,"line":335},{"line":336,"name":"$self","containerName":"_parse_predictions","kind":13},{"name":"_add_prediction","containerName":"_parse_predictions","kind":12,"line":336},{"line":336,"name":"$gene","containerName":"_parse_predictions","kind":13},{"containerName":"_parse_predictions","kind":13,"name":"$current_gene_no","line":337},{"line":337,"name":"$prednr","kind":13,"containerName":"_parse_predictions"},{"line":338,"containerName":"_parse_predictions","kind":13,"name":"$gene"},{"line":338,"name":"seq_id","containerName":"_parse_predictions","kind":12},{"kind":13,"containerName":"_parse_predictions","name":"$seqname","line":338},{"line":338,"containerName":"_parse_predictions","kind":13,"name":"$seqname"},{"line":338,"name":"$seqname","kind":13,"containerName":"_parse_predictions"},{"line":342,"containerName":"_parse_predictions","kind":13,"name":"$gene"},{"line":342,"name":"add_exon","kind":12,"containerName":"_parse_predictions"},{"line":342,"name":"$predobj","containerName":"_parse_predictions","kind":13},{"name":"$exontag","kind":13,"containerName":"_parse_predictions","line":342},{"line":343,"name":"$exontags","kind":13,"containerName":"_parse_predictions"},{"kind":13,"containerName":"_parse_predictions","name":"$exontag","line":343},{"line":348,"name":"$self","kind":13,"containerName":"_parse_predictions"},{"name":"analysis_method","kind":12,"containerName":"_parse_predictions","line":348},{"definition":"my","kind":13,"localvar":"my","containerName":"_parse_predictions","name":"$gm_version","line":350},{"containerName":"_parse_predictions","kind":13,"name":"$self","line":352},{"name":"analysis_method_version","containerName":"_parse_predictions","kind":12,"line":352},{"line":352,"name":"$gm_version","containerName":"_parse_predictions","kind":13},{"line":358,"name":"$self","containerName":"_parse_predictions","kind":13},{"line":358,"containerName":"_parse_predictions","kind":12,"name":"analysis_subject"},{"definition":"my","line":362,"containerName":"_parse_predictions","localvar":"my","kind":13,"name":"$_date"},{"line":362,"containerName":"_parse_predictions","kind":13,"name":"$self"},{"kind":12,"containerName":"_parse_predictions","name":"_readline","line":362},{"kind":13,"containerName":"_parse_predictions","name":"$_date","line":363},{"kind":13,"containerName":"_parse_predictions","name":"$self","line":364},{"containerName":"_parse_predictions","kind":12,"name":"analysis_date","line":364},{"kind":13,"containerName":"_parse_predictions","name":"$_date","line":364},{"line":370,"name":"$self","containerName":"_parse_predictions","kind":13},{"line":370,"containerName":"_parse_predictions","kind":12,"name":"analysis_subject"},{"kind":13,"localvar":"my","containerName":"_parse_predictions","name":"$_date","line":374,"definition":"my"},{"kind":13,"containerName":"_parse_predictions","name":"$self","line":374},{"containerName":"_parse_predictions","kind":12,"name":"_readline","line":374},{"name":"$_date","kind":13,"containerName":"_parse_predictions","line":375},{"kind":13,"containerName":"_parse_predictions","name":"$self","line":375},{"containerName":"_parse_predictions","kind":12,"name":"_readline","line":375},{"line":376,"kind":13,"containerName":"_parse_predictions","name":"$_date"},{"containerName":"_parse_predictions","kind":13,"name":"$self","line":377},{"line":377,"name":"analysis_date","kind":12,"containerName":"_parse_predictions"},{"name":"$_date","containerName":"_parse_predictions","kind":13,"line":377},{"kind":13,"containerName":"_parse_predictions","name":"$seqname","line":382},{"line":401,"name":"$geneno","localvar":"my","kind":13,"containerName":"_parse_predictions","definition":"my"},{"containerName":"_parse_predictions","kind":13,"name":"$aa_id","line":402},{"definition":"my","name":"$seqobj","kind":13,"localvar":"my","containerName":"_parse_predictions","line":404},{"containerName":"_parse_predictions","kind":12,"name":"new","line":404},{"line":404,"name":"$seq","kind":13,"containerName":"_parse_predictions"},{"line":405,"name":"$aa_id","containerName":"_parse_predictions","kind":13},{"line":407,"name":"$gene","kind":13,"containerName":"_parse_predictions"},{"containerName":"_parse_predictions","kind":12,"name":"predicted_protein","line":407},{"line":407,"name":"$seqobj","kind":13,"containerName":"_parse_predictions"}],"containerName":"main::","name":"_parse_predictions","definition":"sub","detail":"($self)"},{"line":281,"name":"Bio","containerName":"Tools::Prediction::Exon","kind":12},{"containerName":"Factory::FTLocationFactory","kind":12,"name":"Bio","line":304},{"kind":12,"containerName":"Tools::Prediction::Gene","name":"Bio","line":332},{"name":"Bio","kind":12,"containerName":"Seq","line":404},{"line":408,"name":"FINDPRED","kind":12},{"line":421,"name":"$self","containerName":null,"kind":13},{"line":421,"name":"analysis_query","kind":12,"containerName":"main::"},{"definition":"my","name":"$orig_seq","localvar":"my","kind":13,"containerName":null,"line":422},{"name":"$self","containerName":null,"kind":13,"line":422},{"name":"analysis_query","containerName":"main::","kind":12,"line":422},{"name":"FINDPREDSEQ","kind":12,"line":423},{"definition":"my","line":423,"name":"$gene","localvar":"my","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%self","line":423},{"definition":"my","line":424,"localvar":"my","kind":13,"containerName":null,"name":"$predseq"},{"definition":"my","line":425,"containerName":null,"localvar":"my","kind":13,"name":"$exon"},{"line":425,"containerName":null,"kind":13,"name":"$gene"},{"line":425,"kind":12,"containerName":"main::","name":"exons"},{"line":427,"name":"$predseq","containerName":null,"kind":13},{"name":"$orig_seq","kind":13,"containerName":null,"line":427},{"containerName":"main::","kind":12,"name":"subseq","line":427},{"line":427,"kind":13,"containerName":null,"name":"$exon"},{"line":427,"kind":12,"containerName":"main::","name":"start"},{"line":427,"kind":13,"containerName":null,"name":"$exon"},{"name":"end","kind":12,"containerName":"main::","line":427},{"kind":13,"localvar":"my","containerName":null,"name":"$seqobj","line":430,"definition":"my"},{"line":430,"name":"Bio","kind":12,"containerName":"PrimarySeq"},{"line":430,"name":"new","containerName":"main::","kind":12},{"line":430,"containerName":null,"kind":13,"name":"$predseq"},{"line":432,"containerName":null,"kind":13,"name":"$gene"},{"line":432,"containerName":"main::","kind":12,"name":"predicted_cds"},{"line":432,"containerName":null,"kind":13,"name":"$seqobj"},{"containerName":null,"kind":13,"name":"$self","line":437},{"kind":12,"containerName":"main::","name":"_predictions_parsed","line":437},{"detail":"($self)","definition":"sub","containerName":"main::","name":"_prediction","children":[{"line":451,"kind":13,"localvar":"my","containerName":"_prediction","name":"$self","definition":"my"},{"line":453,"kind":13,"containerName":"_prediction","name":"$self"},{"kind":13,"containerName":"_prediction","name":"$self","line":453}],"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Genemark.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Genemark\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mark Fiers <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp, Mark Fiers\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Genemark - Results of one Genemark run\n\n=head1 SYNOPSIS\n\n   $Genemark = Bio::Tools::Genemark->new(-file => 'result.Genemark');\n   # filehandle:\n   $Genemark = Bio::Tools::Genemark->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $Genemark->next_feature() is the same\n   while($gene = $Genemark->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of\n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons:\n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $Genemark->close();\n\n=head1 DESCRIPTION\n\nThe Genemark module provides a parser for Genemark gene structure\nprediction output. It parses one gene prediction into a\nBio::SeqFeature::Gene::Transcript- derived object.\n\nThis module has been developed around genemark.hmm for eukaryots v2.2a\nand will probably not work with other versions.\n\n\nThis module also implements the Bio::SeqAnalysisParserI interface, and\nthus can be used wherever such an object fits. See\nL<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp, Mark Fiers\n\nEmail hlapp@gmx.net\n      m.w.e.j.fiers@plant.wag-ur.nl\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Genemark;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\nuse Bio::Seq;\nuse Bio::Factory::FTLocationFactory;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Genemark->new();\n Function: Builds a new Bio::Tools::Genemark object\n Returns : an instance of Bio::Tools::Genemark\n Args    : seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($seqname) = $self->_rearrange([qw(SEQNAME)], @args);\n\n  # hardwire seq_id when creating gene and exon objects\n  $self->_seqname($seqname) if defined($seqname);\n\n  return $self;\n}\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $Genemark->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /GeneMark.hmm/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method {\n#-------------\n    my ($self, $method) = @_;\n    if($method && ($method !~ /Genemark\\.hmm/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $Genemark->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genemark result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for\n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $Genemark->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genemark result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # get next gene structure\n    $gene = $self->_prediction();\n\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns :\n\n\nsub _parse_predictions {\n    my ($self) = @_;\n    my %exontags = ('Initial' => 'Initial',\n\t\t    'Internal' => 'Internal',\n\t\t    'Terminal' => 'Terminal',\n\t\t    'Single' => '',\n\t\t    '_na_' => '');\n    my $exontag;\n    my $gene;\n    my $exontype;\n    my $current_gene_no = -1;\n\n    # The prediction report does not contain a sequence identifier\n    # (at least the prokaryotic version doesn't)\n    my $seqname = $self->_seqname();\n    \n    while(defined($_ = $self->_readline())) {\n\n\tif( (/^\\s*(\\d+)\\s+(\\d+)/) || (/^\\s*(\\d+)\\s+[\\+\\-]/)) {\n\n\t    #  this is an exon, Genemark doesn't predict anything else\n\t    # $prednr corresponds to geneno.\n\t    my $prednr = $1;\n\n\t    #exon no:\n\t    my $signalnr = 0;\n\t    if ($2) { my $signalnr = $2; } # used in tag: exon_no\n\t\n\t    # split into fields\n\t    chomp();\n\t    my @flds = split(' ', $_);\n\n\t    # create the feature (an exon) object\n\t    my $predobj = Bio::Tools::Prediction::Exon->new();\n\n\t\t\n\t    # define info depending on it being eu- or prokaryot\n\t    my ($start, $end, $orientation, $prediction_source);\n\n\t    if ($self->analysis_method() =~ /PROKARYOTIC/i) {\n\t        $prediction_source = \"Genemark.hmm.pro\";\n\t       \t$orientation = ($flds[1] eq '+') ? 1 : -1;\n\t        ($start, $end) = @flds[(2,3)];\n\t\t$exontag = \"_na_\";\n\n\t    } else {\t\t\n\t        $prediction_source = \"Genemark.hmm.eu\";\n\t       \t$orientation = ($flds[2] eq '+') ? 1 : -1;\n\t        ($start, $end) = @flds[(4,5)];\n\t\t$exontag = $flds[3];\n\t    }\n\n            # instatiate a location object via\n            # Bio::Factory::FTLocationFactory (to handle\n            # inexact coordinates)\n            my $location_string = join('..', $start, $end);\n            my $location_factory = Bio::Factory::FTLocationFactory->new();\n            my $location_obj = $location_factory->from_string($location_string);\n            $predobj->location($location_obj);\n\n            #store the data in the exon object\n            $predobj->source_tag($prediction_source);\n\t    $predobj->strand($orientation);\n\n\t    $predobj->primary_tag($exontags{$exontag} . \"Exon\");\n\n\t    $predobj->add_tag_value('exon_no',\"$signalnr\") if ($signalnr);\n\n    \t    $predobj->is_coding(1);\n\n            $predobj->seq_id($seqname) if (defined($seqname) && ($seqname ne 'unknown'));\n\t\t\n\t    # frame calculation as in the genscan module\n\t    # is to be implemented...\n\t\n\t    #If the $prednr is not equal to the current gene, we\n\t    #need to make a new gene and close the old one\n\t    if($prednr != $current_gene_no) {\n \t        # a new gene, store the old one if it exists\n\t\tif (defined ($gene)) {\n\t\t    $gene->seq_id($seqname);\n\t\t    $gene = undef ;\n\t\t}\n\t\t#and make a new one\n\t\t$gene = Bio::Tools::Prediction::Gene->new\n\t\t    (\n\t\t     '-primary' => \"GenePrediction$prednr\",\n\t\t     '-source' => $prediction_source);\n                $self->_add_prediction($gene);\t\t\n\t\t$current_gene_no = $prednr;\n                $gene->seq_id($seqname) if (defined($seqname) && ($seqname ne 'unknown'));\n\t    }\n\t\n\t    # Add the exon to the gene\n\t    $gene->add_exon($predobj, ($exontag eq \"_na_\" ?\n\t\t\t\t       undef : $exontags{$exontag}));\n\n\t}\n\n\tif(/^(Genemark\\.hmm\\s*[PROKARYOTIC]*)\\s+\\(Version (.*)\\)$/i) {\n\t    $self->analysis_method($1);\n\n\t    my $gm_version = $2;\n\n\t    $self->analysis_method_version($gm_version);\n\t    next;\n\t}\n\n       #Matrix file for eukaryot version\n       if (/^Matrices file:\\s+(\\S+)?/i)  {\n\t    $self->analysis_subject($1);\n\t    # since the line after the matrix file is always the date\n\t    # (in the output file's I have seen!) extract and store this\n\t    # here\n\t     if (defined(my $_date = $self->_readline())) {\n\t         chomp ($_date);\n\t     \t $self->analysis_date($_date);\n\t     }\n\t}\t\t\t\n\t\n        #Matrix file for prokaryot version\n       if (/^Model file name:\\s+(\\S+)/) {\n\t    $self->analysis_subject($1);\n\t    # since the line after the matrix file is always the date\n\t    # (in the output file's I have seen!) extract and store this\n\t    # here\n\t    my $_date = $self->_readline() ;\n\t    if (defined($_date = $self->_readline())) {\n\t         chomp ($_date);\n\t     \t $self->analysis_date($_date);\n\t     }\n\t}\n\t\n\tif(/^Sequence[ file]? name:\\s+(.+)\\s*$/i) {\n\t    $seqname = $1;\n\t    #    $self->analysis_subject($seqname);\n\t    next;\n\t}\n\t\n\n\t/^>/ && do {\t\t\n    \t    $self->_pushback($_);\n\n\t    # section of predicted aa sequences on recognition\n\t    # of a fasta start, read all sequences and find the\n\t    # appropriate gene\n            while (1) {\n\t       my ($aa_id, $seq) = $self->_read_fasta_seq();\n\t       last unless ($aa_id);\n\n\t       #now parse through the predictions to add the pred. protein\n\t       FINDPRED: foreach my $gene (@{$self->{'_preds'}}) {\n\t            $gene->primary_tag() =~ /[^0-9]([0-9]+)$/;\n\t\t    my $geneno = $1;\n\t\t    if ($aa_id =~ /\\|gene.$geneno\\|/) {\n\t\t          #print \"x SEQ : \\n $seq \\nXXXX\\n\";\n  \t\t\t  my $seqobj = Bio::Seq->new('-seq' => $seq,\n\t                     \t\t             '-display_id' => $aa_id,\n\t\t\t\t\t              '-alphabet' => \"protein\");\n\t\t\t$gene->predicted_protein($seqobj);\n\t\t\tlast FINDPRED;\n\t\t    }\t\n\n\t       }\n           }\t\t\t\t\n\n \t   last;\n\t};\n    }\n\n    # if the analysis query object contains a ref to a Seq of PrimarySeq\n    # object, then extract the predicted sequences and add it to the gene\n    # object.\n    if (defined $self->analysis_query()) {\n        my $orig_seq = $self->analysis_query();\n        FINDPREDSEQ: foreach my $gene (@{$self->{'_preds'}}) {\n\t   my $predseq = \"\";\n\t   foreach my $exon ($gene->exons()) {\n\t\t#print $exon->start() . \" \" . $exon->end () . \"\\n\";\n\t\t$predseq .= $orig_seq->subseq($exon->start(), $exon->end());\n\t   }\n\n\t   my $seqobj = Bio::PrimarySeq->new('-seq' => $predseq,\n\t                     \t\t     '-display_id' => \"transl\");\n\t   $gene->predicted_cds($seqobj);\n\t}\n    }\n\n\n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns :","label":"_prediction($self)"},"kind":12,"range":{"start":{"character":0,"line":450},"end":{"character":9999,"line":453}},"line":450},{"line":454,"kind":13,"containerName":null,"name":"%self"},{"kind":12,"range":{"start":{"line":467,"character":0},"end":{"line":473,"character":9999}},"line":467,"signature":{"label":"_add_prediction($self,$gene)","documentation":"1;\n# $Id: Genemark.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Genemark\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mark Fiers <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp, Mark Fiers\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Genemark - Results of one Genemark run\n\n=head1 SYNOPSIS\n\n   $Genemark = Bio::Tools::Genemark->new(-file => 'result.Genemark');\n   # filehandle:\n   $Genemark = Bio::Tools::Genemark->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $Genemark->next_feature() is the same\n   while($gene = $Genemark->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of\n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons:\n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $Genemark->close();\n\n=head1 DESCRIPTION\n\nThe Genemark module provides a parser for Genemark gene structure\nprediction output. It parses one gene prediction into a\nBio::SeqFeature::Gene::Transcript- derived object.\n\nThis module has been developed around genemark.hmm for eukaryots v2.2a\nand will probably not work with other versions.\n\n\nThis module also implements the Bio::SeqAnalysisParserI interface, and\nthus can be used wherever such an object fits. See\nL<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp, Mark Fiers\n\nEmail hlapp@gmx.net\n      m.w.e.j.fiers@plant.wag-ur.nl\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Genemark;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\nuse Bio::Seq;\nuse Bio::Factory::FTLocationFactory;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Genemark->new();\n Function: Builds a new Bio::Tools::Genemark object\n Returns : an instance of Bio::Tools::Genemark\n Args    : seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($seqname) = $self->_rearrange([qw(SEQNAME)], @args);\n\n  # hardwire seq_id when creating gene and exon objects\n  $self->_seqname($seqname) if defined($seqname);\n\n  return $self;\n}\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $Genemark->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /GeneMark.hmm/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method {\n#-------------\n    my ($self, $method) = @_;\n    if($method && ($method !~ /Genemark\\.hmm/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $Genemark->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genemark result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for\n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $Genemark->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genemark result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # get next gene structure\n    $gene = $self->_prediction();\n\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns :\n\n\nsub _parse_predictions {\n    my ($self) = @_;\n    my %exontags = ('Initial' => 'Initial',\n\t\t    'Internal' => 'Internal',\n\t\t    'Terminal' => 'Terminal',\n\t\t    'Single' => '',\n\t\t    '_na_' => '');\n    my $exontag;\n    my $gene;\n    my $exontype;\n    my $current_gene_no = -1;\n\n    # The prediction report does not contain a sequence identifier\n    # (at least the prokaryotic version doesn't)\n    my $seqname = $self->_seqname();\n    \n    while(defined($_ = $self->_readline())) {\n\n\tif( (/^\\s*(\\d+)\\s+(\\d+)/) || (/^\\s*(\\d+)\\s+[\\+\\-]/)) {\n\n\t    #  this is an exon, Genemark doesn't predict anything else\n\t    # $prednr corresponds to geneno.\n\t    my $prednr = $1;\n\n\t    #exon no:\n\t    my $signalnr = 0;\n\t    if ($2) { my $signalnr = $2; } # used in tag: exon_no\n\t\n\t    # split into fields\n\t    chomp();\n\t    my @flds = split(' ', $_);\n\n\t    # create the feature (an exon) object\n\t    my $predobj = Bio::Tools::Prediction::Exon->new();\n\n\t\t\n\t    # define info depending on it being eu- or prokaryot\n\t    my ($start, $end, $orientation, $prediction_source);\n\n\t    if ($self->analysis_method() =~ /PROKARYOTIC/i) {\n\t        $prediction_source = \"Genemark.hmm.pro\";\n\t       \t$orientation = ($flds[1] eq '+') ? 1 : -1;\n\t        ($start, $end) = @flds[(2,3)];\n\t\t$exontag = \"_na_\";\n\n\t    } else {\t\t\n\t        $prediction_source = \"Genemark.hmm.eu\";\n\t       \t$orientation = ($flds[2] eq '+') ? 1 : -1;\n\t        ($start, $end) = @flds[(4,5)];\n\t\t$exontag = $flds[3];\n\t    }\n\n            # instatiate a location object via\n            # Bio::Factory::FTLocationFactory (to handle\n            # inexact coordinates)\n            my $location_string = join('..', $start, $end);\n            my $location_factory = Bio::Factory::FTLocationFactory->new();\n            my $location_obj = $location_factory->from_string($location_string);\n            $predobj->location($location_obj);\n\n            #store the data in the exon object\n            $predobj->source_tag($prediction_source);\n\t    $predobj->strand($orientation);\n\n\t    $predobj->primary_tag($exontags{$exontag} . \"Exon\");\n\n\t    $predobj->add_tag_value('exon_no',\"$signalnr\") if ($signalnr);\n\n    \t    $predobj->is_coding(1);\n\n            $predobj->seq_id($seqname) if (defined($seqname) && ($seqname ne 'unknown'));\n\t\t\n\t    # frame calculation as in the genscan module\n\t    # is to be implemented...\n\t\n\t    #If the $prednr is not equal to the current gene, we\n\t    #need to make a new gene and close the old one\n\t    if($prednr != $current_gene_no) {\n \t        # a new gene, store the old one if it exists\n\t\tif (defined ($gene)) {\n\t\t    $gene->seq_id($seqname);\n\t\t    $gene = undef ;\n\t\t}\n\t\t#and make a new one\n\t\t$gene = Bio::Tools::Prediction::Gene->new\n\t\t    (\n\t\t     '-primary' => \"GenePrediction$prednr\",\n\t\t     '-source' => $prediction_source);\n                $self->_add_prediction($gene);\t\t\n\t\t$current_gene_no = $prednr;\n                $gene->seq_id($seqname) if (defined($seqname) && ($seqname ne 'unknown'));\n\t    }\n\t\n\t    # Add the exon to the gene\n\t    $gene->add_exon($predobj, ($exontag eq \"_na_\" ?\n\t\t\t\t       undef : $exontags{$exontag}));\n\n\t}\n\n\tif(/^(Genemark\\.hmm\\s*[PROKARYOTIC]*)\\s+\\(Version (.*)\\)$/i) {\n\t    $self->analysis_method($1);\n\n\t    my $gm_version = $2;\n\n\t    $self->analysis_method_version($gm_version);\n\t    next;\n\t}\n\n       #Matrix file for eukaryot version\n       if (/^Matrices file:\\s+(\\S+)?/i)  {\n\t    $self->analysis_subject($1);\n\t    # since the line after the matrix file is always the date\n\t    # (in the output file's I have seen!) extract and store this\n\t    # here\n\t     if (defined(my $_date = $self->_readline())) {\n\t         chomp ($_date);\n\t     \t $self->analysis_date($_date);\n\t     }\n\t}\t\t\t\n\t\n        #Matrix file for prokaryot version\n       if (/^Model file name:\\s+(\\S+)/) {\n\t    $self->analysis_subject($1);\n\t    # since the line after the matrix file is always the date\n\t    # (in the output file's I have seen!) extract and store this\n\t    # here\n\t    my $_date = $self->_readline() ;\n\t    if (defined($_date = $self->_readline())) {\n\t         chomp ($_date);\n\t     \t $self->analysis_date($_date);\n\t     }\n\t}\n\t\n\tif(/^Sequence[ file]? name:\\s+(.+)\\s*$/i) {\n\t    $seqname = $1;\n\t    #    $self->analysis_subject($seqname);\n\t    next;\n\t}\n\t\n\n\t/^>/ && do {\t\t\n    \t    $self->_pushback($_);\n\n\t    # section of predicted aa sequences on recognition\n\t    # of a fasta start, read all sequences and find the\n\t    # appropriate gene\n            while (1) {\n\t       my ($aa_id, $seq) = $self->_read_fasta_seq();\n\t       last unless ($aa_id);\n\n\t       #now parse through the predictions to add the pred. protein\n\t       FINDPRED: foreach my $gene (@{$self->{'_preds'}}) {\n\t            $gene->primary_tag() =~ /[^0-9]([0-9]+)$/;\n\t\t    my $geneno = $1;\n\t\t    if ($aa_id =~ /\\|gene.$geneno\\|/) {\n\t\t          #print \"x SEQ : \\n $seq \\nXXXX\\n\";\n  \t\t\t  my $seqobj = Bio::Seq->new('-seq' => $seq,\n\t                     \t\t             '-display_id' => $aa_id,\n\t\t\t\t\t              '-alphabet' => \"protein\");\n\t\t\t$gene->predicted_protein($seqobj);\n\t\t\tlast FINDPRED;\n\t\t    }\t\n\n\t       }\n           }\t\t\t\t\n\n \t   last;\n\t};\n    }\n\n    # if the analysis query object contains a ref to a Seq of PrimarySeq\n    # object, then extract the predicted sequences and add it to the gene\n    # object.\n    if (defined $self->analysis_query()) {\n        my $orig_seq = $self->analysis_query();\n        FINDPREDSEQ: foreach my $gene (@{$self->{'_preds'}}) {\n\t   my $predseq = \"\";\n\t   foreach my $exon ($gene->exons()) {\n\t\t#print $exon->start() . \" \" . $exon->end () . \"\\n\";\n\t\t$predseq .= $orig_seq->subseq($exon->start(), $exon->end());\n\t   }\n\n\t   my $seqobj = Bio::PrimarySeq->new('-seq' => $predseq,\n\t                     \t\t     '-display_id' => \"transl\");\n\t   $gene->predicted_cds($seqobj);\n\t}\n    }\n\n\n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns :\n\n\nsub _prediction {\n    my ($self) = @_;\n\n    return unless(exists($self->{'_preds'}) && @{$self->{'_preds'}});\n    return shift(@{$self->{'_preds'}});\n}\n\n=head2 _add_prediction\n\n Title   : _add_prediction()\n Usage   : $obj->_add_prediction($gene)\n Function: internal\n Example :\n Returns :","parameters":[{"label":"$self"},{"label":"$gene"}]},"containerName":"main::","name":"_add_prediction","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"_add_prediction","line":468},{"line":468,"name":"$gene","kind":13,"containerName":"_add_prediction"},{"line":470,"name":"$self","kind":13,"containerName":"_add_prediction"},{"containerName":"_add_prediction","kind":13,"name":"$self","line":471},{"name":"$self","containerName":"_add_prediction","kind":13,"line":473}],"detail":"($self,$gene)","definition":"sub"},{"line":473,"name":"$gene","kind":13,"containerName":null},{"detail":"($self,$val)","definition":"sub","containerName":"main::","name":"_predictions_parsed","children":[{"definition":"my","name":"$self","containerName":"_predictions_parsed","localvar":"my","kind":13,"line":487},{"line":487,"containerName":"_predictions_parsed","kind":13,"name":"$val"},{"kind":13,"containerName":"_predictions_parsed","name":"$self","line":489},{"kind":13,"containerName":"_predictions_parsed","name":"$val","line":489},{"containerName":"_predictions_parsed","kind":13,"name":"$val","line":489},{"containerName":"_predictions_parsed","kind":13,"name":"$self","line":490},{"kind":13,"containerName":"_predictions_parsed","name":"$self","line":491},{"containerName":"_predictions_parsed","kind":13,"name":"$self","line":493}],"signature":{"parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: Genemark.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Genemark\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mark Fiers <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp, Mark Fiers\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Genemark - Results of one Genemark run\n\n=head1 SYNOPSIS\n\n   $Genemark = Bio::Tools::Genemark->new(-file => 'result.Genemark');\n   # filehandle:\n   $Genemark = Bio::Tools::Genemark->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $Genemark->next_feature() is the same\n   while($gene = $Genemark->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of\n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons:\n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $Genemark->close();\n\n=head1 DESCRIPTION\n\nThe Genemark module provides a parser for Genemark gene structure\nprediction output. It parses one gene prediction into a\nBio::SeqFeature::Gene::Transcript- derived object.\n\nThis module has been developed around genemark.hmm for eukaryots v2.2a\nand will probably not work with other versions.\n\n\nThis module also implements the Bio::SeqAnalysisParserI interface, and\nthus can be used wherever such an object fits. See\nL<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp, Mark Fiers\n\nEmail hlapp@gmx.net\n      m.w.e.j.fiers@plant.wag-ur.nl\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Genemark;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\nuse Bio::Seq;\nuse Bio::Factory::FTLocationFactory;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Genemark->new();\n Function: Builds a new Bio::Tools::Genemark object\n Returns : an instance of Bio::Tools::Genemark\n Args    : seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($seqname) = $self->_rearrange([qw(SEQNAME)], @args);\n\n  # hardwire seq_id when creating gene and exon objects\n  $self->_seqname($seqname) if defined($seqname);\n\n  return $self;\n}\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $Genemark->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /GeneMark.hmm/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method {\n#-------------\n    my ($self, $method) = @_;\n    if($method && ($method !~ /Genemark\\.hmm/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $Genemark->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genemark result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for\n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $Genemark->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genemark result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # get next gene structure\n    $gene = $self->_prediction();\n\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns :\n\n\nsub _parse_predictions {\n    my ($self) = @_;\n    my %exontags = ('Initial' => 'Initial',\n\t\t    'Internal' => 'Internal',\n\t\t    'Terminal' => 'Terminal',\n\t\t    'Single' => '',\n\t\t    '_na_' => '');\n    my $exontag;\n    my $gene;\n    my $exontype;\n    my $current_gene_no = -1;\n\n    # The prediction report does not contain a sequence identifier\n    # (at least the prokaryotic version doesn't)\n    my $seqname = $self->_seqname();\n    \n    while(defined($_ = $self->_readline())) {\n\n\tif( (/^\\s*(\\d+)\\s+(\\d+)/) || (/^\\s*(\\d+)\\s+[\\+\\-]/)) {\n\n\t    #  this is an exon, Genemark doesn't predict anything else\n\t    # $prednr corresponds to geneno.\n\t    my $prednr = $1;\n\n\t    #exon no:\n\t    my $signalnr = 0;\n\t    if ($2) { my $signalnr = $2; } # used in tag: exon_no\n\t\n\t    # split into fields\n\t    chomp();\n\t    my @flds = split(' ', $_);\n\n\t    # create the feature (an exon) object\n\t    my $predobj = Bio::Tools::Prediction::Exon->new();\n\n\t\t\n\t    # define info depending on it being eu- or prokaryot\n\t    my ($start, $end, $orientation, $prediction_source);\n\n\t    if ($self->analysis_method() =~ /PROKARYOTIC/i) {\n\t        $prediction_source = \"Genemark.hmm.pro\";\n\t       \t$orientation = ($flds[1] eq '+') ? 1 : -1;\n\t        ($start, $end) = @flds[(2,3)];\n\t\t$exontag = \"_na_\";\n\n\t    } else {\t\t\n\t        $prediction_source = \"Genemark.hmm.eu\";\n\t       \t$orientation = ($flds[2] eq '+') ? 1 : -1;\n\t        ($start, $end) = @flds[(4,5)];\n\t\t$exontag = $flds[3];\n\t    }\n\n            # instatiate a location object via\n            # Bio::Factory::FTLocationFactory (to handle\n            # inexact coordinates)\n            my $location_string = join('..', $start, $end);\n            my $location_factory = Bio::Factory::FTLocationFactory->new();\n            my $location_obj = $location_factory->from_string($location_string);\n            $predobj->location($location_obj);\n\n            #store the data in the exon object\n            $predobj->source_tag($prediction_source);\n\t    $predobj->strand($orientation);\n\n\t    $predobj->primary_tag($exontags{$exontag} . \"Exon\");\n\n\t    $predobj->add_tag_value('exon_no',\"$signalnr\") if ($signalnr);\n\n    \t    $predobj->is_coding(1);\n\n            $predobj->seq_id($seqname) if (defined($seqname) && ($seqname ne 'unknown'));\n\t\t\n\t    # frame calculation as in the genscan module\n\t    # is to be implemented...\n\t\n\t    #If the $prednr is not equal to the current gene, we\n\t    #need to make a new gene and close the old one\n\t    if($prednr != $current_gene_no) {\n \t        # a new gene, store the old one if it exists\n\t\tif (defined ($gene)) {\n\t\t    $gene->seq_id($seqname);\n\t\t    $gene = undef ;\n\t\t}\n\t\t#and make a new one\n\t\t$gene = Bio::Tools::Prediction::Gene->new\n\t\t    (\n\t\t     '-primary' => \"GenePrediction$prednr\",\n\t\t     '-source' => $prediction_source);\n                $self->_add_prediction($gene);\t\t\n\t\t$current_gene_no = $prednr;\n                $gene->seq_id($seqname) if (defined($seqname) && ($seqname ne 'unknown'));\n\t    }\n\t\n\t    # Add the exon to the gene\n\t    $gene->add_exon($predobj, ($exontag eq \"_na_\" ?\n\t\t\t\t       undef : $exontags{$exontag}));\n\n\t}\n\n\tif(/^(Genemark\\.hmm\\s*[PROKARYOTIC]*)\\s+\\(Version (.*)\\)$/i) {\n\t    $self->analysis_method($1);\n\n\t    my $gm_version = $2;\n\n\t    $self->analysis_method_version($gm_version);\n\t    next;\n\t}\n\n       #Matrix file for eukaryot version\n       if (/^Matrices file:\\s+(\\S+)?/i)  {\n\t    $self->analysis_subject($1);\n\t    # since the line after the matrix file is always the date\n\t    # (in the output file's I have seen!) extract and store this\n\t    # here\n\t     if (defined(my $_date = $self->_readline())) {\n\t         chomp ($_date);\n\t     \t $self->analysis_date($_date);\n\t     }\n\t}\t\t\t\n\t\n        #Matrix file for prokaryot version\n       if (/^Model file name:\\s+(\\S+)/) {\n\t    $self->analysis_subject($1);\n\t    # since the line after the matrix file is always the date\n\t    # (in the output file's I have seen!) extract and store this\n\t    # here\n\t    my $_date = $self->_readline() ;\n\t    if (defined($_date = $self->_readline())) {\n\t         chomp ($_date);\n\t     \t $self->analysis_date($_date);\n\t     }\n\t}\n\t\n\tif(/^Sequence[ file]? name:\\s+(.+)\\s*$/i) {\n\t    $seqname = $1;\n\t    #    $self->analysis_subject($seqname);\n\t    next;\n\t}\n\t\n\n\t/^>/ && do {\t\t\n    \t    $self->_pushback($_);\n\n\t    # section of predicted aa sequences on recognition\n\t    # of a fasta start, read all sequences and find the\n\t    # appropriate gene\n            while (1) {\n\t       my ($aa_id, $seq) = $self->_read_fasta_seq();\n\t       last unless ($aa_id);\n\n\t       #now parse through the predictions to add the pred. protein\n\t       FINDPRED: foreach my $gene (@{$self->{'_preds'}}) {\n\t            $gene->primary_tag() =~ /[^0-9]([0-9]+)$/;\n\t\t    my $geneno = $1;\n\t\t    if ($aa_id =~ /\\|gene.$geneno\\|/) {\n\t\t          #print \"x SEQ : \\n $seq \\nXXXX\\n\";\n  \t\t\t  my $seqobj = Bio::Seq->new('-seq' => $seq,\n\t                     \t\t             '-display_id' => $aa_id,\n\t\t\t\t\t              '-alphabet' => \"protein\");\n\t\t\t$gene->predicted_protein($seqobj);\n\t\t\tlast FINDPRED;\n\t\t    }\t\n\n\t       }\n           }\t\t\t\t\n\n \t   last;\n\t};\n    }\n\n    # if the analysis query object contains a ref to a Seq of PrimarySeq\n    # object, then extract the predicted sequences and add it to the gene\n    # object.\n    if (defined $self->analysis_query()) {\n        my $orig_seq = $self->analysis_query();\n        FINDPREDSEQ: foreach my $gene (@{$self->{'_preds'}}) {\n\t   my $predseq = \"\";\n\t   foreach my $exon ($gene->exons()) {\n\t\t#print $exon->start() . \" \" . $exon->end () . \"\\n\";\n\t\t$predseq .= $orig_seq->subseq($exon->start(), $exon->end());\n\t   }\n\n\t   my $seqobj = Bio::PrimarySeq->new('-seq' => $predseq,\n\t                     \t\t     '-display_id' => \"transl\");\n\t   $gene->predicted_cds($seqobj);\n\t}\n    }\n\n\n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns :\n\n\nsub _prediction {\n    my ($self) = @_;\n\n    return unless(exists($self->{'_preds'}) && @{$self->{'_preds'}});\n    return shift(@{$self->{'_preds'}});\n}\n\n=head2 _add_prediction\n\n Title   : _add_prediction()\n Usage   : $obj->_add_prediction($gene)\n Function: internal\n Example :\n Returns :\n\n\nsub _add_prediction {\n    my ($self, $gene) = @_;\n\n    if(! exists($self->{'_preds'})) {\n\t$self->{'_preds'} = [];\n    }\n    push(@{$self->{'_preds'}}, $gene);\n}\n\n=head2 _predictions_parsed\n\n Title   : _predictions_parsed\n Usage   : $obj->_predictions_parsed\n Function: internal\n Example :\n Returns : TRUE or FALSE","label":"_predictions_parsed($self,$val)"},"kind":12,"range":{"end":{"character":9999,"line":494},"start":{"line":486,"character":0}},"line":486},{"line":506,"kind":12,"range":{"start":{"line":506,"character":0},"end":{"line":514,"character":9999}},"signature":{"label":"_has_cds($self,$val)","parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: Genemark.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Genemark\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mark Fiers <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp, Mark Fiers\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Genemark - Results of one Genemark run\n\n=head1 SYNOPSIS\n\n   $Genemark = Bio::Tools::Genemark->new(-file => 'result.Genemark');\n   # filehandle:\n   $Genemark = Bio::Tools::Genemark->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $Genemark->next_feature() is the same\n   while($gene = $Genemark->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of\n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons:\n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $Genemark->close();\n\n=head1 DESCRIPTION\n\nThe Genemark module provides a parser for Genemark gene structure\nprediction output. It parses one gene prediction into a\nBio::SeqFeature::Gene::Transcript- derived object.\n\nThis module has been developed around genemark.hmm for eukaryots v2.2a\nand will probably not work with other versions.\n\n\nThis module also implements the Bio::SeqAnalysisParserI interface, and\nthus can be used wherever such an object fits. See\nL<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp, Mark Fiers\n\nEmail hlapp@gmx.net\n      m.w.e.j.fiers@plant.wag-ur.nl\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Genemark;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\nuse Bio::Seq;\nuse Bio::Factory::FTLocationFactory;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Genemark->new();\n Function: Builds a new Bio::Tools::Genemark object\n Returns : an instance of Bio::Tools::Genemark\n Args    : seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($seqname) = $self->_rearrange([qw(SEQNAME)], @args);\n\n  # hardwire seq_id when creating gene and exon objects\n  $self->_seqname($seqname) if defined($seqname);\n\n  return $self;\n}\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $Genemark->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /GeneMark.hmm/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method {\n#-------------\n    my ($self, $method) = @_;\n    if($method && ($method !~ /Genemark\\.hmm/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $Genemark->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genemark result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for\n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $Genemark->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genemark result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # get next gene structure\n    $gene = $self->_prediction();\n\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns :\n\n\nsub _parse_predictions {\n    my ($self) = @_;\n    my %exontags = ('Initial' => 'Initial',\n\t\t    'Internal' => 'Internal',\n\t\t    'Terminal' => 'Terminal',\n\t\t    'Single' => '',\n\t\t    '_na_' => '');\n    my $exontag;\n    my $gene;\n    my $exontype;\n    my $current_gene_no = -1;\n\n    # The prediction report does not contain a sequence identifier\n    # (at least the prokaryotic version doesn't)\n    my $seqname = $self->_seqname();\n    \n    while(defined($_ = $self->_readline())) {\n\n\tif( (/^\\s*(\\d+)\\s+(\\d+)/) || (/^\\s*(\\d+)\\s+[\\+\\-]/)) {\n\n\t    #  this is an exon, Genemark doesn't predict anything else\n\t    # $prednr corresponds to geneno.\n\t    my $prednr = $1;\n\n\t    #exon no:\n\t    my $signalnr = 0;\n\t    if ($2) { my $signalnr = $2; } # used in tag: exon_no\n\t\n\t    # split into fields\n\t    chomp();\n\t    my @flds = split(' ', $_);\n\n\t    # create the feature (an exon) object\n\t    my $predobj = Bio::Tools::Prediction::Exon->new();\n\n\t\t\n\t    # define info depending on it being eu- or prokaryot\n\t    my ($start, $end, $orientation, $prediction_source);\n\n\t    if ($self->analysis_method() =~ /PROKARYOTIC/i) {\n\t        $prediction_source = \"Genemark.hmm.pro\";\n\t       \t$orientation = ($flds[1] eq '+') ? 1 : -1;\n\t        ($start, $end) = @flds[(2,3)];\n\t\t$exontag = \"_na_\";\n\n\t    } else {\t\t\n\t        $prediction_source = \"Genemark.hmm.eu\";\n\t       \t$orientation = ($flds[2] eq '+') ? 1 : -1;\n\t        ($start, $end) = @flds[(4,5)];\n\t\t$exontag = $flds[3];\n\t    }\n\n            # instatiate a location object via\n            # Bio::Factory::FTLocationFactory (to handle\n            # inexact coordinates)\n            my $location_string = join('..', $start, $end);\n            my $location_factory = Bio::Factory::FTLocationFactory->new();\n            my $location_obj = $location_factory->from_string($location_string);\n            $predobj->location($location_obj);\n\n            #store the data in the exon object\n            $predobj->source_tag($prediction_source);\n\t    $predobj->strand($orientation);\n\n\t    $predobj->primary_tag($exontags{$exontag} . \"Exon\");\n\n\t    $predobj->add_tag_value('exon_no',\"$signalnr\") if ($signalnr);\n\n    \t    $predobj->is_coding(1);\n\n            $predobj->seq_id($seqname) if (defined($seqname) && ($seqname ne 'unknown'));\n\t\t\n\t    # frame calculation as in the genscan module\n\t    # is to be implemented...\n\t\n\t    #If the $prednr is not equal to the current gene, we\n\t    #need to make a new gene and close the old one\n\t    if($prednr != $current_gene_no) {\n \t        # a new gene, store the old one if it exists\n\t\tif (defined ($gene)) {\n\t\t    $gene->seq_id($seqname);\n\t\t    $gene = undef ;\n\t\t}\n\t\t#and make a new one\n\t\t$gene = Bio::Tools::Prediction::Gene->new\n\t\t    (\n\t\t     '-primary' => \"GenePrediction$prednr\",\n\t\t     '-source' => $prediction_source);\n                $self->_add_prediction($gene);\t\t\n\t\t$current_gene_no = $prednr;\n                $gene->seq_id($seqname) if (defined($seqname) && ($seqname ne 'unknown'));\n\t    }\n\t\n\t    # Add the exon to the gene\n\t    $gene->add_exon($predobj, ($exontag eq \"_na_\" ?\n\t\t\t\t       undef : $exontags{$exontag}));\n\n\t}\n\n\tif(/^(Genemark\\.hmm\\s*[PROKARYOTIC]*)\\s+\\(Version (.*)\\)$/i) {\n\t    $self->analysis_method($1);\n\n\t    my $gm_version = $2;\n\n\t    $self->analysis_method_version($gm_version);\n\t    next;\n\t}\n\n       #Matrix file for eukaryot version\n       if (/^Matrices file:\\s+(\\S+)?/i)  {\n\t    $self->analysis_subject($1);\n\t    # since the line after the matrix file is always the date\n\t    # (in the output file's I have seen!) extract and store this\n\t    # here\n\t     if (defined(my $_date = $self->_readline())) {\n\t         chomp ($_date);\n\t     \t $self->analysis_date($_date);\n\t     }\n\t}\t\t\t\n\t\n        #Matrix file for prokaryot version\n       if (/^Model file name:\\s+(\\S+)/) {\n\t    $self->analysis_subject($1);\n\t    # since the line after the matrix file is always the date\n\t    # (in the output file's I have seen!) extract and store this\n\t    # here\n\t    my $_date = $self->_readline() ;\n\t    if (defined($_date = $self->_readline())) {\n\t         chomp ($_date);\n\t     \t $self->analysis_date($_date);\n\t     }\n\t}\n\t\n\tif(/^Sequence[ file]? name:\\s+(.+)\\s*$/i) {\n\t    $seqname = $1;\n\t    #    $self->analysis_subject($seqname);\n\t    next;\n\t}\n\t\n\n\t/^>/ && do {\t\t\n    \t    $self->_pushback($_);\n\n\t    # section of predicted aa sequences on recognition\n\t    # of a fasta start, read all sequences and find the\n\t    # appropriate gene\n            while (1) {\n\t       my ($aa_id, $seq) = $self->_read_fasta_seq();\n\t       last unless ($aa_id);\n\n\t       #now parse through the predictions to add the pred. protein\n\t       FINDPRED: foreach my $gene (@{$self->{'_preds'}}) {\n\t            $gene->primary_tag() =~ /[^0-9]([0-9]+)$/;\n\t\t    my $geneno = $1;\n\t\t    if ($aa_id =~ /\\|gene.$geneno\\|/) {\n\t\t          #print \"x SEQ : \\n $seq \\nXXXX\\n\";\n  \t\t\t  my $seqobj = Bio::Seq->new('-seq' => $seq,\n\t                     \t\t             '-display_id' => $aa_id,\n\t\t\t\t\t              '-alphabet' => \"protein\");\n\t\t\t$gene->predicted_protein($seqobj);\n\t\t\tlast FINDPRED;\n\t\t    }\t\n\n\t       }\n           }\t\t\t\t\n\n \t   last;\n\t};\n    }\n\n    # if the analysis query object contains a ref to a Seq of PrimarySeq\n    # object, then extract the predicted sequences and add it to the gene\n    # object.\n    if (defined $self->analysis_query()) {\n        my $orig_seq = $self->analysis_query();\n        FINDPREDSEQ: foreach my $gene (@{$self->{'_preds'}}) {\n\t   my $predseq = \"\";\n\t   foreach my $exon ($gene->exons()) {\n\t\t#print $exon->start() . \" \" . $exon->end () . \"\\n\";\n\t\t$predseq .= $orig_seq->subseq($exon->start(), $exon->end());\n\t   }\n\n\t   my $seqobj = Bio::PrimarySeq->new('-seq' => $predseq,\n\t                     \t\t     '-display_id' => \"transl\");\n\t   $gene->predicted_cds($seqobj);\n\t}\n    }\n\n\n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns :\n\n\nsub _prediction {\n    my ($self) = @_;\n\n    return unless(exists($self->{'_preds'}) && @{$self->{'_preds'}});\n    return shift(@{$self->{'_preds'}});\n}\n\n=head2 _add_prediction\n\n Title   : _add_prediction()\n Usage   : $obj->_add_prediction($gene)\n Function: internal\n Example :\n Returns :\n\n\nsub _add_prediction {\n    my ($self, $gene) = @_;\n\n    if(! exists($self->{'_preds'})) {\n\t$self->{'_preds'} = [];\n    }\n    push(@{$self->{'_preds'}}, $gene);\n}\n\n=head2 _predictions_parsed\n\n Title   : _predictions_parsed\n Usage   : $obj->_predictions_parsed\n Function: internal\n Example :\n Returns : TRUE or FALSE\n\n\nsub _predictions_parsed {\n    my ($self, $val) = @_;\n\n    $self->{'_preds_parsed'} = $val if $val;\n    if(! exists($self->{'_preds_parsed'})) {\n\t$self->{'_preds_parsed'} = 0;\n    }\n    return $self->{'_preds_parsed'};\n}\n\n=head2 _has_cds\n\n Title   : _has_cds()\n Usage   : $obj->_has_cds()\n Function: Whether or not the result contains the predicted CDSs, too.\n Example :\n Returns : TRUE or FALSE"},"children":[{"definition":"my","line":507,"containerName":"_has_cds","localvar":"my","kind":13,"name":"$self"},{"line":507,"kind":13,"containerName":"_has_cds","name":"$val"},{"line":509,"name":"$self","containerName":"_has_cds","kind":13},{"kind":13,"containerName":"_has_cds","name":"$val","line":509},{"kind":13,"containerName":"_has_cds","name":"$val","line":509},{"containerName":"_has_cds","kind":13,"name":"$self","line":510},{"name":"$self","containerName":"_has_cds","kind":13,"line":511},{"name":"$self","kind":13,"containerName":"_has_cds","line":513}],"containerName":"main::","name":"_has_cds","definition":"sub","detail":"($self,$val)"},{"signature":{"label":"_read_fasta_seq($self)","documentation":"1;\n# $Id: Genemark.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Genemark\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mark Fiers <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp, Mark Fiers\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Genemark - Results of one Genemark run\n\n=head1 SYNOPSIS\n\n   $Genemark = Bio::Tools::Genemark->new(-file => 'result.Genemark');\n   # filehandle:\n   $Genemark = Bio::Tools::Genemark->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $Genemark->next_feature() is the same\n   while($gene = $Genemark->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of\n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons:\n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $Genemark->close();\n\n=head1 DESCRIPTION\n\nThe Genemark module provides a parser for Genemark gene structure\nprediction output. It parses one gene prediction into a\nBio::SeqFeature::Gene::Transcript- derived object.\n\nThis module has been developed around genemark.hmm for eukaryots v2.2a\nand will probably not work with other versions.\n\n\nThis module also implements the Bio::SeqAnalysisParserI interface, and\nthus can be used wherever such an object fits. See\nL<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp, Mark Fiers\n\nEmail hlapp@gmx.net\n      m.w.e.j.fiers@plant.wag-ur.nl\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Genemark;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\nuse Bio::Seq;\nuse Bio::Factory::FTLocationFactory;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Genemark->new();\n Function: Builds a new Bio::Tools::Genemark object\n Returns : an instance of Bio::Tools::Genemark\n Args    : seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($seqname) = $self->_rearrange([qw(SEQNAME)], @args);\n\n  # hardwire seq_id when creating gene and exon objects\n  $self->_seqname($seqname) if defined($seqname);\n\n  return $self;\n}\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $Genemark->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /GeneMark.hmm/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method {\n#-------------\n    my ($self, $method) = @_;\n    if($method && ($method !~ /Genemark\\.hmm/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $Genemark->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genemark result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for\n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $Genemark->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genemark result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # get next gene structure\n    $gene = $self->_prediction();\n\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns :\n\n\nsub _parse_predictions {\n    my ($self) = @_;\n    my %exontags = ('Initial' => 'Initial',\n\t\t    'Internal' => 'Internal',\n\t\t    'Terminal' => 'Terminal',\n\t\t    'Single' => '',\n\t\t    '_na_' => '');\n    my $exontag;\n    my $gene;\n    my $exontype;\n    my $current_gene_no = -1;\n\n    # The prediction report does not contain a sequence identifier\n    # (at least the prokaryotic version doesn't)\n    my $seqname = $self->_seqname();\n    \n    while(defined($_ = $self->_readline())) {\n\n\tif( (/^\\s*(\\d+)\\s+(\\d+)/) || (/^\\s*(\\d+)\\s+[\\+\\-]/)) {\n\n\t    #  this is an exon, Genemark doesn't predict anything else\n\t    # $prednr corresponds to geneno.\n\t    my $prednr = $1;\n\n\t    #exon no:\n\t    my $signalnr = 0;\n\t    if ($2) { my $signalnr = $2; } # used in tag: exon_no\n\t\n\t    # split into fields\n\t    chomp();\n\t    my @flds = split(' ', $_);\n\n\t    # create the feature (an exon) object\n\t    my $predobj = Bio::Tools::Prediction::Exon->new();\n\n\t\t\n\t    # define info depending on it being eu- or prokaryot\n\t    my ($start, $end, $orientation, $prediction_source);\n\n\t    if ($self->analysis_method() =~ /PROKARYOTIC/i) {\n\t        $prediction_source = \"Genemark.hmm.pro\";\n\t       \t$orientation = ($flds[1] eq '+') ? 1 : -1;\n\t        ($start, $end) = @flds[(2,3)];\n\t\t$exontag = \"_na_\";\n\n\t    } else {\t\t\n\t        $prediction_source = \"Genemark.hmm.eu\";\n\t       \t$orientation = ($flds[2] eq '+') ? 1 : -1;\n\t        ($start, $end) = @flds[(4,5)];\n\t\t$exontag = $flds[3];\n\t    }\n\n            # instatiate a location object via\n            # Bio::Factory::FTLocationFactory (to handle\n            # inexact coordinates)\n            my $location_string = join('..', $start, $end);\n            my $location_factory = Bio::Factory::FTLocationFactory->new();\n            my $location_obj = $location_factory->from_string($location_string);\n            $predobj->location($location_obj);\n\n            #store the data in the exon object\n            $predobj->source_tag($prediction_source);\n\t    $predobj->strand($orientation);\n\n\t    $predobj->primary_tag($exontags{$exontag} . \"Exon\");\n\n\t    $predobj->add_tag_value('exon_no',\"$signalnr\") if ($signalnr);\n\n    \t    $predobj->is_coding(1);\n\n            $predobj->seq_id($seqname) if (defined($seqname) && ($seqname ne 'unknown'));\n\t\t\n\t    # frame calculation as in the genscan module\n\t    # is to be implemented...\n\t\n\t    #If the $prednr is not equal to the current gene, we\n\t    #need to make a new gene and close the old one\n\t    if($prednr != $current_gene_no) {\n \t        # a new gene, store the old one if it exists\n\t\tif (defined ($gene)) {\n\t\t    $gene->seq_id($seqname);\n\t\t    $gene = undef ;\n\t\t}\n\t\t#and make a new one\n\t\t$gene = Bio::Tools::Prediction::Gene->new\n\t\t    (\n\t\t     '-primary' => \"GenePrediction$prednr\",\n\t\t     '-source' => $prediction_source);\n                $self->_add_prediction($gene);\t\t\n\t\t$current_gene_no = $prednr;\n                $gene->seq_id($seqname) if (defined($seqname) && ($seqname ne 'unknown'));\n\t    }\n\t\n\t    # Add the exon to the gene\n\t    $gene->add_exon($predobj, ($exontag eq \"_na_\" ?\n\t\t\t\t       undef : $exontags{$exontag}));\n\n\t}\n\n\tif(/^(Genemark\\.hmm\\s*[PROKARYOTIC]*)\\s+\\(Version (.*)\\)$/i) {\n\t    $self->analysis_method($1);\n\n\t    my $gm_version = $2;\n\n\t    $self->analysis_method_version($gm_version);\n\t    next;\n\t}\n\n       #Matrix file for eukaryot version\n       if (/^Matrices file:\\s+(\\S+)?/i)  {\n\t    $self->analysis_subject($1);\n\t    # since the line after the matrix file is always the date\n\t    # (in the output file's I have seen!) extract and store this\n\t    # here\n\t     if (defined(my $_date = $self->_readline())) {\n\t         chomp ($_date);\n\t     \t $self->analysis_date($_date);\n\t     }\n\t}\t\t\t\n\t\n        #Matrix file for prokaryot version\n       if (/^Model file name:\\s+(\\S+)/) {\n\t    $self->analysis_subject($1);\n\t    # since the line after the matrix file is always the date\n\t    # (in the output file's I have seen!) extract and store this\n\t    # here\n\t    my $_date = $self->_readline() ;\n\t    if (defined($_date = $self->_readline())) {\n\t         chomp ($_date);\n\t     \t $self->analysis_date($_date);\n\t     }\n\t}\n\t\n\tif(/^Sequence[ file]? name:\\s+(.+)\\s*$/i) {\n\t    $seqname = $1;\n\t    #    $self->analysis_subject($seqname);\n\t    next;\n\t}\n\t\n\n\t/^>/ && do {\t\t\n    \t    $self->_pushback($_);\n\n\t    # section of predicted aa sequences on recognition\n\t    # of a fasta start, read all sequences and find the\n\t    # appropriate gene\n            while (1) {\n\t       my ($aa_id, $seq) = $self->_read_fasta_seq();\n\t       last unless ($aa_id);\n\n\t       #now parse through the predictions to add the pred. protein\n\t       FINDPRED: foreach my $gene (@{$self->{'_preds'}}) {\n\t            $gene->primary_tag() =~ /[^0-9]([0-9]+)$/;\n\t\t    my $geneno = $1;\n\t\t    if ($aa_id =~ /\\|gene.$geneno\\|/) {\n\t\t          #print \"x SEQ : \\n $seq \\nXXXX\\n\";\n  \t\t\t  my $seqobj = Bio::Seq->new('-seq' => $seq,\n\t                     \t\t             '-display_id' => $aa_id,\n\t\t\t\t\t              '-alphabet' => \"protein\");\n\t\t\t$gene->predicted_protein($seqobj);\n\t\t\tlast FINDPRED;\n\t\t    }\t\n\n\t       }\n           }\t\t\t\t\n\n \t   last;\n\t};\n    }\n\n    # if the analysis query object contains a ref to a Seq of PrimarySeq\n    # object, then extract the predicted sequences and add it to the gene\n    # object.\n    if (defined $self->analysis_query()) {\n        my $orig_seq = $self->analysis_query();\n        FINDPREDSEQ: foreach my $gene (@{$self->{'_preds'}}) {\n\t   my $predseq = \"\";\n\t   foreach my $exon ($gene->exons()) {\n\t\t#print $exon->start() . \" \" . $exon->end () . \"\\n\";\n\t\t$predseq .= $orig_seq->subseq($exon->start(), $exon->end());\n\t   }\n\n\t   my $seqobj = Bio::PrimarySeq->new('-seq' => $predseq,\n\t                     \t\t     '-display_id' => \"transl\");\n\t   $gene->predicted_cds($seqobj);\n\t}\n    }\n\n\n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns :\n\n\nsub _prediction {\n    my ($self) = @_;\n\n    return unless(exists($self->{'_preds'}) && @{$self->{'_preds'}});\n    return shift(@{$self->{'_preds'}});\n}\n\n=head2 _add_prediction\n\n Title   : _add_prediction()\n Usage   : $obj->_add_prediction($gene)\n Function: internal\n Example :\n Returns :\n\n\nsub _add_prediction {\n    my ($self, $gene) = @_;\n\n    if(! exists($self->{'_preds'})) {\n\t$self->{'_preds'} = [];\n    }\n    push(@{$self->{'_preds'}}, $gene);\n}\n\n=head2 _predictions_parsed\n\n Title   : _predictions_parsed\n Usage   : $obj->_predictions_parsed\n Function: internal\n Example :\n Returns : TRUE or FALSE\n\n\nsub _predictions_parsed {\n    my ($self, $val) = @_;\n\n    $self->{'_preds_parsed'} = $val if $val;\n    if(! exists($self->{'_preds_parsed'})) {\n\t$self->{'_preds_parsed'} = 0;\n    }\n    return $self->{'_preds_parsed'};\n}\n\n=head2 _has_cds\n\n Title   : _has_cds()\n Usage   : $obj->_has_cds()\n Function: Whether or not the result contains the predicted CDSs, too.\n Example :\n Returns : TRUE or FALSE\n\n\nsub _has_cds {\n    my ($self, $val) = @_;\n\n    $self->{'_has_cds'} = $val if $val;\n    if(! exists($self->{'_has_cds'})) {\n\t$self->{'_has_cds'} = 0;\n    }\n    return $self->{'_has_cds'};\n}\n\n=head2 _read_fasta_seq\n\n Title   : _read_fasta_seq()\n Usage   : ($id,$seqstr) = $obj->_read_fasta_seq();\n Function: Simple but specialised FASTA format sequence reader. Uses\n           $self->_readline() to retrieve input, and is able to strip off\n           the traling description lines.\n Example :\n Returns : An array of two elements.","parameters":[{"label":"$self"}]},"line":528,"range":{"end":{"line":557,"character":9999},"start":{"line":528,"character":0}},"kind":12,"definition":"sub","detail":"($self)","children":[{"containerName":"_read_fasta_seq","localvar":"my","kind":13,"name":"$self","line":529,"definition":"my"},{"name":"$id","localvar":"my","kind":13,"containerName":"_read_fasta_seq","line":530,"definition":"my"},{"line":530,"name":"$seq","containerName":"_read_fasta_seq","kind":13},{"definition":"my","localvar":"my","containerName":"_read_fasta_seq","kind":13,"name":"$entry","line":533},{"line":533,"name":"$self","kind":13,"containerName":"_read_fasta_seq"},{"kind":12,"containerName":"_read_fasta_seq","name":"_readline","line":533},{"line":535,"name":"$entry","containerName":"_read_fasta_seq","kind":13},{"line":537,"name":"$entry","containerName":"_read_fasta_seq","kind":13},{"line":538,"kind":13,"containerName":"_read_fasta_seq","name":"$self"},{"name":"_readline","kind":12,"containerName":"_read_fasta_seq","line":538},{"line":539,"name":"$entry","kind":13,"containerName":"_read_fasta_seq"},{"name":"$entry","containerName":"_read_fasta_seq","kind":13,"line":543},{"line":546,"name":"$entry","containerName":"_read_fasta_seq","kind":13},{"kind":13,"containerName":"_read_fasta_seq","name":"$id","line":547},{"kind":13,"containerName":"_read_fasta_seq","name":"$id","line":548},{"line":549,"containerName":"_read_fasta_seq","kind":13,"name":"$seq"},{"line":549,"name":"$entry","kind":13,"containerName":"_read_fasta_seq"},{"containerName":"_read_fasta_seq","kind":13,"name":"$seq","line":550},{"line":553,"kind":13,"containerName":"_read_fasta_seq","name":"$self"},{"line":553,"kind":12,"containerName":"_read_fasta_seq","name":"throw"},{"name":"$seq","kind":13,"containerName":"_read_fasta_seq","line":555},{"kind":13,"containerName":"_read_fasta_seq","name":"$id","line":556},{"line":556,"containerName":"_read_fasta_seq","kind":13,"name":"$seq"}],"containerName":"main::","name":"_read_fasta_seq"},{"children":[{"definition":"my","name":"$self","localvar":"my","containerName":"_seqname","kind":13,"line":570},{"line":570,"kind":13,"containerName":"_seqname","name":"$val"},{"kind":13,"containerName":"_seqname","name":"$self","line":572},{"containerName":"_seqname","kind":13,"name":"$val","line":572},{"kind":13,"containerName":"_seqname","name":"$val","line":572},{"containerName":"_seqname","kind":13,"name":"$self","line":573},{"line":574,"kind":13,"containerName":"_seqname","name":"$self"},{"line":576,"containerName":"_seqname","kind":13,"name":"$self"}],"containerName":"main::","name":"_seqname","definition":"sub","detail":"($self,$val)","line":569,"kind":12,"range":{"start":{"line":569,"character":0},"end":{"character":9999,"line":577}},"signature":{"documentation":"1;\n# $Id: Genemark.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Genemark\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mark Fiers <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp, Mark Fiers\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Genemark - Results of one Genemark run\n\n=head1 SYNOPSIS\n\n   $Genemark = Bio::Tools::Genemark->new(-file => 'result.Genemark');\n   # filehandle:\n   $Genemark = Bio::Tools::Genemark->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $Genemark->next_feature() is the same\n   while($gene = $Genemark->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of\n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons:\n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $Genemark->close();\n\n=head1 DESCRIPTION\n\nThe Genemark module provides a parser for Genemark gene structure\nprediction output. It parses one gene prediction into a\nBio::SeqFeature::Gene::Transcript- derived object.\n\nThis module has been developed around genemark.hmm for eukaryots v2.2a\nand will probably not work with other versions.\n\n\nThis module also implements the Bio::SeqAnalysisParserI interface, and\nthus can be used wherever such an object fits. See\nL<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp, Mark Fiers\n\nEmail hlapp@gmx.net\n      m.w.e.j.fiers@plant.wag-ur.nl\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Genemark;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\nuse Bio::Seq;\nuse Bio::Factory::FTLocationFactory;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Genemark->new();\n Function: Builds a new Bio::Tools::Genemark object\n Returns : an instance of Bio::Tools::Genemark\n Args    : seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($seqname) = $self->_rearrange([qw(SEQNAME)], @args);\n\n  # hardwire seq_id when creating gene and exon objects\n  $self->_seqname($seqname) if defined($seqname);\n\n  return $self;\n}\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $Genemark->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /GeneMark.hmm/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method {\n#-------------\n    my ($self, $method) = @_;\n    if($method && ($method !~ /Genemark\\.hmm/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $Genemark->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genemark result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for\n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $Genemark->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genemark result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # get next gene structure\n    $gene = $self->_prediction();\n\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns :\n\n\nsub _parse_predictions {\n    my ($self) = @_;\n    my %exontags = ('Initial' => 'Initial',\n\t\t    'Internal' => 'Internal',\n\t\t    'Terminal' => 'Terminal',\n\t\t    'Single' => '',\n\t\t    '_na_' => '');\n    my $exontag;\n    my $gene;\n    my $exontype;\n    my $current_gene_no = -1;\n\n    # The prediction report does not contain a sequence identifier\n    # (at least the prokaryotic version doesn't)\n    my $seqname = $self->_seqname();\n    \n    while(defined($_ = $self->_readline())) {\n\n\tif( (/^\\s*(\\d+)\\s+(\\d+)/) || (/^\\s*(\\d+)\\s+[\\+\\-]/)) {\n\n\t    #  this is an exon, Genemark doesn't predict anything else\n\t    # $prednr corresponds to geneno.\n\t    my $prednr = $1;\n\n\t    #exon no:\n\t    my $signalnr = 0;\n\t    if ($2) { my $signalnr = $2; } # used in tag: exon_no\n\t\n\t    # split into fields\n\t    chomp();\n\t    my @flds = split(' ', $_);\n\n\t    # create the feature (an exon) object\n\t    my $predobj = Bio::Tools::Prediction::Exon->new();\n\n\t\t\n\t    # define info depending on it being eu- or prokaryot\n\t    my ($start, $end, $orientation, $prediction_source);\n\n\t    if ($self->analysis_method() =~ /PROKARYOTIC/i) {\n\t        $prediction_source = \"Genemark.hmm.pro\";\n\t       \t$orientation = ($flds[1] eq '+') ? 1 : -1;\n\t        ($start, $end) = @flds[(2,3)];\n\t\t$exontag = \"_na_\";\n\n\t    } else {\t\t\n\t        $prediction_source = \"Genemark.hmm.eu\";\n\t       \t$orientation = ($flds[2] eq '+') ? 1 : -1;\n\t        ($start, $end) = @flds[(4,5)];\n\t\t$exontag = $flds[3];\n\t    }\n\n            # instatiate a location object via\n            # Bio::Factory::FTLocationFactory (to handle\n            # inexact coordinates)\n            my $location_string = join('..', $start, $end);\n            my $location_factory = Bio::Factory::FTLocationFactory->new();\n            my $location_obj = $location_factory->from_string($location_string);\n            $predobj->location($location_obj);\n\n            #store the data in the exon object\n            $predobj->source_tag($prediction_source);\n\t    $predobj->strand($orientation);\n\n\t    $predobj->primary_tag($exontags{$exontag} . \"Exon\");\n\n\t    $predobj->add_tag_value('exon_no',\"$signalnr\") if ($signalnr);\n\n    \t    $predobj->is_coding(1);\n\n            $predobj->seq_id($seqname) if (defined($seqname) && ($seqname ne 'unknown'));\n\t\t\n\t    # frame calculation as in the genscan module\n\t    # is to be implemented...\n\t\n\t    #If the $prednr is not equal to the current gene, we\n\t    #need to make a new gene and close the old one\n\t    if($prednr != $current_gene_no) {\n \t        # a new gene, store the old one if it exists\n\t\tif (defined ($gene)) {\n\t\t    $gene->seq_id($seqname);\n\t\t    $gene = undef ;\n\t\t}\n\t\t#and make a new one\n\t\t$gene = Bio::Tools::Prediction::Gene->new\n\t\t    (\n\t\t     '-primary' => \"GenePrediction$prednr\",\n\t\t     '-source' => $prediction_source);\n                $self->_add_prediction($gene);\t\t\n\t\t$current_gene_no = $prednr;\n                $gene->seq_id($seqname) if (defined($seqname) && ($seqname ne 'unknown'));\n\t    }\n\t\n\t    # Add the exon to the gene\n\t    $gene->add_exon($predobj, ($exontag eq \"_na_\" ?\n\t\t\t\t       undef : $exontags{$exontag}));\n\n\t}\n\n\tif(/^(Genemark\\.hmm\\s*[PROKARYOTIC]*)\\s+\\(Version (.*)\\)$/i) {\n\t    $self->analysis_method($1);\n\n\t    my $gm_version = $2;\n\n\t    $self->analysis_method_version($gm_version);\n\t    next;\n\t}\n\n       #Matrix file for eukaryot version\n       if (/^Matrices file:\\s+(\\S+)?/i)  {\n\t    $self->analysis_subject($1);\n\t    # since the line after the matrix file is always the date\n\t    # (in the output file's I have seen!) extract and store this\n\t    # here\n\t     if (defined(my $_date = $self->_readline())) {\n\t         chomp ($_date);\n\t     \t $self->analysis_date($_date);\n\t     }\n\t}\t\t\t\n\t\n        #Matrix file for prokaryot version\n       if (/^Model file name:\\s+(\\S+)/) {\n\t    $self->analysis_subject($1);\n\t    # since the line after the matrix file is always the date\n\t    # (in the output file's I have seen!) extract and store this\n\t    # here\n\t    my $_date = $self->_readline() ;\n\t    if (defined($_date = $self->_readline())) {\n\t         chomp ($_date);\n\t     \t $self->analysis_date($_date);\n\t     }\n\t}\n\t\n\tif(/^Sequence[ file]? name:\\s+(.+)\\s*$/i) {\n\t    $seqname = $1;\n\t    #    $self->analysis_subject($seqname);\n\t    next;\n\t}\n\t\n\n\t/^>/ && do {\t\t\n    \t    $self->_pushback($_);\n\n\t    # section of predicted aa sequences on recognition\n\t    # of a fasta start, read all sequences and find the\n\t    # appropriate gene\n            while (1) {\n\t       my ($aa_id, $seq) = $self->_read_fasta_seq();\n\t       last unless ($aa_id);\n\n\t       #now parse through the predictions to add the pred. protein\n\t       FINDPRED: foreach my $gene (@{$self->{'_preds'}}) {\n\t            $gene->primary_tag() =~ /[^0-9]([0-9]+)$/;\n\t\t    my $geneno = $1;\n\t\t    if ($aa_id =~ /\\|gene.$geneno\\|/) {\n\t\t          #print \"x SEQ : \\n $seq \\nXXXX\\n\";\n  \t\t\t  my $seqobj = Bio::Seq->new('-seq' => $seq,\n\t                     \t\t             '-display_id' => $aa_id,\n\t\t\t\t\t              '-alphabet' => \"protein\");\n\t\t\t$gene->predicted_protein($seqobj);\n\t\t\tlast FINDPRED;\n\t\t    }\t\n\n\t       }\n           }\t\t\t\t\n\n \t   last;\n\t};\n    }\n\n    # if the analysis query object contains a ref to a Seq of PrimarySeq\n    # object, then extract the predicted sequences and add it to the gene\n    # object.\n    if (defined $self->analysis_query()) {\n        my $orig_seq = $self->analysis_query();\n        FINDPREDSEQ: foreach my $gene (@{$self->{'_preds'}}) {\n\t   my $predseq = \"\";\n\t   foreach my $exon ($gene->exons()) {\n\t\t#print $exon->start() . \" \" . $exon->end () . \"\\n\";\n\t\t$predseq .= $orig_seq->subseq($exon->start(), $exon->end());\n\t   }\n\n\t   my $seqobj = Bio::PrimarySeq->new('-seq' => $predseq,\n\t                     \t\t     '-display_id' => \"transl\");\n\t   $gene->predicted_cds($seqobj);\n\t}\n    }\n\n\n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns :\n\n\nsub _prediction {\n    my ($self) = @_;\n\n    return unless(exists($self->{'_preds'}) && @{$self->{'_preds'}});\n    return shift(@{$self->{'_preds'}});\n}\n\n=head2 _add_prediction\n\n Title   : _add_prediction()\n Usage   : $obj->_add_prediction($gene)\n Function: internal\n Example :\n Returns :\n\n\nsub _add_prediction {\n    my ($self, $gene) = @_;\n\n    if(! exists($self->{'_preds'})) {\n\t$self->{'_preds'} = [];\n    }\n    push(@{$self->{'_preds'}}, $gene);\n}\n\n=head2 _predictions_parsed\n\n Title   : _predictions_parsed\n Usage   : $obj->_predictions_parsed\n Function: internal\n Example :\n Returns : TRUE or FALSE\n\n\nsub _predictions_parsed {\n    my ($self, $val) = @_;\n\n    $self->{'_preds_parsed'} = $val if $val;\n    if(! exists($self->{'_preds_parsed'})) {\n\t$self->{'_preds_parsed'} = 0;\n    }\n    return $self->{'_preds_parsed'};\n}\n\n=head2 _has_cds\n\n Title   : _has_cds()\n Usage   : $obj->_has_cds()\n Function: Whether or not the result contains the predicted CDSs, too.\n Example :\n Returns : TRUE or FALSE\n\n\nsub _has_cds {\n    my ($self, $val) = @_;\n\n    $self->{'_has_cds'} = $val if $val;\n    if(! exists($self->{'_has_cds'})) {\n\t$self->{'_has_cds'} = 0;\n    }\n    return $self->{'_has_cds'};\n}\n\n=head2 _read_fasta_seq\n\n Title   : _read_fasta_seq()\n Usage   : ($id,$seqstr) = $obj->_read_fasta_seq();\n Function: Simple but specialised FASTA format sequence reader. Uses\n           $self->_readline() to retrieve input, and is able to strip off\n           the traling description lines.\n Example :\n Returns : An array of two elements.\n\n\nsub _read_fasta_seq {\n    my ($self) = @_;\n    my ($id, $seq);\n    local $/ = \">\";\n\n    return 0 unless (my $entry = $self->_readline());\n\n    $entry =~ s/^>//;\n    # complete the entry if the first line came from a pushback buffer\n    while(! ($entry =~ />$/)) {\n\tlast unless ($_ = $self->_readline());\n\t$entry .= $_;\n    }\n\n    # delete everything onwards from an new fasta start (>)\n    $entry =~ s/\\n>.*$//s;\n    # id and sequence\n\n    if($entry =~ s/^(.+)\\n//) {\n\t$id = $1;\n\t$id =~ s/ /_/g;\n\t$seq = $entry;\n\t$seq =~ s/\\s//g;\t\n\t#print \"\\n@@ $id \\n@@ $seq \\n##\\n\";\n    } else {\n\t$self->throw(\"Can't parse Genemark predicted sequence entry\");\n    }\n    $seq =~ s/\\s//g; # Remove whitespace\n    return ($id, $seq);\n}\n\n=head2 _seqname\n\n Title   : _seqname\n Usage   : $obj->_seqname($seqname)\n Function: internal\n Example :\n Returns : String","parameters":[{"label":"$self"},{"label":"$val"}],"label":"_seqname($self,$val)"}}]}