{"vars":[{"containerName":"","kind":2,"name":"base","line":97},{"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"_initialize_state","line":100,"definition":"my"},{"line":100,"kind":13,"containerName":"_initialize_state","name":"@args"},{"name":"$make","kind":13,"localvar":"my","containerName":"_initialize_state","line":103,"definition":"my"},{"containerName":"_initialize_state","kind":13,"name":"$self","line":103},{"line":103,"name":"@args","containerName":"_initialize_state","kind":13},{"line":108,"name":"$self","kind":13,"containerName":"_initialize_state"},{"name":"$self","kind":13,"containerName":"_initialize_state","line":110}],"containerName":"main::","name":"_initialize_state","definition":"sub","detail":"($self,@args)","line":99,"range":{"end":{"line":111,"character":9999},"start":{"character":0,"line":99}},"kind":12,"signature":{"label":"_initialize_state($self,@args)","documentation":"","parameters":[{"label":"$self"},{"label":"@args"}]}},{"line":103,"containerName":"_initialize_state","kind":12,"name":"SUPER"},{"signature":{"documentation":"1;\n# $Id: Eponine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Eponine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Tania Oh <gisoht@nus.edu.sg>\n#\n# Copyright Tania Oh \n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Eponine - Results of one Eponine run\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Eponine;\n use strict;\n    my $seq = \"/data/seq.fa\";\n    my $threshold  = \"0.999\";\n    my @params = ( -seq => $seq,\n                   -threshold => $threshold);\n\n   my $factory = Bio::Tools::Run::Eponine->new(@params);\n     # run eponine against fasta \n        my $r = $factory->run_eponine($seq);\n        my $parser = Bio::Tools::Eponine->new($r);\n\n       while (my $feat = $parser->next_prediction){\n                #$feat contains array of SeqFeature\n               foreach my $orf($feat) {\n                   print $orf->seq_id. \"\\n\";\n               }\n       }\n\n=head1 DESCRIPTION\n\nParser for Eponine, a probabilistic transcription start site detector\noptimized for mammalian genomic sequence. This module inherits off\nBio::Tools::AnalysisResult and therefore implements \nBio::SeqAnalysisParserI (see L<Bio::Tools::AnalysisResult> and\nL<Bio::SeqAnalysisParserI>).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Tania Oh \n\nE<lt>gisoht-at-nus.edu.sgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Eponine;\nuse strict;\n\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    # handle our own parameters\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    #array of Bio::SeqFeatures\n    $self->{'_flist'} =[];\n}\n\n=head2 analysis_method\n\n Usage     : $mzef->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /mzef/i.\n Returns   : String\n Argument  : n/a","parameters":[{"label":"$self"},{"label":"$method"}],"label":"analysis_method($self,$method)"},"line":124,"range":{"start":{"character":0,"line":124},"end":{"character":9999,"line":131}},"kind":12,"definition":"sub","detail":"($self,$method)","children":[{"definition":"my","line":126,"name":"$self","localvar":"my","containerName":"analysis_method","kind":13},{"kind":13,"containerName":"analysis_method","name":"$method","line":126},{"line":127,"containerName":"analysis_method","kind":13,"name":"$method"},{"containerName":"analysis_method","kind":13,"name":"$method","line":127},{"kind":13,"containerName":"analysis_method","name":"$self","line":128},{"kind":12,"containerName":"analysis_method","name":"throw","line":128},{"line":128,"name":"$self","kind":13,"containerName":"analysis_method"},{"kind":13,"containerName":"analysis_method","name":"$self","line":130},{"containerName":"analysis_method","kind":13,"name":"$method","line":130}],"name":"analysis_method","containerName":"main::"},{"containerName":"analysis_method","kind":12,"name":"SUPER","line":130},{"line":156,"range":{"end":{"line":162,"character":9999},"start":{"line":156,"character":0}},"kind":12,"signature":{"label":"next_feature($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Eponine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Eponine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Tania Oh <gisoht@nus.edu.sg>\n#\n# Copyright Tania Oh \n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Eponine - Results of one Eponine run\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Eponine;\n use strict;\n    my $seq = \"/data/seq.fa\";\n    my $threshold  = \"0.999\";\n    my @params = ( -seq => $seq,\n                   -threshold => $threshold);\n\n   my $factory = Bio::Tools::Run::Eponine->new(@params);\n     # run eponine against fasta \n        my $r = $factory->run_eponine($seq);\n        my $parser = Bio::Tools::Eponine->new($r);\n\n       while (my $feat = $parser->next_prediction){\n                #$feat contains array of SeqFeature\n               foreach my $orf($feat) {\n                   print $orf->seq_id. \"\\n\";\n               }\n       }\n\n=head1 DESCRIPTION\n\nParser for Eponine, a probabilistic transcription start site detector\noptimized for mammalian genomic sequence. This module inherits off\nBio::Tools::AnalysisResult and therefore implements \nBio::SeqAnalysisParserI (see L<Bio::Tools::AnalysisResult> and\nL<Bio::SeqAnalysisParserI>).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Tania Oh \n\nE<lt>gisoht-at-nus.edu.sgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Eponine;\nuse strict;\n\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    # handle our own parameters\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    #array of Bio::SeqFeatures\n    $self->{'_flist'} =[];\n}\n\n=head2 analysis_method\n\n Usage     : $mzef->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /mzef/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /epo/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $mzef->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :"},"children":[{"localvar":"my","kind":13,"containerName":"next_feature","name":"$self","line":157,"definition":"my"},{"name":"@args","kind":13,"containerName":"next_feature","line":157},{"line":161,"kind":13,"containerName":"next_feature","name":"$self"},{"line":161,"name":"next_prediction","kind":12,"containerName":"next_feature"},{"line":161,"containerName":"next_feature","kind":13,"name":"@args"}],"containerName":"main::","name":"next_feature","definition":"sub","detail":"($self,@args)"},{"line":182,"kind":12,"range":{"end":{"character":9999,"line":191},"start":{"line":182,"character":0}},"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Eponine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Eponine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Tania Oh <gisoht@nus.edu.sg>\n#\n# Copyright Tania Oh \n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Eponine - Results of one Eponine run\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Eponine;\n use strict;\n    my $seq = \"/data/seq.fa\";\n    my $threshold  = \"0.999\";\n    my @params = ( -seq => $seq,\n                   -threshold => $threshold);\n\n   my $factory = Bio::Tools::Run::Eponine->new(@params);\n     # run eponine against fasta \n        my $r = $factory->run_eponine($seq);\n        my $parser = Bio::Tools::Eponine->new($r);\n\n       while (my $feat = $parser->next_prediction){\n                #$feat contains array of SeqFeature\n               foreach my $orf($feat) {\n                   print $orf->seq_id. \"\\n\";\n               }\n       }\n\n=head1 DESCRIPTION\n\nParser for Eponine, a probabilistic transcription start site detector\noptimized for mammalian genomic sequence. This module inherits off\nBio::Tools::AnalysisResult and therefore implements \nBio::SeqAnalysisParserI (see L<Bio::Tools::AnalysisResult> and\nL<Bio::SeqAnalysisParserI>).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Tania Oh \n\nE<lt>gisoht-at-nus.edu.sgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Eponine;\nuse strict;\n\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    # handle our own parameters\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    #array of Bio::SeqFeatures\n    $self->{'_flist'} =[];\n}\n\n=head2 analysis_method\n\n Usage     : $mzef->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /mzef/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /epo/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $mzef->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $mzef->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :","label":"next_prediction($self)"},"children":[{"line":183,"name":"$self","localvar":"my","containerName":"next_prediction","kind":13,"definition":"my"},{"name":"$gene","localvar":"my","kind":13,"containerName":"next_prediction","line":184,"definition":"my"},{"kind":13,"containerName":"next_prediction","name":"$self","line":187},{"line":187,"kind":12,"containerName":"next_prediction","name":"_parse_predictions"},{"kind":13,"containerName":"next_prediction","name":"$self","line":187},{"containerName":"next_prediction","kind":12,"name":"_predictions_parsed","line":187},{"line":190,"name":"$self","containerName":"next_prediction","kind":13},{"line":190,"kind":12,"containerName":"next_prediction","name":"_prediction"}],"name":"next_prediction","containerName":"main::","definition":"sub","detail":"($self)"},{"definition":"sub","detail":"($self)","children":[{"localvar":"my","containerName":"_parse_predictions","kind":13,"name":"$self","line":205,"definition":"my"},{"kind":13,"containerName":"_parse_predictions","name":"$self","line":207},{"line":207,"name":"_readline","containerName":"_parse_predictions","kind":12},{"line":210,"name":"@element","kind":13,"localvar":"my","containerName":"_parse_predictions","definition":"my"},{"definition":"my","line":211,"localvar":"my","containerName":"_parse_predictions","kind":13,"name":"%feature"},{"name":"$feature","kind":13,"containerName":"_parse_predictions","line":212},{"kind":13,"containerName":"_parse_predictions","name":"$element","line":212},{"name":"$feature","kind":13,"containerName":"_parse_predictions","line":213},{"line":213,"name":"$element","containerName":"_parse_predictions","kind":13},{"name":"$feature","containerName":"_parse_predictions","kind":13,"line":214},{"line":214,"containerName":"_parse_predictions","kind":13,"name":"$element"},{"containerName":"_parse_predictions","kind":13,"name":"$feature","line":215},{"name":"$element","kind":13,"containerName":"_parse_predictions","line":215},{"name":"$feature","containerName":"_parse_predictions","kind":13,"line":216},{"line":216,"name":"$element","containerName":"_parse_predictions","kind":13},{"name":"$feature","containerName":"_parse_predictions","kind":13,"line":217},{"kind":13,"containerName":"_parse_predictions","name":"$feature","line":218},{"line":219,"kind":13,"containerName":"_parse_predictions","name":"$feature"},{"kind":13,"containerName":"_parse_predictions","name":"$feature","line":220},{"line":222,"containerName":"_parse_predictions","kind":13,"name":"$self"},{"line":222,"containerName":"_parse_predictions","kind":12,"name":"create_feature"},{"line":222,"containerName":"_parse_predictions","kind":13,"name":"%feature"},{"line":227,"kind":13,"containerName":"_parse_predictions","name":"$self"},{"name":"_predictions_parsed","kind":12,"containerName":"_parse_predictions","line":227}],"containerName":"main::","name":"_parse_predictions","signature":{"documentation":"1;\n# $Id: Eponine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Eponine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Tania Oh <gisoht@nus.edu.sg>\n#\n# Copyright Tania Oh \n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Eponine - Results of one Eponine run\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Eponine;\n use strict;\n    my $seq = \"/data/seq.fa\";\n    my $threshold  = \"0.999\";\n    my @params = ( -seq => $seq,\n                   -threshold => $threshold);\n\n   my $factory = Bio::Tools::Run::Eponine->new(@params);\n     # run eponine against fasta \n        my $r = $factory->run_eponine($seq);\n        my $parser = Bio::Tools::Eponine->new($r);\n\n       while (my $feat = $parser->next_prediction){\n                #$feat contains array of SeqFeature\n               foreach my $orf($feat) {\n                   print $orf->seq_id. \"\\n\";\n               }\n       }\n\n=head1 DESCRIPTION\n\nParser for Eponine, a probabilistic transcription start site detector\noptimized for mammalian genomic sequence. This module inherits off\nBio::Tools::AnalysisResult and therefore implements \nBio::SeqAnalysisParserI (see L<Bio::Tools::AnalysisResult> and\nL<Bio::SeqAnalysisParserI>).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Tania Oh \n\nE<lt>gisoht-at-nus.edu.sgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Eponine;\nuse strict;\n\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    # handle our own parameters\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    #array of Bio::SeqFeatures\n    $self->{'_flist'} =[];\n}\n\n=head2 analysis_method\n\n Usage     : $mzef->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /mzef/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /epo/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $mzef->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $mzef->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # return the next gene structure (transcript)\n    return $self->_prediction();\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : ","parameters":[{"label":"$self"}],"label":"_parse_predictions($self)"},"line":204,"range":{"start":{"line":204,"character":0},"end":{"character":9999,"line":228}},"kind":12},{"line":212,"name":"name","kind":12},{"name":"score","kind":12,"line":213},{"line":214,"name":"start","kind":12},{"line":215,"kind":12,"name":"end"},{"line":216,"name":"strand","kind":12},{"line":217,"name":"source","kind":12},{"line":218,"kind":12,"name":"primary"},{"line":219,"kind":12,"name":"program"},{"name":"program_version","kind":12,"line":220},{"signature":{"parameters":[{"label":"$self"},{"label":"$feat"}],"documentation":"1;\n# $Id: Eponine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Eponine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Tania Oh <gisoht@nus.edu.sg>\n#\n# Copyright Tania Oh \n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Eponine - Results of one Eponine run\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Eponine;\n use strict;\n    my $seq = \"/data/seq.fa\";\n    my $threshold  = \"0.999\";\n    my @params = ( -seq => $seq,\n                   -threshold => $threshold);\n\n   my $factory = Bio::Tools::Run::Eponine->new(@params);\n     # run eponine against fasta \n        my $r = $factory->run_eponine($seq);\n        my $parser = Bio::Tools::Eponine->new($r);\n\n       while (my $feat = $parser->next_prediction){\n                #$feat contains array of SeqFeature\n               foreach my $orf($feat) {\n                   print $orf->seq_id. \"\\n\";\n               }\n       }\n\n=head1 DESCRIPTION\n\nParser for Eponine, a probabilistic transcription start site detector\noptimized for mammalian genomic sequence. This module inherits off\nBio::Tools::AnalysisResult and therefore implements \nBio::SeqAnalysisParserI (see L<Bio::Tools::AnalysisResult> and\nL<Bio::SeqAnalysisParserI>).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Tania Oh \n\nE<lt>gisoht-at-nus.edu.sgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Eponine;\nuse strict;\n\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    # handle our own parameters\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    #array of Bio::SeqFeatures\n    $self->{'_flist'} =[];\n}\n\n=head2 analysis_method\n\n Usage     : $mzef->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /mzef/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /epo/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $mzef->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $mzef->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # return the next gene structure (transcript)\n    return $self->_prediction();\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n    my ($self) = @_;\n\n    while(defined($_ = $self->_readline())) {\n        if (! /^\\#/){ #ignore introductory lines\n\n\t      my @element = split;\n\t      my (%feature);\n\t      $feature {name} = $element[0];\n\t      $feature {score} = $element[5];\n\t      $feature {start} = $element[3];\n\t      $feature {end} = $element[4];\n\t      $feature {strand} = $element[6];\n\t      $feature {source}= 'Eponine';\n\t      $feature {primary}= 'TSS';\n\t      $feature {program} = 'eponine-scan';\n\t      $feature {program_version} = '2';\n            \n\t      $self->create_feature(\\%feature);\n\t            next;\n\n\t}\n    }\n    $self->_predictions_parsed(1);\n}\n\n=head2 create_feature\n\n    Title   :   create_feature\n    Usage   :   obj->create_feature($feature)\n    Function:   Returns an array of features\n    Returns :   Returns an array of features\n    Args    :   none","label":"create_feature($self,$feat)"},"line":240,"kind":12,"range":{"end":{"line":258,"character":9999},"start":{"line":240,"character":0}},"definition":"sub","detail":"($self,$feat)","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"create_feature","line":241,"definition":"my"},{"line":241,"name":"$feat","kind":13,"containerName":"create_feature"},{"definition":"my","localvar":"my","kind":13,"containerName":"create_feature","name":"$tss","line":244},{"kind":12,"containerName":"create_feature","name":"new","line":245},{"name":"$feat","kind":13,"containerName":"create_feature","line":245},{"line":246,"containerName":"create_feature","kind":13,"name":"$feat"},{"line":247,"kind":13,"containerName":"create_feature","name":"$feat"},{"line":248,"name":"$feat","containerName":"create_feature","kind":13},{"line":249,"containerName":"create_feature","kind":13,"name":"$feat"},{"name":"$feat","containerName":"create_feature","kind":13,"line":250},{"kind":13,"containerName":"create_feature","name":"$feat","line":251},{"line":255,"name":"$tss","containerName":"create_feature","kind":13},{"containerName":"create_feature","kind":13,"name":"$self","line":257},{"line":257,"containerName":"create_feature","kind":13,"name":"$tss"}],"containerName":"main::","name":"create_feature"},{"kind":12,"containerName":"SeqFeature::Generic","name":"Bio","line":244},{"range":{"end":{"line":281,"character":9999},"start":{"line":278,"character":0}},"kind":12,"line":278,"signature":{"documentation":"1;\n# $Id: Eponine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Eponine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Tania Oh <gisoht@nus.edu.sg>\n#\n# Copyright Tania Oh \n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Eponine - Results of one Eponine run\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Eponine;\n use strict;\n    my $seq = \"/data/seq.fa\";\n    my $threshold  = \"0.999\";\n    my @params = ( -seq => $seq,\n                   -threshold => $threshold);\n\n   my $factory = Bio::Tools::Run::Eponine->new(@params);\n     # run eponine against fasta \n        my $r = $factory->run_eponine($seq);\n        my $parser = Bio::Tools::Eponine->new($r);\n\n       while (my $feat = $parser->next_prediction){\n                #$feat contains array of SeqFeature\n               foreach my $orf($feat) {\n                   print $orf->seq_id. \"\\n\";\n               }\n       }\n\n=head1 DESCRIPTION\n\nParser for Eponine, a probabilistic transcription start site detector\noptimized for mammalian genomic sequence. This module inherits off\nBio::Tools::AnalysisResult and therefore implements \nBio::SeqAnalysisParserI (see L<Bio::Tools::AnalysisResult> and\nL<Bio::SeqAnalysisParserI>).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Tania Oh \n\nE<lt>gisoht-at-nus.edu.sgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Eponine;\nuse strict;\n\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    # handle our own parameters\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    #array of Bio::SeqFeatures\n    $self->{'_flist'} =[];\n}\n\n=head2 analysis_method\n\n Usage     : $mzef->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /mzef/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /epo/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $mzef->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $mzef->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # return the next gene structure (transcript)\n    return $self->_prediction();\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n    my ($self) = @_;\n\n    while(defined($_ = $self->_readline())) {\n        if (! /^\\#/){ #ignore introductory lines\n\n\t      my @element = split;\n\t      my (%feature);\n\t      $feature {name} = $element[0];\n\t      $feature {score} = $element[5];\n\t      $feature {start} = $element[3];\n\t      $feature {end} = $element[4];\n\t      $feature {strand} = $element[6];\n\t      $feature {source}= 'Eponine';\n\t      $feature {primary}= 'TSS';\n\t      $feature {program} = 'eponine-scan';\n\t      $feature {program_version} = '2';\n            \n\t      $self->create_feature(\\%feature);\n\t            next;\n\n\t}\n    }\n    $self->_predictions_parsed(1);\n}\n\n=head2 create_feature\n\n    Title   :   create_feature\n    Usage   :   obj->create_feature($feature)\n    Function:   Returns an array of features\n    Returns :   Returns an array of features\n    Args    :   none\n\n\nsub create_feature {\n    my ($self, $feat) = @_;\n     #create and fill Bio::EnsEMBL::Seqfeature object\n\n      my $tss = Bio::SeqFeature::Generic->new\n                    (   -seq_id  => $feat->{'name'},\n                        -start   => $feat->{'start'},\n                        -end     => $feat->{'end'},\n                        -strand  => $feat->{'strand'},\n            \t\t-score   => $feat->{'score'},\n                        -source_tag  => $feat->{'source'},\n\t\t        -primary_tag => $feat->{'primary'});\n\n\t\t\n\n  if ($tss) {\n         # add to _flist\n      push(@{$self->{'_flist'}}, $tss);\n   }\n\n   #print $tss->gff_string;\n}\n\t\t\t    \n\n\n\n\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : ","parameters":[{"label":"$self"}],"label":"_prediction($self)"},"containerName":"main::","name":"_prediction","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_prediction","line":279},{"line":281,"name":"$self","containerName":"_prediction","kind":13},{"line":281,"containerName":"_prediction","kind":13,"name":"$self"}],"detail":"($self)","definition":"sub"},{"line":282,"containerName":null,"kind":13,"name":"%self"},{"detail":"($self,$val)","definition":"sub","containerName":"main::","name":"_predictions_parsed","children":[{"definition":"my","line":296,"name":"$self","kind":13,"localvar":"my","containerName":"_predictions_parsed"},{"line":296,"name":"$val","containerName":"_predictions_parsed","kind":13},{"name":"$self","kind":13,"containerName":"_predictions_parsed","line":298},{"containerName":"_predictions_parsed","kind":13,"name":"$val","line":298},{"name":"$val","containerName":"_predictions_parsed","kind":13,"line":298},{"name":"$self","containerName":"_predictions_parsed","kind":13,"line":300},{"line":301,"name":"$self","kind":13,"containerName":"_predictions_parsed"},{"line":303,"name":"$self","kind":13,"containerName":"_predictions_parsed"}],"signature":{"label":"_predictions_parsed($self,$val)","parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: Eponine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Eponine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Tania Oh <gisoht@nus.edu.sg>\n#\n# Copyright Tania Oh \n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Eponine - Results of one Eponine run\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Eponine;\n use strict;\n    my $seq = \"/data/seq.fa\";\n    my $threshold  = \"0.999\";\n    my @params = ( -seq => $seq,\n                   -threshold => $threshold);\n\n   my $factory = Bio::Tools::Run::Eponine->new(@params);\n     # run eponine against fasta \n        my $r = $factory->run_eponine($seq);\n        my $parser = Bio::Tools::Eponine->new($r);\n\n       while (my $feat = $parser->next_prediction){\n                #$feat contains array of SeqFeature\n               foreach my $orf($feat) {\n                   print $orf->seq_id. \"\\n\";\n               }\n       }\n\n=head1 DESCRIPTION\n\nParser for Eponine, a probabilistic transcription start site detector\noptimized for mammalian genomic sequence. This module inherits off\nBio::Tools::AnalysisResult and therefore implements \nBio::SeqAnalysisParserI (see L<Bio::Tools::AnalysisResult> and\nL<Bio::SeqAnalysisParserI>).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Tania Oh \n\nE<lt>gisoht-at-nus.edu.sgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Eponine;\nuse strict;\n\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    # handle our own parameters\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    #array of Bio::SeqFeatures\n    $self->{'_flist'} =[];\n}\n\n=head2 analysis_method\n\n Usage     : $mzef->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /mzef/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /epo/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $mzef->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $mzef->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the MZEF result\n           file. Call this method repeatedly until FALSE is returned.\n\n           Note that with the present version of MZEF there will only be one\n           object returned, because MZEF does not predict individual genes\n           but just potential internal exons.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # return the next gene structure (transcript)\n    return $self->_prediction();\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n    my ($self) = @_;\n\n    while(defined($_ = $self->_readline())) {\n        if (! /^\\#/){ #ignore introductory lines\n\n\t      my @element = split;\n\t      my (%feature);\n\t      $feature {name} = $element[0];\n\t      $feature {score} = $element[5];\n\t      $feature {start} = $element[3];\n\t      $feature {end} = $element[4];\n\t      $feature {strand} = $element[6];\n\t      $feature {source}= 'Eponine';\n\t      $feature {primary}= 'TSS';\n\t      $feature {program} = 'eponine-scan';\n\t      $feature {program_version} = '2';\n            \n\t      $self->create_feature(\\%feature);\n\t            next;\n\n\t}\n    }\n    $self->_predictions_parsed(1);\n}\n\n=head2 create_feature\n\n    Title   :   create_feature\n    Usage   :   obj->create_feature($feature)\n    Function:   Returns an array of features\n    Returns :   Returns an array of features\n    Args    :   none\n\n\nsub create_feature {\n    my ($self, $feat) = @_;\n     #create and fill Bio::EnsEMBL::Seqfeature object\n\n      my $tss = Bio::SeqFeature::Generic->new\n                    (   -seq_id  => $feat->{'name'},\n                        -start   => $feat->{'start'},\n                        -end     => $feat->{'end'},\n                        -strand  => $feat->{'strand'},\n            \t\t-score   => $feat->{'score'},\n                        -source_tag  => $feat->{'source'},\n\t\t        -primary_tag => $feat->{'primary'});\n\n\t\t\n\n  if ($tss) {\n         # add to _flist\n      push(@{$self->{'_flist'}}, $tss);\n   }\n\n   #print $tss->gff_string;\n}\n\t\t\t    \n\n\n\n\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : \n\n\nsub _prediction {\n    my ($self) = @_;\n\n    return unless(exists($self->{'_flist'}) && @{$self->{'_flist'}});\n    return shift(@{$self->{'_flist'}});\n}\n\n=head2 _predictions_parsed\n\n Title   : _predictions_parsed\n Usage   : $obj->_predictions_parsed\n Function: internal\n Example :\n Returns : TRUE or FALSE"},"range":{"end":{"character":9999,"line":304},"start":{"character":0,"line":295}},"kind":12,"line":295}],"version":5}