{"vars":[{"kind":2,"containerName":"","name":"base","line":132},{"containerName":"main::","name":"new","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"new","name":"$class","line":148},{"line":148,"kind":13,"containerName":"new","name":"@args"},{"definition":"my","name":"$self","localvar":"my","containerName":"new","kind":13,"line":149},{"line":149,"kind":13,"containerName":"new","name":"$class"},{"containerName":"new","kind":13,"name":"@args","line":149},{"line":150,"name":"$self","containerName":"new","kind":13},{"line":150,"kind":12,"containerName":"new","name":"eutil"},{"name":"$self","containerName":"new","kind":13,"line":151},{"kind":12,"containerName":"new","name":"datatype","line":151},{"line":152,"containerName":"new","kind":13,"name":"$self"}],"detail":"($class,@args)","definition":"sub","kind":12,"range":{"end":{"line":153,"character":9999},"start":{"line":147,"character":0}},"line":147,"signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: FieldInfo.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EUtilities::Info\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n# \n# Part of the EUtilities BioPerl package\n\n=head1 NAME\n\nBio::Tools::EUtilities::Info::FieldInfo - class for storing einfo field data\n\n=head1 SYNOPSIS\n\n    #### should not create instance directly; Bio::Tools::EUtilities does this ####\n\n    my $info = Bio::Tools::EUtilities->new(-eutil => 'einfo',\n                                           -file => 'einfo.xml');\n    # can also use '-response' (for HTTP::Response objects) or '-fh' (for filehandles)\n\n    # print available databases (if data is present)\n    print join(', ',$info->get_available_databases),\"\\n\";\n\n    # get database info\n    my $db = $info->get_database; # in case you forgot...\n    my $desc = $info->get_description;\n    my $nm = $info->get_menu_name;\n    my $ct = $info->get_record_count;\n    my $dt = $info->get_last_update;\n    # EUtilDataI interface methods\n    my $eutil = $info->eutil;\n    my $type = $info->type;\n\n    # iterate through Field and Link objects\n    while (my $field = $info->next_Field) {\n        print \"Field code: \",$field->get_field_code,\"\\n\";\n        print \"Field name: \",$field->get_field_name,\"\\n\";\n        print \"Field desc: \",$field->get_field_description,\"\\n\";\n        print \"DB  : \",$field->get_database,\"\\n\";\n        print \"Term ct   : \",$field->get_term_count,\"\\n\";\n        for my $att (qw(is_date is_singletoken is_hierarchy is_hidden is_numerical)) {\n            print \"\\tField $att\\n\" if $field->$att;\n        }\n    }\n\n    my @fields = $info->get_Fields; # grab them all (useful for grep)\n\n    while (my $link = $info->next_Link) {\n        print \"Link name: \",$link->get_link_name,\"\\n\";\n        print \"Link desc: \",$link->get_link_description,\"\\n\";\n        print \"DBFrom: \",$link->get_dbfrom,\"\\n\"; # same as get_database()\n        print \"DBTo: \",$link->get_dbto,\"\\n\"; # database linked to\n    }\n\n    my @links = $info->get_Links; # grab them all (useful for grep)\n\n    $info->rewind(); # rewinds all iterators\n    $info->rewind('links'); # rewinds Link iterator\n    $info->rewind('fields'); # rewinds Field iterator\n\n=head1 DESCRIPTION\n\nThis class handles data output (XML) from einfo.\n\neinfo is capable of returning two types of information: 1) a list of all\navailable databases (when called w/o parameters) and 2) information about a\nspecific database. The latter information includes the database description,\nrecord count, and date/time stamp for the last update, among other things. It\nalso includes a list of fields (indices by which record data is stored which can\nbe used in queries) and links (crossrefs between related records in other\ndatabases at NCBI). Data from the latter two are stored in two small subclasses\n(Field and Link) which can be iterated through or retrieved all at once, as\ndemonstrated above. NOTE: Methods described for the Link and Field subclasses\nare unique to those classes (as they retrieve data unique to those data types).\n\nFurther documentation for Link and Field subclass methods is included below.\n\nFor more information on einfo see:\n\n   http://eutils.ncbi.nlm.nih.gov/entrez/query/static/einfo_help.html\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other Bioperl\nmodules. Send your comments and suggestions preferably to one of the Bioperl\nmailing lists. Your participation is much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track the bugs\nand their resolution. Bug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal\nmethods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::Info::FieldInfo;\nuse base qw(Bio::Root::Root Bio::Tools::EUtilities::EUtilDataI);\nuse strict;\nuse warnings;\n\n=head2 new\n\n Title    : new\n Note     : *** should not be called by end-users ***  \n Usage    : my $ct = Bio::Tools::EUtilities::Info::FieldInfo;\n Function : returns new FieldInfo instance\n Returns  : Bio::Tools::EUtilities::Info::FieldInfo instance\n Args     : none (all data added via _add_data, most methods are getters only)","parameters":[{"label":"$class"},{"label":"@args"}]}},{"kind":2,"containerName":"","name":"warnings","line":148},{"kind":12,"containerName":"new","name":"SUPER","line":149},{"line":165,"range":{"end":{"character":9999,"line":165},"start":{"line":165,"character":0}},"kind":12,"definition":"sub","children":[],"containerName":"main::","name":"get_term_count"},{"line":177,"kind":12,"range":{"end":{"character":9999,"line":177},"start":{"character":0,"line":177}},"children":[],"name":"get_field_name","containerName":"main::","definition":"sub"},{"kind":12,"range":{"start":{"character":0,"line":198},"end":{"character":9999,"line":198}},"line":198,"definition":"sub","containerName":"main::","name":"get_field_code","children":[]},{"range":{"end":{"line":211,"character":9999},"start":{"character":0,"line":211}},"kind":12,"line":211,"name":"get_field_description","containerName":"main::","children":[],"definition":"sub"},{"children":[{"name":"$self","localvar":"my","containerName":"is_date","kind":13,"line":224,"definition":"my"},{"line":225,"kind":13,"containerName":"is_date","name":"$self"},{"line":225,"name":"$self","containerName":"is_date","kind":13}],"name":"is_date","containerName":"main::","definition":"sub","line":223,"range":{"start":{"character":0,"line":223},"end":{"character":9999,"line":226}},"kind":12},{"line":238,"kind":12,"range":{"end":{"line":241,"character":9999},"start":{"character":0,"line":238}},"children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"is_singletoken","line":239},{"line":240,"kind":13,"containerName":"is_singletoken","name":"$self"},{"line":240,"name":"$self","containerName":"is_singletoken","kind":13}],"name":"is_singletoken","containerName":"main::","definition":"sub"},{"line":253,"range":{"start":{"character":0,"line":253},"end":{"line":256,"character":9999}},"kind":12,"children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"is_hierarchy","line":254},{"name":"$self","containerName":"is_hierarchy","kind":13,"line":255},{"line":255,"containerName":"is_hierarchy","kind":13,"name":"$self"}],"name":"is_hierarchy","containerName":"main::","definition":"sub"},{"name":"is_hidden","containerName":"main::","children":[{"localvar":"my","containerName":"is_hidden","kind":13,"name":"$self","line":269,"definition":"my"},{"line":270,"name":"$self","containerName":"is_hidden","kind":13},{"line":270,"kind":13,"containerName":"is_hidden","name":"$self"}],"definition":"sub","kind":12,"range":{"start":{"character":0,"line":268},"end":{"line":271,"character":9999}},"line":268},{"line":283,"kind":12,"range":{"end":{"line":286,"character":9999},"start":{"line":283,"character":0}},"definition":"sub","children":[{"definition":"my","line":284,"localvar":"my","kind":13,"containerName":"is_numerical","name":"$self"},{"name":"$self","kind":13,"containerName":"is_numerical","line":285},{"name":"$self","kind":13,"containerName":"is_numerical","line":285}],"containerName":"main::","name":"is_numerical"},{"signature":{"parameters":[{"label":"$self"},{"label":"$simple"}],"documentation":" private EUtilDataI method","label":"_add_data($self,$simple)"},"line":290,"range":{"end":{"line":293,"character":9999},"start":{"line":290,"character":0}},"kind":12,"definition":"sub","detail":"($self,$simple)","children":[{"line":291,"name":"$self","localvar":"my","containerName":"_add_data","kind":13,"definition":"my"},{"line":291,"name":"$simple","kind":13,"containerName":"_add_data"},{"containerName":"_add_data","kind":13,"name":"$self","line":292},{"line":292,"kind":13,"containerName":"_add_data","name":"$simple"},{"kind":13,"containerName":"_add_data","name":"$simple","line":292},{"name":"$simple","containerName":"_add_data","kind":13,"line":292}],"containerName":"main::","name":"_add_data"},{"children":[{"definition":"my","localvar":"my","containerName":"to_string","kind":13,"name":"$self","line":307},{"line":309,"name":"%tags","localvar":"my","containerName":"to_string","kind":13,"definition":"my"},{"definition":"my","name":"$string","localvar":"my","containerName":"to_string","kind":13,"line":313},{"definition":"my","localvar":"my","kind":13,"containerName":"to_string","name":"$tag","line":314},{"line":314,"containerName":"to_string","kind":13,"name":"$a"},{"line":314,"name":"$b","kind":13,"containerName":"to_string"},{"line":314,"kind":13,"containerName":"to_string","name":"%tags"},{"localvar":"my","kind":13,"containerName":"to_string","name":"$m","line":315,"definition":"my"},{"kind":13,"containerName":"to_string","name":"$nm","line":315},{"name":"$tags","containerName":"to_string","kind":13,"line":315},{"name":"$tag","containerName":"to_string","kind":13,"line":315},{"name":"$tags","containerName":"to_string","kind":13,"line":315},{"containerName":"to_string","kind":13,"name":"$tag","line":315},{"line":316,"name":"$string","kind":13,"containerName":"to_string"},{"name":"$nm","containerName":"to_string","kind":13,"line":316},{"line":317,"containerName":"to_string","kind":13,"name":"$self"},{"containerName":"to_string","kind":12,"name":"_text_wrap","line":317},{"name":"$self","containerName":"to_string","kind":13,"line":317},{"kind":13,"containerName":"to_string","name":"$m","line":317},{"name":"$string","kind":13,"containerName":"to_string","line":319},{"line":320,"name":"$self","kind":13,"containerName":"to_string"},{"line":320,"name":"_text_wrap","kind":12,"containerName":"to_string"},{"line":320,"containerName":"to_string","kind":13,"name":"$self"},{"line":322,"name":"$string","containerName":"to_string","kind":13}],"name":"to_string","containerName":"main::","definition":"sub","line":306,"range":{"start":{"line":306,"character":0},"end":{"character":9999,"line":323}},"kind":12},{"kind":12,"name":"x20","line":317},{"name":"x20","kind":12,"line":320}],"version":5}