{"version":5,"vars":[{"line":116,"kind":2,"containerName":"","name":"base"},{"line":126,"containerName":null,"localvar":"my","kind":13,"name":"%MODE","definition":"my"},{"line":126,"kind":2,"containerName":"URI::HTTP::Request::Bio::Root","name":"IO"},{"line":175,"localvar":"my","kind":13,"containerName":null,"name":"@PARAMS","definition":"my"},{"line":180,"name":"@PARAMS","kind":13,"containerName":null},{"line":184,"containerName":null,"localvar":"my","kind":13,"name":"$method","definition":"my"},{"line":184,"name":"@PARAMS","containerName":null,"kind":13},{"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":""},"line":201,"kind":12,"range":{"end":{"line":213,"character":9999},"start":{"character":0,"line":201}},"definition":"sub","detail":"($class,@args)","children":[{"definition":"my","line":202,"localvar":"my","containerName":"new","kind":13,"name":"$class"},{"line":202,"name":"@args","containerName":"new","kind":13},{"line":203,"name":"$self","kind":13,"localvar":"my","containerName":"new","definition":"my"},{"line":203,"name":"$class","containerName":"new","kind":13},{"line":203,"containerName":"new","kind":13,"name":"@args"},{"line":204,"name":"$retmode","kind":13,"localvar":"my","containerName":"new","definition":"my"},{"containerName":"new","kind":13,"name":"$self","line":204},{"line":204,"name":"_rearrange","containerName":"new","kind":12},{"line":204,"name":"@args","kind":13,"containerName":"new"},{"line":205,"containerName":"new","kind":13,"name":"$self"},{"line":205,"name":"_set_from_args","kind":12,"containerName":"new"},{"line":205,"name":"@args","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"@PARAMS","line":206},{"name":"$self","kind":13,"containerName":"new","line":207},{"line":207,"name":"eutil","kind":12,"containerName":"new"},{"line":207,"kind":13,"containerName":"new","name":"$self"},{"line":207,"containerName":"new","kind":12,"name":"eutil"},{"line":208,"name":"$self","containerName":"new","kind":13},{"name":"tool","kind":12,"containerName":"new","line":208},{"name":"$self","kind":13,"containerName":"new","line":208},{"line":208,"kind":12,"containerName":"new","name":"tool"},{"containerName":"new","kind":13,"name":"$self","line":210},{"name":"set_default_retmode","containerName":"new","kind":12,"line":210},{"line":210,"name":"$retmode","kind":13,"containerName":"new"},{"name":"$self","kind":13,"containerName":"new","line":211},{"name":"$self","kind":13,"containerName":"new","line":212}],"containerName":"main::","name":"new"},{"name":"SUPER","kind":12,"containerName":"new","line":203},{"detail":"($self,@args)","definition":"sub","name":"set_parameters","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"set_parameters","localvar":"my","kind":13,"line":240},{"line":240,"containerName":"set_parameters","kind":13,"name":"@args"},{"name":"$newmode","localvar":"my","kind":13,"containerName":"set_parameters","line":242,"definition":"my"},{"line":242,"containerName":"set_parameters","kind":13,"name":"$file"},{"line":242,"name":"$self","kind":13,"containerName":"set_parameters"},{"line":242,"name":"_rearrange","kind":12,"containerName":"set_parameters"},{"kind":13,"containerName":"set_parameters","name":"@args","line":242},{"line":243,"kind":13,"containerName":"set_parameters","name":"$self"},{"name":"_set_from_args","kind":12,"containerName":"set_parameters","line":243},{"line":243,"kind":13,"containerName":"set_parameters","name":"@args"},{"kind":13,"containerName":"set_parameters","name":"@PARAMS","line":243},{"line":245,"name":"$self","containerName":"set_parameters","kind":13},{"kind":12,"containerName":"set_parameters","name":"set_default_retmode","line":245},{"name":"$newmode","kind":13,"containerName":"set_parameters","line":245},{"line":246,"name":"$file","containerName":"set_parameters","kind":13},{"line":246,"containerName":"set_parameters","kind":13,"name":"$self"},{"line":246,"containerName":"set_parameters","kind":12,"name":"id_file"},{"kind":13,"containerName":"set_parameters","name":"$file","line":246}],"signature":{"documentation":"1;\n# $Id: EUtilParameters.pm 15052 2008-12-01 08:47:39Z heikki $\n#\n# BioPerl module for Bio::Tools::EUtilities::EUtilParameters\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::EUtilities::EUtilParameters - Manipulation of NCBI eutil-based parameters for\nremote database requests.\n\n=head1 SYNOPSIS\n\n # Bio::Tools::EUtilities::EUtilParameters implements Bio::ParameterBaseI\n\n my @params = (-eutil => 'efetch',\n              db => 'nucleotide',\n              id => \\@ids,\n              email => 'me@foo.bar',\n              retmode => 'xml');\n\n my $p = Bio::Tools::EUtilities::EUtilParameters->new(@params);\n\n if ($p->parameters_changed) {\n                              # ...\n                             } # state information\n\n $p->set_parameters(@extra_params); # set new NCBI parameters, leaves others preset\n\n $p->reset_parameters(@new_params); # reset NCBI parameters to original state\n\n $p->to_string(); # get a URI-encoded string representation of the URL address\n\n $p->to_request(); # get an HTTP::Request object (to pass on to LWP::UserAgent)\n\n=head1 DESCRIPTION\n\nBio::Tools::EUtilities::EUtilParameters is-a Bio::ParameterBaseI implementation that allows\nsimple manipulation of NCBI eutil parameters for CGI-based queries. SOAP-based\nmethods may be added in the future.\n\nFor simplicity parameters do not require dashes when passed and do not need URI\nencoding (spaces are converted to '+', symbols encoded, etc). Also, the\nfollowing extra parameters can be passed to the new() constructor or via\nset_parameters() or reset_parameters():\n\n  eutil - the eutil to be used. The default is 'efetch' if not set.\n  correspondence - Flag for how IDs are treated. Default is undef (none).\n  history - a Bio::Tools::EUtilities::HistoryI object. Default is undef (none).\n\nAt this point minimal checking is done for potential errors in parameter\npassing, though these should be easily added in the future when necessary.\n\n=head1 TODO\n\nPossibly integrate SOAP-compliant methods. SOAP::Lite may be undergoing an\ncomplete rewrite so I'm hesitant about adding this in immediately.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the \nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::EUtilParameters;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::ParameterBaseI);\nuse URI;\nuse HTTP::Request;\nuse Bio::Root::IO;\n\n# eutils only has one hostbase URL\n\n# mode : GET or POST (HTTP::Request)\n# location : CGI location\n# params : allowed parameters for that eutil\nmy %MODE = (\n    'einfo'     => {\n        'mode'     => 'GET',\n        'location' => 'einfo.fcgi',\n        'params'   => [qw(db tool email)],\n                   },\n    'epost'     => {\n        'mode'     => 'POST',\n        'location' => 'epost.fcgi',\n        'params'   => [qw(db retmode id tool email WebEnv query_key)],\n                   },\n    'efetch'    => {\n        'mode'     => 'GET',\n        'location' => 'efetch.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype strand seq_start\n                       seq_stop complexity report tool email WebEnv query_key)],\n                   },\n    'esearch'   => {\n        'mode'     => 'GET',\n        'location' => 'esearch.fcgi',\n        'params'   => [qw(db retmode usehistory term field reldate mindate\n                       maxdate datetype retmax retstart rettype sort tool email\n                       WebEnv query_key)],\n                   },\n    'esummary'  => {\n        'mode'     => 'GET',\n        'location' => 'esummary.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype tool email\n                       WebEnv query_key)],\n                   },\n    'elink'     => {\n        'mode'     => 'GET',\n        'location' => 'elink.fcgi',\n        'params'   => [qw(db retmode id reldate mindate maxdate datetype term \n                    dbfrom holding cmd version tool email linkname WebEnv\n                    query_key)],\n                   },\n    'egquery'   => {\n        'mode'     => 'GET',\n        'location' => 'egquery.fcgi',\n        'params'   => [qw(term retmode tool email)],\n                   },\n    'espell'    => {\n        'mode'     => 'GET',\n        'location' => 'espell.fcgi',\n        'params'   => [qw(db retmode term tool email )],\n                   }\n);\n\nmy @PARAMS;\n\n# generate getter/setters (will move this into individual ones at some point)\n\nBEGIN {\n    @PARAMS = qw(db id email retmode rettype usehistory term field tool\n    reldate mindate maxdate datetype retstart retmax sort seq_start seq_stop\n    strand complexity report dbfrom cmd holding version linkname WebEnv\n    query_key);\n    for my $method (@PARAMS) {\n        eval <<END;\nsub $method {\n    my (\\$self, \\$val) = \\@_;\n    if (defined \\$val) {\n        if ((!defined \\$self->{'_$method'}) ||\n        (defined \\$self->{'_$method'} && \\$self->{'_$method'} ne \\$val)) {\n            \\$self->{'_statechange'} = 1;\n            \\$self->{'_$method'} = \\$val;\n        }\n    }\n    return \\$self->{'_$method'};\n}\nEND\n    }\n}\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($retmode) = $self->_rearrange([\"RETMODE\"],@args);\n    $self->_set_from_args(\\@args,\n        -methods => [@PARAMS, qw(eutil history correspondence id_file)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->tool() || $self->tool('bioperl');\n    # set default retmode if not explicitly set    \n    $self->set_default_retmode if (!$retmode);\n    $self->{'_statechange'} = 1;\n    return $self;\n}\n\n=head1 Bio::ParameterBaseI implemented methods\n\n=head2 set_parameters\n\n Title   : set_parameters\n Usage   : $pobj->set_parameters(@params);\n Function: sets the NCBI parameters listed in the hash or array\n Returns : None\n Args    : [optional] hash or array of parameter/values.  \n Note    : This sets any parameter passed but leaves previously set data alone.\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)","parameters":[{"label":"$self"},{"label":"@args"}],"label":"set_parameters($self,@args)"},"range":{"start":{"line":239,"character":0},"end":{"line":248,"character":9999}},"kind":12,"line":239},{"children":[{"definition":"my","line":273,"localvar":"my","containerName":"reset_parameters","kind":13,"name":"$self"},{"line":273,"name":"@args","containerName":"reset_parameters","kind":13},{"definition":"my","containerName":"reset_parameters","localvar":"my","kind":13,"name":"$retmode","line":275},{"line":275,"containerName":"reset_parameters","kind":13,"name":"$file"},{"line":275,"name":"$self","containerName":"reset_parameters","kind":13},{"kind":12,"containerName":"reset_parameters","name":"_rearrange","line":275},{"containerName":"reset_parameters","kind":13,"name":"@args","line":275},{"line":276,"name":"$self","containerName":"reset_parameters","kind":13},{"line":276,"name":"$self","containerName":"reset_parameters","kind":13},{"line":276,"containerName":"reset_parameters","kind":13,"name":"@PARAMS"},{"kind":13,"containerName":"reset_parameters","name":"$self","line":277},{"name":"_set_from_args","containerName":"reset_parameters","kind":12,"line":277},{"line":277,"kind":13,"containerName":"reset_parameters","name":"@args"},{"line":277,"name":"@PARAMS","containerName":"reset_parameters","kind":13},{"line":278,"name":"$self","containerName":"reset_parameters","kind":13},{"kind":12,"containerName":"reset_parameters","name":"eutil","line":278},{"line":278,"containerName":"reset_parameters","kind":13,"name":"$self"},{"line":278,"name":"eutil","kind":12,"containerName":"reset_parameters"},{"name":"$self","kind":13,"containerName":"reset_parameters","line":279},{"name":"set_default_retmode","containerName":"reset_parameters","kind":12,"line":279},{"line":279,"containerName":"reset_parameters","kind":13,"name":"$retmode"},{"line":280,"containerName":"reset_parameters","kind":13,"name":"$file"},{"line":280,"kind":13,"containerName":"reset_parameters","name":"$self"},{"name":"id_file","containerName":"reset_parameters","kind":12,"line":280},{"line":280,"name":"$file","kind":13,"containerName":"reset_parameters"},{"name":"$self","containerName":"reset_parameters","kind":13,"line":281}],"name":"reset_parameters","containerName":"main::","definition":"sub","detail":"($self,@args)","line":272,"kind":12,"range":{"start":{"line":272,"character":0},"end":{"character":9999,"line":282}},"signature":{"label":"reset_parameters($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: EUtilParameters.pm 15052 2008-12-01 08:47:39Z heikki $\n#\n# BioPerl module for Bio::Tools::EUtilities::EUtilParameters\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::EUtilities::EUtilParameters - Manipulation of NCBI eutil-based parameters for\nremote database requests.\n\n=head1 SYNOPSIS\n\n # Bio::Tools::EUtilities::EUtilParameters implements Bio::ParameterBaseI\n\n my @params = (-eutil => 'efetch',\n              db => 'nucleotide',\n              id => \\@ids,\n              email => 'me@foo.bar',\n              retmode => 'xml');\n\n my $p = Bio::Tools::EUtilities::EUtilParameters->new(@params);\n\n if ($p->parameters_changed) {\n                              # ...\n                             } # state information\n\n $p->set_parameters(@extra_params); # set new NCBI parameters, leaves others preset\n\n $p->reset_parameters(@new_params); # reset NCBI parameters to original state\n\n $p->to_string(); # get a URI-encoded string representation of the URL address\n\n $p->to_request(); # get an HTTP::Request object (to pass on to LWP::UserAgent)\n\n=head1 DESCRIPTION\n\nBio::Tools::EUtilities::EUtilParameters is-a Bio::ParameterBaseI implementation that allows\nsimple manipulation of NCBI eutil parameters for CGI-based queries. SOAP-based\nmethods may be added in the future.\n\nFor simplicity parameters do not require dashes when passed and do not need URI\nencoding (spaces are converted to '+', symbols encoded, etc). Also, the\nfollowing extra parameters can be passed to the new() constructor or via\nset_parameters() or reset_parameters():\n\n  eutil - the eutil to be used. The default is 'efetch' if not set.\n  correspondence - Flag for how IDs are treated. Default is undef (none).\n  history - a Bio::Tools::EUtilities::HistoryI object. Default is undef (none).\n\nAt this point minimal checking is done for potential errors in parameter\npassing, though these should be easily added in the future when necessary.\n\n=head1 TODO\n\nPossibly integrate SOAP-compliant methods. SOAP::Lite may be undergoing an\ncomplete rewrite so I'm hesitant about adding this in immediately.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the \nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::EUtilParameters;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::ParameterBaseI);\nuse URI;\nuse HTTP::Request;\nuse Bio::Root::IO;\n\n# eutils only has one hostbase URL\n\n# mode : GET or POST (HTTP::Request)\n# location : CGI location\n# params : allowed parameters for that eutil\nmy %MODE = (\n    'einfo'     => {\n        'mode'     => 'GET',\n        'location' => 'einfo.fcgi',\n        'params'   => [qw(db tool email)],\n                   },\n    'epost'     => {\n        'mode'     => 'POST',\n        'location' => 'epost.fcgi',\n        'params'   => [qw(db retmode id tool email WebEnv query_key)],\n                   },\n    'efetch'    => {\n        'mode'     => 'GET',\n        'location' => 'efetch.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype strand seq_start\n                       seq_stop complexity report tool email WebEnv query_key)],\n                   },\n    'esearch'   => {\n        'mode'     => 'GET',\n        'location' => 'esearch.fcgi',\n        'params'   => [qw(db retmode usehistory term field reldate mindate\n                       maxdate datetype retmax retstart rettype sort tool email\n                       WebEnv query_key)],\n                   },\n    'esummary'  => {\n        'mode'     => 'GET',\n        'location' => 'esummary.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype tool email\n                       WebEnv query_key)],\n                   },\n    'elink'     => {\n        'mode'     => 'GET',\n        'location' => 'elink.fcgi',\n        'params'   => [qw(db retmode id reldate mindate maxdate datetype term \n                    dbfrom holding cmd version tool email linkname WebEnv\n                    query_key)],\n                   },\n    'egquery'   => {\n        'mode'     => 'GET',\n        'location' => 'egquery.fcgi',\n        'params'   => [qw(term retmode tool email)],\n                   },\n    'espell'    => {\n        'mode'     => 'GET',\n        'location' => 'espell.fcgi',\n        'params'   => [qw(db retmode term tool email )],\n                   }\n);\n\nmy @PARAMS;\n\n# generate getter/setters (will move this into individual ones at some point)\n\nBEGIN {\n    @PARAMS = qw(db id email retmode rettype usehistory term field tool\n    reldate mindate maxdate datetype retstart retmax sort seq_start seq_stop\n    strand complexity report dbfrom cmd holding version linkname WebEnv\n    query_key);\n    for my $method (@PARAMS) {\n        eval <<END;\nsub $method {\n    my (\\$self, \\$val) = \\@_;\n    if (defined \\$val) {\n        if ((!defined \\$self->{'_$method'}) ||\n        (defined \\$self->{'_$method'} && \\$self->{'_$method'} ne \\$val)) {\n            \\$self->{'_statechange'} = 1;\n            \\$self->{'_$method'} = \\$val;\n        }\n    }\n    return \\$self->{'_$method'};\n}\nEND\n    }\n}\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($retmode) = $self->_rearrange([\"RETMODE\"],@args);\n    $self->_set_from_args(\\@args,\n        -methods => [@PARAMS, qw(eutil history correspondence id_file)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->tool() || $self->tool('bioperl');\n    # set default retmode if not explicitly set    \n    $self->set_default_retmode if (!$retmode);\n    $self->{'_statechange'} = 1;\n    return $self;\n}\n\n=head1 Bio::ParameterBaseI implemented methods\n\n=head2 set_parameters\n\n Title   : set_parameters\n Usage   : $pobj->set_parameters(@params);\n Function: sets the NCBI parameters listed in the hash or array\n Returns : None\n Args    : [optional] hash or array of parameter/values.  \n Note    : This sets any parameter passed but leaves previously set data alone.\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub set_parameters {\n    my ($self, @args) = @_;\n    # allow automated resetting; must check to ensure that retmode isn't explicitly passed\n    my ($newmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    # set default retmode if not explicitly passed\n    $self->set_default_retmode unless $newmode;\n    $file && $self->id_file($file);\n    return;\n}\n\n=head2 reset_parameters\n\n Title   : reset_parameters\n Usage   : resets values\n Function: resets parameters to either undef or value in passed hash\n Returns : none\n Args    : [optional] hash of parameter-value pairs\n Note    : This sets any parameter passed, but resets all others (deletes them).\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)"}},{"definition":"sub","detail":"($self)","children":[{"line":295,"name":"$self","kind":13,"localvar":"my","containerName":"parameters_changed","definition":"my"},{"containerName":"parameters_changed","kind":13,"name":"$self","line":296}],"containerName":"main::","name":"parameters_changed","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: EUtilParameters.pm 15052 2008-12-01 08:47:39Z heikki $\n#\n# BioPerl module for Bio::Tools::EUtilities::EUtilParameters\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::EUtilities::EUtilParameters - Manipulation of NCBI eutil-based parameters for\nremote database requests.\n\n=head1 SYNOPSIS\n\n # Bio::Tools::EUtilities::EUtilParameters implements Bio::ParameterBaseI\n\n my @params = (-eutil => 'efetch',\n              db => 'nucleotide',\n              id => \\@ids,\n              email => 'me@foo.bar',\n              retmode => 'xml');\n\n my $p = Bio::Tools::EUtilities::EUtilParameters->new(@params);\n\n if ($p->parameters_changed) {\n                              # ...\n                             } # state information\n\n $p->set_parameters(@extra_params); # set new NCBI parameters, leaves others preset\n\n $p->reset_parameters(@new_params); # reset NCBI parameters to original state\n\n $p->to_string(); # get a URI-encoded string representation of the URL address\n\n $p->to_request(); # get an HTTP::Request object (to pass on to LWP::UserAgent)\n\n=head1 DESCRIPTION\n\nBio::Tools::EUtilities::EUtilParameters is-a Bio::ParameterBaseI implementation that allows\nsimple manipulation of NCBI eutil parameters for CGI-based queries. SOAP-based\nmethods may be added in the future.\n\nFor simplicity parameters do not require dashes when passed and do not need URI\nencoding (spaces are converted to '+', symbols encoded, etc). Also, the\nfollowing extra parameters can be passed to the new() constructor or via\nset_parameters() or reset_parameters():\n\n  eutil - the eutil to be used. The default is 'efetch' if not set.\n  correspondence - Flag for how IDs are treated. Default is undef (none).\n  history - a Bio::Tools::EUtilities::HistoryI object. Default is undef (none).\n\nAt this point minimal checking is done for potential errors in parameter\npassing, though these should be easily added in the future when necessary.\n\n=head1 TODO\n\nPossibly integrate SOAP-compliant methods. SOAP::Lite may be undergoing an\ncomplete rewrite so I'm hesitant about adding this in immediately.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the \nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::EUtilParameters;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::ParameterBaseI);\nuse URI;\nuse HTTP::Request;\nuse Bio::Root::IO;\n\n# eutils only has one hostbase URL\n\n# mode : GET or POST (HTTP::Request)\n# location : CGI location\n# params : allowed parameters for that eutil\nmy %MODE = (\n    'einfo'     => {\n        'mode'     => 'GET',\n        'location' => 'einfo.fcgi',\n        'params'   => [qw(db tool email)],\n                   },\n    'epost'     => {\n        'mode'     => 'POST',\n        'location' => 'epost.fcgi',\n        'params'   => [qw(db retmode id tool email WebEnv query_key)],\n                   },\n    'efetch'    => {\n        'mode'     => 'GET',\n        'location' => 'efetch.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype strand seq_start\n                       seq_stop complexity report tool email WebEnv query_key)],\n                   },\n    'esearch'   => {\n        'mode'     => 'GET',\n        'location' => 'esearch.fcgi',\n        'params'   => [qw(db retmode usehistory term field reldate mindate\n                       maxdate datetype retmax retstart rettype sort tool email\n                       WebEnv query_key)],\n                   },\n    'esummary'  => {\n        'mode'     => 'GET',\n        'location' => 'esummary.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype tool email\n                       WebEnv query_key)],\n                   },\n    'elink'     => {\n        'mode'     => 'GET',\n        'location' => 'elink.fcgi',\n        'params'   => [qw(db retmode id reldate mindate maxdate datetype term \n                    dbfrom holding cmd version tool email linkname WebEnv\n                    query_key)],\n                   },\n    'egquery'   => {\n        'mode'     => 'GET',\n        'location' => 'egquery.fcgi',\n        'params'   => [qw(term retmode tool email)],\n                   },\n    'espell'    => {\n        'mode'     => 'GET',\n        'location' => 'espell.fcgi',\n        'params'   => [qw(db retmode term tool email )],\n                   }\n);\n\nmy @PARAMS;\n\n# generate getter/setters (will move this into individual ones at some point)\n\nBEGIN {\n    @PARAMS = qw(db id email retmode rettype usehistory term field tool\n    reldate mindate maxdate datetype retstart retmax sort seq_start seq_stop\n    strand complexity report dbfrom cmd holding version linkname WebEnv\n    query_key);\n    for my $method (@PARAMS) {\n        eval <<END;\nsub $method {\n    my (\\$self, \\$val) = \\@_;\n    if (defined \\$val) {\n        if ((!defined \\$self->{'_$method'}) ||\n        (defined \\$self->{'_$method'} && \\$self->{'_$method'} ne \\$val)) {\n            \\$self->{'_statechange'} = 1;\n            \\$self->{'_$method'} = \\$val;\n        }\n    }\n    return \\$self->{'_$method'};\n}\nEND\n    }\n}\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($retmode) = $self->_rearrange([\"RETMODE\"],@args);\n    $self->_set_from_args(\\@args,\n        -methods => [@PARAMS, qw(eutil history correspondence id_file)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->tool() || $self->tool('bioperl');\n    # set default retmode if not explicitly set    \n    $self->set_default_retmode if (!$retmode);\n    $self->{'_statechange'} = 1;\n    return $self;\n}\n\n=head1 Bio::ParameterBaseI implemented methods\n\n=head2 set_parameters\n\n Title   : set_parameters\n Usage   : $pobj->set_parameters(@params);\n Function: sets the NCBI parameters listed in the hash or array\n Returns : None\n Args    : [optional] hash or array of parameter/values.  \n Note    : This sets any parameter passed but leaves previously set data alone.\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub set_parameters {\n    my ($self, @args) = @_;\n    # allow automated resetting; must check to ensure that retmode isn't explicitly passed\n    my ($newmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    # set default retmode if not explicitly passed\n    $self->set_default_retmode unless $newmode;\n    $file && $self->id_file($file);\n    return;\n}\n\n=head2 reset_parameters\n\n Title   : reset_parameters\n Usage   : resets values\n Function: resets parameters to either undef or value in passed hash\n Returns : none\n Args    : [optional] hash of parameter-value pairs\n Note    : This sets any parameter passed, but resets all others (deletes them).\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub reset_parameters {\n    my ($self, @args) = @_;\n    # is there a better way of doing this?  probably, but this works...\n    my ($retmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    map { defined $self->{\"_$_\"} && undef $self->{\"_$_\"} } (@PARAMS, qw(eutil correspondence history_cache request_cache));\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->set_default_retmode unless $retmode;\n    $file && $self->id_file($file);\n    $self->{'_statechange'} = 1;\n}\n\n=head2 parameters_changed\n\n Title   : parameters_changed\n Usage   : if ($pobj->parameters_changed) {...}\n Function: Returns TRUE if parameters have changed\n Returns : Boolean (0 or 1)\n Args    : [optional] Boolean","label":"parameters_changed($self)"},"line":294,"range":{"start":{"line":294,"character":0},"end":{"character":9999,"line":297}},"kind":12},{"containerName":"main::","name":"available_parameters","children":[{"localvar":"my","containerName":"available_parameters","kind":13,"name":"$self","line":311,"definition":"my"},{"kind":13,"containerName":"available_parameters","name":"$type","line":311},{"line":312,"name":"$type","containerName":"available_parameters","kind":13},{"line":313,"name":"$type","kind":13,"containerName":"available_parameters"},{"name":"@PARAMS","containerName":"available_parameters","kind":13,"line":314},{"containerName":"available_parameters","kind":13,"name":"$self","line":316},{"line":316,"containerName":"available_parameters","kind":12,"name":"throw"},{"name":"$MODE","containerName":"available_parameters","kind":13,"line":316},{"containerName":"available_parameters","kind":13,"name":"$type","line":316},{"line":317,"name":"$MODE","containerName":"available_parameters","kind":13},{"name":"$type","containerName":"available_parameters","kind":13,"line":317}],"detail":"($self,$type)","definition":"sub","range":{"end":{"line":318,"character":9999},"start":{"character":0,"line":310}},"kind":12,"line":310,"signature":{"label":"available_parameters($self,$type)","parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: EUtilParameters.pm 15052 2008-12-01 08:47:39Z heikki $\n#\n# BioPerl module for Bio::Tools::EUtilities::EUtilParameters\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::EUtilities::EUtilParameters - Manipulation of NCBI eutil-based parameters for\nremote database requests.\n\n=head1 SYNOPSIS\n\n # Bio::Tools::EUtilities::EUtilParameters implements Bio::ParameterBaseI\n\n my @params = (-eutil => 'efetch',\n              db => 'nucleotide',\n              id => \\@ids,\n              email => 'me@foo.bar',\n              retmode => 'xml');\n\n my $p = Bio::Tools::EUtilities::EUtilParameters->new(@params);\n\n if ($p->parameters_changed) {\n                              # ...\n                             } # state information\n\n $p->set_parameters(@extra_params); # set new NCBI parameters, leaves others preset\n\n $p->reset_parameters(@new_params); # reset NCBI parameters to original state\n\n $p->to_string(); # get a URI-encoded string representation of the URL address\n\n $p->to_request(); # get an HTTP::Request object (to pass on to LWP::UserAgent)\n\n=head1 DESCRIPTION\n\nBio::Tools::EUtilities::EUtilParameters is-a Bio::ParameterBaseI implementation that allows\nsimple manipulation of NCBI eutil parameters for CGI-based queries. SOAP-based\nmethods may be added in the future.\n\nFor simplicity parameters do not require dashes when passed and do not need URI\nencoding (spaces are converted to '+', symbols encoded, etc). Also, the\nfollowing extra parameters can be passed to the new() constructor or via\nset_parameters() or reset_parameters():\n\n  eutil - the eutil to be used. The default is 'efetch' if not set.\n  correspondence - Flag for how IDs are treated. Default is undef (none).\n  history - a Bio::Tools::EUtilities::HistoryI object. Default is undef (none).\n\nAt this point minimal checking is done for potential errors in parameter\npassing, though these should be easily added in the future when necessary.\n\n=head1 TODO\n\nPossibly integrate SOAP-compliant methods. SOAP::Lite may be undergoing an\ncomplete rewrite so I'm hesitant about adding this in immediately.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the \nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::EUtilParameters;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::ParameterBaseI);\nuse URI;\nuse HTTP::Request;\nuse Bio::Root::IO;\n\n# eutils only has one hostbase URL\n\n# mode : GET or POST (HTTP::Request)\n# location : CGI location\n# params : allowed parameters for that eutil\nmy %MODE = (\n    'einfo'     => {\n        'mode'     => 'GET',\n        'location' => 'einfo.fcgi',\n        'params'   => [qw(db tool email)],\n                   },\n    'epost'     => {\n        'mode'     => 'POST',\n        'location' => 'epost.fcgi',\n        'params'   => [qw(db retmode id tool email WebEnv query_key)],\n                   },\n    'efetch'    => {\n        'mode'     => 'GET',\n        'location' => 'efetch.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype strand seq_start\n                       seq_stop complexity report tool email WebEnv query_key)],\n                   },\n    'esearch'   => {\n        'mode'     => 'GET',\n        'location' => 'esearch.fcgi',\n        'params'   => [qw(db retmode usehistory term field reldate mindate\n                       maxdate datetype retmax retstart rettype sort tool email\n                       WebEnv query_key)],\n                   },\n    'esummary'  => {\n        'mode'     => 'GET',\n        'location' => 'esummary.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype tool email\n                       WebEnv query_key)],\n                   },\n    'elink'     => {\n        'mode'     => 'GET',\n        'location' => 'elink.fcgi',\n        'params'   => [qw(db retmode id reldate mindate maxdate datetype term \n                    dbfrom holding cmd version tool email linkname WebEnv\n                    query_key)],\n                   },\n    'egquery'   => {\n        'mode'     => 'GET',\n        'location' => 'egquery.fcgi',\n        'params'   => [qw(term retmode tool email)],\n                   },\n    'espell'    => {\n        'mode'     => 'GET',\n        'location' => 'espell.fcgi',\n        'params'   => [qw(db retmode term tool email )],\n                   }\n);\n\nmy @PARAMS;\n\n# generate getter/setters (will move this into individual ones at some point)\n\nBEGIN {\n    @PARAMS = qw(db id email retmode rettype usehistory term field tool\n    reldate mindate maxdate datetype retstart retmax sort seq_start seq_stop\n    strand complexity report dbfrom cmd holding version linkname WebEnv\n    query_key);\n    for my $method (@PARAMS) {\n        eval <<END;\nsub $method {\n    my (\\$self, \\$val) = \\@_;\n    if (defined \\$val) {\n        if ((!defined \\$self->{'_$method'}) ||\n        (defined \\$self->{'_$method'} && \\$self->{'_$method'} ne \\$val)) {\n            \\$self->{'_statechange'} = 1;\n            \\$self->{'_$method'} = \\$val;\n        }\n    }\n    return \\$self->{'_$method'};\n}\nEND\n    }\n}\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($retmode) = $self->_rearrange([\"RETMODE\"],@args);\n    $self->_set_from_args(\\@args,\n        -methods => [@PARAMS, qw(eutil history correspondence id_file)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->tool() || $self->tool('bioperl');\n    # set default retmode if not explicitly set    \n    $self->set_default_retmode if (!$retmode);\n    $self->{'_statechange'} = 1;\n    return $self;\n}\n\n=head1 Bio::ParameterBaseI implemented methods\n\n=head2 set_parameters\n\n Title   : set_parameters\n Usage   : $pobj->set_parameters(@params);\n Function: sets the NCBI parameters listed in the hash or array\n Returns : None\n Args    : [optional] hash or array of parameter/values.  \n Note    : This sets any parameter passed but leaves previously set data alone.\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub set_parameters {\n    my ($self, @args) = @_;\n    # allow automated resetting; must check to ensure that retmode isn't explicitly passed\n    my ($newmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    # set default retmode if not explicitly passed\n    $self->set_default_retmode unless $newmode;\n    $file && $self->id_file($file);\n    return;\n}\n\n=head2 reset_parameters\n\n Title   : reset_parameters\n Usage   : resets values\n Function: resets parameters to either undef or value in passed hash\n Returns : none\n Args    : [optional] hash of parameter-value pairs\n Note    : This sets any parameter passed, but resets all others (deletes them).\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub reset_parameters {\n    my ($self, @args) = @_;\n    # is there a better way of doing this?  probably, but this works...\n    my ($retmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    map { defined $self->{\"_$_\"} && undef $self->{\"_$_\"} } (@PARAMS, qw(eutil correspondence history_cache request_cache));\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->set_default_retmode unless $retmode;\n    $file && $self->id_file($file);\n    $self->{'_statechange'} = 1;\n}\n\n=head2 parameters_changed\n\n Title   : parameters_changed\n Usage   : if ($pobj->parameters_changed) {...}\n Function: Returns TRUE if parameters have changed\n Returns : Boolean (0 or 1)\n Args    : [optional] Boolean\n\n\nsub parameters_changed {\n    my ($self) = @_;\n    $self->{'_statechange'};\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : @params = $pobj->available_parameters()\n Function: Returns a list of the available parameters\n Returns : Array of available parameters (no values)\n Args    : [optional] A string with the eutil name (for returning eutil-specific\n           parameters)"}},{"name":"params","kind":12,"line":317},{"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"get_parameters","name":"$self","line":339},{"line":339,"name":"@args","kind":13,"containerName":"get_parameters"},{"definition":"my","localvar":"my","kind":13,"containerName":"get_parameters","name":"$type","line":340},{"line":340,"kind":13,"containerName":"get_parameters","name":"$list"},{"name":"$join","kind":13,"containerName":"get_parameters","line":340},{"line":340,"name":"$self","containerName":"get_parameters","kind":13},{"kind":12,"containerName":"get_parameters","name":"_rearrange","line":340},{"line":340,"kind":13,"containerName":"get_parameters","name":"@args"},{"name":"$self","containerName":"get_parameters","kind":13,"line":341},{"line":341,"name":"throw","containerName":"get_parameters","kind":12},{"kind":13,"containerName":"get_parameters","name":"$list","line":341},{"name":"$list","kind":13,"containerName":"get_parameters","line":341},{"kind":13,"containerName":"get_parameters","name":"$type","line":342},{"name":"@final","containerName":"get_parameters","localvar":"my","kind":13,"line":343,"definition":"my"},{"name":"$list","kind":13,"containerName":"get_parameters","line":343},{"line":343,"name":"$self","kind":13,"containerName":"get_parameters"},{"containerName":"get_parameters","kind":12,"name":"can","line":343},{"name":"$list","kind":13,"containerName":"get_parameters","line":343}],"containerName":"main::","name":"get_parameters","definition":"sub","detail":"($self,@args)","line":338,"kind":12,"range":{"end":{"line":343,"character":9999},"start":{"line":338,"character":0}},"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: EUtilParameters.pm 15052 2008-12-01 08:47:39Z heikki $\n#\n# BioPerl module for Bio::Tools::EUtilities::EUtilParameters\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::EUtilities::EUtilParameters - Manipulation of NCBI eutil-based parameters for\nremote database requests.\n\n=head1 SYNOPSIS\n\n # Bio::Tools::EUtilities::EUtilParameters implements Bio::ParameterBaseI\n\n my @params = (-eutil => 'efetch',\n              db => 'nucleotide',\n              id => \\@ids,\n              email => 'me@foo.bar',\n              retmode => 'xml');\n\n my $p = Bio::Tools::EUtilities::EUtilParameters->new(@params);\n\n if ($p->parameters_changed) {\n                              # ...\n                             } # state information\n\n $p->set_parameters(@extra_params); # set new NCBI parameters, leaves others preset\n\n $p->reset_parameters(@new_params); # reset NCBI parameters to original state\n\n $p->to_string(); # get a URI-encoded string representation of the URL address\n\n $p->to_request(); # get an HTTP::Request object (to pass on to LWP::UserAgent)\n\n=head1 DESCRIPTION\n\nBio::Tools::EUtilities::EUtilParameters is-a Bio::ParameterBaseI implementation that allows\nsimple manipulation of NCBI eutil parameters for CGI-based queries. SOAP-based\nmethods may be added in the future.\n\nFor simplicity parameters do not require dashes when passed and do not need URI\nencoding (spaces are converted to '+', symbols encoded, etc). Also, the\nfollowing extra parameters can be passed to the new() constructor or via\nset_parameters() or reset_parameters():\n\n  eutil - the eutil to be used. The default is 'efetch' if not set.\n  correspondence - Flag for how IDs are treated. Default is undef (none).\n  history - a Bio::Tools::EUtilities::HistoryI object. Default is undef (none).\n\nAt this point minimal checking is done for potential errors in parameter\npassing, though these should be easily added in the future when necessary.\n\n=head1 TODO\n\nPossibly integrate SOAP-compliant methods. SOAP::Lite may be undergoing an\ncomplete rewrite so I'm hesitant about adding this in immediately.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the \nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::EUtilParameters;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::ParameterBaseI);\nuse URI;\nuse HTTP::Request;\nuse Bio::Root::IO;\n\n# eutils only has one hostbase URL\n\n# mode : GET or POST (HTTP::Request)\n# location : CGI location\n# params : allowed parameters for that eutil\nmy %MODE = (\n    'einfo'     => {\n        'mode'     => 'GET',\n        'location' => 'einfo.fcgi',\n        'params'   => [qw(db tool email)],\n                   },\n    'epost'     => {\n        'mode'     => 'POST',\n        'location' => 'epost.fcgi',\n        'params'   => [qw(db retmode id tool email WebEnv query_key)],\n                   },\n    'efetch'    => {\n        'mode'     => 'GET',\n        'location' => 'efetch.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype strand seq_start\n                       seq_stop complexity report tool email WebEnv query_key)],\n                   },\n    'esearch'   => {\n        'mode'     => 'GET',\n        'location' => 'esearch.fcgi',\n        'params'   => [qw(db retmode usehistory term field reldate mindate\n                       maxdate datetype retmax retstart rettype sort tool email\n                       WebEnv query_key)],\n                   },\n    'esummary'  => {\n        'mode'     => 'GET',\n        'location' => 'esummary.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype tool email\n                       WebEnv query_key)],\n                   },\n    'elink'     => {\n        'mode'     => 'GET',\n        'location' => 'elink.fcgi',\n        'params'   => [qw(db retmode id reldate mindate maxdate datetype term \n                    dbfrom holding cmd version tool email linkname WebEnv\n                    query_key)],\n                   },\n    'egquery'   => {\n        'mode'     => 'GET',\n        'location' => 'egquery.fcgi',\n        'params'   => [qw(term retmode tool email)],\n                   },\n    'espell'    => {\n        'mode'     => 'GET',\n        'location' => 'espell.fcgi',\n        'params'   => [qw(db retmode term tool email )],\n                   }\n);\n\nmy @PARAMS;\n\n# generate getter/setters (will move this into individual ones at some point)\n\nBEGIN {\n    @PARAMS = qw(db id email retmode rettype usehistory term field tool\n    reldate mindate maxdate datetype retstart retmax sort seq_start seq_stop\n    strand complexity report dbfrom cmd holding version linkname WebEnv\n    query_key);\n    for my $method (@PARAMS) {\n        eval <<END;\nsub $method {\n    my (\\$self, \\$val) = \\@_;\n    if (defined \\$val) {\n        if ((!defined \\$self->{'_$method'}) ||\n        (defined \\$self->{'_$method'} && \\$self->{'_$method'} ne \\$val)) {\n            \\$self->{'_statechange'} = 1;\n            \\$self->{'_$method'} = \\$val;\n        }\n    }\n    return \\$self->{'_$method'};\n}\nEND\n    }\n}\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($retmode) = $self->_rearrange([\"RETMODE\"],@args);\n    $self->_set_from_args(\\@args,\n        -methods => [@PARAMS, qw(eutil history correspondence id_file)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->tool() || $self->tool('bioperl');\n    # set default retmode if not explicitly set    \n    $self->set_default_retmode if (!$retmode);\n    $self->{'_statechange'} = 1;\n    return $self;\n}\n\n=head1 Bio::ParameterBaseI implemented methods\n\n=head2 set_parameters\n\n Title   : set_parameters\n Usage   : $pobj->set_parameters(@params);\n Function: sets the NCBI parameters listed in the hash or array\n Returns : None\n Args    : [optional] hash or array of parameter/values.  \n Note    : This sets any parameter passed but leaves previously set data alone.\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub set_parameters {\n    my ($self, @args) = @_;\n    # allow automated resetting; must check to ensure that retmode isn't explicitly passed\n    my ($newmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    # set default retmode if not explicitly passed\n    $self->set_default_retmode unless $newmode;\n    $file && $self->id_file($file);\n    return;\n}\n\n=head2 reset_parameters\n\n Title   : reset_parameters\n Usage   : resets values\n Function: resets parameters to either undef or value in passed hash\n Returns : none\n Args    : [optional] hash of parameter-value pairs\n Note    : This sets any parameter passed, but resets all others (deletes them).\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub reset_parameters {\n    my ($self, @args) = @_;\n    # is there a better way of doing this?  probably, but this works...\n    my ($retmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    map { defined $self->{\"_$_\"} && undef $self->{\"_$_\"} } (@PARAMS, qw(eutil correspondence history_cache request_cache));\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->set_default_retmode unless $retmode;\n    $file && $self->id_file($file);\n    $self->{'_statechange'} = 1;\n}\n\n=head2 parameters_changed\n\n Title   : parameters_changed\n Usage   : if ($pobj->parameters_changed) {...}\n Function: Returns TRUE if parameters have changed\n Returns : Boolean (0 or 1)\n Args    : [optional] Boolean\n\n\nsub parameters_changed {\n    my ($self) = @_;\n    $self->{'_statechange'};\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : @params = $pobj->available_parameters()\n Function: Returns a list of the available parameters\n Returns : Array of available parameters (no values)\n Args    : [optional] A string with the eutil name (for returning eutil-specific\n           parameters)\n\n\nsub available_parameters {\n    my ($self, $type) = @_;\n    $type ||= 'all';\n    if ($type eq 'all') {\n        return @PARAMS;\n    } else {\n        $self->throw(\"$type parameters not supported\") if !exists $MODE{$type};\n        return @{$MODE{$type}->{params}};\n    }\n}\n\n=head2 get_parameters\n\n Title   : get_parameters\n Usage   : @params = $pobj->get_parameters;\n           %params = $pobj->get_parameters;\n Function: Returns list of key/value pairs, parameter => value\n Returns : Flattened list of key-value pairs. All key-value pairs returned,\n           though subsets can be returned based on the '-type' parameter. Data\n           originally set as an array ref are returned based on whether the\n           '-join_id' flag is set (default is the same array ref).\n Args    : -type : the eutil name (Default: returns all).  Use of '-list'\n                    supercedes this\n           -list : array ref of specific parameters\n           -join_ids : Boolean; join IDs based on correspondence (Default: no join)","label":"get_parameters($self,@args)"}},{"line":343,"kind":13,"containerName":null,"name":"$self"},{"name":"available_parameters","kind":12,"containerName":"main::","line":343},{"name":"$type","kind":13,"containerName":null,"line":343},{"definition":"my","name":"@p","containerName":null,"localvar":"my","kind":13,"line":344},{"name":"$param","localvar":"my","kind":13,"containerName":null,"line":345,"definition":"my"},{"name":"@final","containerName":null,"kind":13,"line":345},{"containerName":null,"kind":13,"name":"$param","line":346},{"containerName":null,"kind":13,"name":"$self","line":346},{"name":"id","kind":12,"containerName":"main::","line":346},{"name":"%join","kind":13,"containerName":null,"line":346},{"definition":"my","line":347,"name":"$id","kind":13,"localvar":"my","containerName":null},{"line":347,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"containerName":"main::","name":"id","line":347},{"line":348,"name":"$self","kind":13,"containerName":null},{"line":348,"kind":12,"containerName":"main::","name":"correspondence"},{"line":348,"name":"$self","kind":13,"containerName":null},{"line":348,"containerName":"main::","kind":12,"name":"eutil"},{"definition":"my","name":"$id_group","localvar":"my","kind":13,"containerName":null,"line":349},{"line":349,"name":"%id","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%id_group","line":350},{"name":"@p","containerName":null,"kind":13,"line":351},{"line":351,"kind":13,"containerName":null,"name":"$id_group"},{"line":353,"name":"%id_group","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"@p","line":354},{"name":"%id_group","kind":13,"containerName":null,"line":354},{"line":357,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"containerName":"main::","name":"throw","line":357},{"line":361,"containerName":null,"kind":13,"name":"@p"},{"line":361,"name":"$id","containerName":null,"kind":13},{"line":362,"name":"$param","kind":13,"containerName":null},{"name":"$id","kind":13,"containerName":null,"line":362},{"containerName":null,"kind":13,"name":"$param","line":363},{"line":363,"name":"$id","containerName":null,"kind":13},{"line":366,"kind":13,"containerName":null,"name":"$param"},{"line":366,"name":"$self","kind":13,"containerName":null},{"name":"db","kind":12,"containerName":"main::","line":366},{"line":366,"name":"%join","kind":13,"containerName":null},{"name":"$db","localvar":"my","containerName":null,"kind":13,"line":367,"definition":"my"},{"name":"$self","kind":13,"containerName":null,"line":367},{"name":"db","containerName":"main::","kind":12,"line":367},{"containerName":null,"kind":13,"name":"@p","line":368},{"name":"$db","kind":13,"containerName":null,"line":368},{"containerName":null,"kind":13,"name":"$param","line":369},{"line":369,"name":"$db","kind":13,"containerName":null},{"name":"$param","kind":13,"containerName":null,"line":370},{"line":370,"name":"%db","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"@p","line":373},{"line":373,"name":"$param","kind":13,"containerName":null},{"line":373,"containerName":null,"kind":13,"name":"%self"},{"containerName":null,"kind":13,"name":"%self","line":373},{"kind":13,"containerName":null,"name":"@p","line":376},{"signature":{"documentation":"1;\n# $Id: EUtilParameters.pm 15052 2008-12-01 08:47:39Z heikki $\n#\n# BioPerl module for Bio::Tools::EUtilities::EUtilParameters\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::EUtilities::EUtilParameters - Manipulation of NCBI eutil-based parameters for\nremote database requests.\n\n=head1 SYNOPSIS\n\n # Bio::Tools::EUtilities::EUtilParameters implements Bio::ParameterBaseI\n\n my @params = (-eutil => 'efetch',\n              db => 'nucleotide',\n              id => \\@ids,\n              email => 'me@foo.bar',\n              retmode => 'xml');\n\n my $p = Bio::Tools::EUtilities::EUtilParameters->new(@params);\n\n if ($p->parameters_changed) {\n                              # ...\n                             } # state information\n\n $p->set_parameters(@extra_params); # set new NCBI parameters, leaves others preset\n\n $p->reset_parameters(@new_params); # reset NCBI parameters to original state\n\n $p->to_string(); # get a URI-encoded string representation of the URL address\n\n $p->to_request(); # get an HTTP::Request object (to pass on to LWP::UserAgent)\n\n=head1 DESCRIPTION\n\nBio::Tools::EUtilities::EUtilParameters is-a Bio::ParameterBaseI implementation that allows\nsimple manipulation of NCBI eutil parameters for CGI-based queries. SOAP-based\nmethods may be added in the future.\n\nFor simplicity parameters do not require dashes when passed and do not need URI\nencoding (spaces are converted to '+', symbols encoded, etc). Also, the\nfollowing extra parameters can be passed to the new() constructor or via\nset_parameters() or reset_parameters():\n\n  eutil - the eutil to be used. The default is 'efetch' if not set.\n  correspondence - Flag for how IDs are treated. Default is undef (none).\n  history - a Bio::Tools::EUtilities::HistoryI object. Default is undef (none).\n\nAt this point minimal checking is done for potential errors in parameter\npassing, though these should be easily added in the future when necessary.\n\n=head1 TODO\n\nPossibly integrate SOAP-compliant methods. SOAP::Lite may be undergoing an\ncomplete rewrite so I'm hesitant about adding this in immediately.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the \nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::EUtilParameters;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::ParameterBaseI);\nuse URI;\nuse HTTP::Request;\nuse Bio::Root::IO;\n\n# eutils only has one hostbase URL\n\n# mode : GET or POST (HTTP::Request)\n# location : CGI location\n# params : allowed parameters for that eutil\nmy %MODE = (\n    'einfo'     => {\n        'mode'     => 'GET',\n        'location' => 'einfo.fcgi',\n        'params'   => [qw(db tool email)],\n                   },\n    'epost'     => {\n        'mode'     => 'POST',\n        'location' => 'epost.fcgi',\n        'params'   => [qw(db retmode id tool email WebEnv query_key)],\n                   },\n    'efetch'    => {\n        'mode'     => 'GET',\n        'location' => 'efetch.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype strand seq_start\n                       seq_stop complexity report tool email WebEnv query_key)],\n                   },\n    'esearch'   => {\n        'mode'     => 'GET',\n        'location' => 'esearch.fcgi',\n        'params'   => [qw(db retmode usehistory term field reldate mindate\n                       maxdate datetype retmax retstart rettype sort tool email\n                       WebEnv query_key)],\n                   },\n    'esummary'  => {\n        'mode'     => 'GET',\n        'location' => 'esummary.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype tool email\n                       WebEnv query_key)],\n                   },\n    'elink'     => {\n        'mode'     => 'GET',\n        'location' => 'elink.fcgi',\n        'params'   => [qw(db retmode id reldate mindate maxdate datetype term \n                    dbfrom holding cmd version tool email linkname WebEnv\n                    query_key)],\n                   },\n    'egquery'   => {\n        'mode'     => 'GET',\n        'location' => 'egquery.fcgi',\n        'params'   => [qw(term retmode tool email)],\n                   },\n    'espell'    => {\n        'mode'     => 'GET',\n        'location' => 'espell.fcgi',\n        'params'   => [qw(db retmode term tool email )],\n                   }\n);\n\nmy @PARAMS;\n\n# generate getter/setters (will move this into individual ones at some point)\n\nBEGIN {\n    @PARAMS = qw(db id email retmode rettype usehistory term field tool\n    reldate mindate maxdate datetype retstart retmax sort seq_start seq_stop\n    strand complexity report dbfrom cmd holding version linkname WebEnv\n    query_key);\n    for my $method (@PARAMS) {\n        eval <<END;\nsub $method {\n    my (\\$self, \\$val) = \\@_;\n    if (defined \\$val) {\n        if ((!defined \\$self->{'_$method'}) ||\n        (defined \\$self->{'_$method'} && \\$self->{'_$method'} ne \\$val)) {\n            \\$self->{'_statechange'} = 1;\n            \\$self->{'_$method'} = \\$val;\n        }\n    }\n    return \\$self->{'_$method'};\n}\nEND\n    }\n}\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($retmode) = $self->_rearrange([\"RETMODE\"],@args);\n    $self->_set_from_args(\\@args,\n        -methods => [@PARAMS, qw(eutil history correspondence id_file)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->tool() || $self->tool('bioperl');\n    # set default retmode if not explicitly set    \n    $self->set_default_retmode if (!$retmode);\n    $self->{'_statechange'} = 1;\n    return $self;\n}\n\n=head1 Bio::ParameterBaseI implemented methods\n\n=head2 set_parameters\n\n Title   : set_parameters\n Usage   : $pobj->set_parameters(@params);\n Function: sets the NCBI parameters listed in the hash or array\n Returns : None\n Args    : [optional] hash or array of parameter/values.  \n Note    : This sets any parameter passed but leaves previously set data alone.\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub set_parameters {\n    my ($self, @args) = @_;\n    # allow automated resetting; must check to ensure that retmode isn't explicitly passed\n    my ($newmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    # set default retmode if not explicitly passed\n    $self->set_default_retmode unless $newmode;\n    $file && $self->id_file($file);\n    return;\n}\n\n=head2 reset_parameters\n\n Title   : reset_parameters\n Usage   : resets values\n Function: resets parameters to either undef or value in passed hash\n Returns : none\n Args    : [optional] hash of parameter-value pairs\n Note    : This sets any parameter passed, but resets all others (deletes them).\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub reset_parameters {\n    my ($self, @args) = @_;\n    # is there a better way of doing this?  probably, but this works...\n    my ($retmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    map { defined $self->{\"_$_\"} && undef $self->{\"_$_\"} } (@PARAMS, qw(eutil correspondence history_cache request_cache));\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->set_default_retmode unless $retmode;\n    $file && $self->id_file($file);\n    $self->{'_statechange'} = 1;\n}\n\n=head2 parameters_changed\n\n Title   : parameters_changed\n Usage   : if ($pobj->parameters_changed) {...}\n Function: Returns TRUE if parameters have changed\n Returns : Boolean (0 or 1)\n Args    : [optional] Boolean\n\n\nsub parameters_changed {\n    my ($self) = @_;\n    $self->{'_statechange'};\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : @params = $pobj->available_parameters()\n Function: Returns a list of the available parameters\n Returns : Array of available parameters (no values)\n Args    : [optional] A string with the eutil name (for returning eutil-specific\n           parameters)\n\n\nsub available_parameters {\n    my ($self, $type) = @_;\n    $type ||= 'all';\n    if ($type eq 'all') {\n        return @PARAMS;\n    } else {\n        $self->throw(\"$type parameters not supported\") if !exists $MODE{$type};\n        return @{$MODE{$type}->{params}};\n    }\n}\n\n=head2 get_parameters\n\n Title   : get_parameters\n Usage   : @params = $pobj->get_parameters;\n           %params = $pobj->get_parameters;\n Function: Returns list of key/value pairs, parameter => value\n Returns : Flattened list of key-value pairs. All key-value pairs returned,\n           though subsets can be returned based on the '-type' parameter. Data\n           originally set as an array ref are returned based on whether the\n           '-join_id' flag is set (default is the same array ref).\n Args    : -type : the eutil name (Default: returns all).  Use of '-list'\n                    supercedes this\n           -list : array ref of specific parameters\n           -join_ids : Boolean; join IDs based on correspondence (Default: no join)\n\n\nsub get_parameters {\n    my ($self, @args) = @_;\n    my ($type, $list, $join) = $self->_rearrange([qw(TYPE LIST JOIN_IDS)], @args);\n    $self->throw(\"Parameter list not an array ref\") if $list && ref $list ne 'ARRAY';\n    $type ||= '';\n    my @final = $list ? grep {$self->can($_)} @{$list} : $self->available_parameters($type);\n    my @p;\n    for my $param (@final) {\n        if ($param eq 'id' && $self->id && $join) {\n            my $id = $self->id;\n            if ($self->correspondence && $self->eutil eq 'elink') {\n                for my $id_group (@{ $id }) {\n                    if (ref($id_group) eq 'ARRAY') {\n                        push @p, ('id' => join(q(,), @{ $id_group }));\n                    }\n                    elsif (!ref($id_group)) {\n                        push @p, ('id'  => $id_group);\n                    }\n                    else {\n                        $self->throw(\"Unknown ID type: $id_group\");\n                    }\n                }\n            } else {\n                push @p, ref $id eq 'ARRAY' ?\n                ($param => join(',', @{ $id })):\n                ($param => $id);\n            }\n        }\n        elsif ($param eq 'db' && $self->db && $join) {\n            my $db = $self->db;\n            push @p, (ref $db eq 'ARRAY') ? \n                ($param => join(',', @{ $db })) :\n                ($param => $db) ;\n        }\n        else {\n            push @p, ($param => $self->{\"_$param\"}) if defined $self->{\"_$param\"};\n        }\n    }\n    return @p;\n}\n\n=head1 Implementation-specific to_* methods\n\n=head2 to_string\n\n Title   : to_string\n Usage   : $string = $pobj->to_string;\n Function: Returns string (URL only in this case)\n Returns : String (URL only for now)\n Args    : [optional] 'all'; build URI::http using all parameters\n           Default : Builds based on allowed parameters (presence of history data\n           or eutil type in %MODE).\n Note    : Changes state of object.  Absolute string","parameters":[{"label":"$self"},{"label":"@args"}],"label":"to_string($self,@args)"},"kind":12,"range":{"start":{"character":0,"line":394},"end":{"line":403,"character":9999}},"line":394,"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"to_string","children":[{"containerName":"to_string","localvar":"my","kind":13,"name":"$self","line":395,"definition":"my"},{"name":"@args","kind":13,"containerName":"to_string","line":395},{"name":"$self","kind":13,"containerName":"to_string","line":397},{"line":397,"name":"parameters_changed","kind":12,"containerName":"to_string"},{"containerName":"to_string","kind":13,"name":"$self","line":397},{"definition":"my","kind":13,"localvar":"my","containerName":"to_string","name":"$string","line":398},{"name":"$self","containerName":"to_string","kind":13,"line":398},{"containerName":"to_string","kind":12,"name":"to_request","line":398},{"line":398,"containerName":"to_string","kind":13,"name":"@args"},{"line":398,"containerName":"to_string","kind":12,"name":"uri"},{"line":398,"kind":12,"containerName":"to_string","name":"as_string"},{"name":"$self","kind":13,"containerName":"to_string","line":399},{"line":400,"name":"$self","kind":13,"containerName":"to_string"},{"name":"$string","kind":13,"containerName":"to_string","line":400},{"name":"$self","kind":13,"containerName":"to_string","line":402}]},{"name":"to_request","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"to_request","name":"$self","line":419},{"line":419,"containerName":"to_request","kind":13,"name":"$type"},{"name":"$self","containerName":"to_request","kind":13,"line":420},{"name":"parameters_changed","kind":12,"containerName":"to_request","line":420},{"line":420,"name":"$self","kind":13,"containerName":"to_request"},{"definition":"my","name":"$eutil","localvar":"my","containerName":"to_request","kind":13,"line":421},{"line":421,"name":"$self","containerName":"to_request","kind":13},{"line":421,"containerName":"to_request","kind":12,"name":"eutil"},{"containerName":"to_request","kind":13,"name":"$self","line":422},{"line":422,"name":"throw","containerName":"to_request","kind":12},{"line":422,"kind":13,"containerName":"to_request","name":"$eutil"},{"kind":13,"containerName":"to_request","name":"$type","line":424},{"line":424,"name":"$eutil","containerName":"to_request","kind":13},{"containerName":"to_request","localvar":"my","kind":13,"name":"$location","line":425,"definition":"my"},{"name":"$mode","kind":13,"containerName":"to_request","line":425},{"name":"$MODE","containerName":"to_request","kind":13,"line":425},{"containerName":"to_request","kind":13,"name":"$eutil","line":425},{"line":425,"containerName":"to_request","kind":13,"name":"$MODE"},{"line":425,"kind":13,"containerName":"to_request","name":"$eutil"},{"definition":"my","kind":13,"localvar":"my","containerName":"to_request","name":"$request","line":426},{"containerName":"to_request","localvar":"my","kind":13,"name":"$uri","line":427,"definition":"my"},{"kind":12,"containerName":"to_request","name":"new","line":427},{"line":427,"name":"$self","containerName":"to_request","kind":13},{"line":427,"name":"url_base_address","containerName":"to_request","kind":12},{"name":"$location","containerName":"to_request","kind":13,"line":427},{"name":"$mode","containerName":"to_request","kind":13,"line":428},{"containerName":"to_request","kind":13,"name":"$uri","line":429},{"line":429,"name":"query_form","containerName":"to_request","kind":12},{"line":429,"name":"$self","kind":13,"containerName":"to_request"},{"name":"get_parameters","kind":12,"containerName":"to_request","line":429},{"line":429,"name":"$type","kind":13,"containerName":"to_request"},{"line":430,"containerName":"to_request","kind":13,"name":"$request"},{"name":"new","kind":12,"containerName":"to_request","line":430},{"line":430,"name":"$mode","containerName":"to_request","kind":13},{"name":"$uri","kind":13,"containerName":"to_request","line":430},{"kind":13,"containerName":"to_request","name":"$self","line":431},{"line":431,"name":"$request","containerName":"to_request","kind":13},{"name":"$mode","containerName":"to_request","kind":13,"line":432},{"line":433,"containerName":"to_request","kind":13,"name":"$request"},{"line":433,"kind":12,"containerName":"to_request","name":"new"},{"line":433,"kind":13,"containerName":"to_request","name":"$mode"},{"line":433,"name":"$uri","kind":13,"containerName":"to_request"},{"line":433,"name":"as_string","kind":12,"containerName":"to_request"},{"containerName":"to_request","kind":13,"name":"$uri","line":434},{"kind":12,"containerName":"to_request","name":"query_form","line":434},{"kind":13,"containerName":"to_request","name":"$self","line":434},{"line":434,"name":"get_parameters","containerName":"to_request","kind":12},{"line":434,"containerName":"to_request","kind":13,"name":"$type"},{"name":"$request","kind":13,"containerName":"to_request","line":435},{"name":"content_type","kind":12,"containerName":"to_request","line":435},{"line":436,"containerName":"to_request","kind":13,"name":"$request"},{"kind":12,"containerName":"to_request","name":"content","line":436},{"line":436,"containerName":"to_request","kind":13,"name":"$uri"},{"containerName":"to_request","kind":12,"name":"query","line":436},{"containerName":"to_request","kind":13,"name":"$self","line":437},{"containerName":"to_request","kind":13,"name":"$request","line":437},{"line":439,"name":"$self","containerName":"to_request","kind":13},{"line":439,"name":"throw","kind":12,"containerName":"to_request"},{"line":441,"kind":13,"containerName":"to_request","name":"$self"},{"line":442,"name":"$self","kind":13,"containerName":"to_request"},{"containerName":"to_request","kind":13,"name":"$request","line":442},{"line":444,"kind":13,"containerName":"to_request","name":"$self"}],"detail":"($self,$type)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":445},"start":{"character":0,"line":418}},"line":418,"signature":{"label":"to_request($self,$type)","documentation":"1;\n# $Id: EUtilParameters.pm 15052 2008-12-01 08:47:39Z heikki $\n#\n# BioPerl module for Bio::Tools::EUtilities::EUtilParameters\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::EUtilities::EUtilParameters - Manipulation of NCBI eutil-based parameters for\nremote database requests.\n\n=head1 SYNOPSIS\n\n # Bio::Tools::EUtilities::EUtilParameters implements Bio::ParameterBaseI\n\n my @params = (-eutil => 'efetch',\n              db => 'nucleotide',\n              id => \\@ids,\n              email => 'me@foo.bar',\n              retmode => 'xml');\n\n my $p = Bio::Tools::EUtilities::EUtilParameters->new(@params);\n\n if ($p->parameters_changed) {\n                              # ...\n                             } # state information\n\n $p->set_parameters(@extra_params); # set new NCBI parameters, leaves others preset\n\n $p->reset_parameters(@new_params); # reset NCBI parameters to original state\n\n $p->to_string(); # get a URI-encoded string representation of the URL address\n\n $p->to_request(); # get an HTTP::Request object (to pass on to LWP::UserAgent)\n\n=head1 DESCRIPTION\n\nBio::Tools::EUtilities::EUtilParameters is-a Bio::ParameterBaseI implementation that allows\nsimple manipulation of NCBI eutil parameters for CGI-based queries. SOAP-based\nmethods may be added in the future.\n\nFor simplicity parameters do not require dashes when passed and do not need URI\nencoding (spaces are converted to '+', symbols encoded, etc). Also, the\nfollowing extra parameters can be passed to the new() constructor or via\nset_parameters() or reset_parameters():\n\n  eutil - the eutil to be used. The default is 'efetch' if not set.\n  correspondence - Flag for how IDs are treated. Default is undef (none).\n  history - a Bio::Tools::EUtilities::HistoryI object. Default is undef (none).\n\nAt this point minimal checking is done for potential errors in parameter\npassing, though these should be easily added in the future when necessary.\n\n=head1 TODO\n\nPossibly integrate SOAP-compliant methods. SOAP::Lite may be undergoing an\ncomplete rewrite so I'm hesitant about adding this in immediately.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the \nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::EUtilParameters;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::ParameterBaseI);\nuse URI;\nuse HTTP::Request;\nuse Bio::Root::IO;\n\n# eutils only has one hostbase URL\n\n# mode : GET or POST (HTTP::Request)\n# location : CGI location\n# params : allowed parameters for that eutil\nmy %MODE = (\n    'einfo'     => {\n        'mode'     => 'GET',\n        'location' => 'einfo.fcgi',\n        'params'   => [qw(db tool email)],\n                   },\n    'epost'     => {\n        'mode'     => 'POST',\n        'location' => 'epost.fcgi',\n        'params'   => [qw(db retmode id tool email WebEnv query_key)],\n                   },\n    'efetch'    => {\n        'mode'     => 'GET',\n        'location' => 'efetch.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype strand seq_start\n                       seq_stop complexity report tool email WebEnv query_key)],\n                   },\n    'esearch'   => {\n        'mode'     => 'GET',\n        'location' => 'esearch.fcgi',\n        'params'   => [qw(db retmode usehistory term field reldate mindate\n                       maxdate datetype retmax retstart rettype sort tool email\n                       WebEnv query_key)],\n                   },\n    'esummary'  => {\n        'mode'     => 'GET',\n        'location' => 'esummary.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype tool email\n                       WebEnv query_key)],\n                   },\n    'elink'     => {\n        'mode'     => 'GET',\n        'location' => 'elink.fcgi',\n        'params'   => [qw(db retmode id reldate mindate maxdate datetype term \n                    dbfrom holding cmd version tool email linkname WebEnv\n                    query_key)],\n                   },\n    'egquery'   => {\n        'mode'     => 'GET',\n        'location' => 'egquery.fcgi',\n        'params'   => [qw(term retmode tool email)],\n                   },\n    'espell'    => {\n        'mode'     => 'GET',\n        'location' => 'espell.fcgi',\n        'params'   => [qw(db retmode term tool email )],\n                   }\n);\n\nmy @PARAMS;\n\n# generate getter/setters (will move this into individual ones at some point)\n\nBEGIN {\n    @PARAMS = qw(db id email retmode rettype usehistory term field tool\n    reldate mindate maxdate datetype retstart retmax sort seq_start seq_stop\n    strand complexity report dbfrom cmd holding version linkname WebEnv\n    query_key);\n    for my $method (@PARAMS) {\n        eval <<END;\nsub $method {\n    my (\\$self, \\$val) = \\@_;\n    if (defined \\$val) {\n        if ((!defined \\$self->{'_$method'}) ||\n        (defined \\$self->{'_$method'} && \\$self->{'_$method'} ne \\$val)) {\n            \\$self->{'_statechange'} = 1;\n            \\$self->{'_$method'} = \\$val;\n        }\n    }\n    return \\$self->{'_$method'};\n}\nEND\n    }\n}\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($retmode) = $self->_rearrange([\"RETMODE\"],@args);\n    $self->_set_from_args(\\@args,\n        -methods => [@PARAMS, qw(eutil history correspondence id_file)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->tool() || $self->tool('bioperl');\n    # set default retmode if not explicitly set    \n    $self->set_default_retmode if (!$retmode);\n    $self->{'_statechange'} = 1;\n    return $self;\n}\n\n=head1 Bio::ParameterBaseI implemented methods\n\n=head2 set_parameters\n\n Title   : set_parameters\n Usage   : $pobj->set_parameters(@params);\n Function: sets the NCBI parameters listed in the hash or array\n Returns : None\n Args    : [optional] hash or array of parameter/values.  \n Note    : This sets any parameter passed but leaves previously set data alone.\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub set_parameters {\n    my ($self, @args) = @_;\n    # allow automated resetting; must check to ensure that retmode isn't explicitly passed\n    my ($newmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    # set default retmode if not explicitly passed\n    $self->set_default_retmode unless $newmode;\n    $file && $self->id_file($file);\n    return;\n}\n\n=head2 reset_parameters\n\n Title   : reset_parameters\n Usage   : resets values\n Function: resets parameters to either undef or value in passed hash\n Returns : none\n Args    : [optional] hash of parameter-value pairs\n Note    : This sets any parameter passed, but resets all others (deletes them).\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub reset_parameters {\n    my ($self, @args) = @_;\n    # is there a better way of doing this?  probably, but this works...\n    my ($retmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    map { defined $self->{\"_$_\"} && undef $self->{\"_$_\"} } (@PARAMS, qw(eutil correspondence history_cache request_cache));\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->set_default_retmode unless $retmode;\n    $file && $self->id_file($file);\n    $self->{'_statechange'} = 1;\n}\n\n=head2 parameters_changed\n\n Title   : parameters_changed\n Usage   : if ($pobj->parameters_changed) {...}\n Function: Returns TRUE if parameters have changed\n Returns : Boolean (0 or 1)\n Args    : [optional] Boolean\n\n\nsub parameters_changed {\n    my ($self) = @_;\n    $self->{'_statechange'};\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : @params = $pobj->available_parameters()\n Function: Returns a list of the available parameters\n Returns : Array of available parameters (no values)\n Args    : [optional] A string with the eutil name (for returning eutil-specific\n           parameters)\n\n\nsub available_parameters {\n    my ($self, $type) = @_;\n    $type ||= 'all';\n    if ($type eq 'all') {\n        return @PARAMS;\n    } else {\n        $self->throw(\"$type parameters not supported\") if !exists $MODE{$type};\n        return @{$MODE{$type}->{params}};\n    }\n}\n\n=head2 get_parameters\n\n Title   : get_parameters\n Usage   : @params = $pobj->get_parameters;\n           %params = $pobj->get_parameters;\n Function: Returns list of key/value pairs, parameter => value\n Returns : Flattened list of key-value pairs. All key-value pairs returned,\n           though subsets can be returned based on the '-type' parameter. Data\n           originally set as an array ref are returned based on whether the\n           '-join_id' flag is set (default is the same array ref).\n Args    : -type : the eutil name (Default: returns all).  Use of '-list'\n                    supercedes this\n           -list : array ref of specific parameters\n           -join_ids : Boolean; join IDs based on correspondence (Default: no join)\n\n\nsub get_parameters {\n    my ($self, @args) = @_;\n    my ($type, $list, $join) = $self->_rearrange([qw(TYPE LIST JOIN_IDS)], @args);\n    $self->throw(\"Parameter list not an array ref\") if $list && ref $list ne 'ARRAY';\n    $type ||= '';\n    my @final = $list ? grep {$self->can($_)} @{$list} : $self->available_parameters($type);\n    my @p;\n    for my $param (@final) {\n        if ($param eq 'id' && $self->id && $join) {\n            my $id = $self->id;\n            if ($self->correspondence && $self->eutil eq 'elink') {\n                for my $id_group (@{ $id }) {\n                    if (ref($id_group) eq 'ARRAY') {\n                        push @p, ('id' => join(q(,), @{ $id_group }));\n                    }\n                    elsif (!ref($id_group)) {\n                        push @p, ('id'  => $id_group);\n                    }\n                    else {\n                        $self->throw(\"Unknown ID type: $id_group\");\n                    }\n                }\n            } else {\n                push @p, ref $id eq 'ARRAY' ?\n                ($param => join(',', @{ $id })):\n                ($param => $id);\n            }\n        }\n        elsif ($param eq 'db' && $self->db && $join) {\n            my $db = $self->db;\n            push @p, (ref $db eq 'ARRAY') ? \n                ($param => join(',', @{ $db })) :\n                ($param => $db) ;\n        }\n        else {\n            push @p, ($param => $self->{\"_$param\"}) if defined $self->{\"_$param\"};\n        }\n    }\n    return @p;\n}\n\n=head1 Implementation-specific to_* methods\n\n=head2 to_string\n\n Title   : to_string\n Usage   : $string = $pobj->to_string;\n Function: Returns string (URL only in this case)\n Returns : String (URL only for now)\n Args    : [optional] 'all'; build URI::http using all parameters\n           Default : Builds based on allowed parameters (presence of history data\n           or eutil type in %MODE).\n Note    : Changes state of object.  Absolute string\n\n\nsub to_string {\n    my ($self, @args) = @_;\n    # calling to_uri changes the state\n    if ($self->parameters_changed || !defined $self->{'_string_cache'}) {\n        my $string = $self->to_request(@args)->uri->as_string;\n        $self->{'_statechange'} = 0;\n        $self->{'_string_cache'} = $string;\n    }\n    return $self->{'_string_cache'};\n}\n\n=head2 to_request\n\n Title   : to_request\n Usage   : $uri = $pobj->to_request;\n Function: Returns HTTP::Request object\n Returns : HTTP::Request\n Args    : [optional] 'all'; builds request using all parameters\n           Default : Builds based on allowed parameters (presence of history data\n           or eutil type in %MODE).\n Note    : Changes state of object (to boolean FALSE).  Used for CGI-based GET/POST","parameters":[{"label":"$self"},{"label":"$type"}]}},{"kind":12,"name":"location","line":425},{"line":425,"kind":12,"name":"mode"},{"line":427,"name":"URI","kind":12},{"line":430,"name":"HTTP","containerName":"Request","kind":12},{"line":433,"kind":12,"containerName":"Request","name":"HTTP"},{"signature":{"documentation":"1;\n# $Id: EUtilParameters.pm 15052 2008-12-01 08:47:39Z heikki $\n#\n# BioPerl module for Bio::Tools::EUtilities::EUtilParameters\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::EUtilities::EUtilParameters - Manipulation of NCBI eutil-based parameters for\nremote database requests.\n\n=head1 SYNOPSIS\n\n # Bio::Tools::EUtilities::EUtilParameters implements Bio::ParameterBaseI\n\n my @params = (-eutil => 'efetch',\n              db => 'nucleotide',\n              id => \\@ids,\n              email => 'me@foo.bar',\n              retmode => 'xml');\n\n my $p = Bio::Tools::EUtilities::EUtilParameters->new(@params);\n\n if ($p->parameters_changed) {\n                              # ...\n                             } # state information\n\n $p->set_parameters(@extra_params); # set new NCBI parameters, leaves others preset\n\n $p->reset_parameters(@new_params); # reset NCBI parameters to original state\n\n $p->to_string(); # get a URI-encoded string representation of the URL address\n\n $p->to_request(); # get an HTTP::Request object (to pass on to LWP::UserAgent)\n\n=head1 DESCRIPTION\n\nBio::Tools::EUtilities::EUtilParameters is-a Bio::ParameterBaseI implementation that allows\nsimple manipulation of NCBI eutil parameters for CGI-based queries. SOAP-based\nmethods may be added in the future.\n\nFor simplicity parameters do not require dashes when passed and do not need URI\nencoding (spaces are converted to '+', symbols encoded, etc). Also, the\nfollowing extra parameters can be passed to the new() constructor or via\nset_parameters() or reset_parameters():\n\n  eutil - the eutil to be used. The default is 'efetch' if not set.\n  correspondence - Flag for how IDs are treated. Default is undef (none).\n  history - a Bio::Tools::EUtilities::HistoryI object. Default is undef (none).\n\nAt this point minimal checking is done for potential errors in parameter\npassing, though these should be easily added in the future when necessary.\n\n=head1 TODO\n\nPossibly integrate SOAP-compliant methods. SOAP::Lite may be undergoing an\ncomplete rewrite so I'm hesitant about adding this in immediately.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the \nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::EUtilParameters;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::ParameterBaseI);\nuse URI;\nuse HTTP::Request;\nuse Bio::Root::IO;\n\n# eutils only has one hostbase URL\n\n# mode : GET or POST (HTTP::Request)\n# location : CGI location\n# params : allowed parameters for that eutil\nmy %MODE = (\n    'einfo'     => {\n        'mode'     => 'GET',\n        'location' => 'einfo.fcgi',\n        'params'   => [qw(db tool email)],\n                   },\n    'epost'     => {\n        'mode'     => 'POST',\n        'location' => 'epost.fcgi',\n        'params'   => [qw(db retmode id tool email WebEnv query_key)],\n                   },\n    'efetch'    => {\n        'mode'     => 'GET',\n        'location' => 'efetch.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype strand seq_start\n                       seq_stop complexity report tool email WebEnv query_key)],\n                   },\n    'esearch'   => {\n        'mode'     => 'GET',\n        'location' => 'esearch.fcgi',\n        'params'   => [qw(db retmode usehistory term field reldate mindate\n                       maxdate datetype retmax retstart rettype sort tool email\n                       WebEnv query_key)],\n                   },\n    'esummary'  => {\n        'mode'     => 'GET',\n        'location' => 'esummary.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype tool email\n                       WebEnv query_key)],\n                   },\n    'elink'     => {\n        'mode'     => 'GET',\n        'location' => 'elink.fcgi',\n        'params'   => [qw(db retmode id reldate mindate maxdate datetype term \n                    dbfrom holding cmd version tool email linkname WebEnv\n                    query_key)],\n                   },\n    'egquery'   => {\n        'mode'     => 'GET',\n        'location' => 'egquery.fcgi',\n        'params'   => [qw(term retmode tool email)],\n                   },\n    'espell'    => {\n        'mode'     => 'GET',\n        'location' => 'espell.fcgi',\n        'params'   => [qw(db retmode term tool email )],\n                   }\n);\n\nmy @PARAMS;\n\n# generate getter/setters (will move this into individual ones at some point)\n\nBEGIN {\n    @PARAMS = qw(db id email retmode rettype usehistory term field tool\n    reldate mindate maxdate datetype retstart retmax sort seq_start seq_stop\n    strand complexity report dbfrom cmd holding version linkname WebEnv\n    query_key);\n    for my $method (@PARAMS) {\n        eval <<END;\nsub $method {\n    my (\\$self, \\$val) = \\@_;\n    if (defined \\$val) {\n        if ((!defined \\$self->{'_$method'}) ||\n        (defined \\$self->{'_$method'} && \\$self->{'_$method'} ne \\$val)) {\n            \\$self->{'_statechange'} = 1;\n            \\$self->{'_$method'} = \\$val;\n        }\n    }\n    return \\$self->{'_$method'};\n}\nEND\n    }\n}\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($retmode) = $self->_rearrange([\"RETMODE\"],@args);\n    $self->_set_from_args(\\@args,\n        -methods => [@PARAMS, qw(eutil history correspondence id_file)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->tool() || $self->tool('bioperl');\n    # set default retmode if not explicitly set    \n    $self->set_default_retmode if (!$retmode);\n    $self->{'_statechange'} = 1;\n    return $self;\n}\n\n=head1 Bio::ParameterBaseI implemented methods\n\n=head2 set_parameters\n\n Title   : set_parameters\n Usage   : $pobj->set_parameters(@params);\n Function: sets the NCBI parameters listed in the hash or array\n Returns : None\n Args    : [optional] hash or array of parameter/values.  \n Note    : This sets any parameter passed but leaves previously set data alone.\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub set_parameters {\n    my ($self, @args) = @_;\n    # allow automated resetting; must check to ensure that retmode isn't explicitly passed\n    my ($newmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    # set default retmode if not explicitly passed\n    $self->set_default_retmode unless $newmode;\n    $file && $self->id_file($file);\n    return;\n}\n\n=head2 reset_parameters\n\n Title   : reset_parameters\n Usage   : resets values\n Function: resets parameters to either undef or value in passed hash\n Returns : none\n Args    : [optional] hash of parameter-value pairs\n Note    : This sets any parameter passed, but resets all others (deletes them).\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub reset_parameters {\n    my ($self, @args) = @_;\n    # is there a better way of doing this?  probably, but this works...\n    my ($retmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    map { defined $self->{\"_$_\"} && undef $self->{\"_$_\"} } (@PARAMS, qw(eutil correspondence history_cache request_cache));\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->set_default_retmode unless $retmode;\n    $file && $self->id_file($file);\n    $self->{'_statechange'} = 1;\n}\n\n=head2 parameters_changed\n\n Title   : parameters_changed\n Usage   : if ($pobj->parameters_changed) {...}\n Function: Returns TRUE if parameters have changed\n Returns : Boolean (0 or 1)\n Args    : [optional] Boolean\n\n\nsub parameters_changed {\n    my ($self) = @_;\n    $self->{'_statechange'};\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : @params = $pobj->available_parameters()\n Function: Returns a list of the available parameters\n Returns : Array of available parameters (no values)\n Args    : [optional] A string with the eutil name (for returning eutil-specific\n           parameters)\n\n\nsub available_parameters {\n    my ($self, $type) = @_;\n    $type ||= 'all';\n    if ($type eq 'all') {\n        return @PARAMS;\n    } else {\n        $self->throw(\"$type parameters not supported\") if !exists $MODE{$type};\n        return @{$MODE{$type}->{params}};\n    }\n}\n\n=head2 get_parameters\n\n Title   : get_parameters\n Usage   : @params = $pobj->get_parameters;\n           %params = $pobj->get_parameters;\n Function: Returns list of key/value pairs, parameter => value\n Returns : Flattened list of key-value pairs. All key-value pairs returned,\n           though subsets can be returned based on the '-type' parameter. Data\n           originally set as an array ref are returned based on whether the\n           '-join_id' flag is set (default is the same array ref).\n Args    : -type : the eutil name (Default: returns all).  Use of '-list'\n                    supercedes this\n           -list : array ref of specific parameters\n           -join_ids : Boolean; join IDs based on correspondence (Default: no join)\n\n\nsub get_parameters {\n    my ($self, @args) = @_;\n    my ($type, $list, $join) = $self->_rearrange([qw(TYPE LIST JOIN_IDS)], @args);\n    $self->throw(\"Parameter list not an array ref\") if $list && ref $list ne 'ARRAY';\n    $type ||= '';\n    my @final = $list ? grep {$self->can($_)} @{$list} : $self->available_parameters($type);\n    my @p;\n    for my $param (@final) {\n        if ($param eq 'id' && $self->id && $join) {\n            my $id = $self->id;\n            if ($self->correspondence && $self->eutil eq 'elink') {\n                for my $id_group (@{ $id }) {\n                    if (ref($id_group) eq 'ARRAY') {\n                        push @p, ('id' => join(q(,), @{ $id_group }));\n                    }\n                    elsif (!ref($id_group)) {\n                        push @p, ('id'  => $id_group);\n                    }\n                    else {\n                        $self->throw(\"Unknown ID type: $id_group\");\n                    }\n                }\n            } else {\n                push @p, ref $id eq 'ARRAY' ?\n                ($param => join(',', @{ $id })):\n                ($param => $id);\n            }\n        }\n        elsif ($param eq 'db' && $self->db && $join) {\n            my $db = $self->db;\n            push @p, (ref $db eq 'ARRAY') ? \n                ($param => join(',', @{ $db })) :\n                ($param => $db) ;\n        }\n        else {\n            push @p, ($param => $self->{\"_$param\"}) if defined $self->{\"_$param\"};\n        }\n    }\n    return @p;\n}\n\n=head1 Implementation-specific to_* methods\n\n=head2 to_string\n\n Title   : to_string\n Usage   : $string = $pobj->to_string;\n Function: Returns string (URL only in this case)\n Returns : String (URL only for now)\n Args    : [optional] 'all'; build URI::http using all parameters\n           Default : Builds based on allowed parameters (presence of history data\n           or eutil type in %MODE).\n Note    : Changes state of object.  Absolute string\n\n\nsub to_string {\n    my ($self, @args) = @_;\n    # calling to_uri changes the state\n    if ($self->parameters_changed || !defined $self->{'_string_cache'}) {\n        my $string = $self->to_request(@args)->uri->as_string;\n        $self->{'_statechange'} = 0;\n        $self->{'_string_cache'} = $string;\n    }\n    return $self->{'_string_cache'};\n}\n\n=head2 to_request\n\n Title   : to_request\n Usage   : $uri = $pobj->to_request;\n Function: Returns HTTP::Request object\n Returns : HTTP::Request\n Args    : [optional] 'all'; builds request using all parameters\n           Default : Builds based on allowed parameters (presence of history data\n           or eutil type in %MODE).\n Note    : Changes state of object (to boolean FALSE).  Used for CGI-based GET/POST\n\n\nsub to_request {\n    my ($self, $type) = @_;\n    if ($self->parameters_changed || !defined $self->{'_request_cache'}) {\n        my $eutil = $self->eutil;\n        $self->throw(\"No eutil set\") if !$eutil;\n        #set default retmode\n        $type ||= $eutil;\n        my ($location, $mode) = ($MODE{$eutil}->{location}, $MODE{$eutil}->{mode});\n        my $request;\n        my $uri = URI->new($self->url_base_address . $location);\n        if ($mode eq 'GET') {\n            $uri->query_form($self->get_parameters(-type => $type, -join_ids => 1) );\n            $request = HTTP::Request->new($mode => $uri);\n            $self->{'_request_cache'} = $request;\n        } elsif ($mode eq 'POST') {\n            $request = HTTP::Request->new($mode => $uri->as_string);\n            $uri->query_form($self->get_parameters(-type => $type, -join_ids => 1) );\n            $request->content_type('application/x-www-form-urlencoded');\n            $request->content($uri->query);\n            $self->{'_request_cache'} = $request;\n        } else {\n            $self->throw(\"Unrecognized request mode: $mode\");\n        }\n        $self->{'_statechange'} = 0;\n        $self->{'_request_cache'} = $request;\n    }\n    return $self->{'_request_cache'};\n}\n\n=head1 Implementation specific-methods\n\n=head2 eutil\n\n Title   : eutil\n Usage   : $p->eutil('efetch')\n Function: gets/sets the eutil for this set of parameters\n Returns : string (eutil)\n Args    : [optional] string (eutil)\n Throws  : '$eutil not supported' if eutil not present\n Note    : This does not reset retmode to the default if called directly.","parameters":[{"label":"$self"},{"label":"$eutil"}],"label":"eutil($self,$eutil)"},"line":461,"range":{"end":{"character":9999,"line":471},"start":{"character":0,"line":461}},"kind":12,"definition":"sub","detail":"($self,$eutil)","children":[{"line":462,"localvar":"my","containerName":"eutil","kind":13,"name":"$self","definition":"my"},{"name":"$eutil","containerName":"eutil","kind":13,"line":462},{"line":463,"containerName":"eutil","kind":13,"name":"$eutil"},{"containerName":"eutil","kind":13,"name":"$self","line":464},{"kind":12,"containerName":"eutil","name":"throw","line":464},{"kind":13,"containerName":"eutil","name":"$MODE","line":464},{"line":464,"name":"$eutil","containerName":"eutil","kind":13},{"containerName":"eutil","kind":13,"name":"$self","line":465},{"line":465,"containerName":"eutil","kind":13,"name":"$self"},{"kind":13,"containerName":"eutil","name":"$self","line":465},{"line":465,"kind":13,"containerName":"eutil","name":"$eutil"},{"name":"$self","kind":13,"containerName":"eutil","line":466},{"line":466,"containerName":"eutil","kind":13,"name":"$eutil"},{"kind":13,"containerName":"eutil","name":"$self","line":467},{"line":470,"name":"$self","kind":13,"containerName":"eutil"}],"name":"eutil","containerName":"main::"},{"line":486,"range":{"end":{"character":9999,"line":498},"start":{"character":0,"line":486}},"kind":12,"signature":{"documentation":"1;\n# $Id: EUtilParameters.pm 15052 2008-12-01 08:47:39Z heikki $\n#\n# BioPerl module for Bio::Tools::EUtilities::EUtilParameters\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::EUtilities::EUtilParameters - Manipulation of NCBI eutil-based parameters for\nremote database requests.\n\n=head1 SYNOPSIS\n\n # Bio::Tools::EUtilities::EUtilParameters implements Bio::ParameterBaseI\n\n my @params = (-eutil => 'efetch',\n              db => 'nucleotide',\n              id => \\@ids,\n              email => 'me@foo.bar',\n              retmode => 'xml');\n\n my $p = Bio::Tools::EUtilities::EUtilParameters->new(@params);\n\n if ($p->parameters_changed) {\n                              # ...\n                             } # state information\n\n $p->set_parameters(@extra_params); # set new NCBI parameters, leaves others preset\n\n $p->reset_parameters(@new_params); # reset NCBI parameters to original state\n\n $p->to_string(); # get a URI-encoded string representation of the URL address\n\n $p->to_request(); # get an HTTP::Request object (to pass on to LWP::UserAgent)\n\n=head1 DESCRIPTION\n\nBio::Tools::EUtilities::EUtilParameters is-a Bio::ParameterBaseI implementation that allows\nsimple manipulation of NCBI eutil parameters for CGI-based queries. SOAP-based\nmethods may be added in the future.\n\nFor simplicity parameters do not require dashes when passed and do not need URI\nencoding (spaces are converted to '+', symbols encoded, etc). Also, the\nfollowing extra parameters can be passed to the new() constructor or via\nset_parameters() or reset_parameters():\n\n  eutil - the eutil to be used. The default is 'efetch' if not set.\n  correspondence - Flag for how IDs are treated. Default is undef (none).\n  history - a Bio::Tools::EUtilities::HistoryI object. Default is undef (none).\n\nAt this point minimal checking is done for potential errors in parameter\npassing, though these should be easily added in the future when necessary.\n\n=head1 TODO\n\nPossibly integrate SOAP-compliant methods. SOAP::Lite may be undergoing an\ncomplete rewrite so I'm hesitant about adding this in immediately.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the \nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::EUtilParameters;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::ParameterBaseI);\nuse URI;\nuse HTTP::Request;\nuse Bio::Root::IO;\n\n# eutils only has one hostbase URL\n\n# mode : GET or POST (HTTP::Request)\n# location : CGI location\n# params : allowed parameters for that eutil\nmy %MODE = (\n    'einfo'     => {\n        'mode'     => 'GET',\n        'location' => 'einfo.fcgi',\n        'params'   => [qw(db tool email)],\n                   },\n    'epost'     => {\n        'mode'     => 'POST',\n        'location' => 'epost.fcgi',\n        'params'   => [qw(db retmode id tool email WebEnv query_key)],\n                   },\n    'efetch'    => {\n        'mode'     => 'GET',\n        'location' => 'efetch.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype strand seq_start\n                       seq_stop complexity report tool email WebEnv query_key)],\n                   },\n    'esearch'   => {\n        'mode'     => 'GET',\n        'location' => 'esearch.fcgi',\n        'params'   => [qw(db retmode usehistory term field reldate mindate\n                       maxdate datetype retmax retstart rettype sort tool email\n                       WebEnv query_key)],\n                   },\n    'esummary'  => {\n        'mode'     => 'GET',\n        'location' => 'esummary.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype tool email\n                       WebEnv query_key)],\n                   },\n    'elink'     => {\n        'mode'     => 'GET',\n        'location' => 'elink.fcgi',\n        'params'   => [qw(db retmode id reldate mindate maxdate datetype term \n                    dbfrom holding cmd version tool email linkname WebEnv\n                    query_key)],\n                   },\n    'egquery'   => {\n        'mode'     => 'GET',\n        'location' => 'egquery.fcgi',\n        'params'   => [qw(term retmode tool email)],\n                   },\n    'espell'    => {\n        'mode'     => 'GET',\n        'location' => 'espell.fcgi',\n        'params'   => [qw(db retmode term tool email )],\n                   }\n);\n\nmy @PARAMS;\n\n# generate getter/setters (will move this into individual ones at some point)\n\nBEGIN {\n    @PARAMS = qw(db id email retmode rettype usehistory term field tool\n    reldate mindate maxdate datetype retstart retmax sort seq_start seq_stop\n    strand complexity report dbfrom cmd holding version linkname WebEnv\n    query_key);\n    for my $method (@PARAMS) {\n        eval <<END;\nsub $method {\n    my (\\$self, \\$val) = \\@_;\n    if (defined \\$val) {\n        if ((!defined \\$self->{'_$method'}) ||\n        (defined \\$self->{'_$method'} && \\$self->{'_$method'} ne \\$val)) {\n            \\$self->{'_statechange'} = 1;\n            \\$self->{'_$method'} = \\$val;\n        }\n    }\n    return \\$self->{'_$method'};\n}\nEND\n    }\n}\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($retmode) = $self->_rearrange([\"RETMODE\"],@args);\n    $self->_set_from_args(\\@args,\n        -methods => [@PARAMS, qw(eutil history correspondence id_file)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->tool() || $self->tool('bioperl');\n    # set default retmode if not explicitly set    \n    $self->set_default_retmode if (!$retmode);\n    $self->{'_statechange'} = 1;\n    return $self;\n}\n\n=head1 Bio::ParameterBaseI implemented methods\n\n=head2 set_parameters\n\n Title   : set_parameters\n Usage   : $pobj->set_parameters(@params);\n Function: sets the NCBI parameters listed in the hash or array\n Returns : None\n Args    : [optional] hash or array of parameter/values.  \n Note    : This sets any parameter passed but leaves previously set data alone.\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub set_parameters {\n    my ($self, @args) = @_;\n    # allow automated resetting; must check to ensure that retmode isn't explicitly passed\n    my ($newmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    # set default retmode if not explicitly passed\n    $self->set_default_retmode unless $newmode;\n    $file && $self->id_file($file);\n    return;\n}\n\n=head2 reset_parameters\n\n Title   : reset_parameters\n Usage   : resets values\n Function: resets parameters to either undef or value in passed hash\n Returns : none\n Args    : [optional] hash of parameter-value pairs\n Note    : This sets any parameter passed, but resets all others (deletes them).\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub reset_parameters {\n    my ($self, @args) = @_;\n    # is there a better way of doing this?  probably, but this works...\n    my ($retmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    map { defined $self->{\"_$_\"} && undef $self->{\"_$_\"} } (@PARAMS, qw(eutil correspondence history_cache request_cache));\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->set_default_retmode unless $retmode;\n    $file && $self->id_file($file);\n    $self->{'_statechange'} = 1;\n}\n\n=head2 parameters_changed\n\n Title   : parameters_changed\n Usage   : if ($pobj->parameters_changed) {...}\n Function: Returns TRUE if parameters have changed\n Returns : Boolean (0 or 1)\n Args    : [optional] Boolean\n\n\nsub parameters_changed {\n    my ($self) = @_;\n    $self->{'_statechange'};\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : @params = $pobj->available_parameters()\n Function: Returns a list of the available parameters\n Returns : Array of available parameters (no values)\n Args    : [optional] A string with the eutil name (for returning eutil-specific\n           parameters)\n\n\nsub available_parameters {\n    my ($self, $type) = @_;\n    $type ||= 'all';\n    if ($type eq 'all') {\n        return @PARAMS;\n    } else {\n        $self->throw(\"$type parameters not supported\") if !exists $MODE{$type};\n        return @{$MODE{$type}->{params}};\n    }\n}\n\n=head2 get_parameters\n\n Title   : get_parameters\n Usage   : @params = $pobj->get_parameters;\n           %params = $pobj->get_parameters;\n Function: Returns list of key/value pairs, parameter => value\n Returns : Flattened list of key-value pairs. All key-value pairs returned,\n           though subsets can be returned based on the '-type' parameter. Data\n           originally set as an array ref are returned based on whether the\n           '-join_id' flag is set (default is the same array ref).\n Args    : -type : the eutil name (Default: returns all).  Use of '-list'\n                    supercedes this\n           -list : array ref of specific parameters\n           -join_ids : Boolean; join IDs based on correspondence (Default: no join)\n\n\nsub get_parameters {\n    my ($self, @args) = @_;\n    my ($type, $list, $join) = $self->_rearrange([qw(TYPE LIST JOIN_IDS)], @args);\n    $self->throw(\"Parameter list not an array ref\") if $list && ref $list ne 'ARRAY';\n    $type ||= '';\n    my @final = $list ? grep {$self->can($_)} @{$list} : $self->available_parameters($type);\n    my @p;\n    for my $param (@final) {\n        if ($param eq 'id' && $self->id && $join) {\n            my $id = $self->id;\n            if ($self->correspondence && $self->eutil eq 'elink') {\n                for my $id_group (@{ $id }) {\n                    if (ref($id_group) eq 'ARRAY') {\n                        push @p, ('id' => join(q(,), @{ $id_group }));\n                    }\n                    elsif (!ref($id_group)) {\n                        push @p, ('id'  => $id_group);\n                    }\n                    else {\n                        $self->throw(\"Unknown ID type: $id_group\");\n                    }\n                }\n            } else {\n                push @p, ref $id eq 'ARRAY' ?\n                ($param => join(',', @{ $id })):\n                ($param => $id);\n            }\n        }\n        elsif ($param eq 'db' && $self->db && $join) {\n            my $db = $self->db;\n            push @p, (ref $db eq 'ARRAY') ? \n                ($param => join(',', @{ $db })) :\n                ($param => $db) ;\n        }\n        else {\n            push @p, ($param => $self->{\"_$param\"}) if defined $self->{\"_$param\"};\n        }\n    }\n    return @p;\n}\n\n=head1 Implementation-specific to_* methods\n\n=head2 to_string\n\n Title   : to_string\n Usage   : $string = $pobj->to_string;\n Function: Returns string (URL only in this case)\n Returns : String (URL only for now)\n Args    : [optional] 'all'; build URI::http using all parameters\n           Default : Builds based on allowed parameters (presence of history data\n           or eutil type in %MODE).\n Note    : Changes state of object.  Absolute string\n\n\nsub to_string {\n    my ($self, @args) = @_;\n    # calling to_uri changes the state\n    if ($self->parameters_changed || !defined $self->{'_string_cache'}) {\n        my $string = $self->to_request(@args)->uri->as_string;\n        $self->{'_statechange'} = 0;\n        $self->{'_string_cache'} = $string;\n    }\n    return $self->{'_string_cache'};\n}\n\n=head2 to_request\n\n Title   : to_request\n Usage   : $uri = $pobj->to_request;\n Function: Returns HTTP::Request object\n Returns : HTTP::Request\n Args    : [optional] 'all'; builds request using all parameters\n           Default : Builds based on allowed parameters (presence of history data\n           or eutil type in %MODE).\n Note    : Changes state of object (to boolean FALSE).  Used for CGI-based GET/POST\n\n\nsub to_request {\n    my ($self, $type) = @_;\n    if ($self->parameters_changed || !defined $self->{'_request_cache'}) {\n        my $eutil = $self->eutil;\n        $self->throw(\"No eutil set\") if !$eutil;\n        #set default retmode\n        $type ||= $eutil;\n        my ($location, $mode) = ($MODE{$eutil}->{location}, $MODE{$eutil}->{mode});\n        my $request;\n        my $uri = URI->new($self->url_base_address . $location);\n        if ($mode eq 'GET') {\n            $uri->query_form($self->get_parameters(-type => $type, -join_ids => 1) );\n            $request = HTTP::Request->new($mode => $uri);\n            $self->{'_request_cache'} = $request;\n        } elsif ($mode eq 'POST') {\n            $request = HTTP::Request->new($mode => $uri->as_string);\n            $uri->query_form($self->get_parameters(-type => $type, -join_ids => 1) );\n            $request->content_type('application/x-www-form-urlencoded');\n            $request->content($uri->query);\n            $self->{'_request_cache'} = $request;\n        } else {\n            $self->throw(\"Unrecognized request mode: $mode\");\n        }\n        $self->{'_statechange'} = 0;\n        $self->{'_request_cache'} = $request;\n    }\n    return $self->{'_request_cache'};\n}\n\n=head1 Implementation specific-methods\n\n=head2 eutil\n\n Title   : eutil\n Usage   : $p->eutil('efetch')\n Function: gets/sets the eutil for this set of parameters\n Returns : string (eutil)\n Args    : [optional] string (eutil)\n Throws  : '$eutil not supported' if eutil not present\n Note    : This does not reset retmode to the default if called directly.\n\n\nsub eutil {\n    my ($self, $eutil) = @_;\n    if ($eutil) {\n        $self->throw(\"$eutil not supported\") if !exists $MODE{$eutil};\n        if (!defined $self->{'_eutil'} || ($self->{'_eutil'} && $self->{'_eutil'} ne $eutil)) {\n            $self->{'_eutil'} = $eutil;\n            $self->{'_statechange'} = 1;\n        }\n    }\n    return $self->{'_eutil'};\n}\n\n=head2 history\n\n Title   : history\n Usage   : $p->history($history);\n Function: gets/sets the history object to be used for these parameters\n Returns : Bio::Tools::EUtilities::HistoryI (if set)\n Args    : [optional] Bio::Tools::EUtilities::HistoryI \n Throws  : Passed something other than a Bio::Tools::EUtilities::HistoryI \n Note    : This overrides WebEnv() and query_key() settings when set.  This\n           caches the last history object passed and returns like a Get/Set","parameters":[{"label":"$self"},{"label":"$history"}],"label":"history($self,$history)"},"children":[{"definition":"my","localvar":"my","containerName":"history","kind":13,"name":"$self","line":487},{"containerName":"history","kind":13,"name":"$history","line":487},{"line":488,"containerName":"history","kind":13,"name":"$history"},{"containerName":"history","kind":13,"name":"$self","line":489},{"name":"throw","kind":12,"containerName":"history","line":489},{"line":490,"name":"$history","containerName":"history","kind":13},{"name":"isa","kind":12,"containerName":"history","line":490},{"name":"$webenv","kind":13,"localvar":"my","containerName":"history","line":491,"definition":"my"},{"line":491,"containerName":"history","kind":13,"name":"$qkey"},{"name":"$history","containerName":"history","kind":13,"line":491},{"line":491,"name":"history","containerName":"history","kind":12},{"line":492,"containerName":"history","kind":13,"name":"$self"},{"line":492,"name":"WebEnv","kind":12,"containerName":"history"},{"line":492,"name":"$webenv","kind":13,"containerName":"history"},{"line":493,"containerName":"history","kind":13,"name":"$self"},{"kind":12,"containerName":"history","name":"query_key","line":493},{"line":493,"name":"$qkey","kind":13,"containerName":"history"},{"line":494,"name":"$self","containerName":"history","kind":13},{"name":"$self","containerName":"history","kind":13,"line":495},{"line":495,"name":"$history","containerName":"history","kind":13},{"name":"$self","containerName":"history","kind":13,"line":497}],"containerName":"main::","name":"history","definition":"sub","detail":"($self,$history)"},{"name":"correspondence","containerName":"main::","children":[{"definition":"my","line":511,"name":"$self","localvar":"my","containerName":"correspondence","kind":13},{"line":511,"containerName":"correspondence","kind":13,"name":"$corr"},{"line":512,"kind":13,"containerName":"correspondence","name":"$corr"},{"name":"$self","kind":13,"containerName":"correspondence","line":513},{"name":"$corr","containerName":"correspondence","kind":13,"line":513},{"line":514,"name":"$self","containerName":"correspondence","kind":13},{"kind":13,"containerName":"correspondence","name":"$self","line":516}],"detail":"($self,$corr)","definition":"sub","range":{"end":{"character":9999,"line":517},"start":{"line":510,"character":0}},"kind":12,"line":510,"signature":{"documentation":"1;\n# $Id: EUtilParameters.pm 15052 2008-12-01 08:47:39Z heikki $\n#\n# BioPerl module for Bio::Tools::EUtilities::EUtilParameters\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::EUtilities::EUtilParameters - Manipulation of NCBI eutil-based parameters for\nremote database requests.\n\n=head1 SYNOPSIS\n\n # Bio::Tools::EUtilities::EUtilParameters implements Bio::ParameterBaseI\n\n my @params = (-eutil => 'efetch',\n              db => 'nucleotide',\n              id => \\@ids,\n              email => 'me@foo.bar',\n              retmode => 'xml');\n\n my $p = Bio::Tools::EUtilities::EUtilParameters->new(@params);\n\n if ($p->parameters_changed) {\n                              # ...\n                             } # state information\n\n $p->set_parameters(@extra_params); # set new NCBI parameters, leaves others preset\n\n $p->reset_parameters(@new_params); # reset NCBI parameters to original state\n\n $p->to_string(); # get a URI-encoded string representation of the URL address\n\n $p->to_request(); # get an HTTP::Request object (to pass on to LWP::UserAgent)\n\n=head1 DESCRIPTION\n\nBio::Tools::EUtilities::EUtilParameters is-a Bio::ParameterBaseI implementation that allows\nsimple manipulation of NCBI eutil parameters for CGI-based queries. SOAP-based\nmethods may be added in the future.\n\nFor simplicity parameters do not require dashes when passed and do not need URI\nencoding (spaces are converted to '+', symbols encoded, etc). Also, the\nfollowing extra parameters can be passed to the new() constructor or via\nset_parameters() or reset_parameters():\n\n  eutil - the eutil to be used. The default is 'efetch' if not set.\n  correspondence - Flag for how IDs are treated. Default is undef (none).\n  history - a Bio::Tools::EUtilities::HistoryI object. Default is undef (none).\n\nAt this point minimal checking is done for potential errors in parameter\npassing, though these should be easily added in the future when necessary.\n\n=head1 TODO\n\nPossibly integrate SOAP-compliant methods. SOAP::Lite may be undergoing an\ncomplete rewrite so I'm hesitant about adding this in immediately.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the \nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::EUtilParameters;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::ParameterBaseI);\nuse URI;\nuse HTTP::Request;\nuse Bio::Root::IO;\n\n# eutils only has one hostbase URL\n\n# mode : GET or POST (HTTP::Request)\n# location : CGI location\n# params : allowed parameters for that eutil\nmy %MODE = (\n    'einfo'     => {\n        'mode'     => 'GET',\n        'location' => 'einfo.fcgi',\n        'params'   => [qw(db tool email)],\n                   },\n    'epost'     => {\n        'mode'     => 'POST',\n        'location' => 'epost.fcgi',\n        'params'   => [qw(db retmode id tool email WebEnv query_key)],\n                   },\n    'efetch'    => {\n        'mode'     => 'GET',\n        'location' => 'efetch.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype strand seq_start\n                       seq_stop complexity report tool email WebEnv query_key)],\n                   },\n    'esearch'   => {\n        'mode'     => 'GET',\n        'location' => 'esearch.fcgi',\n        'params'   => [qw(db retmode usehistory term field reldate mindate\n                       maxdate datetype retmax retstart rettype sort tool email\n                       WebEnv query_key)],\n                   },\n    'esummary'  => {\n        'mode'     => 'GET',\n        'location' => 'esummary.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype tool email\n                       WebEnv query_key)],\n                   },\n    'elink'     => {\n        'mode'     => 'GET',\n        'location' => 'elink.fcgi',\n        'params'   => [qw(db retmode id reldate mindate maxdate datetype term \n                    dbfrom holding cmd version tool email linkname WebEnv\n                    query_key)],\n                   },\n    'egquery'   => {\n        'mode'     => 'GET',\n        'location' => 'egquery.fcgi',\n        'params'   => [qw(term retmode tool email)],\n                   },\n    'espell'    => {\n        'mode'     => 'GET',\n        'location' => 'espell.fcgi',\n        'params'   => [qw(db retmode term tool email )],\n                   }\n);\n\nmy @PARAMS;\n\n# generate getter/setters (will move this into individual ones at some point)\n\nBEGIN {\n    @PARAMS = qw(db id email retmode rettype usehistory term field tool\n    reldate mindate maxdate datetype retstart retmax sort seq_start seq_stop\n    strand complexity report dbfrom cmd holding version linkname WebEnv\n    query_key);\n    for my $method (@PARAMS) {\n        eval <<END;\nsub $method {\n    my (\\$self, \\$val) = \\@_;\n    if (defined \\$val) {\n        if ((!defined \\$self->{'_$method'}) ||\n        (defined \\$self->{'_$method'} && \\$self->{'_$method'} ne \\$val)) {\n            \\$self->{'_statechange'} = 1;\n            \\$self->{'_$method'} = \\$val;\n        }\n    }\n    return \\$self->{'_$method'};\n}\nEND\n    }\n}\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($retmode) = $self->_rearrange([\"RETMODE\"],@args);\n    $self->_set_from_args(\\@args,\n        -methods => [@PARAMS, qw(eutil history correspondence id_file)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->tool() || $self->tool('bioperl');\n    # set default retmode if not explicitly set    \n    $self->set_default_retmode if (!$retmode);\n    $self->{'_statechange'} = 1;\n    return $self;\n}\n\n=head1 Bio::ParameterBaseI implemented methods\n\n=head2 set_parameters\n\n Title   : set_parameters\n Usage   : $pobj->set_parameters(@params);\n Function: sets the NCBI parameters listed in the hash or array\n Returns : None\n Args    : [optional] hash or array of parameter/values.  \n Note    : This sets any parameter passed but leaves previously set data alone.\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub set_parameters {\n    my ($self, @args) = @_;\n    # allow automated resetting; must check to ensure that retmode isn't explicitly passed\n    my ($newmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    # set default retmode if not explicitly passed\n    $self->set_default_retmode unless $newmode;\n    $file && $self->id_file($file);\n    return;\n}\n\n=head2 reset_parameters\n\n Title   : reset_parameters\n Usage   : resets values\n Function: resets parameters to either undef or value in passed hash\n Returns : none\n Args    : [optional] hash of parameter-value pairs\n Note    : This sets any parameter passed, but resets all others (deletes them).\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub reset_parameters {\n    my ($self, @args) = @_;\n    # is there a better way of doing this?  probably, but this works...\n    my ($retmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    map { defined $self->{\"_$_\"} && undef $self->{\"_$_\"} } (@PARAMS, qw(eutil correspondence history_cache request_cache));\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->set_default_retmode unless $retmode;\n    $file && $self->id_file($file);\n    $self->{'_statechange'} = 1;\n}\n\n=head2 parameters_changed\n\n Title   : parameters_changed\n Usage   : if ($pobj->parameters_changed) {...}\n Function: Returns TRUE if parameters have changed\n Returns : Boolean (0 or 1)\n Args    : [optional] Boolean\n\n\nsub parameters_changed {\n    my ($self) = @_;\n    $self->{'_statechange'};\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : @params = $pobj->available_parameters()\n Function: Returns a list of the available parameters\n Returns : Array of available parameters (no values)\n Args    : [optional] A string with the eutil name (for returning eutil-specific\n           parameters)\n\n\nsub available_parameters {\n    my ($self, $type) = @_;\n    $type ||= 'all';\n    if ($type eq 'all') {\n        return @PARAMS;\n    } else {\n        $self->throw(\"$type parameters not supported\") if !exists $MODE{$type};\n        return @{$MODE{$type}->{params}};\n    }\n}\n\n=head2 get_parameters\n\n Title   : get_parameters\n Usage   : @params = $pobj->get_parameters;\n           %params = $pobj->get_parameters;\n Function: Returns list of key/value pairs, parameter => value\n Returns : Flattened list of key-value pairs. All key-value pairs returned,\n           though subsets can be returned based on the '-type' parameter. Data\n           originally set as an array ref are returned based on whether the\n           '-join_id' flag is set (default is the same array ref).\n Args    : -type : the eutil name (Default: returns all).  Use of '-list'\n                    supercedes this\n           -list : array ref of specific parameters\n           -join_ids : Boolean; join IDs based on correspondence (Default: no join)\n\n\nsub get_parameters {\n    my ($self, @args) = @_;\n    my ($type, $list, $join) = $self->_rearrange([qw(TYPE LIST JOIN_IDS)], @args);\n    $self->throw(\"Parameter list not an array ref\") if $list && ref $list ne 'ARRAY';\n    $type ||= '';\n    my @final = $list ? grep {$self->can($_)} @{$list} : $self->available_parameters($type);\n    my @p;\n    for my $param (@final) {\n        if ($param eq 'id' && $self->id && $join) {\n            my $id = $self->id;\n            if ($self->correspondence && $self->eutil eq 'elink') {\n                for my $id_group (@{ $id }) {\n                    if (ref($id_group) eq 'ARRAY') {\n                        push @p, ('id' => join(q(,), @{ $id_group }));\n                    }\n                    elsif (!ref($id_group)) {\n                        push @p, ('id'  => $id_group);\n                    }\n                    else {\n                        $self->throw(\"Unknown ID type: $id_group\");\n                    }\n                }\n            } else {\n                push @p, ref $id eq 'ARRAY' ?\n                ($param => join(',', @{ $id })):\n                ($param => $id);\n            }\n        }\n        elsif ($param eq 'db' && $self->db && $join) {\n            my $db = $self->db;\n            push @p, (ref $db eq 'ARRAY') ? \n                ($param => join(',', @{ $db })) :\n                ($param => $db) ;\n        }\n        else {\n            push @p, ($param => $self->{\"_$param\"}) if defined $self->{\"_$param\"};\n        }\n    }\n    return @p;\n}\n\n=head1 Implementation-specific to_* methods\n\n=head2 to_string\n\n Title   : to_string\n Usage   : $string = $pobj->to_string;\n Function: Returns string (URL only in this case)\n Returns : String (URL only for now)\n Args    : [optional] 'all'; build URI::http using all parameters\n           Default : Builds based on allowed parameters (presence of history data\n           or eutil type in %MODE).\n Note    : Changes state of object.  Absolute string\n\n\nsub to_string {\n    my ($self, @args) = @_;\n    # calling to_uri changes the state\n    if ($self->parameters_changed || !defined $self->{'_string_cache'}) {\n        my $string = $self->to_request(@args)->uri->as_string;\n        $self->{'_statechange'} = 0;\n        $self->{'_string_cache'} = $string;\n    }\n    return $self->{'_string_cache'};\n}\n\n=head2 to_request\n\n Title   : to_request\n Usage   : $uri = $pobj->to_request;\n Function: Returns HTTP::Request object\n Returns : HTTP::Request\n Args    : [optional] 'all'; builds request using all parameters\n           Default : Builds based on allowed parameters (presence of history data\n           or eutil type in %MODE).\n Note    : Changes state of object (to boolean FALSE).  Used for CGI-based GET/POST\n\n\nsub to_request {\n    my ($self, $type) = @_;\n    if ($self->parameters_changed || !defined $self->{'_request_cache'}) {\n        my $eutil = $self->eutil;\n        $self->throw(\"No eutil set\") if !$eutil;\n        #set default retmode\n        $type ||= $eutil;\n        my ($location, $mode) = ($MODE{$eutil}->{location}, $MODE{$eutil}->{mode});\n        my $request;\n        my $uri = URI->new($self->url_base_address . $location);\n        if ($mode eq 'GET') {\n            $uri->query_form($self->get_parameters(-type => $type, -join_ids => 1) );\n            $request = HTTP::Request->new($mode => $uri);\n            $self->{'_request_cache'} = $request;\n        } elsif ($mode eq 'POST') {\n            $request = HTTP::Request->new($mode => $uri->as_string);\n            $uri->query_form($self->get_parameters(-type => $type, -join_ids => 1) );\n            $request->content_type('application/x-www-form-urlencoded');\n            $request->content($uri->query);\n            $self->{'_request_cache'} = $request;\n        } else {\n            $self->throw(\"Unrecognized request mode: $mode\");\n        }\n        $self->{'_statechange'} = 0;\n        $self->{'_request_cache'} = $request;\n    }\n    return $self->{'_request_cache'};\n}\n\n=head1 Implementation specific-methods\n\n=head2 eutil\n\n Title   : eutil\n Usage   : $p->eutil('efetch')\n Function: gets/sets the eutil for this set of parameters\n Returns : string (eutil)\n Args    : [optional] string (eutil)\n Throws  : '$eutil not supported' if eutil not present\n Note    : This does not reset retmode to the default if called directly.\n\n\nsub eutil {\n    my ($self, $eutil) = @_;\n    if ($eutil) {\n        $self->throw(\"$eutil not supported\") if !exists $MODE{$eutil};\n        if (!defined $self->{'_eutil'} || ($self->{'_eutil'} && $self->{'_eutil'} ne $eutil)) {\n            $self->{'_eutil'} = $eutil;\n            $self->{'_statechange'} = 1;\n        }\n    }\n    return $self->{'_eutil'};\n}\n\n=head2 history\n\n Title   : history\n Usage   : $p->history($history);\n Function: gets/sets the history object to be used for these parameters\n Returns : Bio::Tools::EUtilities::HistoryI (if set)\n Args    : [optional] Bio::Tools::EUtilities::HistoryI \n Throws  : Passed something other than a Bio::Tools::EUtilities::HistoryI \n Note    : This overrides WebEnv() and query_key() settings when set.  This\n           caches the last history object passed and returns like a Get/Set\n\n\nsub history {\n    my ($self, $history) = @_;\n    if ($history) {\n        $self->throw('Not a Bio::Tools::EUtilities::HistoryI object!') if\n            !$history->isa('Bio::Tools::EUtilities::HistoryI');\n        my ($webenv, $qkey) = $history->history;\n        $self->WebEnv($webenv);\n        $self->query_key($qkey);\n        $self->{'_statechange'} = 1;\n        $self->{'_history_cache'} = $history;\n    }\n    return $self->{'_history_cache'};\n}\n\n=head2 correspondence\n\n Title   : correspondence\n Usage   : $p->correspondence(1);\n Function: Sets flag for posting IDs for one-to-one correspondence\n Returns : Boolean\n Args    : [optional] boolean value","parameters":[{"label":"$self"},{"label":"$corr"}],"label":"correspondence($self,$corr)"}},{"detail":"($self,$file)","definition":"sub","name":"id_file","containerName":"main::","children":[{"definition":"my","line":534,"name":"$self","localvar":"my","kind":13,"containerName":"id_file"},{"kind":13,"containerName":"id_file","name":"$file","line":534},{"kind":13,"containerName":"id_file","name":"$file","line":535},{"kind":13,"localvar":"my","containerName":"id_file","name":"$io","line":537,"definition":"my"},{"containerName":"id_file","kind":13,"name":"$self","line":537},{"kind":12,"containerName":"id_file","name":"_io","line":537},{"containerName":"id_file","kind":13,"name":"$io","line":538},{"containerName":"id_file","kind":12,"name":"_initialize_io","line":538},{"name":"$file","containerName":"id_file","kind":13,"line":538},{"definition":"my","line":539,"name":"@ids","containerName":"id_file","localvar":"my","kind":13},{"name":"$line","localvar":"my","containerName":"id_file","kind":13,"line":540,"definition":"my"},{"line":540,"name":"$io","containerName":"id_file","kind":13},{"name":"_readline","containerName":"id_file","kind":12,"line":540},{"name":"$line","containerName":"id_file","kind":13,"line":541},{"line":542,"name":"@ids","kind":13,"containerName":"id_file"},{"name":"$line","kind":13,"containerName":"id_file","line":542},{"line":544,"name":"$self","kind":13,"containerName":"id_file"},{"kind":12,"containerName":"id_file","name":"_io","line":544},{"line":544,"name":"close","kind":12,"containerName":"id_file"},{"line":545,"containerName":"id_file","kind":13,"name":"$self"},{"name":"id","kind":12,"containerName":"id_file","line":545},{"kind":13,"containerName":"id_file","name":"@ids","line":545}],"signature":{"label":"id_file($self,$file)","parameters":[{"label":"$self"},{"label":"$file"}],"documentation":"1;\n# $Id: EUtilParameters.pm 15052 2008-12-01 08:47:39Z heikki $\n#\n# BioPerl module for Bio::Tools::EUtilities::EUtilParameters\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::EUtilities::EUtilParameters - Manipulation of NCBI eutil-based parameters for\nremote database requests.\n\n=head1 SYNOPSIS\n\n # Bio::Tools::EUtilities::EUtilParameters implements Bio::ParameterBaseI\n\n my @params = (-eutil => 'efetch',\n              db => 'nucleotide',\n              id => \\@ids,\n              email => 'me@foo.bar',\n              retmode => 'xml');\n\n my $p = Bio::Tools::EUtilities::EUtilParameters->new(@params);\n\n if ($p->parameters_changed) {\n                              # ...\n                             } # state information\n\n $p->set_parameters(@extra_params); # set new NCBI parameters, leaves others preset\n\n $p->reset_parameters(@new_params); # reset NCBI parameters to original state\n\n $p->to_string(); # get a URI-encoded string representation of the URL address\n\n $p->to_request(); # get an HTTP::Request object (to pass on to LWP::UserAgent)\n\n=head1 DESCRIPTION\n\nBio::Tools::EUtilities::EUtilParameters is-a Bio::ParameterBaseI implementation that allows\nsimple manipulation of NCBI eutil parameters for CGI-based queries. SOAP-based\nmethods may be added in the future.\n\nFor simplicity parameters do not require dashes when passed and do not need URI\nencoding (spaces are converted to '+', symbols encoded, etc). Also, the\nfollowing extra parameters can be passed to the new() constructor or via\nset_parameters() or reset_parameters():\n\n  eutil - the eutil to be used. The default is 'efetch' if not set.\n  correspondence - Flag for how IDs are treated. Default is undef (none).\n  history - a Bio::Tools::EUtilities::HistoryI object. Default is undef (none).\n\nAt this point minimal checking is done for potential errors in parameter\npassing, though these should be easily added in the future when necessary.\n\n=head1 TODO\n\nPossibly integrate SOAP-compliant methods. SOAP::Lite may be undergoing an\ncomplete rewrite so I'm hesitant about adding this in immediately.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the \nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::EUtilParameters;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::ParameterBaseI);\nuse URI;\nuse HTTP::Request;\nuse Bio::Root::IO;\n\n# eutils only has one hostbase URL\n\n# mode : GET or POST (HTTP::Request)\n# location : CGI location\n# params : allowed parameters for that eutil\nmy %MODE = (\n    'einfo'     => {\n        'mode'     => 'GET',\n        'location' => 'einfo.fcgi',\n        'params'   => [qw(db tool email)],\n                   },\n    'epost'     => {\n        'mode'     => 'POST',\n        'location' => 'epost.fcgi',\n        'params'   => [qw(db retmode id tool email WebEnv query_key)],\n                   },\n    'efetch'    => {\n        'mode'     => 'GET',\n        'location' => 'efetch.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype strand seq_start\n                       seq_stop complexity report tool email WebEnv query_key)],\n                   },\n    'esearch'   => {\n        'mode'     => 'GET',\n        'location' => 'esearch.fcgi',\n        'params'   => [qw(db retmode usehistory term field reldate mindate\n                       maxdate datetype retmax retstart rettype sort tool email\n                       WebEnv query_key)],\n                   },\n    'esummary'  => {\n        'mode'     => 'GET',\n        'location' => 'esummary.fcgi',\n        'params'   => [qw(db retmode id retmax retstart rettype tool email\n                       WebEnv query_key)],\n                   },\n    'elink'     => {\n        'mode'     => 'GET',\n        'location' => 'elink.fcgi',\n        'params'   => [qw(db retmode id reldate mindate maxdate datetype term \n                    dbfrom holding cmd version tool email linkname WebEnv\n                    query_key)],\n                   },\n    'egquery'   => {\n        'mode'     => 'GET',\n        'location' => 'egquery.fcgi',\n        'params'   => [qw(term retmode tool email)],\n                   },\n    'espell'    => {\n        'mode'     => 'GET',\n        'location' => 'espell.fcgi',\n        'params'   => [qw(db retmode term tool email )],\n                   }\n);\n\nmy @PARAMS;\n\n# generate getter/setters (will move this into individual ones at some point)\n\nBEGIN {\n    @PARAMS = qw(db id email retmode rettype usehistory term field tool\n    reldate mindate maxdate datetype retstart retmax sort seq_start seq_stop\n    strand complexity report dbfrom cmd holding version linkname WebEnv\n    query_key);\n    for my $method (@PARAMS) {\n        eval <<END;\nsub $method {\n    my (\\$self, \\$val) = \\@_;\n    if (defined \\$val) {\n        if ((!defined \\$self->{'_$method'}) ||\n        (defined \\$self->{'_$method'} && \\$self->{'_$method'} ne \\$val)) {\n            \\$self->{'_statechange'} = 1;\n            \\$self->{'_$method'} = \\$val;\n        }\n    }\n    return \\$self->{'_$method'};\n}\nEND\n    }\n}\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($retmode) = $self->_rearrange([\"RETMODE\"],@args);\n    $self->_set_from_args(\\@args,\n        -methods => [@PARAMS, qw(eutil history correspondence id_file)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->tool() || $self->tool('bioperl');\n    # set default retmode if not explicitly set    \n    $self->set_default_retmode if (!$retmode);\n    $self->{'_statechange'} = 1;\n    return $self;\n}\n\n=head1 Bio::ParameterBaseI implemented methods\n\n=head2 set_parameters\n\n Title   : set_parameters\n Usage   : $pobj->set_parameters(@params);\n Function: sets the NCBI parameters listed in the hash or array\n Returns : None\n Args    : [optional] hash or array of parameter/values.  \n Note    : This sets any parameter passed but leaves previously set data alone.\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub set_parameters {\n    my ($self, @args) = @_;\n    # allow automated resetting; must check to ensure that retmode isn't explicitly passed\n    my ($newmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    # set default retmode if not explicitly passed\n    $self->set_default_retmode unless $newmode;\n    $file && $self->id_file($file);\n    return;\n}\n\n=head2 reset_parameters\n\n Title   : reset_parameters\n Usage   : resets values\n Function: resets parameters to either undef or value in passed hash\n Returns : none\n Args    : [optional] hash of parameter-value pairs\n Note    : This sets any parameter passed, but resets all others (deletes them).\n           In addition to regular eutil-specific parameters, you can set the\n           following:\n\n           -eutil    - the eUtil to be used (default 'efetch')\n           -history  - pass a HistoryI-implementing object, which\n                       sets the WebEnv, query_key, and possibly db and linkname\n                       (the latter two only for LinkSets)\n           -correspondence - Boolean flag, set to TRUE or FALSE; indicates how\n                       IDs are to be added together for elink request where\n                       ID correspondence might be needed\n                       (default 0)\n\n\nsub reset_parameters {\n    my ($self, @args) = @_;\n    # is there a better way of doing this?  probably, but this works...\n    my ($retmode,$file) = $self->_rearrange([qw(RETMODE ID_FILE)],@args);\n    map { defined $self->{\"_$_\"} && undef $self->{\"_$_\"} } (@PARAMS, qw(eutil correspondence history_cache request_cache));\n    $self->_set_from_args(\\@args, -methods => [@PARAMS, qw(eutil correspondence history)]);\n    $self->eutil() || $self->eutil('efetch');\n    $self->set_default_retmode unless $retmode;\n    $file && $self->id_file($file);\n    $self->{'_statechange'} = 1;\n}\n\n=head2 parameters_changed\n\n Title   : parameters_changed\n Usage   : if ($pobj->parameters_changed) {...}\n Function: Returns TRUE if parameters have changed\n Returns : Boolean (0 or 1)\n Args    : [optional] Boolean\n\n\nsub parameters_changed {\n    my ($self) = @_;\n    $self->{'_statechange'};\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : @params = $pobj->available_parameters()\n Function: Returns a list of the available parameters\n Returns : Array of available parameters (no values)\n Args    : [optional] A string with the eutil name (for returning eutil-specific\n           parameters)\n\n\nsub available_parameters {\n    my ($self, $type) = @_;\n    $type ||= 'all';\n    if ($type eq 'all') {\n        return @PARAMS;\n    } else {\n        $self->throw(\"$type parameters not supported\") if !exists $MODE{$type};\n        return @{$MODE{$type}->{params}};\n    }\n}\n\n=head2 get_parameters\n\n Title   : get_parameters\n Usage   : @params = $pobj->get_parameters;\n           %params = $pobj->get_parameters;\n Function: Returns list of key/value pairs, parameter => value\n Returns : Flattened list of key-value pairs. All key-value pairs returned,\n           though subsets can be returned based on the '-type' parameter. Data\n           originally set as an array ref are returned based on whether the\n           '-join_id' flag is set (default is the same array ref).\n Args    : -type : the eutil name (Default: returns all).  Use of '-list'\n                    supercedes this\n           -list : array ref of specific parameters\n           -join_ids : Boolean; join IDs based on correspondence (Default: no join)\n\n\nsub get_parameters {\n    my ($self, @args) = @_;\n    my ($type, $list, $join) = $self->_rearrange([qw(TYPE LIST JOIN_IDS)], @args);\n    $self->throw(\"Parameter list not an array ref\") if $list && ref $list ne 'ARRAY';\n    $type ||= '';\n    my @final = $list ? grep {$self->can($_)} @{$list} : $self->available_parameters($type);\n    my @p;\n    for my $param (@final) {\n        if ($param eq 'id' && $self->id && $join) {\n            my $id = $self->id;\n            if ($self->correspondence && $self->eutil eq 'elink') {\n                for my $id_group (@{ $id }) {\n                    if (ref($id_group) eq 'ARRAY') {\n                        push @p, ('id' => join(q(,), @{ $id_group }));\n                    }\n                    elsif (!ref($id_group)) {\n                        push @p, ('id'  => $id_group);\n                    }\n                    else {\n                        $self->throw(\"Unknown ID type: $id_group\");\n                    }\n                }\n            } else {\n                push @p, ref $id eq 'ARRAY' ?\n                ($param => join(',', @{ $id })):\n                ($param => $id);\n            }\n        }\n        elsif ($param eq 'db' && $self->db && $join) {\n            my $db = $self->db;\n            push @p, (ref $db eq 'ARRAY') ? \n                ($param => join(',', @{ $db })) :\n                ($param => $db) ;\n        }\n        else {\n            push @p, ($param => $self->{\"_$param\"}) if defined $self->{\"_$param\"};\n        }\n    }\n    return @p;\n}\n\n=head1 Implementation-specific to_* methods\n\n=head2 to_string\n\n Title   : to_string\n Usage   : $string = $pobj->to_string;\n Function: Returns string (URL only in this case)\n Returns : String (URL only for now)\n Args    : [optional] 'all'; build URI::http using all parameters\n           Default : Builds based on allowed parameters (presence of history data\n           or eutil type in %MODE).\n Note    : Changes state of object.  Absolute string\n\n\nsub to_string {\n    my ($self, @args) = @_;\n    # calling to_uri changes the state\n    if ($self->parameters_changed || !defined $self->{'_string_cache'}) {\n        my $string = $self->to_request(@args)->uri->as_string;\n        $self->{'_statechange'} = 0;\n        $self->{'_string_cache'} = $string;\n    }\n    return $self->{'_string_cache'};\n}\n\n=head2 to_request\n\n Title   : to_request\n Usage   : $uri = $pobj->to_request;\n Function: Returns HTTP::Request object\n Returns : HTTP::Request\n Args    : [optional] 'all'; builds request using all parameters\n           Default : Builds based on allowed parameters (presence of history data\n           or eutil type in %MODE).\n Note    : Changes state of object (to boolean FALSE).  Used for CGI-based GET/POST\n\n\nsub to_request {\n    my ($self, $type) = @_;\n    if ($self->parameters_changed || !defined $self->{'_request_cache'}) {\n        my $eutil = $self->eutil;\n        $self->throw(\"No eutil set\") if !$eutil;\n        #set default retmode\n        $type ||= $eutil;\n        my ($location, $mode) = ($MODE{$eutil}->{location}, $MODE{$eutil}->{mode});\n        my $request;\n        my $uri = URI->new($self->url_base_address . $location);\n        if ($mode eq 'GET') {\n            $uri->query_form($self->get_parameters(-type => $type, -join_ids => 1) );\n            $request = HTTP::Request->new($mode => $uri);\n            $self->{'_request_cache'} = $request;\n        } elsif ($mode eq 'POST') {\n            $request = HTTP::Request->new($mode => $uri->as_string);\n            $uri->query_form($self->get_parameters(-type => $type, -join_ids => 1) );\n            $request->content_type('application/x-www-form-urlencoded');\n            $request->content($uri->query);\n            $self->{'_request_cache'} = $request;\n        } else {\n            $self->throw(\"Unrecognized request mode: $mode\");\n        }\n        $self->{'_statechange'} = 0;\n        $self->{'_request_cache'} = $request;\n    }\n    return $self->{'_request_cache'};\n}\n\n=head1 Implementation specific-methods\n\n=head2 eutil\n\n Title   : eutil\n Usage   : $p->eutil('efetch')\n Function: gets/sets the eutil for this set of parameters\n Returns : string (eutil)\n Args    : [optional] string (eutil)\n Throws  : '$eutil not supported' if eutil not present\n Note    : This does not reset retmode to the default if called directly.\n\n\nsub eutil {\n    my ($self, $eutil) = @_;\n    if ($eutil) {\n        $self->throw(\"$eutil not supported\") if !exists $MODE{$eutil};\n        if (!defined $self->{'_eutil'} || ($self->{'_eutil'} && $self->{'_eutil'} ne $eutil)) {\n            $self->{'_eutil'} = $eutil;\n            $self->{'_statechange'} = 1;\n        }\n    }\n    return $self->{'_eutil'};\n}\n\n=head2 history\n\n Title   : history\n Usage   : $p->history($history);\n Function: gets/sets the history object to be used for these parameters\n Returns : Bio::Tools::EUtilities::HistoryI (if set)\n Args    : [optional] Bio::Tools::EUtilities::HistoryI \n Throws  : Passed something other than a Bio::Tools::EUtilities::HistoryI \n Note    : This overrides WebEnv() and query_key() settings when set.  This\n           caches the last history object passed and returns like a Get/Set\n\n\nsub history {\n    my ($self, $history) = @_;\n    if ($history) {\n        $self->throw('Not a Bio::Tools::EUtilities::HistoryI object!') if\n            !$history->isa('Bio::Tools::EUtilities::HistoryI');\n        my ($webenv, $qkey) = $history->history;\n        $self->WebEnv($webenv);\n        $self->query_key($qkey);\n        $self->{'_statechange'} = 1;\n        $self->{'_history_cache'} = $history;\n    }\n    return $self->{'_history_cache'};\n}\n\n=head2 correspondence\n\n Title   : correspondence\n Usage   : $p->correspondence(1);\n Function: Sets flag for posting IDs for one-to-one correspondence\n Returns : Boolean\n Args    : [optional] boolean value\n\n\nsub correspondence {\n    my ($self, $corr) = @_;\n    if (defined $corr) {\n        $self->{'_correspondence'} = $corr;\n        $self->{'_statechange'} = 1;\n    }\n    return $self->{'_correspondence'};\n}\n\n=head2 id_file\n\n Title   : id_file\n Usage   : $p->id_file('<foo');\n Function: convenience method; passes in file containing a list of IDs for\n           searches (one per line), sets id() to list\n Returns : none\n Args    : either string indicating file to use, a file handle, or an IO::Handle\n           object\n Note    : use of this overrides concurrent use of the '-id' parameter when both\n           are passed.  The filename is not retained, merely parsed for IDs."},"range":{"end":{"line":547,"character":9999},"start":{"line":533,"character":0}},"kind":12,"line":533},{"definition":"my","line":560,"name":"$HOSTBASE","containerName":null,"localvar":"my","kind":13},{"containerName":"main::","name":"url_base_address","children":[{"definition":"my","name":"$self","containerName":"url_base_address","localvar":"my","kind":13,"line":563},{"containerName":"url_base_address","kind":13,"name":"$address","line":563},{"line":564,"name":"$HOSTBASE","containerName":"url_base_address","kind":13}],"detail":"($self,$address)","definition":"sub","range":{"end":{"line":565,"character":9999},"start":{"line":562,"character":0}},"kind":12,"line":562,"signature":{"label":"url_base_address($self,$address)","parameters":[{"label":"$self"},{"label":"$address"}],"documentation":""}},{"definition":"my","line":581,"kind":13,"localvar":"my","containerName":null,"name":"%NCBI_DATABASE"},{"line":593,"range":{"start":{"line":593,"character":0},"end":{"line":602,"character":9999}},"kind":12,"children":[{"definition":"my","line":594,"containerName":"set_default_retmode","localvar":"my","kind":13,"name":"$self"},{"name":"$self","containerName":"set_default_retmode","kind":13,"line":595},{"kind":12,"containerName":"set_default_retmode","name":"eutil","line":595},{"definition":"my","line":596,"name":"$db","containerName":"set_default_retmode","localvar":"my","kind":13},{"kind":13,"containerName":"set_default_retmode","name":"$self","line":596},{"line":596,"kind":12,"containerName":"set_default_retmode","name":"db"},{"definition":"my","line":597,"name":"$mode","localvar":"my","containerName":"set_default_retmode","kind":13},{"line":597,"name":"$NCBI_DATABASE","containerName":"set_default_retmode","kind":13},{"name":"$db","containerName":"set_default_retmode","kind":13,"line":597},{"name":"$NCBI_DATABASE","kind":13,"containerName":"set_default_retmode","line":597},{"containerName":"set_default_retmode","kind":13,"name":"$db","line":597},{"line":598,"name":"$self","kind":13,"containerName":"set_default_retmode"},{"name":"retmode","kind":12,"containerName":"set_default_retmode","line":598},{"line":598,"name":"$mode","kind":13,"containerName":"set_default_retmode"},{"kind":13,"containerName":"set_default_retmode","name":"$self","line":600},{"line":600,"kind":12,"containerName":"set_default_retmode","name":"retmode"}],"name":"set_default_retmode","containerName":"main::","definition":"sub"},{"line":605,"range":{"start":{"line":605,"character":0},"end":{"line":611,"character":9999}},"kind":12,"definition":"sub","children":[{"line":606,"name":"$self","kind":13,"localvar":"my","containerName":"_io","definition":"my"},{"name":"$self","kind":13,"containerName":"_io","line":607},{"name":"$self","kind":13,"containerName":"_io","line":608},{"name":"new","containerName":"_io","kind":12,"line":608},{"line":610,"name":"$self","containerName":"_io","kind":13}],"containerName":"main::","name":"_io"},{"line":608,"containerName":"Root::IO","kind":12,"name":"Bio"}]}