{"vars":[{"line":153,"name":"Common","kind":2,"containerName":"strict::Bio::Tools::Analysis::Protein::Sopma::IO::String::Bio::SeqIO::HTTP::Request"},{"name":"base","kind":2,"containerName":"","line":158},{"line":161,"name":"$URL","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"line":162,"name":"$ANALYSIS_NAME","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"definition":"my","name":"%ANALYSIS_SPEC","localvar":"my","containerName":null,"kind":13,"line":163},{"kind":12,"name":"name","line":163},{"kind":12,"name":"type","line":163},{"name":"@INPUT_SPEC","kind":13,"localvar":"my","containerName":null,"line":164,"definition":"my"},{"name":"mandatory","kind":12,"line":165},{"name":"type","kind":12,"line":166},{"line":169,"kind":12,"name":"mandatory"},{"kind":12,"name":"type","line":170},{"line":171,"name":"name","kind":12},{"name":"default","kind":12,"line":172},{"line":174,"kind":12,"name":"mandatory"},{"line":175,"name":"type","kind":12},{"name":"name","kind":12,"line":176},{"line":177,"name":"default","kind":12},{"line":179,"kind":12,"name":"mandatory"},{"name":"type","kind":12,"line":180},{"line":181,"kind":12,"name":"name"},{"line":182,"kind":12,"name":"default"},{"localvar":"my","containerName":null,"kind":13,"name":"%RESULT_SPEC","line":185,"definition":"my"},{"name":"raw","kind":12,"line":188},{"name":"meta","kind":12,"line":189},{"name":"MIN_STRUC_LEN","containerName":"main::","kind":14,"line":192,"definition":1},{"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","line":207,"containerName":"similarity_threshold","localvar":"my","kind":13,"name":"$self"},{"containerName":"similarity_threshold","kind":13,"name":"$value","line":207},{"line":208,"name":"$value","containerName":"similarity_threshold","kind":13},{"kind":13,"containerName":"similarity_threshold","name":"$self","line":209},{"name":"throw","containerName":"similarity_threshold","kind":12,"line":209},{"line":210,"kind":13,"containerName":"similarity_threshold","name":"$value"},{"name":"$self","kind":13,"containerName":"similarity_threshold","line":211},{"line":211,"containerName":"similarity_threshold","kind":13,"name":"$value"},{"name":"$self","containerName":"similarity_threshold","kind":13,"line":213},{"line":213,"containerName":"similarity_threshold","kind":13,"name":"$self"},{"kind":12,"containerName":"similarity_threshold","name":"input_spec","line":213},{"line":214,"containerName":"similarity_threshold","kind":13,"name":"$self"}],"name":"similarity_threshold","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Sopma.pm,v 1.0 2003/07/ 11\n#\n# BioPerl module for Bio::Tools::Analysis::Protein::Sopma\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n\n=head1 NAME\n\nBio::Tools::Analysis::Protein::Sopma - a wrapper around the\nSopma protein secondary structure prediction server\n\n=head1  SYNOPSIS\n\n  use Bio::Tools::Analysis::Protein::Sopma;\n  #get a Bio::Seq or Bio::PrimarySeq\n  my $seq;\n\n  my $sopma = Bio::Tools::Analysis::Protein::Sopma->new\n      (-seq=>$seq, states=>4);\n  $sopma->run;\n  print $sopma->result;# #raw text to standard error\n\n=head1  DESCRIPTION\n\nA module to remotely retrieve predictions of protein secondary\nstructure.  Each residue in the protein receives a score representing\nthe likelihood of existing in each of four different states (helix,\ncoil, turn or sheet), e.g.,\n\n  my $analysis_object = Bio::Tools::SimpleAnalysis::Protein::Sopma->new\n      ( -seq          => $seq,\n        -states       => 4,\n        -window_width => 15,\n      );\n\ncreates a new object.  Compulsory argument -seq.  Optional arguments\n-states, -window_width,-similarity_threshold. These arguments can also be\nset by direct methods , e.g.,\n\n  $analysis_object->states(4);\n  $analysis_object->run;\n\nsubmits the query to the server and obtains raw text output. Given an\namino acid sequence the results can be obtained in 4 formats,\ndetermined by the argument to the result method:\n\n=over 4\n\n* 1\n\nThe raw text of the program output.\n\n  my $rawdata = $analysis_object->result;\n\n* 2\n\nA reference to an array of hashes of scores for each state and the\nassigned state.\n\n  my $data_ref = $analysis_object->result('parsed');\n  print \"score for helix at residue 2 is $data_ref->[1]{'helix'}\\n\";\n  print \"predicted struc  at residue 2 is $data_ref->[1]{'struc}\\n\";\n\nHash keys are 'helix', 'struc', 'sheet', 'coil', 'turn'.\n\n* 3\n\nAn array of Bio::SeqFeature::Generic objects where each feature is a\npredicted unit of secondary structure. Only stretches of helix/sheet\npredictions for longer than 4 residues are defined as helices/sheets.\n\n  my @fts = $analysis_object->result(Bio::SeqFeatureI);\n  for my $ft (@fts) {\n      print \" From \",  $ft->start, \" to  \",$ft->end, \" struc: \" ,\n             ($ft->each_tag_value('type'))[0]  ,\"\\n\";\n  }\n\n* 4\n\nA Bio::Seq::Meta::Array implementing sequence.\n\nThis is a Bio::Seq object that can also hold data about each residue\nin the sequence.  In this case, the sequence can be associated with a\narrays of Sopma prediction scores.  e.g.,\n\n  my $meta_sequence = $analysis_object->result('meta');\n  print \"scores from residues 10 -20 are \",\n      $meta_sequence->named_submeta_text(\"Sopma_helix\",10,20), \"\\n\";\n\nMeta sequence names are : Sopma_helix, Sopma_sheet, Sopma_turn,\nSopma_coil, Sopma_struc, representing the scores for each residue.\n\nMany methods common to all analyses are inherited from\nBio::Tools::Analysis::SimpleAnalysisBase.\n\n\n=head1 SEE ALSO\n\nL<Bio::SimpleAnalysisI>, \nL<Bio::Tools::Analysis::SimpleAnalysisBase>\nL<Bio::Seq::Meta::Array>, \nL<Bio::WebAgent>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk, \n\n=head1 APPENDIX\n\n\nuse strict;\n\npackage Bio::Tools::Analysis::Protein::Sopma;\n\nuse IO::String;\nuse Bio::SeqIO;\nuse HTTP::Request::Common qw (POST);\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq::Meta::Array;\n\n\nuse base qw(Bio::Tools::Analysis::SimpleAnalysisBase);\n\n#extends array for 2struc.\nmy $URL = 'http://npsa-pbil.ibcp.fr/cgi-bin/secpred_sopma.pl';\nmy $ANALYSIS_NAME= 'Sopma';\nmy $ANALYSIS_SPEC= {name => 'Sopma', type => 'Protein'};\nmy $INPUT_SPEC = [\n                  {mandatory=>'true',\n                   type     => 'Bio::PrimarySeqI',\n                   'name'   => 'seq',\n                  },\n                  {mandatory =>'false',\n                   type      => 'integer',\n                   name      => 'similarity_threshold',\n                   default   => 8,\n                  },\n                  {mandatory  =>'false',\n                   type       => 'integer',\n                   name       => 'window_width',\n                   default    => 17,\n                  },\n                  {mandatory  =>'false',\n                   type       => 'integer',\n                   name       => 'states',\n                   default    => 4,\n                  },\n                 ];\nmy  $RESULT_SPEC =\n    {\n     ''   => 'bulk',              # same as undef\n     raw  => '[{struc=>, helix=>, turn=>, coil=>, sheet=>}]',\n     meta => 'Bio::Seq::Meta::Array object',\n     'Bio::SeqFeatureI' => 'ARRAY of Bio::SeqFeature::Generic',\n    };\nuse constant MIN_STRUC_LEN => 3; \n\n\n=head2  similarity_threshold\n\n  Useage  : $job->similarity_threshold(...)\n  Returns : The  similarity threshold used in the analysis\n  Args    : None (retrieves value) or  an integer (default = 8) \n            that sets the similarity threshold .\n\nThis method gets/sets the  similarity threshold for the prediction.","label":"similarity_threshold($self,$value)"},"line":206,"kind":12,"range":{"start":{"line":206,"character":0},"end":{"line":215,"character":9999}}},{"signature":{"label":"window_width($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Sopma.pm,v 1.0 2003/07/ 11\n#\n# BioPerl module for Bio::Tools::Analysis::Protein::Sopma\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n\n=head1 NAME\n\nBio::Tools::Analysis::Protein::Sopma - a wrapper around the\nSopma protein secondary structure prediction server\n\n=head1  SYNOPSIS\n\n  use Bio::Tools::Analysis::Protein::Sopma;\n  #get a Bio::Seq or Bio::PrimarySeq\n  my $seq;\n\n  my $sopma = Bio::Tools::Analysis::Protein::Sopma->new\n      (-seq=>$seq, states=>4);\n  $sopma->run;\n  print $sopma->result;# #raw text to standard error\n\n=head1  DESCRIPTION\n\nA module to remotely retrieve predictions of protein secondary\nstructure.  Each residue in the protein receives a score representing\nthe likelihood of existing in each of four different states (helix,\ncoil, turn or sheet), e.g.,\n\n  my $analysis_object = Bio::Tools::SimpleAnalysis::Protein::Sopma->new\n      ( -seq          => $seq,\n        -states       => 4,\n        -window_width => 15,\n      );\n\ncreates a new object.  Compulsory argument -seq.  Optional arguments\n-states, -window_width,-similarity_threshold. These arguments can also be\nset by direct methods , e.g.,\n\n  $analysis_object->states(4);\n  $analysis_object->run;\n\nsubmits the query to the server and obtains raw text output. Given an\namino acid sequence the results can be obtained in 4 formats,\ndetermined by the argument to the result method:\n\n=over 4\n\n* 1\n\nThe raw text of the program output.\n\n  my $rawdata = $analysis_object->result;\n\n* 2\n\nA reference to an array of hashes of scores for each state and the\nassigned state.\n\n  my $data_ref = $analysis_object->result('parsed');\n  print \"score for helix at residue 2 is $data_ref->[1]{'helix'}\\n\";\n  print \"predicted struc  at residue 2 is $data_ref->[1]{'struc}\\n\";\n\nHash keys are 'helix', 'struc', 'sheet', 'coil', 'turn'.\n\n* 3\n\nAn array of Bio::SeqFeature::Generic objects where each feature is a\npredicted unit of secondary structure. Only stretches of helix/sheet\npredictions for longer than 4 residues are defined as helices/sheets.\n\n  my @fts = $analysis_object->result(Bio::SeqFeatureI);\n  for my $ft (@fts) {\n      print \" From \",  $ft->start, \" to  \",$ft->end, \" struc: \" ,\n             ($ft->each_tag_value('type'))[0]  ,\"\\n\";\n  }\n\n* 4\n\nA Bio::Seq::Meta::Array implementing sequence.\n\nThis is a Bio::Seq object that can also hold data about each residue\nin the sequence.  In this case, the sequence can be associated with a\narrays of Sopma prediction scores.  e.g.,\n\n  my $meta_sequence = $analysis_object->result('meta');\n  print \"scores from residues 10 -20 are \",\n      $meta_sequence->named_submeta_text(\"Sopma_helix\",10,20), \"\\n\";\n\nMeta sequence names are : Sopma_helix, Sopma_sheet, Sopma_turn,\nSopma_coil, Sopma_struc, representing the scores for each residue.\n\nMany methods common to all analyses are inherited from\nBio::Tools::Analysis::SimpleAnalysisBase.\n\n\n=head1 SEE ALSO\n\nL<Bio::SimpleAnalysisI>, \nL<Bio::Tools::Analysis::SimpleAnalysisBase>\nL<Bio::Seq::Meta::Array>, \nL<Bio::WebAgent>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk, \n\n=head1 APPENDIX\n\n\nuse strict;\n\npackage Bio::Tools::Analysis::Protein::Sopma;\n\nuse IO::String;\nuse Bio::SeqIO;\nuse HTTP::Request::Common qw (POST);\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq::Meta::Array;\n\n\nuse base qw(Bio::Tools::Analysis::SimpleAnalysisBase);\n\n#extends array for 2struc.\nmy $URL = 'http://npsa-pbil.ibcp.fr/cgi-bin/secpred_sopma.pl';\nmy $ANALYSIS_NAME= 'Sopma';\nmy $ANALYSIS_SPEC= {name => 'Sopma', type => 'Protein'};\nmy $INPUT_SPEC = [\n                  {mandatory=>'true',\n                   type     => 'Bio::PrimarySeqI',\n                   'name'   => 'seq',\n                  },\n                  {mandatory =>'false',\n                   type      => 'integer',\n                   name      => 'similarity_threshold',\n                   default   => 8,\n                  },\n                  {mandatory  =>'false',\n                   type       => 'integer',\n                   name       => 'window_width',\n                   default    => 17,\n                  },\n                  {mandatory  =>'false',\n                   type       => 'integer',\n                   name       => 'states',\n                   default    => 4,\n                  },\n                 ];\nmy  $RESULT_SPEC =\n    {\n     ''   => 'bulk',              # same as undef\n     raw  => '[{struc=>, helix=>, turn=>, coil=>, sheet=>}]',\n     meta => 'Bio::Seq::Meta::Array object',\n     'Bio::SeqFeatureI' => 'ARRAY of Bio::SeqFeature::Generic',\n    };\nuse constant MIN_STRUC_LEN => 3; \n\n\n=head2  similarity_threshold\n\n  Useage  : $job->similarity_threshold(...)\n  Returns : The  similarity threshold used in the analysis\n  Args    : None (retrieves value) or  an integer (default = 8) \n            that sets the similarity threshold .\n\nThis method gets/sets the  similarity threshold for the prediction.\n\n\nsub similarity_threshold {\n    my ($self, $value) = @_;\n    if ($value) {\n        $self->throw (\"similarity_threshold must be integer\")\n            unless $value =~ /^\\d+$/;\n        $self->{'_similarity_threshold'} = $value;\n    }\n    $self->{'_similarity_threshold'} ||= $self->input_spec->[1]{'default'};\n    return $self->{'_similarity_threshold'};\n}\n\n=head2  window_width\n\n  Usage    : $job->window_width(...)\n  Returns  : The window width used in the analysis\n  Args     : None (retrieves value) or  an integer (default = 17)\n             that sets the window width.\n\nThis method gets/sets the window width for the prediction, .  If\nattempted to set longer than the sequence, warns of error."},"range":{"end":{"character":9999,"line":240},"start":{"character":0,"line":229}},"kind":12,"line":229,"detail":"($self,$value)","definition":"sub","name":"window_width","containerName":"main::","children":[{"name":"$self","containerName":"window_width","localvar":"my","kind":13,"line":230,"definition":"my"},{"name":"$value","kind":13,"containerName":"window_width","line":230},{"name":"$value","containerName":"window_width","kind":13,"line":231},{"name":"$self","kind":13,"containerName":"window_width","line":232},{"line":232,"name":"throw","kind":12,"containerName":"window_width"},{"name":"$value","containerName":"window_width","kind":13,"line":233},{"line":234,"containerName":"window_width","kind":13,"name":"$self"},{"line":234,"containerName":"window_width","kind":13,"name":"$value"},{"line":236,"kind":13,"containerName":"window_width","name":"$self"},{"line":236,"containerName":"window_width","kind":13,"name":"$self"},{"line":236,"kind":12,"containerName":"window_width","name":"input_spec"},{"line":237,"kind":13,"containerName":"window_width","name":"$self"},{"name":"warn","containerName":"window_width","kind":12,"line":237},{"line":238,"name":"$self","kind":13,"containerName":"window_width"},{"line":238,"containerName":"window_width","kind":13,"name":"$self"},{"line":238,"containerName":"window_width","kind":12,"name":"seq"},{"name":"length","kind":12,"containerName":"window_width","line":238},{"line":239,"kind":13,"containerName":"window_width","name":"$self"}]},{"kind":12,"range":{"end":{"character":9999,"line":263},"start":{"character":0,"line":254}},"line":254,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Sopma.pm,v 1.0 2003/07/ 11\n#\n# BioPerl module for Bio::Tools::Analysis::Protein::Sopma\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n\n=head1 NAME\n\nBio::Tools::Analysis::Protein::Sopma - a wrapper around the\nSopma protein secondary structure prediction server\n\n=head1  SYNOPSIS\n\n  use Bio::Tools::Analysis::Protein::Sopma;\n  #get a Bio::Seq or Bio::PrimarySeq\n  my $seq;\n\n  my $sopma = Bio::Tools::Analysis::Protein::Sopma->new\n      (-seq=>$seq, states=>4);\n  $sopma->run;\n  print $sopma->result;# #raw text to standard error\n\n=head1  DESCRIPTION\n\nA module to remotely retrieve predictions of protein secondary\nstructure.  Each residue in the protein receives a score representing\nthe likelihood of existing in each of four different states (helix,\ncoil, turn or sheet), e.g.,\n\n  my $analysis_object = Bio::Tools::SimpleAnalysis::Protein::Sopma->new\n      ( -seq          => $seq,\n        -states       => 4,\n        -window_width => 15,\n      );\n\ncreates a new object.  Compulsory argument -seq.  Optional arguments\n-states, -window_width,-similarity_threshold. These arguments can also be\nset by direct methods , e.g.,\n\n  $analysis_object->states(4);\n  $analysis_object->run;\n\nsubmits the query to the server and obtains raw text output. Given an\namino acid sequence the results can be obtained in 4 formats,\ndetermined by the argument to the result method:\n\n=over 4\n\n* 1\n\nThe raw text of the program output.\n\n  my $rawdata = $analysis_object->result;\n\n* 2\n\nA reference to an array of hashes of scores for each state and the\nassigned state.\n\n  my $data_ref = $analysis_object->result('parsed');\n  print \"score for helix at residue 2 is $data_ref->[1]{'helix'}\\n\";\n  print \"predicted struc  at residue 2 is $data_ref->[1]{'struc}\\n\";\n\nHash keys are 'helix', 'struc', 'sheet', 'coil', 'turn'.\n\n* 3\n\nAn array of Bio::SeqFeature::Generic objects where each feature is a\npredicted unit of secondary structure. Only stretches of helix/sheet\npredictions for longer than 4 residues are defined as helices/sheets.\n\n  my @fts = $analysis_object->result(Bio::SeqFeatureI);\n  for my $ft (@fts) {\n      print \" From \",  $ft->start, \" to  \",$ft->end, \" struc: \" ,\n             ($ft->each_tag_value('type'))[0]  ,\"\\n\";\n  }\n\n* 4\n\nA Bio::Seq::Meta::Array implementing sequence.\n\nThis is a Bio::Seq object that can also hold data about each residue\nin the sequence.  In this case, the sequence can be associated with a\narrays of Sopma prediction scores.  e.g.,\n\n  my $meta_sequence = $analysis_object->result('meta');\n  print \"scores from residues 10 -20 are \",\n      $meta_sequence->named_submeta_text(\"Sopma_helix\",10,20), \"\\n\";\n\nMeta sequence names are : Sopma_helix, Sopma_sheet, Sopma_turn,\nSopma_coil, Sopma_struc, representing the scores for each residue.\n\nMany methods common to all analyses are inherited from\nBio::Tools::Analysis::SimpleAnalysisBase.\n\n\n=head1 SEE ALSO\n\nL<Bio::SimpleAnalysisI>, \nL<Bio::Tools::Analysis::SimpleAnalysisBase>\nL<Bio::Seq::Meta::Array>, \nL<Bio::WebAgent>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk, \n\n=head1 APPENDIX\n\n\nuse strict;\n\npackage Bio::Tools::Analysis::Protein::Sopma;\n\nuse IO::String;\nuse Bio::SeqIO;\nuse HTTP::Request::Common qw (POST);\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq::Meta::Array;\n\n\nuse base qw(Bio::Tools::Analysis::SimpleAnalysisBase);\n\n#extends array for 2struc.\nmy $URL = 'http://npsa-pbil.ibcp.fr/cgi-bin/secpred_sopma.pl';\nmy $ANALYSIS_NAME= 'Sopma';\nmy $ANALYSIS_SPEC= {name => 'Sopma', type => 'Protein'};\nmy $INPUT_SPEC = [\n                  {mandatory=>'true',\n                   type     => 'Bio::PrimarySeqI',\n                   'name'   => 'seq',\n                  },\n                  {mandatory =>'false',\n                   type      => 'integer',\n                   name      => 'similarity_threshold',\n                   default   => 8,\n                  },\n                  {mandatory  =>'false',\n                   type       => 'integer',\n                   name       => 'window_width',\n                   default    => 17,\n                  },\n                  {mandatory  =>'false',\n                   type       => 'integer',\n                   name       => 'states',\n                   default    => 4,\n                  },\n                 ];\nmy  $RESULT_SPEC =\n    {\n     ''   => 'bulk',              # same as undef\n     raw  => '[{struc=>, helix=>, turn=>, coil=>, sheet=>}]',\n     meta => 'Bio::Seq::Meta::Array object',\n     'Bio::SeqFeatureI' => 'ARRAY of Bio::SeqFeature::Generic',\n    };\nuse constant MIN_STRUC_LEN => 3; \n\n\n=head2  similarity_threshold\n\n  Useage  : $job->similarity_threshold(...)\n  Returns : The  similarity threshold used in the analysis\n  Args    : None (retrieves value) or  an integer (default = 8) \n            that sets the similarity threshold .\n\nThis method gets/sets the  similarity threshold for the prediction.\n\n\nsub similarity_threshold {\n    my ($self, $value) = @_;\n    if ($value) {\n        $self->throw (\"similarity_threshold must be integer\")\n            unless $value =~ /^\\d+$/;\n        $self->{'_similarity_threshold'} = $value;\n    }\n    $self->{'_similarity_threshold'} ||= $self->input_spec->[1]{'default'};\n    return $self->{'_similarity_threshold'};\n}\n\n=head2  window_width\n\n  Usage    : $job->window_width(...)\n  Returns  : The window width used in the analysis\n  Args     : None (retrieves value) or  an integer (default = 17)\n             that sets the window width.\n\nThis method gets/sets the window width for the prediction, .  If\nattempted to set longer than the sequence, warns of error.\n\n\nsub window_width {\n    my ($self, $value) = @_;\n    if ($value) {\n        $self->throw (\"window_width must be integer\")\n            unless $value =~ /^\\d+$/;\n        $self->{'_window_width'} = $value;\n    }\n    $self->{'_window_width'} ||= $self->input_spec->[2]{'default'};\n    $self->warn (\"window width longer than sequence!\")\n        unless $self->{'_window_width'} < $self->seq->length;\n    return $self->{'_window_width'};\n}\n\n=head2  states\n\n  Usage    : $job->states(...)\n  Returns  : The number of secondary structure prediction states\n  Args     : None (retrieves value) or either '3' or '4' to set\n             prior to running analysis.\n\nThis method gets/sets the number of states for the prediction, either\n3 or 4 (includes turns).","label":"states($self,$value)"},"containerName":"main::","name":"states","children":[{"definition":"my","line":255,"name":"$self","localvar":"my","kind":13,"containerName":"states"},{"line":255,"kind":13,"containerName":"states","name":"$value"},{"line":256,"name":"$value","kind":13,"containerName":"states"},{"name":"$self","containerName":"states","kind":13,"line":257},{"name":"throw","containerName":"states","kind":12,"line":257},{"line":258,"name":"$value","kind":13,"containerName":"states"},{"kind":13,"containerName":"states","name":"$value","line":258},{"line":259,"containerName":"states","kind":13,"name":"$self"},{"kind":13,"containerName":"states","name":"$value","line":259},{"name":"$self","kind":13,"containerName":"states","line":261},{"kind":13,"containerName":"states","name":"$self","line":261},{"line":261,"name":"input_spec","kind":12,"containerName":"states"},{"line":262,"kind":13,"containerName":"states","name":"$self"}],"detail":"($self,$value)","definition":"sub"},{"detail":"($self,$value,$run_id)","definition":"sub","containerName":"main::","name":"result","children":[{"definition":"my","line":309,"name":"$self","kind":13,"localvar":"my","containerName":"result"},{"name":"$value","containerName":"result","kind":13,"line":309},{"line":309,"name":"$run_id","containerName":"result","kind":13},{"kind":13,"localvar":"my","containerName":"result","name":"@score","line":311,"definition":"my"},{"line":312,"localvar":"my","kind":13,"containerName":"result","name":"@fts","definition":"my"},{"kind":13,"containerName":"result","name":"$value","line":314},{"containerName":"result","kind":13,"name":"$self","line":315},{"localvar":"my","containerName":"result","kind":13,"name":"$result","line":316,"definition":"my"},{"line":316,"kind":12,"containerName":"result","name":"new"},{"containerName":"result","kind":13,"name":"$self","line":316},{"line":317,"name":"$line","localvar":"my","kind":13,"containerName":"result","definition":"my"},{"line":317,"name":"$result","kind":13,"containerName":"result"},{"name":"$line","containerName":"result","kind":13,"line":318},{"line":319,"name":"$line","kind":13,"containerName":"result"},{"name":"@score","containerName":"result","kind":13,"line":320},{"containerName":"result","kind":13,"name":"$score","line":326},{"line":326,"name":"$self","kind":13,"containerName":"result"},{"name":"states","kind":12,"containerName":"result","line":326},{"containerName":"result","kind":13,"name":"$self","line":329},{"containerName":"result","kind":13,"name":"@score","line":329},{"containerName":"result","kind":13,"name":"$value","line":331},{"name":"$self","containerName":"result","kind":13,"line":332},{"line":332,"name":"_get_2ary_coords","containerName":"result","kind":12},{"definition":"my","line":333,"name":"$type","localvar":"my","kind":13,"containerName":"result"},{"name":"$self","kind":13,"containerName":"result","line":333},{"name":"$type","containerName":"result","kind":13,"line":334},{"line":338,"localvar":"my","kind":13,"containerName":"result","name":"$tag_hash","definition":"my"},{"line":339,"name":"$type","containerName":"result","kind":13},{"name":"$self","containerName":"result","kind":13,"line":340},{"line":340,"name":"analysis_name","kind":12,"containerName":"result"},{"line":342,"containerName":"result","kind":13,"name":"$self"},{"line":342,"name":"_add_params_to_result","containerName":"result","kind":12},{"name":"$tag_hash","containerName":"result","kind":13,"line":342},{"line":345,"name":"$loc","localvar":"my","containerName":"result","kind":13,"definition":"my"},{"line":345,"kind":13,"containerName":"result","name":"$self"},{"line":345,"kind":13,"containerName":"result","name":"$type"},{"name":"@fts","kind":13,"containerName":"result","line":346},{"line":347,"name":"new","kind":12,"containerName":"result"},{"name":"$loc","kind":13,"containerName":"result","line":347},{"containerName":"result","kind":13,"name":"$loc","line":348},{"line":351,"name":"$tag_hash","kind":13,"containerName":"result"},{"kind":13,"containerName":"result","name":"$self","line":355},{"line":356,"name":"@fts","kind":13,"containerName":"result"}],"signature":{"label":"result($self,$value,$run_id)","documentation":"1;\n# $Id: Sopma.pm,v 1.0 2003/07/ 11\n#\n# BioPerl module for Bio::Tools::Analysis::Protein::Sopma\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n\n=head1 NAME\n\nBio::Tools::Analysis::Protein::Sopma - a wrapper around the\nSopma protein secondary structure prediction server\n\n=head1  SYNOPSIS\n\n  use Bio::Tools::Analysis::Protein::Sopma;\n  #get a Bio::Seq or Bio::PrimarySeq\n  my $seq;\n\n  my $sopma = Bio::Tools::Analysis::Protein::Sopma->new\n      (-seq=>$seq, states=>4);\n  $sopma->run;\n  print $sopma->result;# #raw text to standard error\n\n=head1  DESCRIPTION\n\nA module to remotely retrieve predictions of protein secondary\nstructure.  Each residue in the protein receives a score representing\nthe likelihood of existing in each of four different states (helix,\ncoil, turn or sheet), e.g.,\n\n  my $analysis_object = Bio::Tools::SimpleAnalysis::Protein::Sopma->new\n      ( -seq          => $seq,\n        -states       => 4,\n        -window_width => 15,\n      );\n\ncreates a new object.  Compulsory argument -seq.  Optional arguments\n-states, -window_width,-similarity_threshold. These arguments can also be\nset by direct methods , e.g.,\n\n  $analysis_object->states(4);\n  $analysis_object->run;\n\nsubmits the query to the server and obtains raw text output. Given an\namino acid sequence the results can be obtained in 4 formats,\ndetermined by the argument to the result method:\n\n=over 4\n\n* 1\n\nThe raw text of the program output.\n\n  my $rawdata = $analysis_object->result;\n\n* 2\n\nA reference to an array of hashes of scores for each state and the\nassigned state.\n\n  my $data_ref = $analysis_object->result('parsed');\n  print \"score for helix at residue 2 is $data_ref->[1]{'helix'}\\n\";\n  print \"predicted struc  at residue 2 is $data_ref->[1]{'struc}\\n\";\n\nHash keys are 'helix', 'struc', 'sheet', 'coil', 'turn'.\n\n* 3\n\nAn array of Bio::SeqFeature::Generic objects where each feature is a\npredicted unit of secondary structure. Only stretches of helix/sheet\npredictions for longer than 4 residues are defined as helices/sheets.\n\n  my @fts = $analysis_object->result(Bio::SeqFeatureI);\n  for my $ft (@fts) {\n      print \" From \",  $ft->start, \" to  \",$ft->end, \" struc: \" ,\n             ($ft->each_tag_value('type'))[0]  ,\"\\n\";\n  }\n\n* 4\n\nA Bio::Seq::Meta::Array implementing sequence.\n\nThis is a Bio::Seq object that can also hold data about each residue\nin the sequence.  In this case, the sequence can be associated with a\narrays of Sopma prediction scores.  e.g.,\n\n  my $meta_sequence = $analysis_object->result('meta');\n  print \"scores from residues 10 -20 are \",\n      $meta_sequence->named_submeta_text(\"Sopma_helix\",10,20), \"\\n\";\n\nMeta sequence names are : Sopma_helix, Sopma_sheet, Sopma_turn,\nSopma_coil, Sopma_struc, representing the scores for each residue.\n\nMany methods common to all analyses are inherited from\nBio::Tools::Analysis::SimpleAnalysisBase.\n\n\n=head1 SEE ALSO\n\nL<Bio::SimpleAnalysisI>, \nL<Bio::Tools::Analysis::SimpleAnalysisBase>\nL<Bio::Seq::Meta::Array>, \nL<Bio::WebAgent>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk, \n\n=head1 APPENDIX\n\n\nuse strict;\n\npackage Bio::Tools::Analysis::Protein::Sopma;\n\nuse IO::String;\nuse Bio::SeqIO;\nuse HTTP::Request::Common qw (POST);\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq::Meta::Array;\n\n\nuse base qw(Bio::Tools::Analysis::SimpleAnalysisBase);\n\n#extends array for 2struc.\nmy $URL = 'http://npsa-pbil.ibcp.fr/cgi-bin/secpred_sopma.pl';\nmy $ANALYSIS_NAME= 'Sopma';\nmy $ANALYSIS_SPEC= {name => 'Sopma', type => 'Protein'};\nmy $INPUT_SPEC = [\n                  {mandatory=>'true',\n                   type     => 'Bio::PrimarySeqI',\n                   'name'   => 'seq',\n                  },\n                  {mandatory =>'false',\n                   type      => 'integer',\n                   name      => 'similarity_threshold',\n                   default   => 8,\n                  },\n                  {mandatory  =>'false',\n                   type       => 'integer',\n                   name       => 'window_width',\n                   default    => 17,\n                  },\n                  {mandatory  =>'false',\n                   type       => 'integer',\n                   name       => 'states',\n                   default    => 4,\n                  },\n                 ];\nmy  $RESULT_SPEC =\n    {\n     ''   => 'bulk',              # same as undef\n     raw  => '[{struc=>, helix=>, turn=>, coil=>, sheet=>}]',\n     meta => 'Bio::Seq::Meta::Array object',\n     'Bio::SeqFeatureI' => 'ARRAY of Bio::SeqFeature::Generic',\n    };\nuse constant MIN_STRUC_LEN => 3; \n\n\n=head2  similarity_threshold\n\n  Useage  : $job->similarity_threshold(...)\n  Returns : The  similarity threshold used in the analysis\n  Args    : None (retrieves value) or  an integer (default = 8) \n            that sets the similarity threshold .\n\nThis method gets/sets the  similarity threshold for the prediction.\n\n\nsub similarity_threshold {\n    my ($self, $value) = @_;\n    if ($value) {\n        $self->throw (\"similarity_threshold must be integer\")\n            unless $value =~ /^\\d+$/;\n        $self->{'_similarity_threshold'} = $value;\n    }\n    $self->{'_similarity_threshold'} ||= $self->input_spec->[1]{'default'};\n    return $self->{'_similarity_threshold'};\n}\n\n=head2  window_width\n\n  Usage    : $job->window_width(...)\n  Returns  : The window width used in the analysis\n  Args     : None (retrieves value) or  an integer (default = 17)\n             that sets the window width.\n\nThis method gets/sets the window width for the prediction, .  If\nattempted to set longer than the sequence, warns of error.\n\n\nsub window_width {\n    my ($self, $value) = @_;\n    if ($value) {\n        $self->throw (\"window_width must be integer\")\n            unless $value =~ /^\\d+$/;\n        $self->{'_window_width'} = $value;\n    }\n    $self->{'_window_width'} ||= $self->input_spec->[2]{'default'};\n    $self->warn (\"window width longer than sequence!\")\n        unless $self->{'_window_width'} < $self->seq->length;\n    return $self->{'_window_width'};\n}\n\n=head2  states\n\n  Usage    : $job->states(...)\n  Returns  : The number of secondary structure prediction states\n  Args     : None (retrieves value) or either '3' or '4' to set\n             prior to running analysis.\n\nThis method gets/sets the number of states for the prediction, either\n3 or 4 (includes turns).\n\n\nsub states {\n    my ($self, $value) = @_;\n    if ($value) {\n        $self->throw (\"number of states must be 3 or 4\")\n            unless $value == 3 or $value ==4;\n        $self->{'_states'} = $value;\n    }\n    $self->{'_states'} ||= $self->input_spec->[3]{'default'};\n    return $self->{'_states'};\n}\n\n=head2 result\n\n  Usage   : $job->result (...)\n  Returns : a result created by running an analysis\n  Args    : various\n\nThe method returns a result of an executed job. If the job was\nterminated by an error the result may contain an error message instead\nof the real data.\n\nThis implementation returns differently processed data depending on\nargument:\n\n=over 3\n\n* undef\n\nReturns the raw ASCII data stream but without HTML tags\n\n* 'Bio::SeqFeatureI'\n\nThe argument string defines the type of bioperl objects returned in an\narray.  The objects are L<Bio::SeqFeature::Generic>.  Feature primary\ntag is \"2ary\".  Feature tags are \"type\" (which can be helix, sheet\ncoil, or turn if 4 state prediction requested) \"method\" (Sopma)\n\n* 'parsed'\n\nArray of hash references of scores/structure assignations \n{ helix =E<gt> , sheet =E<gt> , coil =E<gt> , struc=E<gt>}.\n\n* 'all'\n\nA Bio::Seq::Meta::Array object. Scores can be accessed using methods\nfrom this class. Meta sequence names are Sopma_helix, Sopma_sheet,\nSopma_coil, Sopma_turn (if defined), and Sopma_struc.","parameters":[{"label":"$self"},{"label":"$value"},{"label":"$run_id"}]},"range":{"end":{"character":9999,"line":357},"start":{"line":308,"character":0}},"kind":12,"line":308},{"containerName":"String","kind":12,"name":"IO","line":316},{"name":"struc","kind":12,"line":320},{"line":321,"name":"helix","kind":12},{"kind":12,"name":"sheet","line":322},{"kind":12,"name":"coil","line":323},{"kind":12,"name":"score","line":326},{"line":339,"kind":12,"name":"type"},{"kind":12,"name":"method","line":340},{"line":346,"kind":12,"containerName":"SeqFeature::Generic","name":"Bio"},{"name":"%value","kind":13,"containerName":null,"line":359},{"line":361,"name":"%type_scores","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"line":362,"localvar":"my","containerName":null,"kind":13,"name":"$aa","definition":"my"},{"name":"%self","containerName":null,"kind":13,"line":362},{"definition":"my","line":363,"containerName":null,"localvar":"my","kind":13,"name":"%type"},{"line":364,"name":"%type_scores","kind":13,"containerName":null},{"line":364,"name":"$type","containerName":null,"kind":13},{"line":364,"name":"%aa","containerName":null,"kind":13},{"line":364,"name":"$type","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%type_scores","line":366},{"name":"%aa","kind":13,"containerName":null,"line":366},{"kind":13,"containerName":null,"name":"%aa","line":366},{"line":370,"name":"$self","kind":13,"containerName":null},{"line":370,"kind":12,"containerName":"main::","name":"seq"},{"line":370,"kind":12,"containerName":"main::","name":"isa"},{"line":371,"name":"$self","containerName":null,"kind":13},{"name":"seq","kind":12,"containerName":"main::","line":371},{"line":373,"containerName":null,"kind":13,"name":"$self"},{"name":"seq","containerName":"main::","kind":12,"line":373},{"containerName":"main::","kind":12,"name":"isa","line":373},{"name":"$self","containerName":null,"kind":13,"line":374},{"kind":12,"containerName":"main::","name":"throw","line":374},{"line":377,"containerName":null,"kind":13,"name":"$Bio"},{"line":377,"kind":12,"containerName":"Meta::Array::DEFAULT_NAME","name":"Seq"},{"name":"$struc_type","containerName":null,"localvar":"my","kind":13,"line":378,"definition":"my"},{"containerName":null,"kind":13,"name":"%type_scores","line":378},{"definition":"my","line":379,"localvar":"my","kind":13,"containerName":null,"name":"$meta_name"},{"line":380,"name":"%run_id","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$meta_name","line":381},{"name":"@meta","localvar":"my","kind":13,"containerName":null,"line":383,"definition":"my"},{"line":383,"containerName":null,"kind":13,"name":"$struc_type"},{"line":383,"containerName":null,"kind":13,"name":"%self"},{"name":"$meta_name","containerName":null,"kind":13,"line":384},{"containerName":null,"kind":13,"name":"$self","line":384},{"kind":12,"containerName":"main::","name":"seq","line":384},{"line":384,"containerName":"main::","kind":12,"name":"meta_names"},{"line":385,"kind":13,"containerName":null,"name":"$self"},{"name":"warn","containerName":"main::","kind":12,"line":385},{"name":"$self","kind":13,"containerName":null,"line":388},{"name":"seq","containerName":"main::","kind":12,"line":388},{"name":"named_meta","containerName":"main::","kind":12,"line":388},{"line":388,"name":"$meta_name","containerName":null,"kind":13},{"name":"@meta","kind":13,"containerName":null,"line":388},{"line":391,"name":"$self","containerName":null,"kind":13},{"containerName":"main::","kind":12,"name":"seq","line":391},{"line":396,"name":"%self","containerName":null,"kind":13},{"line":401,"name":"%self","containerName":null,"kind":13},{"definition":"sub","containerName":"main::","name":"_init","children":[{"definition":"my","line":405,"name":"$self","kind":13,"localvar":"my","containerName":"_init"},{"line":406,"kind":13,"containerName":"_init","name":"$self"},{"kind":12,"containerName":"_init","name":"url","line":406},{"name":"$URL","kind":13,"containerName":"_init","line":406},{"line":407,"name":"$self","containerName":"_init","kind":13},{"line":407,"name":"$ANALYSIS_SPEC","kind":13,"containerName":"_init"},{"line":408,"kind":13,"containerName":"_init","name":"$self"},{"line":408,"kind":13,"containerName":"_init","name":"$INPUT_SPEC"},{"kind":13,"containerName":"_init","name":"$self","line":409},{"line":409,"kind":13,"containerName":"_init","name":"$RESULT_SPEC"},{"line":410,"name":"$self","containerName":"_init","kind":13},{"line":410,"containerName":"_init","kind":13,"name":"$ANALYSIS_NAME"},{"containerName":"_init","kind":13,"name":"$self","line":411}],"range":{"start":{"line":404,"character":0},"end":{"line":412,"character":9999}},"kind":12,"line":404},{"containerName":"main::","name":"_get_2ary_coords","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"_get_2ary_coords","kind":13,"line":420},{"line":421,"name":"@prot","kind":13,"localvar":"my","containerName":"_get_2ary_coords","definition":"my"},{"containerName":"_get_2ary_coords","kind":13,"name":"$self","line":421}],"detail":"($self)","definition":"sub","kind":12,"range":{"end":{"line":421,"character":9999},"start":{"character":0,"line":414}},"line":414,"signature":{"label":"_get_2ary_coords($self)","documentation":"","parameters":[{"label":"$self"}]}},{"name":"%Result","localvar":"my","kind":13,"containerName":null,"line":422,"definition":"my"},{"name":"$index","localvar":"my","containerName":null,"kind":13,"line":423,"definition":"my"},{"line":423,"name":"$index","containerName":null,"kind":13},{"line":423,"name":"prot","kind":12},{"name":"%index","kind":13,"containerName":null,"line":423},{"containerName":null,"localvar":"my","kind":13,"name":"$type","line":425,"definition":"my"},{"line":425,"name":"@prot","containerName":null,"kind":13},{"line":425,"name":"%index","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$type","line":426},{"line":426,"kind":13,"containerName":null,"name":"$type"},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$length","line":427},{"definition":"my","line":428,"kind":13,"localvar":"my","containerName":null,"name":"$j"},{"name":"$index","containerName":null,"kind":13,"line":428},{"line":428,"name":"$j","containerName":null,"kind":13},{"line":428,"name":"prot","kind":12},{"line":428,"name":"%j","kind":13,"containerName":null},{"line":429,"localvar":"my","containerName":null,"kind":13,"name":"$test","definition":"my"},{"line":429,"kind":13,"containerName":null,"name":"@prot"},{"line":429,"kind":13,"containerName":null,"name":"$j"},{"name":"%test","kind":13,"containerName":null,"line":430},{"line":430,"containerName":null,"kind":13,"name":"%type"},{"kind":13,"containerName":null,"name":"$length","line":431},{"containerName":null,"kind":13,"name":"$length","line":432},{"line":432,"kind":12,"name":"MIN_STRUC_LEN"},{"containerName":null,"kind":13,"name":"$length","line":433},{"name":"MIN_STRUC_LEN","kind":12,"line":433},{"line":433,"name":"%type","containerName":null,"kind":13},{"line":434,"name":"%Result","containerName":null,"kind":13},{"name":"%type","kind":13,"containerName":null,"line":434},{"line":434,"kind":12,"name":"start"},{"line":434,"kind":13,"containerName":null,"name":"$index"},{"line":434,"name":"end","kind":12},{"containerName":null,"kind":13,"name":"$j","line":434},{"line":435,"kind":13,"containerName":null,"name":"$index"},{"name":"%length","containerName":null,"kind":13,"line":435},{"containerName":null,"kind":13,"name":"$index","line":438},{"line":438,"containerName":null,"kind":13,"name":"$length"},{"kind":13,"containerName":null,"name":"%self","line":443},{"containerName":null,"kind":13,"name":"%Result","line":443},{"children":[{"line":447,"kind":13,"localvar":"my","containerName":"_run","name":"$self","definition":"my"},{"line":448,"name":"$self","kind":13,"containerName":"_run"},{"name":"delay","containerName":"_run","kind":12,"line":448},{"line":450,"containerName":"_run","kind":13,"name":"$self"},{"line":450,"kind":12,"containerName":"_run","name":"sleep"},{"name":"$self","containerName":"_run","kind":13,"line":451},{"kind":12,"containerName":"_run","name":"status","line":451},{"localvar":"my","kind":13,"containerName":"_run","name":"$request","line":452,"definition":"my"},{"containerName":"_run","kind":13,"name":"$self","line":455},{"line":455,"kind":12,"containerName":"_run","name":"seq"},{"line":455,"name":"seq","kind":12,"containerName":"_run"},{"line":457,"name":"$self","kind":13,"containerName":"_run"},{"line":457,"name":"states","containerName":"_run","kind":12},{"line":458,"containerName":"_run","kind":13,"name":"$self"},{"line":458,"containerName":"_run","kind":12,"name":"similarity_threshold"},{"line":459,"containerName":"_run","kind":13,"name":"$self"},{"kind":12,"containerName":"_run","name":"window_width","line":459},{"definition":"my","line":462,"name":"$text","kind":13,"localvar":"my","containerName":"_run"},{"line":462,"kind":13,"containerName":"_run","name":"$self"},{"line":462,"name":"request","containerName":"_run","kind":12},{"line":462,"kind":13,"containerName":"_run","name":"$request"},{"line":462,"name":"content","containerName":"_run","kind":12},{"line":463,"name":"$self","containerName":"_run","kind":13},{"name":"$text","containerName":"_run","kind":13,"line":463},{"definition":"my","containerName":"_run","localvar":"my","kind":13,"name":"$next","line":466},{"line":466,"containerName":"_run","kind":13,"name":"$text"},{"line":467,"localvar":"my","kind":13,"containerName":"_run","name":"$out","definition":"my"},{"definition":"my","line":468,"localvar":"my","kind":13,"containerName":"_run","name":"$req2"},{"name":"new","containerName":"_run","kind":12,"line":468},{"line":468,"containerName":"_run","kind":13,"name":"$out"},{"line":469,"kind":13,"localvar":"my","containerName":"_run","name":"$resp2","definition":"my"},{"line":469,"containerName":"_run","kind":13,"name":"$self"},{"line":469,"containerName":"_run","kind":12,"name":"request"},{"name":"$req2","kind":13,"containerName":"_run","line":469},{"containerName":"_run","kind":13,"name":"$self","line":470},{"line":470,"name":"$resp2","containerName":"_run","kind":13},{"name":"content","kind":12,"containerName":"_run","line":470},{"line":471,"name":"$self","kind":13,"containerName":"_run"},{"line":471,"name":"status","kind":12,"containerName":"_run"},{"containerName":"_run","kind":13,"name":"$resp2","line":471},{"kind":13,"containerName":"_run","name":"$self","line":472}],"containerName":"main::","name":"_run","definition":"sub","line":446,"kind":12,"range":{"end":{"line":473,"character":9999},"start":{"line":446,"character":0}}},{"line":452,"kind":12,"name":"POST"},{"line":453,"kind":12,"name":"Content_Type"},{"kind":12,"name":"Content","line":454},{"line":454,"kind":12,"name":"title"},{"line":455,"name":"notice","kind":12},{"kind":12,"name":"ali_width","line":456},{"kind":12,"name":"states","line":457},{"line":458,"kind":12,"name":"threshold"},{"line":459,"name":"width","kind":12},{"kind":12,"containerName":"Request","name":"HTTP","line":468},{"kind":12,"name":"GET","line":468},{"detail":"($self,$tag_hash)","definition":"sub","containerName":"main::","name":"_add_params_to_result","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"_add_params_to_result","line":477},{"line":477,"kind":13,"containerName":"_add_params_to_result","name":"$tag_hash"},{"line":478,"containerName":"_add_params_to_result","localvar":"my","kind":13,"name":"$hash","definition":"my"},{"line":481,"containerName":"_add_params_to_result","kind":13,"name":"$hash"},{"name":"$self","kind":13,"containerName":"_add_params_to_result","line":481},{"line":481,"kind":12,"containerName":"_add_params_to_result","name":"input_spec"}],"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$tag_hash"}],"label":"_add_params_to_result($self,$tag_hash)"},"kind":12,"range":{"end":{"line":481,"character":9999},"start":{"character":0,"line":475}},"line":475},{"line":483,"name":"$p","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"line":483,"containerName":null,"kind":13,"name":"%hash"},{"line":484,"kind":13,"containerName":null,"name":"$self"},{"line":484,"name":"$p","containerName":null,"kind":13},{"line":484,"kind":13,"containerName":null,"name":"$self"},{"line":484,"kind":13,"containerName":null,"name":"$p"},{"line":484,"name":"%hash","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%p","line":484},{"kind":13,"containerName":null,"name":"%tag_hash","line":485},{"kind":13,"containerName":null,"name":"$p","line":485},{"line":485,"kind":13,"containerName":null,"name":"$self"},{"line":485,"containerName":null,"kind":13,"name":"$p"}],"version":5}