{"vars":[{"kind":2,"containerName":"","name":"vars","line":113},{"kind":2,"containerName":"strict::IO::String::Bio::SeqIO::HTTP::Request","name":"Common","line":117},{"line":120,"containerName":"","kind":2,"name":"base"},{"name":"$FLOAT","kind":13,"containerName":null,"line":122},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$URL","line":123},{"line":126,"localvar":"my","kind":13,"containerName":null,"name":"%ANALYSIS_SPEC","definition":"my"},{"definition":"my","line":137,"name":"@INPUT_SPEC","localvar":"my","kind":13,"containerName":null},{"definition":"my","line":152,"kind":13,"localvar":"my","containerName":null,"name":"%RESULT_SPEC"},{"children":[{"name":"$self","containerName":"result","localvar":"my","kind":13,"line":199,"definition":"my"},{"line":199,"containerName":"result","kind":13,"name":"$value"},{"definition":"my","name":"@predictions","localvar":"my","containerName":"result","kind":13,"line":201},{"definition":"my","line":202,"localvar":"my","containerName":"result","kind":13,"name":"@fts"},{"line":204,"name":"$value","containerName":"result","kind":13},{"name":"$result","containerName":"result","localvar":"my","kind":13,"line":206,"definition":"my"},{"line":206,"containerName":"result","kind":12,"name":"new"},{"name":"$self","containerName":"result","kind":13,"line":206},{"name":"$result","kind":13,"containerName":"result","line":207},{"kind":13,"containerName":"result","name":"$self","line":210},{"name":"threshold","containerName":"result","kind":12,"line":210},{"name":"@predictions","containerName":"result","kind":13,"line":211},{"name":"$value","kind":13,"containerName":"result","line":213},{"containerName":"result","kind":13,"name":"@predictions","line":214},{"containerName":"result","kind":13,"name":"@fts","line":215},{"line":216,"name":"new","kind":12,"containerName":"result"},{"kind":13,"containerName":"result","name":"@fts","line":224},{"kind":13,"containerName":"result","name":"@predictions","line":226},{"line":229,"kind":13,"containerName":"result","name":"$self"}],"name":"result","containerName":"main::","definition":"sub","detail":"($self,$value)","line":198,"kind":12,"range":{"end":{"line":230,"character":9999},"start":{"line":198,"character":0}},"signature":{"label":"result($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: NetPhos.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Analysis::Protein::NetPhos\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Analysis::Protein::NetPhos - a wrapper around NetPhos server\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Analysis::Protein::NetPhos;\n\n  my $seq; # a Bio::PrimarySeqI object\n  my $threshold  = \"0.90\";\n\n  my $netphos = Bio::Tools::Analysis::Protein::NetPhos->new\n     ( -seq => $seq,\n       -threshold => $threshold );\n\n  # run NetPhos prediction on a sequence\n  my $netphos->run();\n\n  # alternatively you can say\n  $netphos->seq($seq)->threshold($threshold)->run;\n\n  die \"Could not get a result\" unless $netphos->status =~ /^COMPLETED/;\n\n  print $netphos->result;     # print raw prediction to STDOUT\n\n  foreach my $feat ( $netphos->result('Bio::SeqFeatureI') ) {\n\n      # do something to SeqFeature\n      # e.g. print as GFF\n      print $feat->gff_string, \"\\n\";\n      # or store within the sequence - if it is a Bio::RichSeqI\n      $seq->add_SeqFeature($feat)\n\n }\n\n=head1 DESCRIPTION\n\nThis class is wrapper around the NetPhos 2.0 server which produces\nneural network predictions for serine, threonine and tyrosine\nphosphorylation sites in eukaryotic proteins.\n\nSee L<http://www.cbs.dtu.dk/services/NetPhos/>.\n\nThis the first implentation of Bio::SimpleAnalysisI which hopefully\nwill make it easier to write wrappers on various services. This class\nuses a web resource and therefore inherits from Bio::WebAgent.\n\n=head1 SEE ALSO\n\nL<Bio::SimpleAnalysisI>, \nL<Bio::WebAgent>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk, \nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Analysis::Protein::NetPhos;\nuse vars qw($FLOAT);\nuse strict;\nuse IO::String;\nuse Bio::SeqIO;\nuse HTTP::Request::Common qw (POST);\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Tools::Analysis::SimpleAnalysisBase);\n\n    $FLOAT = '[+-]?\\d*\\.\\d*';\n    my $URL = 'http://www.cbs.dtu.dk/cgi-bin/nph-webface';\n\n\n    my $ANALYSIS_SPEC =\n        {\n         'name'        => 'NetPhos',\n         'type'        => 'Protein',\n         'version'     => '2.0',\n         'supplier'    => 'Center for Biological Sequence Analysis,\n                           Technical University of Denmark',\n         'description' => 'Prediction of serine, threonine and tyrosine\n                             phosphorylation sites in eukaryotic proteins',\n        };\n\n    my $INPUT_SPEC =\n        [\n         {\n          'mandatory' => 'true',\n          'type'      => 'Bio::PrimarySeqI',\n          'name'      => 'seq',\n         },\n         {\n          'mandatory' => 'false',\n          'type'      => 'float',\n          'name'      => 'threshold',\n          'default'   => 0.8,\n         }\n        ];\n\n    my $RESULT_SPEC =\n        {\n         ''                 => 'bulk',  # same as undef\n         'Bio::SeqFeatureI' => 'ARRAY of Bio::SeqFeeature::Generic',\n         'raw'              => 'Array of [ position, score, residue ]'\n        };\n\n\n=head2 result\n\n Name    : result\n Usage   : $job->result (...)\n Returns : a result created by running an analysis\n Args    : none (but an implementation may choose\n           to add arguments for instructions how to process\n           the raw result)\n\nThe method returns a scalar representing a result of an executed\njob. If the job was terminated by an error the result may contain an\nerror message instead of the real data (or both, depending on the\nimplementation).\n\nThis implementation returns differently processed data depending on\nargument:\n\n=over 3\n\n* undef\n\nReturns the raw ASCII data stream but without HTML tags\n\n* 'Bio::SeqFeatureI'\n\nThe argument string defined the type of bioperl objects returned in an\narray.  The objects are L<Bio::SeqFeature::Generic>.\n\n* anything else\n\nArray of array references of [ position, score, residue]."}},{"kind":12,"containerName":"String","name":"IO","line":206},{"kind":12,"containerName":"SeqFeature::Generic","name":"Bio","line":215},{"name":"score","kind":12,"line":221},{"line":222,"kind":12,"name":"residue"},{"name":"threshold","containerName":"main::","children":[{"line":242,"name":"$self","localvar":"my","containerName":"threshold","kind":13,"definition":"my"},{"containerName":"threshold","kind":13,"name":"$value","line":242},{"line":243,"kind":13,"containerName":"threshold","name":"$value"},{"line":244,"name":"$value","containerName":"threshold","kind":13},{"kind":13,"containerName":"threshold","name":"$value","line":244},{"name":"$value","kind":13,"containerName":"threshold","line":244},{"name":"$self","containerName":"threshold","kind":13,"line":245},{"name":"throw","containerName":"threshold","kind":12,"line":245},{"name":"$value","kind":13,"containerName":"threshold","line":245},{"name":"$self","containerName":"threshold","kind":13,"line":247},{"kind":13,"containerName":"threshold","name":"$value","line":247},{"line":248,"name":"$self","containerName":"threshold","kind":13},{"name":"$self","containerName":"threshold","kind":13,"line":250},{"line":250,"name":"$self","containerName":"threshold","kind":13},{"name":"input_spec","kind":12,"containerName":"threshold","line":250}],"detail":"($self,$value)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":241},"end":{"character":9999,"line":251}},"line":241,"signature":{"label":"threshold($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: NetPhos.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Analysis::Protein::NetPhos\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Analysis::Protein::NetPhos - a wrapper around NetPhos server\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Analysis::Protein::NetPhos;\n\n  my $seq; # a Bio::PrimarySeqI object\n  my $threshold  = \"0.90\";\n\n  my $netphos = Bio::Tools::Analysis::Protein::NetPhos->new\n     ( -seq => $seq,\n       -threshold => $threshold );\n\n  # run NetPhos prediction on a sequence\n  my $netphos->run();\n\n  # alternatively you can say\n  $netphos->seq($seq)->threshold($threshold)->run;\n\n  die \"Could not get a result\" unless $netphos->status =~ /^COMPLETED/;\n\n  print $netphos->result;     # print raw prediction to STDOUT\n\n  foreach my $feat ( $netphos->result('Bio::SeqFeatureI') ) {\n\n      # do something to SeqFeature\n      # e.g. print as GFF\n      print $feat->gff_string, \"\\n\";\n      # or store within the sequence - if it is a Bio::RichSeqI\n      $seq->add_SeqFeature($feat)\n\n }\n\n=head1 DESCRIPTION\n\nThis class is wrapper around the NetPhos 2.0 server which produces\nneural network predictions for serine, threonine and tyrosine\nphosphorylation sites in eukaryotic proteins.\n\nSee L<http://www.cbs.dtu.dk/services/NetPhos/>.\n\nThis the first implentation of Bio::SimpleAnalysisI which hopefully\nwill make it easier to write wrappers on various services. This class\nuses a web resource and therefore inherits from Bio::WebAgent.\n\n=head1 SEE ALSO\n\nL<Bio::SimpleAnalysisI>, \nL<Bio::WebAgent>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk, \nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Analysis::Protein::NetPhos;\nuse vars qw($FLOAT);\nuse strict;\nuse IO::String;\nuse Bio::SeqIO;\nuse HTTP::Request::Common qw (POST);\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Tools::Analysis::SimpleAnalysisBase);\n\n    $FLOAT = '[+-]?\\d*\\.\\d*';\n    my $URL = 'http://www.cbs.dtu.dk/cgi-bin/nph-webface';\n\n\n    my $ANALYSIS_SPEC =\n        {\n         'name'        => 'NetPhos',\n         'type'        => 'Protein',\n         'version'     => '2.0',\n         'supplier'    => 'Center for Biological Sequence Analysis,\n                           Technical University of Denmark',\n         'description' => 'Prediction of serine, threonine and tyrosine\n                             phosphorylation sites in eukaryotic proteins',\n        };\n\n    my $INPUT_SPEC =\n        [\n         {\n          'mandatory' => 'true',\n          'type'      => 'Bio::PrimarySeqI',\n          'name'      => 'seq',\n         },\n         {\n          'mandatory' => 'false',\n          'type'      => 'float',\n          'name'      => 'threshold',\n          'default'   => 0.8,\n         }\n        ];\n\n    my $RESULT_SPEC =\n        {\n         ''                 => 'bulk',  # same as undef\n         'Bio::SeqFeatureI' => 'ARRAY of Bio::SeqFeeature::Generic',\n         'raw'              => 'Array of [ position, score, residue ]'\n        };\n\n\n=head2 result\n\n Name    : result\n Usage   : $job->result (...)\n Returns : a result created by running an analysis\n Args    : none (but an implementation may choose\n           to add arguments for instructions how to process\n           the raw result)\n\nThe method returns a scalar representing a result of an executed\njob. If the job was terminated by an error the result may contain an\nerror message instead of the real data (or both, depending on the\nimplementation).\n\nThis implementation returns differently processed data depending on\nargument:\n\n=over 3\n\n* undef\n\nReturns the raw ASCII data stream but without HTML tags\n\n* 'Bio::SeqFeatureI'\n\nThe argument string defined the type of bioperl objects returned in an\narray.  The objects are L<Bio::SeqFeature::Generic>.\n\n* anything else\n\nArray of array references of [ position, score, residue].\n\n\n\n\n\nsub result {\n    my ($self,$value) = @_;\n\n    my @predictions;\n    my @fts;\n\n    if ($value ) {\n\n        my $result = IO::String->new($self->{'_result'});\n        while (<$result>) {\n            next if /^____/;\n            /^\\S+ +(\\d+) +\\w+ +(0\\.\\d+) +.([STY])/;\n            next unless $3 and $2 > $self->threshold;\n            push @predictions, [$1, $2, $3];\n        }\n        if ($value eq 'Bio::SeqFeatureI') {\n            foreach  (@predictions) {\n                push @fts, Bio::SeqFeature::Generic->new\n                    (-start   => $_->[0],\n                     -end     => $_->[0] ,\n                     -source  => 'NetPhos',\n                     -primary => 'Site',\n                     -tag     => {\n                               score   => $_->[1],\n                               residue => $_->[2] });\n            }\n            return @fts;\n        }\n        return \\@predictions;\n    }\n\n    return $self->{'_result'};\n}\n\n=head2  threshold\n\n Usage   : $job->threshold(...)\n Returns  : The significance threshold of a prediction\n Args     : None (retrieves value) or a value beween 0 and 1.\n Purpose  : Get/setter of the threshold to be sumitted for analysis."}},{"range":{"start":{"line":253,"character":0},"end":{"character":9999,"line":262}},"kind":12,"line":253,"name":"_init","containerName":"main::","children":[{"line":255,"kind":13,"localvar":"my","containerName":"_init","name":"$self","definition":"my"},{"line":256,"name":"$self","kind":13,"containerName":"_init"},{"name":"url","kind":12,"containerName":"_init","line":256},{"kind":13,"containerName":"_init","name":"$URL","line":256},{"name":"$self","containerName":"_init","kind":13,"line":257},{"name":"$ANALYSIS_SPEC","kind":13,"containerName":"_init","line":257},{"containerName":"_init","kind":13,"name":"$self","line":258},{"line":258,"name":"$INPUT_SPEC","kind":13,"containerName":"_init"},{"kind":13,"containerName":"_init","name":"$self","line":259},{"name":"$RESULT_SPEC","kind":13,"containerName":"_init","line":259},{"name":"$self","containerName":"_init","kind":13,"line":260},{"kind":13,"containerName":"_init","name":"$ANALYSIS_SPEC","line":260},{"name":"$self","containerName":"_init","kind":13,"line":261}],"definition":"sub"},{"kind":12,"name":"name","line":260},{"name":"_run","containerName":"main::","children":[{"line":265,"kind":13,"localvar":"my","containerName":"_run","name":"$self","definition":"my"},{"containerName":"_run","localvar":"my","kind":13,"name":"$seq_fasta","line":268,"definition":"my"},{"line":269,"localvar":"my","kind":13,"containerName":"_run","name":"$stringfh","definition":"my"},{"name":"$seq_fasta","kind":13,"containerName":"_run","line":269},{"line":270,"containerName":"_run","localvar":"my","kind":13,"name":"$seqout","definition":"my"},{"name":"new","containerName":"_run","kind":12,"line":270},{"containerName":"_run","kind":13,"name":"$stringfh","line":270},{"name":"$seqout","kind":13,"containerName":"_run","line":272},{"line":272,"name":"write_seq","kind":12,"containerName":"_run"},{"name":"$self","containerName":"_run","kind":13,"line":272},{"name":"seq","containerName":"_run","kind":12,"line":272},{"name":"$self","kind":13,"containerName":"_run","line":273},{"name":"debug","kind":12,"containerName":"_run","line":273},{"line":273,"name":"$seq_fasta","kind":13,"containerName":"_run"},{"line":276,"containerName":"_run","kind":13,"name":"$self"},{"name":"sleep","kind":12,"containerName":"_run","line":276},{"kind":13,"containerName":"_run","name":"$self","line":278},{"containerName":"_run","kind":12,"name":"status","line":278},{"line":280,"localvar":"my","kind":13,"containerName":"_run","name":"$request","definition":"my"},{"line":280,"name":"$self","containerName":"_run","kind":13},{"name":"url","kind":12,"containerName":"_run","line":280},{"line":283,"name":"$seq_fasta","containerName":"_run","kind":13},{"localvar":"my","kind":13,"containerName":"_run","name":"$content","line":284,"definition":"my"},{"line":284,"containerName":"_run","kind":13,"name":"$self"},{"kind":12,"containerName":"_run","name":"request","line":284},{"containerName":"_run","kind":13,"name":"$request","line":284},{"definition":"my","containerName":"_run","localvar":"my","kind":13,"name":"$text","line":285},{"line":285,"name":"$content","containerName":"_run","kind":13},{"containerName":"_run","kind":12,"name":"content","line":285},{"line":287,"name":"$result_url","containerName":"_run","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"_run","name":"$text","line":287},{"containerName":"_run","kind":13,"name":"$result_url","line":288},{"line":289,"kind":13,"containerName":"_run","name":"$self"},{"line":289,"name":"debug","kind":12,"containerName":"_run"},{"definition":"my","line":291,"localvar":"my","kind":13,"containerName":"_run","name":"$ua2"},{"name":"$self","containerName":"_run","kind":13,"line":291},{"name":"clone","containerName":"_run","kind":12,"line":291},{"definition":"my","localvar":"my","containerName":"_run","kind":13,"name":"$content2","line":292},{"kind":13,"containerName":"_run","name":"$ua2","line":292},{"name":"request","containerName":"_run","kind":12,"line":292},{"name":"$result_url","kind":13,"containerName":"_run","line":292},{"definition":"my","line":294,"name":"$ua3","containerName":"_run","localvar":"my","kind":13},{"name":"$self","kind":13,"containerName":"_run","line":294},{"kind":12,"containerName":"_run","name":"clone","line":294},{"line":295,"name":"$result_url","kind":13,"containerName":"_run"},{"line":296,"kind":13,"containerName":"_run","name":"$self"},{"line":296,"name":"debug","containerName":"_run","kind":12},{"definition":"my","name":"$content3","containerName":"_run","localvar":"my","kind":13,"line":297},{"line":297,"name":"$ua3","containerName":"_run","kind":13},{"name":"request","kind":12,"containerName":"_run","line":297},{"kind":13,"containerName":"_run","name":"$result_url","line":297},{"line":299,"localvar":"my","kind":13,"containerName":"_run","name":"$response","definition":"my"},{"kind":13,"containerName":"_run","name":"$content3","line":299},{"name":"content","kind":12,"containerName":"_run","line":299},{"containerName":"_run","kind":13,"name":"$response","line":302},{"line":303,"name":"$response","containerName":"_run","kind":13},{"name":"$self","kind":13,"containerName":"_run","line":305},{"containerName":"_run","kind":13,"name":"$response","line":305},{"name":"$self","kind":13,"containerName":"_run","line":307},{"line":307,"kind":12,"containerName":"_run","name":"status"},{"name":"$response","containerName":"_run","kind":13,"line":307}],"definition":"sub","range":{"start":{"character":0,"line":264},"end":{"character":9999,"line":309}},"kind":12,"line":264},{"line":269,"name":"new","kind":12},{"name":"IO","containerName":"String","kind":12,"line":269},{"name":"Bio","kind":12,"containerName":"SeqIO","line":270},{"name":"POST","kind":12,"line":280},{"line":281,"kind":12,"name":"Content_Type"},{"line":282,"name":"Content","kind":12},{"kind":12,"name":"configfile","line":282},{"line":283,"name":"SEQPASTE","kind":12},{"kind":12,"name":"POST","line":292},{"line":297,"name":"POST","kind":12}],"version":5}