{"vars":[{"line":92,"kind":2,"containerName":"","name":"vars"},{"containerName":"HTML::HeadParser::Bio::SeqFeature::Generic::HTTP::Request","kind":2,"name":"Common","line":95},{"line":97,"name":"base","kind":2,"containerName":""},{"line":100,"kind":13,"containerName":null,"name":"%cc"},{"line":101,"kind":12,"name":"all"},{"line":102,"name":"nucleus","kind":12},{"line":103,"name":"extracellular","kind":12},{"line":104,"kind":12,"name":"cytoplasm"},{"line":105,"kind":12,"name":"peroxisome"},{"kind":12,"name":"glycosome","line":106},{"kind":12,"name":"glyoxisome","line":107},{"name":"golgi","kind":12,"line":108},{"name":"er","kind":12,"line":109},{"line":110,"name":"lysosome","kind":12},{"line":111,"name":"endosome","kind":12},{"kind":12,"name":"plasma_membrane","line":112},{"definition":"my","name":"$URL","containerName":null,"localvar":"my","kind":13,"line":115},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$ANALYSIS_NAME","line":116},{"localvar":"my","containerName":null,"kind":13,"name":"@INPUT_SPEC","line":117,"definition":"my"},{"definition":"my","line":138,"localvar":"my","kind":13,"containerName":null,"name":"%RESULT_SPEC"},{"line":148,"name":"%ANALYSIS_SPEC","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"name":"name","kind":12,"line":148},{"name":"type","kind":12,"line":149},{"line":150,"kind":12,"name":"version"},{"line":151,"name":"supplier","kind":12},{"kind":12,"name":"description","line":152},{"name":"reference","kind":12,"line":154},{"kind":12,"range":{"end":{"character":9999,"line":165},"start":{"character":0,"line":157}},"line":157,"name":"_init","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"_init","line":158},{"line":159,"containerName":"_init","kind":13,"name":"$self"},{"line":159,"name":"url","containerName":"_init","kind":12},{"line":159,"containerName":"_init","kind":13,"name":"$URL"},{"line":160,"kind":13,"containerName":"_init","name":"$self"},{"line":160,"kind":13,"containerName":"_init","name":"$ANALYSIS_SPEC"},{"line":161,"containerName":"_init","kind":13,"name":"$self"},{"containerName":"_init","kind":13,"name":"$INPUT_SPEC","line":161},{"line":162,"name":"$self","containerName":"_init","kind":13},{"line":162,"name":"$RESULT_SPEC","containerName":"_init","kind":13},{"name":"$self","kind":13,"containerName":"_init","line":163},{"line":163,"kind":13,"containerName":"_init","name":"$ANALYSIS_NAME"},{"containerName":"_init","kind":13,"name":"$self","line":164}],"definition":"sub"},{"detail":"($self,$arg)","definition":"sub","containerName":"main::","name":"compartment","children":[{"definition":"my","line":180,"localvar":"my","containerName":"compartment","kind":13,"name":"$self"},{"containerName":"compartment","kind":13,"name":"$arg","line":180},{"name":"$arg","containerName":"compartment","kind":13,"line":181},{"line":184,"kind":13,"containerName":"compartment","name":"$arg"},{"line":185,"containerName":"compartment","kind":13,"name":"$arg"},{"line":185,"kind":13,"containerName":"compartment","name":"$arg"},{"definition":"my","containerName":"compartment","localvar":"my","kind":13,"name":"$param","line":189},{"kind":13,"containerName":"compartment","name":"$arg","line":189},{"line":190,"containerName":"compartment","kind":13,"name":"$cc"},{"line":190,"kind":13,"containerName":"compartment","name":"$param"},{"kind":13,"containerName":"compartment","name":"$self","line":191},{"line":191,"name":"$cc","containerName":"compartment","kind":13},{"line":191,"name":"$param","containerName":"compartment","kind":13},{"name":"$self","containerName":"compartment","kind":13,"line":193},{"name":"warn","containerName":"compartment","kind":12,"line":193},{"line":194,"kind":13,"containerName":"compartment","name":"%cc"}],"signature":{"documentation":"1;\n# $Id: ELM.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Analysis::Protein::ELM\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Adams <richard.adams@ed.ac.uk>\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1     NAME\n\nBio::Tools::Analysis::Protein::ELM - a wrapper around the ELM server which predicts short functional motifs on amino acid sequences\n\n=head1     SYNOPSIS\n\n  # get a Bio::Seq object to start with, or a Bio::PrimaryI object.\n\n  my $tool = Bio::Tools::Analysis::Protein::ELM->\n      new(seq => $seqobj->primary_seq() );\t\n  $tool->compartment(['ER', 'Golgi']);\n  $tool->species(9606);\n  $tool->run;\n  my @fts = $tool->Result('Bio::SeqFeatureI');\n  $seqobj->addSeqFeature(@fts);\n\n=head1    DESCRIPTION\n\nThis module is a wrapper around the ELM server L<http://elm.eu.org/>\nwhich predicts short functional motifs on amino acid sequences. \n\nFalse positives can be limited by providing values for the species\nand cellular compartment of the protein. To set the species attribute,\nuse either a L<Bio::Species> object or an NCBI taxon ID number.  To set\nthe cell compartment attribute (any number of compartments can be\nchosen) use an array reference to a list of compartment names.\n\nResults can be obtained either as raw text output, parsed into a\ndata structure, or as Bio::SeqFeature::Generic objects.\n\n=head1 SEE ALSO\n\nL<Bio::SimpleAnalysisI>, \nL<Bio::WebAgent>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk, \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\nuse strict;\npackage Bio::Tools::Analysis::Protein::ELM;\nuse vars qw(%cc);\nuse HTML::HeadParser;\nuse Bio::SeqFeature::Generic;\nuse HTTP::Request::Common qw(POST);\nuse IO::String;\nuse base qw(Bio::Tools::Analysis::SimpleAnalysisBase);\n\n## valid cell compartments ##\n%cc = (\n      all            => 1,\n      nucleus        => 'GO:0005634',\n      extracellular  => 'GO:0005576',\n      cytoplasm      => 'GO:0005737',\n      peroxisome     => 'GO:0005777',\n      glycosome      => 'GO:0020015',\n      glyoxisome     => 'GO:0009514',\n      golgi          => 'GO:0005794',\n      er             => 'GO:0005783',\n      lysosome       => 'GO:0005764',\n      endosome       => 'GO:0005768',\n      plasma_membrane=> 'GO:0005886',\n\t\t);\n\nmy $URL           = 'http://elm.eu.org/basicELM/cgimodel.py';\nmy $ANALYSIS_NAME = 'ELM';\nmy $INPUT_SPEC    =\n    [\n     {\n      'mandatory' => 'true',\n      'type'      => 'Bio::PrimarySeqI',\n      'name'      => 'seq',\n     },\n     {\n      'mandatory' => 'false',\n      'type'      => 'taxon_id or Bio::Species object',\n      'name'      => 'species',\n      'default'   => '9606',\n     },\n     {\n      'mandatory' => 'false',\n      'type'      => 'string',\n      'name'      => 'compartment',\n      'default'   => [1],\n     },\n    ];\n\nmy  $RESULT_SPEC =\n    {\n     ''                 => 'bulk',              # same as undef\n     'Bio::SeqFeatureI' => 'ARRAY of Bio::SeqFeature::Generic',\n     'parsed'           => '{motif1_name=>{locus=>[],\n\t\t\t\t\t   peptide=>[],\n\t\t\t\t\t   regexp=>[]\n\t\t\t\t\t  },\n\t\t\t    }',\n    };\nmy $ANALYSIS_SPEC= {name        => 'ELM',\n\t\t\t\t    type        => 'Protein',\n                    version     => 'n/a',\n                    supplier    =>'BioComputing Unit, EMBL',\n\t\t\t\t\tdescription =>'Prediction of linear functional motifs\n                                  in proteins',\n\t\t\t\t\treference   => 'NAR, 31:3625-3630'};\n\n\nsub _init {\n    my $self = shift;\n    $self->url($URL);\n    $self->{'_ANALYSIS_SPEC'} = $ANALYSIS_SPEC;\n    $self->{'_INPUT_SPEC'}    = $INPUT_SPEC;\n    $self->{'_RESULT_SPEC'}   = $RESULT_SPEC;\n    $self->{'_ANALYSIS_NAME'} = $ANALYSIS_NAME;\n    return $self;\n}\n\n=head2        compartment\n\n name        : compartment\n usage       : $elm->compartment(['golgi', 'er']);\n purpose     : get/setter for cell compartment specifications\n arguments   : None, single compartment string or ref to array of\n               compartment names.\n returns     : Array of compartment names (default if not previously set).","parameters":[{"label":"$self"},{"label":"$arg"}],"label":"compartment($self,$arg)"},"kind":12,"range":{"start":{"line":178,"character":0},"end":{"line":198,"character":9999}},"line":178},{"line":199,"containerName":null,"kind":13,"name":"%self"},{"line":199,"name":"%self","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$self","line":200},{"line":200,"containerName":"main::","kind":12,"name":"input_spec"},{"children":[{"kind":13,"localvar":"my","containerName":"species","name":"$self","line":215,"definition":"my"},{"containerName":"species","kind":13,"name":"$arg","line":215},{"line":217,"name":"$arg","containerName":"species","kind":13},{"name":"$arg","containerName":"species","kind":13,"line":218},{"name":"$arg","kind":13,"containerName":"species","line":218},{"kind":12,"containerName":"species","name":"isa","line":218},{"name":"$self","kind":13,"containerName":"species","line":219},{"name":"$arg","kind":13,"containerName":"species","line":219},{"name":"ncbi_taxid","containerName":"species","kind":12,"line":219},{"line":220,"kind":13,"containerName":"species","name":"$arg"},{"name":"$self","containerName":"species","kind":13,"line":221},{"containerName":"species","kind":13,"name":"$arg","line":221},{"kind":13,"containerName":"species","name":"$self","line":223},{"line":223,"kind":12,"containerName":"species","name":"warn"},{"line":227,"containerName":"species","kind":13,"name":"$self"},{"line":227,"name":"$self","containerName":"species","kind":13},{"containerName":"species","kind":13,"name":"$self","line":228},{"line":228,"containerName":"species","kind":12,"name":"input_spec"}],"containerName":"main::","name":"species","definition":"sub","detail":"($self,$arg)","line":214,"range":{"end":{"character":9999,"line":230},"start":{"line":214,"character":0}},"kind":12,"signature":{"label":"species($self,$arg)","documentation":"1;\n# $Id: ELM.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Analysis::Protein::ELM\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Adams <richard.adams@ed.ac.uk>\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1     NAME\n\nBio::Tools::Analysis::Protein::ELM - a wrapper around the ELM server which predicts short functional motifs on amino acid sequences\n\n=head1     SYNOPSIS\n\n  # get a Bio::Seq object to start with, or a Bio::PrimaryI object.\n\n  my $tool = Bio::Tools::Analysis::Protein::ELM->\n      new(seq => $seqobj->primary_seq() );\t\n  $tool->compartment(['ER', 'Golgi']);\n  $tool->species(9606);\n  $tool->run;\n  my @fts = $tool->Result('Bio::SeqFeatureI');\n  $seqobj->addSeqFeature(@fts);\n\n=head1    DESCRIPTION\n\nThis module is a wrapper around the ELM server L<http://elm.eu.org/>\nwhich predicts short functional motifs on amino acid sequences. \n\nFalse positives can be limited by providing values for the species\nand cellular compartment of the protein. To set the species attribute,\nuse either a L<Bio::Species> object or an NCBI taxon ID number.  To set\nthe cell compartment attribute (any number of compartments can be\nchosen) use an array reference to a list of compartment names.\n\nResults can be obtained either as raw text output, parsed into a\ndata structure, or as Bio::SeqFeature::Generic objects.\n\n=head1 SEE ALSO\n\nL<Bio::SimpleAnalysisI>, \nL<Bio::WebAgent>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk, \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\nuse strict;\npackage Bio::Tools::Analysis::Protein::ELM;\nuse vars qw(%cc);\nuse HTML::HeadParser;\nuse Bio::SeqFeature::Generic;\nuse HTTP::Request::Common qw(POST);\nuse IO::String;\nuse base qw(Bio::Tools::Analysis::SimpleAnalysisBase);\n\n## valid cell compartments ##\n%cc = (\n      all            => 1,\n      nucleus        => 'GO:0005634',\n      extracellular  => 'GO:0005576',\n      cytoplasm      => 'GO:0005737',\n      peroxisome     => 'GO:0005777',\n      glycosome      => 'GO:0020015',\n      glyoxisome     => 'GO:0009514',\n      golgi          => 'GO:0005794',\n      er             => 'GO:0005783',\n      lysosome       => 'GO:0005764',\n      endosome       => 'GO:0005768',\n      plasma_membrane=> 'GO:0005886',\n\t\t);\n\nmy $URL           = 'http://elm.eu.org/basicELM/cgimodel.py';\nmy $ANALYSIS_NAME = 'ELM';\nmy $INPUT_SPEC    =\n    [\n     {\n      'mandatory' => 'true',\n      'type'      => 'Bio::PrimarySeqI',\n      'name'      => 'seq',\n     },\n     {\n      'mandatory' => 'false',\n      'type'      => 'taxon_id or Bio::Species object',\n      'name'      => 'species',\n      'default'   => '9606',\n     },\n     {\n      'mandatory' => 'false',\n      'type'      => 'string',\n      'name'      => 'compartment',\n      'default'   => [1],\n     },\n    ];\n\nmy  $RESULT_SPEC =\n    {\n     ''                 => 'bulk',              # same as undef\n     'Bio::SeqFeatureI' => 'ARRAY of Bio::SeqFeature::Generic',\n     'parsed'           => '{motif1_name=>{locus=>[],\n\t\t\t\t\t   peptide=>[],\n\t\t\t\t\t   regexp=>[]\n\t\t\t\t\t  },\n\t\t\t    }',\n    };\nmy $ANALYSIS_SPEC= {name        => 'ELM',\n\t\t\t\t    type        => 'Protein',\n                    version     => 'n/a',\n                    supplier    =>'BioComputing Unit, EMBL',\n\t\t\t\t\tdescription =>'Prediction of linear functional motifs\n                                  in proteins',\n\t\t\t\t\treference   => 'NAR, 31:3625-3630'};\n\n\nsub _init {\n    my $self = shift;\n    $self->url($URL);\n    $self->{'_ANALYSIS_SPEC'} = $ANALYSIS_SPEC;\n    $self->{'_INPUT_SPEC'}    = $INPUT_SPEC;\n    $self->{'_RESULT_SPEC'}   = $RESULT_SPEC;\n    $self->{'_ANALYSIS_NAME'} = $ANALYSIS_NAME;\n    return $self;\n}\n\n=head2        compartment\n\n name        : compartment\n usage       : $elm->compartment(['golgi', 'er']);\n purpose     : get/setter for cell compartment specifications\n arguments   : None, single compartment string or ref to array of\n               compartment names.\n returns     : Array of compartment names (default if not previously set).\n\n\nsub compartment {\n\n    my ($self, $arg) = @_;\n    if ($arg) {\n\n        # convert to array ref if not one already\n\tif (ref ($arg) ne 'ARRAY') {\n            $arg = [$arg];\n\t}\n \n        ## now add params if valid\n\tfor my $param (@$arg) {\n            if (exists($cc{lc($param)})) {\n                push @{$self->{'_compartment'}} , $cc{$param};\n            } else {\n                $self->warn(\"invalid argument ! Must be one of \" .\n                            join \"\\n\", keys %cc );\n            }\n        }                       #end of for loop\n\t\t\t\n    }                           #endif $arg\n    return defined($self->{'_compartment'})? $self->{'_compartment'}\n        : $self->input_spec()->[2]{'default'};\n\n}\n\n=head1      species\n\n name      : species\n usage     : $tool->species('9606');\n purpose   : get/setter for species selction for ELM server\n arguments : none, taxon_id or Bio::Species object\n returns   : a string of the ncbi taxon_id","parameters":[{"label":"$self"},{"label":"$arg"}]}},{"range":{"end":{"line":244,"character":9999},"start":{"character":0,"line":232}},"kind":12,"line":232,"definition":"sub","containerName":"main::","name":"_run","children":[{"definition":"my","line":233,"name":"$self","containerName":"_run","localvar":"my","kind":13},{"containerName":"_run","kind":13,"name":"$self","line":234},{"containerName":"_run","kind":12,"name":"delay","line":234},{"line":237,"name":"$self","containerName":"_run","kind":13},{"kind":12,"containerName":"_run","name":"status","line":237},{"localvar":"my","kind":13,"containerName":"_run","name":"@cc_str","line":243,"definition":"my"},{"name":"@cmpts","localvar":"my","kind":13,"containerName":"_run","line":244,"definition":"my"},{"line":244,"name":"$self","containerName":"_run","kind":13},{"line":244,"name":"compartment","containerName":"_run","kind":12}]},{"definition":"my","name":"$i","localvar":"my","containerName":null,"kind":13,"line":245},{"line":245,"containerName":null,"kind":13,"name":"$i"},{"name":"cmpts","kind":12,"line":245},{"containerName":null,"kind":13,"name":"%i","line":245},{"containerName":null,"kind":13,"name":"@cc_str","line":246},{"line":246,"containerName":null,"kind":13,"name":"@cc_str"},{"line":246,"containerName":null,"kind":13,"name":"@cmpts"},{"kind":13,"containerName":null,"name":"$i","line":246},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"%h","line":248},{"kind":12,"name":"swissprotId","line":248},{"kind":12,"name":"sequence","line":249},{"line":249,"name":"$self","containerName":null,"kind":13},{"line":249,"name":"seq","containerName":"main::","kind":12},{"line":249,"kind":12,"containerName":"main::","name":"seq"},{"kind":12,"name":"userSpecies","line":250},{"line":250,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","kind":12,"name":"species","line":250},{"name":"typedUserSpecies","kind":12,"line":251},{"kind":12,"name":"fun","line":252},{"name":"@cc_str","kind":13,"containerName":null,"line":253},{"line":253,"containerName":null,"kind":13,"name":"@cc_str"},{"name":"%h","kind":13,"containerName":null,"line":253},{"containerName":null,"kind":13,"name":"%h","line":253},{"localvar":"my","kind":13,"containerName":null,"name":"$request","line":256,"definition":"my"},{"kind":12,"name":"POST","line":256},{"line":256,"containerName":null,"kind":13,"name":"$self"},{"line":256,"name":"url","kind":12,"containerName":"main::"},{"kind":12,"name":"Content_Type","line":257},{"line":258,"kind":12,"name":"Content"},{"name":"@cc_str","kind":13,"containerName":null,"line":258},{"line":259,"name":"$self","containerName":null,"kind":13},{"name":"debug","containerName":"main::","kind":12,"line":259},{"line":259,"name":"$request","containerName":null,"kind":13},{"containerName":"main::","kind":12,"name":"as_string","line":259},{"definition":"my","name":"$r1","localvar":"my","containerName":null,"kind":13,"line":260},{"name":"$self","kind":13,"containerName":null,"line":260},{"kind":12,"containerName":"main::","name":"request","line":260},{"kind":13,"containerName":null,"name":"$request","line":260},{"line":261,"containerName":null,"kind":13,"name":"$r1"},{"line":261,"name":"is_error","kind":12,"containerName":"main::"},{"name":"$self","containerName":null,"kind":13,"line":262},{"line":262,"name":"warn","kind":12,"containerName":"main::"},{"name":"$self","containerName":null,"kind":13,"line":262},{"name":"$r1","containerName":null,"kind":13,"line":262},{"name":"as_string","containerName":"main::","kind":12,"line":262},{"definition":"my","line":266,"name":"$text","localvar":"my","containerName":null,"kind":13},{"line":266,"containerName":null,"kind":13,"name":"$r1"},{"kind":12,"containerName":"main::","name":"content","line":266},{"definition":"my","line":267,"localvar":"my","containerName":null,"kind":13,"name":"$url"},{"line":267,"name":"$text","containerName":null,"kind":13},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$resp2","line":269},{"name":"$url","kind":13,"containerName":null,"line":270},{"kind":13,"containerName":null,"name":"$URL","line":270},{"line":270,"name":"%url","kind":13,"containerName":null},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$req2","line":272},{"line":272,"kind":12,"containerName":"Request","name":"HTTP"},{"containerName":"main::","kind":12,"name":"new","line":272},{"line":272,"kind":12,"name":"GET"},{"name":"$url","kind":13,"containerName":null,"line":272},{"definition":"my","line":273,"containerName":null,"localvar":"my","kind":13,"name":"$r2"},{"name":"$self","kind":13,"containerName":null,"line":273},{"name":"request","containerName":"main::","kind":12,"line":273},{"line":273,"name":"$req2","kind":13,"containerName":null},{"line":274,"containerName":null,"kind":13,"name":"$r2"},{"kind":12,"containerName":"main::","name":"is_error","line":274},{"containerName":null,"kind":13,"name":"$self","line":275},{"name":"warn","containerName":"main::","kind":12,"line":275},{"line":275,"containerName":null,"kind":13,"name":"$self"},{"name":"$r2","containerName":null,"kind":13,"line":275},{"containerName":"main::","kind":12,"name":"as_string","line":275},{"name":"$resp2","containerName":null,"kind":13,"line":278},{"line":278,"containerName":null,"kind":13,"name":"$r2"},{"name":"content","kind":12,"containerName":"main::","line":278},{"line":280,"name":"%resp2","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$self","line":281},{"line":281,"name":"status","containerName":"main::","kind":12},{"line":282,"name":"$resp2","containerName":null,"kind":13},{"name":"%self","kind":13,"containerName":null,"line":283},{"name":"%resp2","kind":13,"containerName":null,"line":283},{"line":286,"name":"$self","containerName":null,"kind":13},{"line":286,"kind":12,"containerName":"main::","name":"verbose"},{"name":"$self","containerName":null,"kind":13,"line":287},{"name":"sleep","kind":12,"containerName":"main::","line":287},{"signature":{"label":"result($self,$val)","parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: ELM.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Analysis::Protein::ELM\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Adams <richard.adams@ed.ac.uk>\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1     NAME\n\nBio::Tools::Analysis::Protein::ELM - a wrapper around the ELM server which predicts short functional motifs on amino acid sequences\n\n=head1     SYNOPSIS\n\n  # get a Bio::Seq object to start with, or a Bio::PrimaryI object.\n\n  my $tool = Bio::Tools::Analysis::Protein::ELM->\n      new(seq => $seqobj->primary_seq() );\t\n  $tool->compartment(['ER', 'Golgi']);\n  $tool->species(9606);\n  $tool->run;\n  my @fts = $tool->Result('Bio::SeqFeatureI');\n  $seqobj->addSeqFeature(@fts);\n\n=head1    DESCRIPTION\n\nThis module is a wrapper around the ELM server L<http://elm.eu.org/>\nwhich predicts short functional motifs on amino acid sequences. \n\nFalse positives can be limited by providing values for the species\nand cellular compartment of the protein. To set the species attribute,\nuse either a L<Bio::Species> object or an NCBI taxon ID number.  To set\nthe cell compartment attribute (any number of compartments can be\nchosen) use an array reference to a list of compartment names.\n\nResults can be obtained either as raw text output, parsed into a\ndata structure, or as Bio::SeqFeature::Generic objects.\n\n=head1 SEE ALSO\n\nL<Bio::SimpleAnalysisI>, \nL<Bio::WebAgent>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk, \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\nuse strict;\npackage Bio::Tools::Analysis::Protein::ELM;\nuse vars qw(%cc);\nuse HTML::HeadParser;\nuse Bio::SeqFeature::Generic;\nuse HTTP::Request::Common qw(POST);\nuse IO::String;\nuse base qw(Bio::Tools::Analysis::SimpleAnalysisBase);\n\n## valid cell compartments ##\n%cc = (\n      all            => 1,\n      nucleus        => 'GO:0005634',\n      extracellular  => 'GO:0005576',\n      cytoplasm      => 'GO:0005737',\n      peroxisome     => 'GO:0005777',\n      glycosome      => 'GO:0020015',\n      glyoxisome     => 'GO:0009514',\n      golgi          => 'GO:0005794',\n      er             => 'GO:0005783',\n      lysosome       => 'GO:0005764',\n      endosome       => 'GO:0005768',\n      plasma_membrane=> 'GO:0005886',\n\t\t);\n\nmy $URL           = 'http://elm.eu.org/basicELM/cgimodel.py';\nmy $ANALYSIS_NAME = 'ELM';\nmy $INPUT_SPEC    =\n    [\n     {\n      'mandatory' => 'true',\n      'type'      => 'Bio::PrimarySeqI',\n      'name'      => 'seq',\n     },\n     {\n      'mandatory' => 'false',\n      'type'      => 'taxon_id or Bio::Species object',\n      'name'      => 'species',\n      'default'   => '9606',\n     },\n     {\n      'mandatory' => 'false',\n      'type'      => 'string',\n      'name'      => 'compartment',\n      'default'   => [1],\n     },\n    ];\n\nmy  $RESULT_SPEC =\n    {\n     ''                 => 'bulk',              # same as undef\n     'Bio::SeqFeatureI' => 'ARRAY of Bio::SeqFeature::Generic',\n     'parsed'           => '{motif1_name=>{locus=>[],\n\t\t\t\t\t   peptide=>[],\n\t\t\t\t\t   regexp=>[]\n\t\t\t\t\t  },\n\t\t\t    }',\n    };\nmy $ANALYSIS_SPEC= {name        => 'ELM',\n\t\t\t\t    type        => 'Protein',\n                    version     => 'n/a',\n                    supplier    =>'BioComputing Unit, EMBL',\n\t\t\t\t\tdescription =>'Prediction of linear functional motifs\n                                  in proteins',\n\t\t\t\t\treference   => 'NAR, 31:3625-3630'};\n\n\nsub _init {\n    my $self = shift;\n    $self->url($URL);\n    $self->{'_ANALYSIS_SPEC'} = $ANALYSIS_SPEC;\n    $self->{'_INPUT_SPEC'}    = $INPUT_SPEC;\n    $self->{'_RESULT_SPEC'}   = $RESULT_SPEC;\n    $self->{'_ANALYSIS_NAME'} = $ANALYSIS_NAME;\n    return $self;\n}\n\n=head2        compartment\n\n name        : compartment\n usage       : $elm->compartment(['golgi', 'er']);\n purpose     : get/setter for cell compartment specifications\n arguments   : None, single compartment string or ref to array of\n               compartment names.\n returns     : Array of compartment names (default if not previously set).\n\n\nsub compartment {\n\n    my ($self, $arg) = @_;\n    if ($arg) {\n\n        # convert to array ref if not one already\n\tif (ref ($arg) ne 'ARRAY') {\n            $arg = [$arg];\n\t}\n \n        ## now add params if valid\n\tfor my $param (@$arg) {\n            if (exists($cc{lc($param)})) {\n                push @{$self->{'_compartment'}} , $cc{$param};\n            } else {\n                $self->warn(\"invalid argument ! Must be one of \" .\n                            join \"\\n\", keys %cc );\n            }\n        }                       #end of for loop\n\t\t\t\n    }                           #endif $arg\n    return defined($self->{'_compartment'})? $self->{'_compartment'}\n        : $self->input_spec()->[2]{'default'};\n\n}\n\n=head1      species\n\n name      : species\n usage     : $tool->species('9606');\n purpose   : get/setter for species selction for ELM server\n arguments : none, taxon_id or Bio::Species object\n returns   : a string of the ncbi taxon_id\n\n\nsub species {\n    my ($self, $arg) = @_;\n\n    if ($arg) {\n        if (ref($arg) && $arg->isa('Bio::Species')) {\n            $self->{'_species'} = $arg->ncbi_taxid();\n        } elsif ($arg =~ /^\\d+$/) {\n            $self->{'_species'} = $arg;\n        } else {\n            $self->warn(\"Argument must be a Bio::Species object or \". \n                        \" an integer NCBI taxon id. \");\n        }\n    }                           #end if $arg\n    return defined($self->{'_species'})?$self->{'_species'}\n        :$self->input_spec()->[1]{'default'};\n\t\n}\n\nsub  _run {\n    my $self  = shift;\n    $self->delay(1);\n    # delay repeated calls by default by 3 sec, set delay() to change\n    #$self->sleep;\n    $self->status('TERMINATED_BY_ERROR');\n\t\n    #### this deals with being able to submit multiple checkboxed\n    #### slections\n\n    #1st of all make param array\n    my @cc_str;\n    my @cmpts = @{$self->compartment()};\n    for (my $i = 0; $i <= $#cmpts ; $i++) {\n        splice @cc_str, @cc_str, 0,   'userCC',$cmpts[$i];\n    }\n    my %h = (swissprotId      => \"\",\n             sequence         => $self->seq->seq,\n             userSpecies      => $self->species,\n             typedUserSpecies => '',\n             fun              => \"Submit\");\n    splice (@cc_str, @cc_str,0, ( map{$_, $h{$_}} keys %h));\n\n\t\t\n    my $request = POST $self->url(),\n        Content_Type => 'form-data',\n            Content  => \\@cc_str;\n    $self->debug( $request->as_string);\n    my $r1 = $self->request($request);\n    if ( $r1->is_error  ) {\n\t$self->warn(ref($self).\" Request Error:\\n\".$r1->as_string);\n\treturn;\n    }\n\n    my $text = $r1->content;\n    my ($url) = $text =~ /URL=\\S+(fun=\\S+r=\\d)/s; \n    #$url =~ s/amp;//g ;\n    my ($resp2);\n    $url = $URL . \"?\" .$url;\n    while (1) {\n\tmy $req2 = HTTP::Request->new(GET=>$url);\n\tmy $r2 = $self->request ($req2);\n\tif ( $r2->is_error ) {\n\t    $self->warn(ref($self).\" Request Error:\\n\".$r2->as_string);\t    \n\t    return;\n\t} \n\t$resp2 = $r2->content();\n\t\n\tif ($resp2 !~ /patient/s) {\n\t    $self->status('COMPLETED');\n\t    $resp2=~ s/<[^>]+>/ /sg;\n            $self->{'_result'} = $resp2;\n\t    return;\n\t} else {\n\t    print \".\" if $self->verbose > 0;\n\t    $self->sleep(1);\n\t}\n    }\n}\n\n=head1      result\n\n name      : result\n usage     : $tool->result('Bio::SeqFeatureI');\n purpose   : parse results into sequence features or basic data format\n arguments : 1. none    (retrieves raw text without html)\n             2. a value (retrieves data structure)\n             3. 'Bio::SeqFeatureI' (returns array of sequence features)\n                tag names are : {method => 'ELM', motif => motifname,\n                                 peptide => seqeunce of match,\n                                 concensus => regexp of match}.\n returns   : see arguments. "},"line":307,"kind":12,"range":{"start":{"line":307,"character":0},"end":{"character":9999,"line":333}},"definition":"sub","detail":"($self,$val)","children":[{"name":"$self","localvar":"my","containerName":"result","kind":13,"line":308,"definition":"my"},{"name":"$val","kind":13,"containerName":"result","line":308},{"line":309,"containerName":"result","kind":13,"name":"$val"},{"line":310,"name":"$self","containerName":"result","kind":13},{"containerName":"result","kind":13,"name":"$self","line":311},{"line":311,"name":"_parse_raw","kind":12,"containerName":"result"},{"line":313,"name":"$val","kind":13,"containerName":"result"},{"definition":"my","line":314,"name":"@fts","localvar":"my","kind":13,"containerName":"result"},{"name":"$motif","localvar":"my","kind":13,"containerName":"result","line":315,"definition":"my"},{"line":315,"kind":13,"containerName":"result","name":"$self"},{"name":"$i","localvar":"my","containerName":"result","kind":13,"line":316,"definition":"my"},{"line":316,"name":"$i","containerName":"result","kind":13},{"line":316,"name":"$self","containerName":"result","kind":13},{"name":"$motif","containerName":"result","kind":13,"line":316},{"name":"$i","containerName":"result","kind":13,"line":316},{"definition":"my","line":317,"name":"$st","localvar":"my","kind":13,"containerName":"result"},{"line":317,"name":"$end","containerName":"result","kind":13},{"containerName":"result","kind":13,"name":"$self","line":317},{"name":"$motif","containerName":"result","kind":13,"line":317},{"name":"$i","kind":13,"containerName":"result","line":317},{"kind":13,"containerName":"result","name":"@fts","line":318},{"line":318,"kind":12,"containerName":"result","name":"new"},{"line":320,"name":"$st","containerName":"result","kind":13},{"line":321,"containerName":"result","kind":13,"name":"$end"},{"name":"$motif","kind":13,"containerName":"result","line":326},{"line":327,"name":"$self","kind":13,"containerName":"result"},{"kind":13,"containerName":"result","name":"$motif","line":327},{"line":327,"name":"$i","containerName":"result","kind":13},{"kind":13,"containerName":"result","name":"$self","line":328},{"line":328,"containerName":"result","kind":13,"name":"$motif"},{"line":332,"name":"@fts","kind":13,"containerName":"result"}],"containerName":"main::","name":"result"},{"line":318,"name":"Bio","kind":12,"containerName":"SeqFeature::Generic"},{"line":325,"name":"method","kind":12},{"line":326,"name":"motif","kind":12},{"kind":12,"name":"peptide","line":327},{"kind":12,"name":"concensus","line":328},{"kind":13,"containerName":null,"name":"%self","line":334},{"line":336,"kind":13,"containerName":null,"name":"%self"},{"name":"_parse_raw","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"_parse_raw","line":341,"definition":"my"},{"line":342,"containerName":"_parse_raw","localvar":"my","kind":13,"name":"$result","definition":"my"},{"line":342,"name":"new","containerName":"_parse_raw","kind":12},{"name":"$self","containerName":"_parse_raw","kind":13,"line":342},{"definition":"my","kind":13,"localvar":"my","containerName":"_parse_raw","name":"$in_results","line":343},{"definition":"my","kind":13,"localvar":"my","containerName":"_parse_raw","name":"$name","line":344},{"line":345,"name":"%results","localvar":"my","containerName":"_parse_raw","kind":13,"definition":"my"},{"definition":"my","name":"$last","localvar":"my","containerName":"_parse_raw","kind":13,"line":346},{"definition":"my","localvar":"my","kind":13,"containerName":"_parse_raw","name":"$l","line":347},{"line":347,"name":"$result","kind":13,"containerName":"_parse_raw"},{"line":348,"name":"$in_results","kind":13,"containerName":"_parse_raw"},{"line":348,"name":"$l","kind":13,"containerName":"_parse_raw"},{"containerName":"_parse_raw","kind":13,"name":"$in_results","line":349},{"containerName":"_parse_raw","kind":13,"name":"$l","line":350},{"name":"$in_results","containerName":"_parse_raw","kind":13,"line":351},{"definition":"my","line":353,"localvar":"my","kind":13,"containerName":"_parse_raw","name":"@line_parts"},{"containerName":"_parse_raw","kind":13,"name":"$l","line":353},{"name":"@line_parts","containerName":"_parse_raw","kind":13,"line":354},{"containerName":"_parse_raw","kind":13,"name":"@line_parts","line":356},{"line":356,"name":"$line_parts","containerName":"_parse_raw","kind":13},{"kind":13,"containerName":"_parse_raw","name":"$name","line":357},{"name":"@line_parts","kind":13,"containerName":"_parse_raw","line":361},{"definition":"my","line":362,"localvar":"my","kind":13,"containerName":"_parse_raw","name":"$index"},{"definition":"my","line":363,"name":"$read_loci","localvar":"my","kind":13,"containerName":"_parse_raw"},{"name":"$index","kind":13,"containerName":"_parse_raw","line":364},{"definition":"my","line":365,"name":"$word","localvar":"my","containerName":"_parse_raw","kind":13},{"line":365,"name":"$line_parts","containerName":"_parse_raw","kind":13},{"line":365,"name":"$index","containerName":"_parse_raw","kind":13},{"line":366,"name":"$read_loci","containerName":"_parse_raw","kind":13},{"line":366,"containerName":"_parse_raw","kind":13,"name":"$word"},{"name":"$name","kind":13,"containerName":"_parse_raw","line":367},{"line":367,"containerName":"_parse_raw","kind":13,"name":"$word"},{"name":"$read_loci","containerName":"_parse_raw","kind":13,"line":368},{"line":368,"name":"$word","containerName":"_parse_raw","kind":13},{"containerName":"_parse_raw","kind":13,"name":"$results","line":369},{"kind":13,"containerName":"_parse_raw","name":"$name","line":369},{"name":"$word","kind":13,"containerName":"_parse_raw","line":369},{"line":370,"name":"$word","kind":13,"containerName":"_parse_raw"},{"name":"$read_loci","kind":13,"containerName":"_parse_raw","line":371},{"line":372,"containerName":"_parse_raw","kind":13,"name":"$results"},{"name":"$name","containerName":"_parse_raw","kind":13,"line":372},{"line":372,"kind":13,"containerName":"_parse_raw","name":"$word"},{"line":377,"name":"$results","kind":13,"containerName":"_parse_raw"},{"line":377,"name":"$name","kind":13,"containerName":"_parse_raw"}],"definition":"sub","kind":12,"range":{"start":{"line":340,"character":0},"end":{"line":377,"character":9999}},"line":340},{"kind":12,"containerName":"String","name":"IO","line":342},{"name":"line_parts","kind":12,"line":364},{"name":"@line_parts","kind":13,"containerName":null,"line":377},{"name":"line_parts","kind":12,"line":377},{"kind":13,"containerName":null,"name":"%self","line":382},{"line":382,"name":"%results","kind":13,"containerName":null}],"version":5}