{"vars":[{"containerName":"strict::Bio::DB::Taxonomy::Bio::Tree::Tree::Scalar","kind":2,"name":"Util","line":103},{"name":"base","kind":2,"containerName":"","line":104},{"kind":12,"range":{"start":{"character":0,"line":117},"end":{"line":128,"character":9999}},"line":117,"signature":{"documentation":"1;\n# $Id: Species.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Species\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by James Gilbert <jgrg@sanger.ac.uk>\n# Reimplemented by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Species - Generic species object\n\n=head1 SYNOPSIS\n\n    $species = Bio::Species->new(-classification => [@classification]);\n                                    # Can also pass classification\n                                    # array to new as below\n\n    $species->classification(qw( sapiens Homo Hominidae\n                                 Catarrhini Primates Eutheria\n                                 Mammalia Vertebrata Chordata\n                                 Metazoa Eukaryota ));\n\n    $genus = $species->genus();\n\n    $bi = $species->binomial();     # $bi is now \"Homo sapiens\"\n\n    # For storing common name\n    $species->common_name(\"human\");\n\n    # For storing subspecies\n    $species->sub_species(\"accountant\");\n\n=head1 DESCRIPTION\n\nProvides a very simple object for storing phylogenetic\ninformation.  The classification is stored in an array,\nwhich is a list of nodes in a phylogenetic tree.  Access to\ngetting and setting species and genus is provided, but not\nto any of the other node types (eg: \"phylum\", \"class\",\n\"order\", \"family\").  There's plenty of scope for making the\nmodel more sophisticated, if this is ever needed.\n\nA methods are also provided for storing common\nnames, and subspecies.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nJames Gilbert email B<jgrg@sanger.ac.uk>\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' Let the code begin...\n\npackage Bio::Species;\nuse strict;\n\nuse Bio::DB::Taxonomy;\nuse Bio::Tree::Tree;\nuse Scalar::Util qw(weaken isweak);\nuse base qw(Bio::Taxon);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Species->new(-classification => \\@class)\n Function: Build a new Species object\n Returns : Bio::Species object\n Args    : -ncbi_taxid     => NCBI taxonomic ID (optional)\n           -classification => arrayref of classification","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"containerName":"main::","name":"new","children":[{"definition":"my","line":118,"name":"$class","localvar":"my","containerName":"new","kind":13},{"line":118,"kind":13,"containerName":"new","name":"@args"},{"line":120,"name":"$self","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"line":120,"name":"$class","containerName":"new","kind":13},{"line":120,"kind":13,"containerName":"new","name":"@args"},{"line":122,"name":"$org","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"name":"$sp","kind":13,"containerName":"new","line":122},{"line":122,"containerName":"new","kind":13,"name":"$var"},{"line":122,"kind":13,"containerName":"new","name":"$classification"},{"line":123,"name":"$self","kind":13,"containerName":"new"},{"containerName":"new","kind":12,"name":"_rearrange","line":123},{"kind":13,"containerName":"new","name":"@args","line":126},{"line":128,"name":"$classification","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$classification","line":128},{"name":"$classification","kind":13,"containerName":"new","line":128}],"detail":"($class,@args)","definition":"sub"},{"kind":12,"containerName":"new","name":"SUPER","line":120},{"name":"$self","kind":13,"containerName":null,"line":129},{"line":129,"name":"classification","kind":12,"containerName":"main::"},{"containerName":null,"kind":13,"name":"%classification","line":129},{"name":"%self","kind":13,"containerName":null,"line":133},{"kind":12,"name":"tree","line":133},{"line":133,"kind":12,"containerName":"Tree::Tree","name":"Bio"},{"line":133,"kind":12,"containerName":"main::","name":"new"},{"line":140,"containerName":null,"kind":13,"name":"$org"},{"line":140,"containerName":null,"kind":13,"name":"$self"},{"kind":12,"containerName":"main::","name":"organelle","line":140},{"name":"$org","containerName":null,"kind":13,"line":140},{"line":141,"containerName":null,"kind":13,"name":"$sp"},{"kind":13,"containerName":null,"name":"$self","line":141},{"containerName":"main::","kind":12,"name":"sub_species","line":141},{"line":141,"name":"$sp","kind":13,"containerName":null},{"line":142,"name":"$var","containerName":null,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":142},{"name":"variant","kind":12,"containerName":"main::","line":142},{"name":"$var","containerName":null,"kind":13,"line":142},{"line":144,"containerName":null,"kind":13,"name":"$self"},{"definition":"sub","detail":"($self,@vals)","children":[{"line":168,"name":"$self","localvar":"my","kind":13,"containerName":"classification","definition":"my"},{"name":"@vals","kind":13,"containerName":"classification","line":168},{"line":170,"name":"@vals","kind":13,"containerName":"classification"},{"containerName":"classification","kind":13,"name":"$vals","line":171},{"name":"@vals","kind":13,"containerName":"classification","line":172},{"line":172,"name":"$vals","containerName":"classification","kind":13},{"definition":"my","line":177,"kind":13,"localvar":"my","containerName":"classification","name":"$name"},{"line":177,"containerName":"classification","kind":13,"name":"$self"},{"line":177,"name":"node_name","containerName":"classification","kind":12},{"name":"$genus","localvar":"my","kind":13,"containerName":"classification","line":178,"definition":"my"},{"line":178,"name":"$species","containerName":"classification","kind":13},{"line":178,"containerName":"classification","kind":13,"name":"$vals"},{"name":"$vals","containerName":"classification","kind":13,"line":178},{"containerName":"classification","kind":13,"name":"$name","line":179},{"line":179,"containerName":"classification","kind":13,"name":"$name"},{"kind":13,"containerName":"classification","name":"$name","line":179},{"line":179,"name":"$name","kind":13,"containerName":"classification"},{"kind":13,"containerName":"classification","name":"$name","line":180},{"containerName":"classification","kind":13,"name":"$self","line":183},{"kind":12,"containerName":"classification","name":"sub_species","line":183},{"containerName":"classification","kind":13,"name":"$name","line":184},{"line":184,"name":"$self","containerName":"classification","kind":13},{"name":"node_name","containerName":"classification","kind":12,"line":184},{"line":187,"name":"$self","kind":13,"containerName":"classification"},{"name":"warn","kind":12,"containerName":"classification","line":187},{"containerName":"classification","kind":13,"name":"@vals","line":187},{"definition":"my","line":192,"containerName":"classification","localvar":"my","kind":13,"name":"$db"},{"name":"new","containerName":"classification","kind":12,"line":192},{"line":192,"name":"@vals","containerName":"classification","kind":13},{"kind":13,"containerName":"classification","name":"$self","line":193},{"kind":12,"containerName":"classification","name":"scientific_name","line":193},{"name":"$self","containerName":"classification","kind":13,"line":195},{"name":"scientific_name","containerName":"classification","kind":12,"line":195},{"line":195,"name":"$vals","kind":13,"containerName":"classification"},{"kind":13,"containerName":"classification","name":"$self","line":197},{"containerName":"classification","kind":12,"name":"rank","line":197},{"containerName":"classification","kind":13,"name":"$self","line":199},{"line":199,"kind":12,"containerName":"classification","name":"rank"},{"kind":13,"containerName":"classification","name":"$self","line":202},{"kind":12,"containerName":"classification","name":"db_handle","line":202},{"kind":13,"containerName":"classification","name":"$db","line":202},{"line":204,"name":"$self","kind":13,"containerName":"classification"},{"name":"new","kind":12,"containerName":"classification","line":204},{"containerName":"classification","kind":13,"name":"$self","line":204},{"kind":13,"containerName":"classification","name":"$self","line":210}],"containerName":"main::","name":"classification","signature":{"label":"classification($self,@vals)","parameters":[{"label":"$self"},{"label":"@vals"}],"documentation":"1;\n# $Id: Species.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Species\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by James Gilbert <jgrg@sanger.ac.uk>\n# Reimplemented by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Species - Generic species object\n\n=head1 SYNOPSIS\n\n    $species = Bio::Species->new(-classification => [@classification]);\n                                    # Can also pass classification\n                                    # array to new as below\n\n    $species->classification(qw( sapiens Homo Hominidae\n                                 Catarrhini Primates Eutheria\n                                 Mammalia Vertebrata Chordata\n                                 Metazoa Eukaryota ));\n\n    $genus = $species->genus();\n\n    $bi = $species->binomial();     # $bi is now \"Homo sapiens\"\n\n    # For storing common name\n    $species->common_name(\"human\");\n\n    # For storing subspecies\n    $species->sub_species(\"accountant\");\n\n=head1 DESCRIPTION\n\nProvides a very simple object for storing phylogenetic\ninformation.  The classification is stored in an array,\nwhich is a list of nodes in a phylogenetic tree.  Access to\ngetting and setting species and genus is provided, but not\nto any of the other node types (eg: \"phylum\", \"class\",\n\"order\", \"family\").  There's plenty of scope for making the\nmodel more sophisticated, if this is ever needed.\n\nA methods are also provided for storing common\nnames, and subspecies.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nJames Gilbert email B<jgrg@sanger.ac.uk>\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' Let the code begin...\n\npackage Bio::Species;\nuse strict;\n\nuse Bio::DB::Taxonomy;\nuse Bio::Tree::Tree;\nuse Scalar::Util qw(weaken isweak);\nuse base qw(Bio::Taxon);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Species->new(-classification => \\@class)\n Function: Build a new Species object\n Returns : Bio::Species object\n Args    : -ncbi_taxid     => NCBI taxonomic ID (optional)\n           -classification => arrayref of classification\n\n\nsub new {\n    my($class, @args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n    \n    my ($org, $sp, $var, $classification) =\n        $self->_rearrange([qw(ORGANELLE\n\t\t\t\t\t       SUB_SPECIES\n\t\t\t\t\t       VARIANT\n\t\t\t\t\t       CLASSIFICATION)], @args);\n    \n    if (defined $classification && ref($classification) eq \"ARRAY\" && @{$classification}) {\n        $self->classification(@$classification);\n    }\n    else {\n        # store a tree on ourselves so we can use Tree methods\n        $self->{tree} = Bio::Tree::Tree->new();\n        \n        # some things want to freeze/thaw Bio::Species objects, but\n        # _root_cleanup_methods contains a CODE ref, delete it.\n        # delete $self->{tree}->{_root_cleanup_methods};\n    }\n    \n    defined $org && $self->organelle($org);\n    defined $sp  && $self->sub_species($sp); \n    defined $var && $self->variant($var);\n    \n    return $self;\n}\n\n=head2 classification\n\n Title   : classification\n Usage   : $self->classification(@class_array);\n           @classification = $self->classification();\n Function: Get/set the lineage of this species. The array provided must be in\n           the order ... ---> SPECIES, GENUS ---> KINGDOM ---> etc.\n Example : $obj->classification(qw( 'Homo sapiens' Homo Hominidae\n           Catarrhini Primates Eutheria Mammalia Vertebrata\n           Chordata Metazoa Eukaryota));\n Returns : Classification array\n Args    : Classification array \n                 OR\n           A reference to the classification array. In the latter case\n           if there is a second argument and it evaluates to true,\n           names will not be validated. NB: in any case, names are never\n           validated anyway."},"line":167,"kind":12,"range":{"start":{"character":0,"line":167},"end":{"line":211,"character":9999}}},{"line":192,"kind":12,"containerName":"DB::Taxonomy","name":"Bio"},{"name":"tree","kind":12,"line":204},{"line":204,"kind":12,"containerName":"Tree::Tree","name":"Bio"},{"name":"tree","kind":12,"line":210},{"line":210,"name":"_root_cleanup_methods","kind":12},{"name":"@vals","containerName":null,"kind":13,"line":213},{"definition":"my","name":"$node","localvar":"my","containerName":null,"kind":13,"line":214},{"name":"%self","containerName":null,"kind":13,"line":214},{"line":214,"name":"tree","kind":12},{"name":"get_lineage_nodes","containerName":"main::","kind":12,"line":214},{"name":"$self","kind":13,"containerName":null,"line":214},{"line":214,"containerName":null,"kind":13,"name":"%self"},{"line":215,"kind":13,"containerName":null,"name":"@vals"},{"line":215,"name":"$node","kind":13,"containerName":null},{"line":215,"containerName":"main::","kind":12,"name":"scientific_name"},{"line":217,"kind":12,"name":"weaken"},{"line":217,"name":"%self","containerName":null,"kind":13},{"line":217,"name":"tree","kind":12},{"kind":12,"name":"isweak","line":217},{"line":217,"kind":13,"containerName":null,"name":"%self"},{"line":217,"name":"tree","kind":12},{"name":"@vals","kind":13,"containerName":null,"line":218},{"kind":12,"range":{"start":{"character":0,"line":265},"end":{"character":9999,"line":358}},"line":265,"signature":{"documentation":"1;\n# $Id: Species.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Species\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by James Gilbert <jgrg@sanger.ac.uk>\n# Reimplemented by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Species - Generic species object\n\n=head1 SYNOPSIS\n\n    $species = Bio::Species->new(-classification => [@classification]);\n                                    # Can also pass classification\n                                    # array to new as below\n\n    $species->classification(qw( sapiens Homo Hominidae\n                                 Catarrhini Primates Eutheria\n                                 Mammalia Vertebrata Chordata\n                                 Metazoa Eukaryota ));\n\n    $genus = $species->genus();\n\n    $bi = $species->binomial();     # $bi is now \"Homo sapiens\"\n\n    # For storing common name\n    $species->common_name(\"human\");\n\n    # For storing subspecies\n    $species->sub_species(\"accountant\");\n\n=head1 DESCRIPTION\n\nProvides a very simple object for storing phylogenetic\ninformation.  The classification is stored in an array,\nwhich is a list of nodes in a phylogenetic tree.  Access to\ngetting and setting species and genus is provided, but not\nto any of the other node types (eg: \"phylum\", \"class\",\n\"order\", \"family\").  There's plenty of scope for making the\nmodel more sophisticated, if this is ever needed.\n\nA methods are also provided for storing common\nnames, and subspecies.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nJames Gilbert email B<jgrg@sanger.ac.uk>\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' Let the code begin...\n\npackage Bio::Species;\nuse strict;\n\nuse Bio::DB::Taxonomy;\nuse Bio::Tree::Tree;\nuse Scalar::Util qw(weaken isweak);\nuse base qw(Bio::Taxon);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Species->new(-classification => \\@class)\n Function: Build a new Species object\n Returns : Bio::Species object\n Args    : -ncbi_taxid     => NCBI taxonomic ID (optional)\n           -classification => arrayref of classification\n\n\nsub new {\n    my($class, @args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n    \n    my ($org, $sp, $var, $classification) =\n        $self->_rearrange([qw(ORGANELLE\n\t\t\t\t\t       SUB_SPECIES\n\t\t\t\t\t       VARIANT\n\t\t\t\t\t       CLASSIFICATION)], @args);\n    \n    if (defined $classification && ref($classification) eq \"ARRAY\" && @{$classification}) {\n        $self->classification(@$classification);\n    }\n    else {\n        # store a tree on ourselves so we can use Tree methods\n        $self->{tree} = Bio::Tree::Tree->new();\n        \n        # some things want to freeze/thaw Bio::Species objects, but\n        # _root_cleanup_methods contains a CODE ref, delete it.\n        # delete $self->{tree}->{_root_cleanup_methods};\n    }\n    \n    defined $org && $self->organelle($org);\n    defined $sp  && $self->sub_species($sp); \n    defined $var && $self->variant($var);\n    \n    return $self;\n}\n\n=head2 classification\n\n Title   : classification\n Usage   : $self->classification(@class_array);\n           @classification = $self->classification();\n Function: Get/set the lineage of this species. The array provided must be in\n           the order ... ---> SPECIES, GENUS ---> KINGDOM ---> etc.\n Example : $obj->classification(qw( 'Homo sapiens' Homo Hominidae\n           Catarrhini Primates Eutheria Mammalia Vertebrata\n           Chordata Metazoa Eukaryota));\n Returns : Classification array\n Args    : Classification array \n                 OR\n           A reference to the classification array. In the latter case\n           if there is a second argument and it evaluates to true,\n           names will not be validated. NB: in any case, names are never\n           validated anyway.\n\n\nsub classification {\n    my ($self, @vals) = @_;\n\n    if (@vals) {\n        if (ref($vals[0]) eq 'ARRAY') {\n            @vals = @{$vals[0]};\n        }\n        \n        # make sure the lineage contains us as first or second element\n        # (lineage may have subspecies, species, genus ...)\n        my $name = $self->node_name;\n        my ($genus, $species) = (quotemeta($vals[1]), quotemeta($vals[0]));\n        if ($name && ($name !~ m{$species}i && $name !~ m{$genus}i) && $name !~ m{$vals[1] $vals[0]}i) {\n            if ($name =~ /^$vals[1] $vals[0]\\s*(.+)/) {\n                # just assume the problem is someone tried to make a Bio::Species starting at subspecies\n                #*** no idea if this is appropriate! just a possible fix related to bug 2092\n                $self->sub_species($1);\n                $name = $self->node_name(\"$vals[1] $vals[0]\");\n            }\n            else {\n                $self->warn(\"The supplied lineage does not start near '$name' (I was supplied '\".join(\" | \", @vals).\"')\");\n            }\n        }\n        \n        # create a lineage for ourselves\n        my $db = Bio::DB::Taxonomy->new(-source => 'list', -names => [reverse @vals]);\n        unless ($self->scientific_name) {\n            # assume we're supposed to be the leaf of the supplied lineage\n            $self->scientific_name($vals[0]);\n        }\n        unless ($self->rank) {\n            # and that we are rank species\n            $self->rank('species');\n        }\n        \n        $self->db_handle($db);\n\n        $self->{tree} = Bio::Tree::Tree->new(-node => $self);\n        # some things want to freeze/thaw Bio::Species objects, but tree's\n        # _root_cleanup_methods contains a CODE ref, delete it.\n        #*** even if we don't delete the cleanup methods, we still get memory\n        #    leak-like symtoms, and the actual cleanup causes a mass of\n        #    warnings... needs investigation!\n        delete $self->{tree}->{_root_cleanup_methods};\n    }\n    \n    @vals = ();\n    foreach my $node ($self->{tree}->get_lineage_nodes($self), $self) {\n        unshift(@vals, $node->scientific_name || next);\n    }\n    weaken($self->{tree}->{'_rootnode'}) unless isweak($self->{tree}->{'_rootnode'});\n    return @vals;\n}\n\n=head2 ncbi_taxid\n\n Title   : ncbi_taxid\n Usage   : $obj->ncbi_taxid($newval)\n Function: Get/set the NCBI Taxon ID\n Returns : the NCBI Taxon ID as a string\n Args    : newvalue to set or undef to unset (optional)\n\n\n=head2 common_name\n\n Title   : common_name\n Usage   : $self->common_name( $common_name );\n           $common_name = $self->common_name();\n Function: Get or set the common name of the species\n Example : $self->common_name('human')\n Returns : The common name in a string\n Args    : String, which is the common name (optional)\n\n\n=head2 division\n\n Title   : division\n Usage   : $obj->division($newval)\n Function: Genbank Division for a species\n Returns : value of division (a scalar)\n Args    : value of division (a scalar)\n\n\n=head2 species\n\n Title   : species\n Usage   : $self->species( $species );\n           $species = $self->species();\n Function: Get or set the scientific species name.\n Example : $self->species('Homo sapiens');\n Returns : Scientific species name as string\n Args    : Scientific species name as string","parameters":[{"label":"$self"},{"label":"$species"}],"label":"species($self,$species)"},"containerName":"main::","name":"species","children":[{"line":266,"name":"$self","containerName":"species","localvar":"my","kind":13,"definition":"my"},{"name":"$species","containerName":"species","kind":13,"line":266},{"line":268,"name":"$species","containerName":"species","kind":13},{"line":269,"name":"$self","containerName":"species","kind":13},{"kind":13,"containerName":"species","name":"$species","line":269},{"line":272,"name":"$self","containerName":"species","kind":13},{"definition":"my","name":"$species_taxon","localvar":"my","containerName":"species","kind":13,"line":274},{"line":274,"name":"$self","containerName":"species","kind":13},{"line":274,"name":"find_node","containerName":"species","kind":12},{"containerName":"species","kind":13,"name":"$species_taxon","line":275},{"line":277,"kind":13,"containerName":"species","name":"$species_taxon"},{"line":277,"kind":13,"containerName":"species","name":"$self"},{"line":280,"name":"$species","kind":13,"containerName":"species"},{"containerName":"species","kind":13,"name":"$species_taxon","line":280},{"line":280,"name":"scientific_name","kind":12,"containerName":"species"},{"definition":"my","name":"$root","localvar":"my","containerName":"species","kind":13,"line":288},{"line":288,"name":"$self","containerName":"species","kind":13},{"line":288,"kind":12,"containerName":"species","name":"get_root_node"},{"name":"$root","kind":13,"containerName":"species","line":289},{"line":290,"name":"$self","containerName":"species","kind":13},{"name":"new","kind":12,"containerName":"species","line":290},{"line":290,"name":"$species_taxon","kind":13,"containerName":"species"},{"containerName":"species","kind":13,"name":"$self","line":291},{"name":"$root","containerName":"species","kind":13,"line":292},{"line":292,"name":"$self","kind":13,"containerName":"species"},{"name":"get_root_node","kind":12,"containerName":"species","line":292},{"name":"$self","containerName":"species","kind":13,"line":293},{"line":293,"kind":13,"containerName":"species","name":"$self"},{"definition":"my","localvar":"my","kind":13,"containerName":"species","name":"@spflds","line":296},{"name":"$species","containerName":"species","kind":13,"line":296},{"containerName":"species","kind":13,"name":"@spflds","line":297},{"line":297,"containerName":"species","kind":13,"name":"$root"},{"name":"node_name","containerName":"species","kind":12,"line":297},{"line":298,"kind":13,"containerName":"species","name":"$species"},{"line":303,"name":"$genus","localvar":"my","containerName":"species","kind":13,"definition":"my"},{"containerName":"species","kind":13,"name":"$spflds","line":304},{"containerName":"species","kind":13,"name":"$genus","line":305},{"name":"@spflds","kind":13,"containerName":"species","line":305},{"line":308,"name":"$genus","containerName":"species","kind":13},{"definition":"my","line":311,"name":"$sub_species","kind":13,"localvar":"my","containerName":"species"},{"line":312,"containerName":"species","kind":13,"name":"@spflds"},{"line":313,"name":"$fld","kind":13,"localvar":"my","containerName":"species","definition":"my"},{"kind":13,"containerName":"species","name":"@spflds","line":313},{"line":314,"name":"$species","kind":13,"containerName":"species"},{"line":316,"containerName":"species","kind":13,"name":"$fld"},{"containerName":"species","kind":13,"name":"$species","line":318},{"line":319,"name":"$sub_species","kind":13,"containerName":"species"},{"name":"@spflds","kind":13,"containerName":"species","line":319},{"containerName":"species","kind":13,"name":"@spflds","line":319},{"kind":13,"containerName":"species","name":"$species","line":322},{"definition":"my","line":329,"name":"$unconv","kind":13,"localvar":"my","containerName":"species"},{"definition":"my","localvar":"my","kind":13,"containerName":"species","name":"@unkn_genus","line":330},{"containerName":"species","kind":13,"name":"@unkn_genus","line":331},{"line":332,"kind":13,"containerName":"species","name":"$genus"},{"kind":13,"containerName":"species","name":"$genus","line":332},{"line":333,"kind":13,"containerName":"species","name":"$species"},{"line":333,"name":"$genus","kind":13,"containerName":"species"},{"containerName":"species","kind":13,"name":"$species","line":333},{"containerName":"species","kind":13,"name":"$genus","line":334},{"line":335,"name":"$unconv","kind":13,"containerName":"species"},{"line":338,"name":"$species","containerName":"species","kind":13},{"line":339,"name":"$unconv","containerName":"species","kind":13},{"containerName":"species","kind":13,"name":"$unconv","line":343},{"name":"$sub_species","containerName":"species","kind":13,"line":343},{"containerName":"species","kind":13,"name":"$species","line":343},{"name":"$sub_species","containerName":"species","kind":13,"line":348},{"kind":13,"containerName":"species","name":"$self","line":351},{"line":351,"name":"genus","kind":12,"containerName":"species"},{"line":351,"name":"$genus","kind":13,"containerName":"species"},{"containerName":"species","kind":13,"name":"$genus","line":351},{"kind":13,"containerName":"species","name":"$self","line":352},{"name":"sub_species","containerName":"species","kind":12,"line":352},{"name":"$sub_species","containerName":"species","kind":13,"line":352},{"line":352,"name":"$sub_species","containerName":"species","kind":13},{"line":355,"kind":13,"containerName":"species","name":"$self"},{"kind":13,"containerName":"species","name":"$species","line":355},{"containerName":"species","kind":13,"name":"$self","line":357}],"detail":"($self,$species)","definition":"sub"},{"line":269,"kind":12,"name":"_species"},{"line":272,"kind":12,"name":"_species"},{"line":274,"kind":12,"name":"tree"},{"kind":12,"name":"tree","line":288},{"line":290,"kind":12,"name":"tree"},{"line":290,"name":"Bio","containerName":"Tree::Tree","kind":12},{"kind":12,"name":"tree","line":291},{"line":291,"name":"_root_cleanup_methods","kind":12},{"name":"tree","kind":12,"line":292},{"name":"weaken","kind":12,"line":293},{"line":293,"kind":12,"name":"tree"},{"line":293,"kind":12,"name":"isweak"},{"line":293,"kind":12,"name":"tree"},{"line":355,"name":"_species","kind":12},{"kind":12,"name":"_species","line":357},{"children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"genus","line":373},{"line":373,"name":"$genus","containerName":"genus","kind":13},{"line":375,"name":"$genus","kind":13,"containerName":"genus"},{"line":376,"name":"$self","containerName":"genus","kind":13},{"line":376,"containerName":"genus","kind":13,"name":"$genus"},{"name":"$self","containerName":"genus","kind":13,"line":379},{"line":380,"localvar":"my","containerName":"genus","kind":13,"name":"$genus_taxon","definition":"my"},{"name":"$self","kind":13,"containerName":"genus","line":380},{"line":380,"containerName":"genus","kind":12,"name":"find_node"},{"containerName":"genus","kind":13,"name":"$genus_taxon","line":381},{"name":"$genus_taxon","containerName":"genus","kind":13,"line":383},{"containerName":"genus","kind":13,"name":"$self","line":383},{"kind":12,"containerName":"genus","name":"ancestor","line":383},{"containerName":"genus","kind":13,"name":"$self","line":386},{"kind":13,"containerName":"genus","name":"$genus_taxon","line":386},{"line":386,"name":"scientific_name","kind":12,"containerName":"genus"},{"name":"$genus_taxon","containerName":"genus","kind":13,"line":386},{"line":389,"name":"$self","kind":13,"containerName":"genus"}],"containerName":"main::","name":"genus","definition":"sub","detail":"($self,$genus)","line":372,"kind":12,"range":{"start":{"line":372,"character":0},"end":{"character":9999,"line":390}},"signature":{"label":"genus($self,$genus)","documentation":"1;\n# $Id: Species.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Species\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by James Gilbert <jgrg@sanger.ac.uk>\n# Reimplemented by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Species - Generic species object\n\n=head1 SYNOPSIS\n\n    $species = Bio::Species->new(-classification => [@classification]);\n                                    # Can also pass classification\n                                    # array to new as below\n\n    $species->classification(qw( sapiens Homo Hominidae\n                                 Catarrhini Primates Eutheria\n                                 Mammalia Vertebrata Chordata\n                                 Metazoa Eukaryota ));\n\n    $genus = $species->genus();\n\n    $bi = $species->binomial();     # $bi is now \"Homo sapiens\"\n\n    # For storing common name\n    $species->common_name(\"human\");\n\n    # For storing subspecies\n    $species->sub_species(\"accountant\");\n\n=head1 DESCRIPTION\n\nProvides a very simple object for storing phylogenetic\ninformation.  The classification is stored in an array,\nwhich is a list of nodes in a phylogenetic tree.  Access to\ngetting and setting species and genus is provided, but not\nto any of the other node types (eg: \"phylum\", \"class\",\n\"order\", \"family\").  There's plenty of scope for making the\nmodel more sophisticated, if this is ever needed.\n\nA methods are also provided for storing common\nnames, and subspecies.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nJames Gilbert email B<jgrg@sanger.ac.uk>\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' Let the code begin...\n\npackage Bio::Species;\nuse strict;\n\nuse Bio::DB::Taxonomy;\nuse Bio::Tree::Tree;\nuse Scalar::Util qw(weaken isweak);\nuse base qw(Bio::Taxon);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Species->new(-classification => \\@class)\n Function: Build a new Species object\n Returns : Bio::Species object\n Args    : -ncbi_taxid     => NCBI taxonomic ID (optional)\n           -classification => arrayref of classification\n\n\nsub new {\n    my($class, @args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n    \n    my ($org, $sp, $var, $classification) =\n        $self->_rearrange([qw(ORGANELLE\n\t\t\t\t\t       SUB_SPECIES\n\t\t\t\t\t       VARIANT\n\t\t\t\t\t       CLASSIFICATION)], @args);\n    \n    if (defined $classification && ref($classification) eq \"ARRAY\" && @{$classification}) {\n        $self->classification(@$classification);\n    }\n    else {\n        # store a tree on ourselves so we can use Tree methods\n        $self->{tree} = Bio::Tree::Tree->new();\n        \n        # some things want to freeze/thaw Bio::Species objects, but\n        # _root_cleanup_methods contains a CODE ref, delete it.\n        # delete $self->{tree}->{_root_cleanup_methods};\n    }\n    \n    defined $org && $self->organelle($org);\n    defined $sp  && $self->sub_species($sp); \n    defined $var && $self->variant($var);\n    \n    return $self;\n}\n\n=head2 classification\n\n Title   : classification\n Usage   : $self->classification(@class_array);\n           @classification = $self->classification();\n Function: Get/set the lineage of this species. The array provided must be in\n           the order ... ---> SPECIES, GENUS ---> KINGDOM ---> etc.\n Example : $obj->classification(qw( 'Homo sapiens' Homo Hominidae\n           Catarrhini Primates Eutheria Mammalia Vertebrata\n           Chordata Metazoa Eukaryota));\n Returns : Classification array\n Args    : Classification array \n                 OR\n           A reference to the classification array. In the latter case\n           if there is a second argument and it evaluates to true,\n           names will not be validated. NB: in any case, names are never\n           validated anyway.\n\n\nsub classification {\n    my ($self, @vals) = @_;\n\n    if (@vals) {\n        if (ref($vals[0]) eq 'ARRAY') {\n            @vals = @{$vals[0]};\n        }\n        \n        # make sure the lineage contains us as first or second element\n        # (lineage may have subspecies, species, genus ...)\n        my $name = $self->node_name;\n        my ($genus, $species) = (quotemeta($vals[1]), quotemeta($vals[0]));\n        if ($name && ($name !~ m{$species}i && $name !~ m{$genus}i) && $name !~ m{$vals[1] $vals[0]}i) {\n            if ($name =~ /^$vals[1] $vals[0]\\s*(.+)/) {\n                # just assume the problem is someone tried to make a Bio::Species starting at subspecies\n                #*** no idea if this is appropriate! just a possible fix related to bug 2092\n                $self->sub_species($1);\n                $name = $self->node_name(\"$vals[1] $vals[0]\");\n            }\n            else {\n                $self->warn(\"The supplied lineage does not start near '$name' (I was supplied '\".join(\" | \", @vals).\"')\");\n            }\n        }\n        \n        # create a lineage for ourselves\n        my $db = Bio::DB::Taxonomy->new(-source => 'list', -names => [reverse @vals]);\n        unless ($self->scientific_name) {\n            # assume we're supposed to be the leaf of the supplied lineage\n            $self->scientific_name($vals[0]);\n        }\n        unless ($self->rank) {\n            # and that we are rank species\n            $self->rank('species');\n        }\n        \n        $self->db_handle($db);\n\n        $self->{tree} = Bio::Tree::Tree->new(-node => $self);\n        # some things want to freeze/thaw Bio::Species objects, but tree's\n        # _root_cleanup_methods contains a CODE ref, delete it.\n        #*** even if we don't delete the cleanup methods, we still get memory\n        #    leak-like symtoms, and the actual cleanup causes a mass of\n        #    warnings... needs investigation!\n        delete $self->{tree}->{_root_cleanup_methods};\n    }\n    \n    @vals = ();\n    foreach my $node ($self->{tree}->get_lineage_nodes($self), $self) {\n        unshift(@vals, $node->scientific_name || next);\n    }\n    weaken($self->{tree}->{'_rootnode'}) unless isweak($self->{tree}->{'_rootnode'});\n    return @vals;\n}\n\n=head2 ncbi_taxid\n\n Title   : ncbi_taxid\n Usage   : $obj->ncbi_taxid($newval)\n Function: Get/set the NCBI Taxon ID\n Returns : the NCBI Taxon ID as a string\n Args    : newvalue to set or undef to unset (optional)\n\n\n=head2 common_name\n\n Title   : common_name\n Usage   : $self->common_name( $common_name );\n           $common_name = $self->common_name();\n Function: Get or set the common name of the species\n Example : $self->common_name('human')\n Returns : The common name in a string\n Args    : String, which is the common name (optional)\n\n\n=head2 division\n\n Title   : division\n Usage   : $obj->division($newval)\n Function: Genbank Division for a species\n Returns : value of division (a scalar)\n Args    : value of division (a scalar)\n\n\n=head2 species\n\n Title   : species\n Usage   : $self->species( $species );\n           $species = $self->species();\n Function: Get or set the scientific species name.\n Example : $self->species('Homo sapiens');\n Returns : Scientific species name as string\n Args    : Scientific species name as string\n\n\nsub species {\n    my ($self, $species) = @_;\n    \n\tif ($species) {\n\t\t$self->{_species} = $species;\n\t}\n\t\n\tunless (defined $self->{_species}) {\n\t\t# work it out from our nodes\n\t\tmy $species_taxon = $self->{tree}->find_node(-rank => 'species');\n\t\tunless ($species_taxon) {\n\t\t\t# just assume we are rank species\n\t\t\t$species_taxon = $self;\n\t\t}\n\t\t\n\t\t$species = $species_taxon->scientific_name;\n        \n\t\t#\n\t\t# munge it like the Bio::SeqIO modules used to do\n\t\t# (more or less copy/pasted from old Bio::SeqIO::genbank, hence comments\n\t\t#  referring to 'ORGANISM' etc.)\n\t\t#\n\t\t\n\t\tmy $root = $self->{tree}->get_root_node;\n\t\tunless ($root) {\n            $self->{tree} = Bio::Tree::Tree->new(-node => $species_taxon);\n            delete $self->{tree}->{_root_cleanup_methods};\n            $root = $self->{tree}->get_root_node;\n            weaken($self->{tree}->{'_rootnode'}) unless isweak($self->{tree}->{'_rootnode'});\n        }\n        \n\t\tmy @spflds = split(' ', $species);\n\t\tif (@spflds > 1 && $root->node_name ne 'Viruses') {\n\t\t\t$species = undef;\n\t\t\t\n\t\t\t# does the next term start with uppercase?\n\t\t\t# yes: valid genus; no then unconventional\n\t\t\t# e.g. leaf litter basidiomycete sp. Collb2-39\n\t\t\tmy $genus;\n\t\t\tif ($spflds[0] =~ m/^[A-Z]/) {\n\t\t\t\t$genus = shift(@spflds);\n\t\t\t}\n\t\t\telse {\n\t\t\t\tundef $genus;\n\t\t\t}\n            \n\t\t\tmy $sub_species;\n\t\t\tif (@spflds) {\n\t\t\t\twhile (my $fld = shift @spflds) {\n\t\t\t\t\t$species .= \"$fld \";\n\t\t\t\t\t# does it have subspecies or varieties?\n\t\t\t\t\tlast if ($fld =~ m/(sp\\.|var\\.)/);\n\t\t\t\t}\n\t\t\t\tchop $species;\t# last space\n\t\t\t\t$sub_species = join ' ',@spflds if(@spflds);\n\t\t\t}\n\t\t\telse {\n\t\t\t\t$species = 'sp.';\n\t\t\t}\n\t\t\t\n\t\t\t# does ORGANISM start with any words which make its genus undefined?\n\t\t\t# these are in @unkn_genus\t\n\t\t\t# this in case species starts with uppercase so isn't caught above. \n\t\t\t# alter common name if required\n\t\t\tmy $unconv = 0; # is it unconventional species name?\n\t\t\tmy @unkn_genus = ('unknown','unclassified','uncultured','unidentified');\n\t\t\tforeach (@unkn_genus) {\n\t\t\t\tif ($genus && $genus =~ m/$_/i)\t{\n\t\t\t\t\t$species = $genus . \" \" . $species;\n\t\t\t\t\tundef $genus;\n\t\t\t\t\t$unconv = 1;\n\t\t\t\t\tlast;\n\t\t\t\t}\n\t\t\t\telsif ($species =~ m/$_/i)\t{\n\t\t\t\t\t$unconv = 1;\n\t\t\t\t\tlast;\n\t\t\t\t}\n\t\t\t}\n\t\t\tif (!$unconv && !$sub_species && $species =~ s/^(\\w+)\\s(\\w+)$/$1/)\t{\n\t\t\t\t# need to extract subspecies from conventional ORGANISM format.  \n\t\t\t\t# Will the 'word' in a two element species name\n\t\t\t\t# e.g. $species = 'thummi thummi' => $species='thummi' & \n\t\t\t\t# $sub_species='thummi'\n\t\t\t\t$sub_species = $2;\n\t\t\t}\n\t\t\t\n\t\t\t$self->genus($genus) if $genus;\n\t\t\t$self->sub_species($sub_species) if $sub_species;\n\t\t}\n\t\t\n\t\t$self->{_species} = $species;\n    }\n\treturn $self->{_species};\n}\n\n=head2 genus\n\n Title   : genus\n Usage   : $self->genus( $genus );\n           $genus = $self->genus();\n Function: Get or set the scientific genus name.\n Example : $self->genus('Homo');\n Returns : Scientific genus name as string\n Args    : Scientific genus name as string","parameters":[{"label":"$self"},{"label":"$genus"}]}},{"line":376,"kind":12,"name":"_genus"},{"name":"_genus","kind":12,"line":379},{"line":380,"name":"tree","kind":12},{"name":"_genus","kind":12,"line":386},{"name":"_genus","kind":12,"line":389},{"detail":"($self,$sub)","definition":"sub","name":"sub_species","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"sub_species","line":403},{"containerName":"sub_species","kind":13,"name":"$sub","line":403},{"kind":13,"containerName":"sub_species","name":"$self","line":405},{"definition":"my","line":406,"name":"$ss_taxon","kind":13,"localvar":"my","containerName":"sub_species"},{"name":"$self","kind":13,"containerName":"sub_species","line":406},{"containerName":"sub_species","kind":12,"name":"find_node","line":406},{"name":"$ss_taxon","containerName":"sub_species","kind":13,"line":407},{"name":"$sub","kind":13,"containerName":"sub_species","line":408},{"line":409,"containerName":"sub_species","kind":13,"name":"$ss_taxon"},{"name":"scientific_name","kind":12,"containerName":"sub_species","line":409},{"name":"$sub","kind":13,"containerName":"sub_species","line":409},{"name":"$self","containerName":"sub_species","kind":13,"line":418},{"name":"$sub","containerName":"sub_species","kind":13,"line":418},{"line":420,"kind":13,"containerName":"sub_species","name":"$ss_taxon"},{"line":420,"name":"scientific_name","kind":12,"containerName":"sub_species"},{"name":"$self","kind":13,"containerName":"sub_species","line":425},{"line":425,"name":"$sub","containerName":"sub_species","kind":13},{"line":425,"name":"$sub","kind":13,"containerName":"sub_species"},{"kind":13,"containerName":"sub_species","name":"$self","line":426}],"signature":{"label":"sub_species($self,$sub)","documentation":"1;\n# $Id: Species.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Species\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by James Gilbert <jgrg@sanger.ac.uk>\n# Reimplemented by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Species - Generic species object\n\n=head1 SYNOPSIS\n\n    $species = Bio::Species->new(-classification => [@classification]);\n                                    # Can also pass classification\n                                    # array to new as below\n\n    $species->classification(qw( sapiens Homo Hominidae\n                                 Catarrhini Primates Eutheria\n                                 Mammalia Vertebrata Chordata\n                                 Metazoa Eukaryota ));\n\n    $genus = $species->genus();\n\n    $bi = $species->binomial();     # $bi is now \"Homo sapiens\"\n\n    # For storing common name\n    $species->common_name(\"human\");\n\n    # For storing subspecies\n    $species->sub_species(\"accountant\");\n\n=head1 DESCRIPTION\n\nProvides a very simple object for storing phylogenetic\ninformation.  The classification is stored in an array,\nwhich is a list of nodes in a phylogenetic tree.  Access to\ngetting and setting species and genus is provided, but not\nto any of the other node types (eg: \"phylum\", \"class\",\n\"order\", \"family\").  There's plenty of scope for making the\nmodel more sophisticated, if this is ever needed.\n\nA methods are also provided for storing common\nnames, and subspecies.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nJames Gilbert email B<jgrg@sanger.ac.uk>\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' Let the code begin...\n\npackage Bio::Species;\nuse strict;\n\nuse Bio::DB::Taxonomy;\nuse Bio::Tree::Tree;\nuse Scalar::Util qw(weaken isweak);\nuse base qw(Bio::Taxon);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Species->new(-classification => \\@class)\n Function: Build a new Species object\n Returns : Bio::Species object\n Args    : -ncbi_taxid     => NCBI taxonomic ID (optional)\n           -classification => arrayref of classification\n\n\nsub new {\n    my($class, @args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n    \n    my ($org, $sp, $var, $classification) =\n        $self->_rearrange([qw(ORGANELLE\n\t\t\t\t\t       SUB_SPECIES\n\t\t\t\t\t       VARIANT\n\t\t\t\t\t       CLASSIFICATION)], @args);\n    \n    if (defined $classification && ref($classification) eq \"ARRAY\" && @{$classification}) {\n        $self->classification(@$classification);\n    }\n    else {\n        # store a tree on ourselves so we can use Tree methods\n        $self->{tree} = Bio::Tree::Tree->new();\n        \n        # some things want to freeze/thaw Bio::Species objects, but\n        # _root_cleanup_methods contains a CODE ref, delete it.\n        # delete $self->{tree}->{_root_cleanup_methods};\n    }\n    \n    defined $org && $self->organelle($org);\n    defined $sp  && $self->sub_species($sp); \n    defined $var && $self->variant($var);\n    \n    return $self;\n}\n\n=head2 classification\n\n Title   : classification\n Usage   : $self->classification(@class_array);\n           @classification = $self->classification();\n Function: Get/set the lineage of this species. The array provided must be in\n           the order ... ---> SPECIES, GENUS ---> KINGDOM ---> etc.\n Example : $obj->classification(qw( 'Homo sapiens' Homo Hominidae\n           Catarrhini Primates Eutheria Mammalia Vertebrata\n           Chordata Metazoa Eukaryota));\n Returns : Classification array\n Args    : Classification array \n                 OR\n           A reference to the classification array. In the latter case\n           if there is a second argument and it evaluates to true,\n           names will not be validated. NB: in any case, names are never\n           validated anyway.\n\n\nsub classification {\n    my ($self, @vals) = @_;\n\n    if (@vals) {\n        if (ref($vals[0]) eq 'ARRAY') {\n            @vals = @{$vals[0]};\n        }\n        \n        # make sure the lineage contains us as first or second element\n        # (lineage may have subspecies, species, genus ...)\n        my $name = $self->node_name;\n        my ($genus, $species) = (quotemeta($vals[1]), quotemeta($vals[0]));\n        if ($name && ($name !~ m{$species}i && $name !~ m{$genus}i) && $name !~ m{$vals[1] $vals[0]}i) {\n            if ($name =~ /^$vals[1] $vals[0]\\s*(.+)/) {\n                # just assume the problem is someone tried to make a Bio::Species starting at subspecies\n                #*** no idea if this is appropriate! just a possible fix related to bug 2092\n                $self->sub_species($1);\n                $name = $self->node_name(\"$vals[1] $vals[0]\");\n            }\n            else {\n                $self->warn(\"The supplied lineage does not start near '$name' (I was supplied '\".join(\" | \", @vals).\"')\");\n            }\n        }\n        \n        # create a lineage for ourselves\n        my $db = Bio::DB::Taxonomy->new(-source => 'list', -names => [reverse @vals]);\n        unless ($self->scientific_name) {\n            # assume we're supposed to be the leaf of the supplied lineage\n            $self->scientific_name($vals[0]);\n        }\n        unless ($self->rank) {\n            # and that we are rank species\n            $self->rank('species');\n        }\n        \n        $self->db_handle($db);\n\n        $self->{tree} = Bio::Tree::Tree->new(-node => $self);\n        # some things want to freeze/thaw Bio::Species objects, but tree's\n        # _root_cleanup_methods contains a CODE ref, delete it.\n        #*** even if we don't delete the cleanup methods, we still get memory\n        #    leak-like symtoms, and the actual cleanup causes a mass of\n        #    warnings... needs investigation!\n        delete $self->{tree}->{_root_cleanup_methods};\n    }\n    \n    @vals = ();\n    foreach my $node ($self->{tree}->get_lineage_nodes($self), $self) {\n        unshift(@vals, $node->scientific_name || next);\n    }\n    weaken($self->{tree}->{'_rootnode'}) unless isweak($self->{tree}->{'_rootnode'});\n    return @vals;\n}\n\n=head2 ncbi_taxid\n\n Title   : ncbi_taxid\n Usage   : $obj->ncbi_taxid($newval)\n Function: Get/set the NCBI Taxon ID\n Returns : the NCBI Taxon ID as a string\n Args    : newvalue to set or undef to unset (optional)\n\n\n=head2 common_name\n\n Title   : common_name\n Usage   : $self->common_name( $common_name );\n           $common_name = $self->common_name();\n Function: Get or set the common name of the species\n Example : $self->common_name('human')\n Returns : The common name in a string\n Args    : String, which is the common name (optional)\n\n\n=head2 division\n\n Title   : division\n Usage   : $obj->division($newval)\n Function: Genbank Division for a species\n Returns : value of division (a scalar)\n Args    : value of division (a scalar)\n\n\n=head2 species\n\n Title   : species\n Usage   : $self->species( $species );\n           $species = $self->species();\n Function: Get or set the scientific species name.\n Example : $self->species('Homo sapiens');\n Returns : Scientific species name as string\n Args    : Scientific species name as string\n\n\nsub species {\n    my ($self, $species) = @_;\n    \n\tif ($species) {\n\t\t$self->{_species} = $species;\n\t}\n\t\n\tunless (defined $self->{_species}) {\n\t\t# work it out from our nodes\n\t\tmy $species_taxon = $self->{tree}->find_node(-rank => 'species');\n\t\tunless ($species_taxon) {\n\t\t\t# just assume we are rank species\n\t\t\t$species_taxon = $self;\n\t\t}\n\t\t\n\t\t$species = $species_taxon->scientific_name;\n        \n\t\t#\n\t\t# munge it like the Bio::SeqIO modules used to do\n\t\t# (more or less copy/pasted from old Bio::SeqIO::genbank, hence comments\n\t\t#  referring to 'ORGANISM' etc.)\n\t\t#\n\t\t\n\t\tmy $root = $self->{tree}->get_root_node;\n\t\tunless ($root) {\n            $self->{tree} = Bio::Tree::Tree->new(-node => $species_taxon);\n            delete $self->{tree}->{_root_cleanup_methods};\n            $root = $self->{tree}->get_root_node;\n            weaken($self->{tree}->{'_rootnode'}) unless isweak($self->{tree}->{'_rootnode'});\n        }\n        \n\t\tmy @spflds = split(' ', $species);\n\t\tif (@spflds > 1 && $root->node_name ne 'Viruses') {\n\t\t\t$species = undef;\n\t\t\t\n\t\t\t# does the next term start with uppercase?\n\t\t\t# yes: valid genus; no then unconventional\n\t\t\t# e.g. leaf litter basidiomycete sp. Collb2-39\n\t\t\tmy $genus;\n\t\t\tif ($spflds[0] =~ m/^[A-Z]/) {\n\t\t\t\t$genus = shift(@spflds);\n\t\t\t}\n\t\t\telse {\n\t\t\t\tundef $genus;\n\t\t\t}\n            \n\t\t\tmy $sub_species;\n\t\t\tif (@spflds) {\n\t\t\t\twhile (my $fld = shift @spflds) {\n\t\t\t\t\t$species .= \"$fld \";\n\t\t\t\t\t# does it have subspecies or varieties?\n\t\t\t\t\tlast if ($fld =~ m/(sp\\.|var\\.)/);\n\t\t\t\t}\n\t\t\t\tchop $species;\t# last space\n\t\t\t\t$sub_species = join ' ',@spflds if(@spflds);\n\t\t\t}\n\t\t\telse {\n\t\t\t\t$species = 'sp.';\n\t\t\t}\n\t\t\t\n\t\t\t# does ORGANISM start with any words which make its genus undefined?\n\t\t\t# these are in @unkn_genus\t\n\t\t\t# this in case species starts with uppercase so isn't caught above. \n\t\t\t# alter common name if required\n\t\t\tmy $unconv = 0; # is it unconventional species name?\n\t\t\tmy @unkn_genus = ('unknown','unclassified','uncultured','unidentified');\n\t\t\tforeach (@unkn_genus) {\n\t\t\t\tif ($genus && $genus =~ m/$_/i)\t{\n\t\t\t\t\t$species = $genus . \" \" . $species;\n\t\t\t\t\tundef $genus;\n\t\t\t\t\t$unconv = 1;\n\t\t\t\t\tlast;\n\t\t\t\t}\n\t\t\t\telsif ($species =~ m/$_/i)\t{\n\t\t\t\t\t$unconv = 1;\n\t\t\t\t\tlast;\n\t\t\t\t}\n\t\t\t}\n\t\t\tif (!$unconv && !$sub_species && $species =~ s/^(\\w+)\\s(\\w+)$/$1/)\t{\n\t\t\t\t# need to extract subspecies from conventional ORGANISM format.  \n\t\t\t\t# Will the 'word' in a two element species name\n\t\t\t\t# e.g. $species = 'thummi thummi' => $species='thummi' & \n\t\t\t\t# $sub_species='thummi'\n\t\t\t\t$sub_species = $2;\n\t\t\t}\n\t\t\t\n\t\t\t$self->genus($genus) if $genus;\n\t\t\t$self->sub_species($sub_species) if $sub_species;\n\t\t}\n\t\t\n\t\t$self->{_species} = $species;\n    }\n\treturn $self->{_species};\n}\n\n=head2 genus\n\n Title   : genus\n Usage   : $self->genus( $genus );\n           $genus = $self->genus();\n Function: Get or set the scientific genus name.\n Example : $self->genus('Homo');\n Returns : Scientific genus name as string\n Args    : Scientific genus name as string\n\n\nsub genus {\n    my ($self, $genus) = @_;\n    \n\tif ($genus) {\n        $self->{_genus} = $genus;\n    }\n\t\n\tunless (defined $self->{_genus}) {\n\t\tmy $genus_taxon = $self->{tree}->find_node(-rank => 'genus');\n\t\tunless ($genus_taxon) {\n\t\t\t# just assume our ancestor is rank genus\n\t\t\t$genus_taxon = $self->ancestor;\n\t\t}\n\t\t\n\t\t$self->{_genus} = $genus_taxon->scientific_name if $genus_taxon;\n\t}\n\t\n\treturn $self->{_genus};\n}\n\n=head2 sub_species\n\n Title   : sub_species\n Usage   : $obj->sub_species($newval)\n Function: Get or set the scientific subspecies name.\n Returns : value of sub_species\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$sub"}]},"range":{"end":{"character":9999,"line":427},"start":{"character":0,"line":402}},"kind":12,"line":402},{"line":406,"kind":12,"name":"tree"},{"signature":{"parameters":[{"label":"$self"},{"label":"$var"}],"documentation":"1;\n# $Id: Species.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Species\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by James Gilbert <jgrg@sanger.ac.uk>\n# Reimplemented by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Species - Generic species object\n\n=head1 SYNOPSIS\n\n    $species = Bio::Species->new(-classification => [@classification]);\n                                    # Can also pass classification\n                                    # array to new as below\n\n    $species->classification(qw( sapiens Homo Hominidae\n                                 Catarrhini Primates Eutheria\n                                 Mammalia Vertebrata Chordata\n                                 Metazoa Eukaryota ));\n\n    $genus = $species->genus();\n\n    $bi = $species->binomial();     # $bi is now \"Homo sapiens\"\n\n    # For storing common name\n    $species->common_name(\"human\");\n\n    # For storing subspecies\n    $species->sub_species(\"accountant\");\n\n=head1 DESCRIPTION\n\nProvides a very simple object for storing phylogenetic\ninformation.  The classification is stored in an array,\nwhich is a list of nodes in a phylogenetic tree.  Access to\ngetting and setting species and genus is provided, but not\nto any of the other node types (eg: \"phylum\", \"class\",\n\"order\", \"family\").  There's plenty of scope for making the\nmodel more sophisticated, if this is ever needed.\n\nA methods are also provided for storing common\nnames, and subspecies.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nJames Gilbert email B<jgrg@sanger.ac.uk>\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' Let the code begin...\n\npackage Bio::Species;\nuse strict;\n\nuse Bio::DB::Taxonomy;\nuse Bio::Tree::Tree;\nuse Scalar::Util qw(weaken isweak);\nuse base qw(Bio::Taxon);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Species->new(-classification => \\@class)\n Function: Build a new Species object\n Returns : Bio::Species object\n Args    : -ncbi_taxid     => NCBI taxonomic ID (optional)\n           -classification => arrayref of classification\n\n\nsub new {\n    my($class, @args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n    \n    my ($org, $sp, $var, $classification) =\n        $self->_rearrange([qw(ORGANELLE\n\t\t\t\t\t       SUB_SPECIES\n\t\t\t\t\t       VARIANT\n\t\t\t\t\t       CLASSIFICATION)], @args);\n    \n    if (defined $classification && ref($classification) eq \"ARRAY\" && @{$classification}) {\n        $self->classification(@$classification);\n    }\n    else {\n        # store a tree on ourselves so we can use Tree methods\n        $self->{tree} = Bio::Tree::Tree->new();\n        \n        # some things want to freeze/thaw Bio::Species objects, but\n        # _root_cleanup_methods contains a CODE ref, delete it.\n        # delete $self->{tree}->{_root_cleanup_methods};\n    }\n    \n    defined $org && $self->organelle($org);\n    defined $sp  && $self->sub_species($sp); \n    defined $var && $self->variant($var);\n    \n    return $self;\n}\n\n=head2 classification\n\n Title   : classification\n Usage   : $self->classification(@class_array);\n           @classification = $self->classification();\n Function: Get/set the lineage of this species. The array provided must be in\n           the order ... ---> SPECIES, GENUS ---> KINGDOM ---> etc.\n Example : $obj->classification(qw( 'Homo sapiens' Homo Hominidae\n           Catarrhini Primates Eutheria Mammalia Vertebrata\n           Chordata Metazoa Eukaryota));\n Returns : Classification array\n Args    : Classification array \n                 OR\n           A reference to the classification array. In the latter case\n           if there is a second argument and it evaluates to true,\n           names will not be validated. NB: in any case, names are never\n           validated anyway.\n\n\nsub classification {\n    my ($self, @vals) = @_;\n\n    if (@vals) {\n        if (ref($vals[0]) eq 'ARRAY') {\n            @vals = @{$vals[0]};\n        }\n        \n        # make sure the lineage contains us as first or second element\n        # (lineage may have subspecies, species, genus ...)\n        my $name = $self->node_name;\n        my ($genus, $species) = (quotemeta($vals[1]), quotemeta($vals[0]));\n        if ($name && ($name !~ m{$species}i && $name !~ m{$genus}i) && $name !~ m{$vals[1] $vals[0]}i) {\n            if ($name =~ /^$vals[1] $vals[0]\\s*(.+)/) {\n                # just assume the problem is someone tried to make a Bio::Species starting at subspecies\n                #*** no idea if this is appropriate! just a possible fix related to bug 2092\n                $self->sub_species($1);\n                $name = $self->node_name(\"$vals[1] $vals[0]\");\n            }\n            else {\n                $self->warn(\"The supplied lineage does not start near '$name' (I was supplied '\".join(\" | \", @vals).\"')\");\n            }\n        }\n        \n        # create a lineage for ourselves\n        my $db = Bio::DB::Taxonomy->new(-source => 'list', -names => [reverse @vals]);\n        unless ($self->scientific_name) {\n            # assume we're supposed to be the leaf of the supplied lineage\n            $self->scientific_name($vals[0]);\n        }\n        unless ($self->rank) {\n            # and that we are rank species\n            $self->rank('species');\n        }\n        \n        $self->db_handle($db);\n\n        $self->{tree} = Bio::Tree::Tree->new(-node => $self);\n        # some things want to freeze/thaw Bio::Species objects, but tree's\n        # _root_cleanup_methods contains a CODE ref, delete it.\n        #*** even if we don't delete the cleanup methods, we still get memory\n        #    leak-like symtoms, and the actual cleanup causes a mass of\n        #    warnings... needs investigation!\n        delete $self->{tree}->{_root_cleanup_methods};\n    }\n    \n    @vals = ();\n    foreach my $node ($self->{tree}->get_lineage_nodes($self), $self) {\n        unshift(@vals, $node->scientific_name || next);\n    }\n    weaken($self->{tree}->{'_rootnode'}) unless isweak($self->{tree}->{'_rootnode'});\n    return @vals;\n}\n\n=head2 ncbi_taxid\n\n Title   : ncbi_taxid\n Usage   : $obj->ncbi_taxid($newval)\n Function: Get/set the NCBI Taxon ID\n Returns : the NCBI Taxon ID as a string\n Args    : newvalue to set or undef to unset (optional)\n\n\n=head2 common_name\n\n Title   : common_name\n Usage   : $self->common_name( $common_name );\n           $common_name = $self->common_name();\n Function: Get or set the common name of the species\n Example : $self->common_name('human')\n Returns : The common name in a string\n Args    : String, which is the common name (optional)\n\n\n=head2 division\n\n Title   : division\n Usage   : $obj->division($newval)\n Function: Genbank Division for a species\n Returns : value of division (a scalar)\n Args    : value of division (a scalar)\n\n\n=head2 species\n\n Title   : species\n Usage   : $self->species( $species );\n           $species = $self->species();\n Function: Get or set the scientific species name.\n Example : $self->species('Homo sapiens');\n Returns : Scientific species name as string\n Args    : Scientific species name as string\n\n\nsub species {\n    my ($self, $species) = @_;\n    \n\tif ($species) {\n\t\t$self->{_species} = $species;\n\t}\n\t\n\tunless (defined $self->{_species}) {\n\t\t# work it out from our nodes\n\t\tmy $species_taxon = $self->{tree}->find_node(-rank => 'species');\n\t\tunless ($species_taxon) {\n\t\t\t# just assume we are rank species\n\t\t\t$species_taxon = $self;\n\t\t}\n\t\t\n\t\t$species = $species_taxon->scientific_name;\n        \n\t\t#\n\t\t# munge it like the Bio::SeqIO modules used to do\n\t\t# (more or less copy/pasted from old Bio::SeqIO::genbank, hence comments\n\t\t#  referring to 'ORGANISM' etc.)\n\t\t#\n\t\t\n\t\tmy $root = $self->{tree}->get_root_node;\n\t\tunless ($root) {\n            $self->{tree} = Bio::Tree::Tree->new(-node => $species_taxon);\n            delete $self->{tree}->{_root_cleanup_methods};\n            $root = $self->{tree}->get_root_node;\n            weaken($self->{tree}->{'_rootnode'}) unless isweak($self->{tree}->{'_rootnode'});\n        }\n        \n\t\tmy @spflds = split(' ', $species);\n\t\tif (@spflds > 1 && $root->node_name ne 'Viruses') {\n\t\t\t$species = undef;\n\t\t\t\n\t\t\t# does the next term start with uppercase?\n\t\t\t# yes: valid genus; no then unconventional\n\t\t\t# e.g. leaf litter basidiomycete sp. Collb2-39\n\t\t\tmy $genus;\n\t\t\tif ($spflds[0] =~ m/^[A-Z]/) {\n\t\t\t\t$genus = shift(@spflds);\n\t\t\t}\n\t\t\telse {\n\t\t\t\tundef $genus;\n\t\t\t}\n            \n\t\t\tmy $sub_species;\n\t\t\tif (@spflds) {\n\t\t\t\twhile (my $fld = shift @spflds) {\n\t\t\t\t\t$species .= \"$fld \";\n\t\t\t\t\t# does it have subspecies or varieties?\n\t\t\t\t\tlast if ($fld =~ m/(sp\\.|var\\.)/);\n\t\t\t\t}\n\t\t\t\tchop $species;\t# last space\n\t\t\t\t$sub_species = join ' ',@spflds if(@spflds);\n\t\t\t}\n\t\t\telse {\n\t\t\t\t$species = 'sp.';\n\t\t\t}\n\t\t\t\n\t\t\t# does ORGANISM start with any words which make its genus undefined?\n\t\t\t# these are in @unkn_genus\t\n\t\t\t# this in case species starts with uppercase so isn't caught above. \n\t\t\t# alter common name if required\n\t\t\tmy $unconv = 0; # is it unconventional species name?\n\t\t\tmy @unkn_genus = ('unknown','unclassified','uncultured','unidentified');\n\t\t\tforeach (@unkn_genus) {\n\t\t\t\tif ($genus && $genus =~ m/$_/i)\t{\n\t\t\t\t\t$species = $genus . \" \" . $species;\n\t\t\t\t\tundef $genus;\n\t\t\t\t\t$unconv = 1;\n\t\t\t\t\tlast;\n\t\t\t\t}\n\t\t\t\telsif ($species =~ m/$_/i)\t{\n\t\t\t\t\t$unconv = 1;\n\t\t\t\t\tlast;\n\t\t\t\t}\n\t\t\t}\n\t\t\tif (!$unconv && !$sub_species && $species =~ s/^(\\w+)\\s(\\w+)$/$1/)\t{\n\t\t\t\t# need to extract subspecies from conventional ORGANISM format.  \n\t\t\t\t# Will the 'word' in a two element species name\n\t\t\t\t# e.g. $species = 'thummi thummi' => $species='thummi' & \n\t\t\t\t# $sub_species='thummi'\n\t\t\t\t$sub_species = $2;\n\t\t\t}\n\t\t\t\n\t\t\t$self->genus($genus) if $genus;\n\t\t\t$self->sub_species($sub_species) if $sub_species;\n\t\t}\n\t\t\n\t\t$self->{_species} = $species;\n    }\n\treturn $self->{_species};\n}\n\n=head2 genus\n\n Title   : genus\n Usage   : $self->genus( $genus );\n           $genus = $self->genus();\n Function: Get or set the scientific genus name.\n Example : $self->genus('Homo');\n Returns : Scientific genus name as string\n Args    : Scientific genus name as string\n\n\nsub genus {\n    my ($self, $genus) = @_;\n    \n\tif ($genus) {\n        $self->{_genus} = $genus;\n    }\n\t\n\tunless (defined $self->{_genus}) {\n\t\tmy $genus_taxon = $self->{tree}->find_node(-rank => 'genus');\n\t\tunless ($genus_taxon) {\n\t\t\t# just assume our ancestor is rank genus\n\t\t\t$genus_taxon = $self->ancestor;\n\t\t}\n\t\t\n\t\t$self->{_genus} = $genus_taxon->scientific_name if $genus_taxon;\n\t}\n\t\n\treturn $self->{_genus};\n}\n\n=head2 sub_species\n\n Title   : sub_species\n Usage   : $obj->sub_species($newval)\n Function: Get or set the scientific subspecies name.\n Returns : value of sub_species\n Args    : newvalue (optional)\n\n\nsub sub_species {\n    my ($self, $sub) = @_;\n    \n    unless (defined $self->{'_sub_species'}) {\n        my $ss_taxon = $self->{tree}->find_node(-rank => 'subspecies');\n        if ($ss_taxon) {\n            if ($sub) {\n                $ss_taxon->scientific_name($sub);\n                \n                # *** weakening ref to our root node in species() to solve a\n                # memory leak means that we have a subspecies taxon to set\n                # during the first call to species(), but it has vanished by\n                # the time a user subsequently calls sub_species() to get the\n                # value. So we 'cheat' and just store the subspecies name in\n                # our self hash, instead of the tree. Is this a problem for\n                # a Species object? Can't decide --sendu\n                $self->{'_sub_species'} = $sub;\n            }\n            return $ss_taxon->scientific_name;\n        }\n    }\n    \n    # fall back to direct storage on self\n    $self->{'_sub_species'} = $sub if $sub;\n    return $self->{'_sub_species'};\n}\n\n=head2 variant\n\n Title   : variant\n Usage   : $obj->variant($newval)\n Function: Get/set variant information for this species object (strain,\n           isolate, etc).\n Example : \n Returns : value of variant (a scalar)\n Args    : new value (a scalar or undef, optional)","label":"variant($self,$var)"},"line":441,"kind":12,"range":{"end":{"line":457,"character":9999},"start":{"character":0,"line":441}},"definition":"sub","detail":"($self,$var)","children":[{"definition":"my","line":442,"name":"$self","localvar":"my","kind":13,"containerName":"variant"},{"containerName":"variant","kind":13,"name":"$var","line":442},{"line":444,"kind":13,"containerName":"variant","name":"$self"},{"name":"$var_taxon","localvar":"my","containerName":"variant","kind":13,"line":445,"definition":"my"},{"line":445,"kind":13,"containerName":"variant","name":"$self"},{"line":445,"containerName":"variant","kind":12,"name":"find_node"},{"name":"$var_taxon","kind":13,"containerName":"variant","line":446},{"containerName":"variant","kind":13,"name":"$var","line":447},{"line":448,"kind":13,"containerName":"variant","name":"$var_taxon"},{"name":"scientific_name","kind":12,"containerName":"variant","line":448},{"line":448,"containerName":"variant","kind":13,"name":"$var"},{"kind":13,"containerName":"variant","name":"$var_taxon","line":450},{"line":450,"name":"scientific_name","containerName":"variant","kind":12},{"line":455,"kind":13,"containerName":"variant","name":"$self"},{"line":455,"containerName":"variant","kind":13,"name":"$var"},{"line":455,"containerName":"variant","kind":13,"name":"$var"},{"line":456,"name":"$self","containerName":"variant","kind":13}],"name":"variant","containerName":"main::"},{"name":"tree","kind":12,"line":445},{"signature":{"documentation":"1;\n# $Id: Species.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Species\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by James Gilbert <jgrg@sanger.ac.uk>\n# Reimplemented by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Species - Generic species object\n\n=head1 SYNOPSIS\n\n    $species = Bio::Species->new(-classification => [@classification]);\n                                    # Can also pass classification\n                                    # array to new as below\n\n    $species->classification(qw( sapiens Homo Hominidae\n                                 Catarrhini Primates Eutheria\n                                 Mammalia Vertebrata Chordata\n                                 Metazoa Eukaryota ));\n\n    $genus = $species->genus();\n\n    $bi = $species->binomial();     # $bi is now \"Homo sapiens\"\n\n    # For storing common name\n    $species->common_name(\"human\");\n\n    # For storing subspecies\n    $species->sub_species(\"accountant\");\n\n=head1 DESCRIPTION\n\nProvides a very simple object for storing phylogenetic\ninformation.  The classification is stored in an array,\nwhich is a list of nodes in a phylogenetic tree.  Access to\ngetting and setting species and genus is provided, but not\nto any of the other node types (eg: \"phylum\", \"class\",\n\"order\", \"family\").  There's plenty of scope for making the\nmodel more sophisticated, if this is ever needed.\n\nA methods are also provided for storing common\nnames, and subspecies.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nJames Gilbert email B<jgrg@sanger.ac.uk>\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' Let the code begin...\n\npackage Bio::Species;\nuse strict;\n\nuse Bio::DB::Taxonomy;\nuse Bio::Tree::Tree;\nuse Scalar::Util qw(weaken isweak);\nuse base qw(Bio::Taxon);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Species->new(-classification => \\@class)\n Function: Build a new Species object\n Returns : Bio::Species object\n Args    : -ncbi_taxid     => NCBI taxonomic ID (optional)\n           -classification => arrayref of classification\n\n\nsub new {\n    my($class, @args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n    \n    my ($org, $sp, $var, $classification) =\n        $self->_rearrange([qw(ORGANELLE\n\t\t\t\t\t       SUB_SPECIES\n\t\t\t\t\t       VARIANT\n\t\t\t\t\t       CLASSIFICATION)], @args);\n    \n    if (defined $classification && ref($classification) eq \"ARRAY\" && @{$classification}) {\n        $self->classification(@$classification);\n    }\n    else {\n        # store a tree on ourselves so we can use Tree methods\n        $self->{tree} = Bio::Tree::Tree->new();\n        \n        # some things want to freeze/thaw Bio::Species objects, but\n        # _root_cleanup_methods contains a CODE ref, delete it.\n        # delete $self->{tree}->{_root_cleanup_methods};\n    }\n    \n    defined $org && $self->organelle($org);\n    defined $sp  && $self->sub_species($sp); \n    defined $var && $self->variant($var);\n    \n    return $self;\n}\n\n=head2 classification\n\n Title   : classification\n Usage   : $self->classification(@class_array);\n           @classification = $self->classification();\n Function: Get/set the lineage of this species. The array provided must be in\n           the order ... ---> SPECIES, GENUS ---> KINGDOM ---> etc.\n Example : $obj->classification(qw( 'Homo sapiens' Homo Hominidae\n           Catarrhini Primates Eutheria Mammalia Vertebrata\n           Chordata Metazoa Eukaryota));\n Returns : Classification array\n Args    : Classification array \n                 OR\n           A reference to the classification array. In the latter case\n           if there is a second argument and it evaluates to true,\n           names will not be validated. NB: in any case, names are never\n           validated anyway.\n\n\nsub classification {\n    my ($self, @vals) = @_;\n\n    if (@vals) {\n        if (ref($vals[0]) eq 'ARRAY') {\n            @vals = @{$vals[0]};\n        }\n        \n        # make sure the lineage contains us as first or second element\n        # (lineage may have subspecies, species, genus ...)\n        my $name = $self->node_name;\n        my ($genus, $species) = (quotemeta($vals[1]), quotemeta($vals[0]));\n        if ($name && ($name !~ m{$species}i && $name !~ m{$genus}i) && $name !~ m{$vals[1] $vals[0]}i) {\n            if ($name =~ /^$vals[1] $vals[0]\\s*(.+)/) {\n                # just assume the problem is someone tried to make a Bio::Species starting at subspecies\n                #*** no idea if this is appropriate! just a possible fix related to bug 2092\n                $self->sub_species($1);\n                $name = $self->node_name(\"$vals[1] $vals[0]\");\n            }\n            else {\n                $self->warn(\"The supplied lineage does not start near '$name' (I was supplied '\".join(\" | \", @vals).\"')\");\n            }\n        }\n        \n        # create a lineage for ourselves\n        my $db = Bio::DB::Taxonomy->new(-source => 'list', -names => [reverse @vals]);\n        unless ($self->scientific_name) {\n            # assume we're supposed to be the leaf of the supplied lineage\n            $self->scientific_name($vals[0]);\n        }\n        unless ($self->rank) {\n            # and that we are rank species\n            $self->rank('species');\n        }\n        \n        $self->db_handle($db);\n\n        $self->{tree} = Bio::Tree::Tree->new(-node => $self);\n        # some things want to freeze/thaw Bio::Species objects, but tree's\n        # _root_cleanup_methods contains a CODE ref, delete it.\n        #*** even if we don't delete the cleanup methods, we still get memory\n        #    leak-like symtoms, and the actual cleanup causes a mass of\n        #    warnings... needs investigation!\n        delete $self->{tree}->{_root_cleanup_methods};\n    }\n    \n    @vals = ();\n    foreach my $node ($self->{tree}->get_lineage_nodes($self), $self) {\n        unshift(@vals, $node->scientific_name || next);\n    }\n    weaken($self->{tree}->{'_rootnode'}) unless isweak($self->{tree}->{'_rootnode'});\n    return @vals;\n}\n\n=head2 ncbi_taxid\n\n Title   : ncbi_taxid\n Usage   : $obj->ncbi_taxid($newval)\n Function: Get/set the NCBI Taxon ID\n Returns : the NCBI Taxon ID as a string\n Args    : newvalue to set or undef to unset (optional)\n\n\n=head2 common_name\n\n Title   : common_name\n Usage   : $self->common_name( $common_name );\n           $common_name = $self->common_name();\n Function: Get or set the common name of the species\n Example : $self->common_name('human')\n Returns : The common name in a string\n Args    : String, which is the common name (optional)\n\n\n=head2 division\n\n Title   : division\n Usage   : $obj->division($newval)\n Function: Genbank Division for a species\n Returns : value of division (a scalar)\n Args    : value of division (a scalar)\n\n\n=head2 species\n\n Title   : species\n Usage   : $self->species( $species );\n           $species = $self->species();\n Function: Get or set the scientific species name.\n Example : $self->species('Homo sapiens');\n Returns : Scientific species name as string\n Args    : Scientific species name as string\n\n\nsub species {\n    my ($self, $species) = @_;\n    \n\tif ($species) {\n\t\t$self->{_species} = $species;\n\t}\n\t\n\tunless (defined $self->{_species}) {\n\t\t# work it out from our nodes\n\t\tmy $species_taxon = $self->{tree}->find_node(-rank => 'species');\n\t\tunless ($species_taxon) {\n\t\t\t# just assume we are rank species\n\t\t\t$species_taxon = $self;\n\t\t}\n\t\t\n\t\t$species = $species_taxon->scientific_name;\n        \n\t\t#\n\t\t# munge it like the Bio::SeqIO modules used to do\n\t\t# (more or less copy/pasted from old Bio::SeqIO::genbank, hence comments\n\t\t#  referring to 'ORGANISM' etc.)\n\t\t#\n\t\t\n\t\tmy $root = $self->{tree}->get_root_node;\n\t\tunless ($root) {\n            $self->{tree} = Bio::Tree::Tree->new(-node => $species_taxon);\n            delete $self->{tree}->{_root_cleanup_methods};\n            $root = $self->{tree}->get_root_node;\n            weaken($self->{tree}->{'_rootnode'}) unless isweak($self->{tree}->{'_rootnode'});\n        }\n        \n\t\tmy @spflds = split(' ', $species);\n\t\tif (@spflds > 1 && $root->node_name ne 'Viruses') {\n\t\t\t$species = undef;\n\t\t\t\n\t\t\t# does the next term start with uppercase?\n\t\t\t# yes: valid genus; no then unconventional\n\t\t\t# e.g. leaf litter basidiomycete sp. Collb2-39\n\t\t\tmy $genus;\n\t\t\tif ($spflds[0] =~ m/^[A-Z]/) {\n\t\t\t\t$genus = shift(@spflds);\n\t\t\t}\n\t\t\telse {\n\t\t\t\tundef $genus;\n\t\t\t}\n            \n\t\t\tmy $sub_species;\n\t\t\tif (@spflds) {\n\t\t\t\twhile (my $fld = shift @spflds) {\n\t\t\t\t\t$species .= \"$fld \";\n\t\t\t\t\t# does it have subspecies or varieties?\n\t\t\t\t\tlast if ($fld =~ m/(sp\\.|var\\.)/);\n\t\t\t\t}\n\t\t\t\tchop $species;\t# last space\n\t\t\t\t$sub_species = join ' ',@spflds if(@spflds);\n\t\t\t}\n\t\t\telse {\n\t\t\t\t$species = 'sp.';\n\t\t\t}\n\t\t\t\n\t\t\t# does ORGANISM start with any words which make its genus undefined?\n\t\t\t# these are in @unkn_genus\t\n\t\t\t# this in case species starts with uppercase so isn't caught above. \n\t\t\t# alter common name if required\n\t\t\tmy $unconv = 0; # is it unconventional species name?\n\t\t\tmy @unkn_genus = ('unknown','unclassified','uncultured','unidentified');\n\t\t\tforeach (@unkn_genus) {\n\t\t\t\tif ($genus && $genus =~ m/$_/i)\t{\n\t\t\t\t\t$species = $genus . \" \" . $species;\n\t\t\t\t\tundef $genus;\n\t\t\t\t\t$unconv = 1;\n\t\t\t\t\tlast;\n\t\t\t\t}\n\t\t\t\telsif ($species =~ m/$_/i)\t{\n\t\t\t\t\t$unconv = 1;\n\t\t\t\t\tlast;\n\t\t\t\t}\n\t\t\t}\n\t\t\tif (!$unconv && !$sub_species && $species =~ s/^(\\w+)\\s(\\w+)$/$1/)\t{\n\t\t\t\t# need to extract subspecies from conventional ORGANISM format.  \n\t\t\t\t# Will the 'word' in a two element species name\n\t\t\t\t# e.g. $species = 'thummi thummi' => $species='thummi' & \n\t\t\t\t# $sub_species='thummi'\n\t\t\t\t$sub_species = $2;\n\t\t\t}\n\t\t\t\n\t\t\t$self->genus($genus) if $genus;\n\t\t\t$self->sub_species($sub_species) if $sub_species;\n\t\t}\n\t\t\n\t\t$self->{_species} = $species;\n    }\n\treturn $self->{_species};\n}\n\n=head2 genus\n\n Title   : genus\n Usage   : $self->genus( $genus );\n           $genus = $self->genus();\n Function: Get or set the scientific genus name.\n Example : $self->genus('Homo');\n Returns : Scientific genus name as string\n Args    : Scientific genus name as string\n\n\nsub genus {\n    my ($self, $genus) = @_;\n    \n\tif ($genus) {\n        $self->{_genus} = $genus;\n    }\n\t\n\tunless (defined $self->{_genus}) {\n\t\tmy $genus_taxon = $self->{tree}->find_node(-rank => 'genus');\n\t\tunless ($genus_taxon) {\n\t\t\t# just assume our ancestor is rank genus\n\t\t\t$genus_taxon = $self->ancestor;\n\t\t}\n\t\t\n\t\t$self->{_genus} = $genus_taxon->scientific_name if $genus_taxon;\n\t}\n\t\n\treturn $self->{_genus};\n}\n\n=head2 sub_species\n\n Title   : sub_species\n Usage   : $obj->sub_species($newval)\n Function: Get or set the scientific subspecies name.\n Returns : value of sub_species\n Args    : newvalue (optional)\n\n\nsub sub_species {\n    my ($self, $sub) = @_;\n    \n    unless (defined $self->{'_sub_species'}) {\n        my $ss_taxon = $self->{tree}->find_node(-rank => 'subspecies');\n        if ($ss_taxon) {\n            if ($sub) {\n                $ss_taxon->scientific_name($sub);\n                \n                # *** weakening ref to our root node in species() to solve a\n                # memory leak means that we have a subspecies taxon to set\n                # during the first call to species(), but it has vanished by\n                # the time a user subsequently calls sub_species() to get the\n                # value. So we 'cheat' and just store the subspecies name in\n                # our self hash, instead of the tree. Is this a problem for\n                # a Species object? Can't decide --sendu\n                $self->{'_sub_species'} = $sub;\n            }\n            return $ss_taxon->scientific_name;\n        }\n    }\n    \n    # fall back to direct storage on self\n    $self->{'_sub_species'} = $sub if $sub;\n    return $self->{'_sub_species'};\n}\n\n=head2 variant\n\n Title   : variant\n Usage   : $obj->variant($newval)\n Function: Get/set variant information for this species object (strain,\n           isolate, etc).\n Example : \n Returns : value of variant (a scalar)\n Args    : new value (a scalar or undef, optional)\n\n\nsub variant{\n    my ($self, $var) = @_;\n    \n    unless (defined $self->{'_variant'}) {\n        my $var_taxon = $self->{tree}->find_node(-rank => 'variant');\n        if ($var_taxon) {\n            if ($var) {\n                $var_taxon->scientific_name($var);\n            }\n            return $var_taxon->scientific_name;\n        }\n    }\n    \n    # fall back to direct storage on self\n    $self->{'_variant'} = $var if $var;\n    return $self->{'_variant'};\n}\n\n=head2 binomial\n\n Title   : binomial\n Usage   : $binomial = $self->binomial();\n           $binomial = $self->binomial('FULL');\n Function: Returns a string \"Genus species\", or \"Genus species subspecies\",\n           if the first argument is 'FULL' (and the species has a subspecies).\n Args    : Optionally the string 'FULL' to get the full name including\n           the subspecies.","parameters":[{"label":"$self"},{"label":"$full"}],"label":"binomial($self,$full)"},"range":{"end":{"line":494,"character":9999},"start":{"line":471,"character":0}},"kind":12,"line":471,"detail":"($self,$full)","definition":"sub","name":"binomial","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"binomial","localvar":"my","kind":13,"line":472},{"name":"$full","kind":13,"containerName":"binomial","line":472},{"definition":"my","name":"$rank","localvar":"my","kind":13,"containerName":"binomial","line":473},{"line":473,"kind":13,"containerName":"binomial","name":"$self"},{"name":"rank","kind":12,"containerName":"binomial","line":473},{"definition":"my","name":"$species","kind":13,"localvar":"my","containerName":"binomial","line":475},{"line":475,"containerName":"binomial","kind":13,"name":"$genus"},{"containerName":"binomial","kind":13,"name":"$self","line":475},{"line":475,"name":"species","kind":12,"containerName":"binomial"},{"kind":13,"containerName":"binomial","name":"$self","line":475},{"line":475,"containerName":"binomial","kind":12,"name":"genus"},{"kind":13,"containerName":"binomial","name":"$species","line":476},{"kind":13,"containerName":"binomial","name":"$species","line":477},{"kind":13,"containerName":"binomial","name":"$self","line":478},{"containerName":"binomial","kind":12,"name":"warn","line":478},{"name":"$genus","kind":13,"containerName":"binomial","line":480},{"name":"$genus","containerName":"binomial","kind":13,"line":480},{"line":482,"kind":13,"containerName":"binomial","name":"$species"},{"line":484,"name":"$bi","localvar":"my","kind":13,"containerName":"binomial","definition":"my"},{"kind":13,"containerName":"binomial","name":"$full","line":485},{"line":485,"name":"$full","containerName":"binomial","kind":13},{"localvar":"my","kind":13,"containerName":"binomial","name":"$ssp","line":486,"definition":"my"},{"name":"$self","containerName":"binomial","kind":13,"line":486},{"name":"sub_species","kind":12,"containerName":"binomial","line":486},{"line":487,"name":"$ssp","containerName":"binomial","kind":13},{"line":488,"containerName":"binomial","kind":13,"name":"$ssp"},{"containerName":"binomial","kind":13,"name":"$ssp","line":489},{"line":490,"name":"$bi","kind":13,"containerName":"binomial"},{"line":493,"containerName":"binomial","kind":13,"name":"$bi"}]},{"children":[{"kind":13,"localvar":"my","containerName":"validate_species_name","name":"$self","line":513,"definition":"my"},{"line":513,"kind":13,"containerName":"validate_species_name","name":"$string"},{"containerName":"validate_species_name","kind":13,"name":"$string","line":515},{"kind":13,"containerName":"validate_species_name","name":"$string","line":516},{"containerName":"validate_species_name","kind":13,"name":"$string","line":517},{"name":"$self","kind":13,"containerName":"validate_species_name","line":518},{"line":518,"name":"throw","containerName":"validate_species_name","kind":12}],"containerName":"main::","name":"validate_species_name","definition":"sub","detail":"($self,$string)","line":512,"range":{"end":{"line":519,"character":9999},"start":{"line":512,"character":0}},"kind":12,"signature":{"label":"validate_species_name($self,$string)","parameters":[{"label":"$self"},{"label":"$string"}],"documentation":"1;\n# $Id: Species.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Species\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by James Gilbert <jgrg@sanger.ac.uk>\n# Reimplemented by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Species - Generic species object\n\n=head1 SYNOPSIS\n\n    $species = Bio::Species->new(-classification => [@classification]);\n                                    # Can also pass classification\n                                    # array to new as below\n\n    $species->classification(qw( sapiens Homo Hominidae\n                                 Catarrhini Primates Eutheria\n                                 Mammalia Vertebrata Chordata\n                                 Metazoa Eukaryota ));\n\n    $genus = $species->genus();\n\n    $bi = $species->binomial();     # $bi is now \"Homo sapiens\"\n\n    # For storing common name\n    $species->common_name(\"human\");\n\n    # For storing subspecies\n    $species->sub_species(\"accountant\");\n\n=head1 DESCRIPTION\n\nProvides a very simple object for storing phylogenetic\ninformation.  The classification is stored in an array,\nwhich is a list of nodes in a phylogenetic tree.  Access to\ngetting and setting species and genus is provided, but not\nto any of the other node types (eg: \"phylum\", \"class\",\n\"order\", \"family\").  There's plenty of scope for making the\nmodel more sophisticated, if this is ever needed.\n\nA methods are also provided for storing common\nnames, and subspecies.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nJames Gilbert email B<jgrg@sanger.ac.uk>\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' Let the code begin...\n\npackage Bio::Species;\nuse strict;\n\nuse Bio::DB::Taxonomy;\nuse Bio::Tree::Tree;\nuse Scalar::Util qw(weaken isweak);\nuse base qw(Bio::Taxon);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Species->new(-classification => \\@class)\n Function: Build a new Species object\n Returns : Bio::Species object\n Args    : -ncbi_taxid     => NCBI taxonomic ID (optional)\n           -classification => arrayref of classification\n\n\nsub new {\n    my($class, @args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n    \n    my ($org, $sp, $var, $classification) =\n        $self->_rearrange([qw(ORGANELLE\n\t\t\t\t\t       SUB_SPECIES\n\t\t\t\t\t       VARIANT\n\t\t\t\t\t       CLASSIFICATION)], @args);\n    \n    if (defined $classification && ref($classification) eq \"ARRAY\" && @{$classification}) {\n        $self->classification(@$classification);\n    }\n    else {\n        # store a tree on ourselves so we can use Tree methods\n        $self->{tree} = Bio::Tree::Tree->new();\n        \n        # some things want to freeze/thaw Bio::Species objects, but\n        # _root_cleanup_methods contains a CODE ref, delete it.\n        # delete $self->{tree}->{_root_cleanup_methods};\n    }\n    \n    defined $org && $self->organelle($org);\n    defined $sp  && $self->sub_species($sp); \n    defined $var && $self->variant($var);\n    \n    return $self;\n}\n\n=head2 classification\n\n Title   : classification\n Usage   : $self->classification(@class_array);\n           @classification = $self->classification();\n Function: Get/set the lineage of this species. The array provided must be in\n           the order ... ---> SPECIES, GENUS ---> KINGDOM ---> etc.\n Example : $obj->classification(qw( 'Homo sapiens' Homo Hominidae\n           Catarrhini Primates Eutheria Mammalia Vertebrata\n           Chordata Metazoa Eukaryota));\n Returns : Classification array\n Args    : Classification array \n                 OR\n           A reference to the classification array. In the latter case\n           if there is a second argument and it evaluates to true,\n           names will not be validated. NB: in any case, names are never\n           validated anyway.\n\n\nsub classification {\n    my ($self, @vals) = @_;\n\n    if (@vals) {\n        if (ref($vals[0]) eq 'ARRAY') {\n            @vals = @{$vals[0]};\n        }\n        \n        # make sure the lineage contains us as first or second element\n        # (lineage may have subspecies, species, genus ...)\n        my $name = $self->node_name;\n        my ($genus, $species) = (quotemeta($vals[1]), quotemeta($vals[0]));\n        if ($name && ($name !~ m{$species}i && $name !~ m{$genus}i) && $name !~ m{$vals[1] $vals[0]}i) {\n            if ($name =~ /^$vals[1] $vals[0]\\s*(.+)/) {\n                # just assume the problem is someone tried to make a Bio::Species starting at subspecies\n                #*** no idea if this is appropriate! just a possible fix related to bug 2092\n                $self->sub_species($1);\n                $name = $self->node_name(\"$vals[1] $vals[0]\");\n            }\n            else {\n                $self->warn(\"The supplied lineage does not start near '$name' (I was supplied '\".join(\" | \", @vals).\"')\");\n            }\n        }\n        \n        # create a lineage for ourselves\n        my $db = Bio::DB::Taxonomy->new(-source => 'list', -names => [reverse @vals]);\n        unless ($self->scientific_name) {\n            # assume we're supposed to be the leaf of the supplied lineage\n            $self->scientific_name($vals[0]);\n        }\n        unless ($self->rank) {\n            # and that we are rank species\n            $self->rank('species');\n        }\n        \n        $self->db_handle($db);\n\n        $self->{tree} = Bio::Tree::Tree->new(-node => $self);\n        # some things want to freeze/thaw Bio::Species objects, but tree's\n        # _root_cleanup_methods contains a CODE ref, delete it.\n        #*** even if we don't delete the cleanup methods, we still get memory\n        #    leak-like symtoms, and the actual cleanup causes a mass of\n        #    warnings... needs investigation!\n        delete $self->{tree}->{_root_cleanup_methods};\n    }\n    \n    @vals = ();\n    foreach my $node ($self->{tree}->get_lineage_nodes($self), $self) {\n        unshift(@vals, $node->scientific_name || next);\n    }\n    weaken($self->{tree}->{'_rootnode'}) unless isweak($self->{tree}->{'_rootnode'});\n    return @vals;\n}\n\n=head2 ncbi_taxid\n\n Title   : ncbi_taxid\n Usage   : $obj->ncbi_taxid($newval)\n Function: Get/set the NCBI Taxon ID\n Returns : the NCBI Taxon ID as a string\n Args    : newvalue to set or undef to unset (optional)\n\n\n=head2 common_name\n\n Title   : common_name\n Usage   : $self->common_name( $common_name );\n           $common_name = $self->common_name();\n Function: Get or set the common name of the species\n Example : $self->common_name('human')\n Returns : The common name in a string\n Args    : String, which is the common name (optional)\n\n\n=head2 division\n\n Title   : division\n Usage   : $obj->division($newval)\n Function: Genbank Division for a species\n Returns : value of division (a scalar)\n Args    : value of division (a scalar)\n\n\n=head2 species\n\n Title   : species\n Usage   : $self->species( $species );\n           $species = $self->species();\n Function: Get or set the scientific species name.\n Example : $self->species('Homo sapiens');\n Returns : Scientific species name as string\n Args    : Scientific species name as string\n\n\nsub species {\n    my ($self, $species) = @_;\n    \n\tif ($species) {\n\t\t$self->{_species} = $species;\n\t}\n\t\n\tunless (defined $self->{_species}) {\n\t\t# work it out from our nodes\n\t\tmy $species_taxon = $self->{tree}->find_node(-rank => 'species');\n\t\tunless ($species_taxon) {\n\t\t\t# just assume we are rank species\n\t\t\t$species_taxon = $self;\n\t\t}\n\t\t\n\t\t$species = $species_taxon->scientific_name;\n        \n\t\t#\n\t\t# munge it like the Bio::SeqIO modules used to do\n\t\t# (more or less copy/pasted from old Bio::SeqIO::genbank, hence comments\n\t\t#  referring to 'ORGANISM' etc.)\n\t\t#\n\t\t\n\t\tmy $root = $self->{tree}->get_root_node;\n\t\tunless ($root) {\n            $self->{tree} = Bio::Tree::Tree->new(-node => $species_taxon);\n            delete $self->{tree}->{_root_cleanup_methods};\n            $root = $self->{tree}->get_root_node;\n            weaken($self->{tree}->{'_rootnode'}) unless isweak($self->{tree}->{'_rootnode'});\n        }\n        \n\t\tmy @spflds = split(' ', $species);\n\t\tif (@spflds > 1 && $root->node_name ne 'Viruses') {\n\t\t\t$species = undef;\n\t\t\t\n\t\t\t# does the next term start with uppercase?\n\t\t\t# yes: valid genus; no then unconventional\n\t\t\t# e.g. leaf litter basidiomycete sp. Collb2-39\n\t\t\tmy $genus;\n\t\t\tif ($spflds[0] =~ m/^[A-Z]/) {\n\t\t\t\t$genus = shift(@spflds);\n\t\t\t}\n\t\t\telse {\n\t\t\t\tundef $genus;\n\t\t\t}\n            \n\t\t\tmy $sub_species;\n\t\t\tif (@spflds) {\n\t\t\t\twhile (my $fld = shift @spflds) {\n\t\t\t\t\t$species .= \"$fld \";\n\t\t\t\t\t# does it have subspecies or varieties?\n\t\t\t\t\tlast if ($fld =~ m/(sp\\.|var\\.)/);\n\t\t\t\t}\n\t\t\t\tchop $species;\t# last space\n\t\t\t\t$sub_species = join ' ',@spflds if(@spflds);\n\t\t\t}\n\t\t\telse {\n\t\t\t\t$species = 'sp.';\n\t\t\t}\n\t\t\t\n\t\t\t# does ORGANISM start with any words which make its genus undefined?\n\t\t\t# these are in @unkn_genus\t\n\t\t\t# this in case species starts with uppercase so isn't caught above. \n\t\t\t# alter common name if required\n\t\t\tmy $unconv = 0; # is it unconventional species name?\n\t\t\tmy @unkn_genus = ('unknown','unclassified','uncultured','unidentified');\n\t\t\tforeach (@unkn_genus) {\n\t\t\t\tif ($genus && $genus =~ m/$_/i)\t{\n\t\t\t\t\t$species = $genus . \" \" . $species;\n\t\t\t\t\tundef $genus;\n\t\t\t\t\t$unconv = 1;\n\t\t\t\t\tlast;\n\t\t\t\t}\n\t\t\t\telsif ($species =~ m/$_/i)\t{\n\t\t\t\t\t$unconv = 1;\n\t\t\t\t\tlast;\n\t\t\t\t}\n\t\t\t}\n\t\t\tif (!$unconv && !$sub_species && $species =~ s/^(\\w+)\\s(\\w+)$/$1/)\t{\n\t\t\t\t# need to extract subspecies from conventional ORGANISM format.  \n\t\t\t\t# Will the 'word' in a two element species name\n\t\t\t\t# e.g. $species = 'thummi thummi' => $species='thummi' & \n\t\t\t\t# $sub_species='thummi'\n\t\t\t\t$sub_species = $2;\n\t\t\t}\n\t\t\t\n\t\t\t$self->genus($genus) if $genus;\n\t\t\t$self->sub_species($sub_species) if $sub_species;\n\t\t}\n\t\t\n\t\t$self->{_species} = $species;\n    }\n\treturn $self->{_species};\n}\n\n=head2 genus\n\n Title   : genus\n Usage   : $self->genus( $genus );\n           $genus = $self->genus();\n Function: Get or set the scientific genus name.\n Example : $self->genus('Homo');\n Returns : Scientific genus name as string\n Args    : Scientific genus name as string\n\n\nsub genus {\n    my ($self, $genus) = @_;\n    \n\tif ($genus) {\n        $self->{_genus} = $genus;\n    }\n\t\n\tunless (defined $self->{_genus}) {\n\t\tmy $genus_taxon = $self->{tree}->find_node(-rank => 'genus');\n\t\tunless ($genus_taxon) {\n\t\t\t# just assume our ancestor is rank genus\n\t\t\t$genus_taxon = $self->ancestor;\n\t\t}\n\t\t\n\t\t$self->{_genus} = $genus_taxon->scientific_name if $genus_taxon;\n\t}\n\t\n\treturn $self->{_genus};\n}\n\n=head2 sub_species\n\n Title   : sub_species\n Usage   : $obj->sub_species($newval)\n Function: Get or set the scientific subspecies name.\n Returns : value of sub_species\n Args    : newvalue (optional)\n\n\nsub sub_species {\n    my ($self, $sub) = @_;\n    \n    unless (defined $self->{'_sub_species'}) {\n        my $ss_taxon = $self->{tree}->find_node(-rank => 'subspecies');\n        if ($ss_taxon) {\n            if ($sub) {\n                $ss_taxon->scientific_name($sub);\n                \n                # *** weakening ref to our root node in species() to solve a\n                # memory leak means that we have a subspecies taxon to set\n                # during the first call to species(), but it has vanished by\n                # the time a user subsequently calls sub_species() to get the\n                # value. So we 'cheat' and just store the subspecies name in\n                # our self hash, instead of the tree. Is this a problem for\n                # a Species object? Can't decide --sendu\n                $self->{'_sub_species'} = $sub;\n            }\n            return $ss_taxon->scientific_name;\n        }\n    }\n    \n    # fall back to direct storage on self\n    $self->{'_sub_species'} = $sub if $sub;\n    return $self->{'_sub_species'};\n}\n\n=head2 variant\n\n Title   : variant\n Usage   : $obj->variant($newval)\n Function: Get/set variant information for this species object (strain,\n           isolate, etc).\n Example : \n Returns : value of variant (a scalar)\n Args    : new value (a scalar or undef, optional)\n\n\nsub variant{\n    my ($self, $var) = @_;\n    \n    unless (defined $self->{'_variant'}) {\n        my $var_taxon = $self->{tree}->find_node(-rank => 'variant');\n        if ($var_taxon) {\n            if ($var) {\n                $var_taxon->scientific_name($var);\n            }\n            return $var_taxon->scientific_name;\n        }\n    }\n    \n    # fall back to direct storage on self\n    $self->{'_variant'} = $var if $var;\n    return $self->{'_variant'};\n}\n\n=head2 binomial\n\n Title   : binomial\n Usage   : $binomial = $self->binomial();\n           $binomial = $self->binomial('FULL');\n Function: Returns a string \"Genus species\", or \"Genus species subspecies\",\n           if the first argument is 'FULL' (and the species has a subspecies).\n Args    : Optionally the string 'FULL' to get the full name including\n           the subspecies.\n\n\nsub binomial {\n    my ($self, $full) = @_;\n    my $rank = $self->rank || 'no rank';\n    \n    my ($species, $genus) = ($self->species, $self->genus);\n    unless (defined $species) {\n        $species = 'sp.';\n        $self->warn(\"requested binomial but classification was not set\");\n    }\n    $genus = '' unless( defined $genus);\n    \n    $species =~ s/$genus\\s+//;\n    \n    my $bi = \"$genus $species\";\n    if (defined($full) && $full =~ /full/i) { \n        my $ssp = $self->sub_species;\n        if ($ssp) {\n            $ssp =~ s/$bi\\s+//;\n            $ssp =~ s/$species\\s+//;\n            $bi .= \" $ssp\";\n        }\n    }\n    return $bi;\n}\n\n=head2 validate_species_name\n\n Title   : validate_species_name\n Usage   : $result = $self->validate_species_name($string);\n Function: Validate the species portion of the binomial\n Args    : string\n Notes   : The string following the \"genus name\" in the NCBI binomial\n           is so variable that it's not clear that this is a useful\n           function. Consider the binomials \n           \"Simian 11 rotavirus (serotype 3 / strain SA11-Patton)\",\n           or \"St. Thomas 3 rotavirus\", straight from GenBank.\n           This is particularly problematic in microbes and viruses.\n           As such, this isn't actually used automatically by any Bio::Species\n           method."}},{"line":521,"range":{"end":{"line":523,"character":9999},"start":{"character":0,"line":521}},"kind":12,"definition":"sub","children":[],"containerName":"main::","name":"validate_name"},{"range":{"end":{"line":541,"character":9999},"start":{"line":537,"character":0}},"kind":12,"line":537,"definition":"sub","containerName":"main::","name":"organelle","children":[{"definition":"my","line":538,"name":"$self","localvar":"my","containerName":"organelle","kind":13},{"kind":13,"containerName":"organelle","name":"$self","line":539},{"name":"$self","containerName":"organelle","kind":13,"line":540}]},{"children":[{"line":544,"name":"$self","localvar":"my","kind":13,"containerName":"dont_DESTROY","definition":"my"},{"kind":13,"containerName":"dont_DESTROY","name":"$self","line":545},{"kind":12,"containerName":"dont_DESTROY","name":"cleanup_tree","line":545},{"containerName":"dont_DESTROY","kind":13,"name":"$self","line":545},{"line":546,"name":"$self","kind":13,"containerName":"dont_DESTROY"},{"line":547,"kind":13,"containerName":"dont_DESTROY","name":"$self"},{"name":"node_cleanup","kind":12,"containerName":"dont_DESTROY","line":547}],"containerName":"main::","name":"dont_DESTROY","definition":"sub","line":543,"range":{"end":{"line":548,"character":9999},"start":{"character":0,"line":543}},"kind":12},{"name":"tree","kind":12,"line":545},{"line":545,"name":"tree","kind":12},{"kind":12,"name":"tree","line":546}],"version":5}