{"vars":[{"definition":"my","name":"$dumper","localvar":"my","containerName":null,"kind":13,"line":86},{"line":86,"name":"Dumpvalue","containerName":"","kind":2},{"name":"new","kind":12,"line":86},{"kind":12,"name":"Dumpvalue","line":86},{"line":88,"name":"base","kind":2,"containerName":""},{"definition":"our","line":90,"containerName":"main::","kind":13,"name":"$WIDTH"},{"line":92,"kind":12,"range":{"end":{"line":102,"character":9999},"start":{"line":92,"character":0}},"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"","label":"_initialize($self,@args)"},"children":[{"definition":"my","line":93,"localvar":"my","containerName":"_initialize","kind":13,"name":"$self"},{"line":93,"name":"@args","containerName":"_initialize","kind":13},{"name":"$self","kind":13,"containerName":"_initialize","line":94},{"line":94,"kind":13,"containerName":"_initialize","name":"@args"},{"line":95,"name":"$width","kind":13,"localvar":"my","containerName":"_initialize","definition":"my"},{"line":95,"kind":13,"containerName":"_initialize","name":"$self"},{"line":95,"containerName":"_initialize","kind":12,"name":"_rearrange"},{"line":95,"name":"@args","containerName":"_initialize","kind":13},{"containerName":"_initialize","kind":13,"name":"$width","line":96},{"line":96,"name":"$self","containerName":"_initialize","kind":13},{"line":96,"name":"width","kind":12,"containerName":"_initialize"},{"line":96,"kind":13,"containerName":"_initialize","name":"$width"},{"line":97,"kind":13,"containerName":"_initialize","name":"$self"},{"line":97,"containerName":"_initialize","kind":12,"name":"sequence_factory"},{"line":98,"containerName":"_initialize","kind":13,"name":"$self"},{"containerName":"_initialize","kind":12,"name":"sequence_factory","line":98},{"containerName":"_initialize","kind":12,"name":"new","line":99},{"line":99,"containerName":"_initialize","kind":13,"name":"$self"},{"line":99,"kind":12,"containerName":"_initialize","name":"verbose"}],"name":"_initialize","containerName":"main::","definition":"sub","detail":"($self,@args)"},{"name":"SUPER","kind":12,"containerName":"_initialize","line":94},{"line":98,"name":"Bio","kind":12,"containerName":"Seq::SeqFactory"},{"line":114,"range":{"start":{"line":114,"character":0},"end":{"line":141,"character":9999}},"kind":12,"signature":{"label":"next_seq($self,@args)","documentation":"__END__\n# $Id: qual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Copyright (c) 1997-9 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::qual - .qual file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class\n(see L<Bio::SeqIO> for details).\n\n  my $in_qual = Bio::SeqIO->new(-file    => $qualfile,\n                                -format  => 'qual',\n                                -width   => $width,\n                                -verbose => $verbose);\n\n=head1 DESCRIPTION\n\nThis object can transform .qual (similar to fasta) objects to and from\nBio::Seq::Quality objects. See L<Bio::Seq::Quality> for details.\n\nLike the fasta module, it can take an argument '-width' to change the\nnumber of values per line (defaults to 50).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::qual;\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n\nuse base qw(Bio::SeqIO);\n\nour $WIDTH = 25;\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($width) = $self->_rearrange([qw(WIDTH)], @args);\n    $width && $self->width($width);\n    if( ! defined $self->sequence_factory ) {\n        $self->sequence_factory(Bio::Seq::SeqFactory->new\n                                (-verbose => $self->verbose(),\n                                 -type => 'Bio::Seq::PrimaryQual'));\n    }\n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : Bio::Seq::PrimaryQual object\n Notes   : Get the next quality sequence from the stream.","parameters":[{"label":"$self"},{"label":"@args"}]},"children":[{"name":"$self","containerName":"next_seq","localvar":"my","kind":13,"line":115,"definition":"my"},{"name":"@args","kind":13,"containerName":"next_seq","line":115},{"line":116,"name":"$qual","localvar":"my","kind":13,"containerName":"next_seq","definition":"my"},{"name":"$seq","containerName":"next_seq","kind":13,"line":116},{"definition":"my","containerName":"next_seq","localvar":"my","kind":13,"name":"$alphabet","line":117},{"definition":"my","line":120,"containerName":"next_seq","localvar":"my","kind":13,"name":"$entry"},{"line":120,"name":"$self","containerName":"next_seq","kind":13},{"line":120,"kind":12,"containerName":"next_seq","name":"_readline"},{"containerName":"next_seq","kind":13,"name":"$entry","line":122},{"kind":13,"containerName":"next_seq","name":"$entry","line":123},{"name":"$self","containerName":"next_seq","kind":13,"line":123},{"kind":12,"containerName":"next_seq","name":"_readline","line":123},{"definition":"my","line":127,"name":"$top","kind":13,"localvar":"my","containerName":"next_seq"},{"name":"$sequence","kind":13,"containerName":"next_seq","line":127},{"kind":13,"containerName":"next_seq","name":"$entry","line":127},{"containerName":"next_seq","kind":13,"name":"$self","line":128},{"name":"throw","containerName":"next_seq","kind":12,"line":128},{"definition":"my","line":129,"localvar":"my","kind":13,"containerName":"next_seq","name":"$id"},{"kind":13,"containerName":"next_seq","name":"$fulldesc","line":129},{"name":"$top","containerName":"next_seq","kind":13,"line":129},{"line":130,"name":"$self","kind":13,"containerName":"next_seq"},{"line":130,"name":"throw","kind":12,"containerName":"next_seq"},{"kind":13,"containerName":"next_seq","name":"$id","line":131},{"name":"$sequence","kind":13,"containerName":"next_seq","line":133},{"line":134,"name":"$self","kind":13,"containerName":"next_seq"},{"name":"sequence_factory","kind":12,"containerName":"next_seq","line":134},{"containerName":"next_seq","kind":12,"name":"create","line":135},{"name":"$sequence","containerName":"next_seq","kind":13,"line":135},{"name":"$id","containerName":"next_seq","kind":13,"line":136},{"name":"$id","kind":13,"containerName":"next_seq","line":137},{"line":138,"name":"$id","containerName":"next_seq","kind":13},{"name":"$fulldesc","containerName":"next_seq","kind":13,"line":140}],"name":"next_seq","containerName":"main::","definition":"sub","detail":"($self,@args)"},{"range":{"start":{"line":156,"character":0},"end":{"character":9999,"line":159}},"kind":12,"line":156,"name":"_next_qual","containerName":"main::","children":[{"definition":"my","line":157,"localvar":"my","kind":13,"containerName":"_next_qual","name":"$qual"},{"kind":13,"containerName":"_next_qual","name":"$qual","line":158}],"definition":"sub"},{"line":157,"name":"next_primary_qual","kind":12},{"detail":"($self,$as_next_qual)","definition":"sub","name":"next_primary_qual","containerName":"main::","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"next_primary_qual","line":173,"definition":"my"},{"line":173,"kind":13,"containerName":"next_primary_qual","name":"$as_next_qual"},{"definition":"my","line":174,"containerName":"next_primary_qual","localvar":"my","kind":13,"name":"$qual"},{"line":174,"name":"$seq","containerName":"next_primary_qual","kind":13},{"definition":"my","line":177,"name":"$entry","kind":13,"localvar":"my","containerName":"next_primary_qual"},{"line":177,"containerName":"next_primary_qual","kind":13,"name":"$self"},{"line":177,"name":"_readline","containerName":"next_primary_qual","kind":12},{"line":179,"name":"$entry","containerName":"next_primary_qual","kind":13},{"line":180,"name":"$entry","kind":13,"containerName":"next_primary_qual"},{"containerName":"next_primary_qual","kind":13,"name":"$self","line":180},{"line":180,"containerName":"next_primary_qual","kind":12,"name":"_readline"},{"definition":"my","kind":13,"localvar":"my","containerName":"next_primary_qual","name":"$top","line":183},{"line":183,"containerName":"next_primary_qual","kind":13,"name":"$sequence"},{"line":183,"containerName":"next_primary_qual","kind":13,"name":"$entry"},{"containerName":"next_primary_qual","kind":13,"name":"$self","line":184},{"kind":12,"containerName":"next_primary_qual","name":"throw","line":184},{"definition":"my","line":185,"containerName":"next_primary_qual","localvar":"my","kind":13,"name":"$id"},{"name":"$fulldesc","containerName":"next_primary_qual","kind":13,"line":185},{"name":"$top","kind":13,"containerName":"next_primary_qual","line":185},{"line":186,"name":"$self","kind":13,"containerName":"next_primary_qual"},{"line":186,"name":"throw","kind":12,"containerName":"next_primary_qual"},{"name":"$id","containerName":"next_primary_qual","kind":13,"line":187},{"line":189,"kind":13,"containerName":"next_primary_qual","name":"$sequence"},{"containerName":"next_primary_qual","kind":13,"name":"$as_next_qual","line":190},{"line":191,"name":"$qual","kind":13,"containerName":"next_primary_qual"},{"containerName":"next_primary_qual","kind":12,"name":"new","line":191},{"name":"$sequence","containerName":"next_primary_qual","kind":13,"line":191},{"line":192,"containerName":"next_primary_qual","kind":13,"name":"$id"},{"line":193,"name":"$id","kind":13,"containerName":"next_primary_qual"},{"name":"$id","containerName":"next_primary_qual","kind":13,"line":194},{"name":"$fulldesc","containerName":"next_primary_qual","kind":13,"line":196},{"name":"$qual","containerName":"next_primary_qual","kind":13,"line":198}],"signature":{"label":"next_primary_qual($self,$as_next_qual)","documentation":"__END__\n# $Id: qual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Copyright (c) 1997-9 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::qual - .qual file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class\n(see L<Bio::SeqIO> for details).\n\n  my $in_qual = Bio::SeqIO->new(-file    => $qualfile,\n                                -format  => 'qual',\n                                -width   => $width,\n                                -verbose => $verbose);\n\n=head1 DESCRIPTION\n\nThis object can transform .qual (similar to fasta) objects to and from\nBio::Seq::Quality objects. See L<Bio::Seq::Quality> for details.\n\nLike the fasta module, it can take an argument '-width' to change the\nnumber of values per line (defaults to 50).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::qual;\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n\nuse base qw(Bio::SeqIO);\n\nour $WIDTH = 25;\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($width) = $self->_rearrange([qw(WIDTH)], @args);\n    $width && $self->width($width);\n    if( ! defined $self->sequence_factory ) {\n        $self->sequence_factory(Bio::Seq::SeqFactory->new\n                                (-verbose => $self->verbose(),\n                                 -type => 'Bio::Seq::PrimaryQual'));\n    }\n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : Bio::Seq::PrimaryQual object\n Notes   : Get the next quality sequence from the stream.\n\n\nsub next_seq {\n    my ($self,@args) = @_;\n    my ($qual,$seq);\n    my $alphabet;\n    local $/ = \"\\n>\";\n\n    return unless my $entry = $self->_readline;\n\n    if ($entry eq '>') {\t# very first one\n        return unless $entry = $self->_readline;\n    }\n\n    # original: my ($top,$sequence) = $entry =~ /^(.+?)\\n([^>]*)/s\n    my ($top,$sequence) = $entry =~ /^(.+?)\\n([^>]*)/s\n        or $self->throw(\"Can't parse entry [$entry]\");\n    my ($id,$fulldesc) = $top =~ /^\\s*(\\S+)\\s*(.*)/\n        or $self->throw(\"Can't parse fasta header\");\n    $id =~ s/^>//;\n    # create the seq object\n    $sequence =~ s/\\n+/ /g;\n    return $self->sequence_factory->create\n        (-qual        => $sequence,\n         -id         => $id,\n         -primary_id => $id,\n         -display_id => $id,\n         -desc       => $fulldesc\n        );\n}\n\n=head2 _next_qual\n\n Title   : _next_qual\n Usage   : $seq = $stream->_next_qual() (but do not do\n      \t  that. Use $stream->next_seq() instead)\n Function: returns the next quality in the stream\n Returns : Bio::Seq::PrimaryQual object\n Args    : NONE\n Notes\t: An internal method. Gets the next quality in\n\t        the stream.\n\n\nsub _next_qual {\n    my $qual = next_primary_qual( $_[0], 1 );\n    return $qual;\n}\n\n=head2 next_primary_qual()\n\n Title   : next_primary_qual()\n Usage   : $seq = $stream->next_primary_qual()\n Function: returns the next sequence in the stream\n Returns : Bio::PrimaryQual object\n Args    : NONE","parameters":[{"label":"$self"},{"label":"$as_next_qual"}]},"range":{"start":{"line":171,"character":0},"end":{"line":199,"character":9999}},"kind":12,"line":171},{"line":191,"name":"Bio","kind":12,"containerName":"Seq::PrimaryQual"},{"signature":{"label":"width($self,$value)","documentation":"__END__\n# $Id: qual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Copyright (c) 1997-9 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::qual - .qual file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class\n(see L<Bio::SeqIO> for details).\n\n  my $in_qual = Bio::SeqIO->new(-file    => $qualfile,\n                                -format  => 'qual',\n                                -width   => $width,\n                                -verbose => $verbose);\n\n=head1 DESCRIPTION\n\nThis object can transform .qual (similar to fasta) objects to and from\nBio::Seq::Quality objects. See L<Bio::Seq::Quality> for details.\n\nLike the fasta module, it can take an argument '-width' to change the\nnumber of values per line (defaults to 50).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::qual;\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n\nuse base qw(Bio::SeqIO);\n\nour $WIDTH = 25;\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($width) = $self->_rearrange([qw(WIDTH)], @args);\n    $width && $self->width($width);\n    if( ! defined $self->sequence_factory ) {\n        $self->sequence_factory(Bio::Seq::SeqFactory->new\n                                (-verbose => $self->verbose(),\n                                 -type => 'Bio::Seq::PrimaryQual'));\n    }\n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : Bio::Seq::PrimaryQual object\n Notes   : Get the next quality sequence from the stream.\n\n\nsub next_seq {\n    my ($self,@args) = @_;\n    my ($qual,$seq);\n    my $alphabet;\n    local $/ = \"\\n>\";\n\n    return unless my $entry = $self->_readline;\n\n    if ($entry eq '>') {\t# very first one\n        return unless $entry = $self->_readline;\n    }\n\n    # original: my ($top,$sequence) = $entry =~ /^(.+?)\\n([^>]*)/s\n    my ($top,$sequence) = $entry =~ /^(.+?)\\n([^>]*)/s\n        or $self->throw(\"Can't parse entry [$entry]\");\n    my ($id,$fulldesc) = $top =~ /^\\s*(\\S+)\\s*(.*)/\n        or $self->throw(\"Can't parse fasta header\");\n    $id =~ s/^>//;\n    # create the seq object\n    $sequence =~ s/\\n+/ /g;\n    return $self->sequence_factory->create\n        (-qual        => $sequence,\n         -id         => $id,\n         -primary_id => $id,\n         -display_id => $id,\n         -desc       => $fulldesc\n        );\n}\n\n=head2 _next_qual\n\n Title   : _next_qual\n Usage   : $seq = $stream->_next_qual() (but do not do\n      \t  that. Use $stream->next_seq() instead)\n Function: returns the next quality in the stream\n Returns : Bio::Seq::PrimaryQual object\n Args    : NONE\n Notes\t: An internal method. Gets the next quality in\n\t        the stream.\n\n\nsub _next_qual {\n    my $qual = next_primary_qual( $_[0], 1 );\n    return $qual;\n}\n\n=head2 next_primary_qual()\n\n Title   : next_primary_qual()\n Usage   : $seq = $stream->next_primary_qual()\n Function: returns the next sequence in the stream\n Returns : Bio::PrimaryQual object\n Args    : NONE\n\n\nsub next_primary_qual {\n    # print(\"CSM next_primary_qual!\\n\");\n    my( $self, $as_next_qual ) = @_;\n    my ($qual,$seq);\n    local $/ = \"\\n>\";\n\n    return unless my $entry = $self->_readline;\n\n    if ($entry eq '>') {        # very first one\n        return unless $entry = $self->_readline;\n    }\n\n    my ($top,$sequence) = $entry =~ /^(.+?)\\n([^>]*)/s\n        or $self->throw(\"Can't parse entry [$entry]\");\n    my ($id,$fulldesc) = $top =~ /^\\s*(\\S+)\\s*(.*)/\n        or $self->throw(\"Can't parse fasta header\");\n    $id =~ s/^>//;\n    # create the seq object\n    $sequence =~ s/\\n+/ /g;\n    if ($as_next_qual) {\n        $qual = Bio::Seq::PrimaryQual->new(-qual       => $sequence,\n                                           -id         => $id,\n                                           -primary_id => $id,\n                                           -display_id => $id,\n                                           -desc       => $fulldesc\n                                          );\n    }\n    return $qual;\n}\n\n\n=head2 width\n\n Title   : width\n Usage   : $obj->width($newval)\n Function: Get/Set the number of values per line  for FASTA-like output\n Returns : value of width\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"line":213,"kind":12,"range":{"start":{"line":213,"character":0},"end":{"line":219,"character":9999}},"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","name":"$self","containerName":"width","localvar":"my","kind":13,"line":214},{"line":214,"kind":13,"containerName":"width","name":"$value"},{"containerName":"width","kind":13,"name":"$value","line":215},{"containerName":"width","kind":13,"name":"$self","line":216},{"containerName":"width","kind":13,"name":"$value","line":216},{"kind":13,"containerName":"width","name":"$self","line":218},{"name":"$WIDTH","containerName":"width","kind":13,"line":218}],"name":"width","containerName":"main::"},{"containerName":"main::","name":"write_seq","children":[{"localvar":"my","containerName":"write_seq","kind":13,"name":"$self","line":244,"definition":"my"},{"containerName":"write_seq","kind":13,"name":"@args","line":244},{"definition":"my","kind":13,"localvar":"my","containerName":"write_seq","name":"$width","line":245},{"kind":13,"containerName":"write_seq","name":"$self","line":245},{"line":245,"name":"width","kind":12,"containerName":"write_seq"},{"line":246,"containerName":"write_seq","localvar":"my","kind":13,"name":"$source","definition":"my"},{"line":246,"name":"$head","containerName":"write_seq","kind":13},{"kind":13,"containerName":"write_seq","name":"$oneline","line":246},{"line":246,"containerName":"write_seq","kind":13,"name":"$self"},{"kind":12,"containerName":"write_seq","name":"_rearrange","line":246},{"name":"@args","kind":13,"containerName":"write_seq","line":246},{"containerName":"write_seq","kind":13,"name":"$source","line":247},{"line":247,"containerName":"write_seq","kind":13,"name":"$source"},{"name":"isa","containerName":"write_seq","kind":12,"line":247},{"name":"$source","kind":13,"containerName":"write_seq","line":248},{"line":248,"kind":12,"containerName":"write_seq","name":"isa"},{"kind":13,"containerName":"write_seq","name":"$self","line":249},{"name":"throw","containerName":"write_seq","kind":12,"line":249},{"definition":"my","line":252,"kind":13,"localvar":"my","containerName":"write_seq","name":"$header"},{"name":"$source","kind":13,"containerName":"write_seq","line":252},{"line":252,"kind":12,"containerName":"write_seq","name":"can"},{"line":252,"containerName":"write_seq","kind":13,"name":"$source"},{"name":"header","containerName":"write_seq","kind":12,"line":252},{"line":253,"name":"$source","containerName":"write_seq","kind":13},{"line":253,"name":"header","containerName":"write_seq","kind":12},{"line":254,"name":"$source","containerName":"write_seq","kind":13},{"name":"can","containerName":"write_seq","kind":12,"line":254},{"name":"$source","containerName":"write_seq","kind":13,"line":254},{"line":254,"containerName":"write_seq","kind":12,"name":"id"},{"containerName":"write_seq","kind":13,"name":"$source","line":255},{"name":"id","kind":12,"containerName":"write_seq","line":255},{"definition":"my","containerName":"write_seq","localvar":"my","kind":13,"name":"@quals","line":257},{"line":257,"containerName":"write_seq","kind":13,"name":"$source"},{"line":257,"name":"qual","kind":12,"containerName":"write_seq"},{"definition":"my","line":259,"localvar":"my","kind":13,"containerName":"write_seq","name":"$desc"},{"line":259,"name":"$source","containerName":"write_seq","kind":13},{"name":"desc","kind":12,"containerName":"write_seq","line":259},{"containerName":"write_seq","kind":13,"name":"$source","line":259},{"line":259,"kind":12,"containerName":"write_seq","name":"can"},{"containerName":"write_seq","kind":13,"name":"$desc","line":260},{"line":261,"containerName":"write_seq","kind":13,"name":"$self"},{"name":"_print","kind":12,"containerName":"write_seq","line":261},{"definition":"my","line":262,"containerName":"write_seq","localvar":"my","kind":13,"name":"@slice"},{"line":262,"kind":13,"containerName":"write_seq","name":"$max"},{"line":262,"name":"$length","containerName":"write_seq","kind":13},{"kind":13,"containerName":"write_seq","name":"$length","line":263},{"line":263,"containerName":"write_seq","kind":13,"name":"$source"},{"line":263,"name":"length","containerName":"write_seq","kind":12},{"kind":13,"containerName":"write_seq","name":"$oneline","line":265},{"line":265,"kind":13,"containerName":"write_seq","name":"$oneline"},{"name":"$count","kind":13,"localvar":"my","containerName":"write_seq","line":267,"definition":"my"},{"line":267,"kind":13,"containerName":"write_seq","name":"$count"},{"name":"$length","kind":13,"containerName":"write_seq","line":267},{"name":"$count","containerName":"write_seq","kind":13,"line":267},{"name":"$width","containerName":"write_seq","kind":13,"line":267},{"kind":13,"containerName":"write_seq","name":"$count","line":268},{"name":"$width","kind":13,"containerName":"write_seq","line":268},{"containerName":"write_seq","kind":13,"name":"$length","line":268},{"line":269,"name":"$max","containerName":"write_seq","kind":13},{"name":"$length","kind":13,"containerName":"write_seq","line":269},{"kind":13,"containerName":"write_seq","name":"$max","line":271},{"kind":13,"containerName":"write_seq","name":"$count","line":271},{"line":271,"name":"$width","kind":13,"containerName":"write_seq"},{"definition":"my","name":"@slice","containerName":"write_seq","localvar":"my","kind":13,"line":273},{"name":"$source","containerName":"write_seq","kind":13,"line":273},{"name":"subqual","kind":12,"containerName":"write_seq","line":273},{"line":273,"name":"$count","containerName":"write_seq","kind":13},{"line":273,"kind":13,"containerName":"write_seq","name":"$max"},{"name":"$self","kind":13,"containerName":"write_seq","line":274},{"name":"_print","containerName":"write_seq","kind":12,"line":274},{"line":274,"containerName":"write_seq","kind":13,"name":"@slice"}],"detail":"($self,@args)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":243},"end":{"line":276,"character":9999}},"line":243,"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"__END__\n# $Id: qual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Copyright (c) 1997-9 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::qual - .qual file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class\n(see L<Bio::SeqIO> for details).\n\n  my $in_qual = Bio::SeqIO->new(-file    => $qualfile,\n                                -format  => 'qual',\n                                -width   => $width,\n                                -verbose => $verbose);\n\n=head1 DESCRIPTION\n\nThis object can transform .qual (similar to fasta) objects to and from\nBio::Seq::Quality objects. See L<Bio::Seq::Quality> for details.\n\nLike the fasta module, it can take an argument '-width' to change the\nnumber of values per line (defaults to 50).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::qual;\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n\nuse base qw(Bio::SeqIO);\n\nour $WIDTH = 25;\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($width) = $self->_rearrange([qw(WIDTH)], @args);\n    $width && $self->width($width);\n    if( ! defined $self->sequence_factory ) {\n        $self->sequence_factory(Bio::Seq::SeqFactory->new\n                                (-verbose => $self->verbose(),\n                                 -type => 'Bio::Seq::PrimaryQual'));\n    }\n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : Bio::Seq::PrimaryQual object\n Notes   : Get the next quality sequence from the stream.\n\n\nsub next_seq {\n    my ($self,@args) = @_;\n    my ($qual,$seq);\n    my $alphabet;\n    local $/ = \"\\n>\";\n\n    return unless my $entry = $self->_readline;\n\n    if ($entry eq '>') {\t# very first one\n        return unless $entry = $self->_readline;\n    }\n\n    # original: my ($top,$sequence) = $entry =~ /^(.+?)\\n([^>]*)/s\n    my ($top,$sequence) = $entry =~ /^(.+?)\\n([^>]*)/s\n        or $self->throw(\"Can't parse entry [$entry]\");\n    my ($id,$fulldesc) = $top =~ /^\\s*(\\S+)\\s*(.*)/\n        or $self->throw(\"Can't parse fasta header\");\n    $id =~ s/^>//;\n    # create the seq object\n    $sequence =~ s/\\n+/ /g;\n    return $self->sequence_factory->create\n        (-qual        => $sequence,\n         -id         => $id,\n         -primary_id => $id,\n         -display_id => $id,\n         -desc       => $fulldesc\n        );\n}\n\n=head2 _next_qual\n\n Title   : _next_qual\n Usage   : $seq = $stream->_next_qual() (but do not do\n      \t  that. Use $stream->next_seq() instead)\n Function: returns the next quality in the stream\n Returns : Bio::Seq::PrimaryQual object\n Args    : NONE\n Notes\t: An internal method. Gets the next quality in\n\t        the stream.\n\n\nsub _next_qual {\n    my $qual = next_primary_qual( $_[0], 1 );\n    return $qual;\n}\n\n=head2 next_primary_qual()\n\n Title   : next_primary_qual()\n Usage   : $seq = $stream->next_primary_qual()\n Function: returns the next sequence in the stream\n Returns : Bio::PrimaryQual object\n Args    : NONE\n\n\nsub next_primary_qual {\n    # print(\"CSM next_primary_qual!\\n\");\n    my( $self, $as_next_qual ) = @_;\n    my ($qual,$seq);\n    local $/ = \"\\n>\";\n\n    return unless my $entry = $self->_readline;\n\n    if ($entry eq '>') {        # very first one\n        return unless $entry = $self->_readline;\n    }\n\n    my ($top,$sequence) = $entry =~ /^(.+?)\\n([^>]*)/s\n        or $self->throw(\"Can't parse entry [$entry]\");\n    my ($id,$fulldesc) = $top =~ /^\\s*(\\S+)\\s*(.*)/\n        or $self->throw(\"Can't parse fasta header\");\n    $id =~ s/^>//;\n    # create the seq object\n    $sequence =~ s/\\n+/ /g;\n    if ($as_next_qual) {\n        $qual = Bio::Seq::PrimaryQual->new(-qual       => $sequence,\n                                           -id         => $id,\n                                           -primary_id => $id,\n                                           -display_id => $id,\n                                           -desc       => $fulldesc\n                                          );\n    }\n    return $qual;\n}\n\n\n=head2 width\n\n Title   : width\n Usage   : $obj->width($newval)\n Function: Get/Set the number of values per line  for FASTA-like output\n Returns : value of width\n Args    : newvalue (optional)\n\n\n\nsub width{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'width'} = $value;\n    }\n    return $self->{'width'} || $WIDTH;\n}\n\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $obj->write_seq( -source => $source,\n                            -header  => \"some information\"\n                            -oneline => 0);\n Function: Write out a list of quality values to a fasta-style file.\n Returns : Nothing.\n Args    : Requires a reference to a Bio::Seq::Quality object or a\n           PrimaryQual object as the -source. Option 1: information\n           for the header. Option 2: whether the quality score should\n           be on a single line or not\n Notes   : If no -header is provided, $obj->id() will be used where\n           $obj is a reference to either a Quality object or a\n           PrimaryQual object. If $source->id() fails, \"unknown\" will\n           be the header. If the Quality object has $source->length()\n           of \"DIFFERENT\" (read the pod, luke), write_seq will use the\n           length of the PrimaryQual object within the Quality object.","label":"write_seq($self,@args)"}},{"name":"@slice","containerName":null,"localvar":"my","kind":13,"line":278,"definition":"my"},{"kind":13,"containerName":null,"name":"$source","line":278},{"line":278,"kind":12,"containerName":"main::","name":"qual"},{"name":"$self","containerName":null,"kind":13,"line":279},{"line":279,"name":"_print","kind":12,"containerName":"main::"},{"kind":13,"containerName":null,"name":"@slice","line":279},{"line":282,"name":"$self","kind":13,"containerName":null},{"line":282,"kind":12,"containerName":"main::","name":"flush"},{"containerName":null,"kind":13,"name":"$self","line":282},{"containerName":"main::","kind":12,"name":"_flush_on_write","line":282},{"name":"$self","containerName":null,"kind":13,"line":282},{"line":282,"name":"_fh","containerName":"main::","kind":12}],"version":5}