{"version":5,"vars":[{"line":85,"name":"base","kind":2,"containerName":""},{"definition":"our","containerName":"main::","kind":13,"name":"%VALID_TYPE","line":87},{"signature":{"label":"_initialize($self,@args)","documentation":"","parameters":[{"label":"$self"},{"label":"@args"}]},"line":89,"range":{"start":{"line":89,"character":0},"end":{"character":9999,"line":97}},"kind":12,"definition":"sub","detail":"($self,@args)","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"_initialize","line":90,"definition":"my"},{"containerName":"_initialize","kind":13,"name":"@args","line":90},{"line":91,"name":"$self","containerName":"_initialize","kind":13},{"line":91,"containerName":"_initialize","kind":13,"name":"@args"},{"containerName":"_initialize","kind":13,"name":"$self","line":92},{"name":"sequence_factory","containerName":"_initialize","kind":12,"line":92},{"name":"$self","kind":13,"containerName":"_initialize","line":93},{"line":93,"containerName":"_initialize","kind":12,"name":"sequence_factory"},{"name":"new","kind":12,"containerName":"_initialize","line":94},{"line":94,"kind":13,"containerName":"_initialize","name":"$self"},{"name":"verbose","containerName":"_initialize","kind":12,"line":94}],"containerName":"main::","name":"_initialize"},{"line":91,"name":"SUPER","kind":12,"containerName":"_initialize"},{"line":93,"name":"Bio","kind":12,"containerName":"Seq::SeqFactory"},{"kind":12,"range":{"end":{"character":9999,"line":146},"start":{"character":0,"line":109}},"line":109,"signature":{"documentation":"1;\n# $Id: pir.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::PIR\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey <amackey@virginia.edu>\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# October 18, 1999  Largely rewritten by Lincoln Stein\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::pir - PIR sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from pir flat\nfile databases.\n\nNote: This does not completely preserve the PIR format - quality\ninformation about sequence is currently discarded since bioperl\ndoes not have a mechanism for handling these encodings in sequence\ndata.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nAaron Mackey E<lt>amackey@virginia.eduE<gt>\nLincoln Stein E<lt>lstein@cshl.orgE<gt>\nJason Stajich E<lt>jason@bioperl.orgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::pir;\nuse strict;\n\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::SeqIO);\n\nour %VALID_TYPE = map {$_ => 1} qw(P1 F1 DL DC RL RC XX);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n\t\t\t      (-verbose => $self->verbose(),\n\t\t\t       -type => 'Bio::Seq'));\n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    : NONE","parameters":[{"label":"$self"}],"label":"next_seq($self)"},"containerName":"main::","name":"next_seq","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"next_seq","line":110},{"definition":"my","localvar":"my","containerName":"next_seq","kind":13,"name":"$line","line":112},{"name":"$self","containerName":"next_seq","kind":13,"line":112},{"name":"_readline","containerName":"next_seq","kind":12,"line":112},{"line":113,"name":"$line","kind":13,"containerName":"next_seq"},{"containerName":"next_seq","kind":13,"name":"$line","line":114},{"line":114,"kind":13,"containerName":"next_seq","name":"$self"},{"name":"_readline","containerName":"next_seq","kind":12,"line":114},{"definition":"my","line":116,"name":"$top","containerName":"next_seq","localvar":"my","kind":13},{"name":"$desc","containerName":"next_seq","kind":13,"line":116},{"name":"$seq","containerName":"next_seq","kind":13,"line":116},{"line":116,"name":"$line","containerName":"next_seq","kind":13},{"containerName":"next_seq","kind":13,"name":"$self","line":117},{"containerName":"next_seq","kind":12,"name":"throw","line":117},{"definition":"my","line":119,"name":"$type","localvar":"my","kind":13,"containerName":"next_seq"},{"line":119,"kind":13,"containerName":"next_seq","name":"$id"},{"line":120,"name":"$top","kind":13,"containerName":"next_seq"},{"kind":13,"containerName":"next_seq","name":"$type","line":121},{"line":121,"name":"$id","containerName":"next_seq","kind":13},{"kind":13,"containerName":"next_seq","name":"$VALID_TYPE","line":122},{"name":"$type","containerName":"next_seq","kind":13,"line":122},{"line":123,"containerName":"next_seq","kind":13,"name":"$self"},{"containerName":"next_seq","kind":12,"name":"throw","line":123},{"line":126,"name":"$self","kind":13,"containerName":"next_seq"},{"line":126,"name":"throw","kind":12,"containerName":"next_seq"},{"line":133,"name":"$seq","kind":13,"containerName":"next_seq"},{"kind":13,"containerName":"next_seq","name":"$seq","line":134},{"line":135,"kind":13,"containerName":"next_seq","name":"$seq"},{"definition":"my","line":137,"containerName":"next_seq","localvar":"my","kind":13,"name":"$alphabet"},{"line":139,"name":"$self","kind":13,"containerName":"next_seq"},{"line":139,"kind":12,"containerName":"next_seq","name":"sequence_factory"},{"line":140,"kind":12,"containerName":"next_seq","name":"create"},{"containerName":"next_seq","kind":13,"name":"$seq","line":140},{"kind":13,"containerName":"next_seq","name":"$id","line":141},{"name":"$id","containerName":"next_seq","kind":13,"line":142},{"kind":13,"containerName":"next_seq","name":"$desc","line":143},{"line":145,"kind":13,"containerName":"next_seq","name":"$alphabet"}],"detail":"($self)","definition":"sub"},{"children":[{"localvar":"my","containerName":"write_seq","kind":13,"name":"$self","line":160,"definition":"my"},{"name":"@seq","kind":13,"containerName":"write_seq","line":160},{"definition":"my","containerName":"write_seq","localvar":"my","kind":13,"name":"$seq","line":161},{"kind":13,"containerName":"write_seq","name":"@seq","line":161},{"name":"$self","containerName":"write_seq","kind":13,"line":162},{"line":162,"containerName":"write_seq","kind":12,"name":"throw"},{"line":163,"name":"$seq","kind":13,"containerName":"write_seq"},{"line":163,"kind":13,"containerName":"write_seq","name":"$seq"},{"kind":13,"containerName":"write_seq","name":"$seq","line":163},{"containerName":"write_seq","kind":12,"name":"isa","line":163},{"line":165,"name":"$self","kind":13,"containerName":"write_seq"},{"name":"warn","kind":12,"containerName":"write_seq","line":165},{"name":"$seq","containerName":"write_seq","kind":13,"line":165},{"kind":12,"containerName":"write_seq","name":"display_id","line":165},{"line":166,"name":"$seq","kind":13,"containerName":"write_seq"},{"line":166,"kind":12,"containerName":"write_seq","name":"display_id"},{"localvar":"my","containerName":"write_seq","kind":13,"name":"$str","line":168,"definition":"my"},{"line":168,"name":"$seq","containerName":"write_seq","kind":13},{"line":168,"containerName":"write_seq","kind":12,"name":"seq"},{"line":169,"kind":13,"containerName":"write_seq","name":"$self"},{"name":"_print","containerName":"write_seq","kind":12,"line":169},{"line":169,"kind":13,"containerName":"write_seq","name":"$seq"},{"containerName":"write_seq","kind":12,"name":"id","line":169},{"line":170,"containerName":"write_seq","kind":13,"name":"$seq"},{"name":"desc","kind":12,"containerName":"write_seq","line":170},{"containerName":"write_seq","kind":13,"name":"$str","line":171},{"line":174,"name":"$self","containerName":"write_seq","kind":13},{"name":"flush","containerName":"write_seq","kind":12,"line":174},{"name":"$self","kind":13,"containerName":"write_seq","line":174},{"line":174,"containerName":"write_seq","kind":12,"name":"_flush_on_write"},{"line":174,"name":"$self","kind":13,"containerName":"write_seq"},{"name":"_fh","containerName":"write_seq","kind":12,"line":174}],"containerName":"main::","name":"write_seq","definition":"sub","detail":"($self,@seq)","line":159,"kind":12,"range":{"start":{"line":159,"character":0},"end":{"line":176,"character":9999}},"signature":{"label":"write_seq($self,@seq)","parameters":[{"label":"$self"},{"label":"@seq"}],"documentation":"1;\n# $Id: pir.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::PIR\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey <amackey@virginia.edu>\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# October 18, 1999  Largely rewritten by Lincoln Stein\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::pir - PIR sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from pir flat\nfile databases.\n\nNote: This does not completely preserve the PIR format - quality\ninformation about sequence is currently discarded since bioperl\ndoes not have a mechanism for handling these encodings in sequence\ndata.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nAaron Mackey E<lt>amackey@virginia.eduE<gt>\nLincoln Stein E<lt>lstein@cshl.orgE<gt>\nJason Stajich E<lt>jason@bioperl.orgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::pir;\nuse strict;\n\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::SeqIO);\n\nour %VALID_TYPE = map {$_ => 1} qw(P1 F1 DL DC RL RC XX);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n\t\t\t      (-verbose => $self->verbose(),\n\t\t\t       -type => 'Bio::Seq'));\n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    : NONE\n\n\nsub next_seq {\n    my ($self) = @_;\n    local $/ = \"\\n>\";\n    return unless my $line = $self->_readline;\n    if( $line eq '>' ) {\t# handle the very first one having no comment\n\treturn unless $line = $self->_readline;\n    }\n    my ($top, $desc,$seq) = ( $line =~ /^(.+?)\\n(.+?)\\n([^>]*)/s )  or\n\t$self->throw(\"Cannot parse entry PIR entry [$line]\");\n\n    my ( $type,$id );\n\tif ( $top =~ /^>?(\\S{2});(\\S+)\\s*$/ ) {\n\t  ( $type,$id ) = ($1, $2);\n\t  if (!exists $VALID_TYPE{$type} ) {\n\t\t$self->throw(\"PIR stream read attempted without proper two-letter sequence code [ $type ]\");\n\t  }\n\t} else {\n\t  $self->throw(\"Line does not match PIR format [ $line ]\");\n\t}\n\n    # P - indicates complete protein\n    # F - indicates protein fragment\n    # not sure how to stuff these into a Bio object\n    # suitable for writing out.\n    $seq =~ s/\\*//g;\n    $seq =~ s/[\\(\\)\\.\\/\\=\\,]//g;\n    $seq =~ s/\\s+//g;\t\t# get rid of whitespace\n\n    my ($alphabet) = ('protein');\n    # TODO - not processing SFS data\n    return $self->sequence_factory->create\n\t(-seq        => $seq,\n\t -primary_id => $id,\n\t -id         => $id,\n\t -desc       => $desc,\n\t -alphabet   => $alphabet\n\t );\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq(@seq)\n Function: writes the $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : Array of Bio::PrimarySeqI objects"}}]}