{"version":5,"vars":[{"kind":2,"containerName":"","name":"base","line":89},{"children":[{"definition":"my","line":109,"name":"$caller","localvar":"my","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$seq","line":109},{"line":109,"name":"%arg","containerName":"new","kind":13},{"definition":"my","line":110,"localvar":"my","containerName":"new","kind":13,"name":"$class"},{"name":"$caller","kind":13,"containerName":"new","line":110},{"name":"$caller","kind":13,"containerName":"new","line":110},{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"$self","line":111},{"containerName":"new","kind":13,"name":"$seq","line":111},{"kind":13,"containerName":"new","name":"$class","line":111},{"containerName":"new","kind":13,"name":"$self","line":114},{"line":114,"kind":13,"containerName":"new","name":"$arg"},{"line":115,"name":"$self","containerName":"new","kind":13},{"name":"$self","containerName":"new","kind":13,"line":116}],"name":"new","containerName":"main::","definition":"sub","detail":"($caller,$seq,%arg)","line":108,"kind":12,"range":{"end":{"line":117,"character":9999},"start":{"character":0,"line":108}},"signature":{"parameters":[{"label":"$caller"},{"label":"$seq"},{"label":"%arg"}],"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file","label":"new($caller,$seq,%arg)"}},{"name":"seq","kind":12,"line":111},{"name":"map","kind":12,"line":114},{"kind":12,"name":"map","line":114},{"kind":12,"name":"anon_set_counters","line":115},{"line":129,"range":{"end":{"character":9999,"line":262},"start":{"character":0,"line":129}},"kind":12,"definition":"sub","children":[{"line":130,"name":"$self","localvar":"my","containerName":"write_to_game","kind":13,"definition":"my"},{"definition":"my","name":"$seq","localvar":"my","kind":13,"containerName":"write_to_game","line":131},{"line":131,"kind":13,"containerName":"write_to_game","name":"$self"},{"definition":"my","kind":13,"localvar":"my","containerName":"write_to_game","name":"@feats","line":132},{"kind":13,"containerName":"write_to_game","name":"$seq","line":132},{"containerName":"write_to_game","kind":12,"name":"remove_SeqFeatures","line":132},{"localvar":"my","kind":13,"containerName":"write_to_game","name":"@nested_feats","line":135,"definition":"my"},{"line":135,"name":"get_SeqFeatures","kind":12,"containerName":"write_to_game"},{"name":"@feats","containerName":"write_to_game","kind":13,"line":135},{"line":136,"kind":13,"containerName":"write_to_game","name":"@feats"},{"line":136,"containerName":"write_to_game","kind":12,"name":"get_SeqFeatures"},{"name":"@feats","containerName":"write_to_game","kind":13,"line":136},{"line":137,"name":"$seq","containerName":"write_to_game","kind":13},{"line":137,"kind":12,"containerName":"write_to_game","name":"add_SeqFeature"},{"name":"@feats","containerName":"write_to_game","kind":13,"line":137},{"definition":"my","line":173,"localvar":"my","containerName":"write_to_game","kind":13,"name":"$uf"},{"line":173,"kind":12,"containerName":"write_to_game","name":"new"},{"containerName":"write_to_game","kind":13,"name":"$uf","line":174},{"name":"unflatten_seq","containerName":"write_to_game","kind":12,"line":174},{"line":174,"kind":13,"containerName":"write_to_game","name":"$seq"},{"line":180,"name":"$seq","containerName":"write_to_game","kind":13},{"line":180,"containerName":"write_to_game","kind":12,"name":"add_SeqFeature"},{"line":180,"name":"@nested_feats","containerName":"write_to_game","kind":13},{"definition":"my","name":"$atts","localvar":"my","containerName":"write_to_game","kind":13,"line":182},{"definition":"my","name":"$xml","kind":13,"localvar":"my","containerName":"write_to_game","line":183},{"definition":"my","name":"$xml_handle","localvar":"my","kind":13,"containerName":"write_to_game","line":186},{"line":186,"name":"new","kind":12,"containerName":"write_to_game"},{"name":"$xml","containerName":"write_to_game","kind":13,"line":186},{"line":187,"kind":13,"localvar":"my","containerName":"write_to_game","name":"$writer","definition":"my"},{"name":"new","containerName":"write_to_game","kind":12,"line":187},{"line":187,"name":"$xml_handle","kind":13,"containerName":"write_to_game"},{"line":192,"name":"$self","kind":13,"containerName":"write_to_game"},{"kind":13,"containerName":"write_to_game","name":"$writer","line":192},{"containerName":"write_to_game","kind":13,"name":"$writer","line":195},{"containerName":"write_to_game","kind":12,"name":"comment","line":195},{"name":"$writer","containerName":"write_to_game","kind":13,"line":196},{"line":196,"containerName":"write_to_game","kind":12,"name":"comment"},{"line":197,"containerName":"write_to_game","kind":13,"name":"$writer"},{"name":"comment","containerName":"write_to_game","kind":12,"line":197},{"name":"$writer","containerName":"write_to_game","kind":13,"line":198},{"line":198,"kind":12,"containerName":"write_to_game","name":"startTag"},{"kind":13,"localvar":"my","containerName":"write_to_game","name":"@sources","line":200,"definition":"my"},{"line":200,"kind":12,"containerName":"write_to_game","name":"primary_tag"},{"containerName":"write_to_game","kind":13,"name":"$seq","line":200},{"line":200,"kind":12,"containerName":"write_to_game","name":"get_SeqFeatures"},{"definition":"my","line":202,"containerName":"write_to_game","localvar":"my","kind":13,"name":"$source"},{"name":"@sources","containerName":"write_to_game","kind":13,"line":202},{"containerName":"write_to_game","kind":13,"name":"$source","line":203},{"line":203,"containerName":"write_to_game","kind":12,"name":"length"},{"line":203,"kind":13,"containerName":"write_to_game","name":"$seq"},{"line":203,"containerName":"write_to_game","kind":12,"name":"length"},{"name":"$source","containerName":"write_to_game","kind":13,"line":205},{"line":205,"kind":12,"containerName":"write_to_game","name":"has_tag"},{"containerName":"write_to_game","kind":13,"name":"$self","line":206},{"line":207,"kind":13,"containerName":"write_to_game","name":"$atts"},{"line":207,"name":"$source","kind":13,"containerName":"write_to_game"},{"line":207,"name":"get_tag_values","kind":12,"containerName":"write_to_game"},{"line":214,"kind":13,"containerName":"write_to_game","name":"$atts"},{"line":214,"name":"$seq","containerName":"write_to_game","kind":13},{"kind":12,"containerName":"write_to_game","name":"accession_number","line":214},{"line":215,"name":"$seq","containerName":"write_to_game","kind":13},{"line":215,"name":"accession_number","kind":12,"containerName":"write_to_game"},{"containerName":"write_to_game","kind":13,"name":"$seq","line":215},{"kind":12,"containerName":"write_to_game","name":"display_name","line":215},{"name":"$self","containerName":"write_to_game","kind":13,"line":217},{"line":217,"name":"_seq","containerName":"write_to_game","kind":12},{"line":217,"name":"$seq","containerName":"write_to_game","kind":13},{"kind":13,"containerName":"write_to_game","name":"$atts","line":217},{"containerName":"write_to_game","kind":13,"name":"$self","line":220},{"line":221,"localvar":"my","containerName":"write_to_game","kind":13,"name":"$seqtype","definition":"my"},{"line":222,"containerName":"write_to_game","kind":13,"name":"$atts"},{"line":222,"name":"$seq","kind":13,"containerName":"write_to_game"},{"line":222,"name":"alphabet","containerName":"write_to_game","kind":12},{"line":223,"name":"$seqtype","containerName":"write_to_game","kind":13},{"name":"$atts","kind":13,"containerName":"write_to_game","line":223},{"name":"$seq","containerName":"write_to_game","kind":13,"line":223},{"name":"alphabet","containerName":"write_to_game","kind":12,"line":223},{"containerName":"write_to_game","kind":13,"name":"$seqtype","line":226},{"line":229,"name":"$writer","containerName":"write_to_game","kind":13},{"line":229,"containerName":"write_to_game","kind":12,"name":"startTag"},{"line":231,"kind":13,"containerName":"write_to_game","name":"$atts"},{"line":233,"kind":13,"containerName":"write_to_game","name":"$seqtype"},{"localvar":"my","kind":13,"containerName":"write_to_game","name":"$arm","line":235,"definition":"my"},{"line":235,"containerName":"write_to_game","kind":13,"name":"$start"},{"line":235,"name":"$end","kind":13,"containerName":"write_to_game"},{"name":"$atts","containerName":"write_to_game","kind":13,"line":235},{"line":236,"kind":13,"containerName":"write_to_game","name":"$self"},{"kind":12,"containerName":"write_to_game","name":"_element","line":236},{"name":"$arm","containerName":"write_to_game","kind":13,"line":236},{"containerName":"write_to_game","kind":13,"name":"$arm","line":236},{"line":237,"name":"$self","kind":13,"containerName":"write_to_game"},{"kind":12,"containerName":"write_to_game","name":"_span","line":237},{"line":237,"name":"$start","kind":13,"containerName":"write_to_game"},{"containerName":"write_to_game","kind":13,"name":"$end","line":237},{"line":238,"containerName":"write_to_game","kind":13,"name":"$writer"},{"line":238,"name":"endTag","containerName":"write_to_game","kind":12},{"containerName":"write_to_game","kind":13,"name":"$seq","line":241},{"line":241,"name":"top_SeqFeatures","containerName":"write_to_game","kind":12},{"containerName":"write_to_game","kind":12,"name":"isa","line":243},{"line":244,"name":"$self","containerName":"write_to_game","kind":13},{"line":244,"name":"_comp_analysis","kind":12,"containerName":"write_to_game"},{"line":249,"kind":12,"containerName":"write_to_game","name":"get_SeqFeatures"},{"kind":13,"containerName":"write_to_game","name":"$self","line":250},{"line":250,"kind":12,"containerName":"write_to_game","name":"_write_gene"},{"line":253,"name":"primary_tag","containerName":"write_to_game","kind":12},{"line":254,"name":"$self","kind":13,"containerName":"write_to_game"},{"line":254,"name":"_write_feature","containerName":"write_to_game","kind":12},{"line":259,"name":"$writer","kind":13,"containerName":"write_to_game"},{"line":259,"name":"endTag","containerName":"write_to_game","kind":12},{"line":260,"name":"$writer","containerName":"write_to_game","kind":13},{"line":260,"containerName":"write_to_game","kind":12,"name":"end"},{"line":261,"name":"$xml","kind":13,"containerName":"write_to_game"}],"name":"write_to_game","containerName":"main::"},{"name":"seq","kind":12,"line":131},{"name":"Bio","containerName":"SeqFeature::Tools::Unflattener","kind":12,"line":173},{"line":174,"name":"use_magic","kind":12},{"line":186,"name":"IO","containerName":"String","kind":12},{"containerName":"Writer","kind":12,"name":"XML","line":187},{"line":187,"name":"OUTPUT","kind":12},{"line":188,"kind":12,"name":"DATA_MODE"},{"line":189,"name":"DATA_INDENT","kind":12},{"line":190,"name":"NEWLINE","kind":12},{"kind":12,"name":"writer","line":192},{"line":198,"kind":12,"name":"version"},{"line":206,"kind":12,"name":"has_organism"},{"name":"name","kind":12,"line":214},{"line":220,"kind":12,"name":"map"},{"name":"mol_type","kind":12,"line":222},{"line":223,"name":"mol_type","kind":12},{"line":231,"kind":12,"name":"seq"},{"name":"name","kind":12,"line":231},{"name":"type","kind":12,"line":232},{"line":235,"name":"name","kind":12},{"definition":"sub","detail":"($self,$seq,@containers)","children":[{"line":278,"name":"$self","kind":13,"localvar":"my","containerName":"_rearrange_hierarchies","definition":"my"},{"name":"$seq","kind":13,"containerName":"_rearrange_hierarchies","line":278},{"line":278,"name":"@containers","containerName":"_rearrange_hierarchies","kind":13},{"line":279,"localvar":"my","kind":13,"containerName":"_rearrange_hierarchies","name":"@feats","definition":"my"},{"line":279,"containerName":"_rearrange_hierarchies","kind":13,"name":"$seq"},{"line":279,"containerName":"_rearrange_hierarchies","kind":12,"name":"remove_SeqFeatures"},{"name":"@genes","localvar":"my","kind":13,"containerName":"_rearrange_hierarchies","line":280,"definition":"my"},{"line":280,"name":"primary_tag","containerName":"_rearrange_hierarchies","kind":12},{"containerName":"_rearrange_hierarchies","kind":13,"name":"@feats","line":280},{"definition":"my","containerName":"_rearrange_hierarchies","localvar":"my","kind":13,"name":"@addback","line":281},{"line":281,"name":"primary_tag","containerName":"_rearrange_hierarchies","kind":12},{"line":281,"containerName":"_rearrange_hierarchies","kind":13,"name":"@feats"},{"line":283,"name":"@containers","kind":13,"containerName":"_rearrange_hierarchies"},{"definition":"my","line":284,"name":"@has_genes","localvar":"my","containerName":"_rearrange_hierarchies","kind":13},{"line":284,"name":"get_tag_values","containerName":"_rearrange_hierarchies","kind":12},{"line":285,"localvar":"my","containerName":"_rearrange_hierarchies","kind":13,"name":"$has_gene","definition":"my"},{"name":"@has_genes","kind":13,"containerName":"_rearrange_hierarchies","line":285},{"definition":"my","kind":13,"localvar":"my","containerName":"_rearrange_hierarchies","name":"$gene","line":286},{"line":286,"name":"@genes","kind":13,"containerName":"_rearrange_hierarchies"},{"kind":13,"containerName":"_rearrange_hierarchies","name":"$gene","line":287},{"line":288,"name":"$gname","localvar":"my","containerName":"_rearrange_hierarchies","kind":13,"definition":"my"},{"name":"$gene","containerName":"_rearrange_hierarchies","kind":13,"line":288},{"line":288,"kind":12,"containerName":"_rearrange_hierarchies","name":"get_tag_values"},{"containerName":"_rearrange_hierarchies","kind":13,"name":"$gname","line":289},{"line":289,"name":"$has_gene","containerName":"_rearrange_hierarchies","kind":13},{"line":290,"containerName":"_rearrange_hierarchies","kind":12,"name":"add_SeqFeature"},{"line":290,"kind":13,"containerName":"_rearrange_hierarchies","name":"$gene"},{"kind":13,"containerName":"_rearrange_hierarchies","name":"$gene","line":291},{"containerName":"_rearrange_hierarchies","kind":13,"name":"@addback","line":297},{"line":297,"containerName":"_rearrange_hierarchies","kind":13,"name":"@containers"},{"kind":13,"containerName":"_rearrange_hierarchies","name":"@genes","line":297},{"containerName":"_rearrange_hierarchies","kind":13,"name":"$seq","line":298},{"name":"add_SeqFeature","containerName":"_rearrange_hierarchies","kind":12,"line":298},{"line":298,"name":"@addback","containerName":"_rearrange_hierarchies","kind":13}],"containerName":"main::","name":"_rearrange_hierarchies","signature":{"label":"_rearrange_hierarchies($self,$seq,@containers)","parameters":[{"label":"$self"},{"label":"$seq"},{"label":"@containers"}],"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed"},"line":277,"range":{"end":{"line":299,"character":9999},"start":{"line":277,"character":0}},"kind":12},{"detail":"($self,$feat,$bare)","definition":"sub","containerName":"main::","name":"_write_feature","children":[{"definition":"my","line":314,"localvar":"my","containerName":"_write_feature","kind":13,"name":"$self"},{"line":314,"name":"$feat","kind":13,"containerName":"_write_feature"},{"line":314,"containerName":"_write_feature","kind":13,"name":"$bare"},{"definition":"my","name":"$writer","localvar":"my","kind":13,"containerName":"_write_feature","line":315},{"line":315,"name":"$self","kind":13,"containerName":"_write_feature"},{"line":316,"name":"$id","localvar":"my","containerName":"_write_feature","kind":13,"definition":"my"},{"line":318,"containerName":"_write_feature","kind":13,"name":"$feat"},{"name":"primary_tag","kind":12,"containerName":"_write_feature","line":318},{"name":"$id","containerName":"_write_feature","kind":13,"line":319},{"containerName":"_write_feature","kind":13,"name":"$self","line":319},{"kind":12,"containerName":"_write_feature","name":"_find_name","line":319},{"line":319,"containerName":"_write_feature","kind":13,"name":"$feat"},{"line":320,"kind":13,"containerName":"_write_feature","name":"$id"},{"line":323,"name":"$id","kind":13,"containerName":"_write_feature"},{"name":"$feat","kind":13,"containerName":"_write_feature","line":323},{"kind":12,"containerName":"_write_feature","name":"primary_tag","line":323},{"line":323,"name":"$self","containerName":"_write_feature","kind":13},{"line":323,"name":"$feat","kind":13,"containerName":"_write_feature"},{"line":323,"containerName":"_write_feature","kind":12,"name":"primary_tag"},{"containerName":"_write_feature","kind":13,"name":"$bare","line":325},{"line":326,"containerName":"_write_feature","kind":13,"name":"$writer"},{"kind":12,"containerName":"_write_feature","name":"startTag","line":326},{"line":326,"containerName":"_write_feature","kind":13,"name":"$id"},{"line":327,"name":"$self","containerName":"_write_feature","kind":13},{"containerName":"_write_feature","kind":12,"name":"_element","line":327},{"containerName":"_write_feature","kind":13,"name":"$id","line":327},{"line":328,"kind":13,"containerName":"_write_feature","name":"$self"},{"line":328,"containerName":"_write_feature","kind":12,"name":"_element"},{"line":328,"containerName":"_write_feature","kind":13,"name":"$feat"},{"line":328,"name":"primary_tag","kind":12,"containerName":"_write_feature"},{"kind":13,"containerName":"_write_feature","name":"$writer","line":331},{"name":"startTag","kind":12,"containerName":"_write_feature","line":331},{"line":331,"kind":13,"containerName":"_write_feature","name":"$id"},{"name":"$self","containerName":"_write_feature","kind":13,"line":332},{"line":332,"containerName":"_write_feature","kind":12,"name":"_element"},{"kind":13,"containerName":"_write_feature","name":"$id","line":332},{"name":"$self","kind":13,"containerName":"_write_feature","line":333},{"kind":12,"containerName":"_write_feature","name":"_element","line":333},{"line":333,"containerName":"_write_feature","kind":13,"name":"$feat"},{"containerName":"_write_feature","kind":12,"name":"primary_tag","line":333},{"line":334,"containerName":"_write_feature","kind":13,"name":"$self"},{"containerName":"_write_feature","kind":12,"name":"_render_tags","line":334},{"kind":13,"containerName":"_write_feature","name":"$feat","line":334},{"name":"$self","containerName":"_write_feature","kind":13,"line":339},{"name":"_feature_span","kind":12,"containerName":"_write_feature","line":339},{"line":339,"name":"$id","containerName":"_write_feature","kind":13},{"line":339,"name":"$feat","containerName":"_write_feature","kind":13},{"containerName":"_write_feature","kind":13,"name":"$writer","line":340},{"line":340,"name":"endTag","containerName":"_write_feature","kind":12},{"name":"$writer","containerName":"_write_feature","kind":13,"line":341},{"containerName":"_write_feature","kind":12,"name":"endTag","line":341},{"line":341,"containerName":"_write_feature","kind":13,"name":"$bare"}],"signature":{"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper","parameters":[{"label":"$self"},{"label":"$feat"},{"label":"$bare"}],"label":"_write_feature($self,$feat,$bare)"},"kind":12,"range":{"end":{"character":9999,"line":342},"start":{"character":0,"line":313}},"line":313},{"name":"writer","kind":12,"line":315},{"line":323,"kind":12,"name":"id"},{"name":"id","kind":12,"line":326},{"name":"id","kind":12,"line":331},{"line":335,"name":"_render_date_tags","kind":12},{"line":336,"kind":12,"name":"_render_comment_tags"},{"kind":12,"name":"_render_tags_as_properties","line":338},{"signature":{"label":"_write_gene($self,$feat)","parameters":[{"label":"$self"},{"label":"$feat"}],"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier"},"range":{"end":{"line":585,"character":9999},"start":{"line":359,"character":0}},"kind":12,"line":359,"detail":"($self,$feat)","definition":"sub","name":"_write_gene","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"_write_gene","kind":13,"line":360,"definition":"my"},{"line":360,"name":"$feat","containerName":"_write_gene","kind":13},{"line":361,"name":"$writer","localvar":"my","kind":13,"containerName":"_write_gene","definition":"my"},{"line":361,"containerName":"_write_gene","kind":13,"name":"$self"},{"line":362,"name":"$str","kind":13,"localvar":"my","containerName":"_write_gene","definition":"my"},{"line":362,"name":"$feat","containerName":"_write_gene","kind":13},{"line":362,"kind":12,"containerName":"_write_gene","name":"strand"},{"name":"$id","localvar":"my","containerName":"_write_gene","kind":13,"line":363,"definition":"my"},{"name":"$self","containerName":"_write_gene","kind":13,"line":363},{"line":363,"kind":12,"containerName":"_write_gene","name":"_find_name"},{"name":"$feat","containerName":"_write_gene","kind":13,"line":363},{"name":"$self","containerName":"_write_gene","kind":13,"line":364},{"line":364,"name":"_find_name","kind":12,"containerName":"_write_gene"},{"line":364,"name":"$feat","containerName":"_write_gene","kind":13},{"line":365,"name":"$self","kind":13,"containerName":"_write_gene"},{"name":"_find_name","kind":12,"containerName":"_write_gene","line":365},{"line":365,"name":"$feat","kind":13,"containerName":"_write_gene"},{"line":365,"kind":13,"containerName":"_write_gene","name":"$feat"},{"line":365,"containerName":"_write_gene","kind":12,"name":"primary_tag"},{"name":"$self","kind":13,"containerName":"_write_gene","line":366},{"name":"_find_name","containerName":"_write_gene","kind":12,"line":366},{"containerName":"_write_gene","kind":13,"name":"$feat","line":366},{"line":367,"containerName":"_write_gene","kind":13,"name":"$self"},{"line":367,"kind":12,"containerName":"_write_gene","name":"_find_name"},{"containerName":"_write_gene","kind":13,"name":"$feat","line":367},{"line":368,"name":"$self","containerName":"_write_gene","kind":13},{"line":368,"name":"throw","containerName":"_write_gene","kind":12},{"line":368,"name":"$feat","kind":13,"containerName":"_write_gene"},{"line":368,"name":"display_name","containerName":"_write_gene","kind":12},{"definition":"my","line":372,"kind":13,"localvar":"my","containerName":"_write_gene","name":"$gid"},{"name":"$self","kind":13,"containerName":"_write_gene","line":372},{"line":372,"kind":12,"containerName":"_write_gene","name":"_find_name"},{"line":372,"kind":13,"containerName":"_write_gene","name":"$feat"},{"name":"$id","kind":13,"containerName":"_write_gene","line":372},{"line":374,"name":"$writer","kind":13,"containerName":"_write_gene"},{"containerName":"_write_gene","kind":12,"name":"startTag","line":374},{"kind":13,"containerName":"_write_gene","name":"$id","line":374},{"kind":13,"containerName":"_write_gene","name":"$self","line":375},{"line":375,"kind":12,"containerName":"_write_gene","name":"_element"},{"line":375,"containerName":"_write_gene","kind":13,"name":"$gid"},{"name":"$self","containerName":"_write_gene","kind":13,"line":376},{"containerName":"_write_gene","kind":12,"name":"_element","line":376},{"line":376,"containerName":"_write_gene","kind":13,"name":"$feat"},{"line":376,"name":"primary_tag","kind":12,"containerName":"_write_gene"},{"name":"$self","kind":13,"containerName":"_write_gene","line":377},{"line":377,"name":"_render_tags","containerName":"_write_gene","kind":12},{"name":"$feat","kind":13,"containerName":"_write_gene","line":377},{"definition":"my","line":384,"containerName":"_write_gene","localvar":"my","kind":13,"name":"@genes"},{"line":386,"name":"$feat","containerName":"_write_gene","kind":13},{"kind":12,"containerName":"_write_gene","name":"primary_tag","line":386},{"line":387,"name":"@genes","kind":13,"containerName":"_write_gene"},{"line":387,"containerName":"_write_gene","kind":13,"name":"$feat"},{"line":391,"kind":13,"containerName":"_write_gene","name":"@genes"},{"line":391,"kind":12,"containerName":"_write_gene","name":"primary_tag"},{"line":391,"name":"$feat","kind":13,"containerName":"_write_gene"},{"line":391,"kind":12,"containerName":"_write_gene","name":"get_SeqFeatures"},{"definition":"my","name":"$g","kind":13,"localvar":"my","containerName":"_write_gene","line":394},{"line":394,"name":"@genes","kind":13,"containerName":"_write_gene"},{"definition":"my","name":"$id","localvar":"my","kind":13,"containerName":"_write_gene","line":395},{"line":395,"name":"$self","kind":13,"containerName":"_write_gene"},{"containerName":"_write_gene","kind":12,"name":"_find_name","line":395},{"line":395,"containerName":"_write_gene","kind":13,"name":"$g"},{"name":"$self","kind":13,"containerName":"_write_gene","line":396},{"line":396,"name":"_find_name","kind":12,"containerName":"_write_gene"},{"line":396,"name":"$g","containerName":"_write_gene","kind":13},{"kind":13,"containerName":"_write_gene","name":"$self","line":397},{"line":397,"name":"_find_name","containerName":"_write_gene","kind":12},{"line":397,"name":"$feat","containerName":"_write_gene","kind":13},{"containerName":"_write_gene","kind":13,"name":"$self","line":398},{"name":"_find_name","kind":12,"containerName":"_write_gene","line":398},{"name":"$feat","containerName":"_write_gene","kind":13,"line":398},{"name":"$self","containerName":"_write_gene","kind":13,"line":399},{"line":399,"kind":12,"containerName":"_write_gene","name":"throw"},{"definition":"my","name":"$gid","containerName":"_write_gene","localvar":"my","kind":13,"line":400},{"name":"$self","kind":13,"containerName":"_write_gene","line":400},{"kind":12,"containerName":"_write_gene","name":"_find_name","line":400},{"kind":13,"containerName":"_write_gene","name":"$g","line":400},{"line":400,"name":"$self","containerName":"_write_gene","kind":13},{"line":400,"kind":12,"containerName":"_write_gene","name":"_find_name"},{"line":400,"containerName":"_write_gene","kind":13,"name":"$g"},{"name":"$writer","containerName":"_write_gene","kind":13,"line":402},{"containerName":"_write_gene","kind":12,"name":"startTag","line":402},{"kind":13,"containerName":"_write_gene","name":"$self","line":403},{"line":403,"name":"_element","containerName":"_write_gene","kind":12},{"line":403,"name":"$gid","containerName":"_write_gene","kind":13},{"containerName":"_write_gene","kind":13,"name":"$writer","line":404},{"line":404,"name":"endTag","kind":12,"containerName":"_write_gene"},{"definition":"my","line":406,"containerName":"_write_gene","localvar":"my","kind":13,"name":"$proteins"},{"definition":"my","kind":13,"localvar":"my","containerName":"_write_gene","name":"@mRNAs","line":407},{"name":"primary_tag","kind":12,"containerName":"_write_gene","line":407},{"line":407,"name":"$g","kind":13,"containerName":"_write_gene"},{"line":407,"kind":12,"containerName":"_write_gene","name":"get_SeqFeatures"},{"line":408,"name":"@other_stuff","localvar":"my","kind":13,"containerName":"_write_gene","definition":"my"},{"name":"primary_tag","kind":12,"containerName":"_write_gene","line":408},{"line":408,"name":"$g","kind":13,"containerName":"_write_gene"},{"name":"get_SeqFeatures","kind":12,"containerName":"_write_gene","line":408},{"definition":"my","line":409,"name":"@variants","localvar":"my","containerName":"_write_gene","kind":13},{"definition":"my","name":"$mRNA","localvar":"my","containerName":"_write_gene","kind":13,"line":411},{"kind":13,"containerName":"_write_gene","name":"@mRNAs","line":411},{"line":412,"localvar":"my","kind":13,"containerName":"_write_gene","name":"$sn","definition":"my"},{"line":412,"kind":13,"containerName":"_write_gene","name":"@units"},{"name":"$mRNA","containerName":"_write_gene","kind":13,"line":416},{"line":416,"name":"primary_tag","kind":12,"containerName":"_write_gene"},{"definition":"my","line":417,"containerName":"_write_gene","localvar":"my","kind":13,"name":"$exon"},{"name":"new","containerName":"_write_gene","kind":12,"line":417},{"line":418,"name":"$exon","kind":13,"containerName":"_write_gene"},{"line":418,"kind":12,"containerName":"_write_gene","name":"location"},{"line":418,"kind":13,"containerName":"_write_gene","name":"$mRNA"},{"line":418,"name":"location","kind":12,"containerName":"_write_gene"},{"line":419,"name":"$mRNA","kind":13,"containerName":"_write_gene"},{"line":419,"name":"add_SeqFeature","kind":12,"containerName":"_write_gene"},{"line":419,"kind":13,"containerName":"_write_gene","name":"$exon"},{"line":423,"kind":13,"containerName":"_write_gene","name":"$mRNA"},{"line":423,"name":"get_SeqFeatures","containerName":"_write_gene","kind":12},{"kind":13,"containerName":"_write_gene","name":"$self","line":424},{"line":424,"name":"_write_feature","containerName":"_write_gene","kind":12},{"containerName":"_write_gene","kind":13,"name":"$mRNA","line":424},{"line":429,"name":"$name","kind":13,"localvar":"my","containerName":"_write_gene","definition":"my"},{"name":"$self","containerName":"_write_gene","kind":13,"line":429},{"line":429,"kind":12,"containerName":"_write_gene","name":"_find_name"},{"line":429,"containerName":"_write_gene","kind":13,"name":"$mRNA"},{"containerName":"_write_gene","kind":13,"name":"$mRNA","line":429},{"containerName":"_write_gene","kind":12,"name":"primary_tag","line":429},{"line":430,"name":"$self","kind":13,"containerName":"_write_gene"},{"containerName":"_write_gene","kind":12,"name":"_find_name","line":430},{"name":"$mRNA","containerName":"_write_gene","kind":13,"line":430},{"name":"%attributes","localvar":"my","kind":13,"containerName":"_write_gene","line":432,"definition":"my"},{"definition":"my","line":433,"name":"$cds","kind":13,"localvar":"my","containerName":"_write_gene"},{"line":433,"name":"primary_tag","kind":12,"containerName":"_write_gene"},{"line":433,"name":"$mRNA","kind":13,"containerName":"_write_gene"},{"name":"get_SeqFeatures","containerName":"_write_gene","kind":12,"line":433},{"line":438,"name":"$cds","kind":13,"containerName":"_write_gene"},{"name":"@mRNAs","containerName":"_write_gene","kind":13,"line":438},{"line":438,"name":"$name","containerName":"_write_gene","kind":13},{"containerName":"_write_gene","kind":13,"name":"$cds","line":439},{"line":439,"kind":13,"containerName":"_write_gene","name":"$self"},{"name":"_check_cds","containerName":"_write_gene","kind":12,"line":439},{"line":439,"containerName":"_write_gene","kind":13,"name":"$cds"},{"line":439,"name":"$name","containerName":"_write_gene","kind":13},{"line":441,"kind":13,"containerName":"_write_gene","name":"$cds"},{"line":441,"containerName":"_write_gene","kind":13,"name":"@mRNAs"},{"line":443,"kind":13,"containerName":"_write_gene","name":"$cds"},{"kind":12,"containerName":"_write_gene","name":"has_tag","line":443},{"line":444,"name":"$name","kind":13,"containerName":"_write_gene"},{"line":444,"kind":13,"containerName":"_write_gene","name":"$cds"},{"line":444,"kind":12,"containerName":"_write_gene","name":"get_tag_values"},{"line":448,"kind":13,"containerName":"_write_gene","name":"$name"},{"name":"$name","kind":13,"containerName":"_write_gene","line":450},{"line":450,"name":"$id","containerName":"_write_gene","kind":13},{"line":450,"kind":13,"containerName":"_write_gene","name":"@variants"},{"definition":"my","line":453,"kind":13,"localvar":"my","containerName":"_write_gene","name":"$pname"},{"line":455,"name":"$cds","containerName":"_write_gene","kind":13},{"containerName":"_write_gene","kind":13,"name":"$sn","line":456},{"name":"$cds","containerName":"_write_gene","kind":13,"line":456},{"line":456,"name":"get_tag_values","containerName":"_write_gene","kind":12},{"line":457,"kind":13,"containerName":"_write_gene","name":"$cds"},{"line":457,"kind":12,"containerName":"_write_gene","name":"has_tag"},{"line":458,"name":"$sn","containerName":"_write_gene","kind":13},{"name":"$cds","kind":13,"containerName":"_write_gene","line":458},{"name":"get_tag_values","containerName":"_write_gene","kind":12,"line":458},{"name":"$cds","kind":13,"containerName":"_write_gene","line":459},{"containerName":"_write_gene","kind":12,"name":"has_tag","line":459},{"kind":13,"localvar":"my","containerName":"_write_gene","name":"$psn","line":462,"definition":"my"},{"line":462,"containerName":"_write_gene","kind":13,"name":"$self"},{"name":"protein_id","kind":12,"containerName":"_write_gene","line":462},{"name":"$cds","kind":13,"containerName":"_write_gene","line":462},{"line":462,"name":"$sn","kind":13,"containerName":"_write_gene"},{"line":463,"name":"$self","kind":13,"containerName":"_write_gene"},{"line":463,"name":"$psn","kind":13,"containerName":"_write_gene"},{"line":466,"kind":13,"containerName":"_write_gene","name":"$feat"},{"line":466,"name":"has_tag","kind":12,"containerName":"_write_gene"},{"name":"$feat","kind":13,"containerName":"_write_gene","line":467},{"line":467,"name":"add_tag_value","containerName":"_write_gene","kind":12},{"line":467,"name":"$psn","kind":13,"containerName":"_write_gene"},{"localvar":"my","containerName":"_write_gene","kind":13,"name":"$c_start","line":471,"definition":"my"},{"line":471,"kind":13,"containerName":"_write_gene","name":"$c_end"},{"name":"$cds","kind":13,"containerName":"_write_gene","line":472},{"line":472,"name":"has_tag","containerName":"_write_gene","kind":12},{"kind":13,"containerName":"_write_gene","name":"$c_start","line":473},{"containerName":"_write_gene","kind":13,"name":"$cds","line":473},{"line":473,"name":"get_tag_values","containerName":"_write_gene","kind":12},{"name":"$cds","containerName":"_write_gene","kind":13,"line":474},{"line":474,"kind":12,"containerName":"_write_gene","name":"remove_tag"},{"line":477,"containerName":"_write_gene","kind":13,"name":"$c_start"},{"definition":"my","line":479,"containerName":"_write_gene","localvar":"my","kind":13,"name":"$cs"},{"line":479,"name":"new","kind":12,"containerName":"_write_gene"},{"line":480,"kind":13,"containerName":"_write_gene","name":"$c_start"},{"kind":13,"containerName":"_write_gene","name":"$c_start","line":481},{"line":481,"name":"$cds","kind":13,"containerName":"_write_gene"},{"line":481,"name":"strand","containerName":"_write_gene","kind":12},{"line":481,"kind":13,"containerName":"_write_gene","name":"$cds"},{"containerName":"_write_gene","kind":12,"name":"start","line":481},{"line":481,"containerName":"_write_gene","kind":13,"name":"$cds"},{"name":"end","containerName":"_write_gene","kind":12,"line":481},{"kind":13,"containerName":"_write_gene","name":"$cds","line":483},{"line":483,"name":"strand","containerName":"_write_gene","kind":12},{"line":484,"containerName":"_write_gene","kind":13,"name":"$c_end"},{"containerName":"_write_gene","kind":13,"name":"$c_start","line":484},{"line":485,"kind":13,"containerName":"_write_gene","name":"$c_start"},{"line":485,"containerName":"_write_gene","kind":13,"name":"$c_start"},{"name":"$c_end","kind":13,"containerName":"_write_gene","line":488},{"name":"$c_start","kind":13,"containerName":"_write_gene","line":488},{"kind":13,"containerName":"_write_gene","name":"$cs","line":490},{"line":490,"name":"start","kind":12,"containerName":"_write_gene"},{"name":"$c_start","kind":13,"containerName":"_write_gene","line":490},{"line":491,"name":"$cs","kind":13,"containerName":"_write_gene"},{"line":491,"name":"end","kind":12,"containerName":"_write_gene"},{"name":"$c_end","containerName":"_write_gene","kind":13,"line":491},{"line":492,"name":"$cs","kind":13,"containerName":"_write_gene"},{"line":492,"name":"strand","kind":12,"containerName":"_write_gene"},{"name":"$cds","kind":13,"containerName":"_write_gene","line":492},{"line":492,"containerName":"_write_gene","kind":12,"name":"strand"},{"line":493,"name":"$cs","containerName":"_write_gene","kind":13},{"name":"primary_tag","containerName":"_write_gene","kind":12,"line":493},{"containerName":"_write_gene","kind":13,"name":"$cs","line":494},{"line":494,"name":"add_tag_value","kind":12,"containerName":"_write_gene"},{"line":494,"kind":13,"containerName":"_write_gene","name":"$name"},{"containerName":"_write_gene","kind":13,"name":"@units","line":495},{"name":"$cs","kind":13,"containerName":"_write_gene","line":495},{"containerName":"_write_gene","kind":13,"name":"$cds","line":498},{"name":"has_tag","kind":12,"containerName":"_write_gene","line":498},{"line":499,"containerName":"_write_gene","localvar":"my","kind":13,"name":"$val","definition":"my"},{"kind":13,"containerName":"_write_gene","name":"$cds","line":499},{"containerName":"_write_gene","kind":12,"name":"get_tag_values","line":499},{"name":"$cds","kind":13,"containerName":"_write_gene","line":500},{"name":"remove_tag","kind":12,"containerName":"_write_gene","line":500},{"line":501,"kind":13,"containerName":"_write_gene","name":"$attributes"},{"kind":13,"containerName":"_write_gene","name":"$val","line":501},{"definition":"my","line":504,"name":"$aa","kind":13,"localvar":"my","containerName":"_write_gene"},{"name":"$cds","kind":13,"containerName":"_write_gene","line":504},{"line":504,"name":"get_tag_values","kind":12,"containerName":"_write_gene"},{"line":505,"containerName":"_write_gene","kind":13,"name":"$cds"},{"name":"has_tag","kind":12,"containerName":"_write_gene","line":505},{"name":"$aa","containerName":"_write_gene","kind":13,"line":507},{"name":"$psn","containerName":"_write_gene","kind":13,"line":507},{"line":508,"kind":13,"containerName":"_write_gene","name":"$cds"},{"line":508,"kind":12,"containerName":"_write_gene","name":"remove_tag"},{"containerName":"_write_gene","localvar":"my","kind":13,"name":"%add_seq","line":509,"definition":"my"},{"name":"$add_seq","containerName":"_write_gene","kind":13,"line":510},{"containerName":"_write_gene","kind":13,"name":"$aa","line":510},{"line":511,"containerName":"_write_gene","kind":13,"name":"$add_seq"},{"line":512,"kind":13,"containerName":"_write_gene","name":"$psn"},{"containerName":"_write_gene","kind":13,"name":"$aa","line":513},{"line":516,"name":"$cds","containerName":"_write_gene","kind":13},{"kind":12,"containerName":"_write_gene","name":"has_tag","line":516},{"name":"$add_seq","containerName":"_write_gene","kind":13,"line":517},{"line":517,"kind":13,"containerName":"_write_gene","name":"$cds"},{"kind":12,"containerName":"_write_gene","name":"get_tag_values","line":517},{"line":518,"kind":13,"containerName":"_write_gene","name":"$cds"},{"line":518,"name":"remove_tag","kind":12,"containerName":"_write_gene"},{"line":521,"name":"$add_seq","containerName":"_write_gene","kind":13},{"kind":13,"containerName":"_write_gene","name":"$add_seq","line":521},{"localvar":"my","containerName":"_write_gene","kind":13,"name":"$start","line":522,"definition":"my"},{"line":522,"containerName":"_write_gene","kind":13,"name":"$cds"},{"name":"start","kind":12,"containerName":"_write_gene","line":522},{"line":523,"localvar":"my","containerName":"_write_gene","kind":13,"name":"$end","definition":"my"},{"containerName":"_write_gene","kind":13,"name":"$cds","line":523},{"line":523,"name":"end","kind":12,"containerName":"_write_gene"},{"name":"$str","containerName":"_write_gene","localvar":"my","kind":13,"line":524,"definition":"my"},{"line":524,"kind":13,"containerName":"_write_gene","name":"$cds"},{"name":"strand","kind":12,"containerName":"_write_gene","line":524},{"definition":"my","line":525,"name":"$acc","kind":13,"localvar":"my","containerName":"_write_gene"},{"name":"$self","kind":13,"containerName":"_write_gene","line":525},{"kind":12,"containerName":"_write_gene","name":"accession","line":525},{"line":525,"name":"$self","containerName":"_write_gene","kind":13},{"line":525,"kind":12,"containerName":"_write_gene","name":"display_id"},{"line":526,"name":"$str","kind":13,"containerName":"_write_gene"},{"line":526,"kind":13,"containerName":"_write_gene","name":"$str"},{"name":"$add_seq","containerName":"_write_gene","kind":13,"line":527},{"containerName":"_write_gene","kind":13,"name":"$acc","line":528},{"line":531,"containerName":"_write_gene","kind":13,"name":"$self"},{"line":532,"containerName":"_write_gene","kind":13,"name":"$self"},{"kind":13,"containerName":"_write_gene","name":"%add_seq","line":532},{"line":537,"name":"$writer","kind":13,"containerName":"_write_gene"},{"containerName":"_write_gene","kind":12,"name":"startTag","line":537},{"line":537,"kind":13,"containerName":"_write_gene","name":"$name"},{"name":"$self","containerName":"_write_gene","kind":13,"line":538},{"name":"_element","kind":12,"containerName":"_write_gene","line":538},{"line":538,"name":"$name","containerName":"_write_gene","kind":13},{"name":"$self","kind":13,"containerName":"_write_gene","line":539},{"line":539,"kind":12,"containerName":"_write_gene","name":"_element"},{"line":540,"name":"$self","containerName":"_write_gene","kind":13},{"name":"_render_tags","kind":12,"containerName":"_write_gene","line":540},{"line":544,"name":"$mRNA","kind":13,"containerName":"_write_gene"},{"line":544,"kind":13,"containerName":"_write_gene","name":"$cds"},{"definition":"my","line":547,"name":"$thing","kind":13,"localvar":"my","containerName":"_write_gene"},{"name":"@other_stuff","kind":13,"containerName":"_write_gene","line":547},{"kind":13,"containerName":"_write_gene","name":"$thing","line":548},{"kind":12,"containerName":"_write_gene","name":"has_tag","line":548},{"definition":"my","name":"$v","containerName":"_write_gene","localvar":"my","kind":13,"line":549},{"containerName":"_write_gene","kind":13,"name":"$thing","line":549},{"containerName":"_write_gene","kind":12,"name":"get_tag_values","line":549},{"line":550,"kind":13,"containerName":"_write_gene","name":"$v"},{"line":550,"kind":13,"containerName":"_write_gene","name":"$sn"},{"line":551,"name":"@units","containerName":"_write_gene","kind":13},{"name":"$thing","kind":13,"containerName":"_write_gene","line":551},{"line":557,"name":"@units","containerName":"_write_gene","kind":13},{"line":557,"containerName":"_write_gene","kind":12,"name":"primary_tag"},{"containerName":"_write_gene","kind":13,"name":"$mRNA","line":557},{"kind":12,"containerName":"_write_gene","name":"get_SeqFeatures","line":557},{"line":558,"containerName":"_write_gene","kind":13,"name":"@units"},{"containerName":"_write_gene","kind":13,"name":"$a","line":558},{"line":558,"name":"start","kind":12,"containerName":"_write_gene"},{"containerName":"_write_gene","kind":13,"name":"$b","line":558},{"kind":12,"containerName":"_write_gene","name":"start","line":558},{"line":558,"name":"@units","kind":13,"containerName":"_write_gene"},{"name":"$count","kind":13,"localvar":"my","containerName":"_write_gene","line":560,"definition":"my"},{"line":562,"containerName":"_write_gene","kind":13,"name":"$str"},{"name":"@units","kind":13,"containerName":"_write_gene","line":563},{"name":"@units","containerName":"_write_gene","kind":13,"line":563},{"definition":"my","name":"$unit","localvar":"my","containerName":"_write_gene","kind":13,"line":566},{"name":"@units","kind":13,"containerName":"_write_gene","line":566},{"line":567,"name":"$unit","containerName":"_write_gene","kind":13},{"line":567,"name":"primary_tag","containerName":"_write_gene","kind":12},{"definition":"my","line":568,"containerName":"_write_gene","localvar":"my","kind":13,"name":"$ename"},{"line":568,"containerName":"_write_gene","kind":13,"name":"$id"},{"line":569,"name":"$ename","kind":13,"containerName":"_write_gene"},{"kind":13,"containerName":"_write_gene","name":"$count","line":569},{"name":"$self","kind":13,"containerName":"_write_gene","line":570},{"line":570,"name":"_feature_span","kind":12,"containerName":"_write_gene"},{"line":570,"name":"$ename","kind":13,"containerName":"_write_gene"},{"line":570,"name":"$unit","kind":13,"containerName":"_write_gene"},{"kind":13,"containerName":"_write_gene","name":"$unit","line":572},{"line":572,"name":"primary_tag","containerName":"_write_gene","kind":12},{"line":573,"kind":13,"containerName":"_write_gene","name":"$self"},{"name":"_feature_span","kind":12,"containerName":"_write_gene","line":573},{"line":573,"name":"$sn","kind":13,"containerName":"_write_gene"},{"line":573,"containerName":"_write_gene","kind":13,"name":"$gid"},{"containerName":"_write_gene","kind":13,"name":"$unit","line":573},{"name":"$self","containerName":"_write_gene","kind":13,"line":573},{"containerName":"_write_gene","localvar":"my","kind":13,"name":"$uname","line":576,"definition":"my"},{"kind":13,"containerName":"_write_gene","name":"$unit","line":576},{"containerName":"_write_gene","kind":12,"name":"primary_tag","line":576},{"kind":13,"containerName":"_write_gene","name":"$self","line":577},{"containerName":"_write_gene","kind":12,"name":"_feature_span","line":577},{"line":577,"kind":13,"containerName":"_write_gene","name":"$uname"},{"containerName":"_write_gene","kind":13,"name":"$unit","line":577},{"line":580,"name":"$self","kind":13,"containerName":"_write_gene"},{"line":581,"kind":13,"containerName":"_write_gene","name":"$writer"},{"line":581,"containerName":"_write_gene","kind":12,"name":"endTag"},{"line":584,"kind":13,"containerName":"_write_gene","name":"$self"},{"line":584,"name":"@other_stuff","kind":13,"containerName":"_write_gene"}]},{"line":361,"kind":12,"name":"writer"},{"kind":12,"name":"id","line":374},{"line":378,"kind":12,"name":"_render_date_tags"},{"name":"_render_dbxref_tags","kind":12,"line":379},{"line":380,"name":"_render_comment_tags","kind":12},{"line":381,"name":"_render_tags_as_properties","kind":12},{"kind":12,"name":"association","line":402},{"kind":12,"containerName":"SeqFeature::Generic","name":"Bio","line":417},{"name":"curr_pname","kind":12,"line":463},{"containerName":"SeqFeature::Generic","kind":12,"name":"Bio","line":479},{"line":501,"kind":12,"name":"problem"},{"line":510,"kind":12,"name":"residues"},{"line":511,"name":"header","kind":12},{"line":512,"name":"id","kind":12},{"line":513,"kind":12,"name":"length"},{"line":514,"kind":12,"name":"type"},{"line":517,"kind":12,"name":"desc"},{"line":521,"name":"desc","kind":12},{"kind":12,"name":"desc","line":521},{"line":525,"kind":12,"name":"seq"},{"kind":12,"name":"seq","line":525},{"name":"desc","kind":12,"line":527},{"kind":12,"name":"add_seqs","line":531},{"line":532,"kind":12,"name":"add_seqs"},{"kind":12,"name":"id","line":537},{"line":541,"kind":12,"name":"_render_date_tags"},{"name":"_render_comment_tags","kind":12,"line":542},{"line":543,"name":"_render_tags_as_properties","kind":12},{"line":573,"name":"curr_pname","kind":12},{"line":580,"kind":12,"name":"curr_pname"},{"line":584,"name":"other_stuff","kind":12},{"name":"$writer","kind":13,"containerName":null,"line":587},{"kind":12,"containerName":"main::","name":"endTag","line":587},{"line":590,"name":"%self","kind":13,"containerName":null},{"line":590,"kind":12,"name":"add_seqs"},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"%h","line":591},{"line":591,"kind":13,"containerName":null,"name":"$_"},{"line":592,"name":"$writer","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"startTag","line":592},{"name":"%h","containerName":null,"kind":13,"line":592},{"name":"header","kind":12,"line":592},{"line":593,"name":"@desc","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"line":593,"name":"%h","kind":13,"containerName":null},{"line":593,"kind":12,"name":"desc"},{"line":594,"name":"$desc","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"definition":"my","name":"$word","localvar":"my","containerName":null,"kind":13,"line":595},{"line":595,"containerName":null,"kind":13,"name":"@desc"},{"line":596,"localvar":"my","kind":13,"containerName":null,"name":"$lastline","definition":"my"},{"name":"$desc","containerName":null,"kind":13,"line":596},{"kind":13,"containerName":null,"name":"$lastline","line":597},{"line":598,"name":"$desc","containerName":null,"kind":13},{"line":598,"name":"$lastline","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$self","line":600},{"line":600,"name":"_element","kind":12,"containerName":"main::"},{"definition":"my","name":"$aa","localvar":"my","kind":13,"containerName":null,"line":602},{"kind":13,"containerName":null,"name":"%h","line":602},{"line":602,"kind":12,"name":"residues"},{"line":603,"containerName":null,"kind":13,"name":"$aa"},{"containerName":null,"kind":13,"name":"$aa","line":604},{"line":605,"containerName":null,"kind":13,"name":"$aa"},{"name":"$aa","kind":13,"containerName":null,"line":605},{"line":606,"name":"$self","containerName":null,"kind":13},{"line":606,"name":"_element","containerName":"main::","kind":12},{"line":606,"name":"$aa","containerName":null,"kind":13},{"line":607,"kind":13,"containerName":null,"name":"$writer"},{"name":"endTag","containerName":"main::","kind":12,"line":607},{"line":608,"kind":13,"containerName":null,"name":"%self"},{"line":608,"kind":12,"name":"add_seqs"},{"definition":"my","line":614,"name":"$thing","kind":13,"localvar":"my","containerName":null},{"name":"%self","kind":13,"containerName":null,"line":614},{"name":"other_stuff","kind":12,"line":614},{"line":615,"name":"$thing","kind":13,"containerName":null},{"kind":12,"containerName":"main::","name":"has_tag","line":615},{"kind":13,"containerName":null,"name":"$self","line":616},{"line":616,"containerName":"main::","kind":12,"name":"_write_feature"},{"kind":13,"containerName":null,"name":"$thing","line":616},{"line":618,"name":"%self","kind":13,"containerName":null},{"line":618,"kind":12,"name":"other_stuff"},{"name":"_check_cds","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"_check_cds","kind":13,"name":"$self","line":640},{"name":"$cds","containerName":"_check_cds","kind":13,"line":640},{"line":640,"name":"$name","kind":13,"containerName":"_check_cds"},{"localvar":"my","kind":13,"containerName":"_check_cds","name":"$cname","line":641,"definition":"my"},{"line":641,"kind":13,"containerName":"_check_cds","name":"$self"},{"name":"_find_name","kind":12,"containerName":"_check_cds","line":641},{"line":641,"containerName":"_check_cds","kind":13,"name":"$cds"},{"line":642,"kind":13,"containerName":"_check_cds","name":"$self"},{"name":"_find_name","kind":12,"containerName":"_check_cds","line":642},{"line":642,"kind":13,"containerName":"_check_cds","name":"$cds"},{"kind":13,"containerName":"_check_cds","name":"$cname","line":644},{"kind":13,"containerName":"_check_cds","name":"$cname","line":645},{"kind":13,"containerName":"_check_cds","name":"$name","line":645},{"line":646,"name":"$cds","kind":13,"containerName":"_check_cds"},{"definition":"my","name":"@CDS","localvar":"my","kind":13,"containerName":"_check_cds","line":649},{"line":649,"kind":12,"containerName":"_check_cds","name":"primary_tag"},{"name":"$self","containerName":"_check_cds","kind":13,"line":649},{"name":"@CDS","containerName":"_check_cds","kind":13,"line":650},{"line":651,"name":"$sname","kind":13,"localvar":"my","containerName":"_check_cds","definition":"my"},{"containerName":"_check_cds","kind":12,"name":"_find_name","line":651},{"name":"_find_name","kind":12,"containerName":"_check_cds","line":652},{"line":652,"name":"primary_tag","containerName":"_check_cds","kind":12},{"name":"$sname","containerName":"_check_cds","kind":13,"line":653},{"containerName":"_check_cds","kind":13,"name":"$name","line":653}],"detail":"($self,$cds,$name)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":657},"start":{"line":639,"character":0}},"line":639,"signature":{"parameters":[{"label":"$self"},{"label":"$cds"},{"label":"$name"}],"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.","label":"_check_cds($self,$cds,$name)"}},{"name":"feats","kind":12,"line":649},{"name":"$cds","kind":13,"containerName":null,"line":659},{"signature":{"label":"_comp_analysis($self,$feat)","documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:","parameters":[{"label":"$self"},{"label":"$feat"}]},"line":675,"kind":12,"range":{"start":{"line":675,"character":0},"end":{"line":690,"character":9999}},"definition":"sub","detail":"($self,$feat)","children":[{"definition":"my","line":676,"name":"$self","kind":13,"localvar":"my","containerName":"_comp_analysis"},{"line":676,"kind":13,"containerName":"_comp_analysis","name":"$feat"},{"definition":"my","containerName":"_comp_analysis","localvar":"my","kind":13,"name":"$writer","line":677},{"name":"$self","containerName":"_comp_analysis","kind":13,"line":677},{"line":679,"name":"$writer","containerName":"_comp_analysis","kind":13},{"containerName":"_comp_analysis","kind":12,"name":"startTag","line":679},{"line":680,"name":"$self","containerName":"_comp_analysis","kind":13},{"line":680,"kind":12,"containerName":"_comp_analysis","name":"_element"},{"line":680,"containerName":"_comp_analysis","kind":13,"name":"$feat"},{"line":680,"name":"program_name","kind":12,"containerName":"_comp_analysis"},{"line":681,"name":"$self","kind":13,"containerName":"_comp_analysis"},{"line":681,"kind":12,"containerName":"_comp_analysis","name":"_element"},{"kind":13,"containerName":"_comp_analysis","name":"$feat","line":681},{"line":681,"name":"database_name","containerName":"_comp_analysis","kind":12},{"name":"$feat","kind":13,"containerName":"_comp_analysis","line":681},{"line":681,"kind":12,"containerName":"_comp_analysis","name":"database_name"},{"kind":13,"containerName":"_comp_analysis","name":"$self","line":682},{"line":682,"name":"_element","containerName":"_comp_analysis","kind":12},{"line":682,"kind":13,"containerName":"_comp_analysis","name":"$feat"},{"line":682,"name":"program_version","kind":12,"containerName":"_comp_analysis"},{"line":682,"kind":13,"containerName":"_comp_analysis","name":"$feat"},{"containerName":"_comp_analysis","kind":12,"name":"program_version","line":682},{"containerName":"_comp_analysis","kind":13,"name":"$self","line":683},{"line":683,"name":"_element","containerName":"_comp_analysis","kind":12},{"containerName":"_comp_analysis","kind":13,"name":"$feat","line":683},{"line":683,"name":"primary_tag","kind":12,"containerName":"_comp_analysis"},{"line":683,"name":"$feat","containerName":"_comp_analysis","kind":13},{"name":"primary_tag","kind":12,"containerName":"_comp_analysis","line":683},{"containerName":"_comp_analysis","kind":13,"name":"$self","line":684},{"containerName":"_comp_analysis","kind":12,"name":"_render_tags","line":684},{"name":"$feat","containerName":"_comp_analysis","kind":13,"line":684},{"name":"$self","containerName":"_comp_analysis","kind":13,"line":688},{"line":688,"containerName":"_comp_analysis","kind":12,"name":"_comp_result"},{"line":688,"name":"$feat","kind":13,"containerName":"_comp_analysis"},{"line":689,"name":"$writer","containerName":"_comp_analysis","kind":13},{"name":"endTag","kind":12,"containerName":"_comp_analysis","line":689}],"containerName":"main::","name":"_comp_analysis"},{"line":677,"kind":12,"name":"writer"},{"line":685,"kind":12,"name":"_render_date_tags"},{"line":686,"kind":12,"name":"_render_tags_as_properties"},{"definition":"sub","detail":"($self,$feat)","children":[{"definition":"my","line":704,"localvar":"my","containerName":"_comp_result","kind":13,"name":"$self"},{"name":"$feat","kind":13,"containerName":"_comp_result","line":704},{"line":711,"name":"@subfeats","localvar":"my","kind":13,"containerName":"_comp_result","definition":"my"},{"line":711,"name":"$feat","kind":13,"containerName":"_comp_result"},{"name":"get_SeqFeatures","kind":12,"containerName":"_comp_result","line":711},{"line":711,"name":"$feat","containerName":"_comp_result","kind":13},{"line":711,"name":"get_all_tags","kind":12,"containerName":"_comp_result"},{"definition":"my","name":"$writer","kind":13,"localvar":"my","containerName":"_comp_result","line":712},{"line":712,"kind":13,"containerName":"_comp_result","name":"$self"},{"name":"$writer","containerName":"_comp_result","kind":13,"line":713},{"name":"startTag","containerName":"_comp_result","kind":12,"line":713},{"kind":13,"containerName":"_comp_result","name":"$feat","line":714},{"kind":12,"containerName":"_comp_result","name":"can","line":714},{"line":714,"name":"$feat","containerName":"_comp_result","kind":13},{"line":714,"name":"computation_id","kind":12,"containerName":"_comp_result"},{"containerName":"_comp_result","kind":13,"name":"$feat","line":715},{"name":"computation_id","kind":12,"containerName":"_comp_result","line":715},{"localvar":"my","containerName":"_comp_result","kind":13,"name":"$fakename","line":717,"definition":"my"},{"line":717,"kind":13,"containerName":"_comp_result","name":"$feat"},{"containerName":"_comp_result","kind":12,"name":"primary_tag","line":717},{"line":718,"name":"$self","kind":13,"containerName":"_comp_result"},{"containerName":"_comp_result","kind":12,"name":"_element","line":718},{"line":718,"containerName":"_comp_result","kind":13,"name":"$feat"},{"line":718,"name":"display_name","containerName":"_comp_result","kind":12},{"name":"$fakename","containerName":"_comp_result","kind":13,"line":718},{"line":718,"name":"$self","kind":13,"containerName":"_comp_result"},{"name":"$fakename","kind":13,"containerName":"_comp_result","line":718},{"line":719,"name":"$self","containerName":"_comp_result","kind":13},{"name":"_seq_relationship","kind":12,"containerName":"_comp_result","line":719},{"line":719,"name":"$feat","kind":13,"containerName":"_comp_result"},{"line":720,"kind":13,"containerName":"_comp_result","name":"$self"},{"line":720,"name":"_render_tags","containerName":"_comp_result","kind":12},{"line":720,"name":"$feat","containerName":"_comp_result","kind":13},{"line":723,"kind":13,"containerName":"_comp_result","name":"@subfeats"},{"containerName":"_comp_result","kind":13,"name":"$self","line":724},{"name":"_comp_result","kind":12,"containerName":"_comp_result","line":724},{"kind":13,"containerName":"_comp_result","name":"$self","line":726},{"containerName":"_comp_result","kind":12,"name":"_comp_result_span","line":726},{"name":"$feat","kind":13,"containerName":"_comp_result","line":726},{"line":727,"name":"$writer","kind":13,"containerName":"_comp_result"},{"line":727,"containerName":"_comp_result","kind":12,"name":"endTag"},{"kind":13,"containerName":"_comp_result","name":"$self","line":730},{"containerName":"_comp_result","kind":12,"name":"_comp_result_span","line":730},{"name":"$feat","kind":13,"containerName":"_comp_result","line":730}],"name":"_comp_result","containerName":"main::","signature":{"label":"_comp_result($self,$feat)","documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature","parameters":[{"label":"$self"},{"label":"$feat"}]},"line":703,"kind":12,"range":{"start":{"character":0,"line":703},"end":{"line":732,"character":9999}}},{"line":712,"kind":12,"name":"writer"},{"line":715,"kind":12,"name":"id"},{"name":"anon_result_set_counters","kind":12,"line":718},{"line":722,"name":"_render_output_tags","kind":12},{"kind":12,"range":{"start":{"line":747,"character":0},"end":{"line":767,"character":9999}},"line":747,"signature":{"label":"_comp_result_span($self,$feat)","parameters":[{"label":"$self"},{"label":"$feat"}],"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:"},"containerName":"main::","name":"_comp_result_span","children":[{"definition":"my","line":749,"containerName":"_comp_result_span","localvar":"my","kind":13,"name":"$self"},{"kind":13,"containerName":"_comp_result_span","name":"$feat","line":749},{"definition":"my","line":750,"localvar":"my","containerName":"_comp_result_span","kind":13,"name":"$writer"},{"name":"$self","kind":13,"containerName":"_comp_result_span","line":750},{"name":"$writer","containerName":"_comp_result_span","kind":13,"line":752},{"line":752,"containerName":"_comp_result_span","kind":12,"name":"startTag"},{"name":"$feat","kind":13,"containerName":"_comp_result_span","line":753},{"line":753,"name":"can","kind":12,"containerName":"_comp_result_span"},{"kind":13,"containerName":"_comp_result_span","name":"$feat","line":753},{"name":"computation_id","containerName":"_comp_result_span","kind":12,"line":753},{"line":753,"name":"$feat","kind":13,"containerName":"_comp_result_span"},{"name":"computation_id","kind":12,"containerName":"_comp_result_span","line":753},{"name":"$self","containerName":"_comp_result_span","kind":13,"line":755},{"line":755,"kind":12,"containerName":"_comp_result_span","name":"_element"},{"line":755,"name":"$feat","kind":13,"containerName":"_comp_result_span"},{"name":"display_name","containerName":"_comp_result_span","kind":12,"line":755},{"line":755,"name":"$feat","kind":13,"containerName":"_comp_result_span"},{"kind":12,"containerName":"_comp_result_span","name":"display_name","line":755},{"kind":13,"containerName":"_comp_result_span","name":"$self","line":756},{"kind":12,"containerName":"_comp_result_span","name":"_element","line":756},{"containerName":"_comp_result_span","kind":13,"name":"$feat","line":756},{"containerName":"_comp_result_span","kind":12,"name":"primary_tag","line":756},{"line":756,"name":"$feat","kind":13,"containerName":"_comp_result_span"},{"line":756,"kind":12,"containerName":"_comp_result_span","name":"primary_tag"},{"line":757,"containerName":"_comp_result_span","localvar":"my","kind":13,"name":"$has_score","definition":"my"},{"name":"$feat","containerName":"_comp_result_span","kind":13,"line":757},{"name":"can","kind":12,"containerName":"_comp_result_span","line":757},{"name":"$feat","containerName":"_comp_result_span","kind":13,"line":757},{"containerName":"_comp_result_span","kind":12,"name":"has_score","line":757},{"name":"$feat","kind":13,"containerName":"_comp_result_span","line":757},{"line":757,"kind":12,"containerName":"_comp_result_span","name":"score"},{"kind":13,"containerName":"_comp_result_span","name":"$self","line":758},{"line":758,"kind":12,"containerName":"_comp_result_span","name":"_element"},{"containerName":"_comp_result_span","kind":13,"name":"$feat","line":758},{"name":"score","kind":12,"containerName":"_comp_result_span","line":758},{"name":"$has_score","kind":13,"containerName":"_comp_result_span","line":758},{"kind":13,"containerName":"_comp_result_span","name":"$self","line":759},{"line":759,"name":"_render_tags","kind":12,"containerName":"_comp_result_span"},{"line":759,"containerName":"_comp_result_span","kind":13,"name":"$feat"},{"name":"$self","containerName":"_comp_result_span","kind":13,"line":762},{"line":762,"name":"_seq_relationship","containerName":"_comp_result_span","kind":12},{"line":762,"name":"$feat","kind":13,"containerName":"_comp_result_span"},{"line":763,"name":"$self","kind":13,"containerName":"_comp_result_span"},{"name":"_render_tags","containerName":"_comp_result_span","kind":12,"line":763},{"containerName":"_comp_result_span","kind":13,"name":"$feat","line":763},{"name":"$writer","kind":13,"containerName":"_comp_result_span","line":766},{"line":766,"containerName":"_comp_result_span","kind":12,"name":"endTag"}],"detail":"($self,$feat)","definition":"sub"},{"kind":12,"name":"writer","line":750},{"name":"id","kind":12,"line":753},{"kind":12,"name":"_render_output_tags","line":761},{"kind":12,"name":"_render_target_tags","line":764},{"kind":12,"range":{"start":{"line":780,"character":0},"end":{"line":791,"character":9999}},"line":780,"signature":{"label":"_render_tags($self,$feat,@render_funcs)","parameters":[{"label":"$self"},{"label":"$feat"},{"label":"@render_funcs"}],"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:"},"containerName":"main::","name":"_render_tags","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"_render_tags","line":781,"definition":"my"},{"name":"$feat","containerName":"_render_tags","kind":13,"line":781},{"name":"@render_funcs","containerName":"_render_tags","kind":13,"line":781},{"definition":"my","localvar":"my","containerName":"_render_tags","kind":13,"name":"@tagnames","line":783},{"line":783,"containerName":"_render_tags","kind":13,"name":"$feat"},{"containerName":"_render_tags","kind":12,"name":"get_all_tags","line":783},{"name":"$func","localvar":"my","kind":13,"containerName":"_render_tags","line":788,"definition":"my"},{"containerName":"_render_tags","kind":13,"name":"@render_funcs","line":788},{"line":789,"name":"@tagnames","containerName":"_render_tags","kind":13},{"line":789,"containerName":"_render_tags","kind":13,"name":"$self"},{"line":789,"name":"$func","kind":13,"containerName":"_render_tags"},{"line":789,"containerName":"_render_tags","kind":13,"name":"$feat"},{"line":789,"name":"@tagnames","containerName":"_render_tags","kind":13}],"detail":"($self,$feat,@render_funcs)","definition":"sub"},{"name":"_render_output_tags","containerName":"main::","children":[{"line":807,"name":"$self","localvar":"my","kind":13,"containerName":"_render_output_tags","definition":"my"},{"name":"$feat","kind":13,"containerName":"_render_output_tags","line":807},{"line":807,"name":"@tagnames","kind":13,"containerName":"_render_output_tags"},{"definition":"my","line":808,"kind":13,"localvar":"my","containerName":"_render_output_tags","name":"$writer"},{"name":"$self","kind":13,"containerName":"_render_output_tags","line":808},{"definition":"my","name":"@passed_up","localvar":"my","kind":13,"containerName":"_render_output_tags","line":809},{"name":"$tag","localvar":"my","kind":13,"containerName":"_render_output_tags","line":811,"definition":"my"},{"containerName":"_render_output_tags","kind":13,"name":"@tagnames","line":811},{"containerName":"_render_output_tags","kind":13,"name":"$tag","line":812},{"localvar":"my","containerName":"_render_output_tags","kind":13,"name":"@outputs","line":813,"definition":"my"},{"line":813,"kind":13,"containerName":"_render_output_tags","name":"$feat"},{"line":813,"kind":12,"containerName":"_render_output_tags","name":"get_tag_values"},{"line":813,"name":"$tag","kind":13,"containerName":"_render_output_tags"},{"name":"$type","localvar":"my","containerName":"_render_output_tags","kind":13,"line":814,"definition":"my"},{"name":"$val","containerName":"_render_output_tags","kind":13,"line":814},{"name":"@outputs","containerName":"_render_output_tags","kind":13,"line":814},{"containerName":"_render_output_tags","kind":13,"name":"$writer","line":815},{"line":815,"name":"startTag","containerName":"_render_output_tags","kind":12},{"line":816,"kind":13,"containerName":"_render_output_tags","name":"$self"},{"kind":12,"containerName":"_render_output_tags","name":"_element","line":816},{"name":"$type","containerName":"_render_output_tags","kind":13,"line":816},{"line":817,"name":"$self","containerName":"_render_output_tags","kind":13},{"name":"_element","kind":12,"containerName":"_render_output_tags","line":817},{"line":817,"kind":13,"containerName":"_render_output_tags","name":"$val"},{"line":818,"name":"$writer","containerName":"_render_output_tags","kind":13},{"containerName":"_render_output_tags","kind":12,"name":"endTag","line":818},{"name":"@passed_up","kind":13,"containerName":"_render_output_tags","line":822},{"name":"$tag","containerName":"_render_output_tags","kind":13,"line":822},{"containerName":"_render_output_tags","kind":13,"name":"@passed_up","line":825}],"detail":"($self,$feat,@tagnames)","definition":"sub","range":{"start":{"character":0,"line":806},"end":{"line":826,"character":9999}},"kind":12,"line":806,"signature":{"parameters":[{"label":"$self"},{"label":"$feat"},{"label":"@tagnames"}],"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _render_tags {\n  my ($self,$feat,@render_funcs) = @_;\n\n  my @tagnames = $feat->get_all_tags;\n\n  #do a chain-of-responsibility down the allowed\n  #tag handlers types for the context in which this is\n  #called\n  foreach my $func (@render_funcs) {\n    @tagnames = $self->$func($feat,@tagnames);\n  }\n}\n\n=head2 _render_output_tags\n\n  Usage:\n  Desc : print out <output> elements, with contents\n         taken from the SeqFeature::Computation's 'output' tag\n  Ret  : array of tag names this did not render\n  Args : feature object, list of tag names to maybe render\n\n  In game xml, only <result_span> and <result_set> elements can\n  have <output> elements.","label":"_render_output_tags($self,$feat,@tagnames)"}},{"line":808,"name":"writer","kind":12},{"containerName":"main::","name":"_render_tags_as_properties","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"_render_tags_as_properties","name":"$self","line":843},{"name":"$feat","containerName":"_render_tags_as_properties","kind":13,"line":843},{"name":"@tagnames","kind":13,"containerName":"_render_tags_as_properties","line":843},{"localvar":"my","containerName":"_render_tags_as_properties","kind":13,"name":"$tag","line":845,"definition":"my"},{"containerName":"_render_tags_as_properties","kind":13,"name":"@tagnames","line":845},{"line":846,"containerName":"_render_tags_as_properties","kind":13,"name":"$tag"},{"line":846,"kind":13,"containerName":"_render_tags_as_properties","name":"$feat"},{"containerName":"_render_tags_as_properties","kind":12,"name":"primary_tag","line":846},{"name":"$self","containerName":"_render_tags_as_properties","kind":13,"line":847},{"name":"_property","containerName":"_render_tags_as_properties","kind":12,"line":847},{"line":847,"name":"$tag","kind":13,"containerName":"_render_tags_as_properties"},{"line":847,"name":"$feat","containerName":"_render_tags_as_properties","kind":13},{"line":847,"name":"get_tag_values","containerName":"_render_tags_as_properties","kind":12},{"name":"$tag","containerName":"_render_tags_as_properties","kind":13,"line":847}],"detail":"($self,$feat,@tagnames)","definition":"sub","range":{"start":{"character":0,"line":842},"end":{"line":851,"character":9999}},"kind":12,"line":842,"signature":{"label":"_render_tags_as_properties($self,$feat,@tagnames)","parameters":[{"label":"$self"},{"label":"$feat"},{"label":"@tagnames"}],"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _render_tags {\n  my ($self,$feat,@render_funcs) = @_;\n\n  my @tagnames = $feat->get_all_tags;\n\n  #do a chain-of-responsibility down the allowed\n  #tag handlers types for the context in which this is\n  #called\n  foreach my $func (@render_funcs) {\n    @tagnames = $self->$func($feat,@tagnames);\n  }\n}\n\n=head2 _render_output_tags\n\n  Usage:\n  Desc : print out <output> elements, with contents\n         taken from the SeqFeature::Computation's 'output' tag\n  Ret  : array of tag names this did not render\n  Args : feature object, list of tag names to maybe render\n\n  In game xml, only <result_span> and <result_set> elements can\n  have <output> elements.\n\n\nsub _render_output_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n\n  for my $tag (@tagnames) {\n    if(lc($tag) eq 'output') {\n      my @outputs = $feat->get_tag_values($tag);\n      while(my($type,$val) = splice @outputs,0,2) {\n\t$writer->startTag('output');\n\t$self->_element('type',$type);\n\t$self->_element('value',$val);\n\t$writer->endTag('output');\n      }\n    }\n    else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_tags_as_properties\n\n  Usage:\n  Desc :\n  Ret  : empty array\n  Args : feature object, array of tag names\n  Side Effects:\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  and <feature_set> elements can have properties."}},{"signature":{"label":"_render_comment_tags($self,$feat,@tagnames)","documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _render_tags {\n  my ($self,$feat,@render_funcs) = @_;\n\n  my @tagnames = $feat->get_all_tags;\n\n  #do a chain-of-responsibility down the allowed\n  #tag handlers types for the context in which this is\n  #called\n  foreach my $func (@render_funcs) {\n    @tagnames = $self->$func($feat,@tagnames);\n  }\n}\n\n=head2 _render_output_tags\n\n  Usage:\n  Desc : print out <output> elements, with contents\n         taken from the SeqFeature::Computation's 'output' tag\n  Ret  : array of tag names this did not render\n  Args : feature object, list of tag names to maybe render\n\n  In game xml, only <result_span> and <result_set> elements can\n  have <output> elements.\n\n\nsub _render_output_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n\n  for my $tag (@tagnames) {\n    if(lc($tag) eq 'output') {\n      my @outputs = $feat->get_tag_values($tag);\n      while(my($type,$val) = splice @outputs,0,2) {\n\t$writer->startTag('output');\n\t$self->_element('type',$type);\n\t$self->_element('value',$val);\n\t$writer->endTag('output');\n      }\n    }\n    else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_tags_as_properties\n\n  Usage:\n  Desc :\n  Ret  : empty array\n  Args : feature object, array of tag names\n  Side Effects:\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  and <feature_set> elements can have properties.\n\n\nsub _render_tags_as_properties {\n  my ($self,$feat,@tagnames) = @_;\n\n  foreach my $tag (@tagnames) {\n    if( $tag ne $feat->primary_tag ) {\n      $self->_property($tag,$_) for $feat->get_tag_values($tag);\n    }\n  }\n  return ();\n}\n\n=head2 _render_comment_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not comment tags\n  Args : feature object, tag names available for us to render\n  Side Effects: writes XML\n  Example:\n\n  In game xml, <annotation> and <feature_set> elements can\n  have comments.","parameters":[{"label":"$self"},{"label":"$feat"},{"label":"@tagnames"}]},"line":867,"range":{"start":{"line":867,"character":0},"end":{"line":887,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$feat,@tagnames)","children":[{"definition":"my","line":868,"name":"$self","containerName":"_render_comment_tags","localvar":"my","kind":13},{"line":868,"name":"$feat","kind":13,"containerName":"_render_comment_tags"},{"kind":13,"containerName":"_render_comment_tags","name":"@tagnames","line":868},{"definition":"my","containerName":"_render_comment_tags","localvar":"my","kind":13,"name":"$writer","line":869},{"name":"$self","kind":13,"containerName":"_render_comment_tags","line":869},{"definition":"my","name":"@passed_up","kind":13,"localvar":"my","containerName":"_render_comment_tags","line":870},{"definition":"my","containerName":"_render_comment_tags","localvar":"my","kind":13,"name":"$tag","line":871},{"name":"@tagnames","kind":13,"containerName":"_render_comment_tags","line":871},{"name":"$tag","kind":13,"containerName":"_render_comment_tags","line":872},{"name":"$val","kind":13,"localvar":"my","containerName":"_render_comment_tags","line":873,"definition":"my"},{"name":"$feat","kind":13,"containerName":"_render_comment_tags","line":873},{"line":873,"name":"get_tag_values","kind":12,"containerName":"_render_comment_tags"},{"kind":13,"containerName":"_render_comment_tags","name":"$tag","line":873},{"line":874,"containerName":"_render_comment_tags","kind":13,"name":"$val"},{"kind":13,"containerName":"_render_comment_tags","name":"$self","line":875},{"kind":12,"containerName":"_render_comment_tags","name":"_unflatten_attribute","line":875},{"containerName":"_render_comment_tags","kind":13,"name":"$val","line":875},{"name":"$writer","kind":13,"containerName":"_render_comment_tags","line":877},{"name":"startTag","containerName":"_render_comment_tags","kind":12,"line":877},{"name":"$self","kind":13,"containerName":"_render_comment_tags","line":878},{"name":"_element","containerName":"_render_comment_tags","kind":12,"line":878},{"kind":13,"containerName":"_render_comment_tags","name":"$val","line":878},{"name":"$writer","kind":13,"containerName":"_render_comment_tags","line":879},{"name":"endTag","kind":12,"containerName":"_render_comment_tags","line":879},{"line":883,"kind":13,"containerName":"_render_comment_tags","name":"@passed_up"},{"line":883,"kind":13,"containerName":"_render_comment_tags","name":"$tag"},{"line":886,"name":"@passed_up","kind":13,"containerName":"_render_comment_tags"}],"containerName":"main::","name":"_render_comment_tags"},{"name":"writer","kind":12,"line":869},{"definition":"sub","detail":"($self,$feat,@tagnames)","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_render_date_tags","line":905},{"name":"$feat","containerName":"_render_date_tags","kind":13,"line":905},{"name":"@tagnames","kind":13,"containerName":"_render_date_tags","line":905},{"kind":13,"localvar":"my","containerName":"_render_date_tags","name":"@passed_up","line":906,"definition":"my"},{"definition":"my","name":"$date","containerName":"_render_date_tags","localvar":"my","kind":13,"line":907},{"kind":13,"localvar":"my","containerName":"_render_date_tags","name":"%timestamp","line":908,"definition":"my"},{"definition":"my","name":"$tag","localvar":"my","kind":13,"containerName":"_render_date_tags","line":909},{"line":909,"containerName":"_render_date_tags","kind":13,"name":"@tagnames"},{"line":910,"name":"$tag","containerName":"_render_date_tags","kind":13},{"line":911,"name":"$date","containerName":"_render_date_tags","kind":13},{"name":"$feat","containerName":"_render_date_tags","kind":13,"line":911},{"name":"get_tag_values","kind":12,"containerName":"_render_date_tags","line":911},{"name":"$tag","containerName":"_render_date_tags","kind":13,"line":911},{"containerName":"_render_date_tags","kind":13,"name":"$tag","line":912},{"name":"$timestamp","containerName":"_render_date_tags","kind":13,"line":913},{"name":"$feat","containerName":"_render_date_tags","kind":13,"line":913},{"kind":12,"containerName":"_render_date_tags","name":"get_tag_values","line":913},{"line":913,"name":"$tag","containerName":"_render_date_tags","kind":13},{"line":916,"name":"@passed_up","kind":13,"containerName":"_render_date_tags"},{"name":"$tag","kind":13,"containerName":"_render_date_tags","line":916},{"line":919,"name":"$self","containerName":"_render_date_tags","kind":13},{"line":919,"name":"_element","kind":12,"containerName":"_render_date_tags"},{"containerName":"_render_date_tags","kind":13,"name":"$date","line":919},{"line":919,"containerName":"_render_date_tags","kind":13,"name":"%timestamp"},{"name":"$date","kind":13,"containerName":"_render_date_tags","line":919},{"line":920,"kind":13,"containerName":"_render_date_tags","name":"@passed_up"}],"containerName":"main::","name":"_render_date_tags","signature":{"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _render_tags {\n  my ($self,$feat,@render_funcs) = @_;\n\n  my @tagnames = $feat->get_all_tags;\n\n  #do a chain-of-responsibility down the allowed\n  #tag handlers types for the context in which this is\n  #called\n  foreach my $func (@render_funcs) {\n    @tagnames = $self->$func($feat,@tagnames);\n  }\n}\n\n=head2 _render_output_tags\n\n  Usage:\n  Desc : print out <output> elements, with contents\n         taken from the SeqFeature::Computation's 'output' tag\n  Ret  : array of tag names this did not render\n  Args : feature object, list of tag names to maybe render\n\n  In game xml, only <result_span> and <result_set> elements can\n  have <output> elements.\n\n\nsub _render_output_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n\n  for my $tag (@tagnames) {\n    if(lc($tag) eq 'output') {\n      my @outputs = $feat->get_tag_values($tag);\n      while(my($type,$val) = splice @outputs,0,2) {\n\t$writer->startTag('output');\n\t$self->_element('type',$type);\n\t$self->_element('value',$val);\n\t$writer->endTag('output');\n      }\n    }\n    else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_tags_as_properties\n\n  Usage:\n  Desc :\n  Ret  : empty array\n  Args : feature object, array of tag names\n  Side Effects:\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  and <feature_set> elements can have properties.\n\n\nsub _render_tags_as_properties {\n  my ($self,$feat,@tagnames) = @_;\n\n  foreach my $tag (@tagnames) {\n    if( $tag ne $feat->primary_tag ) {\n      $self->_property($tag,$_) for $feat->get_tag_values($tag);\n    }\n  }\n  return ();\n}\n\n=head2 _render_comment_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not comment tags\n  Args : feature object, tag names available for us to render\n  Side Effects: writes XML\n  Example:\n\n  In game xml, <annotation> and <feature_set> elements can\n  have comments.\n\n\nsub _render_comment_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n  for my $tag ( @tagnames ) {\n    if( lc($tag) eq 'comment' ) {\n      for my $val ($feat->get_tag_values($tag)) {\n\tif ( $val =~ /=.+?;.+=/ ) {\n\t  $self->_unflatten_attribute('comment', $val);\n\t} else {\n\t  $writer->startTag('comment');\n\t  $self->_element('text', $val);\n\t  $writer->endTag('comment');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_date_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not date tags\n  Args : feature, list of tag names available for us to render\n  Side Effects: writes XML for <date> elements\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  <transaction>, <comment>, and <feature_set> elements\n  can have <date>s.","parameters":[{"label":"$self"},{"label":"$feat"},{"label":"@tagnames"}],"label":"_render_date_tags($self,$feat,@tagnames)"},"line":904,"kind":12,"range":{"start":{"character":0,"line":904},"end":{"character":9999,"line":921}}},{"name":"_render_dbxref_tags","containerName":"main::","children":[{"line":938,"name":"$self","kind":13,"localvar":"my","containerName":"_render_dbxref_tags","definition":"my"},{"line":938,"name":"$feat","kind":13,"containerName":"_render_dbxref_tags"},{"line":938,"containerName":"_render_dbxref_tags","kind":13,"name":"@tagnames"},{"line":939,"name":"@passed_up","kind":13,"localvar":"my","containerName":"_render_dbxref_tags","definition":"my"},{"line":940,"name":"$tag","localvar":"my","containerName":"_render_dbxref_tags","kind":13,"definition":"my"},{"name":"@tagnames","kind":13,"containerName":"_render_dbxref_tags","line":940},{"line":941,"name":"$tag","containerName":"_render_dbxref_tags","kind":13},{"definition":"my","line":942,"containerName":"_render_dbxref_tags","localvar":"my","kind":13,"name":"$writer"},{"line":942,"kind":13,"containerName":"_render_dbxref_tags","name":"$self"},{"containerName":"_render_dbxref_tags","localvar":"my","kind":13,"name":"$val","line":943,"definition":"my"},{"kind":13,"containerName":"_render_dbxref_tags","name":"$feat","line":943},{"line":943,"containerName":"_render_dbxref_tags","kind":12,"name":"get_all_tag_values"},{"name":"$tag","containerName":"_render_dbxref_tags","kind":13,"line":943},{"line":944,"kind":13,"localvar":"my","containerName":"_render_dbxref_tags","name":"$db","definition":"my"},{"kind":13,"containerName":"_render_dbxref_tags","name":"$dbid","line":944},{"line":944,"kind":13,"containerName":"_render_dbxref_tags","name":"$val"},{"line":945,"kind":13,"containerName":"_render_dbxref_tags","name":"$writer"},{"containerName":"_render_dbxref_tags","kind":12,"name":"startTag","line":945},{"line":946,"kind":13,"containerName":"_render_dbxref_tags","name":"$self"},{"line":946,"containerName":"_render_dbxref_tags","kind":12,"name":"_element"},{"line":946,"name":"$db","kind":13,"containerName":"_render_dbxref_tags"},{"name":"$dbid","kind":13,"containerName":"_render_dbxref_tags","line":947},{"line":947,"containerName":"_render_dbxref_tags","kind":13,"name":"$val"},{"line":947,"name":"$db","kind":13,"containerName":"_render_dbxref_tags"},{"name":"$self","kind":13,"containerName":"_render_dbxref_tags","line":948},{"name":"_element","kind":12,"containerName":"_render_dbxref_tags","line":948},{"kind":13,"containerName":"_render_dbxref_tags","name":"$dbid","line":948},{"kind":13,"containerName":"_render_dbxref_tags","name":"$writer","line":949},{"line":949,"kind":12,"containerName":"_render_dbxref_tags","name":"endTag"},{"name":"@passed_up","kind":13,"containerName":"_render_dbxref_tags","line":953},{"line":953,"containerName":"_render_dbxref_tags","kind":13,"name":"$tag"},{"kind":13,"containerName":"_render_dbxref_tags","name":"@passed_up","line":956}],"detail":"($self,$feat,@tagnames)","definition":"sub","range":{"end":{"character":9999,"line":957},"start":{"character":0,"line":937}},"kind":12,"line":937,"signature":{"parameters":[{"label":"$self"},{"label":"$feat"},{"label":"@tagnames"}],"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _render_tags {\n  my ($self,$feat,@render_funcs) = @_;\n\n  my @tagnames = $feat->get_all_tags;\n\n  #do a chain-of-responsibility down the allowed\n  #tag handlers types for the context in which this is\n  #called\n  foreach my $func (@render_funcs) {\n    @tagnames = $self->$func($feat,@tagnames);\n  }\n}\n\n=head2 _render_output_tags\n\n  Usage:\n  Desc : print out <output> elements, with contents\n         taken from the SeqFeature::Computation's 'output' tag\n  Ret  : array of tag names this did not render\n  Args : feature object, list of tag names to maybe render\n\n  In game xml, only <result_span> and <result_set> elements can\n  have <output> elements.\n\n\nsub _render_output_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n\n  for my $tag (@tagnames) {\n    if(lc($tag) eq 'output') {\n      my @outputs = $feat->get_tag_values($tag);\n      while(my($type,$val) = splice @outputs,0,2) {\n\t$writer->startTag('output');\n\t$self->_element('type',$type);\n\t$self->_element('value',$val);\n\t$writer->endTag('output');\n      }\n    }\n    else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_tags_as_properties\n\n  Usage:\n  Desc :\n  Ret  : empty array\n  Args : feature object, array of tag names\n  Side Effects:\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  and <feature_set> elements can have properties.\n\n\nsub _render_tags_as_properties {\n  my ($self,$feat,@tagnames) = @_;\n\n  foreach my $tag (@tagnames) {\n    if( $tag ne $feat->primary_tag ) {\n      $self->_property($tag,$_) for $feat->get_tag_values($tag);\n    }\n  }\n  return ();\n}\n\n=head2 _render_comment_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not comment tags\n  Args : feature object, tag names available for us to render\n  Side Effects: writes XML\n  Example:\n\n  In game xml, <annotation> and <feature_set> elements can\n  have comments.\n\n\nsub _render_comment_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n  for my $tag ( @tagnames ) {\n    if( lc($tag) eq 'comment' ) {\n      for my $val ($feat->get_tag_values($tag)) {\n\tif ( $val =~ /=.+?;.+=/ ) {\n\t  $self->_unflatten_attribute('comment', $val);\n\t} else {\n\t  $writer->startTag('comment');\n\t  $self->_element('text', $val);\n\t  $writer->endTag('comment');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_date_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not date tags\n  Args : feature, list of tag names available for us to render\n  Side Effects: writes XML for <date> elements\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  <transaction>, <comment>, and <feature_set> elements\n  can have <date>s.\n\n\nsub _render_date_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  my $date;\n  my %timestamp;\n  foreach my $tag (@tagnames) {\n    if ( lc($tag) eq 'date' ) {\n      ($date) = $feat->get_tag_values($tag);\n    } elsif ( lc($tag) eq 'timestamp' ) {\n      ($timestamp{'timestamp'}) = $feat->get_tag_values($tag);\n      #ignore timestamps, they are folded in with date elem above\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  $self->_element('date', $date, \\%timestamp) if defined($date);\n  return @passed_up;\n}\n\n=head2 _render_dbxref_tags\n\n  Desc : look for xref tags and render them if they are there\n  Ret  : tag names that we didn't render\n  Args : feature object, list of tag names to render\n  Side Effects: writes a <dbxref> element if a tag with name\n                matching /xref$/i is present\n\n\n  In game xml, <annotation> and <seq> elements can have dbxrefs.\n\nTODO: can't sequences also have database xrefs?  how to find those?","label":"_render_dbxref_tags($self,$feat,@tagnames)"}},{"line":942,"name":"writer","kind":12},{"detail":"($self,$feat,@tagnames)","definition":"sub","containerName":"main::","name":"_render_target_tags","children":[{"localvar":"my","kind":13,"containerName":"_render_target_tags","name":"$self","line":976,"definition":"my"},{"containerName":"_render_target_tags","kind":13,"name":"$feat","line":976},{"line":976,"name":"@tagnames","containerName":"_render_target_tags","kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":"_render_target_tags","name":"@passed_up","line":977},{"containerName":"_render_target_tags","localvar":"my","kind":13,"name":"$tag","line":978,"definition":"my"},{"name":"@tagnames","kind":13,"containerName":"_render_target_tags","line":978},{"line":979,"name":"$tag","containerName":"_render_target_tags","kind":13},{"localvar":"my","kind":13,"containerName":"_render_target_tags","name":"@alignment","line":979,"definition":"my"},{"line":979,"name":"$feat","containerName":"_render_target_tags","kind":13},{"line":979,"kind":12,"containerName":"_render_target_tags","name":"get_tag_values"},{"kind":13,"containerName":"_render_target_tags","name":"$self","line":980},{"name":"_seq_relationship","kind":12,"containerName":"_render_target_tags","line":980},{"line":981,"name":"new","containerName":"_render_target_tags","kind":12},{"name":"$alignment","containerName":"_render_target_tags","kind":13,"line":981},{"name":"$alignment","kind":13,"containerName":"_render_target_tags","line":982},{"kind":13,"containerName":"_render_target_tags","name":"$alignment","line":984},{"name":"$alignment","kind":13,"containerName":"_render_target_tags","line":985},{"kind":13,"containerName":"_render_target_tags","name":"@passed_up","line":988},{"line":988,"name":"$tag","containerName":"_render_target_tags","kind":13},{"name":"@passed_up","kind":13,"containerName":"_render_target_tags","line":991}],"signature":{"parameters":[{"label":"$self"},{"label":"$feat"},{"label":"@tagnames"}],"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _render_tags {\n  my ($self,$feat,@render_funcs) = @_;\n\n  my @tagnames = $feat->get_all_tags;\n\n  #do a chain-of-responsibility down the allowed\n  #tag handlers types for the context in which this is\n  #called\n  foreach my $func (@render_funcs) {\n    @tagnames = $self->$func($feat,@tagnames);\n  }\n}\n\n=head2 _render_output_tags\n\n  Usage:\n  Desc : print out <output> elements, with contents\n         taken from the SeqFeature::Computation's 'output' tag\n  Ret  : array of tag names this did not render\n  Args : feature object, list of tag names to maybe render\n\n  In game xml, only <result_span> and <result_set> elements can\n  have <output> elements.\n\n\nsub _render_output_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n\n  for my $tag (@tagnames) {\n    if(lc($tag) eq 'output') {\n      my @outputs = $feat->get_tag_values($tag);\n      while(my($type,$val) = splice @outputs,0,2) {\n\t$writer->startTag('output');\n\t$self->_element('type',$type);\n\t$self->_element('value',$val);\n\t$writer->endTag('output');\n      }\n    }\n    else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_tags_as_properties\n\n  Usage:\n  Desc :\n  Ret  : empty array\n  Args : feature object, array of tag names\n  Side Effects:\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  and <feature_set> elements can have properties.\n\n\nsub _render_tags_as_properties {\n  my ($self,$feat,@tagnames) = @_;\n\n  foreach my $tag (@tagnames) {\n    if( $tag ne $feat->primary_tag ) {\n      $self->_property($tag,$_) for $feat->get_tag_values($tag);\n    }\n  }\n  return ();\n}\n\n=head2 _render_comment_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not comment tags\n  Args : feature object, tag names available for us to render\n  Side Effects: writes XML\n  Example:\n\n  In game xml, <annotation> and <feature_set> elements can\n  have comments.\n\n\nsub _render_comment_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n  for my $tag ( @tagnames ) {\n    if( lc($tag) eq 'comment' ) {\n      for my $val ($feat->get_tag_values($tag)) {\n\tif ( $val =~ /=.+?;.+=/ ) {\n\t  $self->_unflatten_attribute('comment', $val);\n\t} else {\n\t  $writer->startTag('comment');\n\t  $self->_element('text', $val);\n\t  $writer->endTag('comment');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_date_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not date tags\n  Args : feature, list of tag names available for us to render\n  Side Effects: writes XML for <date> elements\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  <transaction>, <comment>, and <feature_set> elements\n  can have <date>s.\n\n\nsub _render_date_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  my $date;\n  my %timestamp;\n  foreach my $tag (@tagnames) {\n    if ( lc($tag) eq 'date' ) {\n      ($date) = $feat->get_tag_values($tag);\n    } elsif ( lc($tag) eq 'timestamp' ) {\n      ($timestamp{'timestamp'}) = $feat->get_tag_values($tag);\n      #ignore timestamps, they are folded in with date elem above\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  $self->_element('date', $date, \\%timestamp) if defined($date);\n  return @passed_up;\n}\n\n=head2 _render_dbxref_tags\n\n  Desc : look for xref tags and render them if they are there\n  Ret  : tag names that we didn't render\n  Args : feature object, list of tag names to render\n  Side Effects: writes a <dbxref> element if a tag with name\n                matching /xref$/i is present\n\n\n  In game xml, <annotation> and <seq> elements can have dbxrefs.\n\n\n#TODO: can't sequences also have database xrefs?  how to find those?\nsub _render_dbxref_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my @passed_up;\n  for my $tag ( @tagnames ) {                           #look through all the tags\n    if( $tag =~ /xref$/i ) {                            #if they are xref tags\n      my $writer = $self->{writer};\n      for my $val ( $feat->get_all_tag_values($tag) ) { #get all their values\n\tif( my ($db,$dbid) = $val =~ /(\\S+):(\\S+)/ ) {  #and render them as xrefs\n\t  $writer->startTag('dbxref');\n\t  $self->_element('xref_db', $db);\n\t  $dbid = $val if $db =~ /^[A-Z]O$/; # -> ontology, like GO\n\t  $self->_element('db_xref_id', $dbid);\n\t  $writer->endTag('dbxref');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _render_target_tags\n\n  Usage:\n  Desc : process any 'Target' tags that would indicate a sequence alignment subject\n  Ret  : array of tag names that we didn't render\n  Args : feature object\n  Side Effects: writes a <seq_relationship> of type 'subject' if it finds\n                any properly formed tags named 'Target'\n  Example:\n\n  In game xml, <result_span>, <feature_span>, and <result_set> can have\n  <seq_relationship>s.  <result_set> can only have one, a 'query' relation.","label":"_render_target_tags($self,$feat,@tagnames)"},"range":{"start":{"character":0,"line":975},"end":{"line":992,"character":9999}},"kind":12,"line":975},{"name":"Bio","kind":12,"containerName":"Location::Simple","line":981},{"detail":"($self,$tag,$val)","definition":"sub","containerName":"main::","name":"_property","children":[{"containerName":"_property","localvar":"my","kind":13,"name":"$self","line":1006,"definition":"my"},{"containerName":"_property","kind":13,"name":"$tag","line":1006},{"line":1006,"containerName":"_property","kind":13,"name":"$val"},{"name":"$writer","localvar":"my","kind":13,"containerName":"_property","line":1007,"definition":"my"},{"name":"$self","kind":13,"containerName":"_property","line":1007},{"line":1009,"containerName":"_property","kind":13,"name":"$val"},{"name":"@val","kind":13,"localvar":"my","containerName":"_property","line":1010,"definition":"my"},{"kind":13,"containerName":"_property","name":"$val","line":1010},{"name":"$val","kind":13,"containerName":"_property","line":1011},{"definition":"my","line":1013,"name":"$word","localvar":"my","kind":13,"containerName":"_property"},{"kind":13,"containerName":"_property","name":"@val","line":1013},{"name":"$lastline","localvar":"my","kind":13,"containerName":"_property","line":1014,"definition":"my"},{"line":1014,"name":"$val","containerName":"_property","kind":13},{"containerName":"_property","kind":13,"name":"$lastline","line":1015},{"line":1016,"name":"$val","containerName":"_property","kind":13},{"containerName":"_property","kind":13,"name":"$lastline","line":1016},{"line":1018,"name":"$val","kind":13,"containerName":"_property"},{"containerName":"_property","kind":13,"name":"$val","line":1019},{"kind":13,"containerName":"_property","name":"$writer","line":1021},{"containerName":"_property","kind":12,"name":"startTag","line":1021},{"line":1022,"name":"$self","kind":13,"containerName":"_property"},{"name":"_element","containerName":"_property","kind":12,"line":1022},{"line":1022,"name":"$tag","kind":13,"containerName":"_property"},{"line":1023,"name":"$self","kind":13,"containerName":"_property"},{"line":1023,"containerName":"_property","kind":12,"name":"_element"},{"line":1023,"containerName":"_property","kind":13,"name":"$val"},{"line":1024,"name":"$writer","kind":13,"containerName":"_property"},{"line":1024,"containerName":"_property","kind":12,"name":"endTag"}],"signature":{"parameters":[{"label":"$self"},{"label":"$tag"},{"label":"$val"}],"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _render_tags {\n  my ($self,$feat,@render_funcs) = @_;\n\n  my @tagnames = $feat->get_all_tags;\n\n  #do a chain-of-responsibility down the allowed\n  #tag handlers types for the context in which this is\n  #called\n  foreach my $func (@render_funcs) {\n    @tagnames = $self->$func($feat,@tagnames);\n  }\n}\n\n=head2 _render_output_tags\n\n  Usage:\n  Desc : print out <output> elements, with contents\n         taken from the SeqFeature::Computation's 'output' tag\n  Ret  : array of tag names this did not render\n  Args : feature object, list of tag names to maybe render\n\n  In game xml, only <result_span> and <result_set> elements can\n  have <output> elements.\n\n\nsub _render_output_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n\n  for my $tag (@tagnames) {\n    if(lc($tag) eq 'output') {\n      my @outputs = $feat->get_tag_values($tag);\n      while(my($type,$val) = splice @outputs,0,2) {\n\t$writer->startTag('output');\n\t$self->_element('type',$type);\n\t$self->_element('value',$val);\n\t$writer->endTag('output');\n      }\n    }\n    else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_tags_as_properties\n\n  Usage:\n  Desc :\n  Ret  : empty array\n  Args : feature object, array of tag names\n  Side Effects:\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  and <feature_set> elements can have properties.\n\n\nsub _render_tags_as_properties {\n  my ($self,$feat,@tagnames) = @_;\n\n  foreach my $tag (@tagnames) {\n    if( $tag ne $feat->primary_tag ) {\n      $self->_property($tag,$_) for $feat->get_tag_values($tag);\n    }\n  }\n  return ();\n}\n\n=head2 _render_comment_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not comment tags\n  Args : feature object, tag names available for us to render\n  Side Effects: writes XML\n  Example:\n\n  In game xml, <annotation> and <feature_set> elements can\n  have comments.\n\n\nsub _render_comment_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n  for my $tag ( @tagnames ) {\n    if( lc($tag) eq 'comment' ) {\n      for my $val ($feat->get_tag_values($tag)) {\n\tif ( $val =~ /=.+?;.+=/ ) {\n\t  $self->_unflatten_attribute('comment', $val);\n\t} else {\n\t  $writer->startTag('comment');\n\t  $self->_element('text', $val);\n\t  $writer->endTag('comment');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_date_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not date tags\n  Args : feature, list of tag names available for us to render\n  Side Effects: writes XML for <date> elements\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  <transaction>, <comment>, and <feature_set> elements\n  can have <date>s.\n\n\nsub _render_date_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  my $date;\n  my %timestamp;\n  foreach my $tag (@tagnames) {\n    if ( lc($tag) eq 'date' ) {\n      ($date) = $feat->get_tag_values($tag);\n    } elsif ( lc($tag) eq 'timestamp' ) {\n      ($timestamp{'timestamp'}) = $feat->get_tag_values($tag);\n      #ignore timestamps, they are folded in with date elem above\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  $self->_element('date', $date, \\%timestamp) if defined($date);\n  return @passed_up;\n}\n\n=head2 _render_dbxref_tags\n\n  Desc : look for xref tags and render them if they are there\n  Ret  : tag names that we didn't render\n  Args : feature object, list of tag names to render\n  Side Effects: writes a <dbxref> element if a tag with name\n                matching /xref$/i is present\n\n\n  In game xml, <annotation> and <seq> elements can have dbxrefs.\n\n\n#TODO: can't sequences also have database xrefs?  how to find those?\nsub _render_dbxref_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my @passed_up;\n  for my $tag ( @tagnames ) {                           #look through all the tags\n    if( $tag =~ /xref$/i ) {                            #if they are xref tags\n      my $writer = $self->{writer};\n      for my $val ( $feat->get_all_tag_values($tag) ) { #get all their values\n\tif( my ($db,$dbid) = $val =~ /(\\S+):(\\S+)/ ) {  #and render them as xrefs\n\t  $writer->startTag('dbxref');\n\t  $self->_element('xref_db', $db);\n\t  $dbid = $val if $db =~ /^[A-Z]O$/; # -> ontology, like GO\n\t  $self->_element('db_xref_id', $dbid);\n\t  $writer->endTag('dbxref');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _render_target_tags\n\n  Usage:\n  Desc : process any 'Target' tags that would indicate a sequence alignment subject\n  Ret  : array of tag names that we didn't render\n  Args : feature object\n  Side Effects: writes a <seq_relationship> of type 'subject' if it finds\n                any properly formed tags named 'Target'\n  Example:\n\n  In game xml, <result_span>, <feature_span>, and <result_set> can have\n  <seq_relationship>s.  <result_set> can only have one, a 'query' relation.\n\n\nsub _render_target_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  foreach my $tag (@tagnames) {\n    if($tag eq 'Target' && (my @alignment = $feat->get_tag_values('Target')) >= 3) {\n      $self->_seq_relationship('subject',\n\t\t\t       Bio::Location::Simple->new( -start => $alignment[1],\n\t\t\t\t\t\t\t   -end   => $alignment[2],\n\t\t\t\t\t\t\t ),\n\t\t\t       $alignment[0],\n\t\t\t       $alignment[3],\n\t\t\t      );\n    } else {\n      push @passed_up, $tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _property\n\n Title   : _property\n Usage   : $self->_property($tag => $value); \n Function: an internal method to write property XML elements\n Returns : nothing\n Args    : a tag/value pair","label":"_property($self,$tag,$val)"},"kind":12,"range":{"start":{"line":1005,"character":0},"end":{"line":1025,"character":9999}},"line":1005},{"line":1007,"name":"writer","kind":12},{"line":1037,"kind":12,"range":{"end":{"line":1055,"character":9999},"start":{"character":0,"line":1037}},"signature":{"label":"_unflatten_attribute($self,$name,$val)","parameters":[{"label":"$self"},{"label":"$name"},{"label":"$val"}],"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _render_tags {\n  my ($self,$feat,@render_funcs) = @_;\n\n  my @tagnames = $feat->get_all_tags;\n\n  #do a chain-of-responsibility down the allowed\n  #tag handlers types for the context in which this is\n  #called\n  foreach my $func (@render_funcs) {\n    @tagnames = $self->$func($feat,@tagnames);\n  }\n}\n\n=head2 _render_output_tags\n\n  Usage:\n  Desc : print out <output> elements, with contents\n         taken from the SeqFeature::Computation's 'output' tag\n  Ret  : array of tag names this did not render\n  Args : feature object, list of tag names to maybe render\n\n  In game xml, only <result_span> and <result_set> elements can\n  have <output> elements.\n\n\nsub _render_output_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n\n  for my $tag (@tagnames) {\n    if(lc($tag) eq 'output') {\n      my @outputs = $feat->get_tag_values($tag);\n      while(my($type,$val) = splice @outputs,0,2) {\n\t$writer->startTag('output');\n\t$self->_element('type',$type);\n\t$self->_element('value',$val);\n\t$writer->endTag('output');\n      }\n    }\n    else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_tags_as_properties\n\n  Usage:\n  Desc :\n  Ret  : empty array\n  Args : feature object, array of tag names\n  Side Effects:\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  and <feature_set> elements can have properties.\n\n\nsub _render_tags_as_properties {\n  my ($self,$feat,@tagnames) = @_;\n\n  foreach my $tag (@tagnames) {\n    if( $tag ne $feat->primary_tag ) {\n      $self->_property($tag,$_) for $feat->get_tag_values($tag);\n    }\n  }\n  return ();\n}\n\n=head2 _render_comment_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not comment tags\n  Args : feature object, tag names available for us to render\n  Side Effects: writes XML\n  Example:\n\n  In game xml, <annotation> and <feature_set> elements can\n  have comments.\n\n\nsub _render_comment_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n  for my $tag ( @tagnames ) {\n    if( lc($tag) eq 'comment' ) {\n      for my $val ($feat->get_tag_values($tag)) {\n\tif ( $val =~ /=.+?;.+=/ ) {\n\t  $self->_unflatten_attribute('comment', $val);\n\t} else {\n\t  $writer->startTag('comment');\n\t  $self->_element('text', $val);\n\t  $writer->endTag('comment');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_date_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not date tags\n  Args : feature, list of tag names available for us to render\n  Side Effects: writes XML for <date> elements\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  <transaction>, <comment>, and <feature_set> elements\n  can have <date>s.\n\n\nsub _render_date_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  my $date;\n  my %timestamp;\n  foreach my $tag (@tagnames) {\n    if ( lc($tag) eq 'date' ) {\n      ($date) = $feat->get_tag_values($tag);\n    } elsif ( lc($tag) eq 'timestamp' ) {\n      ($timestamp{'timestamp'}) = $feat->get_tag_values($tag);\n      #ignore timestamps, they are folded in with date elem above\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  $self->_element('date', $date, \\%timestamp) if defined($date);\n  return @passed_up;\n}\n\n=head2 _render_dbxref_tags\n\n  Desc : look for xref tags and render them if they are there\n  Ret  : tag names that we didn't render\n  Args : feature object, list of tag names to render\n  Side Effects: writes a <dbxref> element if a tag with name\n                matching /xref$/i is present\n\n\n  In game xml, <annotation> and <seq> elements can have dbxrefs.\n\n\n#TODO: can't sequences also have database xrefs?  how to find those?\nsub _render_dbxref_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my @passed_up;\n  for my $tag ( @tagnames ) {                           #look through all the tags\n    if( $tag =~ /xref$/i ) {                            #if they are xref tags\n      my $writer = $self->{writer};\n      for my $val ( $feat->get_all_tag_values($tag) ) { #get all their values\n\tif( my ($db,$dbid) = $val =~ /(\\S+):(\\S+)/ ) {  #and render them as xrefs\n\t  $writer->startTag('dbxref');\n\t  $self->_element('xref_db', $db);\n\t  $dbid = $val if $db =~ /^[A-Z]O$/; # -> ontology, like GO\n\t  $self->_element('db_xref_id', $dbid);\n\t  $writer->endTag('dbxref');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _render_target_tags\n\n  Usage:\n  Desc : process any 'Target' tags that would indicate a sequence alignment subject\n  Ret  : array of tag names that we didn't render\n  Args : feature object\n  Side Effects: writes a <seq_relationship> of type 'subject' if it finds\n                any properly formed tags named 'Target'\n  Example:\n\n  In game xml, <result_span>, <feature_span>, and <result_set> can have\n  <seq_relationship>s.  <result_set> can only have one, a 'query' relation.\n\n\nsub _render_target_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  foreach my $tag (@tagnames) {\n    if($tag eq 'Target' && (my @alignment = $feat->get_tag_values('Target')) >= 3) {\n      $self->_seq_relationship('subject',\n\t\t\t       Bio::Location::Simple->new( -start => $alignment[1],\n\t\t\t\t\t\t\t   -end   => $alignment[2],\n\t\t\t\t\t\t\t ),\n\t\t\t       $alignment[0],\n\t\t\t       $alignment[3],\n\t\t\t      );\n    } else {\n      push @passed_up, $tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _property\n\n Title   : _property\n Usage   : $self->_property($tag => $value); \n Function: an internal method to write property XML elements\n Returns : nothing\n Args    : a tag/value pair\n\n\nsub _property {\n    my ($self, $tag, $val) = @_;\n    my $writer = $self->{writer};\n\n    if ( length $val > 45 ) {\n\tmy @val = split /\\s+/, $val;\n\t$val = '';\n\t\n\tfor my $word (@val) {\n\t    my ($lastline) = $val =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $val .= length $lastline < 45 ? \" $word \" : \"\\n          $word\";\n\t}\n\t$val = \"\\n         $val\\n        \";\n\t$val =~ s/(\\S)\\s{2}(\\S)/$1 $2/g;\n    }\n    $writer->startTag('property');\n    $self->_element('type', $tag);\n    $self->_element('value', $val);\n    $writer->endTag('property');\n}\n\n=head2 _unflatten_attribute\n\n Title   : _unflatten_attribute\n Usage   : $self->_unflatten_attribute($name, $value)\n Function: an internal method to unflatten and write comment or evidence elements\n Returns : nothing\n Args    : a list of strings"},"children":[{"line":1038,"name":"$self","kind":13,"localvar":"my","containerName":"_unflatten_attribute","definition":"my"},{"kind":13,"containerName":"_unflatten_attribute","name":"$name","line":1038},{"line":1038,"name":"$val","containerName":"_unflatten_attribute","kind":13},{"localvar":"my","kind":13,"containerName":"_unflatten_attribute","name":"$writer","line":1039,"definition":"my"},{"line":1039,"containerName":"_unflatten_attribute","kind":13,"name":"$self"},{"definition":"my","line":1040,"name":"%pair","containerName":"_unflatten_attribute","localvar":"my","kind":13},{"definition":"my","name":"@pairs","localvar":"my","containerName":"_unflatten_attribute","kind":13,"line":1041},{"name":"$val","kind":13,"containerName":"_unflatten_attribute","line":1041},{"definition":"my","name":"$p","localvar":"my","kind":13,"containerName":"_unflatten_attribute","line":1042},{"line":1042,"containerName":"_unflatten_attribute","kind":13,"name":"@pairs"},{"definition":"my","line":1043,"name":"@pair","kind":13,"localvar":"my","containerName":"_unflatten_attribute"},{"name":"$p","kind":13,"containerName":"_unflatten_attribute","line":1043},{"line":1044,"kind":13,"containerName":"_unflatten_attribute","name":"$pair"},{"containerName":"_unflatten_attribute","kind":13,"name":"$pair","line":1045},{"line":1046,"name":"$pair","kind":13,"containerName":"_unflatten_attribute"},{"kind":13,"containerName":"_unflatten_attribute","name":"$pair","line":1046},{"line":1046,"kind":13,"containerName":"_unflatten_attribute","name":"$pair"},{"containerName":"_unflatten_attribute","kind":13,"name":"$writer","line":1048},{"line":1048,"name":"startTag","containerName":"_unflatten_attribute","kind":12},{"containerName":"_unflatten_attribute","kind":13,"name":"$name","line":1048},{"line":1049,"name":"%pair","containerName":"_unflatten_attribute","kind":13},{"kind":13,"containerName":"_unflatten_attribute","name":"$self","line":1050},{"name":"_element","containerName":"_unflatten_attribute","kind":12,"line":1050},{"line":1050,"name":"$pair","kind":13,"containerName":"_unflatten_attribute"},{"line":1052,"kind":13,"containerName":"_unflatten_attribute","name":"$writer"},{"line":1052,"containerName":"_unflatten_attribute","kind":12,"name":"endTag"},{"line":1052,"name":"$name","containerName":"_unflatten_attribute","kind":13}],"name":"_unflatten_attribute","containerName":"main::","definition":"sub","detail":"($self,$name,$val)"},{"line":1039,"name":"writer","kind":12},{"definition":"sub","detail":"($self,@xrefs)","children":[{"line":1068,"localvar":"my","kind":13,"containerName":"_xref","name":"$self","definition":"my"},{"line":1068,"kind":13,"containerName":"_xref","name":"@xrefs"},{"kind":13,"localvar":"my","containerName":"_xref","name":"$writer","line":1069,"definition":"my"},{"name":"$self","containerName":"_xref","kind":13,"line":1069},{"definition":"my","line":1070,"name":"$xref","containerName":"_xref","localvar":"my","kind":13},{"name":"@xrefs","kind":13,"containerName":"_xref","line":1070},{"name":"$db","localvar":"my","kind":13,"containerName":"_xref","line":1071,"definition":"my"},{"kind":13,"containerName":"_xref","name":"$acc","line":1071},{"containerName":"_xref","kind":13,"name":"$xref","line":1071},{"line":1072,"name":"$writer","kind":13,"containerName":"_xref"},{"kind":12,"containerName":"_xref","name":"startTag","line":1072},{"line":1073,"kind":13,"containerName":"_xref","name":"$self"},{"name":"_element","kind":12,"containerName":"_xref","line":1073},{"line":1073,"kind":13,"containerName":"_xref","name":"$db"},{"name":"$acc","containerName":"_xref","kind":13,"line":1074},{"kind":13,"containerName":"_xref","name":"$xref","line":1074},{"line":1074,"name":"$db","kind":13,"containerName":"_xref"},{"line":1075,"name":"$self","kind":13,"containerName":"_xref"},{"line":1075,"name":"_element","containerName":"_xref","kind":12},{"line":1075,"name":"$acc","containerName":"_xref","kind":13},{"line":1076,"kind":13,"containerName":"_xref","name":"$writer"},{"line":1076,"name":"endTag","kind":12,"containerName":"_xref"}],"containerName":"main::","name":"_xref","signature":{"label":"_xref($self,@xrefs)","parameters":[{"label":"$self"},{"label":"@xrefs"}],"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _render_tags {\n  my ($self,$feat,@render_funcs) = @_;\n\n  my @tagnames = $feat->get_all_tags;\n\n  #do a chain-of-responsibility down the allowed\n  #tag handlers types for the context in which this is\n  #called\n  foreach my $func (@render_funcs) {\n    @tagnames = $self->$func($feat,@tagnames);\n  }\n}\n\n=head2 _render_output_tags\n\n  Usage:\n  Desc : print out <output> elements, with contents\n         taken from the SeqFeature::Computation's 'output' tag\n  Ret  : array of tag names this did not render\n  Args : feature object, list of tag names to maybe render\n\n  In game xml, only <result_span> and <result_set> elements can\n  have <output> elements.\n\n\nsub _render_output_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n\n  for my $tag (@tagnames) {\n    if(lc($tag) eq 'output') {\n      my @outputs = $feat->get_tag_values($tag);\n      while(my($type,$val) = splice @outputs,0,2) {\n\t$writer->startTag('output');\n\t$self->_element('type',$type);\n\t$self->_element('value',$val);\n\t$writer->endTag('output');\n      }\n    }\n    else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_tags_as_properties\n\n  Usage:\n  Desc :\n  Ret  : empty array\n  Args : feature object, array of tag names\n  Side Effects:\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  and <feature_set> elements can have properties.\n\n\nsub _render_tags_as_properties {\n  my ($self,$feat,@tagnames) = @_;\n\n  foreach my $tag (@tagnames) {\n    if( $tag ne $feat->primary_tag ) {\n      $self->_property($tag,$_) for $feat->get_tag_values($tag);\n    }\n  }\n  return ();\n}\n\n=head2 _render_comment_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not comment tags\n  Args : feature object, tag names available for us to render\n  Side Effects: writes XML\n  Example:\n\n  In game xml, <annotation> and <feature_set> elements can\n  have comments.\n\n\nsub _render_comment_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n  for my $tag ( @tagnames ) {\n    if( lc($tag) eq 'comment' ) {\n      for my $val ($feat->get_tag_values($tag)) {\n\tif ( $val =~ /=.+?;.+=/ ) {\n\t  $self->_unflatten_attribute('comment', $val);\n\t} else {\n\t  $writer->startTag('comment');\n\t  $self->_element('text', $val);\n\t  $writer->endTag('comment');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_date_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not date tags\n  Args : feature, list of tag names available for us to render\n  Side Effects: writes XML for <date> elements\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  <transaction>, <comment>, and <feature_set> elements\n  can have <date>s.\n\n\nsub _render_date_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  my $date;\n  my %timestamp;\n  foreach my $tag (@tagnames) {\n    if ( lc($tag) eq 'date' ) {\n      ($date) = $feat->get_tag_values($tag);\n    } elsif ( lc($tag) eq 'timestamp' ) {\n      ($timestamp{'timestamp'}) = $feat->get_tag_values($tag);\n      #ignore timestamps, they are folded in with date elem above\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  $self->_element('date', $date, \\%timestamp) if defined($date);\n  return @passed_up;\n}\n\n=head2 _render_dbxref_tags\n\n  Desc : look for xref tags and render them if they are there\n  Ret  : tag names that we didn't render\n  Args : feature object, list of tag names to render\n  Side Effects: writes a <dbxref> element if a tag with name\n                matching /xref$/i is present\n\n\n  In game xml, <annotation> and <seq> elements can have dbxrefs.\n\n\n#TODO: can't sequences also have database xrefs?  how to find those?\nsub _render_dbxref_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my @passed_up;\n  for my $tag ( @tagnames ) {                           #look through all the tags\n    if( $tag =~ /xref$/i ) {                            #if they are xref tags\n      my $writer = $self->{writer};\n      for my $val ( $feat->get_all_tag_values($tag) ) { #get all their values\n\tif( my ($db,$dbid) = $val =~ /(\\S+):(\\S+)/ ) {  #and render them as xrefs\n\t  $writer->startTag('dbxref');\n\t  $self->_element('xref_db', $db);\n\t  $dbid = $val if $db =~ /^[A-Z]O$/; # -> ontology, like GO\n\t  $self->_element('db_xref_id', $dbid);\n\t  $writer->endTag('dbxref');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _render_target_tags\n\n  Usage:\n  Desc : process any 'Target' tags that would indicate a sequence alignment subject\n  Ret  : array of tag names that we didn't render\n  Args : feature object\n  Side Effects: writes a <seq_relationship> of type 'subject' if it finds\n                any properly formed tags named 'Target'\n  Example:\n\n  In game xml, <result_span>, <feature_span>, and <result_set> can have\n  <seq_relationship>s.  <result_set> can only have one, a 'query' relation.\n\n\nsub _render_target_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  foreach my $tag (@tagnames) {\n    if($tag eq 'Target' && (my @alignment = $feat->get_tag_values('Target')) >= 3) {\n      $self->_seq_relationship('subject',\n\t\t\t       Bio::Location::Simple->new( -start => $alignment[1],\n\t\t\t\t\t\t\t   -end   => $alignment[2],\n\t\t\t\t\t\t\t ),\n\t\t\t       $alignment[0],\n\t\t\t       $alignment[3],\n\t\t\t      );\n    } else {\n      push @passed_up, $tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _property\n\n Title   : _property\n Usage   : $self->_property($tag => $value); \n Function: an internal method to write property XML elements\n Returns : nothing\n Args    : a tag/value pair\n\n\nsub _property {\n    my ($self, $tag, $val) = @_;\n    my $writer = $self->{writer};\n\n    if ( length $val > 45 ) {\n\tmy @val = split /\\s+/, $val;\n\t$val = '';\n\t\n\tfor my $word (@val) {\n\t    my ($lastline) = $val =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $val .= length $lastline < 45 ? \" $word \" : \"\\n          $word\";\n\t}\n\t$val = \"\\n         $val\\n        \";\n\t$val =~ s/(\\S)\\s{2}(\\S)/$1 $2/g;\n    }\n    $writer->startTag('property');\n    $self->_element('type', $tag);\n    $self->_element('value', $val);\n    $writer->endTag('property');\n}\n\n=head2 _unflatten_attribute\n\n Title   : _unflatten_attribute\n Usage   : $self->_unflatten_attribute($name, $value)\n Function: an internal method to unflatten and write comment or evidence elements\n Returns : nothing\n Args    : a list of strings\n\n\nsub _unflatten_attribute {\n    my ($self, $name, $val) = @_;\n    my $writer = $self->{writer};\n    my %pair;\n    my @pairs = split ';', $val;\n    for my $p ( @pairs ) {\n\tmy @pair = split '=', $p;\n\t$pair[0] =~ s/^\\s+|\\s+$//g;\n\t$pair[1] =~ s/^\\s+|\\s+$//g;\n\t$pair{$pair[0]} = $pair[1];\n    }\n    $writer->startTag($name);\n    for ( keys %pair ) {\n\t$self->_element($_, $pair{$_});\n    }\n    $writer->endTag($name);\n    \n\n}\n\n=head2 _xref\n\n Title   : _xref\n Usage   : $self->_xref($value) \n Function: an internal method to write db_xref elements\n Returns : nothing \n Args    : a list of strings"},"line":1067,"range":{"start":{"line":1067,"character":0},"end":{"character":9999,"line":1078}},"kind":12},{"line":1069,"name":"writer","kind":12},{"line":1091,"kind":12,"range":{"start":{"character":0,"line":1091},"end":{"line":1107,"character":9999}},"signature":{"parameters":[{"label":"$self"},{"label":"$name"},{"label":"$feat"},{"label":"$pname"}],"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _render_tags {\n  my ($self,$feat,@render_funcs) = @_;\n\n  my @tagnames = $feat->get_all_tags;\n\n  #do a chain-of-responsibility down the allowed\n  #tag handlers types for the context in which this is\n  #called\n  foreach my $func (@render_funcs) {\n    @tagnames = $self->$func($feat,@tagnames);\n  }\n}\n\n=head2 _render_output_tags\n\n  Usage:\n  Desc : print out <output> elements, with contents\n         taken from the SeqFeature::Computation's 'output' tag\n  Ret  : array of tag names this did not render\n  Args : feature object, list of tag names to maybe render\n\n  In game xml, only <result_span> and <result_set> elements can\n  have <output> elements.\n\n\nsub _render_output_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n\n  for my $tag (@tagnames) {\n    if(lc($tag) eq 'output') {\n      my @outputs = $feat->get_tag_values($tag);\n      while(my($type,$val) = splice @outputs,0,2) {\n\t$writer->startTag('output');\n\t$self->_element('type',$type);\n\t$self->_element('value',$val);\n\t$writer->endTag('output');\n      }\n    }\n    else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_tags_as_properties\n\n  Usage:\n  Desc :\n  Ret  : empty array\n  Args : feature object, array of tag names\n  Side Effects:\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  and <feature_set> elements can have properties.\n\n\nsub _render_tags_as_properties {\n  my ($self,$feat,@tagnames) = @_;\n\n  foreach my $tag (@tagnames) {\n    if( $tag ne $feat->primary_tag ) {\n      $self->_property($tag,$_) for $feat->get_tag_values($tag);\n    }\n  }\n  return ();\n}\n\n=head2 _render_comment_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not comment tags\n  Args : feature object, tag names available for us to render\n  Side Effects: writes XML\n  Example:\n\n  In game xml, <annotation> and <feature_set> elements can\n  have comments.\n\n\nsub _render_comment_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n  for my $tag ( @tagnames ) {\n    if( lc($tag) eq 'comment' ) {\n      for my $val ($feat->get_tag_values($tag)) {\n\tif ( $val =~ /=.+?;.+=/ ) {\n\t  $self->_unflatten_attribute('comment', $val);\n\t} else {\n\t  $writer->startTag('comment');\n\t  $self->_element('text', $val);\n\t  $writer->endTag('comment');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_date_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not date tags\n  Args : feature, list of tag names available for us to render\n  Side Effects: writes XML for <date> elements\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  <transaction>, <comment>, and <feature_set> elements\n  can have <date>s.\n\n\nsub _render_date_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  my $date;\n  my %timestamp;\n  foreach my $tag (@tagnames) {\n    if ( lc($tag) eq 'date' ) {\n      ($date) = $feat->get_tag_values($tag);\n    } elsif ( lc($tag) eq 'timestamp' ) {\n      ($timestamp{'timestamp'}) = $feat->get_tag_values($tag);\n      #ignore timestamps, they are folded in with date elem above\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  $self->_element('date', $date, \\%timestamp) if defined($date);\n  return @passed_up;\n}\n\n=head2 _render_dbxref_tags\n\n  Desc : look for xref tags and render them if they are there\n  Ret  : tag names that we didn't render\n  Args : feature object, list of tag names to render\n  Side Effects: writes a <dbxref> element if a tag with name\n                matching /xref$/i is present\n\n\n  In game xml, <annotation> and <seq> elements can have dbxrefs.\n\n\n#TODO: can't sequences also have database xrefs?  how to find those?\nsub _render_dbxref_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my @passed_up;\n  for my $tag ( @tagnames ) {                           #look through all the tags\n    if( $tag =~ /xref$/i ) {                            #if they are xref tags\n      my $writer = $self->{writer};\n      for my $val ( $feat->get_all_tag_values($tag) ) { #get all their values\n\tif( my ($db,$dbid) = $val =~ /(\\S+):(\\S+)/ ) {  #and render them as xrefs\n\t  $writer->startTag('dbxref');\n\t  $self->_element('xref_db', $db);\n\t  $dbid = $val if $db =~ /^[A-Z]O$/; # -> ontology, like GO\n\t  $self->_element('db_xref_id', $dbid);\n\t  $writer->endTag('dbxref');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _render_target_tags\n\n  Usage:\n  Desc : process any 'Target' tags that would indicate a sequence alignment subject\n  Ret  : array of tag names that we didn't render\n  Args : feature object\n  Side Effects: writes a <seq_relationship> of type 'subject' if it finds\n                any properly formed tags named 'Target'\n  Example:\n\n  In game xml, <result_span>, <feature_span>, and <result_set> can have\n  <seq_relationship>s.  <result_set> can only have one, a 'query' relation.\n\n\nsub _render_target_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  foreach my $tag (@tagnames) {\n    if($tag eq 'Target' && (my @alignment = $feat->get_tag_values('Target')) >= 3) {\n      $self->_seq_relationship('subject',\n\t\t\t       Bio::Location::Simple->new( -start => $alignment[1],\n\t\t\t\t\t\t\t   -end   => $alignment[2],\n\t\t\t\t\t\t\t ),\n\t\t\t       $alignment[0],\n\t\t\t       $alignment[3],\n\t\t\t      );\n    } else {\n      push @passed_up, $tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _property\n\n Title   : _property\n Usage   : $self->_property($tag => $value); \n Function: an internal method to write property XML elements\n Returns : nothing\n Args    : a tag/value pair\n\n\nsub _property {\n    my ($self, $tag, $val) = @_;\n    my $writer = $self->{writer};\n\n    if ( length $val > 45 ) {\n\tmy @val = split /\\s+/, $val;\n\t$val = '';\n\t\n\tfor my $word (@val) {\n\t    my ($lastline) = $val =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $val .= length $lastline < 45 ? \" $word \" : \"\\n          $word\";\n\t}\n\t$val = \"\\n         $val\\n        \";\n\t$val =~ s/(\\S)\\s{2}(\\S)/$1 $2/g;\n    }\n    $writer->startTag('property');\n    $self->_element('type', $tag);\n    $self->_element('value', $val);\n    $writer->endTag('property');\n}\n\n=head2 _unflatten_attribute\n\n Title   : _unflatten_attribute\n Usage   : $self->_unflatten_attribute($name, $value)\n Function: an internal method to unflatten and write comment or evidence elements\n Returns : nothing\n Args    : a list of strings\n\n\nsub _unflatten_attribute {\n    my ($self, $name, $val) = @_;\n    my $writer = $self->{writer};\n    my %pair;\n    my @pairs = split ';', $val;\n    for my $p ( @pairs ) {\n\tmy @pair = split '=', $p;\n\t$pair[0] =~ s/^\\s+|\\s+$//g;\n\t$pair[1] =~ s/^\\s+|\\s+$//g;\n\t$pair{$pair[0]} = $pair[1];\n    }\n    $writer->startTag($name);\n    for ( keys %pair ) {\n\t$self->_element($_, $pair{$_});\n    }\n    $writer->endTag($name);\n    \n\n}\n\n=head2 _xref\n\n Title   : _xref\n Usage   : $self->_xref($value) \n Function: an internal method to write db_xref elements\n Returns : nothing \n Args    : a list of strings\n\n\nsub _xref {\n    my ($self, @xrefs) = @_;\n    my $writer = $self->{writer};\n    for my $xref ( @xrefs ) {\n\tmy ($db, $acc) = $xref =~ /(\\S+):(\\S+)/;\n\t$writer->startTag('dbxref');\n\t$self->_element('xref_db', $db);\n\t$acc = $xref if $db eq 'GO';\n\t$self->_element('db_xref_id', $acc);\n\t$writer->endTag('dbxref');\n    }\n}\n\n=head2 _feature_span\n\n Title   : _feature_span\n Usage   : $self->_feature_span($name, $type, $loc)\n Function: an internal method to write a feature_span element\n          (the actual feature with coordinates)\n Returns : nothing \n Args    : a feature name and Bio::SeqFeatureI-compliant object","label":"_feature_span($self,$name,$feat,$pname)"},"children":[{"definition":"my","containerName":"_feature_span","localvar":"my","kind":13,"name":"$self","line":1092},{"name":"$name","containerName":"_feature_span","kind":13,"line":1092},{"line":1092,"name":"$feat","kind":13,"containerName":"_feature_span"},{"name":"$pname","containerName":"_feature_span","kind":13,"line":1092},{"definition":"my","containerName":"_feature_span","localvar":"my","kind":13,"name":"$type","line":1093},{"name":"$feat","kind":13,"containerName":"_feature_span","line":1093},{"line":1093,"containerName":"_feature_span","kind":12,"name":"primary_tag"},{"name":"$writer","localvar":"my","kind":13,"containerName":"_feature_span","line":1094,"definition":"my"},{"line":1094,"kind":13,"containerName":"_feature_span","name":"$self"},{"definition":"my","name":"%atts","localvar":"my","containerName":"_feature_span","kind":13,"line":1095},{"line":1095,"kind":13,"containerName":"_feature_span","name":"$name"},{"kind":13,"containerName":"_feature_span","name":"$pname","line":1097},{"name":"$pname","kind":13,"containerName":"_feature_span","line":1098},{"kind":13,"containerName":"_feature_span","name":"$atts","line":1099},{"containerName":"_feature_span","kind":13,"name":"$pname","line":1099},{"name":"$writer","containerName":"_feature_span","kind":13,"line":1102},{"name":"startTag","containerName":"_feature_span","kind":12,"line":1102},{"name":"%atts","containerName":"_feature_span","kind":13,"line":1102},{"line":1103,"containerName":"_feature_span","kind":13,"name":"$self"},{"kind":12,"containerName":"_feature_span","name":"_element","line":1103},{"kind":13,"containerName":"_feature_span","name":"$name","line":1103},{"name":"$self","containerName":"_feature_span","kind":13,"line":1104},{"line":1104,"containerName":"_feature_span","kind":12,"name":"_element"},{"name":"$type","containerName":"_feature_span","kind":13,"line":1104},{"line":1105,"name":"$self","kind":13,"containerName":"_feature_span"},{"line":1105,"containerName":"_feature_span","kind":12,"name":"_seq_relationship"},{"line":1105,"kind":13,"containerName":"_feature_span","name":"$feat"},{"name":"$writer","kind":13,"containerName":"_feature_span","line":1106},{"line":1106,"kind":12,"containerName":"_feature_span","name":"endTag"}],"containerName":"main::","name":"_feature_span","definition":"sub","detail":"($self,$name,$feat,$pname)"},{"line":1094,"kind":12,"name":"writer"},{"line":1095,"name":"id","kind":12},{"line":1099,"name":"produces_seq","kind":12},{"definition":"sub","detail":"($self,$type,$loc,$seqname,$alignment)","children":[{"containerName":"_seq_relationship","localvar":"my","kind":13,"name":"$self","line":1122,"definition":"my"},{"name":"$type","containerName":"_seq_relationship","kind":13,"line":1122},{"containerName":"_seq_relationship","kind":13,"name":"$loc","line":1122},{"line":1122,"containerName":"_seq_relationship","kind":13,"name":"$seqname"},{"line":1122,"name":"$alignment","containerName":"_seq_relationship","kind":13},{"definition":"my","name":"$writer","localvar":"my","kind":13,"containerName":"_seq_relationship","line":1123},{"line":1123,"name":"$self","kind":13,"containerName":"_seq_relationship"},{"kind":13,"containerName":"_seq_relationship","name":"$seqname","line":1125},{"line":1126,"name":"$self","containerName":"_seq_relationship","kind":13},{"line":1126,"containerName":"_seq_relationship","kind":12,"name":"accession_number"},{"name":"$self","containerName":"_seq_relationship","kind":13,"line":1126},{"line":1127,"containerName":"_seq_relationship","kind":12,"name":"accession_number"},{"kind":13,"containerName":"_seq_relationship","name":"$self","line":1127},{"name":"display_id","containerName":"_seq_relationship","kind":12,"line":1127},{"line":1128,"name":"$writer","kind":13,"containerName":"_seq_relationship"},{"line":1128,"name":"startTag","kind":12,"containerName":"_seq_relationship"},{"name":"$type","containerName":"_seq_relationship","kind":13,"line":1130},{"name":"$seqname","containerName":"_seq_relationship","kind":13,"line":1131},{"name":"$self","containerName":"_seq_relationship","kind":13,"line":1133},{"containerName":"_seq_relationship","kind":12,"name":"_span","line":1133},{"kind":13,"containerName":"_seq_relationship","name":"$loc","line":1133},{"containerName":"_seq_relationship","kind":13,"name":"$writer","line":1134},{"line":1134,"kind":12,"containerName":"_seq_relationship","name":"_element"},{"containerName":"_seq_relationship","kind":13,"name":"$alignment","line":1134},{"name":"$alignment","kind":13,"containerName":"_seq_relationship","line":1134},{"line":1135,"kind":13,"containerName":"_seq_relationship","name":"$writer"},{"containerName":"_seq_relationship","kind":12,"name":"endTag","line":1135}],"name":"_seq_relationship","containerName":"main::","signature":{"label":"_seq_relationship($self,$type,$loc,$seqname,$alignment)","parameters":[{"label":"$self"},{"label":"$type"},{"label":"$loc"},{"label":"$seqname"},{"label":"$alignment"}],"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _render_tags {\n  my ($self,$feat,@render_funcs) = @_;\n\n  my @tagnames = $feat->get_all_tags;\n\n  #do a chain-of-responsibility down the allowed\n  #tag handlers types for the context in which this is\n  #called\n  foreach my $func (@render_funcs) {\n    @tagnames = $self->$func($feat,@tagnames);\n  }\n}\n\n=head2 _render_output_tags\n\n  Usage:\n  Desc : print out <output> elements, with contents\n         taken from the SeqFeature::Computation's 'output' tag\n  Ret  : array of tag names this did not render\n  Args : feature object, list of tag names to maybe render\n\n  In game xml, only <result_span> and <result_set> elements can\n  have <output> elements.\n\n\nsub _render_output_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n\n  for my $tag (@tagnames) {\n    if(lc($tag) eq 'output') {\n      my @outputs = $feat->get_tag_values($tag);\n      while(my($type,$val) = splice @outputs,0,2) {\n\t$writer->startTag('output');\n\t$self->_element('type',$type);\n\t$self->_element('value',$val);\n\t$writer->endTag('output');\n      }\n    }\n    else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_tags_as_properties\n\n  Usage:\n  Desc :\n  Ret  : empty array\n  Args : feature object, array of tag names\n  Side Effects:\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  and <feature_set> elements can have properties.\n\n\nsub _render_tags_as_properties {\n  my ($self,$feat,@tagnames) = @_;\n\n  foreach my $tag (@tagnames) {\n    if( $tag ne $feat->primary_tag ) {\n      $self->_property($tag,$_) for $feat->get_tag_values($tag);\n    }\n  }\n  return ();\n}\n\n=head2 _render_comment_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not comment tags\n  Args : feature object, tag names available for us to render\n  Side Effects: writes XML\n  Example:\n\n  In game xml, <annotation> and <feature_set> elements can\n  have comments.\n\n\nsub _render_comment_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n  for my $tag ( @tagnames ) {\n    if( lc($tag) eq 'comment' ) {\n      for my $val ($feat->get_tag_values($tag)) {\n\tif ( $val =~ /=.+?;.+=/ ) {\n\t  $self->_unflatten_attribute('comment', $val);\n\t} else {\n\t  $writer->startTag('comment');\n\t  $self->_element('text', $val);\n\t  $writer->endTag('comment');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_date_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not date tags\n  Args : feature, list of tag names available for us to render\n  Side Effects: writes XML for <date> elements\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  <transaction>, <comment>, and <feature_set> elements\n  can have <date>s.\n\n\nsub _render_date_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  my $date;\n  my %timestamp;\n  foreach my $tag (@tagnames) {\n    if ( lc($tag) eq 'date' ) {\n      ($date) = $feat->get_tag_values($tag);\n    } elsif ( lc($tag) eq 'timestamp' ) {\n      ($timestamp{'timestamp'}) = $feat->get_tag_values($tag);\n      #ignore timestamps, they are folded in with date elem above\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  $self->_element('date', $date, \\%timestamp) if defined($date);\n  return @passed_up;\n}\n\n=head2 _render_dbxref_tags\n\n  Desc : look for xref tags and render them if they are there\n  Ret  : tag names that we didn't render\n  Args : feature object, list of tag names to render\n  Side Effects: writes a <dbxref> element if a tag with name\n                matching /xref$/i is present\n\n\n  In game xml, <annotation> and <seq> elements can have dbxrefs.\n\n\n#TODO: can't sequences also have database xrefs?  how to find those?\nsub _render_dbxref_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my @passed_up;\n  for my $tag ( @tagnames ) {                           #look through all the tags\n    if( $tag =~ /xref$/i ) {                            #if they are xref tags\n      my $writer = $self->{writer};\n      for my $val ( $feat->get_all_tag_values($tag) ) { #get all their values\n\tif( my ($db,$dbid) = $val =~ /(\\S+):(\\S+)/ ) {  #and render them as xrefs\n\t  $writer->startTag('dbxref');\n\t  $self->_element('xref_db', $db);\n\t  $dbid = $val if $db =~ /^[A-Z]O$/; # -> ontology, like GO\n\t  $self->_element('db_xref_id', $dbid);\n\t  $writer->endTag('dbxref');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _render_target_tags\n\n  Usage:\n  Desc : process any 'Target' tags that would indicate a sequence alignment subject\n  Ret  : array of tag names that we didn't render\n  Args : feature object\n  Side Effects: writes a <seq_relationship> of type 'subject' if it finds\n                any properly formed tags named 'Target'\n  Example:\n\n  In game xml, <result_span>, <feature_span>, and <result_set> can have\n  <seq_relationship>s.  <result_set> can only have one, a 'query' relation.\n\n\nsub _render_target_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  foreach my $tag (@tagnames) {\n    if($tag eq 'Target' && (my @alignment = $feat->get_tag_values('Target')) >= 3) {\n      $self->_seq_relationship('subject',\n\t\t\t       Bio::Location::Simple->new( -start => $alignment[1],\n\t\t\t\t\t\t\t   -end   => $alignment[2],\n\t\t\t\t\t\t\t ),\n\t\t\t       $alignment[0],\n\t\t\t       $alignment[3],\n\t\t\t      );\n    } else {\n      push @passed_up, $tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _property\n\n Title   : _property\n Usage   : $self->_property($tag => $value); \n Function: an internal method to write property XML elements\n Returns : nothing\n Args    : a tag/value pair\n\n\nsub _property {\n    my ($self, $tag, $val) = @_;\n    my $writer = $self->{writer};\n\n    if ( length $val > 45 ) {\n\tmy @val = split /\\s+/, $val;\n\t$val = '';\n\t\n\tfor my $word (@val) {\n\t    my ($lastline) = $val =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $val .= length $lastline < 45 ? \" $word \" : \"\\n          $word\";\n\t}\n\t$val = \"\\n         $val\\n        \";\n\t$val =~ s/(\\S)\\s{2}(\\S)/$1 $2/g;\n    }\n    $writer->startTag('property');\n    $self->_element('type', $tag);\n    $self->_element('value', $val);\n    $writer->endTag('property');\n}\n\n=head2 _unflatten_attribute\n\n Title   : _unflatten_attribute\n Usage   : $self->_unflatten_attribute($name, $value)\n Function: an internal method to unflatten and write comment or evidence elements\n Returns : nothing\n Args    : a list of strings\n\n\nsub _unflatten_attribute {\n    my ($self, $name, $val) = @_;\n    my $writer = $self->{writer};\n    my %pair;\n    my @pairs = split ';', $val;\n    for my $p ( @pairs ) {\n\tmy @pair = split '=', $p;\n\t$pair[0] =~ s/^\\s+|\\s+$//g;\n\t$pair[1] =~ s/^\\s+|\\s+$//g;\n\t$pair{$pair[0]} = $pair[1];\n    }\n    $writer->startTag($name);\n    for ( keys %pair ) {\n\t$self->_element($_, $pair{$_});\n    }\n    $writer->endTag($name);\n    \n\n}\n\n=head2 _xref\n\n Title   : _xref\n Usage   : $self->_xref($value) \n Function: an internal method to write db_xref elements\n Returns : nothing \n Args    : a list of strings\n\n\nsub _xref {\n    my ($self, @xrefs) = @_;\n    my $writer = $self->{writer};\n    for my $xref ( @xrefs ) {\n\tmy ($db, $acc) = $xref =~ /(\\S+):(\\S+)/;\n\t$writer->startTag('dbxref');\n\t$self->_element('xref_db', $db);\n\t$acc = $xref if $db eq 'GO';\n\t$self->_element('db_xref_id', $acc);\n\t$writer->endTag('dbxref');\n    }\n}\n\n=head2 _feature_span\n\n Title   : _feature_span\n Usage   : $self->_feature_span($name, $type, $loc)\n Function: an internal method to write a feature_span element\n          (the actual feature with coordinates)\n Returns : nothing \n Args    : a feature name and Bio::SeqFeatureI-compliant object\n\n\nsub _feature_span {\n    my ($self, $name, $feat, $pname) = @_;\n    my $type = $feat->primary_tag;\n    my $writer = $self->{writer};\n    my %atts = ( id => $name );\n    \n    if ( $pname ) {\n\t$pname =~ s/-R/-P/;\n\t$atts{produces_seq} = $pname;\n    }\n\n    $writer->startTag('feature_span', %atts );\n    $self->_element('name', $name);\n    $self->_element('type', $type);\n    $self->_seq_relationship('query', $feat);\n    $writer->endTag('feature_span');\n}\n\n=head2 _seq_relationship\n\n Title   : _seq_relationship\n Usage   : $self->_seq_relationship($type, $loc)\n Function: an internal method to handle feature_span sequence relationships\n Returns : nothing\n Args    : feature type, a Bio::LocationI-compliant object,\n           (optional) sequence name (defaults to the query seq)\n           and (optional) alignment string"},"line":1121,"range":{"end":{"line":1136,"character":9999},"start":{"character":0,"line":1121}},"kind":12},{"line":1126,"name":"seq","kind":12},{"name":"seq","kind":12,"line":1126},{"kind":12,"name":"seq","line":1127},{"line":1130,"name":"type","kind":12},{"line":1131,"kind":12,"name":"seq"},{"definition":"sub","detail":"($self,$name,$chars,$atts)","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"_element","name":"$self","line":1155},{"line":1155,"name":"$name","kind":13,"containerName":"_element"},{"line":1155,"name":"$chars","containerName":"_element","kind":13},{"name":"$atts","containerName":"_element","kind":13,"line":1155},{"definition":"my","name":"$writer","containerName":"_element","localvar":"my","kind":13,"line":1156},{"name":"$self","kind":13,"containerName":"_element","line":1156},{"name":"%atts","localvar":"my","containerName":"_element","kind":13,"line":1157,"definition":"my"},{"line":1157,"kind":13,"containerName":"_element","name":"$atts"},{"kind":13,"containerName":"_element","name":"$atts","line":1157},{"name":"$writer","kind":13,"containerName":"_element","line":1159},{"line":1159,"containerName":"_element","kind":12,"name":"startTag"},{"containerName":"_element","kind":13,"name":"$name","line":1159},{"line":1159,"kind":13,"containerName":"_element","name":"%atts"},{"containerName":"_element","kind":13,"name":"$writer","line":1160},{"kind":12,"containerName":"_element","name":"characters","line":1160},{"kind":13,"containerName":"_element","name":"$chars","line":1160},{"name":"$writer","containerName":"_element","kind":13,"line":1161},{"containerName":"_element","kind":12,"name":"endTag","line":1161},{"line":1161,"name":"$name","kind":13,"containerName":"_element"}],"name":"_element","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$name"},{"label":"$chars"},{"label":"$atts"}],"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _render_tags {\n  my ($self,$feat,@render_funcs) = @_;\n\n  my @tagnames = $feat->get_all_tags;\n\n  #do a chain-of-responsibility down the allowed\n  #tag handlers types for the context in which this is\n  #called\n  foreach my $func (@render_funcs) {\n    @tagnames = $self->$func($feat,@tagnames);\n  }\n}\n\n=head2 _render_output_tags\n\n  Usage:\n  Desc : print out <output> elements, with contents\n         taken from the SeqFeature::Computation's 'output' tag\n  Ret  : array of tag names this did not render\n  Args : feature object, list of tag names to maybe render\n\n  In game xml, only <result_span> and <result_set> elements can\n  have <output> elements.\n\n\nsub _render_output_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n\n  for my $tag (@tagnames) {\n    if(lc($tag) eq 'output') {\n      my @outputs = $feat->get_tag_values($tag);\n      while(my($type,$val) = splice @outputs,0,2) {\n\t$writer->startTag('output');\n\t$self->_element('type',$type);\n\t$self->_element('value',$val);\n\t$writer->endTag('output');\n      }\n    }\n    else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_tags_as_properties\n\n  Usage:\n  Desc :\n  Ret  : empty array\n  Args : feature object, array of tag names\n  Side Effects:\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  and <feature_set> elements can have properties.\n\n\nsub _render_tags_as_properties {\n  my ($self,$feat,@tagnames) = @_;\n\n  foreach my $tag (@tagnames) {\n    if( $tag ne $feat->primary_tag ) {\n      $self->_property($tag,$_) for $feat->get_tag_values($tag);\n    }\n  }\n  return ();\n}\n\n=head2 _render_comment_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not comment tags\n  Args : feature object, tag names available for us to render\n  Side Effects: writes XML\n  Example:\n\n  In game xml, <annotation> and <feature_set> elements can\n  have comments.\n\n\nsub _render_comment_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n  for my $tag ( @tagnames ) {\n    if( lc($tag) eq 'comment' ) {\n      for my $val ($feat->get_tag_values($tag)) {\n\tif ( $val =~ /=.+?;.+=/ ) {\n\t  $self->_unflatten_attribute('comment', $val);\n\t} else {\n\t  $writer->startTag('comment');\n\t  $self->_element('text', $val);\n\t  $writer->endTag('comment');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_date_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not date tags\n  Args : feature, list of tag names available for us to render\n  Side Effects: writes XML for <date> elements\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  <transaction>, <comment>, and <feature_set> elements\n  can have <date>s.\n\n\nsub _render_date_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  my $date;\n  my %timestamp;\n  foreach my $tag (@tagnames) {\n    if ( lc($tag) eq 'date' ) {\n      ($date) = $feat->get_tag_values($tag);\n    } elsif ( lc($tag) eq 'timestamp' ) {\n      ($timestamp{'timestamp'}) = $feat->get_tag_values($tag);\n      #ignore timestamps, they are folded in with date elem above\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  $self->_element('date', $date, \\%timestamp) if defined($date);\n  return @passed_up;\n}\n\n=head2 _render_dbxref_tags\n\n  Desc : look for xref tags and render them if they are there\n  Ret  : tag names that we didn't render\n  Args : feature object, list of tag names to render\n  Side Effects: writes a <dbxref> element if a tag with name\n                matching /xref$/i is present\n\n\n  In game xml, <annotation> and <seq> elements can have dbxrefs.\n\n\n#TODO: can't sequences also have database xrefs?  how to find those?\nsub _render_dbxref_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my @passed_up;\n  for my $tag ( @tagnames ) {                           #look through all the tags\n    if( $tag =~ /xref$/i ) {                            #if they are xref tags\n      my $writer = $self->{writer};\n      for my $val ( $feat->get_all_tag_values($tag) ) { #get all their values\n\tif( my ($db,$dbid) = $val =~ /(\\S+):(\\S+)/ ) {  #and render them as xrefs\n\t  $writer->startTag('dbxref');\n\t  $self->_element('xref_db', $db);\n\t  $dbid = $val if $db =~ /^[A-Z]O$/; # -> ontology, like GO\n\t  $self->_element('db_xref_id', $dbid);\n\t  $writer->endTag('dbxref');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _render_target_tags\n\n  Usage:\n  Desc : process any 'Target' tags that would indicate a sequence alignment subject\n  Ret  : array of tag names that we didn't render\n  Args : feature object\n  Side Effects: writes a <seq_relationship> of type 'subject' if it finds\n                any properly formed tags named 'Target'\n  Example:\n\n  In game xml, <result_span>, <feature_span>, and <result_set> can have\n  <seq_relationship>s.  <result_set> can only have one, a 'query' relation.\n\n\nsub _render_target_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  foreach my $tag (@tagnames) {\n    if($tag eq 'Target' && (my @alignment = $feat->get_tag_values('Target')) >= 3) {\n      $self->_seq_relationship('subject',\n\t\t\t       Bio::Location::Simple->new( -start => $alignment[1],\n\t\t\t\t\t\t\t   -end   => $alignment[2],\n\t\t\t\t\t\t\t ),\n\t\t\t       $alignment[0],\n\t\t\t       $alignment[3],\n\t\t\t      );\n    } else {\n      push @passed_up, $tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _property\n\n Title   : _property\n Usage   : $self->_property($tag => $value); \n Function: an internal method to write property XML elements\n Returns : nothing\n Args    : a tag/value pair\n\n\nsub _property {\n    my ($self, $tag, $val) = @_;\n    my $writer = $self->{writer};\n\n    if ( length $val > 45 ) {\n\tmy @val = split /\\s+/, $val;\n\t$val = '';\n\t\n\tfor my $word (@val) {\n\t    my ($lastline) = $val =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $val .= length $lastline < 45 ? \" $word \" : \"\\n          $word\";\n\t}\n\t$val = \"\\n         $val\\n        \";\n\t$val =~ s/(\\S)\\s{2}(\\S)/$1 $2/g;\n    }\n    $writer->startTag('property');\n    $self->_element('type', $tag);\n    $self->_element('value', $val);\n    $writer->endTag('property');\n}\n\n=head2 _unflatten_attribute\n\n Title   : _unflatten_attribute\n Usage   : $self->_unflatten_attribute($name, $value)\n Function: an internal method to unflatten and write comment or evidence elements\n Returns : nothing\n Args    : a list of strings\n\n\nsub _unflatten_attribute {\n    my ($self, $name, $val) = @_;\n    my $writer = $self->{writer};\n    my %pair;\n    my @pairs = split ';', $val;\n    for my $p ( @pairs ) {\n\tmy @pair = split '=', $p;\n\t$pair[0] =~ s/^\\s+|\\s+$//g;\n\t$pair[1] =~ s/^\\s+|\\s+$//g;\n\t$pair{$pair[0]} = $pair[1];\n    }\n    $writer->startTag($name);\n    for ( keys %pair ) {\n\t$self->_element($_, $pair{$_});\n    }\n    $writer->endTag($name);\n    \n\n}\n\n=head2 _xref\n\n Title   : _xref\n Usage   : $self->_xref($value) \n Function: an internal method to write db_xref elements\n Returns : nothing \n Args    : a list of strings\n\n\nsub _xref {\n    my ($self, @xrefs) = @_;\n    my $writer = $self->{writer};\n    for my $xref ( @xrefs ) {\n\tmy ($db, $acc) = $xref =~ /(\\S+):(\\S+)/;\n\t$writer->startTag('dbxref');\n\t$self->_element('xref_db', $db);\n\t$acc = $xref if $db eq 'GO';\n\t$self->_element('db_xref_id', $acc);\n\t$writer->endTag('dbxref');\n    }\n}\n\n=head2 _feature_span\n\n Title   : _feature_span\n Usage   : $self->_feature_span($name, $type, $loc)\n Function: an internal method to write a feature_span element\n          (the actual feature with coordinates)\n Returns : nothing \n Args    : a feature name and Bio::SeqFeatureI-compliant object\n\n\nsub _feature_span {\n    my ($self, $name, $feat, $pname) = @_;\n    my $type = $feat->primary_tag;\n    my $writer = $self->{writer};\n    my %atts = ( id => $name );\n    \n    if ( $pname ) {\n\t$pname =~ s/-R/-P/;\n\t$atts{produces_seq} = $pname;\n    }\n\n    $writer->startTag('feature_span', %atts );\n    $self->_element('name', $name);\n    $self->_element('type', $type);\n    $self->_seq_relationship('query', $feat);\n    $writer->endTag('feature_span');\n}\n\n=head2 _seq_relationship\n\n Title   : _seq_relationship\n Usage   : $self->_seq_relationship($type, $loc)\n Function: an internal method to handle feature_span sequence relationships\n Returns : nothing\n Args    : feature type, a Bio::LocationI-compliant object,\n           (optional) sequence name (defaults to the query seq)\n           and (optional) alignment string\n\n\nsub _seq_relationship {\n    my ($self, $type, $loc, $seqname, $alignment) = @_;\n    my $writer = $self->{'writer'};\n\n    $seqname ||= #if no seqname passed in, use the name of our annotating seq\n      $self->{seq}->accession_number ne 'unknown' && $self->{seq}->accession_number\n\t|| $self->{seq}->display_id || 'unknown';\n    $writer->startTag(\n\t\t      'seq_relationship',\n\t\t      type => $type,\n\t\t      seq  => $seqname,\n\t\t     );\n    $self->_span($loc);\n    $writer->_element('alignment',$alignment) if $alignment;\n    $writer->endTag('seq_relationship');\n}\n\n=head2 _element\n\n Title   : _element\n Usage   : $self->_element($name, $chars, $atts)\n Function: an internal method to generate 'generic' XML elements\n Example : \n my $name = 'foo';\n my $content = 'bar';\n my $attributes = { baz => 1 }; \n # print the element\n $self->_element($name, $content, $attributes);\n Returns : nothing \n Args    : the element name and content plus a ref to an attribute hash","label":"_element($self,$name,$chars,$atts)"},"line":1154,"kind":12,"range":{"end":{"character":9999,"line":1162},"start":{"line":1154,"character":0}}},{"kind":12,"name":"writer","line":1156},{"signature":{"label":"_span($self,@loc)","documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _render_tags {\n  my ($self,$feat,@render_funcs) = @_;\n\n  my @tagnames = $feat->get_all_tags;\n\n  #do a chain-of-responsibility down the allowed\n  #tag handlers types for the context in which this is\n  #called\n  foreach my $func (@render_funcs) {\n    @tagnames = $self->$func($feat,@tagnames);\n  }\n}\n\n=head2 _render_output_tags\n\n  Usage:\n  Desc : print out <output> elements, with contents\n         taken from the SeqFeature::Computation's 'output' tag\n  Ret  : array of tag names this did not render\n  Args : feature object, list of tag names to maybe render\n\n  In game xml, only <result_span> and <result_set> elements can\n  have <output> elements.\n\n\nsub _render_output_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n\n  for my $tag (@tagnames) {\n    if(lc($tag) eq 'output') {\n      my @outputs = $feat->get_tag_values($tag);\n      while(my($type,$val) = splice @outputs,0,2) {\n\t$writer->startTag('output');\n\t$self->_element('type',$type);\n\t$self->_element('value',$val);\n\t$writer->endTag('output');\n      }\n    }\n    else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_tags_as_properties\n\n  Usage:\n  Desc :\n  Ret  : empty array\n  Args : feature object, array of tag names\n  Side Effects:\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  and <feature_set> elements can have properties.\n\n\nsub _render_tags_as_properties {\n  my ($self,$feat,@tagnames) = @_;\n\n  foreach my $tag (@tagnames) {\n    if( $tag ne $feat->primary_tag ) {\n      $self->_property($tag,$_) for $feat->get_tag_values($tag);\n    }\n  }\n  return ();\n}\n\n=head2 _render_comment_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not comment tags\n  Args : feature object, tag names available for us to render\n  Side Effects: writes XML\n  Example:\n\n  In game xml, <annotation> and <feature_set> elements can\n  have comments.\n\n\nsub _render_comment_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n  for my $tag ( @tagnames ) {\n    if( lc($tag) eq 'comment' ) {\n      for my $val ($feat->get_tag_values($tag)) {\n\tif ( $val =~ /=.+?;.+=/ ) {\n\t  $self->_unflatten_attribute('comment', $val);\n\t} else {\n\t  $writer->startTag('comment');\n\t  $self->_element('text', $val);\n\t  $writer->endTag('comment');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_date_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not date tags\n  Args : feature, list of tag names available for us to render\n  Side Effects: writes XML for <date> elements\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  <transaction>, <comment>, and <feature_set> elements\n  can have <date>s.\n\n\nsub _render_date_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  my $date;\n  my %timestamp;\n  foreach my $tag (@tagnames) {\n    if ( lc($tag) eq 'date' ) {\n      ($date) = $feat->get_tag_values($tag);\n    } elsif ( lc($tag) eq 'timestamp' ) {\n      ($timestamp{'timestamp'}) = $feat->get_tag_values($tag);\n      #ignore timestamps, they are folded in with date elem above\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  $self->_element('date', $date, \\%timestamp) if defined($date);\n  return @passed_up;\n}\n\n=head2 _render_dbxref_tags\n\n  Desc : look for xref tags and render them if they are there\n  Ret  : tag names that we didn't render\n  Args : feature object, list of tag names to render\n  Side Effects: writes a <dbxref> element if a tag with name\n                matching /xref$/i is present\n\n\n  In game xml, <annotation> and <seq> elements can have dbxrefs.\n\n\n#TODO: can't sequences also have database xrefs?  how to find those?\nsub _render_dbxref_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my @passed_up;\n  for my $tag ( @tagnames ) {                           #look through all the tags\n    if( $tag =~ /xref$/i ) {                            #if they are xref tags\n      my $writer = $self->{writer};\n      for my $val ( $feat->get_all_tag_values($tag) ) { #get all their values\n\tif( my ($db,$dbid) = $val =~ /(\\S+):(\\S+)/ ) {  #and render them as xrefs\n\t  $writer->startTag('dbxref');\n\t  $self->_element('xref_db', $db);\n\t  $dbid = $val if $db =~ /^[A-Z]O$/; # -> ontology, like GO\n\t  $self->_element('db_xref_id', $dbid);\n\t  $writer->endTag('dbxref');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _render_target_tags\n\n  Usage:\n  Desc : process any 'Target' tags that would indicate a sequence alignment subject\n  Ret  : array of tag names that we didn't render\n  Args : feature object\n  Side Effects: writes a <seq_relationship> of type 'subject' if it finds\n                any properly formed tags named 'Target'\n  Example:\n\n  In game xml, <result_span>, <feature_span>, and <result_set> can have\n  <seq_relationship>s.  <result_set> can only have one, a 'query' relation.\n\n\nsub _render_target_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  foreach my $tag (@tagnames) {\n    if($tag eq 'Target' && (my @alignment = $feat->get_tag_values('Target')) >= 3) {\n      $self->_seq_relationship('subject',\n\t\t\t       Bio::Location::Simple->new( -start => $alignment[1],\n\t\t\t\t\t\t\t   -end   => $alignment[2],\n\t\t\t\t\t\t\t ),\n\t\t\t       $alignment[0],\n\t\t\t       $alignment[3],\n\t\t\t      );\n    } else {\n      push @passed_up, $tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _property\n\n Title   : _property\n Usage   : $self->_property($tag => $value); \n Function: an internal method to write property XML elements\n Returns : nothing\n Args    : a tag/value pair\n\n\nsub _property {\n    my ($self, $tag, $val) = @_;\n    my $writer = $self->{writer};\n\n    if ( length $val > 45 ) {\n\tmy @val = split /\\s+/, $val;\n\t$val = '';\n\t\n\tfor my $word (@val) {\n\t    my ($lastline) = $val =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $val .= length $lastline < 45 ? \" $word \" : \"\\n          $word\";\n\t}\n\t$val = \"\\n         $val\\n        \";\n\t$val =~ s/(\\S)\\s{2}(\\S)/$1 $2/g;\n    }\n    $writer->startTag('property');\n    $self->_element('type', $tag);\n    $self->_element('value', $val);\n    $writer->endTag('property');\n}\n\n=head2 _unflatten_attribute\n\n Title   : _unflatten_attribute\n Usage   : $self->_unflatten_attribute($name, $value)\n Function: an internal method to unflatten and write comment or evidence elements\n Returns : nothing\n Args    : a list of strings\n\n\nsub _unflatten_attribute {\n    my ($self, $name, $val) = @_;\n    my $writer = $self->{writer};\n    my %pair;\n    my @pairs = split ';', $val;\n    for my $p ( @pairs ) {\n\tmy @pair = split '=', $p;\n\t$pair[0] =~ s/^\\s+|\\s+$//g;\n\t$pair[1] =~ s/^\\s+|\\s+$//g;\n\t$pair{$pair[0]} = $pair[1];\n    }\n    $writer->startTag($name);\n    for ( keys %pair ) {\n\t$self->_element($_, $pair{$_});\n    }\n    $writer->endTag($name);\n    \n\n}\n\n=head2 _xref\n\n Title   : _xref\n Usage   : $self->_xref($value) \n Function: an internal method to write db_xref elements\n Returns : nothing \n Args    : a list of strings\n\n\nsub _xref {\n    my ($self, @xrefs) = @_;\n    my $writer = $self->{writer};\n    for my $xref ( @xrefs ) {\n\tmy ($db, $acc) = $xref =~ /(\\S+):(\\S+)/;\n\t$writer->startTag('dbxref');\n\t$self->_element('xref_db', $db);\n\t$acc = $xref if $db eq 'GO';\n\t$self->_element('db_xref_id', $acc);\n\t$writer->endTag('dbxref');\n    }\n}\n\n=head2 _feature_span\n\n Title   : _feature_span\n Usage   : $self->_feature_span($name, $type, $loc)\n Function: an internal method to write a feature_span element\n          (the actual feature with coordinates)\n Returns : nothing \n Args    : a feature name and Bio::SeqFeatureI-compliant object\n\n\nsub _feature_span {\n    my ($self, $name, $feat, $pname) = @_;\n    my $type = $feat->primary_tag;\n    my $writer = $self->{writer};\n    my %atts = ( id => $name );\n    \n    if ( $pname ) {\n\t$pname =~ s/-R/-P/;\n\t$atts{produces_seq} = $pname;\n    }\n\n    $writer->startTag('feature_span', %atts );\n    $self->_element('name', $name);\n    $self->_element('type', $type);\n    $self->_seq_relationship('query', $feat);\n    $writer->endTag('feature_span');\n}\n\n=head2 _seq_relationship\n\n Title   : _seq_relationship\n Usage   : $self->_seq_relationship($type, $loc)\n Function: an internal method to handle feature_span sequence relationships\n Returns : nothing\n Args    : feature type, a Bio::LocationI-compliant object,\n           (optional) sequence name (defaults to the query seq)\n           and (optional) alignment string\n\n\nsub _seq_relationship {\n    my ($self, $type, $loc, $seqname, $alignment) = @_;\n    my $writer = $self->{'writer'};\n\n    $seqname ||= #if no seqname passed in, use the name of our annotating seq\n      $self->{seq}->accession_number ne 'unknown' && $self->{seq}->accession_number\n\t|| $self->{seq}->display_id || 'unknown';\n    $writer->startTag(\n\t\t      'seq_relationship',\n\t\t      type => $type,\n\t\t      seq  => $seqname,\n\t\t     );\n    $self->_span($loc);\n    $writer->_element('alignment',$alignment) if $alignment;\n    $writer->endTag('seq_relationship');\n}\n\n=head2 _element\n\n Title   : _element\n Usage   : $self->_element($name, $chars, $atts)\n Function: an internal method to generate 'generic' XML elements\n Example : \n my $name = 'foo';\n my $content = 'bar';\n my $attributes = { baz => 1 }; \n # print the element\n $self->_element($name, $content, $attributes);\n Returns : nothing \n Args    : the element name and content plus a ref to an attribute hash\n\n\nsub _element {\n    my ($self, $name, $chars, $atts) = @_;\n    my $writer = $self->{writer};\n    my %atts = $atts ? %$atts : ();\n    \n    $writer->startTag($name, %atts);\n    $writer->characters($chars);\n    $writer->endTag($name);\n}\n\n=head2 _span\n\n Title   : _span\n Usage   : $self->_span($loc)\n Function: an internal method to write the 'span' element\n Returns : nothing\n Args    : a Bio::LocationI-compliant object","parameters":[{"label":"$self"},{"label":"@loc"}]},"range":{"start":{"character":0,"line":1174},"end":{"line":1198,"character":9999}},"kind":12,"line":1174,"detail":"($self,@loc)","definition":"sub","name":"_span","containerName":"main::","children":[{"definition":"my","line":1175,"name":"$self","kind":13,"localvar":"my","containerName":"_span"},{"name":"@loc","kind":13,"containerName":"_span","line":1175},{"definition":"my","line":1176,"kind":13,"localvar":"my","containerName":"_span","name":"$loc"},{"kind":13,"containerName":"_span","name":"$start","line":1176},{"containerName":"_span","kind":13,"name":"$end","line":1176},{"kind":13,"containerName":"_span","name":"@loc","line":1178},{"line":1179,"kind":13,"containerName":"_span","name":"$loc"},{"kind":13,"containerName":"_span","name":"$loc","line":1179},{"line":1181,"kind":13,"containerName":"_span","name":"@loc"},{"name":"$start","kind":13,"containerName":"_span","line":1182},{"kind":13,"containerName":"_span","name":"$end","line":1182},{"kind":13,"containerName":"_span","name":"@loc","line":1182},{"line":1185,"name":"$loc","containerName":"_span","kind":13},{"line":1186,"name":"$start","kind":13,"containerName":"_span"},{"name":"$end","containerName":"_span","kind":13,"line":1186},{"name":"$loc","containerName":"_span","kind":13,"line":1186},{"line":1186,"name":"start","kind":12,"containerName":"_span"},{"containerName":"_span","kind":13,"name":"$loc","line":1186},{"name":"end","containerName":"_span","kind":12,"line":1186},{"name":"$start","kind":13,"containerName":"_span","line":1187},{"name":"$end","containerName":"_span","kind":13,"line":1187},{"kind":13,"containerName":"_span","name":"$end","line":1187},{"line":1187,"name":"$start","containerName":"_span","kind":13},{"containerName":"_span","kind":13,"name":"$loc","line":1187},{"name":"strand","containerName":"_span","kind":12,"line":1187},{"name":"$start","containerName":"_span","kind":13,"line":1189},{"name":"$start","containerName":"_span","kind":13,"line":1190},{"line":1190,"name":"$end","containerName":"_span","kind":13},{"name":"$self","kind":13,"containerName":"_span","line":1190},{"line":1190,"name":"length","kind":12,"containerName":"_span"},{"line":1193,"localvar":"my","containerName":"_span","kind":13,"name":"$writer","definition":"my"},{"line":1193,"name":"$self","containerName":"_span","kind":13},{"containerName":"_span","kind":13,"name":"$writer","line":1194},{"kind":12,"containerName":"_span","name":"startTag","line":1194},{"name":"$self","containerName":"_span","kind":13,"line":1195},{"line":1195,"name":"_element","kind":12,"containerName":"_span"},{"kind":13,"containerName":"_span","name":"$start","line":1195},{"line":1196,"name":"$self","kind":13,"containerName":"_span"},{"line":1196,"kind":12,"containerName":"_span","name":"_element"},{"name":"$end","containerName":"_span","kind":13,"line":1196},{"containerName":"_span","kind":13,"name":"$writer","line":1197},{"line":1197,"name":"endTag","containerName":"_span","kind":12}]},{"line":1190,"name":"seq","kind":12},{"kind":12,"name":"writer","line":1193},{"line":1210,"range":{"end":{"character":9999,"line":1235},"start":{"line":1210,"character":0}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$seq"},{"label":"$atts"}],"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _render_tags {\n  my ($self,$feat,@render_funcs) = @_;\n\n  my @tagnames = $feat->get_all_tags;\n\n  #do a chain-of-responsibility down the allowed\n  #tag handlers types for the context in which this is\n  #called\n  foreach my $func (@render_funcs) {\n    @tagnames = $self->$func($feat,@tagnames);\n  }\n}\n\n=head2 _render_output_tags\n\n  Usage:\n  Desc : print out <output> elements, with contents\n         taken from the SeqFeature::Computation's 'output' tag\n  Ret  : array of tag names this did not render\n  Args : feature object, list of tag names to maybe render\n\n  In game xml, only <result_span> and <result_set> elements can\n  have <output> elements.\n\n\nsub _render_output_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n\n  for my $tag (@tagnames) {\n    if(lc($tag) eq 'output') {\n      my @outputs = $feat->get_tag_values($tag);\n      while(my($type,$val) = splice @outputs,0,2) {\n\t$writer->startTag('output');\n\t$self->_element('type',$type);\n\t$self->_element('value',$val);\n\t$writer->endTag('output');\n      }\n    }\n    else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_tags_as_properties\n\n  Usage:\n  Desc :\n  Ret  : empty array\n  Args : feature object, array of tag names\n  Side Effects:\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  and <feature_set> elements can have properties.\n\n\nsub _render_tags_as_properties {\n  my ($self,$feat,@tagnames) = @_;\n\n  foreach my $tag (@tagnames) {\n    if( $tag ne $feat->primary_tag ) {\n      $self->_property($tag,$_) for $feat->get_tag_values($tag);\n    }\n  }\n  return ();\n}\n\n=head2 _render_comment_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not comment tags\n  Args : feature object, tag names available for us to render\n  Side Effects: writes XML\n  Example:\n\n  In game xml, <annotation> and <feature_set> elements can\n  have comments.\n\n\nsub _render_comment_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n  for my $tag ( @tagnames ) {\n    if( lc($tag) eq 'comment' ) {\n      for my $val ($feat->get_tag_values($tag)) {\n\tif ( $val =~ /=.+?;.+=/ ) {\n\t  $self->_unflatten_attribute('comment', $val);\n\t} else {\n\t  $writer->startTag('comment');\n\t  $self->_element('text', $val);\n\t  $writer->endTag('comment');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_date_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not date tags\n  Args : feature, list of tag names available for us to render\n  Side Effects: writes XML for <date> elements\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  <transaction>, <comment>, and <feature_set> elements\n  can have <date>s.\n\n\nsub _render_date_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  my $date;\n  my %timestamp;\n  foreach my $tag (@tagnames) {\n    if ( lc($tag) eq 'date' ) {\n      ($date) = $feat->get_tag_values($tag);\n    } elsif ( lc($tag) eq 'timestamp' ) {\n      ($timestamp{'timestamp'}) = $feat->get_tag_values($tag);\n      #ignore timestamps, they are folded in with date elem above\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  $self->_element('date', $date, \\%timestamp) if defined($date);\n  return @passed_up;\n}\n\n=head2 _render_dbxref_tags\n\n  Desc : look for xref tags and render them if they are there\n  Ret  : tag names that we didn't render\n  Args : feature object, list of tag names to render\n  Side Effects: writes a <dbxref> element if a tag with name\n                matching /xref$/i is present\n\n\n  In game xml, <annotation> and <seq> elements can have dbxrefs.\n\n\n#TODO: can't sequences also have database xrefs?  how to find those?\nsub _render_dbxref_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my @passed_up;\n  for my $tag ( @tagnames ) {                           #look through all the tags\n    if( $tag =~ /xref$/i ) {                            #if they are xref tags\n      my $writer = $self->{writer};\n      for my $val ( $feat->get_all_tag_values($tag) ) { #get all their values\n\tif( my ($db,$dbid) = $val =~ /(\\S+):(\\S+)/ ) {  #and render them as xrefs\n\t  $writer->startTag('dbxref');\n\t  $self->_element('xref_db', $db);\n\t  $dbid = $val if $db =~ /^[A-Z]O$/; # -> ontology, like GO\n\t  $self->_element('db_xref_id', $dbid);\n\t  $writer->endTag('dbxref');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _render_target_tags\n\n  Usage:\n  Desc : process any 'Target' tags that would indicate a sequence alignment subject\n  Ret  : array of tag names that we didn't render\n  Args : feature object\n  Side Effects: writes a <seq_relationship> of type 'subject' if it finds\n                any properly formed tags named 'Target'\n  Example:\n\n  In game xml, <result_span>, <feature_span>, and <result_set> can have\n  <seq_relationship>s.  <result_set> can only have one, a 'query' relation.\n\n\nsub _render_target_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  foreach my $tag (@tagnames) {\n    if($tag eq 'Target' && (my @alignment = $feat->get_tag_values('Target')) >= 3) {\n      $self->_seq_relationship('subject',\n\t\t\t       Bio::Location::Simple->new( -start => $alignment[1],\n\t\t\t\t\t\t\t   -end   => $alignment[2],\n\t\t\t\t\t\t\t ),\n\t\t\t       $alignment[0],\n\t\t\t       $alignment[3],\n\t\t\t      );\n    } else {\n      push @passed_up, $tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _property\n\n Title   : _property\n Usage   : $self->_property($tag => $value); \n Function: an internal method to write property XML elements\n Returns : nothing\n Args    : a tag/value pair\n\n\nsub _property {\n    my ($self, $tag, $val) = @_;\n    my $writer = $self->{writer};\n\n    if ( length $val > 45 ) {\n\tmy @val = split /\\s+/, $val;\n\t$val = '';\n\t\n\tfor my $word (@val) {\n\t    my ($lastline) = $val =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $val .= length $lastline < 45 ? \" $word \" : \"\\n          $word\";\n\t}\n\t$val = \"\\n         $val\\n        \";\n\t$val =~ s/(\\S)\\s{2}(\\S)/$1 $2/g;\n    }\n    $writer->startTag('property');\n    $self->_element('type', $tag);\n    $self->_element('value', $val);\n    $writer->endTag('property');\n}\n\n=head2 _unflatten_attribute\n\n Title   : _unflatten_attribute\n Usage   : $self->_unflatten_attribute($name, $value)\n Function: an internal method to unflatten and write comment or evidence elements\n Returns : nothing\n Args    : a list of strings\n\n\nsub _unflatten_attribute {\n    my ($self, $name, $val) = @_;\n    my $writer = $self->{writer};\n    my %pair;\n    my @pairs = split ';', $val;\n    for my $p ( @pairs ) {\n\tmy @pair = split '=', $p;\n\t$pair[0] =~ s/^\\s+|\\s+$//g;\n\t$pair[1] =~ s/^\\s+|\\s+$//g;\n\t$pair{$pair[0]} = $pair[1];\n    }\n    $writer->startTag($name);\n    for ( keys %pair ) {\n\t$self->_element($_, $pair{$_});\n    }\n    $writer->endTag($name);\n    \n\n}\n\n=head2 _xref\n\n Title   : _xref\n Usage   : $self->_xref($value) \n Function: an internal method to write db_xref elements\n Returns : nothing \n Args    : a list of strings\n\n\nsub _xref {\n    my ($self, @xrefs) = @_;\n    my $writer = $self->{writer};\n    for my $xref ( @xrefs ) {\n\tmy ($db, $acc) = $xref =~ /(\\S+):(\\S+)/;\n\t$writer->startTag('dbxref');\n\t$self->_element('xref_db', $db);\n\t$acc = $xref if $db eq 'GO';\n\t$self->_element('db_xref_id', $acc);\n\t$writer->endTag('dbxref');\n    }\n}\n\n=head2 _feature_span\n\n Title   : _feature_span\n Usage   : $self->_feature_span($name, $type, $loc)\n Function: an internal method to write a feature_span element\n          (the actual feature with coordinates)\n Returns : nothing \n Args    : a feature name and Bio::SeqFeatureI-compliant object\n\n\nsub _feature_span {\n    my ($self, $name, $feat, $pname) = @_;\n    my $type = $feat->primary_tag;\n    my $writer = $self->{writer};\n    my %atts = ( id => $name );\n    \n    if ( $pname ) {\n\t$pname =~ s/-R/-P/;\n\t$atts{produces_seq} = $pname;\n    }\n\n    $writer->startTag('feature_span', %atts );\n    $self->_element('name', $name);\n    $self->_element('type', $type);\n    $self->_seq_relationship('query', $feat);\n    $writer->endTag('feature_span');\n}\n\n=head2 _seq_relationship\n\n Title   : _seq_relationship\n Usage   : $self->_seq_relationship($type, $loc)\n Function: an internal method to handle feature_span sequence relationships\n Returns : nothing\n Args    : feature type, a Bio::LocationI-compliant object,\n           (optional) sequence name (defaults to the query seq)\n           and (optional) alignment string\n\n\nsub _seq_relationship {\n    my ($self, $type, $loc, $seqname, $alignment) = @_;\n    my $writer = $self->{'writer'};\n\n    $seqname ||= #if no seqname passed in, use the name of our annotating seq\n      $self->{seq}->accession_number ne 'unknown' && $self->{seq}->accession_number\n\t|| $self->{seq}->display_id || 'unknown';\n    $writer->startTag(\n\t\t      'seq_relationship',\n\t\t      type => $type,\n\t\t      seq  => $seqname,\n\t\t     );\n    $self->_span($loc);\n    $writer->_element('alignment',$alignment) if $alignment;\n    $writer->endTag('seq_relationship');\n}\n\n=head2 _element\n\n Title   : _element\n Usage   : $self->_element($name, $chars, $atts)\n Function: an internal method to generate 'generic' XML elements\n Example : \n my $name = 'foo';\n my $content = 'bar';\n my $attributes = { baz => 1 }; \n # print the element\n $self->_element($name, $content, $attributes);\n Returns : nothing \n Args    : the element name and content plus a ref to an attribute hash\n\n\nsub _element {\n    my ($self, $name, $chars, $atts) = @_;\n    my $writer = $self->{writer};\n    my %atts = $atts ? %$atts : ();\n    \n    $writer->startTag($name, %atts);\n    $writer->characters($chars);\n    $writer->endTag($name);\n}\n\n=head2 _span\n\n Title   : _span\n Usage   : $self->_span($loc)\n Function: an internal method to write the 'span' element\n Returns : nothing\n Args    : a Bio::LocationI-compliant object\n\n\nsub _span {\n    my ($self, @loc) = @_;\n    my ($loc, $start, $end);\n\n    if ( @loc == 1 ) {\n\t$loc = $loc[0];\n    }\n    elsif ( @loc == 2 ) {\n\t($start, $end) = @loc;\n    }\n\n    if ( $loc ) {\n\t($start, $end) = ($loc->start, $loc->end);\n\t($start, $end) = ($end, $start) if $loc->strand < 0;\n    } \n    elsif ( !$start ) {\n\t($start, $end) = (1, $self->{seq}->length);\n    }\n    \n    my $writer = $self->{writer};\n    $writer->startTag('span');\n    $self->_element('start', $start);\n    $self->_element('end', $end);\n    $writer->endTag('span');\n}\n\n=head2 _seq\n\n Title   : _seq\n Usage   : $self->_seq($seq, $dna) \n Function: an internal method to print the 'sequence' element\n Returns : nothing\n Args    : and Bio::SeqI-compliant object and a reference to an attribute  hash","label":"_seq($self,$seq,$atts)"},"children":[{"line":1211,"name":"$self","containerName":"_seq","localvar":"my","kind":13,"definition":"my"},{"name":"$seq","containerName":"_seq","kind":13,"line":1211},{"name":"$atts","containerName":"_seq","kind":13,"line":1211},{"definition":"my","line":1213,"localvar":"my","kind":13,"containerName":"_seq","name":"$writer"},{"containerName":"_seq","kind":13,"name":"$self","line":1213},{"definition":"my","line":1217,"name":"$alphabet","kind":13,"localvar":"my","containerName":"_seq"},{"line":1217,"kind":13,"containerName":"_seq","name":"$seq"},{"line":1217,"name":"alphabet","containerName":"_seq","kind":12},{"name":"$alphabet","containerName":"_seq","kind":13,"line":1218},{"containerName":"_seq","kind":13,"name":"$seq","line":1218},{"name":"mol_type","containerName":"_seq","kind":12,"line":1218},{"name":"$seq","kind":13,"containerName":"_seq","line":1218},{"line":1218,"kind":12,"containerName":"_seq","name":"can"},{"kind":13,"containerName":"_seq","name":"$alphabet","line":1219},{"name":"$alphabet","kind":13,"containerName":"_seq","line":1220},{"localvar":"my","kind":13,"containerName":"_seq","name":"@seq","line":1222,"definition":"my"},{"name":"$atts","kind":13,"containerName":"_seq","line":1223},{"line":1224,"name":"$seq","kind":13,"containerName":"_seq"},{"line":1224,"name":"length","kind":12,"containerName":"_seq"},{"line":1225,"name":"$alphabet","kind":13,"containerName":"_seq"},{"line":1229,"kind":13,"containerName":"_seq","name":"$atts"},{"kind":13,"containerName":"_seq","name":"@seq","line":1230},{"kind":13,"containerName":"_seq","name":"$atts","line":1230},{"line":1231,"name":"$atts","containerName":"_seq","kind":13},{"name":"$writer","kind":13,"containerName":"_seq","line":1233},{"containerName":"_seq","kind":12,"name":"startTag","line":1233},{"containerName":"_seq","kind":13,"name":"@seq","line":1233},{"definition":"my","line":1235,"localvar":"my","kind":13,"containerName":"_seq","name":"$k"},{"line":1235,"kind":13,"containerName":"_seq","name":"$atts"}],"containerName":"main::","name":"_seq","definition":"sub","detail":"($self,$seq,$atts)"},{"line":1223,"kind":12,"name":"id"},{"kind":12,"name":"name","line":1223},{"kind":12,"name":"length","line":1224},{"line":1225,"kind":12,"name":"type"},{"line":1226,"name":"focus","kind":12},{"kind":12,"name":"md5checksum","line":1229},{"kind":12,"name":"md5checksum","line":1230},{"kind":12,"name":"md5checksum","line":1230},{"name":"md5checksum","kind":12,"line":1231},{"line":1236,"containerName":null,"kind":13,"name":"%k"},{"line":1237,"name":"$self","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"_xref","line":1237},{"line":1237,"kind":13,"containerName":null,"name":"%atts"},{"line":1237,"name":"%k","kind":13,"containerName":null},{"line":1240,"kind":13,"containerName":null,"name":"$self"},{"name":"_element","kind":12,"containerName":"main::","line":1240},{"line":1240,"name":"$k","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%atts","line":1240},{"line":1240,"name":"$k","containerName":null,"kind":13},{"line":1246,"name":"$sp","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$dna","line":1247},{"kind":13,"containerName":null,"name":"$seq","line":1247},{"name":"seq","containerName":"main::","kind":12,"line":1247},{"line":1248,"name":"$dna","containerName":null,"kind":13},{"line":1249,"name":"$dna","kind":13,"containerName":null},{"line":1249,"kind":13,"containerName":null,"name":"$dna"},{"kind":13,"containerName":null,"name":"$seq","line":1251},{"name":"species","kind":12,"containerName":"main::","line":1251},{"name":"%self","containerName":null,"kind":13,"line":1251},{"name":"has_organism","kind":12,"line":1251},{"localvar":"my","kind":13,"containerName":null,"name":"$species","line":1252,"definition":"my"},{"containerName":null,"kind":13,"name":"$seq","line":1252},{"line":1252,"name":"species","kind":12,"containerName":"main::"},{"kind":12,"containerName":"main::","name":"binomial","line":1252},{"line":1253,"name":"$self","containerName":null,"kind":13},{"line":1253,"containerName":"main::","kind":12,"name":"_element"},{"line":1253,"name":"$species","kind":13,"containerName":null},{"line":1256,"containerName":null,"kind":13,"name":"$self"},{"line":1256,"name":"_element","containerName":"main::","kind":12},{"line":1256,"kind":13,"containerName":null,"name":"$dna"},{"line":1257,"name":"$writer","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"endTag","line":1257},{"signature":{"documentation":"1;\n# $Id: gameWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::gameWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::gameWriter -- a class for writing game-XML\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n\n  my $in  = Bio::SeqIO->new( -format => 'genbank',\n                             -file => 'myfile.gbk' );\n  my $out = Bio::SeqIO->new( -format => 'game',\n                             -file => 'myfile.xml' );\n\n  # get a sequence object\n  my $seq = $in->next_seq;\n\n  #write it in GAME format\n  $out->write_seq($seq);\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::gameWriter writes GAME-XML (v. 1.2) that is readable\nby Apollo.  It is best not used directly.  It is accessed via\nBio::SeqIO.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::gameWriter;\n\nuse strict;\nuse IO::String;\nuse XML::Writer;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Tools::Unflattener;\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $writer = Bio::SeqIO::game::gameWriter->new($seq);\n Function: constructor method for gameWriter \n Returns : a game writer object \n Args    : a Bio::SeqI implementing object\n           optionally, an argument to set map_position to on.\n           ( map => 1 ).  This will create a map_position elemant\n           that will cause the feature coordinates to be remapped to\n           a parent seqeunce.  A sequence name in the format seq:xxx-xxx\n           is expected to determine the offset for the map_position.\n           The default behavior is to have features mapped relative to \n           the sequence contained in the GAME-XML file\n\n\nsub new {\n    my ($caller, $seq, %arg) = @_;\n    my $class = ref($caller) || $caller;\n    my $self = bless ( { seq => $seq }, $class );\n\n    # make a <map_position> element only if requested \n    $self->{map} = 1 if $arg{map};\n    $self->{anon_set_counters} = {}; #counters for numbering anonymous result and feature sets\n    return $self;\n}\n\n=head2 write_to_game\n\n Title   : write_to_game\n Usage   : $writer->write_to_game\n Function: writes the sequence object to game-XML \n Returns : xml as a multiline string\n Args    : none\n\n\nsub write_to_game {\n    my $self   = shift;\n    my $seq    = $self->{seq};\n    my @feats  = $seq->remove_SeqFeatures;\n\n    # intercept nested features \n    my @nested_feats = grep { $_->get_SeqFeatures } @feats;\n    @feats = grep { !$_->get_SeqFeatures } @feats;\n    map { $seq->add_SeqFeature($_) } @feats;\n\n# NB -- Maybe this belongs in Bio::SeqFeatute::Tools::Unflattener\n\n#    # intercept non-coding RNAs and transposons with contained genes\n#    # GAME-XML has these features as top level annotations which contain\n#    # gene elements\n#    my @gene_containers = ();\n     \n#    for ( @feats ) {\n#\tif ( $_->primary_tag =~ /[^m]RNA|repeat_region|transpos/ && \n#\t     $_->has_tag('gene') ) {\n#\t    my @genes = $_->get_tag_values('gene');\n#\t    my ($min, $max) = (10000000000000,-10000000000000);\n#\t    for my $g ( @genes ) {\n#\t\tmy $gene;\n#\t\tfor my $item ( @feats ) {\n#\t\t    next unless $item->primary_tag eq 'gene';\n#\t\t    my ($n) = $item->get_tag_values('gene');\n#\t\t    next unless $n =~ /$g/;\n#\t\t    $gene = $item;\n#\t\t    last;\n#\t\t}\n#\t\tnext unless $gene && ref $gene;\n#\t\t$max = $gene->end if $gene->end > $max;\n#\t\t$min = $gene->start if $gene->start < $min;\n#\t    }\n#\t    \n#\t    push @gene_containers, $_ if $_->length >= ($max - $min);\n#\t}\n#\telse {\n#\t    $seq->add_SeqFeature($_);\n#\t}\n#    }\n\t\n    # unflatten \n    my $uf = Bio::SeqFeature::Tools::Unflattener->new;\n    $uf->unflatten_seq( -seq => $seq, use_magic => 1 );\n    \n    # rearrange snRNA and transposon hierarchies\n    # $self->_rearrange_hierarchies($seq, @gene_containers);\n\n    # add back nested feats\n    $seq->add_SeqFeature( @nested_feats  );\n    \n    my $atts  = {};\n    my $xml = '';\n    \n    # write the XML to a string\n    my $xml_handle = IO::String->new($xml);\n    my $writer = XML::Writer->new(OUTPUT      => $xml_handle,\n\t\t\t\t  DATA_MODE   => 1,\n\t\t\t\t  DATA_INDENT => 2,\n\t\t\t\t  NEWLINE     => 1\n\t\t\t\t  );\n    $self->{writer} = $writer;\n#    $writer->xmlDecl(\"UTF-8\");\n#    $writer->doctype(\"game\", 'game', \"http://www.fruitfly.org/annot/gamexml.dtd.txt\");\n    $writer->comment(\"GAME-XML generated by Bio::SeqIO::game::gameWriter\");\n    $writer->comment(\"Created \" . localtime);\n    $writer->comment('Questions: mckays@cshl.edu');\n    $writer->startTag('game', version => 1.2);\n    \n    my @sources = grep { $_->primary_tag =~ /source|origin|region/i } $seq->get_SeqFeatures;\n    \n    for my $source ( @sources ) {\n\tnext unless $source->length == $seq->length;\n\tfor ( qw{ name description db_xref organism md5checksum } ) {\n\t    if ( $source->has_tag($_) ) {\n\t\t$self->{has_organism} = 1 if /organism/;\n\t\t($atts->{$_}) = $source->get_tag_values($_);\n\t    }\n\t}\n    }\n    \n\n    #set a name in the attributes if none was given\n    $atts->{name} ||= $seq->accession_number ne 'unknown'\n      ? $seq->accession_number : $seq->display_name;\n\n    $self->_seq($seq, $atts);\n    \n    # make a map_position element if req'd\n    if ( $self->{map} ) {\n\tmy $seqtype;\n\tif ( $atts->{mol_type} || $seq->alphabet ) {\n\t    $seqtype = $atts->{mol_type} || $seq->alphabet;\n\t}\n\telse {\n\t    $seqtype = 'unknown';\n\t}    \n\t\n\t$writer->startTag(\n\t\t\t  'map_position', \n\t\t\t  seq => $atts->{name},\n\t\t\t  type => $seqtype\n\t\t\t  );\n\t\n\tmy ($arm, $start, undef, $end) = $atts->{name} =~ /(\\S+):(-?\\d+)(\\.\\.|-)(-?\\d+)/;\n\t$self->_element('arm', $arm) if $arm;\n\t$self->_span($start, $end);\n\t$writer->endTag('map_position');\n    }\n\n    for ( $seq->top_SeqFeatures ) {\n\n      if($_->isa('Bio::SeqFeature::Computation')) {\n\t$self->_comp_analysis($_);\n      }\n      else {\n        # if the feature has subfeatures, we will assume it is a gene\n\t# (hope this is safe!)\n\tif ( $_->get_SeqFeatures ) {\n\t  $self->_write_gene($_);\n\t} else {\n\t  # non-gene stuff only\n\t  next if $_->primary_tag =~ /CDS|mRNA|exon|UTR/;\n\t  $self->_write_feature($_);\n\t}\n      }\n    }    \n    \n    $writer->endTag('game');\n    $writer->end;\n    $xml;\n}\n\n=head2 _rearrange_hierarchies\n\n Title   : _rearrange_hierarchies\n Usage   : $self->_rearrange_hierarchies($seq)\n Function: internal method to rearrange gene containment hierarchies\n           so that snRNA or transposon features contain their genes\n           rather than the other way around\n Returns : nothing\n Args    : a Bio::RichSeq object\n Note    : Not currently used, may be removed\n\n\nsub _rearrange_hierarchies { #renamed to not conflict with Bio::Root::_rearrange\n    my ($self, $seq, @containers) = @_;\n    my @feats   = $seq->remove_SeqFeatures;\n    my @genes   = grep { $_->primary_tag eq 'gene' } @feats;\n    my @addback = grep { $_->primary_tag ne 'gene' } @feats;\n    \n    for ( @containers ) {\n\tmy @has_genes = $_->get_tag_values('gene');\n\tfor my $has_gene ( @has_genes ) {\n\t    for my $gene ( @genes ) {\n\t\tnext unless $gene;\n\t\tmy ($gname) = $gene->get_tag_values('gene');\n\t\tif ( $gname eq $has_gene ) {\n\t\t    $_->add_SeqFeature($gene);\n\t\t    undef $gene;\n\t\t}\n\t    }\n\t}\n    }    \n   \n    push @addback, (@containers, grep { defined $_ } @genes );\n    $seq->add_SeqFeature(@addback);\n}\n\n\n=head2 _write_feature\n\n Title   : _write_feature\n Usage   : $seld->_write_feature($feat, 1)\n Function: internal method for writing generic features as <annotation> elements\n Returns : nothing\n Args    : a Bio::SeqFeature::Generic object and an optional flag to write a\n           bare feature set with no annotation wrapper\n\n\nsub _write_feature {\n    my ($self, $feat, $bare) = @_;\n    my $writer = $self->{writer};\n    my $id;\n\n    for ( 'standard_name', $feat->primary_tag, 'ID' ) {\n\t$id = $self->_find_name($feat, $_ );\n\tlast if $id;\n    } \n\n    $id ||= $feat->primary_tag . '_' . ++$self->{$feat->primary_tag}->{id};\n\n    unless ( $bare ) {\n\t$writer->startTag('annotation', id => $id); \n\t$self->_element('name', $id);\n\t$self->_element('type', $feat->primary_tag);\n    }\n\n    $writer->startTag('feature_set', id => $id);\n    $self->_element('name', $id);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties\n\t\t       );\n    $self->_feature_span($id, $feat);\n    $writer->endTag('feature_set');\n    $writer->endTag('annotation') unless $bare;\n}\n\n=head2 _write_gene\n\n Title   : _write_gene\n Usage   : $self->_write_gene($feature)\n Function: internal method for rendering gene containment hierarchies into \n           a nested <annotation> element \n Returns : nothing\n Args    : a nested Bio::SeqFeature::Generic gene feature\n Note    : A nested gene hierarchy (gene->mRNA->CDS->exon) is expected.  If other gene \n           subfeatures occur as level one subfeatures (same level as mRNA subfeats) \n           an attempt will be made to link them to transcripts via the 'standard_name'\n           qualifier\n\n\nsub _write_gene {\n    my ($self, $feat) = @_;\n    my $writer = $self->{writer};\n    my $str = $feat->strand;\n    my $id = $self->_find_name($feat, 'standard_name')\n          || $self->_find_name($feat, 'gene')\n\t  || $self->_find_name($feat, $feat->primary_tag)\n\t  || $self->_find_name($feat, 'locus_tag') \n\t  || $self->_find_name($feat, 'symbol')\n          || $self->throw(<<EOM.\"Feature name was: '\".($feat->display_name || 'not set').\"'\");\nCould not find a gene/feature ID, feature must have a primary tag or a tag\nwith one of the names: 'standard_name', 'gene', 'locus_tag', or 'symbol'.\nEOM\n    my $gid = $self->_find_name($feat, 'gene') || $id;\n\n    $writer->startTag('annotation', id => $id);\n    $self->_element('name', $gid);\n    $self->_element('type', $feat->primary_tag);\n    $self->_render_tags( $feat,\n\t\t\t \\&_render_date_tags,\n\t\t\t \\&_render_dbxref_tags,\n\t\t\t \\&_render_comment_tags,\n\t\t\t \\&_render_tags_as_properties,\n\t\t       );\n    \n    my @genes;\n    \n    if ( $feat->primary_tag eq 'gene' ) {\n\t@genes = ($feat);\n    }\n    else {\n\t# we are in a gene container; gene must then be one level down\n\t@genes = grep { $_->primary_tag eq 'gene' } $feat->get_SeqFeatures;\n    }\n\n    for my $g ( @genes ) {\n\tmy $id ||= $self->_find_name($g, 'standard_name')\n               || $self->_find_name($g, 'gene') \n\t       || $self->_find_name($feat, 'locus_tag')\n               || $self->_find_name($feat, 'symbol')\n               || $self->throw(\"Could not find a gene ID\");\n\tmy $gid ||= $self->_find_name($g, 'gene') || $self->_find_name($g);\n\n\t$writer->startTag('gene', association => 'IS');\n        $self->_element('name', $gid);\n        $writer->endTag('gene');\n\n        my $proteins;\n\tmy @mRNAs = grep { $_->primary_tag =~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @other_stuff = grep { $_->primary_tag !~ /mRNA|transcript/ } $g->get_SeqFeatures;\n\tmy @variants = ('A' .. 'Z');\n\n\tfor my $mRNA (@mRNAs) {\n\t    my ($sn, @units);\n            # if the mRNA is a generic transcript, it must be a non-spliced RNA gene\n            # Make a synthetic exon to help build a hierarchy.  We have to assume that\n            # the location is not segmented (otherwise it should be a mRNA)\n\t    if ( $mRNA->primary_tag eq 'transcript') {\n\t\tmy $exon = Bio::SeqFeature::Generic->new ( -primary => 'exon' );\n\t\t$exon->location($mRNA->location);\n\t\t$mRNA->add_SeqFeature($exon);\n\t    }\n\n            # no subfeats? Huh? revert to generic feature\n\t    unless ( $mRNA->get_SeqFeatures ) {\n\t\t$self->_write_feature($mRNA, 1); # 1 flag writes the bare feature\n                                                 # with no annotation wrapper\n\t\tnext;\n\t    }\n\n\t    my $name = $self->_find_name($mRNA, $mRNA->primary_tag) \n                     || $self->_find_name($mRNA, 'standard_name');\n\n\t    my %attributes;\n            my ($cds) = grep { $_->primary_tag eq 'CDS' } $mRNA->get_SeqFeatures;\n\n\t    # make sure we have the right CDS for alternatively spliced genes\n\t    # This is meant to deal with sequences from flattened game annotations, \n\t    # where both the mRNA and CDS have split locations\n\t    if ( $cds && @mRNAs > 1 && $name ) {\n\t\t$cds = $self->_check_cds($cds, $name);\n\t    }\n\t    elsif ( $cds && @mRNAs == 1 ) {\n\t\t# The mRNA/CDS pairing must be right. Get the transcript name from the CDS\n\t\tif ( $cds->has_tag('standard_name') ) {\n\t\t    ($name) = $cds->get_tag_values('standard_name');\n                }\n\t    }\n\t    \n\t    if ( !$name ) {\n\t\t# assign a name to the transcript if it has no 'standard_name' binder\n\t\t$name = $id . '-R' . (shift @variants);\n\t    }\n\n            my $pname;\n\n\t    if ( $cds ) {\n\t\t($sn) = $cds->get_tag_values('standard_name')\n\t\t    if $cds->has_tag('standard_name');\n\t\t($sn) ||= $cds->get_tag_values('mRNA')\n\t\t   if $cds->has_tag('mRNA');\n\n\t\t# the protein needs a name\n\t\tmy $psn = $self->protein_id($cds, $sn);\n                $self->{curr_pname} = $psn;\n\n\t\t# the mRNA need to know the name of its protein\n\t\tunless ( $feat->has_tag('protein_id') ) {\n\t\t    $feat->add_tag_value('protein_id', $psn);\n\t\t}\n\n                # define the translation offset\n\t\tmy ($c_start, $c_end);\n\t\tif ( $cds->has_tag('codon_start') ){\n\t\t    ($c_start) = $cds->get_tag_values('codon_start');\n\t\t    $cds->remove_tag('codon_start');\n\t\t}\n\t\telse {\n\t\t    $c_start = 1;\n\t\t}\n\t\tmy $cs  = Bio::SeqFeature::Generic->new;\n\t\tif ( $c_start == 1 ) {\n\t\t    $c_start = $cds->strand > 0 ? $cds->start : $cds->end;\n\t\t}\n\t\tif ( $cds->strand < 1 ) {\n\t\t    $c_end = $c_start;\n\t\t    $c_start = $c_start - 2;\n\t\t}\n\t\telse {\n\t\t    $c_end = $c_start + 2;\n\t\t}\n\t\t$cs->start($c_start);\n\t\t$cs->end($c_end);\n\t\t$cs->strand($cds->strand);\n\t\t$cs->primary_tag('start_codon');\n\t\t$cs->add_tag_value( 'standard_name' => $name );\n\t\tpush @units, $cs;\n\n\n\t\tif ( $cds->has_tag('problem') ) {\n\t\t    my ($val) = $cds->get_tag_values('problem');\n\t\t    $cds->remove_tag('problem');\n\t\t    $attributes{problem} = $val;\n\t\t}\n\t\t\n\t\tmy ($aa) = $cds->get_tag_values('translation')\n\t\t    if $cds->has_tag('translation');\n\t\t\n\t\tif ( $aa && $psn ) {\n\t\t    $cds->remove_tag('translation');\n\t\t    my %add_seq = ();\n\t\t    $add_seq{residues} = $aa;\n\t\t    $add_seq{header} = ['seq',\n\t\t\t\t\tid     => $psn,\n\t\t\t\t\tlength => length $aa,\n\t\t\t\t\ttype   => 'aa' ];\n\t\t    \n\t\t    if ( $cds->has_tag('product_desc') ) {\n\t\t\t($add_seq{desc}) = $cds->get_tag_values('product_desc');\n\t\t\t$cds->remove_tag('product_desc');\n\t\t    }\n\t\t    \n\t\t    unless ( $add_seq{desc} && $add_seq{desc} =~ /cds_boundaries/ ) {\n\t\t\tmy $start = $cds->start;\n\t\t\tmy $end   = $cds->end;\n\t\t\tmy $str   = $cds->strand;\n\t\t\tmy $acc   = $self->{seq}->accession || $self->{seq}->display_id;\n\t\t\t$str = $str < 0 ? '[-]' : '';\n\t\t\t$add_seq{desc}  = \"translation from_gene[$gid] \" .\n\t\t\t    \"cds_boundaries:(\" . $acc . \n\t\t\t    \":$start..$end$str) transcript_info:[$name]\";\n\t\t    }\n\t\t    $self->{add_seqs} ||= [];\n\t\t    push @{$self->{add_seqs}}, \\%add_seq;\n\t\t}\n\t    }\n\n\t    \n\t    $writer->startTag('feature_set', id => $name);\n\t    $self->_element('name', $name);\n\t    $self->_element('type', 'transcript');\n\t    $self->_render_tags($_,\n\t\t\t\t\\&_render_date_tags,\n\t\t\t\t\\&_render_comment_tags,\n\t\t\t\t\\&_render_tags_as_properties,\n\t\t\t       ) for ( $mRNA, ($cds) || () );\n\t     \n\t    # any UTR's, etc associated with this transcript?\n\t    for my $thing ( @other_stuff ) {\n\t\tif ( $thing->has_tag('standard_name') ) {\n\t\t    my ($v)  = $thing->get_tag_values('standard_name');\n\t\t    if ( $v eq $sn ) {\n\t\t\tpush @units, $thing;\n\t\t    }\n\t\t}\n\t    }\n\t    \n\t    # add the exons\n\t    push @units, grep { $_->primary_tag eq 'exon' } $mRNA->get_SeqFeatures;\n\t    @units = sort { $a->start <=> $b->start } @units;\n\n\t    my $count  = 0;\n\t    \n\t    if ( $str < 0 ) {\n\t\t@units = reverse @units;\n\t    }\n            \n\t    for my $unit ( @units ) {\n\t\tif ( $unit->primary_tag eq 'exon' ) {\n\t\t    my $ename = $id;\n\t\t    $ename .= ':' . ++$count;\n\t\t    $self->_feature_span($ename, $unit);\n\t\t}\n\t\telsif ( $unit->primary_tag eq 'start_codon' ) {\n\t\t    $self->_feature_span(($sn || $gid), $unit, $self->{curr_pname});\n\t\t}\n\t\telse {\n\t\t    my $uname = $unit->primary_tag . \":$id\";\n\t\t    $self->_feature_span($uname, $unit);\n\t\t}\n\t    }\n\t    $self->{curr_pname} = '';\n\t    $writer->endTag('feature_set');\n\t}\n\t\n\t$self->{other_stuff} = \\@other_stuff;\n    }    \n    \n    $writer->endTag('annotation');\n\n    # add the protein sequences\n    for ( @{$self->{add_seqs}} ) {\n\tmy %h = %$_;\n\t$writer->startTag(@{$h{header}});\n\tmy @desc = split /\\s+/, $h{desc};\n\tmy $desc = '';\n\tfor my $word (@desc) {\n\t    my ($lastline) = $desc =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $desc .= length $lastline < 50 ? \" $word \" : \"\\n      $word \";\n\t}\n        $self->_element('description', \"\\n     $desc\\n    \");\n\n\tmy $aa = $h{residues};\n\t$aa =~ s/(\\w{60})/$1\\n      /g;\n\t$aa =~ s/\\n\\s+$//m;\n\t$aa = \"\\n      \" . $aa . \"\\n    \";\n\t$self->_element('residues', $aa);\n\t$writer->endTag('seq');\n\t$self->{add_seqs} = [];\n    }\n    \n    # Is there anything else associated with the gene?  We have to write other\n    # features as stand-alone annotations or apollo will assume they are\n    # transcripts\n    for my $thing ( @{$self->{other_stuff}} ) {\n\tnext if $thing->has_tag('standard_name');\n\t$self->_write_feature($thing);\n    }\n    $self->{other_stuff} = [];\n}\n\n\n=head2 _check_cds\n\n Title   : _check_cds\n Usage   : $self->_check_cds($cds, $name)\n Function: internal method to check if the CDS associated with an mRNA is\n           the correct alternative splice variant\n Returns : a Bio::SeqFeature::Generic CDS object\n Args    : the CDS object plus the transcript\\'s 'standard_name'\n Note    : this method only works if alternatively spliced transcripts are bound\n           together by a 'standard_name' or 'mRNA' qualifier.  If none is present, \n           we will hope that the exons were derived from a segmented RNA or a CDS \n           with no associated mRNA feature.  Neither of these two cases would be \n           confounded by alternative splice variants.\n\n\n\nsub _check_cds {\n    my ($self, $cds, $name) = @_;\n    my $cname = $self->_find_name( $cds, 'standard_name' )\n             || $self->_find_name( $cds, 'mRNA');\n    \n    if ( $cname ) {\n\tif ( $cname eq $name ) {\n\t    return $cds;\n\t}\n\telse {\n\t    my @CDS = grep { $_->primary_tag eq 'CDS' } @{$self->{feats}};\n\t    for ( @CDS ) {\n\t\tmy ($sname) = $_->_find_name( $_, 'standard_name' )\n\t\t           || $_->_find_name( $_, $_->primary_tag );\n\t\treturn $_ if $sname eq $name;\n\t    }\n\t    return '';\n\t}\n    }\n    else {\n\treturn $cds;\n    }\n\n}\n\n=head2 _comp_analysis\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _comp_analysis {\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('computational_analysis');\n  $self->_element('program', $feat->program_name || 'unknown program');\n  $self->_element('database', $feat->database_name) if $feat->database_name;\n  $self->_element('version', $feat->program_version) if $feat->program_version;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  $self->_render_tags($feat,\n\t\t      \\&_render_date_tags,\n\t\t      \\&_render_tags_as_properties,\n\t\t     );\n  $self->_comp_result($feat);\n  $writer->endTag('computational_analysis');\n}\n\n=head2 _comp_result\n\n  Usage:\n  Desc : recursively render a feature and its subfeatures as\n         <result_set> and <result_span> elements\n  Ret  : nothing meaningful\n  Args : a feature\n\n\n\nsub _comp_result {\n  my ($self,$feat) = @_;\n\n  #check that all our subfeatures have the same strand\n  \n\n  #write result sets for things that have subfeatures, or things\n  #that have some tags\n  if( my @subfeats = $feat->get_SeqFeatures or $feat->get_all_tags ) {\n    my $writer = $self->{writer};\n    $writer->startTag('result_set',\n\t\t      ($feat->can('computation_id') && defined($feat->computation_id))\n\t\t        ? (id => $feat->computation_id) : ()\n\t\t     );\n    my $fakename = $feat->primary_tag || 'no_name';\n    $self->_element('name', $feat->display_name || ($fakename).'_'.++$self->{anon_result_set_counters}{$fakename} );\n    $self->_seq_relationship('query', $feat);\n    $self->_render_tags($feat,\n\t\t\t\\&_render_output_tags\n\t\t       );\n    for (@subfeats) { #render the subfeats, if any\n      $self->_comp_result($_);\n    }\n    $self->_comp_result_span($feat); #also have a span to hold this info\n    $writer->endTag('result_set');\n  } else {\n    #just write result spans for simple things\n    $self->_comp_result_span($feat);\n  }\n}\n\n=head2 _comp_result_span\n\n  Usage: _comp_result_span('foo12',$feature);\n  Desc : write GAME XML for a Bio::SeqFeature::Computation feature\n         that has no subfeatures\n  Ret  : nothing meaningful\n  Args : name for this span (some kind of identifier),\n         SeqFeature object to put into this span\n  Side Effects:\n  Example:\n\n\nsub _comp_result_span {\n\n  my ($self, $feat) = @_;\n  my $writer = $self->{writer};\n\n  $writer->startTag('result_span',\n\t\t    ($feat->can('computation_id') && defined($feat->computation_id) ? (id => $feat->computation_id) : ())\n\t\t   );\n  $self->_element('name', $feat->display_name) if $feat->display_name;\n  $self->_element('type', $feat->primary_tag) if $feat->primary_tag;\n  my $has_score = $feat->can('has_score') ? $feat->has_score : defined($feat->score);\n  $self->_element('score', $feat->score) if $has_score;\n  $self->_render_tags($feat,\n\t\t      \\&_render_output_tags\n\t\t     );\n  $self->_seq_relationship('query', $feat);\n  $self->_render_tags($feat,\n\t\t      \\&_render_target_tags,\n\t\t     );\n  $writer->endTag('result_span');\n}\n\n=head2 _render_tags\n\n  Usage:\n  Desc :\n  Ret  :\n  Args :\n  Side Effects:\n  Example:\n\n\nsub _render_tags {\n  my ($self,$feat,@render_funcs) = @_;\n\n  my @tagnames = $feat->get_all_tags;\n\n  #do a chain-of-responsibility down the allowed\n  #tag handlers types for the context in which this is\n  #called\n  foreach my $func (@render_funcs) {\n    @tagnames = $self->$func($feat,@tagnames);\n  }\n}\n\n=head2 _render_output_tags\n\n  Usage:\n  Desc : print out <output> elements, with contents\n         taken from the SeqFeature::Computation's 'output' tag\n  Ret  : array of tag names this did not render\n  Args : feature object, list of tag names to maybe render\n\n  In game xml, only <result_span> and <result_set> elements can\n  have <output> elements.\n\n\nsub _render_output_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n\n  for my $tag (@tagnames) {\n    if(lc($tag) eq 'output') {\n      my @outputs = $feat->get_tag_values($tag);\n      while(my($type,$val) = splice @outputs,0,2) {\n\t$writer->startTag('output');\n\t$self->_element('type',$type);\n\t$self->_element('value',$val);\n\t$writer->endTag('output');\n      }\n    }\n    else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_tags_as_properties\n\n  Usage:\n  Desc :\n  Ret  : empty array\n  Args : feature object, array of tag names\n  Side Effects:\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  and <feature_set> elements can have properties.\n\n\nsub _render_tags_as_properties {\n  my ($self,$feat,@tagnames) = @_;\n\n  foreach my $tag (@tagnames) {\n    if( $tag ne $feat->primary_tag ) {\n      $self->_property($tag,$_) for $feat->get_tag_values($tag);\n    }\n  }\n  return ();\n}\n\n=head2 _render_comment_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not comment tags\n  Args : feature object, tag names available for us to render\n  Side Effects: writes XML\n  Example:\n\n  In game xml, <annotation> and <feature_set> elements can\n  have comments.\n\n\nsub _render_comment_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my $writer = $self->{writer};\n  my @passed_up;\n  for my $tag ( @tagnames ) {\n    if( lc($tag) eq 'comment' ) {\n      for my $val ($feat->get_tag_values($tag)) {\n\tif ( $val =~ /=.+?;.+=/ ) {\n\t  $self->_unflatten_attribute('comment', $val);\n\t} else {\n\t  $writer->startTag('comment');\n\t  $self->_element('text', $val);\n\t  $writer->endTag('comment');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n=head2 _render_date_tags\n\n  Usage:\n  Desc :\n  Ret  : names of tags that were not date tags\n  Args : feature, list of tag names available for us to render\n  Side Effects: writes XML for <date> elements\n  Example:\n\n  In game xml, <annotation>, <computational_analysis>,\n  <transaction>, <comment>, and <feature_set> elements\n  can have <date>s.\n\n\nsub _render_date_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  my $date;\n  my %timestamp;\n  foreach my $tag (@tagnames) {\n    if ( lc($tag) eq 'date' ) {\n      ($date) = $feat->get_tag_values($tag);\n    } elsif ( lc($tag) eq 'timestamp' ) {\n      ($timestamp{'timestamp'}) = $feat->get_tag_values($tag);\n      #ignore timestamps, they are folded in with date elem above\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  $self->_element('date', $date, \\%timestamp) if defined($date);\n  return @passed_up;\n}\n\n=head2 _render_dbxref_tags\n\n  Desc : look for xref tags and render them if they are there\n  Ret  : tag names that we didn't render\n  Args : feature object, list of tag names to render\n  Side Effects: writes a <dbxref> element if a tag with name\n                matching /xref$/i is present\n\n\n  In game xml, <annotation> and <seq> elements can have dbxrefs.\n\n\n#TODO: can't sequences also have database xrefs?  how to find those?\nsub _render_dbxref_tags {\n  my ($self, $feat, @tagnames) = @_;\n  my @passed_up;\n  for my $tag ( @tagnames ) {                           #look through all the tags\n    if( $tag =~ /xref$/i ) {                            #if they are xref tags\n      my $writer = $self->{writer};\n      for my $val ( $feat->get_all_tag_values($tag) ) { #get all their values\n\tif( my ($db,$dbid) = $val =~ /(\\S+):(\\S+)/ ) {  #and render them as xrefs\n\t  $writer->startTag('dbxref');\n\t  $self->_element('xref_db', $db);\n\t  $dbid = $val if $db =~ /^[A-Z]O$/; # -> ontology, like GO\n\t  $self->_element('db_xref_id', $dbid);\n\t  $writer->endTag('dbxref');\n\t}\n      }\n    } else {\n      push @passed_up,$tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _render_target_tags\n\n  Usage:\n  Desc : process any 'Target' tags that would indicate a sequence alignment subject\n  Ret  : array of tag names that we didn't render\n  Args : feature object\n  Side Effects: writes a <seq_relationship> of type 'subject' if it finds\n                any properly formed tags named 'Target'\n  Example:\n\n  In game xml, <result_span>, <feature_span>, and <result_set> can have\n  <seq_relationship>s.  <result_set> can only have one, a 'query' relation.\n\n\nsub _render_target_tags {\n  my ($self,$feat,@tagnames) = @_;\n  my @passed_up;\n  foreach my $tag (@tagnames) {\n    if($tag eq 'Target' && (my @alignment = $feat->get_tag_values('Target')) >= 3) {\n      $self->_seq_relationship('subject',\n\t\t\t       Bio::Location::Simple->new( -start => $alignment[1],\n\t\t\t\t\t\t\t   -end   => $alignment[2],\n\t\t\t\t\t\t\t ),\n\t\t\t       $alignment[0],\n\t\t\t       $alignment[3],\n\t\t\t      );\n    } else {\n      push @passed_up, $tag;\n    }\n  }\n  return @passed_up;\n}\n\n\n=head2 _property\n\n Title   : _property\n Usage   : $self->_property($tag => $value); \n Function: an internal method to write property XML elements\n Returns : nothing\n Args    : a tag/value pair\n\n\nsub _property {\n    my ($self, $tag, $val) = @_;\n    my $writer = $self->{writer};\n\n    if ( length $val > 45 ) {\n\tmy @val = split /\\s+/, $val;\n\t$val = '';\n\t\n\tfor my $word (@val) {\n\t    my ($lastline) = $val =~ /.*^(.+)$/sm;\n\t    $lastline ||= '';\n\t    $val .= length $lastline < 45 ? \" $word \" : \"\\n          $word\";\n\t}\n\t$val = \"\\n         $val\\n        \";\n\t$val =~ s/(\\S)\\s{2}(\\S)/$1 $2/g;\n    }\n    $writer->startTag('property');\n    $self->_element('type', $tag);\n    $self->_element('value', $val);\n    $writer->endTag('property');\n}\n\n=head2 _unflatten_attribute\n\n Title   : _unflatten_attribute\n Usage   : $self->_unflatten_attribute($name, $value)\n Function: an internal method to unflatten and write comment or evidence elements\n Returns : nothing\n Args    : a list of strings\n\n\nsub _unflatten_attribute {\n    my ($self, $name, $val) = @_;\n    my $writer = $self->{writer};\n    my %pair;\n    my @pairs = split ';', $val;\n    for my $p ( @pairs ) {\n\tmy @pair = split '=', $p;\n\t$pair[0] =~ s/^\\s+|\\s+$//g;\n\t$pair[1] =~ s/^\\s+|\\s+$//g;\n\t$pair{$pair[0]} = $pair[1];\n    }\n    $writer->startTag($name);\n    for ( keys %pair ) {\n\t$self->_element($_, $pair{$_});\n    }\n    $writer->endTag($name);\n    \n\n}\n\n=head2 _xref\n\n Title   : _xref\n Usage   : $self->_xref($value) \n Function: an internal method to write db_xref elements\n Returns : nothing \n Args    : a list of strings\n\n\nsub _xref {\n    my ($self, @xrefs) = @_;\n    my $writer = $self->{writer};\n    for my $xref ( @xrefs ) {\n\tmy ($db, $acc) = $xref =~ /(\\S+):(\\S+)/;\n\t$writer->startTag('dbxref');\n\t$self->_element('xref_db', $db);\n\t$acc = $xref if $db eq 'GO';\n\t$self->_element('db_xref_id', $acc);\n\t$writer->endTag('dbxref');\n    }\n}\n\n=head2 _feature_span\n\n Title   : _feature_span\n Usage   : $self->_feature_span($name, $type, $loc)\n Function: an internal method to write a feature_span element\n          (the actual feature with coordinates)\n Returns : nothing \n Args    : a feature name and Bio::SeqFeatureI-compliant object\n\n\nsub _feature_span {\n    my ($self, $name, $feat, $pname) = @_;\n    my $type = $feat->primary_tag;\n    my $writer = $self->{writer};\n    my %atts = ( id => $name );\n    \n    if ( $pname ) {\n\t$pname =~ s/-R/-P/;\n\t$atts{produces_seq} = $pname;\n    }\n\n    $writer->startTag('feature_span', %atts );\n    $self->_element('name', $name);\n    $self->_element('type', $type);\n    $self->_seq_relationship('query', $feat);\n    $writer->endTag('feature_span');\n}\n\n=head2 _seq_relationship\n\n Title   : _seq_relationship\n Usage   : $self->_seq_relationship($type, $loc)\n Function: an internal method to handle feature_span sequence relationships\n Returns : nothing\n Args    : feature type, a Bio::LocationI-compliant object,\n           (optional) sequence name (defaults to the query seq)\n           and (optional) alignment string\n\n\nsub _seq_relationship {\n    my ($self, $type, $loc, $seqname, $alignment) = @_;\n    my $writer = $self->{'writer'};\n\n    $seqname ||= #if no seqname passed in, use the name of our annotating seq\n      $self->{seq}->accession_number ne 'unknown' && $self->{seq}->accession_number\n\t|| $self->{seq}->display_id || 'unknown';\n    $writer->startTag(\n\t\t      'seq_relationship',\n\t\t      type => $type,\n\t\t      seq  => $seqname,\n\t\t     );\n    $self->_span($loc);\n    $writer->_element('alignment',$alignment) if $alignment;\n    $writer->endTag('seq_relationship');\n}\n\n=head2 _element\n\n Title   : _element\n Usage   : $self->_element($name, $chars, $atts)\n Function: an internal method to generate 'generic' XML elements\n Example : \n my $name = 'foo';\n my $content = 'bar';\n my $attributes = { baz => 1 }; \n # print the element\n $self->_element($name, $content, $attributes);\n Returns : nothing \n Args    : the element name and content plus a ref to an attribute hash\n\n\nsub _element {\n    my ($self, $name, $chars, $atts) = @_;\n    my $writer = $self->{writer};\n    my %atts = $atts ? %$atts : ();\n    \n    $writer->startTag($name, %atts);\n    $writer->characters($chars);\n    $writer->endTag($name);\n}\n\n=head2 _span\n\n Title   : _span\n Usage   : $self->_span($loc)\n Function: an internal method to write the 'span' element\n Returns : nothing\n Args    : a Bio::LocationI-compliant object\n\n\nsub _span {\n    my ($self, @loc) = @_;\n    my ($loc, $start, $end);\n\n    if ( @loc == 1 ) {\n\t$loc = $loc[0];\n    }\n    elsif ( @loc == 2 ) {\n\t($start, $end) = @loc;\n    }\n\n    if ( $loc ) {\n\t($start, $end) = ($loc->start, $loc->end);\n\t($start, $end) = ($end, $start) if $loc->strand < 0;\n    } \n    elsif ( !$start ) {\n\t($start, $end) = (1, $self->{seq}->length);\n    }\n    \n    my $writer = $self->{writer};\n    $writer->startTag('span');\n    $self->_element('start', $start);\n    $self->_element('end', $end);\n    $writer->endTag('span');\n}\n\n=head2 _seq\n\n Title   : _seq\n Usage   : $self->_seq($seq, $dna) \n Function: an internal method to print the 'sequence' element\n Returns : nothing\n Args    : and Bio::SeqI-compliant object and a reference to an attribute  hash\n\n\nsub _seq {\n    my ($self, $seq, $atts) = @_;\n\n    my $writer = $self->{'writer'};\n\n   \n    # game moltypes\n    my $alphabet = $seq->alphabet;\n    $alphabet ||= $seq->mol_type if $seq->can('mol_type');\n    $alphabet =~ s/protein/aa/;\n    $alphabet =~ s/rna/cdna/;\n    \n    my @seq = ( 'seq',\n\t\tid     => $atts->{name},\n\t\tlength => $seq->length,\n\t\ttype   => $alphabet,\n\t       \tfocus  => \"true\"\t       \n\t      );\n\n    if ( $atts->{md5checksum} ) {\n\tpush @seq, (md5checksum => $atts->{md5checksum});\n\tdelete $atts->{md5checksum};\n    }\n    $writer->startTag(@seq);\n\n    for my $k ( keys %{$atts} ) {\n\tif ( $k =~ /xref/ ) {\n\t    $self->_xref($atts->{$k});\n\t}\n\telse {\n\t    $self->_element($k, $atts->{$k});\n\t}    \n    }\n    \n    # add leading spaces and line breaks for \n    # nicer xml formatting/indentation\n    my $sp  = (' ' x 6);\n    my $dna = $seq->seq;\n    $dna =~ s/(\\w{60})/$1\\n$sp/g;\n    $dna = \"\\n$sp\" . $dna . \"\\n    \";\n    \n    if ( $seq->species && !$self->{has_organism}) {\n        my $species = $seq->species->binomial;\n\t$self->_element('organism', $species);\n    }\n    \n    $self->_element('residues', $dna);\n    $writer->endTag('seq');\n}\n\n=head2 _find_name\n\n Title   : _find_name\n Usage   : my $name = $self->_find_name($feature)\n Function: an internal method to look for a gene name\n Returns : a string \n Args    : a Bio::SeqFeatureI-compliant object","parameters":[{"label":"$self"},{"label":"$feat"},{"label":"$key"}],"label":"_find_name($self,$feat,$key)"},"line":1270,"kind":12,"range":{"end":{"line":1282,"character":9999},"start":{"line":1270,"character":0}},"definition":"sub","detail":"($self,$feat,$key)","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"_find_name","line":1271,"definition":"my"},{"line":1271,"name":"$feat","kind":13,"containerName":"_find_name"},{"name":"$key","containerName":"_find_name","kind":13,"line":1271},{"kind":13,"localvar":"my","containerName":"_find_name","name":"$name","line":1272,"definition":"my"},{"name":"$key","kind":13,"containerName":"_find_name","line":1274},{"kind":13,"containerName":"_find_name","name":"$feat","line":1274},{"line":1274,"name":"has_tag","containerName":"_find_name","kind":12},{"kind":13,"containerName":"_find_name","name":"$key","line":1274},{"name":"$name","kind":13,"containerName":"_find_name","line":1275},{"line":1275,"kind":13,"containerName":"_find_name","name":"$feat"},{"line":1275,"name":"get_tag_values","kind":12,"containerName":"_find_name"},{"line":1275,"kind":13,"containerName":"_find_name","name":"$key"},{"line":1276,"name":"$name","kind":13,"containerName":"_find_name"}],"containerName":"main::","name":"_find_name"}]}