{"version":5,"vars":[{"line":70,"containerName":"","kind":2,"name":"vars"},{"line":76,"kind":13,"containerName":null,"name":"@ISA"},{"kind":2,"containerName":"strict::Bio::SeqIO::Bio::Seq","name":"SeqFactory","line":76},{"children":[{"name":"$READ_AVAIL","containerName":"BEGIN","kind":13,"line":81},{"line":83,"kind":13,"containerName":"BEGIN","name":"@ISA"},{"containerName":"BEGIN","kind":13,"name":"$READ_AVAIL","line":84}],"containerName":"main::","name":"BEGIN","definition":"sub","line":78,"range":{"start":{"character":0,"line":78},"end":{"line":86,"character":9999}},"kind":12},{"containerName":"SeqIO::staden::read","kind":12,"name":"Bio","line":80},{"signature":{"label":"_initialize($self,@args)","documentation":"","parameters":[{"label":"$self"},{"label":"@args"}]},"kind":12,"range":{"end":{"character":9999,"line":99},"start":{"line":88,"character":0}},"line":88,"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"_initialize","children":[{"definition":"my","containerName":"_initialize","localvar":"my","kind":13,"name":"$self","line":89},{"line":89,"kind":13,"containerName":"_initialize","name":"@args"},{"line":90,"kind":13,"containerName":"_initialize","name":"$self"},{"name":"@args","kind":13,"containerName":"_initialize","line":90},{"line":91,"containerName":"_initialize","kind":13,"name":"$self"},{"line":91,"containerName":"_initialize","kind":12,"name":"sequence_factory"},{"line":92,"containerName":"_initialize","kind":13,"name":"$self"},{"containerName":"_initialize","kind":12,"name":"sequence_factory","line":92},{"line":92,"containerName":"_initialize","kind":12,"name":"new"},{"kind":13,"containerName":"_initialize","name":"$self","line":92},{"containerName":"_initialize","kind":12,"name":"verbose","line":92},{"line":94,"name":"$READ_AVAIL","containerName":"_initialize","kind":13},{"containerName":"_initialize","kind":12,"name":"throw","line":95}]},{"line":90,"kind":12,"containerName":"_initialize","name":"SUPER"},{"line":92,"name":"Bio","kind":12,"containerName":"Seq::SeqFactory"},{"line":95,"name":"Bio","containerName":"Root::Root","kind":12},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: exp.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::SeqIO::exp\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey <amackey@virginia.edu>\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::exp - exp trace sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from exp trace\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Aaron Mackey\n\nEmail: amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::exp;\nuse vars qw(@ISA $READ_AVAIL);\nuse strict;\n\nuse Bio::SeqIO;\nuse Bio::Seq::SeqFactory;\n\npush @ISA, qw( Bio::SeqIO );\n\nsub BEGIN {\n    eval { require Bio::SeqIO::staden::read; };\n    if ($@) {\n\t$READ_AVAIL = 0;\n    } else {\n\tpush @ISA, \"Bio::SeqIO::staden::read\";\n\t$READ_AVAIL = 1;\n    }\n}\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);  \n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new(-verbose => $self->verbose(), -type => 'Bio::Seq::Quality'));\n  }\n  unless ($READ_AVAIL) {\n      Bio::Root::Root->throw( -class => 'Bio::Root::SystemException',\n\t\t\t      -text  => \"Bio::SeqIO::staden::read is not available; make sure the bioperl-ext package has been installed successfully!\"\n\t\t\t    );\n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq::Quality object\n Args    : NONE","label":"next_seq($self)"},"range":{"start":{"character":0,"line":111},"end":{"character":9999,"line":126}},"kind":12,"line":111,"detail":"($self)","definition":"sub","containerName":"main::","name":"next_seq","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"next_seq","name":"$self","line":113},{"definition":"my","kind":13,"localvar":"my","containerName":"next_seq","name":"$seq","line":115},{"name":"$id","kind":13,"containerName":"next_seq","line":115},{"line":115,"name":"$desc","kind":13,"containerName":"next_seq"},{"line":115,"containerName":"next_seq","kind":13,"name":"$qual"},{"name":"$self","kind":13,"containerName":"next_seq","line":115},{"name":"read_trace","kind":12,"containerName":"next_seq","line":115},{"line":115,"name":"$self","containerName":"next_seq","kind":13},{"line":115,"containerName":"next_seq","kind":12,"name":"_fh"},{"line":118,"kind":13,"containerName":"next_seq","name":"$seq"},{"line":118,"name":"$self","containerName":"next_seq","kind":13},{"line":118,"name":"sequence_factory","kind":12,"containerName":"next_seq"},{"containerName":"next_seq","kind":12,"name":"create","line":118},{"line":118,"name":"$seq","kind":13,"containerName":"next_seq"},{"kind":13,"containerName":"next_seq","name":"$id","line":119},{"containerName":"next_seq","kind":13,"name":"$id","line":120},{"containerName":"next_seq","kind":13,"name":"$desc","line":121},{"kind":13,"containerName":"next_seq","name":"$qual","line":124},{"kind":13,"containerName":"next_seq","name":"$seq","line":125}]},{"range":{"end":{"character":9999,"line":149},"start":{"character":0,"line":139}},"kind":12,"line":139,"signature":{"label":"write_seq($self,@seq)","parameters":[{"label":"$self"},{"label":"@seq"}],"documentation":"1;\n# $Id: exp.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::SeqIO::exp\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey <amackey@virginia.edu>\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::exp - exp trace sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from exp trace\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Aaron Mackey\n\nEmail: amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::exp;\nuse vars qw(@ISA $READ_AVAIL);\nuse strict;\n\nuse Bio::SeqIO;\nuse Bio::Seq::SeqFactory;\n\npush @ISA, qw( Bio::SeqIO );\n\nsub BEGIN {\n    eval { require Bio::SeqIO::staden::read; };\n    if ($@) {\n\t$READ_AVAIL = 0;\n    } else {\n\tpush @ISA, \"Bio::SeqIO::staden::read\";\n\t$READ_AVAIL = 1;\n    }\n}\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);  \n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new(-verbose => $self->verbose(), -type => 'Bio::Seq::Quality'));\n  }\n  unless ($READ_AVAIL) {\n      Bio::Root::Root->throw( -class => 'Bio::Root::SystemException',\n\t\t\t      -text  => \"Bio::SeqIO::staden::read is not available; make sure the bioperl-ext package has been installed successfully!\"\n\t\t\t    );\n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq::Quality object\n Args    : NONE\n\n\nsub next_seq {\n\n    my ($self) = @_;\n\n    my ($seq, $id, $desc, $qual) = $self->read_trace($self->_fh, 'exp');\n\n    # create the seq object\n    $seq = $self->sequence_factory->create(-seq        => $seq,\n\t\t\t\t\t   -id         => $id,\n\t\t\t\t\t   -primary_id => $id,\n\t\t\t\t\t   -desc       => $desc,\n\t\t\t\t\t   -alphabet   => 'DNA',\n\t\t\t\t\t   -qual       => $qual\n\t\t\t\t\t   );\n    return $seq;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq(@seq)\n Function: writes the $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Seq object"},"name":"write_seq","containerName":"main::","children":[{"containerName":"write_seq","localvar":"my","kind":13,"name":"$self","line":140,"definition":"my"},{"line":140,"containerName":"write_seq","kind":13,"name":"@seq"},{"definition":"my","name":"$fh","localvar":"my","kind":13,"containerName":"write_seq","line":142},{"line":142,"containerName":"write_seq","kind":13,"name":"$self"},{"line":142,"name":"_fh","kind":12,"containerName":"write_seq"},{"definition":"my","name":"$seq","localvar":"my","containerName":"write_seq","kind":13,"line":143},{"line":143,"name":"@seq","containerName":"write_seq","kind":13},{"line":144,"name":"$self","containerName":"write_seq","kind":13},{"line":144,"name":"write_trace","containerName":"write_seq","kind":12},{"line":144,"containerName":"write_seq","kind":13,"name":"$fh"},{"name":"$seq","containerName":"write_seq","kind":13,"line":144},{"line":147,"name":"$self","kind":13,"containerName":"write_seq"},{"line":147,"kind":12,"containerName":"write_seq","name":"flush"},{"line":147,"name":"$self","kind":13,"containerName":"write_seq"},{"line":147,"kind":12,"containerName":"write_seq","name":"_flush_on_write"},{"line":147,"name":"$self","kind":13,"containerName":"write_seq"},{"name":"_fh","containerName":"write_seq","kind":12,"line":147}],"detail":"($self,@seq)","definition":"sub"}]}