{"vars":[{"containerName":"","kind":2,"name":"base","line":86},{"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","localvar":"my","containerName":"_initialize","kind":13,"name":"$self","line":89},{"line":89,"kind":13,"containerName":"_initialize","name":"@args"},{"line":90,"name":"$self","containerName":"_initialize","kind":13},{"containerName":"_initialize","kind":13,"name":"@args","line":90},{"line":91,"name":"$self","kind":13,"containerName":"_initialize"},{"containerName":"_initialize","kind":12,"name":"sequence_factory","line":91},{"containerName":"_initialize","kind":13,"name":"$self","line":92},{"line":92,"name":"sequence_factory","kind":12,"containerName":"_initialize"},{"line":92,"name":"new","containerName":"_initialize","kind":12},{"name":"$self","kind":13,"containerName":"_initialize","line":92},{"name":"verbose","kind":12,"containerName":"_initialize","line":92}],"containerName":"main::","name":"_initialize","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_initialize($self,@args)"},"line":88,"range":{"start":{"character":0,"line":88},"end":{"line":94,"character":9999}},"kind":12},{"line":90,"kind":12,"containerName":"_initialize","name":"SUPER"},{"line":92,"containerName":"Seq::SeqFactory","kind":12,"name":"Bio"},{"line":107,"name":"%bio_mol_type","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"definition":"sub","detail":"($self)","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"next_seq","name":"$self","line":113},{"name":"$fh","localvar":"my","kind":13,"containerName":"next_seq","line":116,"definition":"my"},{"line":116,"name":"$self","containerName":"next_seq","kind":13},{"name":"_filehandle","kind":12,"containerName":"next_seq","line":116},{"line":117,"name":"$type","localvar":"my","kind":13,"containerName":"next_seq","definition":"my"},{"name":"$id","containerName":"next_seq","kind":13,"line":117},{"kind":13,"containerName":"next_seq","name":"$fh","line":118},{"line":119,"name":"$type","containerName":"next_seq","kind":13},{"line":119,"containerName":"next_seq","kind":13,"name":"$id"},{"name":"$type","kind":13,"containerName":"next_seq","line":126},{"definition":"my","line":129,"name":"$mol_type","containerName":"next_seq","localvar":"my","kind":13},{"line":129,"containerName":"next_seq","kind":13,"name":"$bio_mol_type"},{"kind":13,"containerName":"next_seq","name":"$type","line":129},{"name":"$self","kind":13,"containerName":"next_seq","line":130},{"name":"throw","kind":12,"containerName":"next_seq","line":130},{"line":133,"kind":13,"containerName":"next_seq","name":"$id"},{"line":139,"containerName":"next_seq","kind":13,"name":"$id"},{"name":"$self","containerName":"next_seq","kind":13,"line":142},{"line":142,"name":"sequence_factory","kind":12,"containerName":"next_seq"},{"name":"create","kind":12,"containerName":"next_seq","line":142},{"kind":13,"containerName":"next_seq","name":"$id","line":144},{"name":"$id","kind":13,"containerName":"next_seq","line":145},{"name":"$mol_type","kind":13,"containerName":"next_seq","line":146}],"containerName":"main::","name":"next_seq","signature":{"label":"next_seq($self)","parameters":[{"label":"$self"}],"documentation":""},"line":112,"range":{"start":{"character":0,"line":112},"end":{"line":148,"character":9999}},"kind":12},{"signature":{"label":"write_seq($self,@seq)","parameters":[{"label":"$self"},{"label":"@seq"}],"documentation":"1;\n# $Id: ace.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::ace\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by James Gilbert <jgrg@sanger.ac.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::ace - ace sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and\nfrom ace file format.  It only parses a DNA or\nPeptide objects contained in the ace file,\nproducing PrimarySeq objects from them.  All\nother objects in the files will be ignored.  It\ndoesn't attempt to parse any annotation attatched\nto the containing Sequence or Protein objects,\nwhich would probably be impossible, since\neveryone's ACeDB schema can be different.\n\nIt won't parse ace files containing Timestamps\ncorrectly either.  This can easily be added if\nconsidered necessary.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - James Gilbert\n\nEmail: jgrg@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\npackage Bio::SeqIO::ace;\nuse strict;\n\nuse Bio::Seq;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new(-verbose => $self->verbose(), -type => 'Bio::PrimarySeq'));\n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    : NONE\n\n\n{\n    my %bio_mol_type = (\n        'dna'       => 'dna',\n        'peptide'   => 'protein',\n    );\n\n    sub next_seq {\n        my( $self ) = @_;\n        local $/ = \"\";  # Split input on blank lines\n\n        my $fh = $self->_filehandle;\n        my( $type, $id );\n        while (<$fh>) {\n            if (($type, $id) = /^(DNA|Peptide)[\\s:]+(.+?)\\s*\\n/si) {\n                s/^.+$//m;  # Remove first line\n                s/\\s+//g;   # Remove whitespace\n                last;\n            }\n        }\n        # Return if there weren't any DNA or peptide objects\n        return unless $type;\n\n        # Choose the molecule type\n        my $mol_type = $bio_mol_type{lc $type}\n            or $self->throw(\"Can't get Bio::Seq molecule type for '$type'\");\n\n        # Remove quotes from $id\n        $id =~ s/^\"|\"$//g;\n\n        # Un-escape forward slashes, double quotes, percent signs,\n        # semi-colons, tabs, and backslashes (if you're mad enough\n        # to have any of these as part of object names in your acedb\n        # database).\n\t$id =~ s/\\\\([\\/\"%;\\t\\\\])/$1/g;\n#\"\n\t# Called as next_seq(), so give back a Bio::Seq\n\treturn $self->sequence_factory->create(\n\t\t\t\t\t       -seq        => $_,\n\t\t\t\t\t       -primary_id => $id,\n\t\t\t\t\t       -display_id => $id,\n\t\t\t\t\t       -alphabet    => $mol_type,\n\t\t\t\t\t       );\n    }\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq(@seq)\n Function: writes the $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Seq object(s)"},"line":162,"range":{"end":{"line":202,"character":9999},"start":{"character":0,"line":162}},"kind":12,"definition":"sub","detail":"($self,@seq)","children":[{"definition":"my","line":163,"kind":13,"localvar":"my","containerName":"write_seq","name":"$self"},{"containerName":"write_seq","kind":13,"name":"@seq","line":163},{"line":165,"kind":13,"localvar":"my","containerName":"write_seq","name":"$seq","definition":"my"},{"containerName":"write_seq","kind":13,"name":"@seq","line":165},{"kind":13,"containerName":"write_seq","name":"$self","line":166},{"kind":12,"containerName":"write_seq","name":"throw","line":166},{"containerName":"write_seq","kind":13,"name":"$seq","line":167},{"line":167,"containerName":"write_seq","kind":13,"name":"$seq"},{"containerName":"write_seq","kind":13,"name":"$seq","line":167},{"line":167,"containerName":"write_seq","kind":12,"name":"isa"},{"line":168,"name":"$mol_type","localvar":"my","containerName":"write_seq","kind":13,"definition":"my"},{"line":168,"name":"$seq","kind":13,"containerName":"write_seq"},{"line":168,"name":"alphabet","containerName":"write_seq","kind":12},{"name":"$id","localvar":"my","kind":13,"containerName":"write_seq","line":169,"definition":"my"},{"kind":13,"containerName":"write_seq","name":"$seq","line":169},{"line":169,"name":"display_id","containerName":"write_seq","kind":12},{"containerName":"write_seq","kind":13,"name":"$id","line":172},{"name":"$mol_type","kind":13,"containerName":"write_seq","line":175},{"name":"$self","kind":13,"containerName":"write_seq","line":176},{"line":176,"containerName":"write_seq","kind":12,"name":"_print"},{"name":"$mol_type","kind":13,"containerName":"write_seq","line":181},{"line":182,"containerName":"write_seq","kind":13,"name":"$self"},{"line":182,"name":"_print","containerName":"write_seq","kind":12},{"line":188,"kind":13,"containerName":"write_seq","name":"$self"},{"containerName":"write_seq","kind":12,"name":"throw","line":188},{"line":192,"kind":13,"localvar":"my","containerName":"write_seq","name":"$str","definition":"my"},{"kind":13,"containerName":"write_seq","name":"$seq","line":192},{"name":"seq","kind":12,"containerName":"write_seq","line":192},{"definition":"my","kind":13,"localvar":"my","containerName":"write_seq","name":"$formatted_seq","line":193},{"line":194,"name":"$str","containerName":"write_seq","kind":13},{"name":"$formatted_seq","containerName":"write_seq","kind":13,"line":195},{"name":"$self","kind":13,"containerName":"write_seq","line":197},{"name":"_print","containerName":"write_seq","kind":12,"line":197},{"name":"$formatted_seq","containerName":"write_seq","kind":13,"line":197},{"line":200,"name":"$self","kind":13,"containerName":"write_seq"},{"containerName":"write_seq","kind":12,"name":"flush","line":200},{"name":"$self","containerName":"write_seq","kind":13,"line":200},{"line":200,"kind":12,"containerName":"write_seq","name":"_flush_on_write"},{"name":"$self","kind":13,"containerName":"write_seq","line":200},{"line":200,"name":"_fh","containerName":"write_seq","kind":12}],"containerName":"main::","name":"write_seq"}],"version":5}