{"vars":[{"containerName":"","kind":2,"name":"base","line":89},{"detail":"($class,@args)","definition":"sub","name":"new","containerName":"main::","children":[{"definition":"my","line":92,"name":"$class","containerName":"new","localvar":"my","kind":13},{"line":92,"containerName":"new","kind":13,"name":"@args"},{"line":95,"name":"$self","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"containerName":"new","kind":13,"name":"$self","line":96},{"line":96,"kind":13,"containerName":"new","name":"$class"},{"line":97,"containerName":"new","kind":13,"name":"$self"},{"line":98,"name":"$self","containerName":"new","kind":13}],"signature":{"label":"new($class,@args)","documentation":"","parameters":[{"label":"$class"},{"label":"@args"}]},"range":{"end":{"character":9999,"line":99},"start":{"line":91,"character":0}},"kind":12,"line":91},{"line":115,"range":{"start":{"line":115,"character":0},"end":{"character":9999,"line":154}},"kind":12,"signature":{"label":"_generic_seqfeature($fth,$locfac,$seqid,$source)","parameters":[{"label":"$fth"},{"label":"$locfac"},{"label":"$seqid"},{"label":"$source"}],"documentation":"1;\n# $Id: FTHelper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::FTHelper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::FTHelper - Helper class for Embl/Genbank feature tables\n\n=head1 SYNOPSIS\n\nUsed by Bio::SeqIO::EMBL,Bio::SeqIO::genbank, and Bio::SeqIO::swiss to\nhelp process the Feature Table\n\n=head1 DESCRIPTION\n\nRepresents one particular Feature with the following fields\n\n      key - the key of the feature\n      loc - the location string of the feature\n      <other fields> - other fields\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqIO::FTHelper;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Simple;\nuse Bio::Location::Fuzzy;\nuse Bio::Location::Split;\n\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my ($class, @args) = @_;\n\n    # no chained new because we make lots and lots of these.\n    my $self = {};\n    bless $self,$class;\n    $self->{'_field'} = {};\n    return $self;\n}\n\n=head2 _generic_seqfeature\n\n Title   : _generic_seqfeature\n Usage   : $fthelper->_generic_seqfeature($annseq, \"GenBank\")\n Function: processes fthelper into a generic seqfeature\n Returns : TRUE on success and otherwise FALSE\n Args    : The Bio::Factory::LocationFactoryI object to use for parsing\n           location strings. The ID (e.g., display_id) of the sequence on which\n           this feature is located, optionally a string indicating the source\n           (GenBank/EMBL/SwissProt)"},"children":[{"definition":"my","line":116,"containerName":"_generic_seqfeature","localvar":"my","kind":13,"name":"$fth"},{"name":"$locfac","kind":13,"containerName":"_generic_seqfeature","line":116},{"containerName":"_generic_seqfeature","kind":13,"name":"$seqid","line":116},{"containerName":"_generic_seqfeature","kind":13,"name":"$source","line":116},{"definition":"my","line":117,"containerName":"_generic_seqfeature","localvar":"my","kind":13,"name":"$sf"},{"name":"$source","kind":13,"containerName":"_generic_seqfeature","line":120},{"line":121,"name":"$source","kind":13,"containerName":"_generic_seqfeature"},{"containerName":"_generic_seqfeature","kind":13,"name":"$sf","line":125},{"line":125,"name":"direct_new","kind":12,"containerName":"_generic_seqfeature"},{"definition":"my","line":131,"containerName":"_generic_seqfeature","localvar":"my","kind":13,"name":"$loc"},{"name":"$loc","containerName":"_generic_seqfeature","kind":13,"line":133},{"line":133,"kind":13,"containerName":"_generic_seqfeature","name":"$locfac"},{"name":"from_string","containerName":"_generic_seqfeature","kind":12,"line":133},{"line":133,"kind":13,"containerName":"_generic_seqfeature","name":"$fth"},{"line":133,"name":"loc","containerName":"_generic_seqfeature","kind":12},{"name":"$loc","containerName":"_generic_seqfeature","kind":13,"line":136},{"name":"$fth","kind":13,"containerName":"_generic_seqfeature","line":137},{"containerName":"_generic_seqfeature","kind":12,"name":"warn","line":137},{"line":137,"name":"$fth","containerName":"_generic_seqfeature","kind":13},{"name":"loc","containerName":"_generic_seqfeature","kind":12,"line":137},{"containerName":"_generic_seqfeature","kind":13,"name":"$fth","line":139},{"name":"key","kind":12,"containerName":"_generic_seqfeature","line":139},{"line":139,"name":"$seqid","containerName":"_generic_seqfeature","kind":13},{"line":144,"name":"$seqid","containerName":"_generic_seqfeature","kind":13},{"name":"$loc","kind":13,"containerName":"_generic_seqfeature","line":144},{"containerName":"_generic_seqfeature","kind":12,"name":"is_remote","line":144},{"line":145,"containerName":"_generic_seqfeature","kind":13,"name":"$loc"},{"name":"seq_id","containerName":"_generic_seqfeature","kind":12,"line":145},{"line":145,"kind":13,"containerName":"_generic_seqfeature","name":"$seqid"},{"line":150,"containerName":"_generic_seqfeature","kind":13,"name":"$sf"},{"line":150,"kind":12,"containerName":"_generic_seqfeature","name":"location"},{"kind":13,"containerName":"_generic_seqfeature","name":"$loc","line":150},{"name":"$sf","kind":13,"containerName":"_generic_seqfeature","line":151},{"line":151,"name":"primary_tag","kind":12,"containerName":"_generic_seqfeature"},{"line":151,"name":"$fth","containerName":"_generic_seqfeature","kind":13},{"line":151,"kind":12,"containerName":"_generic_seqfeature","name":"key"},{"name":"$sf","containerName":"_generic_seqfeature","kind":13,"line":152},{"line":152,"containerName":"_generic_seqfeature","kind":12,"name":"source_tag"},{"containerName":"_generic_seqfeature","kind":13,"name":"$source","line":152},{"line":153,"name":"$sf","kind":13,"containerName":"_generic_seqfeature"},{"line":153,"kind":12,"containerName":"_generic_seqfeature","name":"seq_id"},{"line":153,"name":"$seqid","containerName":"_generic_seqfeature","kind":13},{"containerName":"_generic_seqfeature","localvar":"my","kind":13,"name":"$key","line":154,"definition":"my"},{"line":154,"name":"$fth","containerName":"_generic_seqfeature","kind":13},{"containerName":"_generic_seqfeature","kind":12,"name":"field","line":154}],"name":"_generic_seqfeature","containerName":"main::","definition":"sub","detail":"($fth,$locfac,$seqid,$source)"},{"line":125,"name":"Bio","kind":12,"containerName":"SeqFeature::Generic"},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$value","line":155},{"line":155,"kind":13,"containerName":null,"name":"$fth"},{"name":"field","containerName":"main::","kind":12,"line":155},{"line":155,"name":"%key","kind":13,"containerName":null},{"line":156,"name":"$sf","kind":13,"containerName":null},{"kind":12,"containerName":"main::","name":"add_tag_value","line":156},{"containerName":null,"kind":13,"name":"$key","line":156},{"kind":13,"containerName":null,"name":"$value","line":156},{"line":159,"name":"$sf","kind":13,"containerName":null},{"signature":{"parameters":[{"label":"$sf"},{"label":"$context_annseq"}],"documentation":"1;\n# $Id: FTHelper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::FTHelper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::FTHelper - Helper class for Embl/Genbank feature tables\n\n=head1 SYNOPSIS\n\nUsed by Bio::SeqIO::EMBL,Bio::SeqIO::genbank, and Bio::SeqIO::swiss to\nhelp process the Feature Table\n\n=head1 DESCRIPTION\n\nRepresents one particular Feature with the following fields\n\n      key - the key of the feature\n      loc - the location string of the feature\n      <other fields> - other fields\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqIO::FTHelper;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Simple;\nuse Bio::Location::Fuzzy;\nuse Bio::Location::Split;\n\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my ($class, @args) = @_;\n\n    # no chained new because we make lots and lots of these.\n    my $self = {};\n    bless $self,$class;\n    $self->{'_field'} = {};\n    return $self;\n}\n\n=head2 _generic_seqfeature\n\n Title   : _generic_seqfeature\n Usage   : $fthelper->_generic_seqfeature($annseq, \"GenBank\")\n Function: processes fthelper into a generic seqfeature\n Returns : TRUE on success and otherwise FALSE\n Args    : The Bio::Factory::LocationFactoryI object to use for parsing\n           location strings. The ID (e.g., display_id) of the sequence on which\n           this feature is located, optionally a string indicating the source\n           (GenBank/EMBL/SwissProt)\n\n\n\nsub _generic_seqfeature {\n    my ($fth, $locfac, $seqid, $source) = @_;\n    my ($sf);\n\n    # set a default if not specified\n    if(! defined($source)) {\n\t$source = \"EMBL/GenBank/SwissProt\";\n    }\n\n    # initialize feature object\n    $sf = Bio::SeqFeature::Generic->direct_new();\n\n    # parse location; this may cause an exception, in which case we gently\n    # recover and ignore this feature\n\n\n    my $loc;\n    eval {\n\t$loc = $locfac->from_string($fth->loc);\n    };\n\n    if(! $loc) {\n\t  $fth->warn(\"exception while parsing location line [\" . $fth->loc .\n\t\t      \"] in reading $source, ignoring feature \" .\n\t\t      $fth->key() . \" (seqid=\" . $seqid . \"): \" . $@);\n\t  return;\n    }\n\n    # set additional location attributes\n    if($seqid && (! $loc->is_remote())) {\n\t$loc->seq_id($seqid); # propagates if it is a split location\n    }\n\n\n    # set attributes of feature\n    $sf->location($loc);\n    $sf->primary_tag($fth->key);\n    $sf->source_tag($source);\n    $sf->seq_id($seqid);\n    foreach my $key ( keys %{$fth->field} ){\n\tforeach my $value ( @{$fth->field->{$key}} ) {\n\t    $sf->add_tag_value($key,$value);\n\t}\n    }\n    return $sf;\n}\n\n\n=head2 from_SeqFeature\n\n Title   : from_SeqFeature\n Usage   : @fthelperlist = Bio::SeqIO::FTHelper::from_SeqFeature($sf,\n\t\t\t\t\t\t     $context_annseq);\n Function: constructor of fthelpers from SeqFeatures\n         :\n         : The additional annseq argument is to allow the building of FTHelper\n         : lines relevant to particular sequences (ie, when features are spread over\n         : enteries, knowing how to build this)\n Returns : an array of FThelpers\n Args    : seq features","label":"from_SeqFeature($sf,$context_annseq)"},"kind":12,"range":{"start":{"line":179,"character":0},"end":{"line":213,"character":9999}},"line":179,"detail":"($sf,$context_annseq)","definition":"sub","containerName":"main::","name":"from_SeqFeature","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"from_SeqFeature","name":"$sf","line":180},{"kind":13,"containerName":"from_SeqFeature","name":"$context_annseq","line":180},{"containerName":"from_SeqFeature","localvar":"my","kind":13,"name":"@ret","line":181,"definition":"my"},{"kind":13,"containerName":"from_SeqFeature","name":"$sf","line":189},{"line":189,"kind":12,"containerName":"from_SeqFeature","name":"can"},{"name":"$sf","containerName":"from_SeqFeature","kind":13,"line":190},{"name":"to_FTHelper","kind":12,"containerName":"from_SeqFeature","line":190},{"line":190,"kind":13,"containerName":"from_SeqFeature","name":"$context_annseq"},{"containerName":"from_SeqFeature","localvar":"my","kind":13,"name":"$fth","line":193,"definition":"my"},{"line":193,"kind":12,"containerName":"from_SeqFeature","name":"new"},{"definition":"my","line":194,"name":"$key","containerName":"from_SeqFeature","localvar":"my","kind":13},{"line":194,"name":"$sf","containerName":"from_SeqFeature","kind":13},{"containerName":"from_SeqFeature","kind":12,"name":"primary_tag","line":194},{"definition":"my","line":195,"name":"$locstr","localvar":"my","kind":13,"containerName":"from_SeqFeature"},{"containerName":"from_SeqFeature","kind":13,"name":"$sf","line":195},{"name":"location","containerName":"from_SeqFeature","kind":12,"line":195},{"name":"to_FTstring","containerName":"from_SeqFeature","kind":12,"line":195},{"line":207,"kind":13,"containerName":"from_SeqFeature","name":"$fth"},{"line":207,"name":"loc","containerName":"from_SeqFeature","kind":12},{"line":207,"name":"$locstr","containerName":"from_SeqFeature","kind":13},{"kind":13,"containerName":"from_SeqFeature","name":"$fth","line":208},{"line":208,"containerName":"from_SeqFeature","kind":12,"name":"key"},{"line":208,"containerName":"from_SeqFeature","kind":13,"name":"$key"},{"line":209,"containerName":"from_SeqFeature","kind":13,"name":"$fth"},{"line":209,"kind":12,"containerName":"from_SeqFeature","name":"field"},{"kind":13,"containerName":"from_SeqFeature","name":"$sf","line":212},{"line":212,"name":"can","kind":12,"containerName":"from_SeqFeature"},{"kind":13,"containerName":"from_SeqFeature","name":"$sf","line":212},{"name":"score","containerName":"from_SeqFeature","kind":12,"line":212},{"line":212,"name":"$fth","kind":13,"containerName":"from_SeqFeature"},{"line":212,"kind":12,"containerName":"from_SeqFeature","name":"field"},{"line":213,"containerName":"from_SeqFeature","kind":13,"name":"$sf"},{"line":213,"kind":12,"containerName":"from_SeqFeature","name":"score"}]},{"containerName":"SeqIO::FTHelper","kind":12,"name":"Bio","line":193},{"line":214,"kind":13,"containerName":null,"name":"$sf"},{"name":"can","kind":12,"containerName":"main::","line":214},{"line":214,"name":"$sf","kind":13,"containerName":null},{"kind":12,"containerName":"main::","name":"frame","line":214},{"line":214,"kind":13,"containerName":null,"name":"$fth"},{"name":"field","containerName":"main::","kind":12,"line":214},{"line":215,"name":"$sf","containerName":null,"kind":13},{"line":215,"name":"frame","containerName":"main::","kind":12},{"line":218,"localvar":"my","containerName":null,"kind":13,"name":"$tag","definition":"my"},{"line":218,"containerName":null,"kind":13,"name":"$sf"},{"line":218,"kind":12,"containerName":"main::","name":"get_all_tags"},{"line":221,"name":"$tag","containerName":null,"kind":13},{"name":"$fth","containerName":null,"kind":13,"line":222},{"kind":12,"containerName":"main::","name":"field","line":222},{"name":"%tag","containerName":null,"kind":13,"line":222},{"containerName":null,"kind":13,"name":"$fth","line":223},{"line":223,"containerName":"main::","kind":12,"name":"field"},{"name":"@tag","kind":13,"containerName":null,"line":223},{"name":"$val","kind":13,"localvar":"my","containerName":null,"line":225,"definition":"my"},{"kind":13,"containerName":null,"name":"$sf","line":225},{"containerName":"main::","kind":12,"name":"get_tag_values","line":225},{"line":225,"containerName":null,"kind":13,"name":"%tag"},{"line":226,"containerName":null,"kind":13,"name":"$fth"},{"line":226,"containerName":"main::","kind":12,"name":"field"},{"line":226,"name":"$tag","kind":13,"containerName":null},{"line":226,"name":"$val","containerName":null,"kind":13},{"name":"@ret","containerName":null,"kind":13,"line":229},{"line":229,"kind":13,"containerName":null,"name":"$fth"},{"line":231,"name":"@ret","kind":13,"containerName":null},{"name":"$context_annseq","kind":13,"containerName":null,"line":232},{"line":232,"containerName":"main::","kind":12,"name":"throw"},{"name":"$ft","kind":13,"localvar":"my","containerName":null,"line":234,"definition":"my"},{"line":234,"name":"@ret","containerName":null,"kind":13},{"line":235,"kind":13,"containerName":null,"name":"$ft"},{"containerName":"main::","kind":12,"name":"isa","line":235},{"line":236,"kind":13,"containerName":null,"name":"$sf"},{"line":236,"name":"throw","containerName":"main::","kind":12},{"line":240,"name":"@ret","kind":13,"containerName":null},{"children":[{"line":257,"name":"$obj","localvar":"my","kind":13,"containerName":"key","definition":"my"},{"name":"$value","containerName":"key","kind":13,"line":257},{"name":"$value","containerName":"key","kind":13,"line":258},{"line":259,"kind":13,"containerName":"key","name":"$obj"},{"name":"$value","containerName":"key","kind":13,"line":259},{"containerName":"key","kind":13,"name":"$obj","line":261}],"containerName":"main::","name":"key","definition":"sub","detail":"($obj,$value)","line":256,"range":{"start":{"character":0,"line":256},"end":{"line":263,"character":9999}},"kind":12,"signature":{"label":"key($obj,$value)","parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"1;\n# $Id: FTHelper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::FTHelper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::FTHelper - Helper class for Embl/Genbank feature tables\n\n=head1 SYNOPSIS\n\nUsed by Bio::SeqIO::EMBL,Bio::SeqIO::genbank, and Bio::SeqIO::swiss to\nhelp process the Feature Table\n\n=head1 DESCRIPTION\n\nRepresents one particular Feature with the following fields\n\n      key - the key of the feature\n      loc - the location string of the feature\n      <other fields> - other fields\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqIO::FTHelper;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Simple;\nuse Bio::Location::Fuzzy;\nuse Bio::Location::Split;\n\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my ($class, @args) = @_;\n\n    # no chained new because we make lots and lots of these.\n    my $self = {};\n    bless $self,$class;\n    $self->{'_field'} = {};\n    return $self;\n}\n\n=head2 _generic_seqfeature\n\n Title   : _generic_seqfeature\n Usage   : $fthelper->_generic_seqfeature($annseq, \"GenBank\")\n Function: processes fthelper into a generic seqfeature\n Returns : TRUE on success and otherwise FALSE\n Args    : The Bio::Factory::LocationFactoryI object to use for parsing\n           location strings. The ID (e.g., display_id) of the sequence on which\n           this feature is located, optionally a string indicating the source\n           (GenBank/EMBL/SwissProt)\n\n\n\nsub _generic_seqfeature {\n    my ($fth, $locfac, $seqid, $source) = @_;\n    my ($sf);\n\n    # set a default if not specified\n    if(! defined($source)) {\n\t$source = \"EMBL/GenBank/SwissProt\";\n    }\n\n    # initialize feature object\n    $sf = Bio::SeqFeature::Generic->direct_new();\n\n    # parse location; this may cause an exception, in which case we gently\n    # recover and ignore this feature\n\n\n    my $loc;\n    eval {\n\t$loc = $locfac->from_string($fth->loc);\n    };\n\n    if(! $loc) {\n\t  $fth->warn(\"exception while parsing location line [\" . $fth->loc .\n\t\t      \"] in reading $source, ignoring feature \" .\n\t\t      $fth->key() . \" (seqid=\" . $seqid . \"): \" . $@);\n\t  return;\n    }\n\n    # set additional location attributes\n    if($seqid && (! $loc->is_remote())) {\n\t$loc->seq_id($seqid); # propagates if it is a split location\n    }\n\n\n    # set attributes of feature\n    $sf->location($loc);\n    $sf->primary_tag($fth->key);\n    $sf->source_tag($source);\n    $sf->seq_id($seqid);\n    foreach my $key ( keys %{$fth->field} ){\n\tforeach my $value ( @{$fth->field->{$key}} ) {\n\t    $sf->add_tag_value($key,$value);\n\t}\n    }\n    return $sf;\n}\n\n\n=head2 from_SeqFeature\n\n Title   : from_SeqFeature\n Usage   : @fthelperlist = Bio::SeqIO::FTHelper::from_SeqFeature($sf,\n\t\t\t\t\t\t     $context_annseq);\n Function: constructor of fthelpers from SeqFeatures\n         :\n         : The additional annseq argument is to allow the building of FTHelper\n         : lines relevant to particular sequences (ie, when features are spread over\n         : enteries, knowing how to build this)\n Returns : an array of FThelpers\n Args    : seq features\n\n\n\nsub from_SeqFeature {\n  my ($sf, $context_annseq) = @_;\n  my @ret;\n\n  #\n  # If this object knows how to make FThelpers, then let it\n  # - this allows us to store *really* weird objects that can write\n  # themselves to the EMBL/GenBank...\n  #\n\n  if ( $sf->can(\"to_FTHelper\") ) {\n\treturn $sf->to_FTHelper($context_annseq);\n  }\n\n  my $fth = Bio::SeqIO::FTHelper->new();\n  my $key = $sf->primary_tag();\n  my $locstr = $sf->location->to_FTstring;\n\n  # ES 25/06/01 Commented out this code, Jason to double check\n  #The location FT string for all simple subseqfeatures is already\n  #in the Split location FT string\n\n  # going into sub features\n  #foreach my $sub ( $sf->sub_SeqFeature() ) {\n  #my @subfth = &Bio::SeqIO::FTHelper::from_SeqFeature($sub);\n  #push(@ret, @subfth);\n  #}\n\n  $fth->loc($locstr);\n  $fth->key($key);\n  $fth->field->{'note'} = [];\n  #$sf->source_tag && do { push(@{$fth->field->{'note'}},\"source=\" . $sf->source_tag ); };\n\n  ($sf->can('score') && $sf->score) && do { push(@{$fth->field->{'note'}},\n                                                 \"score=\" . $sf->score ); };\n  ($sf->can('frame') && $sf->frame) && do { push(@{$fth->field->{'note'}},\n                                                 \"frame=\" . $sf->frame ); };\n  #$sf->strand && do { push(@{$fth->field->{'note'}},\"strand=\" . $sf->strand ); };\n\n  foreach my $tag ( $sf->get_all_tags ) {\n    # Tags which begin with underscores are considered\n    # private, and are therefore not printed\n    next if $tag =~ /^_/;\n\tif ( !defined $fth->field->{$tag} ) {\n      $fth->field->{$tag} = [];\n\t}\n\tforeach my $val ( $sf->get_tag_values($tag) ) {\n      push(@{$fth->field->{$tag}},$val);\n\t}\n  }\n  push(@ret, $fth);\n\n  unless (@ret) {\n\t$context_annseq->throw(\"Problem in processing seqfeature $sf - no fthelpers. Error!\");\n  }\n  foreach my $ft (@ret) {\n\tif ( !$ft->isa('Bio::SeqIO::FTHelper') ) {\n      $sf->throw(\"Problem in processing seqfeature $sf - made a $fth!\");\n\t}\n  }\n\n  return @ret;\n}\n\n\n=head2 key\n\n Title   : key\n Usage   : $obj->key($newval)\n Function:\n Example :\n Returns : value of key\n Args    : newvalue (optional)"}},{"detail":"($obj,$value)","definition":"sub","name":"loc","containerName":"main::","children":[{"line":278,"kind":13,"localvar":"my","containerName":"loc","name":"$obj","definition":"my"},{"line":278,"kind":13,"containerName":"loc","name":"$value"},{"name":"$value","kind":13,"containerName":"loc","line":279},{"line":280,"kind":13,"containerName":"loc","name":"$obj"},{"line":280,"name":"$value","kind":13,"containerName":"loc"},{"line":282,"name":"$obj","kind":13,"containerName":"loc"}],"signature":{"parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"1;\n# $Id: FTHelper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::FTHelper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::FTHelper - Helper class for Embl/Genbank feature tables\n\n=head1 SYNOPSIS\n\nUsed by Bio::SeqIO::EMBL,Bio::SeqIO::genbank, and Bio::SeqIO::swiss to\nhelp process the Feature Table\n\n=head1 DESCRIPTION\n\nRepresents one particular Feature with the following fields\n\n      key - the key of the feature\n      loc - the location string of the feature\n      <other fields> - other fields\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqIO::FTHelper;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Simple;\nuse Bio::Location::Fuzzy;\nuse Bio::Location::Split;\n\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my ($class, @args) = @_;\n\n    # no chained new because we make lots and lots of these.\n    my $self = {};\n    bless $self,$class;\n    $self->{'_field'} = {};\n    return $self;\n}\n\n=head2 _generic_seqfeature\n\n Title   : _generic_seqfeature\n Usage   : $fthelper->_generic_seqfeature($annseq, \"GenBank\")\n Function: processes fthelper into a generic seqfeature\n Returns : TRUE on success and otherwise FALSE\n Args    : The Bio::Factory::LocationFactoryI object to use for parsing\n           location strings. The ID (e.g., display_id) of the sequence on which\n           this feature is located, optionally a string indicating the source\n           (GenBank/EMBL/SwissProt)\n\n\n\nsub _generic_seqfeature {\n    my ($fth, $locfac, $seqid, $source) = @_;\n    my ($sf);\n\n    # set a default if not specified\n    if(! defined($source)) {\n\t$source = \"EMBL/GenBank/SwissProt\";\n    }\n\n    # initialize feature object\n    $sf = Bio::SeqFeature::Generic->direct_new();\n\n    # parse location; this may cause an exception, in which case we gently\n    # recover and ignore this feature\n\n\n    my $loc;\n    eval {\n\t$loc = $locfac->from_string($fth->loc);\n    };\n\n    if(! $loc) {\n\t  $fth->warn(\"exception while parsing location line [\" . $fth->loc .\n\t\t      \"] in reading $source, ignoring feature \" .\n\t\t      $fth->key() . \" (seqid=\" . $seqid . \"): \" . $@);\n\t  return;\n    }\n\n    # set additional location attributes\n    if($seqid && (! $loc->is_remote())) {\n\t$loc->seq_id($seqid); # propagates if it is a split location\n    }\n\n\n    # set attributes of feature\n    $sf->location($loc);\n    $sf->primary_tag($fth->key);\n    $sf->source_tag($source);\n    $sf->seq_id($seqid);\n    foreach my $key ( keys %{$fth->field} ){\n\tforeach my $value ( @{$fth->field->{$key}} ) {\n\t    $sf->add_tag_value($key,$value);\n\t}\n    }\n    return $sf;\n}\n\n\n=head2 from_SeqFeature\n\n Title   : from_SeqFeature\n Usage   : @fthelperlist = Bio::SeqIO::FTHelper::from_SeqFeature($sf,\n\t\t\t\t\t\t     $context_annseq);\n Function: constructor of fthelpers from SeqFeatures\n         :\n         : The additional annseq argument is to allow the building of FTHelper\n         : lines relevant to particular sequences (ie, when features are spread over\n         : enteries, knowing how to build this)\n Returns : an array of FThelpers\n Args    : seq features\n\n\n\nsub from_SeqFeature {\n  my ($sf, $context_annseq) = @_;\n  my @ret;\n\n  #\n  # If this object knows how to make FThelpers, then let it\n  # - this allows us to store *really* weird objects that can write\n  # themselves to the EMBL/GenBank...\n  #\n\n  if ( $sf->can(\"to_FTHelper\") ) {\n\treturn $sf->to_FTHelper($context_annseq);\n  }\n\n  my $fth = Bio::SeqIO::FTHelper->new();\n  my $key = $sf->primary_tag();\n  my $locstr = $sf->location->to_FTstring;\n\n  # ES 25/06/01 Commented out this code, Jason to double check\n  #The location FT string for all simple subseqfeatures is already\n  #in the Split location FT string\n\n  # going into sub features\n  #foreach my $sub ( $sf->sub_SeqFeature() ) {\n  #my @subfth = &Bio::SeqIO::FTHelper::from_SeqFeature($sub);\n  #push(@ret, @subfth);\n  #}\n\n  $fth->loc($locstr);\n  $fth->key($key);\n  $fth->field->{'note'} = [];\n  #$sf->source_tag && do { push(@{$fth->field->{'note'}},\"source=\" . $sf->source_tag ); };\n\n  ($sf->can('score') && $sf->score) && do { push(@{$fth->field->{'note'}},\n                                                 \"score=\" . $sf->score ); };\n  ($sf->can('frame') && $sf->frame) && do { push(@{$fth->field->{'note'}},\n                                                 \"frame=\" . $sf->frame ); };\n  #$sf->strand && do { push(@{$fth->field->{'note'}},\"strand=\" . $sf->strand ); };\n\n  foreach my $tag ( $sf->get_all_tags ) {\n    # Tags which begin with underscores are considered\n    # private, and are therefore not printed\n    next if $tag =~ /^_/;\n\tif ( !defined $fth->field->{$tag} ) {\n      $fth->field->{$tag} = [];\n\t}\n\tforeach my $val ( $sf->get_tag_values($tag) ) {\n      push(@{$fth->field->{$tag}},$val);\n\t}\n  }\n  push(@ret, $fth);\n\n  unless (@ret) {\n\t$context_annseq->throw(\"Problem in processing seqfeature $sf - no fthelpers. Error!\");\n  }\n  foreach my $ft (@ret) {\n\tif ( !$ft->isa('Bio::SeqIO::FTHelper') ) {\n      $sf->throw(\"Problem in processing seqfeature $sf - made a $fth!\");\n\t}\n  }\n\n  return @ret;\n}\n\n\n=head2 key\n\n Title   : key\n Usage   : $obj->key($newval)\n Function:\n Example :\n Returns : value of key\n Args    : newvalue (optional)\n\n\n\nsub key {\n   my ($obj, $value) = @_;\n   if ( defined $value ) {\n      $obj->{'key'} = $value;\n    }\n    return $obj->{'key'};\n\n}\n\n=head2 loc\n\n Title   : loc\n Usage   : $obj->loc($newval)\n Function:\n Example :\n Returns : value of loc\n Args    : newvalue (optional)","label":"loc($obj,$value)"},"range":{"end":{"line":283,"character":9999},"start":{"character":0,"line":277}},"kind":12,"line":277},{"kind":12,"range":{"start":{"character":0,"line":298},"end":{"character":9999,"line":302}},"line":298,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: FTHelper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::FTHelper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::FTHelper - Helper class for Embl/Genbank feature tables\n\n=head1 SYNOPSIS\n\nUsed by Bio::SeqIO::EMBL,Bio::SeqIO::genbank, and Bio::SeqIO::swiss to\nhelp process the Feature Table\n\n=head1 DESCRIPTION\n\nRepresents one particular Feature with the following fields\n\n      key - the key of the feature\n      loc - the location string of the feature\n      <other fields> - other fields\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqIO::FTHelper;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Simple;\nuse Bio::Location::Fuzzy;\nuse Bio::Location::Split;\n\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my ($class, @args) = @_;\n\n    # no chained new because we make lots and lots of these.\n    my $self = {};\n    bless $self,$class;\n    $self->{'_field'} = {};\n    return $self;\n}\n\n=head2 _generic_seqfeature\n\n Title   : _generic_seqfeature\n Usage   : $fthelper->_generic_seqfeature($annseq, \"GenBank\")\n Function: processes fthelper into a generic seqfeature\n Returns : TRUE on success and otherwise FALSE\n Args    : The Bio::Factory::LocationFactoryI object to use for parsing\n           location strings. The ID (e.g., display_id) of the sequence on which\n           this feature is located, optionally a string indicating the source\n           (GenBank/EMBL/SwissProt)\n\n\n\nsub _generic_seqfeature {\n    my ($fth, $locfac, $seqid, $source) = @_;\n    my ($sf);\n\n    # set a default if not specified\n    if(! defined($source)) {\n\t$source = \"EMBL/GenBank/SwissProt\";\n    }\n\n    # initialize feature object\n    $sf = Bio::SeqFeature::Generic->direct_new();\n\n    # parse location; this may cause an exception, in which case we gently\n    # recover and ignore this feature\n\n\n    my $loc;\n    eval {\n\t$loc = $locfac->from_string($fth->loc);\n    };\n\n    if(! $loc) {\n\t  $fth->warn(\"exception while parsing location line [\" . $fth->loc .\n\t\t      \"] in reading $source, ignoring feature \" .\n\t\t      $fth->key() . \" (seqid=\" . $seqid . \"): \" . $@);\n\t  return;\n    }\n\n    # set additional location attributes\n    if($seqid && (! $loc->is_remote())) {\n\t$loc->seq_id($seqid); # propagates if it is a split location\n    }\n\n\n    # set attributes of feature\n    $sf->location($loc);\n    $sf->primary_tag($fth->key);\n    $sf->source_tag($source);\n    $sf->seq_id($seqid);\n    foreach my $key ( keys %{$fth->field} ){\n\tforeach my $value ( @{$fth->field->{$key}} ) {\n\t    $sf->add_tag_value($key,$value);\n\t}\n    }\n    return $sf;\n}\n\n\n=head2 from_SeqFeature\n\n Title   : from_SeqFeature\n Usage   : @fthelperlist = Bio::SeqIO::FTHelper::from_SeqFeature($sf,\n\t\t\t\t\t\t     $context_annseq);\n Function: constructor of fthelpers from SeqFeatures\n         :\n         : The additional annseq argument is to allow the building of FTHelper\n         : lines relevant to particular sequences (ie, when features are spread over\n         : enteries, knowing how to build this)\n Returns : an array of FThelpers\n Args    : seq features\n\n\n\nsub from_SeqFeature {\n  my ($sf, $context_annseq) = @_;\n  my @ret;\n\n  #\n  # If this object knows how to make FThelpers, then let it\n  # - this allows us to store *really* weird objects that can write\n  # themselves to the EMBL/GenBank...\n  #\n\n  if ( $sf->can(\"to_FTHelper\") ) {\n\treturn $sf->to_FTHelper($context_annseq);\n  }\n\n  my $fth = Bio::SeqIO::FTHelper->new();\n  my $key = $sf->primary_tag();\n  my $locstr = $sf->location->to_FTstring;\n\n  # ES 25/06/01 Commented out this code, Jason to double check\n  #The location FT string for all simple subseqfeatures is already\n  #in the Split location FT string\n\n  # going into sub features\n  #foreach my $sub ( $sf->sub_SeqFeature() ) {\n  #my @subfth = &Bio::SeqIO::FTHelper::from_SeqFeature($sub);\n  #push(@ret, @subfth);\n  #}\n\n  $fth->loc($locstr);\n  $fth->key($key);\n  $fth->field->{'note'} = [];\n  #$sf->source_tag && do { push(@{$fth->field->{'note'}},\"source=\" . $sf->source_tag ); };\n\n  ($sf->can('score') && $sf->score) && do { push(@{$fth->field->{'note'}},\n                                                 \"score=\" . $sf->score ); };\n  ($sf->can('frame') && $sf->frame) && do { push(@{$fth->field->{'note'}},\n                                                 \"frame=\" . $sf->frame ); };\n  #$sf->strand && do { push(@{$fth->field->{'note'}},\"strand=\" . $sf->strand ); };\n\n  foreach my $tag ( $sf->get_all_tags ) {\n    # Tags which begin with underscores are considered\n    # private, and are therefore not printed\n    next if $tag =~ /^_/;\n\tif ( !defined $fth->field->{$tag} ) {\n      $fth->field->{$tag} = [];\n\t}\n\tforeach my $val ( $sf->get_tag_values($tag) ) {\n      push(@{$fth->field->{$tag}},$val);\n\t}\n  }\n  push(@ret, $fth);\n\n  unless (@ret) {\n\t$context_annseq->throw(\"Problem in processing seqfeature $sf - no fthelpers. Error!\");\n  }\n  foreach my $ft (@ret) {\n\tif ( !$ft->isa('Bio::SeqIO::FTHelper') ) {\n      $sf->throw(\"Problem in processing seqfeature $sf - made a $fth!\");\n\t}\n  }\n\n  return @ret;\n}\n\n\n=head2 key\n\n Title   : key\n Usage   : $obj->key($newval)\n Function:\n Example :\n Returns : value of key\n Args    : newvalue (optional)\n\n\n\nsub key {\n   my ($obj, $value) = @_;\n   if ( defined $value ) {\n      $obj->{'key'} = $value;\n    }\n    return $obj->{'key'};\n\n}\n\n=head2 loc\n\n Title   : loc\n Usage   : $obj->loc($newval)\n Function:\n Example :\n Returns : value of loc\n Args    : newvalue (optional)\n\n\n\nsub loc {\n   my ($obj, $value) = @_;\n   if ( defined $value ) {\n      $obj->{'loc'} = $value;\n    }\n    return $obj->{'loc'};\n}\n\n\n=head2 field\n\n Title   : field\n Usage   :\n Function:\n Example :\n Returns :\n Args    :","label":"field($self)"},"name":"field","containerName":"main::","children":[{"definition":"my","line":299,"localvar":"my","containerName":"field","kind":13,"name":"$self"},{"line":301,"name":"$self","kind":13,"containerName":"field"}],"detail":"($self)","definition":"sub"},{"line":316,"kind":12,"range":{"start":{"character":0,"line":316},"end":{"line":322,"character":9999}},"signature":{"documentation":"1;\n# $Id: FTHelper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::FTHelper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::FTHelper - Helper class for Embl/Genbank feature tables\n\n=head1 SYNOPSIS\n\nUsed by Bio::SeqIO::EMBL,Bio::SeqIO::genbank, and Bio::SeqIO::swiss to\nhelp process the Feature Table\n\n=head1 DESCRIPTION\n\nRepresents one particular Feature with the following fields\n\n      key - the key of the feature\n      loc - the location string of the feature\n      <other fields> - other fields\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqIO::FTHelper;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Simple;\nuse Bio::Location::Fuzzy;\nuse Bio::Location::Split;\n\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my ($class, @args) = @_;\n\n    # no chained new because we make lots and lots of these.\n    my $self = {};\n    bless $self,$class;\n    $self->{'_field'} = {};\n    return $self;\n}\n\n=head2 _generic_seqfeature\n\n Title   : _generic_seqfeature\n Usage   : $fthelper->_generic_seqfeature($annseq, \"GenBank\")\n Function: processes fthelper into a generic seqfeature\n Returns : TRUE on success and otherwise FALSE\n Args    : The Bio::Factory::LocationFactoryI object to use for parsing\n           location strings. The ID (e.g., display_id) of the sequence on which\n           this feature is located, optionally a string indicating the source\n           (GenBank/EMBL/SwissProt)\n\n\n\nsub _generic_seqfeature {\n    my ($fth, $locfac, $seqid, $source) = @_;\n    my ($sf);\n\n    # set a default if not specified\n    if(! defined($source)) {\n\t$source = \"EMBL/GenBank/SwissProt\";\n    }\n\n    # initialize feature object\n    $sf = Bio::SeqFeature::Generic->direct_new();\n\n    # parse location; this may cause an exception, in which case we gently\n    # recover and ignore this feature\n\n\n    my $loc;\n    eval {\n\t$loc = $locfac->from_string($fth->loc);\n    };\n\n    if(! $loc) {\n\t  $fth->warn(\"exception while parsing location line [\" . $fth->loc .\n\t\t      \"] in reading $source, ignoring feature \" .\n\t\t      $fth->key() . \" (seqid=\" . $seqid . \"): \" . $@);\n\t  return;\n    }\n\n    # set additional location attributes\n    if($seqid && (! $loc->is_remote())) {\n\t$loc->seq_id($seqid); # propagates if it is a split location\n    }\n\n\n    # set attributes of feature\n    $sf->location($loc);\n    $sf->primary_tag($fth->key);\n    $sf->source_tag($source);\n    $sf->seq_id($seqid);\n    foreach my $key ( keys %{$fth->field} ){\n\tforeach my $value ( @{$fth->field->{$key}} ) {\n\t    $sf->add_tag_value($key,$value);\n\t}\n    }\n    return $sf;\n}\n\n\n=head2 from_SeqFeature\n\n Title   : from_SeqFeature\n Usage   : @fthelperlist = Bio::SeqIO::FTHelper::from_SeqFeature($sf,\n\t\t\t\t\t\t     $context_annseq);\n Function: constructor of fthelpers from SeqFeatures\n         :\n         : The additional annseq argument is to allow the building of FTHelper\n         : lines relevant to particular sequences (ie, when features are spread over\n         : enteries, knowing how to build this)\n Returns : an array of FThelpers\n Args    : seq features\n\n\n\nsub from_SeqFeature {\n  my ($sf, $context_annseq) = @_;\n  my @ret;\n\n  #\n  # If this object knows how to make FThelpers, then let it\n  # - this allows us to store *really* weird objects that can write\n  # themselves to the EMBL/GenBank...\n  #\n\n  if ( $sf->can(\"to_FTHelper\") ) {\n\treturn $sf->to_FTHelper($context_annseq);\n  }\n\n  my $fth = Bio::SeqIO::FTHelper->new();\n  my $key = $sf->primary_tag();\n  my $locstr = $sf->location->to_FTstring;\n\n  # ES 25/06/01 Commented out this code, Jason to double check\n  #The location FT string for all simple subseqfeatures is already\n  #in the Split location FT string\n\n  # going into sub features\n  #foreach my $sub ( $sf->sub_SeqFeature() ) {\n  #my @subfth = &Bio::SeqIO::FTHelper::from_SeqFeature($sub);\n  #push(@ret, @subfth);\n  #}\n\n  $fth->loc($locstr);\n  $fth->key($key);\n  $fth->field->{'note'} = [];\n  #$sf->source_tag && do { push(@{$fth->field->{'note'}},\"source=\" . $sf->source_tag ); };\n\n  ($sf->can('score') && $sf->score) && do { push(@{$fth->field->{'note'}},\n                                                 \"score=\" . $sf->score ); };\n  ($sf->can('frame') && $sf->frame) && do { push(@{$fth->field->{'note'}},\n                                                 \"frame=\" . $sf->frame ); };\n  #$sf->strand && do { push(@{$fth->field->{'note'}},\"strand=\" . $sf->strand ); };\n\n  foreach my $tag ( $sf->get_all_tags ) {\n    # Tags which begin with underscores are considered\n    # private, and are therefore not printed\n    next if $tag =~ /^_/;\n\tif ( !defined $fth->field->{$tag} ) {\n      $fth->field->{$tag} = [];\n\t}\n\tforeach my $val ( $sf->get_tag_values($tag) ) {\n      push(@{$fth->field->{$tag}},$val);\n\t}\n  }\n  push(@ret, $fth);\n\n  unless (@ret) {\n\t$context_annseq->throw(\"Problem in processing seqfeature $sf - no fthelpers. Error!\");\n  }\n  foreach my $ft (@ret) {\n\tif ( !$ft->isa('Bio::SeqIO::FTHelper') ) {\n      $sf->throw(\"Problem in processing seqfeature $sf - made a $fth!\");\n\t}\n  }\n\n  return @ret;\n}\n\n\n=head2 key\n\n Title   : key\n Usage   : $obj->key($newval)\n Function:\n Example :\n Returns : value of key\n Args    : newvalue (optional)\n\n\n\nsub key {\n   my ($obj, $value) = @_;\n   if ( defined $value ) {\n      $obj->{'key'} = $value;\n    }\n    return $obj->{'key'};\n\n}\n\n=head2 loc\n\n Title   : loc\n Usage   : $obj->loc($newval)\n Function:\n Example :\n Returns : value of loc\n Args    : newvalue (optional)\n\n\n\nsub loc {\n   my ($obj, $value) = @_;\n   if ( defined $value ) {\n      $obj->{'loc'} = $value;\n    }\n    return $obj->{'loc'};\n}\n\n\n=head2 field\n\n Title   : field\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub field {\n   my ($self) = @_;\n\n   return $self->{'_field'};\n}\n\n=head2 add_field\n\n Title   : add_field\n Usage   :\n Function:\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"$key"},{"label":"$val"}],"label":"add_field($self,$key,$val)"},"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"add_field","line":317,"definition":"my"},{"kind":13,"containerName":"add_field","name":"$key","line":317},{"line":317,"containerName":"add_field","kind":13,"name":"$val"},{"name":"$self","kind":13,"containerName":"add_field","line":319},{"containerName":"add_field","kind":12,"name":"field","line":319},{"name":"$key","kind":13,"containerName":"add_field","line":319},{"name":"$self","kind":13,"containerName":"add_field","line":320},{"line":320,"name":"field","kind":12,"containerName":"add_field"},{"containerName":"add_field","kind":13,"name":"$key","line":320},{"line":322,"name":"$self","containerName":"add_field","kind":13},{"containerName":"add_field","kind":12,"name":"field","line":322},{"line":322,"containerName":"add_field","kind":13,"name":"$key"}],"containerName":"main::","name":"add_field","definition":"sub","detail":"($self,$key,$val)"},{"line":322,"name":"$val","containerName":null,"kind":13}],"version":5}