{"vars":[{"name":"base","kind":2,"containerName":"","line":119},{"name":"seq","containerName":"main::","children":[{"line":172,"name":"$self","kind":13,"localvar":"my","containerName":"seq","definition":"my"},{"containerName":"seq","kind":13,"name":"$self","line":173},{"line":173,"name":"throw_not_implemented","containerName":"seq","kind":12}],"detail":"($self)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":171},"end":{"line":174,"character":9999}},"line":171,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqI - [Developers] Abstract Interface of Sequence (with features)\n\n=head1 SYNOPSIS\n\n    # Bio::SeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # Bio::SeqI implements Bio::PrimarySeqI\n    $seq      = $seqobj->seq(); # actual sequence as a string\n    $seqstr   = $seqobj->subseq(10,50);\n\n    # Bio::SeqI has annotationcollections\n\n    $ann      = $seqobj->annotation(); # annotation object\n\n    # Bio::SeqI has sequence features\n    # features must implement Bio::SeqFeatureI\n\n    @features = $seqobj->get_SeqFeatures(); # just top level\n    @features = $seqobj->get_all_SeqFeatures(); # descend into sub features\n\n\n\n=head1 DESCRIPTION\n\nBio::SeqI is the abstract interface of annotated Sequences. These\nmethods are those which you can be guarenteed to get for any Bio::SeqI\n- for most users of the package the documentation (and methods) in\nthis class are not at useful - this is a developers only class which\ndefines what methods have to be implmented by other Perl objects to\ncomply to the Bio::SeqI interface. Go \"perldoc Bio::Seq\" or \"man\nBio::Seq\" for more information.\n\n\nThere aren't many here, because too many complicated functions here\nprevent implementations which are just wrappers around a database or\nsimilar delayed mechanisms.\n\nMost of the clever stuff happens inside the SeqFeatureI system.\n\nA good reference implementation is Bio::Seq which is a pure perl\nimplementation of this class with alot of extra pieces for extra\nmanipulation.  However, if you want to be able to use any sequence\nobject in your analysis, if you can do it just using these methods,\nthen you know you will be future proof and compatible with other\nimplementations of Seq.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::SeqI;\nuse strict;\n\n\n# Object preamble - inheriets from Bio::PrimarySeqI\n\nuse base qw(Bio::PrimarySeqI Bio::AnnotatableI Bio::FeatureHolderI);\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   : my @feats = $seq->get_SeqFeatures();\n Function: retrieve just the toplevel sequence features attached to this seq\n Returns : array of Bio::SeqFeatureI objects\n Args    : none\n\nThis method comes through extension of Bio::FeatureHolderI. See\nL<Bio::FeatureHolderI> and L<Bio::SeqFeatureI> for more information.\n\n\n=head2 get_all_SeqFeatures\n\n Title   : get_all_SeqFeatures\n Usage   : @features = $annseq->get_all_SeqFeatures()\n Function: returns all SeqFeatures, included sub SeqFeatures\n Returns : an array of Bio::SeqFeatureI objects\n Args    : none\n\nThis method comes through extension of Bio::FeatureHolderI. See\nL<Bio::FeatureHolderI> and L<Bio::SeqFeatureI> for more information.\n\n\n=head2 feature_count\n\n Title   : feature_count\n Usage   : $seq->feature_count()\n Function: Return the number of SeqFeatures attached to a sequence\n Returns : integer representing the number of SeqFeatures\n Args    : none\n\nThis method comes through extension of Bio::FeatureHolderI. See\nL<Bio::FeatureHolderI> for more information.\n\n\n=head2 seq\n\n Title   : seq\n Usage   : my $string = $seq->seq();\n Function: Retrieves the sequence string for the sequence object\n Returns : string\n Args    : none","label":"seq($self)"}},{"line":188,"kind":12,"range":{"end":{"character":9999,"line":197},"start":{"line":188,"character":0}},"signature":{"documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqI - [Developers] Abstract Interface of Sequence (with features)\n\n=head1 SYNOPSIS\n\n    # Bio::SeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # Bio::SeqI implements Bio::PrimarySeqI\n    $seq      = $seqobj->seq(); # actual sequence as a string\n    $seqstr   = $seqobj->subseq(10,50);\n\n    # Bio::SeqI has annotationcollections\n\n    $ann      = $seqobj->annotation(); # annotation object\n\n    # Bio::SeqI has sequence features\n    # features must implement Bio::SeqFeatureI\n\n    @features = $seqobj->get_SeqFeatures(); # just top level\n    @features = $seqobj->get_all_SeqFeatures(); # descend into sub features\n\n\n\n=head1 DESCRIPTION\n\nBio::SeqI is the abstract interface of annotated Sequences. These\nmethods are those which you can be guarenteed to get for any Bio::SeqI\n- for most users of the package the documentation (and methods) in\nthis class are not at useful - this is a developers only class which\ndefines what methods have to be implmented by other Perl objects to\ncomply to the Bio::SeqI interface. Go \"perldoc Bio::Seq\" or \"man\nBio::Seq\" for more information.\n\n\nThere aren't many here, because too many complicated functions here\nprevent implementations which are just wrappers around a database or\nsimilar delayed mechanisms.\n\nMost of the clever stuff happens inside the SeqFeatureI system.\n\nA good reference implementation is Bio::Seq which is a pure perl\nimplementation of this class with alot of extra pieces for extra\nmanipulation.  However, if you want to be able to use any sequence\nobject in your analysis, if you can do it just using these methods,\nthen you know you will be future proof and compatible with other\nimplementations of Seq.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::SeqI;\nuse strict;\n\n\n# Object preamble - inheriets from Bio::PrimarySeqI\n\nuse base qw(Bio::PrimarySeqI Bio::AnnotatableI Bio::FeatureHolderI);\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   : my @feats = $seq->get_SeqFeatures();\n Function: retrieve just the toplevel sequence features attached to this seq\n Returns : array of Bio::SeqFeatureI objects\n Args    : none\n\nThis method comes through extension of Bio::FeatureHolderI. See\nL<Bio::FeatureHolderI> and L<Bio::SeqFeatureI> for more information.\n\n\n=head2 get_all_SeqFeatures\n\n Title   : get_all_SeqFeatures\n Usage   : @features = $annseq->get_all_SeqFeatures()\n Function: returns all SeqFeatures, included sub SeqFeatures\n Returns : an array of Bio::SeqFeatureI objects\n Args    : none\n\nThis method comes through extension of Bio::FeatureHolderI. See\nL<Bio::FeatureHolderI> and L<Bio::SeqFeatureI> for more information.\n\n\n=head2 feature_count\n\n Title   : feature_count\n Usage   : $seq->feature_count()\n Function: Return the number of SeqFeatures attached to a sequence\n Returns : integer representing the number of SeqFeatures\n Args    : none\n\nThis method comes through extension of Bio::FeatureHolderI. See\nL<Bio::FeatureHolderI> for more information.\n\n\n=head2 seq\n\n Title   : seq\n Usage   : my $string = $seq->seq();\n Function: Retrieves the sequence string for the sequence object\n Returns : string\n Args    : none\n\n\n\nsub seq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 write_GFF\n\n Title   : write_GFF\n Usage   : $seq->write_GFF(\\*FILEHANDLE);\n Function: Convience method to write out all the sequence features\n           in GFF format to the provided filehandle (STDOUT by default)\n Returns : none\n Args    : [optional] filehandle to write to (default is STDOUT)","parameters":[{"label":"$self"},{"label":"$fh"}],"label":"write_GFF($self,$fh)"},"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"write_GFF","line":189,"definition":"my"},{"line":189,"name":"$fh","kind":13,"containerName":"write_GFF"},{"kind":13,"containerName":"write_GFF","name":"$fh","line":191},{"name":"$fh","kind":13,"containerName":"write_GFF","line":191},{"line":193,"localvar":"my","kind":13,"containerName":"write_GFF","name":"$sf","definition":"my"},{"line":193,"name":"$self","kind":13,"containerName":"write_GFF"},{"name":"get_all_SeqFeatures","containerName":"write_GFF","kind":12,"line":193},{"line":194,"containerName":"write_GFF","kind":13,"name":"$fh"},{"kind":13,"containerName":"write_GFF","name":"$sf","line":194},{"name":"gff_string","kind":12,"containerName":"write_GFF","line":194}],"containerName":"main::","name":"write_GFF","definition":"sub","detail":"($self,$fh)"},{"children":[{"definition":"my","line":226,"localvar":"my","containerName":"species","kind":13,"name":"$self"},{"kind":13,"containerName":"species","name":"$self","line":227},{"containerName":"species","kind":12,"name":"throw_not_implemented","line":227}],"containerName":"main::","name":"species","definition":"sub","detail":"($self)","line":225,"kind":12,"range":{"start":{"character":0,"line":225},"end":{"line":228,"character":9999}},"signature":{"documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqI - [Developers] Abstract Interface of Sequence (with features)\n\n=head1 SYNOPSIS\n\n    # Bio::SeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # Bio::SeqI implements Bio::PrimarySeqI\n    $seq      = $seqobj->seq(); # actual sequence as a string\n    $seqstr   = $seqobj->subseq(10,50);\n\n    # Bio::SeqI has annotationcollections\n\n    $ann      = $seqobj->annotation(); # annotation object\n\n    # Bio::SeqI has sequence features\n    # features must implement Bio::SeqFeatureI\n\n    @features = $seqobj->get_SeqFeatures(); # just top level\n    @features = $seqobj->get_all_SeqFeatures(); # descend into sub features\n\n\n\n=head1 DESCRIPTION\n\nBio::SeqI is the abstract interface of annotated Sequences. These\nmethods are those which you can be guarenteed to get for any Bio::SeqI\n- for most users of the package the documentation (and methods) in\nthis class are not at useful - this is a developers only class which\ndefines what methods have to be implmented by other Perl objects to\ncomply to the Bio::SeqI interface. Go \"perldoc Bio::Seq\" or \"man\nBio::Seq\" for more information.\n\n\nThere aren't many here, because too many complicated functions here\nprevent implementations which are just wrappers around a database or\nsimilar delayed mechanisms.\n\nMost of the clever stuff happens inside the SeqFeatureI system.\n\nA good reference implementation is Bio::Seq which is a pure perl\nimplementation of this class with alot of extra pieces for extra\nmanipulation.  However, if you want to be able to use any sequence\nobject in your analysis, if you can do it just using these methods,\nthen you know you will be future proof and compatible with other\nimplementations of Seq.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::SeqI;\nuse strict;\n\n\n# Object preamble - inheriets from Bio::PrimarySeqI\n\nuse base qw(Bio::PrimarySeqI Bio::AnnotatableI Bio::FeatureHolderI);\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   : my @feats = $seq->get_SeqFeatures();\n Function: retrieve just the toplevel sequence features attached to this seq\n Returns : array of Bio::SeqFeatureI objects\n Args    : none\n\nThis method comes through extension of Bio::FeatureHolderI. See\nL<Bio::FeatureHolderI> and L<Bio::SeqFeatureI> for more information.\n\n\n=head2 get_all_SeqFeatures\n\n Title   : get_all_SeqFeatures\n Usage   : @features = $annseq->get_all_SeqFeatures()\n Function: returns all SeqFeatures, included sub SeqFeatures\n Returns : an array of Bio::SeqFeatureI objects\n Args    : none\n\nThis method comes through extension of Bio::FeatureHolderI. See\nL<Bio::FeatureHolderI> and L<Bio::SeqFeatureI> for more information.\n\n\n=head2 feature_count\n\n Title   : feature_count\n Usage   : $seq->feature_count()\n Function: Return the number of SeqFeatures attached to a sequence\n Returns : integer representing the number of SeqFeatures\n Args    : none\n\nThis method comes through extension of Bio::FeatureHolderI. See\nL<Bio::FeatureHolderI> for more information.\n\n\n=head2 seq\n\n Title   : seq\n Usage   : my $string = $seq->seq();\n Function: Retrieves the sequence string for the sequence object\n Returns : string\n Args    : none\n\n\n\nsub seq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 write_GFF\n\n Title   : write_GFF\n Usage   : $seq->write_GFF(\\*FILEHANDLE);\n Function: Convience method to write out all the sequence features\n           in GFF format to the provided filehandle (STDOUT by default)\n Returns : none\n Args    : [optional] filehandle to write to (default is STDOUT)\n\n\n\nsub write_GFF{\n   my ($self,$fh) = @_;\n\n   $fh || do { $fh = \\*STDOUT; };\n\n   foreach my $sf ( $self->get_all_SeqFeatures() ) {\n       print $fh $sf->gff_string, \"\\n\";\n   }\n\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($seq_obj)\n Function: retrieve the attached annotation object\n Returns : Bio::AnnotationCollectionI or none;\n\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information. This method comes through extension from\nL<Bio::AnnotatableI>.\n\n\n=head2 species\n\n Title   : species\n Usage   :\n Function: Gets or sets the species\n Example : $species = $self->species();\n Returns : Bio::Species object\n Args    : Bio::Species object or none;\n\nSee L<Bio::Species> for more information","parameters":[{"label":"$self"}],"label":"species($self)"}},{"definition":"sub","detail":"($self)","children":[{"localvar":"my","kind":13,"containerName":"primary_seq","name":"$self","line":246,"definition":"my"},{"line":247,"kind":13,"containerName":"primary_seq","name":"$self"},{"kind":12,"containerName":"primary_seq","name":"throw_not_implemented","line":247}],"name":"primary_seq","containerName":"main::","signature":{"label":"primary_seq($self)","documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqI - [Developers] Abstract Interface of Sequence (with features)\n\n=head1 SYNOPSIS\n\n    # Bio::SeqI is the interface class for sequences.\n\n    # If you are a newcomer to bioperl, you should\n    # start with Bio::Seq documentation. This\n    # documentation is mainly for developers using\n    # Bioperl.\n\n    # Bio::SeqI implements Bio::PrimarySeqI\n    $seq      = $seqobj->seq(); # actual sequence as a string\n    $seqstr   = $seqobj->subseq(10,50);\n\n    # Bio::SeqI has annotationcollections\n\n    $ann      = $seqobj->annotation(); # annotation object\n\n    # Bio::SeqI has sequence features\n    # features must implement Bio::SeqFeatureI\n\n    @features = $seqobj->get_SeqFeatures(); # just top level\n    @features = $seqobj->get_all_SeqFeatures(); # descend into sub features\n\n\n\n=head1 DESCRIPTION\n\nBio::SeqI is the abstract interface of annotated Sequences. These\nmethods are those which you can be guarenteed to get for any Bio::SeqI\n- for most users of the package the documentation (and methods) in\nthis class are not at useful - this is a developers only class which\ndefines what methods have to be implmented by other Perl objects to\ncomply to the Bio::SeqI interface. Go \"perldoc Bio::Seq\" or \"man\nBio::Seq\" for more information.\n\n\nThere aren't many here, because too many complicated functions here\nprevent implementations which are just wrappers around a database or\nsimilar delayed mechanisms.\n\nMost of the clever stuff happens inside the SeqFeatureI system.\n\nA good reference implementation is Bio::Seq which is a pure perl\nimplementation of this class with alot of extra pieces for extra\nmanipulation.  However, if you want to be able to use any sequence\nobject in your analysis, if you can do it just using these methods,\nthen you know you will be future proof and compatible with other\nimplementations of Seq.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::SeqI;\nuse strict;\n\n\n# Object preamble - inheriets from Bio::PrimarySeqI\n\nuse base qw(Bio::PrimarySeqI Bio::AnnotatableI Bio::FeatureHolderI);\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   : my @feats = $seq->get_SeqFeatures();\n Function: retrieve just the toplevel sequence features attached to this seq\n Returns : array of Bio::SeqFeatureI objects\n Args    : none\n\nThis method comes through extension of Bio::FeatureHolderI. See\nL<Bio::FeatureHolderI> and L<Bio::SeqFeatureI> for more information.\n\n\n=head2 get_all_SeqFeatures\n\n Title   : get_all_SeqFeatures\n Usage   : @features = $annseq->get_all_SeqFeatures()\n Function: returns all SeqFeatures, included sub SeqFeatures\n Returns : an array of Bio::SeqFeatureI objects\n Args    : none\n\nThis method comes through extension of Bio::FeatureHolderI. See\nL<Bio::FeatureHolderI> and L<Bio::SeqFeatureI> for more information.\n\n\n=head2 feature_count\n\n Title   : feature_count\n Usage   : $seq->feature_count()\n Function: Return the number of SeqFeatures attached to a sequence\n Returns : integer representing the number of SeqFeatures\n Args    : none\n\nThis method comes through extension of Bio::FeatureHolderI. See\nL<Bio::FeatureHolderI> for more information.\n\n\n=head2 seq\n\n Title   : seq\n Usage   : my $string = $seq->seq();\n Function: Retrieves the sequence string for the sequence object\n Returns : string\n Args    : none\n\n\n\nsub seq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 write_GFF\n\n Title   : write_GFF\n Usage   : $seq->write_GFF(\\*FILEHANDLE);\n Function: Convience method to write out all the sequence features\n           in GFF format to the provided filehandle (STDOUT by default)\n Returns : none\n Args    : [optional] filehandle to write to (default is STDOUT)\n\n\n\nsub write_GFF{\n   my ($self,$fh) = @_;\n\n   $fh || do { $fh = \\*STDOUT; };\n\n   foreach my $sf ( $self->get_all_SeqFeatures() ) {\n       print $fh $sf->gff_string, \"\\n\";\n   }\n\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($seq_obj)\n Function: retrieve the attached annotation object\n Returns : Bio::AnnotationCollectionI or none;\n\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information. This method comes through extension from\nL<Bio::AnnotatableI>.\n\n\n=head2 species\n\n Title   : species\n Usage   :\n Function: Gets or sets the species\n Example : $species = $self->species();\n Returns : Bio::Species object\n Args    : Bio::Species object or none;\n\nSee L<Bio::Species> for more information\n\n\nsub species {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 primary_seq\n\n Title   : primary_seq\n Usage   : $obj->primary_seq($newval)\n Function: Retrieve the underlying Bio::PrimarySeqI object if available.\n           This is in the event one has a sequence with lots of features\n           but want to be able to narrow the object to just one with\n           the basics of a sequence (no features or annotations).\n Returns : Bio::PrimarySeqI\n Args    : Bio::PrimarySeqI or none;\n\nSee L<Bio::PrimarySeqI> for more information","parameters":[{"label":"$self"}]},"line":245,"range":{"start":{"line":245,"character":0},"end":{"character":9999,"line":248}},"kind":12}],"version":5}